/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-heci-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_mkhi_group_id_to_string(FuMkhiGroupId val)
{
    if (val == FU_MKHI_GROUP_ID_CBM)
        return "cbm";
    if (val == FU_MKHI_GROUP_ID_PM)
        return "pm";
    if (val == FU_MKHI_GROUP_ID_PWD)
        return "pwd";
    if (val == FU_MKHI_GROUP_ID_FWCAPS)
        return "fwcaps";
    if (val == FU_MKHI_GROUP_ID_APP)
        return "app";
    if (val == FU_MKHI_GROUP_ID_FWUPDATE)
        return "fwupdate";
    if (val == FU_MKHI_GROUP_ID_FIRMWARE_UPDATE)
        return "firmware-update";
    if (val == FU_MKHI_GROUP_ID_BIST)
        return "bist";
    if (val == FU_MKHI_GROUP_ID_MDES)
        return "mdes";
    if (val == FU_MKHI_GROUP_ID_ME_DBG)
        return "me-dbg";
    if (val == FU_MKHI_GROUP_ID_MCA)
        return "mca";
    if (val == FU_MKHI_GROUP_ID_GEN)
        return "gen";
    return NULL;
}

const gchar *
fu_mkhi_status_to_string(FuMkhiStatus val)
{
    if (val == FU_MKHI_STATUS_SUCCESS)
        return "success";
    if (val == FU_MKHI_STATUS_INVALID_STATE)
        return "invalid-state";
    if (val == FU_MKHI_STATUS_MESSAGE_SKIPPED)
        return "message-skipped";
    if (val == FU_MKHI_STATUS_SIZE_ERROR)
        return "size-error";
    if (val == FU_MKHI_STATUS_UNKNOWN_PERHAPS_NOT_SUPPORTED)
        return "unknown-perhaps-not-supported";
    if (val == FU_MKHI_STATUS_NOT_SET)
        return "not-set";
    if (val == FU_MKHI_STATUS_NOT_AVAILABLE)
        return "not-available";
    if (val == FU_MKHI_STATUS_INVALID_ACCESS)
        return "invalid-access";
    if (val == FU_MKHI_STATUS_INVALID_PARAMS)
        return "invalid-params";
    if (val == FU_MKHI_STATUS_NOT_READY)
        return "not-ready";
    if (val == FU_MKHI_STATUS_NOT_SUPPORTED)
        return "not-supported";
    if (val == FU_MKHI_STATUS_INVALID_ADDRESS)
        return "invalid-address";
    if (val == FU_MKHI_STATUS_INVALID_COMMAND)
        return "invalid-command";
    if (val == FU_MKHI_STATUS_FAILURE)
        return "failure";
    if (val == FU_MKHI_STATUS_INVALID_RESOURCE)
        return "invalid-resource";
    if (val == FU_MKHI_STATUS_RESOURCE_IN_USE)
        return "resource-in-use";
    if (val == FU_MKHI_STATUS_NO_RESOURCE)
        return "no-resource";
    if (val == FU_MKHI_STATUS_GENERAL_ERROR)
        return "general-error";
    if (val == FU_MKHI_STATUS_LOWER_ARB_SVN)
        return "lower-arb-svn";
    if (val == FU_MKHI_STATUS_LOWER_TCB_SVN)
        return "lower-tcb-svn";
    if (val == FU_MKHI_STATUS_LOWER_VCN)
        return "lower-vcn";
    if (val == FU_MKHI_STATUS_UPDATE_IUP_SVN)
        return "update-iup-svn";
    if (val == FU_MKHI_STATUS_UPDATE_IUP_VCN)
        return "update-iup-vcn";
    if (val == FU_MKHI_STATUS_UPDATE_IMAGE_LEN)
        return "update-image-len";
    if (val == FU_MKHI_STATUS_UPDATE_PV_BIT)
        return "update-pv-bit";
    if (val == FU_MKHI_STATUS_UPDATE_ENGINEERING_MISMATCH)
        return "update-engineering-mismatch";
    if (val == FU_MKHI_STATUS_UPDATE_VER_MAN_FAILED_OROM)
        return "update-ver-man-failed-orom";
    if (val == FU_MKHI_STATUS_UPDATE_DEVICE_ID_NOT_MATCH)
        return "update-device-id-not-match";
    if (val == FU_MKHI_STATUS_UPDATE_OPROM_SECTION_NOT_EXIST)
        return "update-oprom-section-not-exist";
    if (val == FU_MKHI_STATUS_UPDATE_OPROM_INVALID_STRUCTURE)
        return "update-oprom-invalid-structure";
    if (val == FU_MKHI_STATUS_UPDATE_GET_OPROM_VERSION_FAILED0X103_C)
        return "update-get-oprom-version-failed0x103-c";
    if (val == FU_MKHI_STATUS_UPDATE_OROM_INVALID_STRUCTURE)
        return "update-orom-invalid-structure";
    if (val == FU_MKHI_STATUS_UPDATE_VER_MAN_FAILED_GFX_DATA)
        return "update-ver-man-failed-gfx-data";
    if (val == FU_MKHI_STATUS_UPDATE_GFX_DATA_OEM_MANUF_VER)
        return "update-gfx-data-oem-manuf-ver";
    return NULL;
}

static const gchar *
fu_mkhi_command_to_string(FuMkhiCommand val)
{
    if (val == FU_MKHI_COMMAND_READ_FILE)
        return "read-file";
    if (val == FU_MKHI_COMMAND_READ_FILE_EX)
        return "read-file-ex";
    if (val == FU_MKHI_COMMAND_ARBH_SVN_COMMIT)
        return "arbh-svn-commit";
    if (val == FU_MKHI_COMMAND_ARBH_SVN_GET_INFO)
        return "arbh-svn-get-info";
    if (val == FU_MKHI_COMMAND_READ_FILE_RESPONSE)
        return "read-file-response";
    if (val == FU_MKHI_COMMAND_READ_FILE_EX_RESPONSE)
        return "read-file-ex-response";
    if (val == FU_MKHI_COMMAND_ARBH_SVN_COMMIT_RESPONSE)
        return "arbh-svn-commit-response";
    if (val == FU_MKHI_COMMAND_ARBH_SVN_GET_INFO_RESPONSE)
        return "arbh-svn-get-info-response";
    return NULL;
}

static const gchar *
fu_mkhi_arbh_svn_info_entry_usage_id_to_string(FuMkhiArbhSvnInfoEntryUsageId val)
{
    if (val == FU_MKHI_ARBH_SVN_INFO_ENTRY_USAGE_ID_CSE_RBE)
        return "cse-rbe";
    return NULL;
}
/**
 * fu_mkhi_read_file_request_ref: (skip):
 **/
FuMkhiReadFileRequest *
fu_mkhi_read_file_request_ref(FuMkhiReadFileRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_read_file_request_unref: (skip):
 **/
void
fu_mkhi_read_file_request_unref(FuMkhiReadFileRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiReadFileRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_read_file_request_new_internal: (skip):
 **/
static FuMkhiReadFileRequest *
fu_mkhi_read_file_request_new_internal(void)
{
    FuMkhiReadFileRequest *st = g_new0(FuMkhiReadFileRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_mkhi_read_file_request_set_group_id: (skip):
 **/
static void
fu_mkhi_read_file_request_set_group_id(FuMkhiReadFileRequest *st, FuMkhiGroupId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_mkhi_read_file_request_set_command: (skip):
 **/
static void
fu_mkhi_read_file_request_set_command(FuMkhiReadFileRequest *st, FuMkhiCommand value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_mkhi_read_file_request_set_result: (skip):
 **/
static void
fu_mkhi_read_file_request_set_result(FuMkhiReadFileRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_mkhi_read_file_request_set_filename: (skip):
 **/
gboolean
fu_mkhi_read_file_request_set_filename(FuMkhiReadFileRequest *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 4, 0x0, 64);
        return TRUE;
    }
    len = strlen(value);
    if (len > 64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuMkhiReadFileRequest.filename (0x%x bytes)",
                    value, (guint) len, (guint) 64);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_mkhi_read_file_request_set_offset: (skip):
 **/
static void
fu_mkhi_read_file_request_set_offset(FuMkhiReadFileRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 68, value, G_LITTLE_ENDIAN);
}
/**
 * fu_mkhi_read_file_request_set_data_size: (skip):
 **/
void
fu_mkhi_read_file_request_set_data_size(FuMkhiReadFileRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 72, value, G_LITTLE_ENDIAN);
}
/**
 * fu_mkhi_read_file_request_set_flags: (skip):
 **/
void
fu_mkhi_read_file_request_set_flags(FuMkhiReadFileRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[76] = value;
}
/**
 * fu_mkhi_read_file_request_new: (skip):
 **/
FuMkhiReadFileRequest *
fu_mkhi_read_file_request_new(void)
{
    FuMkhiReadFileRequest *st = fu_mkhi_read_file_request_new_internal();
    st->buf = g_byte_array_sized_new(77);
    fu_byte_array_set_size(st->buf, 77, 0x0);
    fu_mkhi_read_file_request_set_group_id(st, FU_MKHI_GROUP_ID_MCA);
    fu_mkhi_read_file_request_set_command(st, FU_MKHI_COMMAND_READ_FILE);
    fu_mkhi_read_file_request_set_result(st, 0x0);
    fu_mkhi_read_file_request_set_offset(st, 0x0);
    return st;
}
/**
 * fu_mkhi_read_file_response_ref: (skip):
 **/
FuMkhiReadFileResponse *
fu_mkhi_read_file_response_ref(FuMkhiReadFileResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_read_file_response_unref: (skip):
 **/
void
fu_mkhi_read_file_response_unref(FuMkhiReadFileResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiReadFileResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_read_file_response_new_internal: (skip):
 **/
static FuMkhiReadFileResponse *
fu_mkhi_read_file_response_new_internal(void)
{
    FuMkhiReadFileResponse *st = g_new0(FuMkhiReadFileResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mkhi_read_file_response_get_group_id: (skip):
 **/
static FuMkhiGroupId
fu_mkhi_read_file_response_get_group_id(const FuMkhiReadFileResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_mkhi_read_file_response_get_command: (skip):
 **/
static FuMkhiCommand
fu_mkhi_read_file_response_get_command(const FuMkhiReadFileResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_mkhi_read_file_response_get_result: (skip):
 **/
guint8
fu_mkhi_read_file_response_get_result(const FuMkhiReadFileResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_mkhi_read_file_response_get_data_size: (skip):
 **/
guint32
fu_mkhi_read_file_response_get_data_size(const FuMkhiReadFileResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_mkhi_read_file_response_to_string: (skip):
 **/
static gchar *
fu_mkhi_read_file_response_to_string(const FuMkhiReadFileResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuMkhiReadFileResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  result: 0x%x\n",
                           (guint) fu_mkhi_read_file_response_get_result(st));
    g_string_append_printf(str, "  data_size: 0x%x\n",
                           (guint) fu_mkhi_read_file_response_get_data_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mkhi_read_file_response_validate_internal(FuMkhiReadFileResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_mkhi_read_file_response_get_group_id(st) != FU_MKHI_GROUP_ID_MCA) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuMkhiReadFileResponse.group_id was not valid, "
                    "expected 'FuMkhiGroupId' and got '%s'",
                    fu_mkhi_group_id_to_string(fu_mkhi_read_file_response_get_group_id(st)));
        return FALSE;
    }
    if (fu_mkhi_read_file_response_get_command(st) != FU_MKHI_COMMAND_READ_FILE_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuMkhiReadFileResponse.command was not valid, "
                    "expected 'FuMkhiCommand' and got '%s'",
                    fu_mkhi_command_to_string(fu_mkhi_read_file_response_get_command(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_mkhi_read_file_response_parse_internal(FuMkhiReadFileResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mkhi_read_file_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mkhi_read_file_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mkhi_read_file_response_parse: (skip):
 **/
FuMkhiReadFileResponse *
fu_mkhi_read_file_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMkhiReadFileResponse) st = fu_mkhi_read_file_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuMkhiReadFileResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_mkhi_read_file_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mkhi_read_file_ex_request_ref: (skip):
 **/
FuMkhiReadFileExRequest *
fu_mkhi_read_file_ex_request_ref(FuMkhiReadFileExRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_read_file_ex_request_unref: (skip):
 **/
void
fu_mkhi_read_file_ex_request_unref(FuMkhiReadFileExRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiReadFileExRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_read_file_ex_request_new_internal: (skip):
 **/
static FuMkhiReadFileExRequest *
fu_mkhi_read_file_ex_request_new_internal(void)
{
    FuMkhiReadFileExRequest *st = g_new0(FuMkhiReadFileExRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_mkhi_read_file_ex_request_set_group_id: (skip):
 **/
static void
fu_mkhi_read_file_ex_request_set_group_id(FuMkhiReadFileExRequest *st, FuMkhiGroupId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_mkhi_read_file_ex_request_set_command: (skip):
 **/
static void
fu_mkhi_read_file_ex_request_set_command(FuMkhiReadFileExRequest *st, FuMkhiCommand value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_mkhi_read_file_ex_request_set_result: (skip):
 **/
static void
fu_mkhi_read_file_ex_request_set_result(FuMkhiReadFileExRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_mkhi_read_file_ex_request_set_file_id: (skip):
 **/
void
fu_mkhi_read_file_ex_request_set_file_id(FuMkhiReadFileExRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_mkhi_read_file_ex_request_set_offset: (skip):
 **/
static void
fu_mkhi_read_file_ex_request_set_offset(FuMkhiReadFileExRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_mkhi_read_file_ex_request_set_data_size: (skip):
 **/
void
fu_mkhi_read_file_ex_request_set_data_size(FuMkhiReadFileExRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_mkhi_read_file_ex_request_set_flags: (skip):
 **/
void
fu_mkhi_read_file_ex_request_set_flags(FuMkhiReadFileExRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[16] = value;
}
/**
 * fu_mkhi_read_file_ex_request_new: (skip):
 **/
FuMkhiReadFileExRequest *
fu_mkhi_read_file_ex_request_new(void)
{
    FuMkhiReadFileExRequest *st = fu_mkhi_read_file_ex_request_new_internal();
    st->buf = g_byte_array_sized_new(17);
    fu_byte_array_set_size(st->buf, 17, 0x0);
    fu_mkhi_read_file_ex_request_set_group_id(st, FU_MKHI_GROUP_ID_MCA);
    fu_mkhi_read_file_ex_request_set_command(st, FU_MKHI_COMMAND_READ_FILE_EX);
    fu_mkhi_read_file_ex_request_set_result(st, 0x0);
    fu_mkhi_read_file_ex_request_set_offset(st, 0x0);
    return st;
}
/**
 * fu_mkhi_read_file_ex_response_ref: (skip):
 **/
FuMkhiReadFileExResponse *
fu_mkhi_read_file_ex_response_ref(FuMkhiReadFileExResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_read_file_ex_response_unref: (skip):
 **/
void
fu_mkhi_read_file_ex_response_unref(FuMkhiReadFileExResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiReadFileExResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_read_file_ex_response_new_internal: (skip):
 **/
static FuMkhiReadFileExResponse *
fu_mkhi_read_file_ex_response_new_internal(void)
{
    FuMkhiReadFileExResponse *st = g_new0(FuMkhiReadFileExResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mkhi_read_file_ex_response_get_group_id: (skip):
 **/
static FuMkhiGroupId
fu_mkhi_read_file_ex_response_get_group_id(const FuMkhiReadFileExResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_mkhi_read_file_ex_response_get_command: (skip):
 **/
static FuMkhiCommand
fu_mkhi_read_file_ex_response_get_command(const FuMkhiReadFileExResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_mkhi_read_file_ex_response_get_result: (skip):
 **/
guint8
fu_mkhi_read_file_ex_response_get_result(const FuMkhiReadFileExResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_mkhi_read_file_ex_response_get_data_size: (skip):
 **/
guint32
fu_mkhi_read_file_ex_response_get_data_size(const FuMkhiReadFileExResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_mkhi_read_file_ex_response_to_string: (skip):
 **/
static gchar *
fu_mkhi_read_file_ex_response_to_string(const FuMkhiReadFileExResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuMkhiReadFileExResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  result: 0x%x\n",
                           (guint) fu_mkhi_read_file_ex_response_get_result(st));
    g_string_append_printf(str, "  data_size: 0x%x\n",
                           (guint) fu_mkhi_read_file_ex_response_get_data_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mkhi_read_file_ex_response_validate_internal(FuMkhiReadFileExResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_mkhi_read_file_ex_response_get_group_id(st) != FU_MKHI_GROUP_ID_MCA) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuMkhiReadFileExResponse.group_id was not valid, "
                    "expected 'FuMkhiGroupId' and got '%s'",
                    fu_mkhi_group_id_to_string(fu_mkhi_read_file_ex_response_get_group_id(st)));
        return FALSE;
    }
    if (fu_mkhi_read_file_ex_response_get_command(st) != FU_MKHI_COMMAND_READ_FILE_EX_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuMkhiReadFileExResponse.command was not valid, "
                    "expected 'FuMkhiCommand' and got '%s'",
                    fu_mkhi_command_to_string(fu_mkhi_read_file_ex_response_get_command(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_mkhi_read_file_ex_response_parse_internal(FuMkhiReadFileExResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mkhi_read_file_ex_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mkhi_read_file_ex_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mkhi_read_file_ex_response_parse: (skip):
 **/
FuMkhiReadFileExResponse *
fu_mkhi_read_file_ex_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMkhiReadFileExResponse) st = fu_mkhi_read_file_ex_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuMkhiReadFileExResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_mkhi_read_file_ex_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mkhi_arbh_svn_info_entry_ref: (skip):
 **/
FuMkhiArbhSvnInfoEntry *
fu_mkhi_arbh_svn_info_entry_ref(FuMkhiArbhSvnInfoEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_arbh_svn_info_entry_unref: (skip):
 **/
void
fu_mkhi_arbh_svn_info_entry_unref(FuMkhiArbhSvnInfoEntry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiArbhSvnInfoEntry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_arbh_svn_info_entry_new_internal: (skip):
 **/
static FuMkhiArbhSvnInfoEntry *
fu_mkhi_arbh_svn_info_entry_new_internal(void)
{
    FuMkhiArbhSvnInfoEntry *st = g_new0(FuMkhiArbhSvnInfoEntry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mkhi_arbh_svn_info_entry_get_usage_id: (skip):
 **/
FuMkhiArbhSvnInfoEntryUsageId
fu_mkhi_arbh_svn_info_entry_get_usage_id(const FuMkhiArbhSvnInfoEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_mkhi_arbh_svn_info_entry_get_executing: (skip):
 **/
guint8
fu_mkhi_arbh_svn_info_entry_get_executing(const FuMkhiArbhSvnInfoEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_mkhi_arbh_svn_info_entry_get_min_allowed: (skip):
 **/
guint8
fu_mkhi_arbh_svn_info_entry_get_min_allowed(const FuMkhiArbhSvnInfoEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_mkhi_arbh_svn_info_entry_to_string: (skip):
 **/
static gchar *
fu_mkhi_arbh_svn_info_entry_to_string(const FuMkhiArbhSvnInfoEntry *st)
{
    g_autoptr(GString) str = g_string_new("FuMkhiArbhSvnInfoEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_mkhi_arbh_svn_info_entry_usage_id_to_string(fu_mkhi_arbh_svn_info_entry_get_usage_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  usage_id: 0x%x [%s]\n", (guint) fu_mkhi_arbh_svn_info_entry_get_usage_id(st), tmp);
        } else {
            g_string_append_printf(str, "  usage_id: 0x%x\n", (guint) fu_mkhi_arbh_svn_info_entry_get_usage_id(st));
        }
    }
    g_string_append_printf(str, "  executing: 0x%x\n",
                           (guint) fu_mkhi_arbh_svn_info_entry_get_executing(st));
    g_string_append_printf(str, "  min_allowed: 0x%x\n",
                           (guint) fu_mkhi_arbh_svn_info_entry_get_min_allowed(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mkhi_arbh_svn_info_entry_validate_internal(FuMkhiArbhSvnInfoEntry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_mkhi_arbh_svn_info_entry_parse_internal(FuMkhiArbhSvnInfoEntry *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mkhi_arbh_svn_info_entry_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mkhi_arbh_svn_info_entry_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mkhi_arbh_svn_info_entry_parse: (skip):
 **/
FuMkhiArbhSvnInfoEntry *
fu_mkhi_arbh_svn_info_entry_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMkhiArbhSvnInfoEntry) st = fu_mkhi_arbh_svn_info_entry_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuMkhiArbhSvnInfoEntry: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_mkhi_arbh_svn_info_entry_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mkhi_arbh_svn_get_info_request_ref: (skip):
 **/
FuMkhiArbhSvnGetInfoRequest *
fu_mkhi_arbh_svn_get_info_request_ref(FuMkhiArbhSvnGetInfoRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_arbh_svn_get_info_request_unref: (skip):
 **/
void
fu_mkhi_arbh_svn_get_info_request_unref(FuMkhiArbhSvnGetInfoRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiArbhSvnGetInfoRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_arbh_svn_get_info_request_new_internal: (skip):
 **/
static FuMkhiArbhSvnGetInfoRequest *
fu_mkhi_arbh_svn_get_info_request_new_internal(void)
{
    FuMkhiArbhSvnGetInfoRequest *st = g_new0(FuMkhiArbhSvnGetInfoRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_mkhi_arbh_svn_get_info_request_set_group_id: (skip):
 **/
static void
fu_mkhi_arbh_svn_get_info_request_set_group_id(FuMkhiArbhSvnGetInfoRequest *st, FuMkhiGroupId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_mkhi_arbh_svn_get_info_request_set_command: (skip):
 **/
static void
fu_mkhi_arbh_svn_get_info_request_set_command(FuMkhiArbhSvnGetInfoRequest *st, FuMkhiCommand value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_mkhi_arbh_svn_get_info_request_set_result: (skip):
 **/
static void
fu_mkhi_arbh_svn_get_info_request_set_result(FuMkhiArbhSvnGetInfoRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_mkhi_arbh_svn_get_info_request_new: (skip):
 **/
FuMkhiArbhSvnGetInfoRequest *
fu_mkhi_arbh_svn_get_info_request_new(void)
{
    FuMkhiArbhSvnGetInfoRequest *st = fu_mkhi_arbh_svn_get_info_request_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    fu_mkhi_arbh_svn_get_info_request_set_group_id(st, FU_MKHI_GROUP_ID_MCA);
    fu_mkhi_arbh_svn_get_info_request_set_command(st, FU_MKHI_COMMAND_ARBH_SVN_GET_INFO);
    fu_mkhi_arbh_svn_get_info_request_set_result(st, 0x0);
    return st;
}
/**
 * fu_mkhi_arbh_svn_get_info_response_ref: (skip):
 **/
FuMkhiArbhSvnGetInfoResponse *
fu_mkhi_arbh_svn_get_info_response_ref(FuMkhiArbhSvnGetInfoResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mkhi_arbh_svn_get_info_response_unref: (skip):
 **/
void
fu_mkhi_arbh_svn_get_info_response_unref(FuMkhiArbhSvnGetInfoResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMkhiArbhSvnGetInfoResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mkhi_arbh_svn_get_info_response_new_internal: (skip):
 **/
static FuMkhiArbhSvnGetInfoResponse *
fu_mkhi_arbh_svn_get_info_response_new_internal(void)
{
    FuMkhiArbhSvnGetInfoResponse *st = g_new0(FuMkhiArbhSvnGetInfoResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mkhi_arbh_svn_get_info_response_get_group_id: (skip):
 **/
static FuMkhiGroupId
fu_mkhi_arbh_svn_get_info_response_get_group_id(const FuMkhiArbhSvnGetInfoResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_mkhi_arbh_svn_get_info_response_get_command: (skip):
 **/
static FuMkhiCommand
fu_mkhi_arbh_svn_get_info_response_get_command(const FuMkhiArbhSvnGetInfoResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_mkhi_arbh_svn_get_info_response_get_result: (skip):
 **/
guint8
fu_mkhi_arbh_svn_get_info_response_get_result(const FuMkhiArbhSvnGetInfoResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_mkhi_arbh_svn_get_info_response_get_num_entries: (skip):
 **/
guint32
fu_mkhi_arbh_svn_get_info_response_get_num_entries(const FuMkhiArbhSvnGetInfoResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_mkhi_arbh_svn_get_info_response_to_string: (skip):
 **/
static gchar *
fu_mkhi_arbh_svn_get_info_response_to_string(const FuMkhiArbhSvnGetInfoResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuMkhiArbhSvnGetInfoResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  result: 0x%x\n",
                           (guint) fu_mkhi_arbh_svn_get_info_response_get_result(st));
    g_string_append_printf(str, "  num_entries: 0x%x\n",
                           (guint) fu_mkhi_arbh_svn_get_info_response_get_num_entries(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mkhi_arbh_svn_get_info_response_validate_internal(FuMkhiArbhSvnGetInfoResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_mkhi_arbh_svn_get_info_response_get_group_id(st) != FU_MKHI_GROUP_ID_MCA) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuMkhiArbhSvnGetInfoResponse.group_id was not valid, "
                    "expected 'FuMkhiGroupId' and got '%s'",
                    fu_mkhi_group_id_to_string(fu_mkhi_arbh_svn_get_info_response_get_group_id(st)));
        return FALSE;
    }
    if (fu_mkhi_arbh_svn_get_info_response_get_command(st) != FU_MKHI_COMMAND_ARBH_SVN_GET_INFO_RESPONSE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuMkhiArbhSvnGetInfoResponse.command was not valid, "
                    "expected 'FuMkhiCommand' and got '%s'",
                    fu_mkhi_command_to_string(fu_mkhi_arbh_svn_get_info_response_get_command(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_mkhi_arbh_svn_get_info_response_parse_internal(FuMkhiArbhSvnGetInfoResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mkhi_arbh_svn_get_info_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mkhi_arbh_svn_get_info_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mkhi_arbh_svn_get_info_response_parse: (skip):
 **/
FuMkhiArbhSvnGetInfoResponse *
fu_mkhi_arbh_svn_get_info_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMkhiArbhSvnGetInfoResponse) st = fu_mkhi_arbh_svn_get_info_response_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuMkhiArbhSvnGetInfoResponse: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_mkhi_arbh_svn_get_info_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
