/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM XRSessionEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "XRSessionEvent.h"
#include "XRSessionEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XRSession.h"
#include "mozilla/dom/XRSessionEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(XRSessionEvent)

NS_IMPL_ADDREF_INHERITED(XRSessionEvent, Event)
NS_IMPL_RELEASE_INHERITED(XRSessionEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(XRSessionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mSession)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(XRSessionEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(XRSessionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mSession)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(XRSessionEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

XRSessionEvent::XRSessionEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

XRSessionEvent::~XRSessionEvent()
{
}

XRSessionEvent*
XRSessionEvent::AsXRSessionEvent()
{
  return this;
}

JSObject*
XRSessionEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return XRSessionEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<XRSessionEvent>
XRSessionEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const XRSessionEventInit& aEventInitDict)
{
  RefPtr<XRSessionEvent> e = new XRSessionEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mSession = aEventInitDict.mSession;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<XRSessionEvent>
XRSessionEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const XRSessionEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

XRSession*
XRSessionEvent::Session() const
{
  return mSession;
}


} // namespace mozilla::dom
