// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanAccessibleMetrics_h
#define mozilla_GleanAccessibleMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace a11y {
  /**
   * generated from a11y.always_underline_links
   * Bool tracking if the user has always underline links enabled in firefox. This metric was generated to correspond to the Legacy Telemetry scalar a11y.always_underline_links.
   */
  constexpr impl::BooleanMetric always_underline_links(1);

  /**
   * generated from a11y.backplate
   * Boolean tracking if the user has the backplate preference enabled or disabled. This metric was generated to correspond to the Legacy Telemetry scalar a11y.backplate.
   */
  constexpr impl::BooleanMetric backplate(2);

  /**
   * generated from a11y.consumers
   * A list of known accessibility clients that inject into Firefox process space (see https://searchfox.org/mozilla-central/source/accessible/windows/msaa/Compatibility.h).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram A11Y_CONSUMERS.
   */
  constexpr impl::CustomDistributionMetric consumers(3);

  /**
   * generated from a11y.hcm_background
   * Unsigned int tracking the user's prefered background color \ (logged when HCM is enabled). This metric was generated to correspond to the Legacy Telemetry scalar a11y.HCM_background.
   */
  constexpr impl::QuantityMetric hcm_background(4);

  /**
   * generated from a11y.hcm_foreground
   * Unsigned int tracking the user's prefered foreground color \ (logged when HCM is enabled). This metric was generated to correspond to the Legacy Telemetry scalar a11y.HCM_foreground.
   */
  constexpr impl::QuantityMetric hcm_foreground(5);

  /**
   * generated from a11y.instantiators
   * The leaf name and version number of the binary for the process responsible for remotely instantiating a11y. This metric was generated to correspond to the Legacy Telemetry scalar a11y.instantiators.
   */
  constexpr impl::StringMetric instantiators(6);

  /**
   * generated from a11y.invert_colors
   * Boolean tracking if the user has an invert colors OS setting enabled. This metric was generated to correspond to the Legacy Telemetry scalar a11y.invert_colors.
   */
  constexpr impl::BooleanMetric invert_colors(7);

  /**
   * generated from a11y.theme
   */
  enum class ThemeLabel: uint16_t {
    eDefault = 0,
    eAlways = 1,
    eNever = 2,
    e__Other__,
  };
  /**
   * OS high contrast or other accessibility theme is enabled. The result is split into keys which represent the values of browser.display.document_color_use: "default", "always", or "never". This metric was generated to correspond to the Legacy Telemetry scalar a11y.theme.
   */
  constexpr impl::Labeled<impl::BooleanMetric, ThemeLabel> theme(8);

  /**
   * generated from a11y.tree_update_timing
   * The amount of time taken to update the accessibility tree (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram A11Y_TREE_UPDATE_TIMING_MS.
   */
  constexpr impl::TimingDistributionMetric tree_update_timing(9);

  /**
   * generated from a11y.use_system_colors
   * Bool tracking if the user has system colors enabled in firefox. This metric was generated to correspond to the Legacy Telemetry scalar a11y.use_system_colors.
   */
  constexpr impl::BooleanMetric use_system_colors(10);
}

} // namespace mozilla::glean

#endif // mozilla_GleanAccessibleMetrics_h
