// This file is generated by kconfig_compiler_kf6 from easyeffects_db_convolver.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_CONVOLVER_H
#define DB_CONVOLVER_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <qqmlintegration.h>

namespace db {

class Convolver : public KConfigBaseEE
{
  Q_OBJECT
  QML_ELEMENT
  QML_UNCREATABLE("")
  public:

    Convolver( const QString & masterGroup, const QString & instanceIndex );
    ~Convolver() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set kernelName
    */
    void setKernelName( const QString & v )
    {
      if (v != mKernelName && !isKernelNameImmutable()) {
        mKernelName = v;
        Q_EMIT kernelNameChanged();
      }
    }

    Q_PROPERTY(QString kernelName READ kernelName WRITE setKernelName NOTIFY kernelNameChanged)
    Q_PROPERTY(bool isKernelNameImmutable READ isKernelNameImmutable CONSTANT)
    Q_PROPERTY(QString defaultKernelNameValue READ defaultKernelNameValue CONSTANT)
    /**
      Get kernelName
    */
    QString kernelName() const
    {
      return mKernelName;
    }

    /**
      Is kernelName Immutable
    */
    bool isKernelNameImmutable() const
    {
      return isImmutable( QStringLiteral( "kernelName" ) );
    }

    /**
      Get kernelName default value
    */
    QString defaultKernelNameValue() const
    {
        return defaultKernelNameValue_helper();
    }

    /**
      Set irWidth
    */
    void setIrWidth( int v )
    {
      if (v < 0)
      {
        qDebug() << "setIrWidth: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 200)
      {
        qDebug() << "setIrWidth: value " << v << " is greater than the maximum value of 200";
        v = 200;
      }

      if (v != mIrWidth && !isIrWidthImmutable()) {
        mIrWidth = v;
        Q_EMIT irWidthChanged();
      }
    }

    Q_PROPERTY(int irWidth READ irWidth WRITE setIrWidth NOTIFY irWidthChanged)
    Q_PROPERTY(bool isIrWidthImmutable READ isIrWidthImmutable CONSTANT)
    Q_PROPERTY(int defaultIrWidthValue READ defaultIrWidthValue CONSTANT)
    /**
      Get irWidth
    */
    int irWidth() const
    {
      return mIrWidth;
    }

    /**
      Is irWidth Immutable
    */
    bool isIrWidthImmutable() const
    {
      return isImmutable( QStringLiteral( "irWidth" ) );
    }

    /**
      Get irWidth default value
    */
    int defaultIrWidthValue() const
    {
        return defaultIrWidthValue_helper();
    }

    /**
      Set autogain
    */
    void setAutogain( bool v )
    {
      if (v != mAutogain && !isAutogainImmutable()) {
        mAutogain = v;
        Q_EMIT autogainChanged();
      }
    }

    Q_PROPERTY(bool autogain READ autogain WRITE setAutogain NOTIFY autogainChanged)
    Q_PROPERTY(bool isAutogainImmutable READ isAutogainImmutable CONSTANT)
    Q_PROPERTY(bool defaultAutogainValue READ defaultAutogainValue CONSTANT)
    /**
      Get autogain
    */
    bool autogain() const
    {
      return mAutogain;
    }

    /**
      Is autogain Immutable
    */
    bool isAutogainImmutable() const
    {
      return isImmutable( QStringLiteral( "autogain" ) );
    }

    /**
      Get autogain default value
    */
    bool defaultAutogainValue() const
    {
        return defaultAutogainValue_helper();
    }

    /**
      Set dry
    */
    void setDry( double v )
    {
      if (v < -100)
      {
        qDebug() << "setDry: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 20)
      {
        qDebug() << "setDry: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mDry && !isDryImmutable()) {
        mDry = v;
        Q_EMIT dryChanged();
      }
    }

    Q_PROPERTY(double dry READ dry WRITE setDry NOTIFY dryChanged)
    Q_PROPERTY(bool isDryImmutable READ isDryImmutable CONSTANT)
    Q_PROPERTY(double defaultDryValue READ defaultDryValue CONSTANT)
    /**
      Get dry
    */
    double dry() const
    {
      return mDry;
    }

    /**
      Is dry Immutable
    */
    bool isDryImmutable() const
    {
      return isImmutable( QStringLiteral( "dry" ) );
    }

    /**
      Get dry default value
    */
    double defaultDryValue() const
    {
        return defaultDryValue_helper();
    }

    /**
      Set wet
    */
    void setWet( double v )
    {
      if (v < -100)
      {
        qDebug() << "setWet: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 20)
      {
        qDebug() << "setWet: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mWet && !isWetImmutable()) {
        mWet = v;
        Q_EMIT wetChanged();
      }
    }

    Q_PROPERTY(double wet READ wet WRITE setWet NOTIFY wetChanged)
    Q_PROPERTY(bool isWetImmutable READ isWetImmutable CONSTANT)
    Q_PROPERTY(double defaultWetValue READ defaultWetValue CONSTANT)
    /**
      Get wet
    */
    double wet() const
    {
      return mWet;
    }

    /**
      Is wet Immutable
    */
    bool isWetImmutable() const
    {
      return isImmutable( QStringLiteral( "wet" ) );
    }

    /**
      Get wet default value
    */
    double defaultWetValue() const
    {
        return defaultWetValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalKernelNameChanged = 4,
      signalIrWidthChanged = 5,
      signalAutogainChanged = 6,
      signalDryChanged = 7,
      signalWetChanged = 8
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void kernelNameChanged();

    void irWidthChanged();

    void autogainChanged();

    void dryChanged();

    void wetChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Convolver#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    QString mKernelName;
    QString defaultKernelNameValue_helper() const;
    int mIrWidth;
    int defaultIrWidthValue_helper() const;
    bool mAutogain;
    bool defaultAutogainValue_helper() const;
    double mDry;
    double defaultDryValue_helper() const;
    double mWet;
    double defaultWetValue_helper() const;
};

}

#endif

