/* Network.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Network.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_NETWORK_0_PROPERTY,
	DEJA_DUP_NETWORK_CONNECTED_PROPERTY,
	DEJA_DUP_NETWORK_METERED_PROPERTY,
	DEJA_DUP_NETWORK_NUM_PROPERTIES
};
static GParamSpec* deja_dup_network_properties[DEJA_DUP_NETWORK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupNetworkCanReachData DejaDupNetworkCanReachData;

struct _DejaDupNetworkPrivate {
	gboolean _connected;
	gboolean _metered;
	GSettings* settings;
};

struct _DejaDupNetworkCanReachData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupNetwork* self;
	gchar* url;
	gboolean result;
	GNetworkMonitor* mon;
	GNetworkMonitor* _tmp0_;
	GNetworkMonitor* _tmp1_;
	GNetworkAddress* socket;
	GNetworkAddress* _tmp2_;
	gboolean _tmp3_;
	GNetworkMonitor* _tmp4_;
	GNetworkAddress* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

static gint DejaDupNetwork_private_offset;
static gpointer deja_dup_network_parent_class = NULL;
static DejaDupNetwork* deja_dup_network_singleton;
static DejaDupNetwork* deja_dup_network_singleton = NULL;

static void deja_dup_network_can_reach_data_free (gpointer _data);
static gboolean deja_dup_network_can_reach_co (DejaDupNetworkCanReachData* _data_);
static void deja_dup_network_can_reach_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void deja_dup_network_update_connected (DejaDupNetwork* self);
static void deja_dup_network_set_connected (DejaDupNetwork* self,
                                     gboolean value);
static void deja_dup_network_update_metered (DejaDupNetwork* self);
static void deja_dup_network_set_metered (DejaDupNetwork* self,
                                   gboolean value);
static GObject * deja_dup_network_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _deja_dup_network_update_connected_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void _deja_dup_network_update_metered_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _deja_dup_network_update_metered_g_settings_changed (GSettings* _sender,
                                                          const gchar* key,
                                                          gpointer self);
static void deja_dup_network_finalize (GObject * obj);
static GType deja_dup_network_get_type_once (void);
static void _vala_deja_dup_network_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_deja_dup_network_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
deja_dup_network_get_instance_private (DejaDupNetwork* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupNetwork_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupNetwork*
deja_dup_network_get (void)
{
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	DejaDupNetwork* result;
	_tmp0_ = deja_dup_network_singleton;
	if (_tmp0_ == NULL) {
		DejaDupNetwork* _tmp1_;
		_tmp1_ = deja_dup_network_new ();
		_g_object_unref0 (deja_dup_network_singleton);
		deja_dup_network_singleton = _tmp1_;
	}
	_tmp2_ = deja_dup_network_singleton;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
deja_dup_network_can_reach_data_free (gpointer _data)
{
	DejaDupNetworkCanReachData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupNetworkCanReachData, _data_);
}

void
deja_dup_network_can_reach (DejaDupNetwork* self,
                            const gchar* url,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	DejaDupNetworkCanReachData* _data_;
	DejaDupNetwork* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_data_ = g_slice_new0 (DejaDupNetworkCanReachData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_network_can_reach_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (url);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	deja_dup_network_can_reach_co (_data_);
}

gboolean
deja_dup_network_can_reach_finish (DejaDupNetwork* self,
                                   GAsyncResult* _res_)
{
	gboolean result;
	DejaDupNetworkCanReachData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
deja_dup_network_can_reach_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	DejaDupNetworkCanReachData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_network_can_reach_co (_data_);
}

static gboolean
deja_dup_network_can_reach_co (DejaDupNetworkCanReachData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_network_monitor_get_default ();
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->mon = _data_->_tmp1_;
	{
		_data_->_tmp2_ = g_network_address_parse_uri (_data_->url, (guint16) 0, &_data_->_inner_error0_);
		_data_->socket = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->mon;
		_data_->_tmp5_ = _data_->socket;
		_data_->_state_ = 1;
		g_network_monitor_can_reach_async (_data_->_tmp4_, (GSocketConnectable*) _data_->_tmp5_, NULL, deja_dup_network_can_reach_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_network_monitor_can_reach_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->socket);
			goto __catch0_g_error;
		}
		_data_->result = _data_->_tmp3_;
		_g_object_unref0 (_data_->socket);
		_g_object_unref0 (_data_->mon);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("Network.vala:30: %s", _data_->_tmp7_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->mon);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->mon);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_network_update_connected (DejaDupNetwork* self)
{
	GNetworkConnectivity connectivity = 0;
	GNetworkMonitor* _tmp0_;
	GNetworkConnectivity _tmp1_;
	GNetworkConnectivity _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = g_network_monitor_get_connectivity (_tmp0_);
	_tmp2_ = _tmp1_;
	connectivity = _tmp2_;
	if (connectivity == G_NETWORK_CONNECTIVITY_FULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = connectivity == G_NETWORK_CONNECTIVITY_LIMITED;
	}
	deja_dup_network_set_connected (self, _tmp3_);
}

static void
deja_dup_network_update_metered (DejaDupNetwork* self)
{
	GNetworkMonitor* mon = NULL;
	GNetworkMonitor* _tmp0_;
	GNetworkMonitor* _tmp1_;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp2_;
	gboolean allow_metered = FALSE;
	DejaDupFilteredSettings* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GNetworkMonitor* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	mon = _tmp1_;
	_tmp2_ = deja_dup_get_settings (NULL);
	settings = _tmp2_;
	_tmp3_ = settings;
	allow_metered = g_settings_get_boolean ((GSettings*) _tmp3_, DEJA_DUP_ALLOW_METERED_KEY);
	_tmp5_ = mon;
	_tmp6_ = g_network_monitor_get_network_metered (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp4_ = !allow_metered;
	} else {
		_tmp4_ = FALSE;
	}
	deja_dup_network_set_metered (self, _tmp4_);
	_g_object_unref0 (settings);
	_g_object_unref0 (mon);
}

DejaDupNetwork*
deja_dup_network_construct (GType object_type)
{
	DejaDupNetwork * self = NULL;
	self = (DejaDupNetwork*) g_object_new (object_type, NULL);
	return self;
}

DejaDupNetwork*
deja_dup_network_new (void)
{
	return deja_dup_network_construct (DEJA_DUP_TYPE_NETWORK);
}

gboolean
deja_dup_network_get_connected (DejaDupNetwork* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_connected;
	return result;
}

static void
deja_dup_network_set_connected (DejaDupNetwork* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_network_get_connected (self);
	if (old_value != value) {
		self->priv->_connected = value;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_network_properties[DEJA_DUP_NETWORK_CONNECTED_PROPERTY]);
	}
}

gboolean
deja_dup_network_get_metered (DejaDupNetwork* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_metered;
	return result;
}

static void
deja_dup_network_set_metered (DejaDupNetwork* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_network_get_metered (self);
	if (old_value != value) {
		self->priv->_metered = value;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_network_properties[DEJA_DUP_NETWORK_METERED_PROPERTY]);
	}
}

static void
_deja_dup_network_update_connected_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	deja_dup_network_update_connected ((DejaDupNetwork*) self);
}

static void
_deja_dup_network_update_metered_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	deja_dup_network_update_metered ((DejaDupNetwork*) self);
}

static void
_deja_dup_network_update_metered_g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self)
{
	deja_dup_network_update_metered ((DejaDupNetwork*) self);
}

static GObject *
deja_dup_network_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupNetwork * self;
	GNetworkMonitor* mon = NULL;
	GNetworkMonitor* _tmp0_;
	GNetworkMonitor* _tmp1_;
	DejaDupFilteredSettings* _tmp2_;
	GNetworkMonitor* _tmp3_;
	GNetworkMonitor* _tmp4_;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	parent_class = G_OBJECT_CLASS (deja_dup_network_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_NETWORK, DejaDupNetwork);
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	mon = _tmp1_;
	_tmp2_ = deja_dup_get_settings (NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = (GSettings*) _tmp2_;
	_tmp3_ = mon;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::connectivity", (GCallback) _deja_dup_network_update_connected_g_object_notify, self, 0);
	deja_dup_network_update_connected (self);
	_tmp4_ = mon;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::network-metered", (GCallback) _deja_dup_network_update_metered_g_object_notify, self, 0);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_strconcat ("changed::", DEJA_DUP_ALLOW_METERED_KEY, NULL);
	g_signal_connect_object (_tmp5_, _tmp6_, (GCallback) _deja_dup_network_update_metered_g_settings_changed, self, 0);
	_g_free0 (_tmp6_);
	deja_dup_network_update_metered (self);
	_g_object_unref0 (mon);
	return obj;
}

static void
deja_dup_network_class_init (DejaDupNetworkClass * klass,
                             gpointer klass_data)
{
	deja_dup_network_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupNetwork_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_network_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_network_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_network_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_network_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_NETWORK_CONNECTED_PROPERTY, deja_dup_network_properties[DEJA_DUP_NETWORK_CONNECTED_PROPERTY] = g_param_spec_boolean ("connected", "connected", "connected", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_NETWORK_METERED_PROPERTY, deja_dup_network_properties[DEJA_DUP_NETWORK_METERED_PROPERTY] = g_param_spec_boolean ("metered", "metered", "metered", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
deja_dup_network_instance_init (DejaDupNetwork * self,
                                gpointer klass)
{
	self->priv = deja_dup_network_get_instance_private (self);
	self->priv->_connected = TRUE;
	self->priv->_metered = FALSE;
}

static void
deja_dup_network_finalize (GObject * obj)
{
	DejaDupNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_NETWORK, DejaDupNetwork);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (deja_dup_network_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_network_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupNetworkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_network_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupNetwork), 0, (GInstanceInitFunc) deja_dup_network_instance_init, NULL };
	GType deja_dup_network_type_id;
	deja_dup_network_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupNetwork", &g_define_type_info, 0);
	DejaDupNetwork_private_offset = g_type_add_instance_private (deja_dup_network_type_id, sizeof (DejaDupNetworkPrivate));
	return deja_dup_network_type_id;
}

GType
deja_dup_network_get_type (void)
{
	static gsize deja_dup_network_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_network_type_id__once)) {
		GType deja_dup_network_type_id;
		deja_dup_network_type_id = deja_dup_network_get_type_once ();
		g_once_init_leave (&deja_dup_network_type_id__once, deja_dup_network_type_id);
	}
	return deja_dup_network_type_id__once;
}

static void
_vala_deja_dup_network_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	DejaDupNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_NETWORK, DejaDupNetwork);
	switch (property_id) {
		case DEJA_DUP_NETWORK_CONNECTED_PROPERTY:
		g_value_set_boolean (value, deja_dup_network_get_connected (self));
		break;
		case DEJA_DUP_NETWORK_METERED_PROPERTY:
		g_value_set_boolean (value, deja_dup_network_get_metered (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_network_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	DejaDupNetwork * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_NETWORK, DejaDupNetwork);
	switch (property_id) {
		case DEJA_DUP_NETWORK_CONNECTED_PROPERTY:
		deja_dup_network_set_connected (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_NETWORK_METERED_PROPERTY:
		deja_dup_network_set_metered (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

