/* FileTree.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileTree.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_FILE_TREE_0_PROPERTY,
	DEJA_DUP_FILE_TREE_ROOT_PROPERTY,
	DEJA_DUP_FILE_TREE_SKIPPED_ROOT_PROPERTY,
	DEJA_DUP_FILE_TREE_OLD_HOME_PROPERTY,
	DEJA_DUP_FILE_TREE_NUM_PROPERTIES
};
static GParamSpec* deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
enum  {
	DEJA_DUP_FILE_TREE_NODE_0_PROPERTY,
	DEJA_DUP_FILE_TREE_NODE_PARENT_PROPERTY,
	DEJA_DUP_FILE_TREE_NODE_FILENAME_PROPERTY,
	DEJA_DUP_FILE_TREE_NODE_KIND_PROPERTY,
	DEJA_DUP_FILE_TREE_NODE_CHILDREN_PROPERTY,
	DEJA_DUP_FILE_TREE_NODE_NUM_PROPERTIES
};
static GParamSpec* deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _DejaDupFileTreePrivate {
	DejaDupFileTreeNode* _root;
	gchar* _skipped_root;
	gchar* _old_home;
	GList* readmes;
};

struct _Block4Data {
	int _ref_count_;
	DejaDupFileTree* self;
	DejaDupFileTreeNode** homes;
	gint homes_length1;
	gint _homes_size_;
};

struct _DejaDupFileTreeNodePrivate {
	DejaDupFileTreeNode* _parent;
	gchar* _filename;
	GFileType _kind;
	GHashTable* _children;
};

static gint DejaDupFileTree_private_offset;
static gpointer deja_dup_file_tree_parent_class = NULL;
static gint DejaDupFileTreeNode_private_offset;
static gpointer deja_dup_file_tree_node_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_file_tree_clear_metadir (DejaDupFileTree* self);
static void deja_dup_file_tree_rewrite_single_home (DejaDupFileTree* self);
static void deja_dup_file_tree_set_root (DejaDupFileTree* self,
                                  DejaDupFileTreeNode* value);
static void deja_dup_file_tree_set_skipped_root (DejaDupFileTree* self,
                                          const gchar* value);
VALA_EXTERN void deja_dup_file_tree_node_set_filename (DejaDupFileTreeNode* self,
                                           const gchar* value);
VALA_EXTERN void deja_dup_file_tree_node_set_parent (DejaDupFileTreeNode* self,
                                         DejaDupFileTreeNode* value);
static void deja_dup_file_tree_erase_node_and_parents (DejaDupFileTree* self,
                                                DejaDupFileTreeNode* node);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _vala_array_add10 (DejaDupFileTreeNode** * array,
                        gint* length,
                        gint* size,
                        DejaDupFileTreeNode* value);
static void ___lambda14_ (Block4Data* _data4_,
                   DejaDupFileTreeNode* x);
static void _vala_array_add11 (DejaDupFileTreeNode** * array,
                        gint* length,
                        gint* size,
                        DejaDupFileTreeNode* value);
static void ____lambda14__gfunc (gconstpointer data,
                          gpointer self);
static void deja_dup_file_tree_set_old_home (DejaDupFileTree* self,
                                      const gchar* value);
VALA_EXTERN void deja_dup_file_tree_node_set_children (DejaDupFileTreeNode* self,
                                           GHashTable* value);
static GObject * deja_dup_file_tree_node_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void deja_dup_file_tree_node_finalize (GObject * obj);
static GType deja_dup_file_tree_node_get_type_once (void);
static void _vala_deja_dup_file_tree_node_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_deja_dup_file_tree_node_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static GObject * deja_dup_file_tree_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void deja_dup_file_tree_finalize (GObject * obj);
static GType deja_dup_file_tree_get_type_once (void);
static void _vala_deja_dup_file_tree_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_deja_dup_file_tree_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
deja_dup_file_tree_get_instance_private (DejaDupFileTree* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupFileTree_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
deja_dup_file_tree_original_path (DejaDupFileTree* self,
                                  const gchar* path)
{
	const gchar* _tmp0_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->_old_home;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = self->priv->_old_home;
		_tmp3_ = string_replace (path, _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup (path);
	result = _tmp4_;
	return result;
}

GFile*
deja_dup_file_tree_node_to_file (DejaDupFileTree* self,
                                 DejaDupFileTreeNode* node)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = deja_dup_file_tree_node_to_path (self, node);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename ("/", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
deja_dup_file_tree_node_to_path (DejaDupFileTree* self,
                                 DejaDupFileTreeNode* node)
{
	gchar* filename = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	DejaDupFileTreeNode* iter = NULL;
	DejaDupFileTreeNode* _tmp3_;
	DejaDupFileTreeNode* _tmp4_;
	DejaDupFileTreeNode* _tmp5_;
	const gchar* _tmp20_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = deja_dup_file_tree_node_get_filename (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	filename = _tmp2_;
	_tmp3_ = deja_dup_file_tree_node_get_parent (node);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	iter = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		DejaDupFileTreeNode* _tmp7_;
		DejaDupFileTreeNode* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		DejaDupFileTreeNode* _tmp16_;
		DejaDupFileTreeNode* _tmp17_;
		DejaDupFileTreeNode* _tmp18_;
		DejaDupFileTreeNode* _tmp19_;
		_tmp7_ = iter;
		if (_tmp7_ != NULL) {
			DejaDupFileTreeNode* _tmp8_;
			DejaDupFileTreeNode* _tmp9_;
			DejaDupFileTreeNode* _tmp10_;
			_tmp8_ = iter;
			_tmp9_ = deja_dup_file_tree_node_get_parent (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp11_ = iter;
		_tmp12_ = deja_dup_file_tree_node_get_filename (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = filename;
		_tmp15_ = g_build_filename (_tmp13_, _tmp14_, NULL);
		_g_free0 (filename);
		filename = _tmp15_;
		_tmp16_ = iter;
		_tmp17_ = deja_dup_file_tree_node_get_parent (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_g_object_unref0 (iter);
		iter = _tmp19_;
	}
	_tmp20_ = self->priv->_skipped_root;
	if (_tmp20_ == NULL) {
		result = filename;
		_g_object_unref0 (iter);
		return result;
	} else {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = self->priv->_skipped_root;
		_tmp22_ = filename;
		_tmp23_ = g_build_filename (_tmp21_, _tmp22_, NULL);
		result = _tmp23_;
		_g_object_unref0 (iter);
		_g_free0 (filename);
		return result;
	}
}

DejaDupFileTreeNode*
deja_dup_file_tree_file_to_node (DejaDupFileTree* self,
                                 GFile* file,
                                 gboolean allow_partial)
{
	gchar* remainder = NULL;
	gchar* prefix = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* prefix_file = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar** parts = NULL;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint parts_length1;
	gint _parts_size_;
	DejaDupFileTreeNode* node = NULL;
	DejaDupFileTreeNode* _tmp15_;
	DejaDupFileTreeNode* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	DejaDupFileTreeNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_strdup ("");
	prefix = _tmp0_;
	_tmp1_ = self->priv->_skipped_root;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_skipped_root;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (prefix);
		prefix = _tmp3_;
	}
	_tmp4_ = prefix;
	_tmp5_ = g_strdup_printf ("/%s", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	prefix_file = _tmp8_;
	_tmp9_ = prefix_file;
	_tmp10_ = g_file_get_relative_path (_tmp9_, file);
	_g_free0 (remainder);
	remainder = _tmp10_;
	_tmp11_ = remainder;
	if (_tmp11_ == NULL) {
		result = NULL;
		_g_object_unref0 (prefix_file);
		_g_free0 (prefix);
		_g_free0 (remainder);
		return result;
	}
	_tmp12_ = remainder;
	_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "/", 0);
	parts = _tmp14_;
	parts_length1 = _vala_array_length (_tmp13_);
	_parts_size_ = parts_length1;
	_tmp15_ = self->priv->_root;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	node = _tmp16_;
	_tmp17_ = parts;
	_tmp17__length1 = parts_length1;
	{
		gchar** part_collection = NULL;
		gint part_collection_length1 = 0;
		gint _part_collection_size_ = 0;
		gint part_it = 0;
		part_collection = _tmp17_;
		part_collection_length1 = _tmp17__length1;
		for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
			gchar* _tmp18_;
			gchar* part = NULL;
			_tmp18_ = g_strdup (part_collection[part_it]);
			part = _tmp18_;
			{
				DejaDupFileTreeNode* child = NULL;
				DejaDupFileTreeNode* _tmp19_;
				GHashTable* _tmp20_;
				GHashTable* _tmp21_;
				const gchar* _tmp22_;
				gconstpointer _tmp23_;
				DejaDupFileTreeNode* _tmp24_;
				DejaDupFileTreeNode* _tmp25_;
				DejaDupFileTreeNode* _tmp29_;
				DejaDupFileTreeNode* _tmp30_;
				_tmp19_ = node;
				_tmp20_ = deja_dup_file_tree_node_get_children (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = part;
				_tmp23_ = g_hash_table_lookup (_tmp21_, _tmp22_);
				_tmp24_ = _g_object_ref0 ((DejaDupFileTreeNode*) _tmp23_);
				child = _tmp24_;
				_tmp25_ = child;
				if (_tmp25_ == NULL) {
					DejaDupFileTreeNode* _tmp26_ = NULL;
					DejaDupFileTreeNode* _tmp28_;
					if (allow_partial) {
						DejaDupFileTreeNode* _tmp27_;
						_tmp27_ = node;
						_tmp26_ = _tmp27_;
					} else {
						_tmp26_ = NULL;
					}
					_tmp28_ = _g_object_ref0 (_tmp26_);
					result = _tmp28_;
					_g_object_unref0 (child);
					_g_free0 (part);
					_g_object_unref0 (node);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (prefix_file);
					_g_free0 (prefix);
					_g_free0 (remainder);
					return result;
				}
				_tmp29_ = child;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (node);
				node = _tmp30_;
				_g_object_unref0 (child);
				_g_free0 (part);
			}
		}
	}
	result = node;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (prefix_file);
	_g_free0 (prefix);
	_g_free0 (remainder);
	return result;
}

DejaDupFileTreeNode*
deja_dup_file_tree_add (DejaDupFileTree* self,
                        const gchar* file,
                        GFileType kind,
                        gboolean* created)
{
	gboolean _vala_created = FALSE;
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	DejaDupFileTreeNode* iter = NULL;
	DejaDupFileTreeNode* _tmp2_;
	DejaDupFileTreeNode* _tmp3_;
	DejaDupFileTreeNode* parent = NULL;
	DejaDupFileTreeNode* _tmp4_;
	DejaDupFileTreeNode* _tmp5_;
	DejaDupFileTreeNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_vala_created = FALSE;
	_tmp1_ = _tmp0_ = g_strsplit (file, "/", 0);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	_tmp2_ = self->priv->_root;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	parent = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				DejaDupFileTreeNode* _tmp11_;
				DejaDupFileTreeNode* _tmp12_;
				DejaDupFileTreeNode* _tmp13_;
				GHashTable* _tmp14_;
				GHashTable* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gconstpointer _tmp18_;
				DejaDupFileTreeNode* _tmp19_;
				DejaDupFileTreeNode* _tmp20_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = parts;
				_tmp8__length1 = parts_length1;
				if (!(i < _tmp8__length1)) {
					break;
				}
				_tmp9_ = parts;
				_tmp9__length1 = parts_length1;
				_tmp10_ = _tmp9_[i];
				if (g_strcmp0 (_tmp10_, "") == 0) {
					continue;
				}
				_tmp11_ = iter;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (parent);
				parent = _tmp12_;
				_tmp13_ = parent;
				_tmp14_ = deja_dup_file_tree_node_get_children (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = parts;
				_tmp16__length1 = parts_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = g_hash_table_lookup (_tmp15_, _tmp17_);
				_tmp19_ = _g_object_ref0 ((DejaDupFileTreeNode*) _tmp18_);
				_g_object_unref0 (iter);
				iter = _tmp19_;
				_tmp20_ = iter;
				if (_tmp20_ == NULL) {
					GFileType _tmp21_ = 0;
					gchar** _tmp22_;
					gint _tmp22__length1;
					GFileType part_kind = 0;
					DejaDupFileTreeNode* _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					const gchar* _tmp25_;
					DejaDupFileTreeNode* _tmp26_;
					DejaDupFileTreeNode* _tmp27_;
					GHashTable* _tmp28_;
					GHashTable* _tmp29_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					DejaDupFileTreeNode* _tmp33_;
					DejaDupFileTreeNode* _tmp34_;
					_tmp22_ = parts;
					_tmp22__length1 = parts_length1;
					if (i == (_tmp22__length1 - 1)) {
						_tmp21_ = kind;
					} else {
						_tmp21_ = G_FILE_TYPE_DIRECTORY;
					}
					part_kind = _tmp21_;
					_tmp23_ = parent;
					_tmp24_ = parts;
					_tmp24__length1 = parts_length1;
					_tmp25_ = _tmp24_[i];
					_tmp26_ = deja_dup_file_tree_node_new (_tmp23_, _tmp25_, part_kind);
					_g_object_unref0 (iter);
					iter = _tmp26_;
					_tmp27_ = parent;
					_tmp28_ = deja_dup_file_tree_node_get_children (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = parts;
					_tmp30__length1 = parts_length1;
					_tmp31_ = _tmp30_[i];
					_tmp32_ = g_strdup (_tmp31_);
					_tmp33_ = iter;
					_tmp34_ = _g_object_ref0 (_tmp33_);
					g_hash_table_insert (_tmp29_, _tmp32_, _tmp34_);
					_vala_created = TRUE;
				}
			}
		}
	}
	if (g_str_has_suffix (file, PACKAGE "/metadata/README")) {
		DejaDupFileTreeNode* _tmp35_;
		DejaDupFileTreeNode* _tmp36_;
		_tmp35_ = iter;
		_tmp36_ = _g_object_ref0 (_tmp35_);
		self->priv->readmes = g_list_append (self->priv->readmes, _tmp36_);
	}
	result = iter;
	_g_object_unref0 (parent);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (created) {
		*created = _vala_created;
	}
	return result;
}

void
deja_dup_file_tree_finish (DejaDupFileTree* self)
{
	DejaDupFileTreeNode* old_root = NULL;
	DejaDupFileTreeNode* _tmp0_;
	DejaDupFileTreeNode* _tmp1_;
	DejaDupFileTreeNode* _tmp19_;
	DejaDupFileTreeNode* _tmp20_;
	DejaDupFileTreeNode* _tmp21_;
	DejaDupFileTreeNode* _tmp25_;
	DejaDupFileTreeNode* _tmp26_;
	g_return_if_fail (self != NULL);
	deja_dup_file_tree_clear_metadir (self);
	deja_dup_file_tree_rewrite_single_home (self);
	_tmp0_ = self->priv->_root;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	old_root = _tmp1_;
	while (TRUE) {
		DejaDupFileTreeNode* _tmp2_;
		GHashTable* _tmp3_;
		GHashTable* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		DejaDupFileTreeNode* child = NULL;
		DejaDupFileTreeNode* _tmp7_;
		GHashTable* _tmp8_;
		GHashTable* _tmp9_;
		GList* _tmp10_;
		GList* _tmp11_;
		gconstpointer _tmp12_;
		DejaDupFileTreeNode* _tmp13_;
		DejaDupFileTreeNode* _tmp14_;
		DejaDupFileTreeNode* _tmp15_;
		GFileType _tmp16_;
		GFileType _tmp17_;
		DejaDupFileTreeNode* _tmp18_;
		_tmp2_ = self->priv->_root;
		_tmp3_ = deja_dup_file_tree_node_get_children (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_hash_table_size (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!(_tmp6_ == ((guint) 1))) {
			break;
		}
		_tmp7_ = self->priv->_root;
		_tmp8_ = deja_dup_file_tree_node_get_children (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_hash_table_get_values (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_->data;
		_tmp13_ = _g_object_ref0 ((DejaDupFileTreeNode*) _tmp12_);
		_tmp14_ = _tmp13_;
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (g_list_free (_tmp11_), NULL));
		child = _tmp14_;
		_tmp15_ = child;
		_tmp16_ = deja_dup_file_tree_node_get_kind (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != G_FILE_TYPE_DIRECTORY) {
			_g_object_unref0 (child);
			break;
		}
		_tmp18_ = child;
		deja_dup_file_tree_set_root (self, _tmp18_);
		_g_object_unref0 (child);
	}
	_tmp19_ = self->priv->_root;
	_tmp20_ = deja_dup_file_tree_node_get_parent (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		DejaDupFileTreeNode* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = self->priv->_root;
		_tmp23_ = deja_dup_file_tree_node_to_path (self, _tmp22_);
		_tmp24_ = _tmp23_;
		deja_dup_file_tree_set_skipped_root (self, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = self->priv->_root;
	deja_dup_file_tree_node_set_filename (_tmp25_, "");
	_tmp26_ = self->priv->_root;
	deja_dup_file_tree_node_set_parent (_tmp26_, NULL);
	_g_object_unref0 (old_root);
	old_root = NULL;
	_g_object_unref0 (old_root);
}

static void
deja_dup_file_tree_erase_node_and_parents (DejaDupFileTree* self,
                                           DejaDupFileTreeNode* node)
{
	DejaDupFileTreeNode* iter = NULL;
	DejaDupFileTreeNode* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _g_object_ref0 (node);
	iter = _tmp0_;
	while (TRUE) {
		DejaDupFileTreeNode* _tmp1_;
		DejaDupFileTreeNode* _tmp2_;
		DejaDupFileTreeNode* _tmp3_;
		DejaDupFileTreeNode* parent = NULL;
		DejaDupFileTreeNode* _tmp4_;
		DejaDupFileTreeNode* _tmp5_;
		DejaDupFileTreeNode* _tmp6_;
		DejaDupFileTreeNode* _tmp7_;
		DejaDupFileTreeNode* _tmp8_;
		GHashTable* _tmp9_;
		GHashTable* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		DejaDupFileTreeNode* _tmp19_;
		GHashTable* _tmp20_;
		GHashTable* _tmp21_;
		guint _tmp22_;
		guint _tmp23_;
		DejaDupFileTreeNode* _tmp24_;
		DejaDupFileTreeNode* _tmp25_;
		_tmp1_ = iter;
		_tmp2_ = deja_dup_file_tree_node_get_parent (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = deja_dup_file_tree_node_get_parent (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		parent = _tmp7_;
		_tmp8_ = iter;
		_tmp9_ = deja_dup_file_tree_node_get_children (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_hash_table_size (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == ((guint) 0)) {
			DejaDupFileTreeNode* _tmp13_;
			GHashTable* _tmp14_;
			GHashTable* _tmp15_;
			DejaDupFileTreeNode* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp13_ = parent;
			_tmp14_ = deja_dup_file_tree_node_get_children (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = iter;
			_tmp17_ = deja_dup_file_tree_node_get_filename (_tmp16_);
			_tmp18_ = _tmp17_;
			g_hash_table_remove (_tmp15_, _tmp18_);
		}
		_tmp19_ = parent;
		_tmp20_ = deja_dup_file_tree_node_get_children (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_hash_table_size (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ > ((guint) 0)) {
			_g_object_unref0 (parent);
			break;
		}
		_tmp24_ = parent;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (iter);
		iter = _tmp25_;
		_g_object_unref0 (parent);
	}
	_g_object_unref0 (iter);
}

static void
deja_dup_file_tree_clear_metadir (DejaDupFileTree* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->readmes;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp0_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			DejaDupFileTreeNode* _tmp1_;
			DejaDupFileTreeNode* node = NULL;
			_tmp1_ = _g_object_ref0 ((DejaDupFileTreeNode*) node_it->data);
			node = _tmp1_;
			{
				DejaDupFileTreeNode* _tmp2_;
				DejaDupFileTreeNode* _tmp3_;
				DejaDupFileTreeNode* _tmp4_;
				GHashTable* _tmp5_;
				GHashTable* _tmp6_;
				_tmp2_ = node;
				_tmp3_ = deja_dup_file_tree_node_get_parent (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = deja_dup_file_tree_node_get_children (_tmp4_);
				_tmp6_ = _tmp5_;
				if (g_hash_table_size (_tmp6_) == ((guint) 1)) {
					DejaDupFileTreeNode* _tmp7_;
					_tmp7_ = node;
					deja_dup_file_tree_erase_node_and_parents (self, _tmp7_);
				}
				_g_object_unref0 (node);
			}
		}
	}
	(self->priv->readmes == NULL) ? NULL : (self->priv->readmes = (_g_list_free__g_object_unref0_ (self->priv->readmes), NULL));
	self->priv->readmes = NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DejaDupFileTree* self;
		self = _data4_->self;
		_data4_->homes = (_vala_array_free (_data4_->homes, _data4_->homes_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_array_add10 (DejaDupFileTreeNode** * array,
                   gint* length,
                   gint* size,
                   DejaDupFileTreeNode* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DejaDupFileTreeNode*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (DejaDupFileTreeNode** * array,
                   gint* length,
                   gint* size,
                   DejaDupFileTreeNode* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DejaDupFileTreeNode*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
___lambda14_ (Block4Data* _data4_,
              DejaDupFileTreeNode* x)
{
	DejaDupFileTree* self;
	DejaDupFileTreeNode* _tmp0_;
	self = _data4_->self;
	g_return_if_fail (x != NULL);
	_tmp0_ = _g_object_ref0 (x);
	_vala_array_add11 (&_data4_->homes, &_data4_->homes_length1, &_data4_->_homes_size_, _tmp0_);
}

static void
____lambda14__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda14_ (self, (DejaDupFileTreeNode*) data);
}

static void
deja_dup_file_tree_rewrite_single_home (DejaDupFileTree* self)
{
	Block4Data* _data4_;
	DejaDupFileTreeNode** _tmp0_;
	DejaDupFileTreeNode* slash_root = NULL;
	DejaDupFileTreeNode* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	DejaDupFileTreeNode* _tmp5_;
	DejaDupFileTreeNode* _tmp6_;
	DejaDupFileTreeNode* slash_home = NULL;
	DejaDupFileTreeNode* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	gconstpointer _tmp12_;
	DejaDupFileTreeNode* _tmp13_;
	DejaDupFileTreeNode* _tmp14_;
	DejaDupFileTreeNode** _tmp20_;
	gint _tmp20__length1;
	GFile* single_home_file = NULL;
	DejaDupFileTreeNode** _tmp21_;
	gint _tmp21__length1;
	DejaDupFileTreeNode* _tmp22_;
	GFile* _tmp23_;
	GFile* my_home_file = NULL;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	gboolean created = FALSE;
	DejaDupFileTreeNode* my_home_node = NULL;
	GFile* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp31_ = FALSE;
	DejaDupFileTreeNode* _tmp32_;
	DejaDupFileTreeNode* _tmp33_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	DejaDupFileTreeNode* _tmp37_;
	DejaDupFileTreeNode** _tmp38_;
	gint _tmp38__length1;
	DejaDupFileTreeNode* _tmp39_;
	GHashTable* _tmp40_;
	GHashTable* _tmp41_;
	DejaDupFileTreeNode* _tmp42_;
	GHashTable* _tmp43_;
	GHashTable* _tmp44_;
	GList* _tmp45_;
	DejaDupFileTreeNode** _tmp48_;
	gint _tmp48__length1;
	DejaDupFileTreeNode* _tmp49_;
	DejaDupFileTreeNode** _tmp50_;
	gint _tmp50__length1;
	DejaDupFileTreeNode* _tmp51_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_new0 (DejaDupFileTreeNode*, 0 + 1);
	_data4_->homes = _tmp0_;
	_data4_->homes_length1 = 0;
	_data4_->_homes_size_ = _data4_->homes_length1;
	_tmp1_ = self->priv->_root;
	_tmp2_ = deja_dup_file_tree_node_get_children (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "root");
	_tmp5_ = _g_object_ref0 ((DejaDupFileTreeNode*) _tmp4_);
	slash_root = _tmp5_;
	_tmp6_ = slash_root;
	if (_tmp6_ != NULL) {
		DejaDupFileTreeNode* _tmp7_;
		DejaDupFileTreeNode* _tmp8_;
		_tmp7_ = slash_root;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_vala_array_add10 (&_data4_->homes, &_data4_->homes_length1, &_data4_->_homes_size_, _tmp8_);
	}
	_tmp9_ = self->priv->_root;
	_tmp10_ = deja_dup_file_tree_node_get_children (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_hash_table_lookup (_tmp11_, "home");
	_tmp13_ = _g_object_ref0 ((DejaDupFileTreeNode*) _tmp12_);
	slash_home = _tmp13_;
	_tmp14_ = slash_home;
	if (_tmp14_ != NULL) {
		DejaDupFileTreeNode* _tmp15_;
		GHashTable* _tmp16_;
		GHashTable* _tmp17_;
		GList* _tmp18_;
		GList* _tmp19_;
		_tmp15_ = slash_home;
		_tmp16_ = deja_dup_file_tree_node_get_children (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_hash_table_get_values (_tmp17_);
		_tmp19_ = _tmp18_;
		g_list_foreach (_tmp19_, ____lambda14__gfunc, _data4_);
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (g_list_free (_tmp19_), NULL));
	}
	_tmp20_ = _data4_->homes;
	_tmp20__length1 = _data4_->homes_length1;
	if (_tmp20__length1 != 1) {
		_g_object_unref0 (slash_home);
		_g_object_unref0 (slash_root);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp21_ = _data4_->homes;
	_tmp21__length1 = _data4_->homes_length1;
	_tmp22_ = _tmp21_[0];
	_tmp23_ = deja_dup_file_tree_node_to_file (self, _tmp22_);
	single_home_file = _tmp23_;
	_tmp24_ = g_get_home_dir ();
	_tmp25_ = g_file_new_for_path (_tmp24_);
	my_home_file = _tmp25_;
	_tmp26_ = single_home_file;
	_tmp27_ = my_home_file;
	if (g_file_equal (_tmp26_, _tmp27_)) {
		_g_object_unref0 (my_home_file);
		_g_object_unref0 (single_home_file);
		_g_object_unref0 (slash_home);
		_g_object_unref0 (slash_root);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp28_ = my_home_file;
	_tmp29_ = g_file_get_path (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp32_ = deja_dup_file_tree_add (self, _tmp30_, G_FILE_TYPE_DIRECTORY, &_tmp31_);
	created = _tmp31_;
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp30_);
	my_home_node = _tmp33_;
	if (!created) {
		_g_object_unref0 (my_home_node);
		_g_object_unref0 (my_home_file);
		_g_object_unref0 (single_home_file);
		_g_object_unref0 (slash_home);
		_g_object_unref0 (slash_root);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp34_ = single_home_file;
	_tmp35_ = g_file_get_path (_tmp34_);
	_tmp36_ = _tmp35_;
	deja_dup_file_tree_set_old_home (self, _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = my_home_node;
	_tmp38_ = _data4_->homes;
	_tmp38__length1 = _data4_->homes_length1;
	_tmp39_ = _tmp38_[0];
	_tmp40_ = deja_dup_file_tree_node_get_children (_tmp39_);
	_tmp41_ = _tmp40_;
	deja_dup_file_tree_node_set_children (_tmp37_, _tmp41_);
	_tmp42_ = my_home_node;
	_tmp43_ = deja_dup_file_tree_node_get_children (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_hash_table_get_values (_tmp44_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp45_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			DejaDupFileTreeNode* child = NULL;
			child = (DejaDupFileTreeNode*) child_it->data;
			{
				DejaDupFileTreeNode* _tmp46_;
				DejaDupFileTreeNode* _tmp47_;
				_tmp46_ = child;
				_tmp47_ = my_home_node;
				deja_dup_file_tree_node_set_parent (_tmp46_, _tmp47_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp48_ = _data4_->homes;
	_tmp48__length1 = _data4_->homes_length1;
	_tmp49_ = _tmp48_[0];
	deja_dup_file_tree_node_set_children (_tmp49_, NULL);
	_tmp50_ = _data4_->homes;
	_tmp50__length1 = _data4_->homes_length1;
	_tmp51_ = _tmp50_[0];
	deja_dup_file_tree_erase_node_and_parents (self, _tmp51_);
	_g_object_unref0 (my_home_node);
	_g_object_unref0 (my_home_file);
	_g_object_unref0 (single_home_file);
	_g_object_unref0 (slash_home);
	_g_object_unref0 (slash_root);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

DejaDupFileTree*
deja_dup_file_tree_construct (GType object_type)
{
	DejaDupFileTree * self = NULL;
	self = (DejaDupFileTree*) g_object_new (object_type, NULL);
	return self;
}

DejaDupFileTree*
deja_dup_file_tree_new (void)
{
	return deja_dup_file_tree_construct (DEJA_DUP_TYPE_FILE_TREE);
}

DejaDupFileTreeNode*
deja_dup_file_tree_get_root (DejaDupFileTree* self)
{
	DejaDupFileTreeNode* result;
	DejaDupFileTreeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root;
	result = _tmp0_;
	return result;
}

static void
deja_dup_file_tree_set_root (DejaDupFileTree* self,
                             DejaDupFileTreeNode* value)
{
	DejaDupFileTreeNode* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_get_root (self);
	if (old_value != value) {
		DejaDupFileTreeNode* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_root);
		self->priv->_root = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_ROOT_PROPERTY]);
	}
}

const gchar*
deja_dup_file_tree_get_skipped_root (DejaDupFileTree* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_skipped_root;
	result = _tmp0_;
	return result;
}

static void
deja_dup_file_tree_set_skipped_root (DejaDupFileTree* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_get_skipped_root (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_skipped_root);
		self->priv->_skipped_root = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_SKIPPED_ROOT_PROPERTY]);
	}
}

const gchar*
deja_dup_file_tree_get_old_home (DejaDupFileTree* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_old_home;
	result = _tmp0_;
	return result;
}

static void
deja_dup_file_tree_set_old_home (DejaDupFileTree* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_get_old_home (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_old_home);
		self->priv->_old_home = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_OLD_HOME_PROPERTY]);
	}
}

static inline gpointer
deja_dup_file_tree_node_get_instance_private (DejaDupFileTreeNode* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupFileTreeNode_private_offset);
}

DejaDupFileTreeNode*
deja_dup_file_tree_node_construct (GType object_type,
                                   DejaDupFileTreeNode* parent,
                                   const gchar* filename,
                                   GFileType kind)
{
	DejaDupFileTreeNode * self = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (DejaDupFileTreeNode*) g_object_new (object_type, "parent", parent, "filename", filename, "kind", kind, NULL);
	return self;
}

DejaDupFileTreeNode*
deja_dup_file_tree_node_new (DejaDupFileTreeNode* parent,
                             const gchar* filename,
                             GFileType kind)
{
	return deja_dup_file_tree_node_construct (DEJA_DUP_FILE_TREE_TYPE_NODE, parent, filename, kind);
}

DejaDupFileTreeNode*
deja_dup_file_tree_node_get_parent (DejaDupFileTreeNode* self)
{
	DejaDupFileTreeNode* result;
	DejaDupFileTreeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

void
deja_dup_file_tree_node_set_parent (DejaDupFileTreeNode* self,
                                    DejaDupFileTreeNode* value)
{
	DejaDupFileTreeNode* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_node_get_parent (self);
	if (old_value != value) {
		self->priv->_parent = value;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_PARENT_PROPERTY]);
	}
}

const gchar*
deja_dup_file_tree_node_get_filename (DejaDupFileTreeNode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

void
deja_dup_file_tree_node_set_filename (DejaDupFileTreeNode* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_node_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_FILENAME_PROPERTY]);
	}
}

GFileType
deja_dup_file_tree_node_get_kind (DejaDupFileTreeNode* self)
{
	GFileType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_kind;
	return result;
}

static void
deja_dup_file_tree_node_set_kind (DejaDupFileTreeNode* self,
                                  GFileType value)
{
	GFileType old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_node_get_kind (self);
	if (old_value != value) {
		self->priv->_kind = value;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_KIND_PROPERTY]);
	}
}

GHashTable*
deja_dup_file_tree_node_get_children (DejaDupFileTreeNode* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_children;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
deja_dup_file_tree_node_set_children (DejaDupFileTreeNode* self,
                                      GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_file_tree_node_get_children (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_children);
		self->priv->_children = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_CHILDREN_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
deja_dup_file_tree_node_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupFileTreeNode * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	parent_class = G_OBJECT_CLASS (deja_dup_file_tree_node_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_FILE_TREE_TYPE_NODE, DejaDupFileTreeNode);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_tmp3_ = _tmp2_;
	deja_dup_file_tree_node_set_children (self, _tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	return obj;
}

static void
deja_dup_file_tree_node_class_init (DejaDupFileTreeNodeClass * klass,
                                    gpointer klass_data)
{
	deja_dup_file_tree_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupFileTreeNode_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_file_tree_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_file_tree_node_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_file_tree_node_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_file_tree_node_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_NODE_PARENT_PROPERTY, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", DEJA_DUP_FILE_TREE_TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_NODE_FILENAME_PROPERTY, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_NODE_KIND_PROPERTY, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_KIND_PROPERTY] = g_param_spec_enum ("kind", "kind", "kind", g_file_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_NODE_CHILDREN_PROPERTY, deja_dup_file_tree_node_properties[DEJA_DUP_FILE_TREE_NODE_CHILDREN_PROPERTY] = g_param_spec_boxed ("children", "children", "children", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
deja_dup_file_tree_node_instance_init (DejaDupFileTreeNode * self,
                                       gpointer klass)
{
	self->priv = deja_dup_file_tree_node_get_instance_private (self);
}

static void
deja_dup_file_tree_node_finalize (GObject * obj)
{
	DejaDupFileTreeNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_FILE_TREE_TYPE_NODE, DejaDupFileTreeNode);
	_g_free0 (self->priv->_filename);
	_g_hash_table_unref0 (self->priv->_children);
	self->search_tokens = (_vala_array_free (self->search_tokens, self->search_tokens_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (deja_dup_file_tree_node_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_file_tree_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupFileTreeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_file_tree_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupFileTreeNode), 0, (GInstanceInitFunc) deja_dup_file_tree_node_instance_init, NULL };
	GType deja_dup_file_tree_node_type_id;
	deja_dup_file_tree_node_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupFileTreeNode", &g_define_type_info, 0);
	DejaDupFileTreeNode_private_offset = g_type_add_instance_private (deja_dup_file_tree_node_type_id, sizeof (DejaDupFileTreeNodePrivate));
	return deja_dup_file_tree_node_type_id;
}

GType
deja_dup_file_tree_node_get_type (void)
{
	static gsize deja_dup_file_tree_node_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_file_tree_node_type_id__once)) {
		GType deja_dup_file_tree_node_type_id;
		deja_dup_file_tree_node_type_id = deja_dup_file_tree_node_get_type_once ();
		g_once_init_leave (&deja_dup_file_tree_node_type_id__once, deja_dup_file_tree_node_type_id);
	}
	return deja_dup_file_tree_node_type_id__once;
}

static void
_vala_deja_dup_file_tree_node_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	DejaDupFileTreeNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_FILE_TREE_TYPE_NODE, DejaDupFileTreeNode);
	switch (property_id) {
		case DEJA_DUP_FILE_TREE_NODE_PARENT_PROPERTY:
		g_value_set_object (value, deja_dup_file_tree_node_get_parent (self));
		break;
		case DEJA_DUP_FILE_TREE_NODE_FILENAME_PROPERTY:
		g_value_set_string (value, deja_dup_file_tree_node_get_filename (self));
		break;
		case DEJA_DUP_FILE_TREE_NODE_KIND_PROPERTY:
		g_value_set_enum (value, deja_dup_file_tree_node_get_kind (self));
		break;
		case DEJA_DUP_FILE_TREE_NODE_CHILDREN_PROPERTY:
		g_value_set_boxed (value, deja_dup_file_tree_node_get_children (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_file_tree_node_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	DejaDupFileTreeNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_FILE_TREE_TYPE_NODE, DejaDupFileTreeNode);
	switch (property_id) {
		case DEJA_DUP_FILE_TREE_NODE_PARENT_PROPERTY:
		deja_dup_file_tree_node_set_parent (self, g_value_get_object (value));
		break;
		case DEJA_DUP_FILE_TREE_NODE_FILENAME_PROPERTY:
		deja_dup_file_tree_node_set_filename (self, g_value_get_string (value));
		break;
		case DEJA_DUP_FILE_TREE_NODE_KIND_PROPERTY:
		deja_dup_file_tree_node_set_kind (self, g_value_get_enum (value));
		break;
		case DEJA_DUP_FILE_TREE_NODE_CHILDREN_PROPERTY:
		deja_dup_file_tree_node_set_children (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
deja_dup_file_tree_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupFileTree * self;
	DejaDupFileTreeNode* _tmp0_;
	DejaDupFileTreeNode* _tmp1_;
	parent_class = G_OBJECT_CLASS (deja_dup_file_tree_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_FILE_TREE, DejaDupFileTree);
	_tmp0_ = deja_dup_file_tree_node_new (NULL, "", G_FILE_TYPE_DIRECTORY);
	_tmp1_ = _tmp0_;
	deja_dup_file_tree_set_root (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
deja_dup_file_tree_class_init (DejaDupFileTreeClass * klass,
                               gpointer klass_data)
{
	deja_dup_file_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupFileTree_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_file_tree_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_file_tree_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_file_tree_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_file_tree_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_ROOT_PROPERTY, deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", DEJA_DUP_FILE_TREE_TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_SKIPPED_ROOT_PROPERTY, deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_SKIPPED_ROOT_PROPERTY] = g_param_spec_string ("skipped-root", "skipped-root", "skipped-root", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_FILE_TREE_OLD_HOME_PROPERTY, deja_dup_file_tree_properties[DEJA_DUP_FILE_TREE_OLD_HOME_PROPERTY] = g_param_spec_string ("old-home", "old-home", "old-home", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
deja_dup_file_tree_instance_init (DejaDupFileTree * self,
                                  gpointer klass)
{
	self->priv = deja_dup_file_tree_get_instance_private (self);
	self->priv->_root = NULL;
	self->priv->_skipped_root = NULL;
	self->priv->_old_home = NULL;
	self->priv->readmes = NULL;
}

static void
deja_dup_file_tree_finalize (GObject * obj)
{
	DejaDupFileTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_FILE_TREE, DejaDupFileTree);
	_g_object_unref0 (self->priv->_root);
	_g_free0 (self->priv->_skipped_root);
	_g_free0 (self->priv->_old_home);
	(self->priv->readmes == NULL) ? NULL : (self->priv->readmes = (_g_list_free__g_object_unref0_ (self->priv->readmes), NULL));
	G_OBJECT_CLASS (deja_dup_file_tree_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_file_tree_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupFileTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_file_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupFileTree), 0, (GInstanceInitFunc) deja_dup_file_tree_instance_init, NULL };
	GType deja_dup_file_tree_type_id;
	deja_dup_file_tree_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupFileTree", &g_define_type_info, 0);
	DejaDupFileTree_private_offset = g_type_add_instance_private (deja_dup_file_tree_type_id, sizeof (DejaDupFileTreePrivate));
	return deja_dup_file_tree_type_id;
}

GType
deja_dup_file_tree_get_type (void)
{
	static gsize deja_dup_file_tree_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_file_tree_type_id__once)) {
		GType deja_dup_file_tree_type_id;
		deja_dup_file_tree_type_id = deja_dup_file_tree_get_type_once ();
		g_once_init_leave (&deja_dup_file_tree_type_id__once, deja_dup_file_tree_type_id);
	}
	return deja_dup_file_tree_type_id__once;
}

static void
_vala_deja_dup_file_tree_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	DejaDupFileTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_FILE_TREE, DejaDupFileTree);
	switch (property_id) {
		case DEJA_DUP_FILE_TREE_ROOT_PROPERTY:
		g_value_set_object (value, deja_dup_file_tree_get_root (self));
		break;
		case DEJA_DUP_FILE_TREE_SKIPPED_ROOT_PROPERTY:
		g_value_set_string (value, deja_dup_file_tree_get_skipped_root (self));
		break;
		case DEJA_DUP_FILE_TREE_OLD_HOME_PROPERTY:
		g_value_set_string (value, deja_dup_file_tree_get_old_home (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_file_tree_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	DejaDupFileTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_FILE_TREE, DejaDupFileTree);
	switch (property_id) {
		case DEJA_DUP_FILE_TREE_ROOT_PROPERTY:
		deja_dup_file_tree_set_root (self, g_value_get_object (value));
		break;
		case DEJA_DUP_FILE_TREE_SKIPPED_ROOT_PROPERTY:
		deja_dup_file_tree_set_skipped_root (self, g_value_get_string (value));
		break;
		case DEJA_DUP_FILE_TREE_OLD_HOME_PROPERTY:
		deja_dup_file_tree_set_old_home (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

