// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-shell.xml

#ifndef QT_WAYLAND_SERVER_DDE_SHELL
#define QT_WAYLAND_SERVER_DDE_SHELL

#include "wayland-server-core.h"
#include "wayland-dde-shell-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  dde_shell
    {
    public:
        dde_shell(struct ::wl_client *client, int id, int version);
        dde_shell(struct ::wl_display *display, int version);
        dde_shell(struct ::wl_resource *resource);
        dde_shell();

        virtual ~dde_shell();

        class Resource
        {
        public:
            Resource() : dde_shell_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_shell *dde_shell_object;
            dde_shell *object() { return dde_shell_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum state {
            state_active = 1 << 0,
            state_minimized = 1 << 1,
            state_maximized = 1 << 2,
            state_fullscreen = 1 << 3,
            state_keep_above = 1 << 4,
            state_keep_below = 1 << 5,
            state_on_all_desktops = 1 << 6,
            state_demands_attention = 1 << 7,
            state_closeable = 1 << 8,
            state_minimizable = 1 << 9,
            state_maximizable = 1 << 10,
            state_fullscreenable = 1 << 11,
            state_skiptaskbar = 1 << 12,
            state_shadeable = 1 << 13,
            state_shaded = 1 << 14,
            state_movable = 1 << 15,
            state_resizable = 1 << 16,
            state_virtual_desktop_changeable = 1 << 17,
            state_skipswitcher = 1 << 18,
            state_accept_focus = 1 << 19,
            state_modality = 1 << 20,
        };

        enum property {
            property_NoTitleBar = 1 << 0,
            property_Theme = 1 << 1,
            property_WindowRadius = 1 << 2,
            property_BorderWidth = 1 << 3,
            property_BorderColor = 1 << 4,
            property_ShadowRadius = 1 << 5,
            property_ShadowOffset = 1 << 6,
            property_ShadowColor = 1 << 7,
            property_MouseInputAreaMargins = 1 << 8,
            property_WindowPixelRatio = 1 << 9,
        };

        enum split_type {
            split_type_left_split = 1 << 0,
            split_type_right_split = 1 << 1,
        };

        enum effectscene {
            effectscene_effectNoRadius = 1 << 0,
            effectscene_effectNoShadow = 1 << 1,
            effectscene_effectNoBorder = 1 << 2,
            effectscene_effectNoStart = 1 << 4,
            effectscene_effectNoClose = 1 << 5,
            effectscene_effectNoMaximize = 1 << 6,
            effectscene_effectNoMinimize = 1 << 7,
        };

        enum effecttype {
            effecttype_effectNormal = 1 << 0,
            effecttype_effectCursor = 1 << 1,
            effecttype_effectTop = 1 << 2,
            effecttype_effectBottom = 1 << 3,
        };

    protected:
        virtual Resource *dde_shell_allocate();

        virtual void dde_shell_destroy_global();

        virtual void dde_shell_bind_resource(Resource *resource);
        virtual void dde_shell_destroy_resource(Resource *resource);

        virtual void dde_shell_get_shell_surface(Resource *resource, uint32_t id, struct ::wl_resource *surface);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_shell_interface m_dde_shell_interface;

        static void handle_get_shell_surface(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_shell *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  dde_shell_surface
    {
    public:
        dde_shell_surface(struct ::wl_client *client, int id, int version);
        dde_shell_surface(struct ::wl_display *display, int version);
        dde_shell_surface(struct ::wl_resource *resource);
        dde_shell_surface();

        virtual ~dde_shell_surface();

        class Resource
        {
        public:
            Resource() : dde_shell_surface_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_shell_surface *dde_shell_surface_object;
            dde_shell_surface *object() { return dde_shell_surface_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_geometry(int32_t x, int32_t y, uint32_t w, uint32_t h);
        void send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, uint32_t w, uint32_t h);
        void send_state_changed(uint32_t flags);
        void send_state_changed(struct ::wl_resource *resource, uint32_t flags);
        void send_splitable(uint32_t flags);
        void send_splitable(struct ::wl_resource *resource, uint32_t flags);
        void send_workarea(struct ::wl_resource *output, uint32_t x, uint32_t y, uint32_t width, uint32_t height);
        void send_workarea(struct ::wl_resource *resource, struct ::wl_resource *output, uint32_t x, uint32_t y, uint32_t width, uint32_t height);

    protected:
        virtual Resource *dde_shell_surface_allocate();

        virtual void dde_shell_surface_destroy_global();

        virtual void dde_shell_surface_bind_resource(Resource *resource);
        virtual void dde_shell_surface_destroy_resource(Resource *resource);

        virtual void dde_shell_surface_get_geometry(Resource *resource);
        virtual void dde_shell_surface_request_active(Resource *resource);
        virtual void dde_shell_surface_set_state(Resource *resource, uint32_t flags, uint32_t state);
        virtual void dde_shell_surface_set_property(Resource *resource, uint32_t property, wl_array *dataArr);
        virtual void dde_shell_surface_request_split_window(Resource *resource, uint32_t split_type);
        virtual void dde_shell_surface_request_window_effect(Resource *resource, uint32_t effectscene);
        virtual void dde_shell_surface_request_window_startup_effect(Resource *resource, uint32_t effecttype);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_shell_surface_interface m_dde_shell_surface_interface;

        static void handle_get_geometry(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_request_active(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_state(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t flags,
            uint32_t state);
        static void handle_set_property(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t property,
            wl_array *dataArr);
        static void handle_request_split_window(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t split_type);
        static void handle_request_window_effect(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t effectscene);
        static void handle_request_window_startup_effect(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t effecttype);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_shell_surface *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
