/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// PKCS12KeystoreApplyConfiguration represents a declarative configuration of the PKCS12Keystore type for use
// with apply.
type PKCS12KeystoreApplyConfiguration struct {
	Create            *bool                                       `json:"create,omitempty"`
	Profile           *certmanagerv1.PKCS12Profile                `json:"profile,omitempty"`
	PasswordSecretRef *metav1.SecretKeySelectorApplyConfiguration `json:"passwordSecretRef,omitempty"`
	Password          *string                                     `json:"password,omitempty"`
}

// PKCS12KeystoreApplyConfiguration constructs a declarative configuration of the PKCS12Keystore type for use with
// apply.
func PKCS12Keystore() *PKCS12KeystoreApplyConfiguration {
	return &PKCS12KeystoreApplyConfiguration{}
}

// WithCreate sets the Create field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Create field is set to the value of the last call.
func (b *PKCS12KeystoreApplyConfiguration) WithCreate(value bool) *PKCS12KeystoreApplyConfiguration {
	b.Create = &value
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *PKCS12KeystoreApplyConfiguration) WithProfile(value certmanagerv1.PKCS12Profile) *PKCS12KeystoreApplyConfiguration {
	b.Profile = &value
	return b
}

// WithPasswordSecretRef sets the PasswordSecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PasswordSecretRef field is set to the value of the last call.
func (b *PKCS12KeystoreApplyConfiguration) WithPasswordSecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *PKCS12KeystoreApplyConfiguration {
	b.PasswordSecretRef = value
	return b
}

// WithPassword sets the Password field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Password field is set to the value of the last call.
func (b *PKCS12KeystoreApplyConfiguration) WithPassword(value string) *PKCS12KeystoreApplyConfiguration {
	b.Password = &value
	return b
}
