/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// OrderStatusApplyConfiguration represents a declarative configuration of the OrderStatus type for use
// with apply.
type OrderStatusApplyConfiguration struct {
	URL            *string                               `json:"url,omitempty"`
	FinalizeURL    *string                               `json:"finalizeURL,omitempty"`
	Authorizations []ACMEAuthorizationApplyConfiguration `json:"authorizations,omitempty"`
	Certificate    []byte                                `json:"certificate,omitempty"`
	State          *acmev1.State                         `json:"state,omitempty"`
	Reason         *string                               `json:"reason,omitempty"`
	FailureTime    *metav1.Time                          `json:"failureTime,omitempty"`
}

// OrderStatusApplyConfiguration constructs a declarative configuration of the OrderStatus type for use with
// apply.
func OrderStatus() *OrderStatusApplyConfiguration {
	return &OrderStatusApplyConfiguration{}
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *OrderStatusApplyConfiguration) WithURL(value string) *OrderStatusApplyConfiguration {
	b.URL = &value
	return b
}

// WithFinalizeURL sets the FinalizeURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FinalizeURL field is set to the value of the last call.
func (b *OrderStatusApplyConfiguration) WithFinalizeURL(value string) *OrderStatusApplyConfiguration {
	b.FinalizeURL = &value
	return b
}

// WithAuthorizations adds the given value to the Authorizations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Authorizations field.
func (b *OrderStatusApplyConfiguration) WithAuthorizations(values ...*ACMEAuthorizationApplyConfiguration) *OrderStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAuthorizations")
		}
		b.Authorizations = append(b.Authorizations, *values[i])
	}
	return b
}

// WithCertificate adds the given value to the Certificate field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Certificate field.
func (b *OrderStatusApplyConfiguration) WithCertificate(values ...byte) *OrderStatusApplyConfiguration {
	for i := range values {
		b.Certificate = append(b.Certificate, values[i])
	}
	return b
}

// WithState sets the State field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the State field is set to the value of the last call.
func (b *OrderStatusApplyConfiguration) WithState(value acmev1.State) *OrderStatusApplyConfiguration {
	b.State = &value
	return b
}

// WithReason sets the Reason field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reason field is set to the value of the last call.
func (b *OrderStatusApplyConfiguration) WithReason(value string) *OrderStatusApplyConfiguration {
	b.Reason = &value
	return b
}

// WithFailureTime sets the FailureTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FailureTime field is set to the value of the last call.
func (b *OrderStatusApplyConfiguration) WithFailureTime(value metav1.Time) *OrderStatusApplyConfiguration {
	b.FailureTime = &value
	return b
}
