﻿/*
Font set #1
-----------
Copyright (c) 2019 Dimitar Toshkov Zhekov,
with Reserved Font Name "Terminus Font".

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is copied below, and is also available with a FAQ at:
http://scripts.sil.org/OFL

Based on http://terminus-font.sourceforge.net/ v4.48
Sizes: 6x12, 8x14, 8x16, 10x18, 10x20, 11x22, 12x24, 14x28 and 16x32.
Weights: normal and bold (except for 6x12, where bold=normal)

Terminus Font 4.48, Copyright(C) 2019 Dimitar Toshkov Zhekov.
Report bugs to <dimitar.zhekov@gmail.com>

Font set #2
-----------
10x20 info_h font from old avisynth info.h + 4 extra characters by pinterf

Avisynth+ source code integration by pinterf

*/

#include "fixedfonts.h"
#include <cstring>
#include <cstdint>
#include <sstream>
#include <unordered_map>
#include <array>

// The font definitions in this file were autogenerated
// by special functions for reading BDF file and exporting it as cpp source

namespace fixed_font_12n {
  // -- start of autogenerated text ---
  // definition section for font: ter-u12n.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 6;
  constexpr int HEIGHT = 12;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u12n.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    false // bold
  };
  // font bitmap definitions
  constexpr std::array<uint16_t, CHARCOUNT * HEIGHT> fixedfont_bitmap = {
  0x0000,0x0000,0xd800,0x8800,0x0000,0x8800,0x8800,0x0000,0x8800,0xd800,0x0000,0x0000, // u0000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0020
  0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x2000,0x2000,0x0000,0x0000, // u0021
  0x0000,0x5000,0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0022
  0x0000,0x0000,0x5000,0x5000,0xf800,0x5000,0x5000,0xf800,0x5000,0x5000,0x0000,0x0000, // u0023
  0x0000,0x0000,0x2000,0x7000,0xa800,0xa000,0x7000,0x2800,0xa800,0x7000,0x2000,0x0000, // u0024
  0x0000,0x0000,0x4800,0xa800,0x5000,0x1000,0x2000,0x2800,0x5400,0x4800,0x0000,0x0000, // u0025
  0x0000,0x0000,0x2000,0x5000,0x5000,0x2000,0x6800,0x9000,0x9000,0x6800,0x0000,0x0000, // u0026
  0x0000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0027
  0x0000,0x0000,0x1000,0x2000,0x4000,0x4000,0x4000,0x4000,0x2000,0x1000,0x0000,0x0000, // u0028
  0x0000,0x0000,0x4000,0x2000,0x1000,0x1000,0x1000,0x1000,0x2000,0x4000,0x0000,0x0000, // u0029
  0x0000,0x0000,0x0000,0x0000,0x5000,0x2000,0xf800,0x2000,0x5000,0x0000,0x0000,0x0000, // u002a
  0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0xf800,0x2000,0x2000,0x0000,0x0000,0x0000, // u002b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x4000,0x0000, // u002c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u002d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000, // u002e
  0x0000,0x0000,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x4000,0x0000,0x0000, // u002f
  0x0000,0x0000,0x7000,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0030
  0x0000,0x0000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0031
  0x0000,0x0000,0x7000,0x8800,0x8800,0x0800,0x1000,0x2000,0x4000,0xf800,0x0000,0x0000, // u0032
  0x0000,0x0000,0x7000,0x8800,0x0800,0x3000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0033
  0x0000,0x0000,0x0800,0x1800,0x2800,0x4800,0x8800,0xf800,0x0800,0x0800,0x0000,0x0000, // u0034
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0035
  0x0000,0x0000,0x7000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0036
  0x0000,0x0000,0xf800,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0037
  0x0000,0x0000,0x7000,0x8800,0x8800,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0038
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x7000,0x0000,0x0000, // u0039
  0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000, // u003a
  0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x4000,0x0000, // u003b
  0x0000,0x0000,0x0000,0x0800,0x1000,0x2000,0x4000,0x2000,0x1000,0x0800,0x0000,0x0000, // u003c
  0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000, // u003d
  0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x0800,0x1000,0x2000,0x4000,0x0000,0x0000, // u003e
  0x0000,0x0000,0x7000,0x8800,0x8800,0x1000,0x2000,0x0000,0x2000,0x2000,0x0000,0x0000, // u003f
  0x0000,0x0000,0x7000,0x8800,0x9800,0xa800,0xa800,0x9800,0x8000,0x7800,0x0000,0x0000, // u0040
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0041
  0x0000,0x0000,0xf000,0x8800,0x8800,0xf000,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0042
  0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0043
  0x0000,0x0000,0xe000,0x9000,0x8800,0x8800,0x8800,0x8800,0x9000,0xe000,0x0000,0x0000, // u0044
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0045
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0046
  0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0047
  0x0000,0x0000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0048
  0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0049
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x9000,0x9000,0x6000,0x0000,0x0000, // u004a
  0x0000,0x0000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8800,0x0000,0x0000, // u004b
  0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u004c
  0x0000,0x0000,0x8800,0xd800,0xa800,0xa800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u004d
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0000,0x0000, // u004e
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u004f
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0050
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0xa800,0x7000,0x0800,0x0000, // u0051
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf000,0xa000,0x9000,0x8800,0x0000,0x0000, // u0052
  0x0000,0x0000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0053
  0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0054
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0055
  0x0000,0x0000,0x8800,0x8800,0x8800,0x5000,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u0056
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0xa800,0xa800,0xd800,0x8800,0x0000,0x0000, // u0057
  0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x8800,0x0000,0x0000, // u0058
  0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0059
  0x0000,0x0000,0xf800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xf800,0x0000,0x0000, // u005a
  0x0000,0x0000,0x7000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7000,0x0000,0x0000, // u005b
  0x0000,0x0000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0000,0x0000, // u005c
  0x0000,0x0000,0x7000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x7000,0x0000,0x0000, // u005d
  0x0000,0x2000,0x5000,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u005e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000, // u005f
  0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0060
  0x0000,0x0000,0x0000,0x0000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0061
  0x0000,0x0000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0062
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0063
  0x0000,0x0000,0x0800,0x0800,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0064
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0065
  0x0000,0x0000,0x1800,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0066
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0067
  0x0000,0x0000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0068
  0x0000,0x2000,0x2000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0069
  0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // u006a
  0x0000,0x0000,0x4000,0x4000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u006b
  0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u006c
  0x0000,0x0000,0x0000,0x0000,0xf000,0xa800,0xa800,0xa800,0xa800,0xa800,0x0000,0x0000, // u006d
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u006e
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u006f
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000, // u0070
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800, // u0071
  0x0000,0x0000,0x0000,0x0000,0xb800,0xc000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0072
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x0000,0x0000, // u0073
  0x0000,0x0000,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u0074
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0075
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u0076
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0xa800,0xa800,0xa800,0x7000,0x0000,0x0000, // u0077
  0x0000,0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x0000,0x0000, // u0078
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0079
  0x0000,0x0000,0x0000,0x0000,0xf800,0x1000,0x2000,0x4000,0x8000,0xf800,0x0000,0x0000, // u007a
  0x0000,0x0000,0x1800,0x2000,0x2000,0x4000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u007b
  0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u007c
  0x0000,0x0000,0x6000,0x1000,0x1000,0x0800,0x1000,0x1000,0x1000,0x6000,0x0000,0x0000, // u007d
  0x0000,0x4800,0xa800,0x9000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u007e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a0
  0x0000,0x0000,0x2000,0x2000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u00a1
  0x0000,0x0000,0x0000,0x2000,0x7000,0xa800,0xa000,0xa000,0xa800,0x7000,0x2000,0x0000, // u00a2
  0x0000,0x0000,0x3000,0x4800,0x4000,0xf000,0x4000,0x4000,0x4800,0xf800,0x0000,0x0000, // u00a3
  0x0000,0x0000,0x0000,0x4800,0x3000,0x4800,0x4800,0x3000,0x4800,0x0000,0x0000,0x0000, // u00a4
  0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x7000,0x2000,0x7000,0x2000,0x0000,0x0000, // u00a5
  0x0000,0x0000,0x2000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x2000,0x0000,0x0000, // u00a6
  0x0000,0x3000,0x4800,0x2000,0x5000,0x4800,0x2800,0x1000,0x4800,0x3000,0x0000,0x0000, // u00a7
  0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a8
  0x0000,0x0000,0x7800,0x8400,0xb400,0xa400,0xa400,0xb400,0x8400,0x7800,0x0000,0x0000, // u00a9
  0x3000,0x0800,0x3800,0x4800,0x3800,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000, // u00aa
  0x0000,0x0000,0x0000,0x1400,0x2800,0x5000,0xa000,0x5000,0x2800,0x1400,0x0000,0x0000, // u00ab
  0x0000,0x0000,0x0000,0x0000,0xf800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u00ac
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ad
  0x0000,0x0000,0x7800,0x8400,0xb400,0xac00,0xb400,0xac00,0x8400,0x7800,0x0000,0x0000, // u00ae
  0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00af
  0x0000,0x2000,0x5000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b0
  0x0000,0x0000,0x0000,0x2000,0x2000,0xf800,0x2000,0x2000,0x0000,0xf800,0x0000,0x0000, // u00b1
  0x0000,0x3000,0x4800,0x1000,0x2000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b2
  0x0000,0x7000,0x0800,0x3000,0x0800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b3
  0x1000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b4
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x9800,0xe800,0x8000,0x8000, // u00b5
  0x0000,0x0000,0x7800,0xa800,0xa800,0xa800,0x6800,0x2800,0x2800,0x2800,0x0000,0x0000, // u00b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x4000, // u00b8
  0x0000,0x1000,0x3000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b9
  0x3000,0x4800,0x4800,0x4800,0x3000,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ba
  0x0000,0x0000,0x0000,0xa000,0x5000,0x2800,0x1400,0x2800,0x5000,0xa000,0x0000,0x0000, // u00bb
  0x4000,0xc000,0x4400,0x4800,0x5000,0x2000,0x4800,0x9800,0x2800,0x7800,0x0800,0x0800, // u00bc
  0x4000,0xc000,0x4400,0x4800,0x5000,0x2000,0x4000,0x9800,0x2400,0x0800,0x1000,0x3c00, // u00bd
  0xe000,0x1000,0x6000,0x1400,0xe800,0x1000,0x2400,0x4c00,0x9400,0x3c00,0x0400,0x0400, // u00be
  0x0000,0x0000,0x2000,0x2000,0x0000,0x2000,0x4000,0x8800,0x8800,0x7000,0x0000,0x0000, // u00bf
  0x4000,0x2000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00c0
  0x1000,0x2000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00c1
  0x2000,0x5000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00c2
  0x2800,0x5000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00c3
  0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00c4
  0x2000,0x5000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00c5
  0x0000,0x0000,0x7c00,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9c00,0x0000,0x0000, // u00c6
  0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x2000,0x4000, // u00c7
  0x4000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u00c8
  0x1000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u00c9
  0x2000,0x5000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u00ca
  0x5000,0x5000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u00cb
  0x4000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00cc
  0x1000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00cd
  0x2000,0x5000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00ce
  0x5000,0x5000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00cf
  0x0000,0x0000,0xe000,0x9000,0x8800,0xe800,0x8800,0x8800,0x9000,0xe000,0x0000,0x0000, // u00d0
  0x2800,0x5000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00d1
  0x4000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d2
  0x1000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d3
  0x2000,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d4
  0x2800,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d5
  0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d6
  0x0000,0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x5000,0x8800,0x0000,0x0000,0x0000, // u00d7
  0x0000,0x0000,0x7400,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d8
  0x4000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00d9
  0x1000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00da
  0x2000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00db
  0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00dc
  0x1000,0x2000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u00dd
  0x0000,0x0000,0x8000,0xf000,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000,0x0000,0x0000, // u00de
  0x0000,0x0000,0xe000,0x9000,0x9000,0xf000,0x8800,0x8800,0xc800,0xb000,0x0000,0x0000, // u00df
  0x0000,0x0000,0x4000,0x2000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00e0
  0x0000,0x0000,0x1000,0x2000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00e1
  0x0000,0x0000,0x2000,0x5000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00e2
  0x0000,0x0000,0x2800,0x5000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00e3
  0x0000,0x0000,0x5000,0x5000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00e4
  0x0000,0x0000,0x2000,0x5000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00e5
  0x0000,0x0000,0x0000,0x0000,0x7000,0x2800,0x6800,0xb000,0xa000,0x7800,0x0000,0x0000, // u00e6
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x2000,0x4000, // u00e7
  0x0000,0x0000,0x4000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u00e8
  0x0000,0x0000,0x1000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u00e9
  0x0000,0x0000,0x2000,0x5000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u00ea
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u00eb
  0x0000,0x0000,0x4000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00ec
  0x0000,0x0000,0x1000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00ed
  0x0000,0x0000,0x2000,0x5000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00ee
  0x0000,0x0000,0x5000,0x5000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u00ef
  0x0000,0xa000,0x4000,0xa000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00f0
  0x0000,0x0000,0x2800,0x5000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u00f1
  0x0000,0x0000,0x4000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00f2
  0x0000,0x0000,0x1000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00f3
  0x0000,0x0000,0x2000,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00f4
  0x0000,0x0000,0x2800,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00f5
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u00f6
  0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0xf800,0x0000,0x2000,0x2000,0x0000,0x0000, // u00f7
  0x0000,0x0000,0x0000,0x0000,0x7400,0x9800,0xa800,0xc800,0x8800,0x7000,0x0000,0x0000, // u00f8
  0x0000,0x0000,0x4000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00f9
  0x0000,0x0000,0x1000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00fa
  0x0000,0x0000,0x2000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00fb
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u00fc
  0x0000,0x0000,0x1000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u00fd
  0x0000,0x0000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000, // u00fe
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u00ff
  0x7000,0x0000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0100
  0x0000,0x0000,0x7000,0x0000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0101
  0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0102
  0x0000,0x0000,0x5000,0x2000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0103
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x1000,0x0c00, // u0104
  0x0000,0x0000,0x0000,0x0000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x1000,0x0c00, // u0105
  0x1000,0x2000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0106
  0x0000,0x0000,0x1000,0x2000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0107
  0x2000,0x5000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0108
  0x0000,0x0000,0x2000,0x5000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0109
  0x2000,0x2000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u010a
  0x0000,0x0000,0x2000,0x2000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u010b
  0x5000,0x2000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u010c
  0x0000,0x0000,0x5000,0x2000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u010d
  0xa000,0x4000,0xe000,0x9000,0x8800,0x8800,0x8800,0x8800,0x9000,0xe000,0x0000,0x0000, // u010e
  0x5000,0x2000,0x0800,0x0800,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u010f
  0x0000,0x0000,0xe000,0x9000,0x8800,0xe800,0x8800,0x8800,0x9000,0xe000,0x0000,0x0000, // u0110
  0x0000,0x0000,0x0800,0x3c00,0x0800,0x7800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0111
  0x7000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0112
  0x0000,0x0000,0x7000,0x0000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0113
  0x5000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0114
  0x0000,0x0000,0x5000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0115
  0x2000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0116
  0x0000,0x0000,0x2000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0117
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x1000,0x0c00, // u0118
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x2000,0x1800, // u0119
  0x5000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u011a
  0x0000,0x0000,0x5000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u011b
  0x2000,0x5000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x0000,0x0000, // u011c
  0x0000,0x0000,0x2000,0x5000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u011d
  0x5000,0x2000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x0000,0x0000, // u011e
  0x0000,0x0000,0x5000,0x2000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u011f
  0x2000,0x2000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0120
  0x0000,0x0000,0x2000,0x2000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0121
  0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x2000,0x4000, // u0122
  0x0000,0x0000,0x1000,0x2000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0123
  0x2000,0x5000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0124
  0x2000,0x5000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0125
  0x0000,0x0000,0x4800,0xfc00,0x4800,0x7800,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000, // u0126
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000, // u0127
  0x2800,0x5000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0128
  0x0000,0x0000,0x2800,0x5000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0129
  0x7000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u012a
  0x0000,0x0000,0x7000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u012b
  0x5000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u012c
  0x0000,0x0000,0x5000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u012d
  0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x1800, // u012e
  0x0000,0x2000,0x2000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x1800, // u012f
  0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0130
  0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0131
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0xa800,0xa800,0x9000,0x0000,0x0000, // u0132
  0x0000,0x8800,0x8800,0x0000,0x9800,0x8800,0x8800,0x8800,0x8800,0x8800,0x2800,0x1000, // u0133
  0x1000,0x2800,0x3800,0x1000,0x1000,0x1000,0x1000,0x9000,0x9000,0x6000,0x0000,0x0000, // u0134
  0x0000,0x0000,0x0800,0x1400,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // u0135
  0x0000,0x0000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0xa800,0x2000,0x4000, // u0136
  0x0000,0x0000,0x4000,0x4000,0x4800,0x5000,0x6000,0x6000,0x5000,0x6800,0x2000,0x4000, // u0137
  0x0000,0x0000,0x0000,0x0000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u0138
  0x2000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0139
  0x1000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u013a
  0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x2000,0x4000, // u013b
  0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x4000, // u013c
  0x5000,0x2000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u013d
  0x5000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u013e
  0x0000,0x0000,0x8000,0x8000,0x8000,0x9000,0x9000,0x8000,0x8000,0xf800,0x0000,0x0000, // u013f
  0x0000,0x0000,0x6000,0x2000,0x2000,0x2400,0x2400,0x2000,0x2000,0x7000,0x0000,0x0000, // u0140
  0x0000,0x0000,0x4000,0x4000,0x4000,0x6000,0xc000,0x4000,0x4000,0x7c00,0x0000,0x0000, // u0141
  0x0000,0x0000,0x6000,0x2000,0x2000,0x3000,0x6000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0142
  0x1000,0x2000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0143
  0x0000,0x0000,0x1000,0x2000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0144
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0xa800,0x2000,0x4000, // u0145
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0xa800,0x2000,0x4000, // u0146
  0x5000,0x2000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0147
  0x0000,0x0000,0x5000,0x2000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0148
  0x0000,0x4000,0x4000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0149
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0800,0x1000, // u014a
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0800,0x1000, // u014b
  0x7000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u014c
  0x0000,0x0000,0x7000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u014d
  0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u014e
  0x0000,0x0000,0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u014f
  0x2800,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0150
  0x0000,0x0000,0x2800,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0151
  0x0000,0x0000,0x7c00,0x9000,0x9000,0x9c00,0x9000,0x9000,0x9000,0x7c00,0x0000,0x0000, // u0152
  0x0000,0x0000,0x0000,0x0000,0x7000,0xa800,0xa800,0xb000,0xa000,0x7800,0x0000,0x0000, // u0153
  0x1000,0x2000,0xf000,0x8800,0x8800,0x8800,0xf000,0xa000,0x9000,0x8800,0x0000,0x0000, // u0154
  0x0000,0x0000,0x1000,0x2000,0xb800,0xc000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0155
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf000,0xa000,0x9000,0xa800,0x2000,0x4000, // u0156
  0x0000,0x0000,0x0000,0x0000,0xb800,0xc000,0x8000,0x8000,0x8000,0xc000,0x4000,0x8000, // u0157
  0x5000,0x2000,0xf000,0x8800,0x8800,0x8800,0xf000,0xa000,0x9000,0x8800,0x0000,0x0000, // u0158
  0x0000,0x0000,0x5000,0x2000,0xb800,0xc000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0159
  0x1000,0x2000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u015a
  0x0000,0x0000,0x1000,0x2000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x0000,0x0000, // u015b
  0x2000,0x5000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u015c
  0x0000,0x0000,0x2000,0x5000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x0000,0x0000, // u015d
  0x0000,0x0000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x2000,0x4000, // u015e
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x2000,0x4000, // u015f
  0x5000,0x2000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0160
  0x0000,0x0000,0x5000,0x2000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x0000,0x0000, // u0161
  0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3000,0x1000,0x2000, // u0162
  0x0000,0x0000,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x1800,0x1000,0x2000, // u0163
  0x5000,0x2000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0164
  0x5000,0x2000,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u0165
  0x0000,0x0000,0xf800,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0166
  0x0000,0x0000,0x2000,0x2000,0x7000,0x2000,0x7000,0x2000,0x2000,0x1800,0x0000,0x0000, // u0167
  0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0168
  0x0000,0x0000,0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0169
  0x7000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u016a
  0x0000,0x0000,0x7000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u016b
  0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u016c
  0x0000,0x0000,0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u016d
  0x2000,0x5000,0xa800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u016e
  0x0000,0x0000,0x2000,0x5000,0xa800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u016f
  0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0170
  0x0000,0x0000,0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0171
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x1800, // u0172
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x1000,0x0c00, // u0173
  0x2000,0x5000,0x8800,0x8800,0x8800,0x8800,0xa800,0xa800,0xd800,0x8800,0x0000,0x0000, // u0174
  0x0000,0x0000,0x2000,0x5000,0x8800,0x8800,0xa800,0xa800,0xa800,0x7000,0x0000,0x0000, // u0175
  0x2000,0x5000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0176
  0x0000,0x0000,0x2000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0177
  0x5000,0x5000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0178
  0x1000,0x2000,0xf800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0179
  0x0000,0x0000,0x1000,0x2000,0xf800,0x1000,0x2000,0x4000,0x8000,0xf800,0x0000,0x0000, // u017a
  0x2000,0x2000,0xf800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xf800,0x0000,0x0000, // u017b
  0x0000,0x0000,0x2000,0x2000,0xf800,0x1000,0x2000,0x4000,0x8000,0xf800,0x0000,0x0000, // u017c
  0x5000,0x2000,0xf800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xf800,0x0000,0x0000, // u017d
  0x0000,0x0000,0x5000,0x2000,0xf800,0x1000,0x2000,0x4000,0x8000,0xf800,0x0000,0x0000, // u017e
  0x0000,0x0000,0x1800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u017f
  0x0000,0x0000,0x7000,0x8800,0x0800,0x0800,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0186
  0x0000,0x0000,0xf800,0x0800,0x0800,0x7800,0x0800,0x0800,0x0800,0xf800,0x0000,0x0000, // u018e
  0x0000,0x0000,0x7000,0x8800,0x0800,0x0800,0xf800,0x8800,0x8800,0x7000,0x0000,0x0000, // u018f
  0x0000,0x0000,0x7000,0x8800,0x8000,0x6000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0190
  0x0000,0x0000,0x1000,0x2800,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0xa000,0x4000, // u0192
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0xc800,0x4000,0x8000, // u019d
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0800,0x0800, // u019e
  0x0000,0x0000,0xf800,0x0800,0x1000,0xf800,0x2000,0x4000,0x8000,0xf800,0x0000,0x0000, // u01b5
  0x0000,0x0000,0x0000,0x0000,0xf800,0x1000,0x7800,0x2000,0x4000,0xf800,0x0000,0x0000, // u01b6
  0x0000,0x0000,0xf800,0x0800,0x1000,0x3000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u01b7
  0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u01cd
  0x0000,0x0000,0x5000,0x2000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u01ce
  0x5000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u01cf
  0x0000,0x0000,0x5000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u01d0
  0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u01d1
  0x0000,0x0000,0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u01d2
  0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u01d3
  0x0000,0x0000,0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u01d4
  0x7800,0x0000,0x7c00,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9c00,0x0000,0x0000, // u01e2
  0x0000,0x0000,0x7000,0x0000,0x7000,0x2800,0x6800,0xb000,0xa000,0x7800,0x0000,0x0000, // u01e3
  0x0000,0x0000,0x7800,0x8000,0x8000,0xb800,0x8800,0x9c00,0x8800,0x7000,0x0000,0x0000, // u01e4
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8800,0x9c00,0x8800,0x8800,0x7800,0x0800,0x7000, // u01e5
  0x5000,0x2000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x0000,0x0000, // u01e6
  0x0000,0x0000,0x5000,0x2000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u01e7
  0x5000,0x2000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8800,0x0000,0x0000, // u01e8
  0x5000,0x2000,0x4000,0x4000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u01e9
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x1800, // u01ea
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x1800, // u01eb
  0x7000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x1800, // u01ec
  0x0000,0x0000,0x7000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x1800, // u01ed
  0x5000,0x2000,0xf800,0x0800,0x1000,0x3000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u01ee
  0x0000,0x0000,0x5000,0x2000,0xf800,0x0800,0x1000,0x3000,0x0800,0x0800,0x8800,0x7000, // u01ef
  0x0000,0x0000,0x1400,0x0800,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // u01f0
  0x1000,0x2000,0x7000,0x8800,0x8000,0x8000,0xb800,0x8800,0x8800,0x7000,0x0000,0x0000, // u01f4
  0x0000,0x0000,0x1000,0x2000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u01f5
  0x0800,0x1000,0x7c00,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9c00,0x0000,0x0000, // u01fc
  0x0000,0x0000,0x1000,0x2000,0x7000,0x2800,0x6800,0xb000,0xa000,0x7800,0x0000,0x0000, // u01fd
  0x1000,0x2000,0x7400,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x7000,0x0000,0x0000, // u01fe
  0x0000,0x0000,0x1000,0x2000,0x7400,0x9800,0xa800,0xc800,0x8800,0x7000,0x0000,0x0000, // u01ff
  0x0000,0x0000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x2000,0x4000, // u0218
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x2000,0x4000, // u0219
  0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3000,0x1000,0x2000, // u021a
  0x0000,0x0000,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0800,0x1000, // u021b
  0x7000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0232
  0x0000,0x0000,0x7000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0233
  0x0000,0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // u0237
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0254
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xf800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0258
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x0800,0xf800,0x8800,0x7000,0x0000,0x0000, // u0259
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x6000,0x8000,0x8800,0x7000,0x0000,0x0000, // u025b
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0xc800,0x4000,0x8000, // u0272
  0x0000,0x0000,0x0000,0x0000,0xf800,0x0800,0x1000,0x3000,0x0800,0x0800,0x8800,0x7000, // u0292
  0x1000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bb
  0x1000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bc
  0x2000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bd
  0x2000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c6
  0x5000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c7
  0x5000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d8
  0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x2000,0x1800, // u02db
  0x2800,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dc
  0x2800,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dd
  0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0300
  0x1000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0301
  0x2000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0302
  0x2800,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0303
  0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0304
  0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0305
  0x5000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0306
  0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0307
  0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0308
  0x2000,0x5000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030a
  0x2800,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030b
  0x5000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000, // u0329
  0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0384
  0x1000,0x2000,0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0385
  0x4000,0x8000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0386
  0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0387
  0x4000,0x8000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0388
  0x4000,0x8000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0389
  0x4000,0x8000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u038a
  0x4000,0x8000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u038c
  0x4000,0x8000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u038e
  0x4000,0x8000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x5000,0xd800,0x0000,0x0000, // u038f
  0x1000,0x2000,0x5000,0x5000,0x6000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u0390
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0391
  0x0000,0x0000,0xf000,0x8800,0x8800,0xf000,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0392
  0x0000,0x0000,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0393
  0x0000,0x0000,0x2000,0x2000,0x5000,0x5000,0x8800,0x8800,0x8800,0xf800,0x0000,0x0000, // u0394
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0395
  0x0000,0x0000,0xf800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0396
  0x0000,0x0000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0397
  0x0000,0x0000,0x7000,0x8800,0x8800,0xa800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u0398
  0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0399
  0x0000,0x0000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8800,0x0000,0x0000, // u039a
  0x0000,0x0000,0x2000,0x2000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u039b
  0x0000,0x0000,0x8800,0xd800,0xa800,0xa800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u039c
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0000,0x0000, // u039d
  0x0000,0x0000,0xf800,0x0000,0x0000,0x7000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000, // u039e
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u039f
  0x0000,0x0000,0xf800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u03a0
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000,0x8000,0x0000,0x0000, // u03a1
  0x0000,0x0000,0xf800,0x4000,0x2000,0x1000,0x1000,0x2000,0x4000,0xf800,0x0000,0x0000, // u03a3
  0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u03a4
  0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u03a5
  0x0000,0x0000,0x2000,0x7000,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x0000,0x0000, // u03a6
  0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x8800,0x0000,0x0000, // u03a7
  0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x2000,0x0000,0x0000, // u03a8
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x5000,0xd800,0x0000,0x0000, // u03a9
  0x5000,0x5000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u03aa
  0x5000,0x5000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u03ab
  0x0000,0x0000,0x1000,0x2000,0x6800,0x9000,0x9000,0x9000,0x9000,0x6800,0x0000,0x0000, // u03ac
  0x0000,0x0000,0x1000,0x2000,0x7000,0x8800,0x6000,0x8000,0x8800,0x7000,0x0000,0x0000, // u03ad
  0x0000,0x0000,0x1000,0x2000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0800,0x0800, // u03ae
  0x0000,0x0000,0x1000,0x2000,0x6000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u03af
  0x1000,0x2000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03b0
  0x0000,0x0000,0x0000,0x0000,0x6800,0x9000,0x9000,0x9000,0x9000,0x6800,0x0000,0x0000, // u03b1
  0x0000,0x0000,0xe000,0x9000,0x9000,0xf000,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000, // u03b2
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000, // u03b3
  0x0000,0x0000,0xf000,0x4000,0x2000,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03b4
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x6000,0x8000,0x8800,0x7000,0x0000,0x0000, // u03b5
  0x0000,0x0000,0xf800,0x1000,0x2000,0x4000,0x8000,0x8000,0x8000,0x7000,0x0800,0x1000, // u03b6
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0800,0x0800, // u03b7
  0x0000,0x0000,0x3000,0x4800,0x4800,0x7800,0x4800,0x4800,0x4800,0x3000,0x0000,0x0000, // u03b8
  0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u03b9
  0x0000,0x0000,0x0000,0x0000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u03ba
  0x0000,0x0000,0x4000,0x4000,0x2000,0x2000,0x5000,0x5000,0x8800,0x8800,0x0000,0x0000, // u03bb
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x9800,0xe800,0x8000,0x8000, // u03bc
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u03bd
  0x0000,0x0000,0x7800,0x8000,0x8000,0x7000,0x8000,0x8000,0x8000,0x7000,0x0800,0x1000, // u03be
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03bf
  0x0000,0x0000,0x0000,0x0000,0xf800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u03c0
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000, // u03c1
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8000,0x7000,0x0800,0x1000, // u03c2
  0x0000,0x0000,0x0000,0x0000,0x7800,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000,0x0000, // u03c3
  0x0000,0x0000,0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x1000,0x0000,0x0000, // u03c4
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03c5
  0x0000,0x0000,0x0000,0x0000,0x9000,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x2000, // u03c6
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x8800, // u03c7
  0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x2000, // u03c8
  0x0000,0x0000,0x0000,0x0000,0x5000,0x8800,0xa800,0xa800,0xa800,0x5000,0x0000,0x0000, // u03c9
  0x0000,0x0000,0x5000,0x5000,0x6000,0x2000,0x2000,0x2000,0x2000,0x1800,0x0000,0x0000, // u03ca
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03cb
  0x0000,0x0000,0x1000,0x2000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03cc
  0x0000,0x0000,0x1000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03cd
  0x0000,0x0000,0x1000,0x2000,0x5000,0x8800,0xa800,0xa800,0xa800,0x5000,0x0000,0x0000, // u03ce
  0x0000,0x0000,0x3000,0x4800,0x4800,0x3c00,0x0800,0xc800,0x4800,0x3000,0x0000,0x0000, // u03d1
  0x0000,0x0000,0x0000,0x2000,0x7000,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x0000, // u03d5
  0x0000,0x0000,0x0000,0x0000,0xc400,0x2800,0x1000,0x2000,0x5000,0x8c00,0x0000,0x0000, // u03f0
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0xf000,0x8000,0x7000, // u03f1
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u03f2
  0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // u03f3
  0x0000,0x0000,0x7000,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u03f4
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8000,0xf000,0x8000,0x8000,0x7800,0x0000,0x0000, // u03f5
  0x0000,0x0000,0x0000,0x0000,0xf000,0x0800,0x7800,0x0800,0x0800,0xf000,0x0000,0x0000, // u03f6
  0x4000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0400
  0x5000,0x5000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0401
  0x0000,0x0000,0xe000,0x4000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0800,0x1000, // u0402
  0x1000,0x2000,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0403
  0x0000,0x0000,0x7000,0x8800,0x8000,0xf000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0404
  0x0000,0x0000,0x7000,0x8800,0x8000,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0405
  0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0406
  0x5000,0x5000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0407
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x9000,0x9000,0x6000,0x0000,0x0000, // u0408
  0x0000,0x0000,0x6000,0xa000,0xb000,0xa800,0xa800,0xa800,0xa800,0xb000,0x0000,0x0000, // u0409
  0x0000,0x0000,0xa000,0xa000,0xb000,0xe800,0xa800,0xa800,0xa800,0xb000,0x0000,0x0000, // u040a
  0x0000,0x0000,0xe000,0x4000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000, // u040b
  0x1000,0x2000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8800,0x0000,0x0000, // u040c
  0x4000,0x2000,0x8800,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x8800,0x0000,0x0000, // u040d
  0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x7000,0x0000,0x0000, // u040e
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0xf800,0x2000,0x2000, // u040f
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0410
  0x0000,0x0000,0xf000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0411
  0x0000,0x0000,0xf000,0x8800,0x8800,0xf000,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0412
  0x0000,0x0000,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0413
  0x0000,0x0000,0x3800,0x4800,0x4800,0x4800,0x4800,0x4800,0x4800,0xfc00,0x8400,0x0000, // u0414
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u0415
  0x0000,0x0000,0xa800,0xa800,0xa800,0x7000,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u0416
  0x0000,0x0000,0x7000,0x8800,0x0800,0x3000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u0417
  0x0000,0x0000,0x8800,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0418
  0x5000,0x2000,0x8800,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x8800,0x0000,0x0000, // u0419
  0x0000,0x0000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8800,0x0000,0x0000, // u041a
  0x0000,0x0000,0x3800,0x4800,0x4800,0x4800,0x4800,0x4800,0x4800,0x8800,0x0000,0x0000, // u041b
  0x0000,0x0000,0x8800,0xd800,0xa800,0xa800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u041c
  0x0000,0x0000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u041d
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u041e
  0x0000,0x0000,0xf800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u041f
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0420
  0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0421
  0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0422
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x7000,0x0000,0x0000, // u0423
  0x0000,0x2000,0x7000,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x0000, // u0424
  0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x8800,0x0000,0x0000, // u0425
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7c00,0x0400,0x0400, // u0426
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x0800,0x0000,0x0000, // u0427
  0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0x7800,0x0000,0x0000, // u0428
  0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0x7c00,0x0400,0x0400, // u0429
  0x0000,0x0000,0xc000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x7000,0x0000,0x0000, // u042a
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0xa800,0xa800,0xa800,0xc800,0x0000,0x0000, // u042b
  0x0000,0x0000,0x4000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x7000,0x0000,0x0000, // u042c
  0x0000,0x0000,0x7000,0x8800,0x0800,0x3800,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u042d
  0x0000,0x0000,0x9000,0xa800,0xa800,0xa800,0xe800,0xa800,0xa800,0x9000,0x0000,0x0000, // u042e
  0x0000,0x0000,0x7800,0x8800,0x8800,0x8800,0x7800,0x2800,0x4800,0x8800,0x0000,0x0000, // u042f
  0x0000,0x0000,0x0000,0x0000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0430
  0x0000,0x0000,0x7000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0431
  0x0000,0x0000,0xe000,0x9000,0x9000,0xf000,0x8800,0x8800,0x8800,0xf000,0x0000,0x0000, // u0432
  0x0000,0x0000,0x0000,0x0000,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0433
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0434
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0435
  0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u0436
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x3000,0x0800,0x8800,0x7000,0x0000,0x0000, // u0437
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0438
  0x0000,0x0000,0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u0439
  0x0000,0x0000,0x0000,0x0000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u043a
  0x0000,0x0000,0x0000,0x0000,0x3800,0x4800,0x4800,0x4800,0x4800,0x8800,0x0000,0x0000, // u043b
  0x0000,0x0000,0x0000,0x0000,0x8800,0xd800,0xa800,0x8800,0x8800,0x8800,0x0000,0x0000, // u043c
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u043d
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u043e
  0x0000,0x0000,0x0000,0x0000,0xf800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u043f
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0xf000,0x8000,0x8000, // u0440
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0441
  0x0000,0x0000,0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u0442
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u0443
  0x0000,0x0000,0x0000,0x2000,0x7000,0xa800,0xa800,0xa800,0xa800,0x7000,0x2000,0x0000, // u0444
  0x0000,0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x0000,0x0000, // u0445
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7c00,0x0400,0x0400, // u0446
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x0000,0x0000, // u0447
  0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xa800,0x7800,0x0000,0x0000, // u0448
  0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xa800,0x7c00,0x0400,0x0400, // u0449
  0x0000,0x0000,0x0000,0x0000,0xc000,0x4000,0x7000,0x4800,0x4800,0x7000,0x0000,0x0000, // u044a
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0xa800,0xc800,0x0000,0x0000, // u044b
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x7000,0x4800,0x4800,0x7000,0x0000,0x0000, // u044c
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x3800,0x0800,0x8800,0x7000,0x0000,0x0000, // u044d
  0x0000,0x0000,0x0000,0x0000,0x9000,0xa800,0xa800,0xe800,0xa800,0x9000,0x0000,0x0000, // u044e
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8800,0x8800,0x7800,0x2800,0x4800,0x0000,0x0000, // u044f
  0x0000,0x0000,0x4000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0450
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u0451
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0800,0x1000, // u0452
  0x0000,0x0000,0x1000,0x2000,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0453
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xe000,0x8000,0x8800,0x7000,0x0000,0x0000, // u0454
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8000,0x7000,0x0800,0x0800,0xf000,0x0000,0x0000, // u0455
  0x0000,0x2000,0x2000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0456
  0x0000,0x0000,0x5000,0x5000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u0457
  0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // u0458
  0x0000,0x0000,0x0000,0x0000,0x6000,0xa000,0xb000,0xa800,0xa800,0xb000,0x0000,0x0000, // u0459
  0x0000,0x0000,0x0000,0x0000,0xa000,0xa000,0xf000,0xa800,0xa800,0xb000,0x0000,0x0000, // u045a
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000, // u045b
  0x0000,0x0000,0x0800,0x1000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u045c
  0x0000,0x0000,0x4000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u045d
  0x0000,0x0000,0x5000,0x2000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u045e
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0xf800,0x2000,0x2000, // u045f
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7000,0x4800,0x4800,0x4800,0x7000,0x0000,0x0000, // u0462
  0x0000,0x0000,0x4000,0x4000,0xe000,0x4000,0x7000,0x4800,0x4800,0x7000,0x0000,0x0000, // u0463
  0x0000,0x0000,0xf800,0x8800,0x5000,0x2000,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u046a
  0x0000,0x0000,0x0000,0x0000,0xf800,0x5000,0x2000,0x7000,0xa800,0xa800,0x0000,0x0000, // u046b
  0x0800,0x0800,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0490
  0x0000,0x0000,0x0800,0x0800,0xf800,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x0000, // u0491
  0x0000,0x0000,0x7c00,0x4000,0x4000,0x4000,0xf000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0492
  0x0000,0x0000,0x0000,0x0000,0x7800,0x4000,0x4000,0xf000,0x4000,0x4000,0x0000,0x0000, // u0493
  0x0000,0x0000,0xf800,0x8000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x0800,0x1000, // u0494
  0x0000,0x0000,0x0000,0x0000,0xf800,0x8000,0x8000,0xe000,0x9000,0x9000,0x1000,0x2000, // u0495
  0x0000,0x0000,0xa800,0xa800,0xa800,0x7000,0x7000,0xa800,0xa800,0xac00,0x0400,0x0400, // u0496
  0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0x7000,0xa800,0xa800,0xac00,0x0400,0x0400, // u0497
  0x0000,0x0000,0x7000,0x8800,0x0800,0x3000,0x0800,0x0800,0x8800,0x7000,0x2000,0x2000, // u0498
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x3000,0x0800,0x8800,0x7000,0x2000,0x2000, // u0499
  0x0000,0x0000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8c00,0x0400,0x0400, // u049a
  0x0000,0x0000,0x0000,0x0000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4c00,0x0400,0x0400, // u049b
  0x0000,0x0000,0x8400,0xa800,0xb000,0xe000,0xe000,0xb000,0xa800,0x8400,0x0000,0x0000, // u049c
  0x0000,0x0000,0x0000,0x0000,0xa800,0xb000,0xe000,0xe000,0xb000,0xa800,0x0000,0x0000, // u049d
  0x0000,0x0000,0xc400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x0000,0x0000, // u04a0
  0x0000,0x0000,0x0000,0x0000,0xc800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x0000, // u04a1
  0x0000,0x0000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x8c00,0x0400,0x0400, // u04a2
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0xf800,0x8800,0x8800,0x8c00,0x0400,0x0400, // u04a3
  0x0000,0x0000,0x9c00,0x9000,0x9000,0xf000,0x9000,0x9000,0x9000,0x9000,0x0000,0x0000, // u04a4
  0x0000,0x0000,0x0000,0x0000,0x9c00,0x9000,0xf000,0x9000,0x9000,0x9000,0x0000,0x0000, // u04a5
  0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x2000,0x2000, // u04aa
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x2000,0x2000, // u04ab
  0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u04ae
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000, // u04af
  0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x7000,0x2000,0x2000,0x0000,0x0000, // u04b0
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x7000,0x2000, // u04b1
  0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x8c00,0x0400,0x0400, // u04b2
  0x0000,0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x2000,0x5000,0x8c00,0x0400,0x0400, // u04b3
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x0c00,0x0400,0x0400, // u04b6
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x7800,0x0800,0x0c00,0x0400,0x0400, // u04b7
  0x0000,0x0000,0x8800,0x8800,0xa800,0xa800,0x7800,0x2800,0x2800,0x0800,0x0000,0x0000, // u04b8
  0x0000,0x0000,0x0000,0x0000,0x8800,0xa800,0xa800,0x7800,0x2800,0x0800,0x0000,0x0000, // u04b9
  0x0000,0x0000,0x8000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u04ba
  0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x0000,0x0000, // u04bb
  0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u04c0
  0x5000,0x2000,0xa800,0xa800,0xa800,0x7000,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u04c1
  0x0000,0x0000,0x5000,0x2000,0xa800,0xa800,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u04c2
  0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u04cf
  0x5000,0x2000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u04d0
  0x0000,0x0000,0x5000,0x2000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u04d1
  0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x0000, // u04d2
  0x0000,0x0000,0x5000,0x5000,0x7000,0x0800,0x7800,0x8800,0x8800,0x7800,0x0000,0x0000, // u04d3
  0x0000,0x0000,0x7c00,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9c00,0x0000,0x0000, // u04d4
  0x0000,0x0000,0x0000,0x0000,0x7000,0x2800,0x6800,0xb000,0xa000,0x7800,0x0000,0x0000, // u04d5
  0x5000,0x2000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u04d6
  0x0000,0x0000,0x5000,0x2000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u04d7
  0x0000,0x0000,0x7000,0x8800,0x0800,0x0800,0xf800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04d8
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x0800,0xf800,0x8800,0x7000,0x0000,0x0000, // u04d9
  0x5000,0x5000,0x7000,0x8800,0x0800,0x0800,0xf800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04da
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0x0800,0xf800,0x8800,0x7000,0x0000,0x0000, // u04db
  0x5000,0x5000,0xa800,0xa800,0xa800,0x7000,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u04dc
  0x0000,0x0000,0x5000,0x5000,0xa800,0xa800,0x7000,0xa800,0xa800,0xa800,0x0000,0x0000, // u04dd
  0x5000,0x5000,0x7000,0x8800,0x0800,0x3000,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u04de
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0x3000,0x0800,0x8800,0x7000,0x0000,0x0000, // u04df
  0x7000,0x0000,0x8800,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x8800,0x0000,0x0000, // u04e2
  0x0000,0x0000,0x7000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u04e3
  0x5000,0x5000,0x8800,0x8800,0x9800,0xa800,0xc800,0x8800,0x8800,0x8800,0x0000,0x0000, // u04e4
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0000,0x0000, // u04e5
  0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04e6
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04e7
  0x0000,0x0000,0x7000,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04e8
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xf800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04e9
  0x5000,0x5000,0x7000,0x8800,0x8800,0x8800,0xf800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04ea
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0xf800,0x8800,0x8800,0x7000,0x0000,0x0000, // u04eb
  0x5000,0x5000,0x7000,0x8800,0x0800,0x3800,0x0800,0x0800,0x8800,0x7000,0x0000,0x0000, // u04ec
  0x0000,0x0000,0x5000,0x5000,0x7000,0x8800,0x3800,0x0800,0x8800,0x7000,0x0000,0x0000, // u04ed
  0x7000,0x0000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x7000,0x0000,0x0000, // u04ee
  0x0000,0x0000,0x7000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u04ef
  0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x7000,0x0000,0x0000, // u04f0
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u04f1
  0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x7000,0x0000,0x0000, // u04f2
  0x0000,0x0000,0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u04f3
  0x5000,0x5000,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x0800,0x0000,0x0000, // u04f4
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0x8800,0x7800,0x0800,0x0800,0x0000,0x0000, // u04f5
  0x5000,0x5000,0x8800,0x8800,0xc800,0xa800,0xa800,0xa800,0xa800,0xc800,0x0000,0x0000, // u04f8
  0x0000,0x0000,0x5000,0x5000,0x8800,0x8800,0xc800,0xa800,0xa800,0xc800,0x0000,0x0000, // u04f9
  0x0000,0x0000,0x8800,0x8800,0x5000,0x2000,0x5000,0x9000,0x8800,0x8800,0x0000,0x0000, // u05d0
  0x0000,0x0000,0xf000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xfc00,0x0000,0x0000, // u05d1
  0x0000,0x0000,0x6000,0x1000,0x1000,0x1000,0x1000,0x3000,0x4800,0x8800,0x0000,0x0000, // u05d2
  0x0000,0x0000,0xfc00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000, // u05d3
  0x0000,0x0000,0xf000,0x0800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u05d4
  0x0000,0x0000,0xc000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u05d5
  0x0000,0x0000,0x7800,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u05d6
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u05d7
  0x0000,0x0000,0x9000,0x9800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u05d8
  0x0000,0x0000,0xc000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u05d9
  0x0000,0x0000,0xf000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u05da
  0x0000,0x0000,0xf000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf000,0x0000,0x0000, // u05db
  0x8000,0x8000,0xf800,0x0800,0x0800,0x0800,0x1000,0x2000,0x2000,0x2000,0x0000,0x0000, // u05dc
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0xf800,0x0000,0x0000, // u05dd
  0x0000,0x0000,0xb000,0xc800,0x8800,0x8800,0x8800,0x8800,0x8800,0x9800,0x0000,0x0000, // u05de
  0x0000,0x0000,0xc000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u05df
  0x0000,0x0000,0x6000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x7000,0x0000,0x0000, // u05e0
  0x0000,0x0000,0xf000,0x4800,0x4800,0x4800,0x4800,0x4800,0x4800,0x3000,0x0000,0x0000, // u05e1
  0x0000,0x0000,0x8800,0x8800,0x8800,0x4800,0x4800,0x4800,0x3000,0xc000,0x0000,0x0000, // u05e2
  0x0000,0x0000,0xf000,0x8800,0x8800,0x4800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u05e3
  0x0000,0x0000,0xf000,0x8800,0x8800,0x4800,0x0800,0x0800,0x0800,0xf000,0x0000,0x0000, // u05e4
  0x0000,0x0000,0x8800,0x8800,0x4800,0x5000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u05e5
  0x0000,0x0000,0x8800,0x8800,0x4800,0x5000,0x2000,0x2000,0x1000,0xf000,0x0000,0x0000, // u05e6
  0x0000,0x0000,0xf800,0x0800,0x8800,0x8800,0x9000,0xa000,0xa000,0xa000,0x8000,0x8000, // u05e7
  0x0000,0x0000,0xf000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000, // u05e8
  0x0000,0x0000,0xa800,0xa800,0xa800,0xa800,0xc800,0x8800,0x8800,0xf000,0x0000,0x0000, // u05e9
  0x0000,0x0000,0xf000,0x4800,0x4800,0x4800,0x4800,0x4800,0x4800,0x8800,0x0000,0x0000, // u05ea
  0x0000,0x0000,0xe000,0x9000,0x8800,0x8800,0x8800,0x8800,0x9000,0xe000,0x2000,0x2000, // u1e0c
  0x0000,0x0000,0x0800,0x0800,0x7800,0x8800,0x8800,0x8800,0x8800,0x7800,0x2000,0x2000, // u1e0d
  0x0000,0x0000,0x8800,0x9000,0xa000,0xc000,0xc000,0xa000,0x9000,0x8800,0x0000,0x7000, // u1e34
  0x0000,0x0000,0x4000,0x4000,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x0000,0x7000, // u1e35
  0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x2000,0x2000, // u1e36
  0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x2000, // u1e37
  0x2000,0x2000,0x8800,0xd800,0xa800,0xa800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u1e40
  0x0000,0x0000,0x2000,0x2000,0xf000,0xa800,0xa800,0xa800,0xa800,0xa800,0x0000,0x0000, // u1e41
  0x0000,0x0000,0x8800,0xd800,0xa800,0xa800,0x8800,0x8800,0x8800,0x8800,0x2000,0x2000, // u1e42
  0x0000,0x0000,0x0000,0x0000,0xf000,0xa800,0xa800,0xa800,0xa800,0xa800,0x1000,0x1000, // u1e43
  0x2000,0x2000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x0000,0x0000, // u1e44
  0x0000,0x0000,0x2000,0x2000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u1e45
  0x0000,0x0000,0x8800,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x8800,0x2000,0x2000, // u1e46
  0x0000,0x0000,0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x2000,0x2000, // u1e47
  0x0000,0x0000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x1000, // u1e6c
  0x0000,0x0000,0x2000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x1800,0x1000,0x1000, // u1e6d
  0x0000,0x0000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x2000,0x2000, // u1eb8
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x2000,0x2000, // u1eb9
  0x2800,0x5000,0xf800,0x8000,0x8000,0xf000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000, // u1ebc
  0x0000,0x0000,0x2800,0x5000,0x7000,0x8800,0xf800,0x8000,0x8000,0x7800,0x0000,0x0000, // u1ebd
  0x0000,0x0000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x2000, // u1eca
  0x0000,0x2000,0x2000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x2000, // u1ecb
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x2000, // u1ecc
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x2000, // u1ecd
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x2000,0x2000, // u1ee4
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x2000,0x2000, // u1ee5
  0x2800,0x5000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u1ef8
  0x0000,0x0000,0x2800,0x5000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7800,0x0800,0x7000, // u1ef9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2001
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2002
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2003
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2004
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2005
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2006
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2007
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2008
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2009
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2010
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2011
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2012
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2013
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2014
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2015
  0x0000,0x0000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x0000,0x0000, // u2016
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0xf800, // u2017
  0x0000,0x1000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2018
  0x0000,0x2000,0x2000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2019
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x4000,0x0000, // u201a
  0x0000,0x2000,0x2000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201b
  0x0000,0x2800,0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201c
  0x0000,0x2800,0x2800,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x5000,0x5000,0xa000,0x0000, // u201e
  0x0000,0xa000,0xa000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201f
  0x0000,0x0000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u2020
  0x0000,0x0000,0x2000,0x7000,0x2000,0x2000,0x2000,0x2000,0x7000,0x2000,0x0000,0x0000, // u2021
  0x0000,0x0000,0x0000,0x0000,0x3000,0x7800,0x7800,0x3000,0x0000,0x0000,0x0000,0x0000, // u2022
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0x0000,0x0000, // u2026
  0x0000,0x0000,0x4400,0xa800,0x5000,0x2000,0x4000,0xa800,0x5400,0x2800,0x0000,0x0000, // u2030
  0x0000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2032
  0x0000,0x5000,0x5000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2033
  0x0000,0x0000,0x0000,0x0800,0x1000,0x2000,0x4000,0x2000,0x1000,0x0800,0x0000,0x0000, // u2039
  0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x0800,0x1000,0x2000,0x4000,0x0000,0x0000, // u203a
  0x0000,0x0000,0x5000,0x5000,0x5000,0x5000,0x5000,0x0000,0x5000,0x5000,0x0000,0x0000, // u203c
  0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u203e
  0x0000,0x3000,0x4800,0x4800,0x4800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2070
  0x2000,0x0000,0x6000,0x2000,0x2000,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2071
  0x0000,0x0800,0x1800,0x2800,0x7800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2074
  0x0000,0x7000,0x4000,0x7000,0x0800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2075
  0x0000,0x3000,0x4000,0x7000,0x4800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2076
  0x0000,0x7800,0x0800,0x1000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2077
  0x0000,0x3000,0x4800,0x3000,0x4800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2078
  0x0000,0x3000,0x4800,0x3800,0x0800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2079
  0x0000,0x2000,0x2000,0xf800,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207a
  0x0000,0x0000,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207b
  0x0000,0x0000,0x7800,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207c
  0x0000,0x1000,0x2000,0x2000,0x2000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207d
  0x0000,0x2000,0x1000,0x1000,0x1000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207e
  0x0000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x4800,0x4800,0x3000,0x0000,0x0000, // u2080
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x3000,0x1000,0x1000,0x3800,0x0000,0x0000, // u2081
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x1000,0x2000,0x7800,0x0000,0x0000, // u2082
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x0800,0x3000,0x0800,0x7000,0x0000,0x0000, // u2083
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1800,0x2800,0x7800,0x0800,0x0000,0x0000, // u2084
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x4000,0x7000,0x0800,0x7000,0x0000,0x0000, // u2085
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4000,0x7000,0x4800,0x3000,0x0000,0x0000, // u2086
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0800,0x1000,0x2000,0x2000,0x0000,0x0000, // u2087
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x3000,0x4800,0x3000,0x0000,0x0000, // u2088
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x3800,0x0800,0x3000,0x0000,0x0000, // u2089
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0xf800,0x2000,0x2000,0x0000,0x0000, // u208a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0000,0x0000,0x0000,0x0000, // u208b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0000,0x7800,0x0000,0x0000,0x0000, // u208c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x2000,0x2000,0x2000,0x1000,0x0000,0x0000, // u208d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x1000,0x1000,0x1000,0x2000,0x0000,0x0000, // u208e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x0800,0x3800,0x4800,0x3800,0x0000,0x0000, // u2090
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x7800,0x4000,0x3800,0x0000,0x0000, // u2091
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x4800,0x4800,0x3000,0x0000,0x0000, // u2092
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x5000,0x8800,0x0000,0x0000, // u2093
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x0800,0x7800,0x4800,0x3000,0x0000,0x0000, // u2094
  0x0000,0x0000,0x0000,0x0000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000, // u2095
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4800,0x5000,0x6000,0x5000,0x4800,0x0000,0x0000, // u2096
  0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000, // u2097
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xa800,0xa800,0xa800,0xa800,0x0000,0x0000, // u2098
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x4800,0x4800,0x4800,0x7000,0x4000,0x4000, // u209a
  0x0000,0x0000,0xc000,0xa000,0xa000,0xc800,0x9c00,0x8800,0x8800,0x8400,0x0000,0x0000, // u20a7
  0x0000,0x0000,0xc800,0xa800,0xa800,0x8800,0x8800,0xa800,0xa800,0xb000,0x0000,0x0000, // u20aa
  0x0000,0x0000,0x0000,0x3800,0x4400,0xf000,0x4000,0xf000,0x4400,0x3800,0x0000,0x0000, // u20ac
  0x0000,0x0000,0xf800,0x2000,0x3000,0x6000,0x3000,0x6000,0x2000,0x2000,0x0000,0x0000, // u20ae
  0x0000,0x0000,0x7000,0xa800,0xa000,0xa000,0xa000,0xa000,0xa800,0x7000,0x0000,0x0000, // u2102
  0x0000,0x0000,0x8000,0x8000,0xf000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u210e
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7000,0x4800,0x4800,0x4800,0x4800,0x0000,0x0000, // u210f
  0x0000,0x0000,0x8800,0xc800,0xa800,0xd800,0xa800,0x9800,0x8800,0x8800,0x0000,0x0000, // u2115
  0x0000,0x0000,0x9400,0x9400,0xd000,0xf000,0xf000,0xb400,0x9000,0x9400,0x0000,0x0000, // u2116
  0x0000,0x0000,0x7000,0xc800,0xa800,0xa800,0xa800,0xa800,0xa800,0x7000,0x1800,0x0000, // u211a
  0x0000,0x0000,0xf000,0xa800,0xa800,0xa800,0xb000,0xb000,0xa800,0xe400,0x0000,0x0000, // u211d
  0x0000,0x0000,0xf400,0x5c00,0x5400,0x5400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2122
  0x0000,0x0000,0xf800,0x1800,0x2800,0x5000,0xa000,0xc000,0x8000,0xf800,0x0000,0x0000, // u2124
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x5000,0xd800,0x0000,0x0000, // u2126
  0x0000,0x0000,0x4800,0x4800,0x2400,0x6800,0x9000,0x9000,0x8800,0x4800,0x0000,0x0000, // u2135
  0x0000,0x0000,0x0000,0x2000,0x6000,0xfc00,0x6000,0x2000,0x0000,0x0000,0x0000,0x0000, // u2190
  0x0000,0x0000,0x2000,0x7000,0xf800,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u2191
  0x0000,0x0000,0x0000,0x1000,0x1800,0xfc00,0x1800,0x1000,0x0000,0x0000,0x0000,0x0000, // u2192
  0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0xf800,0x7000,0x2000,0x0000,0x0000, // u2193
  0x0000,0x0000,0x0000,0x4800,0xcc00,0xfc00,0xcc00,0x4800,0x0000,0x0000,0x0000,0x0000, // u2194
  0x0000,0x0000,0x2000,0x7000,0xf800,0x2000,0x2000,0xf800,0x7000,0x2000,0x0000,0x0000, // u2195
  0x0000,0x0000,0x0000,0x2400,0x6400,0xfc00,0x6400,0x2400,0x0000,0x0000,0x0000,0x0000, // u21a4
  0x0000,0x0000,0x0000,0x9000,0x9800,0xfc00,0x9800,0x9000,0x0000,0x0000,0x0000,0x0000, // u21a6
  0x0000,0x0000,0x2000,0x7000,0xf800,0x2000,0xf800,0x7000,0x2000,0xf800,0x0000,0x0000, // u21a8
  0x0000,0x0000,0x0800,0x0800,0x0800,0x2800,0x6800,0xf800,0x6000,0x2000,0x0000,0x0000, // u21b5
  0x0000,0x0000,0xf000,0x3000,0x5000,0x9400,0x8400,0x8400,0x8400,0x7800,0x0000,0x0000, // u21bb
  0x0000,0x0000,0x2000,0x4000,0xfc00,0x0000,0xfc00,0x0800,0x1000,0x0000,0x0000,0x0000, // u21cb
  0x0000,0x0000,0x1000,0x0800,0xfc00,0x0000,0xfc00,0x4000,0x2000,0x0000,0x0000,0x0000, // u21cc
  0x0000,0x0000,0x0000,0x2000,0x7c00,0xe000,0x7c00,0x2000,0x0000,0x0000,0x0000,0x0000, // u21d0
  0x0000,0x0000,0x2000,0x7000,0xf800,0x5000,0x5000,0x5000,0x5000,0x5000,0x0000,0x0000, // u21d1
  0x0000,0x0000,0x0000,0x1000,0xf800,0x1c00,0xf800,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d2
  0x0000,0x0000,0x5000,0x5000,0x5000,0x5000,0x5000,0xf800,0x7000,0x2000,0x0000,0x0000, // u21d3
  0x0000,0x0000,0x0000,0x4800,0xfc00,0xcc00,0xfc00,0x4800,0x0000,0x0000,0x0000,0x0000, // u21d4
  0x0000,0x0000,0x2000,0x7000,0xf800,0x5000,0x5000,0xf800,0x7000,0x2000,0x0000,0x0000, // u21d5
  0x0000,0x0000,0x8800,0x8800,0xf800,0x5000,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u2200
  0x0000,0x0000,0x0000,0xf800,0x0800,0x0800,0xf800,0x0800,0x0800,0xf800,0x0000,0x0000, // u2203
  0x0000,0x0000,0x1000,0xf800,0x2800,0x2800,0xf800,0x4800,0x4800,0xf800,0x8000,0x0000, // u2204
  0x0000,0x0000,0x0800,0x7000,0x9800,0xa800,0xa800,0xc800,0x7000,0x8000,0x0000,0x0000, // u2205
  0x0000,0x0000,0x2000,0x2000,0x5000,0x5000,0x8800,0x8800,0x8800,0xf800,0x0000,0x0000, // u2206
  0x0000,0x0000,0xf800,0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u2207
  0x0000,0x0000,0x0000,0x3800,0x4000,0x8000,0xf800,0x8000,0x4000,0x3800,0x0000,0x0000, // u2208
  0x0000,0x0000,0x0800,0x3800,0x5000,0x9000,0xf800,0xa000,0x6000,0x7800,0x4000,0x0000, // u2209
  0x0000,0x0000,0x0000,0x0000,0x7800,0x8000,0xf800,0x8000,0x7800,0x0000,0x0000,0x0000, // u220a
  0x0000,0x0000,0x0000,0xe000,0x1000,0x0800,0xf800,0x0800,0x1000,0xe000,0x0000,0x0000, // u220b
  0x0000,0x0000,0x8000,0xe000,0x5000,0x4800,0xf800,0x2800,0x3000,0xf000,0x1000,0x0000, // u220c
  0x0000,0x0000,0x0000,0x0000,0xf000,0x0800,0xf800,0x0800,0xf000,0x0000,0x0000,0x0000, // u220d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2212
  0x0000,0x0000,0x0000,0xf800,0x0000,0x2000,0x2000,0xf800,0x2000,0x2000,0x0000,0x0000, // u2213
  0x0000,0x0000,0x2000,0x2000,0x0000,0x2000,0x2000,0xf800,0x2000,0x2000,0x0000,0x0000, // u2214
  0x0000,0x0000,0x0000,0x0000,0x0800,0x1000,0x2000,0x4000,0x8000,0x0000,0x0000,0x0000, // u2215
  0x0000,0x0000,0x0000,0x0000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0000,0x0000,0x0000, // u2216
  0x0000,0x0000,0x0000,0x0000,0x3000,0x7800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2219
  0x0000,0x0c00,0x0800,0x0800,0x0800,0x8800,0x8800,0x4800,0x2800,0x1800,0x0000,0x0000, // u221a
  0x0000,0x0000,0x0000,0x5000,0xa800,0xa800,0xa800,0x5000,0x0000,0x0000,0x0000,0x0000, // u221e
  0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000,0x0000,0x0000, // u221f
  0x0000,0x0000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x0000,0x0000, // u2225
  0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x5000,0x5000,0x8800,0x8800,0x0000,0x0000, // u2227
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u2228
  0x0000,0x0000,0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u2229
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u222a
  0x0000,0x0000,0x0000,0x0000,0x6800,0xb000,0x0000,0x6800,0xb000,0x0000,0x0000,0x0000, // u2248
  0x0000,0x0000,0x0000,0x0800,0xf800,0x2000,0x4000,0xf800,0x8000,0x0000,0x0000,0x0000, // u2260
  0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0xf800,0x0000,0xf800,0x0000,0x0000,0x0000, // u2261
  0x0000,0x1000,0x2000,0x4000,0x8000,0x4000,0x2000,0x1000,0x0000,0xf800,0x0000,0x0000, // u2264
  0x0000,0x4000,0x2000,0x1000,0x0800,0x1000,0x2000,0x4000,0x0000,0xf800,0x0000,0x0000, // u2265
  0x0000,0x0000,0x0000,0x1400,0x2800,0x5000,0xa000,0x5000,0x2800,0x1400,0x0000,0x0000, // u226a
  0x0000,0x0000,0x0000,0xa000,0x5000,0x2800,0x1400,0x2800,0x5000,0xa000,0x0000,0x0000, // u226b
  0x0000,0x0000,0x0000,0x7800,0x8000,0x8000,0x8000,0x8000,0x7800,0x0000,0x0000,0x0000, // u2282
  0x0000,0x0000,0x0000,0xf000,0x0800,0x0800,0x0800,0x0800,0xf000,0x0000,0x0000,0x0000, // u2283
  0x0000,0x0000,0x7800,0x8000,0x8000,0x8000,0x8000,0x7800,0x0000,0xf800,0x0000,0x0000, // u2286
  0x0000,0x0000,0xf000,0x0800,0x0800,0x0800,0x0800,0xf000,0x0000,0xf800,0x0000,0x0000, // u2287
  0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0xf800,0x0000,0x0000, // u22a5
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x0000,0x0000, // u22c2
  0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u22c3
  0x0000,0x0000,0x0800,0x7000,0x9800,0xa800,0xa800,0xc800,0x7000,0x8000,0x0000,0x0000, // u2300
  0x0000,0x0000,0x0000,0x0000,0x2000,0x5000,0x8800,0x8800,0x8800,0xf800,0x0000,0x0000, // u2302
  0x0000,0x0000,0x7000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u2308
  0x0000,0x0000,0x7000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u2309
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7000,0x0000,0x0000, // u230a
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x7000,0x0000,0x0000, // u230b
  0x0000,0x0000,0x0000,0x0000,0xf800,0x8000,0x8000,0x8000,0x0000,0x0000,0x0000,0x0000, // u2310
  0x0000,0x0000,0x0000,0x0000,0x8000,0x8000,0x8000,0xf800,0x0000,0x0000,0x0000,0x0000, // u2319
  0x0000,0x0000,0x1000,0x2800,0x2800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2320
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xa000,0xa000,0x4000,0x0000,0x0000, // u2321
  0x0800,0x1000,0x1000,0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u239b
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u239c
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x2000,0x2000,0x2000,0x1000,0x1000,0x0800, // u239d
  0x4000,0x2000,0x2000,0x1000,0x1000,0x1000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u239e
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u239f
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1000,0x1000,0x1000,0x2000,0x2000,0x4000, // u23a0
  0x7800,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u23a1
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u23a2
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7800, // u23a3
  0x7800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u23a4
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u23a5
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x7800, // u23a6
  0x0c00,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23a7
  0x2000,0x2000,0x2000,0x2000,0x2000,0xc000,0xc000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23a8
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x0c00, // u23a9
  0xc000,0x2000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u23ab
  0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0c00,0x1000,0x1000,0x1000,0x1000,0x1000, // u23ac
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x2000,0xc000, // u23ad
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23af
  0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23ba
  0x0000,0x0000,0x0000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x0000,0x0000,0x0000, // u23bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00, // u23bd
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23d0
  0x9000,0x9000,0xf000,0x9000,0x9000,0x0000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x0000, // u2409
  0x8000,0x8000,0x8000,0x8000,0xf000,0x0000,0x3c00,0x2000,0x3800,0x2000,0x2000,0x0000, // u240a
  0x8800,0x8800,0x8800,0x5000,0x2000,0x0000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x0000, // u240b
  0xf000,0x8000,0xe000,0x8000,0x8000,0x0000,0x3c00,0x2000,0x3800,0x2000,0x2000,0x0000, // u240c
  0x6000,0x9000,0x8000,0x9000,0x6000,0x0000,0x3800,0x2400,0x3800,0x2800,0x2400,0x0000, // u240d
  0x9000,0xd000,0xb000,0x9000,0x9000,0x0000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x0000, // u2424
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2500
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2501
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2502
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2503
  0x0000,0x0000,0x0000,0x0000,0x0000,0xa800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2508
  0x0000,0x0000,0x0000,0x0000,0x0000,0xa800,0xa800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2509
  0x2000,0x2000,0x0000,0x2000,0x2000,0x0000,0x2000,0x2000,0x0000,0x2000,0x2000,0x0000, // u250a
  0x3000,0x3000,0x0000,0x3000,0x3000,0x0000,0x3000,0x3000,0x0000,0x3000,0x3000,0x0000, // u250b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u250c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u250d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u250e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000, // u250f
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2510
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2511
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2512
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2513
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2514
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2515
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2516
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2517
  0x2000,0x2000,0x2000,0x2000,0x2000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2518
  0x2000,0x2000,0x2000,0x2000,0x2000,0xe000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2519
  0x3000,0x3000,0x3000,0x3000,0x3000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251a
  0x3000,0x3000,0x3000,0x3000,0x3000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251b
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u251c
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u251d
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u251e
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u251f
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2520
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u2521
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3c00,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000, // u2522
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000, // u2523
  0x2000,0x2000,0x2000,0x2000,0x2000,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2524
  0x2000,0x2000,0x2000,0x2000,0x2000,0xe000,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2525
  0x3000,0x3000,0x3000,0x3000,0x3000,0xf000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2526
  0x2000,0x2000,0x2000,0x2000,0x2000,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2527
  0x3000,0x3000,0x3000,0x3000,0x3000,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2528
  0x3000,0x3000,0x3000,0x3000,0x3000,0xf000,0xf000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2529
  0x2000,0x2000,0x2000,0x2000,0x2000,0xf000,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000, // u252a
  0x3000,0x3000,0x3000,0x3000,0x3000,0xf000,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000, // u252b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u252c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u252d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u252e
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000, // u252f
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2530
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2531
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000, // u2532
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000, // u2533
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2534
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2535
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2536
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2537
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2538
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2539
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u253a
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u253b
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u253c
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u253d
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u253e
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000, // u253f
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2540
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2541
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2542
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2543
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u2544
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2545
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000, // u2546
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000, // u2547
  0x2000,0x2000,0x2000,0x2000,0x2000,0xfc00,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000, // u2548
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0xf000,0x3000,0x3000,0x3000,0x3000,0x3000, // u2549
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000, // u254a
  0x3000,0x3000,0x3000,0x3000,0x3000,0xfc00,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000, // u254b
  0x0000,0x0000,0x0000,0x0000,0xfc00,0x0000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2550
  0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2551
  0x0000,0x0000,0x0000,0x0000,0x3c00,0x2000,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u2552
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2553
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x4000,0x5c00,0x5000,0x5000,0x5000,0x5000,0x5000, // u2554
  0x0000,0x0000,0x0000,0x0000,0xe000,0x2000,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2555
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2556
  0x0000,0x0000,0x0000,0x0000,0xf000,0x1000,0xd000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2557
  0x2000,0x2000,0x2000,0x2000,0x3c00,0x2000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2558
  0x5000,0x5000,0x5000,0x5000,0x5000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2559
  0x5000,0x5000,0x5000,0x5000,0x5c00,0x4000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u255a
  0x2000,0x2000,0x2000,0x2000,0xe000,0x2000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255b
  0x5000,0x5000,0x5000,0x5000,0x5000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255c
  0x5000,0x5000,0x5000,0x5000,0xd000,0x1000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255d
  0x2000,0x2000,0x2000,0x2000,0x3c00,0x2000,0x3c00,0x2000,0x2000,0x2000,0x2000,0x2000, // u255e
  0x5000,0x5000,0x5000,0x5000,0x5000,0x5c00,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u255f
  0x5000,0x5000,0x5000,0x5000,0x5c00,0x4000,0x5c00,0x5000,0x5000,0x5000,0x5000,0x5000, // u2560
  0x2000,0x2000,0x2000,0x2000,0xe000,0x2000,0xe000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2561
  0x5000,0x5000,0x5000,0x5000,0x5000,0xd000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2562
  0x5000,0x5000,0x5000,0x5000,0xd000,0x1000,0xd000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2563
  0x0000,0x0000,0x0000,0x0000,0xfc00,0x0000,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000, // u2564
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u2565
  0x0000,0x0000,0x0000,0x0000,0xfc00,0x0000,0xdc00,0x5000,0x5000,0x5000,0x5000,0x5000, // u2566
  0x2000,0x2000,0x2000,0x2000,0xfc00,0x0000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2567
  0x5000,0x5000,0x5000,0x5000,0x5000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2568
  0x5000,0x5000,0x5000,0x5000,0xdc00,0x0000,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2569
  0x2000,0x2000,0x2000,0x2000,0xfc00,0x2000,0xfc00,0x2000,0x2000,0x2000,0x2000,0x2000, // u256a
  0x5000,0x5000,0x5000,0x5000,0x5000,0xfc00,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000, // u256b
  0x5000,0x5000,0x5000,0x5000,0xdc00,0x0000,0xdc00,0x5000,0x5000,0x5000,0x5000,0x5000, // u256c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000, // u256d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x4000,0x2000,0x2000,0x2000,0x2000,0x2000, // u256e
  0x2000,0x2000,0x2000,0x2000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u256f
  0x2000,0x2000,0x2000,0x2000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2570
  0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x4000,0x8000,0x8000, // u2571
  0x8000,0x8000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400, // u2572
  0x8400,0x8400,0x4800,0x4800,0x3000,0x3000,0x3000,0x3000,0x4800,0x4800,0x8400,0x8400, // u2573
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2574
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2575
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2576
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u2577
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2578
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2579
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u257a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u257b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u257c
  0x2000,0x2000,0x2000,0x2000,0x2000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u257d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257e
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u257f
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2580
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00, // u2581
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0xfc00, // u2582
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0xfc00,0xfc00, // u2583
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u2584
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u2585
  0x0000,0x0000,0x0000,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u2586
  0x0000,0x0000,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u2587
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u2588
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800, // u2589
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u258a
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u258b
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u258c
  0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000, // u258d
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000, // u258e
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000, // u258f
  0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00, // u2590
  0x9000,0x2400,0x9000,0x2400,0x9000,0x2400,0x9000,0x2400,0x9000,0x2400,0x9000,0x2400, // u2591
  0xa800,0x5400,0xa800,0x5400,0xa800,0x5400,0xa800,0x5400,0xa800,0x5400,0xa800,0x5400, // u2592
  0xd800,0xb400,0xd800,0xb400,0xd800,0xb400,0xd800,0xb400,0xd800,0xb400,0xd800,0xb400, // u2593
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u2596
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00, // u2597
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2598
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u2599
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00, // u259a
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u259b
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00, // u259c
  0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u259d
  0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u259e
  0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0x1c00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u259f
  0x0000,0x0000,0x0000,0x7800,0x7800,0x7800,0x7800,0x7800,0x0000,0x0000,0x0000,0x0000, // u25a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x0000,0x0000, // u25ac
  0x0000,0x0000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0x0000,0x0000, // u25ae
  0x0000,0x0000,0x0000,0x3000,0x3000,0x7800,0x7800,0xfc00,0xfc00,0x0000,0x0000,0x0000, // u25b2
  0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000, // u25b6
  0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000, // u25ba
  0x0000,0x0000,0x0000,0xfc00,0xfc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000,0x0000, // u25bc
  0x0000,0x0000,0x0000,0x0c00,0x3c00,0xfc00,0xfc00,0x3c00,0x0c00,0x0000,0x0000,0x0000, // u25c0
  0x0000,0x0000,0x0000,0x0c00,0x3c00,0xfc00,0xfc00,0x3c00,0x0c00,0x0000,0x0000,0x0000, // u25c4
  0x0000,0x0000,0x0000,0x2000,0x7000,0xf800,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000, // u25c6
  0x0000,0x0000,0x0000,0x2000,0x5000,0x8800,0x5000,0x2000,0x0000,0x0000,0x0000,0x0000, // u25ca
  0x0000,0x0000,0x0000,0x0000,0x3000,0x4800,0x4800,0x3000,0x0000,0x0000,0x0000,0x0000, // u25cb
  0x0000,0x0000,0x0000,0x0000,0x3000,0x7800,0x7800,0x3000,0x0000,0x0000,0x0000,0x0000, // u25cf
  0xfc00,0xfc00,0xfc00,0xfc00,0xcc00,0x8400,0x8400,0xcc00,0xfc00,0xfc00,0xfc00,0xfc00, // u25d8
  0xfc00,0xfc00,0xfc00,0xfc00,0xcc00,0xb400,0xb400,0xcc00,0xfc00,0xfc00,0xfc00,0xfc00, // u25d9
  0x0000,0x0000,0x7800,0x8400,0xcc00,0x8400,0xb400,0xb400,0x8400,0x7800,0x0000,0x0000, // u263a
  0x0000,0x0000,0x7800,0xfc00,0xb400,0xfc00,0x8400,0xcc00,0xfc00,0x7800,0x0000,0x0000, // u263b
  0x0000,0x0000,0x0000,0x2000,0xa800,0x7000,0xd800,0x7000,0xa800,0x2000,0x0000,0x0000, // u263c
  0x0000,0x0000,0x7000,0x8800,0x8800,0x8800,0x7000,0x2000,0xf800,0x2000,0x0000,0x0000, // u2640
  0x0000,0x0000,0x3c00,0x0c00,0x1400,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000, // u2642
  0x0000,0x0000,0x2000,0x2000,0x7000,0xf800,0xf800,0x7000,0x2000,0x7000,0x0000,0x0000, // u2660
  0x0000,0x0000,0x2000,0x7000,0x2000,0xa800,0xf800,0xa800,0x2000,0x7000,0x0000,0x0000, // u2663
  0x0000,0x0000,0x0000,0x5000,0xf800,0xf800,0xf800,0x7000,0x7000,0x2000,0x0000,0x0000, // u2665
  0x0000,0x0000,0x0000,0x2000,0x7000,0xf800,0x7000,0x2000,0x0000,0x0000,0x0000,0x0000, // u2666
  0x0000,0x0000,0x7800,0x4800,0x7800,0x4000,0x4000,0x4000,0x4000,0x8000,0x0000,0x0000, // u266a
  0x0000,0x0000,0x7800,0x4800,0x7800,0x4800,0x4800,0x4800,0x4800,0x5000,0x8000,0x0000, // u266b
  0x0000,0x0000,0x0400,0x0400,0x0800,0x8800,0x9000,0x5000,0x2000,0x2000,0x0000,0x0000, // u2713
  0x0000,0x0000,0x0c00,0x0c00,0x1800,0xd800,0xf000,0x7000,0x6000,0x6000,0x0000,0x0000, // u2714
  0x0000,0x0000,0x4800,0x2800,0x1000,0x1000,0x2800,0x2400,0x4000,0x4000,0x0000,0x0000, // u2717
  0x0000,0x0000,0x1800,0xd800,0x7000,0x3000,0x7800,0x6c00,0xc000,0xc000,0x0000,0x0000, // u2718
  0x0000,0x1000,0x1000,0x2000,0x2000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0000,0x0000, // u27e8
  0x0000,0x4000,0x4000,0x2000,0x2000,0x1000,0x2000,0x2000,0x4000,0x4000,0x0000,0x0000, // u27e9
  0x0000,0x2800,0x2800,0x5000,0x5000,0xa000,0x5000,0x5000,0x2800,0x2800,0x0000,0x0000, // u27ea
  0x0000,0xa000,0xa000,0x5000,0x5000,0x2800,0x5000,0x5000,0xa000,0xa000,0x0000,0x0000, // u27eb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2800
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2801
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2802
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2803
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2804
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2805
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2806
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2807
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2808
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2809
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280a
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280b
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280c
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280d
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280e
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280f
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2810
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2811
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2812
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2813
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2814
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2815
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2816
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2817
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2818
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2819
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281a
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281b
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281c
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281d
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281e
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2820
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2821
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2822
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2823
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2824
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2825
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2826
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2827
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2828
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2829
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u282a
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u282b
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u282c
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u282d
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u282e
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u282f
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2830
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2831
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2832
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2833
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2834
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2835
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2836
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u2837
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2838
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2839
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u283a
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u283b
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u283c
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u283d
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u283e
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u283f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2840
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2841
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2842
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2843
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2844
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2845
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2846
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2847
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2848
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2849
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284a
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284b
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284c
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284d
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284e
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284f
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2850
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2851
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2852
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2853
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2854
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2855
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2856
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2857
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2858
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2859
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285a
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285b
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285c
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285d
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285e
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2860
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2861
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2862
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2863
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2864
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2865
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2866
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2867
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2868
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2869
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u286a
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u286b
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u286c
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u286d
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u286e
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u286f
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2870
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2871
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2872
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2873
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2874
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2875
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2876
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u2877
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2878
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u2879
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u287a
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000, // u287b
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u287c
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u287d
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u287e
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000, // u287f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2880
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2881
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2882
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2883
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2884
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2885
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2886
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2887
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2888
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2889
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u288a
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u288b
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u288c
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u288d
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u288e
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u288f
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2890
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2891
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2892
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2893
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2894
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2895
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2896
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u2897
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2898
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u2899
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u289a
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000, // u289b
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u289c
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u289d
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u289e
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000, // u289f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28a0
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28a1
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28a2
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28a3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28a4
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28a5
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28a6
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28a7
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28a8
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28a9
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28aa
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28ab
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28ac
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28ad
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28ae
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28af
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28b0
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28b1
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28b2
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28b3
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28b4
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28b5
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28b6
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28b7
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28b8
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28b9
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28ba
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000, // u28bb
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28bc
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28bd
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28be
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000, // u28bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28c0
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28c1
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28c2
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28c4
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28c5
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28c6
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28c7
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28c8
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28c9
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28ca
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28cb
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28cc
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28cd
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28ce
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28cf
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28d0
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28d1
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28d2
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28d3
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28d4
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28d5
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28d6
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28d7
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28d8
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28d9
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28da
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000, // u28db
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28dc
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28dd
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28de
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000, // u28df
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28e0
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28e1
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28e2
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28e3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28e4
  0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28e5
  0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28e6
  0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28e7
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28e8
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28e9
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28ea
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28eb
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28ec
  0x4800,0x4800,0x0000,0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28ed
  0x0800,0x0800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28ee
  0x4800,0x4800,0x0000,0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28ef
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28f0
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28f1
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28f2
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28f3
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28f4
  0x4000,0x4000,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28f5
  0x0000,0x0000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28f6
  0x4000,0x4000,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28f7
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28f8
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28f9
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28fa
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000, // u28fb
  0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28fc
  0x4800,0x4800,0x0000,0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28fd
  0x0800,0x0800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28fe
  0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000,0x4800,0x4800,0x0000, // u28ff
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x0000,0x0000,0x8800,0x8800,0x0000,0x0000, // u2e2c
  0x8000,0x9000,0xb800,0x9000,0x9000,0x9000,0x2000,0x4000,0x8000,0x8000,0x8000,0x8000, // ue0a0
  0x8000,0x8000,0x8000,0x8000,0xf000,0x0000,0x2400,0x3400,0x2c00,0x2400,0x2400,0x0000, // ue0a1
  0x0000,0x3000,0x4800,0x4800,0x4800,0xfc00,0xfc00,0xcc00,0xcc00,0xfc00,0xfc00,0x0000, // ue0a2
  0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0xfc00,0xf800,0xf000,0xe000,0xc000,0x8000, // ue0b0
  0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000, // ue0b1
  0x0400,0x0c00,0x1c00,0x3c00,0x7c00,0xfc00,0xfc00,0x7c00,0x3c00,0x1c00,0x0c00,0x0400, // ue0b2
  0x0400,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0400, // ue0b3
  0x0000,0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x3000, // uf6be
  0x0000,0x0000,0xf800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0xf800,0x0000,0x0000 // ufffd
  };
  // codepoints array
  constexpr std::array<uint16_t, CHARCOUNT> fixedfont_codepoints = {
  0x0000,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,
  0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,
  0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,
  0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,
  0x005f,0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff,
  0x0100,0x0101,0x0102,0x0103,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x010c,0x010d,0x010e,0x010f,
  0x0110,0x0111,0x0112,0x0113,0x0114,0x0115,0x0116,0x0117,0x0118,0x0119,0x011a,0x011b,0x011c,0x011d,0x011e,0x011f,
  0x0120,0x0121,0x0122,0x0123,0x0124,0x0125,0x0126,0x0127,0x0128,0x0129,0x012a,0x012b,0x012c,0x012d,0x012e,0x012f,
  0x0130,0x0131,0x0132,0x0133,0x0134,0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x013d,0x013e,0x013f,
  0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,0x0149,0x014a,0x014b,0x014c,0x014d,0x014e,0x014f,
  0x0150,0x0151,0x0152,0x0153,0x0154,0x0155,0x0156,0x0157,0x0158,0x0159,0x015a,0x015b,0x015c,0x015d,0x015e,0x015f,
  0x0160,0x0161,0x0162,0x0163,0x0164,0x0165,0x0166,0x0167,0x0168,0x0169,0x016a,0x016b,0x016c,0x016d,0x016e,0x016f,
  0x0170,0x0171,0x0172,0x0173,0x0174,0x0175,0x0176,0x0177,0x0178,0x0179,0x017a,0x017b,0x017c,0x017d,0x017e,0x017f,
  0x0186,0x018e,0x018f,0x0190,0x0192,0x019d,0x019e,0x01b5,0x01b6,0x01b7,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d2,
  0x01d3,0x01d4,0x01e2,0x01e3,0x01e4,0x01e5,0x01e6,0x01e7,0x01e8,0x01e9,0x01ea,0x01eb,0x01ec,0x01ed,0x01ee,0x01ef,
  0x01f0,0x01f4,0x01f5,0x01fc,0x01fd,0x01fe,0x01ff,0x0218,0x0219,0x021a,0x021b,0x0232,0x0233,0x0237,0x0254,0x0258,
  0x0259,0x025b,0x0272,0x0292,0x02bb,0x02bc,0x02bd,0x02c6,0x02c7,0x02d8,0x02d9,0x02db,0x02dc,0x02dd,0x0300,0x0301,
  0x0302,0x0303,0x0304,0x0305,0x0306,0x0307,0x0308,0x030a,0x030b,0x030c,0x0329,0x0384,0x0385,0x0386,0x0387,0x0388,
  0x0389,0x038a,0x038c,0x038e,0x038f,0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
  0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03aa,0x03ab,
  0x03ac,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,
  0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x03ca,0x03cb,
  0x03cc,0x03cd,0x03ce,0x03d1,0x03d5,0x03f0,0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,0x03f6,0x0400,0x0401,0x0402,0x0403,
  0x0404,0x0405,0x0406,0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,0x0411,0x0412,0x0413,
  0x0414,0x0415,0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,
  0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,0x0431,0x0432,0x0433,
  0x0434,0x0435,0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,
  0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x0450,0x0451,0x0452,0x0453,
  0x0454,0x0455,0x0456,0x0457,0x0458,0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0462,0x0463,0x046a,0x046b,
  0x0490,0x0491,0x0492,0x0493,0x0494,0x0495,0x0496,0x0497,0x0498,0x0499,0x049a,0x049b,0x049c,0x049d,0x04a0,0x04a1,
  0x04a2,0x04a3,0x04a4,0x04a5,0x04aa,0x04ab,0x04ae,0x04af,0x04b0,0x04b1,0x04b2,0x04b3,0x04b6,0x04b7,0x04b8,0x04b9,
  0x04ba,0x04bb,0x04c0,0x04c1,0x04c2,0x04cf,0x04d0,0x04d1,0x04d2,0x04d3,0x04d4,0x04d5,0x04d6,0x04d7,0x04d8,0x04d9,
  0x04da,0x04db,0x04dc,0x04dd,0x04de,0x04df,0x04e2,0x04e3,0x04e4,0x04e5,0x04e6,0x04e7,0x04e8,0x04e9,0x04ea,0x04eb,
  0x04ec,0x04ed,0x04ee,0x04ef,0x04f0,0x04f1,0x04f2,0x04f3,0x04f4,0x04f5,0x04f8,0x04f9,0x05d0,0x05d1,0x05d2,0x05d3,
  0x05d4,0x05d5,0x05d6,0x05d7,0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,0x05e0,0x05e1,0x05e2,0x05e3,
  0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,0x05ea,0x1e0c,0x1e0d,0x1e34,0x1e35,0x1e36,0x1e37,0x1e40,0x1e41,0x1e42,
  0x1e43,0x1e44,0x1e45,0x1e46,0x1e47,0x1e6c,0x1e6d,0x1eb8,0x1eb9,0x1ebc,0x1ebd,0x1eca,0x1ecb,0x1ecc,0x1ecd,0x1ee4,
  0x1ee5,0x1ef8,0x1ef9,0x2000,0x2001,0x2002,0x2003,0x2004,0x2005,0x2006,0x2007,0x2008,0x2009,0x200a,0x200b,0x200c,
  0x200d,0x200e,0x200f,0x2010,0x2011,0x2012,0x2013,0x2014,0x2015,0x2016,0x2017,0x2018,0x2019,0x201a,0x201b,0x201c,
  0x201d,0x201e,0x201f,0x2020,0x2021,0x2022,0x2026,0x2030,0x2032,0x2033,0x2039,0x203a,0x203c,0x203e,0x2070,0x2071,
  0x2074,0x2075,0x2076,0x2077,0x2078,0x2079,0x207a,0x207b,0x207c,0x207d,0x207e,0x207f,0x2080,0x2081,0x2082,0x2083,
  0x2084,0x2085,0x2086,0x2087,0x2088,0x2089,0x208a,0x208b,0x208c,0x208d,0x208e,0x2090,0x2091,0x2092,0x2093,0x2094,
  0x2095,0x2096,0x2097,0x2098,0x209a,0x20a7,0x20aa,0x20ac,0x20ae,0x2102,0x210e,0x210f,0x2115,0x2116,0x211a,0x211d,
  0x2122,0x2124,0x2126,0x2135,0x2190,0x2191,0x2192,0x2193,0x2194,0x2195,0x21a4,0x21a6,0x21a8,0x21b5,0x21bb,0x21cb,
  0x21cc,0x21d0,0x21d1,0x21d2,0x21d3,0x21d4,0x21d5,0x2200,0x2203,0x2204,0x2205,0x2206,0x2207,0x2208,0x2209,0x220a,
  0x220b,0x220c,0x220d,0x2212,0x2213,0x2214,0x2215,0x2216,0x2219,0x221a,0x221e,0x221f,0x2225,0x2227,0x2228,0x2229,
  0x222a,0x2248,0x2260,0x2261,0x2264,0x2265,0x226a,0x226b,0x2282,0x2283,0x2286,0x2287,0x22a5,0x22c2,0x22c3,0x2300,
  0x2302,0x2308,0x2309,0x230a,0x230b,0x2310,0x2319,0x2320,0x2321,0x239b,0x239c,0x239d,0x239e,0x239f,0x23a0,0x23a1,
  0x23a2,0x23a3,0x23a4,0x23a5,0x23a6,0x23a7,0x23a8,0x23a9,0x23ab,0x23ac,0x23ad,0x23ae,0x23af,0x23ba,0x23bb,0x23bc,
  0x23bd,0x23d0,0x2409,0x240a,0x240b,0x240c,0x240d,0x2424,0x2500,0x2501,0x2502,0x2503,0x2508,0x2509,0x250a,0x250b,
  0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513,0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251a,0x251b,
  0x251c,0x251d,0x251e,0x251f,0x2520,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252a,0x252b,
  0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b,
  0x253c,0x253d,0x253e,0x253f,0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254a,0x254b,
  0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f,
  0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f,
  0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2577,0x2578,0x2579,0x257a,0x257b,0x257c,0x257d,0x257e,0x257f,
  0x2580,0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,0x258e,0x258f,
  0x2590,0x2591,0x2592,0x2593,0x2596,0x2597,0x2598,0x2599,0x259a,0x259b,0x259c,0x259d,0x259e,0x259f,0x25a0,0x25ac,
  0x25ae,0x25b2,0x25b6,0x25ba,0x25bc,0x25c0,0x25c4,0x25c6,0x25ca,0x25cb,0x25cf,0x25d8,0x25d9,0x263a,0x263b,0x263c,
  0x2640,0x2642,0x2660,0x2663,0x2665,0x2666,0x266a,0x266b,0x2713,0x2714,0x2717,0x2718,0x27e8,0x27e9,0x27ea,0x27eb,
  0x2800,0x2801,0x2802,0x2803,0x2804,0x2805,0x2806,0x2807,0x2808,0x2809,0x280a,0x280b,0x280c,0x280d,0x280e,0x280f,
  0x2810,0x2811,0x2812,0x2813,0x2814,0x2815,0x2816,0x2817,0x2818,0x2819,0x281a,0x281b,0x281c,0x281d,0x281e,0x281f,
  0x2820,0x2821,0x2822,0x2823,0x2824,0x2825,0x2826,0x2827,0x2828,0x2829,0x282a,0x282b,0x282c,0x282d,0x282e,0x282f,
  0x2830,0x2831,0x2832,0x2833,0x2834,0x2835,0x2836,0x2837,0x2838,0x2839,0x283a,0x283b,0x283c,0x283d,0x283e,0x283f,
  0x2840,0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847,0x2848,0x2849,0x284a,0x284b,0x284c,0x284d,0x284e,0x284f,
  0x2850,0x2851,0x2852,0x2853,0x2854,0x2855,0x2856,0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e,0x285f,
  0x2860,0x2861,0x2862,0x2863,0x2864,0x2865,0x2866,0x2867,0x2868,0x2869,0x286a,0x286b,0x286c,0x286d,0x286e,0x286f,
  0x2870,0x2871,0x2872,0x2873,0x2874,0x2875,0x2876,0x2877,0x2878,0x2879,0x287a,0x287b,0x287c,0x287d,0x287e,0x287f,
  0x2880,0x2881,0x2882,0x2883,0x2884,0x2885,0x2886,0x2887,0x2888,0x2889,0x288a,0x288b,0x288c,0x288d,0x288e,0x288f,
  0x2890,0x2891,0x2892,0x2893,0x2894,0x2895,0x2896,0x2897,0x2898,0x2899,0x289a,0x289b,0x289c,0x289d,0x289e,0x289f,
  0x28a0,0x28a1,0x28a2,0x28a3,0x28a4,0x28a5,0x28a6,0x28a7,0x28a8,0x28a9,0x28aa,0x28ab,0x28ac,0x28ad,0x28ae,0x28af,
  0x28b0,0x28b1,0x28b2,0x28b3,0x28b4,0x28b5,0x28b6,0x28b7,0x28b8,0x28b9,0x28ba,0x28bb,0x28bc,0x28bd,0x28be,0x28bf,
  0x28c0,0x28c1,0x28c2,0x28c3,0x28c4,0x28c5,0x28c6,0x28c7,0x28c8,0x28c9,0x28ca,0x28cb,0x28cc,0x28cd,0x28ce,0x28cf,
  0x28d0,0x28d1,0x28d2,0x28d3,0x28d4,0x28d5,0x28d6,0x28d7,0x28d8,0x28d9,0x28da,0x28db,0x28dc,0x28dd,0x28de,0x28df,
  0x28e0,0x28e1,0x28e2,0x28e3,0x28e4,0x28e5,0x28e6,0x28e7,0x28e8,0x28e9,0x28ea,0x28eb,0x28ec,0x28ed,0x28ee,0x28ef,
  0x28f0,0x28f1,0x28f2,0x28f3,0x28f4,0x28f5,0x28f6,0x28f7,0x28f8,0x28f9,0x28fa,0x28fb,0x28fc,0x28fd,0x28fe,0x28ff,
  0x2e2c,0xe0a0,0xe0a1,0xe0a2,0xe0b0,0xe0b1,0xe0b2,0xe0b3,0xf6be,0xfffd };
} // namespace
// -- end of autogenerated text ---

namespace fixed_font_12b {
  // -- start of autogenerated text ---
  // definition section for font: ter-u12b.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 6;
  constexpr int HEIGHT = 12;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u12b.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    true // bold
  };
  // font bitmap definitions
  // same as 12n!
  // codepoints array
  // same as 12n!
} // namespace
// -- end of autogenerated text ---

namespace fixed_font_14n {
  // -- start of autogenerated text ---
  // definition section for font: ter-u14n.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 8;
  constexpr int HEIGHT = 14;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u14n.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    false // bold
  };
  // font bitmap definitions
  constexpr std::array<uint16_t, CHARCOUNT * HEIGHT> fixedfont_bitmap = {
  0x0000,0x0000,0x6600,0x4200,0x0000,0x4200,0x4200,0x4200,0x0000,0x4200,0x4200,0x6600,0x0000,0x0000, // u0000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0020
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x0000,0x0000, // u0021
  0x0000,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0022
  0x0000,0x0000,0x2400,0x2400,0x2400,0x7e00,0x2400,0x2400,0x7e00,0x2400,0x2400,0x2400,0x0000,0x0000, // u0023
  0x0000,0x1000,0x1000,0x7c00,0x9200,0x9000,0x9000,0x7c00,0x1200,0x1200,0x9200,0x7c00,0x1000,0x1000, // u0024
  0x0000,0x0000,0x6400,0x9400,0x6800,0x0800,0x1000,0x1000,0x2000,0x2c00,0x5200,0x4c00,0x0000,0x0000, // u0025
  0x0000,0x0000,0x1800,0x2400,0x2400,0x1800,0x3000,0x4a00,0x4400,0x4400,0x4400,0x3a00,0x0000,0x0000, // u0026
  0x0000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0027
  0x0000,0x0000,0x0800,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x0800,0x0000,0x0000, // u0028
  0x0000,0x0000,0x2000,0x1000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1000,0x2000,0x0000,0x0000, // u0029
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x1800,0x7e00,0x1800,0x2400,0x0000,0x0000,0x0000,0x0000, // u002a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u002b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2000,0x0000, // u002c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000, // u002e
  0x0000,0x0000,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x4000,0x0000,0x0000, // u002f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0030
  0x0000,0x0000,0x0800,0x1800,0x2800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3e00,0x0000,0x0000, // u0031
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000, // u0032
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0033
  0x0000,0x0000,0x0200,0x0600,0x0a00,0x1200,0x2200,0x4200,0x7e00,0x0200,0x0200,0x0200,0x0000,0x0000, // u0034
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7c00,0x0200,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u0035
  0x0000,0x0000,0x1c00,0x2000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0036
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x1000,0x0000,0x0000, // u0037
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x3c00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0038
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0400,0x3800,0x0000,0x0000, // u0039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000, // u003a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2000,0x0000, // u003b
  0x0000,0x0000,0x0000,0x0400,0x0800,0x1000,0x2000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0000,0x0000, // u003c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u003d
  0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0800,0x1000,0x2000,0x4000,0x0000,0x0000, // u003e
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x0400,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000, // u003f
  0x0000,0x0000,0x7c00,0x8200,0x9e00,0xa200,0xa200,0xa200,0xa600,0x9a00,0x8000,0x7e00,0x0000,0x0000, // u0040
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0041
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0042
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0043
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000, // u0044
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0045
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0046
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0047
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0048
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0049
  0x0000,0x0000,0x0e00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000,0x0000, // u004a
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u004b
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u004c
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000, // u004d
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000, // u004e
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u004f
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0050
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4a00,0x3c00,0x0200,0x0000, // u0051
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u0052
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0053
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0054
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0055
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x2400,0x1800,0x1800,0x0000,0x0000, // u0056
  0x0000,0x0000,0x8200,0x8200,0x8200,0x8200,0x8200,0x9200,0x9200,0xaa00,0xc600,0x8200,0x0000,0x0000, // u0057
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000,0x0000, // u0058
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0059
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u005a
  0x0000,0x0000,0x3800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3800,0x0000,0x0000, // u005b
  0x0000,0x0000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0000,0x0000, // u005c
  0x0000,0x0000,0x3800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3800,0x0000,0x0000, // u005d
  0x0000,0x1000,0x2800,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u005e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000, // u005f
  0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0060
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0061
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0062
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u0063
  0x0000,0x0000,0x0200,0x0200,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0064
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0065
  0x0000,0x0000,0x0e00,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0066
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0067
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0068
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0069
  0x0000,0x0000,0x0400,0x0400,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // u006a
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u006b
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u006c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000, // u006d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u006e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u006f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000, // u0070
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200, // u0071
  0x0000,0x0000,0x0000,0x0000,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0072
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000, // u0073
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0000, // u0074
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0075
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x0000,0x0000, // u0076
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x0000,0x0000, // u0077
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x1800,0x2400,0x4200,0x4200,0x0000,0x0000, // u0078
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0079
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000, // u007a
  0x0000,0x0000,0x0c00,0x1000,0x1000,0x1000,0x2000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000, // u007b
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u007c
  0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0400,0x0800,0x0800,0x0800,0x0800,0x3000,0x0000,0x0000, // u007d
  0x0000,0x6200,0x9200,0x8c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u007e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a0
  0x0000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u00a1
  0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x9200,0x9000,0x9000,0x9000,0x9200,0x7c00,0x1000,0x1000, // u00a2
  0x0000,0x0000,0x1800,0x2400,0x2000,0x2000,0x7800,0x2000,0x2000,0x2000,0x2200,0x7e00,0x0000,0x0000, // u00a3
  0x0000,0x0000,0x0000,0x0000,0x4400,0x3800,0x4400,0x4400,0x4400,0x3800,0x4400,0x0000,0x0000,0x0000, // u00a4
  0x0000,0x0000,0x8200,0x8200,0x4400,0x2800,0x1000,0x7c00,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000, // u00a5
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u00a6
  0x0000,0x3800,0x4400,0x4000,0x3000,0x4800,0x4400,0x4400,0x2400,0x1800,0x0400,0x4400,0x3800,0x0000, // u00a7
  0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a8
  0x0000,0x0000,0x0000,0x7e00,0x8100,0x9900,0xa500,0xa100,0xa500,0x9900,0x8100,0x7e00,0x0000,0x0000, // u00a9
  0x0000,0x3800,0x0400,0x3c00,0x4400,0x3c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1200,0x2400,0x4800,0x9000,0x4800,0x2400,0x1200,0x0000,0x0000, // u00ab
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ac
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ad
  0x0000,0x0000,0x0000,0x7e00,0x8100,0xb900,0xa500,0xb900,0xa900,0xa500,0x8100,0x7e00,0x0000,0x0000, // u00ae
  0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00af
  0x0000,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x7c00,0x0000,0x0000, // u00b1
  0x0000,0x1800,0x2400,0x0400,0x0800,0x1000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b2
  0x0000,0x3800,0x0400,0x1800,0x0400,0x0400,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b3
  0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4600,0x7a00,0x4000,0x4000, // u00b5
  0x0000,0x0000,0x7e00,0x9200,0x9200,0x9200,0x9200,0x7200,0x1200,0x1200,0x1200,0x1200,0x0000,0x0000, // u00b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2000, // u00b8
  0x0000,0x1000,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b9
  0x0000,0x3800,0x4400,0x4400,0x4400,0x3800,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9000,0x4800,0x2400,0x1200,0x2400,0x4800,0x9000,0x0000,0x0000, // u00bb
  0x2000,0x6000,0x2000,0x2200,0x2400,0x0800,0x1000,0x2200,0x4600,0x8a00,0x1e00,0x0200,0x0200,0x0000, // u00bc
  0x2000,0x6000,0x2000,0x2200,0x2400,0x0800,0x1000,0x2000,0x4c00,0x9200,0x0400,0x0800,0x1e00,0x0000, // u00bd
  0xe000,0x1000,0x6000,0x1200,0xe400,0x0800,0x1000,0x2200,0x4600,0x8a00,0x1e00,0x0200,0x0200,0x0000, // u00be
  0x0000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x2000,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00bf
  0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00c0
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00c1
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00c2
  0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00c3
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00c4
  0x1800,0x2400,0x1800,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00c5
  0x0000,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000, // u00c6
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x1000,0x2000, // u00c7
  0x1000,0x0800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u00c8
  0x0800,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u00c9
  0x1800,0x2400,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u00ca
  0x2400,0x2400,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u00cb
  0x2000,0x1000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00cc
  0x0800,0x1000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00cd
  0x1800,0x2400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00ce
  0x4400,0x4400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00cf
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0xf200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000, // u00d0
  0x3200,0x4c00,0x0000,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000, // u00d1
  0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00d2
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00d3
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00d4
  0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00d5
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00d6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x2400,0x1800,0x1800,0x2400,0x4200,0x0000,0x0000,0x0000, // u00d7
  0x0000,0x0000,0x3c00,0x4300,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0xc200,0x3c00,0x0000,0x0000, // u00d8
  0x1000,0x0800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00d9
  0x0800,0x1000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00da
  0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00db
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00dc
  0x0800,0x1000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u00dd
  0x0000,0x0000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x0000,0x0000, // u00de
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4800,0x7c00,0x4200,0x4200,0x4200,0x6200,0x5c00,0x0000,0x0000, // u00df
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00e0
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00e1
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00e2
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00e3
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00e4
  0x0000,0x0000,0x1800,0x2400,0x1800,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000, // u00e6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x1000,0x2000, // u00e7
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u00e8
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u00e9
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u00ea
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u00eb
  0x0000,0x0000,0x2000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00ec
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00ed
  0x0000,0x0000,0x3000,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00ee
  0x0000,0x0000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u00ef
  0x0000,0x0000,0x2800,0x1000,0x2800,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00f0
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u00f1
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00f2
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00f3
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00f4
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00f5
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u00f6
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x7c00,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000, // u00f7
  0x0000,0x0000,0x0000,0x0000,0x0200,0x3c00,0x4600,0x4a00,0x5200,0x6200,0x4200,0xbc00,0x0000,0x0000, // u00f8
  0x0000,0x0000,0x1000,0x0800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00f9
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00fa
  0x0000,0x0000,0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00fb
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u00fc
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u00fd
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000, // u00fe
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u00ff
  0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0100
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0101
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0102
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0103
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0400,0x0300, // u0104
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0400,0x0300, // u0105
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0106
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u0107
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0108
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u0109
  0x1000,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u010a
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u010b
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u010c
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u010d
  0x2400,0x1800,0x0000,0x7800,0x4400,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000, // u010e
  0x2400,0x1800,0x0200,0x0200,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u010f
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0xf200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000, // u0110
  0x0000,0x0000,0x0200,0x0f00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0111
  0x3c00,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0112
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0113
  0x2400,0x1800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0114
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0115
  0x1000,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0116
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0117
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0400,0x0300, // u0118
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0800,0x0600, // u0119
  0x2400,0x1800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u011a
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u011b
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u011c
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u011d
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u011e
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u011f
  0x1000,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0120
  0x0000,0x0000,0x0800,0x0800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0121
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x1000,0x2000, // u0122
  0x0000,0x0400,0x0800,0x0800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0123
  0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0124
  0x0c00,0x1200,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0125
  0x0000,0x0000,0x4200,0xff00,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0126
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0127
  0x3200,0x4c00,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0128
  0x0000,0x0000,0x3400,0x5800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0129
  0x7c00,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u012a
  0x0000,0x0000,0x0000,0x7800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u012b
  0x2400,0x1800,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u012c
  0x0000,0x0000,0x4800,0x3000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u012d
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x0c00, // u012e
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x0c00, // u012f
  0x1000,0x1000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0130
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0131
  0x0000,0x0000,0xe700,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x5200,0x5200,0xec00,0x0000,0x0000, // u0132
  0x0000,0x0000,0x4200,0x4200,0x0000,0xc600,0x4200,0x4200,0x4200,0x4200,0x4200,0xf200,0x1200,0x0c00, // u0133
  0x0c00,0x1200,0x0000,0x0e00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000,0x0000, // u0134
  0x0000,0x0000,0x0c00,0x1200,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // u0135
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x5200,0x1000,0x2000, // u0136
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x5200,0x1000,0x2000, // u0137
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u0138
  0x2000,0x4000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0139
  0x0800,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u013a
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x1000,0x2000, // u013b
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x2000, // u013c
  0x2400,0x1800,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u013d
  0x4800,0x3000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u013e
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4400,0x4400,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u013f
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1100,0x1100,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0140
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x6000,0xc000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0141
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1800,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0142
  0x0800,0x1000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000, // u0143
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0144
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x5200,0x1000,0x2000, // u0145
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x5200,0x1000,0x2000, // u0146
  0x2400,0x1800,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000, // u0147
  0x0000,0x0000,0x2400,0x1800,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0148
  0x0000,0x4000,0x4000,0x8000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0149
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0200,0x0c00, // u014a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0c00, // u014b
  0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u014c
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u014d
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u014e
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u014f
  0x1200,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0150
  0x0000,0x0000,0x1200,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0151
  0x0000,0x0000,0x7e00,0x9000,0x9000,0x9000,0x9c00,0x9000,0x9000,0x9000,0x9000,0x7e00,0x0000,0x0000, // u0152
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x9200,0x9200,0x9e00,0x9000,0x9000,0x7c00,0x0000,0x0000, // u0153
  0x0800,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u0154
  0x0000,0x0000,0x0800,0x1000,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0155
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x5200,0x1000,0x2000, // u0156
  0x0000,0x0000,0x0000,0x0000,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x6000,0x2000,0x4000, // u0157
  0x2400,0x1800,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u0158
  0x0000,0x0000,0x2400,0x1800,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0159
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u015a
  0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000, // u015b
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u015c
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000, // u015d
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x1000,0x2000, // u015e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x1000,0x2000, // u015f
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u0160
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000, // u0161
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1800,0x0800,0x1000, // u0162
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0400,0x0800, // u0163
  0x2400,0x1800,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0164
  0x2400,0x1800,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0000, // u0165
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0166
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x3800,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0000, // u0167
  0x3200,0x4c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0168
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0169
  0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u016a
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u016b
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u016c
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u016d
  0x1800,0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u016e
  0x0000,0x0000,0x1800,0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u016f
  0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0170
  0x0000,0x0000,0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0171
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x0600, // u0172
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0400,0x0300, // u0173
  0x1800,0x2400,0x0000,0x8200,0x8200,0x8200,0x8200,0x9200,0x9200,0xaa00,0xc600,0x8200,0x0000,0x0000, // u0174
  0x0000,0x0000,0x1800,0x2400,0x0000,0x8200,0x8200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x0000,0x0000, // u0175
  0x1800,0x2400,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0176
  0x0000,0x0000,0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0177
  0x4400,0x4400,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0178
  0x0800,0x1000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0179
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000, // u017a
  0x1000,0x1000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u017b
  0x0000,0x0000,0x1000,0x1000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000, // u017c
  0x2400,0x1800,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u017d
  0x0000,0x0000,0x2400,0x1800,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000, // u017e
  0x0000,0x0000,0x0e00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u017f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x0200,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0186
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0200,0x1e00,0x0200,0x0200,0x0200,0x0200,0x7e00,0x0000,0x0000, // u018e
  0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u018f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x3800,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0190
  0x0000,0x0000,0x0c00,0x1200,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x9000,0x6000, // u0192
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x4000,0x8000, // u019d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200, // u019e
  0x0000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x7e00,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u01b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0400,0x0800,0x7c00,0x1000,0x2000,0x7e00,0x0000,0x0000, // u01b6
  0x0000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01b7
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u01cd
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u01ce
  0x2400,0x1800,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u01cf
  0x0000,0x0000,0x4800,0x3000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u01d0
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01d1
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01d2
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01d3
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u01d4
  0x7c00,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000, // u01e2
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000, // u01e3
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4f00,0x4200,0x3c00,0x0000,0x0000, // u01e4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4f00,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u01e5
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01e6
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u01e7
  0x2400,0x1800,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u01e8
  0x2400,0x1800,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u01e9
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x0600, // u01ea
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x0600, // u01eb
  0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x0600, // u01ec
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x0600, // u01ed
  0x2400,0x1800,0x0000,0x7e00,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01ee
  0x0000,0x0000,0x2400,0x1800,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x3c00, // u01ef
  0x0000,0x0000,0x1200,0x0c00,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // u01f0
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u01f4
  0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u01f5
  0x0800,0x1000,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000, // u01fc
  0x0000,0x0000,0x0800,0x1000,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000, // u01fd
  0x0800,0x1000,0x0000,0x3d00,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0xc200,0x3c00,0x0000,0x0000, // u01fe
  0x0000,0x0000,0x0800,0x1000,0x0200,0x3c00,0x4600,0x4a00,0x5200,0x6200,0x4200,0xbc00,0x0000,0x0000, // u01ff
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x1000,0x2000, // u0218
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x1000,0x2000, // u0219
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1800,0x0800,0x1000, // u021a
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0200,0x0400, // u021b
  0x7c00,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0232
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0233
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // u0237
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u0254
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x0200,0x0200,0x3c00,0x0000,0x0000, // u0258
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0259
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x3800,0x4000,0x4200,0x3c00,0x0000,0x0000, // u025b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4000,0x8000, // u0272
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x3c00, // u0292
  0x0800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bb
  0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bc
  0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bd
  0x1800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c6
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c7
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d8
  0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0800,0x0600, // u02db
  0x3200,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dc
  0x1200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dd
  0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0300
  0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0301
  0x1800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0302
  0x3200,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0303
  0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0304
  0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0305
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0306
  0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0307
  0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0308
  0x1800,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030a
  0x1200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030b
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000, // u0329
  0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0384
  0x0800,0x1000,0x0000,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0385
  0x4000,0x8000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0386
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0387
  0x4000,0x8000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0388
  0x4000,0x8000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0389
  0x4000,0x8000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u038a
  0x4000,0x8000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u038c
  0x4000,0x8000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u038e
  0x4000,0x8000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x6600,0x0000,0x0000, // u038f
  0x0800,0x1000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000, // u0390
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0391
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0392
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0393
  0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x4400,0x8200,0x8200,0xfe00,0x0000,0x0000, // u0394
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0395
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0396
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0397
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x5a00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0398
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0399
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u039a
  0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x4400,0x8200,0x8200,0x8200,0x0000,0x0000, // u039b
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000, // u039c
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000, // u039d
  0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000, // u039e
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u039f
  0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u03a0
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u03a1
  0x0000,0x0000,0x7e00,0x4000,0x2000,0x1000,0x0800,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000, // u03a3
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u03a4
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u03a5
  0x0000,0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000,0x0000, // u03a6
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000,0x0000, // u03a7
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x1000,0x0000,0x0000, // u03a8
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x6600,0x0000,0x0000, // u03a9
  0x4400,0x4400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u03aa
  0x4400,0x4400,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u03ab
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3a00,0x4600,0x4400,0x4400,0x4400,0x4600,0x3a00,0x0000,0x0000, // u03ac
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x3800,0x4000,0x4200,0x3c00,0x0000,0x0000, // u03ad
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200, // u03ae
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000, // u03af
  0x0800,0x1000,0x0000,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3a00,0x4600,0x4400,0x4400,0x4400,0x4600,0x3a00,0x0000,0x0000, // u03b1
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4800,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000, // u03b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x1000, // u03b3
  0x0000,0x0000,0x3e00,0x1000,0x0800,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x3800,0x4000,0x4200,0x3c00,0x0000,0x0000, // u03b5
  0x0000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x4000,0x3c00,0x0200,0x0400, // u03b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200, // u03b7
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x4400,0x3800,0x0000,0x0000, // u03b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000, // u03b9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u03ba
  0x0000,0x0000,0x2000,0x2000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x8200,0x8200,0x0000,0x0000, // u03bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4600,0x7a00,0x4000,0x4000, // u03bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x0000,0x0000, // u03bd
  0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x3c00,0x4000,0x4000,0x4000,0x4000,0x3c00,0x0200,0x0400, // u03be
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u03c0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000, // u03c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4000,0x3c00,0x0200,0x0400, // u03c2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4400,0x4400,0x4400,0x4400,0x4400,0x3800,0x0000,0x0000, // u03c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000, // u03c4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x1000, // u03c6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x2400,0x2400,0x4200,0x4200, // u03c7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x1000, // u03c8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x8200,0x9200,0x9200,0x9200,0x9200,0x6c00,0x0000,0x0000, // u03c9
  0x0000,0x0000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000, // u03ca
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03cb
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03cc
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03cd
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4400,0x8200,0x9200,0x9200,0x9200,0x9200,0x6c00,0x0000,0x0000, // u03ce
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4400,0x3e00,0x0400,0xc400,0x4400,0x4400,0x3800,0x0000,0x0000, // u03d1
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000, // u03d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc200,0x2400,0x1800,0x1000,0x3000,0x4800,0x8600,0x0000,0x0000, // u03f0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x3c00, // u03f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u03f2
  0x0000,0x0000,0x0400,0x0400,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // u03f3
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u03f4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x7c00,0x4000,0x2000,0x1e00,0x0000,0x0000, // u03f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x3e00,0x0200,0x0400,0x7800,0x0000,0x0000, // u03f6
  0x1000,0x0800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0400
  0x2400,0x2400,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0401
  0x0000,0x0000,0xf800,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x2400,0x0000,0x0000, // u0402
  0x0800,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0403
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u0404
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0405
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0406
  0x4400,0x4400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0407
  0x0000,0x0000,0x0e00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000,0x0000, // u0408
  0x0000,0x0000,0x3000,0x5000,0x9000,0x9c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9c00,0x0000,0x0000, // u0409
  0x0000,0x0000,0x9000,0x9000,0x9000,0x9c00,0xf200,0x9200,0x9200,0x9200,0x9200,0x9c00,0x0000,0x0000, // u040a
  0x0000,0x0000,0xf800,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x0000,0x0000, // u040b
  0x0800,0x1000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u040c
  0x1000,0x0800,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000, // u040d
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000, // u040e
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x1800,0x1800, // u040f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0410
  0x0000,0x0000,0x7c00,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0411
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0412
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0413
  0x0000,0x0000,0x3c00,0x4400,0x4400,0x4400,0x4400,0x4400,0x4400,0x4400,0x4400,0xfe00,0x8200,0x0000, // u0414
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u0415
  0x0000,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000, // u0416
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0417
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0418
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000, // u0419
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u041a
  0x0000,0x0000,0x0e00,0x1200,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x4200,0x0000,0x0000, // u041b
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000, // u041c
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u041d
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u041e
  0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u041f
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0420
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000, // u0421
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0422
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000, // u0423
  0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000, // u0424
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000,0x0000, // u0425
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3f00,0x0100,0x0100, // u0426
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000, // u0427
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7e00,0x0000,0x0000, // u0428
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7f00,0x0100,0x0100, // u0429
  0x0000,0x0000,0xc000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u042a
  0x0000,0x0000,0x8200,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000, // u042b
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u042c
  0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x1e00,0x0200,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u042d
  0x0000,0x0000,0x8c00,0x9200,0x9200,0x9200,0x9200,0xf200,0x9200,0x9200,0x9200,0x8c00,0x0000,0x0000, // u042e
  0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0a00,0x1200,0x2200,0x4200,0x0000,0x0000, // u042f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0430
  0x0000,0x0000,0x3c00,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0431
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4800,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0432
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0433
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0434
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0435
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000, // u0436
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x1c00,0x0200,0x4200,0x3c00,0x0000,0x0000, // u0437
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0438
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u0439
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u043a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1e00,0x2200,0x2200,0x2200,0x2200,0x2200,0x4200,0x0000,0x0000, // u043b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x8200,0x8200,0x8200,0x0000,0x0000, // u043c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x0000,0x0000, // u043d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u043e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u043f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000, // u0440
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000, // u0441
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u0442
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u0443
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000, // u0444
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x1800,0x2400,0x4200,0x4200,0x0000,0x0000, // u0445
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3f00,0x0100,0x0100, // u0446
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0000,0x0000, // u0447
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7e00,0x0000,0x0000, // u0448
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7f00,0x0100,0x0100, // u0449
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x3c00,0x0000,0x0000, // u044a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000, // u044b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x7800,0x4400,0x4400,0x4400,0x7800,0x0000,0x0000, // u044c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x1e00,0x0200,0x4200,0x3c00,0x0000,0x0000, // u044d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8c00,0x9200,0x9200,0xf200,0x9200,0x9200,0x8c00,0x0000,0x0000, // u044e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x3e00,0x1200,0x2200,0x4200,0x0000,0x0000, // u044f
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0450
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u0451
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0c00, // u0452
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0453
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x7800,0x4000,0x4200,0x3c00,0x0000,0x0000, // u0454
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000, // u0455
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0456
  0x0000,0x0000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u0457
  0x0000,0x0000,0x0400,0x0400,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // u0458
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x9000,0x9c00,0x9200,0x9200,0x9200,0x9c00,0x0000,0x0000, // u0459
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9000,0x9000,0x9c00,0xf200,0x9200,0x9200,0x9c00,0x0000,0x0000, // u045a
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u045b
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u045c
  0x0000,0x0000,0x1000,0x0800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u045d
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u045e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x1800,0x1800, // u045f
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000, // u0462
  0x0000,0x0000,0x2000,0x2000,0x7800,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x3c00,0x0000,0x0000, // u0463
  0x0000,0x0000,0xfe00,0x8200,0x4400,0x2800,0x3800,0x5400,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000, // u046a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x4400,0x2800,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000, // u046b
  0x0200,0x0200,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0490
  0x0000,0x0000,0x0000,0x0200,0x0200,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0491
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0xf800,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000, // u0492
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0xf800,0x4000,0x4000,0x4000,0x0000,0x0000, // u0493
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x0200,0x0400, // u0494
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x7800,0x4400,0x4400,0x4400,0x0400,0x0800, // u0495
  0x0000,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x9300,0x0100,0x0100, // u0496
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9300,0x0100,0x0100, // u0497
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x1000,0x1000, // u0498
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x1c00,0x0200,0x4200,0x3c00,0x1000,0x1000, // u0499
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4300,0x0100,0x0100, // u049a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4300,0x0100,0x0100, // u049b
  0x0000,0x0000,0x4200,0x4200,0x5400,0x5800,0x7000,0x7000,0x5800,0x5400,0x4200,0x4200,0x0000,0x0000, // u049c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x5400,0x5800,0x7000,0x5800,0x5400,0x4200,0x0000,0x0000, // u049d
  0x0000,0x0000,0xc200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000, // u04a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000, // u04a1
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4300,0x0100,0x0100, // u04a2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4300,0x0100,0x0100, // u04a3
  0x0000,0x0000,0x4700,0x4400,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x4400,0x4400,0x0000,0x0000, // u04a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4700,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x0000,0x0000, // u04a5
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x1000,0x1000, // u04aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x1000,0x1000, // u04ab
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u04ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x1000, // u04af
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x7c00,0x1000,0x1000,0x1000,0x0000,0x0000, // u04b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x7c00,0x1000, // u04b1
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4300,0x0100,0x0100, // u04b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x1800,0x2400,0x4200,0x4300,0x0100,0x0100, // u04b3
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0300,0x0100,0x0100, // u04b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0300,0x0100,0x0100, // u04b7
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4a00,0x4a00,0x3e00,0x0a00,0x0a00,0x0200,0x0200,0x0000,0x0000, // u04b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4a00,0x4a00,0x3e00,0x0a00,0x0200,0x0200,0x0000,0x0000, // u04b9
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u04ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u04bb
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u04c0
  0x2400,0x1800,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x0000,0x0000, // u04c1
  0x0000,0x0000,0x2400,0x1800,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000, // u04c2
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u04cf
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u04d0
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u04d1
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u04d2
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u04d3
  0x0000,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000, // u04d4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000, // u04d5
  0x2400,0x1800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u04d6
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u04d7
  0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04d8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04d9
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x0200,0x7e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04da
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x0200,0x0200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04db
  0x4400,0x4400,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x0000,0x0000, // u04dc
  0x0000,0x0000,0x4400,0x4400,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000, // u04dd
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04de
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x1c00,0x0200,0x4200,0x3c00,0x0000,0x0000, // u04df
  0x3c00,0x0000,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000, // u04e2
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u04e3
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x0000,0x0000, // u04e4
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000, // u04e5
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04e6
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04e7
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04e8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04e9
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04ea
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000, // u04eb
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x0200,0x1e00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000, // u04ec
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x1e00,0x0200,0x4200,0x3c00,0x0000,0x0000, // u04ed
  0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000, // u04ee
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u04ef
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000, // u04f0
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u04f1
  0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000, // u04f2
  0x0000,0x0000,0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u04f3
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000, // u04f4
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0000,0x0000, // u04f5
  0x4800,0x4800,0x0000,0x8200,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000, // u04f8
  0x0000,0x0000,0x4800,0x4800,0x0000,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000, // u04f9
  0x0000,0x0000,0x4200,0x4200,0x2200,0x2200,0x1400,0x2800,0x4400,0x4400,0x4200,0x4200,0x0000,0x0000, // u05d0
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x7f00,0x0000,0x0000, // u05d1
  0x0000,0x0000,0x7000,0x0800,0x0800,0x0800,0x0800,0x0800,0x1400,0x2400,0x4200,0x8200,0x0000,0x0000, // u05d2
  0x0000,0x0000,0x7f00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000, // u05d3
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u05d4
  0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000, // u05d5
  0x0000,0x0000,0x7c00,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u05d6
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u05d7
  0x0000,0x0000,0x4c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u05d8
  0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u05d9
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200, // u05da
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x0000, // u05db
  0x4000,0x4000,0x7e00,0x0200,0x0200,0x0200,0x0200,0x0400,0x0800,0x1000,0x1000,0x1000,0x0000,0x0000, // u05dc
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x0000,0x0000, // u05dd
  0x0000,0x0000,0xdc00,0x6200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4e00,0x0000,0x0000, // u05de
  0x0000,0x0000,0x7000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000, // u05df
  0x0000,0x0000,0x3800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x3c00,0x0000,0x0000, // u05e0
  0x0000,0x0000,0xfc00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u05e1
  0x0000,0x0000,0x4200,0x4200,0x4200,0x2200,0x2200,0x2200,0x1400,0x1400,0x1800,0x6000,0x0000,0x0000, // u05e2
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x3200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200, // u05e3
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x3200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x0000, // u05e4
  0x0000,0x0000,0x4200,0x4200,0x2200,0x2400,0x1800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u05e5
  0x0000,0x0000,0x4200,0x4200,0x2200,0x2400,0x1800,0x1000,0x0800,0x0800,0x0400,0x7c00,0x0000,0x0000, // u05e6
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x4200,0x4200,0x4400,0x4800,0x4800,0x4800,0x4800,0x4000,0x4000, // u05e7
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000, // u05e8
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0xa200,0xc200,0x8200,0x8400,0xf800,0x0000,0x0000, // u05e9
  0x0000,0x0000,0xfc00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x8200,0x0000,0x0000, // u05ea
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x7800,0x1000,0x1000, // u1e0c
  0x0000,0x0000,0x0200,0x0200,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0800,0x0800, // u1e0d
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x3c00, // u1e34
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x3c00, // u1e35
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x1000,0x1000, // u1e36
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x1000, // u1e37
  0x1000,0x1000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000, // u1e40
  0x0000,0x0000,0x1000,0x1000,0x0000,0xfc00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000, // u1e41
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x1000,0x1000, // u1e42
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x0800,0x0800, // u1e43
  0x1000,0x1000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000, // u1e44
  0x0000,0x0000,0x1000,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u1e45
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x1000,0x1000, // u1e46
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x1000,0x1000, // u1e47
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0800, // u1e6c
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0400,0x0400, // u1e6d
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x1000,0x1000, // u1eb8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x1000,0x1000, // u1eb9
  0x3200,0x4c00,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000, // u1ebc
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000, // u1ebd
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x1000, // u1eca
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x1000, // u1ecb
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x1000,0x1000, // u1ecc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x1000,0x1000, // u1ecd
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x1000,0x1000, // u1ee4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0800,0x0800, // u1ee5
  0x6400,0x9800,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u1ef8
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x3c00, // u1ef9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2001
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2002
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2003
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2004
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2005
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2006
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2007
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2008
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2009
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2010
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2011
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2012
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2013
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2014
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2015
  0x0000,0x0000,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x0000,0x0000, // u2016
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x7e00, // u2017
  0x0000,0x0800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2018
  0x0000,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2019
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x1000,0x0000, // u201a
  0x0000,0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201b
  0x0000,0x1200,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201c
  0x0000,0x1200,0x1200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x2400,0x4800,0x0000, // u201e
  0x0000,0x4800,0x4800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201f
  0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u2020
  0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000, // u2021
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2022
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x0000,0x0000, // u2026
  0x0000,0x0000,0x4800,0xa800,0x5000,0x1000,0x2000,0x2000,0x4000,0x5400,0xaa00,0x9400,0x0000,0x0000, // u2030
  0x0000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2032
  0x0000,0x2400,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2033
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0800,0x1000,0x2000,0x1000,0x0800,0x0400,0x0000,0x0000, // u2039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0800,0x1000,0x2000,0x0000,0x0000, // u203a
  0x0000,0x0000,0x2400,0x2400,0x2400,0x2400,0x2400,0x2400,0x2400,0x0000,0x2400,0x2400,0x0000,0x0000, // u203c
  0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u203e
  0x0000,0x1800,0x2400,0x2400,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2070
  0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2071
  0x0000,0x0400,0x0c00,0x1400,0x3e00,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2074
  0x0000,0x3800,0x2000,0x3800,0x0400,0x0400,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2075
  0x0000,0x1800,0x2000,0x3800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2076
  0x0000,0x3c00,0x0400,0x0800,0x0800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2077
  0x0000,0x1800,0x2400,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2078
  0x0000,0x1800,0x2400,0x2400,0x1c00,0x0400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2079
  0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207a
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207b
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207c
  0x0000,0x0800,0x1000,0x1000,0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207d
  0x0000,0x1000,0x0800,0x0800,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207e
  0x0000,0x0000,0x3800,0x2400,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x2400,0x2400,0x1800,0x0000,0x0000, // u2080
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u2081
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x0400,0x0800,0x1000,0x3c00,0x0000,0x0000, // u2082
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x0400,0x1800,0x0400,0x0400,0x3800,0x0000,0x0000, // u2083
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0c00,0x1400,0x3e00,0x0400,0x0400,0x0000,0x0000, // u2084
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x2000,0x3800,0x0400,0x0400,0x3800,0x0000,0x0000, // u2085
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2000,0x3800,0x2400,0x2400,0x1800,0x0000,0x0000, // u2086
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0400,0x0800,0x0800,0x1000,0x1000,0x0000,0x0000, // u2087
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000, // u2088
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x1c00,0x0400,0x1800,0x0000,0x0000, // u2089
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000, // u208a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u208b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000, // u208c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1000,0x1000,0x1000,0x1000,0x0800,0x0000,0x0000, // u208d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x0800,0x0800,0x0800,0x0800,0x1000,0x0000,0x0000, // u208e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x0400,0x1c00,0x2400,0x1c00,0x0000,0x0000, // u2090
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x3c00,0x2000,0x1c00,0x0000,0x0000, // u2091
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x2400,0x1800,0x0000,0x0000, // u2092
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x2800,0x1000,0x2800,0x4400,0x0000,0x0000, // u2093
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x0400,0x3c00,0x2400,0x1800,0x0000,0x0000, // u2094
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x3800,0x2400,0x2400,0x2400,0x2400,0x0000,0x0000, // u2095
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x2400,0x2800,0x3000,0x2800,0x2400,0x0000,0x0000, // u2096
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000, // u2097
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x5400,0x5400,0x5400,0x5400,0x0000,0x0000, // u2098
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x2400,0x2400,0x2400,0x3800,0x2000,0x2000, // u209a
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf400,0x8400,0x8e00,0x8400,0x8400,0x8200,0x0000,0x0000, // u20a7
  0x0000,0x0000,0xf200,0x8a00,0x8a00,0xaa00,0xaa00,0xaa00,0xaa00,0xa200,0xa200,0xbc00,0x0000,0x0000, // u20aa
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x4000,0xf800,0x4000,0xf800,0x4000,0x2200,0x1c00,0x0000,0x0000, // u20ac
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1c00,0x7000,0x1c00,0x7000,0x1000,0x1000,0x1000,0x0000,0x0000, // u20ae
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5000,0x5000,0x5000,0x5000,0x5200,0x5200,0x3c00,0x0000,0x0000, // u2102
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u210e
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u210f
  0x0000,0x0000,0x4200,0x4200,0x6200,0x5200,0x6a00,0x5600,0x4a00,0x4600,0x4200,0x4200,0x0000,0x0000, // u2115
  0x0000,0x0000,0x9600,0x9600,0x9600,0xd000,0xf000,0xf000,0xb000,0x9600,0x9000,0x9600,0x0000,0x0000, // u2116
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5a00,0x3c00,0x0600,0x0000, // u211a
  0x0000,0x0000,0xf800,0xa400,0xa400,0xa400,0xa400,0xb800,0xa800,0xb400,0xaa00,0xe600,0x0000,0x0000, // u211d
  0x0000,0x0000,0xfb00,0x5500,0x5500,0x5100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2122
  0x0000,0x0000,0x7e00,0x0200,0x0600,0x0a00,0x1400,0x2800,0x5000,0x6000,0x4000,0x7e00,0x0000,0x0000, // u2124
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x6600,0x0000,0x0000, // u2126
  0x0000,0x0000,0x4400,0x4400,0x2200,0x2200,0x3400,0x5800,0x8800,0x8800,0x8400,0x4400,0x0000,0x0000, // u2135
  0x0000,0x0000,0x0000,0x0000,0x2000,0x4000,0xfe00,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2190
  0x0000,0x0000,0x1000,0x3800,0x5400,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000, // u2191
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0400,0xfe00,0x0400,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2192
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x5400,0x3800,0x1000,0x0000,0x0000, // u2193
  0x0000,0x0000,0x0000,0x0000,0x2400,0x4200,0xff00,0x4200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2194
  0x0000,0x0000,0x1000,0x3800,0x5400,0x1000,0x1000,0x1000,0x1000,0x5400,0x3800,0x1000,0x0000,0x0000, // u2195
  0x0000,0x0000,0x0000,0x0000,0x2200,0x4200,0xfe00,0x4200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000, // u21a4
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8400,0xfe00,0x8400,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000, // u21a6
  0x0000,0x0000,0x1000,0x3800,0x5400,0x1000,0x1000,0x1000,0x5400,0x3800,0x1000,0x7c00,0x0000,0x0000, // u21a8
  0x0000,0x0000,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,0x4200,0xfe00,0x4000,0x2000,0x0000,0x0000, // u21b5
  0x0000,0x0000,0x0000,0xf000,0x3000,0x5000,0x9200,0x8200,0x8200,0x4400,0x3800,0x0000,0x0000,0x0000, // u21bb
  0x0000,0x0000,0x0000,0x2000,0x4000,0xfe00,0x0000,0xfe00,0x0400,0x0800,0x0000,0x0000,0x0000,0x0000, // u21cb
  0x0000,0x0000,0x0000,0x0800,0x0400,0xfe00,0x0000,0xfe00,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000, // u21cc
  0x0000,0x0000,0x0000,0x0000,0x2000,0x7e00,0xc000,0x7e00,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d0
  0x0000,0x0000,0x1000,0x3800,0x6c00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x0000,0x0000, // u21d1
  0x0000,0x0000,0x0000,0x0000,0x0800,0xfc00,0x0600,0xfc00,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d2
  0x0000,0x0000,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x6c00,0x3800,0x1000,0x0000,0x0000, // u21d3
  0x0000,0x0000,0x0000,0x0000,0x2400,0x7e00,0xc300,0x7e00,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d4
  0x0000,0x0000,0x1000,0x3800,0x6c00,0x2800,0x2800,0x2800,0x2800,0x6c00,0x3800,0x1000,0x0000,0x0000, // u21d5
  0x0000,0x0000,0x8200,0x8200,0x8200,0x7c00,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000, // u2200
  0x0000,0x0000,0x0000,0x7e00,0x0200,0x0200,0x0200,0x7e00,0x0200,0x0200,0x0200,0x7e00,0x0000,0x0000, // u2203
  0x0000,0x0000,0x0400,0x7e00,0x0a00,0x0a00,0x1200,0x7e00,0x1200,0x2200,0x2200,0x7e00,0x4000,0x0000, // u2204
  0x0000,0x0000,0x0200,0x0400,0x7c00,0x8a00,0x9200,0x9200,0xa200,0x7c00,0x4000,0x8000,0x0000,0x0000, // u2205
  0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x4400,0x8200,0x8200,0xfe00,0x0000,0x0000, // u2206
  0x0000,0x0000,0xfe00,0x8200,0x8200,0x4400,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000, // u2207
  0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x4000,0x7e00,0x4000,0x4000,0x2000,0x1e00,0x0000,0x0000, // u2208
  0x0000,0x0000,0x0200,0x1e00,0x2400,0x4400,0x4800,0x7e00,0x4800,0x5000,0x3000,0x3e00,0x2000,0x0000, // u2209
  0x0000,0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x7e00,0x4000,0x2000,0x1e00,0x0000,0x0000,0x0000, // u220a
  0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x0200,0x7e00,0x0200,0x0200,0x0400,0x7800,0x0000,0x0000, // u220b
  0x0000,0x0000,0x4000,0x7800,0x2400,0x2200,0x1200,0x7e00,0x1200,0x0a00,0x0c00,0x7c00,0x0400,0x0000, // u220c
  0x0000,0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x7e00,0x0200,0x0400,0x7800,0x0000,0x0000,0x0000, // u220d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2212
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000, // u2213
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000, // u2214
  0x0000,0x0000,0x0000,0x0000,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000,0x0000,0x0000,0x0000, // u2215
  0x0000,0x0000,0x0000,0x0000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0000,0x0000,0x0000, // u2216
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2219
  0x0000,0x0600,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x4400,0x2400,0x1400,0x0c00,0x0000,0x0000, // u221a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x9200,0x9200,0x9200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u221e
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u221f
  0x0000,0x0000,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x0000,0x0000, // u2225
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x8200,0x8200,0x0000,0x0000, // u2227
  0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000, // u2228
  0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u2229
  0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u222a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3200,0x4c00,0x0000,0x3200,0x4c00,0x0000,0x0000,0x0000,0x0000, // u2248
  0x0000,0x0000,0x0000,0x0000,0x0200,0x7e00,0x0800,0x1000,0x7e00,0x4000,0x0000,0x0000,0x0000,0x0000, // u2260
  0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x7e00,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000, // u2261
  0x0000,0x0000,0x0000,0x0400,0x0800,0x1000,0x2000,0x1000,0x0800,0x0400,0x0000,0x3e00,0x0000,0x0000, // u2264
  0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0800,0x1000,0x2000,0x0000,0x7c00,0x0000,0x0000, // u2265
  0x0000,0x0000,0x0000,0x0900,0x1200,0x2400,0x4800,0x9000,0x4800,0x2400,0x1200,0x0900,0x0000,0x0000, // u226a
  0x0000,0x0000,0x0000,0x9000,0x4800,0x2400,0x1200,0x0900,0x1200,0x2400,0x4800,0x9000,0x0000,0x0000, // u226b
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0000,0x0000,0x0000, // u2282
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000, // u2283
  0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0000,0x7e00,0x0000,0x0000, // u2286
  0x0000,0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x7e00,0x0000,0x0000, // u2287
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xfe00,0x0000,0x0000, // u22a5
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000, // u22c2
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000, // u22c3
  0x0000,0x0000,0x0200,0x0400,0x7c00,0x8a00,0x9200,0x9200,0xa200,0x7c00,0x4000,0x8000,0x0000,0x0000, // u2300
  0x0000,0x0000,0x0000,0x0000,0x1000,0x2800,0x4400,0x8200,0x8200,0x8200,0x8200,0xfe00,0x0000,0x0000, // u2302
  0x0000,0x0000,0x3800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000, // u2308
  0x0000,0x0000,0x3800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000, // u2309
  0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3800,0x0000,0x0000, // u230a
  0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3800,0x0000,0x0000, // u230b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2310
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2319
  0x0000,0x0000,0x0c00,0x1200,0x1200,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2320
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x9000,0x9000,0x6000,0x0000,0x0000, // u2321
  0x0400,0x0800,0x1000,0x1000,0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u239b
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u239c
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x2000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0400, // u239d
  0x4000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u239e
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u239f
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0800,0x0800,0x0800,0x1000,0x1000,0x2000,0x4000, // u23a0
  0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u23a1
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u23a2
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7c00, // u23a3
  0x7c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u23a4
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u23a5
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x7c00, // u23a6
  0x0e00,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23a7
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xc000,0xc000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23a8
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x0e00, // u23a9
  0xe000,0x1000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u23ab
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0600,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u23ac
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1000,0xe000, // u23ad
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u23ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23af
  0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23ba
  0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000, // u23bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00, // u23bd
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u23d0
  0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x1f00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0000, // u2409
  0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x1f00,0x1000,0x1c00,0x1000,0x1000,0x1000,0x0000, // u240a
  0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x1f00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0000, // u240b
  0xf800,0x8000,0xe000,0x8000,0x8000,0x8000,0x0000,0x1f00,0x1000,0x1c00,0x1000,0x1000,0x1000,0x0000, // u240c
  0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x1e00,0x1100,0x1100,0x1e00,0x1200,0x1100,0x0000, // u240d
  0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x0000, // u2424
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2500
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2501
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2502
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2503
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2508
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2509
  0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x0000, // u250a
  0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000, // u250b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u250c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u250d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2510
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2511
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2512
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2513
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2514
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2515
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2516
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2517
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2518
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2519
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251b
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u251c
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u251d
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u251e
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251f
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2520
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2521
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2522
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2523
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2524
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2525
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2526
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2527
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2528
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2529
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2530
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2531
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2532
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2533
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2534
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2535
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2536
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2537
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2538
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2539
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253b
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253c
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253d
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253e
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253f
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2540
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2541
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2542
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2543
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2544
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2545
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2546
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2547
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2548
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2549
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u254a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u254b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2550
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2551
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2552
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2553
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x2000,0x2f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2554
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x1000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2555
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2556
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0800,0xe800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2557
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1000,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2558
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2559
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2f00,0x2000,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255a
  0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x1000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255b
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255c
  0x2800,0x2800,0x2800,0x2800,0x2800,0xe800,0x0800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255d
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u255e
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u255f
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2f00,0x2000,0x2f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2560
  0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x1000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2561
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xe800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2562
  0x2800,0x2800,0x2800,0x2800,0x2800,0xe800,0x0800,0xe800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2563
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2564
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2565
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0xef00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2566
  0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2567
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2568
  0x2800,0x2800,0x2800,0x2800,0x2800,0xef00,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2569
  0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u256a
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xff00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u256b
  0x2800,0x2800,0x2800,0x2800,0x2800,0xef00,0x0000,0xef00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u256c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0700,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u256d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0x2000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u256e
  0x1000,0x1000,0x1000,0x1000,0x1000,0x2000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u256f
  0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0700,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2570
  0x0100,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x4000,0x8000, // u2571
  0x8000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0200,0x0200,0x0100, // u2572
  0x8100,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x8100, // u2573
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2574
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2575
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2576
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2577
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2578
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2579
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u257b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257c
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u257d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u257f
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2580
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00, // u2581
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00, // u2582
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00, // u2583
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2584
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2585
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2586
  0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2587
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2588
  0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00, // u2589
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u258a
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800, // u258b
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u258c
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u258d
  0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000, // u258e
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000, // u258f
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2590
  0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200, // u2591
  0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500, // u2592
  0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00, // u2593
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u2596
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2597
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2598
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2599
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259a
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259b
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259c
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u259d
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259e
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u259f
  0x0000,0x0000,0x0000,0x0000,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x0000,0x0000,0x0000,0x0000, // u25a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x7e00,0x7e00,0x7e00,0x0000,0x0000, // u25ac
  0x0000,0x0000,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x0000,0x0000, // u25ae
  0x0000,0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x7c00,0x7c00,0xfe00,0xfe00,0x0000,0x0000,0x0000, // u25b2
  0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,0x0000, // u25b6
  0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,0x0000, // u25ba
  0x0000,0x0000,0x0000,0xfe00,0xfe00,0x7c00,0x7c00,0x3800,0x3800,0x1000,0x1000,0x0000,0x0000,0x0000, // u25bc
  0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000,0x0000, // u25c0
  0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000,0x0000, // u25c4
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3800,0x7c00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000, // u25c6
  0x0000,0x0000,0x0000,0x0000,0x1000,0x2800,0x4400,0x8200,0x4400,0x2800,0x1000,0x0000,0x0000,0x0000, // u25ca
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u25cb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u25cf
  0xff00,0xff00,0xff00,0xff00,0xff00,0xe700,0xc300,0xc300,0xe700,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d8
  0xff00,0xff00,0xff00,0xff00,0xff00,0xe700,0xdb00,0xdb00,0xe700,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d9
  0x0000,0x0000,0x7c00,0x8200,0xaa00,0x8200,0x8200,0xba00,0x9200,0x8200,0x8200,0x7c00,0x0000,0x0000, // u263a
  0x0000,0x0000,0x7c00,0xfe00,0xd600,0xfe00,0xfe00,0xc600,0xee00,0xfe00,0xfe00,0x7c00,0x0000,0x0000, // u263b
  0x0000,0x0000,0x0000,0x1000,0x9200,0x5400,0x3800,0xee00,0x3800,0x5400,0x9200,0x1000,0x0000,0x0000, // u263c
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4400,0x4400,0x3800,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000, // u2640
  0x0000,0x0000,0x1e00,0x0600,0x0a00,0x1200,0x3800,0x4400,0x4400,0x4400,0x4400,0x3800,0x0000,0x0000, // u2642
  0x0000,0x0000,0x1000,0x1000,0x3800,0x7c00,0xfe00,0xfe00,0x7c00,0x1000,0x1000,0x3800,0x0000,0x0000, // u2660
  0x0000,0x0000,0x1000,0x3800,0x3800,0x1000,0x5400,0xfe00,0xfe00,0x5400,0x1000,0x3800,0x0000,0x0000, // u2663
  0x0000,0x0000,0x0000,0x6c00,0xfe00,0xfe00,0xfe00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000, // u2665
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3800,0x7c00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000, // u2666
  0x0000,0x0000,0x3e00,0x2200,0x3e00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xc000,0x0000,0x0000, // u266a
  0x0000,0x0000,0x7e00,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x8000,0x0000, // u266b
  0x0000,0x0000,0x0200,0x0200,0x0400,0x0400,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000, // u2713
  0x0000,0x0000,0x0300,0x0300,0x0600,0x0600,0xcc00,0xcc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000, // u2714
  0x0000,0x0000,0x0400,0x4400,0x2800,0x1800,0x1800,0x1400,0x2200,0x2000,0x4000,0x4000,0x0000,0x0000, // u2717
  0x0000,0x0000,0x0c00,0xcc00,0x7800,0x3800,0x3800,0x3c00,0x6600,0x6000,0xc000,0xc000,0x0000,0x0000, // u2718
  0x0000,0x0000,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0000,0x0000, // u27e8
  0x0000,0x0000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x0000,0x0000, // u27e9
  0x0000,0x0000,0x1200,0x1200,0x2400,0x2400,0x4800,0x4800,0x2400,0x2400,0x1200,0x1200,0x0000,0x0000, // u27ea
  0x0000,0x0000,0x4800,0x4800,0x2400,0x2400,0x1200,0x1200,0x2400,0x2400,0x4800,0x4800,0x0000,0x0000, // u27eb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2800
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2801
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2802
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2803
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2804
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2805
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2806
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2807
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2808
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2809
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280a
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280d
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280e
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u280f
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2810
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2811
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2812
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2813
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2814
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2815
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2816
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2817
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2818
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2819
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281a
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281b
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281c
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281d
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281e
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u281f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2820
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2821
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2822
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2823
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2824
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2825
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2826
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2827
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2828
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2829
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u282a
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u282b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u282c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u282d
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u282e
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u282f
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2830
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2831
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2832
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2833
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2834
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2835
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2836
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2837
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2838
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u2839
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u283a
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u283b
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u283c
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u283d
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u283e
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u283f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2840
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2841
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2842
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2843
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2844
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2845
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2846
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2847
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2848
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2849
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284a
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284d
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284e
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u284f
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2850
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2851
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2852
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2853
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2854
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2855
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2856
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u2857
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2858
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2859
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285a
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285b
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285c
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285d
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285e
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000, // u285f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2860
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2861
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2862
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2863
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2864
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2865
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2866
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2867
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2868
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2869
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u286a
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u286b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u286c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u286d
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u286e
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u286f
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2870
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2871
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2872
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2873
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2874
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2875
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2876
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u2877
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2878
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u2879
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u287a
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000, // u287b
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u287c
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u287d
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u287e
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000, // u287f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2880
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2881
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2882
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2883
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2884
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2885
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2886
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2887
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2888
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2889
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288a
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u288c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u288d
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u288e
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u288f
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2890
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2891
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2892
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2893
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2894
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2895
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2896
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u2897
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2898
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2899
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289a
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289b
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u289c
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u289d
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u289e
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000, // u289f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28a0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28a1
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28a2
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28a3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28a4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28a5
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28a6
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28a7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28a8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28a9
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28aa
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28ab
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28ac
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28ad
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28ae
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28af
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28b0
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28b1
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28b2
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28b3
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28b4
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28b5
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28b6
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28b7
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28b8
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28b9
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28ba
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000, // u28bb
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28bc
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28bd
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28be
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000, // u28bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c1
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c2
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28c4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28c5
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28c6
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28c7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c9
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ca
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28cb
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28cc
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28cd
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28ce
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28cf
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d0
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d1
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d2
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d3
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28d4
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28d5
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28d6
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28d7
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d8
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d9
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28da
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28db
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28dc
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28dd
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28de
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000, // u28df
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28e0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28e1
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28e2
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28e3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28e4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28e5
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28e6
  0x0000,0x4000,0x4000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28e7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28e8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28e9
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28ea
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28eb
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28ec
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28ed
  0x0000,0x0400,0x0400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28ee
  0x0000,0x4400,0x4400,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28ef
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28f0
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28f1
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28f2
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28f3
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28f4
  0x0000,0x4000,0x4000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28f5
  0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28f6
  0x0000,0x4000,0x4000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28f7
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28f8
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28f9
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28fa
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000, // u28fb
  0x0000,0x0400,0x0400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28fc
  0x0000,0x4400,0x4400,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28fd
  0x0000,0x0400,0x0400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28fe
  0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x4400,0x4400,0x0000, // u28ff
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x0000,0x0000,0x0000,0x4200,0x4200,0x0000,0x0000, // u2e2c
  0x8000,0x8800,0x9c00,0xaa00,0x8800,0x8800,0x8800,0x1000,0x2000,0x4000,0x8000,0x8000,0x8000,0x8000, // ue0a0
  0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x1100,0x1900,0x1500,0x1300,0x1100,0x1100,0x0000, // ue0a1
  0x3800,0x4400,0x4400,0x4400,0x4400,0xfe00,0xfe00,0xee00,0xc600,0xee00,0xfe00,0xfe00,0xfe00,0x0000, // ue0a2
  0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xfe00,0xfc00,0xf800,0xf000,0xe000,0xc000,0x8000, // ue0b0
  0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000, // ue0b1
  0x0100,0x0300,0x0700,0x0f00,0x1f00,0x3f00,0x7f00,0x7f00,0x3f00,0x1f00,0x0f00,0x0700,0x0300,0x0100, // ue0b2
  0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100, // ue0b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800, // uf6be
  0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x0000,0x0000 // ufffd
  };
  // codepoints array
  constexpr std::array<uint16_t, CHARCOUNT> fixedfont_codepoints = {
  0x0000,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,
  0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,
  0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,
  0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,
  0x005f,0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff,
  0x0100,0x0101,0x0102,0x0103,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x010c,0x010d,0x010e,0x010f,
  0x0110,0x0111,0x0112,0x0113,0x0114,0x0115,0x0116,0x0117,0x0118,0x0119,0x011a,0x011b,0x011c,0x011d,0x011e,0x011f,
  0x0120,0x0121,0x0122,0x0123,0x0124,0x0125,0x0126,0x0127,0x0128,0x0129,0x012a,0x012b,0x012c,0x012d,0x012e,0x012f,
  0x0130,0x0131,0x0132,0x0133,0x0134,0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x013d,0x013e,0x013f,
  0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,0x0149,0x014a,0x014b,0x014c,0x014d,0x014e,0x014f,
  0x0150,0x0151,0x0152,0x0153,0x0154,0x0155,0x0156,0x0157,0x0158,0x0159,0x015a,0x015b,0x015c,0x015d,0x015e,0x015f,
  0x0160,0x0161,0x0162,0x0163,0x0164,0x0165,0x0166,0x0167,0x0168,0x0169,0x016a,0x016b,0x016c,0x016d,0x016e,0x016f,
  0x0170,0x0171,0x0172,0x0173,0x0174,0x0175,0x0176,0x0177,0x0178,0x0179,0x017a,0x017b,0x017c,0x017d,0x017e,0x017f,
  0x0186,0x018e,0x018f,0x0190,0x0192,0x019d,0x019e,0x01b5,0x01b6,0x01b7,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d2,
  0x01d3,0x01d4,0x01e2,0x01e3,0x01e4,0x01e5,0x01e6,0x01e7,0x01e8,0x01e9,0x01ea,0x01eb,0x01ec,0x01ed,0x01ee,0x01ef,
  0x01f0,0x01f4,0x01f5,0x01fc,0x01fd,0x01fe,0x01ff,0x0218,0x0219,0x021a,0x021b,0x0232,0x0233,0x0237,0x0254,0x0258,
  0x0259,0x025b,0x0272,0x0292,0x02bb,0x02bc,0x02bd,0x02c6,0x02c7,0x02d8,0x02d9,0x02db,0x02dc,0x02dd,0x0300,0x0301,
  0x0302,0x0303,0x0304,0x0305,0x0306,0x0307,0x0308,0x030a,0x030b,0x030c,0x0329,0x0384,0x0385,0x0386,0x0387,0x0388,
  0x0389,0x038a,0x038c,0x038e,0x038f,0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
  0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03aa,0x03ab,
  0x03ac,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,
  0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x03ca,0x03cb,
  0x03cc,0x03cd,0x03ce,0x03d1,0x03d5,0x03f0,0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,0x03f6,0x0400,0x0401,0x0402,0x0403,
  0x0404,0x0405,0x0406,0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,0x0411,0x0412,0x0413,
  0x0414,0x0415,0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,
  0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,0x0431,0x0432,0x0433,
  0x0434,0x0435,0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,
  0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x0450,0x0451,0x0452,0x0453,
  0x0454,0x0455,0x0456,0x0457,0x0458,0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0462,0x0463,0x046a,0x046b,
  0x0490,0x0491,0x0492,0x0493,0x0494,0x0495,0x0496,0x0497,0x0498,0x0499,0x049a,0x049b,0x049c,0x049d,0x04a0,0x04a1,
  0x04a2,0x04a3,0x04a4,0x04a5,0x04aa,0x04ab,0x04ae,0x04af,0x04b0,0x04b1,0x04b2,0x04b3,0x04b6,0x04b7,0x04b8,0x04b9,
  0x04ba,0x04bb,0x04c0,0x04c1,0x04c2,0x04cf,0x04d0,0x04d1,0x04d2,0x04d3,0x04d4,0x04d5,0x04d6,0x04d7,0x04d8,0x04d9,
  0x04da,0x04db,0x04dc,0x04dd,0x04de,0x04df,0x04e2,0x04e3,0x04e4,0x04e5,0x04e6,0x04e7,0x04e8,0x04e9,0x04ea,0x04eb,
  0x04ec,0x04ed,0x04ee,0x04ef,0x04f0,0x04f1,0x04f2,0x04f3,0x04f4,0x04f5,0x04f8,0x04f9,0x05d0,0x05d1,0x05d2,0x05d3,
  0x05d4,0x05d5,0x05d6,0x05d7,0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,0x05e0,0x05e1,0x05e2,0x05e3,
  0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,0x05ea,0x1e0c,0x1e0d,0x1e34,0x1e35,0x1e36,0x1e37,0x1e40,0x1e41,0x1e42,
  0x1e43,0x1e44,0x1e45,0x1e46,0x1e47,0x1e6c,0x1e6d,0x1eb8,0x1eb9,0x1ebc,0x1ebd,0x1eca,0x1ecb,0x1ecc,0x1ecd,0x1ee4,
  0x1ee5,0x1ef8,0x1ef9,0x2000,0x2001,0x2002,0x2003,0x2004,0x2005,0x2006,0x2007,0x2008,0x2009,0x200a,0x200b,0x200c,
  0x200d,0x200e,0x200f,0x2010,0x2011,0x2012,0x2013,0x2014,0x2015,0x2016,0x2017,0x2018,0x2019,0x201a,0x201b,0x201c,
  0x201d,0x201e,0x201f,0x2020,0x2021,0x2022,0x2026,0x2030,0x2032,0x2033,0x2039,0x203a,0x203c,0x203e,0x2070,0x2071,
  0x2074,0x2075,0x2076,0x2077,0x2078,0x2079,0x207a,0x207b,0x207c,0x207d,0x207e,0x207f,0x2080,0x2081,0x2082,0x2083,
  0x2084,0x2085,0x2086,0x2087,0x2088,0x2089,0x208a,0x208b,0x208c,0x208d,0x208e,0x2090,0x2091,0x2092,0x2093,0x2094,
  0x2095,0x2096,0x2097,0x2098,0x209a,0x20a7,0x20aa,0x20ac,0x20ae,0x2102,0x210e,0x210f,0x2115,0x2116,0x211a,0x211d,
  0x2122,0x2124,0x2126,0x2135,0x2190,0x2191,0x2192,0x2193,0x2194,0x2195,0x21a4,0x21a6,0x21a8,0x21b5,0x21bb,0x21cb,
  0x21cc,0x21d0,0x21d1,0x21d2,0x21d3,0x21d4,0x21d5,0x2200,0x2203,0x2204,0x2205,0x2206,0x2207,0x2208,0x2209,0x220a,
  0x220b,0x220c,0x220d,0x2212,0x2213,0x2214,0x2215,0x2216,0x2219,0x221a,0x221e,0x221f,0x2225,0x2227,0x2228,0x2229,
  0x222a,0x2248,0x2260,0x2261,0x2264,0x2265,0x226a,0x226b,0x2282,0x2283,0x2286,0x2287,0x22a5,0x22c2,0x22c3,0x2300,
  0x2302,0x2308,0x2309,0x230a,0x230b,0x2310,0x2319,0x2320,0x2321,0x239b,0x239c,0x239d,0x239e,0x239f,0x23a0,0x23a1,
  0x23a2,0x23a3,0x23a4,0x23a5,0x23a6,0x23a7,0x23a8,0x23a9,0x23ab,0x23ac,0x23ad,0x23ae,0x23af,0x23ba,0x23bb,0x23bc,
  0x23bd,0x23d0,0x2409,0x240a,0x240b,0x240c,0x240d,0x2424,0x2500,0x2501,0x2502,0x2503,0x2508,0x2509,0x250a,0x250b,
  0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513,0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251a,0x251b,
  0x251c,0x251d,0x251e,0x251f,0x2520,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252a,0x252b,
  0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b,
  0x253c,0x253d,0x253e,0x253f,0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254a,0x254b,
  0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f,
  0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f,
  0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2577,0x2578,0x2579,0x257a,0x257b,0x257c,0x257d,0x257e,0x257f,
  0x2580,0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,0x258e,0x258f,
  0x2590,0x2591,0x2592,0x2593,0x2596,0x2597,0x2598,0x2599,0x259a,0x259b,0x259c,0x259d,0x259e,0x259f,0x25a0,0x25ac,
  0x25ae,0x25b2,0x25b6,0x25ba,0x25bc,0x25c0,0x25c4,0x25c6,0x25ca,0x25cb,0x25cf,0x25d8,0x25d9,0x263a,0x263b,0x263c,
  0x2640,0x2642,0x2660,0x2663,0x2665,0x2666,0x266a,0x266b,0x2713,0x2714,0x2717,0x2718,0x27e8,0x27e9,0x27ea,0x27eb,
  0x2800,0x2801,0x2802,0x2803,0x2804,0x2805,0x2806,0x2807,0x2808,0x2809,0x280a,0x280b,0x280c,0x280d,0x280e,0x280f,
  0x2810,0x2811,0x2812,0x2813,0x2814,0x2815,0x2816,0x2817,0x2818,0x2819,0x281a,0x281b,0x281c,0x281d,0x281e,0x281f,
  0x2820,0x2821,0x2822,0x2823,0x2824,0x2825,0x2826,0x2827,0x2828,0x2829,0x282a,0x282b,0x282c,0x282d,0x282e,0x282f,
  0x2830,0x2831,0x2832,0x2833,0x2834,0x2835,0x2836,0x2837,0x2838,0x2839,0x283a,0x283b,0x283c,0x283d,0x283e,0x283f,
  0x2840,0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847,0x2848,0x2849,0x284a,0x284b,0x284c,0x284d,0x284e,0x284f,
  0x2850,0x2851,0x2852,0x2853,0x2854,0x2855,0x2856,0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e,0x285f,
  0x2860,0x2861,0x2862,0x2863,0x2864,0x2865,0x2866,0x2867,0x2868,0x2869,0x286a,0x286b,0x286c,0x286d,0x286e,0x286f,
  0x2870,0x2871,0x2872,0x2873,0x2874,0x2875,0x2876,0x2877,0x2878,0x2879,0x287a,0x287b,0x287c,0x287d,0x287e,0x287f,
  0x2880,0x2881,0x2882,0x2883,0x2884,0x2885,0x2886,0x2887,0x2888,0x2889,0x288a,0x288b,0x288c,0x288d,0x288e,0x288f,
  0x2890,0x2891,0x2892,0x2893,0x2894,0x2895,0x2896,0x2897,0x2898,0x2899,0x289a,0x289b,0x289c,0x289d,0x289e,0x289f,
  0x28a0,0x28a1,0x28a2,0x28a3,0x28a4,0x28a5,0x28a6,0x28a7,0x28a8,0x28a9,0x28aa,0x28ab,0x28ac,0x28ad,0x28ae,0x28af,
  0x28b0,0x28b1,0x28b2,0x28b3,0x28b4,0x28b5,0x28b6,0x28b7,0x28b8,0x28b9,0x28ba,0x28bb,0x28bc,0x28bd,0x28be,0x28bf,
  0x28c0,0x28c1,0x28c2,0x28c3,0x28c4,0x28c5,0x28c6,0x28c7,0x28c8,0x28c9,0x28ca,0x28cb,0x28cc,0x28cd,0x28ce,0x28cf,
  0x28d0,0x28d1,0x28d2,0x28d3,0x28d4,0x28d5,0x28d6,0x28d7,0x28d8,0x28d9,0x28da,0x28db,0x28dc,0x28dd,0x28de,0x28df,
  0x28e0,0x28e1,0x28e2,0x28e3,0x28e4,0x28e5,0x28e6,0x28e7,0x28e8,0x28e9,0x28ea,0x28eb,0x28ec,0x28ed,0x28ee,0x28ef,
  0x28f0,0x28f1,0x28f2,0x28f3,0x28f4,0x28f5,0x28f6,0x28f7,0x28f8,0x28f9,0x28fa,0x28fb,0x28fc,0x28fd,0x28fe,0x28ff,
  0x2e2c,0xe0a0,0xe0a1,0xe0a2,0xe0b0,0xe0b1,0xe0b2,0xe0b3,0xf6be,0xfffd };
} // namespace
// -- end of autogenerated text ---

namespace fixed_font_14b {
  // -- start of autogenerated text ---
  // definition section for font: ter-u14b.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 8;
  constexpr int HEIGHT = 14;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u14b.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    true // bold
  };
  // font bitmap definitions
  constexpr std::array<uint16_t, CHARCOUNT * HEIGHT> fixedfont_bitmap = {
  0x0000,0x0000,0xee00,0xc600,0x0000,0xc600,0xc600,0xc600,0x0000,0xc600,0xc600,0xee00,0x0000,0x0000, // u0000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0020
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000,0x0000, // u0021
  0x0000,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0022
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0xfe00,0x6c00,0x6c00,0xfe00,0x6c00,0x6c00,0x6c00,0x0000,0x0000, // u0023
  0x0000,0x1000,0x1000,0x7c00,0xd600,0xd000,0xd000,0x7c00,0x1600,0x1600,0xd600,0x7c00,0x1000,0x1000, // u0024
  0x0000,0x0000,0x6600,0xd600,0x6c00,0x0c00,0x1800,0x1800,0x3000,0x3600,0x6b00,0x6600,0x0000,0x0000, // u0025
  0x0000,0x0000,0x3800,0x6c00,0x6c00,0x3800,0x7600,0xdc00,0xcc00,0xcc00,0xdc00,0x7600,0x0000,0x0000, // u0026
  0x0000,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0027
  0x0000,0x0000,0x0c00,0x1800,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1800,0x0c00,0x0000,0x0000, // u0028
  0x0000,0x0000,0x3000,0x1800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x1800,0x3000,0x0000,0x0000, // u0029
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x3800,0xfe00,0x3800,0x6c00,0x0000,0x0000,0x0000,0x0000, // u002a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u002b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3000,0x0000, // u002c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000, // u002e
  0x0000,0x0000,0x0600,0x0600,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x6000,0x6000,0x0000,0x0000, // u002f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0030
  0x0000,0x0000,0x1800,0x3800,0x7800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x7e00,0x0000,0x0000, // u0031
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000, // u0032
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0033
  0x0000,0x0000,0x0600,0x0e00,0x1e00,0x3600,0x6600,0xc600,0xfe00,0x0600,0x0600,0x0600,0x0000,0x0000, // u0034
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xfc00,0x0600,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u0035
  0x0000,0x0000,0x3c00,0x6000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0036
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x3000,0x0000,0x0000, // u0037
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x7c00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0038
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0c00,0x7800,0x0000,0x0000, // u0039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000, // u003a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x1800,0x1800,0x3000,0x0000, // u003b
  0x0000,0x0000,0x0000,0x0600,0x0c00,0x1800,0x3000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0000,0x0000, // u003c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000, // u003d
  0x0000,0x0000,0x0000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0c00,0x1800,0x3000,0x6000,0x0000,0x0000, // u003e
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x0c00,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000,0x0000, // u003f
  0x0000,0x0000,0x7c00,0xc600,0xce00,0xd600,0xd600,0xd600,0xd600,0xce00,0xc000,0x7e00,0x0000,0x0000, // u0040
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0041
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0042
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0043
  0x0000,0x0000,0xf800,0xcc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x0000, // u0044
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0045
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0046
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0047
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0048
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0049
  0x0000,0x0000,0x1e00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0x7800,0x0000,0x0000, // u004a
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000, // u004b
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u004c
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u004d
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000, // u004e
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u004f
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0050
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xde00,0x7c00,0x0600,0x0000, // u0051
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u0052
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0053
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0054
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0055
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0x6c00,0x3800,0x3800,0x0000,0x0000, // u0056
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xd600,0xfe00,0xee00,0xc600,0x8200,0x0000,0x0000, // u0057
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000,0x0000, // u0058
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0059
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u005a
  0x0000,0x0000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x0000,0x0000, // u005b
  0x0000,0x0000,0x6000,0x6000,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x0600,0x0600,0x0000,0x0000, // u005c
  0x0000,0x0000,0x3c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x3c00,0x0000,0x0000, // u005d
  0x0000,0x1800,0x3c00,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u005e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000, // u005f
  0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0060
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0061
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0062
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u0063
  0x0000,0x0000,0x0600,0x0600,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0064
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0065
  0x0000,0x0000,0x1e00,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000, // u0066
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0067
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0068
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0069
  0x0000,0x0000,0x0600,0x0600,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // u006a
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u006b
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u006c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000, // u006d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u006e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u006f
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000, // u0070
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600, // u0071
  0x0000,0x0000,0x0000,0x0000,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0072
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000, // u0073
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0000, // u0074
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0075
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x0000,0x0000, // u0076
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x0000,0x0000, // u0077
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x3800,0x6c00,0xc600,0xc600,0x0000,0x0000, // u0078
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0079
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000, // u007a
  0x0000,0x0000,0x1c00,0x3000,0x3000,0x3000,0x6000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000, // u007b
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u007c
  0x0000,0x0000,0x7000,0x1800,0x1800,0x1800,0x0c00,0x1800,0x1800,0x1800,0x1800,0x7000,0x0000,0x0000, // u007d
  0x0000,0x7300,0xdb00,0xce00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u007e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a0
  0x0000,0x0000,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u00a1
  0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0xd600,0xd000,0xd000,0xd000,0xd600,0x7c00,0x1000,0x1000, // u00a2
  0x0000,0x0000,0x3800,0x6c00,0x6000,0x6000,0xf800,0x6000,0x6000,0x6000,0x6600,0xfe00,0x0000,0x0000, // u00a3
  0x0000,0x0000,0x0000,0x0000,0x6600,0x3c00,0x6600,0x6600,0x6600,0x3c00,0x6600,0x0000,0x0000,0x0000, // u00a4
  0x0000,0x0000,0xc300,0xc300,0x6600,0x3c00,0x1800,0x7e00,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000, // u00a5
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u00a6
  0x0000,0x3c00,0x6600,0x6000,0x3800,0x6c00,0x6600,0x6600,0x3600,0x1c00,0x0600,0x6600,0x3c00,0x0000, // u00a7
  0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a8
  0x0000,0x0000,0x0000,0x7e00,0x8100,0x9900,0xa500,0xa100,0xa500,0x9900,0x8100,0x7e00,0x0000,0x0000, // u00a9
  0x0000,0x3c00,0x0600,0x3e00,0x6600,0x3e00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1b00,0x3600,0x6c00,0xd800,0x6c00,0x3600,0x1b00,0x0000,0x0000, // u00ab
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ac
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ad
  0x0000,0x0000,0x0000,0x7e00,0x8100,0xb900,0xa500,0xb900,0xa900,0xa500,0x8100,0x7e00,0x0000,0x0000, // u00ae
  0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00af
  0x0000,0x3800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x7e00,0x0000,0x0000, // u00b1
  0x0000,0x3800,0x6c00,0x0c00,0x1800,0x3000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b2
  0x0000,0x7800,0x0c00,0x3800,0x0c00,0x0c00,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b3
  0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xce00,0xf600,0xc000,0xc000, // u00b5
  0x0000,0x0000,0x7e00,0xd600,0xd600,0xd600,0xd600,0x7600,0x1600,0x1600,0x1600,0x1600,0x0000,0x0000, // u00b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x3000,0x6000, // u00b8
  0x0000,0x1800,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b9
  0x0000,0x3c00,0x6600,0x6600,0x6600,0x3c00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd800,0x6c00,0x3600,0x1b00,0x3600,0x6c00,0xd800,0x0000,0x0000, // u00bb
  0x6000,0xe000,0x6200,0x6600,0x6c00,0x1800,0x3000,0x6600,0xce00,0x9a00,0x3e00,0x0600,0x0600,0x0000, // u00bc
  0x6000,0xe000,0x6200,0x6600,0x6c00,0x1800,0x3000,0x6000,0xdc00,0xb600,0x0c00,0x1800,0x3e00,0x0000, // u00bd
  0xe000,0x3000,0x6200,0x3600,0xec00,0x1800,0x3000,0x6600,0xce00,0x9a00,0x3e00,0x0600,0x0600,0x0000, // u00be
  0x0000,0x0000,0x3000,0x3000,0x0000,0x3000,0x3000,0x6000,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00bf
  0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00c0
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00c1
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00c2
  0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00c3
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00c4
  0x3800,0x6c00,0x3800,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00c5
  0x0000,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000, // u00c6
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x3000,0x6000, // u00c7
  0x3000,0x1800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u00c8
  0x1800,0x3000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u00c9
  0x3800,0x6c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u00ca
  0x6c00,0x6c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u00cb
  0x3000,0x1800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00cc
  0x0c00,0x1800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00cd
  0x3800,0x6c00,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00ce
  0x6600,0x6600,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00cf
  0x0000,0x0000,0x7800,0x6c00,0x6600,0x6600,0xf600,0x6600,0x6600,0x6600,0x6c00,0x7800,0x0000,0x0000, // u00d0
  0x7600,0xdc00,0x0000,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000, // u00d1
  0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d2
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d3
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d4
  0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d5
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0x6c00,0x3800,0x3800,0x6c00,0xc600,0x0000,0x0000,0x0000, // u00d7
  0x0000,0x0000,0x7c00,0xc700,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d8
  0x3000,0x1800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00d9
  0x1800,0x3000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00da
  0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00db
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00dc
  0x0c00,0x1800,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u00dd
  0x0000,0x0000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0x0000,0x0000, // u00de
  0x0000,0x0000,0x7800,0xcc00,0xcc00,0xc800,0xfc00,0xc600,0xc600,0xc600,0xe600,0xdc00,0x0000,0x0000, // u00df
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00e0
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00e1
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00e2
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00e3
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00e4
  0x0000,0x0000,0x3800,0x6c00,0x3800,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000, // u00e6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x3000,0x6000, // u00e7
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u00e8
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u00e9
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u00ea
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u00eb
  0x0000,0x0000,0x3000,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00ec
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00ed
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00ee
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u00ef
  0x0000,0x0000,0x6800,0x3000,0x5800,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00f0
  0x0000,0x0000,0x7600,0xdc00,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u00f1
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00f2
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00f3
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00f4
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00f5
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u00f6
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x7e00,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000, // u00f7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3d00,0x6700,0x6e00,0x7e00,0x7600,0xe600,0xbc00,0x0000,0x0000, // u00f8
  0x0000,0x0000,0x3000,0x1800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00f9
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00fa
  0x0000,0x0000,0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00fb
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u00fc
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u00fd
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000, // u00fe
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u00ff
  0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0100
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0101
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0102
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0103
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0c00,0x0700, // u0104
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0c00,0x0700, // u0105
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0106
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u0107
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0108
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u0109
  0x1800,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u010a
  0x0000,0x0000,0x1800,0x1800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u010b
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u010c
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u010d
  0x6c00,0x3800,0x0000,0xf800,0xcc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x0000, // u010e
  0x6c00,0x3800,0x0600,0x0600,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u010f
  0x0000,0x0000,0x7800,0x6c00,0x6600,0x6600,0xf600,0x6600,0x6600,0x6600,0x6c00,0x7800,0x0000,0x0000, // u0110
  0x0000,0x0000,0x0600,0x1f00,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0111
  0x7c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0112
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0113
  0x6c00,0x3800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0114
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0115
  0x1800,0x1800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0116
  0x0000,0x0000,0x1800,0x1800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0117
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0c00,0x0700, // u0118
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x1800,0x0e00, // u0119
  0x6c00,0x3800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u011a
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u011b
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u011c
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u011d
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u011e
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u011f
  0x1800,0x1800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0120
  0x0000,0x0000,0x1800,0x1800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0121
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x3000,0x6000, // u0122
  0x0000,0x0c00,0x1800,0x1800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0123
  0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0124
  0x1c00,0x3600,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0125
  0x0000,0x0000,0x6600,0xff00,0x6600,0x6600,0x7e00,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000, // u0126
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000, // u0127
  0x7600,0xdc00,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0128
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0129
  0x7e00,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u012a
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u012b
  0x6c00,0x3800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u012c
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u012d
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x0e00, // u012e
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x0e00, // u012f
  0x1800,0x1800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0130
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0131
  0x0000,0x0000,0xcf00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xf600,0xf600,0xdc00,0x0000,0x0000, // u0132
  0x0000,0x0000,0xc600,0xc600,0x0000,0xce00,0xc600,0xc600,0xc600,0xc600,0xc600,0xf600,0x3600,0x1c00, // u0133
  0x1c00,0x3600,0x0000,0x1e00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0x7800,0x0000,0x0000, // u0134
  0x0000,0x0000,0x0e00,0x1b00,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // u0135
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xf600,0x3000,0x6000, // u0136
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xf600,0x3000,0x6000, // u0137
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u0138
  0x6000,0xc000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0139
  0x0c00,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u013a
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x3000,0x6000, // u013b
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x3000, // u013c
  0x6c00,0x3800,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u013d
  0x6c00,0x3800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u013e
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xcc00,0xcc00,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u013f
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1b00,0x1b00,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0140
  0x0000,0x0000,0x6000,0x6000,0x6000,0x6000,0x7000,0xe000,0x6000,0x6000,0x6000,0x7f00,0x0000,0x0000, // u0141
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1c00,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0142
  0x1800,0x3000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000, // u0143
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0144
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xf600,0x3000,0x6000, // u0145
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xf600,0x3000,0x6000, // u0146
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000, // u0147
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0148
  0x0000,0x6000,0x6000,0xc000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0149
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0600,0x1c00, // u014a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x1c00, // u014b
  0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u014c
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u014d
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u014e
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u014f
  0x3600,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0150
  0x0000,0x0000,0x3600,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0151
  0x0000,0x0000,0x7e00,0xd800,0xd800,0xd800,0xde00,0xd800,0xd800,0xd800,0xd800,0x7e00,0x0000,0x0000, // u0152
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xd600,0xd600,0xde00,0xd000,0xd000,0x7c00,0x0000,0x0000, // u0153
  0x1800,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u0154
  0x0000,0x0000,0x1800,0x3000,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0155
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xf600,0x3000,0x6000, // u0156
  0x0000,0x0000,0x0000,0x0000,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xe000,0x6000,0xc000, // u0157
  0x6c00,0x3800,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u0158
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0159
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u015a
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000, // u015b
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u015c
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000, // u015d
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x3000,0x6000, // u015e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x3000,0x6000, // u015f
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u0160
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000, // u0161
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1c00,0x0c00,0x1800, // u0162
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0c00,0x1800, // u0163
  0x6c00,0x3800,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0164
  0x6c00,0x3800,0x0000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0000, // u0165
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0166
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x7800,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0000, // u0167
  0x7600,0xdc00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0168
  0x0000,0x0000,0x7600,0xdc00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0169
  0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u016a
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u016b
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u016c
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u016d
  0x3800,0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u016e
  0x0000,0x0000,0x3800,0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u016f
  0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0170
  0x0000,0x0000,0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0171
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x0e00, // u0172
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0c00,0x0700, // u0173
  0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xd600,0xfe00,0xee00,0xc600,0x8200,0x0000,0x0000, // u0174
  0x0000,0x0000,0x3800,0x6c00,0x0000,0xc600,0xc600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x0000,0x0000, // u0175
  0x3800,0x6c00,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0176
  0x0000,0x0000,0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0177
  0x6600,0x6600,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0178
  0x1800,0x3000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0179
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000, // u017a
  0x1800,0x1800,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u017b
  0x0000,0x0000,0x1800,0x1800,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000, // u017c
  0x6c00,0x3800,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u017d
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000, // u017e
  0x0000,0x0000,0x1e00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000, // u017f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x0600,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0186
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0600,0x3e00,0x0600,0x0600,0x0600,0x0600,0xfe00,0x0000,0x0000, // u018e
  0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u018f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0x7800,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0190
  0x0000,0x0000,0x0e00,0x1b00,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0xd800,0x7000, // u0192
  0x0000,0x0000,0x6600,0x6600,0x6600,0x7600,0x7e00,0x6e00,0x6600,0x6600,0x6600,0x6600,0x6000,0xc000, // u019d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600, // u019e
  0x0000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0xfe00,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u01b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0c00,0x1800,0xfc00,0x3000,0x6000,0xfe00,0x0000,0x0000, // u01b6
  0x0000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01b7
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u01cd
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u01ce
  0x6c00,0x3800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u01cf
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u01d0
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01d1
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01d2
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01d3
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u01d4
  0x7c00,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000, // u01e2
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000, // u01e3
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xde00,0xc600,0xdf00,0xc600,0x7c00,0x0000,0x0000, // u01e4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xdf00,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u01e5
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01e6
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u01e7
  0x6c00,0x3800,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000, // u01e8
  0x6c00,0x3800,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u01e9
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x0e00, // u01ea
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x0e00, // u01eb
  0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x0e00, // u01ec
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x0e00, // u01ed
  0x6c00,0x3800,0x0000,0xfe00,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01ee
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0x7c00, // u01ef
  0x0000,0x0000,0x1b00,0x0e00,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // u01f0
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u01f4
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u01f5
  0x0c00,0x1800,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000, // u01fc
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000, // u01fd
  0x1800,0x3000,0x0000,0x7c00,0xc700,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0x7c00,0x0000,0x0000, // u01fe
  0x0000,0x0000,0x1800,0x3000,0x0000,0x3d00,0x6700,0x6e00,0x7e00,0x7600,0xe600,0xbc00,0x0000,0x0000, // u01ff
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x3000,0x6000, // u0218
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x3000,0x6000, // u0219
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1c00,0x0c00,0x1800, // u021a
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0600,0x0c00, // u021b
  0x7e00,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0232
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0233
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // u0237
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u0254
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0x0600,0x0600,0x7c00,0x0000,0x0000, // u0258
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x0600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0259
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0x7800,0xc000,0xc600,0x7c00,0x0000,0x0000, // u025b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6000,0xc000, // u0272
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0x7c00, // u0292
  0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bb
  0x1800,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bc
  0x3000,0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bd
  0x3800,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c6
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c7
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d8
  0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1800,0x0e00, // u02db
  0x7600,0xdc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dc
  0x3600,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dd
  0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0300
  0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0301
  0x3800,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0302
  0x7600,0xdc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0303
  0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0304
  0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0305
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0306
  0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0307
  0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0308
  0x3800,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030a
  0x3600,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030b
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800, // u0329
  0x6000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0384
  0x1800,0x3000,0x0000,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0385
  0x6000,0xc000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0386
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0387
  0x6000,0xc000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0388
  0x6000,0xc000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0389
  0x6000,0xc000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u038a
  0x6000,0xc000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u038c
  0x6000,0xc000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u038e
  0x6000,0xc000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0xee00,0x0000,0x0000, // u038f
  0x1800,0x3000,0xd800,0xd800,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000, // u0390
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0391
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0392
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0393
  0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x6c00,0x6c00,0x6c00,0xc600,0xc600,0xfe00,0x0000,0x0000, // u0394
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0395
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0396
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0397
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xd600,0xd600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0398
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0399
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000, // u039a
  0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x6c00,0x6c00,0x6c00,0xc600,0xc600,0xc600,0x0000,0x0000, // u039b
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u039c
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000, // u039d
  0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000, // u039e
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u039f
  0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u03a0
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u03a1
  0x0000,0x0000,0xfe00,0xc000,0x6000,0x3000,0x1800,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000, // u03a3
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u03a4
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u03a5
  0x0000,0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000,0x0000, // u03a6
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000,0x0000, // u03a7
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x1000,0x0000,0x0000, // u03a8
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0xee00,0x0000,0x0000, // u03a9
  0x6600,0x6600,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u03aa
  0x6600,0x6600,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u03ab
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7a00,0xce00,0xcc00,0xcc00,0xcc00,0xce00,0x7a00,0x0000,0x0000, // u03ac
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0x7800,0xc000,0xc600,0x7c00,0x0000,0x0000, // u03ad
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600, // u03ae
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000, // u03af
  0x1800,0x3000,0x0000,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7a00,0xce00,0xcc00,0xcc00,0xcc00,0xce00,0x7a00,0x0000,0x0000, // u03b1
  0x0000,0x0000,0x7800,0xcc00,0xcc00,0xc800,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000, // u03b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x1800, // u03b3
  0x0000,0x0000,0x7e00,0x3000,0x1800,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0x7800,0xc000,0xc600,0x7c00,0x0000,0x0000, // u03b5
  0x0000,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xc000,0xc000,0x7c00,0x0600,0x0c00, // u03b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600, // u03b7
  0x0000,0x0000,0x3c00,0x6600,0x6600,0x6600,0x7e00,0x6600,0x6600,0x6600,0x6600,0x3c00,0x0000,0x0000, // u03b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000, // u03b9
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u03ba
  0x0000,0x0000,0x3000,0x3000,0x1800,0x1800,0x3c00,0x3c00,0x6600,0x6600,0xc300,0xc300,0x0000,0x0000, // u03bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xce00,0xf600,0xc000,0xc000, // u03bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x0000,0x0000, // u03bd
  0x0000,0x0000,0x7e00,0xc000,0xc000,0xc000,0x7c00,0xc000,0xc000,0xc000,0xc000,0x7c00,0x0600,0x0c00, // u03be
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u03c0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000, // u03c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc000,0x7c00,0x0600,0x0c00, // u03c2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x6600,0x6600,0x6600,0x6600,0x6600,0x3c00,0x0000,0x0000, // u03c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0e00,0x0000,0x0000, // u03c4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4c00,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x1000, // u03c6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x6c00,0x6c00,0xc600,0xc600, // u03c7
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x1000, // u03c8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0xc600,0xd600,0xd600,0xd600,0xfe00,0x6c00,0x0000,0x0000, // u03c9
  0x0000,0x0000,0xd800,0xd800,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000, // u03ca
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03cb
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03cc
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03cd
  0x0000,0x0000,0x1800,0x3000,0x0000,0x4400,0xc600,0xd600,0xd600,0xd600,0xfe00,0x6c00,0x0000,0x0000, // u03ce
  0x0000,0x0000,0x3c00,0x6600,0x6600,0x6600,0x3f00,0x0600,0xe600,0x6600,0x6600,0x3c00,0x0000,0x0000, // u03d1
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000, // u03d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe300,0x3600,0x1c00,0x1800,0x3800,0x6c00,0xc700,0x0000,0x0000, // u03f0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0x7c00, // u03f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u03f2
  0x0000,0x0000,0x0600,0x0600,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // u03f3
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u03f4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x6000,0xc000,0xfc00,0xc000,0x6000,0x3e00,0x0000,0x0000, // u03f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0c00,0x0600,0x7e00,0x0600,0x0c00,0xf800,0x0000,0x0000, // u03f6
  0x3000,0x1800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0400
  0x6c00,0x6c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0401
  0x0000,0x0000,0xf000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6c00,0x0000,0x0000, // u0402
  0x1800,0x3000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0403
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u0404
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0405
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0406
  0x6600,0x6600,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0407
  0x0000,0x0000,0x1e00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0x7800,0x0000,0x0000, // u0408
  0x0000,0x0000,0x3000,0x7000,0xd000,0xdc00,0xd600,0xd600,0xd600,0xd600,0xd600,0x9c00,0x0000,0x0000, // u0409
  0x0000,0x0000,0xd000,0xd000,0xd000,0xdc00,0xf600,0xd600,0xd600,0xd600,0xd600,0xdc00,0x0000,0x0000, // u040a
  0x0000,0x0000,0xf000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000, // u040b
  0x1800,0x3000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000, // u040c
  0x3000,0x1800,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000, // u040d
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000, // u040e
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x3800,0x3800, // u040f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0410
  0x0000,0x0000,0xfc00,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0411
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0412
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0413
  0x0000,0x0000,0x3e00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0xff00,0xc300,0x0000, // u0414
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u0415
  0x0000,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000, // u0416
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0417
  0x0000,0x0000,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0418
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000, // u0419
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000, // u041a
  0x0000,0x0000,0x1e00,0x3600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0xc600,0x0000,0x0000, // u041b
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u041c
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u041d
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u041e
  0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u041f
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0420
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000, // u0421
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0422
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000, // u0423
  0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000, // u0424
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000,0x0000, // u0425
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7f00,0x0300,0x0300, // u0426
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000, // u0427
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7e00,0x0000,0x0000, // u0428
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7f00,0x0300,0x0300, // u0429
  0x0000,0x0000,0xe000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000, // u042a
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000, // u042b
  0x0000,0x0000,0x6000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000, // u042c
  0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0x3e00,0x0600,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u042d
  0x0000,0x0000,0xcc00,0xd600,0xd600,0xd600,0xd600,0xf600,0xd600,0xd600,0xd600,0xcc00,0x0000,0x0000, // u042e
  0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0x7e00,0x1e00,0x3600,0x6600,0xc600,0x0000,0x0000, // u042f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0430
  0x0000,0x0000,0x7c00,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0431
  0x0000,0x0000,0x7800,0xcc00,0xcc00,0xc800,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000, // u0432
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0433
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0434
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0435
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000, // u0436
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x3c00,0x0600,0xc600,0x7c00,0x0000,0x0000, // u0437
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0438
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u0439
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u043a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x6600,0x6600,0x6600,0x6600,0x6600,0xc600,0x0000,0x0000, // u043b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0x0000,0x0000, // u043c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0x0000,0x0000, // u043d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u043e
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u043f
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000, // u0440
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000, // u0441
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u0442
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u0443
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000, // u0444
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x3800,0x6c00,0xc600,0xc600,0x0000,0x0000, // u0445
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7f00,0x0300,0x0300, // u0446
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0000,0x0000, // u0447
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7e00,0x0000,0x0000, // u0448
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7f00,0x0300,0x0300, // u0449
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000, // u044a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000, // u044b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000, // u044c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x3e00,0x0600,0xc600,0x7c00,0x0000,0x0000, // u044d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xcc00,0xd600,0xd600,0xf600,0xd600,0xd600,0xcc00,0x0000,0x0000, // u044e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0x7e00,0x3600,0x6600,0xc600,0x0000,0x0000, // u044f
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0450
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u0451
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0600,0x1c00, // u0452
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0453
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xf800,0xc000,0xc600,0x7c00,0x0000,0x0000, // u0454
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000, // u0455
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0456
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u0457
  0x0000,0x0000,0x0600,0x0600,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // u0458
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0xd000,0xdc00,0xd600,0xd600,0xd600,0x9c00,0x0000,0x0000, // u0459
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd000,0xd000,0xdc00,0xf600,0xd600,0xd600,0xdc00,0x0000,0x0000, // u045a
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000, // u045b
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000, // u045c
  0x0000,0x0000,0x3000,0x1800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u045d
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u045e
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x3800,0x3800, // u045f
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000, // u0462
  0x0000,0x0000,0x6000,0x6000,0xf800,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000, // u0463
  0x0000,0x0000,0xfe00,0xc600,0x6c00,0x6c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000, // u046a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x6c00,0x2800,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000, // u046b
  0x0600,0x0600,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0490
  0x0000,0x0000,0x0000,0x0600,0x0600,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000, // u0491
  0x0000,0x0000,0x7f00,0x6000,0x6000,0x6000,0xfc00,0x6000,0x6000,0x6000,0x6000,0x6000,0x0000,0x0000, // u0492
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x6000,0x6000,0xfc00,0x6000,0x6000,0x6000,0x0000,0x0000, // u0493
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0x0600,0x0c00, // u0494
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc000,0xc000,0xf800,0xcc00,0xcc00,0xcc00,0x0c00,0x1800, // u0495
  0x0000,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0xd700,0x0300,0x0300, // u0496
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd700,0x0300,0x0300, // u0497
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x3000,0x3000, // u0498
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x3c00,0x0600,0xc600,0x7c00,0x3000,0x3000, // u0499
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc700,0x0300,0x0300, // u049a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc700,0x0300,0x0300, // u049b
  0x0000,0x0000,0xc600,0xc600,0xd600,0xdc00,0xf800,0xf800,0xdc00,0xd600,0xc600,0xc600,0x0000,0x0000, // u049c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xd600,0xdc00,0xf800,0xdc00,0xd600,0xc600,0x0000,0x0000, // u049d
  0x0000,0x0000,0xe300,0xe300,0x6600,0x6c00,0x7800,0x7800,0x6c00,0x6600,0x6300,0x6300,0x0000,0x0000, // u04a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe300,0x6600,0x6c00,0x7800,0x6c00,0x6600,0x6300,0x0000,0x0000, // u04a1
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc700,0x0300,0x0300, // u04a2
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc700,0x0300,0x0300, // u04a3
  0x0000,0x0000,0xcf00,0xcc00,0xcc00,0xcc00,0xfc00,0xcc00,0xcc00,0xcc00,0xcc00,0xcc00,0x0000,0x0000, // u04a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xcf00,0xcc00,0xcc00,0xfc00,0xcc00,0xcc00,0xcc00,0x0000,0x0000, // u04a5
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x3000,0x3000, // u04aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x3000,0x3000, // u04ab
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u04ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x1800, // u04af
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x7e00,0x1800,0x1800,0x1800,0x0000,0x0000, // u04b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x7e00,0x1800, // u04b1
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc700,0x0300,0x0300, // u04b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x3800,0x6c00,0xc600,0xc700,0x0300,0x0300, // u04b3
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0700,0x0300,0x0300, // u04b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0700,0x0300,0x0300, // u04b7
  0x0000,0x0000,0xc600,0xc600,0xc600,0xd600,0xd600,0x7e00,0x1600,0x1600,0x0600,0x0600,0x0000,0x0000, // u04b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xd600,0xd600,0x7e00,0x1600,0x0600,0x0600,0x0000,0x0000, // u04b9
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u04ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u04bb
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u04c0
  0x6c00,0x3800,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0x0000,0x0000, // u04c1
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000, // u04c2
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u04cf
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u04d0
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u04d1
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u04d2
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u04d3
  0x0000,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000, // u04d4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000, // u04d5
  0x6c00,0x3800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u04d6
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u04d7
  0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04d8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x0600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04d9
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x0600,0xfe00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04da
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0x0600,0x0600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04db
  0x6c00,0x6c00,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0x0000,0x0000, // u04dc
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000, // u04dd
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04de
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x3c00,0x0600,0xc600,0x7c00,0x0000,0x0000, // u04df
  0x7c00,0x0000,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000, // u04e2
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u04e3
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0x0000,0x0000, // u04e4
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000, // u04e5
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04e6
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04e7
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04e8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04e9
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04ea
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000, // u04eb
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x0600,0x3e00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000, // u04ec
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x3e00,0x0600,0xc600,0x7c00,0x0000,0x0000, // u04ed
  0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000, // u04ee
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u04ef
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000, // u04f0
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u04f1
  0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000, // u04f2
  0x0000,0x0000,0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u04f3
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000, // u04f4
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0000,0x0000, // u04f5
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000, // u04f8
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000, // u04f9
  0x0000,0x0000,0xc600,0xc600,0x6600,0x6600,0x3c00,0x7800,0xcc00,0xcc00,0xc600,0xc600,0x0000,0x0000, // u05d0
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0xff00,0x0000,0x0000, // u05d1
  0x0000,0x0000,0x7800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x1e00,0x3600,0x6300,0xc300,0x0000,0x0000, // u05d2
  0x0000,0x0000,0xff00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000, // u05d3
  0x0000,0x0000,0xfc00,0x0600,0x0600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u05d4
  0x0000,0x0000,0x7000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u05d5
  0x0000,0x0000,0x7e00,0x0c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u05d6
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u05d7
  0x0000,0x0000,0xcc00,0xce00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u05d8
  0x0000,0x0000,0x7000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u05d9
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u05da
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0x0000, // u05db
  0xc000,0xc000,0xfe00,0x0600,0x0600,0x0600,0x0600,0x0c00,0x1800,0x3000,0x3000,0x3000,0x0000,0x0000, // u05dc
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x0000,0x0000, // u05dd
  0x0000,0x0000,0xdc00,0x7600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6e00,0x0000,0x0000, // u05de
  0x0000,0x0000,0xf000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u05df
  0x0000,0x0000,0x7800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x7c00,0x0000,0x0000, // u05e0
  0x0000,0x0000,0xfc00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x3c00,0x0000,0x0000, // u05e1
  0x0000,0x0000,0xc600,0xc600,0xc600,0x6600,0x6600,0x3600,0x3600,0x1c00,0x3800,0xe000,0x0000,0x0000, // u05e2
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x6600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u05e3
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x6600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0x0000, // u05e4
  0x0000,0x0000,0xc600,0xc600,0x6600,0x6c00,0x3800,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u05e5
  0x0000,0x0000,0xc600,0xc600,0x6600,0x6c00,0x3800,0x3000,0x1800,0x1800,0x0c00,0xfc00,0x0000,0x0000, // u05e6
  0x0000,0x0000,0xfe00,0x0600,0x0600,0xc600,0xc600,0xcc00,0xd800,0xd800,0xd800,0xd800,0xc000,0xc000, // u05e7
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000, // u05e8
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xe600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x0000, // u05e9
  0x0000,0x0000,0xfc00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0xc600,0x0000,0x0000, // u05ea
  0x0000,0x0000,0xf800,0xcc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xcc00,0xf800,0x3000,0x3000, // u1e0c
  0x0000,0x0000,0x0600,0x0600,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x1800,0x1800, // u1e0d
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x7c00, // u1e34
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x7c00, // u1e35
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x1800,0x1800, // u1e36
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x1800, // u1e37
  0x1800,0x1800,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u1e40
  0x0000,0x0000,0x3000,0x3000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000, // u1e41
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x1800,0x1800, // u1e42
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x1800,0x1800, // u1e43
  0x1800,0x1800,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000, // u1e44
  0x0000,0x0000,0x3000,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u1e45
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x1800,0x1800, // u1e46
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x1800,0x1800, // u1e47
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0c00,0x0c00, // u1e6c
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0c00,0x0c00, // u1e6d
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x1800,0x1800, // u1eb8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x1800,0x1800, // u1eb9
  0x7600,0xdc00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000, // u1ebc
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000, // u1ebd
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x1800, // u1eca
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x1800, // u1ecb
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x1800, // u1ecc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x1800, // u1ecd
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x1800, // u1ee4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x1800,0x1800, // u1ee5
  0x7600,0xdc00,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u1ef8
  0x0000,0x0000,0x7600,0xdc00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x7c00, // u1ef9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2001
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2002
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2003
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2004
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2005
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2006
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2007
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2008
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2009
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2010
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2011
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2012
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2013
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2014
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2015
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000, // u2016
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0xfe00, // u2017
  0x0000,0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2018
  0x0000,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2019
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3000,0x0000, // u201a
  0x0000,0x3000,0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201b
  0x0000,0x6600,0xcc00,0xcc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201c
  0x0000,0x3300,0x3300,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0xcc00,0x0000, // u201e
  0x0000,0xcc00,0xcc00,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201f
  0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u2020
  0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000, // u2021
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2022
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdb00,0xdb00,0x0000,0x0000, // u2026
  0x0000,0x0000,0xec00,0xac00,0xf800,0x1800,0x3000,0x3000,0x6000,0x7f00,0xd500,0xdf00,0x0000,0x0000, // u2030
  0x0000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2032
  0x0000,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2033
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1800,0x3000,0x6000,0x3000,0x1800,0x0c00,0x0000,0x0000, // u2039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x3000,0x1800,0x0c00,0x1800,0x3000,0x6000,0x0000,0x0000, // u203a
  0x0000,0x0000,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000, // u203c
  0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u203e
  0x0000,0x3800,0x6c00,0x6c00,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2070
  0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2071
  0x0000,0x0c00,0x1c00,0x3400,0x7e00,0x0c00,0x0c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2074
  0x0000,0x7800,0x6000,0x7800,0x0c00,0x0c00,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2075
  0x0000,0x3800,0x6000,0x7800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2076
  0x0000,0x7c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2077
  0x0000,0x3800,0x6c00,0x3800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2078
  0x0000,0x3800,0x6c00,0x6c00,0x3c00,0x0c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2079
  0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207a
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207b
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207c
  0x0000,0x1800,0x3000,0x3000,0x3000,0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207d
  0x0000,0x3000,0x1800,0x1800,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207e
  0x0000,0x0000,0x7800,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x6c00,0x6c00,0x6c00,0x3800,0x0000,0x0000, // u2080
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u2081
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x0c00,0x1800,0x3000,0x7c00,0x0000,0x0000, // u2082
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0c00,0x3800,0x0c00,0x0c00,0x7800,0x0000,0x0000, // u2083
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1c00,0x3400,0x7e00,0x0c00,0x0c00,0x0000,0x0000, // u2084
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x6000,0x7800,0x0c00,0x0c00,0x7800,0x0000,0x0000, // u2085
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6000,0x7800,0x6c00,0x6c00,0x3800,0x0000,0x0000, // u2086
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x0000,0x0000, // u2087
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x3800,0x6c00,0x6c00,0x3800,0x0000,0x0000, // u2088
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x6c00,0x3c00,0x0c00,0x3800,0x0000,0x0000, // u2089
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000, // u208a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u208b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000, // u208c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3000,0x3000,0x3000,0x3000,0x1800,0x0000,0x0000, // u208d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1800,0x1800,0x1800,0x1800,0x3000,0x0000,0x0000, // u208e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x0c00,0x3c00,0x6c00,0x3c00,0x0000,0x0000, // u2090
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x7c00,0x6000,0x3c00,0x0000,0x0000, // u2091
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x6c00,0x6c00,0x3800,0x0000,0x0000, // u2092
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x3c00,0x1800,0x3c00,0x6600,0x0000,0x0000, // u2093
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0c00,0x7c00,0x6c00,0x3800,0x0000,0x0000, // u2094
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x7800,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000, // u2095
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x6600,0x6c00,0x7800,0x6c00,0x6600,0x0000,0x0000, // u2096
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000, // u2097
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000, // u2098
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x6c00,0x6c00,0x6c00,0x7800,0x6000,0x6000, // u209a
  0x0000,0x0000,0xf800,0xcc00,0xcc00,0xcc00,0xfa00,0xc600,0xcf00,0xc600,0xc600,0xc300,0x0000,0x0000, // u20a7
  0x0000,0x0000,0xf200,0x8a00,0x8a00,0xaa00,0xaa00,0xaa00,0xaa00,0xa200,0xa200,0xbc00,0x0000,0x0000, // u20aa
  0x0000,0x0000,0x0000,0x1e00,0x3300,0x6000,0xfc00,0x6000,0xfc00,0x6000,0x3300,0x1e00,0x0000,0x0000, // u20ac
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1e00,0x7800,0x1e00,0x7800,0x1800,0x1800,0x1800,0x0000,0x0000, // u20ae
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5000,0x5000,0x5000,0x5000,0x5200,0x5200,0x3c00,0x0000,0x0000, // u2102
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u210e
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000, // u210f
  0x0000,0x0000,0x4200,0x4200,0x6200,0x5200,0x6a00,0x5600,0x4a00,0x4600,0x4200,0x4200,0x0000,0x0000, // u2115
  0x0000,0x0000,0x9600,0x9600,0x9600,0xd000,0xf000,0xf000,0xb000,0x9600,0x9000,0x9600,0x0000,0x0000, // u2116
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5a00,0x3c00,0x0600,0x0000, // u211a
  0x0000,0x0000,0xf800,0xa400,0xa400,0xa400,0xa400,0xb800,0xa800,0xb400,0xaa00,0xe600,0x0000,0x0000, // u211d
  0x0000,0x0000,0xfb00,0x5500,0x5500,0x5100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2122
  0x0000,0x0000,0x7e00,0x0200,0x0600,0x0a00,0x1400,0x2800,0x5000,0x6000,0x4000,0x7e00,0x0000,0x0000, // u2124
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0xee00,0x0000,0x0000, // u2126
  0x0000,0x0000,0x6600,0x6600,0x3300,0x3300,0x3e00,0x7c00,0xcc00,0xcc00,0xc600,0x6600,0x0000,0x0000, // u2135
  0x0000,0x0000,0x0000,0x0000,0x2000,0x6000,0xfe00,0xfe00,0x6000,0x2000,0x0000,0x0000,0x0000,0x0000, // u2190
  0x0000,0x0000,0x1800,0x3c00,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000, // u2191
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0c00,0xfe00,0xfe00,0x0c00,0x0800,0x0000,0x0000,0x0000,0x0000, // u2192
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x7e00,0x3c00,0x1800,0x0000,0x0000, // u2193
  0x0000,0x0000,0x0000,0x0000,0x2400,0x6600,0xff00,0xff00,0x6600,0x2400,0x0000,0x0000,0x0000,0x0000, // u2194
  0x0000,0x0000,0x1800,0x3c00,0x7e00,0x1800,0x1800,0x1800,0x1800,0x7e00,0x3c00,0x1800,0x0000,0x0000, // u2195
  0x0000,0x0000,0x0000,0x0000,0x2200,0x6200,0xfe00,0xfe00,0x6200,0x2200,0x0000,0x0000,0x0000,0x0000, // u21a4
  0x0000,0x0000,0x0000,0x0000,0x8800,0x8c00,0xfe00,0xfe00,0x8c00,0x8800,0x0000,0x0000,0x0000,0x0000, // u21a6
  0x0000,0x0000,0x1800,0x3c00,0x7e00,0x1800,0x1800,0x1800,0x7e00,0x3c00,0x1800,0x7e00,0x0000,0x0000, // u21a8
  0x0000,0x0000,0x0600,0x0600,0x0600,0x0600,0x2600,0x6600,0xfe00,0xfe00,0x6000,0x2000,0x0000,0x0000, // u21b5
  0x0000,0x0000,0x0000,0xf800,0x3800,0x6800,0xcb00,0xc300,0xc300,0x6600,0x3c00,0x0000,0x0000,0x0000, // u21bb
  0x0000,0x0000,0x2000,0x6000,0xfe00,0xfe00,0x0000,0xfe00,0xfe00,0x0c00,0x0800,0x0000,0x0000,0x0000, // u21cb
  0x0000,0x0000,0x0800,0x0c00,0xfe00,0xfe00,0x0000,0xfe00,0xfe00,0x6000,0x2000,0x0000,0x0000,0x0000, // u21cc
  0x0000,0x0000,0x0000,0x1000,0x3e00,0x7e00,0xe000,0x7e00,0x3e00,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d0
  0x0000,0x0000,0x1000,0x3800,0x7c00,0xee00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000, // u21d1
  0x0000,0x0000,0x0000,0x1000,0xf800,0xfc00,0x0e00,0xfc00,0xf800,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d2
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xee00,0x7c00,0x3800,0x1000,0x0000,0x0000, // u21d3
  0x0000,0x0000,0x0000,0x2400,0x7e00,0xff00,0xc300,0xff00,0x7e00,0x2400,0x0000,0x0000,0x0000,0x0000, // u21d4
  0x0000,0x0000,0x1000,0x3800,0x7c00,0xee00,0x6c00,0x6c00,0xee00,0x7c00,0x3800,0x1000,0x0000,0x0000, // u21d5
  0x0000,0x0000,0xc600,0xc600,0xc600,0xfe00,0x6c00,0x6c00,0x6c00,0x3800,0x3800,0x3800,0x0000,0x0000, // u2200
  0x0000,0x0000,0x0000,0xfe00,0x0600,0x0600,0x0600,0xfe00,0x0600,0x0600,0x0600,0xfe00,0x0000,0x0000, // u2203
  0x0000,0x0000,0x0c00,0xfe00,0x1e00,0x1600,0x3600,0xfe00,0x3600,0x6600,0x6600,0xfe00,0xc000,0x0000, // u2204
  0x0000,0x0000,0x0600,0x0c00,0x7c00,0xce00,0xde00,0xf600,0xe600,0x7c00,0x6000,0xc000,0x0000,0x0000, // u2205
  0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x6c00,0x6c00,0x6c00,0xc600,0xc600,0xfe00,0x0000,0x0000, // u2206
  0x0000,0x0000,0xfe00,0xc600,0xc600,0x6c00,0x6c00,0x6c00,0x3800,0x3800,0x1000,0x1000,0x0000,0x0000, // u2207
  0x0000,0x0000,0x0000,0x3e00,0x6000,0xc000,0xc000,0xfe00,0xc000,0xc000,0x6000,0x3e00,0x0000,0x0000, // u2208
  0x0000,0x0000,0x0600,0x3e00,0x6c00,0xcc00,0xd800,0xfe00,0xd800,0xf000,0x7000,0x7e00,0x6000,0x0000, // u2209
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x6000,0xc000,0xfe00,0xc000,0x6000,0x3e00,0x0000,0x0000,0x0000, // u220a
  0x0000,0x0000,0x0000,0xf800,0x0c00,0x0600,0x0600,0xfe00,0x0600,0x0600,0x0c00,0xf800,0x0000,0x0000, // u220b
  0x0000,0x0000,0xc000,0xf800,0x6c00,0x6600,0x3600,0xfe00,0x3600,0x1e00,0x1c00,0xfc00,0x0c00,0x0000, // u220c
  0x0000,0x0000,0x0000,0x0000,0xf800,0x0c00,0x0600,0xfe00,0x0600,0x0c00,0xf800,0x0000,0x0000,0x0000, // u220d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2212
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000, // u2213
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000, // u2214
  0x0000,0x0000,0x0000,0x0000,0x0200,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0x8000,0x0000,0x0000, // u2215
  0x0000,0x0000,0x0000,0x0000,0x8000,0xc000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0200,0x0000,0x0000, // u2216
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2219
  0x0000,0x0e00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0xcc00,0x6c00,0x3c00,0x1c00,0x0000,0x0000, // u221a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xd600,0xd600,0xd600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u221e
  0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u221f
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000, // u2225
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3c00,0x3c00,0x6600,0x6600,0xc300,0xc300,0x0000,0x0000, // u2227
  0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x0000,0x0000, // u2228
  0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u2229
  0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u222a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7600,0xdc00,0x0000,0x7600,0xdc00,0x0000,0x0000,0x0000,0x0000, // u2248
  0x0000,0x0000,0x0000,0x0000,0x0600,0xfe00,0x1800,0x3000,0xfe00,0xc000,0x0000,0x0000,0x0000,0x0000, // u2260
  0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0xfe00,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000, // u2261
  0x0000,0x0000,0x0000,0x0c00,0x1800,0x3000,0x6000,0x3000,0x1800,0x0c00,0x0000,0x7e00,0x0000,0x0000, // u2264
  0x0000,0x0000,0x0000,0x3000,0x1800,0x0c00,0x0600,0x0c00,0x1800,0x3000,0x0000,0x7e00,0x0000,0x0000, // u2265
  0x0000,0x0000,0x0000,0x0900,0x1b00,0x3600,0x6c00,0xd800,0x6c00,0x3600,0x1b00,0x0900,0x0000,0x0000, // u226a
  0x0000,0x0000,0x0000,0x9000,0xd800,0x6c00,0x3600,0x1b00,0x3600,0x6c00,0xd800,0x9000,0x0000,0x0000, // u226b
  0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0xc000,0xc000,0xc000,0x7e00,0x0000,0x0000,0x0000, // u2282
  0x0000,0x0000,0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000, // u2283
  0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0xc000,0xc000,0xc000,0x7e00,0x0000,0xfe00,0x0000,0x0000, // u2286
  0x0000,0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0xfe00,0x0000,0x0000, // u2287
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x0000,0x0000, // u22a5
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000, // u22c2
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000, // u22c3
  0x0000,0x0000,0x0600,0x0c00,0x7c00,0xce00,0xde00,0xf600,0xe600,0x7c00,0x6000,0xc000,0x0000,0x0000, // u2300
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3800,0x6c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0x0000,0x0000, // u2302
  0x0000,0x0000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000, // u2308
  0x0000,0x0000,0x3c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0000, // u2309
  0x0000,0x0000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x0000,0x0000, // u230a
  0x0000,0x0000,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x3c00,0x0000,0x0000, // u230b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2310
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2319
  0x0000,0x0000,0x0e00,0x1b00,0x1b00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2320
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xd800,0xd800,0x7000,0x0000,0x0000, // u2321
  0x0600,0x0c00,0x1800,0x1800,0x3000,0x3000,0x3000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u239b
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u239c
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x3000,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0600, // u239d
  0x6000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x0c00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u239e
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u239f
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0c00,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x6000, // u23a0
  0x7e00,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u23a1
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u23a2
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x7e00, // u23a3
  0x7e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u23a4
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u23a5
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x7e00, // u23a6
  0x0f00,0x1800,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u23a7
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0xe000,0xe000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u23a8
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1800,0x0f00, // u23a9
  0xf000,0x1800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00, // u23ab
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0700,0x0700,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00, // u23ac
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x1800,0xf000, // u23ad
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u23ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23af
  0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23ba
  0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000, // u23bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00, // u23bd
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u23d0
  0xcc00,0xcc00,0xfc00,0xcc00,0xcc00,0xcc00,0x0000,0x3f00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000, // u2409
  0xc000,0xc000,0xc000,0xc000,0xc000,0xf800,0x0000,0x3f00,0x3000,0x3c00,0x3000,0x3000,0x3000,0x0000, // u240a
  0xcc00,0xcc00,0xcc00,0xcc00,0x7800,0x3000,0x0000,0x3f00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000, // u240b
  0xfc00,0xc000,0xf000,0xc000,0xc000,0xc000,0x0000,0x3f00,0x3000,0x3c00,0x3000,0x3000,0x3000,0x0000, // u240c
  0x7800,0xcc00,0xc000,0xc000,0xcc00,0x7800,0x0000,0x3e00,0x3300,0x3300,0x3e00,0x3600,0x3300,0x0000, // u240d
  0xcc00,0xec00,0xfc00,0xdc00,0xcc00,0xcc00,0x0000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3f00,0x0000, // u2424
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2500
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2501
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2502
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2503
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2508
  0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0xaa00,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2509
  0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000, // u250a
  0x3800,0x3800,0x3800,0x0000,0x3800,0x3800,0x0000,0x3800,0x3800,0x3800,0x0000,0x3800,0x3800,0x0000, // u250b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u250e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u250f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2510
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2511
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2512
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2513
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2514
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2515
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2516
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2517
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2518
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2519
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251a
  0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251b
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251c
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251d
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u251f
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2520
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2521
  0x1800,0x1800,0x1800,0x1800,0x1800,0x3f00,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2522
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2523
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2524
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2525
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2526
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2527
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2528
  0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2529
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u252a
  0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u252b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252e
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2530
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2531
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2532
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2533
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2534
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2535
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2536
  0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2537
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2538
  0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2539
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253a
  0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253b
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253c
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253d
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253e
  0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253f
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2540
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2541
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2542
  0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2543
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2544
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2545
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2546
  0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2547
  0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2548
  0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2549
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u254a
  0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u254b
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2550
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2551
  0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800, // u2552
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x7f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2553
  0x0000,0x0000,0x0000,0x0000,0x7f00,0x7f00,0x6000,0x6f00,0x6f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2554
  0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2555
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2556
  0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x0c00,0xec00,0xec00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2557
  0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2558
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x7f00,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2559
  0x6c00,0x6c00,0x6c00,0x6c00,0x6f00,0x6f00,0x6000,0x7f00,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000, // u255a
  0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u255b
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255c
  0x6c00,0x6c00,0x6c00,0x6c00,0xec00,0xec00,0x0c00,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u255d
  0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800, // u255e
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6f00,0x6f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u255f
  0x6c00,0x6c00,0x6c00,0x6c00,0x6f00,0x6f00,0x6000,0x6f00,0x6f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2560
  0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2561
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xec00,0xec00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2562
  0x6c00,0x6c00,0x6c00,0x6c00,0xec00,0xec00,0x0c00,0xec00,0xec00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2563
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800, // u2564
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2565
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0xef00,0xef00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2566
  0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2567
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2568
  0x6c00,0x6c00,0x6c00,0x6c00,0xef00,0xef00,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2569
  0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800, // u256a
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xff00,0xff00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u256b
  0x6c00,0x6c00,0x6c00,0x6c00,0xef00,0xef00,0x0000,0xef00,0xef00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u256c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0700,0x0f00,0x1c00,0x1800,0x1800,0x1800,0x1800,0x1800, // u256d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0xf000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800, // u256e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x3800,0xf000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u256f
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1c00,0x0f00,0x0700,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2570
  0x0100,0x0300,0x0200,0x0600,0x0400,0x0c00,0x0800,0x1800,0x1000,0x3000,0x2000,0x6000,0x4000,0xc000, // u2571
  0xc000,0x4000,0x6000,0x2000,0x3000,0x1000,0x1800,0x0800,0x0c00,0x0400,0x0600,0x0200,0x0300,0x0100, // u2572
  0xc100,0x4300,0x6200,0x2600,0x3400,0x1c00,0x1800,0x1800,0x1c00,0x3400,0x2600,0x6200,0x4300,0xc100, // u2573
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2574
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2575
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2576
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2577
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2578
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2579
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u257b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257c
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u257d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257e
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u257f
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2580
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00, // u2581
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00, // u2582
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00, // u2583
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2584
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2585
  0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2586
  0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2587
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2588
  0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00, // u2589
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u258a
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800, // u258b
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u258c
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u258d
  0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000, // u258e
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000, // u258f
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2590
  0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200, // u2591
  0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500, // u2592
  0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00, // u2593
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u2596
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2597
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2598
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2599
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259a
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259b
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259c
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u259d
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259e
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u259f
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x0000,0x0000,0x0000,0x0000, // u25a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xfe00,0xfe00,0xfe00,0x0000,0x0000, // u25ac
  0x0000,0x0000,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0x0000,0x0000, // u25ae
  0x0000,0x0000,0x0000,0x1800,0x1800,0x3c00,0x3c00,0x7e00,0x7e00,0xff00,0xff00,0x0000,0x0000,0x0000, // u25b2
  0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000, // u25b6
  0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000, // u25ba
  0x0000,0x0000,0x0000,0xff00,0xff00,0x7e00,0x7e00,0x3c00,0x3c00,0x1800,0x1800,0x0000,0x0000,0x0000, // u25bc
  0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000, // u25c0
  0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000, // u25c4
  0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x7e00,0xff00,0x7e00,0x3c00,0x1800,0x0000,0x0000,0x0000, // u25c6
  0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x6600,0xc300,0x6600,0x3c00,0x1800,0x0000,0x0000,0x0000, // u25ca
  0x0000,0x0000,0x0000,0x0000,0x3c00,0x6600,0x4200,0x4200,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000, // u25cb
  0x0000,0x0000,0x0000,0x0000,0x3c00,0x7e00,0x7e00,0x7e00,0x7e00,0x3c00,0x0000,0x0000,0x0000,0x0000, // u25cf
  0xff00,0xff00,0xff00,0xff00,0xff00,0xe700,0xc300,0xc300,0xe700,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d8
  0xff00,0xff00,0xff00,0xff00,0xc300,0x9900,0xbd00,0xbd00,0x9900,0xc300,0xff00,0xff00,0xff00,0xff00, // u25d9
  0x0000,0x0000,0x7c00,0x8200,0xaa00,0x8200,0x8200,0xba00,0x9200,0x8200,0x8200,0x7c00,0x0000,0x0000, // u263a
  0x0000,0x0000,0x7c00,0xfe00,0xd600,0xfe00,0xfe00,0xc600,0xee00,0xfe00,0xfe00,0x7c00,0x0000,0x0000, // u263b
  0x0000,0x0000,0x0000,0x1800,0xdb00,0x7e00,0x3c00,0xe700,0x3c00,0x7e00,0xdb00,0x1800,0x0000,0x0000, // u263c
  0x0000,0x0000,0x3c00,0x6600,0x6600,0x6600,0x6600,0x3c00,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000, // u2640
  0x0000,0x0000,0x3e00,0x0e00,0x1a00,0x3200,0x7800,0xcc00,0xcc00,0xcc00,0xcc00,0x7800,0x0000,0x0000, // u2642
  0x0000,0x0000,0x1800,0x1800,0x3c00,0x7e00,0xff00,0xff00,0x7e00,0x1800,0x1800,0x3c00,0x0000,0x0000, // u2660
  0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x5a00,0xff00,0xff00,0x5a00,0x1800,0x3c00,0x0000,0x0000, // u2663
  0x0000,0x0000,0x0000,0x6c00,0xfe00,0xfe00,0xfe00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000, // u2665
  0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x7e00,0xff00,0x7e00,0x3c00,0x1800,0x0000,0x0000,0x0000, // u2666
  0x0000,0x0000,0x7e00,0x6600,0x7e00,0x6000,0x6000,0x6000,0x6000,0x6000,0xe000,0xc000,0x0000,0x0000, // u266a
  0x0000,0x0000,0x7e00,0x6600,0x7e00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6e00,0xec00,0xc000,0x0000, // u266b
  0x0000,0x0000,0x0300,0x0300,0x0600,0x0600,0xcc00,0xcc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000, // u2713
  0x0000,0x0000,0x0700,0x0700,0x0e00,0x0e00,0xdc00,0xfc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000, // u2714
  0x0000,0x0000,0x0c00,0xcc00,0x7800,0x3800,0x3800,0x3c00,0x6600,0x6000,0xc000,0xc000,0x0000,0x0000, // u2717
  0x0000,0x0000,0x0e00,0xee00,0x7c00,0x3c00,0x3c00,0x3e00,0x7700,0x7300,0xe000,0xe000,0x0000,0x0000, // u2718
  0x0000,0x0000,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x0000,0x0000, // u27e8
  0x0000,0x0000,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x0000,0x0000, // u27e9
  0x0000,0x0000,0x3600,0x3600,0x6c00,0x6c00,0xd800,0xd800,0x6c00,0x6c00,0x3600,0x3600,0x0000,0x0000, // u27ea
  0x0000,0x0000,0xd800,0xd800,0x6c00,0x6c00,0x3600,0x3600,0x6c00,0x6c00,0xd800,0xd800,0x0000,0x0000, // u27eb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2800
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2801
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2802
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2803
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2804
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2805
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2806
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2807
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2808
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2809
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280a
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u280c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u280d
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u280e
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u280f
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2810
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2811
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2812
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2813
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2814
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2815
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2816
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2817
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2818
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2819
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281a
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281b
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u281c
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u281d
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u281e
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u281f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2820
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2821
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2822
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2823
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2824
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2825
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2826
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2827
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2828
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2829
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u282a
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u282b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u282c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u282d
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u282e
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u282f
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2830
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2831
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2832
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2833
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2834
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2835
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2836
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2837
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2838
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u2839
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u283a
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u283b
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u283c
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u283d
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u283e
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u283f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2840
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2841
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2842
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2843
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2844
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2845
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2846
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2847
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2848
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2849
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284a
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u284c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u284d
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u284e
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u284f
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2850
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2851
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2852
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2853
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2854
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2855
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2856
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u2857
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2858
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2859
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285a
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285b
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u285c
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u285d
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u285e
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000, // u285f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2860
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2861
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2862
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2863
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2864
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2865
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2866
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2867
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2868
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2869
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u286a
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u286b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u286c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u286d
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u286e
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u286f
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2870
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2871
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2872
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2873
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2874
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2875
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2876
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u2877
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2878
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u2879
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u287a
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000, // u287b
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u287c
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u287d
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u287e
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000, // u287f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2880
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2881
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2882
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2883
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2884
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2885
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2886
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2887
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2888
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2889
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288a
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u288c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u288d
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u288e
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u288f
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2890
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2891
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2892
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2893
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2894
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2895
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2896
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u2897
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2898
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2899
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289a
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289b
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u289c
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u289d
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u289e
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000, // u289f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28a0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28a1
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28a2
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28a3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28a4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28a5
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28a6
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28a7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28a8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28a9
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28aa
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28ab
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28ac
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28ad
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28ae
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28af
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28b0
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28b1
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28b2
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28b3
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28b4
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28b5
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28b6
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28b7
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28b8
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28b9
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28ba
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000, // u28bb
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28bc
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28bd
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28be
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000, // u28bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c1
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c2
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28c4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28c5
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28c6
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28c7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c9
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ca
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28cb
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28cc
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28cd
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28ce
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28cf
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d0
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d1
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d2
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d3
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28d4
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28d5
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28d6
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28d7
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d8
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d9
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28da
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28db
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28dc
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28dd
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28de
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000, // u28df
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28e0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28e1
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28e2
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28e3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28e4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28e5
  0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28e6
  0x0000,0x6000,0x6000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28e7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28e8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28e9
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28ea
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28eb
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28ec
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28ed
  0x0000,0x0600,0x0600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28ee
  0x0000,0x6600,0x6600,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28ef
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28f0
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28f1
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28f2
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28f3
  0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28f4
  0x0000,0x6000,0x6000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28f5
  0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28f6
  0x0000,0x6000,0x6000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28f7
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28f8
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28f9
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28fa
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000, // u28fb
  0x0000,0x0600,0x0600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28fc
  0x0000,0x6600,0x6600,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28fd
  0x0000,0x0600,0x0600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28fe
  0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000, // u28ff
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x0000,0x0000,0x0000,0xc600,0xc600,0x0000,0x0000, // u2e2c
  0xc000,0xcc00,0xde00,0xff00,0xcc00,0xcc00,0xcc00,0x9800,0x3000,0x6000,0xc000,0xc000,0xc000,0xc000, // ue0a0
  0xc000,0xc000,0xc000,0xc000,0xc000,0xfc00,0x0000,0x3300,0x3b00,0x3f00,0x3700,0x3300,0x3300,0x0000, // ue0a1
  0x3c00,0x6600,0x6600,0x6600,0x6600,0xff00,0xff00,0xe700,0xc300,0xe700,0xff00,0xff00,0xff00,0x0000, // ue0a2
  0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xfe00,0xfc00,0xf800,0xf000,0xe000,0xc000,0x8000, // ue0b0
  0x8000,0xc000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0x8000, // ue0b1
  0x0100,0x0300,0x0700,0x0f00,0x1f00,0x3f00,0x7f00,0x7f00,0x3f00,0x1f00,0x0f00,0x0700,0x0300,0x0100, // ue0b2
  0x0100,0x0300,0x0600,0x0c00,0x1800,0x3000,0x6000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0300,0x0100, // ue0b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00, // uf6be
  0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x0000,0x0000 // ufffd
  };
  // codepoints array
  constexpr std::array<uint16_t, CHARCOUNT> fixedfont_codepoints = {
  0x0000,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,
  0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,
  0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,
  0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,
  0x005f,0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff,
  0x0100,0x0101,0x0102,0x0103,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x010c,0x010d,0x010e,0x010f,
  0x0110,0x0111,0x0112,0x0113,0x0114,0x0115,0x0116,0x0117,0x0118,0x0119,0x011a,0x011b,0x011c,0x011d,0x011e,0x011f,
  0x0120,0x0121,0x0122,0x0123,0x0124,0x0125,0x0126,0x0127,0x0128,0x0129,0x012a,0x012b,0x012c,0x012d,0x012e,0x012f,
  0x0130,0x0131,0x0132,0x0133,0x0134,0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x013d,0x013e,0x013f,
  0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,0x0149,0x014a,0x014b,0x014c,0x014d,0x014e,0x014f,
  0x0150,0x0151,0x0152,0x0153,0x0154,0x0155,0x0156,0x0157,0x0158,0x0159,0x015a,0x015b,0x015c,0x015d,0x015e,0x015f,
  0x0160,0x0161,0x0162,0x0163,0x0164,0x0165,0x0166,0x0167,0x0168,0x0169,0x016a,0x016b,0x016c,0x016d,0x016e,0x016f,
  0x0170,0x0171,0x0172,0x0173,0x0174,0x0175,0x0176,0x0177,0x0178,0x0179,0x017a,0x017b,0x017c,0x017d,0x017e,0x017f,
  0x0186,0x018e,0x018f,0x0190,0x0192,0x019d,0x019e,0x01b5,0x01b6,0x01b7,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d2,
  0x01d3,0x01d4,0x01e2,0x01e3,0x01e4,0x01e5,0x01e6,0x01e7,0x01e8,0x01e9,0x01ea,0x01eb,0x01ec,0x01ed,0x01ee,0x01ef,
  0x01f0,0x01f4,0x01f5,0x01fc,0x01fd,0x01fe,0x01ff,0x0218,0x0219,0x021a,0x021b,0x0232,0x0233,0x0237,0x0254,0x0258,
  0x0259,0x025b,0x0272,0x0292,0x02bb,0x02bc,0x02bd,0x02c6,0x02c7,0x02d8,0x02d9,0x02db,0x02dc,0x02dd,0x0300,0x0301,
  0x0302,0x0303,0x0304,0x0305,0x0306,0x0307,0x0308,0x030a,0x030b,0x030c,0x0329,0x0384,0x0385,0x0386,0x0387,0x0388,
  0x0389,0x038a,0x038c,0x038e,0x038f,0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
  0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03aa,0x03ab,
  0x03ac,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,
  0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x03ca,0x03cb,
  0x03cc,0x03cd,0x03ce,0x03d1,0x03d5,0x03f0,0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,0x03f6,0x0400,0x0401,0x0402,0x0403,
  0x0404,0x0405,0x0406,0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,0x0411,0x0412,0x0413,
  0x0414,0x0415,0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,
  0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,0x0431,0x0432,0x0433,
  0x0434,0x0435,0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,
  0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x0450,0x0451,0x0452,0x0453,
  0x0454,0x0455,0x0456,0x0457,0x0458,0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0462,0x0463,0x046a,0x046b,
  0x0490,0x0491,0x0492,0x0493,0x0494,0x0495,0x0496,0x0497,0x0498,0x0499,0x049a,0x049b,0x049c,0x049d,0x04a0,0x04a1,
  0x04a2,0x04a3,0x04a4,0x04a5,0x04aa,0x04ab,0x04ae,0x04af,0x04b0,0x04b1,0x04b2,0x04b3,0x04b6,0x04b7,0x04b8,0x04b9,
  0x04ba,0x04bb,0x04c0,0x04c1,0x04c2,0x04cf,0x04d0,0x04d1,0x04d2,0x04d3,0x04d4,0x04d5,0x04d6,0x04d7,0x04d8,0x04d9,
  0x04da,0x04db,0x04dc,0x04dd,0x04de,0x04df,0x04e2,0x04e3,0x04e4,0x04e5,0x04e6,0x04e7,0x04e8,0x04e9,0x04ea,0x04eb,
  0x04ec,0x04ed,0x04ee,0x04ef,0x04f0,0x04f1,0x04f2,0x04f3,0x04f4,0x04f5,0x04f8,0x04f9,0x05d0,0x05d1,0x05d2,0x05d3,
  0x05d4,0x05d5,0x05d6,0x05d7,0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,0x05e0,0x05e1,0x05e2,0x05e3,
  0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,0x05ea,0x1e0c,0x1e0d,0x1e34,0x1e35,0x1e36,0x1e37,0x1e40,0x1e41,0x1e42,
  0x1e43,0x1e44,0x1e45,0x1e46,0x1e47,0x1e6c,0x1e6d,0x1eb8,0x1eb9,0x1ebc,0x1ebd,0x1eca,0x1ecb,0x1ecc,0x1ecd,0x1ee4,
  0x1ee5,0x1ef8,0x1ef9,0x2000,0x2001,0x2002,0x2003,0x2004,0x2005,0x2006,0x2007,0x2008,0x2009,0x200a,0x200b,0x200c,
  0x200d,0x200e,0x200f,0x2010,0x2011,0x2012,0x2013,0x2014,0x2015,0x2016,0x2017,0x2018,0x2019,0x201a,0x201b,0x201c,
  0x201d,0x201e,0x201f,0x2020,0x2021,0x2022,0x2026,0x2030,0x2032,0x2033,0x2039,0x203a,0x203c,0x203e,0x2070,0x2071,
  0x2074,0x2075,0x2076,0x2077,0x2078,0x2079,0x207a,0x207b,0x207c,0x207d,0x207e,0x207f,0x2080,0x2081,0x2082,0x2083,
  0x2084,0x2085,0x2086,0x2087,0x2088,0x2089,0x208a,0x208b,0x208c,0x208d,0x208e,0x2090,0x2091,0x2092,0x2093,0x2094,
  0x2095,0x2096,0x2097,0x2098,0x209a,0x20a7,0x20aa,0x20ac,0x20ae,0x2102,0x210e,0x210f,0x2115,0x2116,0x211a,0x211d,
  0x2122,0x2124,0x2126,0x2135,0x2190,0x2191,0x2192,0x2193,0x2194,0x2195,0x21a4,0x21a6,0x21a8,0x21b5,0x21bb,0x21cb,
  0x21cc,0x21d0,0x21d1,0x21d2,0x21d3,0x21d4,0x21d5,0x2200,0x2203,0x2204,0x2205,0x2206,0x2207,0x2208,0x2209,0x220a,
  0x220b,0x220c,0x220d,0x2212,0x2213,0x2214,0x2215,0x2216,0x2219,0x221a,0x221e,0x221f,0x2225,0x2227,0x2228,0x2229,
  0x222a,0x2248,0x2260,0x2261,0x2264,0x2265,0x226a,0x226b,0x2282,0x2283,0x2286,0x2287,0x22a5,0x22c2,0x22c3,0x2300,
  0x2302,0x2308,0x2309,0x230a,0x230b,0x2310,0x2319,0x2320,0x2321,0x239b,0x239c,0x239d,0x239e,0x239f,0x23a0,0x23a1,
  0x23a2,0x23a3,0x23a4,0x23a5,0x23a6,0x23a7,0x23a8,0x23a9,0x23ab,0x23ac,0x23ad,0x23ae,0x23af,0x23ba,0x23bb,0x23bc,
  0x23bd,0x23d0,0x2409,0x240a,0x240b,0x240c,0x240d,0x2424,0x2500,0x2501,0x2502,0x2503,0x2508,0x2509,0x250a,0x250b,
  0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513,0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251a,0x251b,
  0x251c,0x251d,0x251e,0x251f,0x2520,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252a,0x252b,
  0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b,
  0x253c,0x253d,0x253e,0x253f,0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254a,0x254b,
  0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f,
  0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f,
  0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2577,0x2578,0x2579,0x257a,0x257b,0x257c,0x257d,0x257e,0x257f,
  0x2580,0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,0x258e,0x258f,
  0x2590,0x2591,0x2592,0x2593,0x2596,0x2597,0x2598,0x2599,0x259a,0x259b,0x259c,0x259d,0x259e,0x259f,0x25a0,0x25ac,
  0x25ae,0x25b2,0x25b6,0x25ba,0x25bc,0x25c0,0x25c4,0x25c6,0x25ca,0x25cb,0x25cf,0x25d8,0x25d9,0x263a,0x263b,0x263c,
  0x2640,0x2642,0x2660,0x2663,0x2665,0x2666,0x266a,0x266b,0x2713,0x2714,0x2717,0x2718,0x27e8,0x27e9,0x27ea,0x27eb,
  0x2800,0x2801,0x2802,0x2803,0x2804,0x2805,0x2806,0x2807,0x2808,0x2809,0x280a,0x280b,0x280c,0x280d,0x280e,0x280f,
  0x2810,0x2811,0x2812,0x2813,0x2814,0x2815,0x2816,0x2817,0x2818,0x2819,0x281a,0x281b,0x281c,0x281d,0x281e,0x281f,
  0x2820,0x2821,0x2822,0x2823,0x2824,0x2825,0x2826,0x2827,0x2828,0x2829,0x282a,0x282b,0x282c,0x282d,0x282e,0x282f,
  0x2830,0x2831,0x2832,0x2833,0x2834,0x2835,0x2836,0x2837,0x2838,0x2839,0x283a,0x283b,0x283c,0x283d,0x283e,0x283f,
  0x2840,0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847,0x2848,0x2849,0x284a,0x284b,0x284c,0x284d,0x284e,0x284f,
  0x2850,0x2851,0x2852,0x2853,0x2854,0x2855,0x2856,0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e,0x285f,
  0x2860,0x2861,0x2862,0x2863,0x2864,0x2865,0x2866,0x2867,0x2868,0x2869,0x286a,0x286b,0x286c,0x286d,0x286e,0x286f,
  0x2870,0x2871,0x2872,0x2873,0x2874,0x2875,0x2876,0x2877,0x2878,0x2879,0x287a,0x287b,0x287c,0x287d,0x287e,0x287f,
  0x2880,0x2881,0x2882,0x2883,0x2884,0x2885,0x2886,0x2887,0x2888,0x2889,0x288a,0x288b,0x288c,0x288d,0x288e,0x288f,
  0x2890,0x2891,0x2892,0x2893,0x2894,0x2895,0x2896,0x2897,0x2898,0x2899,0x289a,0x289b,0x289c,0x289d,0x289e,0x289f,
  0x28a0,0x28a1,0x28a2,0x28a3,0x28a4,0x28a5,0x28a6,0x28a7,0x28a8,0x28a9,0x28aa,0x28ab,0x28ac,0x28ad,0x28ae,0x28af,
  0x28b0,0x28b1,0x28b2,0x28b3,0x28b4,0x28b5,0x28b6,0x28b7,0x28b8,0x28b9,0x28ba,0x28bb,0x28bc,0x28bd,0x28be,0x28bf,
  0x28c0,0x28c1,0x28c2,0x28c3,0x28c4,0x28c5,0x28c6,0x28c7,0x28c8,0x28c9,0x28ca,0x28cb,0x28cc,0x28cd,0x28ce,0x28cf,
  0x28d0,0x28d1,0x28d2,0x28d3,0x28d4,0x28d5,0x28d6,0x28d7,0x28d8,0x28d9,0x28da,0x28db,0x28dc,0x28dd,0x28de,0x28df,
  0x28e0,0x28e1,0x28e2,0x28e3,0x28e4,0x28e5,0x28e6,0x28e7,0x28e8,0x28e9,0x28ea,0x28eb,0x28ec,0x28ed,0x28ee,0x28ef,
  0x28f0,0x28f1,0x28f2,0x28f3,0x28f4,0x28f5,0x28f6,0x28f7,0x28f8,0x28f9,0x28fa,0x28fb,0x28fc,0x28fd,0x28fe,0x28ff,
  0x2e2c,0xe0a0,0xe0a1,0xe0a2,0xe0b0,0xe0b1,0xe0b2,0xe0b3,0xf6be,0xfffd };
} // namespace
// -- end of autogenerated text ---

namespace fixed_font_16n {
  // -- start of autogenerated text ---
  // definition section for font: ter-u16n.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 8;
  constexpr int HEIGHT = 16;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u16n.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    false // bold
  };
  // font bitmap definitions
  constexpr std::array<uint16_t, CHARCOUNT * HEIGHT> fixedfont_bitmap = {
  0x0000,0x0000,0x6600,0x4200,0x0000,0x4200,0x4200,0x4200,0x0000,0x4200,0x4200,0x6600,0x0000,0x0000,0x0000,0x0000, // u0000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0020
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0021
  0x0000,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0022
  0x0000,0x0000,0x2400,0x2400,0x2400,0x7e00,0x2400,0x2400,0x7e00,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000, // u0023
  0x0000,0x1000,0x1000,0x7c00,0x9200,0x9000,0x9000,0x7c00,0x1200,0x1200,0x9200,0x7c00,0x1000,0x1000,0x0000,0x0000, // u0024
  0x0000,0x0000,0x6400,0x9400,0x6800,0x0800,0x1000,0x1000,0x2000,0x2c00,0x5200,0x4c00,0x0000,0x0000,0x0000,0x0000, // u0025
  0x0000,0x0000,0x1800,0x2400,0x2400,0x1800,0x3000,0x4a00,0x4400,0x4400,0x4400,0x3a00,0x0000,0x0000,0x0000,0x0000, // u0026
  0x0000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0027
  0x0000,0x0000,0x0800,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000, // u0028
  0x0000,0x0000,0x2000,0x1000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1000,0x2000,0x0000,0x0000,0x0000,0x0000, // u0029
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x1800,0x7e00,0x1800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2000,0x0000,0x0000,0x0000, // u002c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u002e
  0x0000,0x0000,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u002f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0030
  0x0000,0x0000,0x0800,0x1800,0x2800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0031
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0032
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0033
  0x0000,0x0000,0x0200,0x0600,0x0a00,0x1200,0x2200,0x4200,0x7e00,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u0034
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7c00,0x0200,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0035
  0x0000,0x0000,0x1c00,0x2000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0036
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0037
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x3c00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0038
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0400,0x3800,0x0000,0x0000,0x0000,0x0000, // u0039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u003a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2000,0x0000,0x0000,0x0000, // u003b
  0x0000,0x0000,0x0000,0x0400,0x0800,0x1000,0x2000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0000,0x0000,0x0000,0x0000, // u003c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u003d
  0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0800,0x1000,0x2000,0x4000,0x0000,0x0000,0x0000,0x0000, // u003e
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x0400,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u003f
  0x0000,0x0000,0x7c00,0x8200,0x9e00,0xa200,0xa200,0xa200,0xa600,0x9a00,0x8000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0040
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0041
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0042
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0043
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000,0x0000,0x0000, // u0044
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0045
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0046
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0047
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0048
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0049
  0x0000,0x0000,0x0e00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u004a
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u004b
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u004c
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u004d
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u004e
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u004f
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0050
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4a00,0x3c00,0x0200,0x0000,0x0000,0x0000, // u0051
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u0052
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0053
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0054
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0055
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x2400,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0056
  0x0000,0x0000,0x8200,0x8200,0x8200,0x8200,0x8200,0x9200,0x9200,0xaa00,0xc600,0x8200,0x0000,0x0000,0x0000,0x0000, // u0057
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0058
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0059
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u005a
  0x0000,0x0000,0x3800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3800,0x0000,0x0000,0x0000,0x0000, // u005b
  0x0000,0x0000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000, // u005c
  0x0000,0x0000,0x3800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3800,0x0000,0x0000,0x0000,0x0000, // u005d
  0x0000,0x1000,0x2800,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u005e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000, // u005f
  0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0060
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0061
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0062
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0063
  0x0000,0x0000,0x0200,0x0200,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0064
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0065
  0x0000,0x0000,0x0e00,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0066
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0067
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0068
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0069
  0x0000,0x0000,0x0400,0x0400,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // u006a
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u006b
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u006c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u006d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u006e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u006f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x0000, // u0070
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0000, // u0071
  0x0000,0x0000,0x0000,0x0000,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0072
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0073
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0000,0x0000,0x0000, // u0074
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0075
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0076
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0077
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x1800,0x2400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0078
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0079
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u007a
  0x0000,0x0000,0x0c00,0x1000,0x1000,0x1000,0x2000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000, // u007b
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u007c
  0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0400,0x0800,0x0800,0x0800,0x0800,0x3000,0x0000,0x0000,0x0000,0x0000, // u007d
  0x0000,0x6200,0x9200,0x8c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u007e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a0
  0x0000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u00a1
  0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x9200,0x9000,0x9000,0x9000,0x9200,0x7c00,0x1000,0x1000,0x0000,0x0000, // u00a2
  0x0000,0x0000,0x1800,0x2400,0x2000,0x2000,0x7800,0x2000,0x2000,0x2000,0x2200,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00a3
  0x0000,0x0000,0x0000,0x0000,0x4400,0x3800,0x4400,0x4400,0x4400,0x3800,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a4
  0x0000,0x0000,0x8200,0x8200,0x4400,0x2800,0x1000,0x7c00,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u00a5
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u00a6
  0x0000,0x3800,0x4400,0x4000,0x3000,0x4800,0x4400,0x4400,0x2400,0x1800,0x0400,0x4400,0x3800,0x0000,0x0000,0x0000, // u00a7
  0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a8
  0x0000,0x0000,0x0000,0x7e00,0x8100,0x9900,0xa500,0xa100,0xa500,0x9900,0x8100,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00a9
  0x0000,0x3800,0x0400,0x3c00,0x4400,0x3c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1200,0x2400,0x4800,0x9000,0x4800,0x2400,0x1200,0x0000,0x0000,0x0000,0x0000, // u00ab
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ac
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ad
  0x0000,0x0000,0x0000,0x7e00,0x8100,0xb900,0xa500,0xb900,0xa900,0xa500,0x8100,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00ae
  0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00af
  0x0000,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00b1
  0x0000,0x1800,0x2400,0x0400,0x0800,0x1000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b2
  0x0000,0x3800,0x0400,0x1800,0x0400,0x0400,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b3
  0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4600,0x7a00,0x4000,0x4000,0x4000,0x0000, // u00b5
  0x0000,0x0000,0x7e00,0x9200,0x9200,0x9200,0x9200,0x7200,0x1200,0x1200,0x1200,0x1200,0x0000,0x0000,0x0000,0x0000, // u00b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2000,0x0000, // u00b8
  0x0000,0x1000,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b9
  0x0000,0x3800,0x4400,0x4400,0x4400,0x3800,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9000,0x4800,0x2400,0x1200,0x2400,0x4800,0x9000,0x0000,0x0000,0x0000,0x0000, // u00bb
  0x0000,0x2000,0x6000,0x2000,0x2200,0x2400,0x0800,0x1000,0x2200,0x4600,0x8a00,0x1e00,0x0200,0x0200,0x0000,0x0000, // u00bc
  0x0000,0x2000,0x6000,0x2000,0x2200,0x2400,0x0800,0x1000,0x2000,0x4c00,0x9200,0x0400,0x0800,0x1e00,0x0000,0x0000, // u00bd
  0x0000,0xe000,0x1000,0x6000,0x1200,0xe400,0x0800,0x1000,0x2200,0x4600,0x8a00,0x1e00,0x0200,0x0200,0x0000,0x0000, // u00be
  0x0000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x2000,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00bf
  0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00c0
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00c1
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00c2
  0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00c3
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00c4
  0x1800,0x2400,0x1800,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00c5
  0x0000,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000,0x0000,0x0000, // u00c6
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x1000,0x1000,0x2000,0x0000, // u00c7
  0x1000,0x0800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00c8
  0x0800,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00c9
  0x1800,0x2400,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00ca
  0x2400,0x2400,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00cb
  0x2000,0x1000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00cc
  0x0800,0x1000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00cd
  0x1800,0x2400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00ce
  0x4400,0x4400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00cf
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0xf200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000,0x0000,0x0000, // u00d0
  0x3200,0x4c00,0x0000,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00d1
  0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d2
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d3
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d4
  0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d5
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x2400,0x1800,0x1800,0x2400,0x4200,0x0000,0x0000,0x0000,0x0000,0x0000, // u00d7
  0x0000,0x0000,0x3c00,0x4300,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0xc200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d8
  0x1000,0x0800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00d9
  0x0800,0x1000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00da
  0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00db
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00dc
  0x0800,0x1000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u00dd
  0x0000,0x0000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u00de
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4800,0x7c00,0x4200,0x4200,0x4200,0x6200,0x5c00,0x0000,0x0000,0x0000,0x0000, // u00df
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00e0
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00e1
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00e2
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00e3
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00e4
  0x0000,0x0000,0x1800,0x2400,0x1800,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u00e6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x1000,0x1000,0x2000,0x0000, // u00e7
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00e8
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00e9
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00ea
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00eb
  0x0000,0x0000,0x2000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00ec
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00ed
  0x0000,0x0000,0x3000,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00ee
  0x0000,0x0000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u00ef
  0x0000,0x0000,0x2800,0x1000,0x2800,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00f0
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u00f1
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00f2
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00f3
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00f4
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00f5
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00f6
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x7c00,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00f7
  0x0000,0x0000,0x0000,0x0000,0x0200,0x3c00,0x4600,0x4a00,0x5200,0x6200,0x4200,0xbc00,0x0000,0x0000,0x0000,0x0000, // u00f8
  0x0000,0x0000,0x1000,0x0800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00f9
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00fa
  0x0000,0x0000,0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00fb
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u00fc
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u00fd
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x0000, // u00fe
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u00ff
  0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0100
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0101
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0102
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0103
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0200,0x0400,0x0300,0x0000, // u0104
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0400,0x0300,0x0000, // u0105
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0106
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0107
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0108
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0109
  0x1000,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u010a
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u010b
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u010c
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u010d
  0x2400,0x1800,0x0000,0x7800,0x4400,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000,0x0000,0x0000, // u010e
  0x2400,0x1800,0x0200,0x0200,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u010f
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0xf200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x0000,0x0000,0x0000, // u0110
  0x0000,0x0000,0x0200,0x0f00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0111
  0x3c00,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0112
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0113
  0x2400,0x1800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0114
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0115
  0x1000,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0116
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0117
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0200,0x0400,0x0300,0x0000, // u0118
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0800,0x1000,0x0c00,0x0000, // u0119
  0x2400,0x1800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u011a
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u011b
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u011c
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u011d
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u011e
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u011f
  0x1000,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0120
  0x0000,0x0000,0x0800,0x0800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0121
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x1000,0x1000,0x2000, // u0122
  0x0000,0x0400,0x0800,0x0800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0123
  0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0124
  0x0c00,0x1200,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0125
  0x0000,0x0000,0x4200,0xff00,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0126
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0127
  0x3200,0x4c00,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0128
  0x0000,0x0000,0x3400,0x5800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0129
  0x7c00,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u012a
  0x0000,0x0000,0x0000,0x7800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u012b
  0x2400,0x1800,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u012c
  0x0000,0x0000,0x4800,0x3000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u012d
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x2000,0x1800,0x0000, // u012e
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x1000,0x2000,0x1800,0x0000, // u012f
  0x1000,0x1000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0130
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0131
  0x0000,0x0000,0xe700,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x5200,0x5200,0xec00,0x0000,0x0000,0x0000,0x0000, // u0132
  0x0000,0x0000,0x4200,0x4200,0x0000,0xc600,0x4200,0x4200,0x4200,0x4200,0x4200,0xe200,0x1200,0x1200,0x0c00,0x0000, // u0133
  0x0c00,0x1200,0x0000,0x0e00,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u0134
  0x0000,0x0000,0x0c00,0x1200,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // u0135
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x1000,0x1000,0x2000, // u0136
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x1000,0x1000,0x2000, // u0137
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u0138
  0x2000,0x4000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0139
  0x0800,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u013a
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x1000,0x1000,0x2000, // u013b
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x1000,0x1000,0x2000, // u013c
  0x2400,0x1800,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u013d
  0x4800,0x3000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u013e
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4400,0x4400,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u013f
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1100,0x1100,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0140
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x6000,0xc000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0141
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1800,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0142
  0x0800,0x1000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0143
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0144
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x1000,0x1000,0x2000, // u0145
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x1000,0x1000,0x2000, // u0146
  0x2400,0x1800,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0147
  0x0000,0x0000,0x2400,0x1800,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0148
  0x0000,0x4000,0x4000,0x8000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0149
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0200,0x0200,0x0c00,0x0000, // u014a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200,0x0c00,0x0000, // u014b
  0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u014c
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u014d
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u014e
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u014f
  0x1200,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0150
  0x0000,0x0000,0x1200,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0151
  0x0000,0x0000,0x7e00,0x9000,0x9000,0x9000,0x9c00,0x9000,0x9000,0x9000,0x9000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0152
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x9200,0x9200,0x9e00,0x9000,0x9000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0153
  0x0800,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u0154
  0x0000,0x0000,0x0800,0x1000,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0155
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x1000,0x1000,0x2000, // u0156
  0x0000,0x0000,0x0000,0x0000,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x4000,0x4000,0x8000, // u0157
  0x2400,0x1800,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u0158
  0x0000,0x0000,0x2400,0x1800,0x0000,0x5e00,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0159
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u015a
  0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u015b
  0x1800,0x2400,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u015c
  0x0000,0x0000,0x1800,0x2400,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u015d
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x1000,0x1000,0x2000,0x0000, // u015e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x1000,0x1000,0x2000,0x0000, // u015f
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0160
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0161
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0800,0x1000,0x0000, // u0162
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0400,0x0400,0x0800,0x0000, // u0163
  0x2400,0x1800,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0164
  0x2400,0x1800,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0000,0x0000,0x0000, // u0165
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0166
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x3800,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0000,0x0000,0x0000, // u0167
  0x3200,0x4c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0168
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0169
  0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u016a
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u016b
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u016c
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u016d
  0x1800,0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u016e
  0x0000,0x0000,0x1800,0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u016f
  0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0170
  0x0000,0x0000,0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0171
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x1000,0x0c00,0x0000, // u0172
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0400,0x0300,0x0000, // u0173
  0x1800,0x2400,0x0000,0x8200,0x8200,0x8200,0x8200,0x9200,0x9200,0xaa00,0xc600,0x8200,0x0000,0x0000,0x0000,0x0000, // u0174
  0x0000,0x0000,0x1800,0x2400,0x0000,0x8200,0x8200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0175
  0x1800,0x2400,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0176
  0x0000,0x0000,0x1800,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0177
  0x4400,0x4400,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0178
  0x0800,0x1000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0179
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u017a
  0x1000,0x1000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u017b
  0x0000,0x0000,0x1000,0x1000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u017c
  0x2400,0x1800,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u017d
  0x0000,0x0000,0x2400,0x1800,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u017e
  0x0000,0x0000,0x0e00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u017f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x0200,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0186
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0200,0x1e00,0x0200,0x0200,0x0200,0x0200,0x7e00,0x0000,0x0000,0x0000,0x0000, // u018e
  0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u018f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x3800,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0190
  0x0000,0x0000,0x0c00,0x1200,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x9000,0x6000,0x0000, // u0192
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x4000,0x4000,0x8000,0x0000, // u019d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200,0x0200,0x0000, // u019e
  0x0000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x7e00,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u01b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0400,0x0800,0x7c00,0x1000,0x2000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u01b6
  0x0000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01b7
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u01cd
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u01ce
  0x2400,0x1800,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u01cf
  0x0000,0x0000,0x4800,0x3000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u01d0
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01d1
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01d2
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01d3
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u01d4
  0x7c00,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000,0x0000,0x0000, // u01e2
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u01e3
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4f00,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01e4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4f00,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u01e5
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01e6
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u01e7
  0x2400,0x1800,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u01e8
  0x2400,0x1800,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u01e9
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x1000,0x0c00,0x0000, // u01ea
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x1000,0x0c00,0x0000, // u01eb
  0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x1000,0x0c00,0x0000, // u01ec
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0800,0x1000,0x0c00,0x0000, // u01ed
  0x2400,0x1800,0x0000,0x7e00,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01ee
  0x0000,0x0000,0x2400,0x1800,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000, // u01ef
  0x0000,0x0000,0x1200,0x0c00,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // u01f0
  0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01f4
  0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u01f5
  0x0800,0x1000,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000,0x0000,0x0000, // u01fc
  0x0000,0x0000,0x0800,0x1000,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u01fd
  0x0800,0x1000,0x0000,0x3d00,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0xc200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01fe
  0x0000,0x0000,0x0800,0x1000,0x0200,0x3c00,0x4600,0x4a00,0x5200,0x6200,0x4200,0xbc00,0x0000,0x0000,0x0000,0x0000, // u01ff
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x1000,0x1000,0x2000, // u0218
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x1000,0x1000,0x2000, // u0219
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x2000, // u021a
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0400,0x0400,0x0800, // u021b
  0x7c00,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0232
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0233
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // u0237
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0254
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0258
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0259
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x3800,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u025b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4000,0x4000,0x8000,0x0000, // u0272
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0200,0x0400,0x0800,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000, // u0292
  0x0800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bb
  0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bc
  0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bd
  0x1800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c6
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c7
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d8
  0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1000,0x0c00,0x0000, // u02db
  0x3200,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dc
  0x1200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dd
  0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0300
  0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0301
  0x1800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0302
  0x3200,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0303
  0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0304
  0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0305
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0306
  0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0307
  0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0308
  0x1800,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030a
  0x1200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030b
  0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000, // u0329
  0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0384
  0x0800,0x1000,0x0000,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0385
  0x4000,0x8000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0386
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0387
  0x4000,0x8000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0388
  0x4000,0x8000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0389
  0x4000,0x8000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u038a
  0x4000,0x8000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u038c
  0x4000,0x8000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u038e
  0x4000,0x8000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x6600,0x0000,0x0000,0x0000,0x0000, // u038f
  0x0800,0x1000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000, // u0390
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0391
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0392
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0393
  0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x4400,0x8200,0x8200,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0394
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0395
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0396
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0397
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x5a00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0398
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0399
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u039a
  0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x4400,0x8200,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u039b
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u039c
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u039d
  0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u039e
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u039f
  0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u03a0
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u03a1
  0x0000,0x0000,0x7e00,0x4000,0x2000,0x1000,0x0800,0x0800,0x1000,0x2000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u03a3
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u03a4
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u03a5
  0x0000,0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000,0x0000,0x0000,0x0000, // u03a6
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u03a7
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u03a8
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x6600,0x0000,0x0000,0x0000,0x0000, // u03a9
  0x4400,0x4400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u03aa
  0x4400,0x4400,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u03ab
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3a00,0x4600,0x4400,0x4400,0x4400,0x4600,0x3a00,0x0000,0x0000,0x0000,0x0000, // u03ac
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4000,0x3800,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03ad
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200,0x0200,0x0000, // u03ae
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000, // u03af
  0x0800,0x1000,0x0000,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3a00,0x4600,0x4400,0x4400,0x4400,0x4600,0x3a00,0x0000,0x0000,0x0000,0x0000, // u03b1
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4800,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x0000, // u03b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000, // u03b3
  0x0000,0x0000,0x3e00,0x1000,0x0800,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x3800,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03b5
  0x0000,0x0000,0x7e00,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x4000,0x3c00,0x0200,0x0200,0x0400,0x0000, // u03b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200,0x0200,0x0000, // u03b7
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u03b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000, // u03b9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u03ba
  0x0000,0x0000,0x2000,0x2000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u03bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4600,0x7a00,0x4000,0x4000,0x4000,0x0000, // u03bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u03bd
  0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x3c00,0x4000,0x4000,0x4000,0x4000,0x3c00,0x0200,0x0200,0x0400,0x0000, // u03be
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u03c0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x0000, // u03c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4000,0x3c00,0x0200,0x0200,0x0400,0x0000, // u03c2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4400,0x4400,0x4400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u03c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000, // u03c4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x1000,0x1000,0x0000, // u03c6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000, // u03c7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x1000,0x1000,0x0000, // u03c8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x8200,0x9200,0x9200,0x9200,0x9200,0x6c00,0x0000,0x0000,0x0000,0x0000, // u03c9
  0x0000,0x0000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0c00,0x0000,0x0000,0x0000,0x0000, // u03ca
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03cb
  0x0000,0x0000,0x0800,0x1000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03cc
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03cd
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4400,0x8200,0x9200,0x9200,0x9200,0x9200,0x6c00,0x0000,0x0000,0x0000,0x0000, // u03ce
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4400,0x3e00,0x0400,0xc400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u03d1
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000,0x0000,0x0000, // u03d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc200,0x2400,0x1800,0x1000,0x3000,0x4800,0x8600,0x0000,0x0000,0x0000,0x0000, // u03f0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x3c00,0x0000, // u03f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03f2
  0x0000,0x0000,0x0400,0x0400,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // u03f3
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03f4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x7c00,0x4000,0x2000,0x1e00,0x0000,0x0000,0x0000,0x0000, // u03f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x3e00,0x0200,0x0400,0x7800,0x0000,0x0000,0x0000,0x0000, // u03f6
  0x1000,0x0800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0400
  0x2400,0x2400,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0401
  0x0000,0x0000,0xf800,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x2400,0x0000,0x0000,0x0000,0x0000, // u0402
  0x0800,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0403
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0404
  0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x3c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0405
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0406
  0x4400,0x4400,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0407
  0x0000,0x0000,0x0e00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u0408
  0x0000,0x0000,0x3000,0x5000,0x9000,0x9c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9c00,0x0000,0x0000,0x0000,0x0000, // u0409
  0x0000,0x0000,0x9000,0x9000,0x9000,0x9c00,0xf200,0x9200,0x9200,0x9200,0x9200,0x9c00,0x0000,0x0000,0x0000,0x0000, // u040a
  0x0000,0x0000,0xf800,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x0000,0x0000,0x0000,0x0000, // u040b
  0x0800,0x1000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u040c
  0x1000,0x0800,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u040d
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u040e
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x1800,0x1800,0x0000,0x0000, // u040f
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0410
  0x0000,0x0000,0x7c00,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0411
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0412
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0413
  0x0000,0x0000,0x3c00,0x4400,0x4400,0x4400,0x4400,0x4400,0x4400,0x4400,0x4400,0xfe00,0x8200,0x0000,0x0000,0x0000, // u0414
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0415
  0x0000,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u0416
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0417
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0418
  0x2400,0x1800,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0419
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u041a
  0x0000,0x0000,0x0e00,0x1200,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x4200,0x0000,0x0000,0x0000,0x0000, // u041b
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u041c
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u041d
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u041e
  0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u041f
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0420
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0421
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0422
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0423
  0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000,0x0000,0x0000, // u0424
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0425
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3f00,0x0100,0x0100,0x0000,0x0000, // u0426
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u0427
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0428
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7f00,0x0100,0x0100,0x0000,0x0000, // u0429
  0x0000,0x0000,0xc000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u042a
  0x0000,0x0000,0x8200,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000,0x0000,0x0000, // u042b
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u042c
  0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x1e00,0x0200,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u042d
  0x0000,0x0000,0x8c00,0x9200,0x9200,0x9200,0x9200,0xf200,0x9200,0x9200,0x9200,0x8c00,0x0000,0x0000,0x0000,0x0000, // u042e
  0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0a00,0x1200,0x2200,0x4200,0x0000,0x0000,0x0000,0x0000, // u042f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0430
  0x0000,0x0000,0x3c00,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0431
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4800,0x7c00,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0432
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0433
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0434
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0435
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u0436
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x1c00,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0437
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0438
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u0439
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u043a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1e00,0x2200,0x2200,0x2200,0x2200,0x2200,0x4200,0x0000,0x0000,0x0000,0x0000, // u043b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x8200,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u043c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u043d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u043e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u043f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x4000,0x4000,0x4000,0x0000, // u0440
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0441
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u0442
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u0443
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0x9200,0x9200,0x9200,0x9200,0x9200,0x7c00,0x1000,0x0000,0x0000,0x0000, // u0444
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x1800,0x2400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u0445
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3f00,0x0100,0x0100,0x0000,0x0000, // u0446
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u0447
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0448
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x7f00,0x0100,0x0100,0x0000,0x0000, // u0449
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u044a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000,0x0000,0x0000, // u044b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x7800,0x4400,0x4400,0x4400,0x7800,0x0000,0x0000,0x0000,0x0000, // u044c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x1e00,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u044d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8c00,0x9200,0x9200,0xf200,0x9200,0x9200,0x8c00,0x0000,0x0000,0x0000,0x0000, // u044e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4200,0x4200,0x3e00,0x1200,0x2200,0x4200,0x0000,0x0000,0x0000,0x0000, // u044f
  0x0000,0x0000,0x1000,0x0800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0450
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0451
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0200,0x0200,0x0c00,0x0000, // u0452
  0x0000,0x0000,0x0800,0x1000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0453
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x7800,0x4000,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0454
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x3c00,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0455
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0456
  0x0000,0x0000,0x4800,0x4800,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u0457
  0x0000,0x0000,0x0400,0x0400,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // u0458
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x9000,0x9c00,0x9200,0x9200,0x9200,0x9c00,0x0000,0x0000,0x0000,0x0000, // u0459
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9000,0x9000,0x9c00,0xf200,0x9200,0x9200,0x9c00,0x0000,0x0000,0x0000,0x0000, // u045a
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u045b
  0x0000,0x0000,0x0800,0x1000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u045c
  0x0000,0x0000,0x1000,0x0800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u045d
  0x0000,0x0000,0x2400,0x1800,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u045e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x1800,0x1800,0x0000,0x0000, // u045f
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0462
  0x0000,0x0000,0x2000,0x2000,0x7800,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0463
  0x0000,0x0000,0xfe00,0x8200,0x4400,0x2800,0x3800,0x5400,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u046a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x4400,0x2800,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u046b
  0x0200,0x0200,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0490
  0x0000,0x0000,0x0000,0x0200,0x0200,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0491
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0xf800,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0492
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0xf800,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u0493
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x0200,0x0400,0x0000,0x0000, // u0494
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x7800,0x4400,0x4400,0x4400,0x0400,0x0800,0x0000,0x0000, // u0495
  0x0000,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x9300,0x0100,0x0100,0x0000,0x0000, // u0496
  0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9300,0x0100,0x0100,0x0000,0x0000, // u0497
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x0200,0x4200,0x4200,0x3c00,0x1000,0x1000,0x1000,0x0000, // u0498
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x0200,0x1c00,0x0200,0x4200,0x3c00,0x1000,0x1000,0x1000,0x0000, // u0499
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4300,0x0100,0x0100,0x0000,0x0000, // u049a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4300,0x0100,0x0100,0x0000,0x0000, // u049b
  0x0000,0x0000,0x4200,0x4200,0x5400,0x5800,0x7000,0x7000,0x5800,0x5400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u049c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x5400,0x5800,0x7000,0x5800,0x5400,0x4200,0x0000,0x0000,0x0000,0x0000, // u049d
  0x0000,0x0000,0xc200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u04a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x0000,0x0000,0x0000, // u04a1
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4300,0x0100,0x0100,0x0000,0x0000, // u04a2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4300,0x0100,0x0100,0x0000,0x0000, // u04a3
  0x0000,0x0000,0x4700,0x4400,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u04a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4700,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000, // u04a5
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x3c00,0x1000,0x1000,0x1000,0x0000, // u04aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4000,0x4000,0x4000,0x4200,0x3c00,0x1000,0x1000,0x1000,0x0000, // u04ab
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u04ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000, // u04af
  0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x7c00,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u04b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x7c00,0x1000,0x1000,0x0000, // u04b1
  0x0000,0x0000,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x2400,0x2400,0x4200,0x4300,0x0100,0x0100,0x0000,0x0000, // u04b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x2400,0x1800,0x2400,0x4200,0x4300,0x0100,0x0100,0x0000,0x0000, // u04b3
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0300,0x0100,0x0100,0x0000,0x0000, // u04b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0300,0x0100,0x0100,0x0000,0x0000, // u04b7
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4a00,0x4a00,0x3e00,0x0a00,0x0a00,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u04b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4a00,0x4a00,0x3e00,0x0a00,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u04b9
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u04ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u04bb
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u04c0
  0x2400,0x1800,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u04c1
  0x0000,0x0000,0x2400,0x1800,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u04c2
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u04cf
  0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u04d0
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u04d1
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u04d2
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x0200,0x3e00,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u04d3
  0x0000,0x0000,0x7e00,0x9000,0x9000,0x9000,0xfc00,0x9000,0x9000,0x9000,0x9000,0x9e00,0x0000,0x0000,0x0000,0x0000, // u04d4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1200,0x7200,0x9e00,0x9000,0x9000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u04d5
  0x2400,0x1800,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u04d6
  0x0000,0x0000,0x2400,0x1800,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04d7
  0x0000,0x0000,0x3c00,0x4200,0x0200,0x0200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04d8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04d9
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x0200,0x7e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04da
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x0200,0x0200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04db
  0x4400,0x4400,0x0000,0x9200,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u04dc
  0x0000,0x0000,0x4400,0x4400,0x0000,0x9200,0x9200,0x5400,0x3800,0x5400,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u04dd
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x0200,0x1c00,0x0200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04de
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x1c00,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04df
  0x3c00,0x0000,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u04e2
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u04e3
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4600,0x4a00,0x5200,0x6200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u04e4
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0000,0x0000,0x0000, // u04e5
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04e6
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04e7
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04e8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04e9
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04ea
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04eb
  0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x0200,0x1e00,0x0200,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04ec
  0x0000,0x0000,0x2400,0x2400,0x0000,0x3c00,0x4200,0x0200,0x1e00,0x0200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04ed
  0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04ee
  0x0000,0x0000,0x0000,0x3c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u04ef
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04f0
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u04f1
  0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04f2
  0x0000,0x0000,0x1200,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u04f3
  0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u04f4
  0x0000,0x0000,0x2400,0x2400,0x0000,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u04f5
  0x4800,0x4800,0x0000,0x8200,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000,0x0000,0x0000, // u04f8
  0x0000,0x0000,0x4800,0x4800,0x0000,0x8200,0x8200,0xf200,0x8a00,0x8a00,0x8a00,0xf200,0x0000,0x0000,0x0000,0x0000, // u04f9
  0x0000,0x0000,0x4200,0x4200,0x2200,0x2200,0x1400,0x2800,0x4400,0x4400,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u05d0
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x7f00,0x0000,0x0000,0x0000,0x0000, // u05d1
  0x0000,0x0000,0x7000,0x0800,0x0800,0x0800,0x0800,0x0800,0x1400,0x2400,0x4200,0x8200,0x0000,0x0000,0x0000,0x0000, // u05d2
  0x0000,0x0000,0x7f00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u05d3
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u05d4
  0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u05d5
  0x0000,0x0000,0x7c00,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u05d6
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u05d7
  0x0000,0x0000,0x4c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u05d8
  0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u05d9
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000, // u05da
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u05db
  0x4000,0x4000,0x7e00,0x0200,0x0200,0x0200,0x0200,0x0400,0x0800,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u05dc
  0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x0000,0x0000,0x0000,0x0000, // u05dd
  0x0000,0x0000,0xdc00,0x6200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4e00,0x0000,0x0000,0x0000,0x0000, // u05de
  0x0000,0x0000,0x7000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u05df
  0x0000,0x0000,0x3800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x3c00,0x0000,0x0000,0x0000,0x0000, // u05e0
  0x0000,0x0000,0xfc00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u05e1
  0x0000,0x0000,0x4200,0x4200,0x4200,0x2200,0x2200,0x2200,0x1400,0x1400,0x1800,0x6000,0x0000,0x0000,0x0000,0x0000, // u05e2
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x3200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000, // u05e3
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x3200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u05e4
  0x0000,0x0000,0x4200,0x4200,0x2200,0x2400,0x1800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000, // u05e5
  0x0000,0x0000,0x4200,0x4200,0x2200,0x2400,0x1800,0x1000,0x0800,0x0800,0x0400,0x7c00,0x0000,0x0000,0x0000,0x0000, // u05e6
  0x0000,0x0000,0x7e00,0x0200,0x0200,0x4200,0x4200,0x4400,0x4800,0x4800,0x4800,0x4800,0x4000,0x4000,0x4000,0x0000, // u05e7
  0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000, // u05e8
  0x0000,0x0000,0x9200,0x9200,0x9200,0x9200,0x9200,0xa200,0xc200,0x8200,0x8400,0xf800,0x0000,0x0000,0x0000,0x0000, // u05e9
  0x0000,0x0000,0xfc00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x8200,0x0000,0x0000,0x0000,0x0000, // u05ea
  0x0000,0x0000,0x7800,0x4400,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x7800,0x0000,0x1000,0x1000,0x0000, // u1e0c
  0x0000,0x0000,0x0200,0x0200,0x0200,0x3e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0800,0x0800,0x0000, // u1e0d
  0x0000,0x0000,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x0000,0x3c00,0x0000,0x0000, // u1e34
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x0000,0x3c00,0x0000,0x0000, // u1e35
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x1000,0x1000,0x0000, // u1e36
  0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x1000,0x1000,0x0000, // u1e37
  0x1000,0x1000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u1e40
  0x0000,0x0000,0x1000,0x1000,0x0000,0xfc00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u1e41
  0x0000,0x0000,0x8200,0xc600,0xaa00,0x9200,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000,0x1000,0x1000,0x0000, // u1e42
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x9200,0x9200,0x9200,0x9200,0x9200,0x9200,0x0000,0x1000,0x1000,0x0000, // u1e43
  0x1000,0x1000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u1e44
  0x0000,0x0000,0x1000,0x1000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u1e45
  0x0000,0x0000,0x4200,0x4200,0x4200,0x6200,0x5200,0x4a00,0x4600,0x4200,0x4200,0x4200,0x0000,0x1000,0x1000,0x0000, // u1e46
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x1000,0x1000,0x0000, // u1e47
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x0000, // u1e6c
  0x0000,0x0000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x0e00,0x0000,0x0400,0x0400,0x0000, // u1e6d
  0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x1000,0x1000,0x0000, // u1eb8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x1000,0x1000,0x0000, // u1eb9
  0x3200,0x4c00,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7800,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u1ebc
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x3c00,0x4200,0x4200,0x7e00,0x4000,0x4000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u1ebd
  0x0000,0x0000,0x3800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x1000,0x1000,0x0000, // u1eca
  0x0000,0x0000,0x1000,0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x1000,0x1000,0x0000, // u1ecb
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x1000,0x1000,0x0000, // u1ecc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x1000,0x1000,0x0000, // u1ecd
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x1000,0x1000,0x0000, // u1ee4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0000,0x0800,0x0800,0x0000, // u1ee5
  0x6400,0x9800,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u1ef8
  0x0000,0x0000,0x3200,0x4c00,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3e00,0x0200,0x0200,0x3c00,0x0000, // u1ef9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2001
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2002
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2003
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2004
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2005
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2006
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2007
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2008
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2009
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2010
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2011
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2012
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2013
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2014
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2015
  0x0000,0x0000,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x0000,0x0000,0x0000,0x0000, // u2016
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x7e00, // u2017
  0x0000,0x0800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2018
  0x0000,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2019
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000, // u201a
  0x0000,0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201b
  0x0000,0x1200,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201c
  0x0000,0x1200,0x1200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x2400,0x4800,0x0000,0x0000,0x0000, // u201e
  0x0000,0x4800,0x4800,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201f
  0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2020
  0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2021
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2022
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9200,0x9200,0x0000,0x0000,0x0000,0x0000, // u2026
  0x0000,0x0000,0x4800,0xa800,0x5000,0x1000,0x2000,0x2000,0x4000,0x5400,0xaa00,0x9400,0x0000,0x0000,0x0000,0x0000, // u2030
  0x0000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2032
  0x0000,0x2400,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2033
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0800,0x1000,0x2000,0x1000,0x0800,0x0400,0x0000,0x0000,0x0000,0x0000, // u2039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0800,0x1000,0x2000,0x0000,0x0000,0x0000,0x0000, // u203a
  0x0000,0x0000,0x2400,0x2400,0x2400,0x2400,0x2400,0x2400,0x2400,0x0000,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000, // u203c
  0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u203e
  0x0000,0x1800,0x2400,0x2400,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2070
  0x1000,0x0000,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2071
  0x0000,0x0400,0x0c00,0x1400,0x3e00,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2074
  0x0000,0x3800,0x2000,0x3800,0x0400,0x0400,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2075
  0x0000,0x1800,0x2000,0x3800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2076
  0x0000,0x3c00,0x0400,0x0800,0x0800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2077
  0x0000,0x1800,0x2400,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2078
  0x0000,0x1800,0x2400,0x2400,0x1c00,0x0400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2079
  0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207a
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207b
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207c
  0x0000,0x0800,0x1000,0x1000,0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207d
  0x0000,0x1000,0x0800,0x0800,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207e
  0x0000,0x0000,0x3800,0x2400,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000, // u2080
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x3000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000, // u2081
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x0400,0x0800,0x1000,0x3c00,0x0000,0x0000,0x0000, // u2082
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x0400,0x1800,0x0400,0x0400,0x3800,0x0000,0x0000,0x0000, // u2083
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0c00,0x1400,0x3e00,0x0400,0x0400,0x0000,0x0000,0x0000, // u2084
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x2000,0x3800,0x0400,0x0400,0x3800,0x0000,0x0000,0x0000, // u2085
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2000,0x3800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000, // u2086
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0400,0x0800,0x0800,0x1000,0x1000,0x0000,0x0000,0x0000, // u2087
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000, // u2088
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x1c00,0x0400,0x1800,0x0000,0x0000,0x0000, // u2089
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000, // u208a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u208b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u208c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1000,0x1000,0x1000,0x1000,0x0800,0x0000,0x0000,0x0000, // u208d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x0800,0x0800,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000, // u208e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x0400,0x1c00,0x2400,0x1c00,0x0000,0x0000,0x0000, // u2090
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x3c00,0x2000,0x1c00,0x0000,0x0000,0x0000, // u2091
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000, // u2092
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x2800,0x1000,0x2800,0x4400,0x0000,0x0000,0x0000, // u2093
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x0400,0x3c00,0x2400,0x1800,0x0000,0x0000,0x0000, // u2094
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x3800,0x2400,0x2400,0x2400,0x2400,0x0000,0x0000,0x0000, // u2095
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x2400,0x2800,0x3000,0x2800,0x2400,0x0000,0x0000,0x0000, // u2096
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1000,0x1000,0x1000,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000, // u2097
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x5400,0x5400,0x5400,0x5400,0x0000,0x0000,0x0000, // u2098
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x2400,0x2400,0x2400,0x3800,0x2000,0x2000,0x0000, // u209a
  0x0000,0x0000,0xf000,0x8800,0x8800,0x8800,0xf400,0x8400,0x8e00,0x8400,0x8400,0x8200,0x0000,0x0000,0x0000,0x0000, // u20a7
  0x0000,0x0000,0xf200,0x8a00,0x8a00,0xaa00,0xaa00,0xaa00,0xaa00,0xa200,0xa200,0xbc00,0x0000,0x0000,0x0000,0x0000, // u20aa
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x4000,0xf800,0x4000,0xf800,0x4000,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000, // u20ac
  0x0000,0x0000,0xfe00,0x1000,0x1000,0x1c00,0x7000,0x1c00,0x7000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u20ae
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5000,0x5000,0x5000,0x5000,0x5200,0x5200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u2102
  0x0000,0x0000,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u210e
  0x0000,0x0000,0x4000,0xf000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u210f
  0x0000,0x0000,0x4200,0x4200,0x6200,0x5200,0x6a00,0x5600,0x4a00,0x4600,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u2115
  0x0000,0x0000,0x9600,0x9600,0x9600,0xd000,0xf000,0xf000,0xb000,0x9600,0x9000,0x9600,0x0000,0x0000,0x0000,0x0000, // u2116
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5a00,0x3c00,0x0600,0x0000,0x0000,0x0000, // u211a
  0x0000,0x0000,0xf800,0xa400,0xa400,0xa400,0xa400,0xb800,0xa800,0xb400,0xaa00,0xe600,0x0000,0x0000,0x0000,0x0000, // u211d
  0x0000,0x0000,0xfb00,0x5500,0x5500,0x5100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2122
  0x0000,0x0000,0x7e00,0x0200,0x0600,0x0a00,0x1400,0x2800,0x5000,0x6000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2124
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x2400,0x2400,0x6600,0x0000,0x0000,0x0000,0x0000, // u2126
  0x0000,0x0000,0x4400,0x4400,0x2200,0x2200,0x3400,0x5800,0x8800,0x8800,0x8400,0x4400,0x0000,0x0000,0x0000,0x0000, // u2135
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x4000,0xfe00,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2190
  0x0000,0x0000,0x1000,0x3800,0x5400,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2191
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0400,0xfe00,0x0400,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2192
  0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x5400,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u2193
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x4200,0xff00,0x4200,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2194
  0x0000,0x0000,0x1000,0x3800,0x5400,0x1000,0x1000,0x1000,0x1000,0x5400,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u2195
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2200,0x4200,0xfe00,0x4200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8800,0x8400,0xfe00,0x8400,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21a6
  0x0000,0x0000,0x1000,0x3800,0x5400,0x1000,0x1000,0x1000,0x5400,0x3800,0x1000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u21a8
  0x0000,0x0000,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,0x4200,0xfe00,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000, // u21b5
  0x0000,0x0000,0x0000,0xf000,0x3000,0x5000,0x9200,0x8200,0x8200,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000, // u21bb
  0x0000,0x0000,0x0000,0x0000,0x2000,0x4000,0xfe00,0x0000,0xfe00,0x0400,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000, // u21cb
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0400,0xfe00,0x0000,0xfe00,0x4000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21cc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x7e00,0xc000,0x7e00,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d0
  0x0000,0x0000,0x1000,0x3800,0x6c00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x0000,0x0000,0x0000,0x0000, // u21d1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0xfc00,0x0600,0xfc00,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d2
  0x0000,0x0000,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x6c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x7e00,0xc300,0x7e00,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d4
  0x0000,0x0000,0x1000,0x3800,0x6c00,0x2800,0x2800,0x2800,0x2800,0x6c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d5
  0x0000,0x0000,0x8200,0x8200,0x8200,0x7c00,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2200
  0x0000,0x0000,0x0000,0x7e00,0x0200,0x0200,0x0200,0x7e00,0x0200,0x0200,0x0200,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2203
  0x0000,0x0000,0x0400,0x7e00,0x0a00,0x0a00,0x1200,0x7e00,0x1200,0x2200,0x2200,0x7e00,0x4000,0x0000,0x0000,0x0000, // u2204
  0x0000,0x0000,0x0200,0x0400,0x7c00,0x8a00,0x9200,0x9200,0xa200,0x7c00,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000, // u2205
  0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x4400,0x8200,0x8200,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2206
  0x0000,0x0000,0xfe00,0x8200,0x8200,0x4400,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2207
  0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x4000,0x7e00,0x4000,0x4000,0x2000,0x1e00,0x0000,0x0000,0x0000,0x0000, // u2208
  0x0000,0x0000,0x0200,0x1e00,0x2400,0x4400,0x4800,0x7e00,0x4800,0x5000,0x3000,0x3e00,0x2000,0x0000,0x0000,0x0000, // u2209
  0x0000,0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x7e00,0x4000,0x2000,0x1e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u220a
  0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x0200,0x7e00,0x0200,0x0200,0x0400,0x7800,0x0000,0x0000,0x0000,0x0000, // u220b
  0x0000,0x0000,0x4000,0x7800,0x2400,0x2200,0x1200,0x7e00,0x1200,0x0a00,0x0c00,0x7c00,0x0400,0x0000,0x0000,0x0000, // u220c
  0x0000,0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x7e00,0x0200,0x0400,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000, // u220d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2212
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2213
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x0000,0x1000,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2214
  0x0000,0x0000,0x0000,0x0000,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2215
  0x0000,0x0000,0x0000,0x0000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0000,0x0000,0x0000,0x0000,0x0000, // u2216
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2219
  0x0000,0x0600,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x4400,0x2400,0x1400,0x0c00,0x0000,0x0000,0x0000,0x0000, // u221a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x9200,0x9200,0x9200,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u221e
  0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u221f
  0x0000,0x0000,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x0000,0x0000,0x0000,0x0000, // u2225
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x2800,0x2800,0x4400,0x4400,0x8200,0x8200,0x0000,0x0000,0x0000,0x0000, // u2227
  0x0000,0x0000,0x0000,0x0000,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2228
  0x0000,0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u2229
  0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u222a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3200,0x4c00,0x0000,0x3200,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2248
  0x0000,0x0000,0x0000,0x0000,0x0200,0x7e00,0x0800,0x1000,0x7e00,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2260
  0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x0000,0x7e00,0x0000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2261
  0x0000,0x0000,0x0000,0x0400,0x0800,0x1000,0x2000,0x1000,0x0800,0x0400,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000, // u2264
  0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0800,0x1000,0x2000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u2265
  0x0000,0x0000,0x0000,0x0900,0x1200,0x2400,0x4800,0x9000,0x4800,0x2400,0x1200,0x0900,0x0000,0x0000,0x0000,0x0000, // u226a
  0x0000,0x0000,0x0000,0x9000,0x4800,0x2400,0x1200,0x0900,0x1200,0x2400,0x4800,0x9000,0x0000,0x0000,0x0000,0x0000, // u226b
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2282
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2283
  0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2286
  0x0000,0x0000,0x0000,0x7c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x7c00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2287
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u22a5
  0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u22c2
  0x0000,0x0000,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u22c3
  0x0000,0x0000,0x0200,0x0400,0x7c00,0x8a00,0x9200,0x9200,0xa200,0x7c00,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000, // u2300
  0x0000,0x0000,0x0000,0x0000,0x1000,0x2800,0x4400,0x8200,0x8200,0x8200,0x8200,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2302
  0x0000,0x0000,0x3800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000, // u2308
  0x0000,0x0000,0x3800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u2309
  0x0000,0x0000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x3800,0x0000,0x0000,0x0000,0x0000, // u230a
  0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3800,0x0000,0x0000,0x0000,0x0000, // u230b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2310
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2319
  0x0000,0x0000,0x0c00,0x1200,0x1200,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2320
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x9000,0x9000,0x6000,0x0000,0x0000,0x0000,0x0000, // u2321
  0x0400,0x0800,0x1000,0x1000,0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u239b
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u239c
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x2000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0400, // u239d
  0x4000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u239e
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u239f
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0800,0x0800,0x0800,0x1000,0x1000,0x2000,0x4000, // u23a0
  0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u23a1
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000, // u23a2
  0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7c00, // u23a3
  0x7c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u23a4
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400, // u23a5
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x7c00, // u23a6
  0x0e00,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23a7
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xc000,0xc000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000, // u23a8
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x0e00, // u23a9
  0xe000,0x1000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u23ab
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0600,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800, // u23ac
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1000,0xe000, // u23ad
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u23ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23af
  0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23ba
  0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000, // u23bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00, // u23bd
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u23d0
  0x0000,0x8800,0x8800,0xf800,0x8800,0x8800,0x8800,0x0000,0x1f00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0000,0x0000, // u2409
  0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x1f00,0x1000,0x1c00,0x1000,0x1000,0x1000,0x0000,0x0000, // u240a
  0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x1f00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0000,0x0000, // u240b
  0x0000,0xf800,0x8000,0xe000,0x8000,0x8000,0x8000,0x0000,0x1f00,0x1000,0x1c00,0x1000,0x1000,0x1000,0x0000,0x0000, // u240c
  0x0000,0x7000,0x8800,0x8000,0x8000,0x8800,0x7000,0x0000,0x1e00,0x1100,0x1100,0x1e00,0x1200,0x1100,0x0000,0x0000, // u240d
  0x0000,0x8800,0xc800,0xa800,0x9800,0x8800,0x8800,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x0000,0x0000, // u2424
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2500
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2501
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2502
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2503
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2508
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2509
  0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x1000,0x0000,0x1000,0x1000,0x1000,0x0000, // u250a
  0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000, // u250b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u250c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u250d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2510
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2511
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2512
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2513
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2514
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2515
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2516
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2517
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2518
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2519
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251b
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u251c
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u251d
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u251e
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251f
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2520
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2521
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2522
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2523
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2524
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2525
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2526
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2527
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2528
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2529
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u252f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2530
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2531
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2532
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2533
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2534
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2535
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2536
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2537
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2538
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2539
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253b
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253c
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253d
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253e
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u253f
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2540
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2541
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2542
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2543
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2544
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2545
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2546
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2547
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2548
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2549
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u254a
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u254b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2550
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2551
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2552
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2553
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x2000,0x2f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2554
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x1000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2555
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2556
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0800,0xe800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2557
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1000,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2558
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2559
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2f00,0x2000,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255a
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x1000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255b
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255c
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xe800,0x0800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255d
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1f00,0x1000,0x1f00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u255e
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u255f
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2f00,0x2000,0x2f00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2560
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xf000,0x1000,0xf000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2561
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xe800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2562
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xe800,0x0800,0xe800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2563
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2564
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2565
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x0000,0xef00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u2566
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2567
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2568
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xef00,0x0000,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2569
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xff00,0x1000,0xff00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u256a
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xff00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u256b
  0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0xef00,0x0000,0xef00,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800,0x2800, // u256c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0700,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u256d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0x2000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u256e
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x2000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u256f
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0700,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2570
  0x0100,0x0100,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x4000,0x8000,0x8000, // u2571
  0x8000,0x8000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0200,0x0200,0x0100,0x0100, // u2572
  0x8100,0x8100,0x4200,0x4200,0x2400,0x2400,0x1800,0x1800,0x1800,0x1800,0x2400,0x2400,0x4200,0x4200,0x8100,0x8100, // u2573
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2574
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2575
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2576
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u2577
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2578
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2579
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u257b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257c
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u257d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000, // u257f
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2580
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00, // u2581
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00, // u2582
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2583
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2584
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2585
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2586
  0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2587
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2588
  0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00, // u2589
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u258a
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800, // u258b
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u258c
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u258d
  0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000, // u258e
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000, // u258f
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2590
  0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200, // u2591
  0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500, // u2592
  0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00, // u2593
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u2596
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2597
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2598
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2599
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259a
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259b
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259c
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u259d
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259e
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u259f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u25a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x7e00,0x7e00,0x7e00,0x0000,0x0000,0x0000,0x0000, // u25ac
  0x0000,0x0000,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x7e00,0x0000,0x0000,0x0000,0x0000, // u25ae
  0x0000,0x0000,0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x7c00,0x7c00,0xfe00,0xfe00,0x0000,0x0000,0x0000,0x0000, // u25b2
  0x0000,0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000, // u25b6
  0x0000,0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000, // u25ba
  0x0000,0x0000,0x0000,0x0000,0xfe00,0xfe00,0x7c00,0x7c00,0x3800,0x3800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u25bc
  0x0000,0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, // u25c0
  0x0000,0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000,0x0000,0x0000, // u25c4
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3800,0x7c00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000, // u25c6
  0x0000,0x0000,0x0000,0x0000,0x1000,0x2800,0x4400,0x8200,0x4400,0x2800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000, // u25ca
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x2400,0x2400,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u25cb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u25cf
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xe700,0xc300,0xc300,0xe700,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d8
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xe700,0xdb00,0xdb00,0xe700,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d9
  0x0000,0x0000,0x7c00,0x8200,0xaa00,0x8200,0x8200,0xba00,0x9200,0x8200,0x8200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u263a
  0x0000,0x0000,0x7c00,0xfe00,0xd600,0xfe00,0xfe00,0xc600,0xee00,0xfe00,0xfe00,0x7c00,0x0000,0x0000,0x0000,0x0000, // u263b
  0x0000,0x0000,0x0000,0x1000,0x9200,0x5400,0x3800,0xee00,0x3800,0x5400,0x9200,0x1000,0x0000,0x0000,0x0000,0x0000, // u263c
  0x0000,0x0000,0x3800,0x4400,0x4400,0x4400,0x4400,0x3800,0x1000,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2640
  0x0000,0x0000,0x1e00,0x0600,0x0a00,0x1200,0x3800,0x4400,0x4400,0x4400,0x4400,0x3800,0x0000,0x0000,0x0000,0x0000, // u2642
  0x0000,0x0000,0x1000,0x1000,0x3800,0x7c00,0xfe00,0xfe00,0x7c00,0x1000,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u2660
  0x0000,0x0000,0x1000,0x3800,0x3800,0x1000,0x5400,0xfe00,0xfe00,0x5400,0x1000,0x3800,0x0000,0x0000,0x0000,0x0000, // u2663
  0x0000,0x0000,0x0000,0x0000,0x6c00,0xfe00,0xfe00,0xfe00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u2665
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3800,0x7c00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2666
  0x0000,0x0000,0x3e00,0x2200,0x3e00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xc000,0x0000,0x0000,0x0000,0x0000, // u266a
  0x0000,0x0000,0x7e00,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4400,0x8000,0x0000,0x0000,0x0000, // u266b
  0x0000,0x0000,0x0200,0x0200,0x0400,0x0400,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000, // u2713
  0x0000,0x0000,0x0300,0x0300,0x0600,0x0600,0xcc00,0xcc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u2714
  0x0000,0x0000,0x0400,0x4400,0x2800,0x1800,0x1800,0x1400,0x2200,0x2000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000, // u2717
  0x0000,0x0000,0x0c00,0xcc00,0x7800,0x3800,0x3800,0x3c00,0x6600,0x6000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u2718
  0x0000,0x0000,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000, // u27e8
  0x0000,0x0000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000, // u27e9
  0x0000,0x0000,0x1200,0x1200,0x2400,0x2400,0x4800,0x4800,0x2400,0x2400,0x1200,0x1200,0x0000,0x0000,0x0000,0x0000, // u27ea
  0x0000,0x0000,0x4800,0x4800,0x2400,0x2400,0x1200,0x1200,0x2400,0x2400,0x4800,0x4800,0x0000,0x0000,0x0000,0x0000, // u27eb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2800
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2801
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2802
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2803
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2804
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2805
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2806
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2807
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2808
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2809
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2810
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2811
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2812
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2813
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2814
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2815
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2816
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2817
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2818
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2819
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2820
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2821
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2822
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2823
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2824
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2825
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2826
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2827
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2828
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2829
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u282a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u282b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u282c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u282d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u282e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u282f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2830
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2831
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2832
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2833
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2834
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2835
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2836
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2837
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2838
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2839
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u283a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000, // u283b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u283c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u283d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u283e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000, // u283f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2840
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2841
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2842
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2843
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2844
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2845
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2846
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2847
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2848
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2849
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u284f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2850
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2851
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2852
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2853
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2854
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2855
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2856
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2857
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2858
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u2859
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000, // u285f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2860
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2861
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2862
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2863
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2864
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2865
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2866
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2867
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2868
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2869
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u286a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u286b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u286c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u286d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u286e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u286f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2870
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2871
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2872
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2873
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2874
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2875
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2876
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2877
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2878
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u2879
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u287a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000, // u287b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u287c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u287d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u287e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000, // u287f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2880
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2881
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2882
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2883
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2884
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2885
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2886
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2887
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2888
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2889
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u288f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2890
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2891
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2892
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2893
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2894
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2895
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2896
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2897
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2898
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u2899
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289a
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289b
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289c
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289d
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289e
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000, // u289f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a2
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a6
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28a9
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28aa
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28ab
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28ac
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28ad
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28ae
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28af
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b2
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b6
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28b9
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28ba
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28bb
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28bc
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28bd
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28be
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000, // u28bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c2
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c6
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28c9
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ca
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28cb
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28cc
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28cd
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ce
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28cf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d2
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d6
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28d9
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28da
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28db
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28dc
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28dd
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28de
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000, // u28df
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e2
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e6
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28e9
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ea
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28eb
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ec
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ed
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ee
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ef
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f0
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f2
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f4
  0x0000,0x4000,0x4000,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f6
  0x0000,0x4000,0x4000,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f7
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f8
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28f9
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28fa
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28fb
  0x0000,0x0400,0x0400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28fc
  0x0000,0x4400,0x4400,0x0000,0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28fd
  0x0000,0x0400,0x0400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28fe
  0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000,0x0000,0x4400,0x4400,0x0000, // u28ff
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4200,0x4200,0x0000,0x0000,0x0000,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u2e2c
  0x8000,0x8000,0x8800,0x9c00,0xaa00,0x8800,0x8800,0x8800,0x1000,0x2000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000, // ue0a0
  0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0xf800,0x0000,0x1100,0x1900,0x1500,0x1300,0x1100,0x1100,0x0000,0x0000, // ue0a1
  0x0000,0x3800,0x4400,0x4400,0x4400,0x4400,0xfe00,0xfe00,0xee00,0xc600,0xee00,0xfe00,0xfe00,0xfe00,0x0000,0x0000, // ue0a2
  0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xff00,0xff00,0xfe00,0xfc00,0xf800,0xf000,0xe000,0xc000,0x8000, // ue0b0
  0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000, // ue0b1
  0x0100,0x0300,0x0700,0x0f00,0x1f00,0x3f00,0x7f00,0xff00,0xff00,0x7f00,0x3f00,0x1f00,0x0f00,0x0700,0x0300,0x0100, // ue0b2
  0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100, // ue0b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x4400,0x4400,0x3800,0x0000, // uf6be
  0x0000,0x0000,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x7e00,0x0000,0x0000,0x0000,0x0000 // ufffd
  };
  // codepoints array
  constexpr std::array<uint16_t, CHARCOUNT> fixedfont_codepoints = {
  0x0000,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,
  0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,
  0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,
  0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,
  0x005f,0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff,
  0x0100,0x0101,0x0102,0x0103,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x010c,0x010d,0x010e,0x010f,
  0x0110,0x0111,0x0112,0x0113,0x0114,0x0115,0x0116,0x0117,0x0118,0x0119,0x011a,0x011b,0x011c,0x011d,0x011e,0x011f,
  0x0120,0x0121,0x0122,0x0123,0x0124,0x0125,0x0126,0x0127,0x0128,0x0129,0x012a,0x012b,0x012c,0x012d,0x012e,0x012f,
  0x0130,0x0131,0x0132,0x0133,0x0134,0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x013d,0x013e,0x013f,
  0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,0x0149,0x014a,0x014b,0x014c,0x014d,0x014e,0x014f,
  0x0150,0x0151,0x0152,0x0153,0x0154,0x0155,0x0156,0x0157,0x0158,0x0159,0x015a,0x015b,0x015c,0x015d,0x015e,0x015f,
  0x0160,0x0161,0x0162,0x0163,0x0164,0x0165,0x0166,0x0167,0x0168,0x0169,0x016a,0x016b,0x016c,0x016d,0x016e,0x016f,
  0x0170,0x0171,0x0172,0x0173,0x0174,0x0175,0x0176,0x0177,0x0178,0x0179,0x017a,0x017b,0x017c,0x017d,0x017e,0x017f,
  0x0186,0x018e,0x018f,0x0190,0x0192,0x019d,0x019e,0x01b5,0x01b6,0x01b7,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d2,
  0x01d3,0x01d4,0x01e2,0x01e3,0x01e4,0x01e5,0x01e6,0x01e7,0x01e8,0x01e9,0x01ea,0x01eb,0x01ec,0x01ed,0x01ee,0x01ef,
  0x01f0,0x01f4,0x01f5,0x01fc,0x01fd,0x01fe,0x01ff,0x0218,0x0219,0x021a,0x021b,0x0232,0x0233,0x0237,0x0254,0x0258,
  0x0259,0x025b,0x0272,0x0292,0x02bb,0x02bc,0x02bd,0x02c6,0x02c7,0x02d8,0x02d9,0x02db,0x02dc,0x02dd,0x0300,0x0301,
  0x0302,0x0303,0x0304,0x0305,0x0306,0x0307,0x0308,0x030a,0x030b,0x030c,0x0329,0x0384,0x0385,0x0386,0x0387,0x0388,
  0x0389,0x038a,0x038c,0x038e,0x038f,0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
  0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03aa,0x03ab,
  0x03ac,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,
  0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x03ca,0x03cb,
  0x03cc,0x03cd,0x03ce,0x03d1,0x03d5,0x03f0,0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,0x03f6,0x0400,0x0401,0x0402,0x0403,
  0x0404,0x0405,0x0406,0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,0x0411,0x0412,0x0413,
  0x0414,0x0415,0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,
  0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,0x0431,0x0432,0x0433,
  0x0434,0x0435,0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,
  0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x0450,0x0451,0x0452,0x0453,
  0x0454,0x0455,0x0456,0x0457,0x0458,0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0462,0x0463,0x046a,0x046b,
  0x0490,0x0491,0x0492,0x0493,0x0494,0x0495,0x0496,0x0497,0x0498,0x0499,0x049a,0x049b,0x049c,0x049d,0x04a0,0x04a1,
  0x04a2,0x04a3,0x04a4,0x04a5,0x04aa,0x04ab,0x04ae,0x04af,0x04b0,0x04b1,0x04b2,0x04b3,0x04b6,0x04b7,0x04b8,0x04b9,
  0x04ba,0x04bb,0x04c0,0x04c1,0x04c2,0x04cf,0x04d0,0x04d1,0x04d2,0x04d3,0x04d4,0x04d5,0x04d6,0x04d7,0x04d8,0x04d9,
  0x04da,0x04db,0x04dc,0x04dd,0x04de,0x04df,0x04e2,0x04e3,0x04e4,0x04e5,0x04e6,0x04e7,0x04e8,0x04e9,0x04ea,0x04eb,
  0x04ec,0x04ed,0x04ee,0x04ef,0x04f0,0x04f1,0x04f2,0x04f3,0x04f4,0x04f5,0x04f8,0x04f9,0x05d0,0x05d1,0x05d2,0x05d3,
  0x05d4,0x05d5,0x05d6,0x05d7,0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,0x05e0,0x05e1,0x05e2,0x05e3,
  0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,0x05ea,0x1e0c,0x1e0d,0x1e34,0x1e35,0x1e36,0x1e37,0x1e40,0x1e41,0x1e42,
  0x1e43,0x1e44,0x1e45,0x1e46,0x1e47,0x1e6c,0x1e6d,0x1eb8,0x1eb9,0x1ebc,0x1ebd,0x1eca,0x1ecb,0x1ecc,0x1ecd,0x1ee4,
  0x1ee5,0x1ef8,0x1ef9,0x2000,0x2001,0x2002,0x2003,0x2004,0x2005,0x2006,0x2007,0x2008,0x2009,0x200a,0x200b,0x200c,
  0x200d,0x200e,0x200f,0x2010,0x2011,0x2012,0x2013,0x2014,0x2015,0x2016,0x2017,0x2018,0x2019,0x201a,0x201b,0x201c,
  0x201d,0x201e,0x201f,0x2020,0x2021,0x2022,0x2026,0x2030,0x2032,0x2033,0x2039,0x203a,0x203c,0x203e,0x2070,0x2071,
  0x2074,0x2075,0x2076,0x2077,0x2078,0x2079,0x207a,0x207b,0x207c,0x207d,0x207e,0x207f,0x2080,0x2081,0x2082,0x2083,
  0x2084,0x2085,0x2086,0x2087,0x2088,0x2089,0x208a,0x208b,0x208c,0x208d,0x208e,0x2090,0x2091,0x2092,0x2093,0x2094,
  0x2095,0x2096,0x2097,0x2098,0x209a,0x20a7,0x20aa,0x20ac,0x20ae,0x2102,0x210e,0x210f,0x2115,0x2116,0x211a,0x211d,
  0x2122,0x2124,0x2126,0x2135,0x2190,0x2191,0x2192,0x2193,0x2194,0x2195,0x21a4,0x21a6,0x21a8,0x21b5,0x21bb,0x21cb,
  0x21cc,0x21d0,0x21d1,0x21d2,0x21d3,0x21d4,0x21d5,0x2200,0x2203,0x2204,0x2205,0x2206,0x2207,0x2208,0x2209,0x220a,
  0x220b,0x220c,0x220d,0x2212,0x2213,0x2214,0x2215,0x2216,0x2219,0x221a,0x221e,0x221f,0x2225,0x2227,0x2228,0x2229,
  0x222a,0x2248,0x2260,0x2261,0x2264,0x2265,0x226a,0x226b,0x2282,0x2283,0x2286,0x2287,0x22a5,0x22c2,0x22c3,0x2300,
  0x2302,0x2308,0x2309,0x230a,0x230b,0x2310,0x2319,0x2320,0x2321,0x239b,0x239c,0x239d,0x239e,0x239f,0x23a0,0x23a1,
  0x23a2,0x23a3,0x23a4,0x23a5,0x23a6,0x23a7,0x23a8,0x23a9,0x23ab,0x23ac,0x23ad,0x23ae,0x23af,0x23ba,0x23bb,0x23bc,
  0x23bd,0x23d0,0x2409,0x240a,0x240b,0x240c,0x240d,0x2424,0x2500,0x2501,0x2502,0x2503,0x2508,0x2509,0x250a,0x250b,
  0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513,0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251a,0x251b,
  0x251c,0x251d,0x251e,0x251f,0x2520,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252a,0x252b,
  0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b,
  0x253c,0x253d,0x253e,0x253f,0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254a,0x254b,
  0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f,
  0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f,
  0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2577,0x2578,0x2579,0x257a,0x257b,0x257c,0x257d,0x257e,0x257f,
  0x2580,0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,0x258e,0x258f,
  0x2590,0x2591,0x2592,0x2593,0x2596,0x2597,0x2598,0x2599,0x259a,0x259b,0x259c,0x259d,0x259e,0x259f,0x25a0,0x25ac,
  0x25ae,0x25b2,0x25b6,0x25ba,0x25bc,0x25c0,0x25c4,0x25c6,0x25ca,0x25cb,0x25cf,0x25d8,0x25d9,0x263a,0x263b,0x263c,
  0x2640,0x2642,0x2660,0x2663,0x2665,0x2666,0x266a,0x266b,0x2713,0x2714,0x2717,0x2718,0x27e8,0x27e9,0x27ea,0x27eb,
  0x2800,0x2801,0x2802,0x2803,0x2804,0x2805,0x2806,0x2807,0x2808,0x2809,0x280a,0x280b,0x280c,0x280d,0x280e,0x280f,
  0x2810,0x2811,0x2812,0x2813,0x2814,0x2815,0x2816,0x2817,0x2818,0x2819,0x281a,0x281b,0x281c,0x281d,0x281e,0x281f,
  0x2820,0x2821,0x2822,0x2823,0x2824,0x2825,0x2826,0x2827,0x2828,0x2829,0x282a,0x282b,0x282c,0x282d,0x282e,0x282f,
  0x2830,0x2831,0x2832,0x2833,0x2834,0x2835,0x2836,0x2837,0x2838,0x2839,0x283a,0x283b,0x283c,0x283d,0x283e,0x283f,
  0x2840,0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847,0x2848,0x2849,0x284a,0x284b,0x284c,0x284d,0x284e,0x284f,
  0x2850,0x2851,0x2852,0x2853,0x2854,0x2855,0x2856,0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e,0x285f,
  0x2860,0x2861,0x2862,0x2863,0x2864,0x2865,0x2866,0x2867,0x2868,0x2869,0x286a,0x286b,0x286c,0x286d,0x286e,0x286f,
  0x2870,0x2871,0x2872,0x2873,0x2874,0x2875,0x2876,0x2877,0x2878,0x2879,0x287a,0x287b,0x287c,0x287d,0x287e,0x287f,
  0x2880,0x2881,0x2882,0x2883,0x2884,0x2885,0x2886,0x2887,0x2888,0x2889,0x288a,0x288b,0x288c,0x288d,0x288e,0x288f,
  0x2890,0x2891,0x2892,0x2893,0x2894,0x2895,0x2896,0x2897,0x2898,0x2899,0x289a,0x289b,0x289c,0x289d,0x289e,0x289f,
  0x28a0,0x28a1,0x28a2,0x28a3,0x28a4,0x28a5,0x28a6,0x28a7,0x28a8,0x28a9,0x28aa,0x28ab,0x28ac,0x28ad,0x28ae,0x28af,
  0x28b0,0x28b1,0x28b2,0x28b3,0x28b4,0x28b5,0x28b6,0x28b7,0x28b8,0x28b9,0x28ba,0x28bb,0x28bc,0x28bd,0x28be,0x28bf,
  0x28c0,0x28c1,0x28c2,0x28c3,0x28c4,0x28c5,0x28c6,0x28c7,0x28c8,0x28c9,0x28ca,0x28cb,0x28cc,0x28cd,0x28ce,0x28cf,
  0x28d0,0x28d1,0x28d2,0x28d3,0x28d4,0x28d5,0x28d6,0x28d7,0x28d8,0x28d9,0x28da,0x28db,0x28dc,0x28dd,0x28de,0x28df,
  0x28e0,0x28e1,0x28e2,0x28e3,0x28e4,0x28e5,0x28e6,0x28e7,0x28e8,0x28e9,0x28ea,0x28eb,0x28ec,0x28ed,0x28ee,0x28ef,
  0x28f0,0x28f1,0x28f2,0x28f3,0x28f4,0x28f5,0x28f6,0x28f7,0x28f8,0x28f9,0x28fa,0x28fb,0x28fc,0x28fd,0x28fe,0x28ff,
  0x2e2c,0xe0a0,0xe0a1,0xe0a2,0xe0b0,0xe0b1,0xe0b2,0xe0b3,0xf6be,0xfffd };
} // namespace
// -- end of autogenerated text ---

namespace fixed_font_16b {
  // -- start of autogenerated text ---
  // definition section for font: ter-u16b.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 8;
  constexpr int HEIGHT = 16;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u16b.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    true // bold
  };
  // font bitmap definitions
  constexpr std::array<uint16_t, CHARCOUNT * HEIGHT> fixedfont_bitmap = {
  0x0000,0x0000,0xee00,0xc600,0x0000,0xc600,0xc600,0xc600,0x0000,0xc600,0xc600,0xee00,0x0000,0x0000,0x0000,0x0000, // u0000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0020
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0021
  0x0000,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0022
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0xfe00,0x6c00,0x6c00,0xfe00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000, // u0023
  0x0000,0x1000,0x1000,0x7c00,0xd600,0xd000,0xd000,0x7c00,0x1600,0x1600,0xd600,0x7c00,0x1000,0x1000,0x0000,0x0000, // u0024
  0x0000,0x0000,0x6600,0xd600,0x6c00,0x0c00,0x1800,0x1800,0x3000,0x3600,0x6b00,0x6600,0x0000,0x0000,0x0000,0x0000, // u0025
  0x0000,0x0000,0x3800,0x6c00,0x6c00,0x3800,0x7600,0xdc00,0xcc00,0xcc00,0xdc00,0x7600,0x0000,0x0000,0x0000,0x0000, // u0026
  0x0000,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0027
  0x0000,0x0000,0x0c00,0x1800,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1800,0x0c00,0x0000,0x0000,0x0000,0x0000, // u0028
  0x0000,0x0000,0x3000,0x1800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000, // u0029
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x3800,0xfe00,0x3800,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000, // u002c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u002d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u002e
  0x0000,0x0000,0x0600,0x0600,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u002f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0030
  0x0000,0x0000,0x1800,0x3800,0x7800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0031
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0032
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0033
  0x0000,0x0000,0x0600,0x0e00,0x1e00,0x3600,0x6600,0xc600,0xfe00,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u0034
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xfc00,0x0600,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0035
  0x0000,0x0000,0x3c00,0x6000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0036
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u0037
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x7c00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0038
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0c00,0x7800,0x0000,0x0000,0x0000,0x0000, // u0039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u003a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000, // u003b
  0x0000,0x0000,0x0000,0x0600,0x0c00,0x1800,0x3000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0000,0x0000,0x0000,0x0000, // u003c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u003d
  0x0000,0x0000,0x0000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0c00,0x1800,0x3000,0x6000,0x0000,0x0000,0x0000,0x0000, // u003e
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x0c00,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u003f
  0x0000,0x0000,0x7c00,0xc600,0xce00,0xd600,0xd600,0xd600,0xd600,0xce00,0xc000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0040
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0041
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0042
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0043
  0x0000,0x0000,0xf800,0xcc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x0000,0x0000,0x0000, // u0044
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0045
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0046
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0047
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0048
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0049
  0x0000,0x0000,0x1e00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0x7800,0x0000,0x0000,0x0000,0x0000, // u004a
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u004b
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u004c
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u004d
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u004e
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u004f
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0050
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xde00,0x7c00,0x0600,0x0000,0x0000,0x0000, // u0051
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u0052
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0053
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0054
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0055
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0x6c00,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000, // u0056
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xd600,0xfe00,0xee00,0xc600,0x8200,0x0000,0x0000,0x0000,0x0000, // u0057
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0058
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0059
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u005a
  0x0000,0x0000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u005b
  0x0000,0x0000,0x6000,0x6000,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u005c
  0x0000,0x0000,0x3c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x3c00,0x0000,0x0000,0x0000,0x0000, // u005d
  0x0000,0x1800,0x3c00,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u005e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000, // u005f
  0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0060
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0061
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0062
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0063
  0x0000,0x0000,0x0600,0x0600,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0064
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0065
  0x0000,0x0000,0x1e00,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u0066
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0067
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0068
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0069
  0x0000,0x0000,0x0600,0x0600,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // u006a
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u006b
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u006c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u006d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u006e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u006f
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0x0000, // u0070
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0000, // u0071
  0x0000,0x0000,0x0000,0x0000,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0072
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0073
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0000,0x0000,0x0000, // u0074
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0075
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000, // u0076
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0077
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x3800,0x6c00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0078
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0079
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u007a
  0x0000,0x0000,0x1c00,0x3000,0x3000,0x3000,0x6000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000,0x0000,0x0000, // u007b
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u007c
  0x0000,0x0000,0x7000,0x1800,0x1800,0x1800,0x0c00,0x1800,0x1800,0x1800,0x1800,0x7000,0x0000,0x0000,0x0000,0x0000, // u007d
  0x0000,0x7300,0xdb00,0xce00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u007e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a0
  0x0000,0x0000,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u00a1
  0x0000,0x0000,0x0000,0x1000,0x1000,0x7c00,0xd600,0xd000,0xd000,0xd000,0xd600,0x7c00,0x1000,0x1000,0x0000,0x0000, // u00a2
  0x0000,0x0000,0x3800,0x6c00,0x6000,0x6000,0xf800,0x6000,0x6000,0x6000,0x6600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u00a3
  0x0000,0x0000,0x0000,0x0000,0x6600,0x3c00,0x6600,0x6600,0x6600,0x3c00,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a4
  0x0000,0x0000,0xc300,0xc300,0x6600,0x3c00,0x1800,0x7e00,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u00a5
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u00a6
  0x0000,0x3c00,0x6600,0x6000,0x3800,0x6c00,0x6600,0x6600,0x3600,0x1c00,0x0600,0x6600,0x3c00,0x0000,0x0000,0x0000, // u00a7
  0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00a8
  0x0000,0x0000,0x0000,0x7e00,0x8100,0x9900,0xa500,0xa100,0xa500,0x9900,0x8100,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00a9
  0x0000,0x3c00,0x0600,0x3e00,0x6600,0x3e00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1b00,0x3600,0x6c00,0xd800,0x6c00,0x3600,0x1b00,0x0000,0x0000,0x0000,0x0000, // u00ab
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ac
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ad
  0x0000,0x0000,0x0000,0x7e00,0x8100,0xb900,0xa500,0xb900,0xa900,0xa500,0x8100,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00ae
  0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00af
  0x0000,0x3800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00b1
  0x0000,0x3800,0x6c00,0x0c00,0x1800,0x3000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b2
  0x0000,0x7800,0x0c00,0x3800,0x0c00,0x0c00,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b3
  0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xce00,0xf600,0xc000,0xc000,0xc000,0x0000, // u00b5
  0x0000,0x0000,0x7e00,0xd600,0xd600,0xd600,0xd600,0x7600,0x1600,0x1600,0x1600,0x1600,0x0000,0x0000,0x0000,0x0000, // u00b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x3000,0x6000,0x0000, // u00b8
  0x0000,0x1800,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00b9
  0x0000,0x3c00,0x6600,0x6600,0x6600,0x3c00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u00ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd800,0x6c00,0x3600,0x1b00,0x3600,0x6c00,0xd800,0x0000,0x0000,0x0000,0x0000, // u00bb
  0x0000,0x6000,0xe000,0x6200,0x6600,0x6c00,0x1800,0x3000,0x6600,0xce00,0x9a00,0x3e00,0x0600,0x0600,0x0000,0x0000, // u00bc
  0x0000,0x6000,0xe000,0x6200,0x6600,0x6c00,0x1800,0x3000,0x6000,0xdc00,0xb600,0x0c00,0x1800,0x3e00,0x0000,0x0000, // u00bd
  0x0000,0xe000,0x3000,0x6200,0x3600,0xec00,0x1800,0x3000,0x6600,0xce00,0x9a00,0x3e00,0x0600,0x0600,0x0000,0x0000, // u00be
  0x0000,0x0000,0x3000,0x3000,0x0000,0x3000,0x3000,0x6000,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00bf
  0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00c0
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00c1
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00c2
  0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00c3
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00c4
  0x3800,0x6c00,0x3800,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00c5
  0x0000,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000,0x0000,0x0000, // u00c6
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x3000,0x3000,0x6000,0x0000, // u00c7
  0x3000,0x1800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u00c8
  0x1800,0x3000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u00c9
  0x3800,0x6c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u00ca
  0x6c00,0x6c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u00cb
  0x3000,0x1800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00cc
  0x0c00,0x1800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00cd
  0x3800,0x6c00,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00ce
  0x6600,0x6600,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00cf
  0x0000,0x0000,0x7800,0x6c00,0x6600,0x6600,0xf600,0x6600,0x6600,0x6600,0x6c00,0x7800,0x0000,0x0000,0x0000,0x0000, // u00d0
  0x7600,0xdc00,0x0000,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00d1
  0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d2
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d3
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d4
  0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d5
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0x6c00,0x3800,0x3800,0x6c00,0xc600,0x0000,0x0000,0x0000,0x0000,0x0000, // u00d7
  0x0000,0x0000,0x7c00,0xc700,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d8
  0x3000,0x1800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00d9
  0x1800,0x3000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00da
  0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00db
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00dc
  0x0c00,0x1800,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u00dd
  0x0000,0x0000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u00de
  0x0000,0x0000,0x7800,0xcc00,0xcc00,0xc800,0xfc00,0xc600,0xc600,0xc600,0xe600,0xdc00,0x0000,0x0000,0x0000,0x0000, // u00df
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00e0
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00e1
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00e2
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00e3
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00e4
  0x0000,0x0000,0x3800,0x6c00,0x3800,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u00e6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x3000,0x3000,0x6000,0x0000, // u00e7
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00e8
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00e9
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00ea
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00eb
  0x0000,0x0000,0x3000,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00ec
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00ed
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00ee
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u00ef
  0x0000,0x0000,0x6800,0x3000,0x5800,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00f0
  0x0000,0x0000,0x7600,0xdc00,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u00f1
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00f2
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00f3
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00f4
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00f5
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u00f6
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x7e00,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u00f7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3d00,0x6700,0x6e00,0x7e00,0x7600,0xe600,0xbc00,0x0000,0x0000,0x0000,0x0000, // u00f8
  0x0000,0x0000,0x3000,0x1800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00f9
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00fa
  0x0000,0x0000,0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00fb
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u00fc
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u00fd
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0x0000, // u00fe
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u00ff
  0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0100
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0101
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0102
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0103
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0600,0x0c00,0x0700,0x0000, // u0104
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0c00,0x0700,0x0000, // u0105
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0106
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0107
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0108
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0109
  0x1800,0x1800,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u010a
  0x0000,0x0000,0x1800,0x1800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u010b
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u010c
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u010d
  0x6c00,0x3800,0x0000,0xf800,0xcc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x0000,0x0000,0x0000, // u010e
  0x6c00,0x3800,0x0600,0x0600,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u010f
  0x0000,0x0000,0x7800,0x6c00,0x6600,0x6600,0xf600,0x6600,0x6600,0x6600,0x6c00,0x7800,0x0000,0x0000,0x0000,0x0000, // u0110
  0x0000,0x0000,0x0600,0x1f00,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0111
  0x7c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0112
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0113
  0x6c00,0x3800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0114
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0115
  0x1800,0x1800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0116
  0x0000,0x0000,0x1800,0x1800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0117
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0600,0x0c00,0x0700,0x0000, // u0118
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x1800,0x3000,0x1c00,0x0000, // u0119
  0x6c00,0x3800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u011a
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u011b
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u011c
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u011d
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u011e
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u011f
  0x1800,0x1800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0120
  0x0000,0x0000,0x1800,0x1800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0121
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x3000,0x3000,0x6000, // u0122
  0x0000,0x0c00,0x1800,0x1800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0123
  0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0124
  0x1c00,0x3600,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0125
  0x0000,0x0000,0x6600,0xff00,0x6600,0x6600,0x7e00,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u0126
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u0127
  0x7600,0xdc00,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0128
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0129
  0x7e00,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u012a
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u012b
  0x6c00,0x3800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u012c
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u012d
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x3000,0x1c00,0x0000, // u012e
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x1800,0x3000,0x1c00,0x0000, // u012f
  0x1800,0x1800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0130
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0131
  0x0000,0x0000,0xcf00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xf600,0xf600,0xdc00,0x0000,0x0000,0x0000,0x0000, // u0132
  0x0000,0x0000,0xc600,0xc600,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x3600,0x3600,0x1c00,0x0000, // u0133
  0x1c00,0x3600,0x0000,0x1e00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0x7800,0x0000,0x0000,0x0000,0x0000, // u0134
  0x0000,0x0000,0x0e00,0x1b00,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // u0135
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x3000,0x3000,0x6000, // u0136
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x3000,0x3000,0x6000, // u0137
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u0138
  0x6000,0xc000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0139
  0x0c00,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u013a
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x3000,0x3000,0x6000, // u013b
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x1800,0x1800,0x3000, // u013c
  0x6c00,0x3800,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u013d
  0x6c00,0x3800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u013e
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xcc00,0xcc00,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u013f
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1b00,0x1b00,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0140
  0x0000,0x0000,0x6000,0x6000,0x6000,0x6000,0x7000,0xe000,0x6000,0x6000,0x6000,0x7f00,0x0000,0x0000,0x0000,0x0000, // u0141
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1c00,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0142
  0x1800,0x3000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0143
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0144
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x3000,0x3000,0x6000, // u0145
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x3000,0x3000,0x6000, // u0146
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0147
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0148
  0x0000,0x6000,0x6000,0xc000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0149
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0600,0x0600,0x1c00,0x0000, // u014a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600,0x1c00,0x0000, // u014b
  0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u014c
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u014d
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u014e
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u014f
  0x3600,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0150
  0x0000,0x0000,0x3600,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0151
  0x0000,0x0000,0x7e00,0xd800,0xd800,0xd800,0xde00,0xd800,0xd800,0xd800,0xd800,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0152
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xd600,0xd600,0xde00,0xd000,0xd000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0153
  0x1800,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u0154
  0x0000,0x0000,0x1800,0x3000,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0155
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x3000,0x3000,0x6000, // u0156
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6f00,0x7800,0x7000,0x6000,0x6000,0x6000,0x6000,0x0000,0x6000,0x6000,0xc000, // u0157
  0x6c00,0x3800,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u0158
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xde00,0xf000,0xe000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0159
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u015a
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u015b
  0x3800,0x6c00,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u015c
  0x0000,0x0000,0x3800,0x6c00,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u015d
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x3000,0x3000,0x6000,0x0000, // u015e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x3000,0x3000,0x6000,0x0000, // u015f
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0160
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0161
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0c00,0x0c00,0x1800,0x0000, // u0162
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0c00,0x0c00,0x1800,0x0000, // u0163
  0x6c00,0x3800,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0164
  0x6c00,0x3800,0x0000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0000,0x0000,0x0000, // u0165
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0166
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x7800,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0000,0x0000,0x0000, // u0167
  0x7600,0xdc00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0168
  0x0000,0x0000,0x7600,0xdc00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0169
  0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u016a
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u016b
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u016c
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u016d
  0x3800,0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u016e
  0x0000,0x0000,0x3800,0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u016f
  0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0170
  0x0000,0x0000,0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0171
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x3000,0x1c00,0x0000, // u0172
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0c00,0x0700,0x0000, // u0173
  0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xd600,0xfe00,0xee00,0xc600,0x8200,0x0000,0x0000,0x0000,0x0000, // u0174
  0x0000,0x0000,0x3800,0x6c00,0x0000,0xc600,0xc600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0175
  0x3800,0x6c00,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0176
  0x0000,0x0000,0x3800,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0177
  0x6600,0x6600,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0178
  0x1800,0x3000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0179
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u017a
  0x1800,0x1800,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u017b
  0x0000,0x0000,0x1800,0x1800,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u017c
  0x6c00,0x3800,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u017d
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u017e
  0x0000,0x0000,0x1e00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u017f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x0600,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0186
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0600,0x3e00,0x0600,0x0600,0x0600,0x0600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u018e
  0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u018f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0x7800,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0190
  0x0000,0x0000,0x0e00,0x1b00,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xd800,0x7000,0x0000, // u0192
  0x0000,0x0000,0x6600,0x6600,0x6600,0x7600,0x7e00,0x6e00,0x6600,0x6600,0x6600,0x6600,0x6000,0x6000,0xc000,0x0000, // u019d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600,0x0600,0x0000, // u019e
  0x0000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0xfe00,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u01b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0c00,0x1800,0xfc00,0x3000,0x6000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u01b6
  0x0000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01b7
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u01cd
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u01ce
  0x6c00,0x3800,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01cf
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u01d0
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01d1
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01d2
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01d3
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u01d4
  0x7c00,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000,0x0000,0x0000, // u01e2
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u01e3
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xde00,0xc600,0xdf00,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01e4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xdf00,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u01e5
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01e6
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u01e7
  0x6c00,0x3800,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u01e8
  0x6c00,0x3800,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u01e9
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x3000,0x1c00,0x0000, // u01ea
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x3000,0x1c00,0x0000, // u01eb
  0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x3000,0x1c00,0x0000, // u01ec
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x1800,0x3000,0x1c00,0x0000, // u01ed
  0x6c00,0x3800,0x0000,0xfe00,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01ee
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000, // u01ef
  0x0000,0x0000,0x1b00,0x0e00,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // u01f0
  0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xde00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01f4
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u01f5
  0x0c00,0x1800,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000,0x0000,0x0000, // u01fc
  0x0000,0x0000,0x0c00,0x1800,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u01fd
  0x1800,0x3000,0x0000,0x7c00,0xc700,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u01fe
  0x0000,0x0000,0x1800,0x3000,0x0000,0x3d00,0x6700,0x6e00,0x7e00,0x7600,0xe600,0xbc00,0x0000,0x0000,0x0000,0x0000, // u01ff
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x3000,0x3000,0x6000, // u0218
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x3000,0x3000,0x6000, // u0219
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x3000, // u021a
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0c00,0x0c00,0x1800, // u021b
  0x7e00,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0232
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0233
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // u0237
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0254
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0x0600,0x0600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0258
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x0600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0259
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0x7800,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u025b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6000,0x6000,0xc000,0x0000, // u0272
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0600,0x0c00,0x1800,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000, // u0292
  0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bb
  0x1800,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bc
  0x3000,0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02bd
  0x3800,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c6
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02c7
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d8
  0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02d9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3000,0x1c00,0x0000, // u02db
  0x7600,0xdc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dc
  0x3600,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u02dd
  0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0300
  0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0301
  0x3800,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0302
  0x7600,0xdc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0303
  0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0304
  0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0305
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0306
  0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0307
  0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0308
  0x3800,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030a
  0x3600,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030b
  0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u030c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000, // u0329
  0x6000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0384
  0x1800,0x3000,0x0000,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0385
  0x6000,0xc000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0386
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u0387
  0x6000,0xc000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0388
  0x6000,0xc000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0389
  0x6000,0xc000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u038a
  0x6000,0xc000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u038c
  0x6000,0xc000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u038e
  0x6000,0xc000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0xee00,0x0000,0x0000,0x0000,0x0000, // u038f
  0x1800,0x3000,0xd800,0xd800,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000,0x0000,0x0000, // u0390
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0391
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0392
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0393
  0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x6c00,0x6c00,0x6c00,0xc600,0xc600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0394
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0395
  0x0000,0x0000,0xfe00,0x0600,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0396
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0397
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xd600,0xd600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0398
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0399
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u039a
  0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x6c00,0x6c00,0x6c00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u039b
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u039c
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u039d
  0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u039e
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u039f
  0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u03a0
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u03a1
  0x0000,0x0000,0xfe00,0xc000,0x6000,0x3000,0x1800,0x1800,0x3000,0x6000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u03a3
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u03a4
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u03a5
  0x0000,0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000,0x0000,0x0000,0x0000, // u03a6
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u03a7
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u03a8
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0xee00,0x0000,0x0000,0x0000,0x0000, // u03a9
  0x6600,0x6600,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03aa
  0x6600,0x6600,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u03ab
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7a00,0xce00,0xcc00,0xcc00,0xcc00,0xce00,0x7a00,0x0000,0x0000,0x0000,0x0000, // u03ac
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc000,0x7800,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03ad
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600,0x0600,0x0000, // u03ae
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000,0x0000,0x0000, // u03af
  0x1800,0x3000,0x0000,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7a00,0xce00,0xcc00,0xcc00,0xcc00,0xce00,0x7a00,0x0000,0x0000,0x0000,0x0000, // u03b1
  0x0000,0x0000,0x7800,0xcc00,0xcc00,0xc800,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0x0000, // u03b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000, // u03b3
  0x0000,0x0000,0x7e00,0x3000,0x1800,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0x7800,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03b5
  0x0000,0x0000,0xfe00,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0xc000,0xc000,0x7c00,0x0600,0x0600,0x0c00,0x0000, // u03b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0600,0x0600,0x0600,0x0000, // u03b7
  0x0000,0x0000,0x3c00,0x6600,0x6600,0x6600,0x7e00,0x6600,0x6600,0x6600,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000,0x0000,0x0000, // u03b9
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u03ba
  0x0000,0x0000,0x3000,0x3000,0x1800,0x1800,0x3c00,0x3c00,0x6600,0x6600,0xc300,0xc300,0x0000,0x0000,0x0000,0x0000, // u03bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xce00,0xf600,0xc000,0xc000,0xc000,0x0000, // u03bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000, // u03bd
  0x0000,0x0000,0x7e00,0xc000,0xc000,0xc000,0x7c00,0xc000,0xc000,0xc000,0xc000,0x7c00,0x0600,0x0600,0x0c00,0x0000, // u03be
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u03c0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0x0000, // u03c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc000,0x7c00,0x0600,0x0600,0x0c00,0x0000, // u03c2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x6600,0x6600,0x6600,0x6600,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0e00,0x0000,0x0000,0x0000,0x0000, // u03c4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4c00,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x1000,0x1000,0x0000, // u03c6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000, // u03c7
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x1000,0x1000,0x0000, // u03c8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4400,0xc600,0xd600,0xd600,0xd600,0xfe00,0x6c00,0x0000,0x0000,0x0000,0x0000, // u03c9
  0x0000,0x0000,0xd800,0xd800,0x0000,0x7000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1c00,0x0000,0x0000,0x0000,0x0000, // u03ca
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03cb
  0x0000,0x0000,0x1800,0x3000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03cc
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03cd
  0x0000,0x0000,0x1800,0x3000,0x0000,0x4400,0xc600,0xd600,0xd600,0xd600,0xfe00,0x6c00,0x0000,0x0000,0x0000,0x0000, // u03ce
  0x0000,0x0000,0x3c00,0x6600,0x6600,0x6600,0x3f00,0x0600,0xe600,0x6600,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000, // u03d1
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000,0x0000,0x0000, // u03d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe300,0x3600,0x1c00,0x1800,0x3800,0x6c00,0xc700,0x0000,0x0000,0x0000,0x0000, // u03f0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0x7c00,0x0000, // u03f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03f2
  0x0000,0x0000,0x0600,0x0600,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // u03f3
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u03f4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x6000,0xc000,0xfc00,0xc000,0x6000,0x3e00,0x0000,0x0000,0x0000,0x0000, // u03f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0c00,0x0600,0x7e00,0x0600,0x0c00,0xf800,0x0000,0x0000,0x0000,0x0000, // u03f6
  0x3000,0x1800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0400
  0x6c00,0x6c00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0401
  0x0000,0x0000,0xf000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6c00,0x0000,0x0000,0x0000,0x0000, // u0402
  0x1800,0x3000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0403
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0404
  0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0x7c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0405
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0406
  0x6600,0x6600,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0407
  0x0000,0x0000,0x1e00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0x7800,0x0000,0x0000,0x0000,0x0000, // u0408
  0x0000,0x0000,0x3000,0x7000,0xd000,0xdc00,0xd600,0xd600,0xd600,0xd600,0xd600,0x9c00,0x0000,0x0000,0x0000,0x0000, // u0409
  0x0000,0x0000,0xd000,0xd000,0xd000,0xdc00,0xf600,0xd600,0xd600,0xd600,0xd600,0xdc00,0x0000,0x0000,0x0000,0x0000, // u040a
  0x0000,0x0000,0xf000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u040b
  0x1800,0x3000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u040c
  0x3000,0x1800,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u040d
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u040e
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x3800,0x3800,0x0000,0x0000, // u040f
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0410
  0x0000,0x0000,0xfc00,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0411
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0412
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0413
  0x0000,0x0000,0x3e00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0xff00,0xc300,0x0000,0x0000,0x0000, // u0414
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u0415
  0x0000,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u0416
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0417
  0x0000,0x0000,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0418
  0x6c00,0x3800,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0419
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u041a
  0x0000,0x0000,0x1e00,0x3600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0xc600,0x0000,0x0000,0x0000,0x0000, // u041b
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u041c
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u041d
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u041e
  0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u041f
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0420
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0421
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0422
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0423
  0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000,0x0000,0x0000, // u0424
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0425
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7f00,0x0300,0x0300,0x0000,0x0000, // u0426
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u0427
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0428
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7f00,0x0300,0x0300,0x0000,0x0000, // u0429
  0x0000,0x0000,0xe000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u042a
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000,0x0000,0x0000, // u042b
  0x0000,0x0000,0x6000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u042c
  0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0x3e00,0x0600,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u042d
  0x0000,0x0000,0xcc00,0xd600,0xd600,0xd600,0xd600,0xf600,0xd600,0xd600,0xd600,0xcc00,0x0000,0x0000,0x0000,0x0000, // u042e
  0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0x7e00,0x1e00,0x3600,0x6600,0xc600,0x0000,0x0000,0x0000,0x0000, // u042f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0430
  0x0000,0x0000,0x7c00,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0431
  0x0000,0x0000,0x7800,0xcc00,0xcc00,0xc800,0xfc00,0xc600,0xc600,0xc600,0xc600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0432
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0433
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0434
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0435
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u0436
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x3c00,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0437
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0438
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0439
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u043a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x6600,0x6600,0x6600,0x6600,0x6600,0xc600,0x0000,0x0000,0x0000,0x0000, // u043b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u043c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u043d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u043e
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u043f
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xfc00,0xc000,0xc000,0xc000,0x0000, // u0440
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0441
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u0442
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u0443
  0x0000,0x0000,0x0000,0x0000,0x1000,0x7c00,0xd600,0xd600,0xd600,0xd600,0xd600,0x7c00,0x1000,0x0000,0x0000,0x0000, // u0444
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x3800,0x6c00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u0445
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7f00,0x0300,0x0300,0x0000,0x0000, // u0446
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u0447
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u0448
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x7f00,0x0300,0x0300,0x0000,0x0000, // u0449
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u044a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000,0x0000,0x0000, // u044b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u044c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x3e00,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u044d
  0x0000,0x0000,0x0000,0x0000,0x0000,0xcc00,0xd600,0xd600,0xf600,0xd600,0xd600,0xcc00,0x0000,0x0000,0x0000,0x0000, // u044e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc600,0xc600,0x7e00,0x3600,0x6600,0xc600,0x0000,0x0000,0x0000,0x0000, // u044f
  0x0000,0x0000,0x3000,0x1800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0450
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0451
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0600,0x0600,0x1c00,0x0000, // u0452
  0x0000,0x0000,0x1800,0x3000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0453
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xf800,0xc000,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0454
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0x7c00,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u0455
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0456
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u0457
  0x0000,0x0000,0x0600,0x0600,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // u0458
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7000,0xd000,0xdc00,0xd600,0xd600,0xd600,0x9c00,0x0000,0x0000,0x0000,0x0000, // u0459
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd000,0xd000,0xdc00,0xf600,0xd600,0xd600,0xdc00,0x0000,0x0000,0x0000,0x0000, // u045a
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u045b
  0x0000,0x0000,0x1800,0x3000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x0000,0x0000,0x0000, // u045c
  0x0000,0x0000,0x3000,0x1800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u045d
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u045e
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x3800,0x3800,0x0000,0x0000, // u045f
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0462
  0x0000,0x0000,0x6000,0x6000,0xf800,0x6000,0x6000,0x7c00,0x6600,0x6600,0x6600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u0463
  0x0000,0x0000,0xfe00,0xc600,0x6c00,0x6c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u046a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x6c00,0x2800,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u046b
  0x0600,0x0600,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0490
  0x0000,0x0000,0x0000,0x0600,0x0600,0xfe00,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u0491
  0x0000,0x0000,0x7f00,0x6000,0x6000,0x6000,0xfc00,0x6000,0x6000,0x6000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u0492
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x6000,0x6000,0xfc00,0x6000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000, // u0493
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0x0600,0x0c00,0x0000,0x0000, // u0494
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc000,0xc000,0xf800,0xcc00,0xcc00,0xcc00,0x0c00,0x1800,0x0000,0x0000, // u0495
  0x0000,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0xd700,0x0300,0x0300,0x0000,0x0000, // u0496
  0x0000,0x0000,0x0000,0x0000,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd700,0x0300,0x0300,0x0000,0x0000, // u0497
  0x0000,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0x0600,0xc600,0xc600,0x7c00,0x3000,0x3000,0x3000,0x0000, // u0498
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0x0600,0x3c00,0x0600,0xc600,0x7c00,0x3000,0x3000,0x3000,0x0000, // u0499
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc700,0x0300,0x0300,0x0000,0x0000, // u049a
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc700,0x0300,0x0300,0x0000,0x0000, // u049b
  0x0000,0x0000,0xc600,0xc600,0xd600,0xdc00,0xf800,0xf800,0xdc00,0xd600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u049c
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xd600,0xdc00,0xf800,0xdc00,0xd600,0xc600,0x0000,0x0000,0x0000,0x0000, // u049d
  0x0000,0x0000,0xe300,0xe300,0x6600,0x6c00,0x7800,0x7800,0x6c00,0x6600,0x6300,0x6300,0x0000,0x0000,0x0000,0x0000, // u04a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0xe300,0x6600,0x6c00,0x7800,0x6c00,0x6600,0x6300,0x0000,0x0000,0x0000,0x0000, // u04a1
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc700,0x0300,0x0300,0x0000,0x0000, // u04a2
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc700,0x0300,0x0300,0x0000,0x0000, // u04a3
  0x0000,0x0000,0xcf00,0xcc00,0xcc00,0xcc00,0xfc00,0xcc00,0xcc00,0xcc00,0xcc00,0xcc00,0x0000,0x0000,0x0000,0x0000, // u04a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xcf00,0xcc00,0xcc00,0xfc00,0xcc00,0xcc00,0xcc00,0x0000,0x0000,0x0000,0x0000, // u04a5
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc000,0xc000,0xc000,0xc000,0xc600,0xc600,0x7c00,0x3000,0x3000,0x3000,0x0000, // u04aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc000,0xc000,0xc000,0xc600,0x7c00,0x3000,0x3000,0x3000,0x0000, // u04ab
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u04ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000, // u04af
  0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x7e00,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u04b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x7e00,0x1800,0x1800,0x0000, // u04b1
  0x0000,0x0000,0xc600,0xc600,0x6c00,0x6c00,0x3800,0x3800,0x6c00,0x6c00,0xc600,0xc700,0x0300,0x0300,0x0000,0x0000, // u04b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x6c00,0x3800,0x6c00,0xc600,0xc700,0x0300,0x0300,0x0000,0x0000, // u04b3
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0700,0x0300,0x0300,0x0000,0x0000, // u04b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0700,0x0300,0x0300,0x0000,0x0000, // u04b7
  0x0000,0x0000,0xc600,0xc600,0xc600,0xd600,0xd600,0x7e00,0x1600,0x1600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u04b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xd600,0xd600,0x7e00,0x1600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u04b9
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u04ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u04bb
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04c0
  0x6c00,0x3800,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u04c1
  0x0000,0x0000,0x6c00,0x3800,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u04c2
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u04cf
  0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u04d0
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u04d1
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u04d2
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0x0600,0x7e00,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u04d3
  0x0000,0x0000,0x7e00,0xd800,0xd800,0xd800,0xfe00,0xd800,0xd800,0xd800,0xd800,0xde00,0x0000,0x0000,0x0000,0x0000, // u04d4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6c00,0x1600,0x1600,0x7e00,0xd000,0xd000,0x6c00,0x0000,0x0000,0x0000,0x0000, // u04d5
  0x6c00,0x3800,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u04d6
  0x0000,0x0000,0x6c00,0x3800,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04d7
  0x0000,0x0000,0x7c00,0xc600,0x0600,0x0600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04d8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0600,0x0600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04d9
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x0600,0xfe00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04da
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0x0600,0x0600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04db
  0x6c00,0x6c00,0x0000,0xd600,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u04dc
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xd600,0xd600,0x7c00,0x3800,0x7c00,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u04dd
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0x0600,0x3c00,0x0600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04de
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x3c00,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04df
  0x7c00,0x0000,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u04e2
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u04e3
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xce00,0xde00,0xf600,0xe600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u04e4
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x0000,0x0000,0x0000, // u04e5
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04e6
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04e7
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04e8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04e9
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xc600,0xfe00,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04ea
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04eb
  0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x0600,0x3e00,0x0600,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04ec
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0x7c00,0xc600,0x0600,0x3e00,0x0600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04ed
  0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04ee
  0x0000,0x0000,0x0000,0x7c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u04ef
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04f0
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u04f1
  0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u04f2
  0x0000,0x0000,0x3600,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u04f3
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u04f4
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u04f5
  0x6c00,0x6c00,0x0000,0xc600,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000,0x0000,0x0000, // u04f8
  0x0000,0x0000,0x6c00,0x6c00,0x0000,0xc600,0xc600,0xe600,0xd600,0xd600,0xd600,0xe600,0x0000,0x0000,0x0000,0x0000, // u04f9
  0x0000,0x0000,0xc600,0xc600,0x6600,0x6600,0x3c00,0x7800,0xcc00,0xcc00,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u05d0
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0xff00,0x0000,0x0000,0x0000,0x0000, // u05d1
  0x0000,0x0000,0x7800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x1e00,0x3600,0x6300,0xc300,0x0000,0x0000,0x0000,0x0000, // u05d2
  0x0000,0x0000,0xff00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u05d3
  0x0000,0x0000,0xfc00,0x0600,0x0600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u05d4
  0x0000,0x0000,0x7000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u05d5
  0x0000,0x0000,0x7e00,0x0c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u05d6
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u05d7
  0x0000,0x0000,0xcc00,0xce00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u05d8
  0x0000,0x0000,0x7000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u05d9
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0000, // u05da
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u05db
  0xc000,0xc000,0xfe00,0x0600,0x0600,0x0600,0x0600,0x0c00,0x1800,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u05dc
  0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u05dd
  0x0000,0x0000,0xdc00,0x7600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6e00,0x0000,0x0000,0x0000,0x0000, // u05de
  0x0000,0x0000,0xf000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u05df
  0x0000,0x0000,0x7800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x7c00,0x0000,0x0000,0x0000,0x0000, // u05e0
  0x0000,0x0000,0xfc00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000, // u05e1
  0x0000,0x0000,0xc600,0xc600,0xc600,0x6600,0x6600,0x3600,0x3600,0x1c00,0x3800,0xe000,0x0000,0x0000,0x0000,0x0000, // u05e2
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x6600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0000, // u05e3
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0x6600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000, // u05e4
  0x0000,0x0000,0x6300,0x6300,0x3300,0x3600,0x1c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000, // u05e5
  0x0000,0x0000,0xc600,0xc600,0x6600,0x6c00,0x3800,0x3000,0x1800,0x1800,0x0c00,0xfc00,0x0000,0x0000,0x0000,0x0000, // u05e6
  0x0000,0x0000,0xfe00,0x0600,0x0600,0xc600,0xc600,0xcc00,0xd800,0xd800,0xd800,0xd800,0xc000,0xc000,0xc000,0x0000, // u05e7
  0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000, // u05e8
  0x0000,0x0000,0xd600,0xd600,0xd600,0xd600,0xd600,0xe600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x0000,0x0000,0x0000, // u05e9
  0x0000,0x0000,0xfc00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0xc600,0x0000,0x0000,0x0000,0x0000, // u05ea
  0x0000,0x0000,0xf800,0xcc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xcc00,0xf800,0x0000,0x3000,0x3000,0x0000, // u1e0c
  0x0000,0x0000,0x0600,0x0600,0x0600,0x7e00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x1800,0x1800,0x0000, // u1e0d
  0x0000,0x0000,0xc600,0xc600,0xcc00,0xd800,0xf000,0xf000,0xd800,0xcc00,0xc600,0xc600,0x0000,0x7c00,0x0000,0x0000, // u1e34
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc600,0xcc00,0xd800,0xf000,0xd800,0xcc00,0xc600,0x0000,0x7c00,0x0000,0x0000, // u1e35
  0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x1800,0x1800,0x0000, // u1e36
  0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x1800,0x1800,0x0000, // u1e37
  0x1800,0x1800,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u1e40
  0x0000,0x0000,0x3000,0x3000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000,0x0000, // u1e41
  0x0000,0x0000,0x8200,0xc600,0xee00,0xfe00,0xd600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x1800,0x1800,0x0000, // u1e42
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0xd600,0xd600,0x0000,0x1800,0x1800,0x0000, // u1e43
  0x1800,0x1800,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u1e44
  0x0000,0x0000,0x3000,0x3000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u1e45
  0x0000,0x0000,0xc600,0xc600,0xc600,0xe600,0xf600,0xde00,0xce00,0xc600,0xc600,0xc600,0x0000,0x1800,0x1800,0x0000, // u1e46
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x1800,0x1800,0x0000, // u1e47
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x0000, // u1e6c
  0x0000,0x0000,0x3000,0x3000,0x3000,0xfc00,0x3000,0x3000,0x3000,0x3000,0x3000,0x1e00,0x0000,0x0c00,0x0c00,0x0000, // u1e6d
  0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x1800,0x1800,0x0000, // u1eb8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x1800,0x1800,0x0000, // u1eb9
  0x7600,0xdc00,0x0000,0xfe00,0xc000,0xc000,0xc000,0xf800,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u1ebc
  0x0000,0x0000,0x7600,0xdc00,0x0000,0x7c00,0xc600,0xc600,0xfe00,0xc000,0xc000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u1ebd
  0x0000,0x0000,0x3c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x1800,0x1800,0x0000, // u1eca
  0x0000,0x0000,0x1800,0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x1800,0x1800,0x0000, // u1ecb
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x1800,0x1800,0x0000, // u1ecc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x1800,0x1800,0x0000, // u1ecd
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x1800,0x1800,0x0000, // u1ee4
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0000,0x1800,0x1800,0x0000, // u1ee5
  0x7600,0xdc00,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u1ef8
  0x0000,0x0000,0x7600,0xdc00,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7e00,0x0600,0x0600,0x7c00,0x0000, // u1ef9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2001
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2002
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2003
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2004
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2005
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2006
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2007
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2008
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2009
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u200f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2010
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2011
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2012
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2013
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2014
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2015
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000, // u2016
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0xfe00, // u2017
  0x0000,0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2018
  0x0000,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2019
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000, // u201a
  0x0000,0x3000,0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201b
  0x0000,0x6600,0xcc00,0xcc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201c
  0x0000,0x3300,0x3300,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0xcc00,0x0000,0x0000,0x0000, // u201e
  0x0000,0xcc00,0xcc00,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u201f
  0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2020
  0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2021
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2022
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xdb00,0xdb00,0x0000,0x0000,0x0000,0x0000, // u2026
  0x0000,0x0000,0xec00,0xac00,0xf800,0x1800,0x3000,0x3000,0x6000,0x7f00,0xd500,0xdf00,0x0000,0x0000,0x0000,0x0000, // u2030
  0x0000,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2032
  0x0000,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2033
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1800,0x3000,0x6000,0x3000,0x1800,0x0c00,0x0000,0x0000,0x0000,0x0000, // u2039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x3000,0x1800,0x0c00,0x1800,0x3000,0x6000,0x0000,0x0000,0x0000,0x0000, // u203a
  0x0000,0x0000,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u203c
  0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u203e
  0x0000,0x3800,0x6c00,0x6c00,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2070
  0x1800,0x0000,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2071
  0x0000,0x0c00,0x1c00,0x3400,0x7e00,0x0c00,0x0c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2074
  0x0000,0x7800,0x6000,0x7800,0x0c00,0x0c00,0x7800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2075
  0x0000,0x3800,0x6000,0x7800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2076
  0x0000,0x7c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2077
  0x0000,0x3800,0x6c00,0x3800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2078
  0x0000,0x3800,0x6c00,0x6c00,0x3c00,0x0c00,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2079
  0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207a
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207b
  0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207c
  0x0000,0x1800,0x3000,0x3000,0x3000,0x3000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207d
  0x0000,0x3000,0x1800,0x1800,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207e
  0x0000,0x0000,0x7800,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u207f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x6c00,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000, // u2080
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000, // u2081
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x0c00,0x1800,0x3000,0x7c00,0x0000,0x0000,0x0000, // u2082
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0c00,0x3800,0x0c00,0x0c00,0x7800,0x0000,0x0000,0x0000, // u2083
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1c00,0x3400,0x7e00,0x0c00,0x0c00,0x0000,0x0000,0x0000, // u2084
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x6000,0x7800,0x0c00,0x0c00,0x7800,0x0000,0x0000,0x0000, // u2085
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6000,0x7800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000, // u2086
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x0000,0x0000,0x0000, // u2087
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x3800,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000, // u2088
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x6c00,0x3c00,0x0c00,0x3800,0x0000,0x0000,0x0000, // u2089
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000, // u208a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u208b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0000,0x7c00,0x0000,0x0000,0x0000,0x0000, // u208c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x3000,0x3000,0x3000,0x3000,0x1800,0x0000,0x0000,0x0000, // u208d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x1800,0x1800,0x1800,0x1800,0x3000,0x0000,0x0000,0x0000, // u208e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x0c00,0x3c00,0x6c00,0x3c00,0x0000,0x0000,0x0000, // u2090
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x7c00,0x6000,0x3c00,0x0000,0x0000,0x0000, // u2091
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x6c00,0x6c00,0x6c00,0x3800,0x0000,0x0000,0x0000, // u2092
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x3c00,0x1800,0x3c00,0x6600,0x0000,0x0000,0x0000, // u2093
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x0c00,0x7c00,0x6c00,0x3800,0x0000,0x0000,0x0000, // u2094
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x7800,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000, // u2095
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x6600,0x6c00,0x7800,0x6c00,0x6600,0x0000,0x0000,0x0000, // u2096
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000, // u2097
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xd600,0xd600,0xd600,0xd600,0x0000,0x0000,0x0000, // u2098
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7800,0x6c00,0x6c00,0x6c00,0x7800,0x6000,0x6000,0x0000, // u209a
  0x0000,0x0000,0xf800,0xcc00,0xcc00,0xcc00,0xfa00,0xc600,0xcf00,0xc600,0xc600,0xc300,0x0000,0x0000,0x0000,0x0000, // u20a7
  0x0000,0x0000,0xf200,0x8a00,0x8a00,0xaa00,0xaa00,0xaa00,0xaa00,0xa200,0xa200,0xbc00,0x0000,0x0000,0x0000,0x0000, // u20aa
  0x0000,0x0000,0x0000,0x1e00,0x3300,0x6000,0xfc00,0x6000,0xfc00,0x6000,0x3300,0x1e00,0x0000,0x0000,0x0000,0x0000, // u20ac
  0x0000,0x0000,0xff00,0x1800,0x1800,0x1e00,0x7800,0x1e00,0x7800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u20ae
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5000,0x5000,0x5000,0x5000,0x5200,0x5200,0x3c00,0x0000,0x0000,0x0000,0x0000, // u2102
  0x0000,0x0000,0xc000,0xc000,0xc000,0xfc00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u210e
  0x0000,0x0000,0x6000,0xf800,0x6000,0x7c00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000, // u210f
  0x0000,0x0000,0x4200,0x4200,0x6200,0x5200,0x6a00,0x5600,0x4a00,0x4600,0x4200,0x4200,0x0000,0x0000,0x0000,0x0000, // u2115
  0x0000,0x0000,0x9600,0x9600,0x9600,0xd000,0xf000,0xf000,0xb000,0x9600,0x9000,0x9600,0x0000,0x0000,0x0000,0x0000, // u2116
  0x0000,0x0000,0x3c00,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5200,0x5a00,0x3c00,0x0600,0x0000,0x0000,0x0000, // u211a
  0x0000,0x0000,0xf800,0xa400,0xa400,0xa400,0xa400,0xb800,0xa800,0xb400,0xaa00,0xe600,0x0000,0x0000,0x0000,0x0000, // u211d
  0x0000,0x0000,0xfb00,0x5500,0x5500,0x5100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2122
  0x0000,0x0000,0x7e00,0x0200,0x0600,0x0a00,0x1400,0x2800,0x5000,0x6000,0x4000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2124
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x6c00,0x6c00,0xee00,0x0000,0x0000,0x0000,0x0000, // u2126
  0x0000,0x0000,0x6600,0x6600,0x3300,0x3300,0x3e00,0x7c00,0xcc00,0xcc00,0xc600,0x6600,0x0000,0x0000,0x0000,0x0000, // u2135
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x6000,0xfe00,0xfe00,0x6000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2190
  0x0000,0x0000,0x1800,0x3c00,0x7e00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2191
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0c00,0xfe00,0xfe00,0x0c00,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2192
  0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x7e00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000, // u2193
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x6600,0xff00,0xff00,0x6600,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000, // u2194
  0x0000,0x0000,0x1800,0x3c00,0x7e00,0x1800,0x1800,0x1800,0x1800,0x7e00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000, // u2195
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2200,0x6200,0xfe00,0xfe00,0x6200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000, // u21a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8800,0x8c00,0xfe00,0xfe00,0x8c00,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000, // u21a6
  0x0000,0x0000,0x1800,0x3c00,0x7e00,0x1800,0x1800,0x1800,0x7e00,0x3c00,0x1800,0x7e00,0x0000,0x0000,0x0000,0x0000, // u21a8
  0x0000,0x0000,0x0600,0x0600,0x0600,0x0600,0x2600,0x6600,0xfe00,0xfe00,0x6000,0x2000,0x0000,0x0000,0x0000,0x0000, // u21b5
  0x0000,0x0000,0x0000,0xf800,0x3800,0x6800,0xcb00,0xc300,0xc300,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u21bb
  0x0000,0x0000,0x0000,0x2000,0x6000,0xfe00,0xfe00,0x0000,0xfe00,0xfe00,0x0c00,0x0800,0x0000,0x0000,0x0000,0x0000, // u21cb
  0x0000,0x0000,0x0000,0x0800,0x0c00,0xfe00,0xfe00,0x0000,0xfe00,0xfe00,0x6000,0x2000,0x0000,0x0000,0x0000,0x0000, // u21cc
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3e00,0x7e00,0xe000,0x7e00,0x3e00,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d0
  0x0000,0x0000,0x1000,0x3800,0x7c00,0xee00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000, // u21d1
  0x0000,0x0000,0x0000,0x0000,0x1000,0xf800,0xfc00,0x0e00,0xfc00,0xf800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d2
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xee00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d3
  0x0000,0x0000,0x0000,0x0000,0x2400,0x7e00,0xff00,0xc300,0xff00,0x7e00,0x2400,0x0000,0x0000,0x0000,0x0000,0x0000, // u21d4
  0x0000,0x0000,0x1000,0x3800,0x7c00,0xee00,0x6c00,0x6c00,0xee00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u21d5
  0x0000,0x0000,0xc600,0xc600,0xc600,0xfe00,0x6c00,0x6c00,0x6c00,0x3800,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000, // u2200
  0x0000,0x0000,0x0000,0xfe00,0x0600,0x0600,0x0600,0xfe00,0x0600,0x0600,0x0600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2203
  0x0000,0x0000,0x0c00,0xfe00,0x1e00,0x1600,0x3600,0xfe00,0x3600,0x6600,0x6600,0xfe00,0xc000,0x0000,0x0000,0x0000, // u2204
  0x0000,0x0000,0x0600,0x0c00,0x7c00,0xce00,0xde00,0xf600,0xe600,0x7c00,0x6000,0xc000,0x0000,0x0000,0x0000,0x0000, // u2205
  0x0000,0x0000,0x1000,0x1000,0x3800,0x3800,0x6c00,0x6c00,0x6c00,0xc600,0xc600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2206
  0x0000,0x0000,0xfe00,0xc600,0xc600,0x6c00,0x6c00,0x6c00,0x3800,0x3800,0x1000,0x1000,0x0000,0x0000,0x0000,0x0000, // u2207
  0x0000,0x0000,0x0000,0x3e00,0x6000,0xc000,0xc000,0xfe00,0xc000,0xc000,0x6000,0x3e00,0x0000,0x0000,0x0000,0x0000, // u2208
  0x0000,0x0000,0x0600,0x3e00,0x6c00,0xcc00,0xd800,0xfe00,0xd800,0xf000,0x7000,0x7e00,0x6000,0x0000,0x0000,0x0000, // u2209
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x6000,0xc000,0xfe00,0xc000,0x6000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u220a
  0x0000,0x0000,0x0000,0xf800,0x0c00,0x0600,0x0600,0xfe00,0x0600,0x0600,0x0c00,0xf800,0x0000,0x0000,0x0000,0x0000, // u220b
  0x0000,0x0000,0xc000,0xf800,0x6c00,0x6600,0x3600,0xfe00,0x3600,0x1e00,0x1c00,0xfc00,0x0c00,0x0000,0x0000,0x0000, // u220c
  0x0000,0x0000,0x0000,0x0000,0xf800,0x0c00,0x0600,0xfe00,0x0600,0x0c00,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000, // u220d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2212
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2213
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x0000,0x1800,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2214
  0x0000,0x0000,0x0000,0x0000,0x0200,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0x8000,0x0000,0x0000,0x0000,0x0000, // u2215
  0x0000,0x0000,0x0000,0x0000,0x8000,0xc000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0200,0x0000,0x0000,0x0000,0x0000, // u2216
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2219
  0x0000,0x0e00,0x0c00,0x0c00,0x0c00,0x0c00,0xcc00,0xcc00,0xcc00,0x6c00,0x3c00,0x1c00,0x0000,0x0000,0x0000,0x0000, // u221a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0xd600,0xd600,0xd600,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u221e
  0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u221f
  0x0000,0x0000,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x0000,0x0000,0x0000,0x0000, // u2225
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3c00,0x3c00,0x6600,0x6600,0xc300,0xc300,0x0000,0x0000,0x0000,0x0000, // u2227
  0x0000,0x0000,0x0000,0x0000,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2228
  0x0000,0x0000,0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u2229
  0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u222a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7600,0xdc00,0x0000,0x7600,0xdc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2248
  0x0000,0x0000,0x0000,0x0000,0x0600,0xfe00,0x1800,0x3000,0xfe00,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2260
  0x0000,0x0000,0x0000,0x0000,0xfe00,0x0000,0x0000,0xfe00,0x0000,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2261
  0x0000,0x0000,0x0000,0x0c00,0x1800,0x3000,0x6000,0x3000,0x1800,0x0c00,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2264
  0x0000,0x0000,0x0000,0x3000,0x1800,0x0c00,0x0600,0x0c00,0x1800,0x3000,0x0000,0x7e00,0x0000,0x0000,0x0000,0x0000, // u2265
  0x0000,0x0000,0x0000,0x0900,0x1b00,0x3600,0x6c00,0xd800,0x6c00,0x3600,0x1b00,0x0900,0x0000,0x0000,0x0000,0x0000, // u226a
  0x0000,0x0000,0x0000,0x9000,0xd800,0x6c00,0x3600,0x1b00,0x3600,0x6c00,0xd800,0x9000,0x0000,0x0000,0x0000,0x0000, // u226b
  0x0000,0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0xc000,0xc000,0xc000,0x7e00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2282
  0x0000,0x0000,0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000, // u2283
  0x0000,0x0000,0x0000,0x7e00,0xc000,0xc000,0xc000,0xc000,0xc000,0x7e00,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2286
  0x0000,0x0000,0x0000,0xfc00,0x0600,0x0600,0x0600,0x0600,0x0600,0xfc00,0x0000,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2287
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0x0000,0x0000,0x0000,0x0000, // u22a5
  0x0000,0x0000,0x7c00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u22c2
  0x0000,0x0000,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0x7c00,0x0000,0x0000,0x0000,0x0000, // u22c3
  0x0000,0x0000,0x0600,0x0c00,0x7c00,0xce00,0xde00,0xf600,0xe600,0x7c00,0x6000,0xc000,0x0000,0x0000,0x0000,0x0000, // u2300
  0x0000,0x0000,0x0000,0x0000,0x1000,0x3800,0x6c00,0xc600,0xc600,0xc600,0xc600,0xfe00,0x0000,0x0000,0x0000,0x0000, // u2302
  0x0000,0x0000,0x3c00,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u2308
  0x0000,0x0000,0x3c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0000,0x0000,0x0000, // u2309
  0x0000,0x0000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3c00,0x0000,0x0000,0x0000,0x0000, // u230a
  0x0000,0x0000,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x3c00,0x0000,0x0000,0x0000,0x0000, // u230b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xc000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2310
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0xc000,0xfe00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2319
  0x0000,0x0000,0x0e00,0x1b00,0x1b00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2320
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xd800,0xd800,0x7000,0x0000,0x0000,0x0000,0x0000, // u2321
  0x0600,0x0c00,0x1800,0x1800,0x3000,0x3000,0x3000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u239b
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u239c
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x3000,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0600, // u239d
  0x6000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x0c00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u239e
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u239f
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0c00,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x6000, // u23a0
  0x7e00,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u23a1
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000, // u23a2
  0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x7e00, // u23a3
  0x7e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u23a4
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600, // u23a5
  0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x7e00, // u23a6
  0x0f00,0x1800,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u23a7
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0xe000,0xe000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000, // u23a8
  0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1800,0x0f00, // u23a9
  0xf000,0x1800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00, // u23ab
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0700,0x0700,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00, // u23ac
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x1800,0xf000, // u23ad
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u23ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23af
  0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23ba
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u23bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000, // u23bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00, // u23bd
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u23d0
  0x0000,0xcc00,0xcc00,0xfc00,0xcc00,0xcc00,0xcc00,0x0000,0x3f00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0000, // u2409
  0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xf800,0x0000,0x3f00,0x3000,0x3c00,0x3000,0x3000,0x3000,0x0000,0x0000, // u240a
  0x0000,0xcc00,0xcc00,0xcc00,0xcc00,0x7800,0x3000,0x0000,0x3f00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0000, // u240b
  0x0000,0xfc00,0xc000,0xf000,0xc000,0xc000,0xc000,0x0000,0x3f00,0x3000,0x3c00,0x3000,0x3000,0x3000,0x0000,0x0000, // u240c
  0x0000,0x7800,0xcc00,0xc000,0xc000,0xcc00,0x7800,0x0000,0x3e00,0x3300,0x3300,0x3e00,0x3600,0x3300,0x0000,0x0000, // u240d
  0x0000,0xcc00,0xec00,0xfc00,0xdc00,0xcc00,0xcc00,0x0000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3f00,0x0000,0x0000, // u2424
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2500
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2501
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2502
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2503
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2508
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xaa00,0xaa00,0xaa00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2509
  0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000,0x1800,0x1800,0x1800,0x0000, // u250a
  0x3800,0x3800,0x3800,0x0000,0x3800,0x3800,0x3800,0x0000,0x3800,0x3800,0x3800,0x0000,0x3800,0x3800,0x3800,0x0000, // u250b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u250d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u250e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u250f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2510
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2511
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2512
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2513
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2514
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2515
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2516
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2517
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2518
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2519
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251a
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u251b
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251c
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251d
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u251e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u251f
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2520
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2521
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3f00,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2522
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0x3f00,0x3f00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2523
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2524
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2525
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2526
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2527
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2528
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2529
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u252a
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xf800,0xf800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u252b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u252f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2530
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2531
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2532
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2533
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2534
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2535
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2536
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2537
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2538
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2539
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253a
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u253b
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253c
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253d
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u253f
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2540
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2541
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2542
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2543
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2544
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2545
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2546
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2547
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2548
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xf800,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u2549
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3f00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u254a
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0xff00,0xff00,0xff00,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u254b
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2550
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2551
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2552
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x7f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2553
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x7f00,0x6000,0x6f00,0x6f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2554
  0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2555
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2556
  0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x0c00,0xec00,0xec00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2557
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2558
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x7f00,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2559
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6f00,0x6f00,0x6000,0x7f00,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255a
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255b
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255c
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xec00,0xec00,0x0c00,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u255d
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1f00,0x1f00,0x1800,0x1f00,0x1f00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u255e
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6f00,0x6f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u255f
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6f00,0x6f00,0x6000,0x6f00,0x6f00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2560
  0x1800,0x1800,0x1800,0x1800,0x1800,0xf800,0xf800,0x1800,0xf800,0xf800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2561
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xec00,0xec00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2562
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xec00,0xec00,0x0c00,0xec00,0xec00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2563
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2564
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2565
  0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x0000,0xef00,0xef00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u2566
  0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2567
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2568
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xef00,0xef00,0x0000,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2569
  0x1800,0x1800,0x1800,0x1800,0x1800,0xff00,0xff00,0x1800,0xff00,0xff00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u256a
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xff00,0xff00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u256b
  0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0xef00,0xef00,0x0000,0xef00,0xef00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00,0x6c00, // u256c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0700,0x0f00,0x1c00,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u256d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe000,0xf000,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u256e
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3800,0xf000,0xe000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u256f
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1c00,0x0f00,0x0700,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2570
  0x0100,0x0100,0x0300,0x0200,0x0600,0x0400,0x0c00,0x0800,0x1800,0x1000,0x3000,0x2000,0x6000,0x4000,0xc000,0x8000, // u2571
  0x8000,0xc000,0x4000,0x6000,0x2000,0x3000,0x1000,0x1800,0x0800,0x0c00,0x0400,0x0600,0x0200,0x0300,0x0100,0x0100, // u2572
  0x8100,0xc100,0x4300,0x6200,0x2600,0x3400,0x1c00,0x1800,0x1800,0x1c00,0x3400,0x2600,0x6200,0x4300,0xc100,0x8100, // u2573
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2574
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2575
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2576
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u2577
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2578
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2579
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x1f00,0x1f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u257b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257c
  0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, // u257d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u257e
  0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800, // u257f
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2580
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00, // u2581
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00, // u2582
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2583
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2584
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2585
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2586
  0x0000,0x0000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2587
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2588
  0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00, // u2589
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00, // u258a
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800, // u258b
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u258c
  0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000,0xe000, // u258d
  0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000, // u258e
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000, // u258f
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2590
  0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200,0x8800,0x2200, // u2591
  0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500,0xaa00,0x5500, // u2592
  0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00,0xee00,0xbb00, // u2593
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u2596
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u2597
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2598
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u2599
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259a
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259b
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00, // u259c
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u259d
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000, // u259e
  0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u259f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x7c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u25a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfe00,0xfe00,0xfe00,0xfe00,0x0000,0x0000,0x0000,0x0000, // u25ac
  0x0000,0x0000,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0x0000,0x0000,0x0000,0x0000, // u25ae
  0x0000,0x0000,0x0000,0x0000,0x1800,0x1800,0x3c00,0x3c00,0x7e00,0x7e00,0xff00,0xff00,0x0000,0x0000,0x0000,0x0000, // u25b2
  0x0000,0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,0x0000, // u25b6
  0x0000,0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,0x0000, // u25ba
  0x0000,0x0000,0x0000,0x0000,0xff00,0xff00,0x7e00,0x7e00,0x3c00,0x3c00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u25bc
  0x0000,0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000,0x0000, // u25c0
  0x0000,0x0000,0x0000,0x0000,0x0300,0x0f00,0x3f00,0xff00,0xff00,0x3f00,0x0f00,0x0300,0x0000,0x0000,0x0000,0x0000, // u25c4
  0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x7e00,0xff00,0x7e00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u25c6
  0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x6600,0xc300,0x6600,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u25ca
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x6600,0x4200,0x4200,0x6600,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u25cb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x7e00,0x7e00,0x7e00,0x7e00,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000, // u25cf
  0xff00,0xff00,0xff00,0xff00,0xff00,0xff00,0xe700,0xc300,0xc300,0xe700,0xff00,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d8
  0xff00,0xff00,0xff00,0xff00,0xff00,0xc300,0x9900,0xbd00,0xbd00,0x9900,0xc300,0xff00,0xff00,0xff00,0xff00,0xff00, // u25d9
  0x0000,0x0000,0x7c00,0x8200,0xaa00,0x8200,0x8200,0xba00,0x9200,0x8200,0x8200,0x7c00,0x0000,0x0000,0x0000,0x0000, // u263a
  0x0000,0x0000,0x7c00,0xfe00,0xd600,0xfe00,0xfe00,0xc600,0xee00,0xfe00,0xfe00,0x7c00,0x0000,0x0000,0x0000,0x0000, // u263b
  0x0000,0x0000,0x0000,0x1800,0xdb00,0x7e00,0x3c00,0xe700,0x3c00,0x7e00,0xdb00,0x1800,0x0000,0x0000,0x0000,0x0000, // u263c
  0x0000,0x0000,0x3c00,0x6600,0x6600,0x6600,0x6600,0x3c00,0x1800,0x7e00,0x1800,0x1800,0x0000,0x0000,0x0000,0x0000, // u2640
  0x0000,0x0000,0x3e00,0x0e00,0x1a00,0x3200,0x7800,0xcc00,0xcc00,0xcc00,0xcc00,0x7800,0x0000,0x0000,0x0000,0x0000, // u2642
  0x0000,0x0000,0x1800,0x1800,0x3c00,0x7e00,0xff00,0xff00,0x7e00,0x1800,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u2660
  0x0000,0x0000,0x1800,0x3c00,0x3c00,0x1800,0x5a00,0xff00,0xff00,0x5a00,0x1800,0x3c00,0x0000,0x0000,0x0000,0x0000, // u2663
  0x0000,0x0000,0x0000,0x0000,0x6c00,0xfe00,0xfe00,0xfe00,0xfe00,0x7c00,0x3800,0x1000,0x0000,0x0000,0x0000,0x0000, // u2665
  0x0000,0x0000,0x0000,0x0000,0x1800,0x3c00,0x7e00,0xff00,0x7e00,0x3c00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000, // u2666
  0x0000,0x0000,0x7e00,0x6600,0x7e00,0x6000,0x6000,0x6000,0x6000,0x6000,0xe000,0xc000,0x0000,0x0000,0x0000,0x0000, // u266a
  0x0000,0x0000,0x7e00,0x6600,0x7e00,0x6600,0x6600,0x6600,0x6600,0x6600,0x6e00,0xec00,0xc000,0x0000,0x0000,0x0000, // u266b
  0x0000,0x0000,0x0300,0x0300,0x0600,0x0600,0xcc00,0xcc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u2713
  0x0000,0x0000,0x0700,0x0700,0x0e00,0x0e00,0xdc00,0xfc00,0x7800,0x7800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u2714
  0x0000,0x0000,0x0c00,0xcc00,0x7800,0x3800,0x3800,0x3c00,0x6600,0x6000,0xc000,0xc000,0x0000,0x0000,0x0000,0x0000, // u2717
  0x0000,0x0000,0x0e00,0xee00,0x7c00,0x3c00,0x3c00,0x3e00,0x7700,0x7300,0xe000,0xe000,0x0000,0x0000,0x0000,0x0000, // u2718
  0x0000,0x0000,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x0000,0x0000,0x0000,0x0000, // u27e8
  0x0000,0x0000,0x3000,0x3000,0x1800,0x1800,0x0c00,0x0c00,0x1800,0x1800,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000, // u27e9
  0x0000,0x0000,0x3600,0x3600,0x6c00,0x6c00,0xd800,0xd800,0x6c00,0x6c00,0x3600,0x3600,0x0000,0x0000,0x0000,0x0000, // u27ea
  0x0000,0x0000,0xd800,0xd800,0x6c00,0x6c00,0x3600,0x3600,0x6c00,0x6c00,0xd800,0xd800,0x0000,0x0000,0x0000,0x0000, // u27eb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2800
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2801
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2802
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2803
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2804
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2805
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2806
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2807
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2808
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2809
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u280f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2810
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2811
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2812
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2813
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2814
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2815
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2816
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2817
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2818
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u2819
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000, // u281f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2820
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2821
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2822
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2823
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2824
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2825
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2826
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2827
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2828
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2829
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u282a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u282b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u282c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u282d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u282e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u282f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2830
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2831
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2832
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2833
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2834
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2835
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2836
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2837
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2838
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u2839
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u283a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000, // u283b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u283c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u283d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u283e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000, // u283f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2840
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2841
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2842
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2843
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2844
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2845
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2846
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2847
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2848
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2849
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u284f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2850
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2851
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2852
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2853
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2854
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2855
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2856
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2857
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2858
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u2859
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000, // u285f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2860
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2861
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2862
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2863
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2864
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2865
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2866
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2867
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2868
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2869
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u286a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u286b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u286c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u286d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u286e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u286f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2870
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2871
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2872
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2873
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2874
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2875
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2876
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2877
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2878
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u2879
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u287a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000, // u287b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u287c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u287d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u287e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000, // u287f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2880
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2881
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2882
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2883
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2884
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2885
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2886
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2887
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2888
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2889
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u288f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2890
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2891
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2892
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2893
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2894
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2895
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2896
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2897
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2898
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u2899
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289a
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289b
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289c
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289d
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289e
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000, // u289f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a2
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a6
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28a9
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28aa
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28ab
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28ac
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28ad
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28ae
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28af
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b2
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b6
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28b9
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28ba
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28bb
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28bc
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28bd
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28be
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000, // u28bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c2
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c6
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28c9
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ca
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28cb
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28cc
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28cd
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ce
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28cf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d2
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d6
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28d9
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28da
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28db
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28dc
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28dd
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28de
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000, // u28df
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e2
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e6
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28e9
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ea
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28eb
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ec
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ed
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ee
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ef
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f0
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f2
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f4
  0x0000,0x6000,0x6000,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f6
  0x0000,0x6000,0x6000,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f7
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f8
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28f9
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28fa
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28fb
  0x0000,0x0600,0x0600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28fc
  0x0000,0x6600,0x6600,0x0000,0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28fd
  0x0000,0x0600,0x0600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28fe
  0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000,0x0000,0x6600,0x6600,0x0000, // u28ff
  0x0000,0x0000,0x0000,0x0000,0x0000,0xc600,0xc600,0x0000,0x0000,0x0000,0xc600,0xc600,0x0000,0x0000,0x0000,0x0000, // u2e2c
  0xc000,0xc000,0xcc00,0xde00,0xff00,0xcc00,0xcc00,0xcc00,0x9800,0x3000,0x6000,0xc000,0xc000,0xc000,0xc000,0xc000, // ue0a0
  0x0000,0xc000,0xc000,0xc000,0xc000,0xc000,0xfc00,0x0000,0x3300,0x3b00,0x3f00,0x3700,0x3300,0x3300,0x0000,0x0000, // ue0a1
  0x0000,0x3c00,0x6600,0x6600,0x6600,0x6600,0xff00,0xff00,0xe700,0xc300,0xe700,0xff00,0xff00,0xff00,0x0000,0x0000, // ue0a2
  0x8000,0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xff00,0xff00,0xfe00,0xfc00,0xf800,0xf000,0xe000,0xc000,0x8000, // ue0b0
  0x8000,0xc000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0300,0x0300,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0x8000, // ue0b1
  0x0100,0x0300,0x0700,0x0f00,0x1f00,0x3f00,0x7f00,0xff00,0xff00,0x7f00,0x3f00,0x1f00,0x0f00,0x0700,0x0300,0x0100, // ue0b2
  0x0100,0x0300,0x0600,0x0c00,0x1800,0x3000,0x6000,0xc000,0xc000,0x6000,0x3000,0x1800,0x0c00,0x0600,0x0300,0x0100, // ue0b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0e00,0x0600,0x0600,0x0600,0x0600,0x0600,0x0600,0x6600,0x6600,0x3c00,0x0000, // uf6be
  0x0000,0x0000,0xfe00,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xc600,0xfe00,0x0000,0x0000,0x0000,0x0000 // ufffd
  };
  // codepoints array
  constexpr std::array<uint16_t, CHARCOUNT> fixedfont_codepoints = {
  0x0000,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,
  0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,
  0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,
  0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,
  0x005f,0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,
  0x00a0,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
  0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,
  0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
  0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
  0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x00e5,0x00e6,0x00e7,0x00e8,0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x00ee,0x00ef,
  0x00f0,0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x00f6,0x00f7,0x00f8,0x00f9,0x00fa,0x00fb,0x00fc,0x00fd,0x00fe,0x00ff,
  0x0100,0x0101,0x0102,0x0103,0x0104,0x0105,0x0106,0x0107,0x0108,0x0109,0x010a,0x010b,0x010c,0x010d,0x010e,0x010f,
  0x0110,0x0111,0x0112,0x0113,0x0114,0x0115,0x0116,0x0117,0x0118,0x0119,0x011a,0x011b,0x011c,0x011d,0x011e,0x011f,
  0x0120,0x0121,0x0122,0x0123,0x0124,0x0125,0x0126,0x0127,0x0128,0x0129,0x012a,0x012b,0x012c,0x012d,0x012e,0x012f,
  0x0130,0x0131,0x0132,0x0133,0x0134,0x0135,0x0136,0x0137,0x0138,0x0139,0x013a,0x013b,0x013c,0x013d,0x013e,0x013f,
  0x0140,0x0141,0x0142,0x0143,0x0144,0x0145,0x0146,0x0147,0x0148,0x0149,0x014a,0x014b,0x014c,0x014d,0x014e,0x014f,
  0x0150,0x0151,0x0152,0x0153,0x0154,0x0155,0x0156,0x0157,0x0158,0x0159,0x015a,0x015b,0x015c,0x015d,0x015e,0x015f,
  0x0160,0x0161,0x0162,0x0163,0x0164,0x0165,0x0166,0x0167,0x0168,0x0169,0x016a,0x016b,0x016c,0x016d,0x016e,0x016f,
  0x0170,0x0171,0x0172,0x0173,0x0174,0x0175,0x0176,0x0177,0x0178,0x0179,0x017a,0x017b,0x017c,0x017d,0x017e,0x017f,
  0x0186,0x018e,0x018f,0x0190,0x0192,0x019d,0x019e,0x01b5,0x01b6,0x01b7,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d2,
  0x01d3,0x01d4,0x01e2,0x01e3,0x01e4,0x01e5,0x01e6,0x01e7,0x01e8,0x01e9,0x01ea,0x01eb,0x01ec,0x01ed,0x01ee,0x01ef,
  0x01f0,0x01f4,0x01f5,0x01fc,0x01fd,0x01fe,0x01ff,0x0218,0x0219,0x021a,0x021b,0x0232,0x0233,0x0237,0x0254,0x0258,
  0x0259,0x025b,0x0272,0x0292,0x02bb,0x02bc,0x02bd,0x02c6,0x02c7,0x02d8,0x02d9,0x02db,0x02dc,0x02dd,0x0300,0x0301,
  0x0302,0x0303,0x0304,0x0305,0x0306,0x0307,0x0308,0x030a,0x030b,0x030c,0x0329,0x0384,0x0385,0x0386,0x0387,0x0388,
  0x0389,0x038a,0x038c,0x038e,0x038f,0x0390,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
  0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03aa,0x03ab,
  0x03ac,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,
  0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x03ca,0x03cb,
  0x03cc,0x03cd,0x03ce,0x03d1,0x03d5,0x03f0,0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,0x03f6,0x0400,0x0401,0x0402,0x0403,
  0x0404,0x0405,0x0406,0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,0x0411,0x0412,0x0413,
  0x0414,0x0415,0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,
  0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,0x0431,0x0432,0x0433,
  0x0434,0x0435,0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,
  0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x0450,0x0451,0x0452,0x0453,
  0x0454,0x0455,0x0456,0x0457,0x0458,0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0462,0x0463,0x046a,0x046b,
  0x0490,0x0491,0x0492,0x0493,0x0494,0x0495,0x0496,0x0497,0x0498,0x0499,0x049a,0x049b,0x049c,0x049d,0x04a0,0x04a1,
  0x04a2,0x04a3,0x04a4,0x04a5,0x04aa,0x04ab,0x04ae,0x04af,0x04b0,0x04b1,0x04b2,0x04b3,0x04b6,0x04b7,0x04b8,0x04b9,
  0x04ba,0x04bb,0x04c0,0x04c1,0x04c2,0x04cf,0x04d0,0x04d1,0x04d2,0x04d3,0x04d4,0x04d5,0x04d6,0x04d7,0x04d8,0x04d9,
  0x04da,0x04db,0x04dc,0x04dd,0x04de,0x04df,0x04e2,0x04e3,0x04e4,0x04e5,0x04e6,0x04e7,0x04e8,0x04e9,0x04ea,0x04eb,
  0x04ec,0x04ed,0x04ee,0x04ef,0x04f0,0x04f1,0x04f2,0x04f3,0x04f4,0x04f5,0x04f8,0x04f9,0x05d0,0x05d1,0x05d2,0x05d3,
  0x05d4,0x05d5,0x05d6,0x05d7,0x05d8,0x05d9,0x05da,0x05db,0x05dc,0x05dd,0x05de,0x05df,0x05e0,0x05e1,0x05e2,0x05e3,
  0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,0x05ea,0x1e0c,0x1e0d,0x1e34,0x1e35,0x1e36,0x1e37,0x1e40,0x1e41,0x1e42,
  0x1e43,0x1e44,0x1e45,0x1e46,0x1e47,0x1e6c,0x1e6d,0x1eb8,0x1eb9,0x1ebc,0x1ebd,0x1eca,0x1ecb,0x1ecc,0x1ecd,0x1ee4,
  0x1ee5,0x1ef8,0x1ef9,0x2000,0x2001,0x2002,0x2003,0x2004,0x2005,0x2006,0x2007,0x2008,0x2009,0x200a,0x200b,0x200c,
  0x200d,0x200e,0x200f,0x2010,0x2011,0x2012,0x2013,0x2014,0x2015,0x2016,0x2017,0x2018,0x2019,0x201a,0x201b,0x201c,
  0x201d,0x201e,0x201f,0x2020,0x2021,0x2022,0x2026,0x2030,0x2032,0x2033,0x2039,0x203a,0x203c,0x203e,0x2070,0x2071,
  0x2074,0x2075,0x2076,0x2077,0x2078,0x2079,0x207a,0x207b,0x207c,0x207d,0x207e,0x207f,0x2080,0x2081,0x2082,0x2083,
  0x2084,0x2085,0x2086,0x2087,0x2088,0x2089,0x208a,0x208b,0x208c,0x208d,0x208e,0x2090,0x2091,0x2092,0x2093,0x2094,
  0x2095,0x2096,0x2097,0x2098,0x209a,0x20a7,0x20aa,0x20ac,0x20ae,0x2102,0x210e,0x210f,0x2115,0x2116,0x211a,0x211d,
  0x2122,0x2124,0x2126,0x2135,0x2190,0x2191,0x2192,0x2193,0x2194,0x2195,0x21a4,0x21a6,0x21a8,0x21b5,0x21bb,0x21cb,
  0x21cc,0x21d0,0x21d1,0x21d2,0x21d3,0x21d4,0x21d5,0x2200,0x2203,0x2204,0x2205,0x2206,0x2207,0x2208,0x2209,0x220a,
  0x220b,0x220c,0x220d,0x2212,0x2213,0x2214,0x2215,0x2216,0x2219,0x221a,0x221e,0x221f,0x2225,0x2227,0x2228,0x2229,
  0x222a,0x2248,0x2260,0x2261,0x2264,0x2265,0x226a,0x226b,0x2282,0x2283,0x2286,0x2287,0x22a5,0x22c2,0x22c3,0x2300,
  0x2302,0x2308,0x2309,0x230a,0x230b,0x2310,0x2319,0x2320,0x2321,0x239b,0x239c,0x239d,0x239e,0x239f,0x23a0,0x23a1,
  0x23a2,0x23a3,0x23a4,0x23a5,0x23a6,0x23a7,0x23a8,0x23a9,0x23ab,0x23ac,0x23ad,0x23ae,0x23af,0x23ba,0x23bb,0x23bc,
  0x23bd,0x23d0,0x2409,0x240a,0x240b,0x240c,0x240d,0x2424,0x2500,0x2501,0x2502,0x2503,0x2508,0x2509,0x250a,0x250b,
  0x250c,0x250d,0x250e,0x250f,0x2510,0x2511,0x2512,0x2513,0x2514,0x2515,0x2516,0x2517,0x2518,0x2519,0x251a,0x251b,
  0x251c,0x251d,0x251e,0x251f,0x2520,0x2521,0x2522,0x2523,0x2524,0x2525,0x2526,0x2527,0x2528,0x2529,0x252a,0x252b,
  0x252c,0x252d,0x252e,0x252f,0x2530,0x2531,0x2532,0x2533,0x2534,0x2535,0x2536,0x2537,0x2538,0x2539,0x253a,0x253b,
  0x253c,0x253d,0x253e,0x253f,0x2540,0x2541,0x2542,0x2543,0x2544,0x2545,0x2546,0x2547,0x2548,0x2549,0x254a,0x254b,
  0x2550,0x2551,0x2552,0x2553,0x2554,0x2555,0x2556,0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,0x255f,
  0x2560,0x2561,0x2562,0x2563,0x2564,0x2565,0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,0x256d,0x256e,0x256f,
  0x2570,0x2571,0x2572,0x2573,0x2574,0x2575,0x2576,0x2577,0x2578,0x2579,0x257a,0x257b,0x257c,0x257d,0x257e,0x257f,
  0x2580,0x2581,0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x2588,0x2589,0x258a,0x258b,0x258c,0x258d,0x258e,0x258f,
  0x2590,0x2591,0x2592,0x2593,0x2596,0x2597,0x2598,0x2599,0x259a,0x259b,0x259c,0x259d,0x259e,0x259f,0x25a0,0x25ac,
  0x25ae,0x25b2,0x25b6,0x25ba,0x25bc,0x25c0,0x25c4,0x25c6,0x25ca,0x25cb,0x25cf,0x25d8,0x25d9,0x263a,0x263b,0x263c,
  0x2640,0x2642,0x2660,0x2663,0x2665,0x2666,0x266a,0x266b,0x2713,0x2714,0x2717,0x2718,0x27e8,0x27e9,0x27ea,0x27eb,
  0x2800,0x2801,0x2802,0x2803,0x2804,0x2805,0x2806,0x2807,0x2808,0x2809,0x280a,0x280b,0x280c,0x280d,0x280e,0x280f,
  0x2810,0x2811,0x2812,0x2813,0x2814,0x2815,0x2816,0x2817,0x2818,0x2819,0x281a,0x281b,0x281c,0x281d,0x281e,0x281f,
  0x2820,0x2821,0x2822,0x2823,0x2824,0x2825,0x2826,0x2827,0x2828,0x2829,0x282a,0x282b,0x282c,0x282d,0x282e,0x282f,
  0x2830,0x2831,0x2832,0x2833,0x2834,0x2835,0x2836,0x2837,0x2838,0x2839,0x283a,0x283b,0x283c,0x283d,0x283e,0x283f,
  0x2840,0x2841,0x2842,0x2843,0x2844,0x2845,0x2846,0x2847,0x2848,0x2849,0x284a,0x284b,0x284c,0x284d,0x284e,0x284f,
  0x2850,0x2851,0x2852,0x2853,0x2854,0x2855,0x2856,0x2857,0x2858,0x2859,0x285a,0x285b,0x285c,0x285d,0x285e,0x285f,
  0x2860,0x2861,0x2862,0x2863,0x2864,0x2865,0x2866,0x2867,0x2868,0x2869,0x286a,0x286b,0x286c,0x286d,0x286e,0x286f,
  0x2870,0x2871,0x2872,0x2873,0x2874,0x2875,0x2876,0x2877,0x2878,0x2879,0x287a,0x287b,0x287c,0x287d,0x287e,0x287f,
  0x2880,0x2881,0x2882,0x2883,0x2884,0x2885,0x2886,0x2887,0x2888,0x2889,0x288a,0x288b,0x288c,0x288d,0x288e,0x288f,
  0x2890,0x2891,0x2892,0x2893,0x2894,0x2895,0x2896,0x2897,0x2898,0x2899,0x289a,0x289b,0x289c,0x289d,0x289e,0x289f,
  0x28a0,0x28a1,0x28a2,0x28a3,0x28a4,0x28a5,0x28a6,0x28a7,0x28a8,0x28a9,0x28aa,0x28ab,0x28ac,0x28ad,0x28ae,0x28af,
  0x28b0,0x28b1,0x28b2,0x28b3,0x28b4,0x28b5,0x28b6,0x28b7,0x28b8,0x28b9,0x28ba,0x28bb,0x28bc,0x28bd,0x28be,0x28bf,
  0x28c0,0x28c1,0x28c2,0x28c3,0x28c4,0x28c5,0x28c6,0x28c7,0x28c8,0x28c9,0x28ca,0x28cb,0x28cc,0x28cd,0x28ce,0x28cf,
  0x28d0,0x28d1,0x28d2,0x28d3,0x28d4,0x28d5,0x28d6,0x28d7,0x28d8,0x28d9,0x28da,0x28db,0x28dc,0x28dd,0x28de,0x28df,
  0x28e0,0x28e1,0x28e2,0x28e3,0x28e4,0x28e5,0x28e6,0x28e7,0x28e8,0x28e9,0x28ea,0x28eb,0x28ec,0x28ed,0x28ee,0x28ef,
  0x28f0,0x28f1,0x28f2,0x28f3,0x28f4,0x28f5,0x28f6,0x28f7,0x28f8,0x28f9,0x28fa,0x28fb,0x28fc,0x28fd,0x28fe,0x28ff,
  0x2e2c,0xe0a0,0xe0a1,0xe0a2,0xe0b0,0xe0b1,0xe0b2,0xe0b3,0xf6be,0xfffd };
} // namespace
// -- end of autogenerated text ---

namespace fixed_font_18n {
  // -- start of autogenerated text ---
  // definition section for font: ter-u18n.bdf
  constexpr int CHARCOUNT = 1354;
  constexpr int WIDTH = 10;
  constexpr int HEIGHT = 18;
  constexpr FixedFont_info_t fixedfont_info = {
    "Terminus", // font name
    "ter-u18n.bdf", // font name internal
    CHARCOUNT, // num of chars
    WIDTH,
    HEIGHT,
    false // bold
  };
  // font bitmap definitions
  constexpr std::array<uint16_t, CHARCOUNT * HEIGHT> fixedfont_bitmap = {
  0x0000,0x0000,0x0000,0x7700,0x4100,0x4100,0x0000,0x4100,0x4100,0x4100,0x4100,0x0000,0x4100,0x4100,0x7700,0x0000,
  0x0000,0x0000, // u0000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0020
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0021
  0x0000,0x2200,0x2200,0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0022
  0x0000,0x0000,0x0000,0x2200,0x2200,0x2200,0x7f00,0x2200,0x2200,0x2200,0x2200,0x7f00,0x2200,0x2200,0x2200,0x0000,
  0x0000,0x0000, // u0023
  0x0000,0x0000,0x0800,0x0800,0x3e00,0x4900,0x4800,0x4800,0x4800,0x3e00,0x0900,0x0900,0x0900,0x4900,0x3e00,0x0800,
  0x0800,0x0000, // u0024
  0x0000,0x0000,0x0000,0x7100,0x5100,0x7200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1380,0x2280,0x2380,0x0000,
  0x0000,0x0000, // u0025
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x2200,0x2200,0x1400,0x1880,0x2480,0x4300,0x4100,0x4100,0x2280,0x1c80,0x0000,
  0x0000,0x0000, // u0026
  0x0000,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0027
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0000,
  0x0000,0x0000, // u0028
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0800,0x0800,0x1000,0x0000,
  0x0000,0x0000, // u0029
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2200,0x1400,0x0800,0x7f00,0x0800,0x1400,0x2200,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u002a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u002b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x1000,
  0x0000,0x0000, // u002c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u002d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u002e
  0x0000,0x0000,0x0000,0x0100,0x0100,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x0000,
  0x0000,0x0000, // u002f
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0030
  0x0000,0x0000,0x0000,0x0800,0x1800,0x2800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x3e00,0x0000,
  0x0000,0x0000, // u0031
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0032
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0033
  0x0000,0x0000,0x0000,0x0100,0x0300,0x0500,0x0900,0x1100,0x2100,0x4100,0x4100,0x7f00,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u0034
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0035
  0x0000,0x0000,0x0000,0x1e00,0x2000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0036
  0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x0100,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0037
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0038
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0200,0x3c00,0x0000,
  0x0000,0x0000, // u0039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,
  0x0000,0x0000, // u003a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x1000,
  0x0000,0x0000, // u003b
  0x0000,0x0000,0x0000,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100,0x0000,
  0x0000,0x0000, // u003c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u003d
  0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x0000,
  0x0000,0x0000, // u003e
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x4100,0x4100,0x0100,0x0200,0x0400,0x0800,0x0800,0x0000,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u003f
  0x0000,0x0000,0x0000,0x3f00,0x4080,0x4080,0x4780,0x4880,0x4880,0x4880,0x4980,0x4680,0x4000,0x4000,0x3f80,0x0000,
  0x0000,0x0000, // u0040
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0041
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0042
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0043
  0x0000,0x0000,0x0000,0x7c00,0x4200,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4200,0x7c00,0x0000,
  0x0000,0x0000, // u0044
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0045
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0046
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0047
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0048
  0x0000,0x0000,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0049
  0x0000,0x0000,0x0000,0x0380,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x2100,0x2100,0x2100,0x1e00,0x0000,
  0x0000,0x0000, // u004a
  0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u004b
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u004c
  0x0000,0x0000,0x0000,0x4080,0x6180,0x5280,0x5280,0x4c80,0x4c80,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x0000,
  0x0000,0x0000, // u004d
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u004e
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u004f
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0050
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4900,0x3e00,0x0200,
  0x0100,0x0000, // u0051
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u0052
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0053
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0054
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0055
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x2200,0x2200,0x2200,0x1400,0x1400,0x1400,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0056
  0x0000,0x0000,0x0000,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4c80,0x4c80,0x5280,0x5280,0x6180,0x4080,0x0000,
  0x0000,0x0000, // u0057
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x0800,0x0800,0x1400,0x2200,0x2200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0058
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0059
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u005a
  0x0000,0x0000,0x0000,0x1c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1c00,0x0000,
  0x0000,0x0000, // u005b
  0x0000,0x0000,0x0000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0200,0x0200,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u005c
  0x0000,0x0000,0x0000,0x1c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x1c00,0x0000,
  0x0000,0x0000, // u005d
  0x0000,0x0800,0x1400,0x2200,0x4100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u005e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7f00,0x0000, // u005f
  0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0060
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0061
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0062
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0063
  0x0000,0x0000,0x0000,0x0100,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0064
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0065
  0x0000,0x0000,0x0000,0x0700,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0066
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0067
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0068
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0069
  0x0000,0x0000,0x0000,0x0200,0x0200,0x0000,0x0600,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,
  0x2200,0x1c00, // u006a
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u006b
  0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u006c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u006d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u006e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u006f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,
  0x4000,0x4000, // u0070
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x0100, // u0071
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4f00,0x5000,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0072
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0073
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0700,0x0000,
  0x0000,0x0000, // u0074
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0075
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0076
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0000,
  0x0000,0x0000, // u0077
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x1400,0x0800,0x1400,0x2200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0078
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0079
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u007a
  0x0000,0x0000,0x0000,0x0600,0x0800,0x0800,0x0800,0x0800,0x3000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0000,
  0x0000,0x0000, // u007b
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u007c
  0x0000,0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0600,0x0800,0x0800,0x0800,0x0800,0x0800,0x3000,0x0000,
  0x0000,0x0000, // u007d
  0x0000,0x3100,0x4900,0x4900,0x4600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u007e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00a0
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u00a1
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x3e00,0x4900,0x4800,0x4800,0x4800,0x4800,0x4800,0x4900,0x3e00,0x0800,
  0x0800,0x0000, // u00a2
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x2000,0x2000,0x2000,0x7c00,0x2000,0x2000,0x2000,0x2000,0x2100,0x7f00,0x0000,
  0x0000,0x0000, // u00a3
  0x0000,0x0000,0x0000,0x0000,0x4080,0x2100,0x1e00,0x2100,0x2100,0x2100,0x2100,0x1e00,0x2100,0x4080,0x0000,0x0000,
  0x0000,0x0000, // u00a4
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x0800,0x0800,0x3e00,0x0800,0x3e00,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u00a5
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u00a6
  0x0000,0x0000,0x1c00,0x2200,0x2000,0x1800,0x2400,0x2200,0x2200,0x2200,0x1200,0x0c00,0x0200,0x2200,0x1c00,0x0000,
  0x0000,0x0000, // u00a7
  0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00a8
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x9c80,0xa280,0xa080,0xa080,0xa280,0x9c80,0x4100,0x3e00,0x0000,0x0000,
  0x0000,0x0000, // u00a9
  0x0000,0x1e00,0x0100,0x1f00,0x2100,0x2100,0x1f00,0x0000,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0880,0x1100,0x2200,0x4400,0x8800,0x4400,0x2200,0x1100,0x0880,0x0000,
  0x0000,0x0000, // u00ab
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00ac
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00ad
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0xbc80,0xa280,0xa280,0xbc80,0xa480,0xa280,0x4100,0x3e00,0x0000,0x0000,
  0x0000,0x0000, // u00ae
  0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00af
  0x0000,0x1c00,0x2200,0x2200,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0800,0x0000,0x0000,0x7f00,0x0000,
  0x0000,0x0000, // u00b1
  0x0000,0x1c00,0x2200,0x2200,0x0400,0x0800,0x1000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00b2
  0x0000,0x1c00,0x2200,0x0200,0x0c00,0x0200,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00b3
  0x0400,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4300,0x7d00,0x4000,
  0x4000,0x4000, // u00b5
  0x0000,0x0000,0x0000,0x3f00,0x4900,0x4900,0x4900,0x4900,0x4900,0x3900,0x0900,0x0900,0x0900,0x0900,0x0900,0x0000,
  0x0000,0x0000, // u00b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00b7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,
  0x0800,0x1000, // u00b8
  0x0000,0x0800,0x1800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00b9
  0x0000,0x1e00,0x2100,0x2100,0x2100,0x2100,0x1e00,0x0000,0x3f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8800,0x4400,0x2200,0x1100,0x0880,0x1100,0x2200,0x4400,0x8800,0x0000,
  0x0000,0x0000, // u00bb
  0x0000,0x0000,0x2000,0x6000,0x2080,0x2100,0x2200,0x2400,0x0800,0x1100,0x2300,0x4500,0x8900,0x0f00,0x0100,0x0100,
  0x0000,0x0000, // u00bc
  0x0000,0x0000,0x2000,0x6000,0x2080,0x2100,0x2200,0x2400,0x0800,0x1000,0x2600,0x4900,0x8100,0x0200,0x0400,0x0f00,
  0x0000,0x0000, // u00bd
  0x0000,0x0000,0xe000,0x1000,0x6080,0x1100,0x1200,0xe400,0x0800,0x1100,0x2300,0x4500,0x8900,0x0f00,0x0100,0x0100,
  0x0000,0x0000, // u00be
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0800,0x0800,0x1000,0x2000,0x4000,0x4100,0x4100,0x2200,0x1c00,0x0000,
  0x0000,0x0000, // u00bf
  0x1000,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00c0
  0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00c1
  0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00c2
  0x3300,0x4c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00c3
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00c4
  0x1c00,0x2200,0x1c00,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00c5
  0x0000,0x0000,0x0000,0x7f80,0x8800,0x8800,0x8800,0x8800,0xff00,0x8800,0x8800,0x8800,0x8800,0x8800,0x8f80,0x0000,
  0x0000,0x0000, // u00c6
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u00c7
  0x1000,0x0800,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u00c8
  0x0400,0x0800,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u00c9
  0x1c00,0x2200,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u00ca
  0x2200,0x2200,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u00cb
  0x1000,0x0800,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00cc
  0x0400,0x0800,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00cd
  0x1c00,0x2200,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00ce
  0x2200,0x2200,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00cf
  0x0000,0x0000,0x0000,0x7c00,0x4200,0x4100,0x4100,0x4100,0xf900,0x4100,0x4100,0x4100,0x4100,0x4200,0x7c00,0x0000,
  0x0000,0x0000, // u00d0
  0x3300,0x4c00,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00d1
  0x1000,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d2
  0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d3
  0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d4
  0x3300,0x4c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d5
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x2200,0x1400,0x0800,0x1400,0x2200,0x4100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00d7
  0x0000,0x0000,0x0000,0x3e00,0x4180,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0xc100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d8
  0x1000,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00d9
  0x0400,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00da
  0x1c00,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00db
  0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00dc
  0x0400,0x0800,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u00dd
  0x0000,0x0000,0x0000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u00de
  0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4400,0x7e00,0x4100,0x4100,0x4100,0x4100,0x6100,0x5e00,0x0000,
  0x0000,0x0000, // u00df
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00e0
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00e1
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00e2
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00e3
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00e4
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x1c00,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00e5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7700,0x0880,0x0880,0x7880,0x8f80,0x8800,0x8800,0x8880,0x7700,0x0000,
  0x0000,0x0000, // u00e6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u00e7
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00e8
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00e9
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00ea
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00eb
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00ec
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00ed
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00ee
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u00ef
  0x0000,0x0000,0x0000,0x2c00,0x1000,0x6800,0x0400,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00f0
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u00f1
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00f2
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00f3
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00f4
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00f5
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u00f6
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u00f7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e80,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0xbe00,0x0000,
  0x0000,0x0000, // u00f8
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00f9
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00fa
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00fb
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u00fc
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u00fd
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,
  0x4000,0x4000, // u00fe
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u00ff
  0x0000,0x3e00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0100
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0101
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0102
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0103
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0200,0x0180, // u0104
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0200,0x0180, // u0105
  0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0106
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0107
  0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0108
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0109
  0x0800,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u010a
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u010b
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u010c
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u010d
  0x2200,0x1c00,0x0000,0x7c00,0x4200,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4200,0x7c00,0x0000,
  0x0000,0x0000, // u010e
  0x2200,0x1c00,0x0000,0x0100,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u010f
  0x0000,0x0000,0x0000,0x7c00,0x4200,0x4100,0x4100,0x4100,0xf900,0x4100,0x4100,0x4100,0x4100,0x4200,0x7c00,0x0000,
  0x0000,0x0000, // u0110
  0x0000,0x0000,0x0000,0x0100,0x0f80,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0111
  0x0000,0x3e00,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0112
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0113
  0x2200,0x1c00,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0114
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0115
  0x0800,0x0800,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0116
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0117
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0100,
  0x0200,0x0180, // u0118
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0800,
  0x1000,0x0c00, // u0119
  0x2200,0x1c00,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u011a
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u011b
  0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u011c
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u011d
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u011e
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u011f
  0x0800,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0120
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0121
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u0122
  0x0000,0x0000,0x0400,0x0800,0x0800,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0123
  0x1c00,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0124
  0x1c00,0x2200,0x0000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0125
  0x0000,0x0000,0x0000,0x4100,0x4100,0xff80,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0126
  0x0000,0x0000,0x0000,0x4000,0xf800,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0127
  0x3300,0x4c00,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0128
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0129
  0x0000,0x3e00,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u012a
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u012b
  0x2200,0x1c00,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u012c
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u012d
  0x0000,0x0000,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0800,
  0x1000,0x0c00, // u012e
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0800,
  0x1000,0x0c00, // u012f
  0x0800,0x0800,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0130
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0131
  0x0000,0x0000,0x0000,0xe380,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4900,0x4900,0x4900,0xe600,0x0000,
  0x0000,0x0000, // u0132
  0x0000,0x0000,0x0000,0x2080,0x2080,0x0000,0x6180,0x2080,0x2080,0x2080,0x2080,0x2080,0x2080,0x2080,0x7080,0x0480,
  0x0480,0x0300, // u0133
  0x0700,0x0880,0x0000,0x0700,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x4200,0x4200,0x4200,0x3c00,0x0000,
  0x0000,0x0000, // u0134
  0x0000,0x0000,0x0000,0x0700,0x0880,0x0000,0x0600,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,
  0x2200,0x1c00, // u0135
  0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0800,
  0x0800,0x1000, // u0136
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0800,
  0x0800,0x1000, // u0137
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u0138
  0x2000,0x4000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0139
  0x0400,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u013a
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0800,
  0x0800,0x1000, // u013b
  0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0800,
  0x0800,0x1000, // u013c
  0x2200,0x1c00,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u013d
  0x2200,0x1c00,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u013e
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4200,0x4200,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u013f
  0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0840,0x0840,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0140
  0x0000,0x0000,0x0000,0x2000,0x2000,0x2000,0x2800,0x3000,0x2000,0x6000,0xa000,0x2000,0x2000,0x2000,0x3f80,0x0000,
  0x0000,0x0000, // u0141
  0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0a00,0x0c00,0x0800,0x1800,0x2800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0142
  0x0400,0x0800,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0143
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0144
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0800,
  0x0800,0x1000, // u0145
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0800,
  0x0800,0x1000, // u0146
  0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0147
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0148
  0x0000,0x4000,0x4000,0x4000,0x8000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0149
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0100,0x0600, // u014a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0100,0x0600, // u014b
  0x0000,0x3e00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u014c
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u014d
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u014e
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u014f
  0x1100,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0150
  0x0000,0x0000,0x0000,0x1100,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0151
  0x0000,0x0000,0x0000,0x7f80,0x8800,0x8800,0x8800,0x8800,0x8f00,0x8800,0x8800,0x8800,0x8800,0x8800,0x7f80,0x0000,
  0x0000,0x0000, // u0152
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x8880,0x8880,0x8880,0x8f80,0x8800,0x8800,0x8880,0x7f00,0x0000,
  0x0000,0x0000, // u0153
  0x0400,0x0800,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u0154
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x4f00,0x5000,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0155
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x5000,0x4800,0x4400,0x4200,0x4100,0x0800,
  0x0800,0x1000, // u0156
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4f00,0x5000,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x2000,
  0x2000,0x4000, // u0157
  0x2200,0x1c00,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u0158
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x4f00,0x5000,0x6000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0159
  0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u015a
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u015b
  0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u015c
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u015d
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u015e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u015f
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0160
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0161
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0400,
  0x0400,0x0800, // u0162
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0700,0x0200,
  0x0200,0x0400, // u0163
  0x2200,0x1c00,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0164
  0x2200,0x1c00,0x0000,0x0800,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0700,0x0000,
  0x0000,0x0000, // u0165
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0166
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x3e00,0x0800,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0700,0x0000,
  0x0000,0x0000, // u0167
  0x3300,0x4c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0168
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0169
  0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u016a
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u016b
  0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u016c
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u016d
  0x1c00,0x2200,0x1c00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u016e
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x1c00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u016f
  0x1100,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0170
  0x0000,0x0000,0x0000,0x1100,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0171
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,
  0x1000,0x0c00, // u0172
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0200,0x0180, // u0173
  0x1c00,0x2200,0x0000,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x4c80,0x4c80,0x5280,0x5280,0x6180,0x4080,0x0000,
  0x0000,0x0000, // u0174
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x4100,0x4100,0x4100,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0000,
  0x0000,0x0000, // u0175
  0x1c00,0x2200,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0176
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0177
  0x2200,0x2200,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0178
  0x0400,0x0800,0x0000,0x7f00,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0179
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u017a
  0x0800,0x0800,0x0000,0x7f00,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u017b
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u017c
  0x2200,0x1c00,0x0000,0x7f00,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u017d
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u017e
  0x0000,0x0000,0x0000,0x0700,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u017f
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0186
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0100,0x0100,0x1f00,0x0100,0x0100,0x0100,0x0100,0x0100,0x7f00,0x0000,
  0x0000,0x0000, // u018e
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u018f
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3c00,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0190
  0x0000,0x0000,0x0000,0x0600,0x0900,0x0900,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,
  0x4800,0x3000, // u0192
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x4000,
  0x4000,0x8000, // u019d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0100,0x0100, // u019e
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0200,0x0400,0x7f00,0x0800,0x1000,0x2000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u01b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0100,0x0200,0x0400,0x7f00,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u01b6
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01b7
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u01cd
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u01ce
  0x2200,0x1c00,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u01cf
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u01d0
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01d1
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01d2
  0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01d3
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u01d4
  0x0000,0x3f00,0x0000,0x7f80,0x8800,0x8800,0x8800,0x8800,0xff00,0x8800,0x8800,0x8800,0x8800,0x8800,0x8f80,0x0000,
  0x0000,0x0000, // u01e2
  0x0000,0x0000,0x0000,0x0000,0x3f00,0x0000,0x7700,0x0880,0x0880,0x7880,0x8f80,0x8800,0x8800,0x8880,0x7700,0x0000,
  0x0000,0x0000, // u01e3
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4780,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01e4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4780,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u01e5
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01e6
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u01e7
  0x2200,0x1c00,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u01e8
  0x2200,0x1c00,0x0000,0x4000,0x4000,0x4000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u01e9
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,
  0x1000,0x0c00, // u01ea
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,
  0x1000,0x0c00, // u01eb
  0x0000,0x3e00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,
  0x1000,0x0c00, // u01ec
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,
  0x1000,0x0c00, // u01ed
  0x2200,0x1c00,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01ee
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1e00,0x0100,0x0100,0x0100,0x4100,
  0x4100,0x3e00, // u01ef
  0x0000,0x0000,0x0000,0x0880,0x0700,0x0000,0x0600,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,
  0x2200,0x1c00, // u01f0
  0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4f00,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01f4
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u01f5
  0x0400,0x0800,0x0000,0x7f80,0x8800,0x8800,0x8800,0x8800,0xff00,0x8800,0x8800,0x8800,0x8800,0x8800,0x8f80,0x0000,
  0x0000,0x0000, // u01fc
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x7700,0x0880,0x0880,0x7880,0x8f80,0x8800,0x8800,0x8880,0x7700,0x0000,
  0x0000,0x0000, // u01fd
  0x0400,0x0800,0x0000,0x3e00,0x4180,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0xc100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u01fe
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e80,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0xbe00,0x0000,
  0x0000,0x0000, // u01ff
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u0218
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0800,
  0x0800,0x1000, // u0219
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0400,
  0x0400,0x0800, // u021a
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0700,0x0100,
  0x0100,0x0200, // u021b
  0x0000,0x3e00,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0232
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0233
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0600,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,
  0x2200,0x1c00, // u0237
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x0100,0x0100,0x0100,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0254
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0258
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x0100,0x0100,0x7f00,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0259
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3c00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u025b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4000,
  0x4000,0x8000, // u0272
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0100,0x0200,0x0400,0x0800,0x1e00,0x0100,0x0100,0x0100,0x4100,
  0x4100,0x3e00, // u0292
  0x0400,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02bb
  0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02bc
  0x0800,0x0800,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02bd
  0x1c00,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02c6
  0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02c7
  0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02d8
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02d9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,
  0x1000,0x0c00, // u02db
  0x3300,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02dc
  0x1100,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u02dd
  0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0300
  0x0400,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0301
  0x1c00,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0302
  0x3300,0x4c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0303
  0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0304
  0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0305
  0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0306
  0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0307
  0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0308
  0x1c00,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u030a
  0x1100,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u030b
  0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u030c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0800,0x0800, // u0329
  0x0000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0384
  0x0400,0x0800,0x0000,0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0385
  0x0000,0x4000,0x8000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0386
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u0387
  0x0000,0x4000,0x8000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0388
  0x0000,0x4000,0x8000,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0389
  0x0000,0x4000,0x8000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u038a
  0x0000,0x4000,0x8000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u038c
  0x0000,0x4000,0x8000,0x2080,0x2080,0x1100,0x1100,0x0a00,0x0a00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0000,
  0x0000,0x0000, // u038e
  0x0000,0x4000,0x8000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1400,0x1400,0x7700,0x0000,
  0x0000,0x0000, // u038f
  0x0400,0x0800,0x0000,0x2200,0x2200,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0000,
  0x0000,0x0000, // u0390
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0391
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0392
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0393
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x1400,0x1400,0x1400,0x2200,0x2200,0x2200,0x4100,0x4100,0x7f00,0x0000,
  0x0000,0x0000, // u0394
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0395
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0396
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0397
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x5d00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0398
  0x0000,0x0000,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0399
  0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u039a
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x1400,0x1400,0x1400,0x2200,0x2200,0x2200,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u039b
  0x0000,0x0000,0x0000,0x4080,0x6180,0x5280,0x5280,0x4c80,0x4c80,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x0000,
  0x0000,0x0000, // u039c
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u039d
  0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,
  0x0000,0x0000, // u039e
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u039f
  0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u03a0
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u03a1
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x2000,0x1000,0x0800,0x0400,0x0400,0x0800,0x1000,0x2000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u03a3
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u03a4
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u03a5
  0x0000,0x0000,0x0000,0x0800,0x3e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,0x0000,
  0x0000,0x0000, // u03a6
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x0800,0x0800,0x1400,0x2200,0x2200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u03a7
  0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u03a8
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1400,0x1400,0x7700,0x0000,
  0x0000,0x0000, // u03a9
  0x2200,0x2200,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u03aa
  0x2200,0x2200,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u03ab
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3d80,0x4300,0x4200,0x4200,0x4200,0x4200,0x4200,0x4300,0x3d80,0x0000,
  0x0000,0x0000, // u03ac
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3c00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03ad
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0100,0x0100, // u03ae
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0000,
  0x0000,0x0000, // u03af
  0x0400,0x0800,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3d80,0x4300,0x4200,0x4200,0x4200,0x4200,0x4200,0x4300,0x3d80,0x0000,
  0x0000,0x0000, // u03b1
  0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4400,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,
  0x4000,0x4000, // u03b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x2200,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,
  0x0800,0x0800, // u03b3
  0x0000,0x0000,0x0000,0x3e00,0x1000,0x0800,0x1c00,0x2200,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1c00,0x0000,
  0x0000,0x0000, // u03b4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3c00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03b5
  0x0000,0x0000,0x0000,0x7f00,0x0200,0x0400,0x0800,0x1000,0x2000,0x2000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0100,
  0x0100,0x0200, // u03b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0100,0x0100, // u03b7
  0x0000,0x0000,0x0000,0x1e00,0x2100,0x2100,0x2100,0x2100,0x3f00,0x2100,0x2100,0x2100,0x2100,0x2100,0x1e00,0x0000,
  0x0000,0x0000, // u03b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0000,
  0x0000,0x0000, // u03b9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u03ba
  0x0000,0x0000,0x0000,0x1000,0x1000,0x0800,0x0800,0x1400,0x1400,0x2200,0x2200,0x2200,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u03bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4300,0x7d00,0x4000,
  0x4000,0x4000, // u03bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u03bd
  0x0000,0x0000,0x0000,0x3f00,0x4000,0x4000,0x4000,0x4000,0x3e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0100,
  0x0100,0x0200, // u03be
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u03c0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,
  0x4000,0x4000, // u03c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x3e00,0x0100,
  0x0100,0x0200, // u03c2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f80,0x2200,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1c00,0x0000,
  0x0000,0x0000, // u03c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0000,
  0x0000,0x0000, // u03c4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2600,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,
  0x0800,0x0800, // u03c6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x0800,0x0800,0x1400,0x2200,0x2200,
  0x4100,0x4100, // u03c7
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,
  0x0800,0x0800, // u03c8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2200,0x4100,0x4100,0x4900,0x4900,0x4900,0x4900,0x4900,0x3600,0x0000,
  0x0000,0x0000, // u03c9
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0600,0x0000,
  0x0000,0x0000, // u03ca
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03cb
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03cc
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03cd
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x2200,0x4100,0x4100,0x4900,0x4900,0x4900,0x4900,0x4900,0x3600,0x0000,
  0x0000,0x0000, // u03ce
  0x0000,0x0000,0x0000,0x1e00,0x2100,0x2100,0x2100,0x1f80,0x0100,0x0100,0x6100,0x2100,0x2100,0x2100,0x1e00,0x0000,
  0x0000,0x0000, // u03d1
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x3e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,
  0x0800,0x0000, // u03d5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xe080,0x1100,0x0a00,0x0c00,0x0800,0x1800,0x2800,0x4400,0x8380,0x0000,
  0x0000,0x0000, // u03f0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,
  0x4000,0x3e00, // u03f1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03f2
  0x0000,0x0000,0x0000,0x0200,0x0200,0x0000,0x0600,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,
  0x2200,0x1c00, // u03f3
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u03f4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1f00,0x2000,0x4000,0x4000,0x7e00,0x4000,0x4000,0x2000,0x1f00,0x0000,
  0x0000,0x0000, // u03f5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7c00,0x0200,0x0100,0x0100,0x3f00,0x0100,0x0100,0x0200,0x7c00,0x0000,
  0x0000,0x0000, // u03f6
  0x1000,0x0800,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0400
  0x2200,0x2200,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0401
  0x0000,0x0000,0x0000,0xf800,0x2000,0x2000,0x3e00,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2600,0x0000,
  0x0000,0x0000, // u0402
  0x0400,0x0800,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0403
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0404
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0405
  0x0000,0x0000,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0406
  0x2200,0x2200,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0407
  0x0000,0x0000,0x0000,0x0380,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x2100,0x2100,0x2100,0x1e00,0x0000,
  0x0000,0x0000, // u0408
  0x0000,0x0000,0x0000,0x3800,0x4800,0x8800,0x8800,0x8f00,0x8880,0x8880,0x8880,0x8880,0x8880,0x8880,0x8f00,0x0000,
  0x0000,0x0000, // u0409
  0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8800,0x8f00,0xf880,0x8880,0x8880,0x8880,0x8880,0x8880,0x8f00,0x0000,
  0x0000,0x0000, // u040a
  0x0000,0x0000,0x0000,0xf800,0x2000,0x2000,0x3e00,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x0000,
  0x0000,0x0000, // u040b
  0x0400,0x0800,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u040c
  0x1000,0x0800,0x0000,0x4100,0x4100,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u040d
  0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x3e00,0x0000,
  0x0000,0x0000, // u040e
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x0800,
  0x0800,0x0000, // u040f
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0410
  0x0000,0x0000,0x0000,0x7e00,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0411
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0412
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0413
  0x0000,0x0000,0x0000,0x0f00,0x1100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x7f80,0x4080,
  0x4080,0x0000, // u0414
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u0415
  0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u0416
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0417
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0418
  0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0419
  0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u041a
  0x0000,0x0000,0x0000,0x0f00,0x1100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x4100,0x0000,
  0x0000,0x0000, // u041b
  0x0000,0x0000,0x0000,0x4080,0x6180,0x5280,0x5280,0x4c80,0x4c80,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x0000,
  0x0000,0x0000, // u041c
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u041d
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u041e
  0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u041f
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0420
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0421
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0422
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x3e00,0x0000,
  0x0000,0x0000, // u0423
  0x0000,0x0000,0x0800,0x3e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,
  0x0000,0x0000, // u0424
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x0800,0x0800,0x1400,0x2200,0x2200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0425
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f80,0x0080,
  0x0080,0x0000, // u0426
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u0427
  0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3f00,0x0000,
  0x0000,0x0000, // u0428
  0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3f80,0x0080,
  0x0080,0x0000, // u0429
  0x0000,0x0000,0x0000,0xc000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u042a
  0x0000,0x0000,0x0000,0x4080,0x4080,0x4080,0x4080,0x7880,0x4480,0x4480,0x4480,0x4480,0x4480,0x4480,0x7880,0x0000,
  0x0000,0x0000, // u042b
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u042c
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x1f00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u042d
  0x0000,0x0000,0x0000,0x4700,0x4880,0x4880,0x4880,0x4880,0x7880,0x4880,0x4880,0x4880,0x4880,0x4880,0x4700,0x0000,
  0x0000,0x0000, // u042e
  0x0000,0x0000,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0500,0x0900,0x1100,0x2100,0x4100,0x0000,
  0x0000,0x0000, // u042f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0430
  0x0000,0x0000,0x0000,0x3e00,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0431
  0x0000,0x0000,0x0000,0x3c00,0x4200,0x4200,0x4200,0x4400,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0432
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0433
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0434
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0435
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u0436
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0437
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0438
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u0439
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u043a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0f00,0x1100,0x2100,0x2100,0x2100,0x2100,0x2100,0x2100,0x4100,0x0000,
  0x0000,0x0000, // u043b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x6300,0x5500,0x4900,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u043c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u043d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u043e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u043f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x4000,
  0x4000,0x4000, // u0440
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0441
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u0442
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u0443
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x3e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3e00,0x0800,
  0x0800,0x0000, // u0444
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x1400,0x0800,0x1400,0x2200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u0445
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f80,0x0080,
  0x0080,0x0000, // u0446
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u0447
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3f00,0x0000,
  0x0000,0x0000, // u0448
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x3f80,0x0080,
  0x0080,0x0000, // u0449
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x2000,0x2000,0x3e00,0x2100,0x2100,0x2100,0x2100,0x3e00,0x0000,
  0x0000,0x0000, // u044a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4080,0x4080,0x4080,0x7880,0x4480,0x4480,0x4480,0x4480,0x7880,0x0000,
  0x0000,0x0000, // u044b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x2000,0x3e00,0x2100,0x2100,0x2100,0x2100,0x3e00,0x0000,
  0x0000,0x0000, // u044c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x0100,0x0100,0x1f00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u044d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4700,0x4880,0x4880,0x4880,0x7880,0x4880,0x4880,0x4880,0x4700,0x0000,
  0x0000,0x0000, // u044e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3f00,0x4100,0x4100,0x4100,0x3f00,0x0500,0x0900,0x1100,0x2100,0x0000,
  0x0000,0x0000, // u044f
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0450
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0451
  0x0000,0x0000,0x0000,0x4000,0xf800,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0100,0x0600, // u0452
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0453
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0454
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x3e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u0455
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0456
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u0457
  0x0000,0x0000,0x0000,0x0200,0x0200,0x0000,0x0600,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x2200,
  0x2200,0x1c00, // u0458
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x4800,0x8800,0x8f00,0x8880,0x8880,0x8880,0x8880,0x8f00,0x0000,
  0x0000,0x0000, // u0459
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8800,0x8800,0x8800,0x8f00,0xf880,0x8880,0x8880,0x8880,0x8f00,0x0000,
  0x0000,0x0000, // u045a
  0x0000,0x0000,0x0000,0x4000,0xf800,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u045b
  0x0000,0x0000,0x0000,0x0400,0x0800,0x0000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u045c
  0x0000,0x0000,0x0000,0x1000,0x0800,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u045d
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u045e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x0800,
  0x0800,0x0000, // u045f
  0x0000,0x0000,0x0000,0x4000,0xf800,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7e00,0x0000,
  0x0000,0x0000, // u0462
  0x0000,0x0000,0x0000,0x2000,0x2000,0x2000,0xf800,0x2000,0x2000,0x3e00,0x2100,0x2100,0x2100,0x2100,0x3e00,0x0000,
  0x0000,0x0000, // u0463
  0x0000,0x0000,0x0000,0x7f00,0x4100,0x2200,0x2200,0x1400,0x0800,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u046a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4100,0x2200,0x1400,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u046b
  0x0000,0x0100,0x0100,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0490
  0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0491
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0xf800,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0492
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0xf800,0x4000,0x4000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u0493
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0100,
  0x0200,0x0000, // u0494
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x7c00,0x4200,0x4200,0x4200,0x4200,0x0200,
  0x0400,0x0000, // u0495
  0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x4900,0x4980,0x0080,
  0x0080,0x0000, // u0496
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4980,0x0080,
  0x0080,0x0000, // u0497
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0800,
  0x0800,0x0800, // u0498
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x4100,0x3e00,0x0800,
  0x0800,0x0800, // u0499
  0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4180,0x0080,
  0x0080,0x0000, // u049a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4180,0x0080,
  0x0080,0x0000, // u049b
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4200,0x5400,0x5800,0x7000,0x7000,0x5800,0x5400,0x4200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u049c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x5200,0x5400,0x5800,0x7000,0x5800,0x5400,0x5200,0x4100,0x0000,
  0x0000,0x0000, // u049d
  0x0000,0x0000,0x0000,0xc100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u04a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u04a1
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4180,0x0080,
  0x0080,0x0000, // u04a2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4180,0x0080,
  0x0080,0x0000, // u04a3
  0x0000,0x0000,0x0000,0x43c0,0x4200,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x0000,
  0x0000,0x0000, // u04a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x43c0,0x4200,0x4200,0x4200,0x7e00,0x4200,0x4200,0x4200,0x4200,0x0000,
  0x0000,0x0000, // u04a5
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x4100,0x3e00,0x0800,
  0x0800,0x0800, // u04aa
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4000,0x4000,0x4000,0x4000,0x4000,0x4100,0x3e00,0x0800,
  0x0800,0x0800, // u04ab
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u04ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x2200,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,
  0x0800,0x0800, // u04af
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u04b0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x2200,0x2200,0x2200,0x1400,0x1400,0x0800,0x3e00,
  0x0800,0x0800, // u04b1
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x0800,0x0800,0x1400,0x2200,0x2200,0x4100,0x4180,0x0080,
  0x0080,0x0000, // u04b2
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x1400,0x0800,0x1400,0x2200,0x4100,0x4180,0x0080,
  0x0080,0x0000, // u04b3
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x0180,0x0080,
  0x0080,0x0000, // u04b6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0180,0x0080,
  0x0080,0x0000, // u04b7
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4900,0x4900,0x4900,0x3f00,0x0900,0x0900,0x0900,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u04b8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4900,0x4900,0x3f00,0x0900,0x0900,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u04b9
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u04ba
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u04bb
  0x0000,0x0000,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u04c0
  0x2200,0x1c00,0x0000,0x4900,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u04c1
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u04c2
  0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0000,0x0000, // u04cf
  0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u04d0
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u04d1
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u04d2
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u04d3
  0x0000,0x0000,0x0000,0x7f80,0x8800,0x8800,0x8800,0x8800,0xff00,0x8800,0x8800,0x8800,0x8800,0x8800,0x8f80,0x0000,
  0x0000,0x0000, // u04d4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7700,0x0880,0x0880,0x7880,0x8f80,0x8800,0x8800,0x8880,0x7700,0x0000,
  0x0000,0x0000, // u04d5
  0x2200,0x1c00,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u04d6
  0x0000,0x0000,0x0000,0x2200,0x1c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04d7
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04d8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x0100,0x0100,0x7f00,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04d9
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04da
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x0100,0x0100,0x7f00,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04db
  0x2200,0x2200,0x0000,0x4900,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u04dc
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4900,0x4900,0x4900,0x2a00,0x1c00,0x2a00,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u04dd
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04de
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x0100,0x0100,0x1e00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04df
  0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u04e2
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u04e3
  0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4300,0x4500,0x4900,0x5100,0x6100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u04e4
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0000,0x0000, // u04e5
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04e6
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04e7
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04e8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04e9
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04ea
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04eb
  0x2200,0x2200,0x0000,0x3e00,0x4100,0x4100,0x0100,0x0100,0x1f00,0x0100,0x0100,0x0100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04ec
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x3e00,0x4100,0x0100,0x0100,0x1f00,0x0100,0x0100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u04ed
  0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x3e00,0x0000,
  0x0000,0x0000, // u04ee
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u04ef
  0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x3e00,0x0000,
  0x0000,0x0000, // u04f0
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u04f1
  0x1100,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x3e00,0x0000,
  0x0000,0x0000, // u04f2
  0x0000,0x0000,0x0000,0x1100,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u04f3
  0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u04f4
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u04f5
  0x2200,0x2200,0x0000,0x4080,0x4080,0x4080,0x4080,0x7880,0x4480,0x4480,0x4480,0x4480,0x4480,0x4480,0x7880,0x0000,
  0x0000,0x0000, // u04f8
  0x0000,0x0000,0x0000,0x2200,0x2200,0x0000,0x4080,0x4080,0x4080,0x7880,0x4480,0x4480,0x4480,0x4480,0x7880,0x0000,
  0x0000,0x0000, // u04f9
  0x0000,0x0000,0x0000,0x2080,0x2080,0x1080,0x1080,0x0880,0x1900,0x2600,0x4400,0x4200,0x4200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u05d0
  0x0000,0x0000,0x0000,0x7e00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x7f80,0x0000,
  0x0000,0x0000, // u05d1
  0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0600,0x0900,0x1100,0x2080,0x4080,0x0000,
  0x0000,0x0000, // u05d2
  0x0000,0x0000,0x0000,0x7f80,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u05d3
  0x0000,0x0000,0x0000,0x7e00,0x0100,0x0100,0x0100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u05d4
  0x0000,0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u05d5
  0x0000,0x0000,0x0000,0x3f00,0x0200,0x0400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u05d6
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u05d7
  0x0000,0x0000,0x0000,0x4600,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u05d8
  0x0000,0x0000,0x0000,0x3000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u05d9
  0x0000,0x0000,0x0000,0x7e00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x0100, // u05da
  0x0000,0x0000,0x0000,0x7e00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x7e00,0x0000,
  0x0000,0x0000, // u05db
  0x0000,0x4000,0x4000,0x7f00,0x0100,0x0100,0x0100,0x0100,0x0200,0x0400,0x0800,0x1000,0x1000,0x1000,0x1000,0x0000,
  0x0000,0x0000, // u05dc
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x7f00,0x0000,
  0x0000,0x0000, // u05dd
  0x0000,0x0000,0x0000,0xdc00,0x6200,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4700,0x0000,
  0x0000,0x0000, // u05de
  0x0000,0x0000,0x0000,0x7800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,
  0x0400,0x0400, // u05df
  0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x3e00,0x0000,
  0x0000,0x0000, // u05e0
  0x0000,0x0000,0x0000,0xfe00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u05e1
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x2100,0x2100,0x2100,0x1100,0x1200,0x1200,0x0c00,0x1800,0x6000,0x0000,
  0x0000,0x0000, // u05e2
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x3100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x0100, // u05e3
  0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x3100,0x0100,0x0100,0x0100,0x0100,0x0100,0x7e00,0x0000,
  0x0000,0x0000, // u05e4
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2100,0x2100,0x1200,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u05e5
  0x0000,0x0000,0x0000,0x4100,0x4100,0x2100,0x2100,0x1200,0x1400,0x0800,0x0800,0x0400,0x0400,0x0200,0x7e00,0x0000,
  0x0000,0x0000, // u05e6
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0100,0x4100,0x4100,0x4200,0x4400,0x4800,0x4800,0x4800,0x4800,0x4000,
  0x4000,0x4000, // u05e7
  0x0000,0x0000,0x0000,0x7e00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,
  0x0000,0x0000, // u05e8
  0x0000,0x0000,0x0000,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x5100,0x6100,0x4100,0x4100,0x4200,0x7c00,0x0000,
  0x0000,0x0000, // u05e9
  0x0000,0x0000,0x0000,0xfe00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x8100,0x0000,
  0x0000,0x0000, // u05ea
  0x0000,0x0000,0x0000,0x7c00,0x4200,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4200,0x7c00,0x0000,
  0x1000,0x1000, // u1e0c
  0x0000,0x0000,0x0000,0x0100,0x0100,0x0100,0x3f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0800,0x0800, // u1e0d
  0x0000,0x0000,0x0000,0x4100,0x4200,0x4400,0x4800,0x5000,0x6000,0x6000,0x5000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x3e00,0x0000, // u1e34
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4100,0x4200,0x4400,0x4800,0x7000,0x4800,0x4400,0x4200,0x4100,0x0000,
  0x3e00,0x0000, // u1e35
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0800,0x0800, // u1e36
  0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0800,0x0800, // u1e37
  0x0800,0x0800,0x0000,0x4080,0x6180,0x5280,0x5280,0x4c80,0x4c80,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x0000,
  0x0000,0x0000, // u1e40
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x7e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u1e41
  0x0000,0x0000,0x0000,0x4080,0x6180,0x5280,0x5280,0x4c80,0x4c80,0x4080,0x4080,0x4080,0x4080,0x4080,0x4080,0x0000,
  0x0800,0x0800, // u1e42
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x4900,0x0000,
  0x0800,0x0800, // u1e43
  0x0800,0x0800,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u1e44
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u1e45
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x6100,0x5100,0x4900,0x4500,0x4300,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0800,0x0800, // u1e46
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0800,0x0800, // u1e47
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0800,0x0800, // u1e6c
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0700,0x0200,
  0x0200,0x0000, // u1e6d
  0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0800,0x0800, // u1eb8
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0800,0x0800, // u1eb9
  0x3300,0x4c00,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x7c00,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u1ebc
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x3e00,0x4100,0x4100,0x4100,0x7f00,0x4000,0x4000,0x4100,0x3e00,0x0000,
  0x0000,0x0000, // u1ebd
  0x0000,0x0000,0x0000,0x1c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0800,0x0800, // u1eca
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,0x0000,
  0x0800,0x0800, // u1ecb
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0800,0x0800, // u1ecc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0800,0x0800, // u1ecd
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0000,
  0x0800,0x0800, // u1ee4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0000,
  0x0800,0x0800, // u1ee5
  0x3300,0x4c00,0x0000,0x4100,0x4100,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u1ef8
  0x0000,0x0000,0x0000,0x3300,0x4c00,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x3f00,0x0100,
  0x0100,0x3e00, // u1ef9
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2000
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2001
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2002
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2003
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2004
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2005
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2006
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2007
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2008
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2009
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u200a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u200b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u200c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u200d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u200e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u200f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2010
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2011
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2012
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2013
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2014
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2015
  0x0000,0x0000,0x0000,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x0000,
  0x0000,0x0000, // u2016
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,
  0x0000,0x7f00, // u2017
  0x0000,0x0400,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2018
  0x0000,0x0800,0x0800,0x0800,0x1000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2019
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x1000,
  0x0000,0x0000, // u201a
  0x0000,0x1000,0x1000,0x1000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u201b
  0x0000,0x1100,0x2200,0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u201c
  0x0000,0x1100,0x1100,0x1100,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u201d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2200,0x2200,0x2200,0x4400,
  0x0000,0x0000, // u201e
  0x0000,0x4400,0x4400,0x4400,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u201f
  0x0000,0x0000,0x0000,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2020
  0x0000,0x0000,0x0000,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2021
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x1e00,0x1e00,0x0c00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2022
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4900,0x4900,0x0000,
  0x0000,0x0000, // u2026
  0x0000,0x0000,0x0000,0xe400,0xa400,0xe800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,0x5dc0,0x9540,0x9dc0,0x0000,
  0x0000,0x0000, // u2030
  0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2032
  0x0000,0x2200,0x2200,0x2200,0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2033
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0200,0x0400,0x0800,0x1000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0000,
  0x0000,0x0000, // u2039
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0400,0x0800,0x1000,0x2000,0x0000,
  0x0000,0x0000, // u203a
  0x0000,0x0000,0x0000,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x2200,0x0000,0x0000,0x2200,0x2200,0x0000,
  0x0000,0x0000, // u203c
  0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u203e
  0x0000,0x1c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2070
  0x0800,0x0800,0x0000,0x1800,0x0800,0x0800,0x0800,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2071
  0x0000,0x0200,0x0600,0x0a00,0x1200,0x3f00,0x0200,0x0200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2074
  0x0000,0x3c00,0x2000,0x2000,0x3c00,0x0200,0x0200,0x3c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2075
  0x0000,0x1c00,0x2000,0x2000,0x3c00,0x2200,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2076
  0x0000,0x3e00,0x0200,0x0400,0x0400,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2077
  0x0000,0x1c00,0x2200,0x2200,0x1c00,0x2200,0x2200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2078
  0x0000,0x1c00,0x2200,0x2200,0x1e00,0x0200,0x0200,0x1c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2079
  0x0000,0x0000,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u207a
  0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u207b
  0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u207c
  0x0000,0x0400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u207d
  0x0000,0x0800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u207e
  0x0000,0x0000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u207f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x2200,0x2200,0x2200,0x2200,0x1c00,
  0x0000,0x0000, // u2080
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1800,0x0800,0x0800,0x0800,0x0800,0x1c00,
  0x0000,0x0000, // u2081
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x2200,0x0400,0x0800,0x1000,0x3e00,
  0x0000,0x0000, // u2082
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x0200,0x0c00,0x0200,0x2200,0x1c00,
  0x0000,0x0000, // u2083
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0200,0x0600,0x0a00,0x1200,0x3f00,0x0200,0x0200,
  0x0000,0x0000, // u2084
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x2000,0x2000,0x3c00,0x0200,0x0200,0x3c00,
  0x0000,0x0000, // u2085
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2000,0x2000,0x3c00,0x2200,0x2200,0x1c00,
  0x0000,0x0000, // u2086
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0200,0x0400,0x0400,0x0800,0x0800,0x0800,
  0x0000,0x0000, // u2087
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x2200,0x1c00,0x2200,0x2200,0x1c00,
  0x0000,0x0000, // u2088
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x2200,0x1e00,0x0200,0x0200,0x1c00,
  0x0000,0x0000, // u2089
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x3e00,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u208a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u208b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x0000,0x0000,0x3e00,0x0000,0x0000,
  0x0000,0x0000, // u208c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0800,0x0800,0x0800,0x0800,0x0800,0x0400,
  0x0000,0x0000, // u208d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0800,
  0x0000,0x0000, // u208e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x0200,0x1e00,0x2200,0x2200,0x1e00,
  0x0000,0x0000, // u2090
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x3e00,0x2000,0x2000,0x1e00,
  0x0000,0x0000, // u2091
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x2200,0x2200,0x2200,0x1c00,
  0x0000,0x0000, // u2092
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2200,0x1400,0x0800,0x0800,0x1400,0x2200,
  0x0000,0x0000, // u2093
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x0200,0x0200,0x3e00,0x2200,0x1c00,
  0x0000,0x0000, // u2094
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x2200,
  0x0000,0x0000, // u2095
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x2200,0x2400,0x2800,0x3800,0x2400,0x2200,
  0x0000,0x0000, // u2096
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1c00,
  0x0000,0x0000, // u2097
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7e00,0x4900,0x4900,0x4900,0x4900,0x4900,
  0x0000,0x0000, // u2098
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3c00,0x2200,0x2200,0x2200,0x2200,0x3c00,
  0x2000,0x2000, // u209a
  0x0000,0x0000,0x0000,0x7800,0x4400,0x4400,0x4400,0x4400,0x7a00,0x4200,0x4700,0x4200,0x4200,0x4200,0x4100,0x0000,
  0x0000,0x0000, // u20a7
  0x0000,0x0000,0x0000,0x7900,0x4500,0x4500,0x5500,0x5500,0x5500,0x5500,0x5500,0x5500,0x5100,0x5100,0x5e00,0x0000,
  0x0000,0x0000, // u20aa
  0x0000,0x0000,0x0000,0x1e00,0x2100,0x4080,0x4000,0xfc00,0x4000,0x4000,0xfc00,0x4000,0x4080,0x2100,0x1e00,0x0000,
  0x0000,0x0000, // u20ac
  0x0000,0x0000,0x0000,0x7f00,0x0800,0x0800,0x0800,0x0e00,0x3800,0x0e00,0x3800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u20ae
  0x0000,0x0000,0x0000,0x3e00,0x5100,0x5100,0x5000,0x5000,0x5000,0x5000,0x5000,0x5000,0x5100,0x5100,0x3e00,0x0000,
  0x0000,0x0000, // u2102
  0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u210e
  0x0000,0x0000,0x0000,0x4000,0xf800,0x4000,0x7e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u210f
  0x0000,0x0000,0x0000,0x4100,0x4100,0x6100,0x5100,0x6900,0x5500,0x4b00,0x4500,0x4300,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u2115
  0x0000,0x0000,0x0000,0x8400,0x8480,0xc540,0xc540,0xa480,0xa400,0x9400,0x9400,0x8dc0,0x8c00,0x85c0,0x8400,0x0000,
  0x0000,0x0000, // u2116
  0x0000,0x0000,0x0000,0x3e00,0x5100,0x5100,0x5100,0x5100,0x5100,0x5100,0x5100,0x5100,0x5100,0x5500,0x3e00,0x0100,
  0x0080,0x0000, // u211a
  0x0000,0x0000,0x0000,0x7e00,0x5100,0x5100,0x5100,0x5100,0x5100,0x5e00,0x5400,0x5a00,0x5500,0x5280,0x7180,0x0000,
  0x0000,0x0000, // u211d
  0x0000,0x0000,0x0000,0xe880,0x4d80,0x4a80,0x4880,0x4880,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2122
  0x0000,0x0000,0x0000,0x7f00,0x0100,0x0300,0x0500,0x0a00,0x1400,0x2800,0x5000,0x6000,0x4000,0x4000,0x7f00,0x0000,
  0x0000,0x0000, // u2124
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1400,0x1400,0x7700,0x0000,
  0x0000,0x0000, // u2126
  0x0000,0x0000,0x0000,0x4200,0x4200,0x2100,0x2100,0x1080,0x3100,0x4a00,0x8c00,0x8400,0x8400,0x8200,0x4200,0x0000,
  0x0000,0x0000, // u2135
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x2000,0x4000,0xff80,0x4000,0x2000,0x1000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2190
  0x0000,0x0000,0x0000,0x0800,0x1c00,0x2a00,0x4900,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2191
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0200,0x0100,0xff80,0x0100,0x0200,0x0400,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2192
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4900,0x2a00,0x1c00,0x0800,0x0000,
  0x0000,0x0000, // u2193
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1200,0x2100,0x4080,0xffc0,0x4080,0x2100,0x1200,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2194
  0x0000,0x0000,0x0000,0x0800,0x1c00,0x2a00,0x4900,0x0800,0x0800,0x0800,0x0800,0x4900,0x2a00,0x1c00,0x0800,0x0000,
  0x0000,0x0000, // u2195
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1080,0x2080,0x4080,0xff80,0x4080,0x2080,0x1080,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21a4
  0x0000,0x0000,0x0000,0x0000,0x0000,0x8400,0x8200,0x8100,0xff80,0x8100,0x8200,0x8400,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21a6
  0x0000,0x0000,0x0000,0x0800,0x1c00,0x2a00,0x4900,0x0800,0x0800,0x0800,0x4900,0x2a00,0x1c00,0x0800,0x7f00,0x0000,
  0x0000,0x0000, // u21a8
  0x0000,0x0000,0x0000,0x0080,0x0080,0x0080,0x0080,0x0080,0x1080,0x2080,0x4080,0xff80,0x4000,0x2000,0x1000,0x0000,
  0x0000,0x0000, // u21b5
  0x0000,0x0000,0x0000,0x0000,0x7800,0x1800,0x2800,0x4880,0x4080,0x4080,0x4080,0x2100,0x1e00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21bb
  0x0000,0x0000,0x0000,0x0000,0x1000,0x2000,0x4000,0xff80,0x0000,0xff80,0x0100,0x0200,0x0400,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21cb
  0x0000,0x0000,0x0000,0x0000,0x0400,0x0200,0x0100,0xff80,0x0000,0xff80,0x4000,0x2000,0x1000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21cc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1000,0x2000,0x7f80,0xc000,0x7f80,0x2000,0x1000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21d0
  0x0000,0x0000,0x0000,0x0800,0x1c00,0x3600,0x5500,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x0000,
  0x0000,0x0000, // u21d1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0400,0x0200,0xff00,0x0180,0xff00,0x0200,0x0400,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21d2
  0x0000,0x0000,0x0000,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x5500,0x3600,0x1c00,0x0800,0x0000,
  0x0000,0x0000, // u21d3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1200,0x2100,0x7f80,0xc0c0,0x7f80,0x2100,0x1200,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u21d4
  0x0000,0x0000,0x0000,0x0800,0x1c00,0x3600,0x5500,0x1400,0x1400,0x1400,0x1400,0x5500,0x3600,0x1c00,0x0800,0x0000,
  0x0000,0x0000, // u21d5
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x7f00,0x2200,0x2200,0x2200,0x1400,0x1400,0x1400,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2200
  0x0000,0x0000,0x0000,0x0000,0x7f00,0x0100,0x0100,0x0100,0x0100,0x7f00,0x0100,0x0100,0x0100,0x0100,0x7f00,0x0000,
  0x0000,0x0000, // u2203
  0x0000,0x0000,0x0000,0x0200,0x7f00,0x0500,0x0500,0x0900,0x0900,0x7f00,0x1100,0x1100,0x2100,0x2100,0x7f00,0x4000,
  0x0000,0x0000, // u2204
  0x0000,0x0000,0x0000,0x0000,0x0100,0x0200,0x3e00,0x4500,0x4500,0x4900,0x5100,0x5100,0x3e00,0x2000,0x4000,0x0000,
  0x0000,0x0000, // u2205
  0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x1400,0x1400,0x1400,0x2200,0x2200,0x2200,0x4100,0x4100,0x7f00,0x0000,
  0x0000,0x0000, // u2206
  0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x2200,0x2200,0x2200,0x1400,0x1400,0x1400,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2207
  0x0000,0x0000,0x0000,0x0000,0x0f00,0x1000,0x2000,0x4000,0x4000,0x7f00,0x4000,0x4000,0x2000,0x1000,0x0f00,0x0000,
  0x0000,0x0000, // u2208
  0x0000,0x0000,0x0000,0x0100,0x0f00,0x1200,0x2200,0x4400,0x4400,0x7f00,0x4800,0x4800,0x3000,0x1000,0x2f00,0x2000,
  0x0000,0x0000, // u2209
  0x0000,0x0000,0x0000,0x0000,0x1f00,0x2000,0x4000,0x4000,0x7f00,0x4000,0x4000,0x2000,0x1f00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u220a
  0x0000,0x0000,0x0000,0x0000,0x7800,0x0400,0x0200,0x0100,0x0100,0x7f00,0x0100,0x0100,0x0200,0x0400,0x7800,0x0000,
  0x0000,0x0000, // u220b
  0x0000,0x0000,0x0000,0x4000,0x7800,0x2400,0x2200,0x1100,0x1100,0x7f00,0x0900,0x0900,0x0600,0x0400,0x7a00,0x0200,
  0x0000,0x0000, // u220c
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0200,0x0100,0x0100,0x7f00,0x0100,0x0100,0x0200,0x7c00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u220d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2212
  0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0800,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2213
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0000,0x0000,0x0800,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2214
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0080,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2215
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0100,0x0080,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2216
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x0c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2219
  0x0000,0x0380,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x4200,0x4200,0x4200,0x2200,0x1200,0x0a00,0x0600,0x0000,
  0x0000,0x0000, // u221a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3600,0x4900,0x4900,0x4900,0x4900,0x3600,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u221e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u221f
  0x0000,0x0000,0x0000,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x0000,
  0x0000,0x0000, // u2225
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x1400,0x1400,0x2200,0x2200,0x2200,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u2227
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x2200,0x2200,0x2200,0x1400,0x1400,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2228
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1c00,0x2200,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u2229
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1c00,0x0000,
  0x0000,0x0000, // u222a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3100,0x4900,0x4600,0x0000,0x3100,0x4900,0x4600,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2248
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x7f00,0x0400,0x0800,0x1000,0x7f00,0x4000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2260
  0x0000,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,0x7f00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2261
  0x0000,0x0000,0x0000,0x0200,0x0400,0x0800,0x1000,0x2000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0000,0x7f00,0x0000,
  0x0000,0x0000, // u2264
  0x0000,0x0000,0x0000,0x2000,0x1000,0x0800,0x0400,0x0200,0x0200,0x0400,0x0800,0x1000,0x2000,0x0000,0x7f00,0x0000,
  0x0000,0x0000, // u2265
  0x0000,0x0000,0x0000,0x0000,0x0440,0x0880,0x1100,0x2200,0x4400,0x8800,0x4400,0x2200,0x1100,0x0880,0x0440,0x0000,
  0x0000,0x0000, // u226a
  0x0000,0x0000,0x0000,0x0000,0x8800,0x4400,0x2200,0x1100,0x0880,0x0440,0x0880,0x1100,0x2200,0x4400,0x8800,0x0000,
  0x0000,0x0000, // u226b
  0x0000,0x0000,0x0000,0x0000,0x1f00,0x2000,0x4000,0x4000,0x4000,0x4000,0x4000,0x2000,0x1f00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2282
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0200,0x0100,0x0100,0x0100,0x0100,0x0100,0x0200,0x7c00,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2283
  0x0000,0x0000,0x0000,0x0000,0x1f00,0x2000,0x4000,0x4000,0x4000,0x4000,0x4000,0x2000,0x1f00,0x0000,0x7f00,0x0000,
  0x0000,0x0000, // u2286
  0x0000,0x0000,0x0000,0x0000,0x7c00,0x0200,0x0100,0x0100,0x0100,0x0100,0x0100,0x0200,0x7c00,0x0000,0x7f00,0x0000,
  0x0000,0x0000, // u2287
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x7f00,0x0000,
  0x0000,0x0000, // u22a5
  0x0000,0x0000,0x0000,0x1c00,0x2200,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x0000,
  0x0000,0x0000, // u22c2
  0x0000,0x0000,0x0000,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x2200,0x1c00,0x0000,
  0x0000,0x0000, // u22c3
  0x0000,0x0000,0x0000,0x0000,0x0100,0x0200,0x3e00,0x4500,0x4500,0x4900,0x5100,0x5100,0x3e00,0x2000,0x4000,0x0000,
  0x0000,0x0000, // u2300
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1400,0x2200,0x4100,0x8080,0x8080,0x8080,0x8080,0x8080,0xff80,0x0000,
  0x0000,0x0000, // u2302
  0x0000,0x0000,0x0000,0x1c00,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0000,
  0x0000,0x0000, // u2308
  0x0000,0x0000,0x0000,0x1c00,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0000,
  0x0000,0x0000, // u2309
  0x0000,0x0000,0x0000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1c00,0x0000,
  0x0000,0x0000, // u230a
  0x0000,0x0000,0x0000,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x1c00,0x0000,
  0x0000,0x0000, // u230b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f00,0x4000,0x4000,0x4000,0x4000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2310
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x7f00,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2319
  0x0000,0x0000,0x0000,0x0600,0x0900,0x0900,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2320
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x4800,0x4800,0x3000,0x0000,
  0x0000,0x0000, // u2321
  0x0100,0x0200,0x0400,0x0400,0x0800,0x0800,0x0800,0x1000,0x1000,0x1000,0x1000,0x2000,0x2000,0x2000,0x2000,0x2000,
  0x2000,0x2000, // u239b
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
  0x2000,0x2000, // u239c
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0800,0x0800,0x0400,0x0400,
  0x0200,0x0100, // u239d
  0x2000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0400,0x0200,0x0200,0x0200,0x0200,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x0100, // u239e
  0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x0100, // u239f
  0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0200,0x0200,0x0200,0x0200,0x0400,0x0400,0x0400,0x0800,0x0800,
  0x1000,0x2000, // u23a0
  0x3f00,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
  0x2000,0x2000, // u23a1
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
  0x2000,0x2000, // u23a2
  0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,
  0x2000,0x3f00, // u23a3
  0x3f00,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x0100, // u23a4
  0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x0100, // u23a5
  0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
  0x0100,0x3f00, // u23a6
  0x0380,0x0c00,0x0800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
  0x1000,0x1000, // u23a7
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x2000,0xc000,0xc000,0x2000,0x1000,0x1000,0x1000,0x1000,0x1000,
  0x1000,0x1000, // u23a8
  0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,
  0x0c00,0x0380, // u23a9
  0xe000,0x1800,0x0800,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,
  0x0400,0x0400, // u23ab
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0200,0x0180,0x0180,0x0200,0x0400,0x0400,0x0400,0x0400,0x0400,
  0x0400,0x0400, // u23ac
  0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0800,
  0x1800,0xe000, // u23ad
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u23ae
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u23af
  0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u23ba
  0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u23bb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0x0000,
  0x0000,0x0000, // u23bc
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0xffc0, // u23bd
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u23d0
  0x0000,0x0000,0x4400,0x4400,0x7c00,0x4400,0x4400,0x4400,0x0000,0x0f80,0x0200,0x0200,0x0200,0x0200,0x0200,0x0000,
  0x0000,0x0000, // u2409
  0x0000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x7c00,0x0000,0x0f80,0x0800,0x0e00,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u240a
  0x0000,0x0000,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,0x0000,0x0f80,0x0200,0x0200,0x0200,0x0200,0x0200,
  0x0000,0x0000, // u240b
  0x0000,0x0000,0x7c00,0x4000,0x7000,0x4000,0x4000,0x4000,0x0000,0x0f80,0x0800,0x0e00,0x0800,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u240c
  0x0000,0x0000,0x3800,0x4400,0x4000,0x4000,0x4400,0x3800,0x0000,0x0f00,0x0880,0x0880,0x0f00,0x0900,0x0880,0x0000,
  0x0000,0x0000, // u240d
  0x0000,0x0000,0x4400,0x6400,0x5400,0x4c00,0x4400,0x4400,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0f80,0x0000,
  0x0000,0x0000, // u2424
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2500
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2501
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2502
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2503
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd680,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2508
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xd680,0xd680,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2509
  0x0800,0x0800,0x0800,0x0800,0x0000,0x0800,0x0800,0x0800,0x0000,0x0800,0x0800,0x0800,0x0800,0x0000,0x0800,0x0800,
  0x0800,0x0000, // u250a
  0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0c00,0x0c00,0x0c00,0x0000,0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0c00,0x0c00,
  0x0c00,0x0000, // u250b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u250c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u250d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u250e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u250f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2510
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2511
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2512
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2513
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2514
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2515
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2516
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0fc0,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2517
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2518
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2519
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u251a
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xfc00,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u251b
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u251c
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u251d
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u251e
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u251f
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2520
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0fc0,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2521
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2522
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0fc0,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2523
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2524
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf800,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2525
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xfc00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2526
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2527
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2528
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xfc00,0xfc00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2529
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xfc00,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u252a
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xfc00,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u252b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u252c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u252d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u252e
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u252f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2530
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2531
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2532
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2533
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2534
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2535
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2536
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2537
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2538
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2539
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u253a
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u253b
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u253c
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u253d
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u253e
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u253f
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2540
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2541
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2542
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2543
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2544
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2545
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2546
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2547
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0xffc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2548
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0xfc00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u2549
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0x0fc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u254a
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0xffc0,0xffc0,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u254b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2550
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2551
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0800,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2552
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1fc0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2553
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1fc0,0x1000,0x17c0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2554
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0800,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2555
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2556
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xfc00,0x0400,0xf400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2557
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0800,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2558
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2559
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x17c0,0x1000,0x1fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u255a
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf800,0x0800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u255b
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u255c
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xf400,0x0400,0xfc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u255d
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0fc0,0x0800,0x0fc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u255e
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x17c0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u255f
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x17c0,0x1000,0x17c0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2560
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xf800,0x0800,0xf800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2561
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xf400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2562
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xf400,0x0400,0xf400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2563
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2564
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2565
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0000,0xf7c0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u2566
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0000,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2567
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2568
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xf7c0,0x0000,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2569
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0xffc0,0x0800,0xffc0,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u256a
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xffc0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u256b
  0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,0xf7c0,0x0000,0xf7c0,0x1400,0x1400,0x1400,0x1400,0x1400,0x1400,
  0x1400,0x1400, // u256c
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x01c0,0x0200,0x0400,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u256d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0x2000,0x1000,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u256e
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x1000,0x2000,0xc000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u256f
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0400,0x0200,0x01c0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2570
  0x0040,0x0080,0x0080,0x0100,0x0100,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x2000,0x2000,0x4000,
  0x4000,0x8000, // u2571
  0x8000,0x4000,0x4000,0x2000,0x2000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0200,0x0200,0x0100,0x0100,0x0080,
  0x0080,0x0040, // u2572
  0x8040,0x4080,0x4080,0x2100,0x2100,0x1200,0x1200,0x0c00,0x0c00,0x0c00,0x0c00,0x1200,0x1200,0x2100,0x2100,0x4080,
  0x4080,0x8040, // u2573
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2574
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2575
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2576
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u2577
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2578
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2579
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0fc0,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u257a
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u257b
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0x0fc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u257c
  0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,
  0x0c00,0x0c00, // u257d
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u257e
  0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0c00,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,0x0800,
  0x0800,0x0800, // u257f
  0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2580
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xffc0,0xffc0, // u2581
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2582
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2583
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2584
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2585
  0x0000,0x0000,0x0000,0x0000,0x0000,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2586
  0x0000,0x0000,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2587
  0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2588
  0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,0xff80,
  0xff80,0xff80, // u2589
  0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,
  0xfe00,0xfe00, // u258a
  0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,
  0xfc00,0xfc00, // u258b
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
  0xf800,0xf800, // u258c
  0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,
  0xf000,0xf000, // u258d
  0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,
  0xc000,0xc000, // u258e
  0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,
  0x8000,0x8000, // u258f
  0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,
  0x07c0,0x07c0, // u2590
  0xaa80,0x0000,0xaa80,0x0000,0xaa80,0x0000,0xaa80,0x0000,0xaa80,0x0000,0xaa80,0x0000,0xaa80,0x0000,0xaa80,0x0000,
  0xaa80,0x0000, // u2591
  0xaa80,0x5540,0xaa80,0x5540,0xaa80,0x5540,0xaa80,0x5540,0xaa80,0x5540,0xaa80,0x5540,0xaa80,0x5540,0xaa80,0x5540,
  0xaa80,0x5540, // u2592
  0xffc0,0xaa80,0xffc0,0xaa80,0xffc0,0xaa80,0xffc0,0xaa80,0xffc0,0xaa80,0xffc0,0xaa80,0xffc0,0xaa80,0xffc0,0xaa80,
  0xffc0,0xaa80, // u2593
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
  0xf800,0xf800, // u2596
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,
  0x07c0,0x07c0, // u2597
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2598
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u2599
  0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,
  0x07c0,0x07c0, // u259a
  0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
  0xf800,0xf800, // u259b
  0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,
  0x07c0,0x07c0, // u259c
  0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u259d
  0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,0xf800,
  0xf800,0xf800, // u259e
  0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0x07c0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u259f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x3e00,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25a0
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7f80,0x7f80,0x7f80,0x7f80,0x7f80,0x0000,
  0x0000,0x0000, // u25ac
  0x0000,0x0000,0x0000,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x7f00,0x0000,
  0x0000,0x0000, // u25ae
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0800,0x1c00,0x1c00,0x3e00,0x3e00,0x7f00,0x7f00,0xff80,0xff80,0x0000,0x0000,
  0x0000,0x0000, // u25b2
  0x0000,0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xffc0,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25b6
  0x0000,0x0000,0x0000,0x0000,0xc000,0xf000,0xfc00,0xff00,0xffc0,0xff00,0xfc00,0xf000,0xc000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25ba
  0x0000,0x0000,0x0000,0x0000,0xff80,0xff80,0x7f00,0x7f00,0x3e00,0x3e00,0x1c00,0x1c00,0x0800,0x0800,0x0000,0x0000,
  0x0000,0x0000, // u25bc
  0x0000,0x0000,0x0000,0x0000,0x00c0,0x03c0,0x0fc0,0x3fc0,0xffc0,0x3fc0,0x0fc0,0x03c0,0x00c0,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25c0
  0x0000,0x0000,0x0000,0x0000,0x00c0,0x03c0,0x0fc0,0x3fc0,0xffc0,0x3fc0,0x0fc0,0x03c0,0x00c0,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25c4
  0x0000,0x0000,0x0000,0x0000,0x0800,0x1c00,0x3e00,0x7f00,0xff80,0x7f00,0x3e00,0x1c00,0x0800,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25c6
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0800,0x1400,0x2200,0x4100,0x8080,0x4100,0x2200,0x1400,0x0800,0x0000,0x0000,
  0x0000,0x0000, // u25ca
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1e00,0x2100,0x2100,0x2100,0x2100,0x1e00,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25cb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1e00,0x3f00,0x3f00,0x3f00,0x3f00,0x1e00,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u25cf
  0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xf3c0,0xe1c0,0xe1c0,0xf3c0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u25d8
  0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xffc0,0xe1c0,0xdec0,0xdec0,0xdec0,0xdec0,0xe1c0,0xffc0,0xffc0,0xffc0,0xffc0,
  0xffc0,0xffc0, // u25d9
  0x0000,0x0000,0x0000,0x7f00,0x8080,0x8080,0xb680,0xb680,0x8080,0x8080,0xbe80,0x9c80,0x8080,0x8080,0x7f00,0x0000,
  0x0000,0x0000, // u263a
  0x0000,0x0000,0x0000,0x7f00,0xff80,0xff80,0xc980,0xc980,0xff80,0xff80,0xc180,0xe380,0xff80,0xff80,0x7f00,0x0000,
  0x0000,0x0000, // u263b
  0x0000,0x0000,0x0000,0x0800,0x8880,0x4900,0x2a00,0x1c00,0xf780,0x1c00,0x2a00,0x4900,0x8880,0x0800,0x0000,0x0000,
  0x0000,0x0000, // u263c
  0x0000,0x0000,0x0000,0x3e00,0x4100,0x4100,0x4100,0x4100,0x4100,0x3e00,0x0800,0x0800,0x7f00,0x0800,0x0800,0x0000,
  0x0000,0x0000, // u2640
  0x0000,0x0000,0x0000,0x0f00,0x0300,0x0500,0x0900,0x3c00,0x4200,0x4200,0x4200,0x4200,0x4200,0x4200,0x3c00,0x0000,
  0x0000,0x0000, // u2642
  0x0000,0x0000,0x0000,0x0800,0x0800,0x1c00,0x3e00,0x7f00,0xff80,0xff80,0xff80,0x6b00,0x0800,0x0800,0x3e00,0x0000,
  0x0000,0x0000, // u2660
  0x0000,0x0000,0x0000,0x1c00,0x3e00,0x3e00,0x1c00,0x0800,0x6b00,0xff80,0xff80,0xff80,0x6b00,0x0800,0x3e00,0x0000,
  0x0000,0x0000, // u2663
  0x0000,0x0000,0x0000,0x0000,0x6300,0xf780,0xff80,0xff80,0xff80,0xff80,0x7f00,0x3e00,0x1c00,0x0800,0x0000,0x0000,
  0x0000,0x0000, // u2665
  0x0000,0x0000,0x0000,0x0000,0x0800,0x1c00,0x3e00,0x7f00,0xff80,0x7f00,0x3e00,0x1c00,0x0800,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2666
  0x0000,0x0000,0x0000,0x1f80,0x1080,0x1080,0x1f80,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0xe000,0x0000,
  0x0000,0x0000, // u266a
  0x0000,0x0000,0x0000,0x7f00,0x4100,0x4100,0x7f00,0x4100,0x4100,0x4100,0x4100,0x4100,0x4100,0x4200,0x8000,0x0000,
  0x0000,0x0000, // u266b
  0x0000,0x0000,0x0000,0x0080,0x0080,0x0100,0x0100,0x8200,0x8200,0x4400,0x4400,0x2800,0x2800,0x1000,0x1000,0x0000,
  0x0000,0x0000, // u2713
  0x0000,0x0000,0x0000,0x00c0,0x00c0,0x0180,0x0180,0xc300,0xc300,0x6600,0x6600,0x3c00,0x3c00,0x1800,0x1800,0x0000,
  0x0000,0x0000, // u2714
  0x0000,0x0000,0x0000,0x0200,0x4200,0x2400,0x1400,0x0800,0x0c00,0x1200,0x1100,0x2000,0x2000,0x4000,0x4000,0x0000,
  0x0000,0x0000, // u2717
  0x0000,0x0000,0x0000,0x0300,0x6300,0x3600,0x1e00,0x0c00,0x0e00,0x1b00,0x1980,0x3000,0x3000,0x6000,0x6000,0x0000,
  0x0000,0x0000, // u2718
  0x0000,0x0000,0x0200,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x0800,0x0800,0x0400,0x0400,0x0200,0x0200,0x0000,
  0x0000,0x0000, // u27e8
  0x0000,0x0000,0x1000,0x1000,0x0800,0x0800,0x0400,0x0400,0x0200,0x0400,0x0400,0x0800,0x0800,0x1000,0x1000,0x0000,
  0x0000,0x0000, // u27e9
  0x0000,0x0000,0x0880,0x0880,0x1100,0x1100,0x2200,0x2200,0x4400,0x2200,0x2200,0x1100,0x1100,0x0880,0x0880,0x0000,
  0x0000,0x0000, // u27ea
  0x0000,0x0000,0x4400,0x4400,0x2200,0x2200,0x1100,0x1100,0x0880,0x1100,0x1100,0x2200,0x2200,0x4400,0x4400,0x0000,
  0x0000,0x0000, // u27eb
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2800
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2801
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2802
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2803
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2804
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2805
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2806
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2807
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2808
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2809
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u280a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u280b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u280c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u280d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u280e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u280f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2810
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2811
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2812
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2813
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2814
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2815
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2816
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2817
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2818
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2819
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u281a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u281b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u281c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u281d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u281e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u281f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2820
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2821
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2822
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2823
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2824
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2825
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2826
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2827
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2828
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2829
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u282a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u282b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u282c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u282d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u282e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u282f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2830
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2831
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2832
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2833
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2834
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2835
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2836
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2837
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2838
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u2839
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u283a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u283b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u283c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u283d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u283e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000, // u283f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2840
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2841
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2842
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2843
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2844
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2845
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2846
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2847
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2848
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2849
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u284a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u284b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u284c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u284d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u284e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u284f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2850
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2851
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2852
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2853
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2854
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2855
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2856
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2857
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2858
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2859
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u285a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u285b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u285c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u285d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u285e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u285f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2860
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2861
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2862
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2863
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2864
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2865
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2866
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2867
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2868
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2869
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u286a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u286b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u286c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u286d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u286e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u286f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2870
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2871
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2872
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2873
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2874
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2875
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2876
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2877
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2878
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u2879
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u287a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u287b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u287c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u287d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u287e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,
  0x0000,0x0000, // u287f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2880
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2881
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2882
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2883
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2884
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2885
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2886
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2887
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2888
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2889
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u288a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u288b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u288c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u288d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u288e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u288f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2890
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2891
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2892
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2893
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2894
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2895
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2896
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2897
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2898
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u2899
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u289a
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u289b
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u289c
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u289d
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u289e
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u289f
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a0
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a2
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a4
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a6
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a7
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a8
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28a9
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28aa
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28ab
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28ac
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28ad
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28ae
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28af
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b0
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b2
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b4
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b6
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b7
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b8
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28b9
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28ba
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28bb
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28bc
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28bd
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28be
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x2100,0x2100,0x0000,0x0000,0x0100,0x0100,
  0x0000,0x0000, // u28bf
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c0
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c1
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c2
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c3
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c4
  0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c5
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c6
  0x0000,0x2000,0x2000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c7
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c8
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28c9
  0x0000,0x0100,0x0100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28ca
  0x0000,0x2100,0x2100,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28cb
  0x0000,0x0100,0x0100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x2000,0x0000,0x0000,0x2100,0x2100,
  0x0000,0x0000, // u28cc
  0x0000,0x2100,0x2100,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x20