/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         aalogparse_parse
#define yylex           aalogparse_lex
#define yyerror         aalogparse_error
#define yydebug         aalogparse_debug
#define yynerrs         aalogparse_nerrs

/* First part of user prologue.  */
#line 25 "grammar.y"


#include <string.h>
#include <aalogparse.h>
#include "parser.h"
#include "grammar.h"
#include "scanner.h"

#ifndef unused_
#define unused_ __attribute__ ((unused))
#endif
#if (YYDEBUG != 0)
#define debug_unused_ /* nothing */
#else
#define debug_unused_ unused_
#endif

/* Since we're a library, on any errors we don't want to print out any
 * error messages. We should probably add a debug interface that does
 * emit messages when asked for. */
void aalogparse_error(unused_ void *scanner, aa_log_record *ret_record, debug_unused_ char const *s)
{
#if (YYDEBUG != 0)
	printf("ERROR: %s\n", s);
#endif
	ret_record->event = AA_RECORD_INVALID;
}

struct aa_type_table {
	unsigned int audit_type;
	aa_record_event_type event;
};

static struct aa_type_table aa_type_table[] = {
	{AUDIT_APPARMOR_AUDIT,   AA_RECORD_AUDIT},
	{AUDIT_APPARMOR_ALLOWED, AA_RECORD_ALLOWED},
	{AUDIT_APPARMOR_DENIED,  AA_RECORD_DENIED},
	{AUDIT_APPARMOR_HINT,    AA_RECORD_HINT},
	{AUDIT_APPARMOR_STATUS,  AA_RECORD_STATUS},
	{AUDIT_APPARMOR_ERROR,   AA_RECORD_ERROR},
	{0,                      AA_RECORD_INVALID},
};

aa_record_event_type lookup_aa_event(unsigned int type)
{
	int i;

	for (i = 0; aa_type_table[i].audit_type != 0; i++)
		if (type == aa_type_table[i].audit_type)
			break;

	return aa_type_table[i].event;
}



#line 133 "grammar.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_AALOGPARSE_GRAMMAR_H_INCLUDED
# define YY_AALOGPARSE_GRAMMAR_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int aalogparse_debug;
#endif
/* "%code requires" blocks.  */
#line 21 "grammar.y"

	#include <aalogparse.h>

#line 172 "grammar.c"

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    TOK_DIGITS = 258,              /* TOK_DIGITS  */
    TOK_TYPE_UNKNOWN = 259,        /* TOK_TYPE_UNKNOWN  */
    TOK_QUOTED_STRING = 260,       /* TOK_QUOTED_STRING  */
    TOK_ID = 261,                  /* TOK_ID  */
    TOK_MODE = 262,                /* TOK_MODE  */
    TOK_DMESG_STAMP = 263,         /* TOK_DMESG_STAMP  */
    TOK_AUDIT_DIGITS = 264,        /* TOK_AUDIT_DIGITS  */
    TOK_DATE_MONTH = 265,          /* TOK_DATE_MONTH  */
    TOK_DATE = 266,                /* TOK_DATE  */
    TOK_TIME = 267,                /* TOK_TIME  */
    TOK_HEXSTRING = 268,           /* TOK_HEXSTRING  */
    TOK_TYPE_OTHER = 269,          /* TOK_TYPE_OTHER  */
    TOK_MSG_REST = 270,            /* TOK_MSG_REST  */
    TOK_IP_ADDR = 271,             /* TOK_IP_ADDR  */
    TOK_EQUALS = 272,              /* TOK_EQUALS  */
    TOK_COLON = 273,               /* TOK_COLON  */
    TOK_MINUS = 274,               /* TOK_MINUS  */
    TOK_OPEN_PAREN = 275,          /* TOK_OPEN_PAREN  */
    TOK_CLOSE_PAREN = 276,         /* TOK_CLOSE_PAREN  */
    TOK_PERIOD = 277,              /* TOK_PERIOD  */
    TOK_QUESTION_MARK = 278,       /* TOK_QUESTION_MARK  */
    TOK_SINGLE_QUOTE = 279,        /* TOK_SINGLE_QUOTE  */
    TOK_NONE = 280,                /* TOK_NONE  */
    TOK_TYPE_REJECT = 281,         /* TOK_TYPE_REJECT  */
    TOK_TYPE_AUDIT = 282,          /* TOK_TYPE_AUDIT  */
    TOK_TYPE_COMPLAIN = 283,       /* TOK_TYPE_COMPLAIN  */
    TOK_TYPE_HINT = 284,           /* TOK_TYPE_HINT  */
    TOK_TYPE_STATUS = 285,         /* TOK_TYPE_STATUS  */
    TOK_TYPE_ERROR = 286,          /* TOK_TYPE_ERROR  */
    TOK_TYPE_AA_REJECT = 287,      /* TOK_TYPE_AA_REJECT  */
    TOK_TYPE_AA_AUDIT = 288,       /* TOK_TYPE_AA_AUDIT  */
    TOK_TYPE_AA_COMPLAIN = 289,    /* TOK_TYPE_AA_COMPLAIN  */
    TOK_TYPE_AA_HINT = 290,        /* TOK_TYPE_AA_HINT  */
    TOK_TYPE_AA_STATUS = 291,      /* TOK_TYPE_AA_STATUS  */
    TOK_TYPE_AA_ERROR = 292,       /* TOK_TYPE_AA_ERROR  */
    TOK_TYPE_LSM_AVC = 293,        /* TOK_TYPE_LSM_AVC  */
    TOK_TYPE_USER_AVC = 294,       /* TOK_TYPE_USER_AVC  */
    TOK_KEY_APPARMOR = 295,        /* TOK_KEY_APPARMOR  */
    TOK_KEY_TYPE = 296,            /* TOK_KEY_TYPE  */
    TOK_KEY_MSG = 297,             /* TOK_KEY_MSG  */
    TOK_KEY_OPERATION = 298,       /* TOK_KEY_OPERATION  */
    TOK_KEY_NAME = 299,            /* TOK_KEY_NAME  */
    TOK_KEY_NAME2 = 300,           /* TOK_KEY_NAME2  */
    TOK_KEY_MASK = 301,            /* TOK_KEY_MASK  */
    TOK_KEY_DENIED_MASK = 302,     /* TOK_KEY_DENIED_MASK  */
    TOK_KEY_REQUESTED_MASK = 303,  /* TOK_KEY_REQUESTED_MASK  */
    TOK_KEY_ATTRIBUTE = 304,       /* TOK_KEY_ATTRIBUTE  */
    TOK_KEY_TASK = 305,            /* TOK_KEY_TASK  */
    TOK_KEY_PARENT = 306,          /* TOK_KEY_PARENT  */
    TOK_KEY_MAGIC_TOKEN = 307,     /* TOK_KEY_MAGIC_TOKEN  */
    TOK_KEY_INFO = 308,            /* TOK_KEY_INFO  */
    TOK_KEY_PEER_INFO = 309,       /* TOK_KEY_PEER_INFO  */
    TOK_KEY_PID = 310,             /* TOK_KEY_PID  */
    TOK_KEY_PEER_PID = 311,        /* TOK_KEY_PEER_PID  */
    TOK_KEY_PROFILE = 312,         /* TOK_KEY_PROFILE  */
    TOK_KEY_PEER_PROFILE = 313,    /* TOK_KEY_PEER_PROFILE  */
    TOK_KEY_LABEL = 314,           /* TOK_KEY_LABEL  */
    TOK_KEY_PEER_LABEL = 315,      /* TOK_KEY_PEER_LABEL  */
    TOK_KEY_PEER = 316,            /* TOK_KEY_PEER  */
    TOK_AUDIT = 317,               /* TOK_AUDIT  */
    TOK_KEY_FAMILY = 318,          /* TOK_KEY_FAMILY  */
    TOK_KEY_SOCK_TYPE = 319,       /* TOK_KEY_SOCK_TYPE  */
    TOK_KEY_PROTOCOL = 320,        /* TOK_KEY_PROTOCOL  */
    TOK_KEY_NAMESPACE = 321,       /* TOK_KEY_NAMESPACE  */
    TOK_KEY_ERROR = 322,           /* TOK_KEY_ERROR  */
    TOK_KEY_FSUID = 323,           /* TOK_KEY_FSUID  */
    TOK_KEY_FSUID_UPPER = 324,     /* TOK_KEY_FSUID_UPPER  */
    TOK_KEY_OUID = 325,            /* TOK_KEY_OUID  */
    TOK_KEY_OUID_UPPER = 326,      /* TOK_KEY_OUID_UPPER  */
    TOK_KEY_UID = 327,             /* TOK_KEY_UID  */
    TOK_KEY_AUID = 328,            /* TOK_KEY_AUID  */
    TOK_KEY_SAUID = 329,           /* TOK_KEY_SAUID  */
    TOK_KEY_SES = 330,             /* TOK_KEY_SES  */
    TOK_KEY_HOSTNAME = 331,        /* TOK_KEY_HOSTNAME  */
    TOK_KEY_ADDR = 332,            /* TOK_KEY_ADDR  */
    TOK_KEY_TERMINAL = 333,        /* TOK_KEY_TERMINAL  */
    TOK_KEY_EXE = 334,             /* TOK_KEY_EXE  */
    TOK_KEY_COMM = 335,            /* TOK_KEY_COMM  */
    TOK_KEY_CAPABILITY = 336,      /* TOK_KEY_CAPABILITY  */
    TOK_KEY_CAPNAME = 337,         /* TOK_KEY_CAPNAME  */
    TOK_KEY_OFFSET = 338,          /* TOK_KEY_OFFSET  */
    TOK_KEY_TARGET = 339,          /* TOK_KEY_TARGET  */
    TOK_KEY_LADDR = 340,           /* TOK_KEY_LADDR  */
    TOK_KEY_FADDR = 341,           /* TOK_KEY_FADDR  */
    TOK_KEY_LPORT = 342,           /* TOK_KEY_LPORT  */
    TOK_KEY_FPORT = 343,           /* TOK_KEY_FPORT  */
    TOK_KEY_BUS = 344,             /* TOK_KEY_BUS  */
    TOK_KEY_PATH = 345,            /* TOK_KEY_PATH  */
    TOK_KEY_INTERFACE = 346,       /* TOK_KEY_INTERFACE  */
    TOK_KEY_MEMBER = 347,          /* TOK_KEY_MEMBER  */
    TOK_KEY_SIGNAL = 348,          /* TOK_KEY_SIGNAL  */
    TOK_KEY_FSTYPE = 349,          /* TOK_KEY_FSTYPE  */
    TOK_KEY_FLAGS = 350,           /* TOK_KEY_FLAGS  */
    TOK_KEY_SRCNAME = 351,         /* TOK_KEY_SRCNAME  */
    TOK_KEY_UNIX_PEER_ADDR = 352,  /* TOK_KEY_UNIX_PEER_ADDR  */
    TOK_KEY_EXECPATH = 353,        /* TOK_KEY_EXECPATH  */
    TOK_KEY_CLASS = 354,           /* TOK_KEY_CLASS  */
    TOK_SOCKLOGD_KERNEL = 355,     /* TOK_SOCKLOGD_KERNEL  */
    TOK_SYSLOG_KERNEL = 356,       /* TOK_SYSLOG_KERNEL  */
    TOK_SYSLOG_USER = 357          /* TOK_SYSLOG_USER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define TOK_DIGITS 258
#define TOK_TYPE_UNKNOWN 259
#define TOK_QUOTED_STRING 260
#define TOK_ID 261
#define TOK_MODE 262
#define TOK_DMESG_STAMP 263
#define TOK_AUDIT_DIGITS 264
#define TOK_DATE_MONTH 265
#define TOK_DATE 266
#define TOK_TIME 267
#define TOK_HEXSTRING 268
#define TOK_TYPE_OTHER 269
#define TOK_MSG_REST 270
#define TOK_IP_ADDR 271
#define TOK_EQUALS 272
#define TOK_COLON 273
#define TOK_MINUS 274
#define TOK_OPEN_PAREN 275
#define TOK_CLOSE_PAREN 276
#define TOK_PERIOD 277
#define TOK_QUESTION_MARK 278
#define TOK_SINGLE_QUOTE 279
#define TOK_NONE 280
#define TOK_TYPE_REJECT 281
#define TOK_TYPE_AUDIT 282
#define TOK_TYPE_COMPLAIN 283
#define TOK_TYPE_HINT 284
#define TOK_TYPE_STATUS 285
#define TOK_TYPE_ERROR 286
#define TOK_TYPE_AA_REJECT 287
#define TOK_TYPE_AA_AUDIT 288
#define TOK_TYPE_AA_COMPLAIN 289
#define TOK_TYPE_AA_HINT 290
#define TOK_TYPE_AA_STATUS 291
#define TOK_TYPE_AA_ERROR 292
#define TOK_TYPE_LSM_AVC 293
#define TOK_TYPE_USER_AVC 294
#define TOK_KEY_APPARMOR 295
#define TOK_KEY_TYPE 296
#define TOK_KEY_MSG 297
#define TOK_KEY_OPERATION 298
#define TOK_KEY_NAME 299
#define TOK_KEY_NAME2 300
#define TOK_KEY_MASK 301
#define TOK_KEY_DENIED_MASK 302
#define TOK_KEY_REQUESTED_MASK 303
#define TOK_KEY_ATTRIBUTE 304
#define TOK_KEY_TASK 305
#define TOK_KEY_PARENT 306
#define TOK_KEY_MAGIC_TOKEN 307
#define TOK_KEY_INFO 308
#define TOK_KEY_PEER_INFO 309
#define TOK_KEY_PID 310
#define TOK_KEY_PEER_PID 311
#define TOK_KEY_PROFILE 312
#define TOK_KEY_PEER_PROFILE 313
#define TOK_KEY_LABEL 314
#define TOK_KEY_PEER_LABEL 315
#define TOK_KEY_PEER 316
#define TOK_AUDIT 317
#define TOK_KEY_FAMILY 318
#define TOK_KEY_SOCK_TYPE 319
#define TOK_KEY_PROTOCOL 320
#define TOK_KEY_NAMESPACE 321
#define TOK_KEY_ERROR 322
#define TOK_KEY_FSUID 323
#define TOK_KEY_FSUID_UPPER 324
#define TOK_KEY_OUID 325
#define TOK_KEY_OUID_UPPER 326
#define TOK_KEY_UID 327
#define TOK_KEY_AUID 328
#define TOK_KEY_SAUID 329
#define TOK_KEY_SES 330
#define TOK_KEY_HOSTNAME 331
#define TOK_KEY_ADDR 332
#define TOK_KEY_TERMINAL 333
#define TOK_KEY_EXE 334
#define TOK_KEY_COMM 335
#define TOK_KEY_CAPABILITY 336
#define TOK_KEY_CAPNAME 337
#define TOK_KEY_OFFSET 338
#define TOK_KEY_TARGET 339
#define TOK_KEY_LADDR 340
#define TOK_KEY_FADDR 341
#define TOK_KEY_LPORT 342
#define TOK_KEY_FPORT 343
#define TOK_KEY_BUS 344
#define TOK_KEY_PATH 345
#define TOK_KEY_INTERFACE 346
#define TOK_KEY_MEMBER 347
#define TOK_KEY_SIGNAL 348
#define TOK_KEY_FSTYPE 349
#define TOK_KEY_FLAGS 350
#define TOK_KEY_SRCNAME 351
#define TOK_KEY_UNIX_PEER_ADDR 352
#define TOK_KEY_EXECPATH 353
#define TOK_KEY_CLASS 354
#define TOK_SOCKLOGD_KERNEL 355
#define TOK_SYSLOG_KERNEL 356
#define TOK_SYSLOG_USER 357

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 94 "grammar.y"

	char	*t_str;
	long	t_long;

#line 401 "grammar.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif




int aalogparse_parse (void *scanner, aa_log_record *ret_record);


#endif /* !YY_AALOGPARSE_GRAMMAR_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_DIGITS = 3,                 /* TOK_DIGITS  */
  YYSYMBOL_TOK_TYPE_UNKNOWN = 4,           /* TOK_TYPE_UNKNOWN  */
  YYSYMBOL_TOK_QUOTED_STRING = 5,          /* TOK_QUOTED_STRING  */
  YYSYMBOL_TOK_ID = 6,                     /* TOK_ID  */
  YYSYMBOL_TOK_MODE = 7,                   /* TOK_MODE  */
  YYSYMBOL_TOK_DMESG_STAMP = 8,            /* TOK_DMESG_STAMP  */
  YYSYMBOL_TOK_AUDIT_DIGITS = 9,           /* TOK_AUDIT_DIGITS  */
  YYSYMBOL_TOK_DATE_MONTH = 10,            /* TOK_DATE_MONTH  */
  YYSYMBOL_TOK_DATE = 11,                  /* TOK_DATE  */
  YYSYMBOL_TOK_TIME = 12,                  /* TOK_TIME  */
  YYSYMBOL_TOK_HEXSTRING = 13,             /* TOK_HEXSTRING  */
  YYSYMBOL_TOK_TYPE_OTHER = 14,            /* TOK_TYPE_OTHER  */
  YYSYMBOL_TOK_MSG_REST = 15,              /* TOK_MSG_REST  */
  YYSYMBOL_TOK_IP_ADDR = 16,               /* TOK_IP_ADDR  */
  YYSYMBOL_TOK_EQUALS = 17,                /* TOK_EQUALS  */
  YYSYMBOL_TOK_COLON = 18,                 /* TOK_COLON  */
  YYSYMBOL_TOK_MINUS = 19,                 /* TOK_MINUS  */
  YYSYMBOL_TOK_OPEN_PAREN = 20,            /* TOK_OPEN_PAREN  */
  YYSYMBOL_TOK_CLOSE_PAREN = 21,           /* TOK_CLOSE_PAREN  */
  YYSYMBOL_TOK_PERIOD = 22,                /* TOK_PERIOD  */
  YYSYMBOL_TOK_QUESTION_MARK = 23,         /* TOK_QUESTION_MARK  */
  YYSYMBOL_TOK_SINGLE_QUOTE = 24,          /* TOK_SINGLE_QUOTE  */
  YYSYMBOL_TOK_NONE = 25,                  /* TOK_NONE  */
  YYSYMBOL_TOK_TYPE_REJECT = 26,           /* TOK_TYPE_REJECT  */
  YYSYMBOL_TOK_TYPE_AUDIT = 27,            /* TOK_TYPE_AUDIT  */
  YYSYMBOL_TOK_TYPE_COMPLAIN = 28,         /* TOK_TYPE_COMPLAIN  */
  YYSYMBOL_TOK_TYPE_HINT = 29,             /* TOK_TYPE_HINT  */
  YYSYMBOL_TOK_TYPE_STATUS = 30,           /* TOK_TYPE_STATUS  */
  YYSYMBOL_TOK_TYPE_ERROR = 31,            /* TOK_TYPE_ERROR  */
  YYSYMBOL_TOK_TYPE_AA_REJECT = 32,        /* TOK_TYPE_AA_REJECT  */
  YYSYMBOL_TOK_TYPE_AA_AUDIT = 33,         /* TOK_TYPE_AA_AUDIT  */
  YYSYMBOL_TOK_TYPE_AA_COMPLAIN = 34,      /* TOK_TYPE_AA_COMPLAIN  */
  YYSYMBOL_TOK_TYPE_AA_HINT = 35,          /* TOK_TYPE_AA_HINT  */
  YYSYMBOL_TOK_TYPE_AA_STATUS = 36,        /* TOK_TYPE_AA_STATUS  */
  YYSYMBOL_TOK_TYPE_AA_ERROR = 37,         /* TOK_TYPE_AA_ERROR  */
  YYSYMBOL_TOK_TYPE_LSM_AVC = 38,          /* TOK_TYPE_LSM_AVC  */
  YYSYMBOL_TOK_TYPE_USER_AVC = 39,         /* TOK_TYPE_USER_AVC  */
  YYSYMBOL_TOK_KEY_APPARMOR = 40,          /* TOK_KEY_APPARMOR  */
  YYSYMBOL_TOK_KEY_TYPE = 41,              /* TOK_KEY_TYPE  */
  YYSYMBOL_TOK_KEY_MSG = 42,               /* TOK_KEY_MSG  */
  YYSYMBOL_TOK_KEY_OPERATION = 43,         /* TOK_KEY_OPERATION  */
  YYSYMBOL_TOK_KEY_NAME = 44,              /* TOK_KEY_NAME  */
  YYSYMBOL_TOK_KEY_NAME2 = 45,             /* TOK_KEY_NAME2  */
  YYSYMBOL_TOK_KEY_MASK = 46,              /* TOK_KEY_MASK  */
  YYSYMBOL_TOK_KEY_DENIED_MASK = 47,       /* TOK_KEY_DENIED_MASK  */
  YYSYMBOL_TOK_KEY_REQUESTED_MASK = 48,    /* TOK_KEY_REQUESTED_MASK  */
  YYSYMBOL_TOK_KEY_ATTRIBUTE = 49,         /* TOK_KEY_ATTRIBUTE  */
  YYSYMBOL_TOK_KEY_TASK = 50,              /* TOK_KEY_TASK  */
  YYSYMBOL_TOK_KEY_PARENT = 51,            /* TOK_KEY_PARENT  */
  YYSYMBOL_TOK_KEY_MAGIC_TOKEN = 52,       /* TOK_KEY_MAGIC_TOKEN  */
  YYSYMBOL_TOK_KEY_INFO = 53,              /* TOK_KEY_INFO  */
  YYSYMBOL_TOK_KEY_PEER_INFO = 54,         /* TOK_KEY_PEER_INFO  */
  YYSYMBOL_TOK_KEY_PID = 55,               /* TOK_KEY_PID  */
  YYSYMBOL_TOK_KEY_PEER_PID = 56,          /* TOK_KEY_PEER_PID  */
  YYSYMBOL_TOK_KEY_PROFILE = 57,           /* TOK_KEY_PROFILE  */
  YYSYMBOL_TOK_KEY_PEER_PROFILE = 58,      /* TOK_KEY_PEER_PROFILE  */
  YYSYMBOL_TOK_KEY_LABEL = 59,             /* TOK_KEY_LABEL  */
  YYSYMBOL_TOK_KEY_PEER_LABEL = 60,        /* TOK_KEY_PEER_LABEL  */
  YYSYMBOL_TOK_KEY_PEER = 61,              /* TOK_KEY_PEER  */
  YYSYMBOL_TOK_AUDIT = 62,                 /* TOK_AUDIT  */
  YYSYMBOL_TOK_KEY_FAMILY = 63,            /* TOK_KEY_FAMILY  */
  YYSYMBOL_TOK_KEY_SOCK_TYPE = 64,         /* TOK_KEY_SOCK_TYPE  */
  YYSYMBOL_TOK_KEY_PROTOCOL = 65,          /* TOK_KEY_PROTOCOL  */
  YYSYMBOL_TOK_KEY_NAMESPACE = 66,         /* TOK_KEY_NAMESPACE  */
  YYSYMBOL_TOK_KEY_ERROR = 67,             /* TOK_KEY_ERROR  */
  YYSYMBOL_TOK_KEY_FSUID = 68,             /* TOK_KEY_FSUID  */
  YYSYMBOL_TOK_KEY_FSUID_UPPER = 69,       /* TOK_KEY_FSUID_UPPER  */
  YYSYMBOL_TOK_KEY_OUID = 70,              /* TOK_KEY_OUID  */
  YYSYMBOL_TOK_KEY_OUID_UPPER = 71,        /* TOK_KEY_OUID_UPPER  */
  YYSYMBOL_TOK_KEY_UID = 72,               /* TOK_KEY_UID  */
  YYSYMBOL_TOK_KEY_AUID = 73,              /* TOK_KEY_AUID  */
  YYSYMBOL_TOK_KEY_SAUID = 74,             /* TOK_KEY_SAUID  */
  YYSYMBOL_TOK_KEY_SES = 75,               /* TOK_KEY_SES  */
  YYSYMBOL_TOK_KEY_HOSTNAME = 76,          /* TOK_KEY_HOSTNAME  */
  YYSYMBOL_TOK_KEY_ADDR = 77,              /* TOK_KEY_ADDR  */
  YYSYMBOL_TOK_KEY_TERMINAL = 78,          /* TOK_KEY_TERMINAL  */
  YYSYMBOL_TOK_KEY_EXE = 79,               /* TOK_KEY_EXE  */
  YYSYMBOL_TOK_KEY_COMM = 80,              /* TOK_KEY_COMM  */
  YYSYMBOL_TOK_KEY_CAPABILITY = 81,        /* TOK_KEY_CAPABILITY  */
  YYSYMBOL_TOK_KEY_CAPNAME = 82,           /* TOK_KEY_CAPNAME  */
  YYSYMBOL_TOK_KEY_OFFSET = 83,            /* TOK_KEY_OFFSET  */
  YYSYMBOL_TOK_KEY_TARGET = 84,            /* TOK_KEY_TARGET  */
  YYSYMBOL_TOK_KEY_LADDR = 85,             /* TOK_KEY_LADDR  */
  YYSYMBOL_TOK_KEY_FADDR = 86,             /* TOK_KEY_FADDR  */
  YYSYMBOL_TOK_KEY_LPORT = 87,             /* TOK_KEY_LPORT  */
  YYSYMBOL_TOK_KEY_FPORT = 88,             /* TOK_KEY_FPORT  */
  YYSYMBOL_TOK_KEY_BUS = 89,               /* TOK_KEY_BUS  */
  YYSYMBOL_TOK_KEY_PATH = 90,              /* TOK_KEY_PATH  */
  YYSYMBOL_TOK_KEY_INTERFACE = 91,         /* TOK_KEY_INTERFACE  */
  YYSYMBOL_TOK_KEY_MEMBER = 92,            /* TOK_KEY_MEMBER  */
  YYSYMBOL_TOK_KEY_SIGNAL = 93,            /* TOK_KEY_SIGNAL  */
  YYSYMBOL_TOK_KEY_FSTYPE = 94,            /* TOK_KEY_FSTYPE  */
  YYSYMBOL_TOK_KEY_FLAGS = 95,             /* TOK_KEY_FLAGS  */
  YYSYMBOL_TOK_KEY_SRCNAME = 96,           /* TOK_KEY_SRCNAME  */
  YYSYMBOL_TOK_KEY_UNIX_PEER_ADDR = 97,    /* TOK_KEY_UNIX_PEER_ADDR  */
  YYSYMBOL_TOK_KEY_EXECPATH = 98,          /* TOK_KEY_EXECPATH  */
  YYSYMBOL_TOK_KEY_CLASS = 99,             /* TOK_KEY_CLASS  */
  YYSYMBOL_TOK_SOCKLOGD_KERNEL = 100,      /* TOK_SOCKLOGD_KERNEL  */
  YYSYMBOL_TOK_SYSLOG_KERNEL = 101,        /* TOK_SYSLOG_KERNEL  */
  YYSYMBOL_TOK_SYSLOG_USER = 102,          /* TOK_SYSLOG_USER  */
  YYSYMBOL_YYACCEPT = 103,                 /* $accept  */
  YYSYMBOL_log_message = 104,              /* log_message  */
  YYSYMBOL_audit_type = 105,               /* audit_type  */
  YYSYMBOL_type_syntax = 106,              /* type_syntax  */
  YYSYMBOL_new_syntax = 107,               /* new_syntax  */
  YYSYMBOL_other_audit = 108,              /* other_audit  */
  YYSYMBOL_dmesg_type = 109,               /* dmesg_type  */
  YYSYMBOL_syslog_id = 110,                /* syslog_id  */
  YYSYMBOL_syslog_type = 111,              /* syslog_type  */
  YYSYMBOL_audit_dispatch = 112,           /* audit_dispatch  */
  YYSYMBOL_audit_msg = 113,                /* audit_msg  */
  YYSYMBOL_audit_user_msg_partial_tail = 114, /* audit_user_msg_partial_tail  */
  YYSYMBOL_audit_user_msg_tail = 115,      /* audit_user_msg_tail  */
  YYSYMBOL_audit_user_msg = 116,           /* audit_user_msg  */
  YYSYMBOL_audit_id = 117,                 /* audit_id  */
  YYSYMBOL_syslog_date = 118,              /* syslog_date  */
  YYSYMBOL_key_list = 119,                 /* key_list  */
  YYSYMBOL_key = 120,                      /* key  */
  YYSYMBOL_apparmor_event = 121,           /* apparmor_event  */
  YYSYMBOL_key_pid = 122,                  /* key_pid  */
  YYSYMBOL_key_peer_pid = 123,             /* key_peer_pid  */
  YYSYMBOL_ignored_pid = 124,              /* ignored_pid  */
  YYSYMBOL_ignored_uid = 125,              /* ignored_uid  */
  YYSYMBOL_ignored_auid = 126,             /* ignored_auid  */
  YYSYMBOL_ignored_ses = 127,              /* ignored_ses  */
  YYSYMBOL_key_type = 128,                 /* key_type  */
  YYSYMBOL_safe_string = 129,              /* safe_string  */
  YYSYMBOL_protocol = 130                  /* protocol  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  18
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   372

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  103
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  28
/* YYNRULES -- Number of rules.  */
#define YYNRULES  119
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  315

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   357


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   203,   203,   204,   205,   206,   209,   211,   212,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   227,   235,
     239,   240,   244,   246,   248,   250,   253,   255,   257,   259,
     261,   267,   270,   273,   276,   279,   282,   294,   296,   300,
     301,   304,   306,   308,   310,   312,   314,   316,   318,   320,
     322,   324,   326,   328,   330,   332,   333,   334,   336,   338,
     340,   342,   344,   346,   348,   350,   352,   354,   356,   358,
     359,   360,   362,   363,   365,   367,   369,   371,   373,   374,
     375,   377,   383,   389,   390,   396,   400,   405,   409,   411,
     413,   415,   417,   419,   421,   423,   425,   427,   429,   431,
     433,   435,   440,   445,   446,   447,   448,   449,   450,   453,
     456,   459,   460,   461,   462,   464,   467,   468,   471,   472
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_DIGITS",
  "TOK_TYPE_UNKNOWN", "TOK_QUOTED_STRING", "TOK_ID", "TOK_MODE",
  "TOK_DMESG_STAMP", "TOK_AUDIT_DIGITS", "TOK_DATE_MONTH", "TOK_DATE",
  "TOK_TIME", "TOK_HEXSTRING", "TOK_TYPE_OTHER", "TOK_MSG_REST",
  "TOK_IP_ADDR", "TOK_EQUALS", "TOK_COLON", "TOK_MINUS", "TOK_OPEN_PAREN",
  "TOK_CLOSE_PAREN", "TOK_PERIOD", "TOK_QUESTION_MARK", "TOK_SINGLE_QUOTE",
  "TOK_NONE", "TOK_TYPE_REJECT", "TOK_TYPE_AUDIT", "TOK_TYPE_COMPLAIN",
  "TOK_TYPE_HINT", "TOK_TYPE_STATUS", "TOK_TYPE_ERROR",
  "TOK_TYPE_AA_REJECT", "TOK_TYPE_AA_AUDIT", "TOK_TYPE_AA_COMPLAIN",
  "TOK_TYPE_AA_HINT", "TOK_TYPE_AA_STATUS", "TOK_TYPE_AA_ERROR",
  "TOK_TYPE_LSM_AVC", "TOK_TYPE_USER_AVC", "TOK_KEY_APPARMOR",
  "TOK_KEY_TYPE", "TOK_KEY_MSG", "TOK_KEY_OPERATION", "TOK_KEY_NAME",
  "TOK_KEY_NAME2", "TOK_KEY_MASK", "TOK_KEY_DENIED_MASK",
  "TOK_KEY_REQUESTED_MASK", "TOK_KEY_ATTRIBUTE", "TOK_KEY_TASK",
  "TOK_KEY_PARENT", "TOK_KEY_MAGIC_TOKEN", "TOK_KEY_INFO",
  "TOK_KEY_PEER_INFO", "TOK_KEY_PID", "TOK_KEY_PEER_PID",
  "TOK_KEY_PROFILE", "TOK_KEY_PEER_PROFILE", "TOK_KEY_LABEL",
  "TOK_KEY_PEER_LABEL", "TOK_KEY_PEER", "TOK_AUDIT", "TOK_KEY_FAMILY",
  "TOK_KEY_SOCK_TYPE", "TOK_KEY_PROTOCOL", "TOK_KEY_NAMESPACE",
  "TOK_KEY_ERROR", "TOK_KEY_FSUID", "TOK_KEY_FSUID_UPPER", "TOK_KEY_OUID",
  "TOK_KEY_OUID_UPPER", "TOK_KEY_UID", "TOK_KEY_AUID", "TOK_KEY_SAUID",
  "TOK_KEY_SES", "TOK_KEY_HOSTNAME", "TOK_KEY_ADDR", "TOK_KEY_TERMINAL",
  "TOK_KEY_EXE", "TOK_KEY_COMM", "TOK_KEY_CAPABILITY", "TOK_KEY_CAPNAME",
  "TOK_KEY_OFFSET", "TOK_KEY_TARGET", "TOK_KEY_LADDR", "TOK_KEY_FADDR",
  "TOK_KEY_LPORT", "TOK_KEY_FPORT", "TOK_KEY_BUS", "TOK_KEY_PATH",
  "TOK_KEY_INTERFACE", "TOK_KEY_MEMBER", "TOK_KEY_SIGNAL",
  "TOK_KEY_FSTYPE", "TOK_KEY_FLAGS", "TOK_KEY_SRCNAME",
  "TOK_KEY_UNIX_PEER_ADDR", "TOK_KEY_EXECPATH", "TOK_KEY_CLASS",
  "TOK_SOCKLOGD_KERNEL", "TOK_SYSLOG_KERNEL", "TOK_SYSLOG_USER", "$accept",
  "log_message", "audit_type", "type_syntax", "new_syntax", "other_audit",
  "dmesg_type", "syslog_id", "syslog_type", "audit_dispatch", "audit_msg",
  "audit_user_msg_partial_tail", "audit_user_msg_tail", "audit_user_msg",
  "audit_id", "syslog_date", "key_list", "key", "apparmor_event",
  "key_pid", "key_peer_pid", "ignored_pid", "ignored_uid", "ignored_auid",
  "ignored_ses", "key_type", "safe_string", "protocol", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-154)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-112)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      16,   -31,    38,    49,    48,    56,    69,  -154,  -154,  -154,
    -154,   177,    -4,    57,    62,  -154,    15,    14,  -154,  -154,
      65,    66,    67,    68,    71,    72,    73,    76,    77,    80,
      81,    82,    94,    95,    96,    97,    98,   106,   107,   109,
     110,   111,   112,   113,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   144,   145,   146,   177,  -154,  -154,  -154,   -96,
    -154,    -7,    45,  -154,   148,   148,   148,   148,   148,   148,
     148,   148,   148,   149,  -154,  -154,  -154,   147,  -154,    91,
     161,   160,    27,    27,   163,   164,   165,   167,   171,   172,
     173,   176,   190,   175,   193,    27,    27,    27,    27,   194,
     195,   198,    39,    27,    43,   201,   200,   204,   203,   206,
      54,    55,    58,    27,    27,   208,   207,   210,    27,   150,
     199,   211,   213,   244,   245,   274,   294,   303,   305,   307,
     332,    20,   333,   334,  -154,  -154,   177,   -32,   323,    46,
     177,    14,    14,   177,   326,   177,   177,   177,   177,   177,
     177,   177,   325,  -154,   335,  -154,  -154,  -154,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,   340,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,  -154,   177,    52,   177,    14,
     342,    45,   177,   177,   177,   177,  -154,   177,   177,   177,
     177,   177,   177,   177,    14,   324,  -154,    45,   177,   177,
    -154,    14,   177,   177,   292,   339,    14,   177,   177,   336,
     327,  -154,   277,   337,   237,   177,   347,  -154,   341,   279,
     345,   343,   327,  -154,   177,  -154,   353,   344,   282,   338,
     359,  -154,   360,   348,   322,   349,   296,  -154,   363,   352,
    -154,  -154,   346,   177,   177
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     2,     3,     4,
       5,     0,     0,     0,     0,    38,     0,     0,     1,   101,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,    39,    55,    56,     0,
      21,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     8,     0,    32,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,    20,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    17,     0,   103,   104,   105,   106,   107,
     108,    83,    64,    41,   116,   117,    42,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,   109,   110,    57,
      58,    59,    60,    54,    61,    62,   119,   118,    63,    43,
      65,     0,    67,    74,    68,    75,    76,    78,    77,    69,
      70,    71,    79,    80,    81,    82,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,    72,    73,   100,   102,    30,     0,     0,     0,
       0,     0,    22,     0,     0,    15,    18,     9,    10,    11,
      12,    13,    14,    16,     0,     0,    66,     0,    24,     0,
     115,     0,    23,    19,     0,     0,     0,    25,     0,     0,
       0,    35,     0,     0,     0,    29,     0,    34,     0,     0,
       0,     0,    26,    27,    28,   111,     0,     0,     0,     0,
       0,   112,     0,     0,     0,     0,   109,   113,     0,     0,
      36,   114,     0,     0,    33
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,  -154,
      18,    87,    88,  -154,   -70,  -154,  -153,   -75,  -154,  -154,
    -154,  -154,  -154,  -154,  -154,   -78,   -95,  -154
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     6,     7,    94,    95,    96,     8,    81,     9,    10,
      11,   280,   281,   173,    98,    12,    75,    76,   181,    77,
      78,   282,   289,   298,   304,   161,   186,   208
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     154,   157,    79,   246,   162,   155,   156,   252,   187,   158,
     255,   160,   257,   258,   259,   260,   261,   262,   263,    84,
     199,   200,   201,   202,     1,   184,     2,     3,   209,    85,
     247,    13,   184,   185,   158,   218,   221,   223,   224,   225,
     185,    14,   206,   229,   207,   242,   210,    86,    87,    88,
      89,    90,    91,    92,    93,   159,   243,     4,     5,   184,
     184,    15,   211,   184,   251,    16,   174,   185,   185,    18,
     267,   185,   174,    17,    83,    82,    97,   217,   219,   249,
     220,   222,    99,   100,   101,   102,   158,   248,   103,   104,
     105,   253,   254,   106,   107,   268,    80,   108,   109,   110,
     272,   273,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   111,   112,   113,   114,   115,   277,   175,   176,   177,
     178,   179,   180,   116,   117,   285,   118,   119,   120,   121,
     122,   294,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     314,   151,   152,   153,   182,   183,   230,   174,   188,   189,
     190,   154,   191,   271,   192,   193,   194,   154,   197,   269,
     154,   195,   154,   154,   154,   154,   154,   154,   154,   276,
       5,   172,    19,   154,   274,   196,   198,   154,   154,   203,
     204,   278,   154,   205,   212,   213,   284,   214,   215,   216,
     154,   226,   227,   228,   232,   231,   233,    20,    21,   154,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,   154,
      41,    42,    43,    44,    45,    46,    47,    48,    49,   234,
     235,    50,    19,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    20,    21,   236,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,   291,    35,    36,    37,    38,    39,    40,   237,
      41,    42,    43,    44,    45,    46,    47,    48,    49,   238,
     239,    50,   240,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,   241,   244,   245,
     250,   256,   264,   266,   265,   270,   275,   279,   283,   288,
     295,   287,   297,   286,   299,   290,   301,   303,   296,   305,
     300,   302,   306,   307,   309,   308,   311,   310,  -111,   312,
     313,   292,   293
};

static const yytype_int16 yycheck[] =
{
      75,     8,     6,   156,    82,   101,   102,   160,   103,    41,
     163,    81,   165,   166,   167,   168,   169,   170,   171,     4,
     115,   116,   117,   118,     8,     5,    10,    11,   123,    14,
      62,    62,     5,    13,    41,   130,   131,   132,   133,   134,
      13,     3,     3,   138,     5,    25,     3,    32,    33,    34,
      35,    36,    37,    38,    39,    62,   151,    41,    42,     5,
       5,    12,    19,     5,    18,    17,    20,    13,    13,     0,
      18,    13,    20,    17,    12,    18,    62,    23,    23,   157,
      25,    23,    17,    17,    17,    17,    41,   157,    17,    17,
      17,   161,   162,    17,    17,   248,   100,    17,    17,    17,
     253,   254,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    17,    17,    17,    17,    17,   269,    26,    27,    28,
      29,    30,    31,    17,    17,   278,    17,    17,    17,    17,
      17,   284,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
     313,    17,    17,    17,     3,     5,    16,    20,     5,     5,
       5,   246,     5,   251,     3,     3,     3,   252,     3,   249,
     255,     5,   257,   258,   259,   260,   261,   262,   263,   267,
      42,    42,    15,   268,   264,     5,     3,   272,   273,     5,
       5,   271,   277,     5,     3,     5,   276,     3,     5,     3,
     285,     3,     5,     3,     3,    16,     3,    40,    41,   294,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,   314,
      63,    64,    65,    66,    67,    68,    69,    70,    71,     5,
       5,    74,    15,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,    40,    41,     5,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,     5,
      63,    64,    65,    66,    67,    68,    69,    70,    71,     6,
       5,    74,     5,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,     5,     5,     5,
      17,    15,    17,     3,     9,     3,    22,    55,     9,    72,
       3,    24,    73,    17,     9,    18,     3,    75,    17,    21,
      17,    17,     3,     3,    42,    17,     3,    18,    72,    17,
      24,   284,   284
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     8,    10,    11,    41,    42,   104,   105,   109,   111,
     112,   113,   118,    62,     3,    12,    17,    17,     0,    15,
      40,    41,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      74,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   119,   120,   122,   123,     6,
     100,   110,    18,    12,     4,    14,    32,    33,    34,    35,
      36,    37,    38,    39,   106,   107,   108,    62,   117,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,   120,   101,   102,     8,    41,    62,
     117,   128,   128,   113,   113,   113,   113,   113,   113,   113,
     113,   113,    42,   116,    20,    26,    27,    28,    29,    30,
      31,   121,     3,     5,     5,    13,   129,   129,     5,     5,
       5,     5,     3,     3,     3,     5,     5,     3,     3,   129,
     129,   129,   129,     5,     5,     5,     3,     5,   130,   129,
       3,    19,     3,     5,     3,     5,     3,    23,   129,    23,
      25,   129,    23,   129,   129,   129,     3,     5,     3,   129,
      16,    16,     3,     3,     5,     5,     5,     5,     6,     5,
       5,     5,    25,   129,     5,     5,   119,    62,   117,   128,
      17,    18,   119,   117,   117,   119,    15,   119,   119,   119,
     119,   119,   119,   119,    17,     9,     3,    18,   119,   117,
       3,   128,   119,   119,   117,    22,   128,   119,   117,    55,
     114,   115,   124,     9,   117,   119,    17,    24,    72,   125,
      18,    55,   114,   115,   119,     3,    17,    73,   126,     9,
      17,     3,    17,    75,   127,    21,     3,     3,    17,    42,
      18,     3,    17,    24,   119
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   103,   104,   104,   104,   104,   105,   106,   106,   107,
     107,   107,   107,   107,   107,   107,   107,   107,   108,   109,
     110,   110,   111,   111,   111,   111,   111,   111,   111,   111,
     111,   112,   113,   114,   115,   116,   117,   118,   118,   119,
     119,   120,   120,   120,   120,   120,   120,   120,   120,   120,
     120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
     120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
     120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
     120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
     120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
     120,   120,   120,   121,   121,   121,   121,   121,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   129,   130,   130
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     3,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     3,     6,
       2,     1,     4,     5,     5,     6,     8,     8,     8,     7,
       4,     2,     3,     8,     2,     4,     9,     3,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, ret_record, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner, ret_record); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *scanner, aa_log_record *ret_record)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  YY_USE (ret_record);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *scanner, aa_log_record *ret_record)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner, ret_record);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, void *scanner, aa_log_record *ret_record)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner, ret_record);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner, ret_record); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, void *scanner, aa_log_record *ret_record)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  YY_USE (ret_record);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_TOK_QUOTED_STRING: /* TOK_QUOTED_STRING  */
#line 196 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1486 "grammar.c"
        break;

    case YYSYMBOL_TOK_ID: /* TOK_ID  */
#line 196 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1492 "grammar.c"
        break;

    case YYSYMBOL_TOK_MODE: /* TOK_MODE  */
#line 196 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1498 "grammar.c"
        break;

    case YYSYMBOL_TOK_DMESG_STAMP: /* TOK_DMESG_STAMP  */
#line 196 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1504 "grammar.c"
        break;

    case YYSYMBOL_TOK_AUDIT_DIGITS: /* TOK_AUDIT_DIGITS  */
#line 197 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1510 "grammar.c"
        break;

    case YYSYMBOL_TOK_DATE_MONTH: /* TOK_DATE_MONTH  */
#line 197 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1516 "grammar.c"
        break;

    case YYSYMBOL_TOK_DATE: /* TOK_DATE  */
#line 197 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1522 "grammar.c"
        break;

    case YYSYMBOL_TOK_TIME: /* TOK_TIME  */
#line 197 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1528 "grammar.c"
        break;

    case YYSYMBOL_TOK_HEXSTRING: /* TOK_HEXSTRING  */
#line 198 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1534 "grammar.c"
        break;

    case YYSYMBOL_TOK_TYPE_OTHER: /* TOK_TYPE_OTHER  */
#line 198 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1540 "grammar.c"
        break;

    case YYSYMBOL_TOK_MSG_REST: /* TOK_MSG_REST  */
#line 198 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1546 "grammar.c"
        break;

    case YYSYMBOL_TOK_IP_ADDR: /* TOK_IP_ADDR  */
#line 199 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1552 "grammar.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void *scanner, aa_log_record *ret_record)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 7: /* type_syntax: new_syntax  */
#line 211 "grammar.y"
                        { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1828 "grammar.c"
    break;

  case 9: /* new_syntax: TOK_TYPE_AA_REJECT audit_msg key_list  */
#line 216 "grammar.y"
                                                { ret_record->event = AA_RECORD_DENIED; }
#line 1834 "grammar.c"
    break;

  case 10: /* new_syntax: TOK_TYPE_AA_AUDIT audit_msg key_list  */
#line 217 "grammar.y"
                                               { ret_record->event = AA_RECORD_AUDIT; }
#line 1840 "grammar.c"
    break;

  case 11: /* new_syntax: TOK_TYPE_AA_COMPLAIN audit_msg key_list  */
#line 218 "grammar.y"
                                                  { ret_record->event = AA_RECORD_ALLOWED; }
#line 1846 "grammar.c"
    break;

  case 12: /* new_syntax: TOK_TYPE_AA_HINT audit_msg key_list  */
#line 219 "grammar.y"
                                              { ret_record->event = AA_RECORD_HINT; }
#line 1852 "grammar.c"
    break;

  case 13: /* new_syntax: TOK_TYPE_AA_STATUS audit_msg key_list  */
#line 220 "grammar.y"
                                                { ret_record->event = AA_RECORD_STATUS; }
#line 1858 "grammar.c"
    break;

  case 14: /* new_syntax: TOK_TYPE_AA_ERROR audit_msg key_list  */
#line 221 "grammar.y"
                                               { ret_record->event = AA_RECORD_ERROR; }
#line 1864 "grammar.c"
    break;

  case 15: /* new_syntax: TOK_TYPE_UNKNOWN audit_msg key_list  */
#line 222 "grammar.y"
                                              { ret_record->event = lookup_aa_event((yyvsp[-2].t_long)); }
#line 1870 "grammar.c"
    break;

  case 18: /* other_audit: TOK_TYPE_OTHER audit_msg TOK_MSG_REST  */
#line 228 "grammar.y"
        {
		ret_record->operation = (yyvsp[-2].t_str);
		ret_record->event = AA_RECORD_INVALID;
		ret_record->info = (yyvsp[0].t_str);
	}
#line 1880 "grammar.c"
    break;

  case 19: /* dmesg_type: TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id key_list  */
#line 236 "grammar.y"
        { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1886 "grammar.c"
    break;

  case 20: /* syslog_id: TOK_ID TOK_SYSLOG_KERNEL  */
#line 239 "grammar.y"
                                    { free((yyvsp[-1].t_str)); }
#line 1892 "grammar.c"
    break;

  case 21: /* syslog_id: TOK_SOCKLOGD_KERNEL  */
#line 240 "grammar.y"
                              { }
#line 1898 "grammar.c"
    break;

  case 22: /* syslog_type: syslog_date syslog_id audit_id key_list  */
#line 245 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1904 "grammar.c"
    break;

  case 23: /* syslog_type: syslog_date syslog_id key_type audit_id key_list  */
#line 247 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1910 "grammar.c"
    break;

  case 24: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP audit_id key_list  */
#line 249 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-2].t_str)); }
#line 1916 "grammar.c"
    break;

  case 25: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP key_type audit_id key_list  */
#line 251 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-3].t_str)); }
#line 1922 "grammar.c"
    break;

  case 26: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id audit_user_msg_partial_tail  */
#line 254 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1928 "grammar.c"
    break;

  case 27: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id audit_user_msg_tail  */
#line 256 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1934 "grammar.c"
    break;

  case 28: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id key_list  */
#line 258 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1940 "grammar.c"
    break;

  case 29: /* syslog_type: syslog_date syslog_id TOK_AUDIT TOK_COLON key_type audit_id key_list  */
#line 260 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1946 "grammar.c"
    break;

  case 30: /* syslog_type: syslog_date TOK_ID TOK_SYSLOG_USER key_list  */
#line 262 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-2].t_str)); }
#line 1952 "grammar.c"
    break;

  case 31: /* audit_dispatch: audit_msg key_list  */
#line 267 "grammar.y"
                           { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1958 "grammar.c"
    break;

  case 36: /* audit_id: TOK_AUDIT TOK_OPEN_PAREN TOK_AUDIT_DIGITS TOK_PERIOD TOK_AUDIT_DIGITS TOK_COLON TOK_AUDIT_DIGITS TOK_CLOSE_PAREN TOK_COLON  */
#line 283 "grammar.y"
        {
		if (!asprintf(&ret_record->audit_id, "%s.%s:%s", (yyvsp[-6].t_str), (yyvsp[-4].t_str), (yyvsp[-2].t_str))) {
			yyerror(scanner, ret_record, YY_("Out of memory"));
		}
		ret_record->epoch = atol((yyvsp[-6].t_str));
		ret_record->audit_sub_id = atoi((yyvsp[-2].t_str));
		free((yyvsp[-6].t_str));
		free((yyvsp[-4].t_str));
		free((yyvsp[-2].t_str));
	}
#line 1973 "grammar.c"
    break;

  case 37: /* syslog_date: TOK_DATE_MONTH TOK_DIGITS TOK_TIME  */
#line 295 "grammar.y"
                { free((yyvsp[-2].t_str)); free((yyvsp[0].t_str)); /* do nothing */ }
#line 1979 "grammar.c"
    break;

  case 38: /* syslog_date: TOK_DATE TOK_TIME  */
#line 297 "grammar.y"
                { free((yyvsp[-1].t_str)); free((yyvsp[0].t_str)); /* do nothing */ }
#line 1985 "grammar.c"
    break;

  case 41: /* key: TOK_KEY_OPERATION TOK_EQUALS TOK_QUOTED_STRING  */
#line 305 "grammar.y"
        { ret_record->operation = (yyvsp[0].t_str);}
#line 1991 "grammar.c"
    break;

  case 42: /* key: TOK_KEY_NAME TOK_EQUALS safe_string  */
#line 307 "grammar.y"
        { ret_record->name = (yyvsp[0].t_str);}
#line 1997 "grammar.c"
    break;

  case 43: /* key: TOK_KEY_NAMESPACE TOK_EQUALS safe_string  */
#line 309 "grammar.y"
        { ret_record->aa_namespace = (yyvsp[0].t_str);}
#line 2003 "grammar.c"
    break;

  case 44: /* key: TOK_KEY_NAME2 TOK_EQUALS safe_string  */
#line 311 "grammar.y"
        { ret_record->name2 = (yyvsp[0].t_str);}
#line 2009 "grammar.c"
    break;

  case 45: /* key: TOK_KEY_MASK TOK_EQUALS TOK_QUOTED_STRING  */
#line 313 "grammar.y"
        { ret_record->denied_mask = (yyvsp[0].t_str);}
#line 2015 "grammar.c"
    break;

  case 46: /* key: TOK_KEY_DENIED_MASK TOK_EQUALS TOK_QUOTED_STRING  */
#line 315 "grammar.y"
        { ret_record->denied_mask = (yyvsp[0].t_str);}
#line 2021 "grammar.c"
    break;

  case 47: /* key: TOK_KEY_REQUESTED_MASK TOK_EQUALS TOK_QUOTED_STRING  */
#line 317 "grammar.y"
        { ret_record->requested_mask = (yyvsp[0].t_str);}
#line 2027 "grammar.c"
    break;

  case 48: /* key: TOK_KEY_ATTRIBUTE TOK_EQUALS TOK_QUOTED_STRING  */
#line 319 "grammar.y"
        { ret_record->attribute = (yyvsp[0].t_str);}
#line 2033 "grammar.c"
    break;

  case 49: /* key: TOK_KEY_TASK TOK_EQUALS TOK_DIGITS  */
#line 321 "grammar.y"
        { ret_record->task = (yyvsp[0].t_long);}
#line 2039 "grammar.c"
    break;

  case 50: /* key: TOK_KEY_PARENT TOK_EQUALS TOK_DIGITS  */
#line 323 "grammar.y"
        { ret_record->parent = (yyvsp[0].t_long);}
#line 2045 "grammar.c"
    break;

  case 51: /* key: TOK_KEY_MAGIC_TOKEN TOK_EQUALS TOK_DIGITS  */
#line 325 "grammar.y"
        { ret_record->magic_token = (yyvsp[0].t_long);}
#line 2051 "grammar.c"
    break;

  case 52: /* key: TOK_KEY_INFO TOK_EQUALS TOK_QUOTED_STRING  */
#line 327 "grammar.y"
        { ret_record->info = (yyvsp[0].t_str);}
#line 2057 "grammar.c"
    break;

  case 53: /* key: TOK_KEY_PEER_INFO TOK_EQUALS TOK_QUOTED_STRING  */
#line 329 "grammar.y"
        { ret_record->peer_info = (yyvsp[0].t_str);}
#line 2063 "grammar.c"
    break;

  case 54: /* key: TOK_KEY_PEER TOK_EQUALS TOK_QUOTED_STRING  */
#line 331 "grammar.y"
        { ret_record->peer = (yyvsp[0].t_str);}
#line 2069 "grammar.c"
    break;

  case 57: /* key: TOK_KEY_PROFILE TOK_EQUALS safe_string  */
#line 335 "grammar.y"
        { ret_record->profile = (yyvsp[0].t_str);}
#line 2075 "grammar.c"
    break;

  case 58: /* key: TOK_KEY_PEER_PROFILE TOK_EQUALS safe_string  */
#line 337 "grammar.y"
        { ret_record->peer_profile = (yyvsp[0].t_str);}
#line 2081 "grammar.c"
    break;

  case 59: /* key: TOK_KEY_LABEL TOK_EQUALS safe_string  */
#line 339 "grammar.y"
        { ret_record->profile = (yyvsp[0].t_str);}
#line 2087 "grammar.c"
    break;

  case 60: /* key: TOK_KEY_PEER_LABEL TOK_EQUALS safe_string  */
#line 341 "grammar.y"
        { ret_record->peer_profile = (yyvsp[0].t_str);}
#line 2093 "grammar.c"
    break;

  case 61: /* key: TOK_KEY_FAMILY TOK_EQUALS TOK_QUOTED_STRING  */
#line 343 "grammar.y"
        { ret_record->net_family = (yyvsp[0].t_str);}
#line 2099 "grammar.c"
    break;

  case 62: /* key: TOK_KEY_SOCK_TYPE TOK_EQUALS TOK_QUOTED_STRING  */
#line 345 "grammar.y"
        { ret_record->net_sock_type = (yyvsp[0].t_str);}
#line 2105 "grammar.c"
    break;

  case 63: /* key: TOK_KEY_PROTOCOL TOK_EQUALS protocol  */
#line 347 "grammar.y"
        { ret_record->net_protocol = (yyvsp[0].t_str);}
#line 2111 "grammar.c"
    break;

  case 64: /* key: TOK_KEY_TYPE TOK_EQUALS TOK_DIGITS  */
#line 349 "grammar.y"
        { ret_record->event = lookup_aa_event((yyvsp[0].t_long));}
#line 2117 "grammar.c"
    break;

  case 65: /* key: TOK_KEY_ERROR TOK_EQUALS TOK_DIGITS  */
#line 351 "grammar.y"
        { ret_record->error_code = (yyvsp[0].t_long);}
#line 2123 "grammar.c"
    break;

  case 66: /* key: TOK_KEY_ERROR TOK_EQUALS TOK_MINUS TOK_DIGITS  */
#line 353 "grammar.y"
        { ret_record->error_code = (yyvsp[0].t_long);}
#line 2129 "grammar.c"
    break;

  case 67: /* key: TOK_KEY_FSUID TOK_EQUALS TOK_DIGITS  */
#line 355 "grammar.y"
        { ret_record->fsuid = (yyvsp[0].t_long);}
#line 2135 "grammar.c"
    break;

  case 68: /* key: TOK_KEY_OUID TOK_EQUALS TOK_DIGITS  */
#line 357 "grammar.y"
        { ret_record->ouid = (yyvsp[0].t_long);}
#line 2141 "grammar.c"
    break;

  case 71: /* key: TOK_KEY_ADDR TOK_EQUALS safe_string  */
#line 361 "grammar.y"
        { ret_record->net_addr = (yyvsp[0].t_str); }
#line 2147 "grammar.c"
    break;

  case 73: /* key: TOK_KEY_UNIX_PEER_ADDR TOK_EQUALS safe_string  */
#line 364 "grammar.y"
        { ret_record->peer_addr = (yyvsp[0].t_str); }
#line 2153 "grammar.c"
    break;

  case 74: /* key: TOK_KEY_FSUID_UPPER TOK_EQUALS TOK_QUOTED_STRING  */
#line 366 "grammar.y"
        { free((yyvsp[0].t_str));}
#line 2159 "grammar.c"
    break;

  case 75: /* key: TOK_KEY_OUID_UPPER TOK_EQUALS TOK_QUOTED_STRING  */
#line 368 "grammar.y"
        { free((yyvsp[0].t_str));}
#line 2165 "grammar.c"
    break;

  case 76: /* key: TOK_KEY_SAUID TOK_EQUALS TOK_DIGITS  */
#line 370 "grammar.y"
        { /* Ignore - Source audit ID from user AVC messages */ }
#line 2171 "grammar.c"
    break;

  case 77: /* key: TOK_KEY_HOSTNAME TOK_EQUALS safe_string  */
#line 372 "grammar.y"
        { free((yyvsp[0].t_str)); /* Ignore - hostname from user AVC messages */ }
#line 2177 "grammar.c"
    break;

  case 80: /* key: TOK_KEY_TERMINAL TOK_EQUALS safe_string  */
#line 376 "grammar.y"
        { free((yyvsp[0].t_str)); /* Ignore - TTY from user AVC messages */ }
#line 2183 "grammar.c"
    break;

  case 81: /* key: TOK_KEY_EXE TOK_EQUALS safe_string  */
#line 378 "grammar.y"
        { /* Free existing arrays because exe= and comm= maps to the same
	     aa_log_record member */
	  free(ret_record->comm);
	  ret_record->comm = (yyvsp[0].t_str);
	}
#line 2193 "grammar.c"
    break;

  case 82: /* key: TOK_KEY_COMM TOK_EQUALS safe_string  */
#line 384 "grammar.y"
        { /* Free existing arrays because exe= and comm= maps to the same
	     aa_log_record member */
	  free(ret_record->comm);
	  ret_record->comm = (yyvsp[0].t_str);
	}
#line 2203 "grammar.c"
    break;

  case 84: /* key: TOK_KEY_CAPABILITY TOK_EQUALS TOK_DIGITS  */
#line 391 "grammar.y"
        { /* need to reverse map number to string, need to figure out
	   * how to get auto generation of reverse mapping table into
	   * autotools Makefile.  For now just drop assuming capname is
	   * present which it should be with current kernels */
	}
#line 2213 "grammar.c"
    break;

  case 85: /* key: TOK_KEY_CAPNAME TOK_EQUALS TOK_QUOTED_STRING  */
#line 397 "grammar.y"
        { /* capname used to be reported in name */
	  ret_record->name = (yyvsp[0].t_str);
	}
#line 2221 "grammar.c"
    break;

  case 86: /* key: TOK_KEY_OFFSET TOK_EQUALS TOK_DIGITS  */
#line 401 "grammar.y"
        { /* offset is used for reporting where an error occurred unpacking
	   * loaded policy.  We can just drop this currently
	   */
	}
#line 2230 "grammar.c"
    break;

  case 87: /* key: TOK_KEY_TARGET TOK_EQUALS safe_string  */
#line 406 "grammar.y"
        { /* target was always name2 in the past */
	  ret_record->name2 = (yyvsp[0].t_str);
	}
#line 2238 "grammar.c"
    break;

  case 88: /* key: TOK_KEY_LADDR TOK_EQUALS TOK_IP_ADDR  */
#line 410 "grammar.y"
        { ret_record->net_local_addr = (yyvsp[0].t_str);}
#line 2244 "grammar.c"
    break;

  case 89: /* key: TOK_KEY_FADDR TOK_EQUALS TOK_IP_ADDR  */
#line 412 "grammar.y"
        { ret_record->net_foreign_addr = (yyvsp[0].t_str);}
#line 2250 "grammar.c"
    break;

  case 90: /* key: TOK_KEY_LPORT TOK_EQUALS TOK_DIGITS  */
#line 414 "grammar.y"
        { ret_record->net_local_port = (yyvsp[0].t_long);}
#line 2256 "grammar.c"
    break;

  case 91: /* key: TOK_KEY_FPORT TOK_EQUALS TOK_DIGITS  */
#line 416 "grammar.y"
        { ret_record->net_foreign_port = (yyvsp[0].t_long);}
#line 2262 "grammar.c"
    break;

  case 92: /* key: TOK_KEY_BUS TOK_EQUALS TOK_QUOTED_STRING  */
#line 418 "grammar.y"
        { ret_record->dbus_bus = (yyvsp[0].t_str); }
#line 2268 "grammar.c"
    break;

  case 93: /* key: TOK_KEY_PATH TOK_EQUALS TOK_QUOTED_STRING  */
#line 420 "grammar.y"
        { ret_record->dbus_path = (yyvsp[0].t_str); }
#line 2274 "grammar.c"
    break;

  case 94: /* key: TOK_KEY_INTERFACE TOK_EQUALS TOK_QUOTED_STRING  */
#line 422 "grammar.y"
        { ret_record->dbus_interface = (yyvsp[0].t_str); }
#line 2280 "grammar.c"
    break;

  case 95: /* key: TOK_KEY_MEMBER TOK_EQUALS TOK_QUOTED_STRING  */
#line 424 "grammar.y"
        { ret_record->dbus_member = (yyvsp[0].t_str); }
#line 2286 "grammar.c"
    break;

  case 96: /* key: TOK_KEY_SIGNAL TOK_EQUALS TOK_ID  */
#line 426 "grammar.y"
        { ret_record->signal = (yyvsp[0].t_str); }
#line 2292 "grammar.c"
    break;

  case 97: /* key: TOK_KEY_FSTYPE TOK_EQUALS TOK_QUOTED_STRING  */
#line 428 "grammar.y"
        { ret_record->fs_type = (yyvsp[0].t_str); }
#line 2298 "grammar.c"
    break;

  case 98: /* key: TOK_KEY_FLAGS TOK_EQUALS TOK_QUOTED_STRING  */
#line 430 "grammar.y"
        { ret_record->flags = (yyvsp[0].t_str); }
#line 2304 "grammar.c"
    break;

  case 99: /* key: TOK_KEY_SRCNAME TOK_EQUALS TOK_QUOTED_STRING  */
#line 432 "grammar.y"
        { ret_record->src_name = (yyvsp[0].t_str); }
#line 2310 "grammar.c"
    break;

  case 100: /* key: TOK_KEY_EXECPATH TOK_EQUALS TOK_QUOTED_STRING  */
#line 434 "grammar.y"
        { ret_record->execpath = (yyvsp[0].t_str); }
#line 2316 "grammar.c"
    break;

  case 101: /* key: TOK_MSG_REST  */
#line 436 "grammar.y"
        {
		ret_record->event = AA_RECORD_INVALID;
		ret_record->info = (yyvsp[0].t_str);
	}
#line 2325 "grammar.c"
    break;

  case 102: /* key: TOK_KEY_CLASS TOK_EQUALS TOK_QUOTED_STRING  */
#line 441 "grammar.y"
        { ret_record->rule_class = (yyvsp[0].t_str); }
#line 2331 "grammar.c"
    break;

  case 103: /* apparmor_event: TOK_TYPE_REJECT  */
#line 445 "grammar.y"
                                { ret_record->event = AA_RECORD_DENIED; }
#line 2337 "grammar.c"
    break;

  case 104: /* apparmor_event: TOK_TYPE_AUDIT  */
#line 446 "grammar.y"
                                { ret_record->event = AA_RECORD_AUDIT; }
#line 2343 "grammar.c"
    break;

  case 105: /* apparmor_event: TOK_TYPE_COMPLAIN  */
#line 447 "grammar.y"
                                { ret_record->event = AA_RECORD_ALLOWED; }
#line 2349 "grammar.c"
    break;

  case 106: /* apparmor_event: TOK_TYPE_HINT  */
#line 448 "grammar.y"
                                { ret_record->event = AA_RECORD_HINT; }
#line 2355 "grammar.c"
    break;

  case 107: /* apparmor_event: TOK_TYPE_STATUS  */
#line 449 "grammar.y"
                                { ret_record->event = AA_RECORD_STATUS; }
#line 2361 "grammar.c"
    break;

  case 108: /* apparmor_event: TOK_TYPE_ERROR  */
#line 450 "grammar.y"
                                { ret_record->event = AA_RECORD_ERROR; }
#line 2367 "grammar.c"
    break;

  case 109: /* key_pid: TOK_KEY_PID TOK_EQUALS TOK_DIGITS  */
#line 453 "grammar.y"
                                           { ret_record->pid = (yyvsp[0].t_long); }
#line 2373 "grammar.c"
    break;

  case 110: /* key_peer_pid: TOK_KEY_PEER_PID TOK_EQUALS TOK_DIGITS  */
#line 456 "grammar.y"
                                                     { ret_record->peer_pid = (yyvsp[0].t_long); }
#line 2379 "grammar.c"
    break;

  case 111: /* ignored_pid: TOK_KEY_PID TOK_EQUALS TOK_DIGITS  */
#line 459 "grammar.y"
                                                 { /* DROP */ }
#line 2385 "grammar.c"
    break;

  case 112: /* ignored_uid: TOK_KEY_UID TOK_EQUALS TOK_DIGITS  */
#line 460 "grammar.y"
                                                 { /* DROP */ }
#line 2391 "grammar.c"
    break;

  case 113: /* ignored_auid: TOK_KEY_AUID TOK_EQUALS TOK_DIGITS  */
#line 461 "grammar.y"
                                                 { /* DROP */ }
#line 2397 "grammar.c"
    break;

  case 114: /* ignored_ses: TOK_KEY_SES TOK_EQUALS TOK_DIGITS  */
#line 462 "grammar.y"
                                                 { /* DROP */ }
#line 2403 "grammar.c"
    break;

  case 115: /* key_type: TOK_KEY_TYPE TOK_EQUALS TOK_DIGITS  */
#line 464 "grammar.y"
                                             { ret_record->event = lookup_aa_event((yyvsp[0].t_long)); }
#line 2409 "grammar.c"
    break;

  case 119: /* protocol: TOK_DIGITS  */
#line 473 "grammar.y"
        { /* FIXME: this should probably convert back to a string proto name */
	  (yyval.t_str) = ipproto_to_string((yyvsp[0].t_long));
	}
#line 2417 "grammar.c"
    break;


#line 2421 "grammar.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (scanner, ret_record, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner, ret_record);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner, ret_record);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, ret_record, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner, ret_record);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner, ret_record);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 477 "grammar.y"

