// ui/events/mojom/event.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_MOJOM_EVENT_MOJOM_SHARED_H_
#define UI_EVENTS_MOJOM_EVENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/events/mojom/event.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"



#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace ui::mojom {
class KeyDataDataView;

class LocationDataDataView;

class GesturePinchDataDataView;

class GestureSwipeDataDataView;

class GestureDataDataView;

class ScrollDataDataView;

class PointerDetailsDataView;

class MouseDataDataView;

class TouchDataDataView;

class EventDataView;

class GestureDataDetailsDataView;


}  // ui::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::KeyDataDataView> {
  using Data = ::ui::mojom::internal::KeyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::LocationDataDataView> {
  using Data = ::ui::mojom::internal::LocationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GesturePinchDataDataView> {
  using Data = ::ui::mojom::internal::GesturePinchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GestureSwipeDataDataView> {
  using Data = ::ui::mojom::internal::GestureSwipeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GestureDataDataView> {
  using Data = ::ui::mojom::internal::GestureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::ScrollDataDataView> {
  using Data = ::ui::mojom::internal::ScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::PointerDetailsDataView> {
  using Data = ::ui::mojom::internal::PointerDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::MouseDataDataView> {
  using Data = ::ui::mojom::internal::MouseData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::TouchDataDataView> {
  using Data = ::ui::mojom::internal::TouchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::EventDataView> {
  using Data = ::ui::mojom::internal::Event_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GestureDataDetailsDataView> {
  using Data = ::ui::mojom::internal::GestureDataDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


class KeyDataDataView {
 public:
  KeyDataDataView() = default;

  KeyDataDataView(
      internal::KeyData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t key_code() const {
    return data_->key_code;
  }
  uint32_t dom_code() const {
    return data_->dom_code;
  }
  int32_t dom_key() const {
    return data_->dom_key;
  }
  bool is_char() const {
    return data_->is_char;
  }
 private:
  internal::KeyData_Data* data_ = nullptr;
};


class LocationDataDataView {
 public:
  LocationDataDataView() = default;

  LocationDataDataView(
      internal::LocationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelativeLocationDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeLocation(UserType* output) {
    
    auto* pointer = data_->relative_location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetRootLocationDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootLocation(UserType* output) {
    
    auto* pointer = data_->root_location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
 private:
  internal::LocationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GesturePinchDataDataView {
 public:
  GesturePinchDataDataView() = default;

  GesturePinchDataDataView(
      internal::GesturePinchData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float scale() const {
    return data_->scale;
  }
 private:
  internal::GesturePinchData_Data* data_ = nullptr;
};


class GestureSwipeDataDataView {
 public:
  GestureSwipeDataDataView() = default;

  GestureSwipeDataDataView(
      internal::GestureSwipeData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool left() const {
    return data_->left;
  }
  bool right() const {
    return data_->right;
  }
  bool up() const {
    return data_->up;
  }
  bool down() const {
    return data_->down;
  }
 private:
  internal::GestureSwipeData_Data* data_ = nullptr;
};


class GestureDataDataView {
 public:
  GestureDataDataView() = default;

  GestureDataDataView(
      internal::GestureData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeviceType(UserType* output) const {
    auto data_value = data_->device_type;
    return mojo::internal::Deserialize<::ui::mojom::GestureDeviceType>(
        data_value, output);
  }
  ::ui::mojom::GestureDeviceType device_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::GestureDeviceType>(data_->device_type));
  }
  inline void GetDetailsDataView(
      GestureDataDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::GestureDataDetailsDataView, UserType>(),
    "Attempting to read the optional `details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetails` instead "
    "of `ReadDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->details.is_null() ? &data_->details : nullptr;
    return mojo::internal::Deserialize<::ui::mojom::GestureDataDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::GestureData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollDataDataView {
 public:
  ScrollDataDataView() = default;

  ScrollDataDataView(
      internal::ScrollData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  float x_offset() const {
    return data_->x_offset;
  }
  float y_offset() const {
    return data_->y_offset;
  }
  float x_offset_ordinal() const {
    return data_->x_offset_ordinal;
  }
  float y_offset_ordinal() const {
    return data_->y_offset_ordinal;
  }
  int32_t finger_count() const {
    return data_->finger_count;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMomentumPhase(UserType* output) const {
    auto data_value = data_->momentum_phase;
    return mojo::internal::Deserialize<::ui::mojom::EventMomentumPhase>(
        data_value, output);
  }
  ::ui::mojom::EventMomentumPhase momentum_phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventMomentumPhase>(data_->momentum_phase));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollEventPhase(UserType* output) const {
    auto data_value = data_->scroll_event_phase;
    return mojo::internal::Deserialize<::ui::mojom::ScrollEventPhase>(
        data_value, output);
  }
  ::ui::mojom::ScrollEventPhase scroll_event_phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ScrollEventPhase>(data_->scroll_event_phase));
  }
 private:
  internal::ScrollData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PointerDetailsDataView {
 public:
  PointerDetailsDataView() = default;

  PointerDetailsDataView(
      internal::PointerDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPointerType(UserType* output) const {
    auto data_value = data_->pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }
  ::ui::mojom::EventPointerType pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventPointerType>(data_->pointer_type));
  }
  float radius_x() const {
    return data_->radius_x;
  }
  float radius_y() const {
    return data_->radius_y;
  }
  float force() const {
    return data_->force;
  }
  float tilt_x() const {
    return data_->tilt_x;
  }
  float tilt_y() const {
    return data_->tilt_y;
  }
  float tangential_pressure() const {
    return data_->tangential_pressure;
  }
  float twist() const {
    return data_->twist;
  }
  int32_t id() const {
    return data_->id;
  }
  int32_t offset_x() const {
    return data_->offset_x;
  }
  int32_t offset_y() const {
    return data_->offset_y;
  }
 private:
  internal::PointerDetails_Data* data_ = nullptr;
};


class MouseDataDataView {
 public:
  MouseDataDataView() = default;

  MouseDataDataView(
      internal::MouseData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t changed_button_flags() const {
    return data_->changed_button_flags;
  }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  inline void GetPointerDetailsDataView(
      PointerDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerDetails(UserType* output) {
    
    auto* pointer = data_->pointer_details.Get();
    return mojo::internal::Deserialize<::ui::mojom::PointerDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetWheelOffsetDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWheelOffset(UserType* output) {
    
    auto* pointer = data_->wheel_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetTick120thsDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTick120ths(UserType* output) {
    
    auto* pointer = data_->tick_120ths.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
 private:
  internal::MouseData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchDataDataView {
 public:
  TouchDataDataView() = default;

  TouchDataDataView(
      internal::TouchData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool may_cause_scrolling() const {
    return data_->may_cause_scrolling;
  }
  bool hovering() const {
    return data_->hovering;
  }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  inline void GetPointerDetailsDataView(
      PointerDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerDetails(UserType* output) {
    
    auto* pointer = data_->pointer_details.Get();
    return mojo::internal::Deserialize<::ui::mojom::PointerDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::TouchData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventDataView {
 public:
  EventDataView() = default;

  EventDataView(
      internal::Event_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::ui::mojom::EventType>(
        data_value, output);
  }
  ::ui::mojom::EventType action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventType>(data_->action));
  }
  int32_t flags() const {
    return data_->flags;
  }
  inline void GetTimeStampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeStamp(UserType* output) {
    
    auto* pointer = data_->time_stamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLatencyDataView(
      ::ui::mojom::LatencyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::ui::mojom::LatencyInfoDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataDataView(
      KeyDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::KeyDataDataView, UserType>(),
    "Attempting to read the optional `key_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyData` instead "
    "of `ReadKeyData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::KeyDataDataView>(
        pointer, output, message_);
  }
  inline void GetGestureDataDataView(
      GestureDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGestureData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::GestureDataDataView, UserType>(),
    "Attempting to read the optional `gesture_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGestureData` instead "
    "of `ReadGestureData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gesture_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::GestureDataDataView>(
        pointer, output, message_);
  }
  inline void GetScrollDataDataView(
      ScrollDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::ScrollDataDataView, UserType>(),
    "Attempting to read the optional `scroll_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollData` instead "
    "of `ReadScrollData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroll_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::ScrollDataDataView>(
        pointer, output, message_);
  }
  inline void GetTouchDataDataView(
      TouchDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouchData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::TouchDataDataView, UserType>(),
    "Attempting to read the optional `touch_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTouchData` instead "
    "of `ReadTouchData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->touch_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::TouchDataDataView>(
        pointer, output, message_);
  }
  inline void GetMouseDataDataView(
      MouseDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMouseData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::MouseDataDataView, UserType>(),
    "Attempting to read the optional `mouse_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMouseData` instead "
    "of `ReadMouseData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mouse_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::MouseDataDataView>(
        pointer, output, message_);
  }
  inline void GetPropertiesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProperties(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>, UserType>(),
    "Attempting to read the optional `properties` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProperties` instead "
    "of `ReadProperties if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::Event_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GestureDataDetailsDataView {
 public:
  using Tag = internal::GestureDataDetails_Data::GestureDataDetails_Tag;

  GestureDataDetailsDataView() = default;

  GestureDataDetailsDataView(
      internal::GestureDataDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_pinch() const { return data_->tag == Tag::kPinch; }
  inline void GetPinchDataView(
      GesturePinchDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPinch(UserType* output) const {
    
    CHECK(is_pinch());
    return mojo::internal::Deserialize<::ui::mojom::GesturePinchDataDataView>(
        data_->data.f_pinch.Get(), output, message_);
  }
  bool is_swipe() const { return data_->tag == Tag::kSwipe; }
  inline void GetSwipeDataView(
      GestureSwipeDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSwipe(UserType* output) const {
    
    CHECK(is_swipe());
    return mojo::internal::Deserialize<::ui::mojom::GestureSwipeDataDataView>(
        data_->data.f_swipe.Get(), output, message_);
  }

 private:
  internal::GestureDataDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // ui::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::KeyDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::KeyDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::KeyData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->key_code = Traits::key_code(input);
    fragment->dom_code = Traits::dom_code(input);
    fragment->dom_key = Traits::dom_key(input);
    fragment->is_char = Traits::is_char(input);
  }

  static bool Deserialize(::ui::mojom::internal::KeyData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::KeyDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::LocationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::LocationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::LocationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::relative_location(input)) in_relative_location = Traits::relative_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relative_location)::BaseType> relative_location_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_relative_location, relative_location_fragment);
    fragment->relative_location.Set(
        relative_location_fragment.is_null() ? nullptr : relative_location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->relative_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relative_location in LocationData struct");
    decltype(Traits::root_location(input)) in_root_location = Traits::root_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_location)::BaseType> root_location_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_root_location, root_location_fragment);
    fragment->root_location.Set(
        root_location_fragment.is_null() ? nullptr : root_location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->root_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_location in LocationData struct");
  }

  static bool Deserialize(::ui::mojom::internal::LocationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::LocationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::GesturePinchDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::GesturePinchDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::GesturePinchData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->scale = Traits::scale(input);
  }

  static bool Deserialize(::ui::mojom::internal::GesturePinchData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::GesturePinchDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::GestureSwipeDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::GestureSwipeDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::GestureSwipeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->left = Traits::left(input);
    fragment->right = Traits::right(input);
    fragment->up = Traits::up(input);
    fragment->down = Traits::down(input);
  }

  static bool Deserialize(::ui::mojom::internal::GestureSwipeData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::GestureSwipeDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::GestureDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::GestureDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::GestureData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::LocationDataDataView>(
        in_location, location_fragment);
    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in GestureData struct");
    mojo::internal::Serialize<::ui::mojom::GestureDeviceType>(
        Traits::device_type(input), &fragment->device_type);
    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<decltype(fragment->details)>
        details_fragment(fragment.message());
    details_fragment.Claim(&fragment->details);
    mojo::internal::Serialize<::ui::mojom::GestureDataDetailsDataView>(
        in_details, details_fragment, true);
  }

  static bool Deserialize(::ui::mojom::internal::GestureData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::GestureDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::ScrollDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ScrollDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ScrollData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::LocationDataDataView>(
        in_location, location_fragment);
    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in ScrollData struct");
    fragment->x_offset = Traits::x_offset(input);
    fragment->y_offset = Traits::y_offset(input);
    fragment->x_offset_ordinal = Traits::x_offset_ordinal(input);
    fragment->y_offset_ordinal = Traits::y_offset_ordinal(input);
    fragment->finger_count = Traits::finger_count(input);
    mojo::internal::Serialize<::ui::mojom::EventMomentumPhase>(
        Traits::momentum_phase(input), &fragment->momentum_phase);
    mojo::internal::Serialize<::ui::mojom::ScrollEventPhase>(
        Traits::scroll_event_phase(input), &fragment->scroll_event_phase);
  }

  static bool Deserialize(::ui::mojom::internal::ScrollData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::ScrollDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::PointerDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::PointerDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::PointerDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::ui::mojom::EventPointerType>(
        Traits::pointer_type(input), &fragment->pointer_type);
    fragment->radius_x = Traits::radius_x(input);
    fragment->radius_y = Traits::radius_y(input);
    fragment->force = Traits::force(input);
    fragment->tilt_x = Traits::tilt_x(input);
    fragment->tilt_y = Traits::tilt_y(input);
    fragment->tangential_pressure = Traits::tangential_pressure(input);
    fragment->twist = Traits::twist(input);
    fragment->id = Traits::id(input);
    fragment->offset_x = Traits::offset_x(input);
    fragment->offset_y = Traits::offset_y(input);
  }

  static bool Deserialize(::ui::mojom::internal::PointerDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::PointerDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::MouseDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::MouseDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::MouseData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->changed_button_flags = Traits::changed_button_flags(input);
    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::LocationDataDataView>(
        in_location, location_fragment);
    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in MouseData struct");
    decltype(Traits::pointer_details(input)) in_pointer_details = Traits::pointer_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointer_details)::BaseType> pointer_details_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::PointerDetailsDataView>(
        in_pointer_details, pointer_details_fragment);
    fragment->pointer_details.Set(
        pointer_details_fragment.is_null() ? nullptr : pointer_details_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pointer_details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointer_details in MouseData struct");
    decltype(Traits::wheel_offset(input)) in_wheel_offset = Traits::wheel_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wheel_offset)::BaseType> wheel_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
        in_wheel_offset, wheel_offset_fragment);
    fragment->wheel_offset.Set(
        wheel_offset_fragment.is_null() ? nullptr : wheel_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->wheel_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null wheel_offset in MouseData struct");
    decltype(Traits::tick_120ths(input)) in_tick_120ths = Traits::tick_120ths(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tick_120ths)::BaseType> tick_120ths_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
        in_tick_120ths, tick_120ths_fragment);
    fragment->tick_120ths.Set(
        tick_120ths_fragment.is_null() ? nullptr : tick_120ths_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tick_120ths.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tick_120ths in MouseData struct");
  }

  static bool Deserialize(::ui::mojom::internal::MouseData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::MouseDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::TouchDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::TouchDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::TouchData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->may_cause_scrolling = Traits::may_cause_scrolling(input);
    fragment->hovering = Traits::hovering(input);
    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::LocationDataDataView>(
        in_location, location_fragment);
    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in TouchData struct");
    decltype(Traits::pointer_details(input)) in_pointer_details = Traits::pointer_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointer_details)::BaseType> pointer_details_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::PointerDetailsDataView>(
        in_pointer_details, pointer_details_fragment);
    fragment->pointer_details.Set(
        pointer_details_fragment.is_null() ? nullptr : pointer_details_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pointer_details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointer_details in TouchData struct");
  }

  static bool Deserialize(::ui::mojom::internal::TouchData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::TouchDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::EventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::EventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::Event_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::ui::mojom::EventType>(
        Traits::action(input), &fragment->action);
    fragment->flags = Traits::flags(input);
    decltype(Traits::time_stamp(input)) in_time_stamp = Traits::time_stamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->time_stamp)::BaseType> time_stamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_time_stamp, time_stamp_fragment);
    fragment->time_stamp.Set(
        time_stamp_fragment.is_null() ? nullptr : time_stamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->time_stamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_stamp in Event struct");
    decltype(Traits::latency(input)) in_latency = Traits::latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latency)::BaseType> latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::LatencyInfoDataView>(
        in_latency, latency_fragment);
    fragment->latency.Set(
        latency_fragment.is_null() ? nullptr : latency_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->latency.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in Event struct");
    decltype(Traits::key_data(input)) in_key_data = Traits::key_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_data)::BaseType> key_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::KeyDataDataView>(
        in_key_data, key_data_fragment);
    fragment->key_data.Set(
        key_data_fragment.is_null() ? nullptr : key_data_fragment.data());
    decltype(Traits::gesture_data(input)) in_gesture_data = Traits::gesture_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gesture_data)::BaseType> gesture_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::GestureDataDataView>(
        in_gesture_data, gesture_data_fragment);
    fragment->gesture_data.Set(
        gesture_data_fragment.is_null() ? nullptr : gesture_data_fragment.data());
    decltype(Traits::scroll_data(input)) in_scroll_data = Traits::scroll_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_data)::BaseType> scroll_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::ScrollDataDataView>(
        in_scroll_data, scroll_data_fragment);
    fragment->scroll_data.Set(
        scroll_data_fragment.is_null() ? nullptr : scroll_data_fragment.data());
    decltype(Traits::touch_data(input)) in_touch_data = Traits::touch_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->touch_data)::BaseType> touch_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::TouchDataDataView>(
        in_touch_data, touch_data_fragment);
    fragment->touch_data.Set(
        touch_data_fragment.is_null() ? nullptr : touch_data_fragment.data());
    decltype(Traits::mouse_data(input)) in_mouse_data = Traits::mouse_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mouse_data)::BaseType> mouse_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::ui::mojom::MouseDataDataView>(
        in_mouse_data, mouse_data_fragment);
    fragment->mouse_data.Set(
        mouse_data_fragment.is_null() ? nullptr : mouse_data_fragment.data());
    decltype(Traits::properties(input)) in_properties = Traits::properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->properties)::BaseType>
        properties_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& properties_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>>(
        in_properties, properties_fragment, &properties_validate_params);
    fragment->properties.Set(
        properties_fragment.is_null() ? nullptr : properties_fragment.data());
  }

  static bool Deserialize(::ui::mojom::internal::Event_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::EventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::GestureDataDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ui::mojom::GestureDataDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::ui::mojom::internal::GestureDataDetails_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::ui::mojom::GestureDataDetailsDataView::Tag::kPinch: {
        decltype(Traits::pinch(input))
            in_pinch = Traits::pinch(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_pinch)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::ui::mojom::GesturePinchDataDataView>(
            in_pinch, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null pinch in GestureDataDetails union");
        fragment->data.f_pinch.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::ui::mojom::GestureDataDetailsDataView::Tag::kSwipe: {
        decltype(Traits::swipe(input))
            in_swipe = Traits::swipe(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_swipe)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::ui::mojom::GestureSwipeDataDataView>(
            in_swipe, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null swipe in GestureDataDetails union");
        fragment->data.f_swipe.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::ui::mojom::internal::GestureDataDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::GestureDataDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {



inline void LocationDataDataView::GetRelativeLocationDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->relative_location.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void LocationDataDataView::GetRootLocationDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->root_location.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}






inline void GestureDataDataView::GetLocationDataView(
    LocationDataDataView* output) {
  auto pointer = data_->location.Get();
  *output = LocationDataDataView(pointer, message_);
}
inline void GestureDataDataView::GetDetailsDataView(
    GestureDataDetailsDataView* output) {
  auto pointer = &data_->details;
  *output = GestureDataDetailsDataView(pointer, message_);
}


inline void ScrollDataDataView::GetLocationDataView(
    LocationDataDataView* output) {
  auto pointer = data_->location.Get();
  *output = LocationDataDataView(pointer, message_);
}




inline void MouseDataDataView::GetLocationDataView(
    LocationDataDataView* output) {
  auto pointer = data_->location.Get();
  *output = LocationDataDataView(pointer, message_);
}
inline void MouseDataDataView::GetPointerDetailsDataView(
    PointerDetailsDataView* output) {
  auto pointer = data_->pointer_details.Get();
  *output = PointerDetailsDataView(pointer, message_);
}
inline void MouseDataDataView::GetWheelOffsetDataView(
    ::gfx::mojom::Vector2dDataView* output) {
  auto pointer = data_->wheel_offset.Get();
  *output = ::gfx::mojom::Vector2dDataView(pointer, message_);
}
inline void MouseDataDataView::GetTick120thsDataView(
    ::gfx::mojom::Vector2dDataView* output) {
  auto pointer = data_->tick_120ths.Get();
  *output = ::gfx::mojom::Vector2dDataView(pointer, message_);
}


inline void TouchDataDataView::GetLocationDataView(
    LocationDataDataView* output) {
  auto pointer = data_->location.Get();
  *output = LocationDataDataView(pointer, message_);
}
inline void TouchDataDataView::GetPointerDetailsDataView(
    PointerDetailsDataView* output) {
  auto pointer = data_->pointer_details.Get();
  *output = PointerDetailsDataView(pointer, message_);
}


inline void EventDataView::GetTimeStampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->time_stamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void EventDataView::GetLatencyDataView(
    ::ui::mojom::LatencyInfoDataView* output) {
  auto pointer = data_->latency.Get();
  *output = ::ui::mojom::LatencyInfoDataView(pointer, message_);
}
inline void EventDataView::GetKeyDataDataView(
    KeyDataDataView* output) {
  auto pointer = data_->key_data.Get();
  *output = KeyDataDataView(pointer, message_);
}
inline void EventDataView::GetGestureDataDataView(
    GestureDataDataView* output) {
  auto pointer = data_->gesture_data.Get();
  *output = GestureDataDataView(pointer, message_);
}
inline void EventDataView::GetScrollDataDataView(
    ScrollDataDataView* output) {
  auto pointer = data_->scroll_data.Get();
  *output = ScrollDataDataView(pointer, message_);
}
inline void EventDataView::GetTouchDataDataView(
    TouchDataDataView* output) {
  auto pointer = data_->touch_data.Get();
  *output = TouchDataDataView(pointer, message_);
}
inline void EventDataView::GetMouseDataDataView(
    MouseDataDataView* output) {
  auto pointer = data_->mouse_data.Get();
  *output = MouseDataDataView(pointer, message_);
}
inline void EventDataView::GetPropertiesDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->properties.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void GestureDataDetailsDataView::GetPinchDataView(
    GesturePinchDataDataView* output) const {
  CHECK(is_pinch());
  *output = GesturePinchDataDataView(data_->data.f_pinch.Get(), message_);
}
inline void GestureDataDetailsDataView::GetSwipeDataView(
    GestureSwipeDataDataView* output) const {
  CHECK(is_swipe());
  *output = GestureSwipeDataDataView(data_->data.f_swipe.Get(), message_);
}


}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_EVENTS_MOJOM_EVENT_MOJOM_SHARED_H_