// third_party/blink/public/mojom/frame/policy_container.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class PolicyContainerPoliciesDataView;

class PolicyContainerDataView;

class PolicyContainerBindParamsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PolicyContainerPoliciesDataView> {
  using Data = ::blink::mojom::internal::PolicyContainerPolicies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PolicyContainerDataView> {
  using Data = ::blink::mojom::internal::PolicyContainer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PolicyContainerBindParamsDataView> {
  using Data = ::blink::mojom::internal::PolicyContainerBindParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class PolicyContainerHostInterfaceBase {};

using PolicyContainerHostPtrDataView =
    mojo::InterfacePtrDataView<PolicyContainerHostInterfaceBase>;
using PolicyContainerHostRequestDataView =
    mojo::InterfaceRequestDataView<PolicyContainerHostInterfaceBase>;
using PolicyContainerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PolicyContainerHostInterfaceBase>;
using PolicyContainerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PolicyContainerHostInterfaceBase>;


class PolicyContainerPoliciesDataView {
 public:
  PolicyContainerPoliciesDataView() = default;

  PolicyContainerPoliciesDataView(
      internal::PolicyContainerPolicies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCrossOriginEmbedderPolicyDataView(
      ::network::mojom::CrossOriginEmbedderPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCrossOriginEmbedderPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_embedder_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetContentSecurityPoliciesDataView(
      mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSecurityPolicies(UserType* output) {
    
    auto* pointer = data_->content_security_policies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        pointer, output, message_);
  }
  bool is_credentialless() const {
    return data_->is_credentialless;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSandboxFlags(UserType* output) const {
    auto data_value = data_->sandbox_flags;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }
  ::network::mojom::WebSandboxFlags sandbox_flags() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSandboxFlags>(data_->sandbox_flags));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIpAddressSpace(UserType* output) const {
    auto data_value = data_->ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->ip_address_space));
  }
  bool can_navigate_top_without_user_gesture() const {
    return data_->can_navigate_top_without_user_gesture;
  }
  bool allow_cross_origin_isolation() const {
    return data_->allow_cross_origin_isolation;
  }
 private:
  internal::PolicyContainerPolicies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PolicyContainerDataView {
 public:
  PolicyContainerDataView() = default;

  PolicyContainerDataView(
      internal::PolicyContainer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPoliciesDataView(
      PolicyContainerPoliciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicies(UserType* output) {
    
    auto* pointer = data_->policies.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerPoliciesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PolicyContainerHostAssociatedPtrInfoDataView>(
            &data_->remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PolicyContainer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PolicyContainerBindParamsDataView {
 public:
  PolicyContainerBindParamsDataView() = default;

  PolicyContainerBindParamsDataView(
      internal::PolicyContainerBindParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PolicyContainerHostAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PolicyContainerBindParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyContainerPoliciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerPoliciesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainerPolicies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        in_cross_origin_embedder_policy, cross_origin_embedder_policy_fragment);
    fragment->cross_origin_embedder_policy.Set(
        cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cross_origin_embedder_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cross_origin_embedder_policy in PolicyContainerPolicies struct");
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input), &fragment->referrer_policy);
    decltype(Traits::content_security_policies(input)) in_content_security_policies = Traits::content_security_policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_security_policies)::BaseType>
        content_security_policies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        in_content_security_policies, content_security_policies_fragment, &content_security_policies_validate_params);
    fragment->content_security_policies.Set(
        content_security_policies_fragment.is_null() ? nullptr : content_security_policies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_security_policies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_security_policies in PolicyContainerPolicies struct");
    fragment->is_credentialless = Traits::is_credentialless(input);
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
        Traits::sandbox_flags(input), &fragment->sandbox_flags);
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::ip_address_space(input), &fragment->ip_address_space);
    fragment->can_navigate_top_without_user_gesture = Traits::can_navigate_top_without_user_gesture(input);
    fragment->allow_cross_origin_isolation = Traits::allow_cross_origin_isolation(input);
  }

  static bool Deserialize(::blink::mojom::internal::PolicyContainerPolicies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyContainerPoliciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyContainerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::policies(input)) in_policies = Traits::policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policies)::BaseType> policies_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PolicyContainerPoliciesDataView>(
        in_policies, policies_fragment);
    fragment->policies.Set(
        policies_fragment.is_null() ? nullptr : policies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->policies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null policies in PolicyContainer struct");
    decltype(Traits::remote(input)) in_remote = Traits::remote(input);
    mojo::internal::Serialize<::blink::mojom::PolicyContainerHostAssociatedPtrInfoDataView>(
        in_remote, &fragment->remote, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->remote),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid remote in PolicyContainer struct");
  }

  static bool Deserialize(::blink::mojom::internal::PolicyContainer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyContainerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyContainerBindParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerBindParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainerBindParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);
    mojo::internal::Serialize<::blink::mojom::PolicyContainerHostAssociatedRequestDataView>(
        in_receiver, &fragment->receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid receiver in PolicyContainerBindParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::PolicyContainerBindParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyContainerBindParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void PolicyContainerPoliciesDataView::GetCrossOriginEmbedderPolicyDataView(
    ::network::mojom::CrossOriginEmbedderPolicyDataView* output) {
  auto pointer = data_->cross_origin_embedder_policy.Get();
  *output = ::network::mojom::CrossOriginEmbedderPolicyDataView(pointer, message_);
}
inline void PolicyContainerPoliciesDataView::GetContentSecurityPoliciesDataView(
    mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output) {
  auto pointer = data_->content_security_policies.Get();
  *output = mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>(pointer, message_);
}


inline void PolicyContainerDataView::GetPoliciesDataView(
    PolicyContainerPoliciesDataView* output) {
  auto pointer = data_->policies.Get();
  *output = PolicyContainerPoliciesDataView(pointer, message_);
}





}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SHARED_H_