// third_party/blink/public/mojom/frame/frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_state.mojom.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-forward.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/load_timing_info.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include "services/network/public/mojom/source_location.mojom-forward.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom.h"
#include "services/network/public/mojom/attribution.mojom-forward.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "skia/public/mojom/skcolor4f.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-forward.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-forward.h"
#include "third_party/blink/public/mojom/close_watcher/close_listener.mojom-forward.h"
#include "third_party/blink/public/mojom/confidence_level.mojom-forward.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-forward.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-forward.h"
#include "third_party/blink/public/mojom/drag/drag.mojom.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-forward.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-forward.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/blocked_navigation_types.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/sudden_termination_disabler_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-forward.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/loader/keep_alive_handle_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/messaging/delegated_capability.mojom-forward.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-forward.h"
#include "third_party/blink/public/mojom/opengraph/metadata.mojom-forward.h"
#include "third_party/blink/public/mojom/page/draggable_region.mojom-forward.h"
#include "third_party/blink/public/mojom/page/widget.mojom-forward.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-forward.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-forward.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-forward.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-forward.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-forward.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/events/mojom/scroll_granularity.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/image/mojom/image.mojom-forward.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/frame/frame_owner_element_type_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class LocalFrameHostProxy;

template <typename ImplRefTraits>
class LocalFrameHostStub;

class LocalFrameHostRequestValidator;
class LocalFrameHostResponseValidator;


class BLINK_COMMON_EXPORT LocalFrameHost
    : public LocalFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    371113740, 
    589490140, 
    1399110879, 
    1835899896
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalFrameHostInterfaceBase;
  using Proxy_ = LocalFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameHostRequestValidator;
  using ResponseValidator_ = LocalFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnterFullscreenMinVersion = 0,
    kExitFullscreenMinVersion = 0,
    kFullscreenStateChangedMinVersion = 0,
    kRegisterProtocolHandlerMinVersion = 0,
    kUnregisterProtocolHandlerMinVersion = 0,
    kDidDisplayInsecureContentMinVersion = 0,
    kDidContainInsecureFormActionMinVersion = 0,
    kMainDocumentElementAvailableMinVersion = 0,
    kSetNeedsOcclusionTrackingMinVersion = 0,
    kSetVirtualKeyboardModeMinVersion = 0,
    kVisibilityChangedMinVersion = 0,
    kDidChangeThemeColorMinVersion = 0,
    kDidChangeBackgroundColorMinVersion = 0,
    kDidFailLoadWithErrorMinVersion = 0,
    kDidFocusFrameMinVersion = 0,
    kDidCallFocusMinVersion = 0,
    kEnforceInsecureRequestPolicyMinVersion = 0,
    kEnforceInsecureNavigationsSetMinVersion = 0,
    kSuddenTerminationDisablerChangedMinVersion = 0,
    kHadStickyUserActivationBeforeNavigationChangedMinVersion = 0,
    kScrollRectToVisibleInParentFrameMinVersion = 0,
    kBubbleLogicalScrollInParentFrameMinVersion = 0,
    kStartLoadingForAsyncNavigationApiCommitMinVersion = 0,
    kDidBlockNavigationMinVersion = 0,
    kDidChangeLoadProgressMinVersion = 0,
    kDidFinishLoadMinVersion = 0,
    kDispatchLoadMinVersion = 0,
    kGoToEntryAtOffsetMinVersion = 0,
    kNavigateToNavigationApiKeyMinVersion = 0,
    kNavigateEventHandlerPresenceChangedMinVersion = 0,
    kUpdateTitleMinVersion = 0,
    kUpdateApplicationTitleMinVersion = 0,
    kUpdateUserActivationStateMinVersion = 0,
    kDidConsumeHistoryUserActivationMinVersion = 0,
    kHandleAccessibilityFindInPageResultMinVersion = 0,
    kHandleAccessibilityFindInPageTerminationMinVersion = 0,
    kDocumentOnLoadCompletedMinVersion = 0,
    kForwardResourceTimingToParentMinVersion = 0,
    kDidDispatchDOMContentLoadedEventMinVersion = 0,
    kRunModalAlertDialogMinVersion = 0,
    kRunModalConfirmDialogMinVersion = 0,
    kRunModalPromptDialogMinVersion = 0,
    kRunBeforeUnloadConfirmMinVersion = 0,
    kUpdateFaviconURLMinVersion = 0,
    kDownloadURLMinVersion = 0,
    kFocusedElementChangedMinVersion = 0,
    kTextSelectionChangedMinVersion = 0,
    kShowPopupMenuMinVersion = 0,
    kCreateNewPopupWidgetMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kDidLoadResourceFromMemoryCacheMinVersion = 0,
    kDidChangeFrameOwnerPropertiesMinVersion = 0,
    kDidChangeOpenerMinVersion = 0,
    kDidChangeFramePolicyMinVersion = 0,
    kDidChangeIframeAttributesMinVersion = 0,
    kCapturePaintPreviewOfSubframeMinVersion = 0,
    kSetCloseListenerMinVersion = 0,
    kDetachMinVersion = 0,
    kGetKeepAliveHandleFactoryMinVersion = 0,
    kDidAddMessageToConsoleMinVersion = 0,
    kFrameSizeChangedMinVersion = 0,
    kDidInferColorSchemeMinVersion = 0,
    kDidChangeSrcDocMinVersion = 0,
    kReceivedDelegatedCapabilityMinVersion = 0,
    kSendFencedFrameReportingBeaconMinVersion = 0,
    kSendFencedFrameReportingBeaconToCustomURLMinVersion = 0,
    kDisableUntrustedNetworkInFencedFrameMinVersion = 0,
    kExemptUrlFromNetworkRevocationForTestingMinVersion = 0,
    kSendLegacyTechEventMinVersion = 0,
    kSetFencedFrameAutomaticBeaconReportEventDataMinVersion = 0,
    kSendPrivateAggregationRequestsForFencedFrameEventMinVersion = 0,
    kCreateFencedFrameMinVersion = 0,
    kForwardFencedFrameEventAndUserActivationToEmbedderMinVersion = 0,
    kOnViewTransitionOptInChangedMinVersion = 0,
    kStartDraggingMinVersion = 0,
    kIssueKeepAliveHandleMinVersion = 0,
    kNotifyStorageAccessedMinVersion = 0,
    kRecordWindowProxyUsageMetricsMinVersion = 0,
    kNotifyDocumentInteractiveMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnterFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FullscreenStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterProtocolHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnregisterProtocolHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDisplayInsecureContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidContainInsecureFormAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MainDocumentElementAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNeedsOcclusionTracking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVirtualKeyboardMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeThemeColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeBackgroundColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFailLoadWithError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFocusFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCallFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnforceInsecureRequestPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnforceInsecureNavigationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuddenTerminationDisablerChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HadStickyUserActivationBeforeNavigationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrollRectToVisibleInParentFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BubbleLogicalScrollInParentFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartLoadingForAsyncNavigationApiCommit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidBlockNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeLoadProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFinishLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoToEntryAtOffset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateToNavigationApiKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateEventHandlerPresenceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateApplicationTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateUserActivationState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidConsumeHistoryUserActivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAccessibilityFindInPageResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAccessibilityFindInPageTermination_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DocumentOnLoadCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardResourceTimingToParent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDispatchDOMContentLoadedEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunModalAlertDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunModalConfirmDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunModalPromptDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunBeforeUnloadConfirm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateFaviconURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusedElementChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextSelectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPopupMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateNewPopupWidget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidLoadResourceFromMemoryCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeFrameOwnerProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeOpener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeFramePolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeIframeAttributes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CapturePaintPreviewOfSubframe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCloseListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Detach_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetKeepAliveHandleFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidAddMessageToConsole_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FrameSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidInferColorScheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeSrcDoc_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceivedDelegatedCapability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendFencedFrameReportingBeacon_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendFencedFrameReportingBeaconToCustomURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableUntrustedNetworkInFencedFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExemptUrlFromNetworkRevocationForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendLegacyTechEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFencedFrameAutomaticBeaconReportEventData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendPrivateAggregationRequestsForFencedFrameEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFencedFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardFencedFrameEventAndUserActivationToEmbedder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnViewTransitionOptInChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDragging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueKeepAliveHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyStorageAccessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordWindowProxyUsageMetrics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyDocumentInteractive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalFrameHost() = default;


  using EnterFullscreenCallback = base::OnceCallback<void(bool)>;
  
  virtual void EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullscreenCallback callback) = 0;

  
  virtual void ExitFullscreen() = 0;

  
  virtual void FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::FullscreenOptionsPtr options) = 0;

  
  virtual void RegisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) = 0;

  
  virtual void UnregisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) = 0;

  
  virtual void DidDisplayInsecureContent() = 0;

  
  virtual void DidContainInsecureFormAction() = 0;

  
  virtual void MainDocumentElementAvailable(bool uses_temporary_zoom_level) = 0;

  
  virtual void SetNeedsOcclusionTracking(bool needs_tracking) = 0;

  
  virtual void SetVirtualKeyboardMode(::ui::mojom::VirtualKeyboardMode type) = 0;

  
  virtual void VisibilityChanged(::blink::mojom::FrameVisibility visibility) = 0;

  
  virtual void DidChangeThemeColor(std::optional<::SkColor> theme_color) = 0;

  
  virtual void DidChangeBackgroundColor(const ::SkColor4f& background_color, bool color_adjust) = 0;

  
  virtual void DidFailLoadWithError(const ::GURL& url, int32_t error_code) = 0;

  
  virtual void DidFocusFrame() = 0;

  
  virtual void DidCallFocus() = 0;

  
  virtual void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy_bitmap) = 0;

  
  virtual void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) = 0;

  
  virtual void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::SuddenTerminationDisablerType disabler_type) = 0;

  
  virtual void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) = 0;

  
  virtual void ScrollRectToVisibleInParentFrame(const ::gfx::RectF& rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr params) = 0;

  
  virtual void BubbleLogicalScrollInParentFrame(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) = 0;

  
  virtual void StartLoadingForAsyncNavigationApiCommit() = 0;

  
  virtual void DidBlockNavigation(const ::GURL& blocked_url, ::blink::mojom::NavigationBlockedReason reason) = 0;

  
  virtual void DidChangeLoadProgress(double load_progress) = 0;

  
  virtual void DidFinishLoad(const ::GURL& validated_url) = 0;

  
  virtual void DispatchLoad() = 0;

  
  virtual void GoToEntryAtOffset(int32_t offset, bool has_user_gesture, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) = 0;

  
  virtual void NavigateToNavigationApiKey(const std::string& key, bool has_user_gesture, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) = 0;

  
  virtual void NavigateEventHandlerPresenceChanged(bool present) = 0;

  
  virtual void UpdateTitle(const std::optional<::std::u16string>& title, ::base::i18n::TextDirection title_direction) = 0;

  
  virtual void UpdateApplicationTitle(const ::std::u16string& application_title) = 0;

  
  virtual void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType update_type, ::blink::mojom::UserActivationNotificationType notification_type) = 0;

  
  virtual void DidConsumeHistoryUserActivation() = 0;

  
  virtual void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) = 0;

  
  virtual void HandleAccessibilityFindInPageTermination() = 0;

  
  virtual void DocumentOnLoadCompleted() = 0;

  
  virtual void ForwardResourceTimingToParent(::blink::mojom::ResourceTimingInfoPtr timing) = 0;

  
  virtual void DidDispatchDOMContentLoadedEvent() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion);

  using RunModalAlertDialogCallback = base::OnceCallback<void()>;
  
  virtual void RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success);

  using RunModalConfirmDialogCallback = base::OnceCallback<void(bool)>;
  
  virtual void RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::std::u16string* out_result);

  using RunModalPromptDialogCallback = base::OnceCallback<void(bool, const ::std::u16string&)>;
  
  virtual void RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunBeforeUnloadConfirm(bool is_reload, bool* out_success);

  using RunBeforeUnloadConfirmCallback = base::OnceCallback<void(bool)>;
  
  virtual void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) = 0;

  
  virtual void UpdateFaviconURL(std::vector<::blink::mojom::FaviconURLPtr> favicon_urls) = 0;

  
  virtual void DownloadURL(DownloadURLParamsPtr params) = 0;

  
  virtual void FocusedElementChanged(bool is_editable_element, bool is_richly_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::FocusType focus_type) = 0;

  
  virtual void TextSelectionChanged(const ::std::u16string& text, uint32_t offset, const ::gfx::Range& range, bool user_initiated) = 0;

  
  virtual void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, double font_size, int32_t selected_item, std::vector<::blink::mojom::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) = 0;

  
  virtual void CreateNewPopupWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget) = 0;

  
  virtual void ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) = 0;

  
  virtual void DidLoadResourceFromMemoryCache(const ::GURL& url, const std::string& http_method, const std::string& mime_type, ::network::mojom::RequestDestination request_destination, bool include_credentials) = 0;

  
  virtual void DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties) = 0;

  
  virtual void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) = 0;

  
  virtual void DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) = 0;

  
  virtual void DidChangeIframeAttributes(const ::blink::FrameToken& child_frame_token, IframeAttributesPtr attributes) = 0;

  
  virtual void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) = 0;

  
  virtual void SetCloseListener(::mojo::PendingRemote<::blink::mojom::CloseListener> listener) = 0;

  
  virtual void Detach() = 0;

  
  virtual void GetKeepAliveHandleFactory(::mojo::PendingReceiver<::blink::mojom::KeepAliveHandleFactory> factory) = 0;

  
  virtual void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const ::std::u16string& msg, uint32_t line_number, const std::optional<::std::u16string>& source_id, const std::optional<::std::u16string>& untrusted_stack_trace) = 0;

  
  virtual void FrameSizeChanged(const ::gfx::Size& size) = 0;

  
  virtual void DidInferColorScheme(::blink::mojom::PreferredColorScheme color_scheme) = 0;

  
  virtual void DidChangeSrcDoc(const ::blink::FrameToken& child_frame_token, const std::string& srcdoc_value) = 0;

  
  virtual void ReceivedDelegatedCapability(::blink::mojom::DelegatedCapability delegated_capability) = 0;

  
  virtual void SendFencedFrameReportingBeacon(const std::string& event_data, const std::string& event_type, const std::vector<::blink::FencedFrame::ReportingDestination>& destinations, bool cross_origin_exposed) = 0;

  
  virtual void SendFencedFrameReportingBeaconToCustomURL(const ::GURL& destination_url, bool cross_origin_exposed) = 0;


  using DisableUntrustedNetworkInFencedFrameCallback = base::OnceCallback<void()>;
  
  virtual void DisableUntrustedNetworkInFencedFrame(DisableUntrustedNetworkInFencedFrameCallback callback) = 0;


  using ExemptUrlFromNetworkRevocationForTestingCallback = base::OnceCallback<void()>;
  
  virtual void ExemptUrlFromNetworkRevocationForTesting(const ::GURL& exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) = 0;

  
  virtual void SendLegacyTechEvent(const std::string& type, LegacyTechEventCodeLocationPtr code_location) = 0;

  
  virtual void SetFencedFrameAutomaticBeaconReportEventData(::blink::mojom::AutomaticBeaconType event_type, const std::string& event_data, const std::vector<::blink::FencedFrame::ReportingDestination>& destinations, bool once, bool cross_origin_exposed) = 0;

  
  virtual void SendPrivateAggregationRequestsForFencedFrameEvent(const std::string& event_type) = 0;

  
  virtual void CreateFencedFrame(::mojo::PendingAssociatedReceiver<::blink::mojom::FencedFrameOwnerHost> fenced_frame, ::blink::mojom::RemoteFrameInterfacesFromRendererPtr remote_frame_interfaces, const ::blink::RemoteFrameToken& frame_token, const ::base::UnguessableToken& devtools_frame_token) = 0;

  
  virtual void ForwardFencedFrameEventAndUserActivationToEmbedder(const std::string& event_type) = 0;

  
  virtual void OnViewTransitionOptInChanged(ViewTransitionSameOriginOptIn view_transition_opt_in) = 0;

  
  virtual void StartDragging(::blink::mojom::DragDataPtr drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& cursor_offset_in_dip, const ::gfx::Rect& drag_obj_rect_in_dip, ::blink::mojom::DragEventSourceInfoPtr event_info) = 0;

  
  virtual void IssueKeepAliveHandle(::mojo::PendingReceiver<::blink::mojom::NavigationStateKeepAliveHandle> receiver) = 0;

  
  virtual void NotifyStorageAccessed(StorageTypeAccessed storageType, bool blocked) = 0;

  
  virtual void RecordWindowProxyUsageMetrics(const ::blink::FrameToken& target_frame_token, WindowProxyAccessType access_type) = 0;

  
  virtual void NotifyDocumentInteractive() = 0;
};

class NonAssociatedLocalFrameHostProxy;

template <typename ImplRefTraits>
class NonAssociatedLocalFrameHostStub;

class NonAssociatedLocalFrameHostRequestValidator;


class BLINK_COMMON_EXPORT NonAssociatedLocalFrameHost
    : public NonAssociatedLocalFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NonAssociatedLocalFrameHostInterfaceBase;
  using Proxy_ = NonAssociatedLocalFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = NonAssociatedLocalFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = NonAssociatedLocalFrameHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMaybeStartOutermostMainFrameNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MaybeStartOutermostMainFrameNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NonAssociatedLocalFrameHost() = default;

  
  virtual void MaybeStartOutermostMainFrameNavigation(const std::vector<::GURL>& urls) = 0;
};

class LocalFrameProxy;

template <typename ImplRefTraits>
class LocalFrameStub;

class LocalFrameRequestValidator;
class LocalFrameResponseValidator;


class BLINK_COMMON_EXPORT LocalFrame
    : public LocalFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalFrameInterfaceBase;
  using Proxy_ = LocalFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameRequestValidator;
  using ResponseValidator_ = LocalFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTextSurroundingSelectionMinVersion = 0,
    kSendInterventionReportMinVersion = 0,
    kSetFrameOwnerPropertiesMinVersion = 0,
    kNotifyUserActivationMinVersion = 0,
    kNotifyVirtualKeyboardOverlayRectMinVersion = 0,
    kAddMessageToConsoleMinVersion = 0,
    kSwapInImmediatelyMinVersion = 0,
    kCheckCompletedMinVersion = 0,
    kStopLoadingMinVersion = 0,
    kCollapseMinVersion = 0,
    kEnableViewSourceModeMinVersion = 0,
    kFocusMinVersion = 0,
    kClearFocusedElementMinVersion = 0,
    kCopyImageAtMinVersion = 0,
    kSaveImageAtMinVersion = 0,
    kReportBlinkFeatureUsageMinVersion = 0,
    kRenderFallbackContentMinVersion = 0,
    kBeforeUnloadMinVersion = 0,
    kMediaPlayerActionAtMinVersion = 0,
    kRequestVideoFrameAtWithBoundsHintMinVersion = 0,
    kPluginActionAtMinVersion = 0,
    kAdvanceFocusInFrameMinVersion = 0,
    kAdvanceFocusForIMEMinVersion = 0,
    kReportContentSecurityPolicyViolationMinVersion = 0,
    kDidUpdateFramePolicyMinVersion = 0,
    kOnFrameVisibilityChangedMinVersion = 0,
    kPostMessageEventMinVersion = 0,
    kJavaScriptMethodExecuteRequestMinVersion = 0,
    kJavaScriptExecuteRequestMinVersion = 0,
    kJavaScriptExecuteRequestForTestsMinVersion = 0,
    kJavaScriptExecuteRequestInIsolatedWorldMinVersion = 0,
    kBindReportingObserverMinVersion = 0,
    kUpdateOpenerMinVersion = 0,
    kGetSavableResourceLinksMinVersion = 0,
    kMixedContentFoundMinVersion = 0,
    kBindDevToolsAgentMinVersion = 0,
    kHandleRendererDebugURLMinVersion = 0,
    kGetCanonicalUrlForSharingMinVersion = 0,
    kGetOpenGraphMetadataMinVersion = 0,
    kSetNavigationApiHistoryEntriesForRestoreMinVersion = 0,
    kUpdatePrerenderURLMinVersion = 0,
    kNotifyNavigationApiOfDisposedEntriesMinVersion = 0,
    kTraverseCancelledMinVersion = 0,
    kDispatchNavigateEventForCrossDocumentTraversalMinVersion = 0,
    kSnapshotDocumentForViewTransitionMinVersion = 0,
    kNotifyViewTransitionAbortedToOldDocumentMinVersion = 0,
    kDispatchPageSwapMinVersion = 0,
    kAddResourceTimingEntryForFailedSubframeNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTextSurroundingSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendInterventionReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFrameOwnerProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyUserActivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyVirtualKeyboardOverlayRect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddMessageToConsole_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwapInImmediately_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopLoading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Collapse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableViewSourceMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Focus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearFocusedElement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyImageAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveImageAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportBlinkFeatureUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenderFallbackContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeforeUnload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaPlayerActionAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestVideoFrameAtWithBoundsHint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PluginActionAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdvanceFocusInFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdvanceFocusForIME_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportContentSecurityPolicyViolation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidUpdateFramePolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PostMessageEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptMethodExecuteRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptExecuteRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptExecuteRequestForTests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptExecuteRequestInIsolatedWorld_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReportingObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateOpener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSavableResourceLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MixedContentFound_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindDevToolsAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleRendererDebugURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCanonicalUrlForSharing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOpenGraphMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNavigationApiHistoryEntriesForRestore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePrerenderURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyNavigationApiOfDisposedEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TraverseCancelled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchNavigateEventForCrossDocumentTraversal_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SnapshotDocumentForViewTransition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyViewTransitionAbortedToOldDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPageSwap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddResourceTimingEntryForFailedSubframeNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalFrame() = default;


  using GetTextSurroundingSelectionCallback = base::OnceCallback<void(const ::std::u16string&, uint32_t, uint32_t)>;
  
  virtual void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) = 0;

  
  virtual void SendInterventionReport(const std::string& id, const std::string& message) = 0;

  
  virtual void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) = 0;

  
  virtual void NotifyUserActivation(::blink::mojom::UserActivationNotificationType notification_type) = 0;

  
  virtual void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) = 0;

  
  virtual void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message, bool discard_duplicates) = 0;

  
  virtual void SwapInImmediately() = 0;

  
  virtual void CheckCompleted() = 0;

  
  virtual void StopLoading() = 0;

  
  virtual void Collapse(bool collapsed) = 0;

  
  virtual void EnableViewSourceMode() = 0;

  
  virtual void Focus() = 0;

  
  virtual void ClearFocusedElement() = 0;

  
  virtual void CopyImageAt(const ::gfx::Point& window_point) = 0;

  
  virtual void SaveImageAt(const ::gfx::Point& window_point) = 0;

  
  virtual void ReportBlinkFeatureUsage(const std::vector<::blink::mojom::WebFeature>& features) = 0;

  
  virtual void RenderFallbackContent() = 0;


  using BeforeUnloadCallback = base::OnceCallback<void(bool, ::base::TimeTicks, ::base::TimeTicks)>;
  
  virtual void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) = 0;

  
  virtual void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::MediaPlayerActionPtr action) = 0;


  using RequestVideoFrameAtWithBoundsHintCallback = base::OnceCallback<void(const ::SkBitmap&, const ::gfx::Rect&)>;
  
  virtual void RequestVideoFrameAtWithBoundsHint(const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, RequestVideoFrameAtWithBoundsHintCallback callback) = 0;

  
  virtual void PluginActionAt(const ::gfx::Point& location, PluginActionType action) = 0;

  
  virtual void AdvanceFocusInFrame(::blink::mojom::FocusType focus_type, const std::optional<::blink::RemoteFrameToken>& source_frame_token) = 0;

  
  virtual void AdvanceFocusForIME(::blink::mojom::FocusType focus_type) = 0;

  
  virtual void ReportContentSecurityPolicyViolation(::network::mojom::CSPViolationPtr violation) = 0;

  
  virtual void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) = 0;

  
  virtual void OnFrameVisibilityChanged(::blink::mojom::FrameVisibility visibility) = 0;

  
  virtual void PostMessageEvent(const std::optional<::blink::RemoteFrameToken>& source_frame_token, const ::std::u16string& source_origin, const ::std::u16string& target_origin, ::blink::TransferableMessage message) = 0;


  using JavaScriptMethodExecuteRequestCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptMethodExecuteRequest(const ::std::u16string& object_name, const ::std::u16string& method_name, ::base::Value::List arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) = 0;


  using JavaScriptExecuteRequestCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptExecuteRequest(const ::std::u16string& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) = 0;


  using JavaScriptExecuteRequestForTestsCallback = base::OnceCallback<void(JavaScriptExecutionResultType, ::base::Value)>;
  
  virtual void JavaScriptExecuteRequestForTests(const ::std::u16string& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) = 0;


  using JavaScriptExecuteRequestInIsolatedWorldCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptExecuteRequestInIsolatedWorld(const ::std::u16string& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) = 0;

  
  virtual void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::ReportingObserver> receiver) = 0;

  
  virtual void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) = 0;


  using GetSavableResourceLinksCallback = base::OnceCallback<void(GetSavableResourceLinksReplyPtr)>;
  
  virtual void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) = 0;

  
  virtual void MixedContentFound(const ::GURL& main_resource_url, const ::GURL& mixed_content_url, ::blink::mojom::RequestContextType request_context, bool was_allowed, const ::GURL& url_before_redirects, bool had_redirect, ::network::mojom::SourceLocationPtr source_location) = 0;

  
  virtual void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent) = 0;

  
  virtual void HandleRendererDebugURL(const ::GURL& url) = 0;


  using GetCanonicalUrlForSharingCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;
  
  virtual void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) = 0;


  using GetOpenGraphMetadataCallback = base::OnceCallback<void(::blink::mojom::OpenGraphMetadataPtr)>;
  
  virtual void GetOpenGraphMetadata(GetOpenGraphMetadataCallback callback) = 0;

  
  virtual void SetNavigationApiHistoryEntriesForRestore(::blink::mojom::NavigationApiHistoryEntryArraysPtr entry_arrays, NavigationApiEntryRestoreReason restore_reason) = 0;


  using UpdatePrerenderURLCallback = base::OnceCallback<void()>;
  
  virtual void UpdatePrerenderURL(const ::GURL& matched_url, UpdatePrerenderURLCallback callback) = 0;

  
  virtual void NotifyNavigationApiOfDisposedEntries(const std::vector<std::string>& keys) = 0;

  
  virtual void TraverseCancelled(const std::string& navigation_api_key, TraverseCancelledReason reason) = 0;

  
  virtual void DispatchNavigateEventForCrossDocumentTraversal(const ::GURL& url, const std::string& page_state, bool is_browser_initiated) = 0;


  using SnapshotDocumentForViewTransitionCallback = base::OnceCallback<void(const ::blink::ViewTransitionState&)>;
  
  virtual void SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::PageSwapEventParamsPtr page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) = 0;

  
  virtual void NotifyViewTransitionAbortedToOldDocument() = 0;

  
  virtual void DispatchPageSwap(::blink::mojom::PageSwapEventParamsPtr page_swap_event_params) = 0;

  
  virtual void AddResourceTimingEntryForFailedSubframeNavigation(const ::blink::FrameToken& subframe_token, const ::GURL& initial_url, ::base::TimeTicks start_time, ::base::TimeTicks redirect_time, ::base::TimeTicks request_start, ::base::TimeTicks response_start, uint32_t response_code, const std::string& mime_type, const ::net::LoadTimingInfo& load_timing_info, ::net::HttpConnectionInfo connection_info, const std::string& alpn_negotiated_protocol, bool is_secure_transport, bool is_validated, const std::string& normalized_server_timing, const ::network::URLLoaderCompletionStatus& completion_status) = 0;
};

class LocalMainFrameProxy;

template <typename ImplRefTraits>
class LocalMainFrameStub;

class LocalMainFrameRequestValidator;
class LocalMainFrameResponseValidator;


class BLINK_COMMON_EXPORT LocalMainFrame
    : public LocalMainFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalMainFrameInterfaceBase;
  using Proxy_ = LocalMainFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMainFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalMainFrameRequestValidator;
  using ResponseValidator_ = LocalMainFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAnimateDoubleTapZoomMinVersion = 0,
    kSetScaleFactorMinVersion = 0,
    kClosePageMinVersion = 0,
    kGetFullPageSizeMinVersion = 0,
    kSetInitialFocusMinVersion = 0,
    kEnablePreferredSizeChangedModeMinVersion = 0,
    kZoomToFindInPageRectMinVersion = 0,
    kInstallCoopAccessMonitorMinVersion = 0,
    kUpdateBrowserControlsStateMinVersion = 0,
    kSetV8CompileHintsMinVersion = 0,
    kDiscardMinVersion = 0,
    kFinalizeNavigationConfidenceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AnimateDoubleTapZoom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetScaleFactor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClosePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFullPageSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInitialFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnablePreferredSizeChangedMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ZoomToFindInPageRect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallCoopAccessMonitor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateBrowserControlsState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetV8CompileHints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Discard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FinalizeNavigationConfidence_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalMainFrame() = default;

  
  virtual void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) = 0;

  
  virtual void SetScaleFactor(float scale) = 0;


  using ClosePageCallback = base::OnceCallback<void()>;
  
  virtual void ClosePage(ClosePageCallback callback) = 0;


  using GetFullPageSizeCallback = base::OnceCallback<void(const ::gfx::Size&)>;
  
  virtual void GetFullPageSize(GetFullPageSizeCallback callback) = 0;

  
  virtual void SetInitialFocus(bool reverse) = 0;

  
  virtual void EnablePreferredSizeChangedMode() = 0;

  
  virtual void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) = 0;

  
  virtual void InstallCoopAccessMonitor(const ::blink::FrameToken& accessed_window, ::network::mojom::CrossOriginOpenerPolicyReporterParamsPtr coop_reporter_info, bool is_in_same_virtual_coop_related_group) = 0;

  
  virtual void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) = 0;

  
  virtual void SetV8CompileHints(::base::ReadOnlySharedMemoryRegion data) = 0;

  
  virtual void Discard() = 0;

  
  virtual void FinalizeNavigationConfidence(double randomized_trigger_rate, ::blink::mojom::ConfidenceLevel confidence) = 0;
};

class LocalMainFrameHostProxy;

template <typename ImplRefTraits>
class LocalMainFrameHostStub;

class LocalMainFrameHostRequestValidator;
class LocalMainFrameHostResponseValidator;


class BLINK_COMMON_EXPORT LocalMainFrameHost
    : public LocalMainFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalMainFrameHostInterfaceBase;
  using Proxy_ = LocalMainFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMainFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalMainFrameHostRequestValidator;
  using ResponseValidator_ = LocalMainFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kScaleFactorChangedMinVersion = 0,
    kContentsPreferredSizeChangedMinVersion = 0,
    kTextAutosizerPageInfoChangedMinVersion = 0,
    kFocusPageMinVersion = 0,
    kTakeFocusMinVersion = 0,
    kUpdateTargetURLMinVersion = 0,
    kRequestCloseMinVersion = 0,
    kShowCreatedWindowMinVersion = 0,
    kSetWindowRectMinVersion = 0,
    kDidFirstVisuallyNonEmptyPaintMinVersion = 0,
    kDidAccessInitialMainDocumentMinVersion = 0,
    kMaximizeMinVersion = 0,
    kMinimizeMinVersion = 0,
    kRestoreMinVersion = 0,
    kSetResizableMinVersion = 0,
    kDraggableRegionsChangedMinVersion = 0,
    kOnFirstContentfulPaintMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ScaleFactorChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContentsPreferredSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextAutosizerPageInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTargetURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowCreatedWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWindowRect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFirstVisuallyNonEmptyPaint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidAccessInitialMainDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Maximize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Minimize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Restore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetResizable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggableRegionsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFirstContentfulPaint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalMainFrameHost() = default;

  
  virtual void ScaleFactorChanged(float scale) = 0;

  
  virtual void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) = 0;

  
  virtual void TextAutosizerPageInfoChanged(::blink::mojom::TextAutosizerPageInfoPtr page_info) = 0;

  
  virtual void FocusPage() = 0;

  
  virtual void TakeFocus(bool reverse) = 0;


  using UpdateTargetURLCallback = base::OnceCallback<void()>;
  
  virtual void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) = 0;

  
  virtual void RequestClose() = 0;


  using ShowCreatedWindowCallback = base::OnceCallback<void()>;
  
  virtual void ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::WindowOpenDisposition disposition, ::blink::mojom::WindowFeaturesPtr window_features, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) = 0;


  using SetWindowRectCallback = base::OnceCallback<void()>;
  
  virtual void SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) = 0;

  
  virtual void DidFirstVisuallyNonEmptyPaint() = 0;

  
  virtual void DidAccessInitialMainDocument() = 0;

  
  virtual void Maximize() = 0;

  
  virtual void Minimize() = 0;

  
  virtual void Restore() = 0;

  
  virtual void SetResizable(bool resizable) = 0;

  
  virtual void DraggableRegionsChanged(std::vector<::blink::mojom::DraggableRegionPtr> regions) = 0;

  
  virtual void OnFirstContentfulPaint() = 0;
};



class BLINK_COMMON_EXPORT LocalFrameHostProxy
    : public LocalFrameHost {
 public:
  using InterfaceType = LocalFrameHost;

  explicit LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullscreenCallback callback) final;
  
  void ExitFullscreen() final;
  
  void FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::FullscreenOptionsPtr options) final;
  
  void RegisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) final;
  
  void UnregisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) final;
  
  void DidDisplayInsecureContent() final;
  
  void DidContainInsecureFormAction() final;
  
  void MainDocumentElementAvailable(bool uses_temporary_zoom_level) final;
  
  void SetNeedsOcclusionTracking(bool needs_tracking) final;
  
  void SetVirtualKeyboardMode(::ui::mojom::VirtualKeyboardMode type) final;
  
  void VisibilityChanged(::blink::mojom::FrameVisibility visibility) final;
  
  void DidChangeThemeColor(std::optional<::SkColor> theme_color) final;
  
  void DidChangeBackgroundColor(const ::SkColor4f& background_color, bool color_adjust) final;
  
  void DidFailLoadWithError(const ::GURL& url, int32_t error_code) final;
  
  void DidFocusFrame() final;
  
  void DidCallFocus() final;
  
  void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy_bitmap) final;
  
  void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) final;
  
  void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::SuddenTerminationDisablerType disabler_type) final;
  
  void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) final;
  
  void ScrollRectToVisibleInParentFrame(const ::gfx::RectF& rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr params) final;
  
  void BubbleLogicalScrollInParentFrame(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) final;
  
  void StartLoadingForAsyncNavigationApiCommit() final;
  
  void DidBlockNavigation(const ::GURL& blocked_url, ::blink::mojom::NavigationBlockedReason reason) final;
  
  void DidChangeLoadProgress(double load_progress) final;
  
  void DidFinishLoad(const ::GURL& validated_url) final;
  
  void DispatchLoad() final;
  
  void GoToEntryAtOffset(int32_t offset, bool has_user_gesture, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) final;
  
  void NavigateToNavigationApiKey(const std::string& key, bool has_user_gesture, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) final;
  
  void NavigateEventHandlerPresenceChanged(bool present) final;
  
  void UpdateTitle(const std::optional<::std::u16string>& title, ::base::i18n::TextDirection title_direction) final;
  
  void UpdateApplicationTitle(const ::std::u16string& application_title) final;
  
  void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType update_type, ::blink::mojom::UserActivationNotificationType notification_type) final;
  
  void DidConsumeHistoryUserActivation() final;
  
  void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) final;
  
  void HandleAccessibilityFindInPageTermination() final;
  
  void DocumentOnLoadCompleted() final;
  
  void ForwardResourceTimingToParent(::blink::mojom::ResourceTimingInfoPtr timing) final;
  
  void DidDispatchDOMContentLoadedEvent() final;
  
  bool RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion) final;
  
  void RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) final;
  
  bool RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success) final;
  
  void RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) final;
  
  bool RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::std::u16string* out_result) final;
  
  void RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) final;
  
  bool RunBeforeUnloadConfirm(bool is_reload, bool* out_success) final;
  
  void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) final;
  
  void UpdateFaviconURL(std::vector<::blink::mojom::FaviconURLPtr> favicon_urls) final;
  
  void DownloadURL(DownloadURLParamsPtr params) final;
  
  void FocusedElementChanged(bool is_editable_element, bool is_richly_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::FocusType focus_type) final;
  
  void TextSelectionChanged(const ::std::u16string& text, uint32_t offset, const ::gfx::Range& range, bool user_initiated) final;
  
  void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, double font_size, int32_t selected_item, std::vector<::blink::mojom::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) final;
  
  void CreateNewPopupWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget) final;
  
  void ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) final;
  
  void DidLoadResourceFromMemoryCache(const ::GURL& url, const std::string& http_method, const std::string& mime_type, ::network::mojom::RequestDestination request_destination, bool include_credentials) final;
  
  void DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties) final;
  
  void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) final;
  
  void DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) final;
  
  void DidChangeIframeAttributes(const ::blink::FrameToken& child_frame_token, IframeAttributesPtr attributes) final;
  
  void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) final;
  
  void SetCloseListener(::mojo::PendingRemote<::blink::mojom::CloseListener> listener) final;
  
  void Detach() final;
  
  void GetKeepAliveHandleFactory(::mojo::PendingReceiver<::blink::mojom::KeepAliveHandleFactory> factory) final;
  
  void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const ::std::u16string& msg, uint32_t line_number, const std::optional<::std::u16string>& source_id, const std::optional<::std::u16string>& untrusted_stack_trace) final;
  
  void FrameSizeChanged(const ::gfx::Size& size) final;
  
  void DidInferColorScheme(::blink::mojom::PreferredColorScheme color_scheme) final;
  
  void DidChangeSrcDoc(const ::blink::FrameToken& child_frame_token, const std::string& srcdoc_value) final;
  
  void ReceivedDelegatedCapability(::blink::mojom::DelegatedCapability delegated_capability) final;
  
  void SendFencedFrameReportingBeacon(const std::string& event_data, const std::string& event_type, const std::vector<::blink::FencedFrame::ReportingDestination>& destinations, bool cross_origin_exposed) final;
  
  void SendFencedFrameReportingBeaconToCustomURL(const ::GURL& destination_url, bool cross_origin_exposed) final;
  
  void DisableUntrustedNetworkInFencedFrame(DisableUntrustedNetworkInFencedFrameCallback callback) final;
  
  void ExemptUrlFromNetworkRevocationForTesting(const ::GURL& exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) final;
  
  void SendLegacyTechEvent(const std::string& type, LegacyTechEventCodeLocationPtr code_location) final;
  
  void SetFencedFrameAutomaticBeaconReportEventData(::blink::mojom::AutomaticBeaconType event_type, const std::string& event_data, const std::vector<::blink::FencedFrame::ReportingDestination>& destinations, bool once, bool cross_origin_exposed) final;
  
  void SendPrivateAggregationRequestsForFencedFrameEvent(const std::string& event_type) final;
  
  void CreateFencedFrame(::mojo::PendingAssociatedReceiver<::blink::mojom::FencedFrameOwnerHost> fenced_frame, ::blink::mojom::RemoteFrameInterfacesFromRendererPtr remote_frame_interfaces, const ::blink::RemoteFrameToken& frame_token, const ::base::UnguessableToken& devtools_frame_token) final;
  
  void ForwardFencedFrameEventAndUserActivationToEmbedder(const std::string& event_type) final;
  
  void OnViewTransitionOptInChanged(ViewTransitionSameOriginOptIn view_transition_opt_in) final;
  
  void StartDragging(::blink::mojom::DragDataPtr drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& cursor_offset_in_dip, const ::gfx::Rect& drag_obj_rect_in_dip, ::blink::mojom::DragEventSourceInfoPtr event_info) final;
  
  void IssueKeepAliveHandle(::mojo::PendingReceiver<::blink::mojom::NavigationStateKeepAliveHandle> receiver) final;
  
  void NotifyStorageAccessed(StorageTypeAccessed storageType, bool blocked) final;
  
  void RecordWindowProxyUsageMetrics(const ::blink::FrameToken& target_frame_token, WindowProxyAccessType access_type) final;
  
  void NotifyDocumentInteractive() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT NonAssociatedLocalFrameHostProxy
    : public NonAssociatedLocalFrameHost {
 public:
  using InterfaceType = NonAssociatedLocalFrameHost;

  explicit NonAssociatedLocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MaybeStartOutermostMainFrameNavigation(const std::vector<::GURL>& urls) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT LocalFrameProxy
    : public LocalFrame {
 public:
  using InterfaceType = LocalFrame;

  explicit LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) final;
  
  void SendInterventionReport(const std::string& id, const std::string& message) final;
  
  void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) final;
  
  void NotifyUserActivation(::blink::mojom::UserActivationNotificationType notification_type) final;
  
  void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) final;
  
  void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message, bool discard_duplicates) final;
  
  void SwapInImmediately() final;
  
  void CheckCompleted() final;
  
  void StopLoading() final;
  
  void Collapse(bool collapsed) final;
  
  void EnableViewSourceMode() final;
  
  void Focus() final;
  
  void ClearFocusedElement() final;
  
  void CopyImageAt(const ::gfx::Point& window_point) final;
  
  void SaveImageAt(const ::gfx::Point& window_point) final;
  
  void ReportBlinkFeatureUsage(const std::vector<::blink::mojom::WebFeature>& features) final;
  
  void RenderFallbackContent() final;
  
  void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) final;
  
  void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::MediaPlayerActionPtr action) final;
  
  void RequestVideoFrameAtWithBoundsHint(const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, RequestVideoFrameAtWithBoundsHintCallback callback) final;
  
  void PluginActionAt(const ::gfx::Point& location, PluginActionType action) final;
  
  void AdvanceFocusInFrame(::blink::mojom::FocusType focus_type, const std::optional<::blink::RemoteFrameToken>& source_frame_token) final;
  
  void AdvanceFocusForIME(::blink::mojom::FocusType focus_type) final;
  
  void ReportContentSecurityPolicyViolation(::network::mojom::CSPViolationPtr violation) final;
  
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) final;
  
  void OnFrameVisibilityChanged(::blink::mojom::FrameVisibility visibility) final;
  
  void PostMessageEvent(const std::optional<::blink::RemoteFrameToken>& source_frame_token, const ::std::u16string& source_origin, const ::std::u16string& target_origin, ::blink::TransferableMessage message) final;
  
  void JavaScriptMethodExecuteRequest(const ::std::u16string& object_name, const ::std::u16string& method_name, ::base::Value::List arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) final;
  
  void JavaScriptExecuteRequest(const ::std::u16string& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) final;
  
  void JavaScriptExecuteRequestForTests(const ::std::u16string& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) final;
  
  void JavaScriptExecuteRequestInIsolatedWorld(const ::std::u16string& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) final;
  
  void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::ReportingObserver> receiver) final;
  
  void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) final;
  
  void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) final;
  
  void MixedContentFound(const ::GURL& main_resource_url, const ::GURL& mixed_content_url, ::blink::mojom::RequestContextType request_context, bool was_allowed, const ::GURL& url_before_redirects, bool had_redirect, ::network::mojom::SourceLocationPtr source_location) final;
  
  void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent) final;
  
  void HandleRendererDebugURL(const ::GURL& url) final;
  
  void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) final;
  
  void GetOpenGraphMetadata(GetOpenGraphMetadataCallback callback) final;
  
  void SetNavigationApiHistoryEntriesForRestore(::blink::mojom::NavigationApiHistoryEntryArraysPtr entry_arrays, NavigationApiEntryRestoreReason restore_reason) final;
  
  void UpdatePrerenderURL(const ::GURL& matched_url, UpdatePrerenderURLCallback callback) final;
  
  void NotifyNavigationApiOfDisposedEntries(const std::vector<std::string>& keys) final;
  
  void TraverseCancelled(const std::string& navigation_api_key, TraverseCancelledReason reason) final;
  
  void DispatchNavigateEventForCrossDocumentTraversal(const ::GURL& url, const std::string& page_state, bool is_browser_initiated) final;
  
  void SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::PageSwapEventParamsPtr page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) final;
  
  void NotifyViewTransitionAbortedToOldDocument() final;
  
  void DispatchPageSwap(::blink::mojom::PageSwapEventParamsPtr page_swap_event_params) final;
  
  void AddResourceTimingEntryForFailedSubframeNavigation(const ::blink::FrameToken& subframe_token, const ::GURL& initial_url, ::base::TimeTicks start_time, ::base::TimeTicks redirect_time, ::base::TimeTicks request_start, ::base::TimeTicks response_start, uint32_t response_code, const std::string& mime_type, const ::net::LoadTimingInfo& load_timing_info, ::net::HttpConnectionInfo connection_info, const std::string& alpn_negotiated_protocol, bool is_secure_transport, bool is_validated, const std::string& normalized_server_timing, const ::network::URLLoaderCompletionStatus& completion_status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT LocalMainFrameProxy
    : public LocalMainFrame {
 public:
  using InterfaceType = LocalMainFrame;

  explicit LocalMainFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) final;
  
  void SetScaleFactor(float scale) final;
  
  void ClosePage(ClosePageCallback callback) final;
  
  void GetFullPageSize(GetFullPageSizeCallback callback) final;
  
  void SetInitialFocus(bool reverse) final;
  
  void EnablePreferredSizeChangedMode() final;
  
  void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) final;
  
  void InstallCoopAccessMonitor(const ::blink::FrameToken& accessed_window, ::network::mojom::CrossOriginOpenerPolicyReporterParamsPtr coop_reporter_info, bool is_in_same_virtual_coop_related_group) final;
  
  void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) final;
  
  void SetV8CompileHints(::base::ReadOnlySharedMemoryRegion data) final;
  
  void Discard() final;
  
  void FinalizeNavigationConfidence(double randomized_trigger_rate, ::blink::mojom::ConfidenceLevel confidence) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT LocalMainFrameHostProxy
    : public LocalMainFrameHost {
 public:
  using InterfaceType = LocalMainFrameHost;

  explicit LocalMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ScaleFactorChanged(float scale) final;
  
  void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) final;
  
  void TextAutosizerPageInfoChanged(::blink::mojom::TextAutosizerPageInfoPtr page_info) final;
  
  void FocusPage() final;
  
  void TakeFocus(bool reverse) final;
  
  void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) final;
  
  void RequestClose() final;
  
  void ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::WindowOpenDisposition disposition, ::blink::mojom::WindowFeaturesPtr window_features, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) final;
  
  void SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) final;
  
  void DidFirstVisuallyNonEmptyPaint() final;
  
  void DidAccessInitialMainDocument() final;
  
  void Maximize() final;
  
  void Minimize() final;
  
  void Restore() final;
  
  void SetResizable(bool resizable) final;
  
  void DraggableRegionsChanged(std::vector<::blink::mojom::DraggableRegionPtr> regions) final;
  
  void OnFirstContentfulPaint() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT LocalFrameHostStubDispatch {
 public:
  static bool Accept(LocalFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrameHost>>
class LocalFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameHostStub() = default;
  ~LocalFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NonAssociatedLocalFrameHostStubDispatch {
 public:
  static bool Accept(NonAssociatedLocalFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NonAssociatedLocalFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NonAssociatedLocalFrameHost>>
class NonAssociatedLocalFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NonAssociatedLocalFrameHostStub() = default;
  ~NonAssociatedLocalFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NonAssociatedLocalFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NonAssociatedLocalFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalFrameStubDispatch {
 public:
  static bool Accept(LocalFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrame>>
class LocalFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameStub() = default;
  ~LocalFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalMainFrameStubDispatch {
 public:
  static bool Accept(LocalMainFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMainFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMainFrame>>
class LocalMainFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMainFrameStub() = default;
  ~LocalMainFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostStubDispatch {
 public:
  static bool Accept(LocalMainFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMainFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMainFrameHost>>
class LocalMainFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMainFrameHostStub() = default;
  ~LocalMainFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT NonAssociatedLocalFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_COMMON_EXPORT LegacyTechEventCodeLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LegacyTechEventCodeLocation, T>::value>;
  using DataView = LegacyTechEventCodeLocationDataView;
  using Data_ = internal::LegacyTechEventCodeLocation_Data;

  template <typename... Args>
  static LegacyTechEventCodeLocationPtr New(Args&&... args) {
    return LegacyTechEventCodeLocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LegacyTechEventCodeLocationPtr From(const U& u) {
    return mojo::TypeConverter<LegacyTechEventCodeLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LegacyTechEventCodeLocation>::Convert(*this);
  }


  LegacyTechEventCodeLocation();

  LegacyTechEventCodeLocation(
      const std::string& filename,
      uint64_t line,
      uint64_t column);


  ~LegacyTechEventCodeLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LegacyTechEventCodeLocationPtr>
  LegacyTechEventCodeLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LegacyTechEventCodeLocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LegacyTechEventCodeLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LegacyTechEventCodeLocation_UnserializedMessageContext<
            UserType, LegacyTechEventCodeLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LegacyTechEventCodeLocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LegacyTechEventCodeLocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LegacyTechEventCodeLocation_UnserializedMessageContext<
            UserType, LegacyTechEventCodeLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LegacyTechEventCodeLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string filename;
  
  uint64_t line;
  
  uint64_t column;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT SavableSubframe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SavableSubframe, T>::value>;
  using DataView = SavableSubframeDataView;
  using Data_ = internal::SavableSubframe_Data;

  template <typename... Args>
  static SavableSubframePtr New(Args&&... args) {
    return SavableSubframePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SavableSubframePtr From(const U& u) {
    return mojo::TypeConverter<SavableSubframePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SavableSubframe>::Convert(*this);
  }


  SavableSubframe();

  SavableSubframe(
      const ::GURL& original_url,
      const ::blink::FrameToken& subframe_token);


  ~SavableSubframe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SavableSubframePtr>
  SavableSubframePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SavableSubframe::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SavableSubframe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SavableSubframe_UnserializedMessageContext<
            UserType, SavableSubframe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SavableSubframe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SavableSubframe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SavableSubframe_UnserializedMessageContext<
            UserType, SavableSubframe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SavableSubframe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL original_url;
  
  ::blink::FrameToken subframe_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT GetSavableResourceLinksReply {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetSavableResourceLinksReply, T>::value>;
  using DataView = GetSavableResourceLinksReplyDataView;
  using Data_ = internal::GetSavableResourceLinksReply_Data;

  template <typename... Args>
  static GetSavableResourceLinksReplyPtr New(Args&&... args) {
    return GetSavableResourceLinksReplyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetSavableResourceLinksReplyPtr From(const U& u) {
    return mojo::TypeConverter<GetSavableResourceLinksReplyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetSavableResourceLinksReply>::Convert(*this);
  }


  GetSavableResourceLinksReply();

  GetSavableResourceLinksReply(
      std::vector<::GURL> resources_list,
      ::blink::mojom::ReferrerPtr referrer,
      std::vector<SavableSubframePtr> subframes);

GetSavableResourceLinksReply(const GetSavableResourceLinksReply&) = delete;
GetSavableResourceLinksReply& operator=(const GetSavableResourceLinksReply&) = delete;

  ~GetSavableResourceLinksReply();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetSavableResourceLinksReplyPtr>
  GetSavableResourceLinksReplyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetSavableResourceLinksReply::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetSavableResourceLinksReply::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetSavableResourceLinksReply_UnserializedMessageContext<
            UserType, GetSavableResourceLinksReply::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetSavableResourceLinksReply::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetSavableResourceLinksReply::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetSavableResourceLinksReply_UnserializedMessageContext<
            UserType, GetSavableResourceLinksReply::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetSavableResourceLinksReply::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::GURL> resources_list;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  std::vector<SavableSubframePtr> subframes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FindInPageResultAXParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FindInPageResultAXParams, T>::value>;
  using DataView = FindInPageResultAXParamsDataView;
  using Data_ = internal::FindInPageResultAXParams_Data;

  template <typename... Args>
  static FindInPageResultAXParamsPtr New(Args&&... args) {
    return FindInPageResultAXParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FindInPageResultAXParamsPtr From(const U& u) {
    return mojo::TypeConverter<FindInPageResultAXParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FindInPageResultAXParams>::Convert(*this);
  }


  FindInPageResultAXParams();

  FindInPageResultAXParams(
      int32_t request_id,
      int32_t match_index,
      int32_t start_id,
      int32_t start_offset,
      int32_t end_id,
      int32_t end_offset);


  ~FindInPageResultAXParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FindInPageResultAXParamsPtr>
  FindInPageResultAXParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FindInPageResultAXParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FindInPageResultAXParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FindInPageResultAXParams_UnserializedMessageContext<
            UserType, FindInPageResultAXParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FindInPageResultAXParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FindInPageResultAXParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FindInPageResultAXParams_UnserializedMessageContext<
            UserType, FindInPageResultAXParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FindInPageResultAXParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t request_id;
  
  int32_t match_index;
  
  int32_t start_id;
  
  int32_t start_offset;
  
  int32_t end_id;
  
  int32_t end_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DownloadURLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DownloadURLParams, T>::value>;
  using DataView = DownloadURLParamsDataView;
  using Data_ = internal::DownloadURLParams_Data;

  template <typename... Args>
  static DownloadURLParamsPtr New(Args&&... args) {
    return DownloadURLParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DownloadURLParamsPtr From(const U& u) {
    return mojo::TypeConverter<DownloadURLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DownloadURLParams>::Convert(*this);
  }


  DownloadURLParams();

  DownloadURLParams(
      const ::GURL& url,
      ::blink::mojom::ReferrerPtr referrer,
      const std::optional<::url::Origin>& initiator_origin,
      const std::optional<::std::u16string>& suggested_name,
      ::network::mojom::RedirectMode cross_origin_redirects,
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token,
      ::mojo::PendingRemote<::blink::mojom::Blob> data_url_blob,
      bool is_context_menu_save,
      bool has_user_gesture);

DownloadURLParams(const DownloadURLParams&) = delete;
DownloadURLParams& operator=(const DownloadURLParams&) = delete;

  ~DownloadURLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DownloadURLParamsPtr>
  DownloadURLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DownloadURLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DownloadURLParams_UnserializedMessageContext<
            UserType, DownloadURLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DownloadURLParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DownloadURLParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DownloadURLParams_UnserializedMessageContext<
            UserType, DownloadURLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DownloadURLParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  std::optional<::url::Origin> initiator_origin;
  
  std::optional<::std::u16string> suggested_name;
  
  ::network::mojom::RedirectMode cross_origin_redirects;
  
  ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token;
  
  ::mojo::PendingRemote<::blink::mojom::Blob> data_url_blob;
  
  bool is_context_menu_save;
  
  bool has_user_gesture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IframeAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IframeAttributes, T>::value>;
  using DataView = IframeAttributesDataView;
  using Data_ = internal::IframeAttributes_Data;

  template <typename... Args>
  static IframeAttributesPtr New(Args&&... args) {
    return IframeAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IframeAttributesPtr From(const U& u) {
    return mojo::TypeConverter<IframeAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IframeAttributes>::Convert(*this);
  }


  IframeAttributes();

  IframeAttributes(
      ::network::mojom::ContentSecurityPolicyPtr parsed_csp_attribute,
      bool credentialless,
      bool browsing_topics,
      bool ad_auction_headers,
      bool shared_storage_writable_opted_in,
      const std::optional<std::string>& id,
      const std::optional<std::string>& name,
      const std::optional<std::string>& src);

IframeAttributes(const IframeAttributes&) = delete;
IframeAttributes& operator=(const IframeAttributes&) = delete;

  ~IframeAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IframeAttributesPtr>
  IframeAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IframeAttributes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IframeAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IframeAttributes_UnserializedMessageContext<
            UserType, IframeAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IframeAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IframeAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IframeAttributes_UnserializedMessageContext<
            UserType, IframeAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IframeAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::ContentSecurityPolicyPtr parsed_csp_attribute;
  
  bool credentialless;
  
  bool browsing_topics;
  
  bool ad_auction_headers;
  
  bool shared_storage_writable_opted_in;
  
  std::optional<std::string> id;
  
  std::optional<std::string> name;
  
  std::optional<std::string> src;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
SavableSubframePtr SavableSubframe::Clone() const {
  return New(
      mojo::Clone(original_url),
      mojo::Clone(subframe_token)
  );
}

template <typename T, SavableSubframe::EnableIfSame<T>*>
bool SavableSubframe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->subframe_token, other_struct.subframe_token))
    return false;
  return true;
}

template <typename T, SavableSubframe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.original_url < rhs.original_url)
    return true;
  if (rhs.original_url < lhs.original_url)
    return false;
  if (lhs.subframe_token < rhs.subframe_token)
    return true;
  if (rhs.subframe_token < lhs.subframe_token)
    return false;
  return false;
}
template <typename StructPtrType>
GetSavableResourceLinksReplyPtr GetSavableResourceLinksReply::Clone() const {
  return New(
      mojo::Clone(resources_list),
      mojo::Clone(referrer),
      mojo::Clone(subframes)
  );
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>*>
bool GetSavableResourceLinksReply::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resources_list, other_struct.resources_list))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->subframes, other_struct.subframes))
    return false;
  return true;
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resources_list < rhs.resources_list)
    return true;
  if (rhs.resources_list < lhs.resources_list)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.subframes < rhs.subframes)
    return true;
  if (rhs.subframes < lhs.subframes)
    return false;
  return false;
}
template <typename StructPtrType>
FindInPageResultAXParamsPtr FindInPageResultAXParams::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(match_index),
      mojo::Clone(start_id),
      mojo::Clone(start_offset),
      mojo::Clone(end_id),
      mojo::Clone(end_offset)
  );
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>*>
bool FindInPageResultAXParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->match_index, other_struct.match_index))
    return false;
  if (!mojo::Equals(this->start_id, other_struct.start_id))
    return false;
  if (!mojo::Equals(this->start_offset, other_struct.start_offset))
    return false;
  if (!mojo::Equals(this->end_id, other_struct.end_id))
    return false;
  if (!mojo::Equals(this->end_offset, other_struct.end_offset))
    return false;
  return true;
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.match_index < rhs.match_index)
    return true;
  if (rhs.match_index < lhs.match_index)
    return false;
  if (lhs.start_id < rhs.start_id)
    return true;
  if (rhs.start_id < lhs.start_id)
    return false;
  if (lhs.start_offset < rhs.start_offset)
    return true;
  if (rhs.start_offset < lhs.start_offset)
    return false;
  if (lhs.end_id < rhs.end_id)
    return true;
  if (rhs.end_id < lhs.end_id)
    return false;
  if (lhs.end_offset < rhs.end_offset)
    return true;
  if (rhs.end_offset < lhs.end_offset)
    return false;
  return false;
}
template <typename StructPtrType>
DownloadURLParamsPtr DownloadURLParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(referrer),
      mojo::Clone(initiator_origin),
      mojo::Clone(suggested_name),
      mojo::Clone(cross_origin_redirects),
      mojo::Clone(blob_url_token),
      mojo::Clone(data_url_blob),
      mojo::Clone(is_context_menu_save),
      mojo::Clone(has_user_gesture)
  );
}

template <typename T, DownloadURLParams::EnableIfSame<T>*>
bool DownloadURLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->suggested_name, other_struct.suggested_name))
    return false;
  if (!mojo::Equals(this->cross_origin_redirects, other_struct.cross_origin_redirects))
    return false;
  if (!mojo::Equals(this->blob_url_token, other_struct.blob_url_token))
    return false;
  if (!mojo::Equals(this->data_url_blob, other_struct.data_url_blob))
    return false;
  if (!mojo::Equals(this->is_context_menu_save, other_struct.is_context_menu_save))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  return true;
}

template <typename T, DownloadURLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.initiator_origin < rhs.initiator_origin)
    return true;
  if (rhs.initiator_origin < lhs.initiator_origin)
    return false;
  if (lhs.suggested_name < rhs.suggested_name)
    return true;
  if (rhs.suggested_name < lhs.suggested_name)
    return false;
  if (lhs.cross_origin_redirects < rhs.cross_origin_redirects)
    return true;
  if (rhs.cross_origin_redirects < lhs.cross_origin_redirects)
    return false;
  if (lhs.blob_url_token < rhs.blob_url_token)
    return true;
  if (rhs.blob_url_token < lhs.blob_url_token)
    return false;
  if (lhs.data_url_blob < rhs.data_url_blob)
    return true;
  if (rhs.data_url_blob < lhs.data_url_blob)
    return false;
  if (lhs.is_context_menu_save < rhs.is_context_menu_save)
    return true;
  if (rhs.is_context_menu_save < lhs.is_context_menu_save)
    return false;
  if (lhs.has_user_gesture < rhs.has_user_gesture)
    return true;
  if (rhs.has_user_gesture < lhs.has_user_gesture)
    return false;
  return false;
}
template <typename StructPtrType>
IframeAttributesPtr IframeAttributes::Clone() const {
  return New(
      mojo::Clone(parsed_csp_attribute),
      mojo::Clone(credentialless),
      mojo::Clone(browsing_topics),
      mojo::Clone(ad_auction_headers),
      mojo::Clone(shared_storage_writable_opted_in),
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(src)
  );
}

template <typename T, IframeAttributes::EnableIfSame<T>*>
bool IframeAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parsed_csp_attribute, other_struct.parsed_csp_attribute))
    return false;
  if (!mojo::Equals(this->credentialless, other_struct.credentialless))
    return false;
  if (!mojo::Equals(this->browsing_topics, other_struct.browsing_topics))
    return false;
  if (!mojo::Equals(this->ad_auction_headers, other_struct.ad_auction_headers))
    return false;
  if (!mojo::Equals(this->shared_storage_writable_opted_in, other_struct.shared_storage_writable_opted_in))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  return true;
}

template <typename T, IframeAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parsed_csp_attribute < rhs.parsed_csp_attribute)
    return true;
  if (rhs.parsed_csp_attribute < lhs.parsed_csp_attribute)
    return false;
  if (lhs.credentialless < rhs.credentialless)
    return true;
  if (rhs.credentialless < lhs.credentialless)
    return false;
  if (lhs.browsing_topics < rhs.browsing_topics)
    return true;
  if (rhs.browsing_topics < lhs.browsing_topics)
    return false;
  if (lhs.ad_auction_headers < rhs.ad_auction_headers)
    return true;
  if (rhs.ad_auction_headers < lhs.ad_auction_headers)
    return false;
  if (lhs.shared_storage_writable_opted_in < rhs.shared_storage_writable_opted_in)
    return true;
  if (rhs.shared_storage_writable_opted_in < lhs.shared_storage_writable_opted_in)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  return false;
}
template <typename StructPtrType>
LegacyTechEventCodeLocationPtr LegacyTechEventCodeLocation::Clone() const {
  return New(
      mojo::Clone(filename),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>*>
bool LegacyTechEventCodeLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filename, other_struct.filename))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filename < rhs.filename)
    return true;
  if (rhs.filename < lhs.filename)
    return false;
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.column < rhs.column)
    return true;
  if (rhs.column < lhs.column)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SavableSubframe::DataView,
                                         ::blink::mojom::SavableSubframePtr> {
  static bool IsNull(const ::blink::mojom::SavableSubframePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SavableSubframePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SavableSubframe::original_url)& original_url(
      const ::blink::mojom::SavableSubframePtr& input) {
    return input->original_url;
  }

  static const decltype(::blink::mojom::SavableSubframe::subframe_token)& subframe_token(
      const ::blink::mojom::SavableSubframePtr& input) {
    return input->subframe_token;
  }

  static bool Read(::blink::mojom::SavableSubframe::DataView input, ::blink::mojom::SavableSubframePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::GetSavableResourceLinksReply::DataView,
                                         ::blink::mojom::GetSavableResourceLinksReplyPtr> {
  static bool IsNull(const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetSavableResourceLinksReplyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::GetSavableResourceLinksReply::resources_list)& resources_list(
      const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) {
    return input->resources_list;
  }

  static const decltype(::blink::mojom::GetSavableResourceLinksReply::referrer)& referrer(
      const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::GetSavableResourceLinksReply::subframes)& subframes(
      const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) {
    return input->subframes;
  }

  static bool Read(::blink::mojom::GetSavableResourceLinksReply::DataView input, ::blink::mojom::GetSavableResourceLinksReplyPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FindInPageResultAXParams::DataView,
                                         ::blink::mojom::FindInPageResultAXParamsPtr> {
  static bool IsNull(const ::blink::mojom::FindInPageResultAXParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FindInPageResultAXParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::FindInPageResultAXParams::request_id) request_id(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->request_id;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::match_index) match_index(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->match_index;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::start_id) start_id(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->start_id;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::start_offset) start_offset(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->start_offset;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::end_id) end_id(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->end_id;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::end_offset) end_offset(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->end_offset;
  }

  static bool Read(::blink::mojom::FindInPageResultAXParams::DataView input, ::blink::mojom::FindInPageResultAXParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DownloadURLParams::DataView,
                                         ::blink::mojom::DownloadURLParamsPtr> {
  static bool IsNull(const ::blink::mojom::DownloadURLParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DownloadURLParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DownloadURLParams::url)& url(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::DownloadURLParams::referrer)& referrer(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::DownloadURLParams::initiator_origin)& initiator_origin(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::blink::mojom::DownloadURLParams::suggested_name)& suggested_name(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->suggested_name;
  }

  static decltype(::blink::mojom::DownloadURLParams::cross_origin_redirects) cross_origin_redirects(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->cross_origin_redirects;
  }

  static  decltype(::blink::mojom::DownloadURLParams::blob_url_token)& blob_url_token(
       ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->blob_url_token;
  }

  static  decltype(::blink::mojom::DownloadURLParams::data_url_blob)& data_url_blob(
       ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->data_url_blob;
  }

  static decltype(::blink::mojom::DownloadURLParams::is_context_menu_save) is_context_menu_save(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->is_context_menu_save;
  }

  static decltype(::blink::mojom::DownloadURLParams::has_user_gesture) has_user_gesture(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->has_user_gesture;
  }

  static bool Read(::blink::mojom::DownloadURLParams::DataView input, ::blink::mojom::DownloadURLParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IframeAttributes::DataView,
                                         ::blink::mojom::IframeAttributesPtr> {
  static bool IsNull(const ::blink::mojom::IframeAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IframeAttributesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IframeAttributes::parsed_csp_attribute)& parsed_csp_attribute(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->parsed_csp_attribute;
  }

  static decltype(::blink::mojom::IframeAttributes::credentialless) credentialless(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->credentialless;
  }

  static decltype(::blink::mojom::IframeAttributes::browsing_topics) browsing_topics(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->browsing_topics;
  }

  static decltype(::blink::mojom::IframeAttributes::ad_auction_headers) ad_auction_headers(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->ad_auction_headers;
  }

  static decltype(::blink::mojom::IframeAttributes::shared_storage_writable_opted_in) shared_storage_writable_opted_in(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->shared_storage_writable_opted_in;
  }

  static const decltype(::blink::mojom::IframeAttributes::id)& id(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::IframeAttributes::name)& name(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::IframeAttributes::src)& src(
      const ::blink::mojom::IframeAttributesPtr& input) {
    return input->src;
  }

  static bool Read(::blink::mojom::IframeAttributes::DataView input, ::blink::mojom::IframeAttributesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::LegacyTechEventCodeLocation::DataView,
                                         ::blink::mojom::LegacyTechEventCodeLocationPtr> {
  static bool IsNull(const ::blink::mojom::LegacyTechEventCodeLocationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::LegacyTechEventCodeLocationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::LegacyTechEventCodeLocation::filename)& filename(
      const ::blink::mojom::LegacyTechEventCodeLocationPtr& input) {
    return input->filename;
  }

  static decltype(::blink::mojom::LegacyTechEventCodeLocation::line) line(
      const ::blink::mojom::LegacyTechEventCodeLocationPtr& input) {
    return input->line;
  }

  static decltype(::blink::mojom::LegacyTechEventCodeLocation::column) column(
      const ::blink::mojom::LegacyTechEventCodeLocationPtr& input) {
    return input->column;
  }

  static bool Read(::blink::mojom::LegacyTechEventCodeLocation::DataView input, ::blink::mojom::LegacyTechEventCodeLocationPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_H_