// services/viz/privileged/mojom/compositing/layered_window_updater.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom-test-utils.h"


namespace viz::mojom {
const char LayeredWindowUpdater::Name_[] = "viz.mojom.LayeredWindowUpdater";

LayeredWindowUpdater::IPCStableHashFunction LayeredWindowUpdater::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LayeredWindowUpdater>(message.name())) {
    case messages::LayeredWindowUpdater::kOnAllocatedSharedMemory: {
      return &LayeredWindowUpdater::OnAllocatedSharedMemory_Sym::IPCStableHash;
    }
    case messages::LayeredWindowUpdater::kDraw: {
      return &LayeredWindowUpdater::Draw_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LayeredWindowUpdater::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LayeredWindowUpdater>(message.name())) {
      case messages::LayeredWindowUpdater::kOnAllocatedSharedMemory:
            return "Receive viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory";
      case messages::LayeredWindowUpdater::kDraw:
            return "Receive viz::mojom::LayeredWindowUpdater::Draw";
    }
  } else {
    switch (static_cast<messages::LayeredWindowUpdater>(message.name())) {
      case messages::LayeredWindowUpdater::kOnAllocatedSharedMemory:
            return "Receive reply viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory";
      case messages::LayeredWindowUpdater::kDraw:
            return "Receive reply viz::mojom::LayeredWindowUpdater::Draw";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LayeredWindowUpdater::OnAllocatedSharedMemory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LayeredWindowUpdater::Draw_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::LayeredWindowUpdater::Draw");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LayeredWindowUpdater_Draw_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LayeredWindowUpdater_Draw_ForwardToCallback(
      LayeredWindowUpdater::DrawCallback callback
      ) : callback_(std::move(callback)) {
  }

  LayeredWindowUpdater_Draw_ForwardToCallback(const LayeredWindowUpdater_Draw_ForwardToCallback&) = delete;
  LayeredWindowUpdater_Draw_ForwardToCallback& operator=(const LayeredWindowUpdater_Draw_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LayeredWindowUpdater::DrawCallback callback_;
};

LayeredWindowUpdaterProxy::LayeredWindowUpdaterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LayeredWindowUpdaterProxy::OnAllocatedSharedMemory(
    const ::gfx::Size& in_pixel_size, ::base::UnsafeSharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::LayeredWindowUpdater::OnAllocatedSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pixel_size"), in_pixel_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayeredWindowUpdater::kOnAllocatedSharedMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pixel_size)::BaseType> pixel_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_pixel_size, pixel_size_fragment);
  params->pixel_size.Set(
      pixel_size_fragment.is_null() ? nullptr : pixel_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pixel_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_size in LayeredWindowUpdater.OnAllocatedSharedMemory request");
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in LayeredWindowUpdater.OnAllocatedSharedMemory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayeredWindowUpdater::Name_);
  message.set_method_name("OnAllocatedSharedMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LayeredWindowUpdaterProxy::Draw(
    DrawCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::LayeredWindowUpdater::Draw");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayeredWindowUpdater::kDraw), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayeredWindowUpdater_Draw_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayeredWindowUpdater::Name_);
  message.set_method_name("Draw");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LayeredWindowUpdater_Draw_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LayeredWindowUpdater_Draw_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LayeredWindowUpdater::DrawCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LayeredWindowUpdater_Draw_ProxyToResponder> proxy(
        new LayeredWindowUpdater_Draw_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LayeredWindowUpdater_Draw_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LayeredWindowUpdater_Draw_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LayeredWindowUpdater_Draw_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LayeredWindowUpdater::DrawCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LayeredWindowUpdater_Draw_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LayeredWindowUpdater_Draw_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LayeredWindowUpdater_Draw_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for LayeredWindowUpdater.1
  bool success = true;
  LayeredWindowUpdater_Draw_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LayeredWindowUpdater::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LayeredWindowUpdater_Draw_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply viz::mojom::LayeredWindowUpdater::Draw");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayeredWindowUpdater::kDraw), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayeredWindowUpdater_Draw_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayeredWindowUpdater::Name_);
  message.set_method_name("Draw");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LayeredWindowUpdaterStubDispatch::Accept(
    LayeredWindowUpdater* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LayeredWindowUpdater>(message->header()->name)) {
    case messages::LayeredWindowUpdater::kOnAllocatedSharedMemory: {
      DCHECK(message->is_serialized());
      internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data* params =
          reinterpret_cast<internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for LayeredWindowUpdater.0
      bool success = true;
      ::gfx::Size p_pixel_size{};
      ::base::UnsafeSharedMemoryRegion p_region{};
      LayeredWindowUpdater_OnAllocatedSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPixelSize(&p_pixel_size))
        success = false;
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayeredWindowUpdater::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAllocatedSharedMemory(        
        std::move(p_pixel_size), 
        std::move(p_region));
      return true;
    }
    case messages::LayeredWindowUpdater::kDraw: {
      break;
    }
  }
  return false;
}

// static
bool LayeredWindowUpdaterStubDispatch::AcceptWithResponder(
    LayeredWindowUpdater* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LayeredWindowUpdater>(message->header()->name)) {
    case messages::LayeredWindowUpdater::kOnAllocatedSharedMemory: {
      break;
    }
    case messages::LayeredWindowUpdater::kDraw: {
      internal::LayeredWindowUpdater_Draw_Params_Data* params =
          reinterpret_cast<
              internal::LayeredWindowUpdater_Draw_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for LayeredWindowUpdater.1
      bool success = true;
      LayeredWindowUpdater_Draw_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayeredWindowUpdater::Name_, 1, false);
        return false;
      }
      LayeredWindowUpdater::DrawCallback callback =
          LayeredWindowUpdater_Draw_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Draw(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLayeredWindowUpdaterValidationInfo[] = {
    {base::to_underlying(messages::LayeredWindowUpdater::kOnAllocatedSharedMemory),
     { &internal::LayeredWindowUpdater_OnAllocatedSharedMemory_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::LayeredWindowUpdater::kDraw),
     { &internal::LayeredWindowUpdater_Draw_Params_Data::Validate,
      &internal::LayeredWindowUpdater_Draw_ResponseParams_Data::Validate}},
};

bool LayeredWindowUpdaterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::LayeredWindowUpdater::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLayeredWindowUpdaterValidationInfo);
}

bool LayeredWindowUpdaterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::LayeredWindowUpdater::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLayeredWindowUpdaterValidationInfo);

}


}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void LayeredWindowUpdaterInterceptorForTesting::OnAllocatedSharedMemory(const ::gfx::Size& pixel_size, ::base::UnsafeSharedMemoryRegion region) {
  GetForwardingInterface()->OnAllocatedSharedMemory(
    std::move(pixel_size)
    , 
    std::move(region)
    );
}
void LayeredWindowUpdaterInterceptorForTesting::Draw(DrawCallback callback) {
  GetForwardingInterface()->Draw(std::move(callback));
}
LayeredWindowUpdaterAsyncWaiter::LayeredWindowUpdaterAsyncWaiter(
    LayeredWindowUpdater* proxy) : proxy_(proxy) {}

LayeredWindowUpdaterAsyncWaiter::~LayeredWindowUpdaterAsyncWaiter() = default;

void LayeredWindowUpdaterAsyncWaiter::Draw(
    ) {
  base::RunLoop loop;
  proxy_->Draw(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif