// media/mojo/mojom/speech_recognizer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognizer.mojom-shared-internal.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_error.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_grammar.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_result.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class StartSpeechRecognitionRequestParamsDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::StartSpeechRecognitionRequestParamsDataView> {
  using Data = ::media::mojom::internal::StartSpeechRecognitionRequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class SpeechRecognizerInterfaceBase {};

using SpeechRecognizerPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognizerInterfaceBase>;
using SpeechRecognizerRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognizerInterfaceBase>;
using SpeechRecognizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognizerInterfaceBase>;
using SpeechRecognizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognizerInterfaceBase>;
class OnDeviceSpeechRecognitionInterfaceBase {};

using OnDeviceSpeechRecognitionPtrDataView =
    mojo::InterfacePtrDataView<OnDeviceSpeechRecognitionInterfaceBase>;
using OnDeviceSpeechRecognitionRequestDataView =
    mojo::InterfaceRequestDataView<OnDeviceSpeechRecognitionInterfaceBase>;
using OnDeviceSpeechRecognitionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OnDeviceSpeechRecognitionInterfaceBase>;
using OnDeviceSpeechRecognitionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OnDeviceSpeechRecognitionInterfaceBase>;
class SpeechRecognitionSessionInterfaceBase {};

using SpeechRecognitionSessionPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSessionInterfaceBase>;
using SpeechRecognitionSessionRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSessionInterfaceBase>;
using SpeechRecognitionSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSessionInterfaceBase>;
using SpeechRecognitionSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSessionInterfaceBase>;
class SpeechRecognitionSessionClientInterfaceBase {};

using SpeechRecognitionSessionClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSessionClientInterfaceBase>;
using SpeechRecognitionSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSessionClientInterfaceBase>;
using SpeechRecognitionSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSessionClientInterfaceBase>;
using SpeechRecognitionSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSessionClientInterfaceBase>;


class StartSpeechRecognitionRequestParamsDataView {
 public:
  StartSpeechRecognitionRequestParamsDataView() = default;

  StartSpeechRecognitionRequestParamsDataView(
      internal::StartSpeechRecognitionRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSessionReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionSessionInterfaceBase>>(
            &data_->session_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionSessionClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGrammarsDataView(
      mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGrammars(UserType* output) {
    
    auto* pointer = data_->grammars.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>>(
        pointer, output, message_);
  }
  inline void GetRecognitionContextDataView(
      ::media::mojom::SpeechRecognitionRecognitionContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::SpeechRecognitionRecognitionContextDataView, UserType>(),
    "Attempting to read the optional `recognition_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecognitionContext` instead "
    "of `ReadRecognitionContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recognition_context.Get();
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
        pointer, output, message_);
  }
  uint32_t max_hypotheses() const {
    return data_->max_hypotheses;
  }
  bool continuous() const {
    return data_->continuous;
  }
  bool interim_results() const {
    return data_->interim_results;
  }
  bool on_device() const {
    return data_->on_device;
  }
  bool allow_cloud_fallback() const {
    return data_->allow_cloud_fallback;
  }
  template <typename UserType>
  UserType TakeAudioForwarder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionAudioForwarderInterfaceBase>>(
            &data_->audio_forwarder, &result, message_);
    DCHECK(ret);
    return result;
  }
  int32_t channel_count() const {
    return data_->channel_count;
  }
  int32_t sample_rate() const {
    return data_->sample_rate;
  }
 private:
  internal::StartSpeechRecognitionRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::StartSpeechRecognitionRequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::StartSpeechRecognitionRequestParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::StartSpeechRecognitionRequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::session_receiver(input)) in_session_receiver = Traits::session_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionSessionInterfaceBase>>(
        in_session_receiver, &fragment->session_receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->session_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid session_receiver in StartSpeechRecognitionRequestParams struct");
    decltype(Traits::client(input)) in_client = Traits::client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionSessionClientInterfaceBase>>(
        in_client, &fragment->client, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->client),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client in StartSpeechRecognitionRequestParams struct");
    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_language, language_fragment);
    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->language.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in StartSpeechRecognitionRequestParams struct");
    decltype(Traits::grammars(input)) in_grammars = Traits::grammars(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->grammars)::BaseType>
        grammars_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& grammars_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>>(
        in_grammars, grammars_fragment, &grammars_validate_params);
    fragment->grammars.Set(
        grammars_fragment.is_null() ? nullptr : grammars_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->grammars.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null grammars in StartSpeechRecognitionRequestParams struct");
    decltype(Traits::recognition_context(input)) in_recognition_context = Traits::recognition_context(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recognition_context)::BaseType> recognition_context_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
        in_recognition_context, recognition_context_fragment);
    fragment->recognition_context.Set(
        recognition_context_fragment.is_null() ? nullptr : recognition_context_fragment.data());
    fragment->max_hypotheses = Traits::max_hypotheses(input);
    fragment->continuous = Traits::continuous(input);
    fragment->interim_results = Traits::interim_results(input);
    fragment->on_device = Traits::on_device(input);
    fragment->allow_cloud_fallback = Traits::allow_cloud_fallback(input);
    decltype(Traits::audio_forwarder(input)) in_audio_forwarder = Traits::audio_forwarder(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionAudioForwarderInterfaceBase>>(
        in_audio_forwarder, &fragment->audio_forwarder, &fragment.message());
    fragment->channel_count = Traits::channel_count(input);
    fragment->sample_rate = Traits::sample_rate(input);
  }

  static bool Deserialize(::media::mojom::internal::StartSpeechRecognitionRequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::StartSpeechRecognitionRequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void StartSpeechRecognitionRequestParamsDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StartSpeechRecognitionRequestParamsDataView::GetGrammarsDataView(
    mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>* output) {
  auto pointer = data_->grammars.Get();
  *output = mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>(pointer, message_);
}
inline void StartSpeechRecognitionRequestParamsDataView::GetRecognitionContextDataView(
    ::media::mojom::SpeechRecognitionRecognitionContextDataView* output) {
  auto pointer = data_->recognition_context.Get();
  *output = ::media::mojom::SpeechRecognitionRecognitionContextDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_SHARED_H_