// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_SystemInfo_h
#define content_protocol_SystemInfo_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace SystemInfo {
class GPUDevice;
class Size;
class VideoDecodeAcceleratorCapability;
class VideoEncodeAcceleratorCapability;
using SubsamplingFormat = String;
using ImageType = String;
class ImageDecodeAcceleratorCapability;
class GPUInfo;
class ProcessInfo;

// ------------- Forward and enum declarations.

namespace SubsamplingFormatEnum {
CONTENT_EXPORT extern const char Yuv420[];
CONTENT_EXPORT extern const char Yuv422[];
CONTENT_EXPORT extern const char Yuv444[];
} // namespace SubsamplingFormatEnum

namespace ImageTypeEnum {
CONTENT_EXPORT extern const char Jpeg[];
CONTENT_EXPORT extern const char Webp[];
CONTENT_EXPORT extern const char Unknown[];
} // namespace ImageTypeEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT GPUDevice : public ::crdtp::ProtocolObject<GPUDevice> {
public:
    ~GPUDevice() override { }

    double GetVendorId() { return m_vendorId; }
    void SetVendorId(double value) { m_vendorId = value; }

    double GetDeviceId() { return m_deviceId; }
    void SetDeviceId(double value) { m_deviceId = value; }

    bool HasSubSysId() { return !!m_subSysId; }
    double GetSubSysId(double defaultValue) const {
       return m_subSysId.value_or(defaultValue);
    }
    const std::optional<double>& GetSubSysId() const {
       return m_subSysId;
    }
    void SetSubSysId(double value) { m_subSysId = value; }

    bool HasRevision() { return !!m_revision; }
    double GetRevision(double defaultValue) const {
       return m_revision.value_or(defaultValue);
    }
    const std::optional<double>& GetRevision() const {
       return m_revision;
    }
    void SetRevision(double value) { m_revision = value; }

    String GetVendorString() { return m_vendorString; }
    void SetVendorString(const String& value) { m_vendorString = value; }

    String GetDeviceString() { return m_deviceString; }
    void SetDeviceString(const String& value) { m_deviceString = value; }

    String GetDriverVendor() { return m_driverVendor; }
    void SetDriverVendor(const String& value) { m_driverVendor = value; }

    String GetDriverVersion() { return m_driverVersion; }
    void SetDriverVersion(const String& value) { m_driverVersion = value; }

    template<int STATE>
    class GPUDeviceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            VendorIdSet = 1 << 1,
            DeviceIdSet = 1 << 2,
            VendorStringSet = 1 << 3,
            DeviceStringSet = 1 << 4,
            DriverVendorSet = 1 << 5,
            DriverVersionSet = 1 << 6,
            AllFieldsSet = (VendorIdSet | DeviceIdSet | VendorStringSet | DeviceStringSet | DriverVendorSet | DriverVersionSet | 0)};


        GPUDeviceBuilder<STATE | VendorIdSet>& SetVendorId(double value)
        {
            static_assert(!(STATE & VendorIdSet), "property vendorId should not be set yet");
            m_result->SetVendorId(value);
            return castState<VendorIdSet>();
        }

        GPUDeviceBuilder<STATE | DeviceIdSet>& SetDeviceId(double value)
        {
            static_assert(!(STATE & DeviceIdSet), "property deviceId should not be set yet");
            m_result->SetDeviceId(value);
            return castState<DeviceIdSet>();
        }

        GPUDeviceBuilder<STATE>& SetSubSysId(double value)
        {
            m_result->SetSubSysId(value);
            return *this;
        }

        GPUDeviceBuilder<STATE>& SetRevision(double value)
        {
            m_result->SetRevision(value);
            return *this;
        }

        GPUDeviceBuilder<STATE | VendorStringSet>& SetVendorString(const String& value)
        {
            static_assert(!(STATE & VendorStringSet), "property vendorString should not be set yet");
            m_result->SetVendorString(value);
            return castState<VendorStringSet>();
        }

        GPUDeviceBuilder<STATE | DeviceStringSet>& SetDeviceString(const String& value)
        {
            static_assert(!(STATE & DeviceStringSet), "property deviceString should not be set yet");
            m_result->SetDeviceString(value);
            return castState<DeviceStringSet>();
        }

        GPUDeviceBuilder<STATE | DriverVendorSet>& SetDriverVendor(const String& value)
        {
            static_assert(!(STATE & DriverVendorSet), "property driverVendor should not be set yet");
            m_result->SetDriverVendor(value);
            return castState<DriverVendorSet>();
        }

        GPUDeviceBuilder<STATE | DriverVersionSet>& SetDriverVersion(const String& value)
        {
            static_assert(!(STATE & DriverVersionSet), "property driverVersion should not be set yet");
            m_result->SetDriverVersion(value);
            return castState<DriverVersionSet>();
        }

        std::unique_ptr<GPUDevice> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GPUDevice;
        GPUDeviceBuilder() : m_result(new GPUDevice()) { }

        template<int STEP> GPUDeviceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GPUDeviceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::GPUDevice> m_result;
    };

    static GPUDeviceBuilder<0> Create()
    {
        return GPUDeviceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GPUDevice()
    {
          m_vendorId = 0;
          m_deviceId = 0;
    }

    double m_vendorId;
    double m_deviceId;
    std::optional<double> m_subSysId;
    std::optional<double> m_revision;
    String m_vendorString;
    String m_deviceString;
    String m_driverVendor;
    String m_driverVersion;
};


class CONTENT_EXPORT Size : public ::crdtp::ProtocolObject<Size> {
public:
    ~Size() override { }

    int GetWidth() { return m_width; }
    void SetWidth(int value) { m_width = value; }

    int GetHeight() { return m_height; }
    void SetHeight(int value) { m_height = value; }

    template<int STATE>
    class SizeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            WidthSet = 1 << 1,
            HeightSet = 1 << 2,
            AllFieldsSet = (WidthSet | HeightSet | 0)};


        SizeBuilder<STATE | WidthSet>& SetWidth(int value)
        {
            static_assert(!(STATE & WidthSet), "property width should not be set yet");
            m_result->SetWidth(value);
            return castState<WidthSet>();
        }

        SizeBuilder<STATE | HeightSet>& SetHeight(int value)
        {
            static_assert(!(STATE & HeightSet), "property height should not be set yet");
            m_result->SetHeight(value);
            return castState<HeightSet>();
        }

        std::unique_ptr<Size> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Size;
        SizeBuilder() : m_result(new Size()) { }

        template<int STEP> SizeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SizeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::Size> m_result;
    };

    static SizeBuilder<0> Create()
    {
        return SizeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Size()
    {
          m_width = 0;
          m_height = 0;
    }

    int m_width;
    int m_height;
};


class CONTENT_EXPORT VideoDecodeAcceleratorCapability : public ::crdtp::ProtocolObject<VideoDecodeAcceleratorCapability> {
public:
    ~VideoDecodeAcceleratorCapability() override { }

    String GetProfile() { return m_profile; }
    void SetProfile(const String& value) { m_profile = value; }

    protocol::SystemInfo::Size* GetMaxResolution() { return m_maxResolution.get(); }
    void SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value) { m_maxResolution = std::move(value); }

    protocol::SystemInfo::Size* GetMinResolution() { return m_minResolution.get(); }
    void SetMinResolution(std::unique_ptr<protocol::SystemInfo::Size> value) { m_minResolution = std::move(value); }

    template<int STATE>
    class VideoDecodeAcceleratorCapabilityBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProfileSet = 1 << 1,
            MaxResolutionSet = 1 << 2,
            MinResolutionSet = 1 << 3,
            AllFieldsSet = (ProfileSet | MaxResolutionSet | MinResolutionSet | 0)};


        VideoDecodeAcceleratorCapabilityBuilder<STATE | ProfileSet>& SetProfile(const String& value)
        {
            static_assert(!(STATE & ProfileSet), "property profile should not be set yet");
            m_result->SetProfile(value);
            return castState<ProfileSet>();
        }

        VideoDecodeAcceleratorCapabilityBuilder<STATE | MaxResolutionSet>& SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value)
        {
            static_assert(!(STATE & MaxResolutionSet), "property maxResolution should not be set yet");
            m_result->SetMaxResolution(std::move(value));
            return castState<MaxResolutionSet>();
        }

        VideoDecodeAcceleratorCapabilityBuilder<STATE | MinResolutionSet>& SetMinResolution(std::unique_ptr<protocol::SystemInfo::Size> value)
        {
            static_assert(!(STATE & MinResolutionSet), "property minResolution should not be set yet");
            m_result->SetMinResolution(std::move(value));
            return castState<MinResolutionSet>();
        }

        std::unique_ptr<VideoDecodeAcceleratorCapability> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VideoDecodeAcceleratorCapability;
        VideoDecodeAcceleratorCapabilityBuilder() : m_result(new VideoDecodeAcceleratorCapability()) { }

        template<int STEP> VideoDecodeAcceleratorCapabilityBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VideoDecodeAcceleratorCapabilityBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::VideoDecodeAcceleratorCapability> m_result;
    };

    static VideoDecodeAcceleratorCapabilityBuilder<0> Create()
    {
        return VideoDecodeAcceleratorCapabilityBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VideoDecodeAcceleratorCapability()
    {
    }

    String m_profile;
    std::unique_ptr<protocol::SystemInfo::Size> m_maxResolution;
    std::unique_ptr<protocol::SystemInfo::Size> m_minResolution;
};


class CONTENT_EXPORT VideoEncodeAcceleratorCapability : public ::crdtp::ProtocolObject<VideoEncodeAcceleratorCapability> {
public:
    ~VideoEncodeAcceleratorCapability() override { }

    String GetProfile() { return m_profile; }
    void SetProfile(const String& value) { m_profile = value; }

    protocol::SystemInfo::Size* GetMaxResolution() { return m_maxResolution.get(); }
    void SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value) { m_maxResolution = std::move(value); }

    int GetMaxFramerateNumerator() { return m_maxFramerateNumerator; }
    void SetMaxFramerateNumerator(int value) { m_maxFramerateNumerator = value; }

    int GetMaxFramerateDenominator() { return m_maxFramerateDenominator; }
    void SetMaxFramerateDenominator(int value) { m_maxFramerateDenominator = value; }

    template<int STATE>
    class VideoEncodeAcceleratorCapabilityBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProfileSet = 1 << 1,
            MaxResolutionSet = 1 << 2,
            MaxFramerateNumeratorSet = 1 << 3,
            MaxFramerateDenominatorSet = 1 << 4,
            AllFieldsSet = (ProfileSet | MaxResolutionSet | MaxFramerateNumeratorSet | MaxFramerateDenominatorSet | 0)};


        VideoEncodeAcceleratorCapabilityBuilder<STATE | ProfileSet>& SetProfile(const String& value)
        {
            static_assert(!(STATE & ProfileSet), "property profile should not be set yet");
            m_result->SetProfile(value);
            return castState<ProfileSet>();
        }

        VideoEncodeAcceleratorCapabilityBuilder<STATE | MaxResolutionSet>& SetMaxResolution(std::unique_ptr<protocol::SystemInfo::Size> value)
        {
            static_assert(!(STATE & MaxResolutionSet), "property maxResolution should not be set yet");
            m_result->SetMaxResolution(std::move(value));
            return castState<MaxResolutionSet>();
        }

        VideoEncodeAcceleratorCapabilityBuilder<STATE | MaxFramerateNumeratorSet>& SetMaxFramerateNumerator(int value)
        {
            static_assert(!(STATE & MaxFramerateNumeratorSet), "property maxFramerateNumerator should not be set yet");
            m_result->SetMaxFramerateNumerator(value);
            return castState<MaxFramerateNumeratorSet>();
        }

        VideoEncodeAcceleratorCapabilityBuilder<STATE | MaxFramerateDenominatorSet>& SetMaxFramerateDenominator(int value)
        {
            static_assert(!(STATE & MaxFramerateDenominatorSet), "property maxFramerateDenominator should not be set yet");
            m_result->SetMaxFramerateDenominator(value);
            return castState<MaxFramerateDenominatorSet>();
        }

        std::unique_ptr<VideoEncodeAcceleratorCapability> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VideoEncodeAcceleratorCapability;
        VideoEncodeAcceleratorCapabilityBuilder() : m_result(new VideoEncodeAcceleratorCapability()) { }

        template<int STEP> VideoEncodeAcceleratorCapabilityBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VideoEncodeAcceleratorCapabilityBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::VideoEncodeAcceleratorCapability> m_result;
    };

    static VideoEncodeAcceleratorCapabilityBuilder<0> Create()
    {
        return VideoEncodeAcceleratorCapabilityBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VideoEncodeAcceleratorCapability()
    {
          m_maxFramerateNumerator = 0;
          m_maxFramerateDenominator = 0;
    }

    String m_profile;
    std::unique_ptr<protocol::SystemInfo::Size> m_maxResolution;
    int m_maxFramerateNumerator;
    int m_maxFramerateDenominator;
};


class CONTENT_EXPORT ImageDecodeAcceleratorCapability : public ::crdtp::ProtocolObject<ImageDecodeAcceleratorCapability> {
public:
    ~ImageDecodeAcceleratorCapability() override { }

    String GetImageType() { return m_imageType; }
    void SetImageType(const String& value) { m_imageType = value; }

    protocol::SystemInfo::Size* GetMaxDimensions() { return m_maxDimensions.get(); }
    void SetMaxDimensions(std::unique_ptr<protocol::SystemInfo::Size> value) { m_maxDimensions = std::move(value); }

    protocol::SystemInfo::Size* GetMinDimensions() { return m_minDimensions.get(); }
    void SetMinDimensions(std::unique_ptr<protocol::SystemInfo::Size> value) { m_minDimensions = std::move(value); }

    protocol::Array<String>* GetSubsamplings() { return m_subsamplings.get(); }
    void SetSubsamplings(std::unique_ptr<protocol::Array<String>> value) { m_subsamplings = std::move(value); }

    template<int STATE>
    class ImageDecodeAcceleratorCapabilityBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ImageTypeSet = 1 << 1,
            MaxDimensionsSet = 1 << 2,
            MinDimensionsSet = 1 << 3,
            SubsamplingsSet = 1 << 4,
            AllFieldsSet = (ImageTypeSet | MaxDimensionsSet | MinDimensionsSet | SubsamplingsSet | 0)};


        ImageDecodeAcceleratorCapabilityBuilder<STATE | ImageTypeSet>& SetImageType(const String& value)
        {
            static_assert(!(STATE & ImageTypeSet), "property imageType should not be set yet");
            m_result->SetImageType(value);
            return castState<ImageTypeSet>();
        }

        ImageDecodeAcceleratorCapabilityBuilder<STATE | MaxDimensionsSet>& SetMaxDimensions(std::unique_ptr<protocol::SystemInfo::Size> value)
        {
            static_assert(!(STATE & MaxDimensionsSet), "property maxDimensions should not be set yet");
            m_result->SetMaxDimensions(std::move(value));
            return castState<MaxDimensionsSet>();
        }

        ImageDecodeAcceleratorCapabilityBuilder<STATE | MinDimensionsSet>& SetMinDimensions(std::unique_ptr<protocol::SystemInfo::Size> value)
        {
            static_assert(!(STATE & MinDimensionsSet), "property minDimensions should not be set yet");
            m_result->SetMinDimensions(std::move(value));
            return castState<MinDimensionsSet>();
        }

        ImageDecodeAcceleratorCapabilityBuilder<STATE | SubsamplingsSet>& SetSubsamplings(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & SubsamplingsSet), "property subsamplings should not be set yet");
            m_result->SetSubsamplings(std::move(value));
            return castState<SubsamplingsSet>();
        }

        std::unique_ptr<ImageDecodeAcceleratorCapability> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ImageDecodeAcceleratorCapability;
        ImageDecodeAcceleratorCapabilityBuilder() : m_result(new ImageDecodeAcceleratorCapability()) { }

        template<int STEP> ImageDecodeAcceleratorCapabilityBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ImageDecodeAcceleratorCapabilityBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::ImageDecodeAcceleratorCapability> m_result;
    };

    static ImageDecodeAcceleratorCapabilityBuilder<0> Create()
    {
        return ImageDecodeAcceleratorCapabilityBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ImageDecodeAcceleratorCapability()
    {
    }

    String m_imageType;
    std::unique_ptr<protocol::SystemInfo::Size> m_maxDimensions;
    std::unique_ptr<protocol::SystemInfo::Size> m_minDimensions;
    std::unique_ptr<protocol::Array<String>> m_subsamplings;
};


class CONTENT_EXPORT GPUInfo : public ::crdtp::ProtocolObject<GPUInfo> {
public:
    ~GPUInfo() override { }

    protocol::Array<protocol::SystemInfo::GPUDevice>* GetDevices() { return m_devices.get(); }
    void SetDevices(std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> value) { m_devices = std::move(value); }

    bool HasAuxAttributes() { return !!m_auxAttributes; }
    protocol::DictionaryValue* GetAuxAttributes(protocol::DictionaryValue* defaultValue) {
       return m_auxAttributes ? m_auxAttributes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& GetAuxAttributes() const {
       return m_auxAttributes;
    }
    void SetAuxAttributes(std::unique_ptr<protocol::DictionaryValue> value) { m_auxAttributes = std::move(value); }

    bool HasFeatureStatus() { return !!m_featureStatus; }
    protocol::DictionaryValue* GetFeatureStatus(protocol::DictionaryValue* defaultValue) {
       return m_featureStatus ? m_featureStatus.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DictionaryValue>& GetFeatureStatus() const {
       return m_featureStatus;
    }
    void SetFeatureStatus(std::unique_ptr<protocol::DictionaryValue> value) { m_featureStatus = std::move(value); }

    protocol::Array<String>* GetDriverBugWorkarounds() { return m_driverBugWorkarounds.get(); }
    void SetDriverBugWorkarounds(std::unique_ptr<protocol::Array<String>> value) { m_driverBugWorkarounds = std::move(value); }

    protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>* GetVideoDecoding() { return m_videoDecoding.get(); }
    void SetVideoDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> value) { m_videoDecoding = std::move(value); }

    protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>* GetVideoEncoding() { return m_videoEncoding.get(); }
    void SetVideoEncoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> value) { m_videoEncoding = std::move(value); }

    protocol::Array<protocol::SystemInfo::ImageDecodeAcceleratorCapability>* GetImageDecoding() { return m_imageDecoding.get(); }
    void SetImageDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::ImageDecodeAcceleratorCapability>> value) { m_imageDecoding = std::move(value); }

    template<int STATE>
    class GPUInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DevicesSet = 1 << 1,
            DriverBugWorkaroundsSet = 1 << 2,
            VideoDecodingSet = 1 << 3,
            VideoEncodingSet = 1 << 4,
            ImageDecodingSet = 1 << 5,
            AllFieldsSet = (DevicesSet | DriverBugWorkaroundsSet | VideoDecodingSet | VideoEncodingSet | ImageDecodingSet | 0)};


        GPUInfoBuilder<STATE | DevicesSet>& SetDevices(std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> value)
        {
            static_assert(!(STATE & DevicesSet), "property devices should not be set yet");
            m_result->SetDevices(std::move(value));
            return castState<DevicesSet>();
        }

        GPUInfoBuilder<STATE>& SetAuxAttributes(std::unique_ptr<protocol::DictionaryValue> value)
        {
            m_result->SetAuxAttributes(std::move(value));
            return *this;
        }

        GPUInfoBuilder<STATE>& SetFeatureStatus(std::unique_ptr<protocol::DictionaryValue> value)
        {
            m_result->SetFeatureStatus(std::move(value));
            return *this;
        }

        GPUInfoBuilder<STATE | DriverBugWorkaroundsSet>& SetDriverBugWorkarounds(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & DriverBugWorkaroundsSet), "property driverBugWorkarounds should not be set yet");
            m_result->SetDriverBugWorkarounds(std::move(value));
            return castState<DriverBugWorkaroundsSet>();
        }

        GPUInfoBuilder<STATE | VideoDecodingSet>& SetVideoDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> value)
        {
            static_assert(!(STATE & VideoDecodingSet), "property videoDecoding should not be set yet");
            m_result->SetVideoDecoding(std::move(value));
            return castState<VideoDecodingSet>();
        }

        GPUInfoBuilder<STATE | VideoEncodingSet>& SetVideoEncoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> value)
        {
            static_assert(!(STATE & VideoEncodingSet), "property videoEncoding should not be set yet");
            m_result->SetVideoEncoding(std::move(value));
            return castState<VideoEncodingSet>();
        }

        GPUInfoBuilder<STATE | ImageDecodingSet>& SetImageDecoding(std::unique_ptr<protocol::Array<protocol::SystemInfo::ImageDecodeAcceleratorCapability>> value)
        {
            static_assert(!(STATE & ImageDecodingSet), "property imageDecoding should not be set yet");
            m_result->SetImageDecoding(std::move(value));
            return castState<ImageDecodingSet>();
        }

        std::unique_ptr<GPUInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GPUInfo;
        GPUInfoBuilder() : m_result(new GPUInfo()) { }

        template<int STEP> GPUInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GPUInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::GPUInfo> m_result;
    };

    static GPUInfoBuilder<0> Create()
    {
        return GPUInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GPUInfo()
    {
    }

    std::unique_ptr<protocol::Array<protocol::SystemInfo::GPUDevice>> m_devices;
    std::unique_ptr<protocol::DictionaryValue> m_auxAttributes;
    std::unique_ptr<protocol::DictionaryValue> m_featureStatus;
    std::unique_ptr<protocol::Array<String>> m_driverBugWorkarounds;
    std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoDecodeAcceleratorCapability>> m_videoDecoding;
    std::unique_ptr<protocol::Array<protocol::SystemInfo::VideoEncodeAcceleratorCapability>> m_videoEncoding;
    std::unique_ptr<protocol::Array<protocol::SystemInfo::ImageDecodeAcceleratorCapability>> m_imageDecoding;
};


class CONTENT_EXPORT ProcessInfo : public ::crdtp::ProtocolObject<ProcessInfo> {
public:
    ~ProcessInfo() override { }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    int GetId() { return m_id; }
    void SetId(int value) { m_id = value; }

    double GetCpuTime() { return m_cpuTime; }
    void SetCpuTime(double value) { m_cpuTime = value; }

    template<int STATE>
    class ProcessInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            IdSet = 1 << 2,
            CpuTimeSet = 1 << 3,
            AllFieldsSet = (TypeSet | IdSet | CpuTimeSet | 0)};


        ProcessInfoBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        ProcessInfoBuilder<STATE | IdSet>& SetId(int value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        ProcessInfoBuilder<STATE | CpuTimeSet>& SetCpuTime(double value)
        {
            static_assert(!(STATE & CpuTimeSet), "property cpuTime should not be set yet");
            m_result->SetCpuTime(value);
            return castState<CpuTimeSet>();
        }

        std::unique_ptr<ProcessInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ProcessInfo;
        ProcessInfoBuilder() : m_result(new ProcessInfo()) { }

        template<int STEP> ProcessInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ProcessInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::SystemInfo::ProcessInfo> m_result;
    };

    static ProcessInfoBuilder<0> Create()
    {
        return ProcessInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ProcessInfo()
    {
          m_id = 0;
          m_cpuTime = 0;
    }

    String m_type;
    int m_id;
    double m_cpuTime;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CONTENT_EXPORT GetInfoCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::SystemInfo::GPUInfo> gpu, const String& modelName, const String& modelVersion, const String& commandLine) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetInfoCallback() { }
    };
    virtual void GetInfo(std::unique_ptr<GetInfoCallback> callback) = 0;
    virtual DispatchResponse GetFeatureState(const String& in_featureState, bool* out_featureEnabled) = 0;
    class CONTENT_EXPORT GetProcessInfoCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::SystemInfo::ProcessInfo>> processInfo) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetProcessInfoCallback() { }
    };
    virtual void GetProcessInfo(std::unique_ptr<GetProcessInfoCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace SystemInfo
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_SystemInfo_h)
