// content/browser/attribution_reporting/attribution_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/attribution_reporting/attribution_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/attribution_reporting/attribution_internals.mojom-params-data.h"
namespace attribution_internals {
namespace mojom {

NOINLINE static const char* WebUISource_AttributabilityToStringHelper(WebUISource_Attributability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebUISource_Attributability::kAttributable:
      return "kAttributable";
    case WebUISource_Attributability::kNoisedNever:
      return "kNoisedNever";
    case WebUISource_Attributability::kNoisedFalsely:
      return "kNoisedFalsely";
    case WebUISource_Attributability::kReachedEventLevelAttributionLimit:
      return "kReachedEventLevelAttributionLimit";
    default:
      return nullptr;
  }
}

std::string WebUISource_AttributabilityToString(WebUISource_Attributability value) {
  const char *str = WebUISource_AttributabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebUISource_Attributability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebUISource_Attributability value) {
  return os << WebUISource_AttributabilityToString(value);
}

namespace internal {
// static
bool WebUIReportData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebUIReportData_Data* object = static_cast<const WebUIReportData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebUIReportData_Tag::kEventLevelData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_event_level_data, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_event_level_data, validation_context))
        return false;
      return true;
    }
    case WebUIReportData_Tag::kAggregatableAttributionData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_aggregatable_attribution_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_aggregatable_attribution_data, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebUIReportData");
      return false;
    }
  }
}
// static
bool NetworkStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const NetworkStatus_Data* object = static_cast<const NetworkStatus_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case NetworkStatus_Tag::kHttpResponseCode: {

      return true;
    }
    case NetworkStatus_Tag::kNetworkError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_network_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& network_error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_network_error, validation_context,
                                             &network_error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in NetworkStatus");
      return false;
    }
  }
}
// static
bool ReportStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ReportStatus_Data* object = static_cast<const ReportStatus_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ReportStatus_Tag::kPending: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pending, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pending, validation_context))
        return false;
      return true;
    }
    case ReportStatus_Tag::kReplacedByHigherPriorityReport: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_replaced_by_higher_priority_report, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& replaced_by_higher_priority_report_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_replaced_by_higher_priority_report, validation_context,
                                             &replaced_by_higher_priority_report_validate_params)) {
        return false;
      }
      return true;
    }
    case ReportStatus_Tag::kProhibitedByBrowserPolicy: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_prohibited_by_browser_policy, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_prohibited_by_browser_policy, validation_context))
        return false;
      return true;
    }
    case ReportStatus_Tag::kNetworkStatus: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_network_status, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_network_status,
                                                   validation_context))
        return false;
      return true;
    }
    case ReportStatus_Tag::kFailedToAssemble: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failed_to_assemble, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failed_to_assemble, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ReportStatus");
      return false;
    }
  }
}
// static
bool SendAggregatableDebugReportResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SendAggregatableDebugReportResult_Data* object = static_cast<const SendAggregatableDebugReportResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SendAggregatableDebugReportResult_Tag::kAssemblyFailed: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_assembly_failed, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_assembly_failed, validation_context))
        return false;
      return true;
    }
    case SendAggregatableDebugReportResult_Tag::kNetworkStatus: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_network_status, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_network_status,
                                                   validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SendAggregatableDebugReportResult");
      return false;
    }
  }
}


// static
bool ReportID_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReportID_Data* object =
      static_cast<const ReportID_Data*>(data);

  return true;
}

ReportID_Data::ReportID_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIReportEventLevelData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIReportEventLevelData_Data* object =
      static_cast<const WebUIReportEventLevelData_Data*>(data);

  return true;
}

WebUIReportEventLevelData_Data::WebUIReportEventLevelData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableHistogramContribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableHistogramContribution_Data* object =
      static_cast<const AggregatableHistogramContribution_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

AggregatableHistogramContribution_Data::AggregatableHistogramContribution_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIReportAggregatableAttributionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIReportAggregatableAttributionData_Data* object =
      static_cast<const WebUIReportAggregatableAttributionData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contributions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->contributions, validation_context,
                                         &contributions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregation_coordinator, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregation_coordinator_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregation_coordinator, validation_context,
                                         &aggregation_coordinator_validate_params)) {
    return false;
  }

  return true;
}

WebUIReportAggregatableAttributionData_Data::WebUIReportAggregatableAttributionData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Empty_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Empty_Data* object =
      static_cast<const Empty_Data*>(data);

  return true;
}

Empty_Data::Empty_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIReport_Data* object =
      static_cast<const WebUIReport_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_body, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& report_body_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->report_body, validation_context,
                                         &report_body_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->status, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

WebUIReport_Data::WebUIReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIDebugReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIDebugReport_Data* object =
      static_cast<const WebUIDebugReport_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& body_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->body, validation_context,
                                         &body_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->status, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->status, validation_context))
    return false;

  return true;
}

WebUIDebugReport_Data::WebUIDebugReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIAggregatableDebugReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIAggregatableDebugReport_Data* object =
      static_cast<const WebUIAggregatableDebugReport_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& body_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->body, validation_context,
                                         &body_validate_params)) {
    return false;
  }


  if (!::attribution_reporting::mojom::internal::ProcessAggregatableDebugReportResult_Data
        ::Validate(object->process_result, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->send_result, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->send_result, validation_context))
    return false;

  return true;
}

WebUIAggregatableDebugReport_Data::WebUIAggregatableDebugReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUISource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 184, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUISource_Data* object =
      static_cast<const WebUISource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destinations, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destinations, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trigger_specs_json, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trigger_specs_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trigger_specs_json, validation_context,
                                         &trigger_specs_json_validate_params)) {
    return false;
  }


  if (!::attribution_reporting::mojom::internal::SourceType_Data
        ::Validate(object->source_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dedup_keys, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dedup_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dedup_keys, validation_context,
                                         &dedup_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter_data, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregation_keys, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregation_keys_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->aggregation_keys, validation_context,
                                         &aggregation_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_dedup_keys, 18, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_dedup_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_dedup_keys, validation_context,
                                         &aggregatable_dedup_keys_validate_params)) {
    return false;
  }


  if (!::attribution_reporting::mojom::internal::TriggerDataMatching_Data
        ::Validate(object->trigger_data_matching, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_debug_key_piece, 23, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_debug_key_piece_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_debug_key_piece, validation_context,
                                         &aggregatable_debug_key_piece_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_scopes_data_json, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribution_scopes_data_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribution_scopes_data_json, validation_context,
                                         &attribution_scopes_data_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aggregatable_named_budgets, 25, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aggregatable_named_budgets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->aggregatable_named_budgets, validation_context,
                                         &aggregatable_named_budgets_validate_params)) {
    return false;
  }


  if (!::attribution_internals::mojom::internal::WebUISource_Attributability_Data
        ::Validate(object->attributability, validation_context))
    return false;

  return true;
}

WebUISource_Data::WebUISource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIRegistration_Data* object =
      static_cast<const WebUIRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration_json, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& registration_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->registration_json, validation_context,
                                         &registration_json_validate_params)) {
    return false;
  }

  return true;
}

WebUIRegistration_Data::WebUIRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUITrigger_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUITrigger_Data* object =
      static_cast<const WebUITrigger_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::EventLevelResult_Data
        ::Validate(object->event_level_result, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::AggregatableResult_Data
        ::Validate(object->aggregatable_result, validation_context))
    return false;

  return true;
}

WebUITrigger_Data::WebUITrigger_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUISourceRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUISourceRegistration_Data* object =
      static_cast<const WebUISourceRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::SourceType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::StoreSourceResult_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

WebUISourceRegistration_Data::WebUISourceRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebUIOsRegistration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebUIOsRegistration_Data* object =
      static_cast<const WebUIOsRegistration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_level_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_level_origin, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::RegistrationType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::attribution_reporting::mojom::internal::OsRegistrationResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

WebUIOsRegistration_Data::WebUIOsRegistration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnSourcesChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnSourcesChanged_Params_Data* object =
      static_cast<const Observer_OnSourcesChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  return true;
}

Observer_OnSourcesChanged_Params_Data::Observer_OnSourcesChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnReportsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnReportsChanged_Params_Data* object =
      static_cast<const Observer_OnReportsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reports, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reports, validation_context,
                                         &reports_validate_params)) {
    return false;
  }

  return true;
}

Observer_OnReportsChanged_Params_Data::Observer_OnReportsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnSourceHandled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnSourceHandled_Params_Data* object =
      static_cast<const Observer_OnSourceHandled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source, validation_context))
    return false;

  return true;
}

Observer_OnSourceHandled_Params_Data::Observer_OnSourceHandled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnReportHandled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnReportHandled_Params_Data* object =
      static_cast<const Observer_OnReportHandled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report, validation_context))
    return false;

  return true;
}

Observer_OnReportHandled_Params_Data::Observer_OnReportHandled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnDebugReportSent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnDebugReportSent_Params_Data* object =
      static_cast<const Observer_OnDebugReportSent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report, validation_context))
    return false;

  return true;
}

Observer_OnDebugReportSent_Params_Data::Observer_OnDebugReportSent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnAggregatableDebugReportSent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnAggregatableDebugReportSent_Params_Data* object =
      static_cast<const Observer_OnAggregatableDebugReportSent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report, validation_context))
    return false;

  return true;
}

Observer_OnAggregatableDebugReportSent_Params_Data::Observer_OnAggregatableDebugReportSent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnTriggerHandled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnTriggerHandled_Params_Data* object =
      static_cast<const Observer_OnTriggerHandled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trigger, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->trigger, validation_context))
    return false;

  return true;
}

Observer_OnTriggerHandled_Params_Data::Observer_OnTriggerHandled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnOsRegistration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnOsRegistration_Params_Data* object =
      static_cast<const Observer_OnOsRegistration_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  return true;
}

Observer_OnOsRegistration_Params_Data::Observer_OnOsRegistration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Observer_OnDebugModeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Observer_OnDebugModeChanged_Params_Data* object =
      static_cast<const Observer_OnDebugModeChanged_Params_Data*>(data);

  return true;
}

Observer_OnDebugModeChanged_Params_Data::Observer_OnDebugModeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_IsAttributionReportingEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_IsAttributionReportingEnabled_Params_Data* object =
      static_cast<const Handler_IsAttributionReportingEnabled_Params_Data*>(data);

  return true;
}

Handler_IsAttributionReportingEnabled_Params_Data::Handler_IsAttributionReportingEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_IsAttributionReportingEnabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_IsAttributionReportingEnabled_ResponseParams_Data* object =
      static_cast<const Handler_IsAttributionReportingEnabled_ResponseParams_Data*>(data);


  if (!::network::mojom::internal::AttributionSupport_Data
        ::Validate(object->attribution_support, validation_context))
    return false;

  return true;
}

Handler_IsAttributionReportingEnabled_ResponseParams_Data::Handler_IsAttributionReportingEnabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_SendReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_SendReport_Params_Data* object =
      static_cast<const Handler_SendReport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  return true;
}

Handler_SendReport_Params_Data::Handler_SendReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_SendReport_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_SendReport_ResponseParams_Data* object =
      static_cast<const Handler_SendReport_ResponseParams_Data*>(data);

  return true;
}

Handler_SendReport_ResponseParams_Data::Handler_SendReport_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_ClearStorage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_ClearStorage_Params_Data* object =
      static_cast<const Handler_ClearStorage_Params_Data*>(data);

  return true;
}

Handler_ClearStorage_Params_Data::Handler_ClearStorage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Handler_ClearStorage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Handler_ClearStorage_ResponseParams_Data* object =
      static_cast<const Handler_ClearStorage_ResponseParams_Data*>(data);

  return true;
}

Handler_ClearStorage_ResponseParams_Data::Handler_ClearStorage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Factory_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Factory_Create_Params_Data* object =
      static_cast<const Factory_Create_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Factory_Create_Params_Data::Factory_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace attribution_internals

namespace perfetto {

// static
void TraceFormatTraits<::attribution_internals::mojom::WebUISource_Attributability>::WriteIntoTrace(
   perfetto::TracedValue context, ::attribution_internals::mojom::WebUISource_Attributability value) {
  return std::move(context).WriteString(::attribution_internals::mojom::WebUISource_AttributabilityToString(value));
}

} // namespace perfetto