
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "historyitem_wrapper.h"

// Argument includes
#include <historyitem.h>
#include <qicon.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_HistoryItem_Type = nullptr;
static PyTypeObject *Sbk_HistoryItem_TypeF(void)
{
    return _Sbk_HistoryItem_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_HistoryItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::HistoryItem >()))
        return -1;

    ::HistoryItem *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    if (PyArg_ParseTuple(args, "|O:HistoryItem", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: HistoryItem::HistoryItem(HistoryItem*=)
    if (numArgs == 0) {
        overloadId = 0; // HistoryItem(HistoryItem*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArgs[0])))) {
        overloadId = 0; // HistoryItem(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::HistoryItem *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // HistoryItem(HistoryItem*)
            cptr = new ::HistoryItem(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::HistoryItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_HistoryItemFunc_appendChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::appendChild(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArg)))) {
        overloadId = 0; // appendChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "appendChild", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // appendChild(HistoryItem*)
            cppSelf->appendChild(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_changeParent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::changeParent(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArg)))) {
        overloadId = 0; // changeParent(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "changeParent", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeParent(HistoryItem*)
            cppSelf->changeParent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_child(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::child(int)const->HistoryItem*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // child(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "child", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // child(int)const
            HistoryItem * cppResult = const_cast<const ::HistoryItem *>(cppSelf)->child(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_childCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // childCount()const
        int cppResult = const_cast<const ::HistoryItem *>(cppSelf)->childCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_endTimestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // endTimestamp()const
        qint64 cppResult = const_cast<const ::HistoryItem *>(cppSelf)->endTimestamp();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::HistoryItem *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_indexOfChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::indexOfChild(HistoryItem*)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArg)))) {
        overloadId = 0; // indexOfChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "indexOfChild", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // indexOfChild(HistoryItem*)
            int cppResult = cppSelf->indexOfChild(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_insertChild(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insertChild", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: HistoryItem::insertChild(int,HistoryItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertChild(int,HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertChild", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::HistoryItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertChild(int,HistoryItem*)
            cppSelf->insertChild(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_isTopLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isTopLevel()const
        bool cppResult = const_cast<const ::HistoryItem *>(cppSelf)->isTopLevel();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // parent()const
        HistoryItem * cppResult = const_cast<const ::HistoryItem *>(cppSelf)->parent();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_prependChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::prependChild(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArg)))) {
        overloadId = 0; // prependChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "prependChild", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // prependChild(HistoryItem*)
            cppSelf->prependChild(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_removeChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::removeChild(HistoryItem*)
    // 1: HistoryItem::removeChild(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // removeChild(int)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), (pyArg)))) {
        overloadId = 0; // removeChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeChild", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // removeChild(HistoryItem *child)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::HistoryItem *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // removeChild(HistoryItem*)
                cppSelf->removeChild(cppArg0);
            }
            break;
        }
        case 1: // removeChild(int row)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // removeChild(int)
                cppSelf->removeChild(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_row(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // row()
        int cppResult = cppSelf->row();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryItemFunc_setEndTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::setEndTimestamp(qint64)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setEndTimestamp(qint64)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEndTimestamp", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEndTimestamp(qint64)
            cppSelf->setEndTimestamp(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_setStartTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::setStartTimestamp(qint64)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setStartTimestamp(qint64)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setStartTimestamp", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]);

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStartTimestamp(qint64)
            cppSelf->setStartTimestamp(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryItemFunc_startTimestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startTimestamp()const
        qint64 cppResult = const_cast<const ::HistoryItem *>(cppSelf)->startTimestamp();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_HistoryItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_HistoryItem_methods[] = {
    {"appendChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_appendChild), METH_O, nullptr},
    {"changeParent", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_changeParent), METH_O, nullptr},
    {"child", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_child), METH_O, nullptr},
    {"childCount", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_childCount), METH_NOARGS, nullptr},
    {"endTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_endTimestamp), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_icon), METH_NOARGS, nullptr},
    {"indexOfChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_indexOfChild), METH_O, nullptr},
    {"insertChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_insertChild), METH_VARARGS, nullptr},
    {"isTopLevel", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_isTopLevel), METH_NOARGS, nullptr},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_parent), METH_NOARGS, nullptr},
    {"prependChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_prependChild), METH_O, nullptr},
    {"removeChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_removeChild), METH_O, nullptr},
    {"row", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_row), METH_NOARGS, nullptr},
    {"setEndTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_setEndTimestamp), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_setIcon), METH_O, nullptr},
    {"setStartTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_setStartTimestamp), METH_O, nullptr},
    {"startTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_startTimestamp), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_HistoryItem_get_historyEntry(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->historyEntry), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->historyEntry), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_HistoryItem_set_historyEntry(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("historyEntry");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("historyEntry", "HistoryEntry");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->historyEntry;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_HistoryItem_get_title(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->title);
}
static int Sbk_HistoryItem_set_title(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("title");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("title", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->title;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_HistoryItem_get_canFetchMore(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->canFetchMore;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_HistoryItem_set_canFetchMore(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("canFetchMore");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("canFetchMore", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->canFetchMore;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->canFetchMore = cppOut_local;

    return 0;
}

// Getters and Setters for HistoryItem
static PyGetSetDef Sbk_HistoryItem_getsetlist[] = {
    {const_cast<char *>("historyEntry"), Sbk_HistoryItem_get_historyEntry, Sbk_HistoryItem_set_historyEntry, nullptr, nullptr},
    {const_cast<char *>("title"), Sbk_HistoryItem_get_title, Sbk_HistoryItem_set_title, nullptr, nullptr},
    {const_cast<char *>("canFetchMore"), Sbk_HistoryItem_get_canFetchMore, Sbk_HistoryItem_set_canFetchMore, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_HistoryItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_HistoryItem_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_HistoryItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_HistoryItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_HistoryItem_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_HistoryItem_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_HistoryItem_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_HistoryItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_HistoryItem_spec = {
    "1:PyFalkon.HistoryItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_HistoryItem_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void HistoryItem_PythonToCpp_HistoryItem_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_HistoryItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_HistoryItem_PythonToCpp_HistoryItem_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_HistoryItem_TypeF()))
        return HistoryItem_PythonToCpp_HistoryItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *HistoryItem_PTR_CppToPython_HistoryItem(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_HistoryItem_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_HistoryItem_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *HistoryItem_SignatureStrings[] = {
    "PyFalkon.HistoryItem(self,parent:PyFalkon.HistoryItem=nullptr)",
    "PyFalkon.HistoryItem.appendChild(self,child:PyFalkon.HistoryItem)",
    "PyFalkon.HistoryItem.changeParent(self,parent:PyFalkon.HistoryItem)",
    "PyFalkon.HistoryItem.child(self,row:int)->PyFalkon.HistoryItem",
    "PyFalkon.HistoryItem.childCount(self)->int",
    "PyFalkon.HistoryItem.endTimestamp(self)->qint64",
    "PyFalkon.HistoryItem.icon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.HistoryItem.indexOfChild(self,child:PyFalkon.HistoryItem)->int",
    "PyFalkon.HistoryItem.insertChild(self,row:int,child:PyFalkon.HistoryItem)",
    "PyFalkon.HistoryItem.isTopLevel(self)->bool",
    "PyFalkon.HistoryItem.parent(self)->PyFalkon.HistoryItem",
    "PyFalkon.HistoryItem.prependChild(self,child:PyFalkon.HistoryItem)",
    "1:PyFalkon.HistoryItem.removeChild(self,child:PyFalkon.HistoryItem)",
    "0:PyFalkon.HistoryItem.removeChild(self,row:int)",
    "PyFalkon.HistoryItem.row(self)->int",
    "PyFalkon.HistoryItem.setEndTimestamp(self,end:qint64)",
    "PyFalkon.HistoryItem.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.HistoryItem.setStartTimestamp(self,start:qint64)",
    "PyFalkon.HistoryItem.startTimestamp(self)->qint64",
    nullptr}; // Sentinel
#else
static constexpr size_t HistoryItem_SignatureByteSize = 295;
static constexpr uint8_t HistoryItem_SignatureBytes[295] = {
    0x78, 0xda, 0x95, 0x53, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0xbc, 0xf3, 0x15, 0x1c, 0x89, 0x14, 0x22,
    0x90, 0x50, 0x0f, 0x91, 0xe0, 0x12, 0xf1, 0x88, 0x84, 0x44, 0xaa, 0x96, 0x13, 0xe2, 0x60, 0x92,
    0x6d, 0xbb, 0xc2, 0x59, 0x1b, 0x7b, 0x53, 0x9a, 0xbf, 0xc7, 0xa1, 0x84, 0x4a, 0xa9, 0xd3, 0x24,
    0x37, 0x6b, 0x77, 0x66, 0x3c, 0xeb, 0x1d, 0x67, 0xf5, 0x83, 0x90, 0x9f, 0x8a, 0xa2, 0x27, 0xb4,
    0xac, 0x4c, 0x9d, 0x32, 0x94, 0x17, 0x16, 0xe4, 0x2a, 0xd4, 0xc2, 0x00, 0x71, 0x9c, 0x79, 0x00,
    0xb7, 0x54, 0x49, 0xa9, 0xd9, 0x04, 0x67, 0xbe, 0x6e, 0x24, 0xb4, 0x06, 0x2a, 0x92, 0x0d, 0xca,
    0x62, 0x2f, 0x95, 0x37, 0x47, 0xaf, 0x52, 0x8f, 0x42, 0xbe, 0x11, 0xb4, 0x86, 0xec, 0xd7, 0xc1,
    0xa0, 0x9b, 0x5e, 0x8d, 0xff, 0xfb, 0x8d, 0xfa, 0x8e, 0x91, 0x38, 0xb8, 0xbc, 0xf3, 0x21, 0x4f,
    0xd0, 0x13, 0x55, 0xfd, 0x19, 0x70, 0x5c, 0xa7, 0xe0, 0x87, 0xba, 0x61, 0x97, 0x58, 0x82, 0x65,
    0x51, 0xea, 0x16, 0xfc, 0xe5, 0xd0, 0xb3, 0x1b, 0x3f, 0x1e, 0x73, 0x45, 0x2d, 0x2e, 0xab, 0x17,
    0x58, 0xc0, 0x2c, 0x9a, 0xf3, 0x63, 0x85, 0xd1, 0x3c, 0x75, 0xad, 0x1e, 0x12, 0x15, 0xb0, 0x7b,
    0x59, 0x8d, 0x7b, 0xd5, 0x13, 0x66, 0x91, 0x2c, 0x18, 0x4e, 0x8e, 0x1e, 0x67, 0xfa, 0x92, 0xd0,
    0x2e, 0x95, 0x7e, 0x86, 0x2d, 0xc8, 0x76, 0x98, 0x0f, 0xa5, 0xa4, 0x1f, 0xab, 0x0f, 0xab, 0x9c,
    0xb4, 0x05, 0x6d, 0x60, 0x42, 0x96, 0xae, 0xbd, 0xf5, 0xc8, 0x40, 0xa9, 0xb6, 0x30, 0x52, 0xe3,
    0x6a, 0xa4, 0x46, 0x9b, 0x29, 0xbf, 0x6f, 0xd7, 0x1d, 0x8c, 0x8d, 0x05, 0xbe, 0xef, 0x26, 0x27,
    0x74, 0xc3, 0xc6, 0xfb, 0xec, 0x04, 0xbd, 0xac, 0xb4, 0xcd, 0x4f, 0xd8, 0x24, 0x29, 0xe6, 0x5a,
    0x23, 0xad, 0xa3, 0x57, 0x42, 0x45, 0x6f, 0x9e, 0x3c, 0x85, 0xe7, 0x9d, 0x62, 0x86, 0xbb, 0x52,
    0xe8, 0xf7, 0xfe, 0x0b, 0x16, 0x2c, 0x0c, 0x77, 0x8c, 0xd9, 0xa6, 0x36, 0x60, 0xed, 0x98, 0x76,
    0xf8, 0x09, 0x3f, 0xed, 0x1b, 0xa1, 0x35
};
#endif

PyTypeObject *init_HistoryItem(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX].type;

    Shiboken::AutoDecRef Sbk_HistoryItem_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_HistoryItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "HistoryItem",
        "HistoryItem*",
        &Sbk_HistoryItem_spec,
        &Shiboken::callCppDestructor< ::HistoryItem >,
        Sbk_HistoryItem_Type_bases.object(),
        0);
    auto *pyType = _Sbk_HistoryItem_Type; // references _Sbk_HistoryItem_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, HistoryItem_SignatureStrings);
#else
    InitSignatureBytes(pyType, HistoryItem_SignatureBytes, HistoryItem_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_HistoryItem_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        HistoryItem_PythonToCpp_HistoryItem_PTR,
        is_HistoryItem_PythonToCpp_HistoryItem_PTR_Convertible,
        HistoryItem_PTR_CppToPython_HistoryItem);

    Shiboken::Conversions::registerConverterName(converter, "HistoryItem");
    Shiboken::Conversions::registerConverterName(converter, "HistoryItem*");
    Shiboken::Conversions::registerConverterName(converter, "HistoryItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::HistoryItem).name());

    qRegisterMetaType< ::HistoryItem *>();

    return pyType;
}
