/* command-linking.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from command-linking.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include "folks/folks.h"
#include <stdio.h>
#include <readline/readline.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_LINKING (folks_inspect_commands_linking_get_type ())
#define FOLKS_INSPECT_COMMANDS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinking))
#define FOLKS_INSPECT_COMMANDS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_LINKING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))

typedef struct _FolksInspectCommandsLinking FolksInspectCommandsLinking;
typedef struct _FolksInspectCommandsLinkingClass FolksInspectCommandsLinkingClass;
typedef struct _FolksInspectCommandsLinkingPrivate FolksInspectCommandsLinkingPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksInspectCommandsLinkingRunData FolksInspectCommandsLinkingRunData;

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gint (*run_finish) (FolksInspectCommand* self, GAsyncResult* _res_);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, gint* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsLinking {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsLinkingPrivate * priv;
};

struct _FolksInspectCommandsLinkingClass {
	FolksInspectCommandClass parent_class;
};

struct _FolksInspectCommandsLinkingRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksInspectCommandsLinking* self;
	gchar* command_string;
	gint result;
	gchar** parts;
	gchar** _tmp0_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	GeeHashSet* personas;
	GeeHashSet* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	guint i;
	gboolean _tmp16_;
	guint _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gboolean _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	gboolean found;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	gchar* uid;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	GeeIterator* _individual_it;
	FolksInspectClient* _tmp37_;
	FolksIndividualAggregator* _tmp38_;
	FolksIndividualAggregator* _tmp39_;
	GeeMap* _tmp40_;
	GeeMap* _tmp41_;
	GeeCollection* _tmp42_;
	GeeCollection* _tmp43_;
	GeeCollection* _tmp44_;
	GeeIterator* _tmp45_;
	GeeIterator* _tmp46_;
	GeeIterator* _tmp47_;
	FolksIndividual* individual;
	GeeIterator* _tmp48_;
	gpointer _tmp49_;
	GeeIterator* _persona_it;
	FolksIndividual* _tmp50_;
	GeeSet* _tmp51_;
	GeeSet* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	FolksPersona* persona;
	GeeIterator* _tmp55_;
	gpointer _tmp56_;
	FolksPersona* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	GeeHashSet* _tmp61_;
	FolksPersona* _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	const gchar* _tmp64_;
	gchar* id;
	gchar** _tmp65_;
	gint _tmp65__length1;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	GeeIterator* _vala1__individual_it;
	FolksInspectClient* _tmp68_;
	FolksIndividualAggregator* _tmp69_;
	FolksIndividualAggregator* _tmp70_;
	GeeMap* _tmp71_;
	GeeMap* _tmp72_;
	GeeCollection* _tmp73_;
	GeeCollection* _tmp74_;
	GeeCollection* _tmp75_;
	GeeIterator* _tmp76_;
	GeeIterator* _tmp77_;
	GeeIterator* _tmp78_;
	FolksIndividual* _vala1_individual;
	GeeIterator* _tmp79_;
	gpointer _tmp80_;
	FolksIndividual* _tmp81_;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	GeeIterator* _vala1__persona_it;
	FolksIndividual* _tmp85_;
	GeeSet* _tmp86_;
	GeeSet* _tmp87_;
	GeeIterator* _tmp88_;
	GeeIterator* _tmp89_;
	FolksPersona* _vala1_persona;
	GeeIterator* _tmp90_;
	gpointer _tmp91_;
	GeeHashSet* _tmp92_;
	FolksPersona* _tmp93_;
	gchar** _tmp94_;
	gint _tmp94__length1;
	const gchar* _tmp95_;
	FolksInspectClient* _tmp96_;
	FolksIndividualAggregator* _tmp97_;
	FolksIndividualAggregator* _tmp98_;
	GeeHashSet* _tmp99_;
	GError* e;
	GError* _tmp100_;
	GError* _tmp101_;
	GeeHashSet* _tmp102_;
	gint _tmp103_;
	gint _tmp104_;
	GError* _tmp105_;
	const gchar* _tmp106_;
	GeeHashSet* _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	gchar** _tmp110_;
	gint _tmp110__length1;
	const gchar* _tmp111_;
	gchar** _tmp112_;
	gint _tmp112__length1;
	FolksIndividual* ind;
	FolksInspectClient* _tmp113_;
	FolksIndividualAggregator* _tmp114_;
	FolksIndividualAggregator* _tmp115_;
	GeeMap* _tmp116_;
	GeeMap* _tmp117_;
	gchar** _tmp118_;
	gint _tmp118__length1;
	const gchar* _tmp119_;
	gpointer _tmp120_;
	FolksIndividual* _tmp121_;
	gchar** _tmp122_;
	gint _tmp122__length1;
	const gchar* _tmp123_;
	FolksInspectClient* _tmp124_;
	FolksIndividualAggregator* _tmp125_;
	FolksIndividualAggregator* _tmp126_;
	FolksIndividual* _tmp127_;
	GError* _vala1_e;
	GError* _tmp128_;
	GError* _tmp129_;
	FolksIndividual* _tmp130_;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	GError* _tmp133_;
	const gchar* _tmp134_;
	FolksIndividual* _tmp135_;
	const gchar* _tmp136_;
	const gchar* _tmp137_;
	GError* _inner_error0_;
};

static gpointer folks_inspect_commands_linking_parent_class = NULL;
static gchar** folks_inspect_commands_linking_subcommand_completions;
static gchar** folks_inspect_commands_linking_subcommand_completions = NULL;
static guint folks_inspect_commands_linking_completion_count;
static guint folks_inspect_commands_linking_completion_count = 0U;
static gchar* folks_inspect_commands_linking_prefix;
static gchar* folks_inspect_commands_linking_prefix = NULL;

VALA_EXTERN gpointer folks_inspect_command_ref (gpointer instance);
VALA_EXTERN void folks_inspect_command_unref (gpointer instance);
VALA_EXTERN GParamSpec* folks_inspect_param_spec_command (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void folks_inspect_value_set_command (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void folks_inspect_value_take_command (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer folks_inspect_value_get_command (const GValue* value);
VALA_EXTERN GType folks_inspect_command_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommand, folks_inspect_command_unref)
VALA_EXTERN GType folks_inspect_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectClient, g_object_unref)
VALA_EXTERN GType folks_inspect_commands_linking_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsLinking, folks_inspect_command_unref)
VALA_EXTERN void folks_inspect_command_run (FolksInspectCommand* self,
                                const gchar* command_string,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN gint folks_inspect_command_run_finish (FolksInspectCommand* self,
                                       GAsyncResult* _res_);
VALA_EXTERN gchar** folks_inspect_command_complete_subcommand (FolksInspectCommand* self,
                                                   const gchar* subcommand,
                                                   gint* result_length1);
VALA_EXTERN const gchar* folks_inspect_command_get_name (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_description (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_help (FolksInspectCommand* self);
VALA_EXTERN FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type,
                                                                       FolksInspectClient* client);
VALA_EXTERN FolksInspectCommand* folks_inspect_command_construct (GType object_type,
                                                      FolksInspectClient* client);
static void folks_inspect_commands_linking_real_run_data_free (gpointer _data);
static void folks_inspect_commands_linking_real_run (FolksInspectCommand* base,
                                              const gchar* command_string,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean folks_inspect_commands_linking_real_run_co (FolksInspectCommandsLinkingRunData* _data_);
VALA_EXTERN gboolean folks_inspect_utils_validate_subcommand (const gchar* command,
                                                  const gchar* command_string,
                                                  const gchar* subcommand,
                                                  gchar** valid_subcommands,
                                                  gint valid_subcommands_length1);
VALA_EXTERN void folks_inspect_utils_print_line (const gchar* format,
                                     ...)  G_GNUC_PRINTF(1,2) ;
VALA_EXTERN FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void folks_inspect_commands_linking_run_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN gchar* folks_inspect_commands_linking_subcommand_name_completion_cb (const gchar* word,
                                                                     gint state);
VALA_EXTERN gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word,
                                                      gint state);
static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                           gint a);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
VALA_EXTERN gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word,
                                                        gint state);
static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                             gint a);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** folks_inspect_commands_linking_real_complete_subcommand (FolksInspectCommand* base,
                                                                 const gchar* subcommand,
                                                                 gint* result_length1);
static gchar* _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                                          gint a);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static void folks_inspect_commands_linking_finalize (FolksInspectCommand * obj);
static GType folks_inspect_commands_linking_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* FOLKS_INSPECT_COMMANDS_LINKING__valid_subcommands[3] = {"link-personas", "link-individuals", "unlink-individual"};

FolksInspectCommandsLinking*
folks_inspect_commands_linking_construct (GType object_type,
                                          FolksInspectClient* client)
{
	FolksInspectCommandsLinking* self = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommandsLinking*) folks_inspect_command_construct (object_type, client);
	return self;
}

FolksInspectCommandsLinking*
folks_inspect_commands_linking_new (FolksInspectClient* client)
{
	return folks_inspect_commands_linking_construct (FOLKS_INSPECT_COMMANDS_TYPE_LINKING, client);
}

static void
folks_inspect_commands_linking_real_run_data_free (gpointer _data)
{
	FolksInspectCommandsLinkingRunData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command_string);
	_folks_inspect_command_unref0 (_data_->self);
	g_slice_free (FolksInspectCommandsLinkingRunData, _data_);
}

static gpointer
_folks_inspect_command_ref0 (gpointer self)
{
	return self ? folks_inspect_command_ref (self) : NULL;
}

static void
folks_inspect_commands_linking_real_run (FolksInspectCommand* base,
                                         const gchar* command_string,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	FolksInspectCommandsLinking * self;
	FolksInspectCommandsLinkingRunData* _data_;
	FolksInspectCommandsLinking* _tmp0_;
	gchar* _tmp1_;
	self = (FolksInspectCommandsLinking*) base;
	_data_ = g_slice_new0 (FolksInspectCommandsLinkingRunData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_inspect_commands_linking_real_run_data_free);
	_tmp0_ = _folks_inspect_command_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (command_string);
	_g_free0 (_data_->command_string);
	_data_->command_string = _tmp1_;
	folks_inspect_commands_linking_real_run_co (_data_);
}

static gint
folks_inspect_commands_linking_run_finish (FolksInspectCommand* base,
                                           GAsyncResult* _res_)
{
	gint result;
	FolksInspectCommandsLinkingRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
folks_inspect_commands_linking_run_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	FolksInspectCommandsLinkingRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_inspect_commands_linking_real_run_co (_data_);
}

static gboolean
folks_inspect_commands_linking_real_run_co (FolksInspectCommandsLinkingRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->parts = _data_->_tmp0_;
	_data_->parts_length1 = 0;
	_data_->_parts_size_ = _data_->parts_length1;
	if (_data_->command_string != NULL) {
		_data_->_tmp2_ = _data_->_tmp1_ = g_strsplit (_data_->command_string, " ", 0);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		_data_->parts = _data_->_tmp2_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp1_);
		_data_->_parts_size_ = _data_->parts_length1;
	}
	_data_->_tmp3_ = folks_inspect_command_get_name ((FolksInspectCommand*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->parts;
	_data_->_tmp5__length1 = _data_->parts_length1;
	_data_->_tmp6_ = _data_->_tmp5_[0];
	if (!folks_inspect_utils_validate_subcommand (_data_->_tmp4_, _data_->command_string, _data_->_tmp6_, FOLKS_INSPECT_COMMANDS_LINKING__valid_subcommands, (gint) G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_LINKING__valid_subcommands))) {
		_data_->result = 1;
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->parts;
	_data_->_tmp8__length1 = _data_->parts_length1;
	_data_->_tmp9_ = _data_->_tmp8_[0];
	if (g_strcmp0 (_data_->_tmp9_, "link-personas") == 0) {
		_data_->_tmp7_ = TRUE;
	} else {
		_data_->_tmp10_ = _data_->parts;
		_data_->_tmp10__length1 = _data_->parts_length1;
		_data_->_tmp11_ = _data_->_tmp10_[0];
		_data_->_tmp7_ = g_strcmp0 (_data_->_tmp11_, "link-individuals") == 0;
	}
	if (_data_->_tmp7_) {
		_data_->_tmp12_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->personas = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->parts;
		_data_->_tmp13__length1 = _data_->parts_length1;
		if (_data_->_tmp13__length1 < 2) {
			_data_->_tmp14_ = _data_->parts;
			_data_->_tmp14__length1 = _data_->parts_length1;
			_data_->_tmp15_ = _data_->_tmp14_[0];
			if (g_strcmp0 (_data_->_tmp15_, "link-personas") == 0) {
				folks_inspect_utils_print_line ("%s", "Must pass at least one persona to a " "'link-personas' subcommand.");
			} else {
				folks_inspect_utils_print_line ("%s", "Must pass at least one individual to a " "'link-individuals' subcommand.");
			}
			_data_->result = 1;
			_g_object_unref0 (_data_->personas);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->i = (guint) 1;
			{
				_data_->_tmp16_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp16_) {
						_data_->_tmp17_ = _data_->i;
						_data_->i = _data_->_tmp17_ + 1;
					}
					_data_->_tmp16_ = FALSE;
					_data_->_tmp18_ = _data_->parts;
					_data_->_tmp18__length1 = _data_->parts_length1;
					if (!(_data_->i < ((guint) _data_->_tmp18__length1))) {
						break;
					}
					_data_->_tmp20_ = _data_->parts;
					_data_->_tmp20__length1 = _data_->parts_length1;
					_data_->_tmp21_ = _data_->_tmp20_[_data_->i];
					if (_data_->_tmp21_ == NULL) {
						_data_->_tmp19_ = TRUE;
					} else {
						_data_->_tmp22_ = _data_->parts;
						_data_->_tmp22__length1 = _data_->parts_length1;
						_data_->_tmp23_ = _data_->_tmp22_[_data_->i];
						_data_->_tmp24_ = string_strip (_data_->_tmp23_);
						_data_->_tmp25_ = _data_->_tmp24_;
						_data_->_tmp19_ = g_strcmp0 (_data_->_tmp25_, "") == 0;
						_g_free0 (_data_->_tmp25_);
					}
					if (_data_->_tmp19_) {
						_data_->_tmp26_ = _data_->parts;
						_data_->_tmp26__length1 = _data_->parts_length1;
						_data_->_tmp27_ = _data_->_tmp26_[0];
						if (g_strcmp0 (_data_->_tmp27_, "link-personas") == 0) {
							_data_->_tmp28_ = _data_->parts;
							_data_->_tmp28__length1 = _data_->parts_length1;
							_data_->_tmp29_ = _data_->_tmp28_[_data_->i];
							folks_inspect_utils_print_line ("Unrecognised persona UID '%s'.", _data_->_tmp29_);
						} else {
							_data_->_tmp30_ = _data_->parts;
							_data_->_tmp30__length1 = _data_->parts_length1;
							_data_->_tmp31_ = _data_->_tmp30_[_data_->i];
							folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _data_->_tmp31_);
						}
						_data_->result = 1;
						_g_object_unref0 (_data_->personas);
						_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
						g_task_return_pointer (_data_->_async_result, _data_, NULL);
						if (_data_->_state_ != 0) {
							while (!g_task_get_completed (_data_->_async_result)) {
								g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
							}
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->found = FALSE;
					_data_->_tmp32_ = _data_->parts;
					_data_->_tmp32__length1 = _data_->parts_length1;
					_data_->_tmp33_ = _data_->_tmp32_[0];
					if (g_strcmp0 (_data_->_tmp33_, "link-personas") == 0) {
						_data_->_tmp34_ = _data_->parts;
						_data_->_tmp34__length1 = _data_->parts_length1;
						_data_->_tmp35_ = _data_->_tmp34_[_data_->i];
						_data_->_tmp36_ = string_strip (_data_->_tmp35_);
						_data_->uid = _data_->_tmp36_;
						{
							_data_->_tmp37_ = ((FolksInspectCommand*) _data_->self)->client;
							_data_->_tmp38_ = folks_inspect_client_get_aggregator (_data_->_tmp37_);
							_data_->_tmp39_ = _data_->_tmp38_;
							_data_->_tmp40_ = folks_individual_aggregator_get_individuals (_data_->_tmp39_);
							_data_->_tmp41_ = _data_->_tmp40_;
							_data_->_tmp42_ = gee_map_get_values (_data_->_tmp41_);
							_data_->_tmp43_ = _data_->_tmp42_;
							_data_->_tmp44_ = _data_->_tmp43_;
							_data_->_tmp45_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp44_);
							_data_->_tmp46_ = _data_->_tmp45_;
							_g_object_unref0 (_data_->_tmp44_);
							_data_->_individual_it = _data_->_tmp46_;
							while (TRUE) {
								_data_->_tmp47_ = _data_->_individual_it;
								if (!gee_iterator_next (_data_->_tmp47_)) {
									break;
								}
								_data_->_tmp48_ = _data_->_individual_it;
								_data_->_tmp49_ = gee_iterator_get (_data_->_tmp48_);
								_data_->individual = (FolksIndividual*) _data_->_tmp49_;
								{
									_data_->_tmp50_ = _data_->individual;
									_data_->_tmp51_ = folks_individual_get_personas (_data_->_tmp50_);
									_data_->_tmp52_ = _data_->_tmp51_;
									_data_->_tmp53_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp52_);
									_data_->_persona_it = _data_->_tmp53_;
									while (TRUE) {
										_data_->_tmp54_ = _data_->_persona_it;
										if (!gee_iterator_next (_data_->_tmp54_)) {
											break;
										}
										_data_->_tmp55_ = _data_->_persona_it;
										_data_->_tmp56_ = gee_iterator_get (_data_->_tmp55_);
										_data_->persona = (FolksPersona*) _data_->_tmp56_;
										_data_->_tmp57_ = _data_->persona;
										_data_->_tmp58_ = folks_persona_get_uid (_data_->_tmp57_);
										_data_->_tmp59_ = _data_->_tmp58_;
										_data_->_tmp60_ = _data_->uid;
										if (g_strcmp0 (_data_->_tmp59_, _data_->_tmp60_) == 0) {
											_data_->_tmp61_ = _data_->personas;
											_data_->_tmp62_ = _data_->persona;
											gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp61_, _data_->_tmp62_);
											_data_->found = TRUE;
											_g_object_unref0 (_data_->persona);
											break;
										}
										_g_object_unref0 (_data_->persona);
									}
									_g_object_unref0 (_data_->_persona_it);
								}
								if (_data_->found == TRUE) {
									_g_object_unref0 (_data_->individual);
									break;
								}
								_g_object_unref0 (_data_->individual);
							}
							_g_object_unref0 (_data_->_individual_it);
						}
						if (_data_->found == FALSE) {
							_data_->_tmp63_ = _data_->parts;
							_data_->_tmp63__length1 = _data_->parts_length1;
							_data_->_tmp64_ = _data_->_tmp63_[_data_->i];
							folks_inspect_utils_print_line ("Unrecognised persona UID '%s'.", _data_->_tmp64_);
							_data_->result = 1;
							_g_free0 (_data_->uid);
							_g_object_unref0 (_data_->personas);
							_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
							if (_data_->_state_ != 0) {
								while (!g_task_get_completed (_data_->_async_result)) {
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
								}
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_g_free0 (_data_->uid);
					} else {
						_data_->_tmp65_ = _data_->parts;
						_data_->_tmp65__length1 = _data_->parts_length1;
						_data_->_tmp66_ = _data_->_tmp65_[_data_->i];
						_data_->_tmp67_ = string_strip (_data_->_tmp66_);
						_data_->id = _data_->_tmp67_;
						{
							_data_->_tmp68_ = ((FolksInspectCommand*) _data_->self)->client;
							_data_->_tmp69_ = folks_inspect_client_get_aggregator (_data_->_tmp68_);
							_data_->_tmp70_ = _data_->_tmp69_;
							_data_->_tmp71_ = folks_individual_aggregator_get_individuals (_data_->_tmp70_);
							_data_->_tmp72_ = _data_->_tmp71_;
							_data_->_tmp73_ = gee_map_get_values (_data_->_tmp72_);
							_data_->_tmp74_ = _data_->_tmp73_;
							_data_->_tmp75_ = _data_->_tmp74_;
							_data_->_tmp76_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp75_);
							_data_->_tmp77_ = _data_->_tmp76_;
							_g_object_unref0 (_data_->_tmp75_);
							_data_->_vala1__individual_it = _data_->_tmp77_;
							while (TRUE) {
								_data_->_tmp78_ = _data_->_vala1__individual_it;
								if (!gee_iterator_next (_data_->_tmp78_)) {
									break;
								}
								_data_->_tmp79_ = _data_->_vala1__individual_it;
								_data_->_tmp80_ = gee_iterator_get (_data_->_tmp79_);
								_data_->_vala1_individual = (FolksIndividual*) _data_->_tmp80_;
								_data_->_tmp81_ = _data_->_vala1_individual;
								_data_->_tmp82_ = folks_individual_get_id (_data_->_tmp81_);
								_data_->_tmp83_ = _data_->_tmp82_;
								_data_->_tmp84_ = _data_->id;
								if (g_strcmp0 (_data_->_tmp83_, _data_->_tmp84_) == 0) {
									{
										_data_->_tmp85_ = _data_->_vala1_individual;
										_data_->_tmp86_ = folks_individual_get_personas (_data_->_tmp85_);
										_data_->_tmp87_ = _data_->_tmp86_;
										_data_->_tmp88_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp87_);
										_data_->_vala1__persona_it = _data_->_tmp88_;
										while (TRUE) {
											_data_->_tmp89_ = _data_->_vala1__persona_it;
											if (!gee_iterator_next (_data_->_tmp89_)) {
												break;
											}
											_data_->_tmp90_ = _data_->_vala1__persona_it;
											_data_->_tmp91_ = gee_iterator_get (_data_->_tmp90_);
											_data_->_vala1_persona = (FolksPersona*) _data_->_tmp91_;
											_data_->_tmp92_ = _data_->personas;
											_data_->_tmp93_ = _data_->_vala1_persona;
											gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp92_, _data_->_tmp93_);
											_g_object_unref0 (_data_->_vala1_persona);
										}
										_g_object_unref0 (_data_->_vala1__persona_it);
									}
									_data_->found = TRUE;
									_g_object_unref0 (_data_->_vala1_individual);
									break;
								}
								_g_object_unref0 (_data_->_vala1_individual);
							}
							_g_object_unref0 (_data_->_vala1__individual_it);
						}
						if (_data_->found == FALSE) {
							_data_->_tmp94_ = _data_->parts;
							_data_->_tmp94__length1 = _data_->parts_length1;
							_data_->_tmp95_ = _data_->_tmp94_[_data_->i];
							folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _data_->_tmp95_);
							_data_->result = 1;
							_g_free0 (_data_->id);
							_g_object_unref0 (_data_->personas);
							_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
							g_task_return_pointer (_data_->_async_result, _data_, NULL);
							if (_data_->_state_ != 0) {
								while (!g_task_get_completed (_data_->_async_result)) {
									g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
								}
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_g_free0 (_data_->id);
					}
				}
			}
		}
		{
			_data_->_tmp96_ = ((FolksInspectCommand*) _data_->self)->client;
			_data_->_tmp97_ = folks_inspect_client_get_aggregator (_data_->_tmp96_);
			_data_->_tmp98_ = _data_->_tmp97_;
			_data_->_tmp99_ = _data_->personas;
			_data_->_state_ = 1;
			folks_individual_aggregator_link_personas (_data_->_tmp98_, (GeeSet*) _data_->_tmp99_, folks_inspect_commands_linking_run_ready, _data_);
			return FALSE;
			_state_1:
			folks_individual_aggregator_link_personas_finish (_data_->_tmp98_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					goto __catch0_folks_individual_aggregator_error;
				}
				_g_object_unref0 (_data_->personas);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally0;
		__catch0_folks_individual_aggregator_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp100_ = _data_->e;
			_data_->_tmp101_ = _data_->e;
			_data_->_tmp102_ = _data_->personas;
			_data_->_tmp103_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp102_);
			_data_->_tmp104_ = _data_->_tmp103_;
			_data_->_tmp105_ = _data_->e;
			_data_->_tmp106_ = _data_->_tmp105_->message;
			folks_inspect_utils_print_line ("Error (domain: %u, code: %u) linking %u " "personas: %s", _data_->_tmp100_->domain, _data_->_tmp101_->code, _data_->_tmp104_, _data_->_tmp106_);
			_data_->result = 1;
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->personas);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->personas);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp107_ = _data_->personas;
		_data_->_tmp108_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp107_);
		_data_->_tmp109_ = _data_->_tmp108_;
		folks_inspect_utils_print_line ("Linking of %u personas was successful.", (guint) _data_->_tmp109_);
		_g_object_unref0 (_data_->personas);
	} else {
		_data_->_tmp110_ = _data_->parts;
		_data_->_tmp110__length1 = _data_->parts_length1;
		_data_->_tmp111_ = _data_->_tmp110_[0];
		if (g_strcmp0 (_data_->_tmp111_, "unlink-individual") == 0) {
			_data_->_tmp112_ = _data_->parts;
			_data_->_tmp112__length1 = _data_->parts_length1;
			if (_data_->_tmp112__length1 != 2) {
				folks_inspect_utils_print_line ("%s", "Must pass exactly one individual ID to an " "'unlink-individual' subcommand.");
				_data_->result = 1;
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp113_ = ((FolksInspectCommand*) _data_->self)->client;
			_data_->_tmp114_ = folks_inspect_client_get_aggregator (_data_->_tmp113_);
			_data_->_tmp115_ = _data_->_tmp114_;
			_data_->_tmp116_ = folks_individual_aggregator_get_individuals (_data_->_tmp115_);
			_data_->_tmp117_ = _data_->_tmp116_;
			_data_->_tmp118_ = _data_->parts;
			_data_->_tmp118__length1 = _data_->parts_length1;
			_data_->_tmp119_ = _data_->_tmp118_[1];
			_data_->_tmp120_ = gee_map_get (_data_->_tmp117_, _data_->_tmp119_);
			_data_->ind = (FolksIndividual*) _data_->_tmp120_;
			_data_->_tmp121_ = _data_->ind;
			if (_data_->_tmp121_ == NULL) {
				_data_->_tmp122_ = _data_->parts;
				_data_->_tmp122__length1 = _data_->parts_length1;
				_data_->_tmp123_ = _data_->_tmp122_[1];
				folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _data_->_tmp123_);
				_data_->result = 1;
				_g_object_unref0 (_data_->ind);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			{
				_data_->_tmp124_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp125_ = folks_inspect_client_get_aggregator (_data_->_tmp124_);
				_data_->_tmp126_ = _data_->_tmp125_;
				_data_->_tmp127_ = _data_->ind;
				_data_->_state_ = 2;
				folks_individual_aggregator_unlink_individual (_data_->_tmp126_, _data_->_tmp127_, folks_inspect_commands_linking_run_ready, _data_);
				return FALSE;
				_state_2:
				folks_individual_aggregator_unlink_individual_finish (_data_->_tmp126_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp128_ = _data_->_vala1_e;
				_data_->_tmp129_ = _data_->_vala1_e;
				_data_->_tmp130_ = _data_->ind;
				_data_->_tmp131_ = folks_individual_get_id (_data_->_tmp130_);
				_data_->_tmp132_ = _data_->_tmp131_;
				_data_->_tmp133_ = _data_->_vala1_e;
				_data_->_tmp134_ = _data_->_tmp133_->message;
				folks_inspect_utils_print_line ("Error (domain: %u, code: %u) unlinking " "individual '%s': %s", _data_->_tmp128_->domain, _data_->_tmp129_->code, _data_->_tmp132_, _data_->_tmp134_);
				_data_->result = 1;
				_g_error_free0 (_data_->_vala1_e);
				_g_object_unref0 (_data_->ind);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->ind);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp135_ = _data_->ind;
			_data_->_tmp136_ = folks_individual_get_id (_data_->_tmp135_);
			_data_->_tmp137_ = _data_->_tmp136_;
			folks_inspect_utils_print_line ("Unlinking of individual '%s' was successful.", _data_->_tmp137_);
			_g_object_unref0 (_data_->ind);
		} else {
			g_assert_not_reached ();
		}
	}
	_data_->result = 0;
	_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
_folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                    gint a)
{
	gchar* result;
	result = folks_inspect_utils_persona_uid_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
_folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                      gint a)
{
	gchar* result;
	result = folks_inspect_utils_individual_id_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar*
folks_inspect_commands_linking_subcommand_name_completion_cb (const gchar* word,
                                                              gint state)
{
	gchar* _tmp56_;
	gchar* result;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		gchar** parts = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint parts_length1;
		gint _parts_size_;
		gboolean _tmp2_ = FALSE;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp1_ = _tmp0_ = g_strsplit (word, " ", 0);
		parts = _tmp1_;
		parts_length1 = _vala_array_length (_tmp0_);
		_parts_size_ = parts_length1;
		_tmp3_ = parts;
		_tmp3__length1 = parts_length1;
		if (_tmp3__length1 > 0) {
			gboolean _tmp4_ = FALSE;
			gchar** _tmp5_;
			gint _tmp5__length1;
			const gchar* _tmp6_;
			_tmp5_ = parts;
			_tmp5__length1 = parts_length1;
			_tmp6_ = _tmp5_[0];
			if (g_strcmp0 (_tmp6_, "link-personas") == 0) {
				_tmp4_ = TRUE;
			} else {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp7_ = parts;
				_tmp7__length1 = parts_length1;
				_tmp8_ = _tmp7_[0];
				_tmp4_ = g_strcmp0 (_tmp8_, "link-individuals") == 0;
			}
			_tmp2_ = _tmp4_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* last_part = NULL;
			gchar** _tmp9_;
			gint _tmp9__length1;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			const gchar* _tmp23_;
			_tmp9_ = parts;
			_tmp9__length1 = parts_length1;
			_tmp10_ = parts;
			_tmp10__length1 = parts_length1;
			_tmp11_ = _tmp9_[_tmp10__length1 - 1];
			_tmp12_ = g_strdup (_tmp11_);
			last_part = _tmp12_;
			_tmp13_ = parts;
			_tmp13__length1 = parts_length1;
			_tmp14_ = _tmp13_[0];
			if (g_strcmp0 (_tmp14_, "link-personas") == 0) {
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				_tmp15_ = last_part;
				_tmp17_ = _tmp16_ = rl_completion_matches (_tmp15_, _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t);
				_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup4 (_tmp17_, _vala_array_length (_tmp16_)) : _tmp17_;
				_tmp18__length1 = _vala_array_length (_tmp16_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp18_;
			} else {
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gchar** _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				_tmp19_ = last_part;
				_tmp21_ = _tmp20_ = rl_completion_matches (_tmp19_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup5 (_tmp21_, _vala_array_length (_tmp20_)) : _tmp21_;
				_tmp22__length1 = _vala_array_length (_tmp20_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp22_;
			}
			_tmp23_ = last_part;
			if (g_strcmp0 (_tmp23_, "") == 0) {
				gchar* _tmp24_;
				_tmp24_ = g_strdup (word);
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp24_;
			} else {
				const gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gchar* _tmp28_;
				_tmp25_ = last_part;
				_tmp26_ = strlen (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = string_slice (word, (glong) 0, (glong) (-_tmp27_));
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp28_;
			}
			_g_free0 (last_part);
		} else {
			gboolean _tmp29_ = FALSE;
			gchar** _tmp30_;
			gint _tmp30__length1;
			_tmp30_ = parts;
			_tmp30__length1 = parts_length1;
			if (_tmp30__length1 > 0) {
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				_tmp31_ = parts;
				_tmp31__length1 = parts_length1;
				_tmp32_ = _tmp31_[0];
				_tmp29_ = g_strcmp0 (_tmp32_, "unlink-individual") == 0;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				gchar** _tmp33_;
				gint _tmp33__length1;
				gchar** _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_;
				gchar** _tmp37_;
				gchar** _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				gchar* _tmp40_;
				_tmp33_ = parts;
				_tmp33__length1 = parts_length1;
				if (_tmp33__length1 != 2) {
					gchar* _tmp34_;
					folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
					folks_inspect_commands_linking_subcommand_completions = NULL;
					folks_inspect_commands_linking_completion_count = (guint) 0;
					_tmp34_ = g_strdup ("");
					_g_free0 (folks_inspect_commands_linking_prefix);
					folks_inspect_commands_linking_prefix = _tmp34_;
					result = NULL;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp35_ = parts;
				_tmp35__length1 = parts_length1;
				_tmp36_ = _tmp35_[1];
				_tmp38_ = _tmp37_ = rl_completion_matches (_tmp36_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp39_ = (_tmp38_ != NULL) ? _vala_array_dup6 (_tmp38_, _vala_array_length (_tmp37_)) : _tmp38_;
				_tmp39__length1 = _vala_array_length (_tmp37_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp39_;
				_tmp40_ = g_strdup ("unlink-individual ");
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp40_;
			} else {
				gchar** _tmp41_;
				gint _tmp41__length1;
				gchar* _tmp42_;
				_tmp41_ = _vala_array_dup7 (FOLKS_INSPECT_COMMANDS_LINKING__valid_subcommands, G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_LINKING__valid_subcommands));
				_tmp41__length1 = G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_LINKING__valid_subcommands);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp41_;
				_tmp42_ = g_strdup ("");
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp42_;
			}
		}
		folks_inspect_commands_linking_completion_count = (guint) 0;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	while (TRUE) {
		gchar** _tmp43_;
		gint _tmp43__length1;
		gchar* completion = NULL;
		gchar** _tmp44_;
		gint _tmp44__length1;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* candidate = NULL;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		guint _tmp50_;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		const gchar* _tmp53_;
		_tmp43_ = folks_inspect_commands_linking_subcommand_completions;
		_tmp43__length1 = _vala_array_length (folks_inspect_commands_linking_subcommand_completions);
		if (!(folks_inspect_commands_linking_completion_count < ((guint) _tmp43__length1))) {
			break;
		}
		_tmp44_ = folks_inspect_commands_linking_subcommand_completions;
		_tmp44__length1 = _vala_array_length (folks_inspect_commands_linking_subcommand_completions);
		_tmp45_ = _tmp44_[folks_inspect_commands_linking_completion_count];
		_tmp46_ = g_strdup (_tmp45_);
		completion = _tmp46_;
		_tmp47_ = folks_inspect_commands_linking_prefix;
		_tmp48_ = completion;
		_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
		candidate = _tmp49_;
		_tmp50_ = folks_inspect_commands_linking_completion_count;
		folks_inspect_commands_linking_completion_count = _tmp50_ + 1;
		_tmp53_ = completion;
		if (_tmp53_ != NULL) {
			const gchar* _tmp54_;
			_tmp54_ = completion;
			_tmp52_ = g_strcmp0 (_tmp54_, "") != 0;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			const gchar* _tmp55_;
			_tmp55_ = candidate;
			_tmp51_ = g_str_has_prefix (_tmp55_, word);
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			result = completion;
			_g_free0 (candidate);
			return result;
		}
		_g_free0 (candidate);
		_g_free0 (completion);
	}
	folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
	folks_inspect_commands_linking_subcommand_completions = NULL;
	folks_inspect_commands_linking_completion_count = (guint) 0;
	_tmp56_ = g_strdup ("");
	_g_free0 (folks_inspect_commands_linking_prefix);
	folks_inspect_commands_linking_prefix = _tmp56_;
	result = NULL;
	return result;
}

static gchar*
_folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                                   gint a)
{
	gchar* result;
	result = folks_inspect_commands_linking_subcommand_name_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
folks_inspect_commands_linking_real_complete_subcommand (FolksInspectCommand* base,
                                                         const gchar* subcommand,
                                                         gint* result_length1)
{
	FolksInspectCommandsLinking * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	self = (FolksInspectCommandsLinking*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp1_ = _tmp0_ = rl_completion_matches (subcommand, _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup8 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static const gchar*
folks_inspect_commands_linking_real_get_name (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "linking";
	return result;
}

static const gchar*
folks_inspect_commands_linking_real_get_description (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "Link and unlink personas";
	return result;
}

static const gchar*
folks_inspect_commands_linking_real_get_help (FolksInspectCommand* base)
{
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "linking link-personas [persona 1 UID] " "[persona 2 UID] …           " "Link the given personas.\n" "linking link-individuals [individual 1 ID] " "[individual 2 ID] …    " "Link the personas in the given individuals.\n" "linking unlink-individual " "[individual ID]                         " "Unlink the given individual.";
	return result;
}

static void
folks_inspect_commands_linking_class_init (FolksInspectCommandsLinkingClass * klass,
                                           gpointer klass_data)
{
	folks_inspect_commands_linking_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectCommandClass *) klass)->finalize = folks_inspect_commands_linking_finalize;
	((FolksInspectCommandClass *) klass)->run = (void (*) (FolksInspectCommand*, const gchar*, GAsyncReadyCallback, gpointer)) folks_inspect_commands_linking_real_run;
	((FolksInspectCommandClass *) klass)->run_finish = (gint (*) (FolksInspectCommand*, GAsyncResult*)) folks_inspect_commands_linking_run_finish;
	((FolksInspectCommandClass *) klass)->complete_subcommand = (gchar** (*) (FolksInspectCommand*, const gchar*, gint*)) folks_inspect_commands_linking_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = (const gchar* (*) (FolksInspectCommand*)) folks_inspect_commands_linking_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = (const gchar* (*) (FolksInspectCommand*)) folks_inspect_commands_linking_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = (const gchar* (*) (FolksInspectCommand*)) folks_inspect_commands_linking_real_get_help;
}

static void
folks_inspect_commands_linking_instance_init (FolksInspectCommandsLinking * self,
                                              gpointer klass)
{
}

static void
folks_inspect_commands_linking_finalize (FolksInspectCommand * obj)
{
	FolksInspectCommandsLinking * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinking);
	FOLKS_INSPECT_COMMAND_CLASS (folks_inspect_commands_linking_parent_class)->finalize (obj);
}

static GType
folks_inspect_commands_linking_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsLinkingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_linking_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsLinking), 0, (GInstanceInitFunc) folks_inspect_commands_linking_instance_init, NULL };
	GType folks_inspect_commands_linking_type_id;
	folks_inspect_commands_linking_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsLinking", &g_define_type_info, 0);
	return folks_inspect_commands_linking_type_id;
}

GType
folks_inspect_commands_linking_get_type (void)
{
	static volatile gsize folks_inspect_commands_linking_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_commands_linking_type_id__once)) {
		GType folks_inspect_commands_linking_type_id;
		folks_inspect_commands_linking_type_id = folks_inspect_commands_linking_get_type_once ();
		g_once_init_leave (&folks_inspect_commands_linking_type_id__once, folks_inspect_commands_linking_type_id);
	}
	return folks_inspect_commands_linking_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

