/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.awt.FontMetrics;
import java.util.List;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

abstract class TagCondition
extends StringConditionAdapter {
    static final String SEARCH_ACROSS_ALL_CATEGORIES = "SEARCH_ACROSS_ALL_CATEGORIES";
    private final boolean searchesAcrossAllCategories;
    private final String comparedValue;

    TagCondition(String comparedValue, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics, boolean searchesAcrossAllCategories) {
        super(matchCase, matchApproximately, matchWordwise, ignoreDiacritics);
        this.comparedValue = comparedValue;
        this.searchesAcrossAllCategories = searchesAcrossAllCategories;
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.searchesAcrossAllCategories()) {
            child.setAttribute(SEARCH_ACROSS_ALL_CATEGORIES, "true");
        }
    }

    @Override
    public boolean checkNode(NodeModel node) {
        IconController iconController = IconController.getController();
        List<Tag> tags = iconController.getTags(node);
        if (this.searchesAcrossAllCategories()) {
            TagCategories tagCategories = node.getMap().getIconRegistry().getTagCategories();
            String tagCategorySeparator = tagCategories.getTagCategorySeparator();
            List<Tag> categorizedTags = iconController.extendCategories(tags, node.getMap().getIconRegistry().getTagCategories());
            for (Tag tag : categorizedTags) {
                if (!this.checkShortTag(tag, tagCategorySeparator)) continue;
                return true;
            }
        } else {
            for (Tag tag : tags) {
                if (!this.checkShortTag(tag, "")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkShortTag(Tag tag, String tagCategorySeparator) {
        String tagContent = tag.getContent();
        return this.checkText(tagContent) || !tagCategorySeparator.isEmpty() && tagContent.contains(tagCategorySeparator) && tag.categoryTags(tagCategorySeparator).stream().map(Tag::getContent).anyMatch(this::checkText);
    }

    protected boolean checkCategorizedTag(Tag categorizedTag, String tagCategorySeparatorForMap) {
        return categorizedTag.categoryTags(tagCategorySeparatorForMap).stream().anyMatch(tag -> this.checkText(tag.getContent()));
    }

    protected abstract boolean checkText(String var1);

    @Override
    protected Object conditionValue() {
        return this.comparedValue;
    }

    public boolean searchesAcrossAllCategories() {
        return this.searchesAcrossAllCategories;
    }

    protected TagIcon tagIcon(FontMetrics fontMetrics) {
        return this.tagIcon(this.comparedValue, fontMetrics);
    }

    protected TagIcon tagIcon(String value, FontMetrics fontMetrics) {
        String iconValue = this.searchesAcrossAllCategories ? value + "*" : value;
        return new TagIcon(new Tag(iconValue, Color.YELLOW), fontMetrics.getFont());
    }
}

