// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/monitoring/v3/service_service.proto

package monitoringpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ServiceMonitoringService_CreateService_FullMethodName               = "/google.monitoring.v3.ServiceMonitoringService/CreateService"
	ServiceMonitoringService_GetService_FullMethodName                  = "/google.monitoring.v3.ServiceMonitoringService/GetService"
	ServiceMonitoringService_ListServices_FullMethodName                = "/google.monitoring.v3.ServiceMonitoringService/ListServices"
	ServiceMonitoringService_UpdateService_FullMethodName               = "/google.monitoring.v3.ServiceMonitoringService/UpdateService"
	ServiceMonitoringService_DeleteService_FullMethodName               = "/google.monitoring.v3.ServiceMonitoringService/DeleteService"
	ServiceMonitoringService_CreateServiceLevelObjective_FullMethodName = "/google.monitoring.v3.ServiceMonitoringService/CreateServiceLevelObjective"
	ServiceMonitoringService_GetServiceLevelObjective_FullMethodName    = "/google.monitoring.v3.ServiceMonitoringService/GetServiceLevelObjective"
	ServiceMonitoringService_ListServiceLevelObjectives_FullMethodName  = "/google.monitoring.v3.ServiceMonitoringService/ListServiceLevelObjectives"
	ServiceMonitoringService_UpdateServiceLevelObjective_FullMethodName = "/google.monitoring.v3.ServiceMonitoringService/UpdateServiceLevelObjective"
	ServiceMonitoringService_DeleteServiceLevelObjective_FullMethodName = "/google.monitoring.v3.ServiceMonitoringService/DeleteServiceLevelObjective"
)

// ServiceMonitoringServiceClient is the client API for ServiceMonitoringService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ServiceMonitoringServiceClient interface {
	// Create a `Service`.
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Get the named `Service`.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// List `Service`s for this Metrics Scope.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Update this `Service`.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Soft delete this `Service`.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a `ServiceLevelObjective` for the given `Service`.
	CreateServiceLevelObjective(ctx context.Context, in *CreateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error)
	// Get a `ServiceLevelObjective` by name.
	GetServiceLevelObjective(ctx context.Context, in *GetServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error)
	// List the `ServiceLevelObjective`s for the given `Service`.
	ListServiceLevelObjectives(ctx context.Context, in *ListServiceLevelObjectivesRequest, opts ...grpc.CallOption) (*ListServiceLevelObjectivesResponse, error)
	// Update the given `ServiceLevelObjective`.
	UpdateServiceLevelObjective(ctx context.Context, in *UpdateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error)
	// Delete the given `ServiceLevelObjective`.
	DeleteServiceLevelObjective(ctx context.Context, in *DeleteServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type serviceMonitoringServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceMonitoringServiceClient(cc grpc.ClientConnInterface) ServiceMonitoringServiceClient {
	return &serviceMonitoringServiceClient{cc}
}

func (c *serviceMonitoringServiceClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_CreateService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_GetService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_ListServices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_UpdateService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_DeleteService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) CreateServiceLevelObjective(ctx context.Context, in *CreateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error) {
	out := new(ServiceLevelObjective)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_CreateServiceLevelObjective_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) GetServiceLevelObjective(ctx context.Context, in *GetServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error) {
	out := new(ServiceLevelObjective)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_GetServiceLevelObjective_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) ListServiceLevelObjectives(ctx context.Context, in *ListServiceLevelObjectivesRequest, opts ...grpc.CallOption) (*ListServiceLevelObjectivesResponse, error) {
	out := new(ListServiceLevelObjectivesResponse)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_ListServiceLevelObjectives_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) UpdateServiceLevelObjective(ctx context.Context, in *UpdateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error) {
	out := new(ServiceLevelObjective)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_UpdateServiceLevelObjective_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) DeleteServiceLevelObjective(ctx context.Context, in *DeleteServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ServiceMonitoringService_DeleteServiceLevelObjective_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceMonitoringServiceServer is the server API for ServiceMonitoringService service.
// All implementations should embed UnimplementedServiceMonitoringServiceServer
// for forward compatibility
type ServiceMonitoringServiceServer interface {
	// Create a `Service`.
	CreateService(context.Context, *CreateServiceRequest) (*Service, error)
	// Get the named `Service`.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// List `Service`s for this Metrics Scope.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Update this `Service`.
	UpdateService(context.Context, *UpdateServiceRequest) (*Service, error)
	// Soft delete this `Service`.
	DeleteService(context.Context, *DeleteServiceRequest) (*emptypb.Empty, error)
	// Create a `ServiceLevelObjective` for the given `Service`.
	CreateServiceLevelObjective(context.Context, *CreateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error)
	// Get a `ServiceLevelObjective` by name.
	GetServiceLevelObjective(context.Context, *GetServiceLevelObjectiveRequest) (*ServiceLevelObjective, error)
	// List the `ServiceLevelObjective`s for the given `Service`.
	ListServiceLevelObjectives(context.Context, *ListServiceLevelObjectivesRequest) (*ListServiceLevelObjectivesResponse, error)
	// Update the given `ServiceLevelObjective`.
	UpdateServiceLevelObjective(context.Context, *UpdateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error)
	// Delete the given `ServiceLevelObjective`.
	DeleteServiceLevelObjective(context.Context, *DeleteServiceLevelObjectiveRequest) (*emptypb.Empty, error)
}

// UnimplementedServiceMonitoringServiceServer should be embedded to have forward compatible implementations.
type UnimplementedServiceMonitoringServiceServer struct {
}

func (UnimplementedServiceMonitoringServiceServer) CreateService(context.Context, *CreateServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateService not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) GetService(context.Context, *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) UpdateService(context.Context, *UpdateServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateService not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) DeleteService(context.Context, *DeleteServiceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteService not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) CreateServiceLevelObjective(context.Context, *CreateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceLevelObjective not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) GetServiceLevelObjective(context.Context, *GetServiceLevelObjectiveRequest) (*ServiceLevelObjective, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceLevelObjective not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) ListServiceLevelObjectives(context.Context, *ListServiceLevelObjectivesRequest) (*ListServiceLevelObjectivesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceLevelObjectives not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) UpdateServiceLevelObjective(context.Context, *UpdateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceLevelObjective not implemented")
}
func (UnimplementedServiceMonitoringServiceServer) DeleteServiceLevelObjective(context.Context, *DeleteServiceLevelObjectiveRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceLevelObjective not implemented")
}

// UnsafeServiceMonitoringServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServiceMonitoringServiceServer will
// result in compilation errors.
type UnsafeServiceMonitoringServiceServer interface {
	mustEmbedUnimplementedServiceMonitoringServiceServer()
}

func RegisterServiceMonitoringServiceServer(s grpc.ServiceRegistrar, srv ServiceMonitoringServiceServer) {
	s.RegisterService(&ServiceMonitoringService_ServiceDesc, srv)
}

func _ServiceMonitoringService_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_CreateService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_GetService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_ListServices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_UpdateService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_DeleteService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_CreateServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).CreateServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_CreateServiceLevelObjective_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).CreateServiceLevelObjective(ctx, req.(*CreateServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_GetServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).GetServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_GetServiceLevelObjective_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).GetServiceLevelObjective(ctx, req.(*GetServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_ListServiceLevelObjectives_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceLevelObjectivesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).ListServiceLevelObjectives(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_ListServiceLevelObjectives_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).ListServiceLevelObjectives(ctx, req.(*ListServiceLevelObjectivesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_UpdateServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).UpdateServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_UpdateServiceLevelObjective_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).UpdateServiceLevelObjective(ctx, req.(*UpdateServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_DeleteServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).DeleteServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServiceMonitoringService_DeleteServiceLevelObjective_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).DeleteServiceLevelObjective(ctx, req.(*DeleteServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ServiceMonitoringService_ServiceDesc is the grpc.ServiceDesc for ServiceMonitoringService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ServiceMonitoringService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.ServiceMonitoringService",
	HandlerType: (*ServiceMonitoringServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateService",
			Handler:    _ServiceMonitoringService_CreateService_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceMonitoringService_GetService_Handler,
		},
		{
			MethodName: "ListServices",
			Handler:    _ServiceMonitoringService_ListServices_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _ServiceMonitoringService_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _ServiceMonitoringService_DeleteService_Handler,
		},
		{
			MethodName: "CreateServiceLevelObjective",
			Handler:    _ServiceMonitoringService_CreateServiceLevelObjective_Handler,
		},
		{
			MethodName: "GetServiceLevelObjective",
			Handler:    _ServiceMonitoringService_GetServiceLevelObjective_Handler,
		},
		{
			MethodName: "ListServiceLevelObjectives",
			Handler:    _ServiceMonitoringService_ListServiceLevelObjectives_Handler,
		},
		{
			MethodName: "UpdateServiceLevelObjective",
			Handler:    _ServiceMonitoringService_UpdateServiceLevelObjective_Handler,
		},
		{
			MethodName: "DeleteServiceLevelObjective",
			Handler:    _ServiceMonitoringService_DeleteServiceLevelObjective_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/service_service.proto",
}
