/* Copyright (c) 2004, 2024, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is designed to work with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have either included with
   the program or referenced in the documentation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  </build/xtrabackup/src/percona-xtrabackup-8.4.0-4/scripts/fill_help_tables.sql>
*/
const char* fill_help_tables[]={
"-- Copyright (c) 2003, 2024, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is designed to work with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have either included with\n"
  "-- the program or referenced in the documentation.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "-- DO NOT EDIT THIS FILE. It is generated automatically by the MySQL\n"
  "-- documentation team. If you require changes to the content of this\n"
  "-- file, contact the documentation team.\n"
  "-- File generation date: 2024-03-18\n"
  "-- MySQL series: 8.4\n"
  "-- Document repository revision: 78088\n"
  "-- To use this file, load its contents into the mysql system database.\n"
  "-- For example, with the mysql client program, process the file like\n"
  "-- this, where file_name is the name of this file:\n"
  "--     mysql -u root -p mysql < file_name\n"
  "SET sql_log_bin=0;\n",
"SET NAMES 'utf8';\n",
"TRUNCATE TABLE help_topic;\n",
"TRUNCATE TABLE help_category;\n",
"TRUNCATE TABLE help_keyword;\n",
"TRUNCATE TABLE help_relation;\n",
"START TRANSACTION;\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (0,'Contents',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (1,'Help Metadata',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (2,'Data Types',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (3,'Administration',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (4,'Functions',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (5,'Enterprise Encryption Functions',4,'"
  "');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (6,'Language Structure',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (7,'Geographic Features',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (8,'MBR',7,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (9,'WKT',7,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (10,'Comparison Operators',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (11,'Logical Operators',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (12,'Flow Control Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (13,'Numeric Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (14,'Date and Time Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (15,'String Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (16,'Cast Functions and Operators',4,'')"
  ";\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (17,'XML',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (18,'Bit Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (19,'Encryption Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (20,'Locking Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (21,'Information Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (22,'Spatial Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (23,'WKT Functions',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (24,'WKB Functions',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (25,'Geometry Constructors',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (26,'Geometry Property Functions',22,'')"
  ";\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (27,'Point Property Functions',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (28,'LineString Property Functions',22,'"
  "');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (29,'Polygon Property Functions',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (30,'GeometryCollection Property Functio"
  "ns',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (31,'Geometry Relation Functions',22,'')"
  ";\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (32,'MBR Functions',22,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (33,'GTID',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (34,'Aggregate Functions and Modifiers',"
  "4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (35,'GROUP BY Functions and Modifiers',4"
  ",'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (36,'Window Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (37,'Performance Schema Functions',4,'')"
  ";\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (38,'Internal Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (39,'Miscellaneous Functions',4,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (40,'Data Definition',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (41,'Data Manipulation',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (42,'Transactions',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (43,'Replication Statements',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (44,'Prepared Statements',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (45,'Compound Statements',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (46,'Account Management',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (47,'Table Maintenance',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (48,'Loadable Functions',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (49,'Components',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (50,'Plugins',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (51,'Utility',0,'');\n",
"INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (52,'Storage Engines',0,'');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (0,1,'HELP_DATE','This help "
  "information was generated from the MySQL 8.4 Reference Manual\\non: 2024-03-18\\n','','');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (1,1,'HELP_VERSION','This he"
  "lp information was generated from the MySQL 8.4 Reference Manual\\non: 2024-03-18 (revision: 78088)\\n\\nThis informatio"
  "n applies to MySQL 8.4 through 8.4.0.\\n','','');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (2,2,'AUTO_INCREMENT','The A"
  "UTO_INCREMENT attribute can be used to generate a unique identity\\nfor new rows:\\n\\nURL: https://dev.mysql.com/doc/re"
  "fman/8.4/en/example-auto-increment.html\\n\\n','CREATE TABLE animals (\\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\\n   "
  "  name CHAR(30) NOT NULL,\\n     PRIMARY KEY (id)\\n);\\n\\nINSERT INTO animals (name) VALUES\\n    (\\'dog\\'),(\\'cat\\'),(\\"
  "'penguin\\'),\\n    (\\'lax\\'),(\\'whale\\'),(\\'ostrich\\');\\n\\nSELECT * FROM animals;\\n','https://dev.mysql.com/doc/refman"
  "/8.4/en/example-auto-increment.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (3,3,'HELP COMMAND','Syntax:"
  "\\nmysql> help search_string\\n\\nIf you provide an argument to the help command, mysql uses it as a\\nsearch string to a"
  "ccess server-side help from the contents of the MySQL\\nReference Manual. The proper operation of this command require"
  "s that\\nthe help tables in the mysql database be initialized with help topic\\ninformation (see\\nhttps://dev.mysql.com"
  "/doc/refman/8.4/en/server-side-help-support.html).\\n\\nIf there is no match for the search string, the search fails:\\n"
  "\\nmysql> help me\\n\\nNothing found\\nPlease try to run \\'help contents\\' for a list of all accessible topics\\n\\nUse hel"
  "p contents to see a list of the help categories:\\n\\nmysql> help contents\\nYou asked for help about help category: \"C"
  "ontents\"\\nFor more information, type \\'help <item>\\', where <item> is one of the\\nfollowing categories:\\n   Account "
  "Management\\n   Administration\\n   Data Definition\\n   Data Manipulation\\n   Data Types\\n   Functions\\n   Functions an"
  "d Modifiers for Use with GROUP BY\\n   Geographic Features\\n   Language Structure\\n   Plugins\\n   Storage Engines\\n   "
  "Stored Routines\\n   Table Maintenance\\n   Transactions\\n   Triggers\\n\\nIf the search string matches multiple items, m"
  "ysql shows a list of\\nmatching topics:\\n\\nmysql> help logs\\nMany help items for your request exist.\\nTo make a more s"
  "pecific request, please type \\'help <item>\\',\\nwhere <item> is one of the following topics:\\n   SHOW\\n   SHOW BINARY "
  "LOGS\\n   SHOW ENGINE\\n   SHOW LOGS\\n\\nUse a topic as the search string to see the help entry for that topic:\\n\\nmysql"
  "> help show binary logs\\nName: \\'SHOW BINARY LOGS\\'\\nDescription:\\nSyntax:\\nSHOW BINARY LOGS\\n\\nLists the binary log "
  "files on the server. This statement is used as\\npart of the procedure described in [purge-binary-logs], that shows ho"
  "w\\nto determine which logs can be purged.\\n\\nmysql> SHOW BINARY LOGS;\\n+---------------+-----------+-----------+\\n| L"
  "og_name      | File_size | Encrypted |\\n+---------------+-----------+-----------+\\n| binlog.000015 |    724935 | Yes "
  "      |\\n| binlog.000016 |    733481 | Yes       |\\n+---------------+-----------+-----------+\\n\\nThe search string ca"
  "n contain the wildcard characters % and _. These\\nhave the same meaning as for pattern-matching operations performed "
  "with\\nthe LIKE operator. For example, HELP rep% returns a list of topics that\\nbegin with rep:\\n\\nmysql> HELP rep%\\nM"
  "any help items for your request exist.\\nTo make a more specific request, please type \\'help <item>\\',\\nwhere <item> i"
  "s one of the following\\ntopics:\\n   REPAIR TABLE\\n   REPEAT FUNCTION\\n   REPEAT LOOP\\n   REPLACE\\n   REPLACE FUNCTION"
  "\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mysql-server-side-help.html\\n\\n','','https://dev.mysql.com/doc/refma"
  "n/8.4/en/mysql-server-side-help.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (4,5,'ASYMMETRIC_DECRYPT','S"
  "yntax:\\nasymmetric_decrypt(algorithm, data_str, priv_key_str)\\n\\nDecrypts an encrypted string using the given algorit"
  "hm and key string,\\nand returns the resulting plaintext as a binary string. If decryption\\nfails, the result is NULL."
  "\\n\\nFor the legacy version of this function in use before MySQL 8.0.29, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/"
  "enterprise-encryption-functions\\n-legacy.html.\\n\\nBy default, the component_enterprise_encryption function assumes th"
  "at\\nencrypted text uses the RSAES-OAEP padding scheme. The function\\nsupports decryption for content encrypted by the"
  " legacy openssl_udf\\nshared library functions if the system variable\\nenterprise_encryption.rsa_support_legacy_paddin"
  "g is set to ON (the\\ndefault is OFF). When ON is set, the function also supports the\\nRSAES-PKCS1-v1_5 padding scheme"
  ", as used by the legacy openssl_udf\\nshared library functions. When OFF is set, content encrypted by the\\nlegacy func"
  "tions cannot be decrypted, and the function returns null\\noutput for such content.\\n\\nalgorithm is the encryption alg"
  "orithm used to create the key. The\\nsupported algorithm value is \\'RSA\\'.\\n\\ndata_str is the encrypted string to decr"
  "ypt, which was encrypted with\\nasymmetric_encrypt().\\n\\npriv_key_str is a valid PEM encoded RSA private key. For succ"
  "essful\\ndecryption, the key string must correspond to the public key string\\nused with asymmetric_encrypt() to produc"
  "e the encrypted string. The\\nasymmetric_encrypt() component function only supports encryption using\\na public key, so"
  " decryption takes place with the corresponding private\\nkey.\\n\\nFor a usage example, see the description of asymmetri"
  "c_encrypt().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html\\n\\n','','https://de"
  "v.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (5,5,'ASYMMETRIC_ENCRYPT','S"
  "yntax:\\nasymmetric_encrypt(algorithm, data_str, pub_key_str)\\n\\nEncrypts a string using the given algorithm and key s"
  "tring, and returns\\nthe resulting ciphertext as a binary string. If encryption fails, the\\nresult is NULL.\\n\\nFor the"
  " legacy version of this function in use before MySQL 8.0.29, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/enterprise-"
  "encryption-functions\\n-legacy.html.\\n\\nalgorithm is the encryption algorithm used to create the key. The\\nsupported a"
  "lgorithm value is \\'RSA\\'.\\n\\ndata_str is the string to encrypt. The length of this string cannot be\\ngreater than th"
  "e key string length in bytes, minus 42 (to account for\\nthe padding).\\n\\npub_key_str is a valid PEM encoded RSA publi"
  "c key. The\\nasymmetric_encrypt() component function only supports encryption using\\na public key.\\n\\nTo recover the o"
  "riginal unencrypted string, pass the encrypted string\\nto asymmetric_decrypt(), along with the other part of the key "
  "pair used\\nfor encryption, as in the following example:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterprise-en"
  "cryption-functions.html\\n\\n','-- Generate private/public key pair\\nSET @priv = create_asymmetric_priv_key(\\'RSA\\', 20"
  "48);\\nSET @pub = create_asymmetric_pub_key(\\'RSA\\', @priv);\\n\\n-- Encrypt using public key, decrypt using private key"
  "\\nSET @ciphertext = asymmetric_encrypt(\\'RSA\\', \\'The quick brown fox\\', @pub);\\nSET @plaintext = asymmetric_decrypt("
  "\\'RSA\\', @ciphertext, @priv);\\n','https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (6,5,'ASYMMETRIC_SIGN','Synt"
  "ax:\\nasymmetric_sign(algorithm, text, priv_key_str, digest_type)\\n\\nSigns a digest string or data string using a priv"
  "ate key, and returns\\nthe signature as a binary string. If signing fails, the result is NULL.\\n\\nFor the legacy versi"
  "on of this function in use before MySQL 8.0.29, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-fu"
  "nctions\\n-legacy.html.\\n\\nalgorithm is the encryption algorithm used to create the key. The\\nsupported algorithm valu"
  "e is \\'RSA\\'.\\n\\ntext is a data string or digest string. The function accepts digests\\nbut does not require them, as "
  "it is also capable of handling data\\nstrings of an arbitrary length. A digest string can be generated by\\ncalling cre"
  "ate_digest().\\n\\npriv_key_str is the private key string to use for signing the digest\\nstring. It must be a valid PEM"
  " encoded RSA private key.\\n\\ndigest_type is the algorithm to be used to sign the data. The supported\\ndigest_type val"
  "ues are \\'SHA224\\', \\'SHA256\\', \\'SHA384\\', and \\'SHA512\\' when\\nOpenSSL 1.0.1 is in use. If OpenSSL 1.1.1 is in use,"
  " the additional\\ndigest_type values \\'SHA3-224\\', \\'SHA3-256\\', \\'SHA3-384\\', and \\'SHA3-512\\'\\nare available.\\n\\nFor"
  " a usage example, see the description of asymmetric_verify().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterpr"
  "ise-encryption-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (7,5,'ASYMMETRIC_VERIFY','Sy"
  "ntax:\\nasymmetric_verify(algorithm, text, sig_str, pub_key_str, digest_type)\\n\\nVerifies whether the signature string"
  " matches the digest string, and\\nreturns 1 or 0 to indicate whether verification succeeded or failed. If\\nverificatio"
  "n fails, the result is NULL.\\n\\nFor the legacy version of this function in use before MySQL 8.0.29, see\\nhttps://dev."
  "mysql.com/doc/refman/8.4/en/enterprise-encryption-functions\\n-legacy.html.\\n\\nBy default, the component_enterprise_en"
  "cryption function assumes that\\nsignatures use the RSASSA-PSS signature scheme. The function supports\\nverification f"
  "or signatures produced by the legacy openssl_udf shared\\nlibrary functions if the system variable\\nenterprise_encrypt"
  "ion.rsa_support_legacy_padding is set to ON (the\\ndefault is OFF). When ON is set, the function also supports the\\nRS"
  "ASSA-PKCS1-v1_5 signature scheme, as used by the legacy openssl_udf\\nshared library functions. When OFF is set, signa"
  "tures produced by the\\nlegacy functions cannot be verified, and the function returns null\\noutput for such content.\\n"
  "\\nalgorithm is the encryption algorithm used to create the key. The\\nsupported algorithm value is \\'RSA\\'.\\n\\ntext is"
  " a data string or digest string. The component function accepts\\ndigests but does not require them, as it is also cap"
  "able of handling\\ndata strings of an arbitrary length. A digest string can be generated\\nby calling create_digest().\\"
  "n\\nsig_str is the signature string to be verified. A signature string can\\nbe generated by calling asymmetric_sign()."
  "\\n\\npub_key_str is the public key string of the signer. It corresponds to\\nthe private key passed to asymmetric_sign("
  ") to generate the signature\\nstring. It must be a valid PEM encoded RSA public key.\\n\\ndigest_type is the algorithm t"
  "hat was used to sign the data. The\\nsupported digest_type values are \\'SHA224\\', \\'SHA256\\', \\'SHA384\\', and\\n\\'SHA51"
  "2\\' when OpenSSL 1.0.1 is in use. If OpenSSL 1.1.1 is in use, the\\nadditional digest_type values \\'SHA3-224\\', \\'SHA3"
  "-256\\', \\'SHA3-384\\', and\\n\\'SHA3-512\\' are available.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterprise-enc"
  "ryption-functions.html\\n\\n','-- Set the encryption algorithm and digest type\\nSET @algo = \\'RSA\\';\\nSET @dig_type = \\"
  "'SHA512\\';\\n\\n-- Create private/public key pair\\nSET @priv = create_asymmetric_priv_key(@algo, 2048);\\nSET @pub = cre"
  "ate_asymmetric_pub_key(@algo, @priv);\\n\\n-- Generate digest from string\\nSET @dig = create_digest(@dig_type, \\'The qu"
  "ick brown fox\\');\\n\\n-- Generate signature for digest and verify signature against digest\\nSET @sig = asymmetric_sign"
  "(@algo, @dig, @priv, @dig_type);\\nSET @verf = asymmetric_verify(@algo, @dig, @sig, @pub, @dig_type);\\n','https://dev."
  "mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (8,5,'CREATE_ASYMMETRIC_PRIV"
  "_KEY','Syntax:\\ncreate_asymmetric_priv_key(algorithm, key_length)\\n\\nCreates a private key using the given algorithm "
  "and key length, and\\nreturns the key as a binary string in PEM format. The key is in PKCS #8\\nformat. If key generati"
  "on fails, the result is NULL.\\n\\nFor the legacy version of this function in use before MySQL 8.0.29, see\\nhttps://dev"
  ".mysql.com/doc/refman/8.4/en/enterprise-encryption-functions\\n-legacy.html.\\n\\nalgorithm is the encryption algorithm "
  "used to create the key. The\\nsupported algorithm value is \\'RSA\\'.\\n\\nkey_length is the key length in bits. If you ex"
  "ceed the maximum allowed\\nkey length or specify less than the minimum, key generation fails and\\nthe result is null o"
  "utput. The minimum allowed key length in bits is\\n2048. The maximum allowed key length is the value of the\\nenterpris"
  "e_encryption.maximum_rsa_key_size system variable, which\\ndefaults to 4096. It has a maximum setting of 16384, which "
  "is the\\nmaximum key length allowed for the RSA algorithm. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/enterprise-enc"
  "ryption-configuri\\nng.html.\\n\\n*Note*:\\n\\nGenerating longer keys can consume significant CPU resources. Limiting\\nthe"
  " key length using the enterprise_encryption.maximum_rsa_key_size\\nsystem variable lets you provide adequate security "
  "for your\\nrequirements while balancing this with resource usage.\\n\\nThis example creates a 2048-bit RSA private key, "
  "then derives a public\\nkey from the private key:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryptio"
  "n-functions.html\\n\\n','SET @priv = create_asymmetric_priv_key(\\'RSA\\', 2048);\\nSET @pub = create_asymmetric_pub_key(\\"
  "'RSA\\', @priv);\\n','https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (9,5,'CREATE_ASYMMETRIC_PUB_"
  "KEY','Syntax:\\ncreate_asymmetric_pub_key(algorithm, priv_key_str)\\n\\nDerives a public key from the given private key "
  "using the given\\nalgorithm, and returns the key as a binary string in PEM format. The\\nkey is in PKCS #8 format. If k"
  "ey derivation fails, the result is NULL.\\n\\nFor the legacy version of this function in use before MySQL 8.0.29, see\\n"
  "https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions\\n-legacy.html.\\n\\nalgorithm is the encryption"
  " algorithm used to create the key. The\\nsupported algorithm value is \\'RSA\\'.\\n\\npriv_key_str is a valid PEM encoded "
  "RSA private key.\\n\\nFor a usage example, see the description of\\ncreate_asymmetric_priv_key().\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/enterprise-encryption-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/enter"
  "prise-encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (10,5,'CREATE_DIGEST','Synta"
  "x:\\ncreate_digest(digest_type, str)\\n\\nCreates a digest from the given string using the given digest type, and\\nretur"
  "ns the digest as a binary string. If digest generation fails, the\\nresult is NULL.\\n\\nFor the legacy version of this "
  "function in use before MySQL 8.0.29, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions\\n-l"
  "egacy.html.\\n\\nThe resulting digest string is suitable for use with asymmetric_sign()\\nand asymmetric_verify(). The c"
  "omponent versions of these functions\\naccept digests but do not require them, as they are capable of handling\\ndata o"
  "f an arbitrary length.\\n\\ndigest_type is the digest algorithm to be used to generate the digest\\nstring. The supporte"
  "d digest_type values are \\'SHA224\\', \\'SHA256\\',\\n\\'SHA384\\', and \\'SHA512\\' when OpenSSL 1.0.1 is in use. If OpenSSL"
  " 1.1.1\\nis in use, the additional digest_type values \\'SHA3-224\\', \\'SHA3-256\\',\\n\\'SHA3-384\\', and \\'SHA3-512\\' are "
  "available.\\n\\nstr is the non-null data string for which the digest is to be\\ngenerated.\\n\\nURL: https://dev.mysql.com"
  "/doc/refman/8.4/en/enterprise-encryption-functions.html\\n\\n','SET @dig = create_digest(\\'SHA512\\', \\'The quick brown "
  "fox\\');\\n','https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (11,5,'ASYMMETRIC_DERIVE','S"
  "yntax:\\nasymmetric_derive(pub_key_str, priv_key_str)\\n\\nDerives a symmetric key using the private key of one party an"
  "d the\\npublic key of another, and returns the resulting key as a binary\\nstring. If key derivation fails, the result "
  "is NULL.\\n\\npub_key_str and priv_key_str are valid PEM encoded key strings that\\nwere created using the DH algorithm."
  "\\n\\nSuppose that you have two pairs of public and private keys:\\n\\nSET @dhp = create_dh_parameters(1024);\\nSET @priv1"
  " = create_asymmetric_priv_key(\\'DH\\', @dhp);\\nSET @pub1 = create_asymmetric_pub_key(\\'DH\\', @priv1);\\nSET @priv2 = cr"
  "eate_asymmetric_priv_key(\\'DH\\', @dhp);\\nSET @pub2 = create_asymmetric_pub_key(\\'DH\\', @priv2);\\n\\nSuppose further th"
  "at you use the private key from one pair and the\\npublic key from the other pair to create a symmetric key string. Th"
  "en\\nthis symmetric key identity relationship holds:\\n\\nasymmetric_derive(@pub1, @priv2) = asymmetric_derive(@pub2, @p"
  "riv1)\\n\\nThis example requires DH private/public keys as inputs, created using a\\nshared symmetric secret. Create the"
  " secret by passing the key length to\\ncreate_dh_parameters(), then pass the secret as the \"key length\" to\\ncreate_a"
  "symmetric_priv_key().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions-legacy.html\\n\\n"
  "','-- Generate DH shared symmetric secret\\nSET @dhp = create_dh_parameters(1024);\\n-- Generate DH key pairs\\nSET @alg"
  "o = \\'DH\\';\\nSET @priv1 = create_asymmetric_priv_key(@algo, @dhp);\\nSET @pub1 = create_asymmetric_pub_key(@algo, @pri"
  "v1);\\nSET @priv2 = create_asymmetric_priv_key(@algo, @dhp);\\nSET @pub2 = create_asymmetric_pub_key(@algo, @priv2);\\n\\"
  "n-- Generate symmetric key using public key of first party,\\n-- private key of second party\\nSET @sym1 = asymmetric_d"
  "erive(@pub1, @priv2);\\n\\n-- Or use public key of second party, private key of first party\\nSET @sym2 = asymmetric_der"
  "ive(@pub2, @priv1);\\n','https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions-legacy.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (12,5,'CREATE_DH_PARAMETERS'"
  ",'create_dh_parameters(key_len)\\n\\nCreates a shared secret for generating a DH private/public key pair and\\nreturns a"
  " binary string that can be passed to\\ncreate_asymmetric_priv_key(). If secret generation fails, the result is\\nNULL.\\"
  "n\\nkey_len is the key length. The minimum and maximum key lengths in bits\\nare 1,024 and 10,000. These key-length lim"
  "its are constraints imposed\\nby OpenSSL. Server administrators can impose additional limits on\\nmaximum key length by"
  " setting the MYSQL_OPENSSL_UDF_RSA_BITS_THRESHOLD,\\nMYSQL_OPENSSL_UDF_DSA_BITS_THRESHOLD, and\\nMYSQL_OPENSSL_UDF_DH_B"
  "ITS_THRESHOLD environment variables. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-configuri\\nng"
  ".html.\\n\\nFor an example showing how to use the return value for generating\\nsymmetric keys, see the description of a"
  "symmetric_derive().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions-legacy.html\\n\\n',"
  "'SET @dhp = create_dh_parameters(1024);\\n','https://dev.mysql.com/doc/refman/8.4/en/enterprise-encryption-functions-l"
  "egacy.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (13,6,'TRUE','The constants "
  "TRUE and FALSE evaluate to 1 and 0, respectively. The\\nconstant names can be written in any lettercase.\\n\\nmysql> SEL"
  "ECT TRUE, true, FALSE, false;\\n        -> 1, 1, 0, 0\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/boolean-literals"
  ".html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/boolean-literals.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (14,6,'FALSE','The constants"
  " TRUE and FALSE evaluate to 1 and 0, respectively. The\\nconstant names can be written in any lettercase.\\n\\nmysql> SE"
  "LECT TRUE, true, FALSE, false;\\n        -> 1, 1, 0, 0\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/boolean-literal"
  "s.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/boolean-literals.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (15,2,'BIT','BIT[(M)]\\n\\nA b"
  "it-value type. M indicates the number of bits per value, from 1 to\\n64. The default is 1 if M is omitted.\\n\\nURL: htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/numeri"
  "c-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (16,2,'TINYINT','TINYINT[(M)"
  "] [UNSIGNED] [ZEROFILL]\\n\\nA very small integer. The signed range is -128 to 127. The unsigned\\nrange is 0 to 255.\\n\\"
  "nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/"
  "en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (17,2,'BOOLEAN','BOOL, BOOLE"
  "AN\\n\\nThese types are synonyms for TINYINT(1). A value of zero is considered\\nfalse. Nonzero values are considered tr"
  "ue:\\n\\nmysql> SELECT IF(0, \\'true\\', \\'false\\');\\n+------------------------+\\n| IF(0, \\'true\\', \\'false\\') |\\n+------"
  "------------------+\\n| false                  |\\n+------------------------+\\n\\nmysql> SELECT IF(1, \\'true\\', \\'false\\"
  "');\\n+------------------------+\\n| IF(1, \\'true\\', \\'false\\') |\\n+------------------------+\\n| true                  "
  " |\\n+------------------------+\\n\\nmysql> SELECT IF(2, \\'true\\', \\'false\\');\\n+------------------------+\\n| IF(2, \\'tr"
  "ue\\', \\'false\\') |\\n+------------------------+\\n| true                   |\\n+------------------------+\\n\\nHowever, th"
  "e values TRUE and FALSE are merely aliases for 1 and 0,\\nrespectively, as shown here:\\n\\nmysql> SELECT IF(0 = FALSE, "
  "\\'true\\', \\'false\\');\\n+--------------------------------+\\n| IF(0 = FALSE, \\'true\\', \\'false\\') |\\n+-----------------"
  "---------------+\\n| true                           |\\n+--------------------------------+\\n\\nmysql> SELECT IF(1 = TRUE"
  ", \\'true\\', \\'false\\');\\n+-------------------------------+\\n| IF(1 = TRUE, \\'true\\', \\'false\\') |\\n+-----------------"
  "--------------+\\n| true                          |\\n+-------------------------------+\\n\\nmysql> SELECT IF(2 = TRUE, \\"
  "'true\\', \\'false\\');\\n+-------------------------------+\\n| IF(2 = TRUE, \\'true\\', \\'false\\') |\\n+--------------------"
  "-----------+\\n| false                         |\\n+-------------------------------+\\n\\nmysql> SELECT IF(2 = FALSE, \\'t"
  "rue\\', \\'false\\');\\n+--------------------------------+\\n| IF(2 = FALSE, \\'true\\', \\'false\\') |\\n+--------------------"
  "------------+\\n| false                          |\\n+--------------------------------+\\n\\nThe last two statements disp"
  "lay the results shown because 2 is equal to\\nneither 1 nor 0.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric"
  "-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (18,2,'SMALLINT','SMALLINT[("
  "M)] [UNSIGNED] [ZEROFILL]\\n\\nA small integer. The signed range is -32768 to 32767. The unsigned\\nrange is 0 to 65535."
  "\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8"
  ".4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (19,2,'MEDIUMINT','MEDIUMINT"
  "[(M)] [UNSIGNED] [ZEROFILL]\\n\\nA medium-sized integer. The signed range is -8388608 to 8388607. The\\nunsigned range i"
  "s 0 to 16777215.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql."
  "com/doc/refman/8.4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (20,2,'INT','INT[(M)] [UNSIG"
  "NED] [ZEROFILL]\\n\\nA normal-size integer. The signed range is -2147483648 to 2147483647.\\nThe unsigned range is 0 to "
  "4294967295.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/d"
  "oc/refman/8.4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (21,2,'INTEGER','INTEGER[(M)"
  "] [UNSIGNED] [ZEROFILL]\\n\\nThis type is a synonym for INT.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric-ty"
  "pe-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (22,2,'BIGINT','BIGINT[(M)] "
  "[UNSIGNED] [ZEROFILL]\\n\\nA large integer. The signed range is -9223372036854775808 to\\n9223372036854775807. The unsig"
  "ned range is 0 to 18446744073709551615.\\n\\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\\n\\n"
  "URL: https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/e"
  "n/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (23,2,'DECIMAL','DECIMAL[(M["
  ",D])] [UNSIGNED] [ZEROFILL]\\n\\nA packed \"exact\" fixed-point number. M is the total number of digits\\n(the precision"
  ") and D is the number of digits after the decimal point\\n(the scale). The decimal point and (for negative numbers) th"
  "e - sign\\nare not counted in M. If D is 0, values have no decimal point or\\nfractional part. The maximum number of di"
  "gits (M) for DECIMAL is 65.\\nThe maximum number of supported decimals (D) is 30. If D is omitted,\\nthe default is 0. "
  "If M is omitted, the default is 10. (There is also a\\nlimit on how long the text of DECIMAL literals can be; see\\nhtt"
  "ps://dev.mysql.com/doc/refman/8.4/en/precision-math-expressions.html\\n.)\\n\\nUNSIGNED, if specified, disallows negativ"
  "e values. The UNSIGNED\\nattribute is deprecated for columns of type DECIMAL (and any synonyms);\\nyou should expect su"
  "pport for it to be removed in a future version of\\nMySQL. Consider using a simple CHECK constraint instead for such\\n"
  "columns.\\n\\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with\\na precision of 65 digits.\\n\\nURL:"
  " https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/nu"
  "meric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (24,2,'DEC','DEC[(M[,D])] [U"
  "NSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\\n\\nThese types are"
  " synonyms for DECIMAL. The FIXED synonym is available\\nfor compatibility with other database systems.\\n\\nURL: https:/"
  "/dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/numeric-ty"
  "pe-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (25,2,'FLOAT','FLOAT[(M,D)] "
  "[UNSIGNED] [ZEROFILL]\\n\\nA small (single-precision) floating-point number. Permissible values\\nare -3.402823466E+38 t"
  "o -1.175494351E-38, 0, and 1.175494351E-38 to\\n3.402823466E+38. These are the theoretical limits, based on the IEEE\\n"
  "standard. The actual range might be slightly smaller depending on your\\nhardware or operating system.\\n\\nM is the tot"
  "al number of digits and D is the number of digits following\\nthe decimal point. If M and D are omitted, values are st"
  "ored to the\\nlimits permitted by the hardware. A single-precision floating-point\\nnumber is accurate to approximately"
  " 7 decimal places.\\n\\nFLOAT(M,D) is a nonstandard MySQL extension. This syntax is deprecated,\\nand you should expect "
  "support for it to be removed in a future version\\nof MySQL.\\n\\nUNSIGNED, if specified, disallows negative values. The"
  " UNSIGNED\\nattribute is deprecated for columns of type FLOAT (and any synonyms)\\nand you should expect support for it"
  " to be removed in a future version\\nof MySQL. Consider using a simple CHECK constraint instead for such\\ncolumns.\\n\\n"
  "Using FLOAT might give you some unexpected problems because all\\ncalculations in MySQL are done with double precision"
  ". See\\nhttps://dev.mysql.com/doc/refman/8.4/en/no-matching-rows.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (26,2,'DOUBLE','DOUBLE[(M,D)"
  "] [UNSIGNED] [ZEROFILL]\\n\\nA normal-size (double-precision) floating-point number. Permissible\\nvalues are -1.7976931"
  "348623157E+308 to -2.2250738585072014E-308, 0, and\\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the"
  "\\ntheoretical limits, based on the IEEE standard. The actual range might\\nbe slightly smaller depending on your hardw"
  "are or operating system.\\n\\nM is the total number of digits and D is the number of digits following\\nthe decimal poin"
  "t. If M and D are omitted, values are stored to the\\nlimits permitted by the hardware. A double-precision floating-po"
  "int\\nnumber is accurate to approximately 15 decimal places.\\n\\nDOUBLE(M,D) is a nonstandard MySQL extension; and is d"
  "eprecated. You\\nshould expect support for this syntax to be removed in a future version\\nof MySQL.\\n\\nUNSIGNED, if sp"
  "ecified, disallows negative values. The UNSIGNED\\nattribute is deprecated for columns of type DOUBLE (and any synonym"
  "s)\\nand you should expect support for it to be removed in a future version\\nof MySQL. Consider using a simple CHECK c"
  "onstraint instead for such\\ncolumns.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n',''"
  ",'https://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (27,2,'DOUBLE PRECISION','DO"
  "UBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\\n[ZEROFILL]\\n\\nThese types are synonyms for DOUBL"
  "E. Exception: If the REAL_AS_FLOAT\\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/numeric-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/numeric"
  "-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (28,2,'DATE','DATE\\n\\nA date"
  ". The supported range is \\'1000-01-01\\' to \\'9999-12-31\\'. MySQL\\ndisplays DATE values in \\'YYYY-MM-DD\\' format, but "
  "permits assignment of\\nvalues to DATE columns using either strings or numbers.\\n\\nURL: https://dev.mysql.com/doc/refm"
  "an/8.4/en/date-and-time-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-type-syntax.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (29,2,'DATETIME','DATETIME[("
  "fsp)]\\n\\nA date and time combination. The supported range is \\'1000-01-01\\n00:00:00.000000\\' to \\'9999-12-31 23:59:59"
  ".499999\\'. MySQL displays\\nDATETIME values in \\'YYYY-MM-DD hh:mm:ss[.fraction]\\' format, but permits\\nassignment of v"
  "alues to DATETIME columns using either strings or\\nnumbers.\\n\\nAn optional fsp value in the range from 0 to 6 may be "
  "given to specify\\nfractional seconds precision. A value of 0 signifies that there is no\\nfractional part. If omitted,"
  " the default precision is 0.\\n\\nAutomatic initialization and updating to the current date and time for\\nDATETIME colu"
  "mns can be specified using DEFAULT and ON UPDATE column\\ndefinition clauses, as described in\\nhttps://dev.mysql.com/d"
  "oc/refman/8.4/en/timestamp-initialization.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-type-sy"
  "ntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (30,2,'TIMESTAMP','TIMESTAMP"
  "[(fsp)]\\n\\nA timestamp. The range is \\'1970-01-01 00:00:01.000000\\' UTC to\\n\\'2038-01-19 03:14:07.499999\\' UTC. TIMES"
  "TAMP values are stored as the\\nnumber of seconds since the epoch (\\'1970-01-01 00:00:00\\' UTC). A\\nTIMESTAMP cannot r"
  "epresent the value \\'1970-01-01 00:00:00\\' because that\\nis equivalent to 0 seconds from the epoch and the value 0 is"
  " reserved\\nfor representing \\'0000-00-00 00:00:00\\', the \"zero\" TIMESTAMP value.\\n\\nAn optional fsp value in the ra"
  "nge from 0 to 6 may be given to specify\\nfractional seconds precision. A value of 0 signifies that there is no\\nfract"
  "ional part. If omitted, the default precision is 0.\\n\\nThe way the server handles TIMESTAMP definitions depends on th"
  "e value\\nof the explicit_defaults_for_timestamp system variable (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-"
  "system-variables.html).\\n\\nIf explicit_defaults_for_timestamp is enabled, there is no automatic\\nassignment of the DE"
  "FAULT CURRENT_TIMESTAMP or ON UPDATE\\nCURRENT_TIMESTAMP attributes to any TIMESTAMP column. They must be\\nincluded ex"
  "plicitly in the column definition. Also, any TIMESTAMP not\\nexplicitly declared as NOT NULL permits NULL values.\\n\\nI"
  "f explicit_defaults_for_timestamp is disabled, the server handles\\nTIMESTAMP as follows:\\n\\nUnless specified otherwis"
  "e, the first TIMESTAMP column in a table is\\ndefined to be automatically set to the date and time of the most recent\\"
  "nmodification if not explicitly assigned a value. This makes TIMESTAMP\\nuseful for recording the timestamp of an INSE"
  "RT or UPDATE operation.\\nYou can also set any TIMESTAMP column to the current date and time by\\nassigning it a NULL v"
  "alue, unless it has been defined with the NULL\\nattribute to permit NULL values.\\n\\nAutomatic initialization and upda"
  "ting to the current date and time can\\nbe specified using DEFAULT CURRENT_TIMESTAMP and ON UPDATE\\nCURRENT_TIMESTAMP "
  "column definition clauses. By default, the first\\nTIMESTAMP column has these properties, as previously noted. However"
  ",\\nany TIMESTAMP column in a table can be defined to have these\\nproperties.\\n\\nURL: https://dev.mysql.com/doc/refman"
  "/8.4/en/date-and-time-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-type-syntax.htm"
  "l');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (31,2,'TIME','TIME[(fsp)]\\n\\"
  "nA time. The range is \\'-838:59:59.000000\\' to \\'838:59:59.000000\\'. MySQL\\ndisplays TIME values in \\'hh:mm:ss[.fract"
  "ion]\\' format, but permits\\nassignment of values to TIME columns using either strings or numbers.\\n\\nAn optional fsp "
  "value in the range from 0 to 6 may be given to specify\\nfractional seconds precision. A value of 0 signifies that the"
  "re is no\\nfractional part. If omitted, the default precision is 0.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/da"
  "te-and-time-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (32,2,'YEAR DATA TYPE','YEAR"
  "[(4)]\\n\\nA year in 4-digit format. MySQL displays YEAR values in YYYY format,\\nbut permits assignment of values to YE"
  "AR columns using either strings\\nor numbers. Values display as 1901 to 2155, or 0000.\\n\\nFor additional information a"
  "bout YEAR display format and interpretation\\nof input values, see https://dev.mysql.com/doc/refman/8.4/en/year.html.\\"
  "n\\n*Note*:\\n\\nThe YEAR(4) data type with an explicit display width is deprecated; you\\nshould expect support for it t"
  "o be removed in a future version of\\nMySQL. Instead, use YEAR without a display width, which has the same\\nmeaning.\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refm"
  "an/8.4/en/date-and-time-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (33,2,'CHAR','[NATIONAL] CHA"
  "R[(M)] [CHARACTER SET charset_name] [COLLATE\\ncollation_name]\\n\\nA fixed-length string that is always right-padded wi"
  "th spaces to the\\nspecified length when stored. M represents the column length in\\ncharacters. The range of M is 0 to"
  " 255. If M is omitted, the length is\\n1.\\n\\n*Note*:\\n\\nTrailing spaces are removed when CHAR values are retrieved unl"
  "ess the\\nPAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-type-syn"
  "tax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (34,2,'CHAR BYTE','The CHAR "
  "BYTE data type is an alias for the BINARY data type. This is a\\ncompatibility feature.\\n\\nURL: https://dev.mysql.com/"
  "doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (35,2,'VARCHAR','[NATIONAL] "
  "VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\\ncollation_name]\\n\\nA variable-length string. M represents the maxim"
  "um column length in\\ncharacters. The range of M is 0 to 65,535. The effective maximum length\\nof a VARCHAR is subject"
  " to the maximum row size (65,535 bytes, which is\\nshared among all columns) and the character set used. For example,\\"
  "nutf8mb3 characters can require up to three bytes per character, so a\\nVARCHAR column that uses the utf8mb3 character"
  " set can be declared to\\nbe a maximum of 21,844 characters. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/column-count"
  "-limit.html.\\n\\nMySQL stores VARCHAR values as a 1-byte or 2-byte length prefix plus\\ndata. The length prefix indicat"
  "es the number of bytes in the value. A\\nVARCHAR column uses one length byte if values require no more than 255\\nbytes"
  ", two length bytes if values may require more than 255 bytes.\\n\\n*Note*:\\n\\nMySQL follows the standard SQL specificat"
  "ion, and does not remove\\ntrailing spaces from VARCHAR values.\\n\\nVARCHAR is shorthand for CHARACTER VARYING. NATIONA"
  "L VARCHAR is the\\nstandard SQL way to define that a VARCHAR column should use some\\npredefined character set. MySQL u"
  "ses utf8mb3 as this predefined\\ncharacter set.\\nhttps://dev.mysql.com/doc/refman/8.4/en/charset-national.html. NVARCH"
  "AR\\nis shorthand for NATIONAL VARCHAR.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','"
  "','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (36,2,'BINARY','BINARY[(M)]\\"
  "n\\nThe BINARY type is similar to the CHAR type, but stores binary byte\\nstrings rather than nonbinary character strin"
  "gs. An optional length M\\nrepresents the column length in bytes. If omitted, M defaults to 1.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax."
  "html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (37,2,'VARBINARY','VARBINARY"
  "(M)\\n\\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\\nbyte strings rather than nonbinary chara"
  "cter strings. M represents the\\nmaximum column length in bytes.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/strin"
  "g-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (38,2,'TINYBLOB','TINYBLOB\\n"
  "\\nA BLOB column with a maximum length of 255 (28 − 1) bytes. Each\\nTINYBLOB value is stored using a 1-byte length p"
  "refix that indicates\\nthe number of bytes in the value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-type-s"
  "yntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (39,2,'TINYTEXT','TINYTEXT ["
  "CHARACTER SET charset_name] [COLLATE collation_name]\\n\\nA TEXT column with a maximum length of 255 (28 − 1) charact"
  "ers. The\\neffective maximum length is less if the value contains multibyte\\ncharacters. Each TINYTEXT value is stored"
  " using a 1-byte length prefix\\nthat indicates the number of bytes in the value.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (40,2,'BLOB','BLOB[(M)]\\n\\nA"
  " BLOB column with a maximum length of 65,535 (216 − 1) bytes. Each\\nBLOB value is stored using a 2-byte length pref"
  "ix that indicates the\\nnumber of bytes in the value.\\n\\nAn optional length M can be given for this type. If this is d"
  "one, MySQL\\ncreates the column as the smallest BLOB type large enough to hold\\nvalues M bytes long.\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-s"
  "yntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (41,2,'TEXT','TEXT[(M)] [CHA"
  "RACTER SET charset_name] [COLLATE collation_name]\\n\\nA TEXT column with a maximum length of 65,535 (216 − 1) charac"
  "ters.\\nThe effective maximum length is less if the value contains multibyte\\ncharacters. Each TEXT value is stored us"
  "ing a 2-byte length prefix that\\nindicates the number of bytes in the value.\\n\\nAn optional length M can be given for"
  " this type. If this is done, MySQL\\ncreates the column as the smallest TEXT type large enough to hold\\nvalues M chara"
  "cters long.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/do"
  "c/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (42,2,'MEDIUMBLOB','MEDIUMBL"
  "OB\\n\\nA BLOB column with a maximum length of 16,777,215 (224 − 1) bytes.\\nEach MEDIUMBLOB value is stored using a 3"
  "-byte length prefix that\\nindicates the number of bytes in the value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (43,2,'MEDIUMTEXT','MEDIUMTE"
  "XT [CHARACTER SET charset_name] [COLLATE collation_name]\\n\\nA TEXT column with a maximum length of 16,777,215 (224 −"
  " 1)\\ncharacters. The effective maximum length is less if the value contains\\nmultibyte characters. Each MEDIUMTEXT va"
  "lue is stored using a 3-byte\\nlength prefix that indicates the number of bytes in the value.\\n\\nURL: https://dev.mysq"
  "l.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (44,2,'LONGBLOB','LONGBLOB\\n"
  "\\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 − 1)\\nbytes. The effective maximum length of LON"
  "GBLOB columns depends on the\\nconfigured maximum packet size in the client/server protocol and\\navailable memory. Eac"
  "h LONGBLOB value is stored using a 4-byte length\\nprefix that indicates the number of bytes in the value.\\n\\nURL: htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-"
  "type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (45,2,'LONGTEXT','LONGTEXT ["
  "CHARACTER SET charset_name] [COLLATE collation_name]\\n\\nA TEXT column with a maximum length of 4,294,967,295 or 4GB ("
  "232 − 1)\\ncharacters. The effective maximum length is less if the value contains\\nmultibyte characters. The effecti"
  "ve maximum length of LONGTEXT columns\\nalso depends on the configured maximum packet size in the client/server\\nproto"
  "col and available memory. Each LONGTEXT value is stored using a\\n4-byte length prefix that indicates the number of by"
  "tes in the value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql."
  "com/doc/refman/8.4/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (46,2,'ENUM','ENUM(\\'value1\\"
  "',\\'value2\\',...) [CHARACTER SET charset_name] [COLLATE\\ncollation_name]\\n\\nAn enumeration. A string object that can "
  "have only one value, chosen\\nfrom the list of values \\'value1\\', \\'value2\\', ..., NULL or the special \\'\\'\\nerror val"
  "ue. ENUM values are represented internally as integers.\\n\\nAn ENUM column can have a maximum of 65,535 distinct eleme"
  "nts.\\n\\nThe maximum supported length of an individual ENUM element is M <= 255\\nand (M x w) <= 1020, where M is the e"
  "lement literal length and w is the\\nnumber of bytes required for the maximum-length character in the\\ncharacter set.\\"
  "n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4"
  "/en/string-type-syntax.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (47,2,'SET DATA TYPE','SET(\\"
  "'value1\\',\\'value2\\',...) [CHARACTER SET charset_name] [COLLATE\\ncollation_name]\\n\\nA set. A string object that can h"
  "ave zero or more values, each of which\\nmust be chosen from the list of values \\'value1\\', \\'value2\\', ... SET\\nvalue"
  "s are represented internally as integers.\\n\\nA SET column can have a maximum of 64 distinct members.\\n\\nThe maximum s"
  "upported length of an individual SET element is M <= 255\\nand (M x w) <= 1020, where M is the element literal length "
  "and w is the\\nnumber of bytes required for the maximum-length character in the\\ncharacter set.\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/string-type-syntax.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-type-syntax"
  ".html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (48,2,'BLOB DATA TYPE','A BL"
  "OB is a binary large object that can hold a variable amount of\\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMB"
  "LOB, and LONGBLOB.\\nThese differ only in the maximum length of the values they can hold.\\nThe four TEXT types are TIN"
  "YTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\\ncorrespond to the four BLOB types and have the same maximum lengths and"
  "\\nstorage requirements. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/storage-requirements.html.\\n\\nURL: https://dev.m"
  "ysql.com/doc/refman/8.4/en/blob.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/blob.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (49,7,'GEOMETRY HIERARCHY','"
  "Geometry is the base class. It is an abstract class. The instantiable\\nsubclasses of Geometry are restricted to zero-"
  ", one-, and\\ntwo-dimensional geometric objects that exist in two-dimensional\\ncoordinate space. All instantiable geom"
  "etry classes are defined so that\\nvalid instances of a geometry class are topologically closed (that is,\\nall defined"
  " geometries include their boundary).\\n\\nThe base Geometry class has subclasses for Point, Curve, Surface, and\\nGeomet"
  "ryCollection:\\n\\no Point represents zero-dimensional objects.\\n\\no Curve represents one-dimensional objects, and has "
  "subclass\\n  LineString, with sub-subclasses Line and LinearRing.\\n\\no Surface is designed for two-dimensional objects"
  " and has subclass\\n  Polygon.\\n\\no GeometryCollection has specialized zero-, one-, and two-dimensional\\n  collection "
  "classes named MultiPoint, MultiLineString, and\\n  MultiPolygon for modeling geometries corresponding to collections o"
  "f\\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\\n  MultiSurface are introduced as abstract super"
  "classes that generalize\\n  the collection interfaces to handle Curves and Surfaces.\\n\\nGeometry, Curve, Surface, Mult"
  "iCurve, and MultiSurface are defined as\\nnoninstantiable classes. They define a common set of methods for their\\nsubc"
  "lasses and are included for extensibility.\\n\\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\\nMultiLineS"
  "tring, and MultiPolygon are instantiable classes.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-geometry-class-"
  "hierarchy.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-geometry-class-hierarchy.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (50,8,'MBR DEFINITION','Its "
  "MBR (minimum bounding rectangle), or envelope. This is the bounding\\ngeometry, formed by the minimum and maximum (X,Y"
  ") coordinates:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-class-geometry.html\\n\\n','((MINX MINY, MAXX MINY, "
  "MAXX MAXY, MINX MAXY, MINX MINY))\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-class-geometry.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (51,9,'WKT DEFINITION','The "
  "Well-Known Text (WKT) representation of geometry values is designed\\nfor exchanging geometry data in ASCII form. The "
  "OpenGIS specification\\nprovides a Backus-Naur grammar that specifies the formal production\\nrules for writing WKT val"
  "ues (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/spatial-types.html).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/e"
  "n/gis-data-formats.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-data-formats.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (52,7,'SPATIAL COLUMNS','MyS"
  "QL provides a standard way of creating spatial columns for geometry\\ntypes, for example, with CREATE TABLE or ALTER T"
  "ABLE. Spatial columns\\nare supported for MyISAM, InnoDB, NDB, and ARCHIVE tables. See also the\\nnotes about spatial i"
  "ndexes under [HELP SPATIAL indexes].\\n\\nColumns with a spatial data type can have an SRID attribute, to\\nexplicitly i"
  "ndicate the spatial reference system (SRS) for values\\nstored in the column. For implications of an SRID-restricted c"
  "olumn,\\nsee https://dev.mysql.com/doc/refman/8.4/en/spatial-type-overview.html.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/creating-spatial-columns.html\\n\\n','CREATE TABLE geom (g GEOMETRY);\\n','https://dev.mysql.com/doc/refman/8"
  ".4/en/creating-spatial-columns.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (53,7,'SPATIAL INDEXES','For"
  " InnoDB and MyISAM tables, MySQL can create spatial indexes using\\nsyntax similar to that for creating regular indexe"
  "s, but using the\\nSPATIAL keyword. Columns in spatial indexes must be declared NOT NULL.\\nThe following examples demo"
  "nstrate how to create spatial indexes:\\n\\no With CREATE TABLE:\\n\\nCREATE TABLE geom (g GEOMETRY NOT NULL SRID 4326, S"
  "PATIAL INDEX(g));\\n\\no With ALTER TABLE:\\n\\nCREATE TABLE geom (g GEOMETRY NOT NULL SRID 4326);\\nALTER TABLE geom ADD "
  "SPATIAL INDEX(g);\\n\\no With CREATE INDEX:\\n\\nCREATE TABLE geom (g GEOMETRY NOT NULL SRID 4326);\\nCREATE SPATIAL INDEX"
  " g ON geom (g);\\n\\nSPATIAL INDEX creates an R-tree index. For storage engines that support\\nnonspatial indexing of sp"
  "atial columns, the engine creates a B-tree\\nindex. A B-tree index on spatial values is useful for exact-value\\nlookup"
  "s, but not for range scans.\\n\\nThe optimizer can use spatial indexes defined on columns that are\\nSRID-restricted. Fo"
  "r more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/spatial-type-overview.html, and\\nhttps://dev.mysql.c"
  "om/doc/refman/8.4/en/spatial-index-optimization.html\\n.\\n\\nFor more information on indexing spatial columns, see [HEL"
  "P CREATE\\nINDEX].\\n\\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\\n\\no With ALTER TABLE:\\n\\nALTER TABLE ge"
  "om DROP INDEX g;\\n\\no With DROP INDEX:\\n\\nDROP INDEX g ON geom;\\n\\nExample: Suppose that a table geom contains more t"
  "han 32,000\\ngeometries, which are stored in the column g of type GEOMETRY. The\\ntable also has an AUTO_INCREMENT colu"
  "mn fid for storing object ID\\nvalues.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/creating-spatial-indexes.html\\n"
  "\\n','','https://dev.mysql.com/doc/refman/8.4/en/creating-spatial-indexes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (54,10,'=','=\\n\\nEqual:\\n\\nU"
  "RL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 1 = 0;\\n        -> 0\\nmysql"
  "> SELECT \\'0\\' = 0;\\n        -> 1\\nmysql> SELECT \\'0.0\\' = 0;\\n        -> 1\\nmysql> SELECT \\'0.01\\' = 0;\\n        -> "
  "0\\nmysql> SELECT \\'.01\\' = 0.01;\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (55,10,'<=>','Syntax:\\n<=>\\n"
  "\\nNULL-safe equal. This operator performs an equality comparison like the\\n= operator, but returns 1 rather than NULL"
  " if both operands are NULL,\\nand 0 rather than NULL if one operand is NULL.\\n\\nThe <=> operator is equivalent to the "
  "standard SQL IS NOT DISTINCT FROM\\noperator.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.htm"
  "l\\n\\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\\n        -> 1, 1, 0\\nmysql> SELECT 1 = 1, NULL = NULL, 1 = "
  "NULL;\\n        -> 1, NULL, NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (56,10,'!=','Syntax:\\n<>, !="
  "\\n\\nNot equal:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT \\'.01\\' "
  "<> \\'0.01\\';\\n        -> 1\\nmysql> SELECT .01 <> \\'0.01\\';\\n        -> 0\\nmysql> SELECT \\'zapp\\' <> \\'zappp\\';\\n     "
  "   -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (57,10,'<=','Syntax:\\n<=\\n\\n"
  "Less than or equal:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 0.1"
  " <= 2;\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (58,10,'<','Syntax:\\n<\\n\\nLe"
  "ss than:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 2 < 2;\\n      "
  "  -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (59,10,'>=','Syntax:\\n>=\\n\\n"
  "Greater than or equal:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT "
  "2 >= 2;\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (60,10,'>','Syntax:\\n>\\n\\nGr"
  "eater than:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 2 > 2;\\n   "
  "     -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (61,10,'BETWEEN AND','Syntax"
  ":\\nexpr BETWEEN min AND max\\n\\nIf expr is greater than or equal to min and expr is less than or equal\\nto max, BETWEE"
  "N returns 1, otherwise it returns 0. This is equivalent\\nto the expression (min <= expr AND expr <= max) if all the a"
  "rguments\\nare of the same type. Otherwise type conversion takes place according\\nto the rules described in\\nhttps://d"
  "ev.mysql.com/doc/refman/8.4/en/type-conversion.html, but\\napplied to all the three arguments.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 2 BETWEEN 1 AND 3, 2 BETWEEN 3 and 1;\\n       "
  " -> 1, 0\\nmysql> SELECT 1 BETWEEN 2 AND 3;\\n        -> 0\\nmysql> SELECT \\'b\\' BETWEEN \\'a\\' AND \\'c\\';\\n        -> 1\\"
  "nmysql> SELECT 2 BETWEEN 2 AND \\'3\\';\\n        -> 1\\nmysql> SELECT 2 BETWEEN 2 AND \\'x-3\\';\\n        -> 0\\n','https:/"
  "/dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (62,10,'NOT BETWEEN','Syntax"
  ":\\nexpr NOT BETWEEN min AND max\\n\\nThis is the same as NOT (expr BETWEEN min AND max).\\n\\nURL: https://dev.mysql.com/"
  "doc/refman/8.4/en/comparison-operators.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.htm"
  "l');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (63,10,'COALESCE','Syntax:\\n"
  "COALESCE(value,...)\\n\\nReturns the first non-NULL value in the list, or NULL if there are no\\nnon-NULL values.\\n\\nThe"
  " return type of COALESCE() is the aggregated type of the argument\\ntypes.\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/comparison-operators.html\\n\\n','mysql> SELECT COALESCE(NULL,1);\\n        -> 1\\nmysql> SELECT COALESCE(NULL,NULL,"
  "NULL);\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (64,10,'GREATEST','Syntax:\\n"
  "GREATEST(value1,value2,...)\\n\\nWith two or more arguments, returns the largest (maximum-valued)\\nargument. The argume"
  "nts are compared using the same rules as for\\nLEAST().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-ope"
  "rators.html\\n\\n','mysql> SELECT GREATEST(2,0);\\n        -> 2\\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\\n        ->"
  " 767.0\\nmysql> SELECT GREATEST(\\'B\\',\\'A\\',\\'C\\');\\n        -> \\'C\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/comp"
  "arison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (65,10,'IN','Syntax:\\nexpr I"
  "N (value,...)\\n\\nReturns 1 (true) if expr is equal to any of the values in the IN()\\nlist, else returns 0 (false).\\n\\"
  "nType conversion takes place according to the rules described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/type-conver"
  "sion.html, applied\\nto all the arguments. If no type conversion is needed for the values in\\nthe IN() list, they are "
  "all non-JSON constants of the same type, and\\nexpr can be compared to each of them as a value of the same type\\n(poss"
  "ibly after type conversion), an optimization takes place. The\\nvalues the list are sorted and the search for expr is "
  "done using a\\nbinary search, which makes the IN() operation very quick.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/"
  "en/comparison-operators.html\\n\\n','mysql> SELECT 2 IN (0,3,5,7);\\n        -> 0\\nmysql> SELECT \\'wefwf\\' IN (\\'wee\\',\\"
  "'wefwf\\',\\'weg\\');\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (66,10,'NOT IN','Syntax:\\nex"
  "pr NOT IN (value,...)\\n\\nThis is the same as NOT (expr IN (value,...)).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/"
  "en/comparison-operators.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (67,10,'INTERVAL','Syntax:\\n"
  "INTERVAL(N,N1,N2,N3,...)\\n\\nReturns 0 if N <= N1, 1 if N <= N2 and so on, or -1 if N is NULL. All\\narguments are trea"
  "ted as integers. It is required that N1 <= N2 <= N3\\n<= ... <= Nn for this function to work correctly. This is becaus"
  "e a\\nbinary search is used (very fast).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n"
  "','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\\n        -> 3\\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\\n"
  "        -> 2\\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\\n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/"
  "comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (68,10,'IS','Syntax:\\nIS boo"
  "lean_value\\n\\nTests a value against a boolean value, where boolean_value can be TRUE,\\nFALSE, or UNKNOWN.\\n\\nURL: htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNK"
  "NOWN;\\n        -> 1, 1, 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (69,10,'IS NOT','Syntax:\\nIS"
  " NOT boolean_value\\n\\nTests a value against a boolean value, where boolean_value can be TRUE,\\nFALSE, or UNKNOWN.\\n\\n"
  "URL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\n','mysql> SELECT 1 IS NOT UNKNOWN, 0 IS NOT"
  " UNKNOWN, NULL IS NOT UNKNOWN;\\n        -> 1, 1, 0\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (70,10,'IS NULL','Syntax:\\nI"
  "S NULL\\n\\nTests whether a value is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n\\"
  "n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\\n        -> 0, 0, 1\\n','https://dev.mysql.com/doc/refman/8.4/en"
  "/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (71,10,'IS NOT NULL','Syntax"
  ":\\nIS NOT NULL\\n\\nTests whether a value is not NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-opera"
  "tors.html\\n\\n','mysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\\n        -> 1, 1, 0\\n','https://dev.mys"
  "ql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (72,10,'ISNULL','Syntax:\\nIS"
  "NULL(expr)\\n\\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\\n\\nURL: https://dev.mysql.com/doc/refman/8"
  ".4/en/comparison-operators.html\\n\\n','mysql> SELECT ISNULL(1+1);\\n        -> 0\\nmysql> SELECT ISNULL(1/0);\\n        -"
  "> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (73,10,'LEAST','Syntax:\\nLEA"
  "ST(value1,value2,...)\\n\\nWith two or more arguments, returns the smallest (minimum-valued)\\nargument. The arguments a"
  "re compared using the following rules:\\n\\no If any argument is NULL, the result is NULL. No comparison is needed.\\n\\n"
  "o If all arguments are integer-valued, they are compared as integers.\\n\\no If at least one argument is double precisi"
  "on, they are compared as\\n  double-precision values. Otherwise, if at least one argument is a\\n  DECIMAL value, they "
  "are compared as DECIMAL values.\\n\\no If the arguments comprise a mix of numbers and strings, they are\\n  compared as "
  "strings.\\n\\no If any argument is a nonbinary (character) string, the arguments are\\n  compared as nonbinary strings.\\"
  "n\\no In all other cases, the arguments are compared as binary strings.\\n\\nThe return type of LEAST() is the aggregate"
  "d type of the comparison\\nargument types.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html\\n"
  "\\n','mysql> SELECT LEAST(2,0);\\n        -> 0\\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\\n        -> 3.0\\nmysql> SELECT"
  " LEAST(\\'B\\',\\'A\\',\\'C\\');\\n        -> \\'A\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/comparison-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (74,11,'!','Syntax:\\nNOT, !\\"
  "n\\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\\nnonzero, and NOT NULL returns NULL.\\n\\nUR"
  "L: https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html\\n\\n','mysql> SELECT NOT 10;\\n        -> 0\\nmysql> S"
  "ELECT NOT 0;\\n        -> 1\\nmysql> SELECT NOT NULL;\\n        -> NULL\\nmysql> SELECT ! (1+1);\\n        -> 0\\nmysql> SE"
  "LECT ! 1+1;\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (75,11,'AND','Syntax:\\nAND, "
  "&&\\n\\nLogical AND. Evaluates to 1 if all operands are nonzero and not NULL,\\nto 0 if one or more operands are 0, othe"
  "rwise NULL is returned.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html\\n\\n','mysql> SELECT 1 "
  "AND 1;\\n        -> 1\\nmysql> SELECT 1 AND 0;\\n        -> 0\\nmysql> SELECT 1 AND NULL;\\n        -> NULL\\nmysql> SELECT"
  " 0 AND NULL;\\n        -> 0\\nmysql> SELECT NULL AND 0;\\n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/logic"
  "al-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (76,11,'OR','Syntax:\\nOR, ||"
  "\\n\\nLogical OR. When both operands are non-NULL, the result is 1 if any\\noperand is nonzero, and 0 otherwise. With a "
  "NULL operand, the result is\\n1 if the other operand is nonzero, and NULL otherwise. If both operands\\nare NULL, the r"
  "esult is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html\\n\\n','mysql> SELECT 1 OR 1;\\n  "
  "      -> 1\\nmysql> SELECT 1 OR 0;\\n        -> 1\\nmysql> SELECT 0 OR 0;\\n        -> 0\\nmysql> SELECT 0 OR NULL;\\n     "
  "   -> NULL\\nmysql> SELECT 1 OR NULL;\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html"
  "');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (77,11,'XOR','Syntax:\\nXOR\\n"
  "\\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\\noperands, evaluates to 1 if an odd number of ope"
  "rands is nonzero,\\notherwise 0 is returned.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html\\n\\"
  "n','mysql> SELECT 1 XOR 1;\\n        -> 0\\nmysql> SELECT 1 XOR 0;\\n        -> 1\\nmysql> SELECT 1 XOR NULL;\\n        ->"
  " NULL\\nmysql> SELECT 1 XOR 1 XOR 1;\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/logical-operators.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (78,11,'ASSIGN-VALUE','Synta"
  "x:\\n:=\\n\\nAssignment operator. Causes the user variable on the left hand side of\\nthe operator to take on the value t"
  "o its right. The value on the right\\nhand side may be a literal value, another variable storing a value, or\\nany lega"
  "l expression that yields a scalar value, including the result\\nof a query (provided that this value is a scalar value"
  "). You can\\nperform multiple assignments in the same SET statement. You can perform\\nmultiple assignments in the same"
  " statement.\\n\\nUnlike =, the := operator is never interpreted as a comparison\\noperator. This means you can use := in"
  " any valid SQL statement (not\\njust in SET statements) to assign a value to a variable.\\n\\nURL: https://dev.mysql.com"
  "/doc/refman/8.4/en/assignment-operators.html\\n\\n','mysql> SELECT @var1, @var2;\\n        -> NULL, NULL\\nmysql> SELECT "
  "@var1 := 1, @var2;\\n        -> 1, NULL\\nmysql> SELECT @var1, @var2;\\n        -> 1, NULL\\nmysql> SELECT @var1, @var2 :"
  "= @var1;\\n        -> 1, 1\\nmysql> SELECT @var1, @var2;\\n        -> 1, 1\\n\\nmysql> SELECT @var1:=COUNT(*) FROM t1;\\n  "
  "      -> 4\\nmysql> SELECT @var1;\\n        -> 4\\n','https://dev.mysql.com/doc/refman/8.4/en/assignment-operators.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (79,11,'ASSIGN-EQUAL','Synta"
  "x:\\n=\\n\\nThis operator is used to perform value assignments in two cases,\\ndescribed in the next two paragraphs.\\n\\nW"
  "ithin a SET statement, = is treated as an assignment operator that\\ncauses the user variable on the left hand side of"
  " the operator to take\\non the value to its right. (In other words, when used in a SET\\nstatement, = is treated identi"
  "cally to :=.) The value on the right hand\\nside may be a literal value, another variable storing a value, or any\\nleg"
  "al expression that yields a scalar value, including the result of a\\nquery (provided that this value is a scalar valu"
  "e). You can perform\\nmultiple assignments in the same SET statement.\\n\\nIn the SET clause of an UPDATE statement, = a"
  "lso acts as an assignment\\noperator; in this case, however, it causes the column named on the left\\nhand side of the "
  "operator to assume the value given to the right,\\nprovided any WHERE conditions that are part of the UPDATE are met. "
  "You\\ncan make multiple assignments in the same SET clause of an UPDATE\\nstatement.\\n\\nIn any other context, = is trea"
  "ted as a comparison operator.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/assignment-operators.html\\n\\n','mysql> "
  "SELECT @var1, @var2;\\n        -> NULL, NULL\\nmysql> SELECT @var1 := 1, @var2;\\n        -> 1, NULL\\nmysql> SELECT @var"
  "1, @var2;\\n        -> 1, NULL\\nmysql> SELECT @var1, @var2 := @var1;\\n        -> 1, 1\\nmysql> SELECT @var1, @var2;\\n  "
  "      -> 1, 1\\n','https://dev.mysql.com/doc/refman/8.4/en/assignment-operators.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (80,12,'CASE OPERATOR','Synt"
  "ax:\\nCASE value WHEN compare_value THEN result [WHEN compare_value THEN\\nresult ...] [ELSE result] END\\n\\nCASE WHEN c"
  "ondition THEN result [WHEN condition THEN result ...] [ELSE\\nresult] END\\n\\nThe first CASE syntax returns the result "
  "for the first\\nvalue=compare_value comparison that is true. The second syntax returns\\nthe result for the first condi"
  "tion that is true. If no comparison or\\ncondition is true, the result after ELSE is returned, or NULL if there\\nis no"
  " ELSE part.\\n\\n*Note*:\\n\\nThe syntax of the CASE operator described here differs slightly from\\nthat of the SQL CASE "
  "statement described in [HELP CASE statement], for\\nuse inside stored programs. The CASE statement cannot have an ELSE"
  " NULL\\nclause, and it is terminated with END CASE instead of END.\\n\\nThe return type of a CASE expression result is t"
  "he aggregated type of\\nall result values:\\n\\no If all types are numeric, the aggregated type is also numeric:\\n\\n  o "
  "If at least one argument is double precision, the result is double\\n    precision.\\n\\n  o Otherwise, if at least one "
  "argument is DECIMAL, the result is\\n    DECIMAL.\\n\\n  o Otherwise, the result is an integer type (with one exception)"
  ":\\n\\n    o If all integer types are all signed or all unsigned, the result\\n      is the same sign and the precision "
  "is the highest of all\\n      specified integer types (that is, TINYINT, SMALLINT, MEDIUMINT,\\n      INT, or BIGINT).\\"
  "n\\n    o If there is a combination of signed and unsigned integer types,\\n      the result is signed and the precisio"
  "n may be higher. For\\n      example, if the types are signed INT and unsigned INT, the result\\n      is signed BIGINT"
  ".\\n\\n    o The exception is unsigned BIGINT combined with any signed integer\\n      type. The result is DECIMAL with "
  "sufficient precision and scale\\n      0.\\n\\no If all types are BIT, the result is BIT. Otherwise, BIT arguments are\\n"
  "  treated similar to BIGINT.\\n\\no If all types are YEAR, the result is YEAR. Otherwise, YEAR arguments\\n  are treated"
  " similar to INT.\\n\\no If all types are character string (CHAR or VARCHAR), the result is\\n  VARCHAR with maximum leng"
  "th determined by the longest character\\n  length of the operands.\\n\\no If all types are character or binary string, t"
  "he result is VARBINARY.\\n\\no SET and ENUM are treated similar to VARCHAR; the result is VARCHAR.\\n\\no If all types ar"
  "e JSON, the result is JSON.\\n\\no If all types are temporal, the result is temporal:\\n\\n  o If all temporal types are "
  "DATE, TIME, or TIMESTAMP, the result is\\n    DATE, TIME, or TIMESTAMP, respectively.\\n\\n  o Otherwise, for a mix of t"
  "emporal types, the result is DATETIME.\\n\\no If all types are GEOMETRY, the result is GEOMETRY.\\n\\no If any type is BL"
  "OB, the result is BLOB.\\n\\no For all other type combinations, the result is VARCHAR.\\n\\no Literal NULL operands are i"
  "gnored for type aggregation.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/flow-control-functions.html\\n\\n','mysql>"
  " SELECT CASE 1 WHEN 1 THEN \\'one\\'\\n    ->     WHEN 2 THEN \\'two\\' ELSE \\'more\\' END;\\n        -> \\'one\\'\\nmysql> SEL"
  "ECT CASE WHEN 1>0 THEN \\'true\\' ELSE \\'false\\' END;\\n        -> \\'true\\'\\nmysql> SELECT CASE BINARY \\'B\\'\\n    ->    "
  " WHEN \\'a\\' THEN 1 WHEN \\'b\\' THEN 2 END;\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/flow-control-f"
  "unctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (81,12,'IF FUNCTION','Syntax"
  ":\\nIF(expr1,expr2,expr3)\\n\\nIf expr1 is TRUE (expr1 <> 0 and expr1 IS NOT NULL), IF() returns\\nexpr2. Otherwise, it r"
  "eturns expr3.\\n\\n*Note*:\\n\\nThere is also an IF statement, which differs from the IF() function\\ndescribed here. See "
  "[HELP IF statement].\\n\\nIf only one of expr2 or expr3 is explicitly NULL, the result type of\\nthe IF() function is th"
  "e type of the non-NULL expression.\\n\\nThe default return type of IF() (which may matter when it is stored\\ninto a tem"
  "porary table) is calculated as follows:\\n\\no If expr2 or expr3 produce a string, the result is a string.\\n\\n  If expr"
  "2 and expr3 are both strings, the result is case-sensitive if\\n  either string is case-sensitive.\\n\\no If expr2 or ex"
  "pr3 produce a floating-point value, the result is a\\n  floating-point value.\\n\\no If expr2 or expr3 produce an intege"
  "r, the result is an integer.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/flow-control-functions.html\\n\\n','mysql>"
  " SELECT IF(1>2,2,3);\\n        -> 3\\nmysql> SELECT IF(1<2,\\'yes\\',\\'no\\');\\n        -> \\'yes\\'\\nmysql> SELECT IF(STRCM"
  "P(\\'test\\',\\'test1\\'),\\'no\\',\\'yes\\');\\n        -> \\'no\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/flow-control-fu"
  "nctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (82,12,'IFNULL','Syntax:\\nIF"
  "NULL(expr1,expr2)\\n\\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\\nexpr2.\\n\\nURL: https://dev.m"
  "ysql.com/doc/refman/8.4/en/flow-control-functions.html\\n\\n','mysql> SELECT IFNULL(1,0);\\n        -> 1\\nmysql> SELECT "
  "IFNULL(NULL,10);\\n        -> 10\\nmysql> SELECT IFNULL(1/0,10);\\n        -> 10\\nmysql> SELECT IFNULL(1/0,\\'yes\\');\\n  "
  "      -> \\'yes\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/flow-control-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (83,12,'NULLIF','Syntax:\\nNU"
  "LLIF(expr1,expr2)\\n\\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\\nthe same as CASE WHEN e"
  "xpr1 = expr2 THEN NULL ELSE expr1 END.\\n\\nThe return value has the same type as the first argument.\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/flow-control-functions.html\\n\\n','mysql> SELECT NULLIF(1,1);\\n        -> NULL\\nmysql> "
  "SELECT NULLIF(1,2);\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/flow-control-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (84,13,'+','Syntax:\\n+\\n\\nAd"
  "dition:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html\\n\\n','mysql> SELECT 3+5;\\n        -"
  "> 8\\n','https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (85,13,'- BINARY','Syntax:\\n"
  "-\\n\\nSubtraction:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html\\n\\n','mysql> SELECT 3-5;\\"
  "n        -> -2\\n','https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (86,13,'- UNARY','Syntax:\\n-"
  "\\n\\nUnary minus. This operator changes the sign of the operand.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/arith"
  "metic-functions.html\\n\\n','mysql> SELECT - 2;\\n        -> -2\\n','https://dev.mysql.com/doc/refman/8.4/en/arithmetic-f"
  "unctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (87,13,'*','Syntax:\\n*\\n\\nMu"
  "ltiplication:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html\\n\\n','mysql> SELECT 3*5;\\n   "
  "     -> 15\\nmysql> SELECT 18014398509481984*18014398509481984.0;\\n        -> 324518553658426726783156020576256.0\\nmys"
  "ql> SELECT 18014398509481984*18014398509481984;\\n        -> out-of-range error\\n','https://dev.mysql.com/doc/refman/8"
  ".4/en/arithmetic-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (88,13,'/','Syntax:\\n/\\n\\nDi"
  "vision:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html\\n\\n','mysql> SELECT 3/5;\\n        -"
  "> 0.60\\n','https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (89,13,'DIV','Syntax:\\nDIV\\n"
  "\\nInteger division. Discards from the division result any fractional part\\nto the right of the decimal point.\\n\\nIf e"
  "ither operand has a noninteger type, the operands are converted to\\nDECIMAL and divided using DECIMAL arithmetic befo"
  "re converting the\\nresult to BIGINT. If the result exceeds BIGINT range, an error occurs.\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/arithmetic-functions.html\\n\\n','mysql> SELECT 5 DIV 2, -5 DIV 2, 5 DIV -2, -5 DIV -2;\\n        -"
  "> 2, -2, -2, 2\\n','https://dev.mysql.com/doc/refman/8.4/en/arithmetic-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (90,13,'%','Syntax:\\nN % M, "
  "N MOD M\\n\\nModulo operation. Returns the remainder of N divided by M. For more\\ninformation, see the description for "
  "the MOD() function in\\nhttps://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html.\\n\\nURL: https://dev.mysql"
  ".com/doc/refman/8.4/en/arithmetic-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/arithmetic-function"
  "s.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (91,13,'ABS','Syntax:\\nABS(X"
  ")\\n\\nReturns the absolute value of X, or NULL if X is NULL.\\n\\nThe result type is derived from the argument type. An "
  "implication of\\nthis is that ABS(-9223372036854775808) produces an error because the\\nresult cannot be stored in a si"
  "gned BIGINT value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT AB"
  "S(2);\\n        -> 2\\nmysql> SELECT ABS(-32);\\n        -> 32\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-"
  "functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (92,13,'ACOS','Syntax:\\nACOS"
  "(X)\\n\\nReturns the arc cosine of X, that is, the value whose cosine is X.\\nReturns NULL if X is not in the range -1 t"
  "o 1, or if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT"
  " ACOS(1);\\n        -> 0\\nmysql> SELECT ACOS(1.0001);\\n        -> NULL\\nmysql> SELECT ACOS(0);\\n        -> 1.570796326"
  "7949\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (93,13,'ASIN','Syntax:\\nASIN"
  "(X)\\n\\nReturns the arc sine of X, that is, the value whose sine is X. Returns\\nNULL if X is not in the range -1 to 1,"
  " or if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT ASI"
  "N(0.2);\\n        -> 0.20135792079033\\nmysql> SELECT ASIN(\\'foo\\');\\n\\n+-------------+\\n| ASIN(\\'foo\\') |\\n+----------"
  "---+\\n|           0 |\\n+-------------+\\n1 row in set, 1 warning (0.00 sec)\\n\\nmysql> SHOW WARNINGS;\\n+---------+-----"
  "-+-----------------------------------------+\\n| Level   | Code | Message                                 |\\n+--------"
  "-+------+-----------------------------------------+\\n| Warning | 1292 | Truncated incorrect DOUBLE value: \\'foo\\' |\\n"
  "+---------+------+-----------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical"
  "-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (94,13,'ATAN','Syntax:\\nATAN"
  "(X)\\n\\nReturns the arc tangent of X, that is, the value whose tangent is X.\\nReturns NULL if X is NULL\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT ATAN(2);\\n        -> 1.107148717794"
  "1\\nmysql> SELECT ATAN(-2);\\n        -> -1.1071487177941\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-func"
  "tions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (95,13,'ATAN2','Syntax:\\nATA"
  "N(Y,X), ATAN2(Y,X)\\n\\nReturns the arc tangent of the two variables X and Y. It is similar to\\ncalculating the arc tan"
  "gent of Y / X, except that the signs of both\\narguments are used to determine the quadrant of the result. Returns\\nNU"
  "LL if X or Y is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT"
  " ATAN(-2,2);\\n        -> -0.78539816339745\\nmysql> SELECT ATAN2(PI(),0);\\n        -> 1.5707963267949\\n','https://dev."
  "mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (96,13,'CEIL','Syntax:\\nCEIL"
  "(X)\\n\\nCEIL() is a synonym for CEILING().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html"
  "\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (97,13,'CEILING','Syntax:\\nC"
  "EILING(X)\\n\\nReturns the smallest integer value not less than X. Returns NULL if X\\nis NULL.\\n\\nURL: https://dev.mysq"
  "l.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT CEILING(1.23);\\n        -> 2\\nmysql> SELECT C"
  "EILING(-1.23);\\n        -> -1\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (98,13,'CONV','Syntax:\\nCONV"
  "(N,from_base,to_base)\\n\\nConverts numbers between different number bases. Returns a string\\nrepresentation of the num"
  "ber N, converted from base from_base to base\\nto_base. Returns NULL if any argument is NULL. The argument N is\\ninter"
  "preted as an integer, but may be specified as an integer or a\\nstring. The minimum base is 2 and the maximum base is "
  "36. If from_base\\nis a negative number, N is regarded as a signed number. Otherwise, N is\\ntreated as unsigned. CONV("
  ") works with 64-bit precision.\\n\\nCONV() returns NULL if any of its arguments are NULL.\\n\\nURL: https://dev.mysql.com"
  "/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT CONV(\\'a\\',16,2);\\n        -> \\'1010\\'\\nmysql> SEL"
  "ECT CONV(\\'6E\\',18,8);\\n        -> \\'172\\'\\nmysql> SELECT CONV(-17,10,-18);\\n        -> \\'-H\\'\\nmysql> SELECT CONV(10"
  "+\\'10\\'+\\'10\\'+X\\'0a\\',10,10);\\n        -> \\'40\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions."
  "html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (99,13,'COS','Syntax:\\nCOS(X"
  ")\\n\\nReturns the cosine of X, where X is given in radians. Returns NULL if X\\nis NULL.\\n\\nURL: https://dev.mysql.com/"
  "doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT COS(PI());\\n        -> -1\\n','https://dev.mysql.com"
  "/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (100,13,'COT','Syntax:\\nCOT("
  "X)\\n\\nReturns the cotangent of X. Returns NULL if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathemat"
  "ical-functions.html\\n\\n','mysql> SELECT COT(12);\\n        -> -1.5726734063977\\nmysql> SELECT COT(0);\\n        -> out-"
  "of-range error\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (101,13,'CRC32','Syntax:\\nCR"
  "C32(expr)\\n\\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\\nvalue. The result is NULL if the"
  " argument is NULL. The argument is\\nexpected to be a string and (if possible) is treated as one if it is\\nnot.\\n\\nURL"
  ": https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT CRC32(\\'MySQL\\');\\n        "
  "-> 3259397556\\nmysql> SELECT CRC32(\\'mysql\\');\\n        -> 2501908538\\n','https://dev.mysql.com/doc/refman/8.4/en/mat"
  "hematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (102,13,'DEGREES','Syntax:\\n"
  "DEGREES(X)\\n\\nReturns the argument X, converted from radians to degrees. Returns NULL\\nif X is NULL.\\n\\nURL: https://"
  "dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT DEGREES(PI());\\n        -> 180\\nmysql"
  "> SELECT DEGREES(PI() / 2);\\n        -> 90\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (103,13,'EXP','Syntax:\\nEXP("
  "X)\\n\\nReturns the value of e (the base of natural logarithms) raised to the\\npower of X. The inverse of this function"
  " is LOG() (using a single\\nargument only) or LN().\\n\\nIf X is NULL, this function returns NULL.\\n\\nURL: https://dev.m"
  "ysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT EXP(2);\\n        -> 7.3890560989307\\nmysql"
  "> SELECT EXP(-2);\\n        -> 0.13533528323661\\nmysql> SELECT EXP(0);\\n        -> 1\\n','https://dev.mysql.com/doc/ref"
  "man/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (104,13,'FLOOR','Syntax:\\nFL"
  "OOR(X)\\n\\nReturns the largest integer value not greater than X. Returns NULL if X\\nis NULL.\\n\\nURL: https://dev.mysql"
  ".com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT FLOOR(1.23), FLOOR(-1.23);\\n        -> 1, -2\\n"
  "','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (105,13,'LN','Syntax:\\nLN(X)"
  "\\n\\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\\nIf X is less than or equal to 0.0E0, the"
  " function returns NULL and a\\nwarning \"Invalid argument for logarithm\" is reported. Returns NULL if X\\nis NULL.\\n\\n"
  "URL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT LN(2);\\n        -> 0.693"
  "14718055995\\nmysql> SELECT LN(-2);\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-function"
  "s.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (106,13,'LOG','Syntax:\\nLOG("
  "X), LOG(B,X)\\n\\nIf called with one parameter, this function returns the natural\\nlogarithm of X. If X is less than or"
  " equal to 0.0E0, the function\\nreturns NULL and a warning \"Invalid argument for logarithm\" is\\nreported. Returns NU"
  "LL if X or B is NULL.\\n\\nThe inverse of this function (when called with a single argument) is\\nthe EXP() function.\\n\\"
  "nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT LOG(2);\\n        -> 0.6"
  "9314718055995\\nmysql> SELECT LOG(-2);\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-funct"
  "ions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (107,13,'LOG2','Syntax:\\nLOG"
  "2(X)\\n\\nReturns the base-2 logarithm of X. If X is less than or equal to 0.0E0,\\nthe function returns NULL and a warn"
  "ing \"Invalid argument for\\nlogarithm\" is reported. Returns NULL if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT LOG2(65536);\\n        -> 16\\nmysql> SELECT LOG2(-100);\\n  "
  "      -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (108,13,'LOG10','Syntax:\\nLO"
  "G10(X)\\n\\nReturns the base-10 logarithm of X. If X is less than or equal to\\n0.0E0, the function returns NULL and a w"
  "arning \"Invalid argument for\\nlogarithm\" is reported. Returns NULL if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/"
  "refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT LOG10(2);\\n        -> 0.30102999566398\\nmysql> SELECT L"
  "OG10(100);\\n        -> 2\\nmysql> SELECT LOG10(-100);\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/mat"
  "hematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (109,13,'MOD','Syntax:\\nMOD("
  "N,M), N % M, N MOD M\\n\\nModulo operation. Returns the remainder of N divided by M. Returns NULL\\nif M or N is NULL.\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT MOD(234, 10);\\n       "
  " -> 4\\nmysql> SELECT 253 % 7;\\n        -> 1\\nmysql> SELECT MOD(29,9);\\n        -> 2\\nmysql> SELECT 29 MOD 9;\\n       "
  " -> 2\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (110,13,'PI','Syntax:\\nPI()\\"
  "n\\nReturns the value of π (pi). The default number of decimal places\\ndisplayed is seven, but MySQL uses the full do"
  "uble-precision value\\ninternally.\\n\\nBecause the return value of this function is a double-precision value,\\nits exac"
  "t representation may vary between platforms or implementations.\\nThis also applies to any expressions making use of P"
  "I(). See\\nhttps://dev.mysql.com/doc/refman/8.4/en/floating-point-types.html.\\n\\nURL: https://dev.mysql.com/doc/refman"
  "/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT PI();\\n        -> 3.141593\\nmysql> SELECT PI()+0.000000000000"
  "000000;\\n        -> 3.141592653589793000\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (111,13,'POW','Syntax:\\nPOW("
  "X,Y)\\n\\nReturns the value of X raised to the power of Y. Returns NULL if X or Y\\nis NULL.\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT POW(2,2);\\n        -> 4\\nmysql> SELECT POW(2,-2)"
  ";\\n        -> 0.25\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (112,13,'POWER','Syntax:\\nPO"
  "WER(X,Y)\\n\\nThis is a synonym for POW().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\"
  "n\\n','','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (113,13,'RADIANS','Syntax:\\n"
  "RADIANS(X)\\n\\nReturns the argument X, converted from degrees to radians. (Note that\\nπ radians equals 180 degrees.) "
  "Returns NULL if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> S"
  "ELECT RADIANS(90);\\n        -> 1.5707963267949\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.htm"
  "l');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (114,13,'RAND','Syntax:\\nRAN"
  "D([N])\\n\\nReturns a random floating-point value v in the range 0 <= v < 1.0. To\\nobtain a random integer R in the ran"
  "ge i <= R < j, use the expression\\nFLOOR(i + RAND() * (j − i)). For example, to obtain a random integer\\nin the ran"
  "ge the range 7 <= R < 12, use the following statement:\\n\\nSELECT FLOOR(7 + (RAND() * 5));\\n\\nIf an integer argument N"
  " is specified, it is used as the seed value:\\n\\no With a constant initializer argument, the seed is initialized once\\"
  "n  when the statement is prepared, prior to execution.\\n\\no With a nonconstant initializer argument (such as a column"
  " name), the\\n  seed is initialized with the value for each invocation of RAND().\\n\\nOne implication of this behavior "
  "is that for equal argument values,\\nRAND(N) returns the same value each time, and thus produces a\\nrepeatable sequenc"
  "e of column values. In the following example, the\\nsequence of values produced by RAND(3) is the same both places it\\"
  "noccurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> CREATE TABLE t (i I"
  "NT);\\nQuery OK, 0 rows affected (0.42 sec)\\n\\nmysql> INSERT INTO t VALUES(1),(2),(3);\\nQuery OK, 3 rows affected (0.0"
  "0 sec)\\nRecords: 3  Duplicates: 0  Warnings: 0\\n\\nmysql> SELECT i, RAND() FROM t;\\n+------+------------------+\\n| i  "
  "  | RAND()           |\\n+------+------------------+\\n|    1 | 0.61914388706828 |\\n|    2 | 0.93845168309142 |\\n|    3"
  " | 0.83482678498591 |\\n+------+------------------+\\n3 rows in set (0.00 sec)\\n\\nmysql> SELECT i, RAND(3) FROM t;\\n+--"
  "----+------------------+\\n| i    | RAND(3)          |\\n+------+------------------+\\n|    1 | 0.90576975597606 |\\n|   "
  " 2 | 0.37307905813035 |\\n|    3 | 0.14808605345719 |\\n+------+------------------+\\n3 rows in set (0.00 sec)\\n\\nmysql>"
  " SELECT i, RAND() FROM t;\\n+------+------------------+\\n| i    | RAND()           |\\n+------+------------------+\\n|  "
  "  1 | 0.35877890638893 |\\n|    2 | 0.28941420772058 |\\n|    3 | 0.37073435016976 |\\n+------+------------------+\\n3 ro"
  "ws in set (0.00 sec)\\n\\nmysql> SELECT i, RAND(3) FROM t;\\n+------+------------------+\\n| i    | RAND(3)          |\\n+"
  "------+------------------+\\n|    1 | 0.90576975597606 |\\n|    2 | 0.37307905813035 |\\n|    3 | 0.14808605345719 |\\n+-"
  "-----+------------------+\\n3 rows in set (0.01 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-function"
  "s.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (115,13,'ROUND','Syntax:\\nRO"
  "UND(X), ROUND(X,D)\\n\\nRounds the argument X to D decimal places. The rounding algorithm\\ndepends on the data type of "
  "X. D defaults to 0 if not specified. D can\\nbe negative to cause D digits left of the decimal point of the value X\\nt"
  "o become zero. The maximum absolute value for D is 30; any digits in\\nexcess of 30 (or -30) are truncated. If X or D "
  "is NULL, the function\\nreturns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n'"
  ",'mysql> SELECT ROUND(-1.23);\\n        -> -1\\nmysql> SELECT ROUND(-1.58);\\n        -> -2\\nmysql> SELECT ROUND(1.58);\\"
  "n        -> 2\\nmysql> SELECT ROUND(1.298, 1);\\n        -> 1.3\\nmysql> SELECT ROUND(1.298, 0);\\n        -> 1\\nmysql> S"
  "ELECT ROUND(23.298, -1);\\n        -> 20\\nmysql> SELECT ROUND(.12345678901234567890123456789012345, 35);\\n        -> 0"
  ".123456789012345678901234567890\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (116,13,'SIGN','Syntax:\\nSIG"
  "N(X)\\n\\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\\nis negative, zero, or positive. Retu"
  "rns NULL if X is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELEC"
  "T SIGN(-32);\\n        -> -1\\nmysql> SELECT SIGN(0);\\n        -> 0\\nmysql> SELECT SIGN(234);\\n        -> 1\\n','https:/"
  "/dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (117,13,'SIN','Syntax:\\nSIN("
  "X)\\n\\nReturns the sine of X, where X is given in radians. Returns NULL if X\\nis NULL.\\n\\nURL: https://dev.mysql.com/d"
  "oc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT SIN(PI());\\n        -> 1.2246063538224e-16\\nmysql> S"
  "ELECT ROUND(SIN(PI()));\\n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (118,13,'SQRT','Syntax:\\nSQR"
  "T(X)\\n\\nReturns the square root of a nonnegative number X. If X is NULL, the\\nfunction returns NULL.\\n\\nURL: https://"
  "dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT SQRT(4);\\n        -> 2\\nmysql> SELECT"
  " SQRT(20);\\n        -> 4.4721359549996\\nmysql> SELECT SQRT(-16);\\n        -> NULL\\n','https://dev.mysql.com/doc/refma"
  "n/8.4/en/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (119,13,'TAN','Syntax:\\nTAN("
  "X)\\n\\nReturns the tangent of X, where X is given in radians. Returns NULL if\\nX is NULL.\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/mathematical-functions.html\\n\\n','mysql> SELECT TAN(PI());\\n        -> -1.2246063538224e-16\\nmysq"
  "l> SELECT TAN(PI()+1);\\n        -> 1.5574077246549\\n','https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions"
  ".html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (120,13,'TRUNCATE','Syntax:\\"
  "nTRUNCATE(X,D)\\n\\nReturns the number X, truncated to D decimal places. If D is 0, the\\nresult has no decimal point or"
  " fractional part. D can be negative to\\ncause D digits left of the decimal point of the value X to become zero.\\nIf X"
  " or D is NULL, the function returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/mathematical-functions.html"
  "\\n\\n','mysql> SELECT TRUNCATE(1.223,1);\\n        -> 1.2\\nmysql> SELECT TRUNCATE(1.999,1);\\n        -> 1.9\\nmysql> SEL"
  "ECT TRUNCATE(1.999,0);\\n        -> 1\\nmysql> SELECT TRUNCATE(-1.999,1);\\n        -> -1.9\\nmysql> SELECT TRUNCATE(122,"
  "-2);\\n       -> 100\\nmysql> SELECT TRUNCATE(10.28*100,0);\\n       -> 1028\\n','https://dev.mysql.com/doc/refman/8.4/en"
  "/mathematical-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (121,14,'ADDDATE','Syntax:\\n"
  "ADDDATE(date,INTERVAL expr unit), ADDDATE(date,days)\\n\\nWhen invoked with the INTERVAL form of the second argument, A"
  "DDDATE()\\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\\nsynonym for DATE_SUB(). For information o"
  "n the INTERVAL unit argument,\\nsee\\nhttps://dev.mysql.com/doc/refman/8.4/en/expressions.html#temporal-inter\\nvals.\\n\\"
  "nmysql> SELECT DATE_ADD(\\'2008-01-02\\', INTERVAL 31 DAY);\\n        -> \\'2008-02-02\\'\\nmysql> SELECT ADDDATE(\\'2008-01"
  "-02\\', INTERVAL 31 DAY);\\n        -> \\'2008-02-02\\'\\n\\nWhen invoked with the days form of the second argument, MySQL "
  "treats it\\nas an integer number of days to be added to expr.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and"
  "-time-functions.html\\n\\n','mysql> SELECT ADDDATE(\\'2008-01-02\\', 31);\\n        -> \\'2008-02-02\\'\\n','https://dev.mysq"
  "l.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (122,14,'ADDTIME','Syntax:\\n"
  "ADDTIME(expr1,expr2)\\n\\nADDTIME() adds expr2 to expr1 and returns the result. expr1 is a time\\nor datetime expression"
  ", and expr2 is a time expression. Returns NULL if\\nexpr1or expr2 is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/date-and-time-functions.html\\n\\n','mysql> SELECT ADDTIME(\\'2007-12-31 23:59:59.999999\\', \\'1 1:1:1.000002\\');\\n "
  "       -> \\'2008-01-02 01:01:01.000001\\'\\nmysql> SELECT ADDTIME(\\'01:00:00.999999\\', \\'02:00:00.999998\\');\\n        -"
  "> \\'03:00:01.999997\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (123,14,'CONVERT_TZ','Syntax"
  ":\\nCONVERT_TZ(dt,from_tz,to_tz)\\n\\nCONVERT_TZ() converts a datetime value dt from the time zone given by\\nfrom_tz to "
  "the time zone given by to_tz and returns the resulting\\nvalue. Time zones are specified as described in\\nhttps://dev."
  "mysql.com/doc/refman/8.4/en/time-zone-support.html. This\\nfunction returns NULL if any of the arguments are invalid, "
  "or if any of\\nthem are NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql"
  "> SELECT CONVERT_TZ(\\'2004-01-01 12:00:00\\',\\'GMT\\',\\'MET\\');\\n        -> \\'2004-01-01 13:00:00\\'\\nmysql> SELECT CONV"
  "ERT_TZ(\\'2004-01-01 12:00:00\\',\\'+00:00\\',\\'+10:00\\');\\n        -> \\'2004-01-01 22:00:00\\'\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (124,14,'CURDATE','Syntax:\\n"
  "CURDATE()\\n\\nReturns the current date as a value in \\'YYYY-MM-DD\\' or YYYYMMDD format,\\ndepending on whether the func"
  "tion is used in string or numeric context.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.ht"
  "ml\\n\\n','mysql> SELECT CURDATE();\\n        -> \\'2008-06-13\\'\\nmysql> SELECT CURDATE() + 0;\\n        -> 20080613\\n','h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (125,14,'CURRENT_DATE','Synt"
  "ax:\\nCURRENT_DATE, CURRENT_DATE()\\n\\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\\n\\nURL: https://dev."
  "mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-ti"
  "me-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (126,14,'CURRENT_TIME','Synt"
  "ax:\\nCURRENT_TIME, CURRENT_TIME([fsp])\\n\\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\\n\\nURL: https:/"
  "/dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-a"
  "nd-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (127,14,'CURRENT_TIMESTAMP',"
  "'Syntax:\\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP([fsp])\\n\\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for N"
  "OW().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','','https://dev.mysql.com/doc"
  "/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (128,14,'CURTIME','Syntax:\\n"
  "CURTIME([fsp])\\n\\nReturns the current time as a value in \\'hh:mm:ss\\' or hhmmss format,\\ndepending on whether the fun"
  "ction is used in string or numeric context.\\nThe value is expressed in the session time zone.\\n\\nIf the fsp argument "
  "is given to specify a fractional seconds precision\\nfrom 0 to 6, the return value includes a fractional seconds part "
  "of\\nthat many digits.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELEC"
  "T CURTIME();\\n+-----------+\\n| CURTIME() |\\n+-----------+\\n| 19:25:37  |\\n+-----------+\\n\\nmysql> SELECT CURTIME() + "
  "0;\\n+---------------+\\n| CURTIME() + 0 |\\n+---------------+\\n|        192537 |\\n+---------------+\\n\\nmysql> SELECT CU"
  "RTIME(3);\\n+--------------+\\n| CURTIME(3)   |\\n+--------------+\\n| 19:25:37.840 |\\n+--------------+\\n','https://dev.m"
  "ysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (129,14,'DATE FUNCTION','Syn"
  "tax:\\nDATE(expr)\\n\\nExtracts the date part of the date or datetime expression expr. Returns\\nNULL if expr is NULL.\\n\\"
  "nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT DATE(\\'2003-12-31 01:0"
  "2:03\\');\\n        -> \\'2003-12-31\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (130,14,'DATEDIFF','Syntax:\\"
  "nDATEDIFF(expr1,expr2)\\n\\nDATEDIFF() returns expr1 − expr2 expressed as a value in days from\\none date to the other"
  ". expr1 and expr2 are date or date-and-time\\nexpressions. Only the date parts of the values are used in the\\ncalculat"
  "ion.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT DATEDIFF(\\'2007"
  "-12-31 23:59:59\\',\\'2007-12-30\\');\\n        -> 1\\nmysql> SELECT DATEDIFF(\\'2010-11-30 23:59:59\\',\\'2010-12-31\\');\\n  "
  "      -> -31\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (131,14,'DATE_ADD','Syntax:\\"
  "nDATE_ADD(date,INTERVAL expr unit), DATE_SUB(date,INTERVAL expr unit)\\n\\nThese functions perform date arithmetic. The"
  " date argument specifies\\nthe starting date or datetime value. expr is an expression specifying\\nthe interval value t"
  "o be added or subtracted from the starting date.\\nexpr is evaluated as a string; it may start with a - for negative\\n"
  "intervals. unit is a keyword indicating the units in which the\\nexpression should be interpreted.\\n\\nURL: https://dev"
  ".mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT DATE_ADD(\\'2018-05-01\\',INTERVAL 1 DAY)"
  ";\\n        -> \\'2018-05-02\\'\\nmysql> SELECT DATE_SUB(\\'2018-05-01\\',INTERVAL 1 YEAR);\\n        -> \\'2017-05-01\\'\\nmys"
  "ql> SELECT DATE_ADD(\\'2020-12-31 23:59:59\\',\\n    ->                 INTERVAL 1 SECOND);\\n        -> \\'2021-01-01 00:"
  "00:00\\'\\nmysql> SELECT DATE_ADD(\\'2018-12-31 23:59:59\\',\\n    ->                 INTERVAL 1 DAY);\\n        -> \\'2019-"
  "01-01 23:59:59\\'\\nmysql> SELECT DATE_ADD(\\'2100-12-31 23:59:59\\',\\n    ->                 INTERVAL \\'1:1\\' MINUTE_SEC"
  "OND);\\n        -> \\'2101-01-01 00:01:00\\'\\nmysql> SELECT DATE_SUB(\\'2025-01-01 00:00:00\\',\\n    ->                 IN"
  "TERVAL \\'1 1:1:1\\' DAY_SECOND);\\n        -> \\'2024-12-30 22:58:59\\'\\nmysql> SELECT DATE_ADD(\\'1900-01-01 00:00:00\\',\\"
  "n    ->                 INTERVAL \\'-1 10\\' DAY_HOUR);\\n        -> \\'1899-12-30 14:00:00\\'\\nmysql> SELECT DATE_SUB(\\'1"
  "998-01-02\\', INTERVAL 31 DAY);\\n        -> \\'1997-12-02\\'\\nmysql> SELECT DATE_ADD(\\'1992-12-31 23:59:59.000002\\',\\n  "
  "  ->            INTERVAL \\'1.999999\\' SECOND_MICROSECOND);\\n        -> \\'1993-01-01 00:00:01.000001\\'\\n','https://dev"
  ".mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (132,14,'DATE_FORMAT','Synta"
  "x:\\nDATE_FORMAT(date,format)\\n\\nFormats the date value according to the format string. If either\\nargument is NULL, t"
  "he function returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> S"
  "ELECT DATE_FORMAT(\\'2009-10-04 22:23:00\\', \\'%W %M %Y\\');\\n        -> \\'Sunday October 2009\\'\\nmysql> SELECT DATE_FOR"
  "MAT(\\'2007-10-04 22:23:00\\', \\'%H:%i:%s\\');\\n        -> \\'22:23:00\\'\\nmysql> SELECT DATE_FORMAT(\\'1900-10-04 22:23:00"
  "\\',\\n    ->                 \\'%D %y %a %d %m %b %j\\');\\n        -> \\'4th 00 Thu 04 10 Oct 277\\'\\nmysql> SELECT DATE_F"
  "ORMAT(\\'1997-10-04 22:23:00\\',\\n    ->                 \\'%H %k %I %r %T %S %w\\');\\n        -> \\'22 22 10 10:23:00 PM "
  "22:23:00 00 6\\'\\nmysql> SELECT DATE_FORMAT(\\'1999-01-01\\', \\'%X %V\\');\\n        -> \\'1998 52\\'\\nmysql> SELECT DATE_FO"
  "RMAT(\\'2006-06-00\\', \\'%d\\');\\n        -> \\'00\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions."
  "html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (133,14,'DATE_SUB','Syntax:\\"
  "nDATE_SUB(date,INTERVAL expr unit)\\n\\nSee the description for DATE_ADD().\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/date-and-time-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (134,14,'DAY','Syntax:\\nDAY("
  "date)\\n\\nDAY() is a synonym for DAYOFMONTH().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions"
  ".html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (135,14,'DAYNAME','Syntax:\\n"
  "DAYNAME(date)\\n\\nReturns the name of the weekday for date. The language used for the\\nname is controlled by the value"
  " of the lc_time_names system variable\\n(see https://dev.mysql.com/doc/refman/8.4/en/locale-support.html).\\nReturns NU"
  "LL if date is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT "
  "DAYNAME(\\'2007-02-03\\');\\n        -> \\'Saturday\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions"
  ".html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (136,14,'DAYOFMONTH','Syntax"
  ":\\nDAYOFMONTH(date)\\n\\nReturns the day of the month for date, in the range 1 to 31, or 0 for\\ndates such as \\'0000-00"
  "-00\\' or \\'2008-00-00\\' that have a zero day part.\\nReturns NULL if date is NULL.\\n\\nURL: https://dev.mysql.com/doc/r"
  "efman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT DAYOFMONTH(\\'2007-02-03\\');\\n        -> 3\\n','https://d"
  "ev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (137,14,'DAYOFWEEK','Syntax:"
  "\\nDAYOFWEEK(date)\\n\\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\\nSaturday). These index val"
  "ues correspond to the ODBC standard. Returns\\nNULL if date is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/d"
  "ate-and-time-functions.html\\n\\n','mysql> SELECT DAYOFWEEK(\\'2007-02-03\\');\\n        -> 7\\n','https://dev.mysql.com/do"
  "c/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (138,14,'DAYOFYEAR','Syntax:"
  "\\nDAYOFYEAR(date)\\n\\nReturns the day of the year for date, in the range 1 to 366. Returns\\nNULL if date is NULL.\\n\\nU"
  "RL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT DAYOFYEAR(\\'2007-02-03\\'"
  ");\\n        -> 34\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (139,14,'EXTRACT','Syntax:\\n"
  "EXTRACT(unit FROM date)\\n\\nThe EXTRACT() function uses the same kinds of unit specifiers as\\nDATE_ADD() or DATE_SUB()"
  ", but extracts parts from the date rather than\\nperforming date arithmetic. For information on the unit argument, see"
  "\\nhttps://dev.mysql.com/doc/refman/8.4/en/expressions.html#temporal-inter\\nvals. Returns NULL if date is NULL.\\n\\nURL"
  ": https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT EXTRACT(YEAR FROM \\'2019-0"
  "7-02\\');\\n        -> 2019\\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \\'2019-07-02 01:02:03\\');\\n        -> 201907\\nmysql>"
  " SELECT EXTRACT(DAY_MINUTE FROM \\'2019-07-02 01:02:03\\');\\n        -> 20102\\nmysql> SELECT EXTRACT(MICROSECOND\\n    -"
  ">                FROM \\'2003-01-02 10:30:00.000123\\');\\n        -> 123\\n','https://dev.mysql.com/doc/refman/8.4/en/da"
  "te-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (140,14,'FROM_DAYS','Syntax:"
  "\\nFROM_DAYS(N)\\n\\nGiven a day number N, returns a DATE value. Returns NULL if N is NULL.\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT FROM_DAYS(730669);\\n        -> \\'2000-07-03\\'\\n'"
  ",'https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (141,14,'FROM_UNIXTIME','Syn"
  "tax:\\nFROM_UNIXTIME(unix_timestamp[,format])\\n\\nReturns a representation of unix_timestamp as a datetime or character"
  "\\nstring value. The value returned is expressed using the session time\\nzone. (Clients can set the session time zone "
  "as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/time-zone-support.html.)\\nunix_timestamp is an internal time"
  "stamp value representing seconds\\nsince \\'1970-01-01 00:00:00\\' UTC, such as produced by the\\nUNIX_TIMESTAMP() functi"
  "on.\\n\\nIf format is omitted, this function returns a DATETIME value.\\n\\nIf unix_timestamp or format is NULL, this fun"
  "ction returns NULL.\\n\\nIf unix_timestamp is an integer, the fractional seconds precision of\\nthe DATETIME is zero. Wh"
  "en unix_timestamp is a decimal value, the\\nfractional seconds precision of the DATETIME is the same as the\\nprecision"
  " of the decimal value, up to a maximum of 6. When\\nunix_timestamp is a floating point number, the fractional seconds\\"
  "nprecision of the datetime is 6.\\n\\nOn 32-bit platforms, the maximum useful value for unix_timestamp is\\n2147483647.9"
  "99999, which returns \\'2038-01-19 03:14:07.999999\\' UTC. On\\n64-bit platforms, the effective maximum is 32536771199.9"
  "99999, which\\nreturns \\'3001-01-18 23:59:59.999999\\' UTC. Regardless of platform or\\nversion, a greater value for uni"
  "x_timestamp than the effective maximum\\nreturns 0.\\n\\nformat is used to format the result in the same way as the form"
  "at\\nstring used for the DATE_FORMAT() function. If format is supplied, the\\nvalue returned is a VARCHAR.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT FROM_UNIXTIME(1447430881);\\n    "
  "    -> \\'2015-11-13 10:08:01\\'\\nmysql> SELECT FROM_UNIXTIME(1447430881) + 0;\\n        -> 20151113100801\\nmysql> SELEC"
  "T FROM_UNIXTIME(1447430881,\\n    ->                      \\'%Y %D %M %h:%i:%s %x\\');\\n        -> \\'2015 13th November "
  "10:08:01 2015\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (142,14,'GET_FORMAT','Syntax"
  ":\\nGET_FORMAT({DATE|TIME|DATETIME}, {\\'EUR\\'|\\'USA\\'|\\'JIS\\'|\\'ISO\\'|\\'INTERNAL\\'})\\n\\nReturns a format string. This "
  "function is useful in combination with\\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\\n\\nIf format is NULL, this"
  " function returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SEL"
  "ECT DATE_FORMAT(\\'2003-10-03\\',GET_FORMAT(DATE,\\'EUR\\'));\\n        -> \\'03.10.2003\\'\\nmysql> SELECT STR_TO_DATE(\\'10."
  "31.2003\\',GET_FORMAT(DATE,\\'USA\\'));\\n        -> \\'2003-10-31\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-"
  "time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (143,14,'HOUR','Syntax:\\nHOU"
  "R(time)\\n\\nReturns the hour for time. The range of the return value is 0 to 23 for\\ntime-of-day values. However, the "
  "range of TIME values actually is much\\nlarger, so HOUR can return values greater than 23. Returns NULL if time\\nis NU"
  "LL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT HOUR(\\'10:05:03\\"
  "');\\n        -> 10\\nmysql> SELECT HOUR(\\'272:59:59\\');\\n        -> 272\\n','https://dev.mysql.com/doc/refman/8.4/en/da"
  "te-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (144,14,'LAST_DAY','Syntax:\\"
  "nLAST_DAY(date)\\n\\nTakes a date or datetime value and returns the corresponding value for\\nthe last day of the month."
  " Returns NULL if the argument is invalid or\\nNULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-func"
  "tions.html\\n\\n','mysql> SELECT LAST_DAY(\\'2003-02-05\\');\\n        -> \\'2003-02-28\\'\\nmysql> SELECT LAST_DAY(\\'2004-02"
  "-05\\');\\n        -> \\'2004-02-29\\'\\nmysql> SELECT LAST_DAY(\\'2004-01-01 01:01:01\\');\\n        -> \\'2004-01-31\\'\\nmysq"
  "l> SELECT LAST_DAY(\\'2003-03-32\\');\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functi"
  "ons.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (145,14,'LOCALTIME','Syntax:"
  "\\nLOCALTIME, LOCALTIME([fsp])\\n\\nLOCALTIME and LOCALTIME() are synonyms for NOW().\\n\\nURL: https://dev.mysql.com/doc/"
  "refman/8.4/en/date-and-time-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (146,14,'LOCALTIMESTAMP','Sy"
  "ntax:\\nLOCALTIMESTAMP, LOCALTIMESTAMP([fsp])\\n\\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/"
  "date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (147,14,'MAKEDATE','Syntax:\\"
  "nMAKEDATE(year,dayofyear)\\n\\nReturns a date, given year and day-of-year values. dayofyear must be\\ngreater than 0 or "
  "the result is NULL. The result is also NULL if either\\nargument is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4"
  "/en/date-and-time-functions.html\\n\\n','mysql> SELECT MAKEDATE(2011,31), MAKEDATE(2011,32);\\n        -> \\'2011-01-31\\'"
  ", \\'2011-02-01\\'\\nmysql> SELECT MAKEDATE(2011,365), MAKEDATE(2014,365);\\n        -> \\'2011-12-31\\', \\'2014-12-31\\'\\nm"
  "ysql> SELECT MAKEDATE(2011,0);\\n        -> NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (148,14,'MAKETIME','Syntax:\\"
  "nMAKETIME(hour,minute,second)\\n\\nReturns a time value calculated from the hour, minute, and second\\narguments. Return"
  "s NULL if any of its arguments are NULL.\\n\\nThe second argument can have a fractional part.\\n\\nURL: https://dev.mysql"
  ".com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT MAKETIME(12,15,30);\\n        -> \\'12:15:30\\'\\"
  "n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (149,14,'MICROSECOND','Synta"
  "x:\\nMICROSECOND(expr)\\n\\nReturns the microseconds from the time or datetime expression expr as a\\nnumber in the range"
  " from 0 to 999999. Returns NULL if expr is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functi"
  "ons.html\\n\\n','mysql> SELECT MICROSECOND(\\'12:00:00.123456\\');\\n        -> 123456\\nmysql> SELECT MICROSECOND(\\'2019-1"
  "2-31 23:59:59.000010\\');\\n        -> 10\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (150,14,'MINUTE','Syntax:\\nM"
  "INUTE(time)\\n\\nReturns the minute for time, in the range 0 to 59, or NULL if time is\\nNULL.\\n\\nURL: https://dev.mysql"
  ".com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT MINUTE(\\'2008-02-03 10:05:03\\');\\n        -> "
  "5\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (151,14,'MONTH','Syntax:\\nMO"
  "NTH(date)\\n\\nReturns the month for date, in the range 1 to 12 for January to\\nDecember, or 0 for dates such as \\'0000"
  "-00-00\\' or \\'2008-00-00\\' that have\\na zero month part. Returns NULL if date is NULL.\\n\\nURL: https://dev.mysql.com/"
  "doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT MONTH(\\'2008-02-03\\');\\n        -> 2\\n','https://d"
  "ev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (152,14,'MONTHNAME','Syntax:"
  "\\nMONTHNAME(date)\\n\\nReturns the full name of the month for date. The language used for the\\nname is controlled by th"
  "e value of the lc_time_names system variable\\n(https://dev.mysql.com/doc/refman/8.4/en/locale-support.html). Returns\\"
  "nNULL if date is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELE"
  "CT MONTHNAME(\\'2008-02-03\\');\\n        -> \\'February\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-func"
  "tions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (153,14,'NOW','Syntax:\\nNOW("
  "[fsp])\\n\\nReturns the current date and time as a value in \\'YYYY-MM-DD hh:mm:ss\\'\\nor YYYYMMDDhhmmss format, dependin"
  "g on whether the function is used in\\nstring or numeric context. The value is expressed in the session time\\nzone.\\n\\"
  "nIf the fsp argument is given to specify a fractional seconds precision\\nfrom 0 to 6, the return value includes a fra"
  "ctional seconds part of\\nthat many digits.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.ht"
  "ml\\n\\n','mysql> SELECT NOW();\\n        -> \\'2007-12-15 23:50:26\\'\\nmysql> SELECT NOW() + 0;\\n        -> 2007121523502"
  "6.000000\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (154,14,'PERIOD_ADD','Syntax"
  ":\\nPERIOD_ADD(P,N)\\n\\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\\nvalue in the format YYYYMM"
  ".\\n\\n*Note*:\\n\\nThe period argument P is not a date value.\\n\\nThis function returns NULL if P or N is NULL.\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT PERIOD_ADD(200801,2);\\n      "
  "  -> 200803\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (155,14,'PERIOD_DIFF','Synta"
  "x:\\nPERIOD_DIFF(P1,P2)\\n\\nReturns the number of months between periods P1 and P2. P1 and P2\\nshould be in the format "
  "YYMM or YYYYMM. Note that the period arguments\\nP1 and P2 are not date values.\\n\\nThis function returns NULL if P1 or"
  " P2 is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT PERIOD_"
  "DIFF(200802,200703);\\n        -> 11\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (156,14,'QUARTER','Syntax:\\n"
  "QUARTER(date)\\n\\nReturns the quarter of the year for date, in the range 1 to 4, or NULL\\nif date is NULL.\\n\\nURL: htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT QUARTER(\\'2008-04-01\\');\\n     "
  "   -> 2\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (157,14,'SECOND','Syntax:\\nS"
  "ECOND(time)\\n\\nReturns the second for time, in the range 0 to 59, or NULL if time is\\nNULL.\\n\\nURL: https://dev.mysql"
  ".com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT SECOND(\\'10:05:03\\');\\n        -> 3\\n','https"
  "://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (158,14,'SEC_TO_TIME','Synta"
  "x:\\nSEC_TO_TIME(seconds)\\n\\nReturns the seconds argument, converted to hours, minutes, and seconds,\\nas a TIME value."
  " The range of the result is constrained to that of the\\nTIME data type. A warning occurs if the argument corresponds "
  "to a value\\noutside that range.\\n\\nThe function returns NULL if seconds is NULL.\\n\\nURL: https://dev.mysql.com/doc/re"
  "fman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT SEC_TO_TIME(2378);\\n        -> \\'00:39:38\\'\\nmysql> SELE"
  "CT SEC_TO_TIME(2378) + 0;\\n        -> 3938\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (159,14,'STR_TO_DATE','Synta"
  "x:\\nSTR_TO_DATE(str,format)\\n\\nThis is the inverse of the DATE_FORMAT() function. It takes a string\\nstr and a format"
  " string format. STR_TO_DATE() returns a DATETIME value\\nif the format string contains both date and time parts, or a "
  "DATE or\\nTIME value if the string contains only date or time parts. If str or\\nformat is NULL, the function returns N"
  "ULL. If the date, time, or\\ndatetime value extracted from str cannot be parsed according to the\\nrules followed by th"
  "e server, STR_TO_DATE() returns NULL and produces a\\nwarning.\\n\\nThe server scans str attempting to match format to i"
  "t. The format\\nstring can contain literal characters and format specifiers beginning\\nwith %. Literal characters in f"
  "ormat must match literally in str.\\nFormat specifiers in format must match a date or time part in str. For\\nthe speci"
  "fiers that can be used in format, see the DATE_FORMAT()\\nfunction description.\\n\\nmysql> SELECT STR_TO_DATE(\\'01,5,20"
  "13\\',\\'%d,%m,%Y\\');\\n        -> \\'2013-05-01\\'\\nmysql> SELECT STR_TO_DATE(\\'May 1, 2013\\',\\'%M %d,%Y\\');\\n        -> "
  "\\'2013-05-01\\'\\n\\nScanning starts at the beginning of str and fails if format is found\\nnot to match. Extra character"
  "s at the end of str are ignored.\\n\\nmysql> SELECT STR_TO_DATE(\\'a09:30:17\\',\\'a%h:%i:%s\\');\\n        -> \\'09:30:17\\'\\"
  "nmysql> SELECT STR_TO_DATE(\\'a09:30:17\\',\\'%h:%i:%s\\');\\n        -> NULL\\nmysql> SELECT STR_TO_DATE(\\'09:30:17a\\',\\'%"
  "h:%i:%s\\');\\n        -> \\'09:30:17\\'\\n\\nUnspecified date or time parts have a value of 0, so incompletely\\nspecified "
  "values in str produce a result with some or all parts set to\\n0:\\n\\nmysql> SELECT STR_TO_DATE(\\'abc\\',\\'abc\\');\\n    "
  "    -> \\'0000-00-00\\'\\nmysql> SELECT STR_TO_DATE(\\'9\\',\\'%m\\');\\n        -> \\'0000-09-00\\'\\nmysql> SELECT STR_TO_DATE"
  "(\\'9\\',\\'%s\\');\\n        -> \\'00:00:09\\'\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html"
  "\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (160,14,'SUBDATE','Syntax:\\n"
  "SUBDATE(date,INTERVAL expr unit), SUBDATE(expr,days)\\n\\nWhen invoked with the INTERVAL form of the second argument, S"
  "UBDATE()\\nis a synonym for DATE_SUB(). For information on the INTERVAL unit\\nargument, see the discussion for DATE_AD"
  "D().\\n\\nmysql> SELECT DATE_SUB(\\'2008-01-02\\', INTERVAL 31 DAY);\\n        -> \\'2007-12-02\\'\\nmysql> SELECT SUBDATE(\\'"
  "2008-01-02\\', INTERVAL 31 DAY);\\n        -> \\'2007-12-02\\'\\n\\nThe second form enables the use of an integer value for"
  " days. In such\\ncases, it is interpreted as the number of days to be subtracted from\\nthe date or datetime expression"
  " expr.\\n\\nmysql> SELECT SUBDATE(\\'2008-01-02 12:00:00\\', 31);\\n        -> \\'2007-12-02 12:00:00\\'\\n\\nThis function re"
  "turns NULL if any of its arguments are NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions."
  "html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (161,14,'SUBTIME','Syntax:\\n"
  "SUBTIME(expr1,expr2)\\n\\nSUBTIME() returns expr1 − expr2 expressed as a value in the same\\nformat as expr1. expr1 is"
  " a time or datetime expression, and expr2 is a\\ntime expression.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date"
  "-and-time-functions.html\\n\\n','mysql> SELECT SUBTIME(\\'2007-12-31 23:59:59.999999\\',\\'1 1:1:1.000002\\');\\n        -> "
  "\\'2007-12-30 22:58:58.999997\\'\\nmysql> SELECT SUBTIME(\\'01:00:00.999999\\', \\'02:00:00.999998\\');\\n        -> \\'-00:59"
  ":59.999999\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (162,14,'SYSDATE','Syntax:\\n"
  "SYSDATE([fsp])\\n\\nReturns the current date and time as a value in \\'YYYY-MM-DD hh:mm:ss\\'\\nor YYYYMMDDhhmmss format, "
  "depending on whether the function is used in\\nstring or numeric context.\\n\\nIf the fsp argument is given to specify a"
  " fractional seconds precision\\nfrom 0 to 6, the return value includes a fractional seconds part of\\nthat many digits."
  "\\n\\nSYSDATE() returns the time at which it executes. This differs from the\\nbehavior for NOW(), which returns a const"
  "ant time that indicates the\\ntime at which the statement began to execute. (Within a stored function\\nor trigger, NOW"
  "() returns the time at which the function or triggering\\nstatement began to execute.)\\n\\nmysql> SELECT NOW(), SLEEP(2"
  "), NOW();\\n+---------------------+----------+---------------------+\\n| NOW()               | SLEEP(2) | NOW()        "
  "       |\\n+---------------------+----------+---------------------+\\n| 2006-04-12 13:47:36 |        0 | 2006-04-12 13:"
  "47:36 |\\n+---------------------+----------+---------------------+\\n\\nmysql> SELECT SYSDATE(), SLEEP(2), SYSDATE();\\n+"
  "---------------------+----------+---------------------+\\n| SYSDATE()           | SLEEP(2) | SYSDATE()           |\\n+-"
  "--------------------+----------+---------------------+\\n| 2006-04-12 13:47:44 |        0 | 2006-04-12 13:47:46 |\\n+--"
  "-------------------+----------+---------------------+\\n\\nIn addition, the SET TIMESTAMP statement affects the value r"
  "eturned by\\nNOW() but not by SYSDATE(). This means that timestamp settings in the\\nbinary log have no effect on invoc"
  "ations of SYSDATE().\\n\\nBecause SYSDATE() can return different values even within the same\\nstatement, and is not aff"
  "ected by SET TIMESTAMP, it is nondeterministic\\nand therefore unsafe for replication if statement-based binary loggin"
  "g\\nis used. If that is a problem, you can use row-based logging.\\n\\nAlternatively, you can use the --sysdate-is-now o"
  "ption to cause\\nSYSDATE() to be an alias for NOW(). This works if the option is used on\\nboth the replication source "
  "server and the replica.\\n\\nThe nondeterministic nature of SYSDATE() also means that indexes cannot\\nbe used for evalu"
  "ating expressions that refer to it.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n'"
  ",'','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (163,14,'TIME FUNCTION','Syn"
  "tax:\\nTIME(expr)\\n\\nExtracts the time part of the time or datetime expression expr and\\nreturns it as a string. Retur"
  "ns NULL if expr is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SE"
  "LECT TIME(\\'2003-12-31 01:02:03\\');\\n        -> \\'01:02:03\\'\\nmysql> SELECT TIME(\\'2003-12-31 01:02:03.000123\\');\\n  "
  "      -> \\'01:02:03.000123\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (164,14,'TIMEDIFF','Syntax:\\"
  "nTIMEDIFF(expr1,expr2)\\n\\nTIMEDIFF() returns expr1 − expr2 expressed as a time value. expr1 and\\nexpr2 are strings "
  "which are converted to TIME or DATETIME expressions;\\nthese must be of the same type following conversion. Returns NU"
  "LL if\\nexpr1 or expr2 is NULL.\\n\\nThe result returned by TIMEDIFF() is limited to the range allowed for\\nTIME values."
  " Alternatively, you can use either of the functions\\nTIMESTAMPDIFF() and UNIX_TIMESTAMP(), both of which return integ"
  "ers.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT TIMEDIFF(\\'2000"
  "-01-01 00:00:00\\',\\n    ->                 \\'2000-01-01 00:00:00.000001\\');\\n        -> \\'-00:00:00.000001\\'\\nmysql> "
  "SELECT TIMEDIFF(\\'2008-12-31 23:59:59.000001\\',\\n    ->                 \\'2008-12-30 01:01:01.000002\\');\\n        -> "
  "\\'46:58:57.999999\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (165,14,'TIMESTAMP FUNCTION'"
  ",'Syntax:\\nTIMESTAMP(expr), TIMESTAMP(expr1,expr2)\\n\\nWith a single argument, this function returns the date or datet"
  "ime\\nexpression expr as a datetime value. With two arguments, it adds the\\ntime expression expr2 to the date or datet"
  "ime expression expr1 and\\nreturns the result as a datetime value. Returns NULL if expr, expr1, or\\nexpr2 is NULL.\\n\\n"
  "URL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT TIMESTAMP(\\'2003-12-31\\"
  "');\\n        -> \\'2003-12-31 00:00:00\\'\\nmysql> SELECT TIMESTAMP(\\'2003-12-31 12:00:00\\',\\'12:00:00\\');\\n        -> \\"
  "'2004-01-01 00:00:00\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (166,14,'TIMESTAMPADD','Synt"
  "ax:\\nTIMESTAMPADD(unit,interval,datetime_expr)\\n\\nAdds the integer expression interval to the date or datetime expres"
  "sion\\ndatetime_expr. The unit for interval is given by the unit argument,\\nwhich should be one of the following value"
  "s: MICROSECOND\\n(microseconds), SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or\\nYEAR.\\n\\nThe unit value may be s"
  "pecified using one of keywords as shown, or with\\na prefix of SQL_TSI_. For example, DAY and SQL_TSI_DAY both are leg"
  "al.\\n\\nThis function returns NULL if interval or datetime_expr is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/"
  "en/date-and-time-functions.html\\n\\n','mysql> SELECT TIMESTAMPADD(MINUTE, 1, \\'2003-01-02\\');\\n        -> \\'2003-01-02"
  " 00:01:00\\'\\nmysql> SELECT TIMESTAMPADD(WEEK,1,\\'2003-01-02\\');\\n        -> \\'2003-01-09\\'\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (167,14,'TIMESTAMPDIFF','Syn"
  "tax:\\nTIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\\n\\nReturns datetime_expr2 − datetime_expr1, where datetime_"
  "expr1 and\\ndatetime_expr2 are date or datetime expressions. One expression may be\\na date and the other a datetime; a"
  " date value is treated as a datetime\\nhaving the time part \\'00:00:00\\' where necessary. The unit for the\\nresult (an"
  " integer) is given by the unit argument. The legal values for\\nunit are the same as those listed in the description o"
  "f the\\nTIMESTAMPADD() function.\\n\\nThis function returns NULL if datetime_expr1 or datetime_expr2 is NULL.\\n\\nURL: ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT TIMESTAMPDIFF(MONTH,\\'2003-02-"
  "01\\',\\'2003-05-01\\');\\n        -> 3\\nmysql> SELECT TIMESTAMPDIFF(YEAR,\\'2002-05-01\\',\\'2001-01-01\\');\\n        -> -1\\"
  "nmysql> SELECT TIMESTAMPDIFF(MINUTE,\\'2003-02-01\\',\\'2003-05-01 12:05:55\\');\\n        -> 128885\\n','https://dev.mysql"
  ".com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (168,14,'TIME_FORMAT','Synta"
  "x:\\nTIME_FORMAT(time,format)\\n\\nThis is used like the DATE_FORMAT() function, but the format string may\\ncontain form"
  "at specifiers only for hours, minutes, seconds, and\\nmicroseconds. Other specifiers produce a NULL or 0. TIME_FORMAT("
  ")\\nreturns NULL if time or format is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.ht"
  "ml\\n\\n','mysql> SELECT TIME_FORMAT(\\'100:00:00\\', \\'%H %k %h %I %l\\');\\n        -> \\'100 100 04 04 4\\'\\n','https://de"
  "v.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (169,14,'TIME_TO_SEC','Synta"
  "x:\\nTIME_TO_SEC(time)\\n\\nReturns the time argument, converted to seconds. Returns NULL if time\\nis NULL.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT TIME_TO_SEC(\\'22:23:00\\');\\n    "
  "    -> 80580\\nmysql> SELECT TIME_TO_SEC(\\'00:39:38\\');\\n        -> 2378\\n','https://dev.mysql.com/doc/refman/8.4/en/d"
  "ate-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (170,14,'TO_DAYS','Syntax:\\n"
  "TO_DAYS(date)\\n\\nGiven a date date, returns a day number (the number of days since year\\n0). Returns NULL if date is "
  "NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT TO_DAYS(950501"
  ");\\n        -> 728779\\nmysql> SELECT TO_DAYS(\\'2007-10-07\\');\\n        -> 733321\\n','https://dev.mysql.com/doc/refman"
  "/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (171,14,'TO_SECONDS','Syntax"
  ":\\nTO_SECONDS(expr)\\n\\nGiven a date or datetime expr, returns the number of seconds since the\\nyear 0. If expr is not"
  " a valid date or datetime value (including NULL),\\nit returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/d"
  "ate-and-time-functions.html\\n\\n','mysql> SELECT TO_SECONDS(950501);\\n        -> 62966505600\\nmysql> SELECT TO_SECONDS"
  "(\\'2009-11-29\\');\\n        -> 63426672000\\nmysql> SELECT TO_SECONDS(\\'2009-11-29 13:43:32\\');\\n        -> 63426721412"
  "\\nmysql> SELECT TO_SECONDS( NOW() );\\n        -> 63426721458\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-tim"
  "e-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (172,14,'UNIX_TIMESTAMP','Sy"
  "ntax:\\nUNIX_TIMESTAMP([date])\\n\\nIf UNIX_TIMESTAMP() is called with no date argument, it returns a Unix\\ntimestamp re"
  "presenting seconds since \\'1970-01-01 00:00:00\\' UTC.\\n\\nIf UNIX_TIMESTAMP() is called with a date argument, it retur"
  "ns the\\nvalue of the argument as seconds since \\'1970-01-01 00:00:00\\' UTC. The\\nserver interprets date as a value in"
  " the session time zone and converts\\nit to an internal Unix timestamp value in UTC. (Clients can set the\\nsession tim"
  "e zone as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/time-zone-support.html.) The\\ndate argument may be a "
  "DATE, DATETIME, or TIMESTAMP string, or a number\\nin YYMMDD, YYMMDDhhmmss, YYYYMMDD, or YYYYMMDDhhmmss format. If the"
  "\\nargument includes a time part, it may optionally include a fractional\\nseconds part.\\n\\nThe return value is an inte"
  "ger if no argument is given or the argument\\ndoes not include a fractional seconds part, or DECIMAL if an argument\\ni"
  "s given that includes a fractional seconds part.\\n\\nWhen the date argument is a TIMESTAMP column, UNIX_TIMESTAMP() re"
  "turns\\nthe internal timestamp value directly, with no implicit\\n\"string-to-Unix-timestamp\" conversion.\\n\\nThe valid"
  " range of argument values is the same as for the TIMESTAMP\\ndata type: \\'1970-01-01 00:00:01.000000\\' UTC to \\'2038-0"
  "1-19\\n03:14:07.999999\\' UTC for 32-bit platforms; for MySQL running on 64-bit\\nplatforms, the valid range of argument"
  " values for UNIX_TIMESTAMP() is\\n\\'1970-01-01 00:00:01.000000\\' UTC to \\'3001-01-19 03:14:07.999999\\' UTC\\n(correspon"
  "ding to 32536771199.999999 seconds).\\n\\nRegardless of MySQL version or platform architecture, if you pass an\\nout-of-"
  "range date to UNIX_TIMESTAMP(), it returns 0. If date is NULL,\\nit returns NULL.\\n\\nURL: https://dev.mysql.com/doc/re"
  "fman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT UNIX_TIMESTAMP();\\n        -> 1447431666\\nmysql> SELECT "
  "UNIX_TIMESTAMP(\\'2015-11-13 10:20:19\\');\\n        -> 1447431619\\nmysql> SELECT UNIX_TIMESTAMP(\\'2015-11-13 10:20:19.0"
  "12\\');\\n        -> 1447431619.012\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (173,14,'UTC_DATE','Syntax:\\"
  "nUTC_DATE, UTC_DATE()\\n\\nReturns the current UTC date as a value in \\'YYYY-MM-DD\\' or YYYYMMDD\\nformat, depending on "
  "whether the function is used in string or numeric\\ncontext.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-"
  "time-functions.html\\n\\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\\n        -> \\'2003-08-14\\', 20030814\\n','https://"
  "dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (174,14,'UTC_TIME','Syntax:\\"
  "nUTC_TIME, UTC_TIME([fsp])\\n\\nReturns the current UTC time as a value in \\'hh:mm:ss\\' or hhmmss format,\\ndepending on"
  " whether the function is used in string or numeric context.\\n\\nIf the fsp argument is given to specify a fractional s"
  "econds precision\\nfrom 0 to 6, the return value includes a fractional seconds part of\\nthat many digits.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\\n   "
  "     -> \\'18:07:53\\', 180753.000000\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (175,14,'UTC_TIMESTAMP','Syn"
  "tax:\\nUTC_TIMESTAMP, UTC_TIMESTAMP([fsp])\\n\\nReturns the current UTC date and time as a value in \\'YYYY-MM-DD\\nhh:mm:"
  "ss\\' or YYYYMMDDhhmmss format, depending on whether the function\\nis used in string or numeric context.\\n\\nIf the fsp"
  " argument is given to specify a fractional seconds precision\\nfrom 0 to 6, the return value includes a fractional sec"
  "onds part of\\nthat many digits.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','my"
  "sql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\\n        -> \\'2003-08-14 18:08:04\\', 20030814180804.000000\\n','http"
  "s://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (176,14,'WEEK','Syntax:\\nWEE"
  "K(date[,mode])\\n\\nThis function returns the week number for date. The two-argument form\\nof WEEK() enables you to spe"
  "cify whether the week starts on Sunday or\\nMonday and whether the return value should be in the range from 0 to 53\\no"
  "r from 1 to 53. If the mode argument is omitted, the value of the\\ndefault_week_format system variable is used. See\\n"
  "https://dev.mysql.com/doc/refman/8.4/en/server-system-variables.html.\\nFor a NULL date value, the function returns NU"
  "LL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT WEEK(\\'2008-02-2"
  "0\\');\\n        -> 7\\nmysql> SELECT WEEK(\\'2008-02-20\\',0);\\n        -> 7\\nmysql> SELECT WEEK(\\'2008-02-20\\',1);\\n    "
  "    -> 8\\nmysql> SELECT WEEK(\\'2008-12-31\\',1);\\n        -> 53\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-t"
  "ime-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (177,14,'WEEKDAY','Syntax:\\n"
  "WEEKDAY(date)\\n\\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\\nSunday). Returns NULL if date "
  "is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT WEEKDAY(\\'2"
  "008-02-03 22:23:00\\');\\n        -> 6\\nmysql> SELECT WEEKDAY(\\'2007-11-06\\');\\n        -> 1\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (178,14,'WEEKOFYEAR','Syntax"
  ":\\nWEEKOFYEAR(date)\\n\\nReturns the calendar week of the date as a number in the range from 1\\nto 53. Returns NULL if "
  "date is NULL.\\n\\nWEEKOFYEAR() is a compatibility function that is equivalent to\\nWEEK(date,3).\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT WEEKOFYEAR(\\'2008-02-20\\');\\n        -> 8\\"
  "n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (179,14,'YEAR','Syntax:\\nYEA"
  "R(date)\\n\\nReturns the year for date, in the range 1000 to 9999, or 0 for the\\n\"zero\" date. Returns NULL if date is"
  " NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT YEAR(\\'1987-0"
  "1-01\\');\\n        -> 1987\\n','https://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (180,14,'YEARWEEK','Syntax:\\"
  "nYEARWEEK(date), YEARWEEK(date,mode)\\n\\nReturns year and week for a date. The year in the result may be\\ndifferent fr"
  "om the year in the date argument for the first and the last\\nweek of the year. Returns NULL if date is NULL.\\n\\nThe m"
  "ode argument works exactly like the mode argument to WEEK(). For\\nthe single-argument syntax, a mode value of 0 is us"
  "ed. Unlike WEEK(),\\nthe value of default_week_format does not influence YEARWEEK().\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/date-and-time-functions.html\\n\\n','mysql> SELECT YEARWEEK(\\'1987-01-01\\');\\n        -> 198652\\n','http"
  "s://dev.mysql.com/doc/refman/8.4/en/date-and-time-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (181,15,'ASCII','Syntax:\\nAS"
  "CII(str)\\n\\nReturns the numeric value of the leftmost character of the string str.\\nReturns 0 if str is the empty str"
  "ing. Returns NULL if str is NULL.\\nASCII() works for 8-bit characters.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/e"
  "n/string-functions.html\\n\\n','mysql> SELECT ASCII(\\'2\\');\\n        -> 50\\nmysql> SELECT ASCII(2);\\n        -> 50\\nmys"
  "ql> SELECT ASCII(\\'dx\\');\\n        -> 100\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (182,15,'BIN','Syntax:\\nBIN("
  "N)\\n\\nReturns a string representation of the binary value of N, where N is a\\nlonglong (BIGINT) number. This is equiv"
  "alent to CONV(N,10,2). Returns\\nNULL if N is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.h"
  "tml\\n\\n','mysql> SELECT BIN(12);\\n        -> \\'1100\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.ht"
  "ml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (183,15,'BIT_LENGTH','Syntax"
  ":\\nBIT_LENGTH(str)\\n\\nReturns the length of the string str in bits. Returns NULL if str is\\nNULL.\\n\\nURL: https://dev"
  ".mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT BIT_LENGTH(\\'text\\');\\n        -> 32\\n','https"
  "://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (184,15,'CHAR FUNCTION','Syn"
  "tax:\\nCHAR(N,... [USING charset_name])\\n\\nCHAR() interprets each argument N as an integer and returns a string\\nconsi"
  "sting of the characters given by the code values of those\\nintegers. NULL values are skipped.\\n\\nBy default, CHAR() r"
  "eturns a binary string. To produce a string in a\\ngiven character set, use the optional USING clause:\\n\\nmysql> SELEC"
  "T CHAR(77,121,83,81,\\'76\\' USING utf8mb4);\\n+---------------------------------------+\\n| CHAR(77,121,83,81,\\'76\\' USI"
  "NG utf8mb4) |\\n+---------------------------------------+\\n| MySQL                                 |\\n+---------------"
  "------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT CHAR(77,77.3,\\'77.3\\' USING utf8mb4);\\n+---------"
  "---------------------------+\\n| CHAR(77,77.3,\\'77.3\\' USING utf8mb4) |\\n+------------------------------------+\\n| MMM"
  "                                |\\n+------------------------------------+\\n1 row in set, 1 warning (0.00 sec)\\n\\nmysq"
  "l> SHOW WARNINGS;\\n+---------+------+-------------------------------------------+\\n| Level   | Code | Message        "
  "                           |\\n+---------+------+-------------------------------------------+\\n| Warning | 1292 | Trun"
  "cated incorrect INTEGER value: \\'77.3\\' |\\n+---------+------+-------------------------------------------+\\n1 row in s"
  "et (0.00 sec)\\n\\nIf USING is given and the result string is illegal for the given\\ncharacter set, a warning is issued"
  ". Also, if strict SQL mode is\\nenabled, the result from CHAR() becomes NULL.\\n\\nIf CHAR() is invoked from within the "
  "mysql client, binary strings\\ndisplay using hexadecimal notation, depending on the value of the\\n--binary-as-hex. For"
  " more information about that option, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql.html.\\n\\nCHAR() arguments lar"
  "ger than 255 are converted into multiple result\\nbytes. For example, CHAR(256) is equivalent to CHAR(1,0), and\\nCHAR("
  "256*256) is equivalent to CHAR(1,0,0):\\n\\nmysql> SELECT HEX(CHAR(1,0)), HEX(CHAR(256));\\n+----------------+----------"
  "------+\\n| HEX(CHAR(1,0)) | HEX(CHAR(256)) |\\n+----------------+----------------+\\n| 0100           | 0100           "
  "|\\n+----------------+----------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT HEX(CHAR(1,0,0)), HEX(CHAR(256*256))"
  ";\\n+------------------+--------------------+\\n| HEX(CHAR(1,0,0)) | HEX(CHAR(256*256)) |\\n+------------------+--------"
  "------------+\\n| 010000           | 010000             |\\n+------------------+--------------------+\\n1 row in set (0."
  "00 sec)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT CHAR(77,121,83,81,\\"
  "'76\\');\\n+--------------------------------------------------+\\n| CHAR(77,121,83,81,\\'76\\')                          |"
  "\\n+--------------------------------------------------+\\n| 0x4D7953514C                                     |\\n+------"
  "--------------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT CHAR(77,77.3,\\'77.3\\');\\n+---"
  "-----------------------------------------+\\n| CHAR(77,77.3,\\'77.3\\')                       |\\n+----------------------"
  "----------------------+\\n| 0x4D4D4D                                   |\\n+-------------------------------------------"
  "-+\\n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (185,15,'CHAR_LENGTH','Synta"
  "x:\\nCHAR_LENGTH(str)\\n\\nReturns the length of the string str, measured in code points. A\\nmultibyte character counts "
  "as a single code point. This means that, for\\na string containing two 3-byte characters, LENGTH() returns 6, whereas\\"
  "nCHAR_LENGTH() returns 2, as shown here:\\n\\nmysql> SET @dolphin:=\\'海豚\\';\\nQuery OK, 0 rows affected (0.01 sec)\\n\\"
  "nmysql> SELECT LENGTH(@dolphin), CHAR_LENGTH(@dolphin);\\n+------------------+-----------------------+\\n| LENGTH(@dolp"
  "hin) | CHAR_LENGTH(@dolphin) |\\n+------------------+-----------------------+\\n|                6 |                   "
  "  2 |\\n+------------------+-----------------------+\\n1 row in set (0.00 sec)\\n\\nCHAR_LENGTH() returns NULL if str is "
  "NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman"
  "/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (186,15,'CHARACTER_LENGTH','"
  "Syntax:\\nCHARACTER_LENGTH(str)\\n\\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\\n\\nURL: https://dev.mysql.com/do"
  "c/refman/8.4/en/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (187,15,'CONCAT','Syntax:\\nC"
  "ONCAT(str1,str2,...)\\n\\nReturns the string that results from concatenating the arguments. May\\nhave one or more argum"
  "ents. If all arguments are nonbinary strings, the\\nresult is a nonbinary string. If the arguments include any binary\\"
  "nstrings, the result is a binary string. A numeric argument is converted\\nto its equivalent nonbinary string form.\\n\\"
  "nCONCAT() returns NULL if any argument is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html"
  "\\n\\n','mysql> SELECT CONCAT(\\'My\\', \\'S\\', \\'QL\\');\\n        -> \\'MySQL\\'\\nmysql> SELECT CONCAT(\\'My\\', NULL, \\'QL\\')"
  ";\\n        -> NULL\\nmysql> SELECT CONCAT(14.3);\\n        -> \\'14.3\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/stri"
  "ng-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (188,15,'CONCAT_WS','Syntax:"
  "\\nCONCAT_WS(separator,str1,str2,...)\\n\\nCONCAT_WS() stands for Concatenate With Separator and is a special form\\nof C"
  "ONCAT(). The first argument is the separator for the rest of the\\narguments. The separator is added between the strin"
  "gs to be\\nconcatenated. The separator can be a string, as can the rest of the\\narguments. If the separator is NULL, t"
  "he result is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT CONCAT_W"
  "S(\\',\\',\\'First name\\',\\'Second name\\',\\'Last Name\\');\\n        -> \\'First name,Second name,Last Name\\'\\nmysql> SELEC"
  "T CONCAT_WS(\\',\\',\\'First name\\',NULL,\\'Last Name\\');\\n        -> \\'First name,Last Name\\'\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (189,15,'ELT','Syntax:\\nELT("
  "N,str1,str2,str3,...)\\n\\nELT() returns the Nth element of the list of strings: str1 if N = 1,\\nstr2 if N = 2, and so "
  "on. Returns NULL if N is less than 1, greater\\nthan the number of arguments, or NULL. ELT() is the complement of\\nFIE"
  "LD().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT ELT(1, \\'Aa\\', \\'Bb\\'"
  ", \\'Cc\\', \\'Dd\\');\\n        -> \\'Aa\\'\\nmysql> SELECT ELT(4, \\'Aa\\', \\'Bb\\', \\'Cc\\', \\'Dd\\');\\n        -> \\'Dd\\'\\n','h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (190,15,'EXPORT_SET','Syntax"
  ":\\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\\n\\nReturns a string such that for every bit set in the value "
  "bits, you get\\nan on string and for every bit not set in the value, you get an off\\nstring. Bits in bits are examined"
  " from right to left (from low-order to\\nhigh-order bits). Strings are added to the result from left to right,\\nsepara"
  "ted by the separator string (the default being the comma\\ncharacter ,). The number of bits examined is given by numbe"
  "r_of_bits,\\nwhich has a default of 64 if not specified. number_of_bits is silently\\nclipped to 64 if larger than 64. "
  "It is treated as an unsigned integer,\\nso a value of −1 is effectively the same as 64.\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT EXPORT_SET(5,\\'Y\\',\\'N\\',\\',\\',4);\\n        -> \\'Y,N,Y,"
  "N\\'\\nmysql> SELECT EXPORT_SET(6,\\'1\\',\\'0\\',\\',\\',10);\\n        -> \\'0,1,1,0,0,0,0,0,0,0\\'\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (191,15,'FIELD','Syntax:\\nFI"
  "ELD(str,str1,str2,str3,...)\\n\\nReturns the index (position) of str in the str1, str2, str3, ... list.\\nReturns 0 if s"
  "tr is not found.\\n\\nIf all arguments to FIELD() are strings, all arguments are compared as\\nstrings. If all arguments"
  " are numbers, they are compared as numbers.\\nOtherwise, the arguments are compared as double.\\n\\nIf str is NULL, the "
  "return value is 0 because NULL fails equality\\ncomparison with any value. FIELD() is the complement of ELT().\\n\\nURL:"
  " https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT FIELD(\\'Bb\\', \\'Aa\\', \\'Bb\\', \\'Cc"
  "\\', \\'Dd\\', \\'Ff\\');\\n        -> 2\\nmysql> SELECT FIELD(\\'Gg\\', \\'Aa\\', \\'Bb\\', \\'Cc\\', \\'Dd\\', \\'Ff\\');\\n        -> "
  "0\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (192,15,'FIND_IN_SET','Synta"
  "x:\\nFIND_IN_SET(str,strlist)\\n\\nReturns a value in the range of 1 to N if the string str is in the\\nstring list strli"
  "st consisting of N substrings. A string list is a\\nstring composed of substrings separated by , characters. If the fi"
  "rst\\nargument is a constant string and the second is a column of type SET,\\nthe FIND_IN_SET() function is optimized t"
  "o use bit arithmetic. Returns\\n0 if str is not in strlist or if strlist is the empty string. Returns\\nNULL if either "
  "argument is NULL. This function does not work properly\\nif the first argument contains a comma (,) character.\\n\\nURL:"
  " https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT FIND_IN_SET(\\'b\\',\\'a,b,c,d\\');\\n "
  "       -> 2\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (193,15,'FORMAT','Syntax:\\nF"
  "ORMAT(X,D[,locale])\\n\\nFormats the number X to a format like \\'#,###,###.##\\', rounded to D\\ndecimal places, and retu"
  "rns the result as a string. If D is 0, the\\nresult has no decimal point or fractional part. If X or D is NULL, the\\nf"
  "unction returns NULL.\\n\\nThe optional third parameter enables a locale to be specified to be\\nused for the result num"
  "ber\\'s decimal point, thousands separator, and\\ngrouping between separators. Permissible locale values are the same a"
  "s\\nthe legal values for the lc_time_names system variable (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/locale-suppor"
  "t.html). If the\\nlocale is NULL or not specified, the default locale is \\'en_US\\'.\\n\\nURL: https://dev.mysql.com/doc/"
  "refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT FORMAT(12332.123456, 4);\\n        -> \\'12,332.1235\\'\\nmysql> "
  "SELECT FORMAT(12332.1,4);\\n        -> \\'12,332.1000\\'\\nmysql> SELECT FORMAT(12332.2,0);\\n        -> \\'12,332\\'\\nmysql"
  "> SELECT FORMAT(12332.2,2,\\'de_DE\\');\\n        -> \\'12.332,20\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-fu"
  "nctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (194,15,'FROM_BASE64','Synta"
  "x:\\nFROM_BASE64(str)\\n\\nTakes a string encoded with the base-64 encoded rules used by\\nTO_BASE64() and returns the de"
  "coded result as a binary string. The\\nresult is NULL if the argument is NULL or not a valid base-64 string.\\nSee the "
  "description of TO_BASE64() for details about the encoding and\\ndecoding rules.\\n\\nURL: https://dev.mysql.com/doc/refm"
  "an/8.4/en/string-functions.html\\n\\n','mysql> SELECT TO_BASE64(\\'abc\\'), FROM_BASE64(TO_BASE64(\\'abc\\'));\\n        -> "
  "\\'JWJj\\', \\'abc\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (195,15,'HEX','Syntax:\\nHEX("
  "str), HEX(N)\\n\\nFor a string argument str, HEX() returns a hexadecimal string\\nrepresentation of str where each byte "
  "of each character in str is\\nconverted to two hexadecimal digits. (Multibyte characters therefore\\nbecome more than t"
  "wo digits.) The inverse of this operation is\\nperformed by the UNHEX() function.\\n\\nFor a numeric argument N, HEX() r"
  "eturns a hexadecimal string\\nrepresentation of the value of N treated as a longlong (BIGINT) number.\\nThis is equival"
  "ent to CONV(N,10,16). The inverse of this operation is\\nperformed by CONV(HEX(N),16,10).\\n\\nFor a NULL argument, this"
  " function returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT X\\'"
  "616263\\', HEX(\\'abc\\'), UNHEX(HEX(\\'abc\\'));\\n        -> \\'abc\\', 616263, \\'abc\\'\\nmysql> SELECT HEX(255), CONV(HEX(2"
  "55),16,10);\\n        -> \\'FF\\', 255\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (196,15,'INSERT FUNCTION','S"
  "yntax:\\nINSERT(str,pos,len,newstr)\\n\\nReturns the string str, with the substring beginning at position pos\\nand len c"
  "haracters long replaced by the string newstr. Returns the\\noriginal string if pos is not within the length of the str"
  "ing. Replaces\\nthe rest of the string from position pos if len is not within the\\nlength of the rest of the string. R"
  "eturns NULL if any argument is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysq"
  "l> SELECT INSERT(\\'Quadratic\\', 3, 4, \\'What\\');\\n        -> \\'QuWhattic\\'\\nmysql> SELECT INSERT(\\'Quadratic\\', -1, 4"
  ", \\'What\\');\\n        -> \\'Quadratic\\'\\nmysql> SELECT INSERT(\\'Quadratic\\', 3, 100, \\'What\\');\\n        -> \\'QuWhat\\'"
  "\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (197,15,'INSTR','Syntax:\\nIN"
  "STR(str,substr)\\n\\nReturns the position of the first occurrence of substring substr in\\nstring str. This is the same "
  "as the two-argument form of LOCATE(),\\nexcept that the order of the arguments is reversed.\\n\\nURL: https://dev.mysql."
  "com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT INSTR(\\'foobarbar\\', \\'bar\\');\\n        -> 4\\nmysql> "
  "SELECT INSTR(\\'xbar\\', \\'foobar\\');\\n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (198,15,'LCASE','Syntax:\\nLC"
  "ASE(str)\\n\\nLCASE() is a synonym for LOWER().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n"
  "\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (199,15,'LEFT','Syntax:\\nLEF"
  "T(str,len)\\n\\nReturns the leftmost len characters from the string str, or NULL if any\\nargument is NULL.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT LEFT(\\'foobarbar\\', 5);\\n        -> \\'f"
  "ooba\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (200,15,'LENGTH','Syntax:\\nL"
  "ENGTH(str)\\n\\nReturns the length of the string str, measured in bytes. A multibyte\\ncharacter counts as multiple byte"
  "s. This means that for a string\\ncontaining five 2-byte characters, LENGTH() returns 10, whereas\\nCHAR_LENGTH() retur"
  "ns 5. Returns NULL if str is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql>"
  " SELECT LENGTH(\\'text\\');\\n        -> 4\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (201,15,'LOAD_FILE','Syntax:"
  "\\nLOAD_FILE(file_name)\\n\\nReads the file and returns the file contents as a string. To use this\\nfunction, the file m"
  "ust be located on the server host, you must specify\\nthe full path name to the file, and you must have the FILE privi"
  "lege.\\nThe file must be readable by the server and its size less than\\nmax_allowed_packet bytes. If the secure_file_p"
  "riv system variable is\\nset to a nonempty directory name, the file to be loaded must be located\\nin that directory.\\n"
  "\\nIf the file does not exist or cannot be read because one of the\\npreceding conditions is not satisfied, the functio"
  "n returns NULL.\\n\\nThe character_set_filesystem system variable controls interpretation of\\nfile names that are given"
  " as literal strings.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> UPDATE t\\n   "
  "         SET blob_col=LOAD_FILE(\\'/tmp/picture\\')\\n            WHERE id=1;\\n','https://dev.mysql.com/doc/refman/8.4/e"
  "n/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (202,15,'LOCATE','Syntax:\\nL"
  "OCATE(substr,str), LOCATE(substr,str,pos)\\n\\nThe first syntax returns the position of the first occurrence of\\nsubstr"
  "ing substr in string str. The second syntax returns the position\\nof the first occurrence of substring substr in stri"
  "ng str, starting at\\nposition pos. Returns 0 if substr is not in str. Returns NULL if any\\nargument is NULL.\\n\\nURL: "
  "https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT LOCATE(\\'bar\\', \\'foobarbar\\');\\n  "
  "      -> 4\\nmysql> SELECT LOCATE(\\'xbar\\', \\'foobar\\');\\n        -> 0\\nmysql> SELECT LOCATE(\\'bar\\', \\'foobarbar\\', 5"
  ");\\n        -> 7\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (203,15,'LOWER','Syntax:\\nLO"
  "WER(str)\\n\\nReturns the string str with all characters changed to lowercase\\naccording to the current character set m"
  "apping, or NULL if str is NULL.\\nThe default character set is utf8mb4.\\n\\nmysql> SELECT LOWER(\\'QUADRATICALLY\\');\\n  "
  "      -> \\'quadratically\\'\\n\\nLOWER() (and UPPER()) are ineffective when applied to binary strings\\n(BINARY, VARBINAR"
  "Y, BLOB). To perform lettercase conversion of a binary\\nstring, first convert it to a nonbinary string using a charac"
  "ter set\\nappropriate for the data stored in the string:\\n\\nmysql> SET @str = BINARY \\'New York\\';\\nmysql> SELECT LOWE"
  "R(@str), LOWER(CONVERT(@str USING utf8mb4));\\n+-------------+------------------------------------+\\n| LOWER(@str) | L"
  "OWER(CONVERT(@str USING utf8mb4)) |\\n+-------------+------------------------------------+\\n| New York    | new york  "
  "                         |\\n+-------------+------------------------------------+\\n\\nFor collations of Unicode charact"
  "er sets, LOWER() and UPPER() work\\naccording to the Unicode Collation Algorithm (UCA) version in the\\ncollation name,"
  " if there is one, and UCA 4.0.0 if no version is\\nspecified. For example, utf8mb4_0900_ai_ci and utf8mb3_unicode_520_"
  "ci\\nwork according to UCA 9.0.0 and 5.2.0, respectively, whereas\\nutf8mb3_unicode_ci works according to UCA 4.0.0. Se"
  "e\\nhttps://dev.mysql.com/doc/refman/8.4/en/charset-unicode-sets.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (204,15,'LPAD','Syntax:\\nLPA"
  "D(str,len,padstr)\\n\\nReturns the string str, left-padded with the string padstr to a length\\nof len characters. If st"
  "r is longer than len, the return value is\\nshortened to len characters.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/"
  "en/string-functions.html\\n\\n','mysql> SELECT LPAD(\\'hi\\',4,\\'??\\');\\n        -> \\'??hi\\'\\nmysql> SELECT LPAD(\\'hi\\',1"
  ",\\'??\\');\\n        -> \\'h\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (205,15,'LTRIM','Syntax:\\nLT"
  "RIM(str)\\n\\nReturns the string str with leading space characters removed. Returns\\nNULL if str is NULL.\\n\\nURL: https"
  "://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT LTRIM(\\'  barbar\\');\\n        -> \\'barba"
  "r\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (206,15,'MAKE_SET','Syntax:\\"
  "nMAKE_SET(bits,str1,str2,...)\\n\\nReturns a set value (a string containing substrings separated by ,\\ncharacters) cons"
  "isting of the strings that have the corresponding bit\\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so "
  "on. NULL\\nvalues in str1, str2, ... are not appended to the result.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/s"
  "tring-functions.html\\n\\n','mysql> SELECT MAKE_SET(1,\\'a\\',\\'b\\',\\'c\\');\\n        -> \\'a\\'\\nmysql> SELECT MAKE_SET(1 |"
  " 4,\\'hello\\',\\'nice\\',\\'world\\');\\n        -> \\'hello,world\\'\\nmysql> SELECT MAKE_SET(1 | 4,\\'hello\\',\\'nice\\',NULL,\\"
  "'world\\');\\n        -> \\'hello\\'\\nmysql> SELECT MAKE_SET(0,\\'a\\',\\'b\\',\\'c\\');\\n        -> \\'\\'\\n','https://dev.mysql"
  ".com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (207,15,'MID','Syntax:\\nMID("
  "str,pos,len)\\n\\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (208,15,'OCT','Syntax:\\nOCT("
  "N)\\n\\nReturns a string representation of the octal value of N, where N is a\\nlonglong (BIGINT) number. This is equiva"
  "lent to CONV(N,10,8). Returns\\nNULL if N is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.ht"
  "ml\\n\\n','mysql> SELECT OCT(12);\\n        -> \\'14\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (209,15,'OCTET_LENGTH','Synt"
  "ax:\\nOCTET_LENGTH(str)\\n\\nOCTET_LENGTH() is a synonym for LENGTH().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/s"
  "tring-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (210,15,'ORD','Syntax:\\nORD("
  "str)\\n\\nIf the leftmost character of the string str is a multibyte character,\\nreturns the code for that character, c"
  "alculated from the numeric values\\nof its constituent bytes using this formula:\\n\\n  (1st byte code)\\n+ (2nd byte cod"
  "e * 256)\\n+ (3rd byte code * 256^2) ...\\n\\nIf the leftmost character is not a multibyte character, ORD() returns\\nthe"
  " same value as the ASCII() function. The function returns NULL if\\nstr is NULL.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/string-functions.html\\n\\n','mysql> SELECT ORD(\\'2\\');\\n        -> 50\\n','https://dev.mysql.com/doc/refman/"
  "8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (211,15,'POSITION','Syntax:\\"
  "nPOSITION(substr IN str)\\n\\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (212,15,'QUOTE','Syntax:\\nQU"
  "OTE(str)\\n\\nQuotes a string to produce a result that can be used as a properly\\nescaped data value in an SQL statemen"
  "t. The string is returned enclosed\\nby single quotation marks and with each instance of backslash (\\\\),\\nsingle quote"
  " (\\'), ASCII NUL, and Control+Z preceded by a backslash. If\\nthe argument is NULL, the return value is the word \"NUL"
  "L\" without\\nenclosing single quotation marks.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\"
  "n\\n','mysql> SELECT QUOTE(\\'Don\\\\\\'t!\\');\\n        -> \\'Don\\\\\\'t!\\'\\nmysql> SELECT QUOTE(NULL);\\n        -> NULL\\n','"
  "https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (213,15,'REPEAT FUNCTION','S"
  "yntax:\\nREPEAT(str,count)\\n\\nReturns a string consisting of the string str repeated count times. If\\ncount is less th"
  "an 1, returns an empty string. Returns NULL if str or\\ncount is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/string-functions.html\\n\\n','mysql> SELECT REPEAT(\\'MySQL\\', 3);\\n        -> \\'MySQLMySQLMySQL\\'\\n','https://dev.mysq"
  "l.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (214,15,'REPLACE FUNCTION','"
  "Syntax:\\nREPLACE(str,from_str,to_str)\\n\\nReturns the string str with all occurrences of the string from_str\\nreplaced"
  " by the string to_str. REPLACE() performs a case-sensitive\\nmatch when searching for from_str.\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT REPLACE(\\'www.mysql.com\\', \\'w\\', \\'Ww\\');\\n     "
  "   -> \\'WwWwWw.mysql.com\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (215,15,'REVERSE','Syntax:\\n"
  "REVERSE(str)\\n\\nReturns the string str with the order of the characters reversed, or\\nNULL if str is NULL.\\n\\nURL: ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT REVERSE(\\'abc\\');\\n        -> \\'cba\\'"
  "\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (216,15,'RIGHT','Syntax:\\nRI"
  "GHT(str,len)\\n\\nReturns the rightmost len characters from the string str, or NULL if\\nany argument is NULL.\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT RIGHT(\\'foobarbar\\', 4);\\n        ->"
  " \\'rbar\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (217,15,'RPAD','Syntax:\\nRPA"
  "D(str,len,padstr)\\n\\nReturns the string str, right-padded with the string padstr to a length\\nof len characters. If s"
  "tr is longer than len, the return value is\\nshortened to len characters. If str, padstr, or len is NULL, the\\nfunctio"
  "n returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT RPAD(\\'hi\\'"
  ",5,\\'?\\');\\n        -> \\'hi???\\'\\nmysql> SELECT RPAD(\\'hi\\',1,\\'?\\');\\n        -> \\'h\\'\\n','https://dev.mysql.com/doc"
  "/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (218,15,'RTRIM','Syntax:\\nRT"
  "RIM(str)\\n\\nReturns the string str with trailing space characters removed.\\n\\nURL: https://dev.mysql.com/doc/refman/8"
  ".4/en/string-functions.html\\n\\n','mysql> SELECT RTRIM(\\'barbar   \\');\\n        -> \\'barbar\\'\\n','https://dev.mysql.co"
  "m/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (219,15,'SOUNDEX','Syntax:\\n"
  "SOUNDEX(str)\\n\\nReturns a soundex string from str, or NULL if str is NULL. Two strings\\nthat sound almost the same sh"
  "ould have identical soundex strings. A\\nstandard soundex string is four characters long, but the SOUNDEX()\\nfunction "
  "returns an arbitrarily long string. You can use SUBSTRING() on\\nthe result to get a standard soundex string. All nona"
  "lphabetic\\ncharacters in str are ignored. All international alphabetic characters\\noutside the A-Z range are treated "
  "as vowels.\\n\\n*Important*:\\n\\nWhen using SOUNDEX(), you should be aware of the following limitations:\\n\\no This funct"
  "ion, as currently implemented, is intended to work well\\n  with strings that are in the English language only. String"
  "s in other\\n  languages may not produce reliable results.\\n\\no This function is not guaranteed to provide consistent "
  "results with\\n  strings that use multibyte character sets, including utf-8. See Bug\\n  #22638 for more information.\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT SOUNDEX(\\'Hello\\');\\n       "
  " -> \\'H400\\'\\nmysql> SELECT SOUNDEX(\\'Quadratically\\');\\n        -> \\'Q36324\\'\\n','https://dev.mysql.com/doc/refman/8"
  ".4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (220,15,'SOUNDS LIKE','Synta"
  "x:\\nexpr1 SOUNDS LIKE expr2\\n\\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (221,15,'SPACE','Syntax:\\nSP"
  "ACE(N)\\n\\nReturns a string consisting of N space characters, or NULL if N is\\nNULL.\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT SPACE(6);\\n        -> \\'      \\'\\n','https://dev.mysql.com/d"
  "oc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (222,15,'SUBSTR','Syntax:\\nS"
  "UBSTR(str,pos), SUBSTR(str FROM pos), SUBSTR(str,pos,len), SUBSTR(str\\nFROM pos FOR len)\\n\\nSUBSTR() is a synonym for"
  " SUBSTRING().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','','https://dev.mysql.com/do"
  "c/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (223,15,'SUBSTRING','Syntax:"
  "\\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\\nSUBSTRING(str FROM pos FOR len)\\n\\nThe forms "
  "without a len argument return a substring from string str\\nstarting at position pos. The forms with a len argument re"
  "turn a\\nsubstring len characters long from string str, starting at position\\npos. The forms that use FROM are standar"
  "d SQL syntax. It is also\\npossible to use a negative value for pos. In this case, the beginning\\nof the substring is "
  "pos characters from the end of the string, rather\\nthan the beginning. A negative value may be used for pos in any of"
  " the\\nforms of this function. A value of 0 for pos returns an empty string.\\n\\nFor all forms of SUBSTRING(), the posi"
  "tion of the first character in\\nthe string from which the substring is to be extracted is reckoned as\\n1.\\n\\nURL: htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT SUBSTRING(\\'Quadratically\\',5);\\n     "
  "   -> \\'ratically\\'\\nmysql> SELECT SUBSTRING(\\'foobarbar\\' FROM 4);\\n        -> \\'barbar\\'\\nmysql> SELECT SUBSTRING(\\"
  "'Quadratically\\',5,6);\\n        -> \\'ratica\\'\\nmysql> SELECT SUBSTRING(\\'Sakila\\', -3);\\n        -> \\'ila\\'\\nmysql> S"
  "ELECT SUBSTRING(\\'Sakila\\', -5, 3);\\n        -> \\'aki\\'\\nmysql> SELECT SUBSTRING(\\'Sakila\\' FROM -4 FOR 2);\\n        "
  "-> \\'ki\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (224,15,'SUBSTRING_INDEX','S"
  "yntax:\\nSUBSTRING_INDEX(str,delim,count)\\n\\nReturns the substring from string str before count occurrences of the\\nde"
  "limiter delim. If count is positive, everything to the left of the\\nfinal delimiter (counting from the left) is retur"
  "ned. If count is\\nnegative, everything to the right of the final delimiter (counting from\\nthe right) is returned. SU"
  "BSTRING_INDEX() performs a case-sensitive\\nmatch when searching for delim.\\n\\nURL: https://dev.mysql.com/doc/refman/8"
  ".4/en/string-functions.html\\n\\n','mysql> SELECT SUBSTRING_INDEX(\\'www.mysql.com\\', \\'.\\', 2);\\n        -> \\'www.mysql"
  "\\'\\nmysql> SELECT SUBSTRING_INDEX(\\'www.mysql.com\\', \\'.\\', -2);\\n        -> \\'mysql.com\\'\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (225,15,'TO_BASE64','Syntax:"
  "\\nTO_BASE64(str)\\n\\nConverts the string argument to base-64 encoded form and returns the\\nresult as a character strin"
  "g with the connection character set and\\ncollation. If the argument is not a string, it is converted to a string\\nbef"
  "ore conversion takes place. The result is NULL if the argument is\\nNULL. Base-64 encoded strings can be decoded using"
  " the FROM_BASE64()\\nfunction.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELE"
  "CT TO_BASE64(\\'abc\\'), FROM_BASE64(TO_BASE64(\\'abc\\'));\\n        -> \\'JWJj\\', \\'abc\\'\\n','https://dev.mysql.com/doc/r"
  "efman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (226,15,'TRIM','Syntax:\\nTRI"
  "M([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\\nFROM] str)\\n\\nReturns the string str with all remst"
  "r prefixes or suffixes removed. If\\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\\nassumed. rem"
  "str is optional and, if not specified, spaces are removed.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-fun"
  "ctions.html\\n\\n','mysql> SELECT TRIM(\\'  bar   \\');\\n        -> \\'bar\\'\\nmysql> SELECT TRIM(LEADING \\'x\\' FROM \\'xxxb"
  "arxxx\\');\\n        -> \\'barxxx\\'\\nmysql> SELECT TRIM(BOTH \\'x\\' FROM \\'xxxbarxxx\\');\\n        -> \\'bar\\'\\nmysql> SELE"
  "CT TRIM(TRAILING \\'xyz\\' FROM \\'barxxyz\\');\\n        -> \\'barx\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-f"
  "unctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (227,15,'UCASE','Syntax:\\nUC"
  "ASE(str)\\n\\nUCASE() is a synonym for UPPER().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n"
  "\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (228,15,'UNHEX','Syntax:\\nUN"
  "HEX(str)\\n\\nFor a string argument str, UNHEX(str) interprets each pair of\\ncharacters in the argument as a hexadecima"
  "l number and converts it to\\nthe byte represented by the number. The return value is a binary\\nstring.\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','mysql> SELECT UNHEX(\\'4D7953514C\\');\\n        -> \\'MySQ"
  "L\\'\\nmysql> SELECT X\\'4D7953514C\\';\\n        -> \\'MySQL\\'\\nmysql> SELECT UNHEX(HEX(\\'string\\'));\\n        -> \\'string"
  "\\'\\nmysql> SELECT HEX(UNHEX(\\'1267\\'));\\n        -> \\'1267\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/string-funct"
  "ions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (229,15,'UPPER','Syntax:\\nUP"
  "PER(str)\\n\\nReturns the string str with all characters changed to uppercase\\naccording to the current character set m"
  "apping, or NULL if str is NULL.\\nThe default character set is utf8mb4.\\n\\nmysql> SELECT UPPER(\\'Hej\\');\\n        -> \\"
  "'HEJ\\'\\n\\nSee the description of LOWER() for information that also applies to\\nUPPER(). This included information abo"
  "ut how to perform lettercase\\nconversion of binary strings (BINARY, VARBINARY, BLOB) for which these\\nfunctions are i"
  "neffective, and information about case folding for\\nUnicode character sets.\\n\\nURL: https://dev.mysql.com/doc/refman/"
  "8.4/en/string-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (230,15,'WEIGHT_STRING','Syn"
  "tax:\\nWEIGHT_STRING(str [AS {CHAR|BINARY}(N)] [flags])\\n\\nThis function returns the weight string for the input strin"
  "g. The\\nreturn value is a binary string that represents the comparison and\\nsorting value of the string, or NULL if t"
  "he argument is NULL. It has\\nthese properties:\\n\\no If WEIGHT_STRING(str1) = WEIGHT_STRING(str2), then str1 = str2 (s"
  "tr1\\n  and str2 are considered equal)\\n\\no If WEIGHT_STRING(str1) < WEIGHT_STRING(str2), then str1 < str2 (str1\\n  so"
  "rts before str2)\\n\\nWEIGHT_STRING() is a debugging function intended for internal use. Its\\nbehavior can change witho"
  "ut notice between MySQL versions. It can be\\nused for testing and debugging of collations, especially if you are\\nadd"
  "ing a new collation. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/adding-collation.html.\\n\\nThis list briefly summari"
  "zes the arguments. More details are given in\\nthe discussion following the list.\\n\\no str: The input string expressio"
  "n.\\n\\no AS clause: Optional; cast the input string to a given type and\\n  length.\\n\\no flags: Optional; unused.\\n\\nTh"
  "e input string, str, is a string expression. If the input is a\\nnonbinary (character) string such as a CHAR, VARCHAR,"
  " or TEXT value,\\nthe return value contains the collation weights for the string. If the\\ninput is a binary (byte) str"
  "ing such as a BINARY, VARBINARY, or BLOB\\nvalue, the return value is the same as the input (the weight for each\\nbyte"
  " in a binary string is the byte value). If the input is NULL,\\nWEIGHT_STRING() returns NULL.\\n\\nExamples:\\n\\nmysql> S"
  "ET @s = _utf8mb4 \\'AB\\' COLLATE utf8mb4_0900_ai_ci;\\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\\n+------+----"
  "-----+------------------------+\\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\\n+------+---------+---------------------"
  "---+\\n| AB   | 4142    | 1C471C60               |\\n+------+---------+------------------------+\\n\\nmysql> SET @s = _ut"
  "f8mb4 \\'ab\\' COLLATE utf8mb4_0900_ai_ci;\\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\\n+------+---------+-----"
  "-------------------+\\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\\n+------+---------+------------------------+\\n| ab "
  "  | 6162    | 1C471C60               |\\n+------+---------+------------------------+\\n\\nmysql> SET @s = CAST(\\'AB\\' AS"
  " BINARY);\\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\\n+------+---------+------------------------+\\n| @s   | "
  "HEX(@s) | HEX(WEIGHT_STRING(@s)) |\\n+------+---------+------------------------+\\n| AB   | 4142    | 4142             "
  "      |\\n+------+---------+------------------------+\\n\\nmysql> SET @s = CAST(\\'ab\\' AS BINARY);\\nmysql> SELECT @s, HE"
  "X(@s), HEX(WEIGHT_STRING(@s));\\n+------+---------+------------------------+\\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)"
  ") |\\n+------+---------+------------------------+\\n| ab   | 6162    | 6162                   |\\n+------+---------+----"
  "--------------------+\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/string-functions.html\\n\\n','','https://dev.mysq"
  "l.com/doc/refman/8.4/en/string-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (231,15,'LIKE','Syntax:\\nexp"
  "r LIKE pat [ESCAPE \\'escape_char\\']\\n\\nPattern matching using an SQL pattern. Returns 1 (TRUE) or 0 (FALSE).\\nIf eith"
  "er expr or pat is NULL, the result is NULL.\\n\\nThe pattern need not be a literal string. For example, it can be\\nspec"
  "ified as a string expression or table column. In the latter case,\\nthe column must be defined as one of the MySQL str"
  "ing types (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/string-types.html).\\n\\nURL: https://dev.mysql.com/doc/refman/"
  "8.4/en/string-comparison-functions.html\\n\\n','mysql> SELECT \\'David!\\' LIKE \\'David_\\';\\n        -> 1\\nmysql> SELECT "
  "\\'David!\\' LIKE \\'%D%v%\\';\\n        -> 1\\n','https://dev.mysql.com/doc/refman/8.4/en/string-comparison-functions.html"
  "');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (232,15,'NOT LIKE','Syntax:\\"
  "nexpr NOT LIKE pat [ESCAPE \\'escape_char\\']\\n\\nThis is the same as NOT (expr LIKE pat [ESCAPE \\'escape_char\\']).\\n\\nU"
  "RL: https://dev.mysql.com/doc/refman/8.4/en/string-comparison-functions.html\\n\\n','','https://dev.mysql.com/doc/refma"
  "n/8.4/en/string-comparison-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (233,15,'STRCMP','Syntax:\\nS"
  "TRCMP(expr1,expr2)\\n\\nSTRCMP() returns 0 if the strings are the same, -1 if the first\\nargument is smaller than the s"
  "econd according to the current sort\\norder, and NULL if either argument is NULL. It returns 1 otherwise.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/string-comparison-functions.html\\n\\n','mysql> SELECT STRCMP(\\'text\\', \\'text2\\');"
  "\\n        -> -1\\nmysql> SELECT STRCMP(\\'text2\\', \\'text\\');\\n        -> 1\\nmysql> SELECT STRCMP(\\'text\\', \\'text\\');\\"
  "n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/string-comparison-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (234,15,'NOT REGEXP','Syntax"
  ":\\nexpr NOT REGEXP pat, expr NOT RLIKE pat\\n\\nThis is the same as NOT (expr REGEXP pat).\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/regexp.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/regexp.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (235,15,'REGEXP','Syntax:\\ne"
  "xpr REGEXP pat, expr RLIKE pat\\n\\nReturns 1 if the string expr matches the regular expression specified\\nby the patte"
  "rn pat, 0 otherwise. If expr or pat is NULL, the return\\nvalue is NULL.\\n\\nREGEXP and RLIKE are synonyms for REGEXP_L"
  "IKE().\\n\\nFor additional information about how matching occurs, see the\\ndescription for REGEXP_LIKE().\\n\\nURL: https"
  "://dev.mysql.com/doc/refman/8.4/en/regexp.html\\n\\n','mysql> SELECT \\'Michael!\\' REGEXP \\'.*\\';\\n+--------------------"
  "----+\\n| \\'Michael!\\' REGEXP \\'.*\\' |\\n+------------------------+\\n|                      1 |\\n+---------------------"
  "---+\\nmysql> SELECT \\'new*\\\\n*line\\' REGEXP \\'new\\\\\\\\*.\\\\\\\\*line\\';\\n+---------------------------------------+\\n| \\'n"
  "ew*\\\\n*line\\' REGEXP \\'new\\\\\\\\*.\\\\\\\\*line\\' |\\n+---------------------------------------+\\n|                          "
  "           0 |\\n+---------------------------------------+\\nmysql> SELECT \\'a\\' REGEXP \\'^[a-d]\\';\\n+-----------------"
  "----+\\n| \\'a\\' REGEXP \\'^[a-d]\\' |\\n+---------------------+\\n|                   1 |\\n+---------------------+\\n','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/regexp.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (236,15,'REGEXP_INSTR','REGE"
  "XP_INSTR(expr, pat[, pos[, occurrence[, return_option[,\\nmatch_type]]]])\\n\\nReturns the starting index of the substri"
  "ng of the string expr that\\nmatches the regular expression specified by the pattern pat, 0 if there\\nis no match. If "
  "expr or pat is NULL, the return value is NULL.\\nCharacter indexes begin at 1.\\n\\nREGEXP_INSTR() takes these optional "
  "arguments:\\n\\no pos: The position in expr at which to start the search. If omitted,\\n  the default is 1.\\n\\no occurre"
  "nce: Which occurrence of a match to search for. If omitted,\\n  the default is 1.\\n\\no return_option: Which type of po"
  "sition to return. If this value is 0,\\n  REGEXP_INSTR() returns the position of the matched substring\\'s first\\n  cha"
  "racter. If this value is 1, REGEXP_INSTR() returns the position\\n  following the matched substring. If omitted, the d"
  "efault is 0.\\n\\no match_type: A string that specifies how to perform matching. The\\n  meaning is as described for REG"
  "EXP_LIKE().\\n\\nFor additional information about how matching occurs, see the\\ndescription for REGEXP_LIKE().\\n\\nURL: "
  "https://dev.mysql.com/doc/refman/8.4/en/regexp.html\\n\\n','mysql> SELECT REGEXP_INSTR(\\'dog cat dog\\', \\'dog\\');\\n+---"
  "---------------------------------+\\n| REGEXP_INSTR(\\'dog cat dog\\', \\'dog\\') |\\n+------------------------------------"
  "+\\n|                                  1 |\\n+------------------------------------+\\nmysql> SELECT REGEXP_INSTR(\\'dog c"
  "at dog\\', \\'dog\\', 2);\\n+---------------------------------------+\\n| REGEXP_INSTR(\\'dog cat dog\\', \\'dog\\', 2) |\\n+--"
  "-------------------------------------+\\n|                                     9 |\\n+---------------------------------"
  "------+\\nmysql> SELECT REGEXP_INSTR(\\'aa aaa aaaa\\', \\'a{2}\\');\\n+-------------------------------------+\\n| REGEXP_IN"
  "STR(\\'aa aaa aaaa\\', \\'a{2}\\') |\\n+-------------------------------------+\\n|                                   1 |\\n+"
  "-------------------------------------+\\nmysql> SELECT REGEXP_INSTR(\\'aa aaa aaaa\\', \\'a{4}\\');\\n+--------------------"
  "-----------------+\\n| REGEXP_INSTR(\\'aa aaa aaaa\\', \\'a{4}\\') |\\n+-------------------------------------+\\n|          "
  "                         8 |\\n+-------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/reg"
  "exp.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (237,15,'REGEXP_LIKE','REGEX"
  "P_LIKE(expr, pat[, match_type])\\n\\nReturns 1 if the string expr matches the regular expression specified\\nby the patt"
  "ern pat, 0 otherwise. If expr or pat is NULL, the return\\nvalue is NULL.\\n\\nThe pattern can be an extended regular ex"
  "pression, the syntax for which\\nis discussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/regexp.html#regexp-syntax. T"
  "he\\npattern need not be a literal string. For example, it can be specified\\nas a string expression or table column.\\n"
  "\\nThe optional match_type argument is a string that may contain any or\\nall the following characters specifying how t"
  "o perform matching:\\n\\no c: Case-sensitive matching.\\n\\no i: Case-insensitive matching.\\n\\no m: Multiple-line mode. R"
  "ecognize line terminators within the string.\\n  The default behavior is to match line terminators only at the start\\n"
  "  and end of the string expression.\\n\\no n: The . character matches line terminators. The default is for .\\n  matchin"
  "g to stop at the end of a line.\\n\\no u: Unix-only line endings. Only the newline character is recognized\\n  as a line"
  " ending by the ., ^, and $ match operators.\\n\\nIf characters specifying contradictory options are specified within\\nm"
  "atch_type, the rightmost one takes precedence.\\n\\nBy default, regular expression operations use the character set and"
  "\\ncollation of the expr and pat arguments when deciding the type of a\\ncharacter and performing the comparison. If th"
  "e arguments have\\ndifferent character sets or collations, coercibility rules apply as\\ndescribed in\\nhttps://dev.mysq"
  "l.com/doc/refman/8.4/en/charset-collation-coercibility.\\nhtml. Arguments may be specified with explicit collation ind"
  "icators to\\nchange comparison behavior.\\n\\nmysql> SELECT REGEXP_LIKE(\\'CamelCase\\', \\'CAMELCASE\\');\\n+---------------"
  "------------------------+\\n| REGEXP_LIKE(\\'CamelCase\\', \\'CAMELCASE\\') |\\n+---------------------------------------+\\n"
  "|                                     1 |\\n+---------------------------------------+\\nmysql> SELECT REGEXP_LIKE(\\'Cam"
  "elCase\\', \\'CAMELCASE\\' COLLATE utf8mb4_0900_as_cs);\\n+--------------------------------------------------------------"
  "----+\\n| REGEXP_LIKE(\\'CamelCase\\', \\'CAMELCASE\\' COLLATE utf8mb4_0900_as_cs) |\\n+-----------------------------------"
  "-------------------------------+\\n|                                                                0 |\\n+------------"
  "------------------------------------------------------+\\n\\nmatch_type may be specified with the c or i characters to "
  "override the\\ndefault case sensitivity. Exception: If either argument is a binary\\nstring, the arguments are handled "
  "in case-sensitive fashion as binary\\nstrings, even if match_type contains the i character.\\n\\n*Note*:\\n\\nMySQL uses C"
  " escape syntax in strings (for example, \\\\n to represent the\\nnewline character). If you want your expr or pat argume"
  "nt to contain a\\nliteral \\\\, you must double it. (Unless the NO_BACKSLASH_ESCAPES SQL\\nmode is enabled, in which case"
  " no escape character is used.)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/regexp.html\\n\\n','mysql> SELECT REGEXP"
  "_LIKE(\\'Michael!\\', \\'.*\\');\\n+-------------------------------+\\n| REGEXP_LIKE(\\'Michael!\\', \\'.*\\') |\\n+------------"
  "-------------------+\\n|                             1 |\\n+-------------------------------+\\nmysql> SELECT REGEXP_LIKE"
  "(\\'new*\\\\n*line\\', \\'new\\\\\\\\*.\\\\\\\\*line\\');\\n+----------------------------------------------+\\n| REGEXP_LIKE(\\'new*\\\\"
  "n*line\\', \\'new\\\\\\\\*.\\\\\\\\*line\\') |\\n+----------------------------------------------+\\n|                             "
  "               0 |\\n+----------------------------------------------+\\nmysql> SELECT REGEXP_LIKE(\\'a\\', \\'^[a-d]\\');\\n"
  "+----------------------------+\\n| REGEXP_LIKE(\\'a\\', \\'^[a-d]\\') |\\n+----------------------------+\\n|                "
  "          1 |\\n+----------------------------+\\n\\nmysql> SELECT REGEXP_LIKE(\\'abc\\', \\'ABC\\');\\n+---------------------"
  "------+\\n| REGEXP_LIKE(\\'abc\\', \\'ABC\\') |\\n+---------------------------+\\n|                         1 |\\n+----------"
  "-----------------+\\nmysql> SELECT REGEXP_LIKE(\\'abc\\', \\'ABC\\', \\'c\\');\\n+--------------------------------+\\n| REGEXP"
  "_LIKE(\\'abc\\', \\'ABC\\', \\'c\\') |\\n+--------------------------------+\\n|                              0 |\\n+----------"
  "----------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/regexp.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (238,15,'REGEXP_REPLACE','RE"
  "GEXP_REPLACE(expr, pat, repl[, pos[, occurrence[, match_type]]])\\n\\nReplaces occurrences in the string expr that matc"
  "h the regular\\nexpression specified by the pattern pat with the replacement string\\nrepl, and returns the resulting s"
  "tring. If expr, pat, or repl is NULL,\\nthe return value is NULL.\\n\\nREGEXP_REPLACE() takes these optional arguments:\\"
  "n\\no pos: The position in expr at which to start the search. If omitted,\\n  the default is 1.\\n\\no occurrence: Which "
  "occurrence of a match to replace. If omitted, the\\n  default is 0 (which means \"replace all occurrences\").\\n\\no mat"
  "ch_type: A string that specifies how to perform matching. The\\n  meaning is as described for REGEXP_LIKE().\\n\\nThe re"
  "sult returned by this function uses the character set and\\ncollation of the expression searched for matches.\\n\\nFor a"
  "dditional information about how matching occurs, see the\\ndescription for REGEXP_LIKE().\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/regexp.html\\n\\n','mysql> SELECT REGEXP_REPLACE(\\'a b c\\', \\'b\\', \\'X\\');\\n+----------------------"
  "-------------+\\n| REGEXP_REPLACE(\\'a b c\\', \\'b\\', \\'X\\') |\\n+-----------------------------------+\\n| a X c          "
  "                   |\\n+-----------------------------------+\\nmysql> SELECT REGEXP_REPLACE(\\'abc def ghi\\', \\'[a-z]+\\'"
  ", \\'X\\', 1, 3);\\n+----------------------------------------------------+\\n| REGEXP_REPLACE(\\'abc def ghi\\', \\'[a-z]+\\'"
  ", \\'X\\', 1, 3) |\\n+----------------------------------------------------+\\n| abc def X                                "
  "          |\\n+----------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/regex"
  "p.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (239,15,'REGEXP_SUBSTR','REG"
  "EXP_SUBSTR(expr, pat[, pos[, occurrence[, match_type]]])\\n\\nReturns the substring of the string expr that matches the"
  " regular\\nexpression specified by the pattern pat, NULL if there is no match. If\\nexpr or pat is NULL, the return val"
  "ue is NULL.\\n\\nREGEXP_SUBSTR() takes these optional arguments:\\n\\no pos: The position in expr at which to start the s"
  "earch. If omitted,\\n  the default is 1.\\n\\no occurrence: Which occurrence of a match to search for. If omitted,\\n  th"
  "e default is 1.\\n\\no match_type: A string that specifies how to perform matching. The\\n  meaning is as described for "
  "REGEXP_LIKE().\\n\\nThe result returned by this function uses the character set and\\ncollation of the expression search"
  "ed for matches.\\n\\nFor additional information about how matching occurs, see the\\ndescription for REGEXP_LIKE().\\n\\nU"
  "RL: https://dev.mysql.com/doc/refman/8.4/en/regexp.html\\n\\n','mysql> SELECT REGEXP_SUBSTR(\\'abc def ghi\\', \\'[a-z]+\\'"
  ");\\n+----------------------------------------+\\n| REGEXP_SUBSTR(\\'abc def ghi\\', \\'[a-z]+\\') |\\n+--------------------"
  "--------------------+\\n| abc                                    |\\n+----------------------------------------+\\nmysql>"
  " SELECT REGEXP_SUBSTR(\\'abc def ghi\\', \\'[a-z]+\\', 1, 3);\\n+----------------------------------------------+\\n| REGEXP"
  "_SUBSTR(\\'abc def ghi\\', \\'[a-z]+\\', 1, 3) |\\n+----------------------------------------------+\\n| ghi                "
  "                          |\\n+----------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8."
  "4/en/regexp.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (240,15,'MATCH AGAINST','Syn"
  "tax:\\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\\n\\nMySQL has support for full-text indexing and searchin"
  "g:\\n\\no A full-text index in MySQL is an index of type FULLTEXT.\\n\\no Full-text indexes can be used only with InnoDB "
  "or MyISAM tables, and\\n  can be created only for CHAR, VARCHAR, or TEXT columns.\\n\\no MySQL provides a built-in full-"
  "text ngram parser that supports\\n  Chinese, Japanese, and Korean (CJK), and an installable MeCab\\n  full-text parser "
  "plugin for Japanese. Parsing differences are\\n  outlined in\\n  https://dev.mysql.com/doc/refman/8.4/en/fulltext-searc"
  "h-ngram.html,\\n  and\\n  https://dev.mysql.com/doc/refman/8.4/en/fulltext-search-mecab.html.\\n\\no A FULLTEXT index def"
  "inition can be given in the CREATE TABLE\\n  statement when a table is created, or added later using ALTER TABLE\\n  or"
  " CREATE INDEX.\\n\\no For large data sets, it is much faster to load your data into a table\\n  that has no FULLTEXT ind"
  "ex and then create the index after that, than\\n  to load data into a table that has an existing FULLTEXT index.\\n\\nFu"
  "ll-text searching is performed using MATCH() AGAINST() syntax.\\nMATCH() takes a comma-separated list that names the c"
  "olumns to be\\nsearched. AGAINST takes a string to search for, and an optional\\nmodifier that indicates what type of s"
  "earch to perform. The search\\nstring must be a string value that is constant during query evaluation.\\nThis rules out"
  ", for example, a table column because that can differ for\\neach row.\\n\\nMySQL does not permit the use of a rollup col"
  "umn with MATCH(); more\\nspecifically, any query matching all of the criteria listed here is\\nrejected with ER_FULLTEX"
  "T_WITH_ROLLUP\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_fulltext_with_ro"
  "llup):\\n\\no MATCH() appears in the SELECT list, GROUP BY clause, HAVING clause,\\n  or ORDER BY clause of a query bloc"
  "k.\\n\\no The query block contains a GROUP BY ... WITH ROLLUP clause.\\n\\no The argument of the call to the MATCH() func"
  "tion is one of the\\n  grouping columns.\\n\\nSome examples of such queries are shown here:\\n\\n# MATCH() in SELECT list."
  "..\\nSELECT MATCH (a) AGAINST (\\'abc\\') FROM t GROUP BY a WITH ROLLUP;\\nSELECT 1 FROM t GROUP BY a, MATCH (a) AGAINST "
  "(\\'abc\\') WITH ROLLUP;\\n\\n# ...in HAVING clause...\\nSELECT 1 FROM t GROUP BY a WITH ROLLUP HAVING MATCH (a) AGAINST ("
  "\\'abc\\');\\n\\n# ...and in ORDER BY clause\\nSELECT 1 FROM t GROUP BY a WITH ROLLUP ORDER BY MATCH (a) AGAINST (\\'abc\\')"
  ";\\n\\nThe use of MATCH() with a rollup column in the WHERE clause is\\npermitted.\\n\\nThere are three types of full-text"
  " searches:\\n\\no A natural language search interprets the search string as a phrase in\\n  natural human language (a ph"
  "rase in free text). There are no special\\n  operators, with the exception of double quote (\") characters. The\\n  sto"
  "pword list applies. For more information about stopword lists, see\\n  https://dev.mysql.com/doc/refman/8.4/en/fulltex"
  "t-stopwords.html.\\n\\n  Full-text searches are natural language searches if the IN NATURAL\\n  LANGUAGE MODE modifier i"
  "s given or if no modifier is given. For more\\n  information, see\\n  https://dev.mysql.com/doc/refman/8.4/en/fulltext-"
  "natural-language.htm\\n  l.\\n\\no A boolean search interprets the search string using the rules of a\\n  special query l"
  "anguage. The string contains the words to search for.\\n  It can also contain operators that specify requirements such"
  " that a\\n  word must be present or absent in matching rows, or that it should be\\n  weighted higher or lower than usu"
  "al. Certain common words (stopwords)\\n  are omitted from the search index and do not match if present in the\\n  searc"
  "h string. The IN BOOLEAN MODE modifier specifies a boolean\\n  search. For more information, see\\n  https://dev.mysql."
  "com/doc/refman/8.4/en/fulltext-boolean.html.\\n\\no A query expansion search is a modification of a natural language\\n "
  " search. The search string is used to perform a natural language\\n  search. Then words from the most relevant rows re"
  "turned by the search\\n  are added to the search string and the search is done again. The\\n  query returns the rows fr"
  "om the second search. The IN NATURAL\\n  LANGUAGE MODE WITH QUERY EXPANSION or WITH QUERY EXPANSION modifier\\n  specif"
  "ies a query expansion search. For more information, see\\n  https://dev.mysql.com/doc/refman/8.4/en/fulltext-query-exp"
  "ansion.html\\n  .\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/fulltext-search.html\\n\\n','mysql> SELECT id, body, M"
  "ATCH (title,body)\\n    ->   AGAINST (\\'Security implications of running MySQL as root\\'\\n    ->   IN NATURAL LANGUAGE"
  " MODE) AS score\\n    -> FROM articles\\n    ->   WHERE MATCH (title,body) \\n    ->   AGAINST(\\'Security implications o"
  "f running MySQL as root\\'\\n    ->   IN NATURAL LANGUAGE MODE);\\n+----+-------------------------------------+---------"
  "--------+\\n| id | body                                | score           |\\n+----+------------------------------------"
  "-+-----------------+\\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\\n|  6 | When configured properly"
  ", MySQL ... | 1.3114095926285 |\\n+----+-------------------------------------+-----------------+\\n2 rows in set (0.00 "
  "sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/fulltext-search.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (241,16,'BINARY OPERATOR','S"
  "yntax:\\nBINARY expr\\n\\nThe BINARY operator converts the expression to a binary string (a\\nstring that has the binary "
  "character set and binary collation). A\\ncommon use for BINARY is to force a character string comparison to be\\ndone b"
  "yte by byte using numeric byte values rather than character by\\ncharacter. The BINARY operator also causes trailing s"
  "paces in\\ncomparisons to be significant. For information about the differences\\nbetween the binary collation of the b"
  "inary character set and the _bin\\ncollations of nonbinary character sets, see\\nhttps://dev.mysql.com/doc/refman/8.4/e"
  "n/charset-binary-collations.html.\\n\\nThe BINARY operator is deprecated; you should expect its removal in a\\nfuture ve"
  "rsion of MySQL. Use CAST(... AS BINARY) instead.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/cast-functions.html\\"
  "n\\n','mysql> SET NAMES utf8mb4 COLLATE utf8mb4_general_ci;\\n        -> OK\\nmysql> SELECT \\'a\\' = \\'A\\';\\n        -> 1"
  "\\nmysql> SELECT BINARY \\'a\\' = \\'A\\';\\n        -> 0\\nmysql> SELECT \\'a\\' = \\'a \\';\\n        -> 1\\nmysql> SELECT BINAR"
  "Y \\'a\\' = \\'a \\';\\n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/cast-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (242,16,'CAST','Syntax:\\nCAS"
  "T(expr AS type [ARRAY])\\n\\nCAST(timestamp_value AT TIME ZONE timezone_specifier AS\\nDATETIME[(precision)])\\n\\ntimezon"
  "e_specifier: [INTERVAL] \\'+00:00\\' | \\'UTC\\'\\n\\nWith CAST(expr AS type syntax, the CAST() function takes an expressio"
  "n\\nof any type and produces a result value of the specified type. This\\noperation may also be expressed as CONVERT(ex"
  "pr, type), which is\\nequivalent. If expr is NULL, CAST() returns NULL.\\n\\nThese type values are permitted:\\n\\no BINAR"
  "Y[(N)]\\n\\n  Produces a string with the VARBINARY data type, except that when the\\n  expression expr is empty (zero le"
  "ngth), the result type is BINARY(0).\\n  If the optional length N is given, BINARY(N) causes the cast to use\\n  no mor"
  "e than N bytes of the argument. Values shorter than N bytes are\\n  padded with 0x00 bytes to a length of N. If the op"
  "tional length N is\\n  not given, MySQL calculates the maximum length from the expression.\\n  If the supplied or calcu"
  "lated length is greater than an internal\\n  threshold, the result type is BLOB. If the length is still too long,\\n  t"
  "he result type is LONGBLOB.\\n\\n  For a description of how casting to BINARY affects comparisons, see\\n  https://dev.m"
  "ysql.com/doc/refman/8.4/en/binary-varbinary.html.\\n\\no CHAR[(N)] [charset_info]\\n\\n  Produces a string with the VARCH"
  "AR data type, unless the expression\\n  expr is empty (zero length), in which case the result type is\\n  CHAR(0). If t"
  "he optional length N is given, CHAR(N) causes the cast\\n  to use no more than N characters of the argument. No paddin"
  "g occurs\\n  for values shorter than N characters. If the optional length N is not\\n  given, MySQL calculates the maxi"
  "mum length from the expression. If\\n  the supplied or calculated length is greater than an internal\\n  threshold, the"
  " result type is TEXT. If the length is still too long,\\n  the result type is LONGTEXT.\\n\\n  With no charset_info clau"
  "se, CHAR produces a string with the default\\n  character set. To specify the character set explicitly, these\\n  chars"
  "et_info values are permitted:\\n\\n  o CHARACTER SET charset_name: Produces a string with the given\\n    character set."
  "\\n\\n  o ASCII: Shorthand for CHARACTER SET latin1.\\n\\n  o UNICODE: Shorthand for CHARACTER SET ucs2.\\n\\n  In all case"
  "s, the string has the character set default collation.\\n\\no DATE\\n\\n  Produces a DATE value.\\n\\no DATETIME[(M)]\\n\\n  "
  "Produces a DATETIME value. If the optional M value is given, it\\n  specifies the fractional seconds precision.\\n\\no D"
  "ECIMAL[(M[,D])]\\n\\n  Produces a DECIMAL value. If the optional M and D values are given,\\n  they specify the maximum "
  "number of digits (the precision) and the\\n  number of digits following the decimal point (the scale). If D is\\n  omit"
  "ted, 0 is assumed. If M is omitted, 10 is assumed.\\n\\no DOUBLE\\n\\n  Produces a DOUBLE result.\\n\\no FLOAT[(p)]\\n\\n  If"
  " the precision p is not specified, produces a result of type FLOAT.\\n  If p is provided and 0 <= < p <= 24, the resul"
  "t is of type FLOAT. If\\n  25 <= p <= 53, the result is of type DOUBLE. If p < 0 or p > 53, an\\n  error is returned.\\n"
  "\\no JSON\\n\\n  Produces a JSON value. For details on the rules for conversion of\\n  values between JSON and other type"
  "s, see\\n  https://dev.mysql.com/doc/refman/8.4/en/json.html#json-comparison.\\n\\no NCHAR[(N)]\\n\\n  Like CHAR, but prod"
  "uces a string with the national character set. See\\n  https://dev.mysql.com/doc/refman/8.4/en/charset-national.html.\\"
  "n\\n  Unlike CHAR, NCHAR does not permit trailing character set information\\n  to be specified.\\n\\no REAL\\n\\n  Produce"
  "s a result of type REAL. This is actually FLOAT if the\\n  REAL_AS_FLOAT SQL mode is enabled; otherwise the result is "
  "of type\\n  DOUBLE.\\n\\no SIGNED [INTEGER]\\n\\n  Produces a signed BIGINT value.\\n\\no spatial_type\\n\\n  CAST() and CONVE"
  "RT() support casting geometry values from one spatial\\n  type to another, for certain combinations of spatial types. "
  "For\\n  details, see\\n  https://dev.mysql.com/doc/refman/8.4/en/cast-functions.html#cast-spat\\n  ial-types.\\n\\no TIME["
  "(M)]\\n\\n  Produces a TIME value. If the optional M value is given, it specifies\\n  the fractional seconds precision.\\"
  "n\\no UNSIGNED [INTEGER]\\n\\n  Produces an unsigned BIGINT value.\\n\\no YEAR\\n\\n  Produces a YEAR value. These rules gov"
  "ern conversion to YEAR as\\n  follows:\\n\\n  o For a four-digit number in the range 1901-2155 inclusive, or for a\\n    "
  "string which can be interpreted as a four-digit number in this\\n    range, return the corresponding YEAR value.\\n\\n  "
  "o For a number consisting of one or two digits, or for a string which\\n    can be interpreted as such a number, retur"
  "n a YEAR value as\\n    follows:\\n\\n    o If the number is in the range 1-69 inclusive, add 2000 and return\\n      the"
  " sum.\\n\\n    o If the number is in the range 70-99 inclusive, add 1900 and\\n      return the sum.\\n\\n  o For a string"
  " which evaluates to 0, return 2000.\\n\\n  o For the number 0, return 0.\\n\\n  o For a DATE, DATETIME, or TIMESTAMP valu"
  "e, return the YEAR portion\\n    of the value. For a TIME value, return the current year.\\n\\n    If you do not specify"
  " the type of a TIME argument, you may get a\\n    different result from what you expect, as shown here:\\n\\nmysql> SELE"
  "CT CAST(\"11:35:00\" AS YEAR), CAST(TIME \"11:35:00\" AS YEAR);\\n+--------------------------+------------------------"
  "-------+\\n| CAST(\"11:35:00\" AS YEAR) | CAST(TIME \"11:35:00\" AS YEAR) |\\n+--------------------------+-------------"
  "------------------+\\n|                     2011 |                          2021 |\\n+--------------------------+------"
  "-------------------------+\\n\\n  o If the argument is of type DECIMAL, DOUBLE, DECIMAL, or REAL, round\\n    the value "
  "to the nearest integer, then attempt to cast the value to\\n    YEAR using the rules for integer values, as shown here"
  ":\\n\\nmysql> SELECT CAST(1944.35 AS YEAR), CAST(1944.50 AS YEAR);\\n+-----------------------+-----------------------+\\n"
  "| CAST(1944.35 AS YEAR) | CAST(1944.50 AS YEAR) |\\n+-----------------------+-----------------------+\\n|              "
  "    1944 |                  1945 |\\n+-----------------------+-----------------------+\\n\\nmysql> SELECT CAST(66.35 AS "
  "YEAR), CAST(66.50 AS YEAR);\\n+---------------------+---------------------+\\n| CAST(66.35 AS YEAR) | CAST(66.50 AS YEA"
  "R) |\\n+---------------------+---------------------+\\n|                2066 |                2067 |\\n+----------------"
  "-----+---------------------+\\n\\n  o An argument of type GEOMETRY cannot be converted to YEAR.\\n\\n  o For a value that"
  " cannot be successfully converted to YEAR, return\\n    NULL.\\n\\n  A string value containing non-numeric characters wh"
  "ich must be\\n  truncated prior to conversion raises a warning, as shown here:\\n\\nmysql> SELECT CAST(\"1979aaa\" AS YE"
  "AR);\\n+-------------------------+\\n| CAST(\"1979aaa\" AS YEAR) |\\n+-------------------------+\\n|                    1"
  "979 |\\n+-------------------------+\\n1 row in set, 1 warning (0.00 sec)\\n\\nmysql> SHOW WARNINGS;\\n+---------+------+--"
  "-----------------------------------------+\\n| Level   | Code | Message                                   |\\n+--------"
  "-+------+-------------------------------------------+\\n| Warning | 1292 | Truncated incorrect YEAR value: \\'1979aaa\\'"
  " |\\n+---------+------+-------------------------------------------+\\n\\nInnoDB allows the use of an additional ARRAY ke"
  "yword for creating a\\nmulti-valued index on a JSON array as part of CREATE INDEX, CREATE\\nTABLE, and ALTER TABLE stat"
  "ements. ARRAY is not supported except when\\nused to create a multi-valued index in one of these statements, in\\nwhich"
  " case it is required. The column being indexed must be a column of\\ntype JSON. With ARRAY, the type following the AS "
  "keyword may specify\\nany of the types supported by CAST(), with the exceptions of BINARY,\\nJSON, and YEAR. For syntax"
  " information and examples, as well as other\\nrelevant information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/creat"
  "e-index.html#create-index-\\nmulti-valued.\\n\\n*Note*:\\n\\nCONVERT(), unlike CAST(), does not support multi-valued index"
  " creation\\nor the ARRAY keyword.\\n\\nCAST() supports retrieval of a TIMESTAMP value as being in UTC, using\\nthe AT TIM"
  "EZONE operator. The only supported time zone is UTC; this can\\nbe specified as either of \\'+00:00\\' or \\'UTC\\'. The o"
  "nly return type\\nsupported by this syntax is DATETIME, with an optional precision\\nspecifier in the range of 0 to 6, "
  "inclusive.\\n\\nTIMESTAMP values that use timezone offsets are also supported.\\n\\nmysql> SELECT @@system_time_zone;\\n+-"
  "-------------------+\\n| @@system_time_zone |\\n+--------------------+\\n| EDT                |\\n+--------------------+\\"
  "n1 row in set (0.00 sec)\\n\\nmysql> CREATE TABLE TZ (c TIMESTAMP);\\nQuery OK, 0 rows affected (0.41 sec)\\n\\nmysql> INS"
  "ERT INTO tz VALUES\\n    ->     ROW(CURRENT_TIMESTAMP),\\n    ->     ROW(\\'2020-07-28 14:50:15+1:00\\');\\nQuery OK, 1 ro"
  "w affected (0.08 sec)\\n\\nmysql> TABLE tz;\\n+---------------------+\\n| c                   |\\n+---------------------+\\"
  "n| 2020-07-28 09:22:41 |\\n| 2020-07-28 09:50:15 |\\n+---------------------+\\n2 rows in set (0.00 sec)\\n\\nmysql> SELECT"
  " CAST(c AT TIME ZONE \\'+00:00\\' AS DATETIME) AS u FROM tz;\\n+---------------------+\\n| u                   |\\n+------"
  "---------------+\\n| 2020-07-28 13:22:41 |\\n| 2020-07-28 13:50:15 |\\n+---------------------+\\n2 rows in set (0.00 sec)"
  "\\n\\nmysql> SELECT CAST(c AT TIME ZONE \\'UTC\\' AS DATETIME(2)) AS u FROM tz;\\n+------------------------+\\n| u         "
  "             |\\n+------------------------+\\n| 2020-07-28 13:22:41.00 |\\n| 2020-07-28 13:50:15.00 |\\n+----------------"
  "--------+\\n2 rows in set (0.00 sec)\\n\\nIf you use \\'UTC\\' as the time zone specifier with this form of CAST(),\\nand t"
  "he server raises an error such as Unknown or incorrect time zone:\\n\\'UTC\\', you may need to install the MySQL time zo"
  "ne tables (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/time-zone-support.html#time-zon\\ne-installation).\\n\\nAT TIME "
  "ZONE does not support the ARRAY keyword, and is not supported\\nby the CONVERT() function.\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/cast-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/cast-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (243,16,'CONVERT','Syntax:\\n"
  "CONVERT(expr USING transcoding_name)\\n\\nCONVERT(expr,type)\\n\\nCONVERT(expr USING transcoding_name) is standard SQL sy"
  "ntax. The\\nnon-USING form of CONVERT() is ODBC syntax. Regardless of the syntax\\nused, the function returns NULL if e"
  "xpr is NULL.\\n\\nCONVERT(expr USING transcoding_name) converts data between different\\ncharacter sets. In MySQL, trans"
  "coding names are the same as the\\ncorresponding character set names. For example, this statement converts\\nthe string"
  " \\'abc\\' in the default character set to the corresponding\\nstring in the utf8mb4 character set:\\n\\nSELECT CONVERT(\\'"
  "abc\\' USING utf8mb4);\\n\\nCONVERT(expr, type) syntax (without USING) takes an expression and a\\ntype value specifying "
  "a result type, and produces a result value of the\\nspecified type. This operation may also be expressed as CAST(expr "
  "AS\\ntype), which is equivalent. For more information, see the description\\nof CAST().\\n\\nURL: https://dev.mysql.com/d"
  "oc/refman/8.4/en/cast-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/cast-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (244,17,'EXTRACTVALUE','Synt"
  "ax:\\nExtractValue(xml_frag, xpath_expr)\\n\\nExtractValue() takes two string arguments, a fragment of XML markup\\nxml_f"
  "rag and an XPath expression xpath_expr (also known as a locator);\\nit returns the text (CDATA) of the first text node"
  " which is a child of\\nthe element or elements matched by the XPath expression.\\n\\nUsing this function is the equivale"
  "nt of performing a match using the\\nxpath_expr after appending /text(). In other words,\\nExtractValue(\\'<a><b>Sakila<"
  "/b></a>\\', \\'/a/b\\') and\\nExtractValue(\\'<a><b>Sakila</b></a>\\', \\'/a/b/text()\\') produce the same\\nresult. If xml_fr"
  "ag or xpath_expr is NULL, the function returns NULL.\\n\\nIf multiple matches are found, the content of the first child"
  " text node\\nof each matching element is returned (in the order matched) as a\\nsingle, space-delimited string.\\n\\nIf n"
  "o matching text node is found for the expression (including the\\nimplicit /text())---for whatever reason, as long as "
  "xpath_expr is\\nvalid, and xml_frag consists of elements which are properly nested and\\nclosed---an empty string is re"
  "turned. No distinction is made between a\\nmatch on an empty element and no match at all. This is by design.\\n\\nIf you"
  " need to determine whether no matching element was found in\\nxml_frag or such an element was found but contained no c"
  "hild text\\nnodes, you should test the result of an expression that uses the XPath\\ncount() function. For example, bot"
  "h of these statements return an empty\\nstring, as shown here:\\n\\nmysql> SELECT ExtractValue(\\'<a><b/></a>\\', \\'/a/b\\'"
  ");\\n+-------------------------------------+\\n| ExtractValue(\\'<a><b/></a>\\', \\'/a/b\\') |\\n+--------------------------"
  "-----------+\\n|                                     |\\n+-------------------------------------+\\n1 row in set (0.00 se"
  "c)\\n\\nmysql> SELECT ExtractValue(\\'<a><c/></a>\\', \\'/a/b\\');\\n+-------------------------------------+\\n| ExtractValue"
  "(\\'<a><c/></a>\\', \\'/a/b\\') |\\n+-------------------------------------+\\n|                                     |\\n+---"
  "----------------------------------+\\n1 row in set (0.00 sec)\\n\\nHowever, you can determine whether there was actually"
  " a matching\\nelement using the following:\\n\\nmysql> SELECT ExtractValue(\\'<a><b/></a>\\', \\'count(/a/b)\\');\\n+--------"
  "-----------------------------+\\n| ExtractValue(\\'<a><b/></a>\\', \\'count(/a/b)\\') |\\n+--------------------------------"
  "-----+\\n| 1                                   |\\n+-------------------------------------+\\n1 row in set (0.00 sec)\\n\\n"
  "mysql> SELECT ExtractValue(\\'<a><c/></a>\\', \\'count(/a/b)\\');\\n+-------------------------------------+\\n| ExtractValu"
  "e(\\'<a><c/></a>\\', \\'count(/a/b)\\') |\\n+-------------------------------------+\\n| 0                                  "
  " |\\n+-------------------------------------+\\n1 row in set (0.01 sec)\\n\\n*Important*:\\n\\nExtractValue() returns only C"
  "DATA, and does not return any tags that\\nmight be contained within a matching tag, nor any of their content (see\\nthe"
  " result returned as val1 in the following example).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/xml-functions.htm"
  "l\\n\\n','mysql> SELECT\\n    ->   ExtractValue(\\'<a>ccc<b>ddd</b></a>\\', \\'/a\\') AS val1,\\n    ->   ExtractValue(\\'<a>c"
  "cc<b>ddd</b></a>\\', \\'/a/b\\') AS val2,\\n    ->   ExtractValue(\\'<a>ccc<b>ddd</b></a>\\', \\'//b\\') AS val3,\\n    ->   E"
  "xtractValue(\\'<a>ccc<b>ddd</b></a>\\', \\'/b\\') AS val4,\\n    ->   ExtractValue(\\'<a>ccc<b>ddd</b><b>eee</b></a>\\', \\'/"
  "/b\\') AS val5;\\n\\n+------+------+------+------+---------+\\n| val1 | val2 | val3 | val4 | val5    |\\n+------+------+--"
  "----+------+---------+\\n| ccc  | ddd  | ddd  |      | ddd eee |\\n+------+------+------+------+---------+\\n','https://"
  "dev.mysql.com/doc/refman/8.4/en/xml-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (245,17,'UPDATEXML','Syntax:"
  "\\nUpdateXML(xml_target, xpath_expr, new_xml)\\n\\nThis function replaces a single portion of a given fragment of XML\\nm"
  "arkup xml_target with a new XML fragment new_xml, and then returns the\\nchanged XML. The portion of xml_target that i"
  "s replaced matches an\\nXPath expression xpath_expr supplied by the user.\\n\\nIf no expression matching xpath_expr is f"
  "ound, or if multiple matches\\nare found, the function returns the original xml_target XML fragment.\\nAll three argume"
  "nts should be strings. If any of the arguments to\\nUpdateXML() are NULL, the function returns NULL.\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/xml-functions.html\\n\\n','mysql> SELECT\\n    ->   UpdateXML(\\'<a><b>ccc</b><d></d></a>\\"
  "', \\'/a\\', \\'<e>fff</e>\\') AS val1,\\n    ->   UpdateXML(\\'<a><b>ccc</b><d></d></a>\\', \\'/b\\', \\'<e>fff</e>\\') AS val2"
  ",\\n    ->   UpdateXML(\\'<a><b>ccc</b><d></d></a>\\', \\'//b\\', \\'<e>fff</e>\\') AS val3,\\n    ->   UpdateXML(\\'<a><b>ccc"
  "</b><d></d></a>\\', \\'/a/d\\', \\'<e>fff</e>\\') AS val4,\\n    ->   UpdateXML(\\'<a><d></d><b>ccc</b><d></d></a>\\', \\'/a/d"
  "\\', \\'<e>fff</e>\\') AS val5\\n    -> \\\\G\\n\\n*************************** 1. row ***************************\\nval1: <e>f"
  "ff</e>\\nval2: <a><b>ccc</b><d></d></a>\\nval3: <a><e>fff</e><d></d></a>\\nval4: <a><b>ccc</b><e>fff</e></a>\\nval5: <a><"
  "d></d><b>ccc</b><d></d></a>\\n','https://dev.mysql.com/doc/refman/8.4/en/xml-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (246,18,'|','Syntax:\\n|\\n\\nB"
  "itwise OR.\\n\\nThe result type depends on whether the arguments are evaluated as\\nbinary strings or numbers:\\n\\no Bina"
  "ry-string evaluation occurs when the arguments have a binary\\n  string type, and at least one of them is not a hexade"
  "cimal literal,\\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\\n  with argument conversion to u"
  "nsigned 64-bit integers as necessary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  as"
  " the arguments. If the arguments have unequal lengths, an\\n  ER_INVALID_BITWISE_OPERANDS_SIZE\\n  (https://dev.mysql.c"
  "om/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_invalid_bitwise_operands_size) error occurs. Nume"
  "ric\\n  evaluation produces an unsigned 64-bit integer.\\n\\nFor more information, see the introductory discussion in th"
  "is section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html\\n\\n','mysql> SELECT 29 | 15;\\n        "
  "-> 31\\nmysql> SELECT _binary X\\'40404040\\' | X\\'01020304\\';\\n        -> \\'ABCD\\'\\n','https://dev.mysql.com/doc/refman"
  "/8.4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (247,18,'&','Syntax:\\n&\\n\\nB"
  "itwise AND.\\n\\nThe result type depends on whether the arguments are evaluated as\\nbinary strings or numbers:\\n\\no Bin"
  "ary-string evaluation occurs when the arguments have a binary\\n  string type, and at least one of them is not a hexad"
  "ecimal literal,\\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\\n  with argument conversion to "
  "unsigned 64-bit integers as necessary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  a"
  "s the arguments. If the arguments have unequal lengths, an\\n  ER_INVALID_BITWISE_OPERANDS_SIZE\\n  (https://dev.mysql."
  "com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_invalid_bitwise_operands_size) error occurs. Num"
  "eric\\n  evaluation produces an unsigned 64-bit integer.\\n\\nFor more information, see the introductory discussion in t"
  "his section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html\\n\\n','mysql> SELECT 29 & 15;\\n       "
  " -> 13\\nmysql> SELECT HEX(_binary X\\'FF\\' & b\\'11110000\\');\\n        -> \\'F0\\'\\n','https://dev.mysql.com/doc/refman/8"
  ".4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (248,18,'^','Syntax:\\n^\\n\\nB"
  "itwise XOR.\\n\\nThe result type depends on whether the arguments are evaluated as\\nbinary strings or numbers:\\n\\no Bin"
  "ary-string evaluation occurs when the arguments have a binary\\n  string type, and at least one of them is not a hexad"
  "ecimal literal,\\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\\n  with argument conversion to "
  "unsigned 64-bit integers as necessary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  a"
  "s the arguments. If the arguments have unequal lengths, an\\n  ER_INVALID_BITWISE_OPERANDS_SIZE\\n  (https://dev.mysql."
  "com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_invalid_bitwise_operands_size) error occurs. Num"
  "eric\\n  evaluation produces an unsigned 64-bit integer.\\n\\nFor more information, see the introductory discussion in t"
  "his section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html\\n\\n','mysql> SELECT 1 ^ 1;\\n        -"
  "> 0\\nmysql> SELECT 1 ^ 0;\\n        -> 1\\nmysql> SELECT 11 ^ 3;\\n        -> 8\\nmysql> SELECT HEX(_binary X\\'FEDC\\' ^ X"
  "\\'1111\\');\\n        -> \\'EFCD\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (249,18,'<<','Syntax:\\n<<\\n\\"
  "nShifts a longlong (BIGINT) number or binary string to the left.\\n\\nThe result type depends on whether the bit argume"
  "nt is evaluated as a\\nbinary string or number:\\n\\no Binary-string evaluation occurs when the bit argument has a binar"
  "y\\n  string type, and is not a hexadecimal literal, bit literal, or NULL\\n  literal. Numeric evaluation occurs otherw"
  "ise, with argument\\n  conversion to an unsigned 64-bit integer as necessary.\\n\\no Binary-string evaluation produces a"
  " binary string of the same length\\n  as the bit argument. Numeric evaluation produces an unsigned 64-bit\\n  integer.\\"
  "n\\nBits shifted off the end of the value are lost without warning,\\nregardless of the argument type. In particular, i"
  "f the shift count is\\ngreater or equal to the number of bits in the bit argument, all bits in\\nthe result are 0.\\n\\nF"
  "or more information, see the introductory discussion in this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/bit-functions.html\\n\\n','mysql> SELECT 1 << 2;\\n        -> 4\\nmysql> SELECT HEX(_binary X\\'00FF00FF00FF\\' << 8);\\n  "
  "      -> \\'FF00FF00FF00\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (250,18,'>>','Syntax:\\n>>\\n\\"
  "nShifts a longlong (BIGINT) number or binary string to the right.\\n\\nThe result type depends on whether the bit argum"
  "ent is evaluated as a\\nbinary string or number:\\n\\no Binary-string evaluation occurs when the bit argument has a bina"
  "ry\\n  string type, and is not a hexadecimal literal, bit literal, or NULL\\n  literal. Numeric evaluation occurs other"
  "wise, with argument\\n  conversion to an unsigned 64-bit integer as necessary.\\n\\no Binary-string evaluation produces "
  "a binary string of the same length\\n  as the bit argument. Numeric evaluation produces an unsigned 64-bit\\n  integer."
  "\\n\\nBits shifted off the end of the value are lost without warning,\\nregardless of the argument type. In particular, "
  "if the shift count is\\ngreater or equal to the number of bits in the bit argument, all bits in\\nthe result are 0.\\n\\n"
  "For more information, see the introductory discussion in this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/e"
  "n/bit-functions.html\\n\\n','mysql> SELECT 4 >> 2;\\n        -> 1\\nmysql> SELECT HEX(_binary X\\'00FF00FF00FF\\' >> 8);\\n "
  "       -> \\'0000FF00FF00\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (251,18,'~','Syntax:\\n~\\n\\nI"
  "nvert all bits.\\n\\nThe result type depends on whether the bit argument is evaluated as a\\nbinary string or number:\\n\\"
  "no Binary-string evaluation occurs when the bit argument has a binary\\n  string type, and is not a hexadecimal litera"
  "l, bit literal, or NULL\\n  literal. Numeric evaluation occurs otherwise, with argument\\n  conversion to an unsigned 6"
  "4-bit integer as necessary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  as the bit a"
  "rgument. Numeric evaluation produces an unsigned 64-bit\\n  integer.\\n\\nFor more information, see the introductory dis"
  "cussion in this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html\\n\\n','mysql> SELECT 5 & ~"
  "1;\\n        -> 4\\nmysql> SELECT HEX(~X\\'0000FFFF1111EEEE\\');\\n        -> \\'FFFF0000EEEE1111\\'\\n','https://dev.mysql.c"
  "om/doc/refman/8.4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (252,18,'BIT_COUNT','Syntax:"
  "\\nBIT_COUNT(N)\\n\\nReturns the number of bits that are set in the argument N as an\\nunsigned 64-bit integer, or NULL i"
  "f the argument is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/bit-functions.html\\n\\n','mysql> SELECT BIT_CO"
  "UNT(64), BIT_COUNT(BINARY 64);\\n        -> 1, 7\\nmysql> SELECT BIT_COUNT(\\'64\\'), BIT_COUNT(_binary \\'64\\');\\n       "
  " -> 1, 7\\nmysql> SELECT BIT_COUNT(X\\'40\\'), BIT_COUNT(_binary X\\'40\\');\\n        -> 1, 1\\n','https://dev.mysql.com/do"
  "c/refman/8.4/en/bit-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (253,19,'AES_DECRYPT','Synta"
  "x:\\nAES_DECRYPT(crypt_str,key_str[,init_vector][,kdf_name][,salt][,info |\\niterations])\\n\\nThis function decrypts dat"
  "a using the official AES (Advanced Encryption\\nStandard) algorithm. For more information, see the description of\\nAES"
  "_ENCRYPT().\\n\\nStatements that use AES_DECRYPT() are unsafe for statement-based\\nreplication.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/encryption-functi"
  "ons.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (254,19,'AES_ENCRYPT','Synta"
  "x:\\nAES_ENCRYPT(str,key_str[,init_vector][,kdf_name][,salt][,info |\\niterations])\\n\\nAES_ENCRYPT() and AES_DECRYPT() "
  "implement encryption and decryption of\\ndata using the official AES (Advanced Encryption Standard) algorithm,\\nprevio"
  "usly known as \"Rijndael.\" The AES standard permits various key\\nlengths. By default these functions implement AES w"
  "ith a 128-bit key\\nlength. Key lengths of 196 or 256 bits can be used, as described later.\\nThe key length is a trade"
  " off between performance and security.\\n\\nAES_ENCRYPT() encrypts the string str using the key string key_str, and\\nre"
  "turns a binary string containing the encrypted output. AES_DECRYPT()\\ndecrypts the encrypted string crypt_str using t"
  "he key string key_str,\\nand returns the original (binary) string in hexadecimal format. (To\\nobtain the string as pla"
  "intext, cast the result to CHAR. Alternatively,\\nstart the mysql client with --skip-binary-as-hex to cause all binary"
  "\\nvalues to be displayed as text.) If either function argument is NULL,\\nthe function returns NULL. If AES_DECRYPT() "
  "detects invalid data or\\nincorrect padding, it returns NULL. However, it is possible for\\nAES_DECRYPT() to return a n"
  "on-NULL value (possibly garbage) if the\\ninput data or the key is invalid.\\n\\nThese functions support the use of a ke"
  "y derivation function (KDF) to\\ncreate a cryptographically strong secret key from the information\\npassed in key_str."
  " The derived key is used to encrypt and decrypt the\\ndata, and it remains in the MySQL Server instance and is not acc"
  "essible\\nto users. Using a KDF is highly recommended, as it provides better\\nsecurity than specifying your own premad"
  "e key or deriving it by a\\nsimpler method as you use the function. The functions support HKDF\\n(available from OpenSS"
  "L 1.1.0), for which you can specify an optional\\nsalt and context-specific information to include in the keying\\nmate"
  "rial, and PBKDF2 (available from OpenSSL 1.0.2), for which you can\\nspecify an optional salt and set the number of it"
  "erations used to\\nproduce the key.\\n\\nAES_ENCRYPT() and AES_DECRYPT() permit control of the block encryption\\nmode. T"
  "he block_encryption_mode system variable controls the mode for\\nblock-based encryption algorithms. Its default value "
  "is aes-128-ecb,\\nwhich signifies encryption using a key length of 128 bits and ECB mode.\\nFor a description of the pe"
  "rmitted values of this variable, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-system-variables.html.\\nThe opti"
  "onal init_vector argument is used to provide an initialization\\nvector for block encryption modes that require it.\\n\\"
  "nStatements that use AES_ENCRYPT() or AES_DECRYPT() are unsafe for\\nstatement-based replication.\\n\\nIf AES_ENCRYPT() "
  "is invoked from within the mysql client, binary\\nstrings display using hexadecimal notation, depending on the value o"
  "f\\nthe --binary-as-hex. For more information about that option, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql.ht"
  "ml.\\n\\nThe arguments for the AES_ENCRYPT() and AES_DECRYPT() functions are as\\nfollows:\\n\\no str\\n\\n  The string for "
  "AES_ENCRYPT() to encrypt using the key string key_str,\\n  or the key derived from it by the specified KDF. The string"
  " can be\\n  any length. Padding is automatically added to str so it is a multiple\\n  of a block as required by block-b"
  "ased algorithms such as AES. This\\n  padding is automatically removed by the AES_DECRYPT() function.\\n\\no crypt_str\\n"
  "\\n  The encrypted string for AES_DECRYPT() to decrypt using the key\\n  string key_str, or the key derived from it by "
  "the specified KDF. The\\n  string can be any length. The length of crypt_str can be calculated\\n  from the length of t"
  "he original string using this formula:\\n\\n16 * (trunc(string_length / 16) + 1)\\n\\no key_str\\n\\n  The encryption key, "
  "or the input keying material that is used as the\\n  basis for deriving a key using a key derivation function (KDF). F"
  "or\\n  the same instance of data, use the same value of key_str for\\n  encryption with AES_ENCRYPT() and decryption wi"
  "th AES_DECRYPT().\\n\\n  If you are using a KDF, key_str can be any arbitrary information such\\n  as a password or pass"
  "phrase. In the further arguments for the\\n  function, you specify the KDF name, then add further options to\\n  increa"
  "se the security as appropriate for the KDF.\\n\\n  When you use a KDF, the function creates a cryptographically strong\\"
  "n  secret key from the information passed in key_str and any salt or\\n  additional information that you provide in th"
  "e other arguments. The\\n  derived key is used to encrypt and decrypt the data, and it remains\\n  in the MySQL Server "
  "instance and is not accessible to users. Using a\\n  KDF is highly recommended, as it provides better security than\\n "
  " specifying your own premade key or deriving it by a simpler method as\\n  you use the function.\\n\\n  If you are not u"
  "sing a KDF, for a key length of 128 bits, the most\\n  secure way to pass a key to the key_str argument is to create a"
  " truly\\n  random 128-bit value and pass it as a binary value. For example:\\n\\nINSERT INTO t\\nVALUES (1,AES_ENCRYPT(\\'"
  "text\\',UNHEX(\\'F3229A0B371ED2D9441B830D21A390C3\\')));\\n\\n  A passphrase can be used to generate an AES key by hashing"
  " the\\n  passphrase. For example:\\n\\nINSERT INTO t\\nVALUES (1,AES_ENCRYPT(\\'text\\', UNHEX(SHA2(\\'My secret passphrase\\"
  "',512))));\\n\\n  If you exceed the maximum key length of 128 bits, a warning is\\n  returned. If you are not using a KD"
  "F, do not pass a password or\\n  passphrase directly to key_str, hash it first. Previous versions of\\n  this documenta"
  "tion suggested the former approach, but it is no longer\\n  recommended as the examples shown here are more secure.\\n\\"
  "no init_vector\\n\\n  An initialization vector, for block encryption modes that require it.\\n  The block_encryption_mod"
  "e system variable controls the mode. For the\\n  same instance of data, use the same value of init_vector for\\n  encry"
  "ption with AES_ENCRYPT() and decryption with AES_DECRYPT().\\n\\n  *Note*:\\n\\n  If you are using a KDF, you must specif"
  "y an initialization vector or\\n  a null string for this argument, in order to access the later\\n  arguments to define"
  " the KDF.\\n\\n  For modes that require an initialization vector, it must be 16 bytes\\n  or longer (bytes in excess of "
  "16 are ignored). An error occurs if\\n  init_vector is missing. For modes that do not require an\\n  initialization vec"
  "tor, it is ignored and a warning is generated if\\n  init_vector is specified, unless you are using a KDF.\\n\\n  The de"
  "fault value for the block_encryption_mode system variable is\\n  aes-128-ecb, or ECB mode, which does not require an i"
  "nitialization\\n  vector. The alternative permitted block encryption modes CBC, CFB1,\\n  CFB8, CFB128, and OFB all req"
  "uire an initialization vector.\\n\\n  A random string of bytes to use for the initialization vector can be\\n  produced "
  "by calling RANDOM_BYTES(16).\\n\\no kdf_name\\n\\n  The name of the key derivation function (KDF) to create a key from\\n "
  " the input keying material passed in key_str, and other arguments as\\n  appropriate for the KDF. Optional.\\n\\n  For t"
  "he same instance of data, use the same value of kdf_name for\\n  encryption with AES_ENCRYPT() and decryption with AES"
  "_DECRYPT(). When\\n  you specify kdf_name, you must specify init_vector, using either a\\n  valid initialization vector"
  ", or a null string if the encryption mode\\n  does not require an initialization vector.\\n\\n  The following values are"
  " supported:\\n\\n  o hkdf\\n\\n    HKDF, which is available from OpenSSL 1.1.0. HKDF extracts a\\n    pseudorandom key fro"
  "m the keying material then expands it into\\n    additional keys. With HKDF, you can specify an optional salt (salt)\\n"
  "    and context-specific information such as application details (info)\\n    to include in the keying material.\\n\\n  "
  "o pbkdf2_hmac\\n\\n    PBKDF2, which is available from OpenSSL 1.0.2. PBKDF2 applies a\\n    pseudorandom function to th"
  "e keying material, and repeats this\\n    process a large number of times to produce the key. With PBKDF2,\\n    you ca"
  "n specify an optional salt (salt) to include in the keying\\n    material, and set the number of iterations used to pr"
  "oduce the key\\n    (iterations).\\n\\n  In this example, HKDF is specified as the key derivation function,\\n  and a sal"
  "t and context information are provided. The argument for the\\n  initialization vector is included but is the empty st"
  "ring:\\n\\nSELECT AES_ENCRYPT(\\'mytext\\',\\'mykeystring\\', \\'\\', \\'hkdf\\', \\'salt\\', \\'info\\');\\n\\n  In this example, PB"
  "KDF2 is specified as the key derivation function,\\n  a salt is provided, and the number of iterations is doubled from"
  " the\\n  recommended minimum:\\n\\nSELECT AES_ENCRYPT(\\'mytext\\',\\'mykeystring\\', \\'\\', \\'pbkdf2_hmac\\',\\'salt\\', \\'2000"
  "\\');\\n\\no salt\\n\\n  A salt to be passed to the key derivation function (KDF). Optional.\\n  Both HKDF and PBKDF2 can u"
  "se salts, and their use is recommended to\\n  help prevent attacks based on dictionaries of common passwords or\\n  rai"
  "nbow tables.\\n\\n  A salt consists of random data, which for security must be different\\n  for each encryption operati"
  "on. A random string of bytes to use for\\n  the salt can be produced by calling RANDOM_BYTES(). This example\\n  produc"
  "es a 64-bit salt:\\n\\nSET @salt = RANDOM_BYTES(8);\\n\\n  For the same instance of data, use the same value of salt for\\"
  "n  encryption with AES_ENCRYPT() and decryption with AES_DECRYPT(). The\\n  salt can safely be stored along with the e"
  "ncrypted data.\\n\\no info\\n\\n  Context-specific information for HKDF to include in the keying\\n  material, such as inf"
  "ormation about the application. Optional;\\n  available when you specify hkdf as the KDF name. HKDF adds this\\n  infor"
  "mation to the keying material specified in key_str and the salt\\n  specified in salt to produce the key.\\n\\n  For the"
  " same instance of data, use the same value of info for\\n  encryption with AES_ENCRYPT() and decryption with AES_DECRY"
  "PT().\\n\\no iterations\\n\\n  The iteration count for PBKDF2 to use when producing the key.\\n  Optional; available when "
  "you specify pbkdf2_hmac as the KDF name. A\\n  higher count gives greater resistance to brute-force attacks because\\n "
  " it has a greater computational cost for the attacker, but the same is\\n  necessarily true for the key derivation pro"
  "cess. The default if you\\n  do not specify this argument is 1000, which is the minimum\\n  recommended by the OpenSSL "
  "standard.\\n\\n  For the same instance of data, use the same value of iterations for\\n  encryption with AES_ENCRYPT() a"
  "nd decryption with AES_DECRYPT().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','mys"
  "ql> SET block_encryption_mode = \\'aes-256-cbc\\';\\nmysql> SET @key_str = SHA2(\\'My secret passphrase\\',512);\\nmysql> S"
  "ET @init_vector = RANDOM_BYTES(16);\\nmysql> SET @crypt_str = AES_ENCRYPT(\\'text\\',@key_str,@init_vector);\\nmysql> SEL"
  "ECT CAST(AES_DECRYPT(@crypt_str,@key_str,@init_vector) AS CHAR);\\n+--------------------------------------------------"
  "-----------+\\n| CAST(AES_DECRYPT(@crypt_str,@key_str,@init_vector) AS CHAR) |\\n+-------------------------------------"
  "------------------------+\\n| text                                                        |\\n+------------------------"
  "-------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (255,19,'COMPRESS','Syntax:\\"
  "nCOMPRESS(string_to_compress)\\n\\nCompresses a string and returns the result as a binary string. This\\nfunction requir"
  "es MySQL to have been compiled with a compression\\nlibrary such as zlib. Otherwise, the return value is always NULL. "
  "The\\nreturn value is also NULL if string_to_compress is NULL. The compressed\\nstring can be uncompressed with UNCOMPR"
  "ESS().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','mysql> SELECT LENGTH(COMPRESS("
  "REPEAT(\\'a\\',1000)));\\n        -> 21\\nmysql> SELECT LENGTH(COMPRESS(\\'\\'));\\n        -> 0\\nmysql> SELECT LENGTH(COMPR"
  "ESS(\\'a\\'));\\n        -> 13\\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\\'a\\',16)));\\n        -> 15\\n','https://dev.mysql.c"
  "om/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (256,19,'MD5','Syntax:\\nMD5("
  "str)\\n\\nCalculates an MD5 128-bit checksum for the string. The value is\\nreturned as a string of 32 hexadecimal digit"
  "s, or NULL if the argument\\nwas NULL. The return value can, for example, be used as a hash key. See\\nthe notes at the"
  " beginning of this section about storing hash values\\nefficiently.\\n\\nThe return value is a string in the connection "
  "character set.\\n\\nIf FIPS mode is enabled, MD5() returns NULL. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/fips-mode"
  ".html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','mysql> SELECT MD5(\\'testing\\')"
  ";\\n        -> \\'ae2b1fca515949e5d54fb22b8ed95575\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (257,19,'RANDOM_BYTES','Synt"
  "ax:\\nRANDOM_BYTES(len)\\n\\nThis function returns a binary string of len random bytes generated\\nusing the random numbe"
  "r generator of the SSL library. Permitted values\\nof len range from 1 to 1024. For values outside that range, an erro"
  "r\\noccurs. Returns NULL if len is NULL.\\n\\nRANDOM_BYTES() can be used to provide the initialization vector for the\\nA"
  "ES_DECRYPT() and AES_ENCRYPT() functions. For use in that context, len\\nmust be at least 16. Larger values are permit"
  "ted, but bytes in excess\\nof 16 are ignored.\\n\\nRANDOM_BYTES() generates a random value, which makes its result\\nnond"
  "eterministic. Consequently, statements that use this function are\\nunsafe for statement-based replication.\\n\\nIf RAND"
  "OM_BYTES() is invoked from within the mysql client, binary\\nstrings display using hexadecimal notation, depending on "
  "the value of\\nthe --binary-as-hex. For more information about that option, see\\nhttps://dev.mysql.com/doc/refman/8.4/"
  "en/mysql.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','','https://dev.mysql.c"
  "om/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (258,19,'SHA1','Syntax:\\nSHA"
  "1(str), SHA(str)\\n\\nCalculates an SHA-1 160-bit checksum for the string, as described in\\nRFC 3174 (Secure Hash Algor"
  "ithm). The value is returned as a string of\\n40 hexadecimal digits, or NULL if the argument is NULL. One of the\\nposs"
  "ible uses for this function is as a hash key. See the notes at the\\nbeginning of this section about storing hash valu"
  "es efficiently. SHA()\\nis synonymous with SHA1().\\n\\nThe return value is a string in the connection character set.\\n\\"
  "nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','mysql> SELECT SHA1(\\'abc\\');\\n        -"
  "> \\'a9993e364706816aba3e25717850c26c9cd0d89d\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (259,19,'SHA2','Syntax:\\nSHA"
  "2(str, hash_length)\\n\\nCalculates the SHA-2 family of hash functions (SHA-224, SHA-256,\\nSHA-384, and SHA-512). The f"
  "irst argument is the plaintext string to be\\nhashed. The second argument indicates the desired bit length of the\\nres"
  "ult, which must have a value of 224, 256, 384, 512, or 0 (which is\\nequivalent to 256). If either argument is NULL or"
  " the hash length is\\nnot one of the permitted values, the return value is NULL. Otherwise,\\nthe function result is a "
  "hash value containing the desired number of\\nbits. See the notes at the beginning of this section about storing hash\\"
  "nvalues efficiently.\\n\\nThe return value is a string in the connection character set.\\n\\nURL: https://dev.mysql.com/d"
  "oc/refman/8.4/en/encryption-functions.html\\n\\n','mysql> SELECT SHA2(\\'abc\\', 224);\\n        -> \\'23097d223405d8228642"
  "a477bda255b32aadbce4bda0b3f7e36c9da7\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (260,19,'STATEMENT_DIGEST','"
  "STATEMENT_DIGEST(statement)\\n\\nGiven an SQL statement as a string, returns the statement digest hash\\nvalue as a stri"
  "ng in the connection character set, or NULL if the\\nargument is NULL. The related STATEMENT_DIGEST_TEXT() function re"
  "turns\\nthe normalized statement digest. For information about statement\\ndigesting, see\\nhttps://dev.mysql.com/doc/re"
  "fman/8.4/en/performance-schema-statement-di\\ngests.html.\\n\\nBoth functions use the MySQL parser to parse the statemen"
  "t. If parsing\\nfails, an error occurs. The error message includes the parse error only\\nif the statement is provided "
  "as a literal string.\\n\\nThe max_digest_length system variable determines the maximum number of\\nbytes available to th"
  "ese functions for computing normalized statement\\ndigests.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption"
  "-functions.html\\n\\n','mysql> SET @stmt = \\'SELECT * FROM mytable WHERE cola = 10 AND colb = 20\\';\\nmysql> SELECT STAT"
  "EMENT_DIGEST(@stmt);\\n+------------------------------------------------------------------+\\n| STATEMENT_DIGEST(@stmt)"
  "                                          |\\n+------------------------------------------------------------------+\\n| "
  "3bb95eeade896657c4526e74ff2a2862039d0a0fe8a9e7155b5fe492cbd78387 |\\n+------------------------------------------------"
  "------------------+\\nmysql> SELECT STATEMENT_DIGEST_TEXT(@stmt);\\n+--------------------------------------------------"
  "--------+\\n| STATEMENT_DIGEST_TEXT(@stmt)                             |\\n+-------------------------------------------"
  "---------------+\\n| SELECT * FROM `mytable` WHERE `cola` = ? AND `colb` = ?  |\\n+------------------------------------"
  "----------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (261,19,'STATEMENT_DIGEST_TE"
  "XT','STATEMENT_DIGEST_TEXT(statement)\\n\\nGiven an SQL statement as a string, returns the normalized statement\\ndigest"
  " as a string in the connection character set, or NULL if the\\nargument is NULL. For additional discussion and example"
  "s, see the\\ndescription of the related STATEMENT_DIGEST() function.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/e"
  "ncryption-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (262,19,'UNCOMPRESS','Syntax"
  ":\\nUNCOMPRESS(string_to_uncompress)\\n\\nUncompresses a string compressed by the COMPRESS() function. If the\\nargument "
  "is not a compressed value, the result is NULL; if\\nstring_to_uncompress is NULL, the result is also NULL. This functi"
  "on\\nrequires MySQL to have been compiled with a compression library such as\\nzlib. Otherwise, the return value is alw"
  "ays NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','mysql> SELECT UNCOMPRESS(CO"
  "MPRESS(\\'any string\\'));\\n        -> \\'any string\\'\\nmysql> SELECT UNCOMPRESS(\\'any string\\');\\n        -> NULL\\n','h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (263,19,'UNCOMPRESSED_LENGTH"
  "','Syntax:\\nUNCOMPRESSED_LENGTH(compressed_string)\\n\\nReturns the length that the compressed string had before being\\"
  "ncompressed. Returns NULL if compressed_string is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-fu"
  "nctions.html\\n\\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\\'a\\',30)));\\n        -> 30\\n','https://dev.mysq"
  "l.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (264,19,'VALIDATE_PASSWORD_S"
  "TRENGTH','Syntax:\\nVALIDATE_PASSWORD_STRENGTH(str)\\n\\nGiven an argument representing a plaintext password, this funct"
  "ion\\nreturns an integer to indicate how strong the password is, or NULL if\\nthe argument is NULL. The return value ra"
  "nges from 0 (weak) to 100\\n(strong).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html\\n\\n','"
  "','https://dev.mysql.com/doc/refman/8.4/en/encryption-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (265,20,'GET_LOCK','Syntax:\\"
  "nGET_LOCK(str,timeout)\\n\\nTries to obtain a lock with a name given by the string str, using a\\ntimeout of timeout sec"
  "onds. A negative timeout value means infinite\\ntimeout. The lock is exclusive. While held by one session, other\\nsess"
  "ions cannot obtain a lock of the same name.\\n\\nReturns 1 if the lock was obtained successfully, 0 if the attempt time"
  "d\\nout (for example, because another client has previously locked the\\nname), or NULL if an error occurred (such as r"
  "unning out of memory or\\nthe thread was killed with mysqladmin kill).\\n\\nA lock obtained with GET_LOCK() is released "
  "explicitly by executing\\nRELEASE_LOCK() or implicitly when your session terminates (either\\nnormally or abnormally). "
  "Locks obtained with GET_LOCK() are not\\nreleased when transactions commit or roll back.\\n\\nGET_LOCK() is implemented "
  "using the metadata locking (MDL) subsystem.\\nMultiple simultaneous locks can be acquired and GET_LOCK() does not\\nrel"
  "ease any existing locks. For example, suppose that you execute these\\nstatements:\\n\\nSELECT GET_LOCK(\\'lock1\\',10);\\n"
  "SELECT GET_LOCK(\\'lock2\\',10);\\nSELECT RELEASE_LOCK(\\'lock2\\');\\nSELECT RELEASE_LOCK(\\'lock1\\');\\n\\nThe second GET_LO"
  "CK() acquires a second lock and both RELEASE_LOCK()\\ncalls return 1 (success).\\n\\nIt is even possible for a given ses"
  "sion to acquire multiple locks for\\nthe same name. Other sessions cannot acquire a lock with that name\\nuntil the acq"
  "uiring session releases all its locks for the name.\\n\\nUniquely named locks acquired with GET_LOCK() appear in the Pe"
  "rformance\\nSchema metadata_locks table. The OBJECT_TYPE column says USER LEVEL\\nLOCK and the OBJECT_NAME column indic"
  "ates the lock name. In the case\\nthat multiple locks are acquired for the same name, only the first lock\\nfor the nam"
  "e registers a row in the metadata_locks table. Subsequent\\nlocks for the name increment a counter in the lock but do "
  "not acquire\\nadditional metadata locks. The metadata_locks row for the lock is\\ndeleted when the last lock instance o"
  "n the name is released.\\n\\nThe capability of acquiring multiple locks means there is the\\npossibility of deadlock amo"
  "ng clients. When this happens, the server\\nchooses a caller and terminates its lock-acquisition request with an\\nER_U"
  "SER_LOCK_DEADLOCK\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_user_lock_de"
  "adlock) error. This error does not cause\\ntransactions to roll back.\\n\\nMySQL enforces a maximum length on lock names"
  " of 64 characters.\\n\\nGET_LOCK() can be used to implement application locks or to simulate\\nrecord locks. Names are l"
  "ocked on a server-wide basis. If a name has\\nbeen locked within one session, GET_LOCK() blocks any request by\\nanothe"
  "r session for a lock with the same name. This enables clients\\nthat agree on a given lock name to use the name to per"
  "form cooperative\\nadvisory locking. But be aware that it also enables a client that is\\nnot among the set of cooperat"
  "ing clients to lock a name, either\\ninadvertently or deliberately, and thus prevent any of the cooperating\\nclients f"
  "rom locking that name. One way to reduce the likelihood of\\nthis is to use lock names that are database-specific or\\n"
  "application-specific. For example, use lock names of the form\\ndb_name.str or app_name.str.\\n\\nURL: https://dev.mysql"
  ".com/doc/refman/8.4/en/locking-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/locking-functions.html"
  "');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (266,20,'IS_FREE_LOCK','Synt"
  "ax:\\nIS_FREE_LOCK(str)\\n\\nChecks whether the lock named str is free to use (that is, not locked).\\nReturns 1 if the l"
  "ock is free (no one is using the lock), 0 if the lock\\nis in use, and NULL if an error occurs (such as an incorrect a"
  "rgument).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/locking-functions.html\\n\\n','','https://dev.mysql.com/doc/r"
  "efman/8.4/en/locking-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (267,20,'IS_USED_LOCK','Synt"
  "ax:\\nIS_USED_LOCK(str)\\n\\nChecks whether the lock named str is in use (that is, locked). If so,\\nit returns the conne"
  "ction identifier of the client session that holds\\nthe lock. Otherwise, it returns NULL.\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/locking-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/locking-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (268,20,'RELEASE_ALL_LOCKS',"
  "'Syntax:\\nRELEASE_ALL_LOCKS()\\n\\nReleases all named locks held by the current session and returns the\\nnumber of lock"
  "s released (0 if there were none)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/locking-functions.html\\n\\n','','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/locking-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (269,20,'RELEASE_LOCK','Synt"
  "ax:\\nRELEASE_LOCK(str)\\n\\nReleases the lock named by the string str that was obtained with\\nGET_LOCK(). Returns 1 if "
  "the lock was released, 0 if the lock was not\\nestablished by this thread (in which case the lock is not released),\\na"
  "nd NULL if the named lock did not exist. The lock does not exist if it\\nwas never obtained by a call to GET_LOCK() or"
  " if it has previously been\\nreleased.\\n\\nThe DO statement is convenient to use with RELEASE_LOCK(). See [HELP\\nDO].\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/locking-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/e"
  "n/locking-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (270,21,'BENCHMARK','Syntax:"
  "\\nBENCHMARK(count,expr)\\n\\nThe BENCHMARK() function executes the expression expr repeatedly count\\ntimes. It may be u"
  "sed to time how quickly MySQL processes the\\nexpression. The result value is 0, or NULL for inappropriate arguments\\n"
  "such as a NULL or negative repeat count.\\n\\nThe intended use is from within the mysql client, which reports query\\nex"
  "ecution times:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','mysql> SELECT BENCHMA"
  "RK(1000000,AES_ENCRYPT(\\'hello\\',\\'goodbye\\'));\\n+---------------------------------------------------+\\n| BENCHMARK(1"
  "000000,AES_ENCRYPT(\\'hello\\',\\'goodbye\\')) |\\n+---------------------------------------------------+\\n|               "
  "                                  0 |\\n+---------------------------------------------------+\\n1 row in set (4.74 sec)"
  "\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (271,21,'CHARSET','Syntax:\\n"
  "CHARSET(str)\\n\\nReturns the character set of the string argument, or NULL if the\\nargument is NULL.\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','mysql> SELECT CHARSET(\\'abc\\');\\n        -> \\'utf8mb3"
  "\\'\\nmysql> SELECT CHARSET(CONVERT(\\'abc\\' USING latin1));\\n        -> \\'latin1\\'\\nmysql> SELECT CHARSET(USER());\\n   "
  "     -> \\'utf8mb3\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (272,21,'COERCIBILITY','Synt"
  "ax:\\nCOERCIBILITY(str)\\n\\nReturns the collation coercibility value of the string argument.\\n\\nURL: https://dev.mysql."
  "com/doc/refman/8.4/en/information-functions.html\\n\\n','mysql> SELECT COERCIBILITY(\\'abc\\' COLLATE utf8mb4_swedish_ci)"
  ";\\n        -> 0\\nmysql> SELECT COERCIBILITY(USER());\\n        -> 3\\nmysql> SELECT COERCIBILITY(\\'abc\\');\\n        -> "
  "4\\nmysql> SELECT COERCIBILITY(1000);\\n        -> 5\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions."
  "html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (273,21,'COLLATION','Syntax:"
  "\\nCOLLATION(str)\\n\\nReturns the collation of the string argument.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/inf"
  "ormation-functions.html\\n\\n','mysql> SELECT COLLATION(\\'abc\\');\\n        -> \\'utf8mb4_0900_ai_ci\\'\\nmysql> SELECT COL"
  "LATION(_utf8mb4\\'abc\\');\\n        -> \\'utf8mb4_0900_ai_ci\\'\\nmysql> SELECT COLLATION(_latin1\\'abc\\');\\n        -> \\'l"
  "atin1_swedish_ci\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (274,21,'CONNECTION_ID','Syn"
  "tax:\\nCONNECTION_ID()\\n\\nReturns the connection ID (thread ID) for the connection. Every\\nconnection has an ID that i"
  "s unique among the set of currently\\nconnected clients.\\n\\nThe value returned by CONNECTION_ID() is the same type of "
  "value as\\ndisplayed in the ID column of the Information Schema PROCESSLIST table,\\nthe Id column of SHOW PROCESSLIST "
  "output, and the PROCESSLIST_ID column\\nof the Performance Schema threads table.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/information-functions.html\\n\\n','mysql> SELECT CONNECTION_ID();\\n        -> 23786\\n','https://dev.mysql.co"
  "m/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (275,21,'CURRENT_ROLE','CURR"
  "ENT_ROLE()\\n\\nReturns a utf8mb3 string containing the current active roles for the\\ncurrent session, separated by com"
  "mas, or NONE if there are none. The\\nvalue reflects the setting of the sql_quote_show_create system\\nvariable.\\n\\nURL"
  ": https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','GRANT \\'r1\\', \\'r2\\' TO \\'u1\\'@\\'localhost"
  "\\';\\nSET DEFAULT ROLE ALL TO \\'u1\\'@\\'localhost\\';\\n\\nmysql> SELECT CURRENT_ROLE();\\n+-------------------+\\n| CURRENT"
  "_ROLE()    |\\n+-------------------+\\n| `r1`@`%`,`r2`@`%` |\\n+-------------------+\\nmysql> SET ROLE \\'r1\\'; SELECT CUR"
  "RENT_ROLE();\\n+----------------+\\n| CURRENT_ROLE() |\\n+----------------+\\n| `r1`@`%`       |\\n+----------------+\\n','"
  "https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (276,21,'CURRENT_USER','Synt"
  "ax:\\nCURRENT_USER, CURRENT_USER()\\n\\nReturns the user name and host name combination for the MySQL account\\nthat the "
  "server used to authenticate the current client. This account\\ndetermines your access privileges. The return value is "
  "a string in the\\nutf8mb3 character set.\\n\\nThe value of CURRENT_USER() can differ from the value of USER().\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','mysql> SELECT USER();\\n        -> \\'davida@lo"
  "calhost\\'\\nmysql> SELECT * FROM mysql.user;\\nERROR 1044: Access denied for user \\'\\'@\\'localhost\\' to\\ndatabase \\'mys"
  "ql\\'\\nmysql> SELECT CURRENT_USER();\\n        -> \\'@localhost\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/informatio"
  "n-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (277,21,'DATABASE','Syntax:\\"
  "nDATABASE()\\n\\nReturns the default (current) database name as a string in the utf8mb3\\ncharacter set. If there is no "
  "default database, DATABASE() returns\\nNULL. Within a stored routine, the default database is the database\\nthat the r"
  "outine is associated with, which is not necessarily the same\\nas the database that is the default in the calling cont"
  "ext.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','mysql> SELECT DATABASE();\\n    "
  "    -> \\'test\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (278,21,'FOUND_ROWS','Syntax"
  ":\\nFOUND_ROWS()\\n\\n*Note*:\\n\\nThe SQL_CALC_FOUND_ROWS query modifier and accompanying FOUND_ROWS()\\nfunction are depr"
  "ecated; expect them to be removed in a future version\\nof MySQL. Execute the query with LIMIT, and then a second quer"
  "y with\\nCOUNT(*) and without LIMIT to determine whether there are additional\\nrows. For example, instead of these que"
  "ries:\\n\\nSELECT SQL_CALC_FOUND_ROWS * FROM tbl_name WHERE id > 100 LIMIT 10;\\nSELECT FOUND_ROWS();\\n\\nUse these queri"
  "es instead:\\n\\nSELECT * FROM tbl_name WHERE id > 100 LIMIT 10;\\nSELECT COUNT(*) FROM tbl_name WHERE id > 100;\\n\\nCOUN"
  "T(*) is subject to certain optimizations. SQL_CALC_FOUND_ROWS\\ncauses some optimizations to be disabled.\\n\\nA SELECT "
  "statement may include a LIMIT clause to restrict the number of\\nrows the server returns to the client. In some cases,"
  " it is desirable\\nto know how many rows the statement would have returned without the\\nLIMIT, but without running the"
  " statement again. To obtain this row\\ncount, include an SQL_CALC_FOUND_ROWS option in the SELECT statement,\\nand then"
  " invoke FOUND_ROWS() afterward:\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','mysq"
  "l> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\\n    -> WHERE id > 100 LIMIT 10;\\nmysql> SELECT FOUND_ROWS();\\n','https"
  "://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (279,21,'ICU_VERSION','ICU_V"
  "ERSION()\\n\\nThe version of the International Components for Unicode (ICU) library\\nused to support regular expression"
  " operations (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/regexp.html). This function is\\nprimarily intended for use "
  "in test cases.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','','https://dev.mysql."
  "com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (280,21,'LAST_INSERT_ID','Sy"
  "ntax:\\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\\n\\nWith no argument, LAST_INSERT_ID() returns a BIGINT UNSIGNED (64-bit"
  ")\\nvalue representing the first automatically generated value successfully\\ninserted for an AUTO_INCREMENT column as "
  "a result of the most recently\\nexecuted INSERT statement. The value of LAST_INSERT_ID() remains\\nunchanged if no rows"
  " are successfully inserted.\\n\\nWith an argument, LAST_INSERT_ID() returns an unsigned integer, or NULL\\nif the argume"
  "nt is NULL.\\n\\nFor example, after inserting a row that generates an AUTO_INCREMENT\\nvalue, you can get the value like"
  " this:\\n\\nmysql> SELECT LAST_INSERT_ID();\\n        -> 195\\n\\nThe currently executing statement does not affect the va"
  "lue of\\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value\\nwith one statement, and then refer to LA"
  "ST_INSERT_ID() in a\\nmultiple-row INSERT statement that inserts rows into a table with its\\nown AUTO_INCREMENT column"
  ". The value of LAST_INSERT_ID() remains stable\\nin the second statement; its value for the second and later rows is n"
  "ot\\naffected by the earlier row insertions. (You should be aware that, if\\nyou mix references to LAST_INSERT_ID() and"
  " LAST_INSERT_ID(expr), the\\neffect is undefined.)\\n\\nIf the previous statement returned an error, the value of\\nLAST_"
  "INSERT_ID() is undefined. For transactional tables, if the\\nstatement is rolled back due to an error, the value of LA"
  "ST_INSERT_ID()\\nis left undefined. For manual ROLLBACK, the value of LAST_INSERT_ID()\\nis not restored to that before"
  " the transaction; it remains as it was at\\nthe point of the ROLLBACK.\\n\\nWithin the body of a stored routine (procedu"
  "re or function) or a\\ntrigger, the value of LAST_INSERT_ID() changes the same way as for\\nstatements executed outside"
  " the body of these kinds of objects. The\\neffect of a stored routine or trigger upon the value of\\nLAST_INSERT_ID() t"
  "hat is seen by following statements depends on the\\nkind of routine:\\n\\no If a stored procedure executes statements t"
  "hat change the value of\\n  LAST_INSERT_ID(), the changed value is seen by statements that follow\\n  the procedure cal"
  "l.\\n\\no For stored functions and triggers that change the value, the value is\\n  restored when the function or trigge"
  "r ends, so statements coming\\n  after it do not see a changed value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/"
  "information-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (281,21,'ROLES_GRAPHML','ROL"
  "ES_GRAPHML()\\n\\nReturns a utf8mb3 string containing a GraphML document representing\\nmemory role subgraphs. The ROLE_"
  "ADMIN privilege (or the deprecated\\nSUPER privilege) is required to see content in the <graphml> element.\\nOtherwise,"
  " the result shows only an empty element:\\n\\nmysql> SELECT ROLES_GRAPHML();\\n+----------------------------------------"
  "-----------+\\n| ROLES_GRAPHML()                                   |\\n+-----------------------------------------------"
  "----+\\n| <?xml version=\"1.0\" encoding=\"UTF-8\"?><graphml /> |\\n+--------------------------------------------------"
  "-+\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','','https://dev.mysql.com/doc/refm"
  "an/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (282,21,'ROW_COUNT','Syntax:"
  "\\nROW_COUNT()\\n\\nROW_COUNT() returns a value as follows:\\n\\no DDL statements: 0. This applies to statements such as C"
  "REATE TABLE or\\n  DROP TABLE.\\n\\no DML statements other than SELECT: The number of affected rows. This\\n  applies to "
  "statements such as UPDATE, INSERT, or DELETE (as before),\\n  but now also to statements such as ALTER TABLE and LOAD "
  "DATA.\\n\\no SELECT: -1 if the statement returns a result set, or the number of\\n  rows \"affected\" if it does not. Fo"
  "r example, for SELECT * FROM t1,\\n  ROW_COUNT() returns -1. For SELECT * FROM t1 INTO OUTFILE\\n  \\'file_name\\', ROW_C"
  "OUNT() returns the number of rows written to the\\n  file.\\n\\no SIGNAL statements: 0.\\n\\nFor UPDATE statements, the af"
  "fected-rows value by default is the number\\nof rows actually changed. If you specify the CLIENT_FOUND_ROWS flag to\\nm"
  "ysql_real_connect()\\n(https://dev.mysql.com/doc/c-api/8.4/en/mysql-real-connect.html) when\\nconnecting to mysqld, the"
  " affected-rows value is the number of rows\\n\"found\"; that is, matched by the WHERE clause.\\n\\nFor REPLACE statement"
  "s, the affected-rows value is 2 if the new row\\nreplaced an old row, because in this case, one row was inserted after"
  "\\nthe duplicate was deleted.\\n\\nFor INSERT ... ON DUPLICATE KEY UPDATE statements, the affected-rows\\nvalue per row i"
  "s 1 if the row is inserted as a new row, 2 if an\\nexisting row is updated, and 0 if an existing row is set to its cur"
  "rent\\nvalues. If you specify the CLIENT_FOUND_ROWS flag, the affected-rows\\nvalue is 1 (not 0) if an existing row is "
  "set to its current values.\\n\\nThe ROW_COUNT() value is similar to the value from the\\nmysql_affected_rows()\\n(https:/"
  "/dev.mysql.com/doc/c-api/8.4/en/mysql-affected-rows.html) C API\\nfunction and the row count that the mysql client dis"
  "plays following\\nstatement execution.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n'"
  ",'mysql> INSERT INTO t VALUES(1),(2),(3);\\nQuery OK, 3 rows affected (0.00 sec)\\nRecords: 3  Duplicates: 0  Warnings:"
  " 0\\n\\nmysql> SELECT ROW_COUNT();\\n+-------------+\\n| ROW_COUNT() |\\n+-------------+\\n|           3 |\\n+-------------+"
  "\\n1 row in set (0.00 sec)\\n\\nmysql> DELETE FROM t WHERE i IN(1,2);\\nQuery OK, 2 rows affected (0.00 sec)\\n\\nmysql> SE"
  "LECT ROW_COUNT();\\n+-------------+\\n| ROW_COUNT() |\\n+-------------+\\n|           2 |\\n+-------------+\\n1 row in set "
  "(0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (283,21,'SCHEMA','Syntax:\\nS"
  "CHEMA()\\n\\nThis function is a synonym for DATABASE().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/information-fun"
  "ctions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (284,21,'SESSION_USER','Synt"
  "ax:\\nSESSION_USER()\\n\\nSESSION_USER() is a synonym for USER().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/inform"
  "ation-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (285,21,'SYSTEM_USER','Synta"
  "x:\\nSYSTEM_USER()\\n\\nSYSTEM_USER() is a synonym for USER().\\n\\n*Note*:\\n\\nThe SYSTEM_USER() function is distinct from"
  " the SYSTEM_USER privilege.\\nThe former returns the current MySQL account name. The latter\\ndistinguishes the system "
  "user and regular user account categories (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/account-categories.html).\\n\\nU"
  "RL: https://dev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/"
  "en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (286,21,'USER','Syntax:\\nUSE"
  "R()\\n\\nReturns the current MySQL user name and host name as a string in the\\nutf8mb3 character set.\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/information-functions.html\\n\\n','mysql> SELECT USER();\\n        -> \\'davida@localhost\\"
  "'\\n','https://dev.mysql.com/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (287,21,'VERSION','Syntax:\\n"
  "VERSION()\\n\\nReturns a string that indicates the MySQL server version. The string\\nuses the utf8mb3 character set. Th"
  "e value might have a suffix in\\naddition to the version number. See the description of the version\\nsystem variable i"
  "n\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-system-variables.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4"
  "/en/information-functions.html\\n\\n','mysql> SELECT VERSION();\\n        -> \\'8.4.0-standard\\'\\n','https://dev.mysql.co"
  "m/doc/refman/8.4/en/information-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (288,23,'ST_GEOMCOLLFROMTEXT"
  "','ST_GeomCollFromText(wkt [, srid [, options]]),\\nST_GeometryCollectionFromText(wkt [, srid [, options]]),\\nST_GeomC"
  "ollFromTxt(wkt [, srid [, options]])\\n\\nConstructs a GeometryCollection value using its WKT representation and\\nSRID."
  "\\n\\nThese functions handle their arguments as described in the introduction\\nto this section.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','mysql> SET @g = \"MULTILINESTRING((10 10, 11 11), (9 9, 10 10))"
  "\";\\nmysql> SELECT ST_AsText(ST_GeomCollFromText(@g));\\n+--------------------------------------------+\\n| ST_AsText(S"
  "T_GeomCollFromText(@g))         |\\n+--------------------------------------------+\\n| MULTILINESTRING((10 10,11 11),(9"
  " 9,10 10)) |\\n+--------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-func"
  "tions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (289,23,'ST_GEOMFROMTEXT','S"
  "T_GeomFromText(wkt [, srid [, options]]), ST_GeometryFromText(wkt [,\\nsrid [, options]])\\n\\nConstructs a geometry val"
  "ue of any type using its WKT representation\\nand SRID.\\n\\nThese functions handle their arguments as described in the "
  "introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','https:"
  "//dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (290,23,'ST_LINEFROMTEXT','S"
  "T_LineFromText(wkt [, srid [, options]]), ST_LineStringFromText(wkt [,\\nsrid [, options]])\\n\\nConstructs a LineString"
  " value using its WKT representation and SRID.\\n\\nThese functions handle their arguments as described in the introduct"
  "ion\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','https://dev.mys"
  "ql.com/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (291,23,'ST_MLINEFROMTEXT','"
  "ST_MLineFromText(wkt [, srid [, options]]),\\nST_MultiLineStringFromText(wkt [, srid [, options]])\\n\\nConstructs a Mul"
  "tiLineString value using its WKT representation and\\nSRID.\\n\\nThese functions handle their arguments as described in "
  "the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (292,23,'ST_MPOINTFROMTEXT',"
  "'ST_MPointFromText(wkt [, srid [, options]]), ST_MultiPointFromText(wkt\\n[, srid [, options]])\\n\\nConstructs a MultiP"
  "oint value using its WKT representation and SRID.\\n\\nThese functions handle their arguments as described in the intro"
  "duction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','https://dev"
  ".mysql.com/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (293,23,'ST_MPOLYFROMTEXT','"
  "ST_MPolyFromText(wkt [, srid [, options]]), ST_MultiPolygonFromText(wkt\\n[, srid [, options]])\\n\\nConstructs a MultiP"
  "olygon value using its WKT representation and SRID.\\n\\nThese functions handle their arguments as described in the int"
  "roduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','https://d"
  "ev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (294,23,'ST_POINTFROMTEXT','"
  "ST_PointFromText(wkt [, srid [, options]])\\n\\nConstructs a Point value using its WKT representation and SRID.\\n\\nST_P"
  "ointFromText() handles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com"
  "/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (295,23,'ST_POLYFROMTEXT','S"
  "T_PolyFromText(wkt [, srid [, options]]), ST_PolygonFromText(wkt [,\\nsrid [, options]])\\n\\nConstructs a Polygon value"
  " using its WKT representation and SRID.\\n\\nThese functions handle their arguments as described in the introduction\\nt"
  "o this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkt-functions.html\\n\\n','','https://dev.mysql.com"
  "/doc/refman/8.4/en/gis-wkt-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (296,24,'ST_GEOMCOLLFROMWKB'"
  ",'ST_GeomCollFromWKB(wkb [, srid [, options]]),\\nST_GeometryCollectionFromWKB(wkb [, srid [, options]])\\n\\nConstructs"
  " a GeometryCollection value using its WKB representation and\\nSRID.\\n\\nThese functions handle their arguments as desc"
  "ribed in the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\"
  "n','','https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (297,24,'ST_GEOMFROMWKB','ST"
  "_GeomFromWKB(wkb [, srid [, options]]), ST_GeometryFromWKB(wkb [,\\nsrid [, options]])\\n\\nConstructs a geometry value "
  "of any type using its WKB representation\\nand SRID.\\n\\nThese functions handle their arguments as described in the int"
  "roduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https://d"
  "ev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (298,24,'ST_LINEFROMWKB','ST"
  "_LineFromWKB(wkb [, srid [, options]]), ST_LineStringFromWKB(wkb [,\\nsrid [, options]])\\n\\nConstructs a LineString va"
  "lue using its WKB representation and SRID.\\n\\nThese functions handle their arguments as described in the introduction"
  "\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https://dev.mysql."
  "com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (299,24,'ST_MLINEFROMWKB','S"
  "T_MLineFromWKB(wkb [, srid [, options]]),\\nST_MultiLineStringFromWKB(wkb [, srid [, options]])\\n\\nConstructs a MultiL"
  "ineString value using its WKB representation and\\nSRID.\\n\\nThese functions handle their arguments as described in the"
  " introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https"
  "://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (300,24,'ST_MPOINTFROMWKB','"
  "ST_MPointFromWKB(wkb [, srid [, options]]), ST_MultiPointFromWKB(wkb [,\\nsrid [, options]])\\n\\nConstructs a MultiPoin"
  "t value using its WKB representation and SRID.\\n\\nThese functions handle their arguments as described in the introduc"
  "tion\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https://dev.my"
  "sql.com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (301,24,'ST_MPOLYFROMWKB','S"
  "T_MPolyFromWKB(wkb [, srid [, options]]), ST_MultiPolygonFromWKB(wkb\\n[, srid [, options]])\\n\\nConstructs a MultiPoly"
  "gon value using its WKB representation and SRID.\\n\\nThese functions handle their arguments as described in the introd"
  "uction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https://dev."
  "mysql.com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (302,24,'ST_POINTFROMWKB','S"
  "T_PointFromWKB(wkb [, srid [, options]])\\n\\nConstructs a Point value using its WKB representation and SRID.\\n\\nST_Poi"
  "ntFromWKB() handles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/do"
  "c/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (303,24,'ST_POLYFROMWKB','ST"
  "_PolyFromWKB(wkb [, srid [, options]]), ST_PolygonFromWKB(wkb [, srid\\n[, options]])\\n\\nConstructs a Polygon value us"
  "ing its WKB representation and SRID.\\n\\nThese functions handle their arguments as described in the introduction\\nto t"
  "his section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-wkb-functions.html\\n\\n','','https://dev.mysql.com/do"
  "c/refman/8.4/en/gis-wkb-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (304,25,'GEOMCOLLECTION','Ge"
  "omCollection(g [, g] ...)\\n\\nConstructs a GeomCollection value from the geometry arguments.\\n\\nGeomCollection() retur"
  "ns all the proper geometries contained in the\\narguments even if a nonsupported geometry is present.\\n\\nGeomCollectio"
  "n() with no arguments is permitted as a way to create an\\nempty geometry. Also, functions such as ST_GeomFromText() t"
  "hat accept\\nWKT geometry collection arguments understand both OpenGIS\\n\\'GEOMETRYCOLLECTION EMPTY\\' standard syntax a"
  "nd MySQL\\n\\'GEOMETRYCOLLECTION()\\' nonstandard syntax.\\n\\nGeomCollection() and GeometryCollection() are synonymous, w"
  "ith\\nGeomCollection() the preferred function.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-func"
  "tions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (305,25,'GEOMETRYCOLLECTION'"
  ",'GeometryCollection(g [, g] ...)\\n\\nConstructs a GeomCollection value from the geometry arguments.\\n\\nGeometryCollec"
  "tion() returns all the proper geometries contained in the\\narguments even if a nonsupported geometry is present.\\n\\nG"
  "eometryCollection() with no arguments is permitted as a way to create\\nan empty geometry. Also, functions such as ST_"
  "GeomFromText() that\\naccept WKT geometry collection arguments understand both OpenGIS\\n\\'GEOMETRYCOLLECTION EMPTY\\' s"
  "tandard syntax and MySQL\\n\\'GEOMETRYCOLLECTION()\\' nonstandard syntax.\\n\\nGeomCollection() and GeometryCollection() a"
  "re synonymous, with\\nGeomCollection() the preferred function.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-mys"
  "ql-specific-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (306,25,'LINESTRING','LineSt"
  "ring(pt [, pt] ...)\\n\\nConstructs a LineString value from a number of Point or WKB Point\\narguments. If the number of"
  " arguments is less than two, the return\\nvalue is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-spe"
  "cific-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (307,25,'MULTILINESTRING','M"
  "ultiLineString(ls [, ls] ...)\\n\\nConstructs a MultiLineString value using LineString or WKB LineString\\narguments.\\n\\"
  "nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html\\n\\n','','https://dev.mysql.com/doc/re"
  "fman/8.4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (308,25,'MULTIPOINT','MultiP"
  "oint(pt [, pt2] ...)\\n\\nConstructs a MultiPoint value using Point or WKB Point arguments.\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/gis-mysql-specific-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-spe"
  "cific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (309,25,'MULTIPOLYGON','Mult"
  "iPolygon(poly [, poly] ...)\\n\\nConstructs a MultiPolygon value from a set of Polygon or WKB Polygon\\narguments.\\n\\nUR"
  "L: https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html\\n\\n','','https://dev.mysql.com/doc/refma"
  "n/8.4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (310,25,'POINT','Point(x, y)"
  "\\n\\nConstructs a Point using its coordinates.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-func"
  "tions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (311,25,'POLYGON','Polygon(l"
  "s [, ls] ...)\\n\\nConstructs a Polygon value from a number of LineString or WKB\\nLineString arguments. If any argument"
  " does not represent a LinearRing\\n(that is, not a closed and simple LineString), the return value is\\nNULL.\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/gis-mysql-specific-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8."
  "4/en/gis-mysql-specific-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (312,24,'ST_ASBINARY','ST_As"
  "Binary(g [, options]), ST_AsWKB(g [, options])\\n\\nConverts a value in internal geometry format to its WKB representat"
  "ion\\nand returns the binary result.\\n\\nThe function return value has geographic coordinates (latitude,\\nlongitude) in"
  " the order specified by the spatial reference system that\\napplies to the geometry argument. An optional options argu"
  "ment may be\\ngiven to override the default axis order.\\n\\nST_AsBinary() and ST_AsWKB() handle their arguments as desc"
  "ribed in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-format-conversion-fun"
  "ctions.html\\n\\n','mysql> SET @g = ST_LineFromText(\\'LINESTRING(0 5,5 10,10 15)\\', 4326);\\nmysql> SELECT ST_AsText(ST_"
  "GeomFromWKB(ST_AsWKB(@g)));\\n+-----------------------------------------+\\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g))) |"
  "\\n+-----------------------------------------+\\n| LINESTRING(5 0,10 5,15 10)              |\\n+------------------------"
  "-----------------+\\nmysql> SELECT ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \\'axis-order=long-lat\\')));\\n+---------------"
  "-------------------------------------------------+\\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \\'axis-order=long-lat\\'))"
  ") |\\n+----------------------------------------------------------------+\\n| LINESTRING(0 5,5 10,10 15)                "
  "                     |\\n+----------------------------------------------------------------+\\nmysql> SELECT ST_AsText(S"
  "T_GeomFromWKB(ST_AsWKB(@g, \\'axis-order=lat-long\\')));\\n+------------------------------------------------------------"
  "----+\\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \\'axis-order=lat-long\\'))) |\\n+---------------------------------------"
  "-------------------------+\\n| LINESTRING(5 0,10 5,15 10)                                     |\\n+--------------------"
  "--------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-format-conversion-funct"
  "ions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (313,24,'ST_ASTEXT','ST_AsTe"
  "xt(g [, options]), ST_AsWKT(g [, options])\\n\\nConverts a value in internal geometry format to its WKT representation\\"
  "nand returns the string result.\\n\\nThe function return value has geographic coordinates (latitude,\\nlongitude) in the"
  " order specified by the spatial reference system that\\napplies to the geometry argument. An optional options argument"
  " may be\\ngiven to override the default axis order.\\n\\nST_AsText() and ST_AsWKT() handle their arguments as described "
  "in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-format-conversion-functions"
  ".html\\n\\n','mysql> SET @g = \\'LineString(1 1,2 2,3 3)\\';\\nmysql> SELECT ST_AsText(ST_GeomFromText(@g));\\n+-----------"
  "---------------------+\\n| ST_AsText(ST_GeomFromText(@g)) |\\n+--------------------------------+\\n| LINESTRING(1 1,2 2,"
  "3 3)        |\\n+--------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-format-conversion-f"
  "unctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (314,24,'ST_SWAPXY','ST_Swap"
  "XY(g)\\n\\nAccepts an argument in internal geometry format, swaps the X and Y\\nvalues of each coordinate pair within th"
  "e geometry, and returns the\\nresult.\\n\\nST_SwapXY() handles its arguments as described in the introduction to\\nthis s"
  "ection.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-format-conversion-functions.html\\n\\n','mysql> SET @g = ST"
  "_LineFromText(\\'LINESTRING(0 5,5 10,10 15)\\');\\nmysql> SELECT ST_AsText(@g);\\n+----------------------------+\\n| ST_As"
  "Text(@g)              |\\n+----------------------------+\\n| LINESTRING(0 5,5 10,10 15) |\\n+---------------------------"
  "-+\\nmysql> SELECT ST_AsText(ST_SwapXY(@g));\\n+----------------------------+\\n| ST_AsText(ST_SwapXY(@g))   |\\n+-------"
  "---------------------+\\n| LINESTRING(5 0,10 5,15 10) |\\n+----------------------------+\\n','https://dev.mysql.com/doc/"
  "refman/8.4/en/gis-format-conversion-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (315,26,'ST_DIMENSION','ST_D"
  "imension(g)\\n\\nReturns the inherent dimension of the geometry value g. The dimension\\ncan be −1, 0, 1, or 2. The me"
  "aning of these values is given in\\nhttps://dev.mysql.com/doc/refman/8.4/en/gis-class-geometry.html.\\n\\nST_Dimension()"
  " handles its arguments as described in the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/gis-general-property-functions.html\\n\\n','mysql> SELECT ST_Dimension(ST_GeomFromText(\\'LineString(1 1,2 2)\\'));\\"
  "n+------------------------------------------------------+\\n| ST_Dimension(ST_GeomFromText(\\'LineString(1 1,2 2)\\')) |"
  "\\n+------------------------------------------------------+\\n|                                                    1 |\\"
  "n+------------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-general-pro"
  "perty-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (316,26,'ST_ENVELOPE','ST_En"
  "velope(g)\\n\\nReturns the minimum bounding rectangle (MBR) for the geometry value g.\\nThe result is returned as a Poly"
  "gon value that is defined by the corner\\npoints of the bounding box:\\n\\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MIN"
  "X MAXY, MINX MINY))\\n\\nmysql> SELECT ST_AsText(ST_Envelope(ST_GeomFromText(\\'LineString(1 1,2 2)\\')));\\n+------------"
  "----------------------------------------------------+\\n| ST_AsText(ST_Envelope(ST_GeomFromText(\\'LineString(1 1,2 2)\\"
  "'))) |\\n+----------------------------------------------------------------+\\n| POLYGON((1 1,2 1,2 2,1 2,1 1))         "
  "                        |\\n+----------------------------------------------------------------+\\n\\nIf the argument is a"
  " point or a vertical or horizontal line segment,\\nST_Envelope() returns the point or the line segment as its MBR rath"
  "er\\nthan returning an invalid polygon:\\n\\nmysql> SELECT ST_AsText(ST_Envelope(ST_GeomFromText(\\'LineString(1 1,1 2)\\'"
  ")));\\n+----------------------------------------------------------------+\\n| ST_AsText(ST_Envelope(ST_GeomFromText(\\'L"
  "ineString(1 1,1 2)\\'))) |\\n+----------------------------------------------------------------+\\n| LINESTRING(1 1,1 2) "
  "                                           |\\n+----------------------------------------------------------------+\\n\\nS"
  "T_Envelope() handles its arguments as described in the introduction to\\nthis section, with this exception:\\n\\no If th"
  "e geometry has an SRID value for a geographic spatial reference\\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC"
  "_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_not_implemented_for_g"
  "eographic_srs) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-general-property-functions.html\\n\\n'"
  ",'','https://dev.mysql.com/doc/refman/8.4/en/gis-general-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (317,26,'ST_GEOMETRYTYPE','S"
  "T_GeometryType(g)\\n\\nReturns a binary string indicating the name of the geometry type of\\nwhich the geometry instance"
  " g is a member. The name corresponds to one\\nof the instantiable Geometry subclasses.\\n\\nST_GeometryType() handles it"
  "s arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-ge"
  "neral-property-functions.html\\n\\n','mysql> SELECT ST_GeometryType(ST_GeomFromText(\\'POINT(1 1)\\'));\\n+---------------"
  "---------------------------------+\\n| ST_GeometryType(ST_GeomFromText(\\'POINT(1 1)\\')) |\\n+--------------------------"
  "----------------------+\\n| POINT                                          |\\n+---------------------------------------"
  "---------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-general-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (318,26,'ST_ISEMPTY','ST_IsE"
  "mpty(g)\\n\\nThis function is a placeholder that returns 1 for an empty geometry\\ncollection value or 0 otherwise.\\n\\nT"
  "he only valid empty geometry is represented in the form of an empty\\ngeometry collection value. MySQL does not suppor"
  "t GIS EMPTY values such\\nas POINT EMPTY.\\n\\nST_IsEmpty() handles its arguments as described in the introduction to\\nt"
  "his section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-general-property-functions.html\\n\\n','','https://dev"
  ".mysql.com/doc/refman/8.4/en/gis-general-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (319,26,'ST_ISSIMPLE','ST_Is"
  "Simple(g)\\n\\nReturns 1 if the geometry value g is simple according to the ISO SQL/MM\\nPart 3: Spatial standard. ST_Is"
  "Simple() returns 0 if the argument is\\nnot simple.\\n\\nThe descriptions of the instantiable geometric classes given un"
  "der\\nhttps://dev.mysql.com/doc/refman/8.4/en/opengis-geometry-model.html\\ninclude the specific conditions that cause "
  "class instances to be\\nclassified as not simple.\\n\\nST_IsSimple() handles its arguments as described in the introduct"
  "ion to\\nthis section, with this exception:\\n\\no If the geometry has a geographic SRS with a longitude or latitude\\n  "
  "that is out of range, an error occurs:\\n\\n  o If a longitude value is not in the range (−180, 180], an\\n    ER_GEOM"
  "ETRY_PARAM_LONGITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.ht"
  "ml#error_er_geometry_param_longitude_out_of_range) error\\n    occurs.\\n\\n  o If a latitude value is not in the range "
  "[−90, 90], an\\n    ER_GEOMETRY_PARAM_LATITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/serv"
  "er-error-referen\\n    ce.html#error_er_geometry_param_latitude_out_of_range) error\\n    occurs.\\n\\n  Ranges shown are"
  " in degrees. The exact range limits deviate slightly\\n  due to floating-point arithmetic.\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/gis-general-property-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/gis-general"
  "-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (320,26,'ST_SRID','ST_SRID(g"
  " [, srid])\\n\\nWith a single argument representing a valid geometry object g,\\nST_SRID() returns an integer indicating"
  " the ID of the spatial reference\\nsystem (SRS) associated with g.\\n\\nWith the optional second argument representing a"
  " valid SRID value,\\nST_SRID() returns an object with the same type as its first argument\\nwith an SRID value equal to"
  " the second argument. This only sets the\\nSRID value of the object; it does not perform any transformation of\\ncoordi"
  "nate values.\\n\\nST_SRID() handles its arguments as described in the introduction to\\nthis section, with this exceptio"
  "n:\\n\\no For the single-argument syntax, ST_SRID() returns the geometry SRID\\n  even if it refers to an undefined SRS."
  " An ER_SRS_NOT_FOUND\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_srs_n"
  "ot_found) error does not occur.\\n\\nST_SRID(g, target_srid) and ST_Transform(g, target_srid) differ as\\nfollows:\\n\\no "
  "ST_SRID() changes the geometry SRID value without transforming its\\n  coordinates.\\n\\no ST_Transform() transforms the"
  " geometry coordinates in addition to\\n  changing its SRID value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-"
  "general-property-functions.html\\n\\n','mysql> SET @g = ST_GeomFromText(\\'LineString(1 1,2 2)\\', 0);\\nmysql> SELECT ST_"
  "SRID(@g);\\n+-------------+\\n| ST_SRID(@g) |\\n+-------------+\\n|           0 |\\n+-------------+\\nmysql> SET @g = ST_SR"
  "ID(@g, 4326);\\nmysql> SELECT ST_SRID(@g);\\n+-------------+\\n| ST_SRID(@g) |\\n+-------------+\\n|        4326 |\\n+-----"
  "--------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-general-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (321,27,'ST_LATITUDE','ST_La"
  "titude(p [, new_latitude_val])\\n\\nWith a single argument representing a valid Point object p that has a\\ngeographic s"
  "patial reference system (SRS), ST_Latitude() returns the\\nlatitude value of p as a double-precision number.\\n\\nWith t"
  "he optional second argument representing a valid latitude value,\\nST_Latitude() returns a Point object like the first"
  " argument with its\\nlatitude equal to the second argument.\\n\\nST_Latitude() handles its arguments as described in the"
  " introduction to\\nthis section, with the addition that if the Point object is valid but\\ndoes not have a geographic S"
  "RS, an ER_SRS_NOT_GEOGRAPHIC\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_s"
  "rs_not_geographic) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-point-property-functions.html\\n\\"
  "n','mysql> SET @pt = ST_GeomFromText(\\'POINT(45 90)\\', 4326);\\nmysql> SELECT ST_Latitude(@pt);\\n+------------------+\\"
  "n| ST_Latitude(@pt) |\\n+------------------+\\n|               45 |\\n+------------------+\\nmysql> SELECT ST_AsText(ST_L"
  "atitude(@pt, 10));\\n+---------------------------------+\\n| ST_AsText(ST_Latitude(@pt, 10)) |\\n+----------------------"
  "-----------+\\n| POINT(10 90)                    |\\n+---------------------------------+\\n','https://dev.mysql.com/doc/"
  "refman/8.4/en/gis-point-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (322,27,'ST_LONGITUDE','ST_L"
  "ongitude(p [, new_longitude_val])\\n\\nWith a single argument representing a valid Point object p that has a\\ngeographi"
  "c spatial reference system (SRS), ST_Longitude() returns the\\nlongitude value of p as a double-precision number.\\n\\nW"
  "ith the optional second argument representing a valid longitude value,\\nST_Longitude() returns a Point object like th"
  "e first argument with its\\nlongitude equal to the second argument.\\n\\nST_Longitude() handles its arguments as describ"
  "ed in the introduction\\nto this section, with the addition that if the Point object is valid\\nbut does not have a geo"
  "graphic SRS, an ER_SRS_NOT_GEOGRAPHIC\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference.html\\n#e"
  "rror_er_srs_not_geographic) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-point-property-function"
  "s.html\\n\\n','mysql> SET @pt = ST_GeomFromText(\\'POINT(45 90)\\', 4326);\\nmysql> SELECT ST_Longitude(@pt);\\n+----------"
  "---------+\\n| ST_Longitude(@pt) |\\n+-------------------+\\n|                90 |\\n+-------------------+\\nmysql> SELECT"
  " ST_AsText(ST_Longitude(@pt, 10));\\n+----------------------------------+\\n| ST_AsText(ST_Longitude(@pt, 10)) |\\n+----"
  "------------------------------+\\n| POINT(45 10)                     |\\n+----------------------------------+\\n','https"
  "://dev.mysql.com/doc/refman/8.4/en/gis-point-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (323,27,'ST_X','ST_X(p [, ne"
  "w_x_val])\\n\\nWith a single argument representing a valid Point object p, ST_X()\\nreturns the X-coordinate value of p "
  "as a double-precision number. The X\\ncoordinate is considered to refer to the axis that appears first in the\\nPoint s"
  "patial reference system (SRS) definition.\\n\\nWith the optional second argument, ST_X() returns a Point object like\\nt"
  "he first argument with its X coordinate equal to the second argument.\\nIf the Point object has a geographic SRS, the "
  "second argument must be\\nin the proper range for longitude or latitude values.\\n\\nST_X() handles its arguments as des"
  "cribed in the introduction to this\\nsection.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-point-property-funct"
  "ions.html\\n\\n','mysql> SELECT ST_X(Point(56.7, 53.34));\\n+--------------------------+\\n| ST_X(Point(56.7, 53.34)) |\\n"
  "+--------------------------+\\n|                     56.7 |\\n+--------------------------+\\nmysql> SELECT ST_AsText(ST_"
  "X(Point(56.7, 53.34), 10.5));\\n+-------------------------------------------+\\n| ST_AsText(ST_X(Point(56.7, 53.34), 10"
  ".5)) |\\n+-------------------------------------------+\\n| POINT(10.5 53.34)                         |\\n+--------------"
  "-----------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-point-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (324,27,'ST_Y','ST_Y(p [, ne"
  "w_y_val])\\n\\nWith a single argument representing a valid Point object p, ST_Y()\\nreturns the Y-coordinate value of p "
  "as a double-precision number.The Y\\ncoordinate is considered to refer to the axis that appears second in\\nthe Point s"
  "patial reference system (SRS) definition.\\n\\nWith the optional second argument, ST_Y() returns a Point object like\\nt"
  "he first argument with its Y coordinate equal to the second argument.\\nIf the Point object has a geographic SRS, the "
  "second argument must be\\nin the proper range for longitude or latitude values.\\n\\nST_Y() handles its arguments as des"
  "cribed in the introduction to this\\nsection.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-point-property-funct"
  "ions.html\\n\\n','mysql> SELECT ST_Y(Point(56.7, 53.34));\\n+--------------------------+\\n| ST_Y(Point(56.7, 53.34)) |\\n"
  "+--------------------------+\\n|                    53.34 |\\n+--------------------------+\\nmysql> SELECT ST_AsText(ST_"
  "Y(Point(56.7, 53.34), 10.5));\\n+-------------------------------------------+\\n| ST_AsText(ST_Y(Point(56.7, 53.34), 10"
  ".5)) |\\n+-------------------------------------------+\\n| POINT(56.7 10.5)                          |\\n+--------------"
  "-----------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-point-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (325,28,'ST_ENDPOINT','ST_En"
  "dPoint(ls)\\n\\nReturns the Point that is the endpoint of the LineString value ls.\\n\\nST_EndPoint() handles its argumen"
  "ts as described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-"
  "property-functions.html\\n\\n','mysql> SET @ls = \\'LineString(1 1,2 2,3 3)\\';\\nmysql> SELECT ST_AsText(ST_EndPoint(ST_G"
  "eomFromText(@ls)));\\n+----------------------------------------------+\\n| ST_AsText(ST_EndPoint(ST_GeomFromText(@ls)))"
  " |\\n+----------------------------------------------+\\n| POINT(3 3)                                   |\\n+------------"
  "----------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-property-functions.htm"
  "l');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (326,28,'ST_ISCLOSED','ST_Is"
  "Closed(ls)\\n\\nFor a LineString value ls, ST_IsClosed() returns 1 if ls is closed\\n(that is, its ST_StartPoint() and S"
  "T_EndPoint() values are the same).\\n\\nFor a MultiLineString value ls, ST_IsClosed() returns 1 if ls is closed\\n(that "
  "is, the ST_StartPoint() and ST_EndPoint() values are the same for\\neach LineString in ls).\\n\\nST_IsClosed() returns 0"
  " if ls is not closed, and NULL if ls is NULL.\\n\\nST_IsClosed() handles its arguments as described in the introduction"
  " to\\nthis section, with this exception:\\n\\no If the geometry has an SRID value for a geographic spatial reference\\n  "
  "system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error"
  "-reference\\n  .html#error_er_not_implemented_for_geographic_srs) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refm"
  "an/8.4/en/gis-linestring-property-functions.html\\n\\n','mysql> SET @ls1 = \\'LineString(1 1,2 2,3 3,2 2)\\';\\nmysql> SET"
  " @ls2 = \\'LineString(1 1,2 2,3 3,1 1)\\';\\n\\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls1));\\n+---------------------"
  "---------------+\\n| ST_IsClosed(ST_GeomFromText(@ls1)) |\\n+------------------------------------+\\n|                  "
  "                0 |\\n+------------------------------------+\\n\\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls2));\\n+--"
  "----------------------------------+\\n| ST_IsClosed(ST_GeomFromText(@ls2)) |\\n+------------------------------------+\\n"
  "|                                  1 |\\n+------------------------------------+\\n\\nmysql> SET @ls3 = \\'MultiLineString"
  "((1 1,2 2,3 3),(4 4,5 5))\\';\\n\\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls3));\\n+---------------------------------"
  "---+\\n| ST_IsClosed(ST_GeomFromText(@ls3)) |\\n+------------------------------------+\\n|                              "
  "    0 |\\n+------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-property-f"
  "unctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (327,28,'ST_LENGTH','ST_Leng"
  "th(ls [, unit])\\n\\nReturns a double-precision number indicating the length of the\\nLineString or MultiLineString valu"
  "e ls in its associated spatial\\nreference system. The length of a MultiLineString value is equal to the\\nsum of the l"
  "engths of its elements.\\n\\nST_Length() computes a result as follows:\\n\\no If the geometry is a valid LineString in a "
  "Cartesian SRS, the return\\n  value is the Cartesian length of the geometry.\\n\\no If the geometry is a valid MultiLine"
  "String in a Cartesian SRS, the\\n  return value is the sum of the Cartesian lengths of its elements.\\n\\no If the geome"
  "try is a valid LineString in a geographic SRS, the return\\n  value is the geodetic length of the geometry in that SRS"
  ", in meters.\\n\\no If the geometry is a valid MultiLineString in a geographic SRS, the\\n  return value is the sum of t"
  "he geodetic lengths of its elements in\\n  that SRS, in meters.\\n\\nST_Length() handles its arguments as described in t"
  "he introduction to\\nthis section, with these exceptions:\\n\\no If the geometry is not a LineString or MultiLineString,"
  " the return\\n  value is NULL.\\n\\no If the geometry is geometrically invalid, either the result is an\\n  undefined len"
  "gth (that is, it can be any number), or an error occurs.\\n\\no If the length computation result is +inf, an ER_DATA_OU"
  "T_OF_RANGE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_data_out_of_ran"
  "ge) error occurs.\\n\\no If the geometry has a geographic SRS with a longitude or latitude\\n  that is out of range, an "
  "error occurs:\\n\\n  o If a longitude value is not in the range (−180, 180], an\\n    ER_GEOMETRY_PARAM_LONGITUDE_OUT_"
  "OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.html#error_er_geometry_para"
  "m_longitude_out_of_range) error\\n    occurs.\\n\\n  o If a latitude value is not in the range [−90, 90], an\\n    ER_G"
  "EOMETRY_PARAM_LATITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce."
  "html#error_er_geometry_param_latitude_out_of_range) error\\n    occurs.\\n\\n  Ranges shown are in degrees. The exact ra"
  "nge limits deviate slightly\\n  due to floating-point arithmetic.\\n\\nST_Length() permits an optional unit argument tha"
  "t specifies the linear\\nunit for the returned length value. These rules apply:\\n\\no If a unit is specified but not su"
  "pported by MySQL, an\\n  ER_UNIT_NOT_FOUND\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n "
  " .html#error_er_unit_not_found) error occurs.\\n\\no If a supported linear unit is specified and the SRID is 0, an\\n  E"
  "R_GEOMETRY_IN_UNKNOWN_LENGTH_UNIT\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#e"
  "rror_er_geometry_in_unknown_length_unit) error occurs.\\n\\no If a supported linear unit is specified and the SRID is n"
  "ot 0, the\\n  result is in that unit.\\n\\no If a unit is not specified, the result is in the unit of the SRS of\\n  the "
  "geometries, whether Cartesian or geographic. Currently, all MySQL\\n  SRSs are expressed in meters.\\n\\nA unit is suppo"
  "rted if it is found in the INFORMATION_SCHEMA\\nST_UNITS_OF_MEASURE table. See\\nhttps://dev.mysql.com/doc/refman/8.4/e"
  "n/information-schema-st-units-of-\\nmeasure-table.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-linestring"
  "-property-functions.html\\n\\n','mysql> SET @ls = ST_GeomFromText(\\'LineString(1 1,2 2,3 3)\\');\\nmysql> SELECT ST_Lengt"
  "h(@ls);\\n+--------------------+\\n| ST_Length(@ls)     |\\n+--------------------+\\n| 2.8284271247461903 |\\n+-----------"
  "---------+\\n\\nmysql> SET @mls = ST_GeomFromText(\\'MultiLineString((1 1,2 2,3 3),(4 4,5 5))\\');\\nmysql> SELECT ST_Leng"
  "th(@mls);\\n+-------------------+\\n| ST_Length(@mls)   |\\n+-------------------+\\n| 4.242640687119286 |\\n+-------------"
  "------+\\n\\nmysql> SET @ls = ST_GeomFromText(\\'LineString(1 1,2 2,3 3)\\', 4326);\\nmysql> SELECT ST_Length(@ls);\\n+----"
  "---------------+\\n| ST_Length(@ls)    |\\n+-------------------+\\n| 313701.9623204328 |\\n+-------------------+\\nmysql> "
  "SELECT ST_Length(@ls, \\'metre\\');\\n+-------------------------+\\n| ST_Length(@ls, \\'metre\\') |\\n+---------------------"
  "----+\\n|       313701.9623204328 |\\n+-------------------------+\\nmysql> SELECT ST_Length(@ls, \\'foot\\');\\n+----------"
  "--------------+\\n| ST_Length(@ls, \\'foot\\') |\\n+------------------------+\\n|     1029205.9131247795 |\\n+-------------"
  "-----------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (328,28,'ST_NUMPOINTS','ST_N"
  "umPoints(ls)\\n\\nReturns the number of Point objects in the LineString value ls.\\n\\nST_NumPoints() handles its argumen"
  "ts as described in the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-"
  "property-functions.html\\n\\n','mysql> SET @ls = \\'LineString(1 1,2 2,3 3)\\';\\nmysql> SELECT ST_NumPoints(ST_GeomFromTe"
  "xt(@ls));\\n+------------------------------------+\\n| ST_NumPoints(ST_GeomFromText(@ls)) |\\n+-------------------------"
  "-----------+\\n|                                  3 |\\n+------------------------------------+\\n','https://dev.mysql.co"
  "m/doc/refman/8.4/en/gis-linestring-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (329,28,'ST_POINTN','ST_Poin"
  "tN(ls, N)\\n\\nReturns the N-th Point in the Linestring value ls. Points are numbered\\nbeginning with 1.\\n\\nST_PointN()"
  " handles its arguments as described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/gis-linestring-property-functions.html\\n\\n','mysql> SET @ls = \\'LineString(1 1,2 2,3 3)\\';\\nmysql> SELECT ST_AsT"
  "ext(ST_PointN(ST_GeomFromText(@ls),2));\\n+----------------------------------------------+\\n| ST_AsText(ST_PointN(ST_G"
  "eomFromText(@ls),2)) |\\n+----------------------------------------------+\\n| POINT(2 2)                               "
  "    |\\n+----------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-pr"
  "operty-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (330,28,'ST_STARTPOINT','ST_"
  "StartPoint(ls)\\n\\nReturns the Point that is the start point of the LineString value ls.\\n\\nST_StartPoint() handles it"
  "s arguments as described in the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-li"
  "nestring-property-functions.html\\n\\n','mysql> SET @ls = \\'LineString(1 1,2 2,3 3)\\';\\nmysql> SELECT ST_AsText(ST_Star"
  "tPoint(ST_GeomFromText(@ls)));\\n+------------------------------------------------+\\n| ST_AsText(ST_StartPoint(ST_Geom"
  "FromText(@ls))) |\\n+------------------------------------------------+\\n| POINT(1 1)                                  "
  "   |\\n+------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-linestring-p"
  "roperty-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (331,29,'ST_AREA','ST_Area({"
  "poly|mpoly})\\n\\nReturns a double-precision number indicating the area of the Polygon or\\nMultiPolygon argument, as me"
  "asured in its spatial reference system.\\n\\nST_Area() handles its arguments as described in the introduction to\\nthis "
  "section, with these exceptions:\\n\\no If the geometry is geometrically invalid, either the result is an\\n  undefined a"
  "rea (that is, it can be any number), or an error occurs.\\n\\no If the geometry is valid but is not a Polygon or MultiP"
  "olygon object,\\n  an ER_UNEXPECTED_GEOMETRY_TYPE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-refer"
  "ence\\n  .html#error_er_unexpected_geometry_type) error occurs.\\n\\no If the geometry is a valid Polygon in a Cartesian"
  " SRS, the result is\\n  the Cartesian area of the polygon.\\n\\no If the geometry is a valid MultiPolygon in a Cartesian"
  " SRS, the\\n  result is the sum of the Cartesian area of the polygons.\\n\\no If the geometry is a valid Polygon in a ge"
  "ographic SRS, the result is\\n  the geodetic area of the polygon in that SRS, in square meters.\\n\\no If the geometry i"
  "s a valid MultiPolygon in a geographic SRS, the\\n  result is the sum of geodetic area of the polygons in that SRS, in"
  "\\n  square meters.\\n\\no If an area computation results in +inf, an ER_DATA_OUT_OF_RANGE\\n  (https://dev.mysql.com/doc"
  "/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_data_out_of_range) error occurs.\\n\\no If the geometry h"
  "as a geographic SRS with a longitude or latitude\\n  that is out of range, an error occurs:\\n\\n  o If a longitude valu"
  "e is not in the range (−180, 180], an\\n    ER_GEOMETRY_PARAM_LONGITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc"
  "/mysql-errors/8.4/en/server-error-referen\\n    ce.html#error_er_geometry_param_longitude_out_of_range) error\\n    occ"
  "urs.\\n\\n  o If a latitude value is not in the range [−90, 90], an\\n    ER_GEOMETRY_PARAM_LATITUDE_OUT_OF_RANGE\\n   "
  " (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.html#error_er_geometry_param_latitude_ou"
  "t_of_range) error\\n    occurs.\\n\\n  Ranges shown are in degrees. The exact range limits deviate slightly\\n  due to fl"
  "oating-point arithmetic.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.html\\n\\n','my"
  "sql> SET @poly =\\n       \\'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\\';\\nmysql> SELECT ST_Area(ST_GeomFromText(@po"
  "ly));\\n+---------------------------------+\\n| ST_Area(ST_GeomFromText(@poly)) |\\n+---------------------------------+\\"
  "n|                               4 |\\n+---------------------------------+\\n\\nmysql> SET @mpoly =\\n       \\'MultiPolyg"
  "on(((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1)))\\';\\nmysql> SELECT ST_Area(ST_GeomFromText(@mpoly));\\n+-------------"
  "---------------------+\\n| ST_Area(ST_GeomFromText(@mpoly)) |\\n+----------------------------------+\\n|                "
  "                8 |\\n+----------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-pro"
  "perty-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (332,29,'ST_CENTROID','ST_Ce"
  "ntroid({poly|mpoly})\\n\\nReturns the mathematical centroid for the Polygon or MultiPolygon\\nargument as a Point. The r"
  "esult is not guaranteed to be on the\\nMultiPolygon.\\n\\nThis function processes geometry collections by computing the "
  "centroid\\npoint for components of highest dimension in the collection. Such\\ncomponents are extracted and made into a"
  " single MultiPolygon,\\nMultiLineString, or MultiPoint for centroid computation.\\n\\nST_Centroid() handles its argument"
  "s as described in the introduction to\\nthis section, with these exceptions:\\n\\no The return value is NULL for the add"
  "itional condition that the\\n  argument is an empty geometry collection.\\n\\no If the geometry has an SRID value for a "
  "geographic spatial reference\\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n  (https://dev.mysql.com/doc/"
  "mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_not_implemented_for_geographic_srs) error occurs.\\n\\nURL"
  ": https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.html\\n\\n','mysql> SET @poly =\\n       ST_Geo"
  "mFromText(\\'POLYGON((0 0,10 0,10 10,0 10,0 0),(5 5,7 5,7 7,5 7,5 5))\\');\\nmysql> SELECT ST_GeometryType(@poly),ST_AsT"
  "ext(ST_Centroid(@poly));\\n+------------------------+--------------------------------------------+\\n| ST_GeometryType("
  "@poly) | ST_AsText(ST_Centroid(@poly))              |\\n+------------------------+------------------------------------"
  "--------+\\n| POLYGON                | POINT(4.958333333333333 4.958333333333333) |\\n+------------------------+-------"
  "-------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.htm"
  "l');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (333,29,'ST_EXTERIORRING','S"
  "T_ExteriorRing(poly)\\n\\nReturns the exterior ring of the Polygon value poly as a LineString.\\n\\nST_ExteriorRing() han"
  "dles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/gis-polygon-property-functions.html\\n\\n','mysql> SET @poly =\\n       \\'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 "
  "1,1 1))\\';\\nmysql> SELECT ST_AsText(ST_ExteriorRing(ST_GeomFromText(@poly)));\\n+-------------------------------------"
  "---------------+\\n| ST_AsText(ST_ExteriorRing(ST_GeomFromText(@poly))) |\\n+------------------------------------------"
  "----------+\\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)                    |\\n+-----------------------------------------------"
  "-----+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (334,29,'ST_INTERIORRINGN','"
  "ST_InteriorRingN(poly, N)\\n\\nReturns the N-th interior ring for the Polygon value poly as a\\nLineString. Rings are nu"
  "mbered beginning with 1.\\n\\nST_InteriorRingN() handles its arguments as described in the\\nintroduction to this sectio"
  "n.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.html\\n\\n','mysql> SET @poly =\\n    "
  "   \\'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\\';\\nmysql> SELECT ST_AsText(ST_InteriorRingN(ST_GeomFromTex"
  "t(@poly),1));\\n+-------------------------------------------------------+\\n| ST_AsText(ST_InteriorRingN(ST_GeomFromTex"
  "t(@poly),1)) |\\n+-------------------------------------------------------+\\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)         "
  "              |\\n+-------------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/e"
  "n/gis-polygon-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (335,29,'ST_NUMINTERIORRINGS"
  "','ST_NumInteriorRing(poly), ST_NumInteriorRings(poly)\\n\\nReturns the number of interior rings in the Polygon value p"
  "oly.\\n\\nST_NumInteriorRing() and ST_NuminteriorRings() handle their arguments\\nas described in the introduction to th"
  "is section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.html\\n\\n','mysql> SET @pol"
  "y =\\n       \\'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\\';\\nmysql> SELECT ST_NumInteriorRings(ST_GeomFromT"
  "ext(@poly));\\n+---------------------------------------------+\\n| ST_NumInteriorRings(ST_GeomFromText(@poly)) |\\n+----"
  "-----------------------------------------+\\n|                                           1 |\\n+-----------------------"
  "----------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-polygon-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (336,30,'ST_GEOMETRYN','ST_G"
  "eometryN(gc, N)\\n\\nReturns the N-th geometry in the GeometryCollection value gc.\\nGeometries are numbered beginning w"
  "ith 1.\\n\\nST_GeometryN() handles its arguments as described in the introduction\\nto this section.\\n\\nURL: https://dev"
  ".mysql.com/doc/refman/8.4/en/gis-geometrycollection-property-functions.html\\n\\n','mysql> SET @gc = \\'GeometryCollecti"
  "on(Point(1 1),LineString(2 2, 3 3))\\';\\nmysql> SELECT ST_AsText(ST_GeometryN(ST_GeomFromText(@gc),1));\\n+------------"
  "-------------------------------------+\\n| ST_AsText(ST_GeometryN(ST_GeomFromText(@gc),1)) |\\n+-----------------------"
  "--------------------------+\\n| POINT(1 1)                                      |\\n+----------------------------------"
  "---------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-geometrycollection-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (337,30,'ST_NUMGEOMETRIES','"
  "ST_NumGeometries(gc)\\n\\nReturns the number of geometries in the GeometryCollection value gc.\\n\\nST_NumGeometries() ha"
  "ndles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/e"
  "n/gis-geometrycollection-property-functions.html\\n\\n','mysql> SET @gc = \\'GeometryCollection(Point(1 1),LineString(2 "
  "2, 3 3))\\';\\nmysql> SELECT ST_NumGeometries(ST_GeomFromText(@gc));\\n+----------------------------------------+\\n| ST_"
  "NumGeometries(ST_GeomFromText(@gc)) |\\n+----------------------------------------+\\n|                                 "
  "     2 |\\n+----------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/gis-geometrycollecti"
  "on-property-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (338,30,'ST_BUFFER','ST_Buff"
  "er(g, d [, strategy1 [, strategy2 [, strategy3]]])\\n\\nReturns a geometry that represents all points whose distance fr"
  "om the\\ngeometry value g is less than or equal to a distance of d. The result\\nis in the same SRS as the geometry arg"
  "ument.\\n\\nIf the geometry argument is empty, ST_Buffer() returns an empty\\ngeometry.\\n\\nIf the distance is 0, ST_Buff"
  "er() returns the geometry argument\\nunchanged:\\n\\nmysql> SET @pt = ST_GeomFromText(\\'POINT(0 0)\\');\\nmysql> SELECT ST"
  "_AsText(ST_Buffer(@pt, 0));\\n+------------------------------+\\n| ST_AsText(ST_Buffer(@pt, 0)) |\\n+-------------------"
  "-----------+\\n| POINT(0 0)                   |\\n+------------------------------+\\n\\nIf the geometry argument is in a "
  "Cartesian SRS:\\n\\no ST_Buffer() supports negative distances for Polygon and MultiPolygon\\n  values, and for geometry "
  "collections containing Polygon or\\n  MultiPolygon values.\\n\\no If the result is reduced so much that it disappears, t"
  "he result is an\\n  empty geometry.\\n\\no An ER_WRONG_ARGUMENTS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/serve"
  "r-error-reference\\n  .html#error_er_wrong_arguments) error occurs for ST_Buffer() with a\\n  negative distance for Poi"
  "nt, MultiPoint, LineString, and\\n  MultiLineString values, and for geometry collections not containing\\n  any Polygon"
  " or MultiPolygon values.\\n\\nPoint geometries in a geographic SRS are permitted, subject to the\\nfollowing conditions:"
  "\\n\\no If the distance is not negative and no strategies are specified, the\\n  function returns the geographic buffer "
  "of the Point in its SRS. The\\n  distance argument must be in the SRS distance unit (currently always\\n  meters).\\n\\no"
  " If the distance is negative or any strategy (except NULL) is\\n  specified, an ER_WRONG_ARGUMENTS\\n  (https://dev.mys"
  "ql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_wrong_arguments) error occurs.\\n\\nFor non-Poi"
  "nt geometries, an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-"
  "reference.html\\n#error_er_not_implemented_for_geographic_srs) error occurs.\\n\\nST_Buffer() permits up to three option"
  "al strategy arguments following\\nthe distance argument. Strategies influence buffer computation. These\\narguments are"
  " byte string values produced by the ST_Buffer_Strategy()\\nfunction, to be used for point, join, and end strategies:\\n"
  "\\no Point strategies apply to Point and MultiPoint geometries. If no\\n  point strategy is specified, the default is\\n"
  "  ST_Buffer_Strategy(\\'point_circle\\', 32).\\n\\no Join strategies apply to LineString, MultiLineString, Polygon, and\\n"
  "  MultiPolygon geometries. If no join strategy is specified, the\\n  default is ST_Buffer_Strategy(\\'join_round\\', 32)"
  ".\\n\\no End strategies apply to LineString and MultiLineString geometries. If\\n  no end strategy is specified, the def"
  "ault is\\n  ST_Buffer_Strategy(\\'end_round\\', 32).\\n\\nUp to one strategy of each type may be specified, and they may b"
  "e given\\nin any order.\\n\\nIf the buffer strategies are invalid, an ER_WRONG_ARGUMENTS\\n(https://dev.mysql.com/doc/mys"
  "ql-errors/8.4/en/server-error-reference.html\\n#error_er_wrong_arguments) error occurs. Strategies are invalid\\nunder "
  "any of these circumstances:\\n\\no Multiple strategies of a given type (point, join, or end) are\\n  specified.\\n\\no A v"
  "alue that is not a strategy (such as an arbitrary binary string or\\n  a number) is passed as a strategy.\\n\\no A Point"
  " strategy is passed and the geometry contains no Point or\\n  MultiPoint values.\\n\\no An end or join strategy is passe"
  "d and the geometry contains no\\n  LineString, Polygon, MultiLinestring or MultiPolygon values.\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/spatial-operator-functions.html\\n\\n','mysql> SET @pt = ST_GeomFromText(\\'POINT(0 0)\\');\\nmy"
  "sql> SET @pt_strategy = ST_Buffer_Strategy(\\'point_square\\');\\nmysql> SELECT ST_AsText(ST_Buffer(@pt, 2, @pt_strategy"
  "));\\n+--------------------------------------------+\\n| ST_AsText(ST_Buffer(@pt, 2, @pt_strategy)) |\\n+---------------"
  "-----------------------------+\\n| POLYGON((-2 -2,2 -2,2 2,-2 2,-2 -2))       |\\n+------------------------------------"
  "--------+\\n\\nmysql> SET @ls = ST_GeomFromText(\\'LINESTRING(0 0,0 5,5 5)\\');\\nmysql> SET @end_strategy = ST_Buffer_Str"
  "ategy(\\'end_flat\\');\\nmysql> SET @join_strategy = ST_Buffer_Strategy(\\'join_round\\', 10);\\nmysql> SELECT ST_AsText(ST"
  "_Buffer(@ls, 5, @end_strategy, @join_strategy))\\n+---------------------------------------------------------------+\\n|"
  " ST_AsText(ST_Buffer(@ls, 5, @end_strategy, @join_strategy))   |\\n+--------------------------------------------------"
  "-------------+\\n| POLYGON((5 5,5 10,0 10,-3.5355339059327373 8.535533905932738, |\\n| -5 5,-5 0,0 0,5 0,5 5))         "
  "                              |\\n+---------------------------------------------------------------+\\n','https://dev.my"
  "sql.com/doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (339,30,'ST_BUFFER_STRATEGY'"
  ",'ST_Buffer_Strategy(strategy [, points_per_circle])\\n\\nThis function returns a strategy byte string for use with ST_"
  "Buffer()\\nto influence buffer computation.\\n\\nInformation about strategies is available at Boost.org\\n(http://www.boo"
  "st.org).\\n\\nThe first argument must be a string indicating a strategy option:\\n\\no For point strategies, permitted va"
  "lues are \\'point_circle\\' and\\n  \\'point_square\\'.\\n\\no For join strategies, permitted values are \\'join_round\\' and\\"
  "n  \\'join_miter\\'.\\n\\no For end strategies, permitted values are \\'end_round\\' and \\'end_flat\\'.\\n\\nIf the first argu"
  "ment is \\'point_circle\\', \\'join_round\\', \\'join_miter\\', or\\n\\'end_round\\', the points_per_circle argument must be g"
  "iven as a positive\\nnumeric value. The maximum points_per_circle value is the value of the\\nmax_points_in_geometry sy"
  "stem variable.\\n\\nFor examples, see the description of ST_Buffer().\\n\\nST_Buffer_Strategy() handles its arguments as "
  "described in the\\nintroduction to this section, with these exceptions:\\n\\no If any argument is invalid, an ER_WRONG_A"
  "RGUMENTS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_wrong_arguments) "
  "error occurs.\\n\\no If the first argument is \\'point_square\\' or \\'end_flat\\', the\\n  points_per_circle argument must "
  "not be given or an ER_WRONG_ARGUMENTS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .ht"
  "ml#error_er_wrong_arguments) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions"
  ".html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (340,30,'ST_CONVEXHULL','ST_"
  "ConvexHull(g)\\n\\nReturns a geometry that represents the convex hull of the geometry\\nvalue g.\\n\\nThis function comput"
  "es a geometry\\'s convex hull by first checking\\nwhether its vertex points are colinear. The function returns a linear"
  "\\nhull if so, a polygon hull otherwise. This function processes geometry\\ncollections by extracting all vertex points"
  " of all components of the\\ncollection, creating a MultiPoint value from them, and computing its\\nconvex hull.\\n\\nST_C"
  "onvexHull() handles its arguments as described in the introduction\\nto this section, with this exception:\\n\\no The re"
  "turn value is NULL for the additional condition that the\\n  argument is an empty geometry collection.\\n\\nURL: https:/"
  "/dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html\\n\\n','mysql> SET @g = \\'MULTIPOINT(5 0,25 0,15 10,15"
  " 25)\\';\\nmysql> SELECT ST_AsText(ST_ConvexHull(ST_GeomFromText(@g)));\\n+---------------------------------------------"
  "--+\\n| ST_AsText(ST_ConvexHull(ST_GeomFromText(@g))) |\\n+-----------------------------------------------+\\n| POLYGON("
  "(5 0,25 0,15 25,5 0))                 |\\n+-----------------------------------------------+\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (341,30,'ST_DIFFERENCE','ST_"
  "Difference(g1, g2)\\n\\nReturns a geometry that represents the point set difference of the\\ngeometry values g1 and g2. "
  "The result is in the same SRS as the\\ngeometry arguments.\\n\\nST_Difference() permits arguments in either a Cartesian "
  "or a geographic\\nSRS, and handles its arguments as described in the introduction to this\\nsection.\\n\\nURL: https://de"
  "v.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html\\n\\n','mysql> SET @g1 = Point(1,1), @g2 = Point(2,2);\\nm"
  "ysql> SELECT ST_AsText(ST_Difference(@g1, @g2));\\n+------------------------------------+\\n| ST_AsText(ST_Difference(@"
  "g1, @g2)) |\\n+------------------------------------+\\n| POINT(1 1)                         |\\n+-----------------------"
  "-------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (342,30,'ST_INTERSECTION','S"
  "T_Intersection(g1, g2)\\n\\nReturns a geometry that represents the point set intersection of the\\ngeometry values g1 an"
  "d g2. The result is in the same SRS as the\\ngeometry arguments.\\n\\nST_Intersection() permits arguments in either a Ca"
  "rtesian or a\\ngeographic SRS, and handles its arguments as described in the\\nintroduction to this section.\\n\\nURL: ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'LineSt"
  "ring(1 1, 3 3)\\');\\nmysql> SET @g2 = ST_GeomFromText(\\'LineString(1 3, 3 1)\\');\\nmysql> SELECT ST_AsText(ST_Intersect"
  "ion(@g1, @g2));\\n+--------------------------------------+\\n| ST_AsText(ST_Intersection(@g1, @g2)) |\\n+---------------"
  "-----------------------+\\n| POINT(2 2)                           |\\n+--------------------------------------+\\n','http"
  "s://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (343,30,'ST_LINEINTERPOLATEP"
  "OINT','ST_LineInterpolatePoint(ls, fractional_distance)\\n\\nThis function takes a LineString geometry and a fractional"
  " distance in\\nthe range [0.0, 1.0] and returns the Point along the LineString at the\\ngiven fraction of the distance "
  "from its start point to its endpoint. It\\ncan be used to answer questions such as which Point lies halfway along\\nthe"
  " road described by the geometry argument.\\n\\nThe function is implemented for LineString geometries in all spatial\\nre"
  "ference systems, both Cartesian and geographic.\\n\\nIf the fractional_distance argument is 1.0, the result may not be\\"
  "nexactly the last point of the LineString argument but a point close to\\nit due to numerical inaccuracies in approxim"
  "ate-value computations.\\n\\nA related function, ST_LineInterpolatePoints(), takes similar arguments\\nbut returns a Mul"
  "tiPoint consisting of Point values along the\\nLineString at each fraction of the distance from its start point to its"
  "\\nendpoint. For examples of both functions, see the\\nST_LineInterpolatePoints() description.\\n\\nST_LineInterpolatePoi"
  "nt() handles its arguments as described in the\\nintroduction to this section, with these exceptions:\\n\\no If the geom"
  "etry argument is not a LineString, an\\n  ER_UNEXPECTED_GEOMETRY_TYPE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/e"
  "n/server-error-reference\\n  .html#error_er_unexpected_geometry_type) error occurs.\\n\\no If the fractional distance ar"
  "gument is outside the range [0.0, 1.0],\\n  an ER_DATA_OUT_OF_RANGE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/"
  "server-error-reference\\n  .html#error_er_data_out_of_range) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/spatial-operator-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html"
  "');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (344,30,'ST_LINEINTERPOLATEP"
  "OINTS','ST_LineInterpolatePoints(ls, fractional_distance)\\n\\nThis function takes a LineString geometry and a fraction"
  "al distance in\\nthe range (0.0, 1.0] and returns the MultiPoint consisting of the\\nLineString start point, plus Point"
  " values along the LineString at each\\nfraction of the distance from its start point to its endpoint. It can\\nbe used "
  "to answer questions such as which Point values lie every 10% of\\nthe way along the road described by the geometry arg"
  "ument.\\n\\nThe function is implemented for LineString geometries in all spatial\\nreference systems, both Cartesian and"
  " geographic.\\n\\nIf the fractional_distance argument divides 1.0 with zero remainder the\\nresult may not contain the l"
  "ast point of the LineString argument but a\\npoint close to it due to numerical inaccuracies in approximate-value\\ncom"
  "putations.\\n\\nA related function, ST_LineInterpolatePoint(), takes similar arguments\\nbut returns the Point along the"
  " LineString at the given fraction of the\\ndistance from its start point to its endpoint.\\n\\nST_LineInterpolatePoints("
  ") handles its arguments as described in the\\nintroduction to this section, with these exceptions:\\n\\no If the geometr"
  "y argument is not a LineString, an\\n  ER_UNEXPECTED_GEOMETRY_TYPE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/s"
  "erver-error-reference\\n  .html#error_er_unexpected_geometry_type) error occurs.\\n\\no If the fractional distance argum"
  "ent is outside the range [0.0, 1.0],\\n  an ER_DATA_OUT_OF_RANGE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/ser"
  "ver-error-reference\\n  .html#error_er_data_out_of_range) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/e"
  "n/spatial-operator-functions.html\\n\\n','mysql> SET @ls1 = ST_GeomFromText(\\'LINESTRING(0 0,0 5,5 5)\\');\\nmysql> SELEC"
  "T ST_AsText(ST_LineInterpolatePoint(@ls1, .5));\\n+----------------------------------------------+\\n| ST_AsText(ST_Lin"
  "eInterpolatePoint(@ls1, .5)) |\\n+----------------------------------------------+\\n| POINT(0 5)                       "
  "            |\\n+----------------------------------------------+\\nmysql> SELECT ST_AsText(ST_LineInterpolatePoint(@ls1"
  ", .75));\\n+-----------------------------------------------+\\n| ST_AsText(ST_LineInterpolatePoint(@ls1, .75)) |\\n+----"
  "-------------------------------------------+\\n| POINT(2.5 5)                                  |\\n+-------------------"
  "----------------------------+\\nmysql> SELECT ST_AsText(ST_LineInterpolatePoint(@ls1, 1));\\n+-------------------------"
  "--------------------+\\n| ST_AsText(ST_LineInterpolatePoint(@ls1, 1)) |\\n+--------------------------------------------"
  "-+\\n| POINT(5 5)                                  |\\n+---------------------------------------------+\\nmysql> SELECT S"
  "T_AsText(ST_LineInterpolatePoints(@ls1, .25));\\n+------------------------------------------------+\\n| ST_AsText(ST_Li"
  "neInterpolatePoints(@ls1, .25)) |\\n+------------------------------------------------+\\n| MULTIPOINT((0 2.5),(0 5),(2."
  "5 5),(5 5))        |\\n+------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/"
  "spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (345,30,'ST_POINTATDISTANCE'"
  ",'ST_PointAtDistance(ls, distance)\\n\\nThis function takes a LineString geometry and a distance in the range\\n[0.0, ST"
  "_Length(ls)] measured in the unit of the spatial reference\\nsystem (SRS) of the LineString, and returns the Point alo"
  "ng the\\nLineString at that distance from its start point. It can be used to\\nanswer questions such as which Point val"
  "ue is 400 meters from the start\\nof the road described by the geometry argument.\\n\\nThe function is implemented for L"
  "ineString geometries in all spatial\\nreference systems, both Cartesian and geographic.\\n\\nST_PointAtDistance() handle"
  "s its arguments as described in the\\nintroduction to this section, with these exceptions:\\n\\no If the geometry argume"
  "nt is not a LineString, an\\n  ER_UNEXPECTED_GEOMETRY_TYPE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-er"
  "ror-reference\\n  .html#error_er_unexpected_geometry_type) error occurs.\\n\\no If the fractional distance argument is o"
  "utside the range [0.0,\\n  ST_Length(ls)], an ER_DATA_OUT_OF_RANGE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/s"
  "erver-error-reference\\n  .html#error_er_data_out_of_range) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4"
  "/en/spatial-operator-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (346,30,'ST_SYMDIFFERENCE','"
  "ST_SymDifference(g1, g2)\\n\\nReturns a geometry that represents the point set symmetric difference\\nof the geometry va"
  "lues g1 and g2, which is defined as:\\n\\ng1 symdifference g2 := (g1 union g2) difference (g1 intersection g2)\\n\\nOr, i"
  "n function call notation:\\n\\nST_SymDifference(g1, g2) = ST_Difference(ST_Union(g1, g2), ST_Intersection(g1, g2))\\n\\nT"
  "he result is in the same SRS as the geometry arguments.\\n\\nST_SymDifference() permits arguments in either a Cartesian"
  " or a\\ngeographic SRS, and handles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'MULTIPOINT(5 "
  "0,15 10,15 25)\\');\\nmysql> SET @g2 = ST_GeomFromText(\\'MULTIPOINT(1 1,15 10,15 25)\\');\\nmysql> SELECT ST_AsText(ST_Sy"
  "mDifference(@g1, @g2));\\n+---------------------------------------+\\n| ST_AsText(ST_SymDifference(@g1, @g2)) |\\n+-----"
  "----------------------------------+\\n| MULTIPOINT((1 1),(5 0))               |\\n+------------------------------------"
  "---+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (347,30,'ST_TRANSFORM','ST_T"
  "ransform(g, target_srid)\\n\\nTransforms a geometry from one spatial reference system (SRS) to\\nanother. The return val"
  "ue is a geometry of the same type as the input\\ngeometry with all coordinates transformed to the target SRID,\\ntarget"
  "_srid. MySQL supports all SRSs defined by EPSG except for those\\nlisted here:\\n\\no EPSG 1042 Krovak Modified\\n\\no EPS"
  "G 1043 Krovak Modified (North Orientated)\\n\\no EPSG 9816 Tunisia Mining Grid\\n\\no EPSG 9826 Lambert Conic Conformal ("
  "West Orientated)\\n\\nST_Transform() handles its arguments as described in the introduction\\nto this section, with thes"
  "e exceptions:\\n\\no Geometry arguments that have an SRID value for a geographic SRS do\\n  not produce an error.\\n\\no I"
  "f the geometry or target SRID argument has an SRID value that refers\\n  to an undefined spatial reference system (SRS"
  "), an ER_SRS_NOT_FOUND\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_srs"
  "_not_found) error occurs.\\n\\no If the geometry is in an SRS that ST_Transform() cannot transform\\n  from, an ER_TRANS"
  "FORM_SOURCE_SRS_NOT_SUPPORTED\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error"
  "_er_transform_source_srs_not_supported) error occurs.\\n\\no If the target SRID is in an SRS that ST_Transform() cannot"
  " transform\\n  to, an ER_TRANSFORM_TARGET_SRS_NOT_SUPPORTED\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-e"
  "rror-reference\\n  .html#error_er_transform_target_srs_not_supported) error occurs.\\n\\no If the geometry is in an SRS "
  "that is not WGS 84 and has no TOWGS84\\n  clause, an ER_TRANSFORM_SOURCE_SRS_MISSING_TOWGS84\\n  (https://dev.mysql.com"
  "/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_transform_source_srs_missing_towgs84) error occurs."
  "\\n\\no If the target SRID is in an SRS that is not WGS 84 and has no TOWGS84\\n  clause, an ER_TRANSFORM_TARGET_SRS_MIS"
  "SING_TOWGS84\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_transform_tar"
  "get_srs_missing_towgs84) error occurs.\\n\\nST_SRID(g, target_srid) and ST_Transform(g, target_srid) differ as\\nfollows"
  ":\\n\\no ST_SRID() changes the geometry SRID value without transforming its\\n  coordinates.\\n\\no ST_Transform() transfo"
  "rms the geometry coordinates in addition to\\n  changing its SRID value.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/"
  "en/spatial-operator-functions.html\\n\\n','mysql> SET @p = ST_GeomFromText(\\'POINT(52.381389 13.064444)\\', 4326);\\nmysq"
  "l> SELECT ST_AsText(@p);\\n+----------------------------+\\n| ST_AsText(@p)              |\\n+--------------------------"
  "--+\\n| POINT(52.381389 13.064444) |\\n+----------------------------+\\nmysql> SET @p = ST_Transform(@p, 4230);\\nmysql> "
  "SELECT ST_AsText(@p);\\n+---------------------------------------------+\\n| ST_AsText(@p)                              "
  " |\\n+---------------------------------------------+\\n| POINT(52.38208611407426 13.065520672345304) |\\n+--------------"
  "-------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (348,30,'ST_UNION','ST_Union"
  "(g1, g2)\\n\\nReturns a geometry that represents the point set union of the geometry\\nvalues g1 and g2. The result is i"
  "n the same SRS as the geometry\\narguments.\\n\\nST_Union() permits arguments in either a Cartesian or a geographic SRS,"
  "\\nand handles its arguments as described in the introduction to this\\nsection.\\n\\nURL: https://dev.mysql.com/doc/refm"
  "an/8.4/en/spatial-operator-functions.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'LineString(1 1, 3 3)\\');\\nmysql> S"
  "ET @g2 = ST_GeomFromText(\\'LineString(1 3, 3 1)\\');\\nmysql> SELECT ST_AsText(ST_Union(@g1, @g2));\\n+-----------------"
  "---------------------+\\n| ST_AsText(ST_Union(@g1, @g2))        |\\n+--------------------------------------+\\n| MULTILI"
  "NESTRING((1 1,3 3),(1 3,3 1)) |\\n+--------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en"
  "/spatial-operator-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (349,31,'ST_CONTAINS','ST_Co"
  "ntains(g1, g2)\\n\\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\\ntests the opposite relationship"
  " as ST_Within().\\n\\nST_Contains() handles its arguments as described in the introduction to\\nthis section.\\n\\nURL: ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','','https://dev.mysql.com/do"
  "c/refman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (350,31,'ST_CROSSES','ST_Cro"
  "sses(g1, g2)\\n\\nTwo geometries spatially cross if their spatial relation has the\\nfollowing properties:\\n\\no Unless g"
  "1 and g2 are both of dimension 1: g1 crosses g2 if the\\n  interior of g2 has points in common with the interior of g1"
  ", but g2\\n  does not cover the entire interior of g1.\\n\\no If both g1 and g2 are of dimension 1: If the lines cross e"
  "ach other\\n  in a finite number of points (that is, no common line segments, only\\n  single points in common).\\n\\nThi"
  "s function returns 1 or 0 to indicate whether g1 spatially crosses\\ng2.\\n\\nST_Crosses() handles its arguments as desc"
  "ribed in the introduction to\\nthis section except that the return value is NULL for these additional\\nconditions:\\n\\n"
  "o g1 is of dimension 2 (Polygon or MultiPolygon).\\n\\no g2 is of dimension 1 (Point or MultiPoint).\\n\\nURL: https://de"
  "v.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','','https://dev.mysql.com/doc/refman"
  "/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (351,31,'ST_DISJOINT','ST_Di"
  "sjoint(g1, g2)\\n\\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\\nnot intersect) g2.\\n\\nST_Di"
  "sjoint() handles its arguments as described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/r"
  "efman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-r"
  "elation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (352,31,'ST_DISTANCE','ST_Di"
  "stance(g1, g2 [, unit])\\n\\nReturns the distance between g1 and g2, measured in the length unit of\\nthe spatial refere"
  "nce system (SRS) of the geometry arguments, or in the\\nunit of the optional unit argument if that is specified.\\n\\nTh"
  "is function processes geometry collections by returning the shortest\\ndistance among all combinations of the componen"
  "ts of the two geometry\\narguments.\\n\\nST_Distance() handles its geometry arguments as described in the\\nintroduction "
  "to this section, with these exceptions:\\n\\no ST_Distance() detects arguments in a geographic (ellipsoidal) spatial\\n "
  " reference system and returns the geodetic distance on the ellipsoid.\\n  ST_Distance() supports distance calculations"
  " for geographic SRS\\n  arguments of all geometry types.\\n\\no If any argument is geometrically invalid, either the res"
  "ult is an\\n  undefined distance (that is, it can be any number), or an error\\n  occurs.\\n\\no If an intermediate or fi"
  "nal result produces NaN or a negative number,\\n  an ER_GIS_INVALID_DATA\\n  (https://dev.mysql.com/doc/mysql-errors/8."
  "4/en/server-error-reference\\n  .html#error_er_gis_invalid_data) error occurs.\\n\\nST_Distance() permits specifying the"
  " linear unit for the returned\\ndistance value with an optional unit argument which ST_Distance()\\nhandles as describe"
  "d in the introduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-obj"
  "ect-shapes.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'POINT(1 1)\\');\\nmysql> SET @g2 = ST_GeomFromText(\\'POINT(2 2"
  ")\\');\\nmysql> SELECT ST_Distance(@g1, @g2);\\n+-----------------------+\\n| ST_Distance(@g1, @g2) |\\n+-----------------"
  "------+\\n|    1.4142135623730951 |\\n+-----------------------+\\n\\nmysql> SET @g1 = ST_GeomFromText(\\'POINT(1 1)\\', 432"
  "6);\\nmysql> SET @g2 = ST_GeomFromText(\\'POINT(2 2)\\', 4326);\\nmysql> SELECT ST_Distance(@g1, @g2);\\n+----------------"
  "-------+\\n| ST_Distance(@g1, @g2) |\\n+-----------------------+\\n|     156874.3859490455 |\\n+-----------------------+\\"
  "nmysql> SELECT ST_Distance(@g1, @g2, \\'metre\\');\\n+--------------------------------+\\n| ST_Distance(@g1, @g2, \\'metre"
  "\\') |\\n+--------------------------------+\\n|              156874.3859490455 |\\n+--------------------------------+\\nmy"
  "sql> SELECT ST_Distance(@g1, @g2, \\'foot\\');\\n+-------------------------------+\\n| ST_Distance(@g1, @g2, \\'foot\\') |\\"
  "n+-------------------------------+\\n|             514679.7439273146 |\\n+-------------------------------+\\n','https://"
  "dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (353,31,'ST_EQUALS','ST_Equa"
  "ls(g1, g2)\\n\\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\\n\\nST_Equals() handles its arguments as"
  " described in the introduction to\\nthis section, except that it does not return NULL for empty geometry\\narguments.\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','mysql> SET @g1 = P"
  "oint(1,1), @g2 = Point(2,2);\\nmysql> SELECT ST_Equals(@g1, @g1), ST_Equals(@g1, @g2);\\n+---------------------+-------"
  "--------------+\\n| ST_Equals(@g1, @g1) | ST_Equals(@g1, @g2) |\\n+---------------------+---------------------+\\n|     "
  "              1 |                   0 |\\n+---------------------+---------------------+\\n','https://dev.mysql.com/doc/"
  "refman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (354,31,'ST_FRECHETDISTANCE'"
  ",'ST_FrechetDistance(g1, g2 [, unit])\\n\\nReturns the discrete Fréchet distance between two geometries,\\nreflecting h"
  "ow similar the geometries are. The result is a\\ndouble-precision number measured in the length unit of the spatial\\nr"
  "eference system (SRS) of the geometry arguments, or in the length unit\\nof the unit argument if that argument is give"
  "n.\\n\\nThis function implements the discrete Fréchet distance, which means it\\nis restricted to distances between the"
  " points of the geometries. For\\nexample, given two LineString arguments, only the points explicitly\\nmentioned in the"
  " geometries are considered. Points on the line segments\\nbetween these points are not considered.\\n\\nST_FrechetDistan"
  "ce() handles its geometry arguments as described in the\\nintroduction to this section, with these exceptions:\\n\\no Th"
  "e geometries may have a Cartesian or geographic SRS, but only\\n  LineString values are supported. If the arguments ar"
  "e in the same\\n  Cartesian or geographic SRS, but either is not a LineString, an\\n  ER_NOT_IMPLEMENTED_FOR_CARTESIAN_"
  "SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_not_implemented_for_ca"
  "rtesian_srs) or\\n  ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-err"
  "or-reference\\n  .html#error_er_not_implemented_for_geographic_srs) error occurs,\\n  depending on the SRS type.\\n\\nST_"
  "FrechetDistance() handles its optional unit argument as described in\\nthe introduction to this section.\\n\\nURL: https"
  "://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','mysql> SET @ls1 = ST_GeomFromT"
  "ext(\\'LINESTRING(0 0,0 5,5 5)\\');\\nmysql> SET @ls2 = ST_GeomFromText(\\'LINESTRING(0 1,0 6,3 3,5 6)\\');\\nmysql> SELECT"
  " ST_FrechetDistance(@ls1, @ls2);\\n+--------------------------------+\\n| ST_FrechetDistance(@ls1, @ls2) |\\n+----------"
  "----------------------+\\n|             2.8284271247461903 |\\n+--------------------------------+\\n\\nmysql> SET @ls1 = "
  "ST_GeomFromText(\\'LINESTRING(0 0,0 5,5 5)\\', 4326);\\nmysql> SET @ls2 = ST_GeomFromText(\\'LINESTRING(0 1,0 6,3 3,5 6)\\"
  "', 4326);\\nmysql> SELECT ST_FrechetDistance(@ls1, @ls2);\\n+--------------------------------+\\n| ST_FrechetDistance(@l"
  "s1, @ls2) |\\n+--------------------------------+\\n|              313421.1999416798 |\\n+-------------------------------"
  "-+\\nmysql> SELECT ST_FrechetDistance(@ls1, @ls2, \\'foot\\');\\n+----------------------------------------+\\n| ST_Frechet"
  "Distance(@ls1, @ls2, \\'foot\\') |\\n+----------------------------------------+\\n|                     1028284.776711547"
  "7 |\\n+----------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-function"
  "s-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (355,31,'ST_HAUSDORFFDISTANC"
  "E','ST_HausdorffDistance(g1, g2 [, unit])\\n\\nReturns the discrete Hausdorff distance between two geometries,\\nreflect"
  "ing how similar the geometries are. The result is a\\ndouble-precision number measured in the length unit of the spati"
  "al\\nreference system (SRS) of the geometry arguments, or in the length unit\\nof the unit argument if that argument is"
  " given.\\n\\nThis function implements the discrete Hausdorff distance, which means\\nit is restricted to distances betwe"
  "en the points of the geometries. For\\nexample, given two LineString arguments, only the points explicitly\\nmentioned "
  "in the geometries are considered. Points on the line segments\\nbetween these points are not considered.\\n\\nST_Hausdor"
  "ffDistance() handles its geometry arguments as described in\\nthe introduction to this section, with these exceptions:"
  "\\n\\no If the geometry arguments are in the same Cartesian or geographic\\n  SRS, but are not in a supported combinatio"
  "n, an\\n  ER_NOT_IMPLEMENTED_FOR_CARTESIAN_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referenc"
  "e\\n  .html#error_er_not_implemented_for_cartesian_srs) or\\n  ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n  (https://dev.my"
  "sql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_not_implemented_for_geographic_srs) error oc"
  "curs,\\n  depending on the SRS type. These combinations are supported:\\n\\n  o LineString and LineString\\n\\n  o Point a"
  "nd MultiPoint\\n\\n  o LineString and MultiLineString\\n\\n  o MultiPoint and MultiPoint\\n\\n  o MultiLineString and Multi"
  "LineString\\n\\nST_HausdorffDistance() handles its optional unit argument as described\\nin the introduction to this sec"
  "tion.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','mysql> SET "
  "@ls1 = ST_GeomFromText(\\'LINESTRING(0 0,0 5,5 5)\\');\\nmysql> SET @ls2 = ST_GeomFromText(\\'LINESTRING(0 1,0 6,3 3,5 6)"
  "\\');\\nmysql> SELECT ST_HausdorffDistance(@ls1, @ls2);\\n+----------------------------------+\\n| ST_HausdorffDistance(@"
  "ls1, @ls2) |\\n+----------------------------------+\\n|                                1 |\\n+--------------------------"
  "--------+\\n\\nmysql> SET @ls1 = ST_GeomFromText(\\'LINESTRING(0 0,0 5,5 5)\\', 4326);\\nmysql> SET @ls2 = ST_GeomFromText"
  "(\\'LINESTRING(0 1,0 6,3 3,5 6)\\', 4326);\\nmysql> SELECT ST_HausdorffDistance(@ls1, @ls2);\\n+-------------------------"
  "---------+\\n| ST_HausdorffDistance(@ls1, @ls2) |\\n+----------------------------------+\\n|               111319.490793"
  "26246 |\\n+----------------------------------+\\nmysql> SELECT ST_HausdorffDistance(@ls1, @ls2, \\'foot\\');\\n+----------"
  "--------------------------------+\\n| ST_HausdorffDistance(@ls1, @ls2, \\'foot\\') |\\n+---------------------------------"
  "---------+\\n|                        365221.4264870815 |\\n+------------------------------------------+\\n','https://de"
  "v.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (356,31,'ST_INTERSECTS','ST_"
  "Intersects(g1, g2)\\n\\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\\n\\nST_Intersects() handles its a"
  "rguments as described in the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-r"
  "elation-functions-object-shapes.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-obje"
  "ct-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (357,31,'ST_OVERLAPS','ST_Ov"
  "erlaps(g1, g2)\\n\\nTwo geometries spatially overlap if they intersect and their\\nintersection results in a geometry of"
  " the same dimension but not equal\\nto either of the given geometries.\\n\\nThis function returns 1 or 0 to indicate whe"
  "ther g1 spatially overlaps\\ng2.\\n\\nST_Overlaps() handles its arguments as described in the introduction to\\nthis sect"
  "ion except that the return value is NULL for the additional\\ncondition that the dimensions of the two geometries are "
  "not equal.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (358,31,'ST_TOUCHES','ST_Tou"
  "ches(g1, g2)\\n\\nTwo geometries spatially touch if their interiors do not intersect, but\\nthe boundary of one of the g"
  "eometries intersects either the boundary or\\nthe interior of the other.\\n\\nThis function returns 1 or 0 to indicate w"
  "hether g1 spatially touches\\ng2.\\n\\nST_Touches() handles its arguments as described in the introduction to\\nthis sect"
  "ion except that the return value is NULL for the additional\\ncondition that both geometries are of dimension 0 (Point"
  " or\\nMultiPoint).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n',"
  "'','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (359,31,'ST_WITHIN','ST_With"
  "in(g1, g2)\\n\\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\\ntests the opposite relationship as "
  "ST_Contains().\\n\\nST_Within() handles its arguments as described in the introduction to\\nthis section.\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-object-shapes.html\\n\\n','','https://dev.mysql.com/doc/re"
  "fman/8.4/en/spatial-relation-functions-object-shapes.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (360,32,'MBRCONTAINS','MBRCo"
  "ntains(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\\ncontains the minimum bound"
  "ing rectangle of g2. This tests the opposite\\nrelationship as MBRWithin().\\n\\nMBRContains() handles its arguments as "
  "described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-func"
  "tions-mbr.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'Polygon((0 0,0 3,3 3,3 0,0 0))\\');\\nmysql> SET @g2 = ST_GeomF"
  "romText(\\'Point(1 1)\\');\\nmysql> SELECT MBRContains(@g1,@g2), MBRWithin(@g2,@g1);\\n+----------------------+----------"
  "----------+\\n| MBRContains(@g1,@g2) | MBRWithin(@g2,@g1) |\\n+----------------------+--------------------+\\n|         "
  "           1 |                  1 |\\n+----------------------+--------------------+\\n','https://dev.mysql.com/doc/refm"
  "an/8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (361,32,'MBRCOVEREDBY','MBRC"
  "overedBy(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\\nis covered by the minimu"
  "m bounding rectangle of g2. This tests the\\nopposite relationship as MBRCovers().\\n\\nMBRCoveredBy() handles its argum"
  "ents as described in the introduction\\nto this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relat"
  "ion-functions-mbr.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'Polygon((0 0,0 3,3 3,3 0,0 0))\\');\\nmysql> SET @g2 = "
  "ST_GeomFromText(\\'Point(1 1)\\');\\nmysql> SELECT MBRCovers(@g1,@g2), MBRCoveredby(@g1,@g2);\\n+--------------------+---"
  "--------------------+\\n| MBRCovers(@g1,@g2) | MBRCoveredby(@g1,@g2) |\\n+--------------------+-----------------------+"
  "\\n|                  1 |                     0 |\\n+--------------------+-----------------------+\\nmysql> SELECT MBRCo"
  "vers(@g2,@g1), MBRCoveredby(@g2,@g1);\\n+--------------------+-----------------------+\\n| MBRCovers(@g2,@g1) | MBRCove"
  "redby(@g2,@g1) |\\n+--------------------+-----------------------+\\n|                  0 |                     1 |\\n+--"
  "------------------+-----------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-mb"
  "r.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (362,32,'MBRCOVERS','MBRCove"
  "rs(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\\ncovers the minimum bounding re"
  "ctangle of g2. This tests the opposite\\nrelationship as MBRCoveredBy(). See the description of MBRCoveredBy()\\nfor ex"
  "amples.\\n\\nMBRCovers() handles its arguments as described in the introduction to\\nthis section.\\n\\nURL: https://dev.m"
  "ysql.com/doc/refman/8.4/en/spatial-relation-functions-mbr.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spati"
  "al-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (363,32,'MBRDISJOINT','MBRDi"
  "sjoint(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\\nthe two geometries g1 and g2"
  " are disjoint (do not intersect).\\n\\nMBRDisjoint() handles its arguments as described in the introduction to\\nthis se"
  "ction.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-mbr.html\\n\\n','','https://dev.mysql"
  ".com/doc/refman/8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (364,32,'MBREQUALS','MBREqua"
  "ls(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\\nthe two geometries g1 and g2 are"
  " the same.\\n\\nMBREquals() handles its arguments as described in the introduction to\\nthis section, except that it doe"
  "s not return NULL for empty geometry\\narguments.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-fun"
  "ctions-mbr.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (365,32,'MBRINTERSECTS','MBR"
  "Intersects(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\\nthe two geometries g1 an"
  "d g2 intersect.\\n\\nMBRIntersects() handles its arguments as described in the introduction\\nto this section.\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-mbr.html\\n\\n','','https://dev.mysql.com/doc/refman/"
  "8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (366,32,'MBROVERLAPS','MBROv"
  "erlaps(g1, g2)\\n\\nTwo geometries spatially overlap if they intersect and their\\nintersection results in a geometry of"
  " the same dimension but not equal\\nto either of the given geometries.\\n\\nThis function returns 1 or 0 to indicate whe"
  "ther the minimum bounding\\nrectangles of the two geometries g1 and g2 overlap.\\n\\nMBROverlaps() handles its arguments"
  " as described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-"
  "functions-mbr.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (367,32,'MBRTOUCHES','MBRTou"
  "ches(g1, g2)\\n\\nTwo geometries spatially touch if their interiors do not intersect, but\\nthe boundary of one of the g"
  "eometries intersects either the boundary or\\nthe interior of the other.\\n\\nThis function returns 1 or 0 to indicate w"
  "hether the minimum bounding\\nrectangles of the two geometries g1 and g2 touch.\\n\\nMBRTouches() handles its arguments "
  "as described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-f"
  "unctions-mbr.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (368,32,'MBRWITHIN','MBRWith"
  "in(g1, g2)\\n\\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\\nis within the minimum bounding"
  " rectangle of g2. This tests the opposite\\nrelationship as MBRContains().\\n\\nMBRWithin() handles its arguments as des"
  "cribed in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-relation-functio"
  "ns-mbr.html\\n\\n','mysql> SET @g1 = ST_GeomFromText(\\'Polygon((0 0,0 3,3 3,3 0,0 0))\\');\\nmysql> SET @g2 = ST_GeomFrom"
  "Text(\\'Polygon((0 0,0 5,5 5,5 0,0 0))\\');\\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\\n+------------------"
  "--+--------------------+\\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\\n+--------------------+--------------------+\\n|"
  "                  1 |                  0 |\\n+--------------------+--------------------+\\n','https://dev.mysql.com/doc"
  "/refman/8.4/en/spatial-relation-functions-mbr.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (369,32,'ST_GEOHASH','ST_Geo"
  "Hash(longitude, latitude, max_length), ST_GeoHash(point,\\nmax_length)\\n\\nReturns a geohash string in the connection c"
  "haracter set and collation.\\n\\nFor the first syntax, the longitude must be a number in the range\\n[−180, 180], and "
  "the latitude must be a number in the range [−90,\\n90]. For the second syntax, a POINT value is required, where the "
  "X and\\nY coordinates are in the valid ranges for longitude and latitude,\\nrespectively.\\n\\nThe resulting string is no"
  " longer than max_length characters, which has\\nan upper limit of 100. The string might be shorter than max_length\\nch"
  "aracters because the algorithm that creates the geohash value\\ncontinues until it has created a string that is either"
  " an exact\\nrepresentation of the location or max_length characters, whichever\\ncomes first.\\n\\nST_GeoHash() handles i"
  "ts arguments as described in the introduction to\\nthis section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spati"
  "al-geohash-functions.html\\n\\n','mysql> SELECT ST_GeoHash(180,0,10), ST_GeoHash(-180,-90,15);\\n+----------------------"
  "+-------------------------+\\n| ST_GeoHash(180,0,10) | ST_GeoHash(-180,-90,15) |\\n+----------------------+------------"
  "-------------+\\n| xbpbpbpbpb           | 000000000000000         |\\n+----------------------+-------------------------"
  "+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-geohash-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (370,32,'ST_LATFROMGEOHASH',"
  "'ST_LatFromGeoHash(geohash_str)\\n\\nReturns the latitude from a geohash string value, as a double-precision\\nnumber in"
  " the range [−90, 90].\\n\\nThe ST_LatFromGeoHash() decoding function reads no more than 433\\ncharacters from the geoh"
  "ash_str argument. That represents the upper\\nlimit on information in the internal representation of coordinate\\nvalue"
  "s. Characters past the 433rd are ignored, even if they are\\notherwise illegal and produce an error.\\n\\nST_LatFromGeoH"
  "ash() handles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refm"
  "an/8.4/en/spatial-geohash-functions.html\\n\\n','mysql> SELECT ST_LatFromGeoHash(ST_GeoHash(45,-20,10));\\n+------------"
  "------------------------------+\\n| ST_LatFromGeoHash(ST_GeoHash(45,-20,10)) |\\n+-------------------------------------"
  "-----+\\n|                                      -20 |\\n+------------------------------------------+\\n','https://dev.my"
  "sql.com/doc/refman/8.4/en/spatial-geohash-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (371,32,'ST_LONGFROMGEOHASH'"
  ",'ST_LongFromGeoHash(geohash_str)\\n\\nReturns the longitude from a geohash string value, as a\\ndouble-precision number"
  " in the range [−180, 180].\\n\\nThe remarks in the description of ST_LatFromGeoHash() regarding the\\nmaximum number o"
  "f characters processed from the geohash_str argument\\nalso apply to ST_LongFromGeoHash().\\n\\nST_LongFromGeoHash() han"
  "dles its arguments as described in the\\nintroduction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en"
  "/spatial-geohash-functions.html\\n\\n','mysql> SELECT ST_LongFromGeoHash(ST_GeoHash(45,-20,10));\\n+--------------------"
  "-----------------------+\\n| ST_LongFromGeoHash(ST_GeoHash(45,-20,10)) |\\n+-------------------------------------------"
  "+\\n|                                        45 |\\n+-------------------------------------------+\\n','https://dev.mysql"
  ".com/doc/refman/8.4/en/spatial-geohash-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (372,32,'ST_POINTFROMGEOHASH"
  "','ST_PointFromGeoHash(geohash_str, srid)\\n\\nReturns a POINT value containing the decoded geohash value, given a\\ngeo"
  "hash string value.\\n\\nThe X and Y coordinates of the point are the longitude in the range\\n[−180, 180] and the lati"
  "tude in the range [−90, 90], respectively.\\n\\nThe srid argument is an 32-bit unsigned integer.\\n\\nThe remarks in th"
  "e description of ST_LatFromGeoHash() regarding the\\nmaximum number of characters processed from the geohash_str argum"
  "ent\\nalso apply to ST_PointFromGeoHash().\\n\\nST_PointFromGeoHash() handles its arguments as described in the\\nintrodu"
  "ction to this section.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-geohash-functions.html\\n\\n','mysql> SE"
  "T @gh = ST_GeoHash(45,-20,10);\\nmysql> SELECT ST_AsText(ST_PointFromGeoHash(@gh,0));\\n+------------------------------"
  "---------+\\n| ST_AsText(ST_PointFromGeoHash(@gh,0)) |\\n+---------------------------------------+\\n| POINT(45 -20)    "
  "                     |\\n+---------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial"
  "-geohash-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (373,32,'ST_ASGEOJSON','ST_A"
  "sGeoJSON(g [, max_dec_digits [, options]])\\n\\nGenerates a GeoJSON object from the geometry g. The object string has\\n"
  "the connection character set and collation.\\n\\nIf any argument is NULL, the return value is NULL. If any non-NULL\\nar"
  "gument is invalid, an error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-geojson-functions.html\\n\\"
  "n','mysql> SELECT ST_AsGeoJSON(ST_GeomFromText(\\'POINT(11.11111 12.22222)\\'),2);\\n+----------------------------------"
  "---------------------------+\\n| ST_AsGeoJSON(ST_GeomFromText(\\'POINT(11.11111 12.22222)\\'),2) |\\n+-------------------"
  "------------------------------------------+\\n| {\"type\": \"Point\", \"coordinates\": [11.11, 12.22]}            |\\n+"
  "-------------------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-ge"
  "ojson-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (374,32,'ST_GEOMFROMGEOJSON'"
  ",'ST_GeomFromGeoJSON(str [, options [, srid]])\\n\\nParses a string str representing a GeoJSON object and returns a\\nge"
  "ometry.\\n\\nIf any argument is NULL, the return value is NULL. If any non-NULL\\nargument is invalid, an error occurs.\\"
  "n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-geojson-functions.html\\n\\n','mysql> SET @json = \\'{ \"type\":"
  " \"Point\", \"coordinates\": [102.0, 0.0]}\\';\\nmysql> SELECT ST_AsText(ST_GeomFromGeoJSON(@json));\\n+----------------"
  "----------------------+\\n| ST_AsText(ST_GeomFromGeoJSON(@json)) |\\n+--------------------------------------+\\n| POINT("
  "0 102)                         |\\n+--------------------------------------+\\nmysql> SELECT ST_SRID(ST_GeomFromGeoJSON("
  "@json));\\n+------------------------------------+\\n| ST_SRID(ST_GeomFromGeoJSON(@json)) |\\n+--------------------------"
  "----------+\\n|                               4326 |\\n+------------------------------------+\\nmysql> SELECT ST_AsText("
  "ST_SRID(ST_GeomFromGeoJSON(@json),0));\\n+-------------------------------------------------+\\n| ST_AsText(ST_SRID(ST_G"
  "eomFromGeoJSON(@json),0)) |\\n+-------------------------------------------------+\\n| POINT(102 0)                     "
  "               |\\n+-------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spa"
  "tial-geojson-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (375,32,'ST_COLLECT','ST_Col"
  "lect([DISTINCT] g) [over_clause]\\n\\nAggregates geometry values and returns a single geometry collection\\nvalue. With "
  "the DISTINCT option, returns the aggregation of the\\ndistinct geometry arguments.\\n\\nAs with other aggregate function"
  "s, GROUP BY may be used to group\\narguments into subsets. ST_Collect() returns an aggregate value for\\neach subset.\\n"
  "\\nThis function executes as a window function if over_clause is present.\\nover_clause is as described in\\nhttps://dev"
  ".mysql.com/doc/refman/8.4/en/window-functions-usage.html. In\\ncontrast to most aggregate functions that support windo"
  "wing,\\nST_Collect() permits use of over_clause together with DISTINCT.\\n\\nST_Collect() handles its arguments as follo"
  "ws:\\n\\no NULL arguments are ignored.\\n\\no If all arguments are NULL or the aggregate result is empty, the\\n  return v"
  "alue is NULL.\\n\\no If any geometry argument is not a syntactically well-formed geometry,\\n  an ER_GIS_INVALID_DATA\\n "
  " (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_gis_invalid_data) error occu"
  "rs.\\n\\no If any geometry argument is a syntactically well-formed geometry in\\n  an undefined spatial reference system"
  " (SRS), an ER_SRS_NOT_FOUND\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_e"
  "r_srs_not_found) error occurs.\\n\\no If there are multiple geometry arguments and those arguments are in\\n  the same S"
  "RS, the return value is in that SRS. If those arguments are\\n  not in the same SRS, an ER_GIS_DIFFERENT_SRIDS_AGGREGA"
  "TION\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_gis_different_srids_a"
  "ggregation) error occurs.\\n\\no The result is the narrowest MultiXxx or GeometryCollection value\\n  possible, with the"
  " result type determined from the non-NULL geometry\\n  arguments as follows:\\n\\n  o If all arguments are Point values,"
  " the result is a MultiPoint\\n    value.\\n\\n  o If all arguments are LineString values, the result is a\\n    MultiLine"
  "String value.\\n\\n  o If all arguments are Polygon values, the result is a MultiPolygon\\n    value.\\n\\n  o Otherwise, "
  "the arguments are a mix of geometry types and the result\\n    is a GeometryCollection value.\\n\\nURL: https://dev.mysq"
  "l.com/doc/refman/8.4/en/spatial-aggregate-functions.html\\n\\n','CREATE TABLE product (\\n  year INTEGER,\\n  product VAR"
  "CHAR(256),\\n  location Geometry\\n);\\n\\nINSERT INTO product\\n(year,  product,     location) VALUES\\n(2000, \"Calculato"
  "r\", ST_GeomFromText(\\'point(60 -24)\\',4326)),\\n(2000, \"Computer\"  , ST_GeomFromText(\\'point(28 -77)\\',4326)),\\n(20"
  "00, \"Abacus\"    , ST_GeomFromText(\\'point(28 -77)\\',4326)),\\n(2000, \"TV\"        , ST_GeomFromText(\\'point(38  60)"
  "\\',4326)),\\n(2001, \"Calculator\", ST_GeomFromText(\\'point(60 -24)\\',4326)),\\n(2001, \"Computer\"  , ST_GeomFromText("
  "\\'point(28 -77)\\',4326));\\n\\nmysql> SELECT ST_AsText(ST_Collect(location)) AS result\\n       FROM product;\\n+--------"
  "----------------------------------------------------------+\\n| result                                                "
  "           |\\n+------------------------------------------------------------------+\\n| MULTIPOINT((60 -24),(28 -77),(2"
  "8 -77),(38 60),(60 -24),(28 -77)) |\\n+------------------------------------------------------------------+\\n\\nmysql> S"
  "ELECT ST_AsText(ST_Collect(DISTINCT location)) AS result\\n       FROM product;\\n+------------------------------------"
  "---+\\n| result                                |\\n+---------------------------------------+\\n| MULTIPOINT((60 -24),(28"
  " -77),(38 60)) |\\n+---------------------------------------+\\n\\nmysql> SELECT year, ST_AsText(ST_Collect(location)) AS"
  " result\\n       FROM product GROUP BY year;\\n+------+------------------------------------------------+\\n| year | resu"
  "lt                                         |\\n+------+------------------------------------------------+\\n| 2000 | MUL"
  "TIPOINT((60 -24),(28 -77),(28 -77),(38 60)) |\\n| 2001 | MULTIPOINT((60 -24),(28 -77))                  |\\n+------+---"
  "---------------------------------------------+\\n\\nmysql> SELECT year, ST_AsText(ST_Collect(DISTINCT location)) AS res"
  "ult\\n       FROM product GROUP BY year;\\n+------+---------------------------------------+\\n| year | result           "
  "                     |\\n+------+---------------------------------------+\\n| 2000 | MULTIPOINT((60 -24),(28 -77),(38 6"
  "0)) |\\n| 2001 | MULTIPOINT((60 -24),(28 -77))         |\\n+------+---------------------------------------+\\n\\n# select"
  "s nothing\\nmysql> SELECT ST_Collect(location) AS result\\n       FROM product WHERE year = 1999;\\n+--------+\\n| result"
  " |\\n+--------+\\n| NULL   |\\n+--------+\\n\\nmysql> SELECT ST_AsText(ST_Collect(location)\\n         OVER (ORDER BY year,"
  " product ROWS BETWEEN 1 PRECEDING AND CURRENT ROW))\\n         AS result\\n       FROM product;\\n+---------------------"
  "----------+\\n| result                        |\\n+-------------------------------+\\n| MULTIPOINT((28 -77))          |\\"
  "n| MULTIPOINT((28 -77),(60 -24)) |\\n| MULTIPOINT((60 -24),(28 -77)) |\\n| MULTIPOINT((28 -77),(38 60))  |\\n| MULTIPOIN"
  "T((38 60),(60 -24))  |\\n| MULTIPOINT((60 -24),(28 -77)) |\\n+-------------------------------+\\n','https://dev.mysql.co"
  "m/doc/refman/8.4/en/spatial-aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (376,32,'ST_DISTANCE_SPHERE'"
  ",'ST_Distance_Sphere(g1, g2 [, radius])\\n\\nReturns the minimum spherical distance between Point or MultiPoint\\nargume"
  "nts on a sphere, in meters. (For general-purpose distance\\ncalculations, see the ST_Distance() function.) The optiona"
  "l radius\\nargument should be given in meters.\\n\\nIf both geometry parameters are valid Cartesian Point or MultiPoint\\"
  "nvalues in SRID 0, the return value is shortest distance between the two\\ngeometries on a sphere with the provided ra"
  "dius. If omitted, the\\ndefault radius is 6,370,986 meters, Point X and Y coordinates are\\ninterpreted as longitude an"
  "d latitude, respectively, in degrees.\\n\\nIf both geometry parameters are valid Point or MultiPoint values in a\\ngeogr"
  "aphic spatial reference system (SRS), the return value is the\\nshortest distance between the two geometries on a sphe"
  "re with the\\nprovided radius. If omitted, the default radius is equal to the mean\\nradius, defined as (2a+b)/3, where"
  " a is the semi-major axis and b is\\nthe semi-minor axis of the SRS.\\n\\nST_Distance_Sphere() handles its arguments as "
  "described in the\\nintroduction to this section, with these exceptions:\\n\\no Supported geometry argument combinations "
  "are Point and Point, or\\n  Point and MultiPoint (in any argument order). If at least one of the\\n  geometries is neit"
  "her Point nor MultiPoint, and its SRID is 0, an\\n  ER_NOT_IMPLEMENTED_FOR_CARTESIAN_SRS\\n  (https://dev.mysql.com/doc"
  "/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_not_implemented_for_cartesian_srs) error occurs. If at\\"
  "n  least one of the geometries is neither Point nor MultiPoint, and its\\n  SRID refers to a geographic SRS, an\\n  ER_"
  "NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#"
  "error_er_not_implemented_for_geographic_srs) error occurs. If\\n  any geometry refers to a projected SRS, an\\n  ER_NOT"
  "_IMPLEMENTED_FOR_PROJECTED_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#erro"
  "r_er_not_implemented_for_projected_srs) error occurs.\\n\\no If any argument has a longitude or latitude that is out of"
  " range, an\\n  error occurs:\\n\\n  o If a longitude value is not in the range (−180, 180], an\\n    ER_GEOMETRY_PARAM_"
  "LONGITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.html#error_er"
  "_geometry_param_longitude_out_of_range) error\\n    occurs.\\n\\n  o If a latitude value is not in the range [−90, 90]"
  ", an\\n    ER_GEOMETRY_PARAM_LATITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-re"
  "feren\\n    ce.html#error_er_geometry_param_latitude_out_of_range) error\\n    occurs.\\n\\n  Ranges shown are in degrees"
  ". If an SRS uses another unit, the range\\n  uses the corresponding values in its unit. The exact range limits\\n  devi"
  "ate slightly due to floating-point arithmetic.\\n\\no If the radius argument is present but not positive, an\\n  ER_NONP"
  "OSITIVE_RADIUS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_nonpositive"
  "_radius) error occurs.\\n\\no If the distance exceeds the range of a double-precision number, an\\n  ER_STD_OVERFLOW_ERR"
  "OR\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_std_overflow_error) err"
  "or occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-convenience-functions.html\\n\\n','mysql> SET @pt1 ="
  " ST_GeomFromText(\\'POINT(0 0)\\');\\nmysql> SET @pt2 = ST_GeomFromText(\\'POINT(180 0)\\');\\nmysql> SELECT ST_Distance_Sp"
  "here(@pt1, @pt2);\\n+--------------------------------+\\n| ST_Distance_Sphere(@pt1, @pt2) |\\n+-------------------------"
  "-------+\\n|             20015042.813723423 |\\n+--------------------------------+\\n','https://dev.mysql.com/doc/refman"
  "/8.4/en/spatial-convenience-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (377,32,'ST_ISVALID','ST_IsV"
  "alid(g)\\n\\nReturns 1 if the argument is geometrically valid, 0 if the argument is\\nnot geometrically valid. Geometry "
  "validity is defined by the OGC\\nspecification.\\n\\nThe only valid empty geometry is represented in the form of an empt"
  "y\\ngeometry collection value. ST_IsValid() returns 1 in this case. MySQL\\ndoes not support GIS EMPTY values such as P"
  "OINT EMPTY.\\n\\nST_IsValid() handles its arguments as described in the introduction to\\nthis section, with this except"
  "ion:\\n\\no If the geometry has a geographic SRS with a longitude or latitude\\n  that is out of range, an error occurs:"
  "\\n\\n  o If a longitude value is not in the range (−180, 180], an\\n    ER_GEOMETRY_PARAM_LONGITUDE_OUT_OF_RANGE\\n   "
  " (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.html#error_er_geometry_param_longitude_o"
  "ut_of_range) error\\n    occurs.\\n\\n  o If a latitude value is not in the range [−90, 90], an\\n    ER_GEOMETRY_PARAM"
  "_LATITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.html#error_er"
  "_geometry_param_latitude_out_of_range) error\\n    occurs.\\n\\n  Ranges shown are in degrees. If an SRS uses another un"
  "it, the range\\n  uses the corresponding values in its unit. The exact range limits\\n  deviate slightly due to floatin"
  "g-point arithmetic.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-convenience-functions.html\\n\\n','mysql> S"
  "ET @ls1 = ST_GeomFromText(\\'LINESTRING(0 0,-0.00 0,0.0 0)\\');\\nmysql> SET @ls2 = ST_GeomFromText(\\'LINESTRING(0 0, 1 "
  "1)\\');\\nmysql> SELECT ST_IsValid(@ls1);\\n+------------------+\\n| ST_IsValid(@ls1) |\\n+------------------+\\n|         "
  "       0 |\\n+------------------+\\nmysql> SELECT ST_IsValid(@ls2);\\n+------------------+\\n| ST_IsValid(@ls2) |\\n+-----"
  "-------------+\\n|                1 |\\n+------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-conven"
  "ience-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (378,32,'ST_MAKEENVELOPE','S"
  "T_MakeEnvelope(pt1, pt2)\\n\\nReturns the rectangle that forms the envelope around two points, as a\\nPoint, LineString,"
  " or Polygon.\\n\\nCalculations are done using the Cartesian coordinate system rather than\\non a sphere, spheroid, or on"
  " earth.\\n\\nGiven two points pt1 and pt2, ST_MakeEnvelope() creates the result\\ngeometry on an abstract plane like thi"
  "s:\\n\\no If pt1 and pt2 are equal, the result is the point pt1.\\n\\no Otherwise, if (pt1, pt2) is a vertical or horizon"
  "tal line segment,\\n  the result is the line segment (pt1, pt2).\\n\\no Otherwise, the result is a polygon using pt1 and"
  " pt2 as diagonal\\n  points.\\n\\nThe result geometry has an SRID of 0.\\n\\nST_MakeEnvelope() handles its arguments as de"
  "scribed in the\\nintroduction to this section, with these exceptions:\\n\\no If the arguments are not Point values, an E"
  "R_WRONG_ARGUMENTS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_wrong_ar"
  "guments) error occurs.\\n\\no An ER_GIS_INVALID_DATA\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-ref"
  "erence\\n  .html#error_er_gis_invalid_data) error occurs for the additional\\n  condition that any coordinate value of "
  "the two points is infinite or\\n  NaN.\\n\\no If any geometry has an SRID value for a geographic spatial reference\\n  sy"
  "stem (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-r"
  "eference\\n  .html#error_er_not_implemented_for_geographic_srs) error occurs.\\n\\nURL: https://dev.mysql.com/doc/refman"
  "/8.4/en/spatial-convenience-functions.html\\n\\n','mysql> SET @pt1 = ST_GeomFromText(\\'POINT(0 0)\\');\\nmysql> SET @pt2 "
  "= ST_GeomFromText(\\'POINT(1 1)\\');\\nmysql> SELECT ST_AsText(ST_MakeEnvelope(@pt1, @pt2));\\n+-------------------------"
  "---------------+\\n| ST_AsText(ST_MakeEnvelope(@pt1, @pt2)) |\\n+----------------------------------------+\\n| POLYGON(("
  "0 0,1 0,1 1,0 1,0 0))         |\\n+----------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/"
  "en/spatial-convenience-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (379,32,'ST_SIMPLIFY','ST_Si"
  "mplify(g, max_distance)\\n\\nSimplifies a geometry using the Douglas-Peucker algorithm and returns a\\nsimplified value "
  "of the same type.\\n\\nThe geometry may be any geometry type, although the Douglas-Peucker\\nalgorithm may not actually "
  "process every type. A geometry collection is\\nprocessed by giving its components one by one to the simplification\\nal"
  "gorithm, and the returned geometries are put into a geometry\\ncollection as result.\\n\\nThe max_distance argument is t"
  "he distance (in units of the input\\ncoordinates) of a vertex to other segments to be removed. Vertices\\nwithin this d"
  "istance of the simplified linestring are removed.\\n\\nAccording to Boost.Geometry, geometries might become invalid as "
  "a\\nresult of the simplification process, and the process might create\\nself-intersections. To check the validity of t"
  "he result, pass it to\\nST_IsValid().\\n\\nST_Simplify() handles its arguments as described in the introduction to\\nthis"
  " section, with this exception:\\n\\no If the max_distance argument is not positive, or is NaN, an\\n  ER_WRONG_ARGUMENTS"
  "\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_wrong_arguments) error oc"
  "curs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/spatial-convenience-functions.html\\n\\n','mysql> SET @g = ST_Geo"
  "mFromText(\\'LINESTRING(0 0,0 1,1 1,1 2,2 2,2 3,3 3)\\');\\nmysql> SELECT ST_AsText(ST_Simplify(@g, 0.5));\\n+-----------"
  "----------------------+\\n| ST_AsText(ST_Simplify(@g, 0.5)) |\\n+---------------------------------+\\n| LINESTRING(0 0,0"
  " 1,1 1,2 3,3 3) |\\n+---------------------------------+\\nmysql> SELECT ST_AsText(ST_Simplify(@g, 1.0));\\n+------------"
  "---------------------+\\n| ST_AsText(ST_Simplify(@g, 1.0)) |\\n+---------------------------------+\\n| LINESTRING(0 0,3 "
  "3)             |\\n+---------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-convenience"
  "-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (380,32,'ST_VALIDATE','ST_Va"
  "lidate(g)\\n\\nValidates a geometry according to the OGC specification. A geometry can\\nbe syntactically well-formed (W"
  "KB value plus SRID) but geometrically\\ninvalid. For example, this polygon is geometrically invalid: POLYGON((0\\n0, 0 "
  "0, 0 0, 0 0, 0 0))\\n\\nST_Validate() returns the geometry if it is syntactically well-formed\\nand is geometrically val"
  "id, NULL if the argument is not syntactically\\nwell-formed or is not geometrically valid or is NULL.\\n\\nST_Validate()"
  " can be used to filter out invalid geometry data, although\\nat a cost. For applications that require more precise res"
  "ults not\\ntainted by invalid data, this penalty may be worthwhile.\\n\\nIf the geometry argument is valid, it is return"
  "ed as is, except that if\\nan input Polygon or MultiPolygon has clockwise rings, those rings are\\nreversed before chec"
  "king for validity. If the geometry is valid, the\\nvalue with the reversed rings is returned.\\n\\nThe only valid empty "
  "geometry is represented in the form of an empty\\ngeometry collection value. ST_Validate() returns it directly without"
  "\\nfurther checks in this case.\\n\\nST_Validate() handles its arguments as described in the introduction to\\nthis secti"
  "on, with the exceptions listed here:\\n\\no If the geometry has a geographic SRS with a longitude or latitude\\n  that i"
  "s out of range, an error occurs:\\n\\n  o If a longitude value is not in the range (−180, 180], an\\n    ER_GEOMETRY_P"
  "ARAM_LONGITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-referen\\n    ce.html#err"
  "or_er_geometry_param_longitude_out_of_range) error\\n    occurs.\\n\\n  o If a latitude value is not in the range [−90"
  ", 90], an\\n    ER_GEOMETRY_PARAM_LATITUDE_OUT_OF_RANGE\\n    (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-err"
  "or-referen\\n    ce.html#error_er_geometry_param_latitude_out_of_range) error\\n    occurs.\\n\\n  Ranges shown are in de"
  "grees. The exact range limits deviate slightly\\n  due to floating-point arithmetic.\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/spatial-convenience-functions.html\\n\\n','mysql> SET @ls1 = ST_GeomFromText(\\'LINESTRING(0 0)\\');\\nmysq"
  "l> SET @ls2 = ST_GeomFromText(\\'LINESTRING(0 0, 1 1)\\');\\nmysql> SELECT ST_AsText(ST_Validate(@ls1));\\n+-------------"
  "-----------------+\\n| ST_AsText(ST_Validate(@ls1)) |\\n+------------------------------+\\n| NULL                       "
  "  |\\n+------------------------------+\\nmysql> SELECT ST_AsText(ST_Validate(@ls2));\\n+------------------------------+\\"
  "n| ST_AsText(ST_Validate(@ls2)) |\\n+------------------------------+\\n| LINESTRING(0 0,1 1)          |\\n+-------------"
  "-----------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/spatial-convenience-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (381,32,'JSON_ARRAY','Syntax"
  ":\\nJSON_ARRAY([val[, val] ...])\\n\\nEvaluates a (possibly empty) list of values and returns a JSON array\\ncontaining t"
  "hose values.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-creation-functions.html\\n\\n','mysql> SELECT JSON_AR"
  "RAY(1, \"abc\", NULL, TRUE, CURTIME());\\n+---------------------------------------------+\\n| JSON_ARRAY(1, \"abc\", NU"
  "LL, TRUE, CURTIME()) |\\n+---------------------------------------------+\\n| [1, \"abc\", null, true, \"11:30:24.000000"
  "\"]   |\\n+---------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-creation-fu"
  "nctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (382,32,'JSON_OBJECT','Synta"
  "x:\\nJSON_OBJECT([key, val[, key, val] ...])\\n\\nEvaluates a (possibly empty) list of key-value pairs and returns a JSO"
  "N\\nobject containing those pairs. An error occurs if any key name is NULL\\nor the number of arguments is odd.\\n\\nURL:"
  " https://dev.mysql.com/doc/refman/8.4/en/json-creation-functions.html\\n\\n','mysql> SELECT JSON_OBJECT(\\'id\\', 87, \\'n"
  "ame\\', \\'carrot\\');\\n+-----------------------------------------+\\n| JSON_OBJECT(\\'id\\', 87, \\'name\\', \\'carrot\\') |\\n"
  "+-----------------------------------------+\\n| {\"id\": 87, \"name\": \"carrot\"}            |\\n+--------------------"
  "---------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-creation-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (383,32,'JSON_QUOTE','Syntax"
  ":\\nJSON_QUOTE(string)\\n\\nQuotes a string as a JSON value by wrapping it with double quote\\ncharacters and escaping in"
  "terior quote and other characters, then\\nreturning the result as a utf8mb4 string. Returns NULL if the argument\\nis N"
  "ULL.\\n\\nThis function is typically used to produce a valid JSON string literal\\nfor inclusion within a JSON document."
  "\\n\\nCertain special characters are escaped with backslashes per the escape\\nsequences shown in\\nhttps://dev.mysql.com"
  "/doc/refman/8.4/en/json-modification-functions.html\\n#json-unquote-character-escape-sequences.\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/json-creation-functions.html\\n\\n','mysql> SELECT JSON_QUOTE(\\'null\\'), JSON_QUOTE(\\'\"null\""
  "\\');\\n+--------------------+----------------------+\\n| JSON_QUOTE(\\'null\\') | JSON_QUOTE(\\'\"null\"\\') |\\n+----------"
  "----------+----------------------+\\n| \"null\"             | \"\\\\\"null\\\\\"\"           |\\n+--------------------+----"
  "------------------+\\nmysql> SELECT JSON_QUOTE(\\'[1, 2, 3]\\');\\n+-------------------------+\\n| JSON_QUOTE(\\'[1, 2, 3]\\"
  "') |\\n+-------------------------+\\n| \"[1, 2, 3]\"             |\\n+-------------------------+\\n','https://dev.mysql.c"
  "om/doc/refman/8.4/en/json-creation-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (384,32,'JSON_CONTAINS','Syn"
  "tax:\\nJSON_CONTAINS(target, candidate[, path])\\n\\nIndicates by returning 1 or 0 whether a given candidate JSON docume"
  "nt\\nis contained within a target JSON document, or---if a path argument was\\nsupplied---whether the candidate is foun"
  "d at a specific path within the\\ntarget. Returns NULL if any argument is NULL, or if the path argument\\ndoes not iden"
  "tify a section of the target document. An error occurs if\\ntarget or candidate is not a valid JSON document, or if th"
  "e path\\nargument is not a valid path expression or contains a * or ** wildcard.\\n\\nTo check only whether any data exi"
  "sts at the path, use\\nJSON_CONTAINS_PATH() instead.\\n\\nThe following rules define containment:\\n\\no A candidate scala"
  "r is contained in a target scalar if and only if\\n  they are comparable and are equal. Two scalar values are comparab"
  "le\\n  if they have the same JSON_TYPE() types, with the exception that\\n  values of types INTEGER and DECIMAL are als"
  "o comparable to each\\n  other.\\n\\no A candidate array is contained in a target array if and only if every\\n  element "
  "in the candidate is contained in some element of the target.\\n\\no A candidate nonarray is contained in a target array"
  " if and only if\\n  the candidate is contained in some element of the target.\\n\\no A candidate object is contained in "
  "a target object if and only if for\\n  each key in the candidate there is a key with the same name in the\\n  target an"
  "d the value associated with the candidate key is contained\\n  in the value associated with the target key.\\n\\nOtherwi"
  "se, the candidate value is not contained in the target document.\\n\\nQueries using JSON_CONTAINS() on InnoDB tables ca"
  "n be optimized using\\nmulti-valued indexes; see\\nhttps://dev.mysql.com/doc/refman/8.4/en/create-index.html#create-ind"
  "ex-\\nmulti-valued, for more information.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html\\n"
  "\\n','mysql> SET @j = \\'{\"a\": 1, \"b\": 2, \"c\": {\"d\": 4}}\\';\\nmysql> SET @j2 = \\'1\\';\\nmysql> SELECT JSON_CONTAI"
  "NS(@j, @j2, \\'$.a\\');\\n+-------------------------------+\\n| JSON_CONTAINS(@j, @j2, \\'$.a\\') |\\n+---------------------"
  "----------+\\n|                             1 |\\n+-------------------------------+\\nmysql> SELECT JSON_CONTAINS(@j, @j"
  "2, \\'$.b\\');\\n+-------------------------------+\\n| JSON_CONTAINS(@j, @j2, \\'$.b\\') |\\n+------------------------------"
  "-+\\n|                             0 |\\n+-------------------------------+\\n\\nmysql> SET @j2 = \\'{\"d\": 4}\\';\\nmysql> "
  "SELECT JSON_CONTAINS(@j, @j2, \\'$.a\\');\\n+-------------------------------+\\n| JSON_CONTAINS(@j, @j2, \\'$.a\\') |\\n+---"
  "----------------------------+\\n|                             0 |\\n+-------------------------------+\\nmysql> SELECT JS"
  "ON_CONTAINS(@j, @j2, \\'$.c\\');\\n+-------------------------------+\\n| JSON_CONTAINS(@j, @j2, \\'$.c\\') |\\n+------------"
  "-------------------+\\n|                             1 |\\n+-------------------------------+\\n','https://dev.mysql.com/"
  "doc/refman/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (385,32,'JSON_CONTAINS_PATH'"
  ",'Syntax:\\nJSON_CONTAINS_PATH(json_doc, one_or_all, path[, path] ...)\\n\\nReturns 0 or 1 to indicate whether a JSON do"
  "cument contains data at a\\ngiven path or paths. Returns NULL if any argument is NULL. An error\\noccurs if the json_do"
  "c argument is not a valid JSON document, any path\\nargument is not a valid path expression, or one_or_all is not \\'on"
  "e\\' or\\n\\'all\\'.\\n\\nTo check for a specific value at a path, use JSON_CONTAINS() instead.\\n\\nThe return value is 0 if"
  " no specified path exists within the document.\\nOtherwise, the return value depends on the one_or_all argument:\\n\\no "
  "\\'one\\': 1 if at least one path exists within the document, 0\\n  otherwise.\\n\\no \\'all\\': 1 if all paths exist within"
  " the document, 0 otherwise.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html\\n\\n','mysql> S"
  "ET @j = \\'{\"a\": 1, \"b\": 2, \"c\": {\"d\": 4}}\\';\\nmysql> SELECT JSON_CONTAINS_PATH(@j, \\'one\\', \\'$.a\\', \\'$.e\\')"
  ";\\n+---------------------------------------------+\\n| JSON_CONTAINS_PATH(@j, \\'one\\', \\'$.a\\', \\'$.e\\') |\\n+---------"
  "------------------------------------+\\n|                                           1 |\\n+----------------------------"
  "-----------------+\\nmysql> SELECT JSON_CONTAINS_PATH(@j, \\'all\\', \\'$.a\\', \\'$.e\\');\\n+------------------------------"
  "---------------+\\n| JSON_CONTAINS_PATH(@j, \\'all\\', \\'$.a\\', \\'$.e\\') |\\n+-------------------------------------------"
  "--+\\n|                                           0 |\\n+---------------------------------------------+\\nmysql> SELECT "
  "JSON_CONTAINS_PATH(@j, \\'one\\', \\'$.c.d\\');\\n+----------------------------------------+\\n| JSON_CONTAINS_PATH(@j, \\'o"
  "ne\\', \\'$.c.d\\') |\\n+----------------------------------------+\\n|                                      1 |\\n+--------"
  "--------------------------------+\\nmysql> SELECT JSON_CONTAINS_PATH(@j, \\'one\\', \\'$.a.d\\');\\n+----------------------"
  "------------------+\\n| JSON_CONTAINS_PATH(@j, \\'one\\', \\'$.a.d\\') |\\n+----------------------------------------+\\n|   "
  "                                   0 |\\n+----------------------------------------+\\n','https://dev.mysql.com/doc/refm"
  "an/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (386,32,'JSON_EXTRACT','Synt"
  "ax:\\nJSON_EXTRACT(json_doc, path[, path] ...)\\n\\nReturns data from a JSON document, selected from the parts of the\\nd"
  "ocument matched by the path arguments. Returns NULL if any argument is\\nNULL or no paths locate a value in the docume"
  "nt. An error occurs if the\\njson_doc argument is not a valid JSON document or any path argument is\\nnot a valid path "
  "expression.\\n\\nThe return value consists of all values matched by the path arguments.\\nIf it is possible that those a"
  "rguments could return multiple values,\\nthe matched values are autowrapped as an array, in the order\\ncorresponding t"
  "o the paths that produced them. Otherwise, the return\\nvalue is the single matched value.\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/json-search-functions.html\\n\\n','mysql> SELECT JSON_EXTRACT(\\'[10, 20, [30, 40]]\\', \\'$[1]\\');\\n"
  "+--------------------------------------------+\\n| JSON_EXTRACT(\\'[10, 20, [30, 40]]\\', \\'$[1]\\') |\\n+----------------"
  "----------------------------+\\n| 20                                         |\\n+-------------------------------------"
  "-------+\\nmysql> SELECT JSON_EXTRACT(\\'[10, 20, [30, 40]]\\', \\'$[1]\\', \\'$[0]\\');\\n+---------------------------------"
  "-------------------+\\n| JSON_EXTRACT(\\'[10, 20, [30, 40]]\\', \\'$[1]\\', \\'$[0]\\') |\\n+--------------------------------"
  "--------------------+\\n| [20, 10]                                           |\\n+-------------------------------------"
  "---------------+\\nmysql> SELECT JSON_EXTRACT(\\'[10, 20, [30, 40]]\\', \\'$[2][*]\\');\\n+--------------------------------"
  "---------------+\\n| JSON_EXTRACT(\\'[10, 20, [30, 40]]\\', \\'$[2][*]\\') |\\n+-------------------------------------------"
  "----+\\n| [30, 40]                                      |\\n+-----------------------------------------------+\\n','https"
  "://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (387,32,'->','Syntax:\\ncolum"
  "n->path\\n\\nThe -> operator serves as an alias for the JSON_EXTRACT() function when\\nused with two arguments, a column"
  " identifier on the left and a JSON\\npath (a string literal) on the right that is evaluated against the JSON\\ndocument"
  " (the column value). You can use such expressions in place of\\ncolumn references wherever they occur in SQL statement"
  "s.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html\\n\\n','mysql> SELECT c, JSON_EXTRACT(c, "
  "\"$.id\"), g\\n     > FROM jemp\\n     > WHERE JSON_EXTRACT(c, \"$.id\") > 1\\n     > ORDER BY JSON_EXTRACT(c, \"$.name\""
  ");\\n+-------------------------------+-----------+------+\\n| c                             | c->\"$.id\" | g    |\\n+--"
  "-----------------------------+-----------+------+\\n| {\"id\": \"3\", \"name\": \"Barney\"} | \"3\"       |    3 |\\n| "
  "{\"id\": \"4\", \"name\": \"Betty\"}  | \"4\"       |    4 |\\n| {\"id\": \"2\", \"name\": \"Wilma\"}  | \"2\"       |"
  "    2 |\\n+-------------------------------+-----------+------+\\n3 rows in set (0.00 sec)\\n\\nmysql> SELECT c, c->\"$.id"
  "\", g\\n     > FROM jemp\\n     > WHERE c->\"$.id\" > 1\\n     > ORDER BY c->\"$.name\";\\n+-----------------------------"
  "--+-----------+------+\\n| c                             | c->\"$.id\" | g    |\\n+-------------------------------+----"
  "-------+------+\\n| {\"id\": \"3\", \"name\": \"Barney\"} | \"3\"       |    3 |\\n| {\"id\": \"4\", \"name\": \"Betty\""
  "}  | \"4\"       |    4 |\\n| {\"id\": \"2\", \"name\": \"Wilma\"}  | \"2\"       |    2 |\\n+-------------------------"
  "------+-----------+------+\\n3 rows in set (0.00 sec)\\n\\nmysql> ALTER TABLE jemp ADD COLUMN n INT;\\nQuery OK, 0 rows a"
  "ffected (0.68 sec)\\nRecords: 0  Duplicates: 0  Warnings: 0\\n\\nmysql> UPDATE jemp SET n=1 WHERE c->\"$.id\" = \"4\";\\n"
  "Query OK, 1 row affected (0.04 sec)\\nRows matched: 1  Changed: 1  Warnings: 0\\n\\nmysql> SELECT c, c->\"$.id\", g, n\\n"
  "     > FROM jemp\\n     > WHERE JSON_EXTRACT(c, \"$.id\") > 1\\n     > ORDER BY c->\"$.name\";\\n+----------------------"
  "---------+-----------+------+------+\\n| c                             | c->\"$.id\" | g    | n    |\\n+---------------"
  "----------------+-----------+------+------+\\n| {\"id\": \"3\", \"name\": \"Barney\"} | \"3\"       |    3 | NULL |\\n|"
  " {\"id\": \"4\", \"name\": \"Betty\"}  | \"4\"       |    4 |    1 |\\n| {\"id\": \"2\", \"name\": \"Wilma\"}  | \"2\""
  "       |    2 | NULL |\\n+-------------------------------+-----------+------+------+\\n3 rows in set (0.00 sec)\\n\\nmysq"
  "l> DELETE FROM jemp WHERE c->\"$.id\" = \"4\";\\nQuery OK, 1 row affected (0.04 sec)\\n\\nmysql> SELECT c, c->\"$.id\", "
  "g, n\\n     > FROM jemp\\n     > WHERE JSON_EXTRACT(c, \"$.id\") > 1\\n     > ORDER BY c->\"$.name\";\\n+----------------"
  "---------------+-----------+------+------+\\n| c                             | c->\"$.id\" | g    | n    |\\n+---------"
  "----------------------+-----------+------+------+\\n| {\"id\": \"3\", \"name\": \"Barney\"} | \"3\"       |    3 | NUL"
  "L |\\n| {\"id\": \"2\", \"name\": \"Wilma\"}  | \"2\"       |    2 | NULL |\\n+-------------------------------+--------"
  "---+------+------+\\n2 rows in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (388,32,'->>','Syntax:\\ncolu"
  "mn->>path\\n\\nThis is an improved, unquoting extraction operator. Whereas the ->\\noperator simply extracts a value, th"
  "e ->> operator in addition unquotes\\nthe extracted result. In other words, given a JSON column value column\\nand a pa"
  "th expression path (a string literal), the following three\\nexpressions return the same value:\\n\\no JSON_UNQUOTE( JSO"
  "N_EXTRACT(column, path) )\\n\\no JSON_UNQUOTE(column -> path)\\n\\no column->>path\\n\\nThe ->> operator can be used wherev"
  "er JSON_UNQUOTE(JSON_EXTRACT())\\nwould be allowed. This includes (but is not limited to) SELECT lists,\\nWHERE and HAV"
  "ING clauses, and ORDER BY and GROUP BY clauses.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-functions"
  ".html\\n\\n','mysql> SELECT * FROM jemp WHERE g > 2;\\n+-------------------------------+------+\\n| c                    "
  "         | g    |\\n+-------------------------------+------+\\n| {\"id\": \"3\", \"name\": \"Barney\"} |    3 |\\n| {\"i"
  "d\": \"4\", \"name\": \"Betty\"}  |    4 |\\n+-------------------------------+------+\\n2 rows in set (0.01 sec)\\n\\nmys"
  "ql> SELECT c->\\'$.name\\' AS name\\n    ->     FROM jemp WHERE g > 2;\\n+----------+\\n| name     |\\n+----------+\\n| \"Ba"
  "rney\" |\\n| \"Betty\"  |\\n+----------+\\n2 rows in set (0.00 sec)\\n\\nmysql> SELECT JSON_UNQUOTE(c->\\'$.name\\') AS name"
  "\\n    ->     FROM jemp WHERE g > 2;\\n+--------+\\n| name   |\\n+--------+\\n| Barney |\\n| Betty  |\\n+--------+\\n2 rows i"
  "n set (0.00 sec)\\n\\nmysql> SELECT c->>\\'$.name\\' AS name\\n    ->     FROM jemp WHERE g > 2;\\n+--------+\\n| name   |\\n"
  "+--------+\\n| Barney |\\n| Betty  |\\n+--------+\\n2 rows in set (0.00 sec)\\n\\nmysql> CREATE TABLE tj10 (a JSON, b INT);"
  "\\nQuery OK, 0 rows affected (0.26 sec)\\n\\nmysql> INSERT INTO tj10 VALUES\\n    ->     (\\'[3,10,5,\"x\",44]\\', 33),\\n  "
  "  ->     (\\'[3,10,5,17,[22,\"y\",66]]\\', 0);\\nQuery OK, 2 rows affected (0.04 sec)\\nRecords: 2  Duplicates: 0  Warnin"
  "gs: 0\\n\\nmysql> SELECT a->\"$[3]\", a->\"$[4][1]\" FROM tj10;\\n+-----------+--------------+\\n| a->\"$[3]\" | a->\"$[4"
  "][1]\" |\\n+-----------+--------------+\\n| \"x\"       | NULL         |\\n| 17        | \"y\"          |\\n+-----------+"
  "--------------+\\n2 rows in set (0.00 sec)\\n\\nmysql> SELECT a->>\"$[3]\", a->>\"$[4][1]\" FROM tj10;\\n+------------+--"
  "-------------+\\n| a->>\"$[3]\" | a->>\"$[4][1]\" |\\n+------------+---------------+\\n| x          | NULL          |\\n|"
  " 17         | y             |\\n+------------+---------------+\\n2 rows in set (0.00 sec)\\n\\nmysql> EXPLAIN SELECT c->>"
  "\\'$.name\\' AS name\\n    ->     FROM jemp WHERE g > 2\\\\G\\n*************************** 1. row *************************"
  "**\\n           id: 1\\n  select_type: SIMPLE\\n        table: jemp\\n   partitions: NULL\\n         type: range\\npossible"
  "_keys: i\\n          key: i\\n      key_len: 5\\n          ref: NULL\\n         rows: 2\\n     filtered: 100.00\\n        E"
  "xtra: Using where\\n1 row in set, 1 warning (0.00 sec)\\n\\nmysql> SHOW WARNINGS\\\\G\\n*************************** 1. row "
  "***************************\\n  Level: Note\\n   Code: 1003\\nMessage: /* select#1 */ select\\njson_unquote(json_extract("
  "`jtest`.`jemp`.`c`,\\'$.name\\')) AS `name` from\\n`jtest`.`jemp` where (`jtest`.`jemp`.`g` > 2)\\n1 row in set (0.00 sec"
  ")\\n','https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (389,32,'JSON_KEYS','Syntax:"
  "\\nJSON_KEYS(json_doc[, path])\\n\\nReturns the keys from the top-level value of a JSON object as a JSON\\narray, or, if "
  "a path argument is given, the top-level keys from the\\nselected path. Returns NULL if any argument is NULL, the json_"
  "doc\\nargument is not an object, or path, if given, does not locate an\\nobject. An error occurs if the json_doc argume"
  "nt is not a valid JSON\\ndocument or the path argument is not a valid path expression or\\ncontains a * or ** wildcard."
  "\\n\\nThe result array is empty if the selected object is empty. If the\\ntop-level value has nested subobjects, the ret"
  "urn value does not\\ninclude keys from those subobjects.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-f"
  "unctions.html\\n\\n','mysql> SELECT JSON_KEYS(\\'{\"a\": 1, \"b\": {\"c\": 30}}\\');\\n+----------------------------------"
  "-----+\\n| JSON_KEYS(\\'{\"a\": 1, \"b\": {\"c\": 30}}\\') |\\n+---------------------------------------+\\n| [\"a\", \"b\""
  "]                            |\\n+---------------------------------------+\\nmysql> SELECT JSON_KEYS(\\'{\"a\": 1, \"b\""
  ": {\"c\": 30}}\\', \\'$.b\\');\\n+----------------------------------------------+\\n| JSON_KEYS(\\'{\"a\": 1, \"b\": {\"c\""
  ": 30}}\\', \\'$.b\\') |\\n+----------------------------------------------+\\n| [\"c\"]                                    "
  "    |\\n+----------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-search-funct"
  "ions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (390,32,'JSON_OVERLAPS','Syn"
  "tax:\\nJSON_OVERLAPS(json_doc1, json_doc2)\\n\\nCompares two JSON documents. Returns true (1) if the two document have\\n"
  "any key-value pairs or array elements in common. If both arguments are\\nscalars, the function performs a simple equal"
  "ity test. If either\\nargument is NULL, the function returns NULL.\\n\\nThis function serves as counterpart to JSON_CONT"
  "AINS(), which requires\\nall elements of the array searched for to be present in the array\\nsearched in. Thus, JSON_CO"
  "NTAINS() performs an AND operation on search\\nkeys, while JSON_OVERLAPS() performs an OR operation.\\n\\nQueries on JSO"
  "N columns of InnoDB tables using JSON_OVERLAPS() in the\\nWHERE clause can be optimized using multi-valued indexes.\\nh"
  "ttps://dev.mysql.com/doc/refman/8.4/en/create-index.html#create-index-\\nmulti-valued, provides detailed information a"
  "nd examples.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html\\n\\n','mysql> SELECT JSON_OVER"
  "LAPS(\"[1,3,5,7]\", \"[2,5,7]\");\\n+---------------------------------------+\\n| JSON_OVERLAPS(\"[1,3,5,7]\", \"[2,5,7"
  "]\") |\\n+---------------------------------------+\\n|                                     1 |\\n+----------------------"
  "-----------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_OVERLAPS(\"[1,3,5,7]\", \"[2,6,7]\");\\n+-----------"
  "----------------------------+\\n| JSON_OVERLAPS(\"[1,3,5,7]\", \"[2,6,7]\") |\\n+--------------------------------------"
  "-+\\n|                                     1 |\\n+---------------------------------------+\\n1 row in set (0.00 sec)\\n\\n"
  "mysql> SELECT JSON_OVERLAPS(\"[1,3,5,7]\", \"[2,6,8]\");\\n+---------------------------------------+\\n| JSON_OVERLAPS("
  "\"[1,3,5,7]\", \"[2,6,8]\") |\\n+---------------------------------------+\\n|                                     0 |\\n"
  "+---------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_OVERLAPS(\\'[[1,2],[3,4],5]\\'"
  ", \\'[1,[2,3],[4,5]]\\');\\n+-----------------------------------------------------+\\n| JSON_OVERLAPS(\\'[[1,2],[3,4],5]\\'"
  ", \\'[1,[2,3],[4,5]]\\') |\\n+-----------------------------------------------------+\\n|                                 "
  "                  0 |\\n+-----------------------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SEL"
  "ECT JSON_OVERLAPS(\\'{\"a\":1,\"b\":10,\"d\":10}\\', \\'{\"c\":1,\"e\":10,\"f\":1,\"d\":10}\\');\\n+----------------------"
  "-------------------------------------------------+\\n| JSON_OVERLAPS(\\'{\"a\":1,\"b\":10,\"d\":10}\\', \\'{\"c\":1,\"e\""
  ":10,\"f\":1,\"d\":10}\\') |\\n+-----------------------------------------------------------------------+\\n|             "
  "                                                        1 |\\n+-------------------------------------------------------"
  "----------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_OVERLAPS(\\'{\"a\":1,\"b\":10,\"d\":10}\\', \\'{\"a\":5"
  ",\"e\":10,\"f\":1,\"d\":20}\\');\\n+-----------------------------------------------------------------------+\\n| JSON_OV"
  "ERLAPS(\\'{\"a\":1,\"b\":10,\"d\":10}\\', \\'{\"a\":5,\"e\":10,\"f\":1,\"d\":20}\\') |\\n+--------------------------------"
  "---------------------------------------+\\n|                                                                     0 |\\n"
  "+-----------------------------------------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT J"
  "SON_OVERLAPS(\\'5\\', \\'5\\');\\n+-------------------------+\\n| JSON_OVERLAPS(\\'5\\', \\'5\\') |\\n+-------------------------"
  "+\\n|                       1 |\\n+-------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_OVERLAPS(\\"
  "'5\\', \\'6\\');\\n+-------------------------+\\n| JSON_OVERLAPS(\\'5\\', \\'6\\') |\\n+-------------------------+\\n|          "
  "             0 |\\n+-------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_OVERLAPS(\\'[4,5,6,7]\\', "
  "\\'6\\');\\n+---------------------------------+\\n| JSON_OVERLAPS(\\'[4,5,6,7]\\', \\'6\\') |\\n+-----------------------------"
  "----+\\n|                               1 |\\n+---------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SE"
  "LECT JSON_OVERLAPS(\\'[4,5,\"6\",7]\\', \\'6\\');\\n+-----------------------------------+\\n| JSON_OVERLAPS(\\'[4,5,\"6\",7]"
  "\\', \\'6\\') |\\n+-----------------------------------+\\n|                                 0 |\\n+------------------------"
  "-----------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_OVERLAPS(\\'[4,5,6,7]\\', \\'\"6\"\\');\\n+-------------------"
  "----------------+\\n| JSON_OVERLAPS(\\'[4,5,6,7]\\', \\'\"6\"\\') |\\n+-----------------------------------+\\n|             "
  "                    0 |\\n+-----------------------------------+\\n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc"
  "/refman/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (391,32,'JSON_SEARCH','Synta"
  "x:\\nJSON_SEARCH(json_doc, one_or_all, search_str[, escape_char[, path]\\n...])\\n\\nReturns the path to the given string"
  " within a JSON document. Returns\\nNULL if any of the json_doc, search_str, or path arguments are NULL; no\\npath exist"
  "s within the document; or search_str is not found. An error\\noccurs if the json_doc argument is not a valid JSON docu"
  "ment, any path\\nargument is not a valid path expression, one_or_all is not \\'one\\' or\\n\\'all\\', or escape_char is not"
  " a constant expression.\\n\\nThe one_or_all argument affects the search as follows:\\n\\no \\'one\\': The search terminates"
  " after the first match and returns one\\n  path string. It is undefined which match is considered first.\\n\\no \\'all\\':"
  " The search returns all matching path strings such that no\\n  duplicate paths are included. If there are multiple str"
  "ings, they are\\n  autowrapped as an array. The order of the array elements is\\n  undefined.\\n\\nWithin the search_str "
  "search string argument, the % and _ characters\\nwork as for the LIKE operator: % matches any number of characters\\n(i"
  "ncluding zero characters), and _ matches exactly one character.\\n\\nTo specify a literal % or _ character in the searc"
  "h string, precede it\\nby the escape character. The default is \\\\ if the escape_char argument\\nis missing or NULL. Oth"
  "erwise, escape_char must be a constant that is\\nempty or one character.\\n\\nFor more information about matching and es"
  "cape character behavior, see\\nthe description of LIKE in\\nhttps://dev.mysql.com/doc/refman/8.4/en/string-comparison-f"
  "unctions.html\\n. For escape character handling, a difference from the LIKE behavior\\nis that the escape character for"
  " JSON_SEARCH() must evaluate to a\\nconstant at compile time, not just at execution time. For example, if\\nJSON_SEARCH"
  "() is used in a prepared statement and the escape_char\\nargument is supplied using a ? parameter, the parameter value"
  " might be\\nconstant at execution time, but is not at compile time.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/js"
  "on-search-functions.html\\n\\n','mysql> SET @j = \\'[\"abc\", [{\"k\": \"10\"}, \"def\"], {\"x\":\"abc\"}, {\"y\":\"bcd\""
  "}]\\';\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'one\\', \\'abc\\');\\n+-------------------------------+\\n| JSON_SEARCH(@j, \\'one"
  "\\', \\'abc\\') |\\n+-------------------------------+\\n| \"$[0]\"                        |\\n+----------------------------"
  "---+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'abc\\');\\n+-------------------------------+\\n| JSON_SEARCH(@j, \\'all\\"
  "', \\'abc\\') |\\n+-------------------------------+\\n| [\"$[0]\", \"$[2].x\"]            |\\n+---------------------------"
  "----+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'ghi\\');\\n+-------------------------------+\\n| JSON_SEARCH(@j, \\'all"
  "\\', \\'ghi\\') |\\n+-------------------------------+\\n| NULL                          |\\n+------------------------------"
  "-+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'10\\');\\n+------------------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\"
  "'10\\') |\\n+------------------------------+\\n| \"$[1][0].k\"                  |\\n+------------------------------+\\n\\nm"
  "ysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$\\');\\n+-----------------------------------------+\\n| JSON_SEAR"
  "CH(@j, \\'all\\', \\'10\\', NULL, \\'$\\') |\\n+-----------------------------------------+\\n| \"$[1][0].k\"                 "
  "            |\\n+-----------------------------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'"
  "$[*]\\');\\n+--------------------------------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$[*]\\') |\\n+----"
  "----------------------------------------+\\n| \"$[1][0].k\"                                |\\n+-----------------------"
  "---------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$**.k\\');\\n+------------------------"
  "---------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$**.k\\') |\\n+-------------------------------------"
  "--------+\\n| \"$[1][0].k\"                                 |\\n+---------------------------------------------+\\n\\nmysq"
  "l> SELECT JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$[*][0].k\\');\\n+-------------------------------------------------+"
  "\\n| JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$[*][0].k\\') |\\n+-------------------------------------------------+\\n| \""
  "$[1][0].k\"                                     |\\n+-------------------------------------------------+\\n\\nmysql> SELE"
  "CT JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$[1]\\');\\n+--------------------------------------------+\\n| JSON_SEARCH(@"
  "j, \\'all\\', \\'10\\', NULL, \\'$[1]\\') |\\n+--------------------------------------------+\\n| \"$[1][0].k\"               "
  "                 |\\n+--------------------------------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'10\\', "
  "NULL, \\'$[1][0]\\');\\n+-----------------------------------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'10\\', NULL, \\'$["
  "1][0]\\') |\\n+-----------------------------------------------+\\n| \"$[1][0].k\"                                   |\\n+"
  "-----------------------------------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'abc\\', NULL, \\'$[2]\\');\\"
  "n+---------------------------------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'abc\\', NULL, \\'$[2]\\') |\\n+-----------"
  "----------------------------------+\\n| \"$[2].x\"                                    |\\n+----------------------------"
  "-----------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'%a%\\');\\n+-------------------------------+\\n| JSON_SEA"
  "RCH(@j, \\'all\\', \\'%a%\\') |\\n+-------------------------------+\\n| [\"$[0]\", \"$[2].x\"]            |\\n+-------------"
  "------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'%b%\\');\\n+-------------------------------+\\n| JSON_SE"
  "ARCH(@j, \\'all\\', \\'%b%\\') |\\n+-------------------------------+\\n| [\"$[0]\", \"$[2].x\", \"$[3].y\"]  |\\n+----------"
  "---------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'%b%\\', NULL, \\'$[0]\\');\\n+------------------------"
  "---------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'%b%\\', NULL, \\'$[0]\\') |\\n+-------------------------------------"
  "--------+\\n| \"$[0]\"                                      |\\n+---------------------------------------------+\\n\\nmysq"
  "l> SELECT JSON_SEARCH(@j, \\'all\\', \\'%b%\\', NULL, \\'$[2]\\');\\n+---------------------------------------------+\\n| JSON"
  "_SEARCH(@j, \\'all\\', \\'%b%\\', NULL, \\'$[2]\\') |\\n+---------------------------------------------+\\n| \"$[2].x\"       "
  "                             |\\n+---------------------------------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'al"
  "l\\', \\'%b%\\', NULL, \\'$[1]\\');\\n+---------------------------------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'%b%\\', "
  "NULL, \\'$[1]\\') |\\n+---------------------------------------------+\\n| NULL                                        |\\n"
  "+---------------------------------------------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'%b%\\', \\'\\', \\'$[1]\\');\\n"
  "+-------------------------------------------+\\n| JSON_SEARCH(@j, \\'all\\', \\'%b%\\', \\'\\', \\'$[1]\\') |\\n+--------------"
  "-----------------------------+\\n| NULL                                      |\\n+-------------------------------------"
  "------+\\n\\nmysql> SELECT JSON_SEARCH(@j, \\'all\\', \\'%b%\\', \\'\\', \\'$[3]\\');\\n+---------------------------------------"
  "----+\\n| JSON_SEARCH(@j, \\'all\\', \\'%b%\\', \\'\\', \\'$[3]\\') |\\n+-------------------------------------------+\\n| \"$[3]"
  ".y\"                                  |\\n+-------------------------------------------+\\n','https://dev.mysql.com/doc/"
  "refman/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (392,32,'JSON_VALUE','Syntax"
  ":\\nJSON_VALUE(json_doc, path)\\n\\nExtracts a value from a JSON document at the path given in the\\nspecified document, "
  "and returns the extracted value, optionally\\nconverting it to a desired type. The complete syntax is shown here:\\n\\nJ"
  "SON_VALUE(json_doc, path [RETURNING type] [on_empty] [on_error])\\n\\non_empty:\\n    {NULL | ERROR | DEFAULT value} ON "
  "EMPTY\\n\\non_error:\\n    {NULL | ERROR | DEFAULT value} ON ERROR\\n\\njson_doc is a valid JSON document. If this is NULL"
  ", the function\\nreturns NULL.\\n\\npath is a JSON path pointing to a location in the document. This must\\nbe a string l"
  "iteral value.\\n\\ntype is one of the following data types:\\n\\no FLOAT\\n\\no DOUBLE\\n\\no DECIMAL\\n\\no SIGNED\\n\\no UNSIGN"
  "ED\\n\\no DATE\\n\\no TIME\\n\\no DATETIME\\n\\no YEAR\\n\\n  YEAR values of one or two digits are not supported.\\n\\no CHAR\\n\\n"
  "o JSON\\n\\nThe types just listed are the same as the (non-array) types supported\\nby the CAST() function.\\n\\nIf not sp"
  "ecified by a RETURNING clause, the JSON_VALUE() function\\'s\\nreturn type is VARCHAR(512). When no character set is sp"
  "ecified for the\\nreturn type, JSON_VALUE() uses utf8mb4 with the binary collation, which\\nis case-sensitive; if utf8m"
  "b4 is specified as the character set for the\\nresult, the server uses the default collation for this character set,\\n"
  "which is not case-sensitive.\\n\\nWhen the data at the specified path consists of or resolves to a JSON\\nnull literal, "
  "the function returns SQL NULL.\\n\\non_empty, if specified, determines how JSON_VALUE() behaves when no\\ndata is found "
  "at the path given; this clause takes one of the following\\nvalues:\\n\\no NULL ON EMPTY: The function returns NULL; thi"
  "s is the default ON\\n  EMPTY behavior.\\n\\no DEFAULT value ON EMPTY: the provided value is returned. The value\\'s\\n  t"
  "ype must match that of the return type.\\n\\no ERROR ON EMPTY: The function throws an error.\\n\\nIf used, on_error takes"
  " one of the following values with the\\ncorresponding outcome when an error occurs, as listed here:\\n\\no NULL ON ERROR"
  ": JSON_VALUE() returns NULL; this is the default\\n  behavior if no ON ERROR clause is used.\\n\\no DEFAULT value ON ERR"
  "OR: This is the value returned; its value must\\n  match that of the return type.\\n\\no ERROR ON ERROR: An error is thr"
  "own.\\n\\nON EMPTY, if used, must precede any ON ERROR clause. Specifying them in\\nthe wrong order results in a syntax "
  "error.\\n\\nError handling In general, errors are handled by JSON_VALUE() as\\nfollows:\\n\\no All JSON input (document an"
  "d path) is checked for validity. If any of\\n  it is not valid, an SQL error is thrown without triggering the ON\\n  ER"
  "ROR clause.\\n\\no ON ERROR is triggered whenever any of the following events occur:\\n\\n  o Attempting to extract an ob"
  "ject or an array, such as that resulting\\n    from a path that resolves to multiple locations within the JSON\\n    do"
  "cument\\n\\n  o Conversion errors, such as attempting to convert \\'asdf\\' to an\\n    UNSIGNED value\\n\\n  o Truncation o"
  "f values\\n\\no A conversion error always triggers a warning even if NULL ON ERROR or\\n  DEFAULT ... ON ERROR is specif"
  "ied.\\n\\no The ON EMPTY clause is triggered when the source JSON document (expr)\\n  contains no data at the specified "
  "location (path).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html\\n\\n','mysql> SELECT JSON_"
  "VALUE(\\'{\"fname\": \"Joe\", \"lname\": \"Palmer\"}\\', \\'$.fname\\');\\n+----------------------------------------------"
  "----------------+\\n| JSON_VALUE(\\'{\"fname\": \"Joe\", \"lname\": \"Palmer\"}\\', \\'$.fname\\') |\\n+-------------------"
  "-------------------------------------------+\\n| Joe                                                          |\\n+----"
  "----------------------------------------------------------+\\n\\nmysql> SELECT JSON_VALUE(\\'{\"item\": \"shoes\", \"pri"
  "ce\": \"49.95\"}\\', \\'$.price\\'\\n    -> RETURNING DECIMAL(4,2)) AS price;\\n+-------+\\n| price |\\n+-------+\\n| 49.95 |"
  "\\n+-------+\\n\\nSELECT CAST(\\n    JSON_UNQUOTE( JSON_EXTRACT(json_doc, path) )\\n    AS type\\n);\\n\\nCREATE TABLE t1(\\n "
  "   j JSON,\\n    INDEX i1 ( (JSON_VALUE(j, \\'$.id\\' RETURNING UNSIGNED)) )\\n);\\n\\nmysql> EXPLAIN SELECT * FROM t1\\n   "
  " ->     WHERE JSON_VALUE(j, \\'$.id\\' RETURNING UNSIGNED) = 123\\\\G\\n*************************** 1. row ***************"
  "************\\n           id: 1\\n  select_type: SIMPLE\\n        table: t1\\n   partitions: NULL\\n         type: ref\\npo"
  "ssible_keys: i1\\n          key: i1\\n      key_len: 9\\n          ref: const\\n         rows: 1\\n     filtered: 100.00\\n"
  "        Extra: NULL\\n\\nCREATE TABLE t2 (\\n    j JSON,\\n    g INT GENERATED ALWAYS AS (j->\"$.id\"),\\n    INDEX i1 (g)"
  "\\n);\\n\\nmysql> EXPLAIN SELECT * FROM t2 WHERE g  = 123\\\\G\\n*************************** 1. row ***********************"
  "****\\n           id: 1\\n  select_type: SIMPLE\\n        table: t2\\n   partitions: NULL\\n         type: ref\\npossible_k"
  "eys: i1\\n          key: i1\\n      key_len: 5\\n          ref: const\\n         rows: 1\\n     filtered: 100.00\\n        "
  "Extra: NULL\\n','https://dev.mysql.com/doc/refman/8.4/en/json-search-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (393,32,'MEMBER OF','Syntax:"
  "\\nvalue MEMBER OF(json_array)\\n\\nReturns true (1) if value is an element of json_array, otherwise\\nreturns false (0)."
  " value must be a scalar or a JSON document; if it is\\na scalar, the operator attempts to treat it as an element of a "
  "JSON\\narray. If value or json_array is NULL, the function returns NULL.\\n\\nQueries using MEMBER OF() on JSON columns "
  "of InnoDB tables in the WHERE\\nclause can be optimized using multi-valued indexes. See\\nhttps://dev.mysql.com/doc/ref"
  "man/8.4/en/create-index.html#create-index-\\nmulti-valued, for detailed information and examples.\\n\\nURL: https://dev."
  "mysql.com/doc/refman/8.4/en/json-search-functions.html\\n\\n','mysql> SELECT 17 MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 1"
  "0]\\');\\n+-------------------------------------------+\\n| 17 MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\') |\\n+--------"
  "-----------------------------------+\\n|                                         1 |\\n+-------------------------------"
  "------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT \\'ab\\' MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\');\\n+------"
  "---------------------------------------+\\n| \\'ab\\' MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\') |\\n+-----------------"
  "----------------------------+\\n|                                           1 |\\n+------------------------------------"
  "---------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT 7 MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\');\\n+--------------"
  "----------------------------+\\n| 7 MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\') |\\n+---------------------------------"
  "---------+\\n|                                        0 |\\n+------------------------------------------+\\n1 row in set "
  "(0.00 sec)\\n\\nmysql> SELECT \\'a\\' MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\');\\n+-----------------------------------"
  "---------+\\n| \\'a\\' MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\') |\\n+--------------------------------------------+\\n|"
  "                                          0 |\\n+--------------------------------------------+\\n1 row in set (0.00 sec"
  ")\\n\\nmysql> SELECT\\n    -> 17 MEMBER OF(\\'[23, \"abc\", \"17\", \"ab\", 10]\\'),\\n    -> \"17\" MEMBER OF(\\'[23, \"abc"
  "\", 17, \"ab\", 10]\\')\\\\G\\n*************************** 1. row ***************************\\n17 MEMBER OF(\\'[23, \"abc\""
  ", \"17\", \"ab\", 10]\\'): 0\\n\"17\" MEMBER OF(\\'[23, \"abc\", 17, \"ab\", 10]\\'): 0\\n1 row in set (0.00 sec)\\n\\nmysql"
  "> SELECT CAST(\\'[4,5]\\' AS JSON) MEMBER OF(\\'[[3,4],[4,5]]\\');\\n+--------------------------------------------------+\\"
  "n| CAST(\\'[4,5]\\' AS JSON) MEMBER OF(\\'[[3,4],[4,5]]\\') |\\n+--------------------------------------------------+\\n|   "
  "                                             1 |\\n+--------------------------------------------------+\\n1 row in set "
  "(0.00 sec)\\n\\nmysql> SELECT JSON_ARRAY(4,5) MEMBER OF(\\'[[3,4],[4,5]]\\');\\n+-----------------------------------------"
  "---+\\n| JSON_ARRAY(4,5) MEMBER OF(\\'[[3,4],[4,5]]\\') |\\n+--------------------------------------------+\\n|            "
  "                              1 |\\n+--------------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> "
  "SET @a = CAST(\\'{\"a\":1}\\' AS JSON);\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SET @b = JSON_OBJECT(\"b\", 2);"
  "\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SET @c = JSON_ARRAY(17, @b, \"abc\", @a, 23);\\nQuery OK, 0 rows affe"
  "cted (0.00 sec)\\n\\nmysql> SELECT @a MEMBER OF(@c), @b MEMBER OF(@c);\\n+------------------+------------------+\\n| @a M"
  "EMBER OF(@c) | @b MEMBER OF(@c) |\\n+------------------+------------------+\\n|                1 |                1 |\\n"
  "+------------------+------------------+\\n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/json-sea"
  "rch-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (394,32,'JSON_ARRAY_APPEND',"
  "'Syntax:\\nJSON_ARRAY_APPEND(json_doc, path, val[, path, val] ...)\\n\\nAppends values to the end of the indicated array"
  "s within a JSON\\ndocument and returns the result. Returns NULL if any argument is NULL.\\nAn error occurs if the json_"
  "doc argument is not a valid JSON document\\nor any path argument is not a valid path expression or contains a * or\\n**"
  " wildcard.\\n\\nThe path-value pairs are evaluated left to right. The document produced\\nby evaluating one pair becomes"
  " the new value against which the next\\npair is evaluated.\\n\\nIf a path selects a scalar or object value, that value i"
  "s autowrapped\\nwithin an array and the new value is added to that array. Pairs for\\nwhich the path does not identify "
  "any value in the JSON document are\\nignored.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modification-functi"
  "ons.html\\n\\n','mysql> SET @j = \\'[\"a\", [\"b\", \"c\"], \"d\"]\\';\\nmysql> SELECT JSON_ARRAY_APPEND(@j, \\'$[1]\\', 1);"
  "\\n+----------------------------------+\\n| JSON_ARRAY_APPEND(@j, \\'$[1]\\', 1) |\\n+----------------------------------+\\"
  "n| [\"a\", [\"b\", \"c\", 1], \"d\"]        |\\n+----------------------------------+\\nmysql> SELECT JSON_ARRAY_APPEND("
  "@j, \\'$[0]\\', 2);\\n+----------------------------------+\\n| JSON_ARRAY_APPEND(@j, \\'$[0]\\', 2) |\\n+-------------------"
  "---------------+\\n| [[\"a\", 2], [\"b\", \"c\"], \"d\"]      |\\n+----------------------------------+\\nmysql> SELECT J"
  "SON_ARRAY_APPEND(@j, \\'$[1][0]\\', 3);\\n+-------------------------------------+\\n| JSON_ARRAY_APPEND(@j, \\'$[1][0]\\', "
  "3) |\\n+-------------------------------------+\\n| [\"a\", [[\"b\", 3], \"c\"], \"d\"]         |\\n+--------------------"
  "-----------------+\\n\\nmysql> SET @j = \\'{\"a\": 1, \"b\": [2, 3], \"c\": 4}\\';\\nmysql> SELECT JSON_ARRAY_APPEND(@j, \\"
  "'$.b\\', \\'x\\');\\n+------------------------------------+\\n| JSON_ARRAY_APPEND(@j, \\'$.b\\', \\'x\\')  |\\n+---------------"
  "---------------------+\\n| {\"a\": 1, \"b\": [2, 3, \"x\"], \"c\": 4} |\\n+------------------------------------+\\nmysql"
  "> SELECT JSON_ARRAY_APPEND(@j, \\'$.c\\', \\'y\\');\\n+--------------------------------------+\\n| JSON_ARRAY_APPEND(@j, \\'"
  "$.c\\', \\'y\\')    |\\n+--------------------------------------+\\n| {\"a\": 1, \"b\": [2, 3], \"c\": [4, \"y\"]} |\\n+----"
  "----------------------------------+\\n\\nmysql> SET @j = \\'{\"a\": 1}\\';\\nmysql> SELECT JSON_ARRAY_APPEND(@j, \\'$\\', \\'"
  "z\\');\\n+---------------------------------+\\n| JSON_ARRAY_APPEND(@j, \\'$\\', \\'z\\') |\\n+-------------------------------"
  "--+\\n| [{\"a\": 1}, \"z\"]                 |\\n+---------------------------------+\\n','https://dev.mysql.com/doc/refma"
  "n/8.4/en/json-modification-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (395,32,'JSON_ARRAY_INSERT',"
  "'Syntax:\\nJSON_ARRAY_INSERT(json_doc, path, val[, path, val] ...)\\n\\nUpdates a JSON document, inserting into an array"
  " within the document\\nand returning the modified document. Returns NULL if any argument is\\nNULL. An error occurs if "
  "the json_doc argument is not a valid JSON\\ndocument or any path argument is not a valid path expression or\\ncontains "
  "a * or ** wildcard or does not end with an array element\\nidentifier.\\n\\nThe path-value pairs are evaluated left to r"
  "ight. The document produced\\nby evaluating one pair becomes the new value against which the next\\npair is evaluated.\\"
  "n\\nPairs for which the path does not identify any array in the JSON\\ndocument are ignored. If a path identifies an ar"
  "ray element, the\\ncorresponding value is inserted at that element position, shifting any\\nfollowing values to the rig"
  "ht. If a path identifies an array position\\npast the end of an array, the value is inserted at the end of the\\narray."
  "\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> SET @j = \\'[\"a\", {\""
  "b\": [1, 2]}, [3, 4]]\\';\\nmysql> SELECT JSON_ARRAY_INSERT(@j, \\'$[1]\\', \\'x\\');\\n+-----------------------------------"
  "-+\\n| JSON_ARRAY_INSERT(@j, \\'$[1]\\', \\'x\\') |\\n+------------------------------------+\\n| [\"a\", \"x\", {\"b\": [1, "
  "2]}, [3, 4]]  |\\n+------------------------------------+\\nmysql> SELECT JSON_ARRAY_INSERT(@j, \\'$[100]\\', \\'x\\');\\n+--"
  "------------------------------------+\\n| JSON_ARRAY_INSERT(@j, \\'$[100]\\', \\'x\\') |\\n+-------------------------------"
  "-------+\\n| [\"a\", {\"b\": [1, 2]}, [3, 4], \"x\"]    |\\n+--------------------------------------+\\nmysql> SELECT JSO"
  "N_ARRAY_INSERT(@j, \\'$[1].b[0]\\', \\'x\\');\\n+-----------------------------------------+\\n| JSON_ARRAY_INSERT(@j, \\'$[1"
  "].b[0]\\', \\'x\\') |\\n+-----------------------------------------+\\n| [\"a\", {\"b\": [\"x\", 1, 2]}, [3, 4]]       |\\n+"
  "-----------------------------------------+\\nmysql> SELECT JSON_ARRAY_INSERT(@j, \\'$[2][1]\\', \\'y\\');\\n+--------------"
  "-------------------------+\\n| JSON_ARRAY_INSERT(@j, \\'$[2][1]\\', \\'y\\') |\\n+---------------------------------------+\\"
  "n| [\"a\", {\"b\": [1, 2]}, [3, \"y\", 4]]     |\\n+---------------------------------------+\\nmysql> SELECT JSON_ARRAY"
  "_INSERT(@j, \\'$[0]\\', \\'x\\', \\'$[2][1]\\', \\'y\\');\\n+----------------------------------------------------+\\n| JSON_ARR"
  "AY_INSERT(@j, \\'$[0]\\', \\'x\\', \\'$[2][1]\\', \\'y\\') |\\n+----------------------------------------------------+\\n| [\"x\""
  ", \"a\", {\"b\": [1, 2]}, [3, 4]]                  |\\n+----------------------------------------------------+\\n','http"
  "s://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (396,32,'JSON_INSERT','Synta"
  "x:\\nJSON_INSERT(json_doc, path, val[, path, val] ...)\\n\\nInserts data into a JSON document and returns the result. Re"
  "turns NULL\\nif any argument is NULL. An error occurs if the json_doc argument is\\nnot a valid JSON document or any pa"
  "th argument is not a valid path\\nexpression or contains a * or ** wildcard.\\n\\nThe path-value pairs are evaluated lef"
  "t to right. The document produced\\nby evaluating one pair becomes the new value against which the next\\npair is evalu"
  "ated.\\n\\nA path-value pair for an existing path in the document is ignored and\\ndoes not overwrite the existing docum"
  "ent value. A path-value pair for a\\nnonexisting path in the document adds the value to the document if the\\npath iden"
  "tifies one of these types of values:\\n\\no A member not present in an existing object. The member is added to\\n  the o"
  "bject and associated with the new value.\\n\\no A position past the end of an existing array. The array is extended\\n  "
  "with the new value. If the existing value is not an array, it is\\n  autowrapped as an array, then extended with the n"
  "ew value.\\n\\nOtherwise, a path-value pair for a nonexisting path in the document is\\nignored and has no effect.\\n\\nFo"
  "r a comparison of JSON_INSERT(), JSON_REPLACE(), and JSON_SET(), see\\nthe discussion of JSON_SET().\\n\\nURL: https://d"
  "ev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> SET @j = \\'{ \"a\": 1, \"b\": [2, 3]}\\';"
  "\\nmysql> SELECT JSON_INSERT(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\');\\n+-----------------------------------------"
  "-----------+\\n| JSON_INSERT(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\') |\\n+----------------------------------------"
  "------------+\\n| {\"a\": 1, \"b\": [2, 3], \"c\": \"[true, false]\"}        |\\n+-------------------------------------"
  "---------------+\\n\\nmysql> SELECT JSON_INSERT(@j, \\'$.a\\', 10, \\'$.c\\', CAST(\\'[true, false]\\' AS JSON));\\n+---------"
  "---------------------------------------------------------+\\n| JSON_INSERT(@j, \\'$.a\\', 10, \\'$.c\\', CAST(\\'[true, fal"
  "se]\\' AS JSON)) |\\n+------------------------------------------------------------------+\\n| {\"a\": 1, \"b\": [2, 3], "
  "\"c\": [true, false]}                        |\\n+------------------------------------------------------------------+\\"
  "n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (397,32,'JSON_MERGE','Syntax"
  ":\\nJSON_MERGE(json_doc, json_doc[, json_doc] ...)\\n\\nDeprecated synonym for JSON_MERGE_PRESERVE().\\n\\nURL: https://de"
  "v.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/json-"
  "modification-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (398,32,'JSON_MERGE_PATCH()'"
  ",'Syntax:\\nJSON_MERGE_PATCH(json_doc, json_doc[, json_doc] ...)\\n\\nPerforms an RFC 7396 (https://tools.ietf.org/html/"
  "rfc7396) compliant\\nmerge of two or more JSON documents and returns the merged result,\\nwithout preserving members ha"
  "ving duplicate keys. Raises an error if at\\nleast one of the documents passed as arguments to this function is not\\nv"
  "alid.\\n\\n*Note*:\\n\\nFor an explanation and example of the differences between this function\\nand JSON_MERGE_PRESERVE("
  "), see\\nhttps://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n#json-merge-patch-json-merge-preser"
  "ve-compared.\\n\\nJSON_MERGE_PATCH() performs a merge as follows:\\n\\n1. If the first argument is not an object, the res"
  "ult of the merge is\\n   the same as if an empty object had been merged with the second\\n   argument.\\n\\n2. If the sec"
  "ond argument is not an object, the result of the merge is\\n   the second argument.\\n\\n3. If both arguments are object"
  "s, the result of the merge is an object\\n   with the following members:\\n\\n  o All members of the first object which "
  "do not have a corresponding\\n    member with the same key in the second object.\\n\\n  o All members of the second obje"
  "ct which do not have a corresponding\\n    key in the first object, and whose value is not the JSON null\\n    literal."
  "\\n\\n  o All members with a key that exists in both the first and the second\\n    object, and whose value in the secon"
  "d object is not the JSON null\\n    literal. The values of these members are the results of recursively\\n    merging t"
  "he value in the first object with the value in the second\\n    object.\\n\\nFor additional information, see\\nhttps://de"
  "v.mysql.com/doc/refman/8.4/en/json.html#json-normalization.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modi"
  "fication-functions.html\\n\\n','mysql> SELECT JSON_MERGE_PATCH(\\'[1, 2]\\', \\'[true, false]\\');\\n+----------------------"
  "-----------------------+\\n| JSON_MERGE_PATCH(\\'[1, 2]\\', \\'[true, false]\\') |\\n+-------------------------------------"
  "--------+\\n| [true, false]                               |\\n+---------------------------------------------+\\n\\nmysql>"
  " SELECT JSON_MERGE_PATCH(\\'{\"name\": \"x\"}\\', \\'{\"id\": 47}\\');\\n+------------------------------------------------"
  "-+\\n| JSON_MERGE_PATCH(\\'{\"name\": \"x\"}\\', \\'{\"id\": 47}\\') |\\n+-------------------------------------------------"
  "+\\n| {\"id\": 47, \"name\": \"x\"}                         |\\n+-------------------------------------------------+\\n\\n"
  "mysql> SELECT JSON_MERGE_PATCH(\\'1\\', \\'true\\');\\n+-------------------------------+\\n| JSON_MERGE_PATCH(\\'1\\', \\'true"
  "\\') |\\n+-------------------------------+\\n| true                          |\\n+-------------------------------+\\n\\nmys"
  "ql> SELECT JSON_MERGE_PATCH(\\'[1, 2]\\', \\'{\"id\": 47}\\');\\n+------------------------------------------+\\n| JSON_MERG"
  "E_PATCH(\\'[1, 2]\\', \\'{\"id\": 47}\\') |\\n+------------------------------------------+\\n| {\"id\": 47}                "
  "               |\\n+------------------------------------------+\\n\\nmysql> SELECT JSON_MERGE_PATCH(\\'{ \"a\": 1, \"b\":"
  "2 }\\',\\n     >     \\'{ \"a\": 3, \"c\":4 }\\');\\n+-----------------------------------------------------------+\\n| JSON"
  "_MERGE_PATCH(\\'{ \"a\": 1, \"b\":2 }\\',\\'{ \"a\": 3, \"c\":4 }\\') |\\n+-----------------------------------------------"
  "------------+\\n| {\"a\": 3, \"b\": 2, \"c\": 4}                                  |\\n+--------------------------------"
  "---------------------------+\\n\\nmysql> SELECT JSON_MERGE_PATCH(\\'{ \"a\": 1, \"b\":2 }\\',\\'{ \"a\": 3, \"c\":4 }\\',\\n"
  "     >     \\'{ \"a\": 5, \"d\":6 }\\');\\n+----------------------------------------------------------------------------"
  "---+\\n| JSON_MERGE_PATCH(\\'{ \"a\": 1, \"b\":2 }\\',\\'{ \"a\": 3, \"c\":4 }\\',\\'{ \"a\": 5, \"d\":6 }\\') |\\n+---------"
  "----------------------------------------------------------------------+\\n| {\"a\": 5, \"b\": 2, \"c\": 4, \"d\": 6}  "
  "                                            |\\n+---------------------------------------------------------------------"
  "----------+\\n\\nmysql> SELECT JSON_MERGE_PATCH(\\'{\"a\":1, \"b\":2}\\', \\'{\"b\":null}\\');\\n+--------------------------"
  "------------------------+\\n| JSON_MERGE_PATCH(\\'{\"a\":1, \"b\":2}\\', \\'{\"b\":null}\\') |\\n+-------------------------"
  "-------------------------+\\n| {\"a\": 1}                                         |\\n+--------------------------------"
  "------------------+\\n\\nmysql> SELECT JSON_MERGE_PATCH(\\'{\"a\":{\"x\":1}}\\', \\'{\"a\":{\"y\":2}}\\');\\n+--------------"
  "--------------------------------------+\\n| JSON_MERGE_PATCH(\\'{\"a\":{\"x\":1}}\\', \\'{\"a\":{\"y\":2}}\\') |\\n+-------"
  "---------------------------------------------+\\n| {\"a\": {\"x\": 1, \"y\": 2}}                            |\\n+------"
  "----------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-modification-functio"
  "ns.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (399,32,'JSON_MERGE_PRESERVE"
  "()','Syntax:\\nJSON_MERGE_PRESERVE(json_doc, json_doc[, json_doc] ...)\\n\\nMerges two or more JSON documents and return"
  "s the merged result.\\nReturns NULL if any argument is NULL. An error occurs if any argument\\nis not a valid JSON docu"
  "ment.\\n\\nMerging takes place according to the following rules. For additional\\ninformation, see\\nhttps://dev.mysql.co"
  "m/doc/refman/8.4/en/json.html#json-normalization.\\n\\no Adjacent arrays are merged to a single array.\\n\\no Adjacent ob"
  "jects are merged to a single object.\\n\\no A scalar value is autowrapped as an array and merged as an array.\\n\\no An a"
  "djacent array and object are merged by autowrapping the object as\\n  an array and merging the two arrays.\\n\\nURL: htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> SELECT JSON_MERGE_PRESERVE(\\'[1, 2"
  "]\\', \\'[true, false]\\');\\n+------------------------------------------------+\\n| JSON_MERGE_PRESERVE(\\'[1, 2]\\', \\'[tr"
  "ue, false]\\') |\\n+------------------------------------------------+\\n| [1, 2, true, false]                           "
  " |\\n+------------------------------------------------+\\n\\nmysql> SELECT JSON_MERGE_PRESERVE(\\'{\"name\": \"x\"}\\', \\'"
  "{\"id\": 47}\\');\\n+----------------------------------------------------+\\n| JSON_MERGE_PRESERVE(\\'{\"name\": \"x\"}\\'"
  ", \\'{\"id\": 47}\\') |\\n+----------------------------------------------------+\\n| {\"id\": 47, \"name\": \"x\"}       "
  "                     |\\n+----------------------------------------------------+\\n\\nmysql> SELECT JSON_MERGE_PRESERVE(\\"
  "'1\\', \\'true\\');\\n+----------------------------------+\\n| JSON_MERGE_PRESERVE(\\'1\\', \\'true\\') |\\n+------------------"
  "----------------+\\n| [1, true]                        |\\n+----------------------------------+\\n\\nmysql> SELECT JSON_M"
  "ERGE_PRESERVE(\\'[1, 2]\\', \\'{\"id\": 47}\\');\\n+---------------------------------------------+\\n| JSON_MERGE_PRESERVE("
  "\\'[1, 2]\\', \\'{\"id\": 47}\\') |\\n+---------------------------------------------+\\n| [1, 2, {\"id\": 47}]             "
  "             |\\n+---------------------------------------------+\\n\\nmysql> SELECT JSON_MERGE_PRESERVE(\\'{ \"a\": 1, \""
  "b\": 2 }\\',\\n     >    \\'{ \"a\": 3, \"c\": 4 }\\');\\n+--------------------------------------------------------------+"
  "\\n| JSON_MERGE_PRESERVE(\\'{ \"a\": 1, \"b\": 2 }\\',\\'{ \"a\": 3, \"c\":4 }\\') |\\n+-----------------------------------"
  "---------------------------+\\n| {\"a\": [1, 3], \"b\": 2, \"c\": 4}                                |\\n+--------------"
  "------------------------------------------------+\\n\\nmysql> SELECT JSON_MERGE_PRESERVE(\\'{ \"a\": 1, \"b\": 2 }\\',\\'{"
  " \"a\": 3, \"c\": 4 }\\',\\n     >    \\'{ \"a\": 5, \"d\": 6 }\\');\\n+--------------------------------------------------"
  "--------------------------------+\\n| JSON_MERGE_PRESERVE(\\'{ \"a\": 1, \"b\": 2 }\\',\\'{ \"a\": 3, \"c\": 4 }\\',\\'{ \""
  "a\": 5, \"d\": 6 }\\') |\\n+----------------------------------------------------------------------------------+\\n| {\"a"
  "\": [1, 3, 5], \"b\": 2, \"c\": 4, \"d\": 6}                                         |\\n+----------------------------"
  "------------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-modification"
  "-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (400,32,'JSON_REMOVE','Synta"
  "x:\\nJSON_REMOVE(json_doc, path[, path] ...)\\n\\nRemoves data from a JSON document and returns the result. Returns NULL"
  "\\nif any argument is NULL. An error occurs if the json_doc argument is\\nnot a valid JSON document or any path argumen"
  "t is not a valid path\\nexpression or is $ or contains a * or ** wildcard.\\n\\nThe path arguments are evaluated left to"
  " right. The document produced\\nby evaluating one path becomes the new value against which the next\\npath is evaluated"
  ".\\n\\nIt is not an error if the element to be removed does not exist in the\\ndocument; in that case, the path does not"
  " affect the document.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> S"
  "ET @j = \\'[\"a\", [\"b\", \"c\"], \"d\"]\\';\\nmysql> SELECT JSON_REMOVE(@j, \\'$[1]\\');\\n+-------------------------+\\n|"
  " JSON_REMOVE(@j, \\'$[1]\\') |\\n+-------------------------+\\n| [\"a\", \"d\"]              |\\n+------------------------"
  "-+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (401,32,'JSON_REPLACE','Synt"
  "ax:\\nJSON_REPLACE(json_doc, path, val[, path, val] ...)\\n\\nReplaces existing values in a JSON document and returns th"
  "e result.\\nReturns NULL if any argument is NULL. An error occurs if the json_doc\\nargument is not a valid JSON docume"
  "nt or any path argument is not a\\nvalid path expression or contains a * or ** wildcard.\\n\\nThe path-value pairs are e"
  "valuated left to right. The document produced\\nby evaluating one pair becomes the new value against which the next\\np"
  "air is evaluated.\\n\\nA path-value pair for an existing path in the document overwrites the\\nexisting document value w"
  "ith the new value. A path-value pair for a\\nnonexisting path in the document is ignored and has no effect.\\n\\nThe opt"
  "imizer can perform a partial, in-place update of a JSON column\\ninstead of removing the old document and writing the "
  "new document in\\nits entirety to the column. This optimization can be performed for an\\nupdate statement that uses th"
  "e JSON_REPLACE() function and meets the\\nconditions outlined in\\nhttps://dev.mysql.com/doc/refman/8.4/en/json.html#js"
  "on-partial-updates.\\n\\nFor a comparison of JSON_INSERT(), JSON_REPLACE(), and JSON_SET(), see\\nthe discussion of JSON"
  "_SET().\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> SET @j = \\'{ \""
  "a\": 1, \"b\": [2, 3]}\\';\\nmysql> SELECT JSON_REPLACE(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\');\\n+---------------"
  "--------------------------------------+\\n| JSON_REPLACE(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\') |\\n+------------"
  "-----------------------------------------+\\n| {\"a\": 10, \"b\": [2, 3]}                              |\\n+-----------"
  "------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (402,32,'JSON_SET','Syntax:\\"
  "nJSON_SET(json_doc, path, val[, path, val] ...)\\n\\nInserts or updates data in a JSON document and returns the result."
  "\\nReturns NULL if json_doc or path is NULL, or if path, when given, does\\nnot locate an object. Otherwise, an error o"
  "ccurs if the json_doc\\nargument is not a valid JSON document or any path argument is not a\\nvalid path expression or "
  "contains a * or ** wildcard.\\n\\nThe path-value pairs are evaluated left to right. The document produced\\nby evaluatin"
  "g one pair becomes the new value against which the next\\npair is evaluated.\\n\\nA path-value pair for an existing path"
  " in the document overwrites the\\nexisting document value with the new value. A path-value pair for a\\nnonexisting pat"
  "h in the document adds the value to the document if the\\npath identifies one of these types of values:\\n\\no A member "
  "not present in an existing object. The member is added to\\n  the object and associated with the new value.\\n\\no A pos"
  "ition past the end of an existing array. The array is extended\\n  with the new value. If the existing value is not an"
  " array, it is\\n  autowrapped as an array, then extended with the new value.\\n\\nOtherwise, a path-value pair for a non"
  "existing path in the document is\\nignored and has no effect.\\n\\nThe optimizer can perform a partial, in-place update "
  "of a JSON column\\ninstead of removing the old document and writing the new document in\\nits entirety to the column. T"
  "his optimization can be performed for an\\nupdate statement that uses the JSON_SET() function and meets the\\ncondition"
  "s outlined in\\nhttps://dev.mysql.com/doc/refman/8.4/en/json.html#json-partial-updates.\\n\\nThe JSON_SET(), JSON_INSERT"
  "(), and JSON_REPLACE() functions are\\nrelated:\\n\\no JSON_SET() replaces existing values and adds nonexisting values.\\"
  "n\\no JSON_INSERT() inserts values without replacing existing values.\\n\\no JSON_REPLACE() replaces only existing value"
  "s.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> SET @j = \\'{ \"a\": "
  "1, \"b\": [2, 3]}\\';\\nmysql> SELECT JSON_SET(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\');\\n+------------------------"
  "-------------------------+\\n| JSON_SET(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\') |\\n+-----------------------------"
  "--------------------+\\n| {\"a\": 10, \"b\": [2, 3], \"c\": \"[true, false]\"}    |\\n+--------------------------------"
  "-----------------+\\nmysql> SELECT JSON_INSERT(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\');\\n+-----------------------"
  "-----------------------------+\\n| JSON_INSERT(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\') |\\n+----------------------"
  "------------------------------+\\n| {\"a\": 1, \"b\": [2, 3], \"c\": \"[true, false]\"}        |\\n+-------------------"
  "---------------------------------+\\nmysql> SELECT JSON_REPLACE(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\');\\n+------"
  "-----------------------------------------------+\\n| JSON_REPLACE(@j, \\'$.a\\', 10, \\'$.c\\', \\'[true, false]\\') |\\n+---"
  "--------------------------------------------------+\\n| {\"a\": 10, \"b\": [2, 3]}                              |\\n+--"
  "---------------------------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-modification-fu"
  "nctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (403,32,'JSON_UNQUOTE','Synt"
  "ax:\\nJSON_UNQUOTE(json_val)\\n\\nUnquotes JSON value and returns the result as a utf8mb4 string. Returns\\nNULL if the a"
  "rgument is NULL. An error occurs if the value starts and\\nends with double quotes but is not a valid JSON string lite"
  "ral.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html\\n\\n','mysql> SET @j = \\'\"abc\""
  "\\';\\nmysql> SELECT @j, JSON_UNQUOTE(@j);\\n+-------+------------------+\\n| @j    | JSON_UNQUOTE(@j) |\\n+-------+------"
  "------------+\\n| \"abc\" | abc              |\\n+-------+------------------+\\nmysql> SET @j = \\'[1, 2, 3]\\';\\nmysql> S"
  "ELECT @j, JSON_UNQUOTE(@j);\\n+-----------+------------------+\\n| @j        | JSON_UNQUOTE(@j) |\\n+-----------+-------"
  "-----------+\\n| [1, 2, 3] | [1, 2, 3]        |\\n+-----------+------------------+\\n\\nmysql> SELECT @@sql_mode;\\n+-----"
  "-------+\\n| @@sql_mode |\\n+------------+\\n|            |\\n+------------+\\n\\nmysql> SELECT JSON_UNQUOTE(\\'\"\\\\\\\\t\\\\\\\\u"
  "0032\"\\');\\n+------------------------------+\\n| JSON_UNQUOTE(\\'\"\\\\\\\\t\\\\\\\\u0032\"\\') |\\n+----------------------------"
  "--+\\n|       2                           |\\n+------------------------------+\\n\\nmysql> SET @@sql_mode = \\'NO_BACKSLAS"
  "H_ESCAPES\\';\\nmysql> SELECT JSON_UNQUOTE(\\'\"\\\\\\\\t\\\\\\\\u0032\"\\');\\n+------------------------------+\\n| JSON_UNQUOTE(\\"
  "'\"\\\\\\\\t\\\\\\\\u0032\"\\') |\\n+------------------------------+\\n| \\\\t\\\\u0032                     |\\n+--------------------"
  "----------+\\n\\nmysql> SELECT JSON_UNQUOTE(\\'\"\\\\t\\\\u0032\"\\');\\n+----------------------------+\\n| JSON_UNQUOTE(\\'\"\\\\"
  "t\\\\u0032\"\\') |\\n+----------------------------+\\n|       2                         |\\n+----------------------------+\\"
  "n','https://dev.mysql.com/doc/refman/8.4/en/json-modification-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (404,32,'JSON_DEPTH','Syntax"
  ":\\nJSON_DEPTH(json_doc)\\n\\nReturns the maximum depth of a JSON document. Returns NULL if the\\nargument is NULL. An er"
  "ror occurs if the argument is not a valid JSON\\ndocument.\\n\\nAn empty array, empty object, or scalar value has depth "
  "1. A nonempty\\narray containing only elements of depth 1 or nonempty object containing\\nonly member values of depth 1"
  " has depth 2. Otherwise, a JSON document\\nhas depth greater than 2.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/j"
  "son-attribute-functions.html\\n\\n','mysql> SELECT JSON_DEPTH(\\'{}\\'), JSON_DEPTH(\\'[]\\'), JSON_DEPTH(\\'true\\');\\n+----"
  "--------------+------------------+--------------------+\\n| JSON_DEPTH(\\'{}\\') | JSON_DEPTH(\\'[]\\') | JSON_DEPTH(\\'tru"
  "e\\') |\\n+------------------+------------------+--------------------+\\n|                1 |                1 |        "
  "          1 |\\n+------------------+------------------+--------------------+\\nmysql> SELECT JSON_DEPTH(\\'[10, 20]\\'), "
  "JSON_DEPTH(\\'[[], {}]\\');\\n+------------------------+------------------------+\\n| JSON_DEPTH(\\'[10, 20]\\') | JSON_DEP"
  "TH(\\'[[], {}]\\') |\\n+------------------------+------------------------+\\n|                      2 |                  "
  "    2 |\\n+------------------------+------------------------+\\nmysql> SELECT JSON_DEPTH(\\'[10, {\"a\": 20}]\\');\\n+----"
  "---------------------------+\\n| JSON_DEPTH(\\'[10, {\"a\": 20}]\\') |\\n+-------------------------------+\\n|            "
  "                 3 |\\n+-------------------------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-attribute-fu"
  "nctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (405,32,'JSON_LENGTH','Synta"
  "x:\\nJSON_LENGTH(json_doc[, path])\\n\\nReturns the length of a JSON document, or, if a path argument is given,\\nthe len"
  "gth of the value within the document identified by the path.\\nReturns NULL if any argument is NULL or the path argume"
  "nt does not\\nidentify a value in the document. An error occurs if the json_doc\\nargument is not a valid JSON document"
  " or the path argument is not a\\nvalid path expression.\\n\\nThe length of a document is determined as follows:\\n\\no The"
  " length of a scalar is 1.\\n\\no The length of an array is the number of array elements.\\n\\no The length of an object i"
  "s the number of object members.\\n\\no The length does not count the length of nested arrays or objects.\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/json-attribute-functions.html\\n\\n','mysql> SELECT JSON_LENGTH(\\'[1, 2, {\"a\": 3}]\\"
  "');\\n+---------------------------------+\\n| JSON_LENGTH(\\'[1, 2, {\"a\": 3}]\\') |\\n+---------------------------------"
  "+\\n|                               3 |\\n+---------------------------------+\\nmysql> SELECT JSON_LENGTH(\\'{\"a\": 1, \""
  "b\": {\"c\": 30}}\\');\\n+-----------------------------------------+\\n| JSON_LENGTH(\\'{\"a\": 1, \"b\": {\"c\": 30}}\\')"
  " |\\n+-----------------------------------------+\\n|                                       2 |\\n+----------------------"
  "-------------------+\\nmysql> SELECT JSON_LENGTH(\\'{\"a\": 1, \"b\": {\"c\": 30}}\\', \\'$.b\\');\\n+---------------------"
  "---------------------------+\\n| JSON_LENGTH(\\'{\"a\": 1, \"b\": {\"c\": 30}}\\', \\'$.b\\') |\\n+------------------------"
  "------------------------+\\n|                                              1 |\\n+-------------------------------------"
  "-----------+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-attribute-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (406,32,'JSON_TYPE','Syntax:"
  "\\nJSON_TYPE(json_val)\\n\\nReturns a utf8mb4 string indicating the type of a JSON value. This can\\nbe an object, an arr"
  "ay, or a scalar type, as shown here:\\n\\nmysql> SET @j = \\'{\"a\": [10, true]}\\';\\nmysql> SELECT JSON_TYPE(@j);\\n+----"
  "-----------+\\n| JSON_TYPE(@j) |\\n+---------------+\\n| OBJECT        |\\n+---------------+\\nmysql> SELECT JSON_TYPE(JSO"
  "N_EXTRACT(@j, \\'$.a\\'));\\n+------------------------------------+\\n| JSON_TYPE(JSON_EXTRACT(@j, \\'$.a\\')) |\\n+--------"
  "----------------------------+\\n| ARRAY                              |\\n+------------------------------------+\\nmysql>"
  " SELECT JSON_TYPE(JSON_EXTRACT(@j, \\'$.a[0]\\'));\\n+---------------------------------------+\\n| JSON_TYPE(JSON_EXTRACT"
  "(@j, \\'$.a[0]\\')) |\\n+---------------------------------------+\\n| INTEGER                               |\\n+---------"
  "------------------------------+\\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \\'$.a[1]\\'));\\n+---------------------------"
  "------------+\\n| JSON_TYPE(JSON_EXTRACT(@j, \\'$.a[1]\\')) |\\n+---------------------------------------+\\n| BOOLEAN     "
  "                          |\\n+---------------------------------------+\\n\\nJSON_TYPE() returns NULL if the argument is"
  " NULL:\\n\\nmysql> SELECT JSON_TYPE(NULL);\\n+-----------------+\\n| JSON_TYPE(NULL) |\\n+-----------------+\\n| NULL      "
  "      |\\n+-----------------+\\n\\nAn error occurs if the argument is not a valid JSON value:\\n\\nmysql> SELECT JSON_TYPE"
  "(1);\\nERROR 3146 (22032): Invalid data type for JSON data in argument 1\\nto function json_type; a JSON string or JSON"
  " type is required.\\n\\nFor a non-NULL, non-error result, the following list describes the\\npossible JSON_TYPE() return"
  " values:\\n\\no Purely JSON types:\\n\\n  o OBJECT: JSON objects\\n\\n  o ARRAY: JSON arrays\\n\\n  o BOOLEAN: The JSON true "
  "and false literals\\n\\n  o NULL: The JSON null literal\\n\\no Numeric types:\\n\\n  o INTEGER: MySQL TINYINT, SMALLINT, ME"
  "DIUMINT and INT and BIGINT\\n    scalars\\n\\n  o DOUBLE: MySQL DOUBLE FLOAT scalars\\n\\n  o DECIMAL: MySQL DECIMAL and N"
  "UMERIC scalars\\n\\no Temporal types:\\n\\n  o DATETIME: MySQL DATETIME and TIMESTAMP scalars\\n\\n  o DATE: MySQL DATE sca"
  "lars\\n\\n  o TIME: MySQL TIME scalars\\n\\no String types:\\n\\n  o STRING: MySQL utf8mb3 character type scalars: CHAR, VA"
  "RCHAR, TEXT,\\n    ENUM, and SET\\n\\no Binary types:\\n\\n  o BLOB: MySQL binary type scalars including BINARY, VARBINARY"
  ", BLOB,\\n    and BIT\\n\\no All other types:\\n\\n  o OPAQUE (raw bits)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/j"
  "son-attribute-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/json-attribute-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (407,32,'JSON_VALID','Syntax"
  ":\\nJSON_VALID(val)\\n\\nReturns 0 or 1 to indicate whether a value is valid JSON. Returns NULL\\nif the argument is NULL"
  ".\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-attribute-functions.html\\n\\n','mysql> SELECT JSON_VALID(\\'{\"a"
  "\": 1}\\');\\n+------------------------+\\n| JSON_VALID(\\'{\"a\": 1}\\') |\\n+------------------------+\\n|                "
  "      1 |\\n+------------------------+\\nmysql> SELECT JSON_VALID(\\'hello\\'), JSON_VALID(\\'\"hello\"\\');\\n+------------"
  "---------+-----------------------+\\n| JSON_VALID(\\'hello\\') | JSON_VALID(\\'\"hello\"\\') |\\n+---------------------+---"
  "--------------------+\\n|                   0 |                     1 |\\n+---------------------+----------------------"
  "-+\\n','https://dev.mysql.com/doc/refman/8.4/en/json-attribute-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (408,32,'JSON_TABLE','Syntax"
  ":\\nJSON_TABLE(expr, path COLUMNS (column_list) [AS] alias)\\n\\nExtracts data from a JSON document and returns it as a "
  "relational table\\nhaving the specified columns. The complete syntax for this function is\\nshown here:\\n\\nJSON_TABLE(\\"
  "n    expr,\\n    path COLUMNS (column_list)\\n)   [AS] alias\\n\\ncolumn_list:\\n    column[, column][, ...]\\n\\ncolumn:\\n "
  "   name FOR ORDINALITY\\n    |  name type PATH string path [on_empty] [on_error]\\n    |  name type EXISTS PATH string "
  "path\\n    |  NESTED [PATH] path COLUMNS (column_list)\\n\\non_empty:\\n    {NULL | DEFAULT json_string | ERROR} ON EMPTY"
  "\\n\\non_error:\\n    {NULL | DEFAULT json_string | ERROR} ON ERROR\\n\\nexpr: This is an expression that returns JSON dat"
  "a. This can be a\\nconstant (\\'{\"a\":1}\\'), a column (t1.json_data, given table t1 specified\\nprior to JSON_TABLE() i"
  "n the FROM clause), or a function call\\n(JSON_EXTRACT(t1.json_data,\\'$.post.comments\\')).\\n\\npath: A JSON path expres"
  "sion, which is applied to the data source. We\\nrefer to the JSON value matching the path as the row source; this is\\n"
  "used to generate a row of relational data. The COLUMNS clause evaluates\\nthe row source, finds specific JSON values w"
  "ithin the row source, and\\nreturns those JSON values as SQL values in individual columns of a row\\nof relational data"
  ".\\n\\nThe alias is required. The usual rules for table aliases apply (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/ide"
  "ntifiers.html).\\n\\nThis function compares column names in case-insensitive fashion.\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/json-table-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/json-table-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (409,32,'JSON_SCHEMA_VALID',"
  "'JSON_SCHEMA_VALID(schema,document)\\n\\nValidates a JSON document against a JSON schema. Both schema and\\ndocument are"
  " required. The schema must be a valid JSON object; the\\ndocument must be a valid JSON document. Provided that these c"
  "onditions\\nare met: If the document validates against the schema, the function\\nreturns true (1); otherwise, it retur"
  "ns false (0).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-validation-functions.html\\n\\n','mysql> SET @schema"
  " = \\'{\\n    \\'>  \"id\": \"http://json-schema.org/geo\",\\n    \\'> \"$schema\": \"http://json-schema.org/draft-04/sche"
  "ma#\",\\n    \\'> \"description\": \"A geographical coordinate\",\\n    \\'> \"type\": \"object\",\\n    \\'> \"properties\""
  ": {\\n    \\'>   \"latitude\": {\\n    \\'>     \"type\": \"number\",\\n    \\'>     \"minimum\": -90,\\n    \\'>     \"maxim"
  "um\": 90\\n    \\'>   },\\n    \\'>   \"longitude\": {\\n    \\'>     \"type\": \"number\",\\n    \\'>     \"minimum\": -180,"
  "\\n    \\'>     \"maximum\": 180\\n    \\'>   }\\n    \\'> },\\n    \\'> \"required\": [\"latitude\", \"longitude\"]\\n    \\'>"
  "}\\';\\nQuery OK, 0 rows affected (0.01 sec)\\n\\nmysql> SET @document = \\'{\\n    \\'> \"latitude\": 63.444697,\\n    \\'> \""
  "longitude\": 10.445118\\n    \\'>}\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT JSON_SCHEMA_VALID(@schema,"
  " @document);\\n+---------------------------------------+\\n| JSON_SCHEMA_VALID(@schema, @document) |\\n+----------------"
  "-----------------------+\\n|                                     1 |\\n+---------------------------------------+\\n1 row"
  " in set (0.00 sec)\\n\\nmysql> SET @document = \\'{}\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT JSON_SCHE"
  "MA_VALID(@schema, @document);\\n+---------------------------------------+\\n| JSON_SCHEMA_VALID(@schema, @document) |\\n"
  "+---------------------------------------+\\n|                                     0 |\\n+------------------------------"
  "---------+\\n1 row in set (0.00 sec)\\n\\nmysql> SET @schema = \\'{\\n    \\'> \"id\": \"http://json-schema.org/geo\",\\n   "
  " \\'> \"$schema\": \"http://json-schema.org/draft-04/schema#\",\\n    \\'> \"description\": \"A geographical coordinate\""
  ",\\n    \\'> \"type\": \"object\",\\n    \\'> \"properties\": {\\n    \\'>   \"latitude\": {\\n    \\'>     \"type\": \"numbe"
  "r\",\\n    \\'>     \"minimum\": -90,\\n    \\'>     \"maximum\": 90\\n    \\'>   },\\n    \\'>   \"longitude\": {\\n    \\'>  "
  "   \"type\": \"number\",\\n    \\'>     \"minimum\": -180,\\n    \\'>     \"maximum\": 180\\n    \\'>   }\\n    \\'> }\\n    \\"
  "'>}\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\n\\nmysql> SELECT JSON_SCHEMA_VALID(@schema, @document);\\n+------------"
  "---------------------------+\\n| JSON_SCHEMA_VALID(@schema, @document) |\\n+---------------------------------------+\\n|"
  "                                     1 |\\n+---------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql"
  "> CREATE TABLE geo (\\n    ->     coordinate JSON,\\n    ->     CHECK(\\n    ->         JSON_SCHEMA_VALID(\\n    ->      "
  "       \\'{\\n    \\'>                 \"type\":\"object\",\\n    \\'>                 \"properties\":{\\n    \\'>          "
  "             \"latitude\":{\"type\":\"number\", \"minimum\":-90, \"maximum\":90},\\n    \\'>                       \"lo"
  "ngitude\":{\"type\":\"number\", \"minimum\":-180, \"maximum\":180}\\n    \\'>                 },\\n    \\'>              "
  "   \"required\": [\"latitude\", \"longitude\"]\\n    \\'>             }\\',\\n    ->             coordinate\\n    ->      "
  "   )\\n    ->     )\\n    -> );\\nQuery OK, 0 rows affected (0.45 sec)\\n\\nmysql> SET @point1 = \\'{\"latitude\":59, \"lon"
  "gitude\":18}\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SET @point2 = \\'{\"latitude\":91, \"longitude\":0}\\';"
  "\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SET @point3 = \\'{\"longitude\":120}\\';\\nQuery OK, 0 rows affected (0"
  ".00 sec)\\n\\nmysql> INSERT INTO geo VALUES(@point1);\\nQuery OK, 1 row affected (0.05 sec)\\n\\nmysql> INSERT INTO geo VA"
  "LUES(@point2);\\nERROR 3819 (HY000): Check constraint \\'geo_chk_1\\' is violated.\\n\\nmysql> SHOW WARNINGS\\\\G\\n*********"
  "****************** 1. row ***************************\\n  Level: Error\\n   Code: 3934\\nMessage: The JSON document loca"
  "tion \\'#/latitude\\' failed requirement \\'maximum\\' at\\nJSON Schema location \\'#/properties/latitude\\'.\\n*************"
  "************** 2. row ***************************\\n  Level: Error\\n   Code: 3819\\nMessage: Check constraint \\'geo_chk"
  "_1\\' is violated.\\n2 rows in set (0.00 sec)\\n\\nmysql> INSERT INTO geo VALUES(@point3);\\nERROR 3819 (HY000): Check con"
  "straint \\'geo_chk_1\\' is violated.\\nmysql> SHOW WARNINGS\\\\G\\n*************************** 1. row *********************"
  "******\\n  Level: Error\\n   Code: 3934\\nMessage: The JSON document location \\'#\\' failed requirement \\'required\\' at J"
  "SON\\nSchema location \\'#\\'.\\n*************************** 2. row ***************************\\n  Level: Error\\n   Code:"
  " 3819\\nMessage: Check constraint \\'geo_chk_1\\' is violated.\\n2 rows in set (0.00 sec)\\n\\nmysql> SELECT JSON_SCHEMA_VA"
  "LID(\\'{\"type\":\"string\",\"pattern\":\"(\"}\\', \\'\"abc\"\\');\\n+----------------------------------------------------"
  "-----------+\\n| JSON_SCHEMA_VALID(\\'{\"type\":\"string\",\"pattern\":\"(\"}\\', \\'\"abc\"\\') |\\n+---------------------"
  "------------------------------------------+\\n|                                                             1 |\\n+----"
  "-----------------------------------------------------------+\\n1 row in set (0.04 sec)\\n','https://dev.mysql.com/doc/r"
  "efman/8.4/en/json-validation-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (410,32,'JSON_SCHEMA_VALIDAT"
  "ION_REPORT','JSON_SCHEMA_VALIDATION_REPORT(schema,document)\\n\\nValidates a JSON document against a JSON schema. Both "
  "schema and\\ndocument are required. As with JSON_VALID_SCHEMA(), the schema must be\\na valid JSON object, and the docu"
  "ment must be a valid JSON document.\\nProvided that these conditions are met, the function returns a report,\\nas a JSO"
  "N document, on the outcome of the validation. If the JSON\\ndocument is considered valid according to the JSON Schema,"
  " the function\\nreturns a JSON object with one property valid having the value \"true\".\\nIf the JSON document fails v"
  "alidation, the function returns a JSON\\nobject which includes the properties listed here:\\n\\no valid: Always \"false\""
  " for a failed schema validation\\n\\no reason: A human-readable string containing the reason for the failure\\n\\no schem"
  "a-location: A JSON pointer URI fragment identifier indicating\\n  where in the JSON schema the validation failed (see "
  "Note following\\n  this list)\\n\\no document-location: A JSON pointer URI fragment identifier indicating\\n  where in th"
  "e JSON document the validation failed (see Note following\\n  this list)\\n\\no schema-failed-keyword: A string containi"
  "ng the name of the keyword or\\n  property in the JSON schema that was violated\\n\\n*Note*:\\n\\nJSON pointer URI fragmen"
  "t identifiers are defined in RFC 6901 -\\nJavaScript Object Notation (JSON) Pointer\\n(https://tools.ietf.org/html/rfc6"
  "901#page-5). (These are not the same\\nas the JSON path notation used by JSON_EXTRACT() and other MySQL JSON\\nfunction"
  "s.) In this notation, # represents the entire document, and\\n#/myprop represents the portion of the document included"
  " in the\\ntop-level property named myprop. See the specification just cited and\\nthe examples shown later in this sect"
  "ion for more information.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-validation-functions.html\\n\\n','mysql>"
  " SET @schema = \\'{\\n    \\'>  \"id\": \"http://json-schema.org/geo\",\\n    \\'> \"$schema\": \"http://json-schema.org/d"
  "raft-04/schema#\",\\n    \\'> \"description\": \"A geographical coordinate\",\\n    \\'> \"type\": \"object\",\\n    \\'> \""
  "properties\": {\\n    \\'>   \"latitude\": {\\n    \\'>     \"type\": \"number\",\\n    \\'>     \"minimum\": -90,\\n    \\'>"
  "     \"maximum\": 90\\n    \\'>   },\\n    \\'>   \"longitude\": {\\n    \\'>     \"type\": \"number\",\\n    \\'>     \"mini"
  "mum\": -180,\\n    \\'>     \"maximum\": 180\\n    \\'>   }\\n    \\'> },\\n    \\'> \"required\": [\"latitude\", \"longitude"
  "\"]\\n    \\'>}\\';\\nQuery OK, 0 rows affected (0.01 sec)\\n\\nmysql> SET @document = \\'{\\n    \\'> \"latitude\": 63.444697"
  ",\\n    \\'> \"longitude\": 10.445118\\n    \\'>}\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT JSON_SCHEMA_V"
  "ALIDATION_REPORT(@schema, @document);\\n+---------------------------------------------------+\\n| JSON_SCHEMA_VALIDATIO"
  "N_REPORT(@schema, @document) |\\n+---------------------------------------------------+\\n| {\"valid\": true}           "
  "                        |\\n+---------------------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> S"
  "ET @document = \\'{\\n    \\'> \"latitude\": 63.444697,\\n    \\'> \"longitude\": 310.445118\\n    \\'> }\\';\\n\\nmysql> SELEC"
  "T JSON_PRETTY(JSON_SCHEMA_VALIDATION_REPORT(@schema, @document))\\\\G\\n*************************** 1. row *************"
  "**************\\nJSON_PRETTY(JSON_SCHEMA_VALIDATION_REPORT(@schema, @document)): {\\n  \"valid\": false,\\n  \"reason\":"
  " \"The JSON document location \\'#/longitude\\' failed requirement \\'maximum\\' at JSON Schema location \\'#/properties/l"
  "ongitude\\'\",\\n  \"schema-location\": \"#/properties/longitude\",\\n  \"document-location\": \"#/longitude\",\\n  \"sch"
  "ema-failed-keyword\": \"maximum\"\\n}\\n1 row in set (0.00 sec)\\n\\nmysql> SET @document = \\'{}\\';\\nQuery OK, 0 rows aff"
  "ected (0.00 sec)\\n\\nmysql> SELECT JSON_PRETTY(JSON_SCHEMA_VALIDATION_REPORT(@schema, @document))\\\\G\\n****************"
  "*********** 1. row ***************************\\nJSON_PRETTY(JSON_SCHEMA_VALIDATION_REPORT(@schema, @document)): {\\n  "
  "\"valid\": false,\\n  \"reason\": \"The JSON document location \\'#\\' failed requirement \\'required\\' at JSON Schema lo"
  "cation \\'#\\'\",\\n  \"schema-location\": \"#\",\\n  \"document-location\": \"#\",\\n  \"schema-failed-keyword\": \"requi"
  "red\"\\n}\\n1 row in set (0.00 sec)\\n\\nmysql> SET @schema = \\'{\\n    \\'> \"id\": \"http://json-schema.org/geo\",\\n    \\"
  "'> \"$schema\": \"http://json-schema.org/draft-04/schema#\",\\n    \\'> \"description\": \"A geographical coordinate\","
  "\\n    \\'> \"type\": \"object\",\\n    \\'> \"properties\": {\\n    \\'>   \"latitude\": {\\n    \\'>     \"type\": \"number"
  "\",\\n    \\'>     \"minimum\": -90,\\n    \\'>     \"maximum\": 90\\n    \\'>   },\\n    \\'>   \"longitude\": {\\n    \\'>   "
  "  \"type\": \"number\",\\n    \\'>     \"minimum\": -180,\\n    \\'>     \"maximum\": 180\\n    \\'>   }\\n    \\'> }\\n    \\'"
  ">}\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT JSON_SCHEMA_VALIDATION_REPORT(@schema, @document);\\n+---"
  "------------------------------------------------+\\n| JSON_SCHEMA_VALIDATION_REPORT(@schema, @document) |\\n+----------"
  "-----------------------------------------+\\n| {\"valid\": true}                                   |\\n+---------------"
  "------------------------------------+\\n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/json-valid"
  "ation-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (411,32,'JSON_PRETTY','JSON_"
  "PRETTY(json_val)\\n\\nProvides pretty-printing of JSON values similar to that implemented in\\nPHP and by other language"
  "s and database systems. The value supplied\\nmust be a JSON value or a valid string representation of a JSON value.\\nE"
  "xtraneous whitespaces and newlines present in this value have no\\neffect on the output. For a NULL value, the functio"
  "n returns NULL. If\\nthe value is not a JSON document, or if it cannot be parsed as one, the\\nfunction fails with an e"
  "rror.\\n\\nFormatting of the output from this function adheres to the following\\nrules:\\n\\no Each array element or obje"
  "ct member appears on a separate line,\\n  indented by one additional level as compared to its parent.\\n\\no Each level "
  "of indentation adds two leading spaces.\\n\\no A comma separating individual array elements or object members is\\n  pri"
  "nted before the newline that separates the two elements or\\n  members.\\n\\no The key and the value of an object member"
  " are separated by a colon\\n  followed by a space (\\': \\').\\n\\no An empty object or array is printed on a single line."
  " No space is\\n  printed between the opening and closing brace.\\n\\no Special characters in string scalars and key name"
  "s are escaped\\n  employing the same rules used by the JSON_QUOTE() function.\\n\\nURL: https://dev.mysql.com/doc/refman"
  "/8.4/en/json-utility-functions.html\\n\\n','mysql> SELECT JSON_PRETTY(\\'123\\'); # scalar\\n+--------------------+\\n| JSO"
  "N_PRETTY(\\'123\\') |\\n+--------------------+\\n| 123                |\\n+--------------------+\\n\\nmysql> SELECT JSON_PRE"
  "TTY(\"[1,3,5]\"); # array\\n+------------------------+\\n| JSON_PRETTY(\"[1,3,5]\") |\\n+------------------------+\\n| [\\"
  "n  1,\\n  3,\\n  5\\n]      |\\n+------------------------+\\n\\nmysql> SELECT JSON_PRETTY(\\'{\"a\":\"10\",\"b\":\"15\",\"x\""
  ":\"25\"}\\'); # object\\n+---------------------------------------------+\\n| JSON_PRETTY(\\'{\"a\":\"10\",\"b\":\"15\",\""
  "x\":\"25\"}\\') |\\n+---------------------------------------------+\\n| {\\n  \"a\": \"10\",\\n  \"b\": \"15\",\\n  \"x\": "
  "\"25\"\\n}   |\\n+---------------------------------------------+\\n\\nmysql> SELECT JSON_PRETTY(\\'[\"a\",1,{\"key1\":\\n  "
  "  \\'>    \"value1\"},\"5\",     \"77\" ,\\n    \\'>       {\"key2\":[\"value3\",\"valueX\",\\n    \\'> \"valueY\"]},\"j\""
  ", \"2\"   ]\\')\\\\G  # nested arrays and objects\\n*************************** 1. row ***************************\\nJSON_"
  "PRETTY(\\'[\"a\",1,{\"key1\":\\n             \"value1\"},\"5\",     \"77\" ,\\n                {\"key2\":[\"value3\",\"v"
  "aluex\",\\n          \"valuey\"]},\"j\", \"2\"   ]\\'): [\\n  \"a\",\\n  1,\\n  {\\n    \"key1\": \"value1\"\\n  },\\n  \"5\""
  ",\\n  \"77\",\\n  {\\n    \"key2\": [\\n      \"value3\",\\n      \"valuex\",\\n      \"valuey\"\\n    ]\\n  },\\n  \"j\",\\n  "
  "\"2\"\\n]\\n','https://dev.mysql.com/doc/refman/8.4/en/json-utility-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (412,32,'JSON_STORAGE_FREE',"
  "'JSON_STORAGE_FREE(json_val)\\n\\nFor a JSON column value, this function shows how much storage space was\\nfreed in its"
  " binary representation after it was updated in place using\\nJSON_SET(), JSON_REPLACE(), or JSON_REMOVE(). The argumen"
  "t can also be\\na valid JSON document or a string which can be parsed as one---either\\nas a literal value or as the va"
  "lue of a user variable---in which case\\nthe function returns 0. It returns a positive, nonzero value if the\\nargument"
  " is a JSON column value which has been updated as described\\npreviously, such that its binary representation takes up"
  " less space\\nthan it did prior to the update. For a JSON column which has been\\nupdated such that its binary represen"
  "tation is the same as or larger\\nthan before, or if the update was not able to take advantage of a\\npartial update, i"
  "t returns 0; it returns NULL if the argument is NULL.\\n\\nIf json_val is not NULL, and neither is a valid JSON documen"
  "t nor can\\nbe successfully parsed as one, an error results.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-util"
  "ity-functions.html\\n\\n','mysql> CREATE TABLE jtable (jcol JSON);\\nQuery OK, 0 rows affected (0.38 sec)\\n\\nmysql> INSE"
  "RT INTO jtable VALUES\\n    ->     (\\'{\"a\": 10, \"b\": \"wxyz\", \"c\": \"[true, false]\"}\\');\\nQuery OK, 1 row affe"
  "cted (0.04 sec)\\n\\nmysql> SELECT * FROM jtable;\\n+----------------------------------------------+\\n| jcol            "
  "                             |\\n+----------------------------------------------+\\n| {\"a\": 10, \"b\": \"wxyz\", \"c\""
  ": \"[true, false]\"} |\\n+----------------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> UPDATE jt"
  "able\\n    ->     SET jcol = JSON_SET(jcol, \"$.a\", 10, \"$.b\", \"wxyz\", \"$.c\", 1);\\nQuery OK, 1 row affected (0."
  "03 sec)\\nRows matched: 1  Changed: 1  Warnings: 0\\n\\nmysql> SELECT * FROM jtable;\\n+--------------------------------+"
  "\\n| jcol                           |\\n+--------------------------------+\\n| {\"a\": 10, \"b\": \"wxyz\", \"c\": 1} |\\"
  "n+--------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_STORAGE_FREE(jcol) FROM jtable;\\n+"
  "-------------------------+\\n| JSON_STORAGE_FREE(jcol) |\\n+-------------------------+\\n|                      14 |\\n+-"
  "------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> UPDATE jtable\\n    ->     SET jcol = JSON_SET(jcol, \"$."
  "a\", 10, \"$.b\", \"wx\", \"$.c\", 1);\\nQuery OK, 1 row affected (0.03 sec)\\nRows matched: 1  Changed: 1  Warnings: 0"
  "\\n\\nmysql> SELECT JSON_STORAGE_FREE(jcol) FROM jtable;\\n+-------------------------+\\n| JSON_STORAGE_FREE(jcol) |\\n+--"
  "-----------------------+\\n|                      16 |\\n+-------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql>"
  " UPDATE jtable SET jcol = \\'{\"a\": 10, \"b\": 1}\\';\\nQuery OK, 1 row affected (0.05 sec)\\nRows matched: 1  Changed: "
  "1  Warnings: 0\\n\\nmysql> SELECT JSON_STORAGE_FREE(jcol) FROM jtable;\\n+-------------------------+\\n| JSON_STORAGE_FRE"
  "E(jcol) |\\n+-------------------------+\\n|                       0 |\\n+-------------------------+\\n1 row in set (0.00 "
  "sec)\\n\\nmysql> SET @j = \\'{\"a\": 10, \"b\": \"wxyz\", \"c\": \"[true, false]\"}\\';\\nQuery OK, 0 rows affected (0.00 "
  "sec)\\n\\nmysql> SET @j = JSON_SET(@j, \\'$.a\\', 10, \\'$.b\\', \\'wxyz\\', \\'$.c\\', \\'1\\');\\nQuery OK, 0 rows affected (0.0"
  "0 sec)\\n\\nmysql> SELECT @j, JSON_STORAGE_FREE(@j) AS Free;\\n+----------------------------------+------+\\n| @j        "
  "                       | Free |\\n+----------------------------------+------+\\n| {\"a\": 10, \"b\": \"wxyz\", \"c\": \""
  "1\"} |    0 |\\n+----------------------------------+------+\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT JSON_STORAGE_FRE"
  "E(\\'{\"a\": 10, \"b\": \"wxyz\", \"c\": \"1\"}\\') AS Free;\\n+------+\\n| Free |\\n+------+\\n|    0 |\\n+------+\\n1 row i"
  "n set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/json-utility-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (413,32,'JSON_STORAGE_SIZE',"
  "'JSON_STORAGE_SIZE(json_val)\\n\\nThis function returns the number of bytes used to store the binary\\nrepresentation of"
  " a JSON document. When the argument is a JSON column,\\nthis is the space used to store the JSON document as it was in"
  "serted\\ninto the column, prior to any partial updates that may have been\\nperformed on it afterwards. json_val must b"
  "e a valid JSON document or a\\nstring which can be parsed as one. In the case where it is string, the\\nfunction return"
  "s the amount of storage space in the JSON binary\\nrepresentation that is created by parsing the string as JSON and\\nc"
  "onverting it to binary. It returns NULL if the argument is NULL.\\n\\nAn error results when json_val is not NULL, and i"
  "s not---or cannot be\\nsuccessfully parsed as---a JSON document.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/json-"
  "utility-functions.html\\n\\n','mysql> CREATE TABLE jtable (jcol JSON);\\nQuery OK, 0 rows affected (0.42 sec)\\n\\nmysql> "
  "INSERT INTO jtable VALUES\\n    ->     (\\'{\"a\": 1000, \"b\": \"wxyz\", \"c\": \"[1, 3, 5, 7]\"}\\');\\nQuery OK, 1 row"
  " affected (0.04 sec)\\n\\nmysql> SELECT\\n    ->     jcol,\\n    ->     JSON_STORAGE_SIZE(jcol) AS Size,\\n    ->     JSON"
  "_STORAGE_FREE(jcol) AS Free\\n    -> FROM jtable;\\n+-----------------------------------------------+------+------+\\n| "
  "jcol                                          | Size | Free |\\n+-----------------------------------------------+-----"
  "-+------+\\n| {\"a\": 1000, \"b\": \"wxyz\", \"c\": \"[1, 3, 5, 7]\"} |   47 |    0 |\\n+------------------------------"
  "-----------------+------+------+\\n1 row in set (0.00 sec)\\n\\nmysql> UPDATE jtable SET jcol = \\n    ->     JSON_SET(jc"
  "ol, \"$.b\", \"a\");\\nQuery OK, 1 row affected (0.04 sec)\\nRows matched: 1  Changed: 1  Warnings: 0\\n\\nmysql> SELECT\\"
  "n    ->     jcol,\\n    ->     JSON_STORAGE_SIZE(jcol) AS Size,\\n    ->     JSON_STORAGE_FREE(jcol) AS Free\\n    -> FR"
  "OM jtable;\\n+--------------------------------------------+------+------+\\n| jcol                                     "
  "  | Size | Free |\\n+--------------------------------------------+------+------+\\n| {\"a\": 1000, \"b\": \"a\", \"c\":"
  " \"[1, 3, 5, 7]\"} |   47 |    3 |\\n+--------------------------------------------+------+------+\\n1 row in set (0.00 "
  "sec)\\n\\nmysql> UPDATE jtable\\nmysql>     SET jcol = \\'{\"a\": 4.55, \"b\": \"wxyz\", \"c\": \"[true, false]\"}\\';\\nQu"
  "ery OK, 1 row affected (0.04 sec)\\nRows matched: 1  Changed: 1  Warnings: 0\\n\\nmysql> SELECT\\n    ->     jcol,\\n    -"
  ">     JSON_STORAGE_SIZE(jcol) AS Size,\\n    ->     JSON_STORAGE_FREE(jcol) AS Free\\n    -> FROM jtable;\\n+-----------"
  "-------------------------------------+------+------+\\n| jcol                                           | Size | Free "
  "|\\n+------------------------------------------------+------+------+\\n| {\"a\": 4.55, \"b\": \"wxyz\", \"c\": \"[true,"
  " false]\"} |   56 |    0 |\\n+------------------------------------------------+------+------+\\n1 row in set (0.00 sec)"
  "\\n\\nmysql> SET @j = \\'[100, \"sakila\", [1, 3, 5], 425.05]\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT "
  "@j, JSON_STORAGE_SIZE(@j) AS Size;\\n+------------------------------------+------+\\n| @j                              "
  "   | Size |\\n+------------------------------------+------+\\n| [100, \"sakila\", [1, 3, 5], 425.05] |   45 |\\n+-------"
  "-----------------------------+------+\\n1 row in set (0.00 sec)\\n\\nmysql> SET @j = JSON_SET(@j, \\'$[1]\\', \"json\");\\n"
  "Query OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT @j, JSON_STORAGE_SIZE(@j) AS Size;\\n+--------------------------"
  "--------+------+\\n| @j                               | Size |\\n+----------------------------------+------+\\n| [100, \""
  "json\", [1, 3, 5], 425.05] |   43 |\\n+----------------------------------+------+\\n1 row in set (0.00 sec)\\n\\nmysql> S"
  "ET @j = JSON_SET(@j, \\'$[2][0]\\', JSON_ARRAY(10, 20, 30));\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT @j,"
  " JSON_STORAGE_SIZE(@j) AS Size;\\n+---------------------------------------------+------+\\n| @j                        "
  "                  | Size |\\n+---------------------------------------------+------+\\n| [100, \"json\", [[10, 20, 30], "
  "3, 5], 425.05] |   56 |\\n+---------------------------------------------+------+\\n1 row in set (0.00 sec)\\n\\nmysql> SE"
  "LECT\\n    ->     JSON_STORAGE_SIZE(\\'[100, \"sakila\", [1, 3, 5], 425.05]\\') AS A,\\n    ->     JSON_STORAGE_SIZE(\\'{\""
  "a\": 1000, \"b\": \"a\", \"c\": \"[1, 3, 5, 7]\"}\\') AS B,\\n    ->     JSON_STORAGE_SIZE(\\'{\"a\": 1000, \"b\": \"wxy"
  "z\", \"c\": \"[1, 3, 5, 7]\"}\\') AS C,\\n    ->     JSON_STORAGE_SIZE(\\'[100, \"json\", [[10, 20, 30], 3, 5], 425.05]\\"
  "') AS D;\\n+----+----+----+----+\\n| A  | B  | C  | D  |\\n+----+----+----+----+\\n| 45 | 44 | 47 | 56 |\\n+----+----+----"
  "+----+\\n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/json-utility-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (414,33,'GTID_SUBSET','Synta"
  "x:\\nGTID_SUBSET(set1,set2)\\n\\nGiven two sets of global transaction identifiers set1 and set2, returns\\ntrue if all GT"
  "IDs in set1 are also in set2. Returns NULL if set1 or\\nset2 is NULL. Returns false otherwise.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/gtid-functions.html\\n\\n','mysql> SELECT GTID_SUBSET(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:2"
  "3\\',\\n    ->     \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\')\\\\G\\n*************************** 1. row *************"
  "**************\\nGTID_SUBSET(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23\\',\\n    \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:"
  "21-57\\'): 1\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT GTID_SUBSET(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-25\\',\\n  "
  "  ->     \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\')\\\\G\\n*************************** 1. row *********************"
  "******\\nGTID_SUBSET(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-25\\',\\n    \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57"
  "\\'): 1\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT GTID_SUBSET(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\\',\\n    -> "
  "    \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\')\\\\G\\n*************************** 1. row **************************"
  "*\\nGTID_SUBSET(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\\',\\n    \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\'): "
  "0\\n1 row in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/gtid-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (415,33,'GTID_SUBTRACT','Syn"
  "tax:\\nGTID_SUBTRACT(set1,set2)\\n\\nGiven two sets of global transaction identifiers set1 and set2, returns\\nonly those"
  " GTIDs from set1 that are not in set2. Returns NULL if set1\\nor set2 is NULL.\\n\\nURL: https://dev.mysql.com/doc/refma"
  "n/8.4/en/gtid-functions.html\\n\\n','mysql> SELECT GTID_SUBTRACT(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\',\\n    -"
  ">     \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21\\')\\\\G\\n*************************** 1. row ***************************"
  "\\nGTID_SUBTRACT(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\',\\n    \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21\\'): 3e"
  "11fa47-71ca-11e1-9e33-c80aa9429562:22-57\\n1 row in set (0.00 sec)\\n\\nmysql> SELECT GTID_SUBTRACT(\\'3E11FA47-71CA-11E1"
  "-9E33-C80AA9429562:21-57\\',\\n    ->     \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\\')\\\\G\\n*************************"
  "** 1. row ***************************\\nGTID_SUBTRACT(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\',\\n    \\'3E11FA47-"
  "71CA-11E1-9E33-C80AA9429562:20-25\\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:26-57\\n1 row in set (0.00 sec)\\n\\nmysql> S"
  "ELECT GTID_SUBTRACT(\\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\\',\\n    ->     \\'3E11FA47-71CA-11E1-9E33-C80AA942956"
  "2:23-24\\')\\\\G\\n*************************** 1. row ***************************\\nGTID_SUBTRACT(\\'3E11FA47-71CA-11E1-9E3"
  "3-C80AA9429562:21-57\\',\\n    \\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-24\\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:21"
  "-22:25-57\\n1 row in set (0.01 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/gtid-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (416,33,'WAIT_FOR_EXECUTED_G"
  "TID_SET','Syntax:\\nWAIT_FOR_EXECUTED_GTID_SET(gtid_set[, timeout])\\n\\nWait until the server has applied all of the tr"
  "ansactions whose global\\ntransaction identifiers are contained in gtid_set; that is, until the\\ncondition GTID_SUBSET"
  "(gtid_subset, @@GLOBAL.gtid_executed) holds. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-gtids-concepts."
  "html\\nfor a definition of GTID sets.\\n\\nIf a timeout is specified, and timeout seconds elapse before all of the\\ntran"
  "sactions in the GTID set have been applied, the function stops\\nwaiting. timeout is optional, and the default timeout"
  " is 0 seconds, in\\nwhich case the function always waits until all of the transactions in\\nthe GTID set have been appl"
  "ied. timeout must be greater than or equal\\nto 0; when running in strict SQL mode, a negative timeout value is\\nimmed"
  "iately rejected with an error (ER_WRONG_ARGUMENTS\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-refere"
  "nce.html\\n#error_er_wrong_arguments)); otherwise the function returns NULL,\\nand raises a warning.\\n\\nWAIT_FOR_EXECUT"
  "ED_GTID_SET() monitors all the GTIDs that are applied on\\nthe server, including transactions that arrive from all rep"
  "lication\\nchannels and user clients. It does not take into account whether\\nreplication channels have been started or"
  " stopped.\\n\\nFor more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-gtids.html.\\n\\nURL: https"
  "://dev.mysql.com/doc/refman/8.4/en/gtid-functions.html\\n\\n','mysql> SELECT WAIT_FOR_EXECUTED_GTID_SET(\\'3E11FA47-71CA"
  "-11E1-9E33-C80AA9429562:1-5\\');\\n        -> 0\\n','https://dev.mysql.com/doc/refman/8.4/en/gtid-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (417,33,'MASTER_POS_WAIT','S"
  "yntax:\\nMASTER_POS_WAIT(log_name,log_pos[,timeout][,channel])\\n\\nDeprecated alias for SOURCE_POS_WAIT().\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/replication-functions-synchronization.html\\n\\n','','https://dev.mysql.com/doc/ref"
  "man/8.4/en/replication-functions-synchronization.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (418,33,'SOURCE_POS_WAIT','S"
  "yntax:\\nSOURCE_POS_WAIT(log_name,log_pos[,timeout][,channel])\\n\\nThis function is for control of source-replica synch"
  "ronization. It\\nblocks until the replica has read and applied all updates up to the\\nspecified position in the source"
  "\\'s binary log.\\n\\nThe return value is the number of log events the replica had to wait\\nfor to advance to the specif"
  "ied position. The function returns NULL if\\nthe replication SQL thread is not started, the replica\\'s source\\ninforma"
  "tion is not initialized, the arguments are incorrect, or an\\nerror occurs. It returns -1 if the timeout has been exce"
  "eded. If the\\nreplication SQL thread stops while SOURCE_POS_WAIT() is waiting, the\\nfunction returns NULL. If the rep"
  "lica is past the specified position,\\nthe function returns immediately.\\n\\nIf the binary log file position has been m"
  "arked as invalid, the\\nfunction waits until a valid file position is known. The binary log\\nfile position can be mark"
  "ed as invalid when the CHANGE REPLICATION\\nSOURCE TO option GTID_ONLY is set for the replication channel, and the\\nse"
  "rver is restarted or replication is stopped. The file position\\nbecomes valid after a transaction is successfully app"
  "lied past the\\ngiven file position. If the applier does not reach the stated position,\\nthe function waits until the "
  "timeout. Use a SHOW REPLICA STATUS\\nstatement to check if the binary log file position has been marked as\\ninvalid.\\n"
  "\\nOn a multithreaded replica, the function waits until expiry of the\\nlimit set by the replica_checkpoint_group or re"
  "plica_checkpoint_period\\nsystem variable, when the checkpoint operation is called to update the\\nstatus of the replic"
  "a. Depending on the setting for the system\\nvariables, the function might therefore return some time after the\\nspeci"
  "fied position was reached.\\n\\nIf binary log transaction compression is in use and the transaction\\npayload at the spe"
  "cified position is compressed (as a\\nTransaction_payload_event), the function waits until the whole\\ntransaction has "
  "been read and applied, and the positions have updated.\\n\\nIf a timeout value is specified, SOURCE_POS_WAIT() stops wa"
  "iting when\\ntimeout seconds have elapsed. timeout must be greater than or equal to\\n0. (When the server is running in"
  " strict SQL mode, a negative timeout\\nvalue is immediately rejected with ER_WRONG_ARGUMENTS\\n(https://dev.mysql.com/d"
  "oc/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_wrong_arguments); otherwise the function returns NULL, "
  "and\\nraises a warning.)\\n\\nThe optional channel value enables you to name which replication\\nchannel the function app"
  "lies to. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-channels.html for\\nmore information.\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/replication-functions-synchronization.html\\n\\n','','https://dev.mysql.com/doc/refma"
  "n/8.4/en/replication-functions-synchronization.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (419,34,'AVG','Syntax:\\nAVG("
  "[DISTINCT] expr) [over_clause]\\n\\nReturns the average value of expr. The DISTINCT option can be used to\\nreturn the a"
  "verage of the distinct values of expr.\\n\\nIf there are no matching rows, AVG() returns NULL. The function also\\nretur"
  "ns NULL if expr is NULL.\\n\\nThis function executes as a window function if over_clause is present.\\nover_clause is as"
  " described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html; it\\ncannot be used with DISTINCT."
  "\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','mysql> SELECT student_name, AVG(test_"
  "score)\\n       FROM student\\n       GROUP BY student_name;\\n','https://dev.mysql.com/doc/refman/8.4/en/aggregate-func"
  "tions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (420,34,'BIT_AND','Syntax:\\n"
  "BIT_AND(expr) [over_clause]\\n\\nReturns the bitwise AND of all bits in expr.\\n\\nThe result type depends on whether the"
  " function argument values are\\nevaluated as binary strings or numbers:\\n\\no Binary-string evaluation occurs when the "
  "argument values have a\\n  binary string type, and the argument is not a hexadecimal literal,\\n  bit literal, or NULL "
  "literal. Numeric evaluation occurs otherwise,\\n  with argument value conversion to unsigned 64-bit integers as\\n  nec"
  "essary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  as the argument values. If argum"
  "ent values have unequal lengths, an\\n  ER_INVALID_BITWISE_OPERANDS_SIZE\\n  (https://dev.mysql.com/doc/mysql-errors/8."
  "4/en/server-error-reference\\n  .html#error_er_invalid_bitwise_operands_size) error occurs. If the\\n  argument size ex"
  "ceeds 511 bytes, an\\n  ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/s"
  "erver-error-reference\\n  .html#error_er_invalid_bitwise_aggregate_operands_size) error occurs.\\n  Numeric evaluation "
  "produces an unsigned 64-bit integer.\\n\\nIf there are no matching rows, BIT_AND() returns a neutral value (all\\nbits s"
  "et to 1) having the same length as the argument values.\\n\\nNULL values do not affect the result unless all values are"
  " NULL. In\\nthat case, the result is a neutral value having the same length as the\\nargument values.\\n\\nFor more infor"
  "mation discussion about argument evaluation and result\\ntypes, see the introductory discussion in\\nhttps://dev.mysql."
  "com/doc/refman/8.4/en/bit-functions.html.\\n\\nIf BIT_AND() is invoked from within the mysql client, binary string\\nres"
  "ults display using hexadecimal notation, depending on the value of\\nthe --binary-as-hex. For more information about t"
  "hat option, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql.html.\\n\\nThis function executes as a window function i"
  "f over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-u"
  "sage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/do"
  "c/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (421,34,'BIT_OR','Syntax:\\nB"
  "IT_OR(expr) [over_clause]\\n\\nReturns the bitwise OR of all bits in expr.\\n\\nThe result type depends on whether the fu"
  "nction argument values are\\nevaluated as binary strings or numbers:\\n\\no Binary-string evaluation occurs when the arg"
  "ument values have a\\n  binary string type, and the argument is not a hexadecimal literal,\\n  bit literal, or NULL lit"
  "eral. Numeric evaluation occurs otherwise,\\n  with argument value conversion to unsigned 64-bit integers as\\n  necess"
  "ary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  as the argument values. If argument"
  " values have unequal lengths, an\\n  ER_INVALID_BITWISE_OPERANDS_SIZE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/e"
  "n/server-error-reference\\n  .html#error_er_invalid_bitwise_operands_size) error occurs. If the\\n  argument size excee"
  "ds 511 bytes, an\\n  ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/serv"
  "er-error-reference\\n  .html#error_er_invalid_bitwise_aggregate_operands_size) error occurs.\\n  Numeric evaluation pro"
  "duces an unsigned 64-bit integer.\\n\\nIf there are no matching rows, BIT_OR() returns a neutral value (all\\nbits set t"
  "o 0) having the same length as the argument values.\\n\\nNULL values do not affect the result unless all values are NUL"
  "L. In\\nthat case, the result is a neutral value having the same length as the\\nargument values.\\n\\nFor more informati"
  "on discussion about argument evaluation and result\\ntypes, see the introductory discussion in\\nhttps://dev.mysql.com/"
  "doc/refman/8.4/en/bit-functions.html.\\n\\nIf BIT_OR() is invoked from within the mysql client, binary string\\nresults "
  "display using hexadecimal notation, depending on the value of\\nthe --binary-as-hex. For more information about that o"
  "ption, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql.html.\\n\\nThis function executes as a window function if ove"
  "r_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage."
  "html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/doc/ref"
  "man/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (422,34,'BIT_XOR','Syntax:\\n"
  "BIT_XOR(expr) [over_clause]\\n\\nReturns the bitwise XOR of all bits in expr.\\n\\nThe result type depends on whether the"
  " function argument values are\\nevaluated as binary strings or numbers:\\n\\no Binary-string evaluation occurs when the "
  "argument values have a\\n  binary string type, and the argument is not a hexadecimal literal,\\n  bit literal, or NULL "
  "literal. Numeric evaluation occurs otherwise,\\n  with argument value conversion to unsigned 64-bit integers as\\n  nec"
  "essary.\\n\\no Binary-string evaluation produces a binary string of the same length\\n  as the argument values. If argum"
  "ent values have unequal lengths, an\\n  ER_INVALID_BITWISE_OPERANDS_SIZE\\n  (https://dev.mysql.com/doc/mysql-errors/8."
  "4/en/server-error-reference\\n  .html#error_er_invalid_bitwise_operands_size) error occurs. If the\\n  argument size ex"
  "ceeds 511 bytes, an\\n  ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/s"
  "erver-error-reference\\n  .html#error_er_invalid_bitwise_aggregate_operands_size) error occurs.\\n  Numeric evaluation "
  "produces an unsigned 64-bit integer.\\n\\nIf there are no matching rows, BIT_XOR() returns a neutral value (all\\nbits s"
  "et to 0) having the same length as the argument values.\\n\\nNULL values do not affect the result unless all values are"
  " NULL. In\\nthat case, the result is a neutral value having the same length as the\\nargument values.\\n\\nFor more infor"
  "mation discussion about argument evaluation and result\\ntypes, see the introductory discussion in\\nhttps://dev.mysql."
  "com/doc/refman/8.4/en/bit-functions.html.\\n\\nIf BIT_XOR() is invoked from within the mysql client, binary string\\nres"
  "ults display using hexadecimal notation, depending on the value of\\nthe --binary-as-hex. For more information about t"
  "hat option, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql.html.\\n\\nThis function executes as a window function i"
  "f over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-u"
  "sage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/do"
  "c/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (423,34,'COUNT','Syntax:\\nCO"
  "UNT(expr) [over_clause]\\n\\nReturns a count of the number of non-NULL values of expr in the rows\\nretrieved by a SELEC"
  "T statement. The result is a BIGINT value.\\n\\nIf there are no matching rows, COUNT() returns 0. COUNT(NULL) returns\\n"
  "0.\\n\\nThis function executes as a window function if over_clause is present.\\nover_clause is as described in\\nhttps:/"
  "/dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggrega"
  "te-functions.html\\n\\n','mysql> SELECT student.student_name,COUNT(*)\\n       FROM student,course\\n       WHERE student"
  ".student_id=course.student_id\\n       GROUP BY student_name;\\n','https://dev.mysql.com/doc/refman/8.4/en/aggregate-fu"
  "nctions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (424,34,'COUNT DISTINCT','Sy"
  "ntax:\\nCOUNT(DISTINCT expr,[expr...])\\n\\nReturns a count of the number of rows with different non-NULL expr\\nvalues.\\"
  "n\\nIf there are no matching rows, COUNT(DISTINCT) returns 0.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregat"
  "e-functions.html\\n\\n','mysql> SELECT COUNT(DISTINCT results) FROM student;\\n','https://dev.mysql.com/doc/refman/8.4/e"
  "n/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (425,34,'GROUP_CONCAT','Synt"
  "ax:\\nGROUP_CONCAT(expr)\\n\\nThis function returns a string result with the concatenated non-NULL\\nvalues from a group."
  " It returns NULL if there are no non-NULL values.\\nThe full syntax is as follows:\\n\\nGROUP_CONCAT([DISTINCT] expr [,e"
  "xpr ...]\\n             [ORDER BY {unsigned_integer | col_name | expr}\\n                 [ASC | DESC] [,col_name ...]]"
  "\\n             [SEPARATOR str_val])\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','my"
  "sql> SELECT student_name,\\n         GROUP_CONCAT(test_score)\\n       FROM student\\n       GROUP BY student_name;\\n','"
  "https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (426,34,'JSON_ARRAYAGG','Syn"
  "tax:\\nJSON_ARRAYAGG(col_or_expr) [over_clause]\\n\\nAggregates a result set as a single JSON array whose elements consi"
  "st\\nof the rows. The order of elements in this array is undefined. The\\nfunction acts on a column or an expression th"
  "at evaluates to a single\\nvalue. Returns NULL if the result contains no rows, or in the event of\\nan error. If col_or"
  "_expr is NULL, the function returns an array of JSON\\n[null] elements.\\n\\nThis function executes as a window function"
  " if over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions"
  "-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','mysql> SELECT o_id, attri"
  "bute, value FROM t3;\\n+------+-----------+-------+\\n| o_id | attribute | value |\\n+------+-----------+-------+\\n|    "
  "2 | color     | red   |\\n|    2 | fabric    | silk  |\\n|    3 | color     | green |\\n|    3 | shape     | square|\\n+-"
  "-----+-----------+-------+\\n4 rows in set (0.00 sec)\\n\\nmysql> SELECT o_id, JSON_ARRAYAGG(attribute) AS attributes\\n "
  "   -> FROM t3 GROUP BY o_id;\\n+------+---------------------+\\n| o_id | attributes          |\\n+------+---------------"
  "------+\\n|    2 | [\"color\", \"fabric\"] |\\n|    3 | [\"color\", \"shape\"]  |\\n+------+---------------------+\\n2 ro"
  "ws in set (0.00 sec)\\n','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (427,34,'JSON_OBJECTAGG','Sy"
  "ntax:\\nJSON_OBJECTAGG(key, value) [over_clause]\\n\\nTakes two column names or expressions as arguments, the first of t"
  "hese\\nbeing used as a key and the second as a value, and returns a JSON\\nobject containing key-value pairs. Returns N"
  "ULL if the result contains\\nno rows, or in the event of an error. An error occurs if any key name\\nis NULL or the num"
  "ber of arguments is not equal to 2.\\n\\nThis function executes as a window function if over_clause is present.\\nover_c"
  "lause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.my"
  "sql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','mysql> SELECT o_id, attribute, value FROM t3;\\n+------+-----"
  "------+-------+\\n| o_id | attribute | value |\\n+------+-----------+-------+\\n|    2 | color     | red   |\\n|    2 | f"
  "abric    | silk  |\\n|    3 | color     | green |\\n|    3 | shape     | square|\\n+------+-----------+-------+\\n4 rows "
  "in set (0.00 sec)\\n\\nmysql> SELECT o_id, JSON_OBJECTAGG(attribute, value)\\n    -> FROM t3 GROUP BY o_id;\\n+------+---"
  "------------------------------------+\\n| o_id | JSON_OBJECTAGG(attribute, value)      |\\n+------+--------------------"
  "-------------------+\\n|    2 | {\"color\": \"red\", \"fabric\": \"silk\"}    |\\n|    3 | {\"color\": \"green\", \"sha"
  "pe\": \"square\"} |\\n+------+---------------------------------------+\\n2 rows in set (0.00 sec)\\n','https://dev.mysql"
  ".com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (428,34,'MAX','Syntax:\\nMAX("
  "[DISTINCT] expr) [over_clause]\\n\\nReturns the maximum value of expr. MAX() may take a string argument; in\\nsuch cases"
  ", it returns the maximum string value. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql-indexes.html. The\\nDISTINCT"
  " keyword can be used to find the maximum of the distinct values\\nof expr, however, this produces the same result as o"
  "mitting DISTINCT.\\n\\nIf there are no matching rows, or if expr is NULL, MAX() returns NULL.\\n\\nThis function executes"
  " as a window function if over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8."
  "4/en/window-functions-usage.html; it\\ncannot be used with DISTINCT.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/a"
  "ggregate-functions.html\\n\\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\\n       FROM student\\n    "
  "   GROUP BY student_name;\\n','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (429,34,'MIN','Syntax:\\nMIN("
  "[DISTINCT] expr) [over_clause]\\n\\nReturns the minimum value of expr. MIN() may take a string argument; in\\nsuch cases"
  ", it returns the minimum string value. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql-indexes.html. The\\nDISTINCT"
  " keyword can be used to find the minimum of the distinct values\\nof expr, however, this produces the same result as o"
  "mitting DISTINCT.\\n\\nIf there are no matching rows, or if expr is NULL, MIN() returns NULL.\\n\\nThis function executes"
  " as a window function if over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8."
  "4/en/window-functions-usage.html; it\\ncannot be used with DISTINCT.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/a"
  "ggregate-functions.html\\n\\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\\n       FROM student\\n    "
  "   GROUP BY student_name;\\n','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (430,34,'STD','Syntax:\\nSTD("
  "expr) [over_clause]\\n\\nReturns the population standard deviation of expr. STD() is a synonym\\nfor the standard SQL fu"
  "nction STDDEV_POP(), provided as a MySQL\\nextension.\\n\\nIf there are no matching rows, or if expr is NULL, STD() retu"
  "rns NULL.\\n\\nThis function executes as a window function if over_clause is present.\\nover_clause is as described in\\n"
  "https://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/"
  "aggregate-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (431,34,'STDDEV','Syntax:\\nS"
  "TDDEV(expr) [over_clause]\\n\\nReturns the population standard deviation of expr. STDDEV() is a\\nsynonym for the standa"
  "rd SQL function STDDEV_POP(), provided for\\ncompatibility with Oracle.\\n\\nIf there are no matching rows, or if expr i"
  "s NULL, STDDEV() returns\\nNULL.\\n\\nThis function executes as a window function if over_clause is present.\\nover_claus"
  "e is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql."
  "com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (432,34,'STDDEV_POP','Syntax"
  ":\\nSTDDEV_POP(expr) [over_clause]\\n\\nReturns the population standard deviation of expr (the square root of\\nVAR_POP()"
  "). You can also use STD() or STDDEV(), which are equivalent\\nbut not standard SQL.\\n\\nIf there are no matching rows, "
  "or if expr is NULL, STDDEV_POP() returns\\nNULL.\\n\\nThis function executes as a window function if over_clause is pres"
  "ent.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/aggre"
  "gate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (433,34,'STDDEV_SAMP','Synta"
  "x:\\nSTDDEV_SAMP(expr) [over_clause]\\n\\nReturns the sample standard deviation of expr (the square root of\\nVAR_SAMP()."
  "\\n\\nIf there are no matching rows, or if expr is NULL, STDDEV_SAMP()\\nreturns NULL.\\n\\nThis function executes as a wi"
  "ndow function if over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/win"
  "dow-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://d"
  "ev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (434,34,'SUM','Syntax:\\nSUM("
  "[DISTINCT] expr) [over_clause]\\n\\nReturns the sum of expr. If the return set has no rows, SUM() returns\\nNULL. The DI"
  "STINCT keyword can be used to sum only the distinct values\\nof expr.\\n\\nIf there are no matching rows, or if expr is "
  "NULL, SUM() returns NULL.\\n\\nThis function executes as a window function if over_clause is present.\\nover_clause is a"
  "s described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html; it\\ncannot be used with DISTINCT"
  ".\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/"
  "8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (435,34,'VAR_POP','Syntax:\\n"
  "VAR_POP(expr) [over_clause]\\n\\nReturns the population standard variance of expr. It considers rows as\\nthe whole popu"
  "lation, not as a sample, so it has the number of rows as\\nthe denominator. You can also use VARIANCE(), which is equi"
  "valent but\\nis not standard SQL.\\n\\nIf there are no matching rows, or if expr is NULL, VAR_POP() returns\\nNULL.\\n\\nTh"
  "is function executes as a window function if over_clause is present.\\nover_clause is as described in\\nhttps://dev.mys"
  "ql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-funct"
  "ions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (436,34,'VAR_SAMP','Syntax:\\"
  "nVAR_SAMP(expr) [over_clause]\\n\\nReturns the sample variance of expr. That is, the denominator is the\\nnumber of rows"
  " minus one.\\n\\nIf there are no matching rows, or if expr is NULL, VAR_SAMP() returns\\nNULL.\\n\\nThis function executes"
  " as a window function if over_clause is present.\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8."
  "4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html\\n\\n','','h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (437,34,'VARIANCE','Syntax:\\"
  "nVARIANCE(expr) [over_clause]\\n\\nReturns the population standard variance of expr. VARIANCE() is a\\nsynonym for the s"
  "tandard SQL function VAR_POP(), provided as a MySQL\\nextension.\\n\\nIf there are no matching rows, or if expr is NULL,"
  " VARIANCE() returns\\nNULL.\\n\\nThis function executes as a window function if over_clause is present.\\nover_clause is "
  "as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/d"
  "oc/refman/8.4/en/aggregate-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/aggregate-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (438,36,'CUME_DIST','CUME_DI"
  "ST() over_clause\\n\\nReturns the cumulative distribution of a value within a group of\\nvalues; that is, the percentage"
  " of partition values less than or equal\\nto the value in the current row. This represents the number of rows\\nprecedi"
  "ng or peer with the current row in the window ordering of the\\nwindow partition divided by the total number of rows i"
  "n the window\\npartition. Return values range from 0 to 1.\\n\\nThis function should be used with ORDER BY to sort parti"
  "tion rows into\\nthe desired order. Without ORDER BY, all rows are peers and have value\\nN/N = 1, where N is the parti"
  "tion size.\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\"
  "nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html\\n\\n','mysql> SELECT\\n         val,\\n "
  "        ROW_NUMBER()   OVER w AS \\'row_number\\',\\n         CUME_DIST()    OVER w AS \\'cume_dist\\',\\n         PERCENT_"
  "RANK() OVER w AS \\'percent_rank\\'\\n       FROM numbers\\n       WINDOW w AS (ORDER BY val);\\n+------+------------+----"
  "----------------+--------------+\\n| val  | row_number | cume_dist          | percent_rank |\\n+------+------------+---"
  "-----------------+--------------+\\n|    1 |          1 | 0.2222222222222222 |            0 |\\n|    1 |          2 | 0"
  ".2222222222222222 |            0 |\\n|    2 |          3 | 0.3333333333333333 |         0.25 |\\n|    3 |          4 | "
  "0.6666666666666666 |        0.375 |\\n|    3 |          5 | 0.6666666666666666 |        0.375 |\\n|    3 |          6 |"
  " 0.6666666666666666 |        0.375 |\\n|    4 |          7 | 0.8888888888888888 |         0.75 |\\n|    4 |          8 "
  "| 0.8888888888888888 |         0.75 |\\n|    5 |          9 |                  1 |            1 |\\n+------+-----------"
  "-+--------------------+--------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (439,36,'DENSE_RANK','DENSE_"
  "RANK() over_clause\\n\\nReturns the rank of the current row within its partition, without gaps.\\nPeers are considered t"
  "ies and receive the same rank. This function\\nassigns consecutive ranks to peer groups; the result is that groups of\\"
  "nsize greater than one do not produce noncontiguous rank numbers. For an\\nexample, see the RANK() function descriptio"
  "n.\\n\\nThis function should be used with ORDER BY to sort partition rows into\\nthe desired order. Without ORDER BY, al"
  "l rows are peers.\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.h"
  "tml.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html\\n\\n','','https://dev.mysql.com"
  "/doc/refman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (440,36,'FIRST_VALUE','FIRST"
  "_VALUE(expr) [null_treatment] over_clause\\n\\nReturns the value of expr from the first row of the window frame.\\n\\nove"
  "r_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\nnull_treatment is "
  "as described in the section introduction.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-description"
  "s.html\\n\\n','mysql> SELECT\\n         time, subject, val,\\n         FIRST_VALUE(val)  OVER w AS \\'first\\',\\n         L"
  "AST_VALUE(val)   OVER w AS \\'last\\',\\n         NTH_VALUE(val, 2) OVER w AS \\'second\\',\\n         NTH_VALUE(val, 4) OV"
  "ER w AS \\'fourth\\'\\n       FROM observations\\n       WINDOW w AS (PARTITION BY subject ORDER BY time\\n               "
  "     ROWS UNBOUNDED PRECEDING);\\n+----------+---------+------+-------+------+--------+--------+\\n| time     | subject"
  " | val  | first | last | second | fourth |\\n+----------+---------+------+-------+------+--------+--------+\\n| 07:00:0"
  "0 | st113   |   10 |    10 |   10 |   NULL |   NULL |\\n| 07:15:00 | st113   |    9 |    10 |    9 |      9 |   NULL |"
  "\\n| 07:30:00 | st113   |   25 |    10 |   25 |      9 |   NULL |\\n| 07:45:00 | st113   |   20 |    10 |   20 |      9"
  " |     20 |\\n| 07:00:00 | xh458   |    0 |     0 |    0 |   NULL |   NULL |\\n| 07:15:00 | xh458   |   10 |     0 |   "
  "10 |     10 |   NULL |\\n| 07:30:00 | xh458   |    5 |     0 |    5 |     10 |   NULL |\\n| 07:45:00 | xh458   |   30 |"
  "     0 |   30 |     10 |     30 |\\n| 08:00:00 | xh458   |   25 |     0 |   25 |     10 |     30 |\\n+----------+------"
  "---+------+-------+------+--------+--------+\\n','https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions"
  ".html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (441,36,'LAG','LAG(expr [, N"
  "[, default]]) [null_treatment] over_clause\\n\\nReturns the value of expr from the row that lags (precedes) the current"
  "\\nrow by N rows within its partition. If there is no such row, the return\\nvalue is default. For example, if N is 3, "
  "the return value is default\\nfor the first three rows. If N or default are missing, the defaults are\\n1 and NULL, res"
  "pectively.\\n\\nN must be a literal nonnegative integer. If N is 0, expr is evaluated\\nfor the current row.\\n\\nN cannot"
  " be NULL, and must be an integer in the range 0 to 263,\\ninclusive, in any of the following forms:\\n\\no an unsigned i"
  "nteger constant literal\\n\\no a positional parameter marker (?)\\n\\no a user-defined variable\\n\\no a local variable in "
  "a stored routine\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.ht"
  "ml.\\nnull_treatment is as described in the section introduction.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/wind"
  "ow-function-descriptions.html\\n\\n','mysql> SELECT\\n         t, val,\\n         LAG(val)        OVER w AS \\'lag\\',\\n   "
  "      LEAD(val)       OVER w AS \\'lead\\',\\n         val - LAG(val)  OVER w AS \\'lag diff\\',\\n         val - LEAD(val)"
  " OVER w AS \\'lead diff\\'\\n       FROM series\\n       WINDOW w AS (ORDER BY t);\\n+----------+------+------+------+----"
  "------+-----------+\\n| t        | val  | lag  | lead | lag diff | lead diff |\\n+----------+------+------+------+-----"
  "-----+-----------+\\n| 12:00:00 |  100 | NULL |  125 |     NULL |       -25 |\\n| 13:00:00 |  125 |  100 |  132 |      "
  " 25 |        -7 |\\n| 14:00:00 |  132 |  125 |  145 |        7 |       -13 |\\n| 15:00:00 |  145 |  132 |  140 |       "
  "13 |         5 |\\n| 16:00:00 |  140 |  145 |  150 |       -5 |       -10 |\\n| 17:00:00 |  150 |  140 |  200 |       1"
  "0 |       -50 |\\n| 18:00:00 |  200 |  150 | NULL |       50 |      NULL |\\n+----------+------+------+------+---------"
  "-+-----------+\\n\\nmysql> SELECT n FROM fib ORDER BY n;\\n+------+\\n| n    |\\n+------+\\n|    1 |\\n|    1 |\\n|    2 |\\n|"
  "    3 |\\n|    5 |\\n|    8 |\\n+------+\\n\\nmysql> SELECT\\n         n,\\n         LAG(n, 1, 0)      OVER w AS \\'lag\\',\\n "
  "        LEAD(n, 1, 0)     OVER w AS \\'lead\\',\\n         n + LAG(n, 1, 0)  OVER w AS \\'next_n\\',\\n         n + LEAD(n,"
  " 1, 0) OVER w AS \\'next_next_n\\'\\n       FROM fib\\n       WINDOW w AS (ORDER BY n);\\n+------+------+------+--------+-"
  "------------+\\n| n    | lag  | lead | next_n | next_next_n |\\n+------+------+------+--------+-------------+\\n|    1 |"
  "    0 |    1 |      1 |           2 |\\n|    1 |    1 |    2 |      2 |           3 |\\n|    2 |    1 |    3 |      3 |"
  "           5 |\\n|    3 |    2 |    5 |      5 |           8 |\\n|    5 |    3 |    8 |      8 |          13 |\\n|    8 "
  "|    5 |    0 |     13 |           8 |\\n+------+------+------+--------+-------------+\\n','https://dev.mysql.com/doc/r"
  "efman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (442,36,'LAST_VALUE','LAST_V"
  "ALUE(expr) [null_treatment] over_clause\\n\\nReturns the value of expr from the last row of the window frame.\\n\\nover_c"
  "lause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\nnull_treatment is as "
  "described in the section introduction.\\n\\nFor an example, see the FIRST_VALUE() function description.\\n\\nURL: https:/"
  "/dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/w"
  "indow-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (443,36,'LEAD','LEAD(expr [,"
  " N[, default]]) [null_treatment] over_clause\\n\\nReturns the value of expr from the row that leads (follows) the curre"
  "nt\\nrow by N rows within its partition. If there is no such row, the return\\nvalue is default. For example, if N is 3"
  ", the return value is default\\nfor the last three rows. If N or default are missing, the defaults are\\n1 and NULL, re"
  "spectively.\\n\\nN must be a literal nonnegative integer. If N is 0, expr is evaluated\\nfor the current row.\\n\\nN canno"
  "t be NULL, and must be an integer in the range 0 to 263,\\ninclusive, in any of the following forms:\\n\\no an unsigned "
  "integer constant literal\\n\\no a positional parameter marker (?)\\n\\no a user-defined variable\\n\\no a local variable in"
  " a stored routine\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.h"
  "tml.\\nnull_treatment is as described in the section introduction.\\n\\nFor an example, see the LAG() function descripti"
  "on.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html\\n\\n','','https://dev.mysql.com/"
  "doc/refman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (444,36,'NTH_VALUE','NTH_VAL"
  "UE(expr, N) [from_first_last] [null_treatment] over_clause\\n\\nReturns the value of expr from the N-th row of the wind"
  "ow frame. If\\nthere is no such row, the return value is NULL.\\n\\nN must be a literal positive integer.\\n\\nfrom_first_"
  "last is part of the SQL standard, but the MySQL\\nimplementation permits only FROM FIRST (which is also the default).\\"
  "nThis means that calculations begin at the first row of the window. FROM\\nLAST is parsed, but produces an error. To o"
  "btain the same effect as\\nFROM LAST (begin calculations at the last row of the window), use ORDER\\nBY to sort in reve"
  "rse order.\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\nn"
  "ull_treatment is as described in the section introduction.\\n\\nFor an example, see the FIRST_VALUE() function descript"
  "ion.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html\\n\\n','','https://dev.mysql.com"
  "/doc/refman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (445,36,'NTILE','NTILE(N) ov"
  "er_clause\\n\\nDivides a partition into N groups (buckets), assigns each row in the\\npartition its bucket number, and r"
  "eturns the bucket number of the\\ncurrent row within its partition. For example, if N is 4, NTILE()\\ndivides rows into"
  " four buckets. If N is 100, NTILE() divides rows into\\n100 buckets.\\n\\nN must be a literal positive integer. Bucket n"
  "umber return values range\\nfrom 1 to N.\\n\\nN cannot be NULL, and must be an integer in the range 0 to 263,\\ninclusive"
  ", in any of the following forms:\\n\\no an unsigned integer constant literal\\n\\no a positional parameter marker (?)\\n\\n"
  "o a user-defined variable\\n\\no a local variable in a stored routine\\n\\nThis function should be used with ORDER BY to "
  "sort partition rows into\\nthe desired order.\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/"
  "en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html\\n\\n"
  "','mysql> SELECT\\n         val,\\n         ROW_NUMBER() OVER w AS \\'row_number\\',\\n         NTILE(2)     OVER w AS \\'n"
  "tile2\\',\\n         NTILE(4)     OVER w AS \\'ntile4\\'\\n       FROM numbers\\n       WINDOW w AS (ORDER BY val);\\n+-----"
  "-+------------+--------+--------+\\n| val  | row_number | ntile2 | ntile4 |\\n+------+------------+--------+--------+\\n"
  "|    1 |          1 |      1 |      1 |\\n|    1 |          2 |      1 |      1 |\\n|    2 |          3 |      1 |     "
  " 1 |\\n|    3 |          4 |      1 |      2 |\\n|    3 |          5 |      1 |      2 |\\n|    3 |          6 |      2 "
  "|      3 |\\n|    4 |          7 |      2 |      3 |\\n|    4 |          8 |      2 |      4 |\\n|    5 |          9 |  "
  "    2 |      4 |\\n+------+------------+--------+--------+\\n','https://dev.mysql.com/doc/refman/8.4/en/window-function"
  "-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (446,36,'PERCENT_RANK','PERC"
  "ENT_RANK() over_clause\\n\\nReturns the percentage of partition values less than the value in the\\ncurrent row, excludi"
  "ng the highest value. Return values range from 0 to\\n1 and represent the row relative rank, calculated as the result "
  "of this\\nformula, where rank is the row rank and rows is the number of partition\\nrows:\\n\\n(rank - 1) / (rows - 1)\\n\\"
  "nThis function should be used with ORDER BY to sort partition rows into\\nthe desired order. Without ORDER BY, all row"
  "s are peers.\\n\\nover_clause is as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\"
  "n\\nFor an example, see the CUME_DIST() function description.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-f"
  "unction-descriptions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (447,36,'RANK','RANK() over_"
  "clause\\n\\nReturns the rank of the current row within its partition, with gaps.\\nPeers are considered ties and receive"
  " the same rank. This function does\\nnot assign consecutive ranks to peer groups if groups of size greater\\nthan one e"
  "xist; the result is noncontiguous rank numbers.\\n\\nThis function should be used with ORDER BY to sort partition rows "
  "into\\nthe desired order. Without ORDER BY, all rows are peers.\\n\\nover_clause is as described in\\nhttps://dev.mysql.c"
  "om/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-function-des"
  "criptions.html\\n\\n','mysql> SELECT\\n         val,\\n         ROW_NUMBER() OVER w AS \\'row_number\\',\\n         RANK()  "
  "     OVER w AS \\'rank\\',\\n         DENSE_RANK() OVER w AS \\'dense_rank\\'\\n       FROM numbers\\n       WINDOW w AS (OR"
  "DER BY val);\\n+------+------------+------+------------+\\n| val  | row_number | rank | dense_rank |\\n+------+---------"
  "---+------+------------+\\n|    1 |          1 |    1 |          1 |\\n|    1 |          2 |    1 |          1 |\\n|    "
  "2 |          3 |    3 |          2 |\\n|    3 |          4 |    4 |          3 |\\n|    3 |          5 |    4 |        "
  "  3 |\\n|    3 |          6 |    4 |          3 |\\n|    4 |          7 |    7 |          4 |\\n|    4 |          8 |   "
  " 7 |          4 |\\n|    5 |          9 |    9 |          5 |\\n+------+------------+------+------------+\\n','https://d"
  "ev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (448,36,'ROW_NUMBER','ROW_NU"
  "MBER() over_clause\\n\\nReturns the number of the current row within its partition. Rows\\nnumbers range from 1 to the n"
  "umber of partition rows.\\n\\nORDER BY affects the order in which rows are numbered. Without ORDER\\nBY, row numbering i"
  "s nondeterministic.\\n\\nROW_NUMBER() assigns peers different row numbers. To assign peers the\\nsame value, use RANK() "
  "or DENSE_RANK(). For an example, see the RANK()\\nfunction description.\\n\\nover_clause is as described in\\nhttps://dev"
  ".mysql.com/doc/refman/8.4/en/window-functions-usage.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/window-func"
  "tion-descriptions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/window-function-descriptions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (449,37,'FORMAT_BYTES','FORM"
  "AT_BYTES(count)\\n\\nGiven a numeric byte count, converts it to human-readable format and\\nreturns a string consisting "
  "of a value and a units indicator. The\\nstring contains the number of bytes rounded to 2 decimal places and a\\nminimum"
  " of 3 significant digits. Numbers less than 1024 bytes are\\nrepresented as whole numbers and are not rounded. Returns"
  " NULL if count\\nis NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/performance-schema-functions.html\\n\\n','mysq"
  "l> SELECT FORMAT_BYTES(512), FORMAT_BYTES(18446644073709551615);\\n+-------------------+------------------------------"
  "------+\\n| FORMAT_BYTES(512) | FORMAT_BYTES(18446644073709551615) |\\n+-------------------+---------------------------"
  "---------+\\n|  512 bytes        | 16.00 EiB                          |\\n+-------------------+------------------------"
  "------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/performance-schema-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (450,37,'FORMAT_PICO_TIME','"
  "FORMAT_PICO_TIME(time_val)\\n\\nGiven a numeric Performance Schema latency or wait time in picoseconds,\\nconverts it to"
  " human-readable format and returns a string consisting of\\na value and a units indicator. The string contains the dec"
  "imal time\\nrounded to 2 decimal places and a minimum of 3 significant digits.\\nTimes under 1 nanosecond are represent"
  "ed as whole numbers and are not\\nrounded.\\n\\nIf time_val is NULL, this function returns NULL.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/performance-schema-functions.html\\n\\n','mysql> SELECT FORMAT_PICO_TIME(3501), FORMAT_PICO_TI"
  "ME(188732396662000);\\n+------------------------+-----------------------------------+\\n| FORMAT_PICO_TIME(3501) | FORM"
  "AT_PICO_TIME(188732396662000) |\\n+------------------------+-----------------------------------+\\n| 3.50 ns           "
  "     | 3.15 min                          |\\n+------------------------+-----------------------------------+\\n','https:"
  "//dev.mysql.com/doc/refman/8.4/en/performance-schema-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (451,37,'PS_CURRENT_THREAD_I"
  "D','PS_CURRENT_THREAD_ID()\\n\\nReturns a BIGINT UNSIGNED value representing the Performance Schema\\nthread ID assigned"
  " to the current connection.\\n\\nThe thread ID return value is a value of the type given in the\\nTHREAD_ID column of Pe"
  "rformance Schema tables.\\n\\nPerformance Schema configuration affects PS_CURRENT_THREAD_ID() the\\nsame way as for PS_T"
  "HREAD_ID(). For details, see the description of\\nthat function.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/perfo"
  "rmance-schema-functions.html\\n\\n','mysql> SELECT PS_CURRENT_THREAD_ID();\\n+------------------------+\\n| PS_CURRENT_TH"
  "READ_ID() |\\n+------------------------+\\n|                     52 |\\n+------------------------+\\nmysql> SELECT PS_THR"
  "EAD_ID(CONNECTION_ID());\\n+-------------------------------+\\n| PS_THREAD_ID(CONNECTION_ID()) |\\n+--------------------"
  "-----------+\\n|                            52 |\\n+-------------------------------+\\n','https://dev.mysql.com/doc/refm"
  "an/8.4/en/performance-schema-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (452,37,'PS_THREAD_ID','PS_T"
  "HREAD_ID(connection_id)\\n\\nGiven a connection ID, returns a BIGINT UNSIGNED value representing the\\nPerformance Schem"
  "a thread ID assigned to the connection ID, or NULL if\\nno thread ID exists for the connection ID. The latter can occu"
  "r for\\nthreads that are not instrumented, or if connection_id is NULL.\\n\\nThe connection ID argument is a value of th"
  "e type given in the\\nPROCESSLIST_ID column of the Performance Schema threads table or the Id\\ncolumn of SHOW PROCESSL"
  "IST output.\\n\\nThe thread ID return value is a value of the type given in the\\nTHREAD_ID column of Performance Schema"
  " tables.\\n\\nPerformance Schema configuration affects PS_THREAD_ID() operation as\\nfollows. (These remarks also apply "
  "to PS_CURRENT_THREAD_ID().)\\n\\no Disabling the thread_instrumentation consumer disables statistics\\n  from being coll"
  "ected and aggregated at the thread level, but has no\\n  effect on PS_THREAD_ID().\\n\\no If performance_schema_max_thre"
  "ad_instances is not 0, the Performance\\n  Schema allocates memory for thread statistics and assigns an internal\\n  ID"
  " to each thread for which instance memory is available. If there\\n  are threads for which instance memory is not avai"
  "lable,\\n  PS_THREAD_ID() returns NULL; in this case,\\n  Performance_schema_thread_instances_lost is nonzero.\\n\\no If "
  "performance_schema_max_thread_instances is 0, the Performance\\n  Schema allocates no thread memory and PS_THREAD_ID()"
  " returns NULL.\\n\\no If the Performance Schema itself is disabled, PS_THREAD_ID() produces\\n  an error.\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/performance-schema-functions.html\\n\\n','mysql> SELECT PS_THREAD_ID(6);\\n+----------"
  "-------+\\n| PS_THREAD_ID(6) |\\n+-----------------+\\n|              45 |\\n+-----------------+\\n','https://dev.mysql.co"
  "m/doc/refman/8.4/en/performance-schema-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (453,38,'CAN_ACCESS_COLUMN',"
  "'CAN_ACCESS_COLUMN(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https://dev"
  ".mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (454,38,'CAN_ACCESS_DATABASE"
  "','CAN_ACCESS_DATABASE(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https:/"
  "/dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (455,38,'CAN_ACCESS_TABLE','"
  "CAN_ACCESS_TABLE(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https://dev.m"
  "ysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (456,38,'CAN_ACCESS_USER','C"
  "AN_ACCESS_USER(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https://dev.mys"
  "ql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (457,38,'CAN_ACCESS_VIEW','C"
  "AN_ACCESS_VIEW(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https://dev.mys"
  "ql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (458,38,'GET_DD_COLUMN_PRIVI"
  "LEGES','GET_DD_COLUMN_PRIVILEGES(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','"
  "','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (459,38,'GET_DD_CREATE_OPTIO"
  "NS','GET_DD_CREATE_OPTIONS(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (460,38,'GET_DD_INDEX_SUB_PA"
  "RT_LENGTH','GET_DD_INDEX_SUB_PART_LENGTH(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.htm"
  "l\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (461,38,'INTERNAL_AUTO_INCRE"
  "MENT','INTERNAL_AUTO_INCREMENT(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','',"
  "'https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (462,38,'INTERNAL_AVG_ROW_LE"
  "NGTH','INTERNAL_AVG_ROW_LENGTH(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','',"
  "'https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (463,38,'INTERNAL_CHECK_TIME"
  "','INTERNAL_CHECK_TIME(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https:/"
  "/dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (464,38,'INTERNAL_CHECKSUM',"
  "'INTERNAL_CHECKSUM(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https://dev"
  ".mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (465,38,'INTERNAL_DATA_FREE'"
  ",'INTERNAL_DATA_FREE(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https://d"
  "ev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (466,38,'INTERNAL_DATA_LENGT"
  "H','INTERNAL_DATA_LENGTH(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https"
  "://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (467,38,'INTERNAL_DD_CHAR_LE"
  "NGTH','INTERNAL_DD_CHAR_LENGTH(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','',"
  "'https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (468,38,'INTERNAL_GET_COMMEN"
  "T_OR_ERROR','INTERNAL_GET_COMMENT_OR_ERROR(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.h"
  "tml\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (469,38,'INTERNAL_GET_ENABLE"
  "D_ROLE_JSON','INTERNAL_GET_ENABLED_ROLE_JSON(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions"
  ".html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (470,38,'INTERNAL_GET_HOSTNA"
  "ME','INTERNAL_GET_HOSTNAME(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (471,38,'INTERNAL_GET_USERNA"
  "ME','INTERNAL_GET_USERNAME(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (472,38,'INTERNAL_GET_VIEW_W"
  "ARNING_OR_ERROR','INTERNAL_GET_VIEW_WARNING_OR_ERROR(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-f"
  "unctions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (473,38,'INTERNAL_INDEX_COLU"
  "MN_CARDINALITY','INTERNAL_INDEX_COLUMN_CARDINALITY(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-fun"
  "ctions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (474,38,'INTERNAL_INDEX_LENG"
  "TH','INTERNAL_INDEX_LENGTH(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (475,38,'INTERNAL_IS_ENABLED"
  "_ROLE','INTERNAL_IS_ENABLED_ROLE(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','"
  "','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (476,38,'INTERNAL_IS_MANDATO"
  "RY_ROLE','INTERNAL_IS_MANDATORY_ROLE(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\"
  "n','','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (477,38,'INTERNAL_KEYS_DISAB"
  "LED','INTERNAL_KEYS_DISABLED(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (478,38,'INTERNAL_MAX_DATA_L"
  "ENGTH','INTERNAL_MAX_DATA_LENGTH(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','"
  "','https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (479,38,'INTERNAL_TABLE_ROWS"
  "','INTERNAL_TABLE_ROWS(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https:/"
  "/dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (480,38,'INTERNAL_UPDATE_TIM"
  "E','INTERNAL_UPDATE_TIME(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https"
  "://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (481,38,'IS_VISIBLE_DD_OBJEC"
  "T','IS_VISIBLE_DD_OBJECT(ARGS)\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/internal-functions.html\\n\\n','','https"
  "://dev.mysql.com/doc/refman/8.4/en/internal-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (482,39,'ANY_VALUE','ANY_VAL"
  "UE(arg)\\n\\nThis function is useful for GROUP BY queries when the\\nONLY_FULL_GROUP_BY SQL mode is enabled, for cases w"
  "hen MySQL rejects a\\nquery that you know is valid for reasons that MySQL cannot determine.\\nThe function return value"
  " and type are the same as the return value and\\ntype of its argument, but the function result is not checked for the\\"
  "nONLY_FULL_GROUP_BY SQL mode.\\n\\nFor example, if name is a nonindexed column, the following query fails\\nwith ONLY_FU"
  "LL_GROUP_BY enabled:\\n\\nmysql> SELECT name, address, MAX(age) FROM t GROUP BY name;\\nERROR 1055 (42000): Expression #"
  "2 of SELECT list is not in GROUP\\nBY clause and contains nonaggregated column \\'mydb.t.address\\' which\\nis not functi"
  "onally dependent on columns in GROUP BY clause; this\\nis incompatible with sql_mode=only_full_group_by\\n\\nThe failure"
  " occurs because address is a nonaggregated column that is\\nneither named among GROUP BY columns nor functionally depe"
  "ndent on\\nthem. As a result, the address value for rows within each name group is\\nnondeterministic. There are multip"
  "le ways to cause MySQL to accept the\\nquery:\\n\\no Alter the table to make name a primary key or a unique NOT NULL\\n  "
  "column. This enables MySQL to determine that address is functionally\\n  dependent on name; that is, address is unique"
  "ly determined by name.\\n  (This technique is inapplicable if NULL must be permitted as a valid\\n  name value.)\\n\\no U"
  "se ANY_VALUE() to refer to address:\\n\\nSELECT name, ANY_VALUE(address), MAX(age) FROM t GROUP BY name;\\n\\n  In this c"
  "ase, MySQL ignores the nondeterminism of address values\\n  within each name group and accepts the query. This may be "
  "useful if\\n  you simply do not care which value of a nonaggregated column is\\n  chosen for each group. ANY_VALUE() is"
  " not an aggregate function,\\n  unlike functions such as SUM() or COUNT(). It simply acts to suppress\\n  the test for "
  "nondeterminism.\\n\\no Disable ONLY_FULL_GROUP_BY. This is equivalent to using ANY_VALUE()\\n  with ONLY_FULL_GROUP_BY e"
  "nabled, as described in the previous item.\\n\\nANY_VALUE() is also useful if functional dependence exists between\\ncol"
  "umns but MySQL cannot determine it. The following query is valid\\nbecause age is functionally dependent on the groupi"
  "ng column age-1, but\\nMySQL cannot tell that and rejects the query with ONLY_FULL_GROUP_BY\\nenabled:\\n\\nSELECT age FR"
  "OM t GROUP BY age-1;\\n\\nTo cause MySQL to accept the query, use ANY_VALUE():\\n\\nSELECT ANY_VALUE(age) FROM t GROUP BY"
  " age-1;\\n\\nANY_VALUE() can be used for queries that refer to aggregate functions\\nin the absence of a GROUP BY clause"
  ":\\n\\nmysql> SELECT name, MAX(age) FROM t;\\nERROR 1140 (42000): In aggregated query without GROUP BY, expression\\n#1 o"
  "f SELECT list contains nonaggregated column \\'mydb.t.name\\'; this\\nis incompatible with sql_mode=only_full_group_by\\n"
  "\\nWithout GROUP BY, there is a single group and it is nondeterministic\\nwhich name value to choose for the group. ANY"
  "_VALUE() tells MySQL to\\naccept the query:\\n\\nSELECT ANY_VALUE(name), MAX(age) FROM t;\\n\\nIt may be that, due to some"
  " property of a given data set, you know that\\na selected nonaggregated column is effectively functionally dependent\\n"
  "on a GROUP BY column. For example, an application may enforce\\nuniqueness of one column with respect to another. In t"
  "his case, using\\nANY_VALUE() for the effectively functionally dependent column may make\\nsense.\\n\\nFor additional dis"
  "cussion, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/group-by-handling.html.\\n\\nURL: https://dev.mysql.com/doc/refma"
  "n/8.4/en/miscellaneous-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (483,39,'BIN_TO_UUID','BIN_T"
  "O_UUID(binary_uuid), BIN_TO_UUID(binary_uuid, swap_flag)\\n\\nBIN_TO_UUID() is the inverse of UUID_TO_BIN(). It convert"
  "s a binary\\nUUID to a string UUID and returns the result. The binary value should\\nbe a UUID as a VARBINARY(16) value"
  ". The return value is a string of\\nfive hexadecimal numbers separated by dashes. (For details about this\\nformat, see"
  " the UUID() function description.) If the UUID argument is\\nNULL, the return value is NULL. If any argument is invali"
  "d, an error\\noccurs.\\n\\nBIN_TO_UUID() takes one or two arguments:\\n\\no The one-argument form takes a binary UUID valu"
  "e. The UUID value is\\n  assumed not to have its time-low and time-high parts swapped. The\\n  string result is in the "
  "same order as the binary argument.\\n\\no The two-argument form takes a binary UUID value and a swap-flag\\n  value:\\n\\n"
  "  o If swap_flag is 0, the two-argument form is equivalent to the\\n    one-argument form. The string result is in the"
  " same order as the\\n    binary argument.\\n\\n  o If swap_flag is 1, the UUID value is assumed to have its time-low\\n  "
  "  and time-high parts swapped. These parts are swapped back to their\\n    original position in the result value.\\n\\nF"
  "or usage examples and information about time-part swapping, see the\\nUUID_TO_BIN() function description.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/mis"
  "cellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (484,39,'DEFAULT','Syntax:\\n"
  "DEFAULT(col_name)\\n\\nReturns the default value for a table column. An error results if the\\ncolumn has no default val"
  "ue.\\n\\nThe use of DEFAULT(col_name) to specify the default value for a named\\ncolumn is permitted only for columns th"
  "at have a literal default value,\\nnot for columns that have an expression default value.\\n\\nURL: https://dev.mysql.co"
  "m/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\\n','https"
  "://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (485,39,'GROUPING','GROUPING"
  "(expr [, expr] ...)\\n\\nFor GROUP BY queries that include a WITH ROLLUP modifier, the ROLLUP\\noperation produces super"
  "-aggregate output rows where NULL represents\\nthe set of all values. The GROUPING() function enables you to\\ndistingu"
  "ish NULL values for super-aggregate rows from NULL values in\\nregular grouped rows.\\n\\nGROUPING() is permitted in the"
  " select list, HAVING clause, and ORDER BY\\nclause.\\n\\nEach argument to GROUPING() must be an expression that exactly "
  "matches\\nan expression in the GROUP BY clause. The expression cannot be a\\npositional specifier. For each expression,"
  " GROUPING() produces 1 if the\\nexpression value in the current row is a NULL representing a\\nsuper-aggregate value. O"
  "therwise, GROUPING() produces 0, indicating\\nthat the expression value is a NULL for a regular result row or is not\\n"
  "NULL.\\n\\nSuppose that table t1 contains these rows, where NULL indicates\\nsomething like \"other\" or \"unknown\":\\n\\"
  "nmysql> SELECT * FROM t1;\\n+------+-------+----------+\\n| name | size  | quantity |\\n+------+-------+----------+\\n| b"
  "all | small |       10 |\\n| ball | large |       20 |\\n| ball | NULL  |        5 |\\n| hoop | small |       15 |\\n| ho"
  "op | large |        5 |\\n| hoop | NULL  |        3 |\\n+------+-------+----------+\\n\\nA summary of the table without W"
  "ITH ROLLUP looks like this:\\n\\nmysql> SELECT name, size, SUM(quantity) AS quantity\\n       FROM t1\\n       GROUP BY n"
  "ame, size;\\n+------+-------+----------+\\n| name | size  | quantity |\\n+------+-------+----------+\\n| ball | small |  "
  "     10 |\\n| ball | large |       20 |\\n| ball | NULL  |        5 |\\n| hoop | small |       15 |\\n| hoop | large |   "
  "     5 |\\n| hoop | NULL  |        3 |\\n+------+-------+----------+\\n\\nThe result contains NULL values, but those do n"
  "ot represent\\nsuper-aggregate rows because the query does not include WITH ROLLUP.\\n\\nAdding WITH ROLLUP produces sup"
  "er-aggregate summary rows containing\\nadditional NULL values. However, without comparing this result to the\\nprevious"
  " one, it is not easy to see which NULL values occur in\\nsuper-aggregate rows and which occur in regular grouped rows:"
  "\\n\\nmysql> SELECT name, size, SUM(quantity) AS quantity\\n       FROM t1\\n       GROUP BY name, size WITH ROLLUP;\\n+--"
  "----+-------+----------+\\n| name | size  | quantity |\\n+------+-------+----------+\\n| ball | NULL  |        5 |\\n| ba"
  "ll | large |       20 |\\n| ball | small |       10 |\\n| ball | NULL  |       35 |\\n| hoop | NULL  |        3 |\\n| hoo"
  "p | large |        5 |\\n| hoop | small |       15 |\\n| hoop | NULL  |       23 |\\n| NULL | NULL  |       58 |\\n+-----"
  "-+-------+----------+\\n\\nTo distinguish NULL values in super-aggregate rows from those in\\nregular grouped rows, use "
  "GROUPING(), which returns 1 only for\\nsuper-aggregate NULL values:\\n\\nmysql> SELECT\\n         name, size, SUM(quantit"
  "y) AS quantity,\\n         GROUPING(name) AS grp_name,\\n         GROUPING(size) AS grp_size\\n       FROM t1\\n       GR"
  "OUP BY name, size WITH ROLLUP;\\n+------+-------+----------+----------+----------+\\n| name | size  | quantity | grp_na"
  "me | grp_size |\\n+------+-------+----------+----------+----------+\\n| ball | NULL  |        5 |        0 |        0 |"
  "\\n| ball | large |       20 |        0 |        0 |\\n| ball | small |       10 |        0 |        0 |\\n| ball | NULL"
  "  |       35 |        0 |        1 |\\n| hoop | NULL  |        3 |        0 |        0 |\\n| hoop | large |        5 | "
  "       0 |        0 |\\n| hoop | small |       15 |        0 |        0 |\\n| hoop | NULL  |       23 |        0 |     "
  "   1 |\\n| NULL | NULL  |       58 |        1 |        1 |\\n+------+-------+----------+----------+----------+\\n\\nCommo"
  "n uses for GROUPING():\\n\\no Substitute a label for super-aggregate NULL values:\\n\\nmysql> SELECT\\n         IF(GROUPIN"
  "G(name) = 1, \\'All items\\', name) AS name,\\n         IF(GROUPING(size) = 1, \\'All sizes\\', size) AS size,\\n         S"
  "UM(quantity) AS quantity\\n       FROM t1\\n       GROUP BY name, size WITH ROLLUP;\\n+-----------+-----------+---------"
  "-+\\n| name      | size      | quantity |\\n+-----------+-----------+----------+\\n| ball      | NULL      |        5 |\\"
  "n| ball      | large     |       20 |\\n| ball      | small     |       10 |\\n| ball      | All sizes |       35 |\\n| "
  "hoop      | NULL      |        3 |\\n| hoop      | large     |        5 |\\n| hoop      | small     |       15 |\\n| hoo"
  "p      | All sizes |       23 |\\n| All items | All sizes |       58 |\\n+-----------+-----------+----------+\\n\\no Retu"
  "rn only super-aggregate lines by filtering out the regular\\n  grouped lines:\\n\\nmysql> SELECT name, size, SUM(quantit"
  "y) AS quantity\\n       FROM t1\\n       GROUP BY name, size WITH ROLLUP\\n       HAVING GROUPING(name) = 1 OR GROUPING("
  "size) = 1;\\n+------+------+----------+\\n| name | size | quantity |\\n+------+------+----------+\\n| ball | NULL |      "
  " 35 |\\n| hoop | NULL |       23 |\\n| NULL | NULL |       58 |\\n+------+------+----------+\\n\\nGROUPING() permits multi"
  "ple expression arguments. In this case, the\\nGROUPING() return value represents a bitmask combined from the results\\n"
  "for each expression, where the lowest-order bit corresponds to the\\nresult for the rightmost expression. For example,"
  " with three expression\\narguments, GROUPING(expr1, expr2, expr3) is evaluated like this:\\n\\n  result for GROUPING(exp"
  "r3)\\n+ result for GROUPING(expr2) << 1\\n+ result for GROUPING(expr1) << 2\\n\\nThe following query shows how GROUPING()"
  " results for single arguments\\ncombine for a multiple-argument call to produce a bitmask value:\\n\\nmysql> SELECT\\n   "
  "      name, size, SUM(quantity) AS quantity,\\n         GROUPING(name) AS grp_name,\\n         GROUPING(size) AS grp_si"
  "ze,\\n       GROUPING(name, size) AS grp_all\\n       FROM t1\\n       GROUP BY name, size WITH ROLLUP;\\n+------+-------"
  "+----------+----------+----------+---------+\\n| name | size  | quantity | grp_name | grp_size | grp_all |\\n+------+--"
  "-----+----------+----------+----------+---------+\\n| ball | NULL  |        5 |        0 |        0 |       0 |\\n| bal"
  "l | large |       20 |        0 |        0 |       0 |\\n| ball | small |       10 |        0 |        0 |       0 |\\n"
  "| ball | NULL  |       35 |        0 |        1 |       1 |\\n| hoop | NULL  |        3 |        0 |        0 |       "
  "0 |\\n| hoop | large |        5 |        0 |        0 |       0 |\\n| hoop | small |       15 |        0 |        0 |  "
  "     0 |\\n| hoop | NULL  |       23 |        0 |        1 |       1 |\\n| NULL | NULL  |       58 |        1 |        "
  "1 |       3 |\\n+------+-------+----------+----------+----------+---------+\\n\\nWith multiple expression arguments, the"
  " GROUPING() return value is\\nnonzero if any expression represents a super-aggregate value.\\nMultiple-argument GROUPIN"
  "G() syntax thus provides a simpler way to\\nwrite the earlier query that returned only super-aggregate rows, by\\nusing"
  " a single multiple-argument GROUPING() call rather than multiple\\nsingle-argument calls:\\n\\nmysql> SELECT name, size,"
  " SUM(quantity) AS quantity\\n       FROM t1\\n       GROUP BY name, size WITH ROLLUP\\n       HAVING GROUPING(name, size"
  ") <> 0;\\n+------+------+----------+\\n| name | size | quantity |\\n+------+------+----------+\\n| ball | NULL |       35"
  " |\\n| hoop | NULL |       23 |\\n| NULL | NULL |       58 |\\n+------+------+----------+\\n\\nUse of GROUPING() is subjec"
  "t to these limitations:\\n\\no Do not use subquery GROUP BY expressions as GROUPING() arguments\\n  because matching mig"
  "ht fail. For example, matching fails for this\\n  query:\\n\\nmysql> SELECT GROUPING((SELECT MAX(name) FROM t1))\\n      "
  " FROM t1\\n       GROUP BY (SELECT MAX(name) FROM t1) WITH ROLLUP;\\nERROR 3580 (HY000): Argument #1 of GROUPING functi"
  "on is not in GROUP BY\\n\\no GROUP BY literal expressions should not be used within a HAVING\\n  clause as GROUPING() ar"
  "guments. Due to differences between when the\\n  optimizer evaluates GROUP BY and HAVING, matching may succeed but\\n  "
  "GROUPING() evaluation does not produce the expected result. Consider\\n  this query:\\n\\nSELECT a AS f1, \\'w\\' AS f2\\nF"
  "ROM t\\nGROUP BY f1, f2 WITH ROLLUP\\nHAVING GROUPING(f2) = 1;\\n\\n  GROUPING() is evaluated earlier for the literal con"
  "stant expression\\n  than for the HAVING clause as a whole and returns 0. To check whether\\n  a query such as this is "
  "affected, use EXPLAIN and look for Impossible\\n  having in the Extra column.\\n\\nURL: https://dev.mysql.com/doc/refman"
  "/8.4/en/miscellaneous-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (486,39,'INET_ATON','Syntax:"
  "\\nINET_ATON(expr)\\n\\nGiven the dotted-quad representation of an IPv4 network address as a\\nstring, returns an integer"
  " that represents the numeric value of the\\naddress in network byte order (big endian). INET_ATON() returns NULL if\\ni"
  "t does not understand its argument, or if expr is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous"
  "-functions.html\\n\\n','mysql> SELECT INET_ATON(\\'10.0.5.9\\');\\n        -> 167773449\\n','https://dev.mysql.com/doc/refm"
  "an/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (487,39,'INET_NTOA','Syntax:"
  "\\nINET_NTOA(expr)\\n\\nGiven a numeric IPv4 network address in network byte order, returns the\\ndotted-quad string repr"
  "esentation of the address as a string in the\\nconnection character set. INET_NTOA() returns NULL if it does not\\nunde"
  "rstand its argument.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT"
  " INET_NTOA(167773449);\\n        -> \\'10.0.5.9\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (488,39,'INET6_ATON','Syntax"
  ":\\nINET6_ATON(expr)\\n\\nGiven an IPv6 or IPv4 network address as a string, returns a binary\\nstring that represents th"
  "e numeric value of the address in network byte\\norder (big endian). Because numeric-format IPv6 addresses require mor"
  "e\\nbytes than the largest integer type, the representation returned by\\nthis function has the VARBINARY data type: VA"
  "RBINARY(16) for IPv6\\naddresses and VARBINARY(4) for IPv4 addresses. If the argument is not a\\nvalid address, or if i"
  "t is NULL, INET6_ATON() returns NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\"
  "n','mysql> SELECT HEX(INET6_ATON(\\'fdfe::5a55:caff:fefa:9089\\'));\\n        -> \\'FDFE0000000000005A55CAFFFEFA9089\\'\\nm"
  "ysql> SELECT HEX(INET6_ATON(\\'10.0.5.9\\'));\\n        -> \\'0A000509\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/misc"
  "ellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (489,39,'INET6_NTOA','Syntax"
  ":\\nINET6_NTOA(expr)\\n\\nGiven an IPv6 or IPv4 network address represented in numeric form as a\\nbinary string, returns"
  " the string representation of the address as a\\nstring in the connection character set. If the argument is not a vali"
  "d\\naddress, or if it is NULL, INET6_NTOA() returns NULL.\\n\\nINET6_NTOA() has these properties:\\n\\no It does not use o"
  "perating system functions to perform conversions,\\n  thus the output string is platform independent.\\n\\no The return "
  "string has a maximum length of 39 (4 x 8 + 7). Given this\\n  statement:\\n\\nCREATE TABLE t AS SELECT INET6_NTOA(expr) "
  "AS c1;\\n\\n  The resulting table would have this definition:\\n\\nCREATE TABLE t (c1 VARCHAR(39) CHARACTER SET utf8mb3 D"
  "EFAULT NULL);\\n\\no The return string uses lowercase letters for IPv6 addresses.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT INET6_NTOA(INET6_ATON(\\'fdfe::5a55:caff:fefa:9089\\'));\\n "
  "       -> \\'fdfe::5a55:caff:fefa:9089\\'\\nmysql> SELECT INET6_NTOA(INET6_ATON(\\'10.0.5.9\\'));\\n        -> \\'10.0.5.9\\'"
  "\\n\\nmysql> SELECT INET6_NTOA(UNHEX(\\'FDFE0000000000005A55CAFFFEFA9089\\'));\\n        -> \\'fdfe::5a55:caff:fefa:9089\\'\\"
  "nmysql> SELECT INET6_NTOA(UNHEX(\\'0A000509\\'));\\n        -> \\'10.0.5.9\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/"
  "miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (490,39,'IS_IPV4','Syntax:\\n"
  "IS_IPV4(expr)\\n\\nReturns 1 if the argument is a valid IPv4 address specified as a\\nstring, 0 otherwise. Returns NULL "
  "if expr is NULL.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT IS_"
  "IPV4(\\'10.0.5.9\\'), IS_IPV4(\\'10.0.5.256\\');\\n        -> 1, 0\\n','https://dev.mysql.com/doc/refman/8.4/en/miscellaneo"
  "us-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (491,39,'IS_IPV4_COMPAT','Sy"
  "ntax:\\nIS_IPV4_COMPAT(expr)\\n\\nThis function takes an IPv6 address represented in numeric form as a\\nbinary string, a"
  "s returned by INET6_ATON(). It returns 1 if the\\nargument is a valid IPv4-compatible IPv6 address, 0 otherwise (unles"
  "s\\nexpr is NULL, in which case the function returns NULL). IPv4-compatible\\naddresses have the form ::ipv4_address.\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT IS_IPV4_COMPAT(INET6_"
  "ATON(\\'::10.0.5.9\\'));\\n        -> 1\\nmysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\\'::ffff:10.0.5.9\\'));\\n        -> 0\\n'"
  ",'https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (492,39,'IS_IPV4_MAPPED','Sy"
  "ntax:\\nIS_IPV4_MAPPED(expr)\\n\\nThis function takes an IPv6 address represented in numeric form as a\\nbinary string, a"
  "s returned by INET6_ATON(). It returns 1 if the\\nargument is a valid IPv4-mapped IPv6 address, 0 otherwise, unless ex"
  "pr\\nis NULL, in which case the function returns NULL. IPv4-mapped addresses\\nhave the form ::ffff:ipv4_address.\\n\\nUR"
  "L: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT IS_IPV4_MAPPED(INET6_ATON"
  "(\\'::10.0.5.9\\'));\\n        -> 0\\nmysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\\'::ffff:10.0.5.9\\'));\\n        -> 1\\n','ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (493,39,'IS_IPV6','Syntax:\\n"
  "IS_IPV6(expr)\\n\\nReturns 1 if the argument is a valid IPv6 address specified as a\\nstring, 0 otherwise, unless expr i"
  "s NULL, in which case the function\\nreturns NULL. This function does not consider IPv4 addresses to be\\nvalid IPv6 ad"
  "dresses.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT IS_IPV6(\\'1"
  "0.0.5.9\\'), IS_IPV6(\\'::1\\');\\n        -> 0, 1\\n','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.ht"
  "ml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (494,39,'IS_UUID','IS_UUID(s"
  "tring_uuid)\\n\\nReturns 1 if the argument is a valid string-format UUID, 0 if the\\nargument is not a valid UUID, and N"
  "ULL if the argument is NULL.\\n\\n\"Valid\" means that the value is in a format that can be parsed. That\\nis, it has th"
  "e correct length and contains only the permitted\\ncharacters (hexadecimal digits in any lettercase and, optionally,\\n"
  "dashes and curly braces). This format is most common:\\n\\naaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\\n\\nThese other formats "
  "are also permitted:\\n\\naaaaaaaabbbbccccddddeeeeeeeeeeee\\n{aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee}\\n\\nFor the meanings o"
  "f fields within the value, see the UUID() function\\ndescription.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/misc"
  "ellaneous-functions.html\\n\\n','mysql> SELECT IS_UUID(\\'6ccd780c-baba-1026-9564-5b8c656024db\\');\\n+-------------------"
  "------------------------------+\\n| IS_UUID(\\'6ccd780c-baba-1026-9564-5b8c656024db\\') |\\n+----------------------------"
  "---------------------+\\n|                                               1 |\\n+---------------------------------------"
  "----------+\\nmysql> SELECT IS_UUID(\\'6CCD780C-BABA-1026-9564-5B8C656024DB\\');\\n+-------------------------------------"
  "------------+\\n| IS_UUID(\\'6CCD780C-BABA-1026-9564-5B8C656024DB\\') |\\n+----------------------------------------------"
  "---+\\n|                                               1 |\\n+-------------------------------------------------+\\nmysql"
  "> SELECT IS_UUID(\\'6ccd780cbaba102695645b8c656024db\\');\\n+---------------------------------------------+\\n| IS_UUID(\\"
  "'6ccd780cbaba102695645b8c656024db\\') |\\n+---------------------------------------------+\\n|                           "
  "                1 |\\n+---------------------------------------------+\\nmysql> SELECT IS_UUID(\\'{6ccd780c-baba-1026-956"
  "4-5b8c656024db}\\');\\n+---------------------------------------------------+\\n| IS_UUID(\\'{6ccd780c-baba-1026-9564-5b8c"
  "656024db}\\') |\\n+---------------------------------------------------+\\n|                                             "
  "    1 |\\n+---------------------------------------------------+\\nmysql> SELECT IS_UUID(\\'6ccd780c-baba-1026-9564-5b8c6"
  "560\\');\\n+---------------------------------------------+\\n| IS_UUID(\\'6ccd780c-baba-1026-9564-5b8c6560\\') |\\n+-------"
  "--------------------------------------+\\n|                                           0 |\\n+--------------------------"
  "-------------------+\\nmysql> SELECT IS_UUID(RAND());\\n+-----------------+\\n| IS_UUID(RAND()) |\\n+-----------------+\\n"
  "|               0 |\\n+-----------------+\\n','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (495,39,'NAME_CONST','Syntax"
  ":\\nNAME_CONST(name,value)\\n\\nReturns the given value. When used to produce a result set column,\\nNAME_CONST() causes "
  "the column to have the given name. The arguments\\nshould be constants.\\n\\nmysql> SELECT NAME_CONST(\\'myname\\', 14);\\n"
  "+--------+\\n| myname |\\n+--------+\\n|     14 |\\n+--------+\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellane"
  "ous-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (496,39,'SLEEP','Syntax:\\nSL"
  "EEP(duration)\\n\\nSleeps (pauses) for the number of seconds given by the duration\\nargument, then returns 0. The durat"
  "ion may have a fractional part. If\\nthe argument is NULL or negative, SLEEP() produces a warning, or an\\nerror in str"
  "ict SQL mode.\\n\\nWhen sleep returns normally (without interruption), it returns 0:\\n\\nmysql> SELECT SLEEP(1000);\\n+--"
  "-----------+\\n| SLEEP(1000) |\\n+-------------+\\n|           0 |\\n+-------------+\\n\\nWhen SLEEP() is the only thing in"
  "voked by a query that is interrupted,\\nit returns 1 and the query itself returns no error. This is true\\nwhether the "
  "query is killed or times out:\\n\\no This statement is interrupted using KILL QUERY from another session:\\n\\nmysql> SEL"
  "ECT SLEEP(1000);\\n+-------------+\\n| SLEEP(1000) |\\n+-------------+\\n|           1 |\\n+-------------+\\n\\no This state"
  "ment is interrupted by timing out:\\n\\nmysql> SELECT /*+ MAX_EXECUTION_TIME(1) */ SLEEP(1000);\\n+-------------+\\n| SLE"
  "EP(1000) |\\n+-------------+\\n|           1 |\\n+-------------+\\n\\nWhen SLEEP() is only part of a query that is interru"
  "pted, the query\\nreturns an error:\\n\\no This statement is interrupted using KILL QUERY from another session:\\n\\nmysql"
  "> SELECT 1 FROM t1 WHERE SLEEP(1000);\\nERROR 1317 (70100): Query execution was interrupted\\n\\no This statement is int"
  "errupted by timing out:\\n\\nmysql> SELECT /*+ MAX_EXECUTION_TIME(1000) */ 1 FROM t1 WHERE SLEEP(1000);\\nERROR 3024 (HY"
  "000): Query execution was interrupted, maximum statement\\nexecution time exceeded\\n\\nURL: https://dev.mysql.com/doc/r"
  "efman/8.4/en/miscellaneous-functions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.ht"
  "ml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (497,39,'UUID','Syntax:\\nUUI"
  "D()\\n\\nReturns a Universal Unique Identifier (UUID) generated according to RFC\\n4122, \"A Universally Unique IDentifi"
  "er (UUID) URN Namespace\"\\n(http://www.ietf.org/rfc/rfc4122.txt).\\n\\nA UUID is designed as a number that is globally "
  "unique in space and\\ntime. Two calls to UUID() are expected to generate two different\\nvalues, even if these calls ar"
  "e performed on two separate devices not\\nconnected to each other.\\n\\n*Warning*:\\n\\nAlthough UUID() values are intende"
  "d to be unique, they are not\\nnecessarily unguessable or unpredictable. If unpredictability is\\nrequired, UUID values"
  " should be generated some other way.\\n\\nUUID() returns a value that conforms to UUID version 1 as described in\\nRFC 4"
  "122. The value is a 128-bit number represented as a utf8mb3 string\\nof five hexadecimal numbers in aaaaaaaa-bbbb-cccc"
  "-dddd-eeeeeeeeeeee\\nformat:\\n\\no The first three numbers are generated from the low, middle, and high\\n  parts of a t"
  "imestamp. The high part also includes the UUID version\\n  number.\\n\\no The fourth number preserves temporal uniquenes"
  "s in case the timestamp\\n  value loses monotonicity (for example, due to daylight saving time).\\n\\no The fifth number"
  " is an IEEE 802 node number that provides spatial\\n  uniqueness. A random number is substituted if the latter is not\\"
  "n  available (for example, because the host device has no Ethernet card,\\n  or it is unknown how to find the hardware"
  " address of an interface on\\n  the host operating system). In this case, spatial uniqueness cannot\\n  be guaranteed. "
  "Nevertheless, a collision should have very low\\n  probability.\\n\\n  The MAC address of an interface is taken into acc"
  "ount only on\\n  FreeBSD, Linux, and Windows. On other operating systems, MySQL uses a\\n  randomly generated 48-bit nu"
  "mber.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT UUID();\\n     "
  "   -> \\'6ccd780c-baba-1026-9564-5b8c656024db\\'\\n','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.ht"
  "ml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (498,39,'UUID_SHORT','Syntax"
  ":\\nUUID_SHORT()\\n\\nReturns a \"short\" universal identifier as a 64-bit unsigned integer.\\nValues returned by UUID_SH"
  "ORT() differ from the string-format 128-bit\\nidentifiers returned by the UUID() function and have different\\nuniquene"
  "ss properties. The value of UUID_SHORT() is guaranteed to be\\nunique if the following conditions hold:\\n\\no The serve"
  "r_id value of the current server is between 0 and 255 and is\\n  unique among your set of source and replica servers\\n"
  "\\no You do not set back the system time for your server host between\\n  mysqld restarts\\n\\no You invoke UUID_SHORT() "
  "on average fewer than 16 million times per\\n  second between mysqld restarts\\n\\nThe UUID_SHORT() return value is cons"
  "tructed this way:\\n\\n  (server_id & 255) << 56\\n+ (server_startup_time_in_seconds << 24)\\n+ incremented_variable++;\\n"
  "\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','mysql> SELECT UUID_SHORT();\\n      "
  "  -> 92395783831158784\\n','https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (499,39,'UUID_TO_BIN','Synta"
  "x:\\nUUID_TO_BIN(string_uuid), UUID_TO_BIN(string_uuid, swap_flag)\\n\\nConverts a string UUID to a binary UUID and retu"
  "rns the result. (The\\nIS_UUID() function description lists the permitted string UUID\\nformats.) The return binary UUI"
  "D is a VARBINARY(16) value. If the UUID\\nargument is NULL, the return value is NULL. If any argument is invalid,\\nan "
  "error occurs.\\n\\nUUID_TO_BIN() takes one or two arguments:\\n\\no The one-argument form takes a string UUID value. The "
  "binary result is\\n  in the same order as the string argument.\\n\\no The two-argument form takes a string UUID value an"
  "d a flag value:\\n\\n  o If swap_flag is 0, the two-argument form is equivalent to the\\n    one-argument form. The bina"
  "ry result is in the same order as the\\n    string argument.\\n\\n  o If swap_flag is 1, the format of the return value "
  "differs: The\\n    time-low and time-high parts (the first and third groups of\\n    hexadecimal digits, respectively) "
  "are swapped. This moves the more\\n    rapidly varying part to the right and can improve indexing\\n    efficiency if t"
  "he result is stored in an indexed column.\\n\\nTime-part swapping assumes the use of UUID version 1 values, such as\\nar"
  "e generated by the UUID() function. For UUID values produced by other\\nmeans that do not follow version 1 format, tim"
  "e-part swapping provides\\nno benefit. For details about version 1 format, see the UUID() function\\ndescription.\\n\\nSu"
  "ppose that you have the following string UUID value:\\n\\nmysql> SET @uuid = \\'6ccd780c-baba-1026-9564-5b8c656024db\\';\\"
  "n\\nTo convert the string UUID to binary with or without time-part\\nswapping, use UUID_TO_BIN():\\n\\nmysql> SELECT HEX("
  "UUID_TO_BIN(@uuid));\\n+----------------------------------+\\n| HEX(UUID_TO_BIN(@uuid))          |\\n+------------------"
  "----------------+\\n| 6CCD780CBABA102695645B8C656024DB |\\n+----------------------------------+\\nmysql> SELECT HEX(UUID"
  "_TO_BIN(@uuid, 0));\\n+----------------------------------+\\n| HEX(UUID_TO_BIN(@uuid, 0))       |\\n+-------------------"
  "---------------+\\n| 6CCD780CBABA102695645B8C656024DB |\\n+----------------------------------+\\nmysql> SELECT HEX(UUID_"
  "TO_BIN(@uuid, 1));\\n+----------------------------------+\\n| HEX(UUID_TO_BIN(@uuid, 1))       |\\n+--------------------"
  "--------------+\\n| 1026BABA6CCD780C95645B8C656024DB |\\n+----------------------------------+\\n\\nTo convert a binary UU"
  "ID returned by UUID_TO_BIN() to a string UUID,\\nuse BIN_TO_UUID(). If you produce a binary UUID by calling\\nUUID_TO_B"
  "IN() with a second argument of 1 to swap time parts, you\\nshould also pass a second argument of 1 to BIN_TO_UUID() to"
  " unswap the\\ntime parts when converting the binary UUID back to a string UUID:\\n\\nmysql> SELECT BIN_TO_UUID(UUID_TO_B"
  "IN(@uuid));\\n+--------------------------------------+\\n| BIN_TO_UUID(UUID_TO_BIN(@uuid))      |\\n+-------------------"
  "-------------------+\\n| 6ccd780c-baba-1026-9564-5b8c656024db |\\n+--------------------------------------+\\nmysql> SELE"
  "CT BIN_TO_UUID(UUID_TO_BIN(@uuid,0),0);\\n+--------------------------------------+\\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,0)"
  ",0)  |\\n+--------------------------------------+\\n| 6ccd780c-baba-1026-9564-5b8c656024db |\\n+------------------------"
  "--------------+\\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid,1),1);\\n+--------------------------------------+\\n| BIN_"
  "TO_UUID(UUID_TO_BIN(@uuid,1),1)  |\\n+--------------------------------------+\\n| 6ccd780c-baba-1026-9564-5b8c656024db "
  "|\\n+--------------------------------------+\\n\\nIf the use of time-part swapping is not the same for the conversion in"
  "\\nboth directions, the original UUID is not recovered properly:\\n\\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid,0),1);"
  "\\n+--------------------------------------+\\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,0),1)  |\\n+------------------------------"
  "--------+\\n| baba1026-780c-6ccd-9564-5b8c656024db |\\n+--------------------------------------+\\nmysql> SELECT BIN_TO_U"
  "UID(UUID_TO_BIN(@uuid,1),0);\\n+--------------------------------------+\\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,1),0)  |\\n+--"
  "------------------------------------+\\n| 1026baba-6ccd-780c-9564-5b8c656024db |\\n+-----------------------------------"
  "---+\\n\\nIf UUID_TO_BIN() is invoked from within the mysql client, binary\\nstrings display using hexadecimal notation,"
  " depending on the value of\\nthe --binary-as-hex. For more information about that option, see\\nhttps://dev.mysql.com/d"
  "oc/refman/8.4/en/mysql.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','','ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (500,39,'VALUES','Syntax:\\nV"
  "ALUES(col_name)\\n\\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\\nVALUES(col_name) function in "
  "the UPDATE clause to refer to column\\nvalues from the INSERT portion of the statement. In other words,\\nVALUES(col_na"
  "me) in the UPDATE clause refers to the value of col_name\\nthat would be inserted, had no duplicate-key conflict occur"
  "red. This\\nfunction is especially useful in multiple-row inserts. The VALUES()\\nfunction is meaningful only in the ON"
  " DUPLICATE KEY UPDATE clause of\\nINSERT statements and returns NULL otherwise. See\\nhttps://dev.mysql.com/doc/refman/"
  "8.4/en/insert-on-duplicate.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html\\n\\n','m"
  "ysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\\n','htt"
  "ps://dev.mysql.com/doc/refman/8.4/en/miscellaneous-functions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (501,40,'ALTER DATABASE','Sy"
  "ntax:\\nALTER {DATABASE | SCHEMA} [db_name]\\n    alter_option ...\\n\\nalter_option: {\\n    [DEFAULT] CHARACTER SET [=] "
  "charset_name\\n  | [DEFAULT] COLLATE [=] collation_name\\n  | [DEFAULT] ENCRYPTION [=] {\\'Y\\' | \\'N\\'}\\n  | READ ONLY ["
  "=] {DEFAULT | 0 | 1}\\n}\\n\\nALTER DATABASE enables you to change the overall characteristics of a\\ndatabase. These cha"
  "racteristics are stored in the data dictionary. This\\nstatement requires the ALTER privilege on the database. ALTER S"
  "CHEMA is\\na synonym for ALTER DATABASE.\\n\\nIf the database name is omitted, the statement applies to the default\\ndat"
  "abase. In that case, an error occurs if there is no default\\ndatabase.\\n\\nFor any alter_option omitted from the state"
  "ment, the database retains\\nits current option value, with the exception that changing the\\ncharacter set may change "
  "the collation and vice versa.\\n\\no https://dev.mysql.com/doc/refman/8.4/en/alter-database.html#alter-dat\\n  abase-cha"
  "rset\\n\\no https://dev.mysql.com/doc/refman/8.4/en/alter-database.html#alter-dat\\n  abase-encryption\\n\\no https://dev."
  "mysql.com/doc/refman/8.4/en/alter-database.html#alter-dat\\n  abase-read-only\\n\\nCharacter Set and Collation Options\\n"
  "\\nThe CHARACTER SET option changes the default database character set.\\nThe COLLATE option changes the default databa"
  "se collation. For\\ninformation about character set and collation names, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/"
  "charset.html.\\n\\nTo see the available character sets and collations, use the SHOW\\nCHARACTER SET and SHOW COLLATION s"
  "tatements, respectively. See [HELP\\nSHOW CHARACTER SET], and [HELP SHOW COLLATION].\\n\\nA stored routine that uses the"
  " database defaults when the routine is\\ncreated includes those defaults as part of its definition. (In a stored\\nrout"
  "ine, variables with character data types use the database defaults\\nif the character set or collation are not specifi"
  "ed explicitly. See\\n[HELP CREATE PROCEDURE].) If you change the default character set or\\ncollation for a database, a"
  "ny stored routines that are to use the new\\ndefaults must be dropped and recreated.\\n\\nEncryption Option\\n\\nThe ENCRY"
  "PTION option, defines the default database encryption, which\\nis inherited by tables created in the database. The per"
  "mitted values\\nare \\'Y\\' (encryption enabled) and \\'N\\' (encryption disabled).\\n\\nThe mysql system schema cannot be s"
  "et to default encryption. The\\nexisting tables within it are part of the general mysql tablespace,\\nwhich may be encr"
  "ypted. The information_schema contains only views. It\\nis not possible to create any tables within it. There is nothi"
  "ng on the\\ndisk to encrypt. All tables in the performance_schema use the\\nPERFORMANCE_SCHEMA engine, which is purely "
  "in-memory. It is not\\npossible to create any other tables in it. There is nothing on the disk\\nto encrypt.\\n\\nOnly ne"
  "wly created tables inherit the default database encryption. For\\nexisting tables associated with the database, their "
  "encryption remains\\nunchanged. If the table_encryption_privilege_check system variable is\\nenabled, the TABLE_ENCRYPT"
  "ION_ADMIN privilege is required to specify a\\ndefault encryption setting that differs from the value of the\\ndefault_"
  "table_encryption system variable. For more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-data-encr"
  "yption.html#inn\\nodb-schema-tablespace-encryption-default.\\n\\nRead Only Option\\n\\nThe READ ONLY option controls wheth"
  "er to permit modification of the\\ndatabase and objects within it. The permitted values are DEFAULT or 0\\n(not read on"
  "ly) and 1 (read only). This option is useful for database\\nmigration because a database for which READ ONLY is enable"
  "d can be\\nmigrated to another MySQL instance without concern that the database\\nmight be changed during the operation"
  ".\\n\\nWith NDB Cluster, making a database read only on one mysqld server is\\nsynchronized to other mysqld servers in t"
  "he same cluster, so that the\\ndatabase becomes read only on all mysqld servers.\\n\\nThe READ ONLY option, if enabled, "
  "is displayed in the\\nINFORMATION_SCHEMA SCHEMATA_EXTENSIONS table. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/infor"
  "mation-schema-schemata-ext\\nensions-table.html.\\n\\nThe READ ONLY option cannot be enabled for these system schemas: m"
  "ysql,\\ninformation_schema, performance_schema.\\n\\nIn ALTER DATABASE statements, the READ ONLY option interacts with o"
  "ther\\ninstances of itself and with other options as follows:\\n\\no An error occurs if multiple instances of READ ONLY "
  "conflict (for\\n  example, READ ONLY = 1 READ ONLY = 0).\\n\\no An ALTER DATABASE statement that contains only (nonconfl"
  "icting) READ\\n  ONLY options is permitted even for a read-only database.\\n\\no A mix of (nonconflicting) READ ONLY opt"
  "ions with other options is\\n  permitted if the read-only state of the database either before or\\n  after the statemen"
  "t permits modifications. If the read-only state\\n  both before and after prohibits changes, an error occurs.\\n\\n  Thi"
  "s statement succeeds whether or not the database is read only:\\n\\nALTER DATABASE mydb READ ONLY = 0 DEFAULT COLLATE u"
  "tf8mb4_bin;\\n\\n  This statement succeeds if the database is not read only, but fails\\n  if it is already read only:\\n"
  "\\nALTER DATABASE mydb READ ONLY = 1 DEFAULT COLLATE utf8mb4_bin;\\n\\nEnabling READ ONLY affects all users of the datab"
  "ase, with these\\nexceptions that are not subject to read-only checks:\\n\\no Statements executed by the server as part "
  "of server initialization,\\n  restart, upgrade, or replication.\\n\\no Statements in a file named at server startup by t"
  "he init_file system\\n  variable.\\n\\no TEMPORARY tables; it is possible to create, alter, drop, and write to\\n  TEMPOR"
  "ARY tables in a read-only database.\\n\\no NDB Cluster non-SQL inserts and updates.\\n\\nOther than for the excepted oper"
  "ations just listed, enabling READ ONLY\\nprohibits write operations to the database and its objects, including\\ntheir "
  "definitions, data, and metadata. The following list details\\naffected SQL statements and operations:\\n\\no The databas"
  "e itself:\\n\\n  o CREATE DATABASE\\n\\n  o ALTER DATABASE (except to change the READ ONLY option)\\n\\n  o DROP DATABASE\\n"
  "\\no Views:\\n\\n  o CREATE VIEW\\n\\n  o ALTER VIEW\\n\\n  o DROP VIEW\\n\\n  o Selecting from views that invoke functions wi"
  "th side effects.\\n\\n  o Updating updatable views.\\n\\n  o Statements that create or drop objects in a writable databas"
  "e are\\n    rejected if they affect metadata of a view in a read-only database\\n    (for example, by making the view v"
  "alid or invalid).\\n\\no Stored routines:\\n\\n  o CREATE PROCEDURE\\n\\n  o DROP PROCEDURE\\n\\n  o CALL (of procedures with"
  " side effects)\\n\\n  o CREATE FUNCTION\\n\\n  o DROP FUNCTION\\n\\n  o SELECT (of functions with side effects)\\n\\n  o For "
  "procedures and functions, read-only checks follow prelocking\\n    behavior. For CALL statements, read-only checks are"
  " done on a\\n    per-statement basis, so if some conditionally executed statement\\n    writing to a read-only database"
  " does not actually execute, the call\\n    still succeeds. On the other hand, for a function called within a\\n    SELE"
  "CT, execution of the function body happens in prelocked mode.\\n    As long as a some statement within the function wr"
  "ites to a\\n    read-only database, execution of the function fails with an error\\n    regardless of whether the state"
  "ment actually executes.\\n\\no Triggers:\\n\\n  o CREATE TRIGGER\\n\\n  o DROP TRIGGER\\n\\n  o Trigger invocation.\\n\\no Even"
  "ts:\\n\\n  o CREATE EVENT\\n\\n  o ALTER EVENT\\n\\n  o DROP EVENT\\n\\n  o Event execution:\\n\\n    o Executing an event in t"
  "he database fails because that would\\n      change the last-execution timestamp, which is event metadata\\n      store"
  "d in the data dictionary. Failure of event execution also\\n      has the effect of causing the event scheduler to sto"
  "p.\\n\\n    o If an event writes to an object in a read-only database,\\n      execution of the event fails with an erro"
  "r, but the event\\n      scheduler is not stopped.\\n\\no Tables:\\n\\n  o CREATE TABLE\\n\\n  o ALTER TABLE\\n\\n  o CREATE I"
  "NDEX\\n\\n  o DROP INDEX\\n\\n  o RENAME TABLE\\n\\n  o TRUNCATE TABLE\\n\\n  o DROP TABLE\\n\\n  o DELETE\\n\\n  o INSERT\\n\\n  o"
  " IMPORT TABLE\\n\\n  o LOAD DATA\\n\\n  o LOAD XML\\n\\n  o REPLACE\\n\\n  o UPDATE\\n\\n  o For cascading foreign keys where t"
  "he child table is in a read-only\\n    database, updates and deletes on the parent are rejected even if\\n    the child"
  " table is not directly affected.\\n\\n  o For a MERGE table such as CREATE TABLE s1.t(i int) ENGINE MERGE\\n    UNION (s"
  "2.t, s3.t), INSERT_METHOD=..., the following behavior\\n    applies:\\n\\n    o Inserting into the MERGE table (INSERT i"
  "nto s1.t) fails if at\\n      least one of s1, s2, s3 is read only, regardless of insert\\n      method. The insert is "
  "refused even if it would actually end up in\\n      a writable table.\\n\\n    o Dropping the MERGE table (DROP TABLE s1"
  ".t) succeeds as long as s1\\n      is not read only. It is permitted to drop a MERGE table that\\n      refers to a rea"
  "d-only database.\\n\\nAn ALTER DATABASE statement blocks until all concurrent transactions\\nthat have already accessed "
  "an object in the database being altered have\\ncommitted. Conversely, a write transaction accessing an object in a\\nda"
  "tabase being altered in a concurrent ALTER DATABASE blocks until the\\nALTER DATABASE has committed.\\n\\nIf the Clone p"
  "lugin is used to clone a local or remote data directory,\\nthe databases in the clone retain the read-only state they "
  "had in the\\nsource data directory. The read-only state does not affect the cloning\\nprocess itself. If it is not desi"
  "rable to have the same database\\nread-only state in the clone, the option must be changed explicitly for\\nthe clone a"
  "fter the cloning process has finished, using ALTER DATABASE\\noperations on the clone.\\n\\nWhen cloning from a donor to"
  " a recipient, if the recipient has a user\\ndatabase that is read only, cloning fails with an error message.\\nCloning "
  "may be retried after making the database writable.\\n\\nREAD ONLY is permitted for ALTER DATABASE, but not for CREATE D"
  "ATABASE.\\nHowever, for a read-only database, the statement produced by SHOW\\nCREATE DATABASE does include READ ONLY=1"
  " within a comment to indicate\\nits read-only status:\\n\\nmysql> ALTER DATABASE mydb READ ONLY = 1;\\nmysql> SHOW CREATE"
  " DATABASE mydb\\\\G\\n*************************** 1. row ***************************\\n       Database: mydb\\nCreate Data"
  "base: CREATE DATABASE `mydb`\\n                 /*!40100 DEFAULT CHARACTER SET utf8mb4\\n                          COLL"
  "ATE utf8mb4_0900_ai_ci */\\n                 /*!80016 DEFAULT ENCRYPTION=\\'N\\' */\\n                 /* READ ONLY = 1 *"
  "/\\n\\nIf the server executes a CREATE DATABASE statement containing such a\\ncomment, the server ignores the comment an"
  "d the READ ONLY option is not\\nprocessed. This has implications for mysqldump, which uses SHOW CREATE\\nDATABASE to pr"
  "oduce CREATE DATABASE statements in dump output:\\n\\no In a dump file, the CREATE DATABASE statement for a read-only\\n"
  "  database contains the commented READ ONLY option.\\n\\no The dump file can be restored as usual, but because the serv"
  "er\\n  ignores the commented READ ONLY option, the restored database is not\\n  read only. If the database is to be rea"
  "d only after being restored,\\n  you must execute ALTER DATABASE manually to make it so.\\n\\nSuppose that mydb is read "
  "only and you dump it as follows:\\n\\n$> mysqldump --databases mydb > mydb.sql\\n\\nA restore operation later must be fol"
  "lowed by ALTER DATABASE if mydb\\nshould still be read only:\\n\\n$> mysql\\nmysql> SOURCE mydb.sql;\\nmysql> ALTER DATABA"
  "SE mydb READ ONLY = 1;\\n\\nMySQL Enterprise Backup is not subject to this issue. It backs up and\\nrestores a read-only"
  " database like any other, but enables the READ ONLY\\noption at restore time if it was enabled at backup time.\\n\\nALTE"
  "R DATABASE is written to the binary log, so a change to the READ\\nONLY option on a replication source server also aff"
  "ects replicas. To\\nprevent this from happening, binary logging must be disabled prior to\\nexecution of the ALTER DATA"
  "BASE statement. For example, to prepare for\\nmigrating a database without affecting replicas, perform these\\noperatio"
  "ns:\\n\\n1. Within a single session, disable binary logging and enable READ ONLY\\n   for the database:\\n\\nmysql> SET sq"
  "l_log_bin = OFF;\\nmysql> ALTER DATABASE mydb READ ONLY = 1;\\n\\n2. Dump the database, for example, with mysqldump:\\n\\n"
  "$> mysqldump --databases mydb > mydb.sql\\n\\n3. Within a single session, disable binary logging and disable READ\\n   O"
  "NLY for the database:\\n\\nmysql> SET sql_log_bin = OFF;\\nmysql> ALTER DATABASE mydb READ ONLY = 0;\\n\\nURL: https://dev"
  ".mysql.com/doc/refman/8.4/en/alter-database.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-database.html"
  "');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (502,40,'ALTER SCHEMA','Synt"
  "ax:\\nALTER {DATABASE | SCHEMA} [db_name]\\n    alter_option ...\\n\\nalter_option: {\\n    [DEFAULT] CHARACTER SET [=] ch"
  "arset_name\\n  | [DEFAULT] COLLATE [=] collation_name\\n  | [DEFAULT] ENCRYPTION [=] {\\'Y\\' | \\'N\\'}\\n  | READ ONLY [=]"
  " {DEFAULT | 0 | 1}\\n}\\n\\nALTER DATABASE enables you to change the overall characteristics of a\\ndatabase. These chara"
  "cteristics are stored in the data dictionary. This\\nstatement requires the ALTER privilege on the database. ALTER SCH"
  "EMA is\\na synonym for ALTER DATABASE.\\n\\nIf the database name is omitted, the statement applies to the default\\ndatab"
  "ase. In that case, an error occurs if there is no default\\ndatabase.\\n\\nFor any alter_option omitted from the stateme"
  "nt, the database retains\\nits current option value, with the exception that changing the\\ncharacter set may change th"
  "e collation and vice versa.\\n\\no https://dev.mysql.com/doc/refman/8.4/en/alter-database.html#alter-dat\\n  abase-chars"
  "et\\n\\no https://dev.mysql.com/doc/refman/8.4/en/alter-database.html#alter-dat\\n  abase-encryption\\n\\no https://dev.my"
  "sql.com/doc/refman/8.4/en/alter-database.html#alter-dat\\n  abase-read-only\\n\\nCharacter Set and Collation Options\\n\\n"
  "The CHARACTER SET option changes the default database character set.\\nThe COLLATE option changes the default database"
  " collation. For\\ninformation about character set and collation names, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/ch"
  "arset.html.\\n\\nTo see the available character sets and collations, use the SHOW\\nCHARACTER SET and SHOW COLLATION sta"
  "tements, respectively. See [HELP\\nSHOW CHARACTER SET], and [HELP SHOW COLLATION].\\n\\nA stored routine that uses the d"
  "atabase defaults when the routine is\\ncreated includes those defaults as part of its definition. (In a stored\\nroutin"
  "e, variables with character data types use the database defaults\\nif the character set or collation are not specified"
  " explicitly. See\\n[HELP CREATE PROCEDURE].) If you change the default character set or\\ncollation for a database, any"
  " stored routines that are to use the new\\ndefaults must be dropped and recreated.\\n\\nEncryption Option\\n\\nThe ENCRYPT"
  "ION option, defines the default database encryption, which\\nis inherited by tables created in the database. The permi"
  "tted values\\nare \\'Y\\' (encryption enabled) and \\'N\\' (encryption disabled).\\n\\nThe mysql system schema cannot be set"
  " to default encryption. The\\nexisting tables within it are part of the general mysql tablespace,\\nwhich may be encryp"
  "ted. The information_schema contains only views. It\\nis not possible to create any tables within it. There is nothing"
  " on the\\ndisk to encrypt. All tables in the performance_schema use the\\nPERFORMANCE_SCHEMA engine, which is purely in"
  "-memory. It is not\\npossible to create any other tables in it. There is nothing on the disk\\nto encrypt.\\n\\nOnly newl"
  "y created tables inherit the default database encryption. For\\nexisting tables associated with the database, their en"
  "cryption remains\\nunchanged. If the table_encryption_privilege_check system variable is\\nenabled, the TABLE_ENCRYPTIO"
  "N_ADMIN privilege is required to specify a\\ndefault encryption setting that differs from the value of the\\ndefault_ta"
  "ble_encryption system variable. For more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-data-encryp"
  "tion.html#inn\\nodb-schema-tablespace-encryption-default.\\n\\nRead Only Option\\n\\nThe READ ONLY option controls whether"
  " to permit modification of the\\ndatabase and objects within it. The permitted values are DEFAULT or 0\\n(not read only"
  ") and 1 (read only). This option is useful for database\\nmigration because a database for which READ ONLY is enabled "
  "can be\\nmigrated to another MySQL instance without concern that the database\\nmight be changed during the operation.\\"
  "n\\nWith NDB Cluster, making a database read only on one mysqld server is\\nsynchronized to other mysqld servers in the"
  " same cluster, so that the\\ndatabase becomes read only on all mysqld servers.\\n\\nThe READ ONLY option, if enabled, is"
  " displayed in the\\nINFORMATION_SCHEMA SCHEMATA_EXTENSIONS table. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/informa"
  "tion-schema-schemata-ext\\nensions-table.html.\\n\\nThe READ ONLY option cannot be enabled for these system schemas: mys"
  "ql,\\ninformation_schema, performance_schema.\\n\\nIn ALTER DATABASE statements, the READ ONLY option interacts with oth"
  "er\\ninstances of itself and with other options as follows:\\n\\no An error occurs if multiple instances of READ ONLY co"
  "nflict (for\\n  example, READ ONLY = 1 READ ONLY = 0).\\n\\no An ALTER DATABASE statement that contains only (nonconflic"
  "ting) READ\\n  ONLY options is permitted even for a read-only database.\\n\\no A mix of (nonconflicting) READ ONLY optio"
  "ns with other options is\\n  permitted if the read-only state of the database either before or\\n  after the statement "
  "permits modifications. If the read-only state\\n  both before and after prohibits changes, an error occurs.\\n\\n  This "
  "statement succeeds whether or not the database is read only:\\n\\nALTER DATABASE mydb READ ONLY = 0 DEFAULT COLLATE utf"
  "8mb4_bin;\\n\\n  This statement succeeds if the database is not read only, but fails\\n  if it is already read only:\\n\\n"
  "ALTER DATABASE mydb READ ONLY = 1 DEFAULT COLLATE utf8mb4_bin;\\n\\nEnabling READ ONLY affects all users of the databas"
  "e, with these\\nexceptions that are not subject to read-only checks:\\n\\no Statements executed by the server as part of"
  " server initialization,\\n  restart, upgrade, or replication.\\n\\no Statements in a file named at server startup by the"
  " init_file system\\n  variable.\\n\\no TEMPORARY tables; it is possible to create, alter, drop, and write to\\n  TEMPORAR"
  "Y tables in a read-only database.\\n\\no NDB Cluster non-SQL inserts and updates.\\n\\nOther than for the excepted operat"
  "ions just listed, enabling READ ONLY\\nprohibits write operations to the database and its objects, including\\ntheir de"
  "finitions, data, and metadata. The following list details\\naffected SQL statements and operations:\\n\\no The database "
  "itself:\\n\\n  o CREATE DATABASE\\n\\n  o ALTER DATABASE (except to change the READ ONLY option)\\n\\n  o DROP DATABASE\\n\\n"
  "o Views:\\n\\n  o CREATE VIEW\\n\\n  o ALTER VIEW\\n\\n  o DROP VIEW\\n\\n  o Selecting from views that invoke functions with"
  " side effects.\\n\\n  o Updating updatable views.\\n\\n  o Statements that create or drop objects in a writable database "
  "are\\n    rejected if they affect metadata of a view in a read-only database\\n    (for example, by making the view val"
  "id or invalid).\\n\\no Stored routines:\\n\\n  o CREATE PROCEDURE\\n\\n  o DROP PROCEDURE\\n\\n  o CALL (of procedures with s"
  "ide effects)\\n\\n  o CREATE FUNCTION\\n\\n  o DROP FUNCTION\\n\\n  o SELECT (of functions with side effects)\\n\\n  o For pr"
  "ocedures and functions, read-only checks follow prelocking\\n    behavior. For CALL statements, read-only checks are d"
  "one on a\\n    per-statement basis, so if some conditionally executed statement\\n    writing to a read-only database d"
  "oes not actually execute, the call\\n    still succeeds. On the other hand, for a function called within a\\n    SELECT"
  ", execution of the function body happens in prelocked mode.\\n    As long as a some statement within the function writ"
  "es to a\\n    read-only database, execution of the function fails with an error\\n    regardless of whether the stateme"
  "nt actually executes.\\n\\no Triggers:\\n\\n  o CREATE TRIGGER\\n\\n  o DROP TRIGGER\\n\\n  o Trigger invocation.\\n\\no Events"
  ":\\n\\n  o CREATE EVENT\\n\\n  o ALTER EVENT\\n\\n  o DROP EVENT\\n\\n  o Event execution:\\n\\n    o Executing an event in the"
  " database fails because that would\\n      change the last-execution timestamp, which is event metadata\\n      stored "
  "in the data dictionary. Failure of event execution also\\n      has the effect of causing the event scheduler to stop."
  "\\n\\n    o If an event writes to an object in a read-only database,\\n      execution of the event fails with an error,"
  " but the event\\n      scheduler is not stopped.\\n\\no Tables:\\n\\n  o CREATE TABLE\\n\\n  o ALTER TABLE\\n\\n  o CREATE IND"
  "EX\\n\\n  o DROP INDEX\\n\\n  o RENAME TABLE\\n\\n  o TRUNCATE TABLE\\n\\n  o DROP TABLE\\n\\n  o DELETE\\n\\n  o INSERT\\n\\n  o I"
  "MPORT TABLE\\n\\n  o LOAD DATA\\n\\n  o LOAD XML\\n\\n  o REPLACE\\n\\n  o UPDATE\\n\\n  o For cascading foreign keys where the"
  " child table is in a read-only\\n    database, updates and deletes on the parent are rejected even if\\n    the child t"
  "able is not directly affected.\\n\\n  o For a MERGE table such as CREATE TABLE s1.t(i int) ENGINE MERGE\\n    UNION (s2."
  "t, s3.t), INSERT_METHOD=..., the following behavior\\n    applies:\\n\\n    o Inserting into the MERGE table (INSERT int"
  "o s1.t) fails if at\\n      least one of s1, s2, s3 is read only, regardless of insert\\n      method. The insert is re"
  "fused even if it would actually end up in\\n      a writable table.\\n\\n    o Dropping the MERGE table (DROP TABLE s1.t"
  ") succeeds as long as s1\\n      is not read only. It is permitted to drop a MERGE table that\\n      refers to a read-"
  "only database.\\n\\nAn ALTER DATABASE statement blocks until all concurrent transactions\\nthat have already accessed an"
  " object in the database being altered have\\ncommitted. Conversely, a write transaction accessing an object in a\\ndata"
  "base being altered in a concurrent ALTER DATABASE blocks until the\\nALTER DATABASE has committed.\\n\\nIf the Clone plu"
  "gin is used to clone a local or remote data directory,\\nthe databases in the clone retain the read-only state they ha"
  "d in the\\nsource data directory. The read-only state does not affect the cloning\\nprocess itself. If it is not desira"
  "ble to have the same database\\nread-only state in the clone, the option must be changed explicitly for\\nthe clone aft"
  "er the cloning process has finished, using ALTER DATABASE\\noperations on the clone.\\n\\nWhen cloning from a donor to a"
  " recipient, if the recipient has a user\\ndatabase that is read only, cloning fails with an error message.\\nCloning ma"
  "y be retried after making the database writable.\\n\\nREAD ONLY is permitted for ALTER DATABASE, but not for CREATE DAT"
  "ABASE.\\nHowever, for a read-only database, the statement produced by SHOW\\nCREATE DATABASE does include READ ONLY=1 w"
  "ithin a comment to indicate\\nits read-only status:\\n\\nmysql> ALTER DATABASE mydb READ ONLY = 1;\\nmysql> SHOW CREATE D"
  "ATABASE mydb\\\\G\\n*************************** 1. row ***************************\\n       Database: mydb\\nCreate Databa"
  "se: CREATE DATABASE `mydb`\\n                 /*!40100 DEFAULT CHARACTER SET utf8mb4\\n                          COLLAT"
  "E utf8mb4_0900_ai_ci */\\n                 /*!80016 DEFAULT ENCRYPTION=\\'N\\' */\\n                 /* READ ONLY = 1 */\\"
  "n\\nIf the server executes a CREATE DATABASE statement containing such a\\ncomment, the server ignores the comment and "
  "the READ ONLY option is not\\nprocessed. This has implications for mysqldump, which uses SHOW CREATE\\nDATABASE to prod"
  "uce CREATE DATABASE statements in dump output:\\n\\no In a dump file, the CREATE DATABASE statement for a read-only\\n  "
  "database contains the commented READ ONLY option.\\n\\no The dump file can be restored as usual, but because the server"
  "\\n  ignores the commented READ ONLY option, the restored database is not\\n  read only. If the database is to be read "
  "only after being restored,\\n  you must execute ALTER DATABASE manually to make it so.\\n\\nSuppose that mydb is read on"
  "ly and you dump it as follows:\\n\\n$> mysqldump --databases mydb > mydb.sql\\n\\nA restore operation later must be follo"
  "wed by ALTER DATABASE if mydb\\nshould still be read only:\\n\\n$> mysql\\nmysql> SOURCE mydb.sql;\\nmysql> ALTER DATABASE"
  " mydb READ ONLY = 1;\\n\\nMySQL Enterprise Backup is not subject to this issue. It backs up and\\nrestores a read-only d"
  "atabase like any other, but enables the READ ONLY\\noption at restore time if it was enabled at backup time.\\n\\nALTER "
  "DATABASE is written to the binary log, so a change to the READ\\nONLY option on a replication source server also affec"
  "ts replicas. To\\nprevent this from happening, binary logging must be disabled prior to\\nexecution of the ALTER DATABA"
  "SE statement. For example, to prepare for\\nmigrating a database without affecting replicas, perform these\\noperations"
  ":\\n\\n1. Within a single session, disable binary logging and enable READ ONLY\\n   for the database:\\n\\nmysql> SET sql_"
  "log_bin = OFF;\\nmysql> ALTER DATABASE mydb READ ONLY = 1;\\n\\n2. Dump the database, for example, with mysqldump:\\n\\n$>"
  " mysqldump --databases mydb > mydb.sql\\n\\n3. Within a single session, disable binary logging and disable READ\\n   ONL"
  "Y for the database:\\n\\nmysql> SET sql_log_bin = OFF;\\nmysql> ALTER DATABASE mydb READ ONLY = 0;\\n\\nURL: https://dev.m"
  "ysql.com/doc/refman/8.4/en/alter-database.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-database.html')"
  ";\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (503,40,'ALTER EVENT','Synta"
  "x:\\nALTER\\n    [DEFINER = user]\\n    EVENT event_name\\n    [ON SCHEDULE schedule]\\n    [ON COMPLETION [NOT] PRESERVE]"
  "\\n    [RENAME TO new_event_name]\\n    [ENABLE | DISABLE | DISABLE ON {REPLICA | SLAVE}]\\n    [COMMENT \\'string\\']\\n  "
  "  [DO event_body]\\n\\nThe ALTER EVENT statement changes one or more of the characteristics of\\nan existing event witho"
  "ut the need to drop and recreate it. The syntax\\nfor each of the DEFINER, ON SCHEDULE, ON COMPLETION, COMMENT, ENABLE"
  " /\\nDISABLE, and DO clauses is exactly the same as when used with CREATE\\nEVENT. (See [HELP CREATE EVENT].)\\n\\nAny us"
  "er can alter an event defined on a database for which that user\\nhas the EVENT privilege. When a user executes a succ"
  "essful ALTER EVENT\\nstatement, that user becomes the definer for the affected event.\\n\\nALTER EVENT works only with a"
  "n existing event:\\n\\nmysql> ALTER EVENT no_such_event \\n     >     ON SCHEDULE \\n     >       EVERY \\'2:3\\' DAY_HOUR;"
  "\\nERROR 1517 (HY000): Unknown event \\'no_such_event\\'\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/alter-event.htm"
  "l\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-event.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (504,40,'ALTER FUNCTION','Sy"
  "ntax:\\nALTER FUNCTION func_name [characteristic ...]\\n\\ncharacteristic: {\\n    COMMENT \\'string\\'\\n  | LANGUAGE SQL\\n"
  "  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\\n  | SQL SECURITY { DEFINER | INVOKER }\\n}\\n\\nThis"
  " statement can be used to change the characteristics of a stored\\nfunction. More than one change may be specified in "
  "an ALTER FUNCTION\\nstatement. However, you cannot change the parameters or body of a\\nstored function using this stat"
  "ement; to make such changes, you must\\ndrop and re-create the function using DROP FUNCTION and CREATE\\nFUNCTION.\\n\\nY"
  "ou must have the ALTER ROUTINE privilege for the function. (That\\nprivilege is granted automatically to the function "
  "creator.) If binary\\nlogging is enabled, the ALTER FUNCTION statement might also require the\\nSUPER privilege, as des"
  "cribed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-programs-logging.html.\\n\\nURL: https://dev.mysql.com/doc/re"
  "fman/8.4/en/alter-function.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-function.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (505,40,'ALTER INSTANCE','Sy"
  "ntax:\\nALTER INSTANCE instance_action\\n\\ninstance_action: {\\n  | {ENABLE|DISABLE} INNODB REDO_LOG\\n  | ROTATE INNODB "
  "MASTER KEY\\n  | ROTATE BINLOG MASTER KEY\\n  | RELOAD TLS\\n      [FOR CHANNEL {mysql_main | mysql_admin}]\\n      [NO R"
  "OLLBACK ON ERROR]\\n  | RELOAD KEYRING\\n}\\n\\nALTER INSTANCE defines actions applicable to a MySQL server instance.\\nTh"
  "e statement supports these actions:\\n\\no ALTER INSTANCE {ENABLE | DISABLE} INNODB REDO_LOG\\n\\n  This action enables o"
  "r disables InnoDB redo logging. Redo logging is\\n  enabled by default. This feature is intended only for loading data"
  "\\n  into a new MySQL instance. The statement is not written to the binary\\n  log.\\n\\n  *Warning*:\\n\\n  Do not disable"
  " redo logging on a production system. While it is\\n  permitted to shut down and restart the server while redo logging"
  " is\\n  disabled, an unexpected server stoppage while redo logging is\\n  disabled can cause data loss and instance cor"
  "ruption.\\n\\n  An ALTER INSTANCE [ENABLE|DISABLE] INNODB REDO_LOG operation requires\\n  an exclusive backup lock, whic"
  "h prevents other ALTER INSTANCE\\n  operations from executing concurrently. Other ALTER INSTANCE\\n  operations must wa"
  "it for the lock to be released before executing.\\n\\n  For more information, see\\n  https://dev.mysql.com/doc/refman/8"
  ".4/en/innodb-redo-log.html#innodb-d\\n  isable-redo-logging.\\n\\no ALTER INSTANCE ROTATE INNODB MASTER KEY\\n\\n  This ac"
  "tion rotates the master encryption key used for InnoDB\\n  tablespace encryption. Key rotation requires the ENCRYPTION"
  "_KEY_ADMIN\\n  or SUPER privilege. To perform this action, a keyring plugin must be\\n  installed and configured. For i"
  "nstructions, see\\n  https://dev.mysql.com/doc/refman/8.4/en/keyring.html.\\n\\n  ALTER INSTANCE ROTATE INNODB MASTER KE"
  "Y supports concurrent DML.\\n  However, it cannot be run concurrently with CREATE TABLE ...\\n  ENCRYPTION or ALTER TAB"
  "LE ... ENCRYPTION operations, and locks are\\n  taken to prevent conflicts that could arise from concurrent execution\\"
  "n  of these statements. If one of the conflicting statements is running,\\n  it must complete before another can proce"
  "ed.\\n\\n  ALTER INSTANCE ROTATE INNODB MASTER KEY statements are written to the\\n  binary log so that they can be exec"
  "uted on replicated servers.\\n\\n  For additional ALTER INSTANCE ROTATE INNODB MASTER KEY usage\\n  information, see\\n  "
  "https://dev.mysql.com/doc/refman/8.4/en/innodb-data-encryption.html.\\n\\no ALTER INSTANCE ROTATE BINLOG MASTER KEY\\n\\n"
  "  This action rotates the binary log master key used for binary log\\n  encryption. Key rotation for the binary log ma"
  "ster key requires the\\n  BINLOG_ENCRYPTION_ADMIN or SUPER privilege. The statement cannot be\\n  used if the binlog_en"
  "cryption system variable is set to OFF. To\\n  perform this action, a keyring plugin must be installed and\\n  configur"
  "ed. For instructions, see\\n  https://dev.mysql.com/doc/refman/8.4/en/keyring.html.\\n\\n  ALTER INSTANCE ROTATE BINLOG "
  "MASTER KEY actions are not written to\\n  the binary log and are not executed on replicas. Binary log master\\n  key ro"
  "tation can therefore be carried out in replication environments\\n  including a mix of MySQL versions. To schedule reg"
  "ular rotation of\\n  the binary log master key on all applicable source and replica\\n  servers, you can enable the MyS"
  "QL Event Scheduler on each server and\\n  issue the ALTER INSTANCE ROTATE BINLOG MASTER KEY statement using a\\n  CREAT"
  "E EVENT statement. If you rotate the binary log master key\\n  because you suspect that the current or any of the prev"
  "ious binary\\n  log master keys might have been compromised, issue the statement on\\n  every applicable source and rep"
  "lica server, which enables you to\\n  verify immediate compliance.\\n\\n  For additional ALTER INSTANCE ROTATE BINLOG MA"
  "STER KEY usage\\n  information, including what to do if the process does not complete\\n  correctly or is interrupted b"
  "y an unexpected server halt, see\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-binlog-encryption\\n  .html.\\n"
  "\\no ALTER INSTANCE RELOAD TLS\\n\\n  This action reconfigures a TLS context from the current values of the\\n  system va"
  "riables that define the context. It also updates the status\\n  variables that reflect the active context values. This"
  " action\\n  requires the CONNECTION_ADMIN privilege. For additional information\\n  about reconfiguring the TLS context"
  ", including which system and\\n  status variables are context-related, see\\n  https://dev.mysql.com/doc/refman/8.4/en/"
  "using-encrypted-connections.h\\n  tml#using-encrypted-connections-server-side-runtime-configuration.\\n\\n  By default, "
  "the statement reloads the TLS context for the main\\n  connection interface. If the FOR CHANNEL clause is given, the\\n"
  "  statement reloads the TLS context for the named channel: mysql_main\\n  for the main connection interface, mysql_adm"
  "in for the administrative\\n  connection interface. For information about the different interfaces,\\n  see\\n  https://"
  "dev.mysql.com/doc/refman/8.4/en/connection-interfaces.html.\\n  The updated TLS context properties are exposed in the "
  "Performance\\n  Schema tls_channel_status table. See\\n  https://dev.mysql.com/doc/refman/8.4/en/performance-schema-tls"
  "-channe\\n  l-status-table.html.\\n\\n  Updating the TLS context for the main interface may also affect the\\n  administr"
  "ative interface because unless some nondefault TLS value is\\n  configured for that interface, it uses the same TLS co"
  "ntext as the\\n  main interface.\\n\\n  *Note*:\\n\\n  When you reload the TLS context, OpenSSL reloads the file containin"
  "g\\n  the CRL (certificate revocation list) as part of the process. If the\\n  CRL file is large, the server allocates "
  "a large chunk of memory (ten\\n  times the file size), which is doubled while the new instance is\\n  being loaded and "
  "the old one has not yet been released. The process\\n  resident memory is not immediately reduced after a large alloca"
  "tion\\n  is freed, so if you issue the ALTER INSTANCE RELOAD TLS statement\\n  repeatedly with a large CRL file, the pr"
  "ocess resident memory usage\\n  may grow as a result of this.\\n\\n  By default, the RELOAD TLS action rolls back with a"
  "n error and has no\\n  effect if the configuration values do not permit creation of the new\\n  TLS context. The previo"
  "us context values continue to be used for new\\n  connections. If the optional NO ROLLBACK ON ERROR clause is given an"
  "d\\n  the new context cannot be created, rollback does not occur. Instead,\\n  a warning is generated and encryption is"
  " disabled for new connections\\n  on the interface to which the statement applies.\\n\\n  ALTER INSTANCE RELOAD TLS stat"
  "ements are not written to the binary\\n  log (and thus are not replicated). TLS configuration is local and\\n  depends "
  "on local files not necessarily present on all servers\\n  involved.\\n\\no ALTER INSTANCE RELOAD KEYRING\\n\\n  If a keyri"
  "ng component is installed, this action tells the component\\n  to re-read its configuration file and reinitialize any "
  "keyring\\n  in-memory data. If you modify the component configuration at runtime,\\n  the new configuration does not ta"
  "ke effect until you perform this\\n  action. Keyring reloading requires the ENCRYPTION_KEY_ADMIN\\n  privilege.\\n\\n  Th"
  "is action enables reconfiguring only the currently installed\\n  keyring component. It does not enable changing which "
  "component is\\n  installed. For example, if you change the configuration for the\\n  installed keyring component, ALTER"
  " INSTANCE RELOAD KEYRING causes the\\n  new configuration to take effect. On the other hand, if you change\\n  the keyr"
  "ing component named in the server manifest file, ALTER\\n  INSTANCE RELOAD KEYRING has no effect and the current compo"
  "nent\\n  remains installed.\\n\\n  ALTER INSTANCE RELOAD KEYRING statements are not written to the\\n  binary log (and th"
  "us are not replicated).\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/alter-instance.html\\n\\n','','https://dev.mysq"
  "l.com/doc/refman/8.4/en/alter-instance.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (506,40,'ALTER LOGFILE GROUP"
  "','Syntax:\\nALTER LOGFILE GROUP logfile_group\\n    ADD UNDOFILE \\'file_name\\'\\n    [INITIAL_SIZE [=] size]\\n    [WAIT"
  "]\\n    ENGINE [=] engine_name\\n\\nThis statement adds an UNDO file named \\'file_name\\' to an existing log\\nfile group "
  "logfile_group. An ALTER LOGFILE GROUP statement has one and\\nonly one ADD UNDOFILE clause. No DROP UNDOFILE clause is"
  " currently\\nsupported.\\n\\n*Note*:\\n\\nAll NDB Cluster Disk Data objects share the same namespace. This means\\nthat eac"
  "h Disk Data object must be uniquely named (and not merely each\\nDisk Data object of a given type). For example, you c"
  "annot have a\\ntablespace and an undo log file with the same name, or an undo log file\\nand a data file with the same "
  "name.\\n\\nThe optional INITIAL_SIZE parameter sets the UNDO file\\'s initial size\\nin bytes; if not specified, the init"
  "ial size defaults to 134217728 (128\\nMB). You may optionally follow size with a one-letter abbreviation for\\nan order"
  " of magnitude, similar to those used in my.cnf. Generally, this\\nis one of the letters M (megabytes) or G (gigabytes)"
  ". (Bug #13116514,\\nBug #16104705, Bug #62858)\\n\\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\\n"
  "4294967296 (4 GB). (Bug #29186)\\n\\nThe minimum allowed value for INITIAL_SIZE is 1048576 (1 MB). (Bug\\n#29574)\\n\\n*No"
  "te*:\\n\\nWAIT is parsed but otherwise ignored. This keyword currently has no\\neffect, and is intended for future expan"
  "sion.\\n\\nThe ENGINE clause (required) determines the storage engine which is\\nused by this log file group, with engin"
  "e_name being the name of the\\nstorage engine. Currently, the only accepted values for engine_name are\\n\"NDBCLUSTER\""
  " and \"NDB\". The two values are equivalent.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/alter-logfile-group.html"
  "\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-logfile-group.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (507,40,'ALTER PROCEDURE','S"
  "yntax:\\nALTER PROCEDURE proc_name [characteristic ...]\\n\\ncharacteristic: {\\n    COMMENT \\'string\\'\\n  | LANGUAGE SQL"
  "\\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\\n  | SQL SECURITY { DEFINER | INVOKER }\\n}\\n\\nTh"
  "is statement can be used to change the characteristics of a stored\\nprocedure. More than one change may be specified "
  "in an ALTER PROCEDURE\\nstatement. However, you cannot change the parameters or body of a\\nstored procedure using this"
  " statement; to make such changes, you must\\ndrop and re-create the procedure using DROP PROCEDURE and CREATE\\nPROCEDU"
  "RE.\\n\\nYou must have the ALTER ROUTINE privilege for the procedure. By\\ndefault, that privilege is granted automatica"
  "lly to the procedure\\ncreator. This behavior can be changed by disabling the\\nautomatic_sp_privileges system variable"
  ". See\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-routines-privileges.html\\n.\\n\\nURL: https://dev.mysql.com/doc/r"
  "efman/8.4/en/alter-procedure.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-procedure.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (508,40,'ALTER SERVER','Synt"
  "ax:\\nALTER SERVER  server_name\\n    OPTIONS (option [, option] ...)\\n\\nAlters the server information for server_name,"
  " adjusting any of the\\noptions permitted in the CREATE SERVER statement. The corresponding\\nfields in the mysql.serve"
  "rs table are updated accordingly. This\\nstatement requires the SUPER privilege.\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/alter-server.html\\n\\n','ALTER SERVER s OPTIONS (USER \\'sally\\');\\n','https://dev.mysql.com/doc/refman/8.4/"
  "en/alter-server.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (509,40,'ALTER TABLE','Synta"
  "x:\\nALTER TABLE tbl_name\\n    [alter_option [, alter_option] ...]\\n    [partition_options]\\n\\nalter_option: {\\n    ta"
  "ble_options\\n  | ADD [COLUMN] col_name column_definition\\n        [FIRST | AFTER col_name]\\n  | ADD [COLUMN] (col_nam"
  "e column_definition,...)\\n  | ADD {INDEX | KEY} [index_name]\\n        [index_type] (key_part,...) [index_option] ...\\"
  "n  | ADD {FULLTEXT | SPATIAL} [INDEX | KEY] [index_name]\\n        (key_part,...) [index_option] ...\\n  | ADD [CONSTRA"
  "INT [symbol]] PRIMARY KEY\\n        [index_type] (key_part,...)\\n        [index_option] ...\\n  | ADD [CONSTRAINT [symb"
  "ol]] UNIQUE [INDEX | KEY]\\n        [index_name] [index_type] (key_part,...)\\n        [index_option] ...\\n  | ADD [CON"
  "STRAINT [symbol]] FOREIGN KEY\\n        [index_name] (col_name,...)\\n        reference_definition\\n  | ADD [CONSTRAINT"
  " [symbol]] CHECK (expr) [[NOT] ENFORCED]\\n  | DROP {CHECK | CONSTRAINT} symbol\\n  | ALTER {CHECK | CONSTRAINT} symbol"
  " [NOT] ENFORCED\\n  | ALGORITHM [=] {DEFAULT | INSTANT | INPLACE | COPY}\\n  | ALTER [COLUMN] col_name {\\n        SET D"
  "EFAULT {literal | (expr)}\\n      | SET {VISIBLE | INVISIBLE}\\n      | DROP DEFAULT\\n    }\\n  | ALTER INDEX index_name"
  " {VISIBLE | INVISIBLE}\\n  | CHANGE [COLUMN] old_col_name new_col_name column_definition\\n        [FIRST | AFTER col_n"
  "ame]\\n  | [DEFAULT] CHARACTER SET [=] charset_name [COLLATE [=] collation_name]\\n  | CONVERT TO CHARACTER SET charset"
  "_name [COLLATE collation_name]\\n  | {DISABLE | ENABLE} KEYS\\n  | {DISCARD | IMPORT} TABLESPACE\\n  | DROP [COLUMN] col"
  "_name\\n  | DROP {INDEX | KEY} index_name\\n  | DROP PRIMARY KEY\\n  | DROP FOREIGN KEY fk_symbol\\n  | FORCE\\n  | LOCK ["
  "=] {DEFAULT | NONE | SHARED | EXCLUSIVE}\\n  | MODIFY [COLUMN] col_name column_definition\\n        [FIRST | AFTER col_"
  "name]\\n  | ORDER BY col_name [, col_name] ...\\n  | RENAME COLUMN old_col_name TO new_col_name\\n  | RENAME {INDEX | KE"
  "Y} old_index_name TO new_index_name\\n  | RENAME [TO | AS] new_tbl_name\\n  | {WITHOUT | WITH} VALIDATION\\n}\\n\\npartiti"
  "on_options:\\n    partition_option [partition_option] ...\\n\\npartition_option: {\\n    ADD PARTITION (partition_definit"
  "ion)\\n  | DROP PARTITION partition_names\\n  | DISCARD PARTITION {partition_names | ALL} TABLESPACE\\n  | IMPORT PARTIT"
  "ION {partition_names | ALL} TABLESPACE\\n  | TRUNCATE PARTITION {partition_names | ALL}\\n  | COALESCE PARTITION number"
  "\\n  | REORGANIZE PARTITION partition_names INTO (partition_definitions)\\n  | EXCHANGE PARTITION partition_name WITH T"
  "ABLE tbl_name [{WITH | WITHOUT} VALIDATION]\\n  | ANALYZE PARTITION {partition_names | ALL}\\n  | CHECK PARTITION {part"
  "ition_names | ALL}\\n  | OPTIMIZE PARTITION {partition_names | ALL}\\n  | REBUILD PARTITION {partition_names | ALL}\\n  "
  "| REPAIR PARTITION {partition_names | ALL}\\n  | REMOVE PARTITIONING\\n}\\n\\nkey_part: {col_name [(length)] | (expr)} [A"
  "SC | DESC]\\n\\nindex_type:\\n    USING {BTREE | HASH}\\n\\nindex_option: {\\n    KEY_BLOCK_SIZE [=] value\\n  | index_type\\"
  "n  | WITH PARSER parser_name\\n  | COMMENT \\'string\\'\\n  | {VISIBLE | INVISIBLE}\\n}\\n\\ntable_options:\\n    table_optio"
  "n [[,] table_option] ...\\n\\ntable_option: {\\n    AUTOEXTEND_SIZE [=] value\\n  | AUTO_INCREMENT [=] value\\n  | AVG_ROW"
  "_LENGTH [=] value\\n  | [DEFAULT] CHARACTER SET [=] charset_name\\n  | CHECKSUM [=] {0 | 1}\\n  | [DEFAULT] COLLATE [=] "
  "collation_name\\n  | COMMENT [=] \\'string\\'\\n  | COMPRESSION [=] {\\'ZLIB\\' | \\'LZ4\\' | \\'NONE\\'}\\n  | CONNECTION [=] \\"
  "'connect_string\\'\\n  | {DATA | INDEX} DIRECTORY [=] \\'absolute path to directory\\'\\n  | DELAY_KEY_WRITE [=] {0 | 1}\\n"
  "  | ENCRYPTION [=] {\\'Y\\' | \\'N\\'}\\n  | ENGINE [=] engine_name\\n  | ENGINE_ATTRIBUTE [=] \\'string\\'\\n  | INSERT_METHO"
  "D [=] { NO | FIRST | LAST }\\n  | KEY_BLOCK_SIZE [=] value\\n  | MAX_ROWS [=] value\\n  | MIN_ROWS [=] value\\n  | PACK_K"
  "EYS [=] {0 | 1 | DEFAULT}\\n  | PASSWORD [=] \\'string\\'\\n  | ROW_FORMAT [=] {DEFAULT | DYNAMIC | FIXED | COMPRESSED | "
  "REDUNDANT | COMPACT}\\n  | SECONDARY_ENGINE_ATTRIBUTE [=] \\'string\\'\\n  | STATS_AUTO_RECALC [=] {DEFAULT | 0 | 1}\\n  |"
  " STATS_PERSISTENT [=] {DEFAULT | 0 | 1}\\n  | STATS_SAMPLE_PAGES [=] value\\n  | TABLESPACE tablespace_name [STORAGE {D"
  "ISK | MEMORY}]\\n  | UNION [=] (tbl_name[,tbl_name]...)\\n}\\n\\npartition_options:\\n    (see CREATE TABLE options)\\n\\nAL"
  "TER TABLE changes the structure of a table. For example, you can add\\nor delete columns, create or destroy indexes, c"
  "hange the type of\\nexisting columns, or rename columns or the table itself. You can also\\nchange characteristics such"
  " as the storage engine used for the table or\\nthe table comment.\\n\\no To use ALTER TABLE, you need ALTER, CREATE, and"
  " INSERT privileges for\\n  the table. Renaming a table requires ALTER and DROP on the old table,\\n  ALTER, CREATE, and"
  " INSERT on the new table.\\n\\no Following the table name, specify the alterations to be made. If none\\n  are given, AL"
  "TER TABLE does nothing.\\n\\no The syntax for many of the permissible alterations is similar to\\n  clauses of the CREAT"
  "E TABLE statement. column_definition clauses use\\n  the same syntax for ADD and CHANGE as for CREATE TABLE. For more\\"
  "n  information, see [HELP CREATE TABLE].\\n\\no The word COLUMN is optional and can be omitted, except for RENAME\\n  CO"
  "LUMN (to distinguish a column-renaming operation from the RENAME\\n  table-renaming operation).\\n\\no Multiple ADD, ALT"
  "ER, DROP, and CHANGE clauses are permitted in a\\n  single ALTER TABLE statement, separated by commas. This is a MySQL"
  "\\n  extension to standard SQL, which permits only one of each clause per\\n  ALTER TABLE statement. For example, to dr"
  "op multiple columns in a\\n  single statement, do this:\\n\\nALTER TABLE t2 DROP COLUMN c, DROP COLUMN d;\\n\\no If a stor"
  "age engine does not support an attempted ALTER TABLE\\n  operation, a warning may result. Such warnings can be display"
  "ed with\\n  SHOW WARNINGS. See [HELP SHOW WARNINGS]. For information on\\n  troubleshooting ALTER TABLE, see\\n  https:/"
  "/dev.mysql.com/doc/refman/8.4/en/alter-table-problems.html.\\n\\no For information about generated columns, see\\n  http"
  "s://dev.mysql.com/doc/refman/8.4/en/alter-table-generated-columns\\n  .html.\\n\\no For usage examples, see\\n  https://d"
  "ev.mysql.com/doc/refman/8.4/en/alter-table-examples.html.\\n\\no InnoDB supports addition of multi-valued indexes on JS"
  "ON columns\\n  using a key_part specification can take the form (CAST json_path AS\\n  type ARRAY). See\\n  https://dev."
  "mysql.com/doc/refman/8.4/en/create-index.html#create-inde\\n  x-multi-valued, for detailed information regarding multi"
  "-valued index\\n  creation and usage of, as well as restrictions and limitations on\\n  multi-valued indexes.\\n\\no With"
  " the mysql_info()\\n  (https://dev.mysql.com/doc/c-api/8.4/en/mysql-info.html) C API\\n  function, you can find out how"
  " many rows were copied by ALTER TABLE.\\n  See mysql_info()\\n  (https://dev.mysql.com/doc/c-api/8.4/en/mysql-info.html"
  ").\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/alter-table.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/"
  "alter-table.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (510,40,'ALTER TABLESPACE','"
  "Syntax:\\nALTER [UNDO] TABLESPACE tablespace_name\\n  NDB only:\\n    {ADD | DROP} DATAFILE \\'file_name\\'\\n    [INITIAL_"
  "SIZE [=] size]\\n    [WAIT]\\n  InnoDB and NDB:\\n    [RENAME TO tablespace_name]\\n  InnoDB only:\\n    [AUTOEXTEND_SIZE "
  "[=] \\'value\\']\\n    [SET {ACTIVE | INACTIVE}]\\n    [ENCRYPTION [=] {\\'Y\\' | \\'N\\'}]\\n  InnoDB and NDB:\\n    [ENGINE ["
  "=] engine_name]\\n  Reserved for future use:\\n    [ENGINE_ATTRIBUTE [=] \\'string\\']\\n\\nThis statement is used with NDB"
  " and InnoDB tablespaces. It can be used\\nto add a new data file to, or to drop a data file from an NDB\\ntablespace. I"
  "t can also be used to rename an NDB Cluster Disk Data\\ntablespace, rename an InnoDB general tablespace, encrypt an In"
  "noDB\\ngeneral tablespace, or mark an InnoDB undo tablespace as active or\\ninactive.\\n\\nThe UNDO keyword is used with "
  "the SET {ACTIVE | INACTIVE} clause to\\nmark an InnoDB undo tablespace as active or inactive. For more\\ninformation, s"
  "ee\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-undo-tablespaces.html.\\n\\nThe ADD DATAFILE variant enables you to "
  "specify an initial size for an\\nNDB Disk Data tablespace using an INITIAL_SIZE clause, where size is\\nmeasured in byt"
  "es; the default value is 134217728 (128 MB). You may\\noptionally follow size with a one-letter abbreviation for an or"
  "der of\\nmagnitude, similar to those used in my.cnf. Generally, this is one of\\nthe letters M (megabytes) or G (gigaby"
  "tes).\\n\\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\\n4294967296 (4 GB). (Bug #29186)\\n\\nINITI"
  "AL_SIZE is rounded, explicitly, as for CREATE TABLESPACE.\\n\\nOnce a data file has been created, its size cannot be ch"
  "anged; however,\\nyou can add more data files to an NDB tablespace using additional ALTER\\nTABLESPACE ... ADD DATAFILE"
  " statements.\\n\\nWhen ALTER TABLESPACE ... ADD DATAFILE is used with ENGINE = NDB, a\\ndata file is created on each Clu"
  "ster data node, but only one row is\\ngenerated in the Information Schema FILES table. See the description of\\nthis ta"
  "ble, as well as\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql-cluster-disk-data-objects\\n.html, for more information"
  ". ADD DATAFILE is not supported with InnoDB\\ntablespaces.\\n\\nUsing DROP DATAFILE with ALTER TABLESPACE drops the data"
  " file\\n\\'file_name\\' from an NDB tablespace. You cannot drop a data file from a\\ntablespace which is in use by any ta"
  "ble; in other words, the data file\\nmust be empty (no extents used). See\\nhttps://dev.mysql.com/doc/refman/8.4/en/mys"
  "ql-cluster-disk-data-objects\\n.html. In addition, any data file to be dropped must previously have\\nbeen added to the"
  " tablespace with CREATE TABLESPACE or ALTER\\nTABLESPACE. DROP DATAFILE is not supported with InnoDB tablespaces.\\n\\nW"
  "AIT is parsed but otherwise ignored. It is intended for future\\nexpansion.\\n\\nThe ENGINE clause, which specifies the "
  "storage engine used by the\\ntablespace, is deprecated, since the tablespace storage engine is known\\nby the data dict"
  "ionary, making the ENGINE clause obsolete. In MySQL\\n8.4, it is supported in the following two cases only:\\n\\nALTER T"
  "ABLESPACE tablespace_name ADD DATAFILE \\'file_name\\'\\n    ENGINE={NDB|NDBCLUSTER}\\n\\nALTER UNDO TABLESPACE tablespace"
  "_name SET {ACTIVE|INACTIVE}\\n    ENGINE=INNODB\\n\\nYou should expect the eventual removal of ENGINE from these stateme"
  "nts\\nas well, in a future version of MySQL.\\n\\nRENAME TO operations are implicitly performed in autocommit mode,\\nreg"
  "ardless of the value of autocommit.\\n\\nA RENAME TO operation cannot be performed while LOCK TABLES or FLUSH\\nTABLES W"
  "ITH READ LOCK is in effect for tables that reside in the\\ntablespace.\\n\\nExclusive metadata locks are taken on tables"
  " that reside in a general\\ntablespace while the tablespace is renamed, which prevents concurrent\\nDDL. Concurrent DML"
  " is supported.\\n\\nThe CREATE TABLESPACE privilege is required to rename an InnoDB general\\ntablespace.\\n\\nThe AUTOEXT"
  "END_SIZE option defines the amount by which InnoDB extends\\nthe size of a tablespace when it becomes full. The settin"
  "g must be a\\nmultiple of 4MB. The default setting is 0, which causes the tablespace\\nto be extended according to the "
  "implicit default behavior. For more\\ninformation, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-tablespace-auto"
  "extend-si\\nze.html.\\n\\nThe ENCRYPTION clause enables or disables page-level data encryption\\nfor an InnoDB general ta"
  "blespace or the mysql system tablespace.\\n\\nA keyring plugin must be installed and configured before encryption can\\n"
  "be enabled.\\n\\nIf the table_encryption_privilege_check variable is enabled, the\\nTABLE_ENCRYPTION_ADMIN privilege is "
  "required to alter a general\\ntablespace with an ENCRYPTION clause setting that differs from the\\ndefault_table_encryp"
  "tion setting.\\n\\nEnabling encryption for a general tablespace fails if any table in the\\ntablespace belongs to a sche"
  "ma defined with DEFAULT ENCRYPTION=\\'N\\'.\\nSimilarly, disabling encryption fails if any table in the general\\ntablesp"
  "ace belongs to a schema defined with DEFAULT ENCRYPTION=\\'Y\\'.\\n\\nIf an ALTER TABLESPACE statement executed on a gene"
  "ral tablespace does\\nnot include an ENCRYPTION clause, the tablespace retains its current\\nencryption status, regardl"
  "ess of the default_table_encryption setting.\\n\\nWhen a general tablespace or the mysql system tablespace is encrypted"
  ",\\nall tables residing in the tablespace are encrypted. Likewise, a table\\ncreated in an encrypted tablespace is encr"
  "ypted.\\n\\nThe INPLACE algorithm is used when altering the ENCRYPTION attribute of\\na general tablespace or the mysql "
  "system tablespace. The INPLACE\\nalgorithm permits concurrent DML on tables that reside in the\\ntablespace. Concurrent"
  " DDL is blocked.\\n\\nFor more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-data-encryption.html.\\n"
  "\\nThe ENGINE_ATTRIBUTE option is used to specify tablespace attributes\\nfor primary storage engines. The option is re"
  "served for future use.\\n\\nThe value assigned to this option is a string literal containing a\\nvalid JSON document or "
  "an empty string (\\'\\'). Invalid JSON is rejected.\\n\\nALTER TABLESPACE ts1 ENGINE_ATTRIBUTE=\\'{\"key\":\"value\"}\\';\\n"
  "\\nENGINE_ATTRIBUTE values can be repeated without error. In this case,\\nthe last specified value is used.\\n\\nENGINE_A"
  "TTRIBUTE values are not checked by the server, nor are they\\ncleared when the table\\'s storage engine is changed.\\n\\n"
  "It is not permitted to alter an individual element of a JSON attribute\\nvalue. You can only add or replace an attribu"
  "te.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/alter-tablespace.html\\n\\n','','https://dev.mysql.com/doc/refman/8"
  ".4/en/alter-tablespace.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (511,40,'ALTER VIEW','Syntax"
  ":\\nALTER\\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\\n    [DEFINER = user]\\n    [SQL SECURITY { DEFINER | INVO"
  "KER }]\\n    VIEW view_name [(column_list)]\\n    AS select_statement\\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\\n\\nTh"
  "is statement changes the definition of a view, which must exist. The\\nsyntax is similar to that for CREATE VIEW see ["
  "HELP CREATE VIEW]). This\\nstatement requires the CREATE VIEW and DROP privileges for the view,\\nand some privilege fo"
  "r each column referred to in the SELECT statement.\\nALTER VIEW is permitted only to the definer or users with the\\nSE"
  "T_ANY_DEFINER or ALLOW_NONEXISTENT_DEFINER privilege.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/alter-view.html"
  "\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/alter-view.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (512,40,'CREATE DATABASE','S"
  "yntax:\\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\\n    [create_option] ...\\n\\ncreate_option: [DEFAULT] {\\n  "
  "  CHARACTER SET [=] charset_name\\n  | COLLATE [=] collation_name\\n  | ENCRYPTION [=] {\\'Y\\' | \\'N\\'}\\n}\\n\\nCREATE DAT"
  "ABASE creates a database with the given name. To use this\\nstatement, you need the CREATE privilege for the database."
  " CREATE\\nSCHEMA is a synonym for CREATE DATABASE.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-database.htm"
  "l\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-database.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (513,40,'CREATE SCHEMA','Syn"
  "tax:\\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\\n    [create_option] ...\\n\\ncreate_option: [DEFAULT] {\\n    "
  "CHARACTER SET [=] charset_name\\n  | COLLATE [=] collation_name\\n  | ENCRYPTION [=] {\\'Y\\' | \\'N\\'}\\n}\\n\\nCREATE DATAB"
  "ASE creates a database with the given name. To use this\\nstatement, you need the CREATE privilege for the database. C"
  "REATE\\nSCHEMA is a synonym for CREATE DATABASE.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-database.html\\"
  "n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-database.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (514,40,'CREATE EVENT','Synt"
  "ax:\\nCREATE\\n    [DEFINER = user]\\n    EVENT\\n    [IF NOT EXISTS]\\n    event_name\\n    ON SCHEDULE schedule\\n    [ON "
  "COMPLETION [NOT] PRESERVE]\\n    [ENABLE | DISABLE | DISABLE ON {REPLICA | SLAVE}]\\n    [COMMENT \\'string\\']\\n    DO e"
  "vent_body;\\n\\nschedule: {\\n    AT timestamp [+ INTERVAL interval] ...\\n  | EVERY interval\\n    [STARTS timestamp [+ I"
  "NTERVAL interval] ...]\\n    [ENDS timestamp [+ INTERVAL interval] ...]\\n}\\n\\ninterval:\\n    quantity {YEAR | QUARTER "
  "| MONTH | DAY | HOUR | MINUTE |\\n              WEEK | SECOND | YEAR_MONTH | DAY_HOUR | DAY_MINUTE |\\n              DA"
  "Y_SECOND | HOUR_MINUTE | HOUR_SECOND | MINUTE_SECOND}\\n\\nThis statement creates and schedules a new event. The event "
  "does not\\nrun unless the Event Scheduler is enabled. For information about\\nchecking Event Scheduler status and enabl"
  "ing it if necessary, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/events-configuration.html.\\n\\nCREATE EVENT requires"
  " the EVENT privilege for the schema in which the\\nevent is to be created. If the DEFINER clause is present, the\\npriv"
  "ileges required depend on the user value, as discussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-objects-sec"
  "urity.html.\\n\\nThe minimum requirements for a valid CREATE EVENT statement are as\\nfollows:\\n\\no The keywords CREATE "
  "EVENT plus an event name, which uniquely\\n  identifies the event in a database schema.\\n\\no An ON SCHEDULE clause, wh"
  "ich determines when and how often the event\\n  executes.\\n\\no A DO clause, which contains the SQL statement to be exe"
  "cuted by an\\n  event.\\n\\nThis is an example of a minimal CREATE EVENT statement:\\n\\nCREATE EVENT myevent\\n    ON SCHE"
  "DULE AT CURRENT_TIMESTAMP + INTERVAL 1 HOUR\\n    DO\\n      UPDATE myschema.mytable SET mycol = mycol + 1;\\n\\nThe prev"
  "ious statement creates an event named myevent. This event\\nexecutes once---one hour following its creation---by runni"
  "ng an SQL\\nstatement that increments the value of the myschema.mytable table\\'s\\nmycol column by 1.\\n\\nThe event_name"
  " must be a valid MySQL identifier with a maximum length\\nof 64 characters. Event names are not case-sensitive, so you"
  " cannot\\nhave two events named myevent and MyEvent in the same schema. In\\ngeneral, the rules governing event names a"
  "re the same as those for\\nnames of stored routines. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/identifiers.html.\\n\\"
  "nAn event is associated with a schema. If no schema is indicated as part\\nof event_name, the default (current) schema"
  " is assumed. To create an\\nevent in a specific schema, qualify the event name with a schema using\\nschema_name.event_"
  "name syntax.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-event.html\\n\\n','','https://dev.mysql.com/doc/ref"
  "man/8.4/en/create-event.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (515,40,'CREATE INDEX','Synt"
  "ax:\\nCREATE [UNIQUE | FULLTEXT | SPATIAL] INDEX index_name\\n    [index_type]\\n    ON tbl_name (key_part,...)\\n    [in"
  "dex_option]\\n    [algorithm_option | lock_option] ...\\n\\nkey_part: {col_name [(length)] | (expr)} [ASC | DESC]\\n\\nind"
  "ex_option: {\\n    KEY_BLOCK_SIZE [=] value\\n  | index_type\\n  | WITH PARSER parser_name\\n  | COMMENT \\'string\\'\\n  | "
  "{VISIBLE | INVISIBLE}\\n  | ENGINE_ATTRIBUTE [=] \\'string\\'\\n  | SECONDARY_ENGINE_ATTRIBUTE [=] \\'string\\'\\n}\\n\\nindex"
  "_type:\\n    USING {BTREE | HASH}\\n\\nalgorithm_option:\\n    ALGORITHM [=] {DEFAULT | INPLACE | COPY}\\n\\nlock_option:\\n"
  "    LOCK [=] {DEFAULT | NONE | SHARED | EXCLUSIVE}\\n\\nNormally, you create all indexes on a table at the time the tab"
  "le\\nitself is created with CREATE TABLE. See [HELP CREATE TABLE]. This\\nguideline is especially important for InnoDB "
  "tables, where the primary\\nkey determines the physical layout of rows in the data file. CREATE\\nINDEX enables you to "
  "add indexes to existing tables.\\n\\nCREATE INDEX is mapped to an ALTER TABLE statement to create indexes.\\nSee [HELP A"
  "LTER TABLE]. CREATE INDEX cannot be used to create a PRIMARY\\nKEY; use ALTER TABLE instead. For more information abou"
  "t indexes, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql-indexes.html.\\n\\nURL: https://dev.mysql.com/doc/refman/"
  "8.4/en/create-index.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-index.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (516,40,'CREATE LOGFILE GROU"
  "P','Syntax:\\nCREATE LOGFILE GROUP logfile_group\\n    ADD UNDOFILE \\'undo_file\\'\\n    [INITIAL_SIZE [=] initial_size]\\"
  "n    [UNDO_BUFFER_SIZE [=] undo_buffer_size]\\n    [REDO_BUFFER_SIZE [=] redo_buffer_size]\\n    [NODEGROUP [=] nodegro"
  "up_id]\\n    [WAIT]\\n    [COMMENT [=] \\'string\\']\\n    ENGINE [=] engine_name\\n\\nThis statement creates a new log file"
  " group named logfile_group having\\na single undo file named \\'undo_file\\'. A CREATE LOGFILE GROUP statement\\nhas one "
  "and only one ADD UNDOFILE clause. For rules covering the naming\\nof log file groups, see\\nhttps://dev.mysql.com/doc/r"
  "efman/8.4/en/identifiers.html.\\n\\n*Note*:\\n\\nAll NDB Cluster Disk Data objects share the same namespace. This means\\n"
  "that each Disk Data object must be uniquely named (and not merely each\\nDisk Data object of a given type). For exampl"
  "e, you cannot have a\\ntablespace and a log file group with the same name, or a tablespace and\\na data file with the s"
  "ame name.\\n\\nThere can be only one log file group per NDB Cluster instance at any\\ngiven time.\\n\\nThe optional INITIA"
  "L_SIZE parameter sets the undo file\\'s initial size;\\nif not specified, it defaults to 128M (128 megabytes). The opti"
  "onal\\nUNDO_BUFFER_SIZE parameter sets the size used by the undo buffer for\\nthe log file group; The default value for"
  " UNDO_BUFFER_SIZE is 8M (eight\\nmegabytes); this value cannot exceed the amount of system memory\\navailable. Both of "
  "these parameters are specified in bytes. You may\\noptionally follow either or both of these with a one-letter\\nabbrev"
  "iation for an order of magnitude, similar to those used in\\nmy.cnf. Generally, this is one of the letters M (for mega"
  "bytes) or G\\n(for gigabytes).\\n\\nMemory used for UNDO_BUFFER_SIZE comes from the global pool whose size\\nis determine"
  "d by the value of the SharedGlobalMemory data node\\nconfiguration parameter. This includes any default value implied "
  "for\\nthis option by the setting of the InitialLogFileGroup data node\\nconfiguration parameter.\\n\\nThe maximum permitt"
  "ed for UNDO_BUFFER_SIZE is 629145600 (600 MB).\\n\\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\\"
  "n4294967296 (4 GB). (Bug #29186)\\n\\nThe minimum allowed value for INITIAL_SIZE is 1048576 (1 MB).\\n\\nThe ENGINE optio"
  "n determines the storage engine to be used by this log\\nfile group, with engine_name being the name of the storage en"
  "gine. This\\nmust be NDB (or NDBCLUSTER). If ENGINE is not set, MySQL tries to use\\nthe engine specified by the defaul"
  "t_storage_engine server system\\nvariable. In any case, if the engine is not specified as NDB or\\nNDBCLUSTER, the CREA"
  "TE LOGFILE GROUP statement appears to succeed but\\nactually fails to create the log file group, as shown here:\\n\\nmys"
  "ql> CREATE LOGFILE GROUP lg1\\n    ->     ADD UNDOFILE \\'undo.dat\\' INITIAL_SIZE = 10M;\\nQuery OK, 0 rows affected, 1 "
  "warning (0.00 sec)\\n\\nmysql> SHOW WARNINGS;\\n+-------+------+--------------------------------------------------------"
  "----------------------------------------+\\n| Level | Code | Message                                                  "
  "                                      |\\n+-------+------+------------------------------------------------------------"
  "------------------------------------+\\n| Error | 1478 | Table storage engine \\'InnoDB\\' does not support the create o"
  "ption \\'TABLESPACE or LOGFILE GROUP\\' |\\n+-------+------+------------------------------------------------------------"
  "------------------------------------+\\n1 row in set (0.00 sec)\\n\\nmysql> DROP LOGFILE GROUP lg1 ENGINE = NDB;\\nERROR "
  "1529 (HY000): Failed to drop LOGFILE GROUP\\n\\nmysql> CREATE LOGFILE GROUP lg1\\n    ->     ADD UNDOFILE \\'undo.dat\\' I"
  "NITIAL_SIZE = 10M\\n    ->     ENGINE = NDB;\\nQuery OK, 0 rows affected (2.97 sec)\\n\\nThe fact that the CREATE LOGFILE"
  " GROUP statement does not actually\\nreturn an error when a storage engine other than NDB is specified, but\\nrather ap"
  "pears to succeed, is a known issue which we hope to address in\\na future version of NDB Cluster.\\n\\nREDO_BUFFER_SIZE,"
  " NODEGROUP, WAIT, and COMMENT are parsed but ignored,\\nand so have no effect in MySQL 8.4. These options are intended"
  " for\\nfuture expansion.\\n\\nWhen used with ENGINE [=] NDB, a log file group and associated undo log\\nfile are created "
  "on each Cluster data node. You can verify that the\\nundo files were created and obtain information about them by quer"
  "ying\\nthe Information Schema FILES table. For example:\\n\\nmysql> SELECT LOGFILE_GROUP_NAME, LOGFILE_GROUP_NUMBER, EXT"
  "RA\\n    -> FROM INFORMATION_SCHEMA.FILES\\n    -> WHERE FILE_NAME = \\'undo_10.dat\\';\\n+--------------------+----------"
  "------------+----------------+\\n| LOGFILE_GROUP_NAME | LOGFILE_GROUP_NUMBER | EXTRA          |\\n+--------------------"
  "+----------------------+----------------+\\n| lg_3               |                   11 | CLUSTER_NODE=3 |\\n| lg_3    "
  "           |                   11 | CLUSTER_NODE=4 |\\n+--------------------+----------------------+----------------+\\"
  "n2 rows in set (0.06 sec)\\n\\nCREATE LOGFILE GROUP is useful only with Disk Data storage for NDB\\nCluster. See\\nhttps:"
  "//dev.mysql.com/doc/refman/8.4/en/mysql-cluster-disk-data.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/creat"
  "e-logfile-group.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-logfile-group.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (517,40,'CREATE PROCEDURE','"
  "Syntax:\\nCREATE\\n    [DEFINER = user]\\n    PROCEDURE [IF NOT EXISTS] sp_name ([proc_parameter[,...]])\\n    [character"
  "istic ...] routine_body\\n\\nCREATE\\n    [DEFINER = user]\\n    FUNCTION [IF NOT EXISTS] sp_name ([func_parameter[,...]]"
  ")\\n    RETURNS type\\n    [characteristic ...] routine_body\\n\\nproc_parameter:\\n    [ IN | OUT | INOUT ] param_name ty"
  "pe\\n\\nfunc_parameter:\\n    param_name type\\n\\ntype:\\n    Any valid MySQL data type\\n\\ncharacteristic: {\\n    COMMENT "
  "\\'string\\'\\n  | LANGUAGE SQL  | [NOT] DETERMINISTIC\\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA"
  " }\\n  | SQL SECURITY { DEFINER | INVOKER }\\n}\\n\\nroutine_body:\\n    SQL routine\\n\\nThese statements are used to creat"
  "e a stored routine (a stored\\nprocedure or function). That is, the specified routine becomes known to\\nthe server. By"
  " default, a stored routine is associated with the default\\ndatabase. To associate the routine explicitly with a given"
  " database,\\nspecify the name as db_name.sp_name when you create it.\\n\\nThe CREATE FUNCTION statement is also used in "
  "MySQL to support loadable\\nfunctions. See [HELP CREATE FUNCTION loadable function]. A loadable\\nfunction can be regar"
  "ded as an external stored function. Stored\\nfunctions share their namespace with loadable functions. See\\nhttps://dev"
  ".mysql.com/doc/refman/8.4/en/function-resolution.html, for\\nthe rules describing how the server interprets references"
  " to different\\nkinds of functions.\\n\\nTo invoke a stored procedure, use the CALL statement (see [HELP CALL]).\\nTo inv"
  "oke a stored function, refer to it in an expression. The function\\nreturns a value during expression evaluation.\\n\\nC"
  "REATE PROCEDURE and CREATE FUNCTION require the CREATE ROUTINE\\nprivilege. If the DEFINER clause is present, the priv"
  "ileges required\\ndepend on the user value, as discussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-objects-se"
  "curity.html.\\nIf binary logging is enabled, CREATE FUNCTION might require the SUPER\\nprivilege, as discussed in\\nhttp"
  "s://dev.mysql.com/doc/refman/8.4/en/stored-programs-logging.html.\\n\\nBy default, MySQL automatically grants the ALTER"
  " ROUTINE and EXECUTE\\nprivileges to the routine creator. This behavior can be changed by\\ndisabling the automatic_sp_"
  "privileges system variable. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-routines-privileges.html\\n.\\n\\nThe DE"
  "FINER and SQL SECURITY clauses specify the security context to be\\nused when checking access privileges at routine ex"
  "ecution time, as\\ndescribed later in this section.\\n\\nIf the routine name is the same as the name of a built-in SQL f"
  "unction,\\na syntax error occurs unless you use a space between the name and the\\nfollowing parenthesis when defining "
  "the routine or invoking it later.\\nFor this reason, avoid using the names of existing SQL functions for\\nyour own sto"
  "red routines.\\n\\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\\nroutines. It is always permi"
  "ssible to have spaces after a stored\\nroutine name, regardless of whether IGNORE_SPACE is enabled.\\n\\nIF NOT EXISTS p"
  "revents an error from occurring if there already exists\\na routine with the same name. This option is supported with "
  "both CREATE\\nFUNCTION and CREATE PROCEDURE.\\n\\nIf a built-in function with the same name already exists, attempting t"
  "o\\ncreate a stored function with CREATE FUNCTION ... IF NOT EXISTS\\nsucceeds with a warning indicating that it has th"
  "e same name as a\\nnative function; this is no different than when performing the same\\nCREATE FUNCTION statement with"
  "out specifying IF NOT EXISTS.\\n\\nIf a loadable function with the same name already exists, attempting to\\ncreate a st"
  "ored function using IF NOT EXISTS succeeds with a warning.\\nThis is the same as without specifying IF NOT EXISTS.\\n\\n"
  "See\\nhttps://dev.mysql.com/doc/refman/8.4/en/function-resolution.html#functi\\non-name-resolution, for more informatio"
  "n.\\n\\nThe parameter list enclosed within parentheses must always be present.\\nIf there are no parameters, an empty pa"
  "rameter list of () should be\\nused. Parameter names are not case-sensitive.\\n\\nEach parameter is an IN parameter by d"
  "efault. To specify otherwise for\\na parameter, use the keyword OUT or INOUT before the parameter name.\\n\\n*Note*:\\n\\n"
  "Specifying a parameter as IN, OUT, or INOUT is valid only for a\\nPROCEDURE. For a FUNCTION, parameters are always reg"
  "arded as IN\\nparameters.\\n\\nAn IN parameter passes a value into a procedure. The procedure might\\nmodify the value, b"
  "ut the modification is not visible to the caller\\nwhen the procedure returns. An OUT parameter passes a value from th"
  "e\\nprocedure back to the caller. Its initial value is NULL within the\\nprocedure, and its value is visible to the cal"
  "ler when the procedure\\nreturns. An INOUT parameter is initialized by the caller, can be\\nmodified by the procedure, "
  "and any change made by the procedure is\\nvisible to the caller when the procedure returns.\\n\\nFor each OUT or INOUT p"
  "arameter, pass a user-defined variable in the\\nCALL statement that invokes the procedure so that you can obtain its\\n"
  "value when the procedure returns. If you are calling the procedure from\\nwithin another stored procedure or function,"
  " you can also pass a\\nroutine parameter or local routine variable as an OUT or INOUT\\nparameter. If you are calling t"
  "he procedure from within a trigger, you\\ncan also pass NEW.col_name as an OUT or INOUT parameter.\\n\\nFor information "
  "about the effect of unhandled conditions on procedure\\nparameters, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/condi"
  "tions-and-parameters.html.\\n\\nRoutine parameters cannot be referenced in statements prepared within\\nthe routine; see"
  "\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-program-restrictions.html\\n.\\n\\nThe following example shows a simple"
  " stored procedure that, given a\\ncountry code, counts the number of cities for that country that appear\\nin the city "
  "table of the world database. The country code is passed\\nusing an IN parameter, and the city count is returned using "
  "an OUT\\nparameter:\\n\\nmysql> delimiter //\\n\\nmysql> CREATE PROCEDURE citycount (IN country CHAR(3), OUT cities INT)\\n"
  "       BEGIN\\n         SELECT COUNT(*) INTO cities FROM world.city\\n         WHERE CountryCode = country;\\n       END"
  "//\\nQuery OK, 0 rows affected (0.01 sec)\\n\\nmysql> delimiter ;\\n\\nmysql> CALL citycount(\\'JPN\\', @cities); -- cities "
  "in Japan\\nQuery OK, 1 row affected (0.00 sec)\\n\\nmysql> SELECT @cities;\\n+---------+\\n| @cities |\\n+---------+\\n|    "
  " 248 |\\n+---------+\\n1 row in set (0.00 sec)\\n\\nmysql> CALL citycount(\\'FRA\\', @cities); -- cities in France\\nQuery O"
  "K, 1 row affected (0.00 sec)\\n\\nmysql> SELECT @cities;\\n+---------+\\n| @cities |\\n+---------+\\n|      40 |\\n+--------"
  "-+\\n1 row in set (0.00 sec)\\n\\nThe example uses the mysql client delimiter command to change the\\nstatement delimiter"
  " from ; to // while the procedure is being defined.\\nThis enables the ; delimiter used in the procedure body to be pa"
  "ssed\\nthrough to the server rather than being interpreted by mysql itself.\\nSee\\nhttps://dev.mysql.com/doc/refman/8.4"
  "/en/stored-programs-defining.html.\\n\\nThe RETURNS clause may be specified only for a FUNCTION, for which it\\nis manda"
  "tory. It indicates the return type of the function, and the\\nfunction body must contain a RETURN value statement. If "
  "the RETURN\\nstatement returns a value of a different type, the value is coerced to\\nthe proper type. For example, if "
  "a function specifies an ENUM or SET\\nvalue in the RETURNS clause, but the RETURN statement returns an\\ninteger, the v"
  "alue returned from the function is the string for the\\ncorresponding ENUM member of set of SET members.\\n\\nThe follow"
  "ing example function takes a parameter, performs an operation\\nusing an SQL function, and returns the result. In this"
  " case, it is\\nunnecessary to use delimiter because the function definition contains\\nno internal ; statement delimite"
  "rs:\\n\\nmysql> CREATE FUNCTION hello (s CHAR(20))\\nmysql> RETURNS CHAR(50) DETERMINISTIC\\n       RETURN CONCAT(\\'Hello"
  ", \\',s,\\'!\\');\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT hello(\\'world\\');\\n+----------------+\\n| hello("
  "\\'world\\') |\\n+----------------+\\n| Hello, world!  |\\n+----------------+\\n1 row in set (0.00 sec)\\n\\nParameter types "
  "and function return types can be declared to use any\\nvalid data type. The COLLATE attribute can be used if preceded "
  "by a\\nCHARACTER SET specification.\\n\\nThe routine_body consists of a valid SQL routine statement. This can be\\na simp"
  "le statement such as SELECT or INSERT, or a compound statement\\nwritten using BEGIN and END. Compound statements can "
  "contain\\ndeclarations, loops, and other control structure statements. The syntax\\nfor these statements is described i"
  "n\\nhttps://dev.mysql.com/doc/refman/8.4/en/sql-compound-statements.html.\\nIn practice, stored functions tend to use c"
  "ompound statements, unless\\nthe body consists of a single RETURN statement.\\n\\nMySQL permits routines to contain DDL "
  "statements, such as CREATE and\\nDROP. MySQL also permits stored procedures (but not stored functions)\\nto contain SQL"
  " transaction statements such as COMMIT. Stored functions\\nmay not contain statements that perform explicit or implici"
  "t commit or\\nrollback. Support for these statements is not required by the SQL\\nstandard, which states that each DBMS"
  " vendor may decide whether to\\npermit them.\\n\\nStatements that return a result set can be used within a stored\\nproce"
  "dure but not within a stored function. This prohibition includes\\nSELECT statements that do not have an INTO var_list"
  " clause and other\\nstatements such as SHOW, EXPLAIN, and CHECK TABLE. For statements that\\ncan be determined at funct"
  "ion definition time to return a result set, a\\nNot allowed to return a result set from a function error occurs\\n(ER_S"
  "P_NO_RETSET\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_sp_no_retset)). Fo"
  "r statements that can be determined only\\nat runtime to return a result set, a PROCEDURE %s can\\'t return a result\\ns"
  "et in the given context error occurs (ER_SP_BADSELECT\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-re"
  "ference.html\\n#error_er_sp_badselect)).\\n\\nUSE statements within stored routines are not permitted. When a routine\\ni"
  "s invoked, an implicit USE db_name is performed (and undone when the\\nroutine terminates). The causes the routine to "
  "have the given default\\ndatabase while it executes. References to objects in databases other\\nthan the routine defaul"
  "t database should be qualified with the\\nappropriate database name.\\n\\nFor additional information about statements th"
  "at are not permitted in\\nstored routines, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-program-restrictions.ht"
  "ml\\n.\\n\\nFor information about invoking stored procedures from within programs\\nwritten in a language that has a MySQ"
  "L interface, see [HELP CALL].\\n\\nMySQL stores the sql_mode system variable setting in effect when a\\nroutine is creat"
  "ed or altered, and always executes the routine with\\nthis setting in force, regardless of the current server SQL mode"
  " when\\nthe routine begins executing.\\n\\nThe switch from the SQL mode of the invoker to that of the routine\\noccurs af"
  "ter evaluation of arguments and assignment of the resulting\\nvalues to routine parameters. If you define a routine in"
  " strict SQL\\nmode but invoke it in nonstrict mode, assignment of arguments to\\nroutine parameters does not take place"
  " in strict mode. If you require\\nthat expressions passed to a routine be assigned in strict SQL mode,\\nyou should inv"
  "oke the routine with strict mode in effect.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-procedure.html\\n\\n"
  "','','https://dev.mysql.com/doc/refman/8.4/en/create-procedure.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (518,40,'CREATE FUNCTION','S"
  "yntax:\\nCREATE\\n    [DEFINER = user]\\n    PROCEDURE [IF NOT EXISTS] sp_name ([proc_parameter[,...]])\\n    [characteri"
  "stic ...] routine_body\\n\\nCREATE\\n    [DEFINER = user]\\n    FUNCTION [IF NOT EXISTS] sp_name ([func_parameter[,...]])"
  "\\n    RETURNS type\\n    [characteristic ...] routine_body\\n\\nproc_parameter:\\n    [ IN | OUT | INOUT ] param_name typ"
  "e\\n\\nfunc_parameter:\\n    param_name type\\n\\ntype:\\n    Any valid MySQL data type\\n\\ncharacteristic: {\\n    COMMENT \\"
  "'string\\'\\n  | LANGUAGE SQL  | [NOT] DETERMINISTIC\\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA "
  "}\\n  | SQL SECURITY { DEFINER | INVOKER }\\n}\\n\\nroutine_body:\\n    SQL routine\\n\\nThese statements are used to create"
  " a stored routine (a stored\\nprocedure or function). That is, the specified routine becomes known to\\nthe server. By "
  "default, a stored routine is associated with the default\\ndatabase. To associate the routine explicitly with a given "
  "database,\\nspecify the name as db_name.sp_name when you create it.\\n\\nThe CREATE FUNCTION statement is also used in M"
  "ySQL to support loadable\\nfunctions. See [HELP CREATE FUNCTION loadable function]. A loadable\\nfunction can be regard"
  "ed as an external stored function. Stored\\nfunctions share their namespace with loadable functions. See\\nhttps://dev."
  "mysql.com/doc/refman/8.4/en/function-resolution.html, for\\nthe rules describing how the server interprets references "
  "to different\\nkinds of functions.\\n\\nTo invoke a stored procedure, use the CALL statement (see [HELP CALL]).\\nTo invo"
  "ke a stored function, refer to it in an expression. The function\\nreturns a value during expression evaluation.\\n\\nCR"
  "EATE PROCEDURE and CREATE FUNCTION require the CREATE ROUTINE\\nprivilege. If the DEFINER clause is present, the privi"
  "leges required\\ndepend on the user value, as discussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-objects-sec"
  "urity.html.\\nIf binary logging is enabled, CREATE FUNCTION might require the SUPER\\nprivilege, as discussed in\\nhttps"
  "://dev.mysql.com/doc/refman/8.4/en/stored-programs-logging.html.\\n\\nBy default, MySQL automatically grants the ALTER "
  "ROUTINE and EXECUTE\\nprivileges to the routine creator. This behavior can be changed by\\ndisabling the automatic_sp_p"
  "rivileges system variable. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-routines-privileges.html\\n.\\n\\nThe DEF"
  "INER and SQL SECURITY clauses specify the security context to be\\nused when checking access privileges at routine exe"
  "cution time, as\\ndescribed later in this section.\\n\\nIf the routine name is the same as the name of a built-in SQL fu"
  "nction,\\na syntax error occurs unless you use a space between the name and the\\nfollowing parenthesis when defining t"
  "he routine or invoking it later.\\nFor this reason, avoid using the names of existing SQL functions for\\nyour own stor"
  "ed routines.\\n\\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\\nroutines. It is always permis"
  "sible to have spaces after a stored\\nroutine name, regardless of whether IGNORE_SPACE is enabled.\\n\\nIF NOT EXISTS pr"
  "events an error from occurring if there already exists\\na routine with the same name. This option is supported with b"
  "oth CREATE\\nFUNCTION and CREATE PROCEDURE.\\n\\nIf a built-in function with the same name already exists, attempting to"
  "\\ncreate a stored function with CREATE FUNCTION ... IF NOT EXISTS\\nsucceeds with a warning indicating that it has the"
  " same name as a\\nnative function; this is no different than when performing the same\\nCREATE FUNCTION statement witho"
  "ut specifying IF NOT EXISTS.\\n\\nIf a loadable function with the same name already exists, attempting to\\ncreate a sto"
  "red function using IF NOT EXISTS succeeds with a warning.\\nThis is the same as without specifying IF NOT EXISTS.\\n\\nS"
  "ee\\nhttps://dev.mysql.com/doc/refman/8.4/en/function-resolution.html#functi\\non-name-resolution, for more information"
  ".\\n\\nThe parameter list enclosed within parentheses must always be present.\\nIf there are no parameters, an empty par"
  "ameter list of () should be\\nused. Parameter names are not case-sensitive.\\n\\nEach parameter is an IN parameter by de"
  "fault. To specify otherwise for\\na parameter, use the keyword OUT or INOUT before the parameter name.\\n\\n*Note*:\\n\\nS"
  "pecifying a parameter as IN, OUT, or INOUT is valid only for a\\nPROCEDURE. For a FUNCTION, parameters are always rega"
  "rded as IN\\nparameters.\\n\\nAn IN parameter passes a value into a procedure. The procedure might\\nmodify the value, bu"
  "t the modification is not visible to the caller\\nwhen the procedure returns. An OUT parameter passes a value from the"
  "\\nprocedure back to the caller. Its initial value is NULL within the\\nprocedure, and its value is visible to the call"
  "er when the procedure\\nreturns. An INOUT parameter is initialized by the caller, can be\\nmodified by the procedure, a"
  "nd any change made by the procedure is\\nvisible to the caller when the procedure returns.\\n\\nFor each OUT or INOUT pa"
  "rameter, pass a user-defined variable in the\\nCALL statement that invokes the procedure so that you can obtain its\\nv"
  "alue when the procedure returns. If you are calling the procedure from\\nwithin another stored procedure or function, "
  "you can also pass a\\nroutine parameter or local routine variable as an OUT or INOUT\\nparameter. If you are calling th"
  "e procedure from within a trigger, you\\ncan also pass NEW.col_name as an OUT or INOUT parameter.\\n\\nFor information a"
  "bout the effect of unhandled conditions on procedure\\nparameters, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/condit"
  "ions-and-parameters.html.\\n\\nRoutine parameters cannot be referenced in statements prepared within\\nthe routine; see\\"
  "nhttps://dev.mysql.com/doc/refman/8.4/en/stored-program-restrictions.html\\n.\\n\\nThe following example shows a simple "
  "stored procedure that, given a\\ncountry code, counts the number of cities for that country that appear\\nin the city t"
  "able of the world database. The country code is passed\\nusing an IN parameter, and the city count is returned using a"
  "n OUT\\nparameter:\\n\\nmysql> delimiter //\\n\\nmysql> CREATE PROCEDURE citycount (IN country CHAR(3), OUT cities INT)\\n "
  "      BEGIN\\n         SELECT COUNT(*) INTO cities FROM world.city\\n         WHERE CountryCode = country;\\n       END/"
  "/\\nQuery OK, 0 rows affected (0.01 sec)\\n\\nmysql> delimiter ;\\n\\nmysql> CALL citycount(\\'JPN\\', @cities); -- cities i"
  "n Japan\\nQuery OK, 1 row affected (0.00 sec)\\n\\nmysql> SELECT @cities;\\n+---------+\\n| @cities |\\n+---------+\\n|     "
  "248 |\\n+---------+\\n1 row in set (0.00 sec)\\n\\nmysql> CALL citycount(\\'FRA\\', @cities); -- cities in France\\nQuery OK"
  ", 1 row affected (0.00 sec)\\n\\nmysql> SELECT @cities;\\n+---------+\\n| @cities |\\n+---------+\\n|      40 |\\n+---------"
  "+\\n1 row in set (0.00 sec)\\n\\nThe example uses the mysql client delimiter command to change the\\nstatement delimiter "
  "from ; to // while the procedure is being defined.\\nThis enables the ; delimiter used in the procedure body to be pas"
  "sed\\nthrough to the server rather than being interpreted by mysql itself.\\nSee\\nhttps://dev.mysql.com/doc/refman/8.4/"
  "en/stored-programs-defining.html.\\n\\nThe RETURNS clause may be specified only for a FUNCTION, for which it\\nis mandat"
  "ory. It indicates the return type of the function, and the\\nfunction body must contain a RETURN value statement. If t"
  "he RETURN\\nstatement returns a value of a different type, the value is coerced to\\nthe proper type. For example, if a"
  " function specifies an ENUM or SET\\nvalue in the RETURNS clause, but the RETURN statement returns an\\ninteger, the va"
  "lue returned from the function is the string for the\\ncorresponding ENUM member of set of SET members.\\n\\nThe followi"
  "ng example function takes a parameter, performs an operation\\nusing an SQL function, and returns the result. In this "
  "case, it is\\nunnecessary to use delimiter because the function definition contains\\nno internal ; statement delimiter"
  "s:\\n\\nmysql> CREATE FUNCTION hello (s CHAR(20))\\nmysql> RETURNS CHAR(50) DETERMINISTIC\\n       RETURN CONCAT(\\'Hello,"
  " \\',s,\\'!\\');\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT hello(\\'world\\');\\n+----------------+\\n| hello(\\"
  "'world\\') |\\n+----------------+\\n| Hello, world!  |\\n+----------------+\\n1 row in set (0.00 sec)\\n\\nParameter types a"
  "nd function return types can be declared to use any\\nvalid data type. The COLLATE attribute can be used if preceded b"
  "y a\\nCHARACTER SET specification.\\n\\nThe routine_body consists of a valid SQL routine statement. This can be\\na simpl"
  "e statement such as SELECT or INSERT, or a compound statement\\nwritten using BEGIN and END. Compound statements can c"
  "ontain\\ndeclarations, loops, and other control structure statements. The syntax\\nfor these statements is described in"
  "\\nhttps://dev.mysql.com/doc/refman/8.4/en/sql-compound-statements.html.\\nIn practice, stored functions tend to use co"
  "mpound statements, unless\\nthe body consists of a single RETURN statement.\\n\\nMySQL permits routines to contain DDL s"
  "tatements, such as CREATE and\\nDROP. MySQL also permits stored procedures (but not stored functions)\\nto contain SQL "
  "transaction statements such as COMMIT. Stored functions\\nmay not contain statements that perform explicit or implicit"
  " commit or\\nrollback. Support for these statements is not required by the SQL\\nstandard, which states that each DBMS "
  "vendor may decide whether to\\npermit them.\\n\\nStatements that return a result set can be used within a stored\\nproced"
  "ure but not within a stored function. This prohibition includes\\nSELECT statements that do not have an INTO var_list "
  "clause and other\\nstatements such as SHOW, EXPLAIN, and CHECK TABLE. For statements that\\ncan be determined at functi"
  "on definition time to return a result set, a\\nNot allowed to return a result set from a function error occurs\\n(ER_SP"
  "_NO_RETSET\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_sp_no_retset)). For"
  " statements that can be determined only\\nat runtime to return a result set, a PROCEDURE %s can\\'t return a result\\nse"
  "t in the given context error occurs (ER_SP_BADSELECT\\n(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-ref"
  "erence.html\\n#error_er_sp_badselect)).\\n\\nUSE statements within stored routines are not permitted. When a routine\\nis"
  " invoked, an implicit USE db_name is performed (and undone when the\\nroutine terminates). The causes the routine to h"
  "ave the given default\\ndatabase while it executes. References to objects in databases other\\nthan the routine default"
  " database should be qualified with the\\nappropriate database name.\\n\\nFor additional information about statements tha"
  "t are not permitted in\\nstored routines, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-program-restrictions.htm"
  "l\\n.\\n\\nFor information about invoking stored procedures from within programs\\nwritten in a language that has a MySQL"
  " interface, see [HELP CALL].\\n\\nMySQL stores the sql_mode system variable setting in effect when a\\nroutine is create"
  "d or altered, and always executes the routine with\\nthis setting in force, regardless of the current server SQL mode "
  "when\\nthe routine begins executing.\\n\\nThe switch from the SQL mode of the invoker to that of the routine\\noccurs aft"
  "er evaluation of arguments and assignment of the resulting\\nvalues to routine parameters. If you define a routine in "
  "strict SQL\\nmode but invoke it in nonstrict mode, assignment of arguments to\\nroutine parameters does not take place "
  "in strict mode. If you require\\nthat expressions passed to a routine be assigned in strict SQL mode,\\nyou should invo"
  "ke the routine with strict mode in effect.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-procedure.html\\n\\n'"
  ",'','https://dev.mysql.com/doc/refman/8.4/en/create-procedure.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (519,40,'CREATE SERVER','Syn"
  "tax:\\nCREATE SERVER server_name\\n    FOREIGN DATA WRAPPER wrapper_name\\n    OPTIONS (option [, option] ...)\\n\\noption"
  ": {\\n    HOST character-literal\\n  | DATABASE character-literal\\n  | USER character-literal\\n  | PASSWORD character-l"
  "iteral\\n  | SOCKET character-literal\\n  | OWNER character-literal\\n  | PORT numeric-literal\\n}\\n\\nThis statement crea"
  "tes the definition of a server for use with the\\nFEDERATED storage engine. The CREATE SERVER statement creates a new "
  "row\\nin the servers table in the mysql database. This statement requires the\\nSUPER privilege.\\n\\nThe server_name sho"
  "uld be a unique reference to the server. Server\\ndefinitions are global within the scope of the server, it is not\\npo"
  "ssible to qualify the server definition to a specific database.\\nserver_name has a maximum length of 64 characters (n"
  "ames longer than 64\\ncharacters are silently truncated), and is case-insensitive. You may\\nspecify the name as a quot"
  "ed string.\\n\\nThe wrapper_name is an identifier and may be quoted with single\\nquotation marks.\\n\\nFor each option yo"
  "u must specify either a character literal or numeric\\nliteral. Character literals are UTF-8, support a maximum length"
  " of 64\\ncharacters and default to a blank (empty) string. String literals are\\nsilently truncated to 64 characters. N"
  "umeric literals must be a number\\nbetween 0 and 9999, default value is 0.\\n\\n*Note*:\\n\\nThe OWNER option is currently"
  " not applied, and has no effect on the\\nownership or operation of the server connection that is created.\\n\\nThe CREAT"
  "E SERVER statement creates an entry in the mysql.servers table\\nthat can later be used with the CREATE TABLE statemen"
  "t when creating a\\nFEDERATED table. The options that you specify are used to populate the\\ncolumns in the mysql.serve"
  "rs table. The table columns are Server_name,\\nHost, Db, Username, Password, Port and Socket.\\n\\nURL: https://dev.mysq"
  "l.com/doc/refman/8.4/en/create-server.html\\n\\n','CREATE SERVER s\\nFOREIGN DATA WRAPPER mysql\\nOPTIONS (USER \\'Remote\\"
  "', HOST \\'198.51.100.106\\', DATABASE \\'test\\');\\n','https://dev.mysql.com/doc/refman/8.4/en/create-server.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (520,40,'CREATE SPATIAL REFE"
  "RENCE SYSTEM','Syntax:\\nCREATE OR REPLACE SPATIAL REFERENCE SYSTEM\\n    srid srs_attribute ...\\n\\nCREATE SPATIAL REFE"
  "RENCE SYSTEM\\n    [IF NOT EXISTS]\\n    srid srs_attribute ...\\n\\nsrs_attribute: {\\n    NAME \\'srs_name\\'\\n  | DEFINIT"
  "ION \\'definition\\'\\n  | ORGANIZATION \\'org_name\\' IDENTIFIED BY org_id\\n  | DESCRIPTION \\'description\\'\\n}\\n\\nsrid, o"
  "rg_id: 32-bit unsigned integer\\n\\nThis statement creates a spatial reference system (SRS) definition and\\nstores it i"
  "n the data dictionary. It requires the SUPER privilege. The\\nresulting data dictionary entry can be inspected using t"
  "he\\nINFORMATION_SCHEMA ST_SPATIAL_REFERENCE_SYSTEMS table.\\n\\nSRID values must be unique, so if neither OR REPLACE no"
  "r IF NOT EXISTS\\nis specified, an error occurs if an SRS definition with the given srid\\nvalue already exists.\\n\\nWit"
  "h CREATE OR REPLACE syntax, any existing SRS definition with the\\nsame SRID value is replaced, unless the SRID value "
  "is used by some\\ncolumn in an existing table. In that case, an error occurs. For\\nexample:\\n\\nmysql> CREATE OR REPLAC"
  "E SPATIAL REFERENCE SYSTEM 4326 ...;\\nERROR 3716 (SR005): Can\\'t modify SRID 4326. There is at\\nleast one column depe"
  "nding on it.\\n\\nTo identify which column or columns use the SRID, use this query,\\nreplacing 4326 with the SRID of th"
  "e definition you are trying to\\ncreate:\\n\\nSELECT * FROM INFORMATION_SCHEMA.ST_GEOMETRY_COLUMNS WHERE SRS_ID=4326;\\n\\"
  "nWith CREATE ... IF NOT EXISTS syntax, any existing SRS definition with\\nthe same SRID value causes the new definitio"
  "n to be ignored and a\\nwarning occurs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-spatial-reference-syste"
  "m.html\\n\\n','CREATE SPATIAL REFERENCE SYSTEM 4120\\nNAME \\'Greek\\'\\nORGANIZATION \\'EPSG\\' IDENTIFIED BY 4120\\nDEFINITI"
  "ON\\n  \\'GEOGCS[\"Greek\",DATUM[\"Greek\",SPHEROID[\"Bessel 1841\",\\n  6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"70"
  "04\"]],\\n  AUTHORITY[\"EPSG\",\"6120\"]],PRIMEM[\"Greenwich\",0,\\n  AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0"
  "17453292519943278,\\n  AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat\",NORTH],AXIS[\"Lon\",EAST],\\n  AUTHORITY[\"EPSG\",\"4"
  "120\"]]\\';\\n','https://dev.mysql.com/doc/refman/8.4/en/create-spatial-reference-system.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (521,40,'CREATE TABLE','Synt"
  "ax:\\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\\n    (create_definition,...)\\n    [table_options]\\n    [partit"
  "ion_options]\\n\\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\\n    [(create_definition,...)]\\n    [table_options]"
  "\\n    [partition_options]\\n    [IGNORE | REPLACE]\\n    [AS] query_expression\\n\\nCREATE [TEMPORARY] TABLE [IF NOT EXIS"
  "TS] tbl_name\\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\\n\\ncreate_definition: {\\n    col_name column_definition"
  "\\n  | {INDEX | KEY} [index_name] [index_type] (key_part,...)\\n      [index_option] ...\\n  | {FULLTEXT | SPATIAL} [IND"
  "EX | KEY] [index_name] (key_part,...)\\n      [index_option] ...\\n  | [CONSTRAINT [symbol]] PRIMARY KEY\\n      [index_"
  "type] (key_part,...)\\n      [index_option] ...\\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX | KEY]\\n      [index_name] [i"
  "ndex_type] (key_part,...)\\n      [index_option] ...\\n  | [CONSTRAINT [symbol]] FOREIGN KEY\\n      [index_name] (col_n"
  "ame,...)\\n      reference_definition\\n  | check_constraint_definition\\n}\\n\\ncolumn_definition: {\\n    data_type [NOT "
  "NULL | NULL] [DEFAULT {literal | (expr)} ]\\n      [VISIBLE | INVISIBLE]\\n      [AUTO_INCREMENT] [UNIQUE [KEY]] [[PRIM"
  "ARY] KEY]\\n      [COMMENT \\'string\\']\\n      [COLLATE collation_name]\\n      [COLUMN_FORMAT {FIXED | DYNAMIC | DEFAUL"
  "T}]\\n      [ENGINE_ATTRIBUTE [=] \\'string\\']\\n      [SECONDARY_ENGINE_ATTRIBUTE [=] \\'string\\']\\n      [STORAGE {DISK"
  " | MEMORY}]\\n      [reference_definition]\\n      [check_constraint_definition]\\n  | data_type\\n      [COLLATE collati"
  "on_name]\\n      [GENERATED ALWAYS] AS (expr)\\n      [VIRTUAL | STORED] [NOT NULL | NULL]\\n      [VISIBLE | INVISIBLE]"
  "\\n      [UNIQUE [KEY]] [[PRIMARY] KEY]\\n      [COMMENT \\'string\\']\\n      [reference_definition]\\n      [check_constr"
  "aint_definition]\\n}\\n\\ndata_type:\\n    (see https://dev.mysql.com/doc/refman/8.4/en/data-types.html)\\n\\nkey_part: {co"
  "l_name [(length)] | (expr)} [ASC | DESC]\\n\\nindex_type:\\n    USING {BTREE | HASH}\\n\\nindex_option: {\\n    KEY_BLOCK_S"
  "IZE [=] value\\n  | index_type\\n  | WITH PARSER parser_name\\n  | COMMENT \\'string\\'\\n  | {VISIBLE | INVISIBLE}\\n  |ENG"
  "INE_ATTRIBUTE [=] \\'string\\'\\n  |SECONDARY_ENGINE_ATTRIBUTE [=] \\'string\\'\\n}\\n\\ncheck_constraint_definition:\\n    [C"
  "ONSTRAINT [symbol]] CHECK (expr) [[NOT] ENFORCED]\\n\\nreference_definition:\\n    REFERENCES tbl_name (key_part,...)\\n "
  "     [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\\n      [ON DELETE reference_option]\\n      [ON UPDATE reference_opti"
  "on]\\n\\nreference_option:\\n    RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT\\n\\ntable_options:\\n    table_op"
  "tion [[,] table_option] ...\\n\\ntable_option: {\\n    AUTOEXTEND_SIZE [=] value\\n  | AUTO_INCREMENT [=] value\\n  | AVG_"
  "ROW_LENGTH [=] value\\n  | [DEFAULT] CHARACTER SET [=] charset_name\\n  | CHECKSUM [=] {0 | 1}\\n  | [DEFAULT] COLLATE ["
  "=] collation_name\\n  | COMMENT [=] \\'string\\'\\n  | COMPRESSION [=] {\\'ZLIB\\' | \\'LZ4\\' | \\'NONE\\'}\\n  | CONNECTION [="
  "] \\'connect_string\\'\\n  | {DATA | INDEX} DIRECTORY [=] \\'absolute path to directory\\'\\n  | DELAY_KEY_WRITE [=] {0 | 1"
  "}\\n  | ENCRYPTION [=] {\\'Y\\' | \\'N\\'}\\n  | ENGINE [=] engine_name\\n  | ENGINE_ATTRIBUTE [=] \\'string\\'\\n  | INSERT_ME"
  "THOD [=] { NO | FIRST | LAST }\\n  | KEY_BLOCK_SIZE [=] value\\n  | MAX_ROWS [=] value\\n  | MIN_ROWS [=] value\\n  | PAC"
  "K_KEYS [=] {0 | 1 | DEFAULT}\\n  | PASSWORD [=] \\'string\\'\\n  | ROW_FORMAT [=] {DEFAULT | DYNAMIC | FIXED | COMPRESSED"
  " | REDUNDANT | COMPACT}\\n  | START TRANSACTION \\n  | SECONDARY_ENGINE_ATTRIBUTE [=] \\'string\\'\\n  | STATS_AUTO_RECALC"
  " [=] {DEFAULT | 0 | 1}\\n  | STATS_PERSISTENT [=] {DEFAULT | 0 | 1}\\n  | STATS_SAMPLE_PAGES [=] value\\n  | tablespace_"
  "option\\n  | UNION [=] (tbl_name[,tbl_name]...)\\n}\\n\\npartition_options:\\n    PARTITION BY\\n        { [LINEAR] HASH(ex"
  "pr)\\n        | [LINEAR] KEY [ALGORITHM={1 | 2}] (column_list)\\n        | RANGE{(expr) | COLUMNS(column_list)}\\n      "
  "  | LIST{(expr) | COLUMNS(column_list)} }\\n    [PARTITIONS num]\\n    [SUBPARTITION BY\\n        { [LINEAR] HASH(expr)\\"
  "n        | [LINEAR] KEY [ALGORITHM={1 | 2}] (column_list) }\\n      [SUBPARTITIONS num]\\n    ]\\n    [(partition_defini"
  "tion [, partition_definition] ...)]\\n\\npartition_definition:\\n    PARTITION partition_name\\n        [VALUES\\n        "
  "    {LESS THAN {(expr | value_list) | MAXVALUE}\\n            |\\n            IN (value_list)}]\\n        [[STORAGE] ENG"
  "INE [=] engine_name]\\n        [COMMENT [=] \\'string\\' ]\\n        [DATA DIRECTORY [=] \\'data_dir\\']\\n        [INDEX DI"
  "RECTORY [=] \\'index_dir\\']\\n        [MAX_ROWS [=] max_number_of_rows]\\n        [MIN_ROWS [=] min_number_of_rows]\\n   "
  "     [TABLESPACE [=] tablespace_name]\\n        [(subpartition_definition [, subpartition_definition] ...)]\\n\\nsubpart"
  "ition_definition:\\n    SUBPARTITION logical_name\\n        [[STORAGE] ENGINE [=] engine_name]\\n        [COMMENT [=] \\'"
  "string\\' ]\\n        [DATA DIRECTORY [=] \\'data_dir\\']\\n        [INDEX DIRECTORY [=] \\'index_dir\\']\\n        [MAX_ROWS"
  " [=] max_number_of_rows]\\n        [MIN_ROWS [=] min_number_of_rows]\\n        [TABLESPACE [=] tablespace_name]\\n\\ntabl"
  "espace_option:\\n    TABLESPACE tablespace_name [STORAGE DISK]\\n  | [TABLESPACE tablespace_name] STORAGE MEMORY\\n\\nque"
  "ry_expression:\\n    SELECT ...   (Some valid select or union statement)\\n\\nCREATE TABLE creates a table with the give"
  "n name. You must have the\\nCREATE privilege for the table.\\n\\nBy default, tables are created in the default database,"
  " using the\\nInnoDB storage engine. An error occurs if the table exists, if there is\\nno default database, or if the d"
  "atabase does not exist.\\n\\nMySQL has no limit on the number of tables. The underlying file system\\nmay have a limit o"
  "n the number of files that represent tables.\\nIndividual storage engines may impose engine-specific constraints.\\nInn"
  "oDB permits up to 4 billion tables.\\n\\nFor information about the physical representation of a table, see\\nhttps://dev"
  ".mysql.com/doc/refman/8.4/en/create-table-files.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-table.ht"
  "ml\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-table.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (522,40,'FOREIGN KEY','MySQL"
  " supports foreign keys, which permit cross-referencing related\\ndata across tables, and foreign key constraints, whic"
  "h help keep the\\nrelated data consistent.\\n\\nA foreign key relationship involves a parent table that holds the\\niniti"
  "al column values, and a child table with column values that\\nreference the parent column values. A foreign key constr"
  "aint is defined\\non the child table.\\n\\nThe essential syntax for a defining a foreign key constraint in a\\nCREATE TAB"
  "LE or ALTER TABLE statement includes the following:\\n\\n[CONSTRAINT [symbol]] FOREIGN KEY\\n    [index_name] (col_name,"
  " ...)\\n    REFERENCES tbl_name (col_name,...)\\n    [ON DELETE reference_option]\\n    [ON UPDATE reference_option]\\n\\n"
  "reference_option:\\n    RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT\\n\\nURL: https://dev.mysql.com/doc/refm"
  "an/8.4/en/create-table-foreign-keys.html\\n\\n','CREATE TABLE product (\\n    category INT NOT NULL, id INT NOT NULL,\\n "
  "   price DECIMAL,\\n    PRIMARY KEY(category, id)\\n)   ENGINE=INNODB;\\n\\nCREATE TABLE customer (\\n    id INT NOT NULL,"
  "\\n    PRIMARY KEY (id)\\n)   ENGINE=INNODB;\\n\\nCREATE TABLE product_order (\\n    no INT NOT NULL AUTO_INCREMENT,\\n    "
  "product_category INT NOT NULL,\\n    product_id INT NOT NULL,\\n    customer_id INT NOT NULL,\\n\\n    PRIMARY KEY(no),\\n"
  "    INDEX (product_category, product_id),\\n    INDEX (customer_id),\\n\\n    FOREIGN KEY (product_category, product_id)"
  "\\n      REFERENCES product(category, id)\\n      ON UPDATE CASCADE ON DELETE RESTRICT,\\n\\n    FOREIGN KEY (customer_id"
  ")\\n      REFERENCES customer(id)\\n)   ENGINE=INNODB;\\n','https://dev.mysql.com/doc/refman/8.4/en/create-table-foreign"
  "-keys.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (523,40,'CREATE TABLESPACE',"
  "'Syntax:\\nCREATE [UNDO] TABLESPACE tablespace_name\\n\\n  InnoDB and NDB:\\n    [ADD DATAFILE \\'file_name\\']\\n    [AUTOE"
  "XTEND_SIZE [=] value]\\n\\n  InnoDB only:\\n    [FILE_BLOCK_SIZE = value]\\n    [ENCRYPTION [=] {\\'Y\\' | \\'N\\'}]\\n\\n  NDB"
  " only:\\n    USE LOGFILE GROUP logfile_group\\n    [EXTENT_SIZE [=] extent_size]\\n    [INITIAL_SIZE [=] initial_size]\\n"
  "    [MAX_SIZE [=] max_size]\\n    [NODEGROUP [=] nodegroup_id]\\n    [WAIT]\\n    [COMMENT [=] \\'string\\']\\n\\n  InnoDB a"
  "nd NDB:\\n    [ENGINE [=] engine_name]\\n\\n  Reserved for future use:\\n    [ENGINE_ATTRIBUTE [=] \\'string\\']\\n\\nThis st"
  "atement is used to create a tablespace. The precise syntax and\\nsemantics depend on the storage engine used. In stand"
  "ard MySQL\\nreleases, this is always an InnoDB tablespace. MySQL NDB Cluster also\\nsupports tablespaces using the NDB "
  "storage engine.\\n\\no https://dev.mysql.com/doc/refman/8.4/en/create-tablespace.html#create\\n  -tablespace-innodb\\n\\no"
  " https://dev.mysql.com/doc/refman/8.4/en/create-tablespace.html#create\\n  -tablespace-ndb\\n\\no https://dev.mysql.com/"
  "doc/refman/8.4/en/create-tablespace.html#create\\n  -tablespace-options\\n\\no https://dev.mysql.com/doc/refman/8.4/en/c"
  "reate-tablespace.html#create\\n  -tablespace-notes\\n\\no https://dev.mysql.com/doc/refman/8.4/en/create-tablespace.html"
  "#create\\n  -tablespace-innodb-examples\\n\\no https://dev.mysql.com/doc/refman/8.4/en/create-tablespace.html#create\\n  "
  "-tablespace-ndb-examples\\n\\nConsiderations for InnoDB\\n\\nCREATE TABLESPACE syntax is used to create general tablespac"
  "es or undo\\ntablespaces. The UNDO keyword must be specified to create an undo\\ntablespace.\\n\\nA general tablespace is"
  " a shared tablespace. It can hold multiple\\ntables, and supports all table row formats. General tablespaces can be\\nc"
  "reated in a location relative to or independent of the data directory.\\n\\nAfter creating an InnoDB general tablespace"
  ", use CREATE TABLE tbl_name\\n... TABLESPACE [=] tablespace_name or ALTER TABLE tbl_name TABLESPACE\\n[=] tablespace_na"
  "me to add tables to the tablespace. For more\\ninformation, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/general-table"
  "spaces.html.\\n\\nUndo tablespaces contain undo logs. Undo tablespaces can be created in\\na chosen location by specifyi"
  "ng a fully qualified data file path. For\\nmore information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-undo-"
  "tablespaces.html.\\n\\nConsiderations for NDB Cluster\\n\\nThis statement is used to create a tablespace, which can conta"
  "in one or\\nmore data files, providing storage space for NDB Cluster Disk Data\\ntables (see\\nhttps://dev.mysql.com/doc"
  "/refman/8.4/en/mysql-cluster-disk-data.html).\\nOne data file is created and added to the tablespace using this\\nstate"
  "ment. Additional data files may be added to the tablespace by\\nusing the ALTER TABLESPACE statement (see [HELP ALTER "
  "TABLESPACE]).\\n\\n*Note*:\\n\\nAll NDB Cluster Disk Data objects share the same namespace. This means\\nthat each Disk Da"
  "ta object must be uniquely named (and not merely each\\nDisk Data object of a given type). For example, you cannot hav"
  "e a\\ntablespace and a log file group with the same name, or a tablespace and\\na data file with the same name.\\n\\nA lo"
  "g file group of one or more UNDO log files must be assigned to the\\ntablespace to be created with the USE LOGFILE GRO"
  "UP clause.\\nlogfile_group must be an existing log file group created with CREATE\\nLOGFILE GROUP (see [HELP CREATE LOG"
  "FILE GROUP]). Multiple tablespaces\\nmay use the same log file group for UNDO logging.\\n\\nWhen setting EXTENT_SIZE or "
  "INITIAL_SIZE, you may optionally follow the\\nnumber with a one-letter abbreviation for an order of magnitude,\\nsimila"
  "r to those used in my.cnf. Generally, this is one of the letters\\nM (for megabytes) or G (for gigabytes).\\n\\nINITIAL_"
  "SIZE and EXTENT_SIZE are subject to rounding as follows:\\n\\no EXTENT_SIZE is rounded up to the nearest whole multiple"
  " of 32K.\\n\\no INITIAL_SIZE is rounded down to the nearest whole multiple of 32K;\\n  this result is rounded up to the "
  "nearest whole multiple of\\n  EXTENT_SIZE (after any rounding).\\n\\n*Note*:\\n\\nNDB reserves 4% of a tablespace for data"
  " node restart operations. This\\nreserved space cannot be used for data storage.\\n\\nThe rounding just described is don"
  "e explicitly, and a warning is issued\\nby the MySQL Server when any such rounding is performed. The rounded\\nvalues a"
  "re also used by the NDB kernel for calculating\\nINFORMATION_SCHEMA.FILES column values and other purposes. However, t"
  "o\\navoid an unexpected result, we suggest that you always use whole\\nmultiples of 32K in specifying these options.\\n\\"
  "nWhen CREATE TABLESPACE is used with ENGINE [=] NDB, a tablespace and\\nassociated data file are created on each Clust"
  "er data node. You can\\nverify that the data files were created and obtain information about\\nthem by querying the Inf"
  "ormation Schema FILES table. (See the example\\nlater in this section.)\\n\\n(See\\nhttps://dev.mysql.com/doc/refman/8.4/"
  "en/information-schema-files-table.\\nhtml.)\\n\\nOptions\\n\\no ADD DATAFILE: Defines the name of a tablespace data file. "
  "This option\\n  is always required when creating an NDB tablespace; for InnoDB, it is\\n  required only when creating a"
  "n undo tablespace. The file_name,\\n  including any specified path, must be quoted with single or double\\n  quotation "
  "marks. File names (not counting the file extension) and\\n  directory names must be at least one byte in length. Zero "
  "length file\\n  names and directory names are not supported.\\n\\n  Because there are considerable differences in how In"
  "noDB and NDB\\n  treat data files, the two storage engines are covered separately in\\n  the discussion that follows.\\n"
  "\\n  InnoDB data files An InnoDB tablespace supports only a single data\\n  file, whose name must include an .ibd exten"
  "sion.\\n\\n  To place an InnoDB general tablespace data file in a location outside\\n  of the data directory, include a "
  "fully qualified path or a path\\n  relative to the data directory. Only a fully qualified path is\\n  permitted for und"
  "o tablespaces. If you do not specify a path, a\\n  general tablespace is created in the data directory. An undo\\n  tab"
  "lespace created without specifying a path is created in the\\n  directory defined by the innodb_undo_directory variabl"
  "e. If\\n  innodb_undo_directory is not set, undo tablespaces are created in the\\n  data directory.\\n\\n  To avoid confl"
  "icts with implicitly created file-per-table\\n  tablespaces, creating an InnoDB general tablespace in a subdirectory\\n"
  "  under the data directory is not supported. When creating a general\\n  tablespace or undo tablespace outside of the "
  "data directory, the\\n  directory must exist and must be known to InnoDB prior to creating\\n  the tablespace. To make "
  "a directory known to InnoDB, add it to the\\n  innodb_directories value or to one of the variables whose values are\\n "
  " appended to the value of innodb_directories. innodb_directories is a\\n  read-only variable. Configuring it requires "
  "restarting the server.\\n\\n  If the ADD DATAFILE clause is not specified when creating an InnoDB\\n  tablespace, a tabl"
  "espace data file with a unique file name is created\\n  implicitly. The unique file name is a 128 bit UUID formatted i"
  "nto\\n  five groups of hexadecimal numbers separated by dashes\\n  (aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee). A file exten"
  "sion is added if\\n  required by the storage engine. An .ibd file extension is added for\\n  InnoDB general tablespace "
  "data files. In a replication environment,\\n  the data file name created on the replication source server is not\\n  th"
  "e same as the data file name created on the replica.\\n\\n  The ADD DATAFILE clause does not permit circular directory "
  "references\\n  when creating an InnoDB tablespace. For example, the circular\\n  directory reference (/../) in the foll"
  "owing statement is not\\n  permitted:\\n\\nCREATE TABLESPACE ts1 ADD DATAFILE ts1.ibd \\'any_directory/../ts1.ibd\\';\\n\\n "
  " An exception to this restriction exists on Linux, where a circular\\n  directory reference is permitted if the preced"
  "ing directory is a\\n  symbolic link. For example, the data file path in the example above\\n  is permitted if any_dire"
  "ctory is a symbolic link. (It is still\\n  permitted for data file paths to begin with \\'../\\'.)\\n\\n  NDB data files A"
  "n NDB tablespace supports multiple data files which\\n  can have any legal file names; more data files can be added to"
  " an NDB\\n  Cluster tablespace following its creation by using an ALTER\\n  TABLESPACE statement.\\n\\n  An NDB tablespac"
  "e data file is created by default in the data node\\n  file system directory---that is, the directory named ndb_nodeid"
  "_fs/TS\\n  under the data node\\'s data directory (DataDir), where nodeid is the\\n  data node\\'s NodeId. To place the d"
  "ata file in a location other than\\n  the default, include an absolute directory path or a path relative to\\n  the def"
  "ault location. If the directory specified does not exist, NDB\\n  attempts to create it; the system user account under"
  " which the data\\n  node process is running must have the appropriate permissions to do\\n  so.\\n\\n  *Note*:\\n\\n  When "
  "determining the path used for a data file, NDB does not expand\\n  the ~ (tilde) character.\\n\\n  When multiple data no"
  "des are run on the same physical host, the\\n  following considerations apply:\\n\\n  o You cannot specify an absolute p"
  "ath when creating a data file.\\n\\n  o It is not possible to create tablespace data files outside the data\\n    node f"
  "ile system directory, unless each data node has a separate\\n    data directory.\\n\\n  o If each data node has its own "
  "data directory, data files can be\\n    created anywhere within this directory.\\n\\n  o If each data node has its own d"
  "ata directory, it may also be\\n    possible to create a data file outside the node\\'s data directory\\n    using a rel"
  "ative path, as long as this path resolves to a unique\\n    location on the host file system for each data node runnin"
  "g on that\\n    host.\\n\\no FILE_BLOCK_SIZE: This option---which is specific to InnoDB general\\n  tablespaces, and is i"
  "gnored by NDB---defines the block size for the\\n  tablespace data file. Values can be specified in bytes or kilobytes"
  ".\\n  For example, an 8 kilobyte file block size can be specified as 8192\\n  or 8K. If you do not specify this option,"
  " FILE_BLOCK_SIZE defaults to\\n  the innodb_page_size value. FILE_BLOCK_SIZE is required when you\\n  intend to use the"
  " tablespace for storing compressed InnoDB tables\\n  (ROW_FORMAT=COMPRESSED). In this case, you must define the tables"
  "pace\\n  FILE_BLOCK_SIZE when creating the tablespace.\\n\\n  If FILE_BLOCK_SIZE is equal the innodb_page_size value, th"
  "e\\n  tablespace can contain only tables having an uncompressed row format\\n  (COMPACT, REDUNDANT, and DYNAMIC). Table"
  "s with a COMPRESSED row\\n  format have a different physical page size than uncompressed tables.\\n  Therefore, compres"
  "sed tables cannot coexist in the same tablespace as\\n  uncompressed tables.\\n\\n  For a general tablespace to contain "
  "compressed tables,\\n  FILE_BLOCK_SIZE must be specified, and the FILE_BLOCK_SIZE value must\\n  be a valid compressed "
  "page size in relation to the innodb_page_size\\n  value. Also, the physical page size of the compressed table\\n  (KEY_"
  "BLOCK_SIZE) must be equal to FILE_BLOCK_SIZE/1024. For example,\\n  if innodb_page_size=16K, and FILE_BLOCK_SIZE=8K, t"
  "he KEY_BLOCK_SIZE\\n  of the table must be 8. For more information, see\\n  https://dev.mysql.com/doc/refman/8.4/en/gen"
  "eral-tablespaces.html.\\n\\no USE LOGFILE GROUP: Required for NDB, this is the name of a log file\\n  group previously c"
  "reated using CREATE LOGFILE GROUP. Not supported\\n  for InnoDB, where it fails with an error.\\n\\no EXTENT_SIZE: This "
  "option is specific to NDB, and is not supported by\\n  InnoDB, where it fails with an error. EXTENT_SIZE sets the size"
  ", in\\n  bytes, of the extents used by any files belonging to the tablespace.\\n  The default value is 1M. The minimum "
  "size is 32K, and theoretical\\n  maximum is 2G, although the practical maximum size depends on a\\n  number of factors."
  " In most cases, changing the extent size does not\\n  have any measurable effect on performance, and the default value"
  " is\\n  recommended for all but the most unusual situations.\\n\\n  An extent is a unit of disk space allocation. One ex"
  "tent is filled\\n  with as much data as that extent can contain before another extent is\\n  used. In theory, up to 65,"
  "535 (64K) extents may used per data file;\\n  however, the recommended maximum is 32,768 (32K). The recommended\\n  max"
  "imum size for a single data file is 32G---that is, 32K extents x 1\\n  MB per extent. In addition, once an extent is a"
  "llocated to a given\\n  partition, it cannot be used to store data from a different\\n  partition; an extent cannot sto"
  "re data from more than one partition.\\n  This means, for example that a tablespace having a single datafile\\n  whose "
  "INITIAL_SIZE (described in the following item) is 256 MB and\\n  whose EXTENT_SIZE is 128M has just two extents, and s"
  "o can be used to\\n  store data from at most two different disk data table partitions.\\n\\n  You can see how many exten"
  "ts remain free in a given data file by\\n  querying the Information Schema FILES table, and so derive an\\n  estimate f"
  "or how much space remains free in the file. For further\\n  discussion and examples, see\\n  https://dev.mysql.com/doc/"
  "refman/8.4/en/information-schema-files-tabl\\n  e.html.\\n\\no INITIAL_SIZE: This option is specific to NDB, and is not "
  "supported by\\n  InnoDB, where it fails with an error.\\n\\n  The INITIAL_SIZE parameter sets the total size in bytes of"
  " the data\\n  file that was specific using ADD DATATFILE. Once this file has been\\n  created, its size cannot be chang"
  "ed; however, you can add more data\\n  files to the tablespace using ALTER TABLESPACE ... ADD DATAFILE.\\n\\n  INITIAL_S"
  "IZE is optional; its default value is 134217728 (128 MB).\\n\\n  On 32-bit systems, the maximum supported value for INI"
  "TIAL_SIZE is\\n  4294967296 (4 GB).\\n\\no AUTOEXTEND_SIZE: Defines the amount by which InnoDB extends the size\\n  of th"
  "e tablespace when it becomes full. The setting must be a\\n  multiple of 4MB. The default setting is 0, which causes t"
  "he\\n  tablespace to be extended according to the implicit default behavior.\\n  For more information, see\\n  https://d"
  "ev.mysql.com/doc/refman/8.4/en/innodb-tablespace-autoextend-\\n  size.html.\\n\\n  Has no effect in any release of MySQL"
  " NDB Cluster, regardless of the\\n  storage engine used.\\n\\no MAX_SIZE: Currently ignored by MySQL; reserved for possi"
  "ble future\\n  use. Has no effect in any release of MySQL or MySQL NDB Cluster,\\n  regardless of the storage engine us"
  "ed.\\n\\no NODEGROUP: Currently ignored by MySQL; reserved for possible future\\n  use. Has no effect in any release of "
  "MySQL or MySQL NDB Cluster,\\n  regardless of the storage engine used.\\n\\no WAIT: Currently ignored by MySQL; reserved"
  " for possible future use.\\n  Has no effect in any release of MySQL or MySQL NDB Cluster,\\n  regardless of the storage"
  " engine used.\\n\\no COMMENT: Currently ignored by MySQL; reserved for possible future\\n  use. Has no effect in any rel"
  "ease of MySQL or MySQL NDB Cluster,\\n  regardless of the storage engine used.\\n\\no The ENCRYPTION clause enables or d"
  "isables page-level data encryption\\n  for an InnoDB general tablespace.\\n\\n  If the ENCRYPTION clause is not specifie"
  "d, the\\n  default_table_encryption setting controls whether encryption is\\n  enabled. The ENCRYPTION clause overrides"
  " the default_table_encryption\\n  setting. However, if the table_encryption_privilege_check variable is\\n  enabled, th"
  "e TABLE_ENCRYPTION_ADMIN privilege is required to use an\\n  ENCRYPTION clause setting that differs from the\\n  defaul"
  "t_table_encryption setting.\\n\\n  A keyring plugin must be installed and configured before an\\n  encryption-enabled ta"
  "blespace can be created.\\n\\n  When a general tablespace is encrypted, all tables residing in the\\n  tablespace are en"
  "crypted. Likewise, a table created in an encrypted\\n  tablespace is encrypted.\\n\\n  For more information, see\\n  http"
  "s://dev.mysql.com/doc/refman/8.4/en/innodb-data-encryption.html\\n\\no ENGINE: Defines the storage engine which uses th"
  "e tablespace, where\\n  engine_name is the name of the storage engine. Currently, only the\\n  InnoDB storage engine is"
  " supported by standard MySQL 8.4 releases.\\n  MySQL NDB Cluster supports both NDB and InnoDB tablespaces. The value\\n"
  "  of the default_storage_engine system variable is used for ENGINE if\\n  the option is not specified.\\n\\no The ENGINE"
  "_ATTRIBUTE option is used to specify tablespace attributes\\n  for primary storage engines. The option is reserved for"
  " future use.\\n\\n  The value assigned to this option must be a string literal containing\\n  a valid JSON document or a"
  "n empty string (\\'\\'). Invalid JSON is\\n  rejected.\\n\\nCREATE TABLESPACE ts1 ENGINE_ATTRIBUTE=\\'{\"key\":\"value\"}\\'"
  ";\\n\\n  ENGINE_ATTRIBUTE values can be repeated without error. In this case,\\n  the last specified value is used.\\n\\n "
  " ENGINE_ATTRIBUTE values are not checked by the server, nor are they\\n  cleared when the table\\'s storage engine is c"
  "hanged.\\n\\nNotes\\n\\no For the rules covering the naming of MySQL tablespaces, see\\n  https://dev.mysql.com/doc/refman"
  "/8.4/en/identifiers.html. In addition\\n  to these rules, the slash character (\"/\") is not permitted, nor can\\n  you"
  " use names beginning with innodb_, as this prefix is reserved for\\n  system use.\\n\\no Creation of temporary general t"
  "ablespaces is not supported.\\n\\no General tablespaces do not support temporary tables.\\n\\no The TABLESPACE option may"
  " be used with CREATE TABLE or ALTER TABLE to\\n  assign an InnoDB table partition or subpartition to a file-per-table\\"
  "n  tablespace. All partitions must belong to the same storage engine.\\n  Assigning table partitions to shared InnoDB "
  "tablespaces is not\\n  supported. Shared tablespaces include the InnoDB system tablespace\\n  and general tablespaces.\\"
  "n\\no General tablespaces support the addition of tables of any row format\\n  using CREATE TABLE ... TABLESPACE. innod"
  "b_file_per_table does not\\n  need to be enabled.\\n\\no innodb_strict_mode is not applicable to general tablespaces.\\n "
  " Tablespace management rules are strictly enforced independently of\\n  innodb_strict_mode. If CREATE TABLESPACE param"
  "eters are incorrect or\\n  incompatible, the operation fails regardless of the\\n  innodb_strict_mode setting. When a t"
  "able is added to a general\\n  tablespace using CREATE TABLE ... TABLESPACE or ALTER TABLE ...\\n  TABLESPACE, innodb_s"
  "trict_mode is ignored but the statement is\\n  evaluated as if innodb_strict_mode is enabled.\\n\\no Use DROP TABLESPACE"
  " to remove a tablespace. All tables must be\\n  dropped from a tablespace using DROP TABLE prior to dropping the\\n  ta"
  "blespace. Before dropping an NDB Cluster tablespace you must also\\n  remove all its data files using one or more ALTE"
  "R TABLESPACE ... DROP\\n  DATATFILE statements. See\\n  https://dev.mysql.com/doc/refman/8.4/en/mysql-cluster-disk-data"
  "-objec\\n  ts.html.\\n\\no All parts of an InnoDB table added to an InnoDB general tablespace\\n  reside in the general t"
  "ablespace, including indexes and BLOB pages.\\n\\n  For an NDB table assigned to a tablespace, only those columns which"
  "\\n  are not indexed are stored on disk, and actually use the tablespace\\n  data files. Indexes and indexed columns fo"
  "r all NDB tables are always\\n  kept in memory.\\n\\no Similar to the system tablespace, truncating or dropping tables\\n"
  "  stored in a general tablespace creates free space internally in the\\n  general tablespace .ibd data file which can "
  "only be used for new\\n  InnoDB data. Space is not released back to the operating system as it\\n  is for file-per-tabl"
  "e tablespaces.\\n\\no A general tablespace is not associated with any database or schema.\\n\\no ALTER TABLE ... DISCARD "
  "TABLESPACE and ALTER TABLE ...IMPORT\\n  TABLESPACE are not supported for tables that belong to a general\\n  tablespac"
  "e.\\n\\no The server uses tablespace-level metadata locking for DDL that\\n  references general tablespaces. By comparis"
  "on, the server uses\\n  table-level metadata locking for DDL that references file-per-table\\n  tablespaces.\\n\\no A gen"
  "erated or existing tablespace cannot be changed to a general\\n  tablespace.\\n\\no There is no conflict between general"
  " tablespace names and\\n  file-per-table tablespace names. The \"/\" character, which is present\\n  in file-per-table "
  "tablespace names, is not permitted in general\\n  tablespace names.\\n\\no mysqldump does not dump InnoDB CREATE TABLESP"
  "ACE statements.\\n\\nInnoDB Examples\\n\\nThis example demonstrates creating a general tablespace and adding\\nthree uncom"
  "pressed tables of different row formats.\\n\\nmysql> CREATE TABLESPACE `ts1` ADD DATAFILE \\'ts1.ibd\\' ENGINE=INNODB;\\n\\"
  "nmysql> CREATE TABLE t1 (c1 INT PRIMARY KEY) TABLESPACE ts1 ROW_FORMAT=REDUNDANT;\\n\\nmysql> CREATE TABLE t2 (c1 INT P"
  "RIMARY KEY) TABLESPACE ts1 ROW_FORMAT=COMPACT;\\n\\nmysql> CREATE TABLE t3 (c1 INT PRIMARY KEY) TABLESPACE ts1 ROW_FORM"
  "AT=DYNAMIC;\\n\\nThis example demonstrates creating a general tablespace and adding a\\ncompressed table. The example as"
  "sumes a default innodb_page_size value\\nof 16K. The FILE_BLOCK_SIZE of 8192 requires that the compressed table\\nhave "
  "a KEY_BLOCK_SIZE of 8.\\n\\nmysql> CREATE TABLESPACE `ts2` ADD DATAFILE \\'ts2.ibd\\' FILE_BLOCK_SIZE = 8192 ENGINE=InnoD"
  "B;\\n\\nmysql> CREATE TABLE t4 (c1 INT PRIMARY KEY) TABLESPACE ts2 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=8;\\n\\nThis exam"
  "ple demonstrates creating a general tablespace without\\nspecifying the ADD DATAFILE clause, which is optional:\\n\\nmys"
  "ql> CREATE TABLESPACE `ts3` ENGINE=INNODB;\\n\\nThis example demonstrates creating an undo tablespace:\\n\\nmysql> CREATE"
  " UNDO TABLESPACE undo_003 ADD DATAFILE \\'undo_003.ibu\\';\\n\\nNDB Example\\n\\nSuppose that you wish to create an NDB Clu"
  "ster Disk Data tablespace\\nnamed myts using a datafile named mydata-1.dat. An NDB tablespace\\nalways requires the use"
  " of a log file group consisting of one or more\\nundo log files. For this example, we first create a log file group\\nn"
  "amed mylg that contains one undo long file named myundo-1.dat, using\\nthe CREATE LOGFILE GROUP statement shown here:\\"
  "n\\nmysql> CREATE LOGFILE GROUP myg1\\n    ->     ADD UNDOFILE \\'myundo-1.dat\\'\\n    ->     ENGINE=NDB;\\nQuery OK, 0 ro"
  "ws affected (3.29 sec)\\n\\nNow you can create the tablespace previously described using the\\nfollowing statement:\\n\\nm"
  "ysql> CREATE TABLESPACE myts\\n    ->     ADD DATAFILE \\'mydata-1.dat\\'\\n    ->     USE LOGFILE GROUP mylg\\n    ->    "
  " ENGINE=NDB;\\nQuery OK, 0 rows affected (2.98 sec)\\n\\nYou can now create a Disk Data table using a CREATE TABLE state"
  "ment\\nwith the TABLESPACE and STORAGE DISK options, similar to what is shown\\nhere:\\n\\nmysql> CREATE TABLE mytable (\\"
  "n    ->     id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,\\n    ->     lname VARCHAR(50) NOT NULL,\\n    ->     "
  "fname VARCHAR(50) NOT NULL,\\n    ->     dob DATE NOT NULL,\\n    ->     joined DATE NOT NULL,\\n    ->     INDEX(last_n"
  "ame, first_name)\\n    -> )\\n    ->     TABLESPACE myts STORAGE DISK\\n    ->     ENGINE=NDB;\\nQuery OK, 0 rows affecte"
  "d (1.41 sec)\\n\\nIt is important to note that only the dob and joined columns from\\nmytable are actually stored on dis"
  "k, due to the fact that the id,\\nlname, and fname columns are all indexed.\\n\\nAs mentioned previously, when CREATE TA"
  "BLESPACE is used with ENGINE [=]\\nNDB, a tablespace and its associated data file are created on each NDB\\nCluster dat"
  "a node. You can verify that the data files were created and\\nobtain information about them by querying the Informatio"
  "n Schema FILES\\ntable, as shown here:\\n\\nmysql> SELECT FILE_NAME, FILE_TYPE, LOGFILE_GROUP_NAME, STATUS, EXTRA\\n    -"
  ">     FROM INFORMATION_SCHEMA.FILES\\n    ->     WHERE TABLESPACE_NAME = \\'myts\\';\\n\\n+--------------+------------+---"
  "-----------------+--------+----------------+\\n| file_name    | file_type  | logfile_group_name | status | extra      "
  "    |\\n+--------------+------------+--------------------+--------+----------------+\\n| mydata-1.dat | DATAFILE   | my"
  "lg               | NORMAL | CLUSTER_NODE=5 |\\n| mydata-1.dat | DATAFILE   | mylg               | NORMAL | CLUSTER_NOD"
  "E=6 |\\n| NULL         | TABLESPACE | mylg               | NORMAL | NULL           |\\n+--------------+------------+---"
  "-----------------+--------+----------------+\\n3 rows in set (0.01 sec)\\n\\nFor additional information and examples, se"
  "e\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysql-cluster-disk-data-objects\\n.html.\\n\\nURL: https://dev.mysql.com/doc/"
  "refman/8.4/en/create-tablespace.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-tablespace.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (524,40,'CREATE TRIGGER','Sy"
  "ntax:\\nCREATE\\n    [DEFINER = user]\\n    TRIGGER [IF NOT EXISTS] trigger_name\\n    trigger_time trigger_event\\n    ON"
  " tbl_name FOR EACH ROW\\n    [trigger_order]\\n    trigger_body\\n\\ntrigger_time: { BEFORE | AFTER }\\n\\ntrigger_event: {"
  " INSERT | UPDATE | DELETE }\\n\\ntrigger_order: { FOLLOWS | PRECEDES } other_trigger_name\\n\\nThis statement creates a n"
  "ew trigger. A trigger is a named database\\nobject that is associated with a table, and that activates when a\\nparticu"
  "lar event occurs for the table. The trigger becomes associated\\nwith the table named tbl_name, which must refer to a "
  "permanent table.\\nYou cannot associate a trigger with a TEMPORARY table or a view.\\n\\nTrigger names exist in the sche"
  "ma namespace, meaning that all triggers\\nmust have unique names within a schema. Triggers in different schemas\\ncan h"
  "ave the same name.\\n\\nIF NOT EXISTS prevents an error from occurring if a trigger having the\\nsame name, on the same "
  "table, exists in the same schema.\\n\\nThis section describes CREATE TRIGGER syntax. For additional\\ndiscussion, see\\nh"
  "ttps://dev.mysql.com/doc/refman/8.4/en/trigger-syntax.html.\\n\\nCREATE TRIGGER requires the TRIGGER privilege for the "
  "table associated\\nwith the trigger. If the DEFINER clause is present, the privileges\\nrequired depend on the user val"
  "ue, as discussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-objects-security.html.\\nIf binary logging is enab"
  "led, CREATE TRIGGER might require the SUPER\\nprivilege, as discussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stor"
  "ed-programs-logging.html.\\n\\nThe DEFINER clause determines the security context to be used when\\nchecking access priv"
  "ileges at trigger activation time, as described\\nlater in this section.\\n\\ntrigger_time is the trigger action time. I"
  "t can be BEFORE or AFTER to\\nindicate that the trigger activates before or after each row to be\\nmodified.\\n\\nBasic c"
  "olumn value checks occur prior to trigger activation, so you\\ncannot use BEFORE triggers to convert values inappropri"
  "ate for the\\ncolumn type to valid values.\\n\\ntrigger_event indicates the kind of operation that activates the\\ntrigge"
  "r. These trigger_event values are permitted:\\n\\no INSERT: The trigger activates whenever a new row is inserted into t"
  "he\\n  table (for example, through INSERT, LOAD DATA, and REPLACE\\n  statements).\\n\\no UPDATE: The trigger activates w"
  "henever a row is modified (for\\n  example, through UPDATE statements).\\n\\no DELETE: The trigger activates whenever a "
  "row is deleted from the\\n  table (for example, through DELETE and REPLACE statements). DROP\\n  TABLE and TRUNCATE TAB"
  "LE statements on the table do not activate this\\n  trigger, because they do not use DELETE. Dropping a partition does"
  "\\n  not activate DELETE triggers, either.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/create-trigger.html\\n\\n',''"
  ",'https://dev.mysql.com/doc/refman/8.4/en/create-trigger.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (525,40,'CREATE VIEW','Synta"
  "x:\\nCREATE\\n    [OR REPLACE]\\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\\n    [DEFINER = user]\\n    [SQL SECUR"
  "ITY { DEFINER | INVOKER }]\\n    VIEW view_name [(column_list)]\\n    AS select_statement\\n    [WITH [CASCADED | LOCAL]"
  " CHECK OPTION]\\n\\nThe CREATE VIEW statement creates a new view, or replaces an existing\\nview if the OR REPLACE claus"
  "e is given. If the view does not exist,\\nCREATE OR REPLACE VIEW is the same as CREATE VIEW. If the view does\\nexist, "
  "CREATE OR REPLACE VIEW replaces it.\\n\\nFor information about restrictions on view use, see\\nhttps://dev.mysql.com/doc"
  "/refman/8.4/en/view-restrictions.html.\\n\\nThe select_statement is a SELECT statement that provides the definition\\nof"
  " the view. (Selecting from the view selects, in effect, using the\\nSELECT statement.) The select_statement can select"
  " from base tables or\\nfrom other views. The SELECT statement can use a VALUES statement as\\nits source, or can be rep"
  "laced with a TABLE statement, as with CREATE\\nTABLE ... SELECT.\\n\\nThe view definition is \"frozen\" at creation time"
  " and is not affected by\\nsubsequent changes to the definitions of the underlying tables. For\\nexample, if a view is d"
  "efined as SELECT * on a table, new columns added\\nto the table later do not become part of the view, and columns drop"
  "ped\\nfrom the table result in an error when selecting from the view.\\n\\nThe ALGORITHM clause affects how MySQL proces"
  "ses the view. The DEFINER\\nand SQL SECURITY clauses specify the security context to be used when\\nchecking access pri"
  "vileges at view invocation time. The WITH CHECK\\nOPTION clause can be given to constrain inserts or updates to rows i"
  "n\\ntables referenced by the view. These clauses are described later in\\nthis section.\\n\\nThe CREATE VIEW statement re"
  "quires the CREATE VIEW privilege for the\\nview, and some privilege for each column selected by the SELECT\\nstatement."
  " For columns used elsewhere in the SELECT statement, you must\\nhave the SELECT privilege. If the OR REPLACE clause is"
  " present, you\\nmust also have the DROP privilege for the view. If the DEFINER clause\\nis present, the privileges requ"
  "ired depend on the user value, as\\ndiscussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-objects-security.html"
  ".\\n\\nWhen a view is referenced, privilege checking occurs as described later\\nin this section.\\n\\nA view belongs to a"
  " database. By default, a new view is created in the\\ndefault database. To create the view explicitly in a given datab"
  "ase,\\nuse db_name.view_name syntax to qualify the view name with the database\\nname:\\n\\nCREATE VIEW test.v AS SELECT "
  "* FROM t;\\n\\nUnqualified table or view names in the SELECT statement are also\\ninterpreted with respect to the defaul"
  "t database. A view can refer to\\ntables or views in other databases by qualifying the table or view name\\nwith the ap"
  "propriate database name.\\n\\nWithin a database, base tables and views share the same namespace, so a\\nbase table and a"
  " view cannot have the same name.\\n\\nColumns retrieved by the SELECT statement can be simple references to\\ntable colu"
  "mns, or expressions that use functions, constant values,\\noperators, and so forth.\\n\\nA view must have unique column "
  "names with no duplicates, just like a\\nbase table. By default, the names of the columns retrieved by the\\nSELECT stat"
  "ement are used for the view column names. To define explicit\\nnames for the view columns, specify the optional column"
  "_list clause as\\na list of comma-separated identifiers. The number of names in\\ncolumn_list must be the same as the n"
  "umber of columns retrieved by the\\nSELECT statement.\\n\\nA view can be created from many kinds of SELECT statements. I"
  "t can\\nrefer to base tables or other views. It can use joins, UNION, and\\nsubqueries. The SELECT need not even refer "
  "to any tables:\\n\\nCREATE VIEW v_today (today) AS SELECT CURRENT_DATE;\\n\\nThe following example defines a view that se"
  "lects two columns from\\nanother table as well as an expression calculated from those columns:\\n\\nmysql> CREATE TABLE "
  "t (qty INT, price INT);\\nmysql> INSERT INTO t VALUES(3, 50);\\nmysql> CREATE VIEW v AS SELECT qty, price, qty*price AS"
  " value FROM t;\\nmysql> SELECT * FROM v;\\n+------+-------+-------+\\n| qty  | price | value |\\n+------+-------+-------+"
  "\\n|    3 |    50 |   150 |\\n+------+-------+-------+\\n\\nA view definition is subject to the following restrictions:\\n"
  "\\no The SELECT statement cannot refer to system variables or user-defined\\n  variables.\\n\\no Within a stored program,"
  " the SELECT statement cannot refer to program\\n  parameters or local variables.\\n\\no The SELECT statement cannot refe"
  "r to prepared statement parameters.\\n\\no Any table or view referred to in the definition must exist. If, after\\n  the"
  " view has been created, a table or view that the definition refers\\n  to is dropped, use of the view results in an er"
  "ror. To check a view\\n  definition for problems of this kind, use the CHECK TABLE statement.\\n\\no The definition cann"
  "ot refer to a TEMPORARY table, and you cannot\\n  create a TEMPORARY view.\\n\\no You cannot associate a trigger with a "
  "view.\\n\\no Aliases for column names in the SELECT statement are checked against\\n  the maximum column length of 64 ch"
  "aracters (not the maximum alias\\n  length of 256 characters).\\n\\nORDER BY is permitted in a view definition, but it i"
  "s ignored if you\\nselect from a view using a statement that has its own ORDER BY.\\n\\nFor other options or clauses in "
  "the definition, they are added to the\\noptions or clauses of the statement that references the view, but the\\neffect "
  "is undefined. For example, if a view definition includes a LIMIT\\nclause, and you select from the view using a statem"
  "ent that has its own\\nLIMIT clause, it is undefined which limit applies. This same principle\\napplies to options such"
  " as ALL, DISTINCT, or SQL_SMALL_RESULT that\\nfollow the SELECT keyword, and to clauses such as INTO, FOR UPDATE, FOR\\"
  "nSHARE, LOCK IN SHARE MODE, and PROCEDURE.\\n\\nThe results obtained from a view may be affected if you change the\\nque"
  "ry processing environment by changing system variables:\\n\\nmysql> CREATE VIEW v (mycol) AS SELECT \\'abc\\';\\nQuery OK,"
  " 0 rows affected (0.01 sec)\\n\\nmysql> SET sql_mode = \\'\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT \"m"
  "ycol\" FROM v;\\n+-------+\\n| mycol |\\n+-------+\\n| mycol |\\n+-------+\\n1 row in set (0.01 sec)\\n\\nmysql> SET sql_mode"
  " = \\'ANSI_QUOTES\\';\\nQuery OK, 0 rows affected (0.00 sec)\\n\\nmysql> SELECT \"mycol\" FROM v;\\n+-------+\\n| mycol |\\n+"
  "-------+\\n| abc   |\\n+-------+\\n1 row in set (0.00 sec)\\n\\nThe DEFINER and SQL SECURITY clauses determine which MySQL"
  " account to\\nuse when checking access privileges for the view when a statement is\\nexecuted that references the view."
  " The valid SQL SECURITY\\ncharacteristic values are DEFINER (the default) and INVOKER. These\\nindicate that the requir"
  "ed privileges must be held by the user who\\ndefined or invoked the view, respectively.\\n\\nIf the DEFINER clause is pr"
  "esent, the user value should be a MySQL\\naccount specified as \\'user_name\\'@\\'host_name\\', CURRENT_USER, or\\nCURRENT_"
  "USER(). The permitted user values depend on the privileges you\\nhold, as discussed in\\nhttps://dev.mysql.com/doc/refm"
  "an/8.4/en/stored-objects-security.html.\\nAlso see that section for additional information about view security.\\n\\nIf "
  "the DEFINER clause is omitted, the default definer is the user who\\nexecutes the CREATE VIEW statement. This is the s"
  "ame as specifying\\nDEFINER = CURRENT_USER explicitly.\\n\\nWithin a view definition, the CURRENT_USER function returns "
  "the view\\'s\\nDEFINER value by default. For views defined with the SQL SECURITY\\nINVOKER characteristic, CURRENT_USER "
  "returns the account for the view\\'s\\ninvoker. For information about user auditing within views, see\\nhttps://dev.mysq"
  "l.com/doc/refman/8.4/en/account-activity-auditing.html.\\n\\nWithin a stored routine that is defined with the SQL SECUR"
  "ITY DEFINER\\ncharacteristic, CURRENT_USER returns the routine\\'s DEFINER value. This\\nalso affects a view defined wit"
  "hin such a routine, if the view\\ndefinition contains a DEFINER value of CURRENT_USER.\\n\\nMySQL checks view privileges"
  " like this:\\n\\no At view definition time, the view creator must have the privileges\\n  needed to use the top-level ob"
  "jects accessed by the view. For\\n  example, if the view definition refers to table columns, the creator\\n  must have "
  "some privilege for each column in the select list of the\\n  definition, and the SELECT privilege for each column used"
  " elsewhere\\n  in the definition. If the definition refers to a stored function,\\n  only the privileges needed to invo"
  "ke the function can be checked. The\\n  privileges required at function invocation time can be checked only\\n  as it e"
  "xecutes: For different invocations, different execution paths\\n  within the function might be taken.\\n\\no The user wh"
  "o references a view must have appropriate privileges to\\n  access it (SELECT to select from it, INSERT to insert into"
  " it, and so\\n  forth.)\\n\\no When a view has been referenced, privileges for objects accessed by\\n  the view are check"
  "ed against the privileges held by the view DEFINER\\n  account or invoker, depending on whether the SQL SECURITY\\n  ch"
  "aracteristic is DEFINER or INVOKER, respectively.\\n\\no If reference to a view causes execution of a stored function,\\"
  "n  privilege checking for statements executed within the function depend\\n  on whether the function SQL SECURITY char"
  "acteristic is DEFINER or\\n  INVOKER. If the security characteristic is DEFINER, the function runs\\n  with the privile"
  "ges of the DEFINER account. If the characteristic is\\n  INVOKER, the function runs with the privileges determined by "
  "the\\n  view\\'s SQL SECURITY characteristic.\\n\\nExample: A view might depend on a stored function, and that function\\n"
  "might invoke other stored routines. For example, the following view\\ninvokes a stored function f():\\n\\nCREATE VIEW v "
  "AS SELECT * FROM t WHERE t.id = f(t.name);\\n\\nSuppose that f() contains a statement such as this:\\n\\nIF name IS NULL "
  "then\\n  CALL p1();\\nELSE\\n  CALL p2();\\nEND IF;\\n\\nThe privileges required for executing statements within f() need t"
  "o be\\nchecked when f() executes. This might mean that privileges are needed\\nfor p1() or p2(), depending on the execu"
  "tion path within f(). Those\\nprivileges must be checked at runtime, and the user who must possess\\nthe privileges is "
  "determined by the SQL SECURITY values of the view v\\nand the function f().\\n\\nThe DEFINER and SQL SECURITY clauses fo"
  "r views are extensions to\\nstandard SQL. In standard SQL, views are handled using the rules for\\nSQL SECURITY DEFINER"
  ". The standard says that the definer of the view,\\nwhich is the same as the owner of the view\\'s schema, gets applica"
  "ble\\nprivileges on the view (for example, SELECT) and may grant them. MySQL\\nhas no concept of a schema \"owner\", so"
  " MySQL adds a clause to identify\\nthe definer. The DEFINER clause is an extension where the intent is to\\nhave what t"
  "he standard has; that is, a permanent record of who defined\\nthe view. This is why the default DEFINER value is the a"
  "ccount of the\\nview creator.\\n\\nThe optional ALGORITHM clause is a MySQL extension to standard SQL. It\\naffects how M"
  "ySQL processes the view. ALGORITHM takes three values:\\nMERGE, TEMPTABLE, or UNDEFINED. For more information, see\\nht"
  "tps://dev.mysql.com/doc/refman/8.4/en/view-algorithms.html, as well\\nas\\nhttps://dev.mysql.com/doc/refman/8.4/en/deri"
  "ved-table-optimization.html\\n.\\n\\nSome views are updatable. That is, you can use them in statements such\\nas UPDATE, "
  "DELETE, or INSERT to update the contents of the underlying\\ntable. For a view to be updatable, there must be a one-to"
  "-one\\nrelationship between the rows in the view and the rows in the\\nunderlying table. There are also certain other c"
  "onstructs that make a\\nview nonupdatable.\\n\\nA generated column in a view is considered updatable because it is\\nposs"
  "ible to assign to it. However, if such a column is updated\\nexplicitly, the only permitted value is DEFAULT. For info"
  "rmation about\\ngenerated columns, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/create-table-generated-columns.\\nhtml."
  "\\n\\nThe WITH CHECK OPTION clause can be given for an updatable view to\\nprevent inserts or updates to rows except tho"
  "se for which the WHERE\\nclause in the select_statement is true.\\n\\nIn a WITH CHECK OPTION clause for an updatable vie"
  "w, the LOCAL and\\nCASCADED keywords determine the scope of check testing when the view is\\ndefined in terms of anothe"
  "r view. The LOCAL keyword restricts the CHECK\\nOPTION only to the view being defined. CASCADED causes the checks for\\"
  "nunderlying views to be evaluated as well. When neither keyword is\\ngiven, the default is CASCADED.\\n\\nFor more infor"
  "mation about updatable views and the WITH CHECK OPTION\\nclause, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/view-upd"
  "atability.html, and\\nhttps://dev.mysql.com/doc/refman/8.4/en/view-check-option.html.\\n\\nURL: https://dev.mysql.com/do"
  "c/refman/8.4/en/create-view.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/create-view.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (526,40,'DROP DATABASE','Syn"
  "tax:\\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\\n\\nDROP DATABASE drops all tables in the database and deletes the\\"
  "ndatabase. Be very careful with this statement! To use DROP DATABASE,\\nyou need the DROP privilege on the database. D"
  "ROP SCHEMA is a synonym\\nfor DROP DATABASE.\\n\\n*Important*:\\n\\nWhen a database is dropped, privileges granted specifi"
  "cally for the\\ndatabase are not automatically dropped. They must be dropped manually.\\nSee [HELP GRANT].\\n\\nIF EXISTS"
  " is used to prevent an error from occurring if the database\\ndoes not exist.\\n\\nURL: https://dev.mysql.com/doc/refman"
  "/8.4/en/drop-database.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-database.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (527,40,'DROP SCHEMA','Synta"
  "x:\\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\\n\\nDROP DATABASE drops all tables in the database and deletes the\\nd"
  "atabase. Be very careful with this statement! To use DROP DATABASE,\\nyou need the DROP privilege on the database. DRO"
  "P SCHEMA is a synonym\\nfor DROP DATABASE.\\n\\n*Important*:\\n\\nWhen a database is dropped, privileges granted specifica"
  "lly for the\\ndatabase are not automatically dropped. They must be dropped manually.\\nSee [HELP GRANT].\\n\\nIF EXISTS i"
  "s used to prevent an error from occurring if the database\\ndoes not exist.\\n\\nURL: https://dev.mysql.com/doc/refman/8"
  ".4/en/drop-database.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-database.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (528,40,'DROP EVENT','Syntax"
  ":\\nDROP EVENT [IF EXISTS] event_name\\n\\nThis statement drops the event named event_name. The event immediately\\ncease"
  "s being active, and is deleted completely from the server.\\n\\nIf the event does not exist, the error ERROR 1517 (HY00"
  "0): Unknown\\nevent \\'event_name\\' results. You can override this and cause the\\nstatement to generate a warning for n"
  "onexistent events instead using IF\\nEXISTS.\\n\\nThis statement requires the EVENT privilege for the schema to which th"
  "e\\nevent to be dropped belongs.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/drop-event.html\\n\\n','','https://dev."
  "mysql.com/doc/refman/8.4/en/drop-event.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (529,40,'DROP INDEX','Syntax"
  ":\\nDROP INDEX index_name ON tbl_name\\n    [algorithm_option | lock_option] ...\\n\\nalgorithm_option:\\n    ALGORITHM [="
  "] {DEFAULT | INPLACE | COPY}\\n\\nlock_option:\\n    LOCK [=] {DEFAULT | NONE | SHARED | EXCLUSIVE}\\n\\nDROP INDEX drops "
  "the index named index_name from the table tbl_name.\\nThis statement is mapped to an ALTER TABLE statement to drop the"
  " index.\\nSee [HELP ALTER TABLE].\\n\\nTo drop a primary key, the index name is always PRIMARY, which must be\\nspecified"
  " as a quoted identifier because PRIMARY is a reserved word:\\n\\nDROP INDEX `PRIMARY` ON t;\\n\\nURL: https://dev.mysql.c"
  "om/doc/refman/8.4/en/drop-index.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-index.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (530,40,'DROP PROCEDURE','Sy"
  "ntax:\\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\\n\\nThese statements are used to drop a stored routine (a store"
  "d procedure\\nor function). That is, the specified routine is removed from the\\nserver. (DROP FUNCTION is also used to"
  " drop loadable functions; see\\n[HELP DROP FUNCTION loadable function].)\\n\\nTo drop a stored routine, you must have th"
  "e ALTER ROUTINE privilege for\\nit. (If the automatic_sp_privileges system variable is enabled, that\\nprivilege and EX"
  "ECUTE are granted automatically to the routine creator\\nwhen the routine is created and dropped from the creator when"
  " the\\nroutine is dropped. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-routines-privileges.html\\n.)\\n\\nIn addi"
  "tion, if the definer of the routine has the SYSTEM_USER\\nprivilege, the user dropping it must also have this privileg"
  "e.\\n\\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\\noccurring if the procedure or function do"
  "es not exist. A warning is\\nproduced that can be viewed with SHOW WARNINGS.\\n\\nURL: https://dev.mysql.com/doc/refman/"
  "8.4/en/drop-procedure.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-procedure.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (531,40,'DROP FUNCTION','Syn"
  "tax:\\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\\n\\nThese statements are used to drop a stored routine (a stored"
  " procedure\\nor function). That is, the specified routine is removed from the\\nserver. (DROP FUNCTION is also used to "
  "drop loadable functions; see\\n[HELP DROP FUNCTION loadable function].)\\n\\nTo drop a stored routine, you must have the"
  " ALTER ROUTINE privilege for\\nit. (If the automatic_sp_privileges system variable is enabled, that\\nprivilege and EXE"
  "CUTE are granted automatically to the routine creator\\nwhen the routine is created and dropped from the creator when "
  "the\\nroutine is dropped. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/stored-routines-privileges.html\\n.)\\n\\nIn addit"
  "ion, if the definer of the routine has the SYSTEM_USER\\nprivilege, the user dropping it must also have this privilege"
  ".\\n\\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\\noccurring if the procedure or function doe"
  "s not exist. A warning is\\nproduced that can be viewed with SHOW WARNINGS.\\n\\nURL: https://dev.mysql.com/doc/refman/8"
  ".4/en/drop-procedure.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-procedure.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (532,40,'DROP SERVER','Synta"
  "x:\\nDROP SERVER [ IF EXISTS ] server_name\\n\\nDrops the server definition for the server named server_name. The\\ncorre"
  "sponding row in the mysql.servers table is deleted. This statement\\nrequires the SUPER privilege.\\n\\nDropping a serve"
  "r for a table does not affect any FEDERATED tables that\\nused this connection information when they were created. See"
  " [HELP\\nCREATE SERVER].\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/drop-server.html\\n\\n','','https://dev.mysql.c"
  "om/doc/refman/8.4/en/drop-server.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (533,40,'DROP SPATIAL REFERE"
  "NCE SYSTEM','Syntax:\\nDROP SPATIAL REFERENCE SYSTEM\\n    [IF EXISTS]\\n    srid\\n\\nsrid: 32-bit unsigned integer\\n\\nTh"
  "is statement removes a spatial reference system (SRS) definition from\\nthe data dictionary. It requires the SUPER pri"
  "vilege.\\n\\nExample:\\n\\nDROP SPATIAL REFERENCE SYSTEM 4120;\\n\\nIf no SRS definition with the SRID value exists, an err"
  "or occurs unless\\nIF EXISTS is specified. In that case, a warning occurs rather than an\\nerror.\\n\\nIf the SRID value "
  "is used by some column in an existing table, an error\\noccurs. For example:\\n\\nmysql> DROP SPATIAL REFERENCE SYSTEM 4"
  "326;\\nERROR 3716 (SR005): Can\\'t modify SRID 4326. There is at\\nleast one column depending on it.\\n\\nTo identify whic"
  "h column or columns use the SRID, use this query:\\n\\nSELECT * FROM INFORMATION_SCHEMA.ST_GEOMETRY_COLUMNS WHERE SRS_I"
  "D=4326;\\n\\nSRID values must be in the range of 32-bit unsigned integers, with\\nthese restrictions:\\n\\no SRID 0 is a v"
  "alid SRID but cannot be used with DROP SPATIAL REFERENCE\\n  SYSTEM.\\n\\no If the value is in a reserved SRID range, a "
  "warning occurs. Reserved\\n  ranges are [0, 32767] (reserved by EPSG), [60,000,000, 69,999,999]\\n  (reserved by EPSG),"
  " and [2,000,000,000, 2,147,483,647] (reserved by\\n  MySQL). EPSG stands for the European Petroleum Survey Group\\n  (h"
  "ttp://epsg.org).\\n\\no Users should not drop SRSs with SRIDs in the reserved ranges. If\\n  system-installed SRSs are d"
  "ropped, the SRS definitions may be\\n  recreated for MySQL upgrades.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/d"
  "rop-spatial-reference-system.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-spatial-reference-system.html"
  "');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (534,40,'DROP TABLE','Syntax"
  ":\\nDROP [TEMPORARY] TABLE [IF EXISTS]\\n    tbl_name [, tbl_name] ...\\n    [RESTRICT | CASCADE]\\n\\nDROP TABLE removes "
  "one or more tables. You must have the DROP privilege\\nfor each table.\\n\\nBe careful with this statement! For each tab"
  "le, it removes the table\\ndefinition and all table data. If the table is partitioned, the\\nstatement removes the tabl"
  "e definition, all its partitions, all data\\nstored in those partitions, and all partition definitions associated\\nwit"
  "h the dropped table.\\n\\nDropping a table also drops any triggers for the table.\\n\\nDROP TABLE causes an implicit comm"
  "it, except when used with the\\nTEMPORARY keyword. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/implicit-commit.html.\\"
  "n\\n*Important*:\\n\\nWhen a table is dropped, privileges granted specifically for the table\\nare not automatically drop"
  "ped. They must be dropped manually. See [HELP\\nGRANT].\\n\\nIf any tables named in the argument list do not exist, DROP"
  " TABLE\\nbehavior depends on whether the IF EXISTS clause is given:\\n\\no Without IF EXISTS, the statement fails with a"
  "n error indicating which\\n  nonexisting tables it was unable to drop, and no changes are made.\\n\\no With IF EXISTS, n"
  "o error occurs for nonexisting tables. The statement\\n  drops all named tables that do exist, and generates a NOTE di"
  "agnostic\\n  for each nonexistent table. These notes can be displayed with SHOW\\n  WARNINGS. See [HELP SHOW WARNINGS]."
  "\\n\\nIF EXISTS can also be useful for dropping tables in unusual\\ncircumstances under which there is an entry in the d"
  "ata dictionary but\\nno table managed by the storage engine. (For example, if an abnormal\\nserver exit occurs after re"
  "moval of the table from the storage engine\\nbut before removal of the data dictionary entry.)\\n\\nThe TEMPORARY keywor"
  "d has the following effects:\\n\\no The statement drops only TEMPORARY tables.\\n\\no The statement does not cause an imp"
  "licit commit.\\n\\no No access rights are checked. A TEMPORARY table is visible only with\\n  the session that created i"
  "t, so no check is necessary.\\n\\nIncluding the TEMPORARY keyword is a good way to prevent accidentally\\ndropping non-T"
  "EMPORARY tables.\\n\\nThe RESTRICT and CASCADE keywords do nothing. They are permitted to\\nmake porting easier from oth"
  "er database systems.\\n\\nDROP TABLE is not supported with all innodb_force_recovery settings.\\nSee\\nhttps://dev.mysql."
  "com/doc/refman/8.4/en/forcing-innodb-recovery.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/drop-table.html\\n"
  "\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-table.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (535,40,'DROP TABLESPACE','S"
  "yntax:\\nDROP [UNDO] TABLESPACE tablespace_name\\n\\nThis statement drops a tablespace that was previously created using"
  "\\nCREATE TABLESPACE. It is supported by the NDB and InnoDB storage\\nengines.\\n\\nThe UNDO keyword must be specified to"
  " drop an undo tablespace. Only\\nundo tablespaces created using CREATE UNDO TABLESPACE syntax can be\\ndropped. An undo"
  " tablespace must be in an empty state before it can be\\ndropped. For more information, see\\nhttps://dev.mysql.com/doc"
  "/refman/8.4/en/innodb-undo-tablespaces.html.\\n\\ntablespace_name is a case-sensitive identifier in MySQL.\\n\\nFor an In"
  "noDB general tablespace, all tables must be dropped from the\\ntablespace prior to a DROP TABLESPACE operation. If the"
  " tablespace is\\nnot empty, DROP TABLESPACE returns an error.\\n\\nAn NDB tablespace to be dropped must not contain any "
  "data files; in\\nother words, before you can drop an NDB tablespace, you must first drop\\neach of its data files using"
  " ALTER TABLESPACE ... DROP DATAFILE.\\n\\nNotes\\n\\no A general InnoDB tablespace is not deleted automatically when the\\"
  "n  last table in the tablespace is dropped. The tablespace must be\\n  dropped explicitly using DROP TABLESPACE tables"
  "pace_name.\\n\\no A DROP DATABASE operation can drop tables that belong to a general\\n  tablespace but it cannot drop t"
  "he tablespace, even if the operation\\n  drops all tables that belong to the tablespace. The tablespace must\\n  be dro"
  "pped explicitly using DROP TABLESPACE tablespace_name.\\n\\no Similar to the system tablespace, truncating or dropping "
  "tables\\n  stored in a general tablespace creates free space internally in the\\n  general tablespace .ibd data file wh"
  "ich can only be used for new\\n  InnoDB data. Space is not released back to the operating system as it\\n  is for file-"
  "per-table tablespaces.\\n\\nInnoDB Examples\\n\\nThis example demonstrates how to drop an InnoDB general tablespace. The\\"
  "ngeneral tablespace ts1 is created with a single table. Before dropping\\nthe tablespace, the table must be dropped.\\n"
  "\\nmysql> CREATE TABLESPACE `ts1` ADD DATAFILE \\'ts1.ibd\\' Engine=InnoDB;\\n\\nmysql> CREATE TABLE t1 (c1 INT PRIMARY KE"
  "Y) TABLESPACE ts1 Engine=InnoDB;\\n\\nmysql> DROP TABLE t1;\\n\\nmysql> DROP TABLESPACE ts1;\\n\\nThis example demonstrates"
  " dropping an undo tablespace. An undo\\ntablespace must be in an empty state before it can be dropped. For more\\ninfor"
  "mation, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/innodb-undo-tablespaces.html.\\n\\nmysql> DROP UNDO TABLESPACE und"
  "o_003;\\n\\nNDB Example\\n\\nThis example shows how to drop an NDB tablespace myts having a data\\nfile named mydata-1.dat"
  " after first creating the tablespace, and\\nassumes the existence of a log file group named mylg (see [HELP CREATE\\nLO"
  "GFILE GROUP]).\\n\\nmysql> CREATE TABLESPACE myts\\n    ->     ADD DATAFILE \\'mydata-1.dat\\'\\n    ->     USE LOGFILE GRO"
  "UP mylg\\n    ->     ENGINE=NDB;\\n\\nYou must remove all data files from the tablespace using ALTER\\nTABLESPACE, as sho"
  "wn here, before it can be dropped:\\n\\nmysql> ALTER TABLESPACE myts\\n    ->     DROP DATAFILE \\'mydata-1.dat\\';\\n\\nmys"
  "ql> DROP TABLESPACE myts;\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/drop-tablespace.html\\n\\n','','https://dev.m"
  "ysql.com/doc/refman/8.4/en/drop-tablespace.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (536,40,'DROP TRIGGER','Synt"
  "ax:\\nDROP TRIGGER [IF EXISTS] [schema_name.]trigger_name\\n\\nThis statement drops a trigger. The schema (database) nam"
  "e is optional.\\nIf the schema is omitted, the trigger is dropped from the default\\nschema. DROP TRIGGER requires the "
  "TRIGGER privilege for the table\\nassociated with the trigger.\\n\\nUse IF EXISTS to prevent an error from occurring for"
  " a trigger that\\ndoes not exist. A NOTE is generated for a nonexistent trigger when\\nusing IF EXISTS. See [HELP SHOW "
  "WARNINGS].\\n\\nTriggers for a table are also dropped if you drop the table.\\n\\nURL: https://dev.mysql.com/doc/refman/8"
  ".4/en/drop-trigger.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/drop-trigger.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (537,40,'DROP VIEW','Syntax:"
  "\\nDROP VIEW [IF EXISTS]\\n    view_name [, view_name] ...\\n    [RESTRICT | CASCADE]\\n\\nDROP VIEW removes one or more v"
  "iews. You must have the DROP privilege\\nfor each view.\\n\\nIf any views named in the argument list do not exist, the s"
  "tatement\\nfails with an error indicating by name which nonexisting views it was\\nunable to drop, and no changes are m"
  "ade.\\n\\n*Note*:\\n\\nIn MySQL 8.3 and earlier, DROP VIEW returns an error if any views named\\nin the argument list do n"
  "ot exist, but also drops all views in the list\\nthat do exist. Due to the change in behavior in MySQL 8.4, a partiall"
  "y\\ncompleted DROP VIEW operation on a MySQL 8.3 replication source server\\nfails when replicated on a MySQL 8.4 repli"
  "ca. To avoid this failure\\nscenario, use IF EXISTS syntax in DROP VIEW statements to prevent an\\nerror from occurring"
  " for views that do not exist. For more information,\\nsee https://dev.mysql.com/doc/refman/8.4/en/atomic-ddl.html.\\n\\n"
  "The IF EXISTS clause prevents an error from occurring for views that\\ndon\\'t exist. When this clause is given, a NOTE"
  " is generated for each\\nnonexistent view. See [HELP SHOW WARNINGS].\\n\\nRESTRICT and CASCADE, if given, are parsed and"
  " ignored.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/drop-view.html\\n\\n','','https://dev.mysql.com/doc/refman/8."
  "4/en/drop-view.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (538,40,'RENAME TABLE','Synt"
  "ax:\\nRENAME TABLE\\n    tbl_name TO new_tbl_name\\n    [, tbl_name2 TO new_tbl_name2] ...\\n\\nRENAME TABLE renames one o"
  "r more tables. You must have ALTER and DROP\\nprivileges for the original table, and CREATE and INSERT privileges for\\"
  "nthe new table.\\n\\nFor example, to rename a table named old_table to new_table, use this\\nstatement:\\n\\nRENAME TABLE "
  "old_table TO new_table;\\n\\nThat statement is equivalent to the following ALTER TABLE statement:\\n\\nALTER TABLE old_ta"
  "ble RENAME new_table;\\n\\nRENAME TABLE, unlike ALTER TABLE, can rename multiple tables within a\\nsingle statement:\\n\\n"
  "RENAME TABLE old_table1 TO new_table1,\\n             old_table2 TO new_table2,\\n             old_table3 TO new_table3"
  ";\\n\\nRenaming operations are performed left to right. Thus, to swap two\\ntable names, do this (assuming that a table "
  "with the intermediary name\\ntmp_table does not already exist):\\n\\nRENAME TABLE old_table TO tmp_table,\\n             "
  "new_table TO old_table,\\n             tmp_table TO new_table;\\n\\nMetadata locks on tables are acquired in name order,"
  " which in some\\ncases can make a difference in operation outcome when multiple\\ntransactions execute concurrently. Se"
  "e\\nhttps://dev.mysql.com/doc/refman/8.4/en/metadata-locking.html.\\n\\nYou can rename tables locked with a LOCK TABLES "
  "statement, provided\\nthat they are locked with a WRITE lock or are the product of renaming\\nWRITE-locked tables from "
  "earlier steps in a multiple-table rename\\noperation. For example, this is permitted:\\n\\nLOCK TABLE old_table1 WRITE;\\"
  "nRENAME TABLE old_table1 TO new_table1,\\n             new_table1 TO new_table2;\\n\\nThis is not permitted:\\n\\nLOCK TAB"
  "LE old_table1 READ;\\nRENAME TABLE old_table1 TO new_table1,\\n             new_table1 TO new_table2;\\n\\nWith the trans"
  "action table locking conditions satisfied, the rename\\noperation is done atomically; no other session can access any "
  "of the\\ntables while the rename is in progress.\\n\\nIf any errors occur during a RENAME TABLE, the statement fails and"
  " no\\nchanges are made.\\n\\nYou can use RENAME TABLE to move a table from one database to another:\\n\\nRENAME TABLE curr"
  "ent_db.tbl_name TO other_db.tbl_name;\\n\\nUsing this method to move all tables from one database to a different\\none i"
  "n effect renames the database (an operation for which MySQL has no\\nsingle statement), except that the original datab"
  "ase continues to\\nexist, albeit with no tables.\\n\\nLike RENAME TABLE, ALTER TABLE ... RENAME can also be used to move"
  " a\\ntable to a different database. Regardless of the statement used, if the\\nrename operation would move the table to"
  " a database located on a\\ndifferent file system, the success of the outcome is platform specific\\nand depends on the "
  "underlying operating system calls used to move table\\nfiles.\\n\\nIf a table has triggers, attempts to rename the table"
  " into a different\\ndatabase fail with a Trigger in wrong schema (ER_TRG_IN_WRONG_SCHEMA\\n(https://dev.mysql.com/doc/m"
  "ysql-errors/8.4/en/server-error-reference.html\\n#error_er_trg_in_wrong_schema)) error.\\n\\nAn unencrypted table can be"
  " moved to an encryption-enabled database and\\nvice versa. However, if the table_encryption_privilege_check variable\\n"
  "is enabled, the TABLE_ENCRYPTION_ADMIN privilege is required if the\\ntable encryption setting differs from the defaul"
  "t database encryption.\\n\\nTo rename TEMPORARY tables, RENAME TABLE does not work. Use ALTER TABLE\\ninstead.\\n\\nRENAME"
  " TABLE works for views, except that views cannot be renamed into\\na different database.\\n\\nAny privileges granted spe"
  "cifically for a renamed table or view are not\\nmigrated to the new name. They must be changed manually.\\n\\nRENAME TAB"
  "LE tbl_name TO new_tbl_name changes internally generated\\nforeign key constraint names and user-defined foreign key c"
  "onstraint\\nnames that begin with the string \"tbl_name_ibfk_\" to reflect the new\\ntable name. InnoDB interprets fore"
  "ign key constraint names that begin\\nwith the string \"tbl_name_ibfk_\" as internally generated names.\\n\\nForeign key"
  " constraint names that point to the renamed table are\\nautomatically updated unless there is a conflict, in which cas"
  "e the\\nstatement fails with an error. A conflict occurs if the renamed\\nconstraint name already exists. In such cases"
  ", you must drop and\\nre-create the foreign keys for them to function properly.\\n\\nRENAME TABLE tbl_name TO new_tbl_na"
  "me changes internally generated and\\nuser-defined CHECK constraint names that begin with the string\\n\"tbl_name_chk_\""
  " to reflect the new table name. MySQL interprets CHECK\\nconstraint names that begin with the string \"tbl_name_chk_\""
  " as\\ninternally generated names. Example:\\n\\nmysql> SHOW CREATE TABLE t1\\\\G\\n*************************** 1. row *****"
  "**********************\\n       Table: t1\\nCreate Table: CREATE TABLE `t1` (\\n  `i1` int(11) DEFAULT NULL,\\n  `i2` int"
  "(11) DEFAULT NULL,\\n  CONSTRAINT `t1_chk_1` CHECK ((`i1` > 0)),\\n  CONSTRAINT `t1_chk_2` CHECK ((`i2` < 0))\\n) ENGINE"
  "=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci\\n1 row in set (0.02 sec)\\n\\nmysql> RENAME TABLE t1 TO t3;\\"
  "nQuery OK, 0 rows affected (0.03 sec)\\n\\nmysql> SHOW CREATE TABLE t3\\\\G\\n*************************** 1. row *********"
  "******************\\n       Table: t3\\nCreate Table: CREATE TABLE `t3` (\\n  `i1` int(11) DEFAULT NULL,\\n  `i2` int(11)"
  " DEFAULT NULL,\\n  CONSTRAINT `t3_chk_1` CHECK ((`i1` > 0)),\\n  CONSTRAINT `t3_chk_2` CHECK ((`i2` < 0))\\n) ENGINE=Inn"
  "oDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci\\n1 row in set (0.01 sec)\\n\\nURL: https://dev.mysql.com/doc/ref"
  "man/8.4/en/rename-table.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/rename-table.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (539,40,'TRUNCATE TABLE','Sy"
  "ntax:\\nTRUNCATE [TABLE] tbl_name\\n\\nTRUNCATE TABLE empties a table completely. It requires the DROP\\nprivilege. Logic"
  "ally, TRUNCATE TABLE is similar to a DELETE statement\\nthat deletes all rows, or a sequence of DROP TABLE and CREATE "
  "TABLE\\nstatements.\\n\\nTo achieve high performance, TRUNCATE TABLE bypasses the DML method of\\ndeleting data. Thus, it"
  " does not cause ON DELETE triggers to fire, it\\ncannot be performed for InnoDB tables with parent-child foreign key\\n"
  "relationships, and it cannot be rolled back like a DML operation.\\nHowever, TRUNCATE TABLE operations on tables that "
  "use an atomic\\nDDL-supported storage engine are either fully committed or rolled back\\nif the server halts during the"
  "ir operation. For more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/atomic-ddl.html.\\n\\nAlthough TRUNCAT"
  "E TABLE is similar to DELETE, it is classified as a DDL\\nstatement rather than a DML statement. It differs from DELET"
  "E in the\\nfollowing ways:\\n\\no Truncate operations drop and re-create the table, which is much\\n  faster than deletin"
  "g rows one by one, particularly for large tables.\\n\\no Truncate operations cause an implicit commit, and so cannot be"
  " rolled\\n  back. See\\n  https://dev.mysql.com/doc/refman/8.4/en/implicit-commit.html.\\n\\no Truncation operations cann"
  "ot be performed if the session holds an\\n  active table lock.\\n\\no TRUNCATE TABLE fails for an InnoDB table or NDB ta"
  "ble if there are\\n  any FOREIGN KEY constraints from other tables that reference the\\n  table. Foreign key constraint"
  "s between columns of the same table are\\n  permitted.\\n\\no Truncation operations do not return a meaningful value for"
  " the number\\n  of deleted rows. The usual result is \"0 rows affected,\" which should\\n  be interpreted as \"no infor"
  "mation.\"\\n\\no As long as the table definition is valid, the table can be re-created\\n  as an empty table with TRUNCA"
  "TE TABLE, even if the data or index\\n  files have become corrupted.\\n\\no Any AUTO_INCREMENT value is reset to its sta"
  "rt value. This is true\\n  even for MyISAM and InnoDB, which normally do not reuse sequence\\n  values.\\n\\no When used "
  "with partitioned tables, TRUNCATE TABLE preserves the\\n  partitioning; that is, the data and index files are dropped "
  "and\\n  re-created, while the partition definitions are unaffected.\\n\\no The TRUNCATE TABLE statement does not invoke "
  "ON DELETE triggers.\\n\\no Truncating a corrupted InnoDB table is supported.\\n\\nTRUNCATE TABLE is treated for purposes "
  "of binary logging and\\nreplication as DDL rather than DML, and is always logged as a\\nstatement.\\n\\nURL: https://dev."
  "mysql.com/doc/refman/8.4/en/truncate-table.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/truncate-table.html'"
  ");\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (540,41,'CALL','Syntax:\\nCAL"
  "L sp_name([parameter[,...]])\\nCALL sp_name[()]\\n\\nThe CALL statement invokes a stored procedure that was defined\\npre"
  "viously with CREATE PROCEDURE.\\n\\nStored procedures that take no arguments can be invoked without\\nparentheses. That "
  "is, CALL p() and CALL p are equivalent.\\n\\nCALL can pass back values to its caller using parameters that are\\ndeclare"
  "d as OUT or INOUT parameters. When the procedure returns, a\\nclient program can also obtain the number of rows affect"
  "ed for the\\nfinal statement executed within the routine: At the SQL level, call the\\nROW_COUNT() function; from the C"
  " API, call the mysql_affected_rows()\\n(https://dev.mysql.com/doc/c-api/8.4/en/mysql-affected-rows.html)\\nfunction.\\n\\"
  "nFor information about the effect of unhandled conditions on procedure\\nparameters, see\\nhttps://dev.mysql.com/doc/re"
  "fman/8.4/en/conditions-and-parameters.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/call.html\\n\\n','','https:"
  "//dev.mysql.com/doc/refman/8.4/en/call.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (541,41,'DELETE','Syntax:\\nD"
  "ELETE is a DML statement that removes rows from a table.\\n\\nA DELETE statement can start with a WITH clause to define"
  " common table\\nexpressions accessible within the DELETE. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/with.html.\\n\\nS"
  "ingle-Table Syntax\\n\\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name [[AS] tbl_alias]\\n    [PARTITION (partitio"
  "n_name [, partition_name] ...)]\\n    [WHERE where_condition]\\n    [ORDER BY ...]\\n    [LIMIT row_count]\\n\\nThe DELETE"
  " statement deletes rows from tbl_name and returns the number\\nof deleted rows. To check the number of deleted rows, c"
  "all the\\nROW_COUNT() function described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/information-functions.html.\\n\\nMa"
  "in Clauses\\n\\nThe conditions in the optional WHERE clause identify which rows to\\ndelete. With no WHERE clause, all r"
  "ows are deleted.\\n\\nwhere_condition is an expression that evaluates to true for each row to\\nbe deleted. It is specif"
  "ied as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/select.html.\\n\\nIf the ORDER BY clause is specified, the"
  " rows are deleted in the order\\nthat is specified. The LIMIT clause places a limit on the number of\\nrows that can be"
  " deleted. These clauses apply to single-table deletes,\\nbut not multi-table deletes.\\n\\nMultiple-Table Syntax\\n\\nDELE"
  "TE [LOW_PRIORITY] [QUICK] [IGNORE]\\n    tbl_name[.*] [, tbl_name[.*]] ...\\n    FROM table_references\\n    [WHERE wher"
  "e_condition]\\n\\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\\n    USING table_r"
  "eferences\\n    [WHERE where_condition]\\n\\nPrivileges\\n\\nYou need the DELETE privilege on a table to delete rows from "
  "it. You\\nneed only the SELECT privilege for any columns that are only read, such\\nas those named in the WHERE clause."
  "\\n\\nPerformance\\n\\nWhen you do not need to know the number of deleted rows, the TRUNCATE\\nTABLE statement is a faster"
  " way to empty a table than a DELETE\\nstatement with no WHERE clause. Unlike DELETE, TRUNCATE TABLE cannot be\\nused wi"
  "thin a transaction or if you have a lock on the table. See [HELP\\nTRUNCATE TABLE] and [HELP LOCK TABLES].\\n\\nThe spee"
  "d of delete operations may also be affected by factors\\ndiscussed in\\nhttps://dev.mysql.com/doc/refman/8.4/en/delete-"
  "optimization.html.\\n\\nTo ensure that a given DELETE statement does not take too much time,\\nthe MySQL-specific LIMIT "
  "row_count clause for DELETE specifies the\\nmaximum number of rows to be deleted. If the number of rows to delete\\nis "
  "larger than the limit, repeat the DELETE statement until the number\\nof affected rows is less than the LIMIT value.\\n"
  "\\nSubqueries\\n\\nYou cannot delete from a table and select from the same table in a\\nsubquery.\\n\\nPartitioned Table Su"
  "pport\\n\\nDELETE supports explicit partition selection using the PARTITION\\nclause, which takes a list of the comma-se"
  "parated names of one or more\\npartitions or subpartitions (or both) from which to select rows to be\\ndropped. Partiti"
  "ons not included in the list are ignored. Given a\\npartitioned table t with a partition named p0, executing the state"
  "ment\\nDELETE FROM t PARTITION (p0) has the same effect on the table as\\nexecuting ALTER TABLE t TRUNCATE PARTITION (p"
  "0); in both cases, all\\nrows in partition p0 are dropped.\\n\\nPARTITION can be used along with a WHERE condition, in w"
  "hich case the\\ncondition is tested only on rows in the listed partitions. For example,\\nDELETE FROM t PARTITION (p0) "
  "WHERE c < 5 deletes rows only from\\npartition p0 for which the condition c < 5 is true; rows in any other\\npartitions"
  " are not checked and thus not affected by the DELETE.\\n\\nThe PARTITION clause can also be used in multiple-table DELE"
  "TE\\nstatements. You can use up to one such option per table named in the\\nFROM option.\\n\\nFor more information and ex"
  "amples, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/partitioning-selection.html.\\n\\nURL: https://dev.mysql.com/doc/r"
  "efman/8.4/en/delete.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/delete.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (542,41,'DO','Syntax:\\nDO ex"
  "pr [, expr] ...\\n\\nDO executes the expressions but does not return any results. In most\\nrespects, DO is shorthand fo"
  "r SELECT expr, ..., but has the advantage\\nthat it is slightly faster when you do not care about the result.\\n\\nDO is"
  " useful primarily with functions that have side effects, such as\\nRELEASE_LOCK().\\n\\nExample: This SELECT statement p"
  "auses, but also produces a result set:\\n\\nmysql> SELECT SLEEP(5);\\n+----------+\\n| SLEEP(5) |\\n+----------+\\n|       "
  " 0 |\\n+----------+\\n1 row in set (5.02 sec)\\n\\nDO, on the other hand, pauses without producing a result set.:\\n\\nmysq"
  "l> DO SLEEP(5);\\nQuery OK, 0 rows affected (4.99 sec)\\n\\nThis could be useful, for example in a stored function or tr"
  "igger,\\nwhich prohibit statements that produce result sets.\\n\\nDO only executes expressions. It cannot be used in all"
  " cases where\\nSELECT can be used. For example, DO id FROM t1 is invalid because it\\nreferences a table.\\n\\nURL: https"
  "://dev.mysql.com/doc/refman/8.4/en/do.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/do.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (543,41,'EXCEPT','Syntax:\\nq"
  "uery_expression_body EXCEPT [ALL | DISTINCT] query_expression_body\\n    [EXCEPT [ALL | DISTINCT] query_expression_bod"
  "y]\\n    [...]\\n\\nquery_expression_body:\\n    See \\n\\nEXCEPT limits the result from the first query block to those row"
  "s which\\nare (also) not found in the second. As with UNION and INTERSECT, either\\nquery block can make use of any of "
  "SELECT, TABLE, or VALUES. An example\\nusing the tables a, b, and c defined in [HELP INTERSECT], is shown\\nhere:\\n\\nmy"
  "sql> TABLE a EXCEPT TABLE b;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    2 |    3 |\\n+------+------+\\n1 "
  "row in set (0.00 sec)\\n\\nmysql> TABLE a EXCEPT TABLE c;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    1 | "
  "   2 |\\n|    2 |    3 |\\n+------+------+\\n2 rows in set (0.00 sec)\\n\\nmysql> TABLE b EXCEPT TABLE c;\\n+------+------+"
  "\\n| m    | n    |\\n+------+------+\\n|    1 |    2 |\\n+------+------+\\n1 row in set (0.00 sec)\\n\\nAs with UNION and IN"
  "TERSECT, if neither DISTINCT nor ALL is specified,\\nthe default is DISTINCT.\\n\\nDISTINCT removes duplicates found on "
  "either side of the relation, as\\nshown here:\\n\\nmysql> TABLE c EXCEPT DISTINCT TABLE a;\\n+------+------+\\n| m    | n "
  "   |\\n+------+------+\\n|    1 |    3 |\\n+------+------+\\n1 row in set (0.00 sec)\\n\\nmysql> TABLE c EXCEPT ALL TABLE a"
  ";\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    1 |    3 |\\n|    1 |    3 |\\n+------+------+\\n2 rows in se"
  "t (0.00 sec)\\n\\n(The first statement has the same effect as TABLE c EXCEPT TABLE a.)\\n\\nUnlike UNION or INTERSECT, EX"
  "CEPT is not commutative---that is, the\\nresult depends on the order of the operands, as shown here:\\n\\nmysql> TABLE a"
  " EXCEPT TABLE c;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    1 |    2 |\\n|    2 |    3 |\\n+------+------"
  "+\\n2 rows in set (0.00 sec)\\n\\nmysql> TABLE c EXCEPT TABLE a;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|  "
  "  1 |    3 |\\n+------+------+\\n1 row in set (0.00 sec)\\n\\nAs with UNION, the result sets to be compared must have the"
  " same number\\nof columns. Result set column types are also determined as for UNION.\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/except.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/except.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (544,41,'HANDLER','Syntax:\\n"
  "HANDLER tbl_name OPEN [ [AS] alias]\\n\\nHANDLER tbl_name READ index_name { = | <= | >= | < | > } (value1,value2,...)\\n"
  "    [ WHERE where_condition ] [LIMIT ... ]\\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\\n    [ WH"
  "ERE where_condition ] [LIMIT ... ]\\nHANDLER tbl_name READ { FIRST | NEXT }\\n    [ WHERE where_condition ] [LIMIT ... "
  "]\\n\\nHANDLER tbl_name CLOSE\\n\\nThe HANDLER statement provides direct access to table storage engine\\ninterfaces. It i"
  "s available for InnoDB and MyISAM tables.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/handler.html\\n\\n','','https"
  "://dev.mysql.com/doc/refman/8.4/en/handler.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (545,41,'IMPORT TABLE','Synt"
  "ax:\\nIMPORT TABLE FROM sdi_file [, sdi_file] ...\\n\\nThe IMPORT TABLE statement imports MyISAM tables based on informa"
  "tion\\ncontained in .sdi (serialized dictionary information) metadata files.\\nIMPORT TABLE requires the FILE privilege"
  " to read the .sdi and table\\ncontent files, and the CREATE privilege for the table to be created.\\n\\nTables can be ex"
  "ported from one server using mysqldump to write a file\\nof SQL statements and imported into another server using mysq"
  "l to\\nprocess the dump file. IMPORT TABLE provides a faster alternative using\\nthe \"raw\" table files.\\n\\nPrior to i"
  "mport, the files that provide the table content must be\\nplaced in the appropriate schema directory for the import se"
  "rver, and\\nthe .sdi file must be located in a directory accessible to the server.\\nFor example, the .sdi file can be "
  "placed in the directory named by the\\nsecure_file_priv system variable, or (if secure_file_priv is empty) in\\na direc"
  "tory under the server data directory.\\n\\nThe following example describes how to export MyISAM tables named\\nemployees"
  " and managers from the hr schema of one server and import them\\ninto the hr schema of another server. The example use"
  "s these\\nassumptions (to perform a similar operation on your own system, modify\\nthe path names as appropriate):\\n\\no"
  " For the export server, export_basedir represents its base directory,\\n  and its data directory is export_basedir/dat"
  "a.\\n\\no For the import server, import_basedir represents its base directory,\\n  and its data directory is import_base"
  "dir/data.\\n\\no Table files are exported from the export server into the /tmp/export\\n  directory and this directory i"
  "s secure (not accessible to other\\n  users).\\n\\no The import server uses /tmp/mysql-files as the directory named by i"
  "ts\\n  secure_file_priv system variable.\\n\\nTo export tables from the export server, use this procedure:\\n\\n1. Ensure "
  "a consistent snapshot by executing this statement to lock the\\n   tables so that they cannot be modified during expor"
  "t:\\n\\nmysql> FLUSH TABLES hr.employees, hr.managers WITH READ LOCK;\\n\\n   While the lock is in effect, the tables can"
  " still be used, but only\\n   for read access.\\n\\n2. At the file system level, copy the .sdi and table content files f"
  "rom\\n   the hr schema directory to the secure export directory:\\n\\n  o The .sdi file is located in the hr schema dire"
  "ctory, but might not\\n    have exactly the same basename as the table name. For example, the\\n    .sdi files for the "
  "employees and managers tables might be named\\n    employees_125.sdi and managers_238.sdi.\\n\\n  o For a MyISAM table, "
  "the content files are its .MYD data file and\\n    .MYI index file.\\n\\n   Given those file names, the copy commands lo"
  "ok like this:\\n\\n$> cd export_basedir/data/hr\\n$> cp employees_125.sdi /tmp/export\\n$> cp managers_238.sdi /tmp/expor"
  "t\\n$> cp employees.{MYD,MYI} /tmp/export\\n$> cp managers.{MYD,MYI} /tmp/export\\n\\n3. Unlock the tables:\\n\\nmysql> UNL"
  "OCK TABLES;\\n\\nTo import tables into the import server, use this procedure:\\n\\n1. The import schema must exist. If ne"
  "cessary, execute this statement\\n   to create it:\\n\\nmysql> CREATE SCHEMA hr;\\n\\n2. At the file system level, copy th"
  "e .sdi files to the import server\\n   secure_file_priv directory, /tmp/mysql-files. Also, copy the table\\n   content "
  "files to the hr schema directory:\\n\\n$> cd /tmp/export\\n$> cp employees_125.sdi /tmp/mysql-files\\n$> cp managers_238."
  "sdi /tmp/mysql-files\\n$> cp employees.{MYD,MYI} import_basedir/data/hr\\n$> cp managers.{MYD,MYI} import_basedir/data/"
  "hr\\n\\n3. Import the tables by executing an IMPORT TABLE statement that names\\n   the .sdi files:\\n\\nmysql> IMPORT TAB"
  "LE FROM\\n       \\'/tmp/mysql-files/employees.sdi\\',\\n       \\'/tmp/mysql-files/managers.sdi\\';\\n\\nThe .sdi file need "
  "not be placed in the import server directory named\\nby the secure_file_priv system variable if that variable is empty"
  "; it\\ncan be in any directory accessible to the server, including the schema\\ndirectory for the imported table. If th"
  "e .sdi file is placed in that\\ndirectory, however, it may be rewritten; the import operation creates a\\nnew .sdi file"
  " for the table, which overwrites the old .sdi file if the\\noperation uses the same file name for the new file.\\n\\nEac"
  "h sdi_file value must be a string literal that names the .sdi file\\nfor a table or is a pattern that matches .sdi fil"
  "es. If the string is a\\npattern, any leading directory path and the .sdi file name suffix must\\nbe given literally. P"
  "attern characters are permitted only in the base\\nname part of the file name:\\n\\no ? matches any single character\\n\\n"
  "o * matches any sequence of characters, including no characters\\n\\nUsing a pattern, the previous IMPORT TABLE stateme"
  "nt could have been\\nwritten like this (assuming that the /tmp/mysql-files directory\\ncontains no other .sdi files mat"
  "ching the pattern):\\n\\nIMPORT TABLE FROM \\'/tmp/mysql-files/*.sdi\\';\\n\\nTo interpret the location of .sdi file path n"
  "ames, the server uses the\\nsame rules for IMPORT TABLE as the server-side rules for LOAD DATA\\n(that is, the non-LOCA"
  "L rules). See [HELP LOAD DATA], paying particular\\nattention to the rules used to interpret relative path names.\\n\\nI"
  "MPORT TABLE fails if the .sdi or table files cannot be located. After\\nimporting a table, the server attempts to open"
  " it and reports as\\nwarnings any problems detected. To attempt a repair to correct any\\nreported issues, use REPAIR T"
  "ABLE.\\n\\nIMPORT TABLE is not written to the binary log.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/import-table."
  "html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/import-table.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (546,41,'INSERT','Syntax:\\nI"
  "NSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\\n    [INTO] tbl_name\\n    [PARTITION (partition_name [, parti"
  "tion_name] ...)]\\n    [(col_name [, col_name] ...)]\\n    { {VALUES | VALUE} (value_list) [, (value_list)] ... }\\n    "
  "[AS row_alias[(col_alias [, col_alias] ...)]]\\n    [ON DUPLICATE KEY UPDATE assignment_list]\\n\\nINSERT [LOW_PRIORITY "
  "| DELAYED | HIGH_PRIORITY] [IGNORE]\\n    [INTO] tbl_name\\n    [PARTITION (partition_name [, partition_name] ...)]\\n  "
  "  SET assignment_list\\n    [AS row_alias[(col_alias [, col_alias] ...)]]\\n    [ON DUPLICATE KEY UPDATE assignment_lis"
  "t]\\n\\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\\n    [INTO] tbl_name\\n    [PARTITION (partition_name [, partitio"
  "n_name] ...)]\\n    [(col_name [, col_name] ...)]\\n    { SELECT ... \\n      | TABLE table_name \\n      | VALUES row_co"
  "nstructor_list\\n    }\\n    [ON DUPLICATE KEY UPDATE assignment_list]\\n\\nvalue:\\n    {expr | DEFAULT}\\n\\nvalue_list:\\n"
  "    value [, value] ...\\n\\nrow_constructor_list:\\n    ROW(value_list)[, ROW(value_list)][, ...]\\n\\nassignment:\\n    c"
  "ol_name = \\n          value\\n        | [row_alias.]col_name\\n        | [tbl_name.]col_name\\n        | [row_alias.]col"
  "_alias\\n\\nassignment_list:\\n    assignment [, assignment] ...\\n\\nINSERT inserts new rows into an existing table. The "
  "INSERT ... VALUES,\\nINSERT ... VALUES ROW(), and INSERT ... SET forms of the statement\\ninsert rows based on explicit"
  "ly specified values. The INSERT ... SELECT\\nform inserts rows selected from another table or tables. You can also\\nus"
  "e INSERT ... TABLE to insert rows from a single table. INSERT with an\\nON DUPLICATE KEY UPDATE clause enables existin"
  "g rows to be updated if a\\nrow to be inserted would cause a duplicate value in a UNIQUE index or\\nPRIMARY KEY. A row "
  "alias with one or more optional column aliases can\\nbe used with ON DUPLICATE KEY UPDATE to refer to the row to be\\ni"
  "nserted.\\n\\nFor additional information about INSERT ... SELECT and INSERT ... ON\\nDUPLICATE KEY UPDATE, see [HELP INS"
  "ERT SELECT], and\\nhttps://dev.mysql.com/doc/refman/8.4/en/insert-on-duplicate.html.\\n\\nIn MySQL 8.4, the DELAYED keyw"
  "ord is accepted but ignored by the\\nserver. For the reasons for this, see [HELP INSERT DELAYED],\\n\\nInserting into a "
  "table requires the INSERT privilege for the table. If\\nthe ON DUPLICATE KEY UPDATE clause is used and a duplicate key"
  " causes\\nan UPDATE to be performed instead, the statement requires the UPDATE\\nprivilege for the columns to be update"
  "d. For columns that are read but\\nnot modified you need only the SELECT privilege (such as for a column\\nreferenced o"
  "nly on the right hand side of an col_name=expr assignment\\nin an ON DUPLICATE KEY UPDATE clause).\\n\\nWhen inserting i"
  "nto a partitioned table, you can control which\\npartitions and subpartitions accept new rows. The PARTITION clause\\nt"
  "akes a list of the comma-separated names of one or more partitions or\\nsubpartitions (or both) of the table. If any o"
  "f the rows to be inserted\\nby a given INSERT statement do not match one of the partitions listed,\\nthe INSERT stateme"
  "nt fails with the error Found a row not matching the\\ngiven partition set. For more information and examples, see\\nht"
  "tps://dev.mysql.com/doc/refman/8.4/en/partitioning-selection.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/in"
  "sert.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/insert.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (547,41,'INSERT SELECT','Syn"
  "tax:\\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\\n    [INTO] tbl_name\\n    [PARTITION (partition_name [, partitio"
  "n_name] ...)]\\n    [(col_name [, col_name] ...)]\\n    {   SELECT ... \\n      | TABLE table_name \\n      | VALUES row_"
  "constructor_list\\n    }\\n    [ON DUPLICATE KEY UPDATE assignment_list]\\n\\n\\nvalue:\\n    {expr | DEFAULT}\\n\\nvalue_lis"
  "t:\\n    value [, value] ...\\n\\nrow_constructor_list:\\n    ROW(value_list)[, ROW(value_list)][, ...]\\n\\nassignment:\\n "
  "   col_name = \\n          value\\n        | [row_alias.]col_name\\n        | [tbl_name.]col_name\\n        | [row_alias."
  "]col_alias\\n\\nassignment_list:\\n    assignment [, assignment] ...\\n\\nWith INSERT ... SELECT, you can quickly insert m"
  "any rows into a table\\nfrom the result of a SELECT statement, which can select from one or\\nmany tables. For example:"
  "\\n\\nINSERT INTO tbl_temp2 (fld_id)\\n  SELECT tbl_temp1.fld_order_id\\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > "
  "100;\\n\\nTABLE statement in place of SELECT, as shown here:\\n\\nINSERT INTO ta TABLE tb;\\n\\nTABLE tb is equivalent to S"
  "ELECT * FROM tb. It can be useful when\\ninserting all columns from the source table into the target table, and\\nno fi"
  "ltering with WHERE is required. In addition, the rows from TABLE\\ncan be ordered by one or more columns using ORDER B"
  "Y, and the number of\\nrows inserted can be limited using a LIMIT clause. For more\\ninformation, see [HELP TABLE].\\n\\n"
  "URL: https://dev.mysql.com/doc/refman/8.4/en/insert-select.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/inse"
  "rt-select.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (548,41,'INSERT DELAYED','Sy"
  "ntax:\\nINSERT DELAYED ...\\n\\nThe DELAYED option for the INSERT statement is a MySQL extension to\\nstandard SQL. In pr"
  "evious versions of MySQL, it can be used for certain\\nkinds of tables (such as MyISAM), such that when a client uses "
  "INSERT\\nDELAYED, it gets an okay from the server at once, and the row is queued\\nto be inserted when the table is not"
  " in use by any other thread.\\n\\nDELAYED inserts and replaces were deprecated in MySQL 5.6. In MySQL\\n8.4, DELAYED is "
  "not supported. The server recognizes but ignores the\\nDELAYED keyword, handles the insert as a nondelayed insert, and"
  "\\ngenerates an ER_WARN_LEGACY_SYNTAX_CONVERTED warning: INSERT DELAYED is\\nno longer supported. The statement was con"
  "verted to INSERT. The DELAYED\\nkeyword is scheduled for removal in a future release.\\n\\nURL: https://dev.mysql.com/do"
  "c/refman/8.4/en/insert-delayed.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/insert-delayed.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (549,41,'INTERSECT','Syntax:"
  "\\nquery_expression_body INTERSECT [ALL | DISTINCT] query_expression_body\\n    [INTERSECT [ALL | DISTINCT] query_expre"
  "ssion_body]\\n    [...]\\n\\nquery_expression_body:\\n    See \\n\\nINTERSECT limits the result from multiple query blocks "
  "to those rows\\nwhich are common to all. Example:\\n\\nmysql> TABLE a;\\n+------+------+\\n| m    | n    |\\n+------+------"
  "+\\n|    1 |    2 |\\n|    2 |    3 |\\n|    3 |    4 |\\n+------+------+\\n3 rows in set (0.00 sec)\\n\\nmysql> TABLE b;\\n+"
  "------+------+\\n| m    | n    |\\n+------+------+\\n|    1 |    2 |\\n|    1 |    3 |\\n|    3 |    4 |\\n+------+------+\\"
  "n3 rows in set (0.00 sec)\\n\\nmysql> TABLE c;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    1 |    3 |\\n|  "
  "  1 |    3 |\\n|    3 |    4 |\\n+------+------+\\n3 rows in set (0.00 sec)\\n\\nmysql> TABLE a INTERSECT TABLE b;\\n+-----"
  "-+------+\\n| m    | n    |\\n+------+------+\\n|    1 |    2 |\\n|    3 |    4 |\\n+------+------+\\n2 rows in set (0.00 s"
  "ec)\\n\\nmysql> TABLE a INTERSECT TABLE c;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    3 |    4 |\\n+------"
  "+------+\\n1 row in set (0.00 sec)\\n\\nAs with UNION and EXCEPT, if neither DISTINCT nor ALL is specified, the\\ndefault"
  " is DISTINCT.\\n\\nDISTINCT can remove duplicates from either side of the intersection, as\\nshown here:\\n\\nmysql> TABLE"
  " c INTERSECT DISTINCT TABLE c;\\n+------+------+\\n| m    | n    |\\n+------+------+\\n|    1 |    3 |\\n|    3 |    4 |\\n"
  "+------+------+\\n2 rows in set (0.00 sec)\\n\\nmysql> TABLE c INTERSECT ALL TABLE c;\\n+------+------+\\n| m    | n    |\\"
  "n+------+------+\\n|    1 |    3 |\\n|    1 |    3 |\\n|    3 |    4 |\\n+------+------+\\n3 rows in set (0.00 sec)\\n\\n(TA"
  "BLE c INTERSECT TABLE c is the equivalent of the first of the two\\nstatements just shown.)\\n\\nAs with UNION, the oper"
  "ands must have the same number of columns.\\nResult set column types are also determined as for UNION.\\n\\nINTERSECT ha"
  "s greater precedence than and is evaluated before UNION and\\nEXCEPT, so that the two statements shown here are equiva"
  "lent:\\n\\nTABLE r EXCEPT TABLE s INTERSECT TABLE t;\\n\\nTABLE r EXCEPT (TABLE s INTERSECT TABLE t);\\n\\nFor INTERSECT AL"
  "L, the maximum supported number of duplicates of any\\nunique row in the left hand table is 4294967295.\\n\\nURL: https:"
  "//dev.mysql.com/doc/refman/8.4/en/intersect.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/intersect.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (550,41,'LOAD DATA','Syntax:"
  "\\nLOAD DATA\\n    [LOW_PRIORITY | CONCURRENT] [LOCAL]\\n    INFILE \\'file_name\\'\\n    [REPLACE | IGNORE]\\n    INTO TABL"
  "E tbl_name\\n    [PARTITION (partition_name [, partition_name] ...)]\\n    [CHARACTER SET charset_name]\\n    [{FIELDS |"
  " COLUMNS}\\n        [TERMINATED BY \\'string\\']\\n        [[OPTIONALLY] ENCLOSED BY \\'char\\']\\n        [ESCAPED BY \\'cha"
  "r\\']\\n    ]\\n    [LINES\\n        [STARTING BY \\'string\\']\\n        [TERMINATED BY \\'string\\']\\n    ]\\n    [IGNORE num"
  "ber {LINES | ROWS}]\\n    [(col_name_or_user_var\\n        [, col_name_or_user_var] ...)]\\n    [SET col_name={expr | DE"
  "FAULT}\\n        [, col_name={expr | DEFAULT}] ...]\\n\\nThe LOAD DATA statement reads rows from a text file into a tabl"
  "e at a\\nvery high speed. The file can be read from the server host or the\\nclient host, depending on whether the LOCA"
  "L modifier is given. LOCAL\\nalso affects data interpretation and error handling.\\n\\nLOAD DATA is the complement of SE"
  "LECT ... INTO OUTFILE. (See\\nhttps://dev.mysql.com/doc/refman/8.4/en/select-into.html.) To write\\ndata from a table t"
  "o a file, use SELECT ... INTO OUTFILE. To read the\\nfile back into a table, use LOAD DATA. The syntax of the FIELDS a"
  "nd\\nLINES clauses is the same for both statements.\\n\\nThe mysqlimport utility provides another way to load data files"
  "; it\\noperates by sending a LOAD DATA statement to the server. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/mysqlimpo"
  "rt.html.\\n\\nFor information about the efficiency of INSERT versus LOAD DATA and\\nspeeding up LOAD DATA, see\\nhttps://"
  "dev.mysql.com/doc/refman/8.4/en/insert-optimization.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/load-data.h"
  "tml\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/load-data.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (551,41,'LOAD XML','Syntax:\\"
  "nLOAD XML\\n    [LOW_PRIORITY | CONCURRENT] [LOCAL]\\n    INFILE \\'file_name\\'\\n    [REPLACE | IGNORE]\\n    INTO TABLE "
  "[db_name.]tbl_name\\n    [CHARACTER SET charset_name]\\n    [ROWS IDENTIFIED BY \\'<tagname>\\']\\n    [IGNORE number {LIN"
  "ES | ROWS}]\\n    [(field_name_or_user_var\\n        [, field_name_or_user_var] ...)]\\n    [SET col_name={expr | DEFAUL"
  "T}\\n        [, col_name={expr | DEFAULT}] ...]\\n\\nThe LOAD XML statement reads data from an XML file into a table. Th"
  "e\\nfile_name must be given as a literal string. The tagname in the\\noptional ROWS IDENTIFIED BY clause must also be g"
  "iven as a literal\\nstring, and must be surrounded by angle brackets (< and >).\\n\\nLOAD XML acts as the complement of "
  "running the mysql client in XML\\noutput mode (that is, starting the client with the --xml option). To\\nwrite data fro"
  "m a table to an XML file, you can invoke the mysql client\\nwith the --xml and -e options from the system shell, as sh"
  "own here:\\n\\n$> mysql --xml -e \\'SELECT * FROM mydb.mytable\\' > file.xml\\n\\nTo read the file back into a table, use L"
  "OAD XML. By default, the <row>\\nelement is considered to be the equivalent of a database table row;\\nthis can be chan"
  "ged using the ROWS IDENTIFIED BY clause.\\n\\nThis statement supports three different XML formats:\\n\\no Column names as"
  " attributes and column values as attribute values:\\n\\n<row column1=\"value1\" column2=\"value2\" .../>\\n\\no Column na"
  "mes as tags and column values as the content of these tags:\\n\\n<row>\\n  <column1>value1</column1>\\n  <column2>value2<"
  "/column2>\\n</row>\\n\\no Column names are the name attributes of <field> tags, and values are\\n  the contents of these "
  "tags:\\n\\n<row>\\n  <field name=\\'column1\\'>value1</field>\\n  <field name=\\'column2\\'>value2</field>\\n</row>\\n\\n  This "
  "is the format used by other MySQL tools, such as mysqldump.\\n\\nAll three formats can be used in the same XML file; th"
  "e import routine\\nautomatically detects the format for each row and interprets it\\ncorrectly. Tags are matched based "
  "on the tag or attribute name and the\\ncolumn name.\\n\\nThe following clauses work essentially the same way for LOAD XM"
  "L as\\nthey do for LOAD DATA:\\n\\no LOW_PRIORITY or CONCURRENT\\n\\no LOCAL\\n\\no REPLACE or IGNORE\\n\\no CHARACTER SET\\n\\n"
  "o SET\\n\\nSee [HELP LOAD DATA], for more information about these clauses.\\n\\n(field_name_or_user_var, ...) is a list o"
  "f one or more comma-separated\\nXML fields or user variables. The name of a user variable used for this\\npurpose must "
  "match the name of a field from the XML file, prefixed with\\n@. You can use field names to select only desired fields."
  " User\\nvariables can be employed to store the corresponding field values for\\nsubsequent re-use.\\n\\nThe IGNORE number"
  " LINES or IGNORE number ROWS clause causes the first\\nnumber rows in the XML file to be skipped. It is analogous to t"
  "he LOAD\\nDATA statement\\'s IGNORE ... LINES clause.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/load-xml.html\\n\\n"
  "','','https://dev.mysql.com/doc/refman/8.4/en/load-xml.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (552,41,'PARENTHESIZED QUERY"
  " EXPRESSIONS','Syntax:\\nparenthesized_query_expression:\\n    ( query_expression [order_by_clause] [limit_clause] )\\n "
  "     [order_by_clause]\\n      [limit_clause]\\n      [into_clause]\\n\\nquery_expression:\\n    query_block [set_op query"
  "_block [set_op query_block ...]]\\n      [order_by_clause]\\n      [limit_clause]\\n      [into_clause]\\n\\nquery_block:\\"
  "n    SELECT ... | TABLE | VALUES\\n\\norder_by_clause:\\n    ORDER BY as for SELECT\\n\\nlimit_clause:\\n    LIMIT as for S"
  "ELECT\\n\\ninto_clause:\\n    INTO as for SELECT\\n\\nset_op:\\n    UNION | INTERSECT | EXCEPT\\n\\nMySQL 8.4 supports parent"
  "hesized query expressions according to the\\npreceding syntax. At its simplest, a parenthesized query expression\\ncont"
  "ains a single SELECT or other statement returning a result set and\\nno following optional clauses:\\n\\n(SELECT 1);\\n(S"
  "ELECT * FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = \\'mysql\\');\\n\\nTABLE t;\\n\\nVALUES ROW(2, 3, 4), ROW(1, -"
  "2, 3);\\n\\nA parenthesized query expression can also contain queries linked by one\\nor more set operations such as UNI"
  "ON, and end with any or all of the\\noptional clauses:\\n\\nmysql> (SELECT 1 AS result UNION SELECT 2);\\n+--------+\\n| r"
  "esult |\\n+--------+\\n|      1 |\\n|      2 |\\n+--------+\\nmysql> (SELECT 1 AS result UNION SELECT 2) LIMIT 1;\\n+------"
  "--+\\n| result |\\n+--------+\\n|      1 |\\n+--------+\\nmysql> (SELECT 1 AS result UNION SELECT 2) LIMIT 1 OFFSET 1;\\n+-"
  "-------+\\n| result |\\n+--------+\\n|      2 |\\n+--------+\\nmysql> (SELECT 1 AS result UNION SELECT 2)\\n       ORDER BY"
  " result DESC LIMIT 1;\\n+--------+\\n| result |\\n+--------+\\n|      2 |\\n+--------+\\nmysql> (SELECT 1 AS result UNION S"
  "ELECT 2)\\n       ORDER BY result DESC LIMIT 1 OFFSET 1;\\n+--------+\\n| result |\\n+--------+\\n|      1 |\\n+--------+\\n"
  "mysql> (SELECT 1 AS result UNION SELECT 3 UNION SELECT 2)\\n       ORDER BY result LIMIT 1 OFFSET 1 INTO @var;\\nmysql>"
  " SELECT @var;\\n+------+\\n| @var |\\n+------+\\n|    2 |\\n+------+\\n\\nINTERSECT acts before UNION and EXCEPT, so that th"
  "e following two\\nstatements are equivalent:\\n\\nSELECT a FROM t1 EXCEPT SELECT b FROM t2 INTERSECT SELECT c FROM t3;\\n"
  "\\nSELECT a FROM t1 EXCEPT (SELECT b FROM t2 INTERSECT SELECT c FROM t3);\\n\\nParenthesized query expressions are also "
  "used as query expressions, so\\na query expression, usually composed of query blocks, may also consist\\nof parenthesiz"
  "ed query expressions:\\n\\n(TABLE t1 ORDER BY a) UNION (TABLE t2 ORDER BY b) ORDER BY z;\\n\\nQuery blocks may have trail"
  "ing ORDER BY and LIMIT clauses, which are\\napplied before the outer set operation, ORDER BY, and LIMIT.\\n\\nYou cannot"
  " have a query block with a trailing ORDER BY or LIMIT without\\nwrapping it in parentheses but parentheses may be used"
  " for enforcement\\nin various ways:\\n\\no To enforce LIMIT on each query block:\\n\\n(SELECT 1 LIMIT 1) UNION (VALUES ROW"
  "(2) LIMIT 1);\\n\\n(VALUES ROW(1), ROW(2) LIMIT 2) EXCEPT (SELECT 2 LIMIT 1);\\n\\no To enforce LIMIT on both query block"
  "s and the entire query\\n  expression:\\n\\n(SELECT 1 LIMIT 1) UNION (SELECT 2 LIMIT 1) LIMIT 1;\\n\\no To enforce LIMIT o"
  "n the entire query expression (with no\\n  parentheses):\\n\\nVALUES ROW(1), ROW(2) INTERSECT VALUES ROW(2), ROW(1) LIMI"
  "T 1;\\n\\no Hybrid enforcement: LIMIT on the first query block and on the entire\\n  query expression:\\n\\n(SELECT 1 LIMI"
  "T 1) UNION SELECT 2 LIMIT 1;\\n\\nThe syntax described in this section is subject to certain\\nrestrictions:\\n\\no A trai"
  "ling INTO clause for a query expression is not permitted if\\n  there is another INTO clause inside parentheses.\\n\\no "
  "An ORDER BY or LIMIT within a parenthesized query expression which is\\n  also applied in the outer query is handled i"
  "n accordance with the SQL\\n  standard.\\n\\n  Nested parenthesized query expressions are permitted. The maximum\\n  leve"
  "l of nesting supported is 63; this is after any simplifications\\n  or merges have been performed by the parser.\\n\\n  "
  "An example of such a statement is shown here:\\n\\nmysql> (SELECT \\'a\\' UNION SELECT \\'b\\' LIMIT 2) LIMIT 3;\\n+---+\\n| "
  "a |\\n+---+\\n| a |\\n| b |\\n+---+\\n2 rows in set (0.00 sec)\\n\\n  You should be aware that, when collapsing parenthesize"
  "d expression\\n  bodies, MySQL follows SQL standard semantics, so that a higher outer\\n  limit cannot override an inne"
  "r lower one. For example, (SELECT ...\\n  LIMIT 5) LIMIT 10 can return no more than five rows.\\n\\nURL: https://dev.mys"
  "ql.com/doc/refman/8.4/en/parenthesized-query-expressions.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/parent"
  "hesized-query-expressions.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (553,41,'REPLACE','Syntax:\\n"
  "REPLACE [LOW_PRIORITY | DELAYED]\\n    [INTO] tbl_name\\n    [PARTITION (partition_name [, partition_name] ...)]\\n    ["
  "(col_name [, col_name] ...)]\\n    { {VALUES | VALUE} (value_list) [, (value_list)] ...\\n      |\\n      VALUES row_con"
  "structor_list\\n    }\\n\\nREPLACE [LOW_PRIORITY | DELAYED]\\n    [INTO] tbl_name\\n    [PARTITION (partition_name [, part"
  "ition_name] ...)]\\n    SET assignment_list\\n\\nREPLACE [LOW_PRIORITY | DELAYED]\\n    [INTO] tbl_name\\n    [PARTITION ("
  "partition_name [, partition_name] ...)]\\n    [(col_name [, col_name] ...)]\\n    {SELECT ... | TABLE table_name}\\n\\nva"
  "lue:\\n    {expr | DEFAULT}\\n\\nvalue_list:\\n    value [, value] ...\\n\\nrow_constructor_list:\\n    ROW(value_list)[, RO"
  "W(value_list)][, ...]\\n\\nassignment:\\n    col_name = value\\n\\nassignment_list:\\n    assignment [, assignment] ...\\n\\n"
  "REPLACE works exactly like INSERT, except that if an old row in the\\ntable has the same value as a new row for a PRIM"
  "ARY KEY or a UNIQUE\\nindex, the old row is deleted before the new row is inserted. See [HELP\\nINSERT].\\n\\nREPLACE is "
  "a MySQL extension to the SQL standard. It either inserts, or\\ndeletes and inserts. For another MySQL extension to sta"
  "ndard SQL---that\\neither inserts or updates---see\\nhttps://dev.mysql.com/doc/refman/8.4/en/insert-on-duplicate.html.\\"
  "n\\nDELAYED inserts and replaces were deprecated in MySQL 5.6. In MySQL\\n8.4, DELAYED is not supported. The server rec"
  "ognizes but ignores the\\nDELAYED keyword, handles the replace as a nondelayed replace, and\\ngenerates an ER_WARN_LEGA"
  "CY_SYNTAX_CONVERTED warning: REPLACE DELAYED\\nis no longer supported. The statement was converted to REPLACE. The\\nDE"
  "LAYED keyword is scheduled for removal in a future release. release.\\n\\n*Note*:\\n\\nREPLACE makes sense only if a tabl"
  "e has a PRIMARY KEY or UNIQUE index.\\nOtherwise, it becomes equivalent to INSERT, because there is no index\\nto be us"
  "ed to determine whether a new row duplicates another.\\n\\nValues for all columns are taken from the values specified i"
  "n the\\nREPLACE statement. Any missing columns are set to their default values,\\njust as happens for INSERT. You canno"
  "t refer to values from the current\\nrow and use them in the new row. If you use an assignment such as SET\\ncol_name ="
  " col_name + 1, the reference to the column name on the right\\nhand side is treated as DEFAULT(col_name), so the assig"
  "nment is\\nequivalent to SET col_name = DEFAULT(col_name) + 1.\\n\\nYou can specify the column values that REPLACE attem"
  "pts to insert using\\nVALUES ROW().\\n\\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\\nthe ta"
  "ble.\\n\\nIf a generated column is replaced explicitly, the only permitted value\\nis DEFAULT. For information about gen"
  "erated columns, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/create-table-generated-columns.\\nhtml.\\n\\nREPLACE suppor"
  "ts explicit partition selection using the PARTITION\\nclause with a list of comma-separated names of partitions,\\nsubp"
  "artitions, or both. As with INSERT, if it is not possible to insert\\nthe new row into any of these partitions or subp"
  "artitions, the REPLACE\\nstatement fails with the error Found a row not matching the given\\npartition set. For more in"
  "formation and examples, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/partitioning-selection.html.\\n\\nURL: https://dev"
  ".mysql.com/doc/refman/8.4/en/replace.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/replace.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (554,41,'SELECT','Syntax:\\nS"
  "ELECT\\n    [ALL | DISTINCT | DISTINCTROW ]\\n    [HIGH_PRIORITY]\\n    [STRAIGHT_JOIN]\\n    [SQL_SMALL_RESULT] [SQL_BIG"
  "_RESULT] [SQL_BUFFER_RESULT]\\n    [SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\\n    select_expr [, select_expr] ...\\n    [int"
  "o_option]\\n    [FROM table_references\\n      [PARTITION partition_list]]\\n    [WHERE where_condition]\\n    [GROUP BY "
  "{col_name | expr | position}, ... [WITH ROLLUP]]\\n    [HAVING where_condition]\\n    [WINDOW window_name AS (window_sp"
  "ec)\\n        [, window_name AS (window_spec)] ...]\\n    [ORDER BY {col_name | expr | position}\\n      [ASC | DESC], ."
  ".. [WITH ROLLUP]]\\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\\n    [into_option]\\n    [FOR {UPDATE |"
  " SHARE}\\n        [OF tbl_name [, tbl_name] ...]\\n        [NOWAIT | SKIP LOCKED]\\n      | LOCK IN SHARE MODE]\\n    [in"
  "to_option]\\n\\ninto_option: {\\n    INTO OUTFILE \\'file_name\\'\\n        [CHARACTER SET charset_name]\\n        export_op"
  "tions\\n  | INTO DUMPFILE \\'file_name\\'\\n  | INTO var_name [, var_name] ...\\n}\\n\\nSELECT is used to retrieve rows sele"
  "cted from one or more tables, and\\ncan include UNION operations and subqueries. INTERSECT and EXCEPT\\noperations are "
  "also supported. The UNION, INTERSECT, and EXCEPT\\noperators are described in more detail later in this section. See a"
  "lso\\nhttps://dev.mysql.com/doc/refman/8.4/en/subqueries.html.\\n\\nA SELECT statement can start with a WITH clause to d"
  "efine common table\\nexpressions accessible within the SELECT. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/with.html."
  "\\n\\nThe most commonly used clauses of SELECT statements are these:\\n\\no Each select_expr indicates a column that you "
  "want to retrieve. There\\n  must be at least one select_expr.\\n\\no table_references indicates the table or tables from"
  " which to retrieve\\n  rows. Its syntax is described in [HELP JOIN].\\n\\no SELECT supports explicit partition selection"
  " using the PARTITION\\n  clause with a list of partitions or subpartitions (or both) following\\n  the name of the tabl"
  "e in a table_reference (see [HELP JOIN]). In this\\n  case, rows are selected only from the partitions listed, and any"
  "\\n  other partitions of the table are ignored. For more information and\\n  examples, see\\n  https://dev.mysql.com/doc"
  "/refman/8.4/en/partitioning-selection.html.\\n\\no The WHERE clause, if given, indicates the condition or conditions\\n "
  " that rows must satisfy to be selected. where_condition is an\\n  expression that evaluates to true for each row to be"
  " selected. The\\n  statement selects all rows if there is no WHERE clause.\\n\\n  In the WHERE expression, you can use a"
  "ny of the functions and\\n  operators that MySQL supports, except for aggregate (group)\\n  functions. See\\n  https://d"
  "ev.mysql.com/doc/refman/8.4/en/expressions.html, and\\n  https://dev.mysql.com/doc/refman/8.4/en/functions.html.\\n\\nSE"
  "LECT can also be used to retrieve rows computed without reference to\\nany table.\\n\\nURL: https://dev.mysql.com/doc/re"
  "fman/8.4/en/select.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/select.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (555,41,'DUAL','You are perm"
  "itted to specify DUAL as a dummy table name in situations\\nwhere no tables are referenced:\\n\\nmysql> SELECT 1 + 1 FRO"
  "M DUAL;\\n        -> 2\\n\\nDUAL is purely for the convenience of people who require that all\\nSELECT statements should "
  "have FROM and possibly other clauses. MySQL\\nmay ignore the clauses. MySQL does not require FROM DUAL if no tables\\na"
  "re referenced.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/select.html\\n\\n','','https://dev.mysql.com/doc/refman/"
  "8.4/en/select.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (556,41,'JOIN','MySQL suppor"
  "ts the following JOIN syntax for the table_references part\\nof SELECT statements and multiple-table DELETE and UPDATE"
  " statements:\\n\\ntable_references:\\n    escaped_table_reference [, escaped_table_reference] ...\\n\\nescaped_table_refer"
  "ence: {\\n    table_reference\\n  | { OJ table_reference }\\n}\\n\\ntable_reference: {\\n    table_factor\\n  | joined_table"
  "\\n}\\n\\ntable_factor: {\\n    tbl_name [PARTITION (partition_names)]\\n        [[AS] alias] [index_hint_list]\\n  | [LATE"
  "RAL] table_subquery [AS] alias [(col_list)]\\n  | ( table_references )\\n}\\n\\njoined_table: {\\n    table_reference {[IN"
  "NER | CROSS] JOIN | STRAIGHT_JOIN} table_factor [join_specification]\\n  | table_reference {LEFT|RIGHT} [OUTER] JOIN t"
  "able_reference join_specification\\n  | table_reference NATURAL [INNER | {LEFT|RIGHT} [OUTER]] JOIN table_factor\\n}\\n\\"
  "njoin_specification: {\\n    ON search_condition\\n  | USING (join_column_list)\\n}\\n\\njoin_column_list:\\n    column_nam"
  "e [, column_name] ...\\n\\nindex_hint_list:\\n    index_hint [, index_hint] ...\\n\\nindex_hint: {\\n    USE {INDEX|KEY}\\n "
  "     [FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\\n  | {IGNORE|FORCE} {INDEX|KEY}\\n      [FOR {JOIN|ORDER BY|GROUP B"
  "Y}] (index_list)\\n}\\n\\nindex_list:\\n    index_name [, index_name] ...\\n\\nA table reference is also known as a join ex"
  "pression.\\n\\nA table reference (when it refers to a partitioned table) may contain a\\nPARTITION clause, including a l"
  "ist of comma-separated partitions,\\nsubpartitions, or both. This option follows the name of the table and\\nprecedes a"
  "ny alias declaration. The effect of this option is that rows\\nare selected only from the listed partitions or subpart"
  "itions. Any\\npartitions or subpartitions not named in the list are ignored. For more\\ninformation and examples, see\\n"
  "https://dev.mysql.com/doc/refman/8.4/en/partitioning-selection.html.\\n\\nThe syntax of table_factor is extended in MyS"
  "QL in comparison with\\nstandard SQL. The standard accepts only table_reference, not a list of\\nthem inside a pair of "
  "parentheses.\\n\\nThis is a conservative extension if each comma in a list of\\ntable_reference items is considered as e"
  "quivalent to an inner join. For\\nexample:\\n\\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\\n                 ON (t2.a = t1."
  "a AND t3.b = t1.b AND t4.c = t1.c)\\n\\nis equivalent to:\\n\\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4"
  ")\\n                 ON (t2.a = t1.a AND t3.b = t1.b AND t4.c = t1.c)\\n\\nIn MySQL, JOIN, CROSS JOIN, and INNER JOIN ar"
  "e syntactic equivalents\\n(they can replace each other). In standard SQL, they are not\\nequivalent. INNER JOIN is used"
  " with an ON clause, CROSS JOIN is used\\notherwise.\\n\\nIn general, parentheses can be ignored in join expressions cont"
  "aining\\nonly inner join operations. MySQL also supports nested joins. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/ne"
  "sted-join-optimization.html.\\n\\nIndex hints can be specified to affect how the MySQL optimizer makes\\nuse of indexes."
  " For more information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/index-hints.html. Optimizer\\nhints and the optimi"
  "zer_switch system variable are other ways to\\ninfluence optimizer use of indexes. See\\nhttps://dev.mysql.com/doc/refm"
  "an/8.4/en/optimizer-hints.html, and\\nhttps://dev.mysql.com/doc/refman/8.4/en/switchable-optimizations.html.\\n\\nURL: h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/join.html\\n\\n','SELECT left_tbl.*\\n  FROM left_tbl LEFT JOIN right_tbl ON left"
  "_tbl.id = right_tbl.id\\n  WHERE right_tbl.id IS NULL;\\n','https://dev.mysql.com/doc/refman/8.4/en/join.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (557,41,'TABLE','Syntax:\\nTA"
  "BLE is a DML statement which returns rows and columns of the named\\ntable.\\n\\nTABLE table_name [ORDER BY column_name]"
  " [LIMIT number [OFFSET number]]\\n\\nThe TABLE statement in some ways acts like SELECT. Given the existence\\nof a table"
  " named t, the following two statements produce identical\\noutput:\\n\\nTABLE t;\\n\\nSELECT * FROM t;\\n\\nYou can order an"
  "d limit the number of rows produced by TABLE using\\nORDER BY and LIMIT clauses, respectively. These function identica"
  "lly to\\nthe same clauses when used with SELECT (including an optional OFFSET\\nclause with LIMIT), as you can see here"
  ":\\n\\nmysql> TABLE t;\\n+----+----+\\n| a  | b  |\\n+----+----+\\n|  1 |  2 |\\n|  6 |  7 |\\n|  9 |  5 |\\n| 10 | -4 |\\n| 11"
  " | -1 |\\n| 13 |  3 |\\n| 14 |  6 |\\n+----+----+\\n7 rows in set (0.00 sec)\\n\\nmysql> TABLE t ORDER BY b;\\n+----+----+\\n"
  "| a  | b  |\\n+----+----+\\n| 10 | -4 |\\n| 11 | -1 |\\n|  1 |  2 |\\n| 13 |  3 |\\n|  9 |  5 |\\n| 14 |  6 |\\n|  6 |  7 |\\n"
  "+----+----+\\n7 rows in set (0.00 sec)\\n\\nmysql> TABLE t LIMIT 3;\\n+---+---+\\n| a | b |\\n+---+---+\\n| 1 | 2 |\\n| 6 | 7"
  " |\\n| 9 | 5 |\\n+---+---+\\n3 rows in set (0.00 sec)\\n\\nmysql> TABLE t ORDER BY b LIMIT 3;\\n+----+----+\\n| a  | b  |\\n+"
  "----+----+\\n| 10 | -4 |\\n| 11 | -1 |\\n|  1 |  2 |\\n+----+----+\\n3 rows in set (0.00 sec)\\n\\nmysql> TABLE t ORDER BY b"
  " LIMIT 3 OFFSET 2;\\n+----+----+\\n| a  | b  |\\n+----+----+\\n|  1 |  2 |\\n| 13 |  3 |\\n|  9 |  5 |\\n+----+----+\\n3 rows"
  " in set (0.00 sec)\\n\\nTABLE differs from SELECT in two key respects:\\n\\no TABLE always displays all columns of the ta"
  "ble.\\n\\n  Exception: The output of TABLE does not include invisible columns.\\n  See https://dev.mysql.com/doc/refman/"
  "8.4/en/invisible-columns.html.\\n\\no TABLE does not allow for any arbitrary filtering of rows; that is,\\n  TABLE does "
  "not support any WHERE clause.\\n\\nFor limiting which table columns are returned, filtering rows beyond\\nwhat can be ac"
  "complished using ORDER BY and LIMIT, or both, use SELECT.\\n\\nTABLE can be used with temporary tables.\\n\\nURL: https:/"
  "/dev.mysql.com/doc/refman/8.4/en/table.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/table.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (558,41,'UPDATE','Syntax:\\nU"
  "PDATE is a DML statement that modifies rows in a table.\\n\\nAn UPDATE statement can start with a WITH clause to define"
  " common table\\nexpressions accessible within the UPDATE. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/with.html.\\n\\nS"
  "ingle-table syntax:\\n\\nUPDATE [LOW_PRIORITY] [IGNORE] table_reference\\n    SET assignment_list\\n    [WHERE where_cond"
  "ition]\\n    [ORDER BY ...]\\n    [LIMIT row_count]\\n\\nvalue:\\n    {expr | DEFAULT}\\n\\nassignment:\\n    col_name = valu"
  "e\\n\\nassignment_list:\\n    assignment [, assignment] ...\\n\\nMultiple-table syntax:\\n\\nUPDATE [LOW_PRIORITY] [IGNORE] "
  "table_references\\n    SET assignment_list\\n    [WHERE where_condition]\\n\\nFor the single-table syntax, the UPDATE sta"
  "tement updates columns of\\nexisting rows in the named table with new values. The SET clause\\nindicates which columns "
  "to modify and the values they should be given.\\nEach value can be given as an expression, or the keyword DEFAULT to s"
  "et\\na column explicitly to its default value. The WHERE clause, if given,\\nspecifies the conditions that identify whi"
  "ch rows to update. With no\\nWHERE clause, all rows are updated. If the ORDER BY clause is\\nspecified, the rows are up"
  "dated in the order that is specified. The\\nLIMIT clause places a limit on the number of rows that can be updated.\\n\\n"
  "For the multiple-table syntax, UPDATE updates rows in each table named\\nin table_references that satisfy the conditio"
  "ns. Each matching row is\\nupdated once, even if it matches the conditions multiple times. For\\nmultiple-table syntax,"
  " ORDER BY and LIMIT cannot be used.\\n\\nFor partitioned tables, both the single-single and multiple-table forms\\nof th"
  "is statement support the use of a PARTITION clause as part of a\\ntable reference. This option takes a list of one or "
  "more partitions or\\nsubpartitions (or both). Only the partitions (or subpartitions) listed\\nare checked for matches, "
  "and a row that is not in any of these\\npartitions or subpartitions is not updated, whether it satisfies the\\nwhere_co"
  "ndition or not.\\n\\n*Note*:\\n\\nUnlike the case when using PARTITION with an INSERT or REPLACE\\nstatement, an otherwise"
  " valid UPDATE ... PARTITION statement is\\nconsidered successful even if no rows in the listed partitions (or\\nsubpart"
  "itions) match the where_condition.\\n\\nFor more information and examples, see\\nhttps://dev.mysql.com/doc/refman/8.4/en"
  "/partitioning-selection.html.\\n\\nwhere_condition is an expression that evaluates to true for each row to\\nbe updated."
  " For expression syntax, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/expressions.html.\\n\\ntable_references and where_"
  "condition are specified as described in\\nhttps://dev.mysql.com/doc/refman/8.4/en/select.html.\\n\\nYou need the UPDATE "
  "privilege only for columns referenced in an UPDATE\\nthat are actually updated. You need only the SELECT privilege for"
  " any\\ncolumns that are read but not modified.\\n\\nThe UPDATE statement supports the following modifiers:\\n\\no With the"
  " LOW_PRIORITY modifier, execution of the UPDATE is delayed\\n  until no other clients are reading from the table. This"
  " affects only\\n  storage engines that use only table-level locking (such as MyISAM,\\n  MEMORY, and MERGE).\\n\\no With "
  "the IGNORE modifier, the update statement does not abort even if\\n  errors occur during the update. Rows for which du"
  "plicate-key\\n  conflicts occur on a unique key value are not updated. Rows updated\\n  to values that would cause data"
  " conversion errors are updated to the\\n  closest valid values instead. For more information, see\\n  https://dev.mysql"
  ".com/doc/refman/8.4/en/sql-mode.html#ignore-effect-o\\n  n-execution.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/"
  "update.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/update.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (559,41,'UNION','Syntax:\\nqu"
  "ery_expression_body UNION [ALL | DISTINCT] query_block\\n    [UNION [ALL | DISTINCT] query_expression_body]\\n    [...]"
  "\\n\\nquery_expression_body:\\n    See \\n\\nUNION combines the result from multiple query blocks into a single\\nresult se"
  "t. This example uses SELECT statements:\\n\\nmysql> SELECT 1, 2;\\n+---+---+\\n| 1 | 2 |\\n+---+---+\\n| 1 | 2 |\\n+---+---+"
  "\\nmysql> SELECT \\'a\\', \\'b\\';\\n+---+---+\\n| a | b |\\n+---+---+\\n| a | b |\\n+---+---+\\nmysql> SELECT 1, 2 UNION SELECT"
  " \\'a\\', \\'b\\';\\n+---+---+\\n| 1 | 2 |\\n+---+---+\\n| 1 | 2 |\\n| a | b |\\n+---+---+\\n\\nURL: https://dev.mysql.com/doc/re"
  "fman/8.4/en/union.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/union.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (560,41,'VALUES STATEMENT','"
  "Syntax:\\nVALUES row_constructor_list [ORDER BY column_designator] [LIMIT number]\\n\\nrow_constructor_list:\\n    ROW(va"
  "lue_list)[, ROW(value_list)][, ...]\\n\\nvalue_list:\\n    value[, value][, ...]\\n\\ncolumn_designator:\\n    column_index"
  "\\n\\nThe VALUES statement consists of the VALUES keyword followed by a list\\nof one or more row constructors, separate"
  "d by commas. A row constructor\\nconsists of the ROW() row constructor clause with a value list of one\\nor more scalar"
  " values enclosed in the parentheses. A value can be a\\nliteral of any MySQL data type or an expression that resolves "
  "to a\\nscalar value.\\n\\nROW() cannot be empty (but each of the supplied scalar values can be\\nNULL). Each ROW() in the"
  " same VALUES statement must have the same\\nnumber of values in its value list.\\n\\nThe DEFAULT keyword is not supporte"
  "d by VALUES and causes a syntax\\nerror, except when it is used to supply values in an INSERT statement.\\n\\nThe output"
  " of VALUES is a table:\\n\\nmysql> VALUES ROW(1,-2,3), ROW(5,7,9), ROW(4,6,8);\\n+----------+----------+----------+\\n| c"
  "olumn_0 | column_1 | column_2 |\\n+----------+----------+----------+\\n|        1 |       -2 |        3 |\\n|        5 |"
  "        7 |        9 |\\n|        4 |        6 |        8 |\\n+----------+----------+----------+\\n3 rows in set (0.00 s"
  "ec)\\n\\nThe columns of the table output from VALUES have the implicitly named\\ncolumns column_0, column_1, column_2, a"
  "nd so on, always beginning with\\n0. This fact can be used to order the rows by column using an optional\\nORDER BY cla"
  "use in the same way that this clause works with a SELECT\\nstatement, as shown here:\\n\\nmysql> VALUES ROW(1,-2,3), ROW"
  "(5,7,9), ROW(4,6,8) ORDER BY column_1;\\n+----------+----------+----------+\\n| column_0 | column_1 | column_2 |\\n+----"
  "------+----------+----------+\\n|        1 |       -2 |        3 |\\n|        4 |        6 |        8 |\\n|        5 |  "
  "      7 |        9 |\\n+----------+----------+----------+\\n3 rows in set (0.00 sec)\\n\\nVALUES statement also supports "
  "a LIMIT clause for limiting the number\\nof rows in the output.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/values"
  ".html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/values.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (561,42,'START TRANSACTION',"
  "'Syntax:\\nSTART TRANSACTION\\n    [transaction_characteristic [, transaction_characteristic] ...]\\n\\ntransaction_chara"
  "cteristic: {\\n    WITH CONSISTENT SNAPSHOT\\n  | READ WRITE\\n  | READ ONLY\\n}\\n\\nBEGIN [WORK]\\nCOMMIT [WORK] [AND [NO]"
  " CHAIN] [[NO] RELEASE]\\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\\nSET autocommit = {0 | 1}\\n\\nThese statements"
  " provide control over use of transactions:\\n\\no START TRANSACTION or BEGIN start a new transaction.\\n\\no COMMIT commi"
  "ts the current transaction, making its changes permanent.\\n\\no ROLLBACK rolls back the current transaction, canceling"
  " its changes.\\n\\no SET autocommit disables or enables the default autocommit mode for\\n  the current session.\\n\\nBy d"
  "efault, MySQL runs with autocommit mode enabled. This means that,\\nwhen not otherwise inside a transaction, each stat"
  "ement is atomic, as\\nif it were surrounded by START TRANSACTION and COMMIT. You cannot use\\nROLLBACK to undo the effe"
  "ct; however, if an error occurs during\\nstatement execution, the statement is rolled back.\\n\\nTo disable autocommit m"
  "ode implicitly for a single series of\\nstatements, use the START TRANSACTION statement:\\n\\nSTART TRANSACTION;\\nSELECT"
  " @A:=SUM(salary) FROM table1 WHERE type=1;\\nUPDATE table2 SET summary=@A WHERE type=1;\\nCOMMIT;\\n\\nWith START TRANSAC"
  "TION, autocommit remains disabled until you end the\\ntransaction with COMMIT or ROLLBACK. The autocommit mode then re"
  "verts\\nto its previous state.\\n\\nSTART TRANSACTION permits several modifiers that control transaction\\ncharacteristic"
  "s. To specify multiple modifiers, separate them by\\ncommas.\\n\\no The WITH CONSISTENT SNAPSHOT modifier starts a consi"
  "stent read for\\n  storage engines that are capable of it. This applies only to InnoDB.\\n  The effect is the same as i"
  "ssuing a START TRANSACTION followed by a\\n  SELECT from any InnoDB table. See\\n  https://dev.mysql.com/doc/refman/8.4"
  "/en/innodb-consistent-read.html.\\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\\n  transaction "
  "isolation level, so it provides a consistent snapshot\\n  only if the current isolation level is one that permits a co"
  "nsistent\\n  read. The only isolation level that permits a consistent read is\\n  REPEATABLE READ. For all other isolat"
  "ion levels, the WITH CONSISTENT\\n  SNAPSHOT clause is ignored. A warning is generated when the WITH\\n  CONSISTENT SNA"
  "PSHOT clause is ignored.\\n\\no The READ WRITE and READ ONLY modifiers set the transaction access\\n  mode. They permit "
  "or prohibit changes to tables used in the\\n  transaction. The READ ONLY restriction prevents the transaction from\\n  "
  "modifying or locking both transactional and nontransactional tables\\n  that are visible to other transactions; the tr"
  "ansaction can still\\n  modify or lock temporary tables.\\n\\n  MySQL enables extra optimizations for queries on InnoDB "
  "tables when\\n  the transaction is known to be read-only. Specifying READ ONLY\\n  ensures these optimizations are appl"
  "ied in cases where the read-only\\n  status cannot be determined automatically. See\\n  https://dev.mysql.com/doc/refma"
  "n/8.4/en/innodb-performance-ro-txn.htm\\n  l for more information.\\n\\n  If no access mode is specified, the default mo"
  "de applies. Unless the\\n  default has been changed, it is read/write. It is not permitted to\\n  specify both READ WRI"
  "TE and READ ONLY in the same statement.\\n\\n  In read-only mode, it remains possible to change tables created with\\n  "
  "the TEMPORARY keyword using DML statements. Changes made with DDL\\n  statements are not permitted, just as with perma"
  "nent tables.\\n\\n  For additional information about transaction access mode, including\\n  ways to change the default m"
  "ode, see [HELP SET TRANSACTION].\\n\\n  If the read_only system variable is enabled, explicitly starting a\\n  transacti"
  "on with START TRANSACTION READ WRITE requires the\\n  CONNECTION_ADMIN privilege (or the deprecated SUPER privilege).\\"
  "n\\n*Important*:\\n\\nMany APIs used for writing MySQL client applications (such as JDBC)\\nprovide their own methods for"
  " starting transactions that can (and\\nsometimes should) be used instead of sending a START TRANSACTION\\nstatement fro"
  "m the client. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/connectors-apis.html, or the\\ndocumentation for your API, "
  "for more information.\\n\\nTo disable autocommit mode explicitly, use the following statement:\\n\\nSET autocommit=0;\\n\\n"
  "After disabling autocommit mode by setting the autocommit variable to\\nzero, changes to transaction-safe tables (such"
  " as those for InnoDB or\\nNDB) are not made permanent immediately. You must use COMMIT to store\\nyour changes to disk "
  "or ROLLBACK to ignore the changes.\\n\\nautocommit is a session variable and must be set for each session. To\\ndisable "
  "autocommit mode for each new connection, see the description of\\nthe autocommit system variable at\\nhttps://dev.mysql"
  ".com/doc/refman/8.4/en/server-system-variables.html.\\n\\nBEGIN and BEGIN WORK are supported as aliases of START TRANSA"
  "CTION for\\ninitiating a transaction. START TRANSACTION is standard SQL syntax, is\\nthe recommended way to start an ad"
  "-hoc transaction, and permits\\nmodifiers that BEGIN does not.\\n\\nThe BEGIN statement differs from the use of the BEGI"
  "N keyword that\\nstarts a BEGIN ... END compound statement. The latter does not begin a\\ntransaction. See [HELP BEGIN "
  "END].\\n\\n*Note*:\\n\\nWithin all stored programs (stored procedures and functions, triggers,\\nand events), the parser t"
  "reats BEGIN [WORK] as the beginning of a BEGIN\\n... END block. Begin a transaction in this context with START\\nTRANSA"
  "CTION instead.\\n\\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\\nthe CHAIN and RELEASE claus"
  "es. CHAIN and RELEASE can be used for\\nadditional control over transaction completion. The value of the\\ncompletion_t"
  "ype system variable determines the default completion\\nbehavior. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-"
  "system-variables.html.\\n\\nThe AND CHAIN clause causes a new transaction to begin as soon as the\\ncurrent one ends, an"
  "d the new transaction has the same isolation level\\nas the just-terminated transaction. The new transaction also uses"
  " the\\nsame access mode (READ WRITE or READ ONLY) as the just-terminated\\ntransaction. The RELEASE clause causes the s"
  "erver to disconnect the\\ncurrent client session after terminating the current transaction.\\nIncluding the NO keyword "
  "suppresses CHAIN or RELEASE completion, which\\ncan be useful if the completion_type system variable is set to cause\\n"
  "chaining or release completion by default.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/commit.html\\n\\n','','https"
  "://dev.mysql.com/doc/refman/8.4/en/commit.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (562,42,'BEGIN','Syntax:\\nST"
  "ART TRANSACTION\\n    [transaction_characteristic [, transaction_characteristic] ...]\\n\\ntransaction_characteristic: {"
  "\\n    WITH CONSISTENT SNAPSHOT\\n  | READ WRITE\\n  | READ ONLY\\n}\\n\\nBEGIN [WORK]\\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO"
  "] RELEASE]\\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\\nSET autocommit = {0 | 1}\\n\\nThese statements provide con"
  "trol over use of transactions:\\n\\no START TRANSACTION or BEGIN start a new transaction.\\n\\no COMMIT commits the curre"
  "nt transaction, making its changes permanent.\\n\\no ROLLBACK rolls back the current transaction, canceling its changes"
  ".\\n\\no SET autocommit disables or enables the default autocommit mode for\\n  the current session.\\n\\nBy default, MySQ"
  "L runs with autocommit mode enabled. This means that,\\nwhen not otherwise inside a transaction, each statement is ato"
  "mic, as\\nif it were surrounded by START TRANSACTION and COMMIT. You cannot use\\nROLLBACK to undo the effect; however,"
  " if an error occurs during\\nstatement execution, the statement is rolled back.\\n\\nTo disable autocommit mode implicit"
  "ly for a single series of\\nstatements, use the START TRANSACTION statement:\\n\\nSTART TRANSACTION;\\nSELECT @A:=SUM(sal"
  "ary) FROM table1 WHERE type=1;\\nUPDATE table2 SET summary=@A WHERE type=1;\\nCOMMIT;\\n\\nWith START TRANSACTION, autoco"
  "mmit remains disabled until you end the\\ntransaction with COMMIT or ROLLBACK. The autocommit mode then reverts\\nto it"
  "s previous state.\\n\\nSTART TRANSACTION permits several modifiers that control transaction\\ncharacteristics. To specif"
  "y multiple modifiers, separate them by\\ncommas.\\n\\no The WITH CONSISTENT SNAPSHOT modifier starts a consistent read f"
  "or\\n  storage engines that are capable of it. This applies only to InnoDB.\\n  The effect is the same as issuing a STA"
  "RT TRANSACTION followed by a\\n  SELECT from any InnoDB table. See\\n  https://dev.mysql.com/doc/refman/8.4/en/innodb-c"
  "onsistent-read.html.\\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\\n  transaction isolation le"
  "vel, so it provides a consistent snapshot\\n  only if the current isolation level is one that permits a consistent\\n  "
  "read. The only isolation level that permits a consistent read is\\n  REPEATABLE READ. For all other isolation levels, "
  "the WITH CONSISTENT\\n  SNAPSHOT clause is ignored. A warning is generated when the WITH\\n  CONSISTENT SNAPSHOT clause"
  " is ignored.\\n\\no The READ WRITE and READ ONLY modifiers set the transaction access\\n  mode. They permit or prohibit "
  "changes to tables used in the\\n  transaction. The READ ONLY restriction prevents the transaction from\\n  modifying or"
  " locking both transactional and nontransactional tables\\n  that are visible to other transactions; the transaction ca"
  "n still\\n  modify or lock temporary tables.\\n\\n  MySQL enables extra optimizations for queries on InnoDB tables when\\"
  "n  the transaction is known to be read-only. Specifying READ ONLY\\n  ensures these optimizations are applied in cases"
  " where the read-only\\n  status cannot be determined automatically. See\\n  https://dev.mysql.com/doc/refman/8.4/en/inn"
  "odb-performance-ro-txn.htm\\n  l for more information.\\n\\n  If no access mode is specified, the default mode applies. "
  "Unless the\\n  default has been changed, it is read/write. It is not permitted to\\n  specify both READ WRITE and READ "
  "ONLY in the same statement.\\n\\n  In read-only mode, it remains possible to change tables created with\\n  the TEMPORAR"
  "Y keyword using DML statements. Changes made with DDL\\n  statements are not permitted, just as with permanent tables."
  "\\n\\n  For additional information about transaction access mode, including\\n  ways to change the default mode, see [HE"
  "LP SET TRANSACTION].\\n\\n  If the read_only system variable is enabled, explicitly starting a\\n  transaction with STAR"
  "T TRANSACTION READ WRITE requires the\\n  CONNECTION_ADMIN privilege (or the deprecated SUPER privilege).\\n\\n*Importan"
  "t*:\\n\\nMany APIs used for writing MySQL client applications (such as JDBC)\\nprovide their own methods for starting tr"
  "ansactions that can (and\\nsometimes should) be used instead of sending a START TRANSACTION\\nstatement from the client"
  ". See\\nhttps://dev.mysql.com/doc/refman/8.4/en/connectors-apis.html, or the\\ndocumentation for your API, for more inf"
  "ormation.\\n\\nTo disable autocommit mode explicitly, use the following statement:\\n\\nSET autocommit=0;\\n\\nAfter disabl"
  "ing autocommit mode by setting the autocommit variable to\\nzero, changes to transaction-safe tables (such as those fo"
  "r InnoDB or\\nNDB) are not made permanent immediately. You must use COMMIT to store\\nyour changes to disk or ROLLBACK "
  "to ignore the changes.\\n\\nautocommit is a session variable and must be set for each session. To\\ndisable autocommit m"
  "ode for each new connection, see the description of\\nthe autocommit system variable at\\nhttps://dev.mysql.com/doc/ref"
  "man/8.4/en/server-system-variables.html.\\n\\nBEGIN and BEGIN WORK are supported as aliases of START TRANSACTION for\\ni"
  "nitiating a transaction. START TRANSACTION is standard SQL syntax, is\\nthe recommended way to start an ad-hoc transac"
  "tion, and permits\\nmodifiers that BEGIN does not.\\n\\nThe BEGIN statement differs from the use of the BEGIN keyword th"
  "at\\nstarts a BEGIN ... END compound statement. The latter does not begin a\\ntransaction. See [HELP BEGIN END].\\n\\n*No"
  "te*:\\n\\nWithin all stored programs (stored procedures and functions, triggers,\\nand events), the parser treats BEGIN "
  "[WORK] as the beginning of a BEGIN\\n... END block. Begin a transaction in this context with START\\nTRANSACTION instea"
  "d.\\n\\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\\nthe CHAIN and RELEASE clauses. CHAIN an"
  "d RELEASE can be used for\\nadditional control over transaction completion. The value of the\\ncompletion_type system v"
  "ariable determines the default completion\\nbehavior. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-system-varia"
  "bles.html.\\n\\nThe AND CHAIN clause causes a new transaction to begin as soon as the\\ncurrent one ends, and the new tr"
  "ansaction has the same isolation level\\nas the just-terminated transaction. The new transaction also uses the\\nsame a"
  "ccess mode (READ WRITE or READ ONLY) as the just-terminated\\ntransaction. The RELEASE clause causes the server to dis"
  "connect the\\ncurrent client session after terminating the current transaction.\\nIncluding the NO keyword suppresses C"
  "HAIN or RELEASE completion, which\\ncan be useful if the completion_type system variable is set to cause\\nchaining or "
  "release completion by default.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/commit.html\\n\\n','','https://dev.mysql"
  ".com/doc/refman/8.4/en/commit.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (563,42,'COMMIT','Syntax:\\nS"
  "TART TRANSACTION\\n    [transaction_characteristic [, transaction_characteristic] ...]\\n\\ntransaction_characteristic: "
  "{\\n    WITH CONSISTENT SNAPSHOT\\n  | READ WRITE\\n  | READ ONLY\\n}\\n\\nBEGIN [WORK]\\nCOMMIT [WORK] [AND [NO] CHAIN] [[N"
  "O] RELEASE]\\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\\nSET autocommit = {0 | 1}\\n\\nThese statements provide co"
  "ntrol over use of transactions:\\n\\no START TRANSACTION or BEGIN start a new transaction.\\n\\no COMMIT commits the curr"
  "ent transaction, making its changes permanent.\\n\\no ROLLBACK rolls back the current transaction, canceling its change"
  "s.\\n\\no SET autocommit disables or enables the default autocommit mode for\\n  the current session.\\n\\nBy default, MyS"
  "QL runs with autocommit mode enabled. This means that,\\nwhen not otherwise inside a transaction, each statement is at"
  "omic, as\\nif it were surrounded by START TRANSACTION and COMMIT. You cannot use\\nROLLBACK to undo the effect; however"
  ", if an error occurs during\\nstatement execution, the statement is rolled back.\\n\\nTo disable autocommit mode implici"
  "tly for a single series of\\nstatements, use the START TRANSACTION statement:\\n\\nSTART TRANSACTION;\\nSELECT @A:=SUM(sa"
  "lary) FROM table1 WHERE type=1;\\nUPDATE table2 SET summary=@A WHERE type=1;\\nCOMMIT;\\n\\nWith START TRANSACTION, autoc"
  "ommit remains disabled until you end the\\ntransaction with COMMIT or ROLLBACK. The autocommit mode then reverts\\nto i"
  "ts previous state.\\n\\nSTART TRANSACTION permits several modifiers that control transaction\\ncharacteristics. To speci"
  "fy multiple modifiers, separate them by\\ncommas.\\n\\no The WITH CONSISTENT SNAPSHOT modifier starts a consistent read "
  "for\\n  storage engines that are capable of it. This applies only to InnoDB.\\n  The effect is the same as issuing a ST"
  "ART TRANSACTION followed by a\\n  SELECT from any InnoDB table. See\\n  https://dev.mysql.com/doc/refman/8.4/en/innodb-"
  "consistent-read.html.\\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\\n  transaction isolation l"
  "evel, so it provides a consistent snapshot\\n  only if the current isolation level is one that permits a consistent\\n "
  " read. The only isolation level that permits a consistent read is\\n  REPEATABLE READ. For all other isolation levels,"
  " the WITH CONSISTENT\\n  SNAPSHOT clause is ignored. A warning is generated when the WITH\\n  CONSISTENT SNAPSHOT claus"
  "e is ignored.\\n\\no The READ WRITE and READ ONLY modifiers set the transaction access\\n  mode. They permit or prohibit"
  " changes to tables used in the\\n  transaction. The READ ONLY restriction prevents the transaction from\\n  modifying o"
  "r locking both transactional and nontransactional tables\\n  that are visible to other transactions; the transaction c"
  "an still\\n  modify or lock temporary tables.\\n\\n  MySQL enables extra optimizations for queries on InnoDB tables when"
  "\\n  the transaction is known to be read-only. Specifying READ ONLY\\n  ensures these optimizations are applied in case"
  "s where the read-only\\n  status cannot be determined automatically. See\\n  https://dev.mysql.com/doc/refman/8.4/en/in"
  "nodb-performance-ro-txn.htm\\n  l for more information.\\n\\n  If no access mode is specified, the default mode applies."
  " Unless the\\n  default has been changed, it is read/write. It is not permitted to\\n  specify both READ WRITE and READ"
  " ONLY in the same statement.\\n\\n  In read-only mode, it remains possible to change tables created with\\n  the TEMPORA"
  "RY keyword using DML statements. Changes made with DDL\\n  statements are not permitted, just as with permanent tables"
  ".\\n\\n  For additional information about transaction access mode, including\\n  ways to change the default mode, see [H"
  "ELP SET TRANSACTION].\\n\\n  If the read_only system variable is enabled, explicitly starting a\\n  transaction with STA"
  "RT TRANSACTION READ WRITE requires the\\n  CONNECTION_ADMIN privilege (or the deprecated SUPER privilege).\\n\\n*Importa"
  "nt*:\\n\\nMany APIs used for writing MySQL client applications (such as JDBC)\\nprovide their own methods for starting t"
  "ransactions that can (and\\nsometimes should) be used instead of sending a START TRANSACTION\\nstatement from the clien"
  "t. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/connectors-apis.html, or the\\ndocumentation for your API, for more in"
  "formation.\\n\\nTo disable autocommit mode explicitly, use the following statement:\\n\\nSET autocommit=0;\\n\\nAfter disab"
  "ling autocommit mode by setting the autocommit variable to\\nzero, changes to transaction-safe tables (such as those f"
  "or InnoDB or\\nNDB) are not made permanent immediately. You must use COMMIT to store\\nyour changes to disk or ROLLBACK"
  " to ignore the changes.\\n\\nautocommit is a session variable and must be set for each session. To\\ndisable autocommit "
  "mode for each new connection, see the description of\\nthe autocommit system variable at\\nhttps://dev.mysql.com/doc/re"
  "fman/8.4/en/server-system-variables.html.\\n\\nBEGIN and BEGIN WORK are supported as aliases of START TRANSACTION for\\n"
  "initiating a transaction. START TRANSACTION is standard SQL syntax, is\\nthe recommended way to start an ad-hoc transa"
  "ction, and permits\\nmodifiers that BEGIN does not.\\n\\nThe BEGIN statement differs from the use of the BEGIN keyword t"
  "hat\\nstarts a BEGIN ... END compound statement. The latter does not begin a\\ntransaction. See [HELP BEGIN END].\\n\\n*N"
  "ote*:\\n\\nWithin all stored programs (stored procedures and functions, triggers,\\nand events), the parser treats BEGIN"
  " [WORK] as the beginning of a BEGIN\\n... END block. Begin a transaction in this context with START\\nTRANSACTION inste"
  "ad.\\n\\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\\nthe CHAIN and RELEASE clauses. CHAIN a"
  "nd RELEASE can be used for\\nadditional control over transaction completion. The value of the\\ncompletion_type system "
  "variable determines the default completion\\nbehavior. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-system-vari"
  "ables.html.\\n\\nThe AND CHAIN clause causes a new transaction to begin as soon as the\\ncurrent one ends, and the new t"
  "ransaction has the same isolation level\\nas the just-terminated transaction. The new transaction also uses the\\nsame "
  "access mode (READ WRITE or READ ONLY) as the just-terminated\\ntransaction. The RELEASE clause causes the server to di"
  "sconnect the\\ncurrent client session after terminating the current transaction.\\nIncluding the NO keyword suppresses "
  "CHAIN or RELEASE completion, which\\ncan be useful if the completion_type system variable is set to cause\\nchaining or"
  " release completion by default.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/commit.html\\n\\n','','https://dev.mysq"
  "l.com/doc/refman/8.4/en/commit.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (564,42,'ROLLBACK','Syntax:\\"
  "nSTART TRANSACTION\\n    [transaction_characteristic [, transaction_characteristic] ...]\\n\\ntransaction_characteristic"
  ": {\\n    WITH CONSISTENT SNAPSHOT\\n  | READ WRITE\\n  | READ ONLY\\n}\\n\\nBEGIN [WORK]\\nCOMMIT [WORK] [AND [NO] CHAIN] ["
  "[NO] RELEASE]\\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\\nSET autocommit = {0 | 1}\\n\\nThese statements provide "
  "control over use of transactions:\\n\\no START TRANSACTION or BEGIN start a new transaction.\\n\\no COMMIT commits the cu"
  "rrent transaction, making its changes permanent.\\n\\no ROLLBACK rolls back the current transaction, canceling its chan"
  "ges.\\n\\no SET autocommit disables or enables the default autocommit mode for\\n  the current session.\\n\\nBy default, M"
  "ySQL runs with autocommit mode enabled. This means that,\\nwhen not otherwise inside a transaction, each statement is "
  "atomic, as\\nif it were surrounded by START TRANSACTION and COMMIT. You cannot use\\nROLLBACK to undo the effect; howev"
  "er, if an error occurs during\\nstatement execution, the statement is rolled back.\\n\\nTo disable autocommit mode impli"
  "citly for a single series of\\nstatements, use the START TRANSACTION statement:\\n\\nSTART TRANSACTION;\\nSELECT @A:=SUM("
  "salary) FROM table1 WHERE type=1;\\nUPDATE table2 SET summary=@A WHERE type=1;\\nCOMMIT;\\n\\nWith START TRANSACTION, aut"
  "ocommit remains disabled until you end the\\ntransaction with COMMIT or ROLLBACK. The autocommit mode then reverts\\nto"
  " its previous state.\\n\\nSTART TRANSACTION permits several modifiers that control transaction\\ncharacteristics. To spe"
  "cify multiple modifiers, separate them by\\ncommas.\\n\\no The WITH CONSISTENT SNAPSHOT modifier starts a consistent rea"
  "d for\\n  storage engines that are capable of it. This applies only to InnoDB.\\n  The effect is the same as issuing a "
  "START TRANSACTION followed by a\\n  SELECT from any InnoDB table. See\\n  https://dev.mysql.com/doc/refman/8.4/en/innod"
  "b-consistent-read.html.\\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\\n  transaction isolation"
  " level, so it provides a consistent snapshot\\n  only if the current isolation level is one that permits a consistent\\"
  "n  read. The only isolation level that permits a consistent read is\\n  REPEATABLE READ. For all other isolation level"
  "s, the WITH CONSISTENT\\n  SNAPSHOT clause is ignored. A warning is generated when the WITH\\n  CONSISTENT SNAPSHOT cla"
  "use is ignored.\\n\\no The READ WRITE and READ ONLY modifiers set the transaction access\\n  mode. They permit or prohib"
  "it changes to tables used in the\\n  transaction. The READ ONLY restriction prevents the transaction from\\n  modifying"
  " or locking both transactional and nontransactional tables\\n  that are visible to other transactions; the transaction"
  " can still\\n  modify or lock temporary tables.\\n\\n  MySQL enables extra optimizations for queries on InnoDB tables wh"
  "en\\n  the transaction is known to be read-only. Specifying READ ONLY\\n  ensures these optimizations are applied in ca"
  "ses where the read-only\\n  status cannot be determined automatically. See\\n  https://dev.mysql.com/doc/refman/8.4/en/"
  "innodb-performance-ro-txn.htm\\n  l for more information.\\n\\n  If no access mode is specified, the default mode applie"
  "s. Unless the\\n  default has been changed, it is read/write. It is not permitted to\\n  specify both READ WRITE and RE"
  "AD ONLY in the same statement.\\n\\n  In read-only mode, it remains possible to change tables created with\\n  the TEMPO"
  "RARY keyword using DML statements. Changes made with DDL\\n  statements are not permitted, just as with permanent tabl"
  "es.\\n\\n  For additional information about transaction access mode, including\\n  ways to change the default mode, see "
  "[HELP SET TRANSACTION].\\n\\n  If the read_only system variable is enabled, explicitly starting a\\n  transaction with S"
  "TART TRANSACTION READ WRITE requires the\\n  CONNECTION_ADMIN privilege (or the deprecated SUPER privilege).\\n\\n*Impor"
  "tant*:\\n\\nMany APIs used for writing MySQL client applications (such as JDBC)\\nprovide their own methods for starting"
  " transactions that can (and\\nsometimes should) be used instead of sending a START TRANSACTION\\nstatement from the cli"
  "ent. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/connectors-apis.html, or the\\ndocumentation for your API, for more "
  "information.\\n\\nTo disable autocommit mode explicitly, use the following statement:\\n\\nSET autocommit=0;\\n\\nAfter dis"
  "abling autocommit mode by setting the autocommit variable to\\nzero, changes to transaction-safe tables (such as those"
  " for InnoDB or\\nNDB) are not made permanent immediately. You must use COMMIT to store\\nyour changes to disk or ROLLBA"
  "CK to ignore the changes.\\n\\nautocommit is a session variable and must be set for each session. To\\ndisable autocommi"
  "t mode for each new connection, see the description of\\nthe autocommit system variable at\\nhttps://dev.mysql.com/doc/"
  "refman/8.4/en/server-system-variables.html.\\n\\nBEGIN and BEGIN WORK are supported as aliases of START TRANSACTION for"
  "\\ninitiating a transaction. START TRANSACTION is standard SQL syntax, is\\nthe recommended way to start an ad-hoc tran"
  "saction, and permits\\nmodifiers that BEGIN does not.\\n\\nThe BEGIN statement differs from the use of the BEGIN keyword"
  " that\\nstarts a BEGIN ... END compound statement. The latter does not begin a\\ntransaction. See [HELP BEGIN END].\\n\\n"
  "*Note*:\\n\\nWithin all stored programs (stored procedures and functions, triggers,\\nand events), the parser treats BEG"
  "IN [WORK] as the beginning of a BEGIN\\n... END block. Begin a transaction in this context with START\\nTRANSACTION ins"
  "tead.\\n\\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\\nthe CHAIN and RELEASE clauses. CHAIN"
  " and RELEASE can be used for\\nadditional control over transaction completion. The value of the\\ncompletion_type syste"
  "m variable determines the default completion\\nbehavior. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/server-system-va"
  "riables.html.\\n\\nThe AND CHAIN clause causes a new transaction to begin as soon as the\\ncurrent one ends, and the new"
  " transaction has the same isolation level\\nas the just-terminated transaction. The new transaction also uses the\\nsam"
  "e access mode (READ WRITE or READ ONLY) as the just-terminated\\ntransaction. The RELEASE clause causes the server to "
  "disconnect the\\ncurrent client session after terminating the current transaction.\\nIncluding the NO keyword suppresse"
  "s CHAIN or RELEASE completion, which\\ncan be useful if the completion_type system variable is set to cause\\nchaining "
  "or release completion by default.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/commit.html\\n\\n','','https://dev.my"
  "sql.com/doc/refman/8.4/en/commit.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (565,42,'SAVEPOINT','Syntax:"
  "\\nSAVEPOINT identifier\\nROLLBACK [WORK] TO [SAVEPOINT] identifier\\nRELEASE SAVEPOINT identifier\\n\\nInnoDB supports th"
  "e SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLBACK.\\n\\n"
  "URL: https://dev.mysql.com/doc/refman/8.4/en/savepoint.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/savepoin"
  "t.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (566,42,'ROLLBACK TO SAVEPOI"
  "NT','Syntax:\\nSAVEPOINT identifier\\nROLLBACK [WORK] TO [SAVEPOINT] identifier\\nRELEASE SAVEPOINT identifier\\n\\nInnoDB"
  " supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\\nRELEASE SAVEPOINT and the optional WORK keyword for R"
  "OLLBACK.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/savepoint.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4"
  "/en/savepoint.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (567,42,'RELEASE SAVEPOINT',"
  "'Syntax:\\nSAVEPOINT identifier\\nROLLBACK [WORK] TO [SAVEPOINT] identifier\\nRELEASE SAVEPOINT identifier\\n\\nInnoDB sup"
  "ports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLB"
  "ACK.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/savepoint.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/"
  "savepoint.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (568,42,'LOCK INSTANCE FOR B"
  "ACKUP','Syntax:\\nLOCK INSTANCE FOR BACKUP\\n\\nUNLOCK INSTANCE\\n\\nLOCK INSTANCE FOR BACKUP acquires an instance-level b"
  "ackup lock that\\npermits DML during an online backup while preventing operations that\\ncould result in an inconsisten"
  "t snapshot.\\n\\nExecuting the LOCK INSTANCE FOR BACKUP statement requires the\\nBACKUP_ADMIN privilege. The BACKUP_ADMI"
  "N privilege is automatically\\ngranted to users with the RELOAD privilege when performing an in-place\\nupgrade to MySQ"
  "L 8.4 from an earlier version.\\n\\nMultiple sessions can hold a backup lock simultaneously.\\n\\nUNLOCK INSTANCE release"
  "s a backup lock held by the current session. A\\nbackup lock held by a session is also released if the session is\\nter"
  "minated.\\n\\nLOCK INSTANCE FOR BACKUP prevents files from being created, renamed, or\\nremoved. REPAIR TABLE TRUNCATE T"
  "ABLE, OPTIMIZE TABLE, and account\\nmanagement statements are blocked. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/ac"
  "count-management-statements.html\\n. Operations that modify InnoDB files that are not recorded in the\\nInnoDB redo log"
  " are also blocked.\\n\\nLOCK INSTANCE FOR BACKUP permits DDL operations that only affect\\nuser-created temporary tables"
  ". In effect, files that belong to\\nuser-created temporary tables can be created, renamed, or removed while\\na backup "
  "lock is held. Creation of binary log files is also permitted.\\n\\nPURGE BINARY LOGS cannot be issued while a LOCK INST"
  "ANCE FOR BACKUP\\nstatement is in effect for the instance, because it contravenes the\\nrules of the backup lock by rem"
  "oving files from the server.\\n\\nA backup lock acquired by LOCK INSTANCE FOR BACKUP is independent of\\ntransactional l"
  "ocks and locks taken by FLUSH TABLES tbl_name [,\\ntbl_name] ... WITH READ LOCK, and the following sequences of statem"
  "ents\\nare permitted:\\n\\nLOCK INSTANCE FOR BACKUP;\\nFLUSH TABLES tbl_name [, tbl_name] ... WITH READ LOCK;\\nUNLOCK TAB"
  "LES;\\nUNLOCK INSTANCE;\\n\\nFLUSH TABLES tbl_name [, tbl_name] ... WITH READ LOCK;\\nLOCK INSTANCE FOR BACKUP;\\nUNLOCK I"
  "NSTANCE;\\nUNLOCK TABLES;\\n\\nThe lock_wait_timeout setting defines the amount of time that a LOCK\\nINSTANCE FOR BACKUP"
  " statement waits to acquire a lock before giving up.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/lock-instance-fo"
  "r-backup.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/lock-instance-for-backup.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (569,42,'LOCK TABLES','Synta"
  "x:\\nLOCK {TABLE | TABLES}\\n    tbl_name [[AS] alias] lock_type\\n    [, tbl_name [[AS] alias] lock_type] ...\\n\\nlock_t"
  "ype: {\\n    READ [LOCAL]\\n  | WRITE\\n}\\n\\nUNLOCK {TABLE | TABLES}\\n\\nMySQL enables client sessions to acquire table l"
  "ocks explicitly for the\\npurpose of cooperating with other sessions for access to tables, or to\\nprevent other sessio"
  "ns from modifying tables during periods when a\\nsession requires exclusive access to them. A session can acquire or\\n"
  "release locks only for itself. One session cannot acquire locks for\\nanother session or release locks held by another"
  " session.\\n\\nLocks may be used to emulate transactions or to get more speed when\\nupdating tables. This is explained "
  "in more detail in\\nhttps://dev.mysql.com/doc/refman/8.4/en/lock-tables.html#lock-tables-re\\nstrictions.\\n\\nLOCK TABLE"
  "S explicitly acquires table locks for the current client\\nsession. Table locks can be acquired for base tables or vie"
  "ws. You must\\nhave the LOCK TABLES privilege, and the SELECT privilege for each\\nobject to be locked.\\n\\nFor view loc"
  "king, LOCK TABLES adds all base tables used in the view to\\nthe set of tables to be locked and locks them automatical"
  "ly. For tables\\nunderlying any view being locked, LOCK TABLES checks that the view\\ndefiner (for SQL SECURITY DEFINER"
  " views) or invoker (for all views) has\\nthe proper privileges on the tables.\\n\\nIf you lock a table explicitly with L"
  "OCK TABLES, any tables used in\\ntriggers are also locked implicitly, as described in\\nhttps://dev.mysql.com/doc/refma"
  "n/8.4/en/lock-tables.html#lock-tables-an\\nd-triggers.\\n\\nIf you lock a table explicitly with LOCK TABLES, any tables "
  "related by\\na foreign key constraint are opened and locked implicitly. For foreign\\nkey checks, a shared read-only lo"
  "ck (LOCK TABLES READ) is taken on\\nrelated tables. For cascading updates, a shared-nothing write lock\\n(LOCK TABLES W"
  "RITE) is taken on related tables that are involved in the\\noperation.\\n\\nUNLOCK TABLES explicitly releases any table "
  "locks held by the current\\nsession. LOCK TABLES implicitly releases any table locks held by the\\ncurrent session befo"
  "re acquiring new locks.\\n\\nAnother use for UNLOCK TABLES is to release the global read lock\\nacquired with the FLUSH "
  "TABLES WITH READ LOCK statement, which enables\\nyou to lock all tables in all databases. See [HELP FLUSH]. (This is a"
  "\\nvery convenient way to get backups if you have a file system such as\\nVeritas that can take snapshots in time.)\\n\\n"
  "LOCK TABLE is a synonym for LOCK TABLES; UNLOCK TABLE is a synonym for\\nUNLOCK TABLES.\\n\\nURL: https://dev.mysql.com/"
  "doc/refman/8.4/en/lock-tables.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/lock-tables.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (570,42,'SET TRANSACTION','S"
  "yntax:\\nSET [GLOBAL | SESSION] TRANSACTION\\n    transaction_characteristic [, transaction_characteristic] ...\\n\\ntran"
  "saction_characteristic: {\\n    ISOLATION LEVEL level\\n  | access_mode\\n}\\n\\nlevel: {\\n     REPEATABLE READ\\n   | READ"
  " COMMITTED\\n   | READ UNCOMMITTED\\n   | SERIALIZABLE\\n}\\n\\naccess_mode: {\\n     READ WRITE\\n   | READ ONLY\\n}\\n\\nThis"
  " statement specifies transaction characteristics. It takes a list\\nof one or more characteristic values separated by "
  "commas. Each\\ncharacteristic value sets the transaction isolation level or access\\nmode. The isolation level is used "
  "for operations on InnoDB tables. The\\naccess mode specifies whether transactions operate in read/write or\\nread-only "
  "mode.\\n\\nIn addition, SET TRANSACTION can include an optional GLOBAL or SESSION\\nkeyword to indicate the scope of the"
  " statement.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/set-transaction.html\\n\\n','','https://dev.mysql.com/doc/r"
  "efman/8.4/en/set-transaction.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (571,42,'XA','Syntax:\\nXA {S"
  "TART|BEGIN} xid [JOIN|RESUME]\\n\\nXA END xid [SUSPEND [FOR MIGRATE]]\\n\\nXA PREPARE xid\\n\\nXA COMMIT xid [ONE PHASE]\\n\\"
  "nXA ROLLBACK xid\\n\\nXA RECOVER [CONVERT XID]\\n\\nFor XA START, the JOIN and RESUME clauses are recognized but have no\\"
  "neffect.\\n\\nFor XA END the SUSPEND [FOR MIGRATE] clause is recognized but has no\\neffect.\\n\\nEach XA statement begins"
  " with the XA keyword, and most of them require\\nan xid value. An xid is an XA transaction identifier. It indicates\\nw"
  "hich transaction the statement applies to. xid values are supplied by\\nthe client, or generated by the MySQL server. "
  "An xid value has from one\\nto three parts:\\n\\nxid: gtrid [, bqual [, formatID ]]\\n\\ngtrid is a global transaction ide"
  "ntifier, bqual is a branch qualifier,\\nand formatID is a number that identifies the format used by the gtrid\\nand bqu"
  "al values. As indicated by the syntax, bqual and formatID are\\noptional. The default bqual value is \\'\\' if not given"
  ". The default\\nformatID value is 1 if not given.\\n\\ngtrid and bqual must be string literals, each up to 64 bytes (not"
  "\\ncharacters) long. gtrid and bqual can be specified in several ways. You\\ncan use a quoted string (\\'ab\\'), hex stri"
  "ng (X\\'6162\\', 0x6162), or bit\\nvalue (b\\'nnnn\\').\\n\\nformatID is an unsigned integer.\\n\\nThe gtrid and bqual values "
  "are interpreted in bytes by the MySQL\\nserver\\'s underlying XA support routines. However, while an SQL\\nstatement con"
  "taining an XA statement is being parsed, the server works\\nwith some specific character set. To be safe, write gtrid "
  "and bqual as\\nhex strings.\\n\\nxid values typically are generated by the Transaction Manager. Values\\ngenerated by one"
  " TM must be different from values generated by other\\nTMs. A given TM must be able to recognize its own xid values in"
  " a list\\nof values returned by the XA RECOVER statement.\\n\\nXA START xid starts an XA transaction with the given xid "
  "value. Each XA\\ntransaction must have a unique xid value, so the value must not\\ncurrently be used by another XA tran"
  "saction. Uniqueness is assessed\\nusing the gtrid and bqual values. All following XA statements for the\\nXA transactio"
  "n must be specified using the same xid value as that given\\nin the XA START statement. If you use any of those statem"
  "ents but\\nspecify an xid value that does not correspond to some existing XA\\ntransaction, an error occurs.\\n\\nXA STAR"
  "T, XA BEGIN, XA END, XA COMMIT, and XA ROLLBACK statements are\\nnot filtered by the default database when the server "
  "is running with\\n--replicate-do-db or --replicate-ignore-db.\\n\\nOne or more XA transactions can be part of the same g"
  "lobal transaction.\\nAll XA transactions within a given global transaction must use the same\\ngtrid value in the xid v"
  "alue. For this reason, gtrid values must be\\nglobally unique so that there is no ambiguity about which global\\ntransa"
  "ction a given XA transaction is part of. The bqual part of the\\nxid value must be different for each XA transaction w"
  "ithin a global\\ntransaction. (The requirement that bqual values be different is a\\nlimitation of the current MySQL XA"
  " implementation. It is not part of\\nthe XA specification.)\\n\\nThe XA RECOVER statement returns information for those "
  "XA transactions\\non the MySQL server that are in the PREPARED state. (See\\nhttps://dev.mysql.com/doc/refman/8.4/en/xa"
  "-states.html.) The output\\nincludes a row for each such XA transaction on the server, regardless\\nof which client sta"
  "rted it.\\n\\nXA RECOVER requires the XA_RECOVER_ADMIN privilege. This privilege\\nrequirement prevents users from disco"
  "vering the XID values for\\noutstanding prepared XA transactions other than their own. It does not\\naffect normal comm"
  "it or rollback of an XA transaction because the user\\nwho started it knows its XID.\\n\\nXA RECOVER output rows look li"
  "ke this (for an example xid value\\nconsisting of the parts \\'abc\\', \\'def\\', and 7):\\n\\nmysql> XA RECOVER;\\n+--------"
  "--+--------------+--------------+--------+\\n| formatID | gtrid_length | bqual_length | data   |\\n+----------+--------"
  "------+--------------+--------+\\n|        7 |            3 |            3 | abcdef |\\n+----------+--------------+----"
  "----------+--------+\\n\\nThe output columns have the following meanings:\\n\\no formatID is the formatID part of the tra"
  "nsaction xid\\n\\no gtrid_length is the length in bytes of the gtrid part of the xid\\n\\no bqual_length is the length in"
  " bytes of the bqual part of the xid\\n\\no data is the concatenation of the gtrid and bqual parts of the xid\\n\\nXID val"
  "ues may contain nonprintable characters. XA RECOVER permits an\\noptional CONVERT XID clause so that clients can reque"
  "st XID values in\\nhexadecimal.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/xa-statements.html\\n\\n','','https://de"
  "v.mysql.com/doc/refman/8.4/en/xa-statements.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (572,43,'PURGE BINARY LOGS',"
  "'Syntax:\\nPURGE BINARY LOGS {\\n    TO \\'log_name\\'\\n  | BEFORE datetime_expr\\n}\\n\\nThe binary log is a set of files t"
  "hat contain information about data\\nmodifications made by the MySQL server. The log consists of a set of\\nbinary log "
  "files, plus an index file (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/binary-log.html).\\n\\nThe PURGE BINARY LOGS st"
  "atement deletes all the binary log files listed\\nin the log index file prior to the specified log file name or date.\\"
  "nDeleted log files also are removed from the list recorded in the index\\nfile, so that the given log file becomes the"
  " first in the list.\\n\\nPURGE BINARY LOGS requires the BINLOG_ADMIN privilege. This statement\\nhas no effect if the se"
  "rver was not started with the --log-bin option\\nto enable binary logging.\\n\\nURL: https://dev.mysql.com/doc/refman/8."
  "4/en/purge-binary-logs.html\\n\\n','PURGE BINARY LOGS TO \\'mysql-bin.010\\';\\nPURGE BINARY LOGS BEFORE \\'2019-04-02 22:4"
  "6:26\\';\\n','https://dev.mysql.com/doc/refman/8.4/en/purge-binary-logs.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (573,43,'RESET BINARY LOGS A"
  "ND GTIDS','Syntax:\\nRESET BINARY LOGS AND GTIDS [TO binary_log_file_index_number]\\n\\n*Warning*:\\n\\nUse this statement"
  " with caution to ensure you do not lose any wanted\\nbinary log file data and GTID execution history.\\n\\nRESET BINARY "
  "LOGS AND GTIDS requires the RELOAD privilege.\\n\\nFor a server where binary logging is enabled (log_bin is ON), RESET\\"
  "nBINARY LOGS AND GTIDS deletes all existing binary log files and resets\\nthe binary log index file, resetting the ser"
  "ver to its state before\\nbinary logging was started. A new empty binary log file is created so\\nthat binary logging c"
  "an be restarted.\\n\\nFor a server where GTIDs are in use (gtid_mode is ON), issuing RESET\\nBINARY LOGS AND GTIDS reset"
  "s the GTID execution history. The value of\\nthe gtid_purged system variable is set to an empty string (\\'\\'), the\\ngl"
  "obal value (but not the session value) of the gtid_executed system\\nvariable is set to an empty string, and the mysql"
  ".gtid_executed table\\nis cleared (see\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-gtids-concepts.html\\n#repl"
  "ication-gtids-gtid-executed-table). If the GTID-enabled server has\\nbinary logging enabled, RESET BINARY LOGS AND GTI"
  "DS also resets the\\nbinary log as described above. Note that RESET BINARY LOGS AND GTIDS is\\nthe method to reset the "
  "GTID execution history even if the GTID-enabled\\nserver is a replica where binary logging is disabled; RESET REPLICA "
  "has\\nno effect on the GTID execution history. For more information on\\nresetting the GTID execution history, see\\nhtt"
  "ps://dev.mysql.com/doc/refman/8.4/en/replication-gtids-lifecycle.html\\n#replication-gtids-execution-history.\\n\\nIssui"
  "ng RESET BINARY LOGS AND GTIDS without the optional TO clause\\ndeletes all binary log files listed in the index file,"
  " resets the\\nbinary log index file to be empty, and creates a new binary log file\\nstarting at 1. Use the optional TO"
  " clause to start the binary log file\\nindex from a number other than 1 after the reset.\\n\\nCheck that you are using a"
  " reasonable value for the index number. If\\nyou enter an incorrect value, you can correct this by issuing another\\nRE"
  "SET BINARY LOGS AND GTIDS statement with or without the TO clause. If\\nyou do not correct a value that is out of rang"
  "e, the server cannot be\\nrestarted.\\n\\nThe following example demonstrates TO clause usage:\\n\\nRESET BINARY LOGS AND G"
  "TIDS TO 1234;\\n\\nSHOW BINARY LOGS;\\n+-------------------+-----------+-----------+\\n| Log_name          | File_size | "
  "Encrypted |\\n+-------------------+-----------+-----------+\\n| source-bin.001234 |       154 | No        |\\n+---------"
  "----------+-----------+-----------+\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/reset-binary-logs-and-gtids.html\\"
  "n\\n','','https://dev.mysql.com/doc/refman/8.4/en/reset-binary-logs-and-gtids.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (574,43,'SET SQL_LOG_BIN','S"
  "yntax:\\nSET sql_log_bin = {OFF|ON}\\n\\nThe sql_log_bin variable controls whether logging to the binary log is\\nenabled"
  " for the current session (assuming that the binary log itself is\\nenabled). The default value is ON. To disable or en"
  "able binary logging\\nfor the current session, set the session sql_log_bin variable to OFF or\\nON.\\n\\nSet this variabl"
  "e to OFF for a session to temporarily disable binary\\nlogging while making changes to the source that you do not want"
  "\\nreplicated to the replica.\\n\\nSetting the session value of this system variable is a restricted\\noperation. The ses"
  "sion user must have privileges sufficient to set\\nrestricted session variables. See\\nhttps://dev.mysql.com/doc/refman"
  "/8.4/en/system-variable-privileges.html\\n.\\n\\nIt is not possible to set the session value of sql_log_bin within a\\ntr"
  "ansaction or subquery.\\n\\nSetting this variable to OFF prevents new GTIDs from being assigned to\\ntransactions in the"
  " binary log. If you are using GTIDs for replication,\\nthis means that even when binary logging is later enabled again"
  ", the\\nGTIDs written into the log from this point do not account for any\\ntransactions that occurred in the meantime,"
  " so in effect those\\ntransactions are lost.\\n\\nmysqldump adds a SET @@SESSION.sql_log_bin=0 statement to a dump file\\"
  "nfrom a server where GTIDs are in use, which disables binary logging\\nwhile the dump file is being reloaded. The stat"
  "ement prevents new GTIDs\\nfrom being generated and assigned to the transactions in the dump file\\nas they are execute"
  "d, so that the original GTIDs for the transactions\\nare used.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/set-sql"
  "-log-bin.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/set-sql-log-bin.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (575,43,'CHANGE REPLICATION "
  "FILTER','Syntax:\\nCHANGE REPLICATION FILTER filter[, filter]\\n	[, ...] [FOR CHANNEL channel]\\n\\nfilter: {\\n    REPLIC"
  "ATE_DO_DB = (db_list)\\n  | REPLICATE_IGNORE_DB = (db_list)\\n  | REPLICATE_DO_TABLE = (tbl_list)\\n  | REPLICATE_IGNORE"
  "_TABLE = (tbl_list)\\n  | REPLICATE_WILD_DO_TABLE = (wild_tbl_list)\\n  | REPLICATE_WILD_IGNORE_TABLE = (wild_tbl_list)"
  "\\n  | REPLICATE_REWRITE_DB = (db_pair_list)\\n}\\n\\ndb_list:\\n    db_name[, db_name][, ...]\\n\\ntbl_list:\\n    db_name.t"
  "able_name[, db_name.table_name][, ...]\\nwild_tbl_list:\\n    \\'db_pattern.table_pattern\\'[, \\'db_pattern.table_pattern"
  "\\'][, ...]\\n\\ndb_pair_list:\\n    (db_pair)[, (db_pair)][, ...]\\n\\ndb_pair:\\n    from_db, to_db\\n\\nCHANGE REPLICATION "
  "FILTER sets one or more replication filtering rules\\non the replica in the same way as starting the replica mysqld wi"
  "th\\nreplication filtering options such as --replicate-do-db or\\n--replicate-wild-ignore-table. Filters set using this"
  " statement differ\\nfrom those set using the server options in two key respects:\\n\\n1. The statement does not require "
  "restarting the server to take effect,\\n   only that the replication SQL thread be stopped using STOP REPLICA\\n   SQL_"
  "THREAD first (and restarted with START REPLICA SQL_THREAD\\n   afterwards).\\n\\n2. The effects of the statement are not"
  " persistent; any filters set\\n   using CHANGE REPLICATION FILTER are lost following a restart of the\\n   replica mysq"
  "ld.\\n\\nCHANGE REPLICATION FILTER requires the REPLICATION_SLAVE_ADMIN\\nprivilege (or the deprecated SUPER privilege)."
  "\\n\\nUse the FOR CHANNEL channel clause to make a replication filter\\nspecific to a replication channel, for example o"
  "n a multi-source\\nreplica. Filters applied without a specific FOR CHANNEL clause are\\nconsidered global filters, mean"
  "ing that they are applied to all\\nreplication channels.\\n\\nGlobal replication filters cannot be set on a MySQL server"
  " instance\\nthat is configured for Group Replication, because filtering\\ntransactions on some servers would make the g"
  "roup unable to reach\\nagreement on a consistent state. Channel specific replication filters\\ncan be set on replicatio"
  "n channels that are not directly involved with\\nGroup Replication, such as where a group member also acts as a replic"
  "a\\nto a source that is outside the group. They cannot be set on the\\ngroup_replication_applier or group_replication_r"
  "ecovery channels.\\n\\nThe following list shows the CHANGE REPLICATION FILTER options and how\\nthey relate to --replica"
  "te-* server options:\\n\\no REPLICATE_DO_DB: Include updates based on database name. Equivalent\\n  to --replicate-do-db"
  ".\\n\\no REPLICATE_IGNORE_DB: Exclude updates based on database name.\\n  Equivalent to --replicate-ignore-db.\\n\\no REPL"
  "ICATE_DO_TABLE: Include updates based on table name. Equivalent\\n  to --replicate-do-table.\\n\\no REPLICATE_IGNORE_TAB"
  "LE: Exclude updates based on table name.\\n  Equivalent to --replicate-ignore-table.\\n\\no REPLICATE_WILD_DO_TABLE: Inc"
  "lude updates based on wildcard pattern\\n  matching table name. Equivalent to --replicate-wild-do-table.\\n\\no REPLICAT"
  "E_WILD_IGNORE_TABLE: Exclude updates based on wildcard\\n  pattern matching table name. Equivalent to\\n  --replicate-w"
  "ild-ignore-table.\\n\\no REPLICATE_REWRITE_DB: Perform updates on replica after substituting\\n  new name on replica for"
  " specified database on source. Equivalent to\\n  --replicate-rewrite-db.\\n\\nThe precise effects of REPLICATE_DO_DB and"
  " REPLICATE_IGNORE_DB filters\\nare dependent on whether statement-based or row-based replication is in\\neffect. See\\nh"
  "ttps://dev.mysql.com/doc/refman/8.4/en/replication-rules.html, for\\nmore information.\\n\\nMultiple replication filteri"
  "ng rules can be created in a single CHANGE\\nREPLICATION FILTER statement by separating the rules with commas, as\\nsho"
  "wn here:\\n\\nCHANGE REPLICATION FILTER\\n    REPLICATE_DO_DB = (d1), REPLICATE_IGNORE_DB = (d2);\\n\\nIssuing the stateme"
  "nt just shown is equivalent to starting the replica\\nmysqld with the options --replicate-do-db=d1 --replicate-ignore-"
  "db=d2.\\n\\nOn a multi-source replica, which uses multiple replication channels to\\nprocess transaction from different "
  "sources, use the FOR CHANNEL channel\\nclause to set a replication filter on a replication channel:\\n\\nCHANGE REPLICAT"
  "ION FILTER REPLICATE_DO_DB = (d1) FOR CHANNEL channel_1;\\n\\nThis enables you to create a channel specific replication"
  " filter to\\nfilter out selected data from a source. When a FOR CHANNEL clause is\\nprovided, the replication filter st"
  "atement acts on that replication\\nchannel, removing any existing replication filter which has the same\\nfilter type a"
  "s the specified replication filters, and replacing them\\nwith the specified filter. Filter types not explicitly liste"
  "d in the\\nstatement are not modified. If issued against a replication channel\\nwhich is not configured, the statement"
  " fails with an\\nER_SLAVE_CONFIGURATION error. If issued against Group Replication\\nchannels, the statement fails with"
  " an\\nER_SLAVE_CHANNEL_OPERATION_NOT_ALLOWED error.\\n\\nOn a replica with multiple replication channels configured, iss"
  "uing\\nCHANGE REPLICATION FILTER with no FOR CHANNEL clause configures the\\nreplication filter for every configured re"
  "plication channel, and for\\nthe global replication filters. For every filter type, if the filter\\ntype is listed in t"
  "he statement, then any existing filter rules of that\\ntype are replaced by the filter rules specified in the most rec"
  "ently\\nissued statement, otherwise the old value of the filter type is\\nretained. For more information see\\nhttps://d"
  "ev.mysql.com/doc/refman/8.4/en/replication-rules-channel-based\\n-filters.html.\\n\\nIf the same filtering rule is speci"
  "fied multiple times, only the last\\nsuch rule is actually used. For example, the two statements shown here\\nhave exac"
  "tly the same effect, because the first REPLICATE_DO_DB rule in\\nthe first statement is ignored:\\n\\nCHANGE REPLICATION"
  " FILTER\\n    REPLICATE_DO_DB = (db1, db2), REPLICATE_DO_DB = (db3, db4);\\n\\nCHANGE REPLICATION FILTER\\n    REPLICATE_"
  "DO_DB = (db3, db4);\\n\\n*Caution*:\\n\\nThis behavior differs from that of the --replicate-* filter options\\nwhere speci"
  "fying the same option multiple times causes the creation of\\nmultiple filter rules.\\n\\nNames of tables and database n"
  "ot containing any special characters need\\nnot be quoted. Values used with REPLICATION_WILD_TABLE and\\nREPLICATION_WI"
  "LD_IGNORE_TABLE are string expressions, possibly\\ncontaining (special) wildcard characters, and so must be quoted. Th"
  "is\\nis shown in the following example statements:\\n\\nCHANGE REPLICATION FILTER\\n    REPLICATE_WILD_DO_TABLE = (\\'db1."
  "old%\\');\\n\\nCHANGE REPLICATION FILTER\\n    REPLICATE_WILD_IGNORE_TABLE = (\\'db1.new%\\', \\'db2.new%\\');\\n\\nValues used"
  " with REPLICATE_REWRITE_DB represent pairs of database\\nnames; each such value must be enclosed in parentheses. The f"
  "ollowing\\nstatement rewrites statements occurring on database db1 on the source\\nto database db2 on the replica:\\n\\nC"
  "HANGE REPLICATION FILTER REPLICATE_REWRITE_DB = ((db1, db2));\\n\\nThe statement just shown contains two sets of parent"
  "heses, one\\nenclosing the pair of database names, and the other enclosing the\\nentire list. This is perhaps more easi"
  "ly seen in the following example,\\nwhich creates two rewrite-db rules, one rewriting database dbA to dbB,\\nand one re"
  "writing database dbC to dbD:\\n\\nCHANGE REPLICATION FILTER\\n  REPLICATE_REWRITE_DB = ((dbA, dbB), (dbC, dbD));\\n\\nThe "
  "CHANGE REPLICATION FILTER statement replaces replication filtering\\nrules only for the filter types and replication c"
  "hannels affected by\\nthe statement, and leaves other rules and channels unchanged. If you\\nwant to unset all filters "
  "of a given type, set the filter\\'s value to an\\nexplicitly empty list, as shown in this example, which removes all\\ne"
  "xisting REPLICATE_DO_DB and REPLICATE_IGNORE_DB rules:\\n\\nCHANGE REPLICATION FILTER\\n    REPLICATE_DO_DB = (), REPLIC"
  "ATE_IGNORE_DB = ();\\n\\nSetting a filter to empty in this way removes all existing rules, does\\nnot create any new one"
  "s, and does not restore any rules set at mysqld\\nstartup using --replicate-* options on the command line or in the\\nc"
  "onfiguration file.\\n\\nThe RESET REPLICA ALL statement removes channel specific replication\\nfilters that were set on "
  "channels deleted by the statement. When the\\ndeleted channel or channels are recreated, any global replication\\nfilte"
  "rs specified for the replica are copied to them, and no channel\\nspecific replication filters are applied.\\n\\nFor mor"
  "e information, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-rules.html.\\n\\nURL: https://dev.mysql.com/doc"
  "/refman/8.4/en/change-replication-filter.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/change-replication-fil"
  "ter.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (576,43,'CHANGE REPLICATION "
  "SOURCE TO','Syntax:\\nCHANGE REPLICATION SOURCE TO option [, option] ... [ channel_option ]\\n\\noption: {\\n    SOURCE_B"
  "IND = \\'interface_name\\'\\n  | SOURCE_HOST = \\'host_name\\'\\n  | SOURCE_USER = \\'user_name\\'\\n  | SOURCE_PASSWORD = \\'p"
  "assword\\'\\n  | SOURCE_PORT = port_num\\n  | PRIVILEGE_CHECKS_USER = {NULL | \\'account\\'}\\n  | REQUIRE_ROW_FORMAT = {0|"
  "1}\\n  | REQUIRE_TABLE_PRIMARY_KEY_CHECK = {STREAM | ON | OFF | GENERATE}\\n  | ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS "
  "= {OFF | LOCAL | uuid}\\n  | SOURCE_LOG_FILE = \\'source_log_name\\'\\n  | SOURCE_LOG_POS = source_log_pos\\n  | SOURCE_AU"
  "TO_POSITION = {0|1}\\n  | RELAY_LOG_FILE = \\'relay_log_name\\'\\n  | RELAY_LOG_POS = relay_log_pos\\n  | SOURCE_HEARTBEAT"
  "_PERIOD = interval\\n  | SOURCE_CONNECT_RETRY = interval\\n  | SOURCE_RETRY_COUNT = count\\n  | SOURCE_CONNECTION_AUTO_F"
  "AILOVER = {0|1}\\n  | SOURCE_DELAY = interval\\n  | SOURCE_COMPRESSION_ALGORITHMS = \\'algorithm[,algorithm][,algorithm]"
  "\\'\\n  | SOURCE_ZSTD_COMPRESSION_LEVEL = level\\n  | SOURCE_SSL = {0|1}\\n  | SOURCE_SSL_CA = \\'ca_file_name\\'\\n  | SOUR"
  "CE_SSL_CAPATH = \\'ca_directory_name\\'\\n  | SOURCE_SSL_CERT = \\'cert_file_name\\'\\n  | SOURCE_SSL_CRL = \\'crl_file_name"
  "\\'\\n  | SOURCE_SSL_CRLPATH = \\'crl_directory_name\\'\\n  | SOURCE_SSL_KEY = \\'key_file_name\\'\\n  | SOURCE_SSL_CIPHER = "
  "\\'cipher_list\\'\\n  | SOURCE_SSL_VERIFY_SERVER_CERT = {0|1}\\n  | SOURCE_TLS_VERSION = \\'protocol_list\\'\\n  | SOURCE_TL"
  "S_CIPHERSUITES = \\'ciphersuite_list\\'\\n  | SOURCE_PUBLIC_KEY_PATH = \\'key_file_name\\'\\n  | GET_SOURCE_PUBLIC_KEY = {0"
  "|1}\\n  | NETWORK_NAMESPACE = \\'namespace\\'\\n  | IGNORE_SERVER_IDS = (server_id_list),\\n  | GTID_ONLY = {0|1}\\n}\\n\\nch"
  "annel_option:\\n    FOR CHANNEL channel\\n\\nserver_id_list:\\n    [server_id [, server_id] ... ]\\n\\nCHANGE REPLICATION S"
  "OURCE TO changes the parameters that the replica\\nserver uses for connecting to the source and reading data from the\\"
  "nsource. It also updates the contents of the replication metadata\\nrepositories (see\\nhttps://dev.mysql.com/doc/refma"
  "n/8.4/en/replica-logs.html).\\n\\nCHANGE REPLICATION SOURCE TO requires the REPLICATION_SLAVE_ADMIN\\nprivilege (or the "
  "deprecated SUPER privilege).\\n\\nOptions that you do not specify on a CHANGE REPLICATION SOURCE TO\\nstatement retain t"
  "heir value, except as indicated in the following\\ndiscussion. In most cases, there is therefore no need to specify\\no"
  "ptions that do not change.\\n\\nValues used for SOURCE_HOST and other CHANGE REPLICATION SOURCE TO\\noptions are checked"
  " for linefeed (\\\\n or 0x0A) characters. The presence\\nof such characters in these values causes the statement to fail"
  " with an\\nerror.\\n\\nThe optional FOR CHANNEL channel clause lets you name which replication\\nchannel the statement ap"
  "plies to. Providing a FOR CHANNEL channel\\nclause applies the CHANGE REPLICATION SOURCE TO statement to a specific\\nr"
  "eplication channel, and is used to add a new channel or modify an\\nexisting channel. For example, to add a new channe"
  "l called channel2:\\n\\nCHANGE REPLICATION SOURCE TO SOURCE_HOST=host1, SOURCE_PORT=3002 FOR CHANNEL \\'channel2\\';\\n\\nI"
  "f no clause is named and no extra channels exist, a CHANGE REPLICATION\\nSOURCE TO statement applies to the default ch"
  "annel, whose name is the\\nempty string (\"\"). When you have set up multiple replication channels,\\nevery CHANGE REPL"
  "ICATION SOURCE TO statement must name a channel using\\nthe FOR CHANNEL channel clause. See\\nhttps://dev.mysql.com/doc"
  "/refman/8.4/en/replication-channels.html for\\nmore information.\\n\\nFor some of the options of the CHANGE REPLICATION "
  "SOURCE TO statement,\\nyou must issue a STOP REPLICA statement prior to issuing a CHANGE\\nREPLICATION SOURCE TO statem"
  "ent (and a START REPLICA statement\\nafterwards). Sometimes, you only need to stop the replication SQL\\n(applier) thre"
  "ad or the replication I/O (receiver) thread, not both:\\n\\no When the applier thread is stopped, you can execute CHANG"
  "E\\n  REPLICATION SOURCE TO using any combination that is otherwise allowed\\n  of RELAY_LOG_FILE, RELAY_LOG_POS, and S"
  "OURCE_DELAY options, even if\\n  the replication receiver thread is running. No other options may be\\n  used with this"
  " statement when the receiver thread is running.\\n\\no When the receiver thread is stopped, you can execute CHANGE\\n  R"
  "EPLICATION SOURCE TO using any of the options for this statement (in\\n  any allowed combination) except RELAY_LOG_FIL"
  "E, RELAY_LOG_POS,\\n  SOURCE_DELAY, or SOURCE_AUTO_POSITION = 1 even when the applier\\n  thread is running.\\n\\no Both "
  "the receiver thread and the applier thread must be stopped\\n  before issuing a CHANGE REPLICATION SOURCE TO statement"
  " that employs\\n  SOURCE_AUTO_POSITION = 1, GTID_ONLY = 1, or\\n  ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS.\\n\\nYou can ch"
  "eck the current state of the replication applier thread and\\nreplication receiver thread using SHOW REPLICA STATUS. N"
  "ote that the\\nGroup Replication applier channel (group_replication_applier) has no\\nreceiver thread, only an applier "
  "thread.\\n\\nCHANGE REPLICATION SOURCE TO statements have a number of side-effects\\nand interactions that you should be"
  " aware of beforehand:\\n\\no CHANGE REPLICATION SOURCE TO causes an implicit commit of an ongoing\\n  transaction. See\\n"
  "  https://dev.mysql.com/doc/refman/8.4/en/implicit-commit.html.\\n\\no CHANGE REPLICATION SOURCE TO causes the previous"
  " values for\\n  SOURCE_HOST, SOURCE_PORT, SOURCE_LOG_FILE, and SOURCE_LOG_POS to be\\n  written to the error log, along"
  " with other information about the\\n  replica\\'s state prior to execution.\\n\\no If you are using statement-based repli"
  "cation and temporary tables, it\\n  is possible for a CHANGE REPLICATION SOURCE TO statement following a\\n  STOP REPLI"
  "CA statement to leave behind temporary tables on the\\n  replica. A warning (ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO\\n  "
  "(https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_warn_open_temp_tables_must_be"
  "_zero)) is issued\\n  whenever this occurs. You can avoid this in such cases by making sure\\n  that the value of the R"
  "eplica_open_temp_tables system status variable\\n  is equal to 0 prior to executing such a CHANGE REPLICATION SOURCE T"
  "O\\n  statement.\\n\\no When using a multithreaded replica (replica_parallel_workers > 0),\\n  stopping the replica can c"
  "ause gaps in the sequence of transactions\\n  that have been executed from the relay log, regardless of whether the\\n "
  " replica was stopped intentionally or otherwise. In MySQL 8.4, these\\n  can be resolved using GTID auto-positioning.\\"
  "n\\nThe following options are available for CHANGE REPLICATION SOURCE TO\\nstatements:\\n\\no ASSIGN_GTIDS_TO_ANONYMOUS_T"
  "RANSACTIONS = {OFF | LOCAL | uuid}\\n\\n  Makes the replication channel assign a GTID to replicated\\n  transactions tha"
  "t do not have one, enabling replication from a source\\n  that does not use GTID-based replication, to a replica that "
  "does. For\\n  a multi-source replica, you can have a mix of channels that use\\n  ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTION"
  "S, and channels that do not. The\\n  default is OFF, meaning that the feature is not used.\\n\\n  LOCAL assigns a GTID i"
  "ncluding the replica\\'s own UUID (the\\n  server_uuid setting). uuid assigns a GTID including the specified\\n  UUID, s"
  "uch as the server_uuid setting for the replication source\\n  server. Using a nonlocal UUID lets you differentiate bet"
  "ween\\n  transactions that originated on the replica and transactions that\\n  originated on the source, and for a mult"
  "i-source replica, between\\n  transactions that originated on different sources. The UUID you\\n  choose only has signi"
  "ficance for the replica\\'s own use. If any of the\\n  transactions sent by the source do have a GTID already, that GTI"
  "D is\\n  retained.\\n\\n  Channels specific to Group Replication cannot use\\n  ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS, b"
  "ut an asynchronous\\n  replication channel for another source on a server instance that is a\\n  Group Replication grou"
  "p member can do so. In that case, do not\\n  specify the Group Replication group name as the UUID for creating the\\n  "
  "GTIDs.\\n\\n  To set ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS to LOCAL or uuid, the\\n  replica must have gtid_mode=ON set"
  ", and this cannot be changed\\n  afterwards. This option is for use with a source that has binary log\\n  file position"
  " based replication, so SOURCE_AUTO_POSITION=1 cannot be\\n  set for the channel. Both the replication SQL thread and t"
  "he\\n  replication I/O (receiver) thread must be stopped before setting this\\n  option.\\n\\n  *Important*:\\n\\n  A repli"
  "ca set up with ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS on any\\n  channel cannot be promoted to replace the replication"
  " source server\\n  in the event that a failover is required, and a backup taken from the\\n  replica cannot be used to "
  "restore the replication source server. The\\n  same restriction applies to replacing or restoring other replicas\\n  th"
  "at use ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS on any channel.\\n\\n  For further restrictions and information, see\\n  h"
  "ttps://dev.mysql.com/doc/refman/8.4/en/replication-gtids-assign-anon\\n  .html.\\n\\no GET_SOURCE_PUBLIC_KEY = {0|1}\\n\\n"
  "  Enables RSA key pair-based password exchange by requesting the public\\n  key from the source. The option is disable"
  "d by default.\\n\\n  This option applies to replicas that authenticate with the\\n  caching_sha2_password authentication"
  " plugin. For connections by\\n  accounts that authenticate using this plugin, the source does not\\n  send the public k"
  "ey unless requested, so it must be requested or\\n  specified in the client. If SOURCE_PUBLIC_KEY_PATH is given and\\n "
  " specifies a valid public key file, it takes precedence over\\n  GET_SOURCE_PUBLIC_KEY. If you are using a replication"
  " user account\\n  that authenticates with the caching_sha2_password plugin (the\\n  default), and you are not using a s"
  "ecure connection, you must specify\\n  either this option or the SOURCE_PUBLIC_KEY_PATH option to provide\\n  the RSA p"
  "ublic key to the replica.\\n\\no GTID_ONLY = {0|1}\\n\\n  Stops the replication channel persisting file names and file\\n "
  " positions in the replication metadata repositories. GTID_ONLY is\\n  disabled by default for asynchronous replication"
  " channels, but is\\n  enabled by default for Group Replication channels, for which it\\n  cannot be disabled.\\n\\n  For "
  "replication channels with this setting, in-memory file positions\\n  are still tracked, and file positions can still b"
  "e observed for\\n  debugging purposes in error messages and through interfaces such as\\n  SHOW REPLICA STATUS statemen"
  "ts (where they are shown as being invalid\\n  if they are out of date). However, the writes and reads required to\\n  p"
  "ersist and check the file positions are avoided in situations where\\n  GTID-based replication does not actually requi"
  "re them, including the\\n  transaction queuing and application process.\\n\\n  This option can be used only if both the "
  "replication SQL (applier)\\n  thread and replication I/O (receiver) thread are stopped. To set\\n  GTID_ONLY = 1 for a "
  "replication channel, GTIDs must be in use on the\\n  server (gtid_mode = ON), and row-based binary logging must be in "
  "use\\n  on the source (statement-based replication is not supported). The\\n  options REQUIRE_ROW_FORMAT = 1 and SOURCE"
  "_AUTO_POSITION = 1 must be\\n  set for the replication channel.\\n\\n  When GTID_ONLY = 1 is set, the replica uses\\n  re"
  "plica_parallel_workers=1 if that system variable is set to zero for\\n  the server, so it is always technically a mult"
  "i-threaded applier.\\n  This is because a multi-threaded applier uses saved positions rather\\n  than the replication m"
  "etadata repositories to locate the start of a\\n  transaction that it needs to reapply.\\n\\n  If you disable GTID_ONLY "
  "after setting it, the existing relay logs\\n  are deleted and the existing known binary log file positions are\\n  pers"
  "isted, even if they are stale. The file positions for the binary\\n  log and relay log in the replication metadata rep"
  "ositories might be\\n  invalid, and a warning is returned if this is the case. Provided that\\n  SOURCE_AUTO_POSITION i"
  "s still enabled, GTID auto-positioning is used\\n  to provide the correct positioning.\\n\\n  If you also disable SOURCE"
  "_AUTO_POSITION, the file positions for the\\n  binary log and relay log in the replication metadata repositories are\\n"
  "  used for positioning if they are valid. If they are marked as\\n  invalid, you must provide a valid binary log file "
  "name and position\\n  (SOURCE_LOG_FILE and SOURCE_LOG_POS). If you also provide a relay log\\n  file name and position "
  "(RELAY_LOG_FILE and RELAY_LOG_POS), the relay\\n  logs are preserved and the applier position is set to the stated\\n  "
  "position. GTID auto-skip ensures that any transactions already\\n  applied are skipped even if the eventual applier po"
  "sition is not\\n  correct.\\n\\no IGNORE_SERVER_IDS = (server_id_list)\\n\\n  Makes the replica ignore events originating "
  "from the specified\\n  servers. The option takes a comma-separated list of 0 or more server\\n  IDs. Log rotation and d"
  "eletion events from the servers are not\\n  ignored, and are recorded in the relay log.\\n\\n  In circular replication, "
  "the originating server normally acts as the\\n  terminator of its own events, so that they are not applied more than\\n"
  "  once. Thus, this option is useful in circular replication when one of\\n  the servers in the circle is removed. Supp"
  "ose that you have a\\n  circular replication setup with 4 servers, having server IDs 1, 2, 3,\\n  and 4, and server 3 f"
  "ails. When bridging the gap by starting\\n  replication from server 2 to server 4, you can include\\n  IGNORE_SERVER_ID"
  "S = (3) in the CHANGE REPLICATION SOURCE TO statement\\n  that you issue on server 4 to tell it to use server 2 as its"
  " source\\n  instead of server 3. Doing so causes it to ignore and not to\\n  propagate any statements that originated w"
  "ith the server that is no\\n  longer in use.\\n\\n  If IGNORE_SERVER_IDS contains the server\\'s own ID and the server wa"
  "s\\n  started with the --replicate-same-server-id option enabled, an error\\n  results.\\n\\n  The source metadata reposi"
  "tory and the output of SHOW REPLICA STATUS\\n  provide the list of servers that are currently ignored. For more\\n  inf"
  "ormation, see\\n  https://dev.mysql.com/doc/refman/8.4/en/replica-logs-status.html, and\\n  [HELP SHOW REPLICA STATUS]."
  "\\n\\n  If a CHANGE REPLICATION SOURCE TO statement is issued without\\n  IGNORE_SERVER_IDS, any existing list is preser"
  "ved. To clear the list\\n  of ignored servers, it is necessary to use the option with an empty\\n  list, like this:\\n\\n"
  "CHANGE REPLICATION SOURCE TO IGNORE_SERVER_IDS = ();\\n\\n  RESET REPLICA ALL also clears IGNORE_SERVER_IDS.\\n\\n  When "
  "global transaction identifiers (GTIDs) are used for replication,\\n  transactions that have already been applied are a"
  "utomatically\\n  ignored. Because of this, IGNORE_SERVER_IDS is not compatible with\\n  gtid_mode=ON. If gtid_mode is O"
  "N, CHANGE REPLICATION SOURCE TO with a\\n  non-empty IGNORE_SERVER_IDS list is rejected with an error. Likewise,\\n  if"
  " any existing replication channel was created with a list of server\\n  IDs to be ignored, SET gtid_mode=ON is also re"
  "jected. Before starting\\n  GTID-based replication, check for and clear any ignored server ID\\n  lists on the servers "
  "involved; you can do this by checking the output\\n  from SHOW REPLICA STATUS. In such cases, you can clear the list b"
  "y\\n  issuing CHANGE REPLICATION SOURCE TO with an empty list of server IDs\\n  as shown previously.\\n\\no NETWORK_NAMES"
  "PACE = \\'namespace\\'\\n\\n  The network namespace to use for TCP/IP connections to the\\n  replication source server or,"
  " if the MySQL communication stack is in\\n  use, for Group Replication\\'s group communication connections. The\\n  maxi"
  "mum length of the string value is 64 characters. If this option\\n  is omitted, connections from the replica use the d"
  "efault (global)\\n  namespace. On platforms that do not implement network namespace\\n  support, failure occurs when th"
  "e replica attempts to connect to the\\n  source. For information about network namespaces, see\\n  https://dev.mysql.co"
  "m/doc/refman/8.4/en/network-namespace-support.htm\\n  l.\\n\\no PRIVILEGE_CHECKS_USER = {NULL | \\'account\\'}\\n\\n  Names "
  "a user account that supplies a security context for the\\n  specified channel. NULL, which is the default, means no se"
  "curity\\n  context is used.\\n\\n  The user name and host name for the user account must follow the\\n  syntax described "
  "in\\n  https://dev.mysql.com/doc/refman/8.4/en/account-names.html, and the\\n  user must not be an anonymous user (with"
  " a blank user name) or the\\n  CURRENT_USER. The account must have the REPLICATION_APPLIER\\n  privilege, plus the requ"
  "ired privileges to execute the transactions\\n  replicated on the channel. For details of the privileges required by\\n"
  "  the account, see\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-privilege-checks.\\n  html. When you restart"
  " the replication channel, the privilege checks\\n  are applied from that point on. If you do not specify a channel and"
  "\\n  no other channels exist, the statement is applied to the default\\n  channel.\\n\\n  The use of row-based binary log"
  "ging is strongly recommended when\\n  PRIVILEGE_CHECKS_USER is set, and you can set REQUIRE_ROW_FORMAT to\\n  enforce t"
  "his. For example, to start privilege checks on the channel\\n  channel_1 on a running replica, issue the following sta"
  "tements:\\n\\nSTOP REPLICA FOR CHANNEL \\'channel_1\\';\\n\\nCHANGE REPLICATION SOURCE TO\\n    PRIVILEGE_CHECKS_USER = \\'us"
  "er\\'@\\'host\\',\\n    REQUIRE_ROW_FORMAT = 1,\\n    FOR CHANNEL \\'channel_1\\';\\n\\nSTART REPLICA FOR CHANNEL \\'channel_1\\"
  "';\\n\\no RELAY_LOG_FILE = \\'relay_log_file\\' , RELAY_LOG_POS = \\'relay_log_pos\\'\\n\\n  The relay log file name, and the"
  " location in that file, at which the\\n  replication SQL thread begins reading from the replica\\'s relay log\\n  the ne"
  "xt time the thread starts. RELAY_LOG_FILE can use either an\\n  absolute or relative path, and uses the same base name"
  " as\\n  SOURCE_LOG_FILE. The maximum length of the string value is 511\\n  characters.\\n\\n  A CHANGE REPLICATION SOURCE"
  " TO statement using RELAY_LOG_FILE,\\n  RELAY_LOG_POS, or both options can be executed on a running replica\\n  when th"
  "e replication SQL (applier) thread is stopped. Relay logs are\\n  preserved if at least one of the replication applier"
  " thread and the\\n  replication I/O (receiver) thread is running. If both threads are\\n  stopped, all relay log files "
  "are deleted unless at least one of\\n  RELAY_LOG_FILE or RELAY_LOG_POS is specified. For the Group\\n  Replication appl"
  "ier channel (group_replication_applier), which only\\n  has an applier thread and no receiver thread, this is the case"
  " if the\\n  applier thread is stopped, but with that channel you cannot use the\\n  RELAY_LOG_FILE and RELAY_LOG_POS op"
  "tions.\\n\\no REQUIRE_ROW_FORMAT = {0|1}\\n\\n  Permits only row-based replication events to be processed by the\\n  repli"
  "cation channel. This option prevents the replication applier\\n  from taking actions such as creating temporary tables"
  " and executing\\n  LOAD DATA INFILE requests, which increases the security of the\\n  channel. The REQUIRE_ROW_FORMAT o"
  "ption is disabled by default for\\n  asynchronous replication channels, but it is enabled by default for\\n  Group Repl"
  "ication channels, and it cannot be disabled for them. For\\n  more information, see\\n  https://dev.mysql.com/doc/refma"
  "n/8.4/en/replication-privilege-checks.\\n  html.\\n\\no REQUIRE_TABLE_PRIMARY_KEY_CHECK = {STREAM | ON | OFF | GENERATE}"
  "\\n\\n  This option lets a replica set its own policy for primary key checks,\\n  as follows:\\n\\n  o ON: The replica set"
  "s sql_require_primary_key = ON; any replicated\\n    CREATE TABLE or ALTER TABLE statement must result in a table that"
  "\\n    contains a primary key.\\n\\n  o OFF: The replica sets sql_require_primary_key = OFF; no replicated\\n    CREATE T"
  "ABLE or ALTER TABLE statement is checked for the presence\\n    of a primary key.\\n\\n  o STREAM: The replica uses what"
  "ever value of sql_require_primary_key\\n    is replicated from the source for each transaction. This is the\\n    defau"
  "lt value, and the default behavior.\\n\\n  o GENERATE: Causes the replica to generate an invisible primary key\\n    for"
  " any InnoDB table that, as replicated, lacks a primary key. See\\n    https://dev.mysql.com/doc/refman/8.4/en/create-t"
  "able-gipks.html,\\n    for more information.\\n\\n    GENERATE is not compatible with Group Replication; you can use ON,"
  "\\n    OFF, or STREAM.\\n\\n  A divergence based on the presence of a generated invisible primary\\n  key solely on a sou"
  "rce or replica table is supported by MySQL\\n  Replication as long as the source supports GIPKs and the replica uses\\n"
  "  MySQL version 8.0.32 or later. If you use GIPKs on a replica with the\\n  source using an earlier version of MySQL, "
  "such divergences in schema,\\n  other than the extra GIPK on the replica, are not supported and may\\n  result in repli"
  "cation errors.\\n\\n  For multisource replication, setting REQUIRE_TABLE_PRIMARY_KEY_CHECK\\n  to ON or OFF lets the rep"
  "lica normalize behavior across replication\\n  channels for different sources, and to keep a consistent setting for\\n "
  " sql_require_primary_key. Using ON safeguards against the accidental\\n  loss of primary keys when multiple sources up"
  "date the same set of\\n  tables. Using OFF lets sources that can manipulate primary keys to\\n  work alongside sources "
  "that cannot.\\n\\n  In the case of multiple replicas, when\\n  REQUIRE_TABLE_PRIMARY_KEY_CHECK is set to GENERATE, the g"
  "enerated\\n  invisible primary key added by a given replica is independent of any\\n  such key added on any other repli"
  "ca. This means that, if generated\\n  invisible primary keys are in use, the values in the generated\\n  primary key co"
  "lumns on different replicas are not guaranteed to be\\n  the same. This may be an issue when failing over to such a re"
  "plica.\\n\\n  When PRIVILEGE_CHECKS_USER is NULL (the default), the user account\\n  does not need administration level "
  "privileges to set restricted\\n  session variables. Setting this option to a value other than NULL\\n  means that, when"
  " REQUIRE_TABLE_PRIMARY_KEY_CHECK is ON, OFF, or\\n  GENERATE, the user account does not require session administration"
  "\\n  level privileges to set restricted session variables such as\\n  sql_require_primary_key, avoiding the need to gra"
  "nt the account such\\n  privileges. For more information, see\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-p"
  "rivilege-checks.\\n  html.\\n\\no SOURCE_AUTO_POSITION = {0|1}\\n\\n  Makes the replica attempt to connect to the source u"
  "sing the\\n  auto-positioning feature of GTID-based replication, rather than a\\n  binary log file based position. This"
  " option is used to start a\\n  replica using GTID-based replication. The default is 0, meaning that\\n  GTID auto-posit"
  "ioning and GTID-based replication are not used. This\\n  option can be used with CHANGE REPLICATION SOURCE TO only if "
  "both the\\n  replication SQL (applier) thread and replication I/O (receiver)\\n  thread are stopped.\\n\\n  Both the repl"
  "ica and the source must have GTIDs enabled\\n  (GTID_MODE=ON, ON_PERMISSIVE, or OFF_PERMISSIVE on the replica, and\\n  "
  "GTID_MODE=ON on the source). SOURCE_LOG_FILE, SOURCE_LOG_POS,\\n  RELAY_LOG_FILE, and RELAY_LOG_POS cannot be specifie"
  "d together with\\n  SOURCE_AUTO_POSITION = 1. If multi-source replication is enabled on\\n  the replica, you need to se"
  "t the SOURCE_AUTO_POSITION = 1 option for\\n  each applicable replication channel.\\n\\n  With SOURCE_AUTO_POSITION = 1 "
  "set, in the initial connection\\n  handshake, the replica sends a GTID set containing the transactions\\n  that it has "
  "already received, committed, or both. The source responds\\n  by sending all transactions recorded in its binary log w"
  "hose GTID is\\n  not included in the GTID set sent by the replica. This exchange\\n  ensures that the source only sends"
  " the transactions with a GTID that\\n  the replica has not already recorded or committed. If the replica\\n  receives t"
  "ransactions from more than one source, as in the case of a\\n  diamond topology, the auto-skip function ensures that t"
  "he\\n  transactions are not applied twice. For details of how the GTID set\\n  sent by the replica is computed, see\\n  "
  "https://dev.mysql.com/doc/refman/8.4/en/replication-gtids-auto-positi\\n  oning.html.\\n\\n  If any of the transactions "
  "that should be sent by the source have\\n  been purged from the source\\'s binary log, or added to the set of\\n  GTIDs "
  "in the gtid_purged system variable by another method, the\\n  source sends the error ER_SOURCE_HAS_PURGED_REQUIRED_GTI"
  "DS\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_source_has_purged_requi"
  "red_gtids) to the replica, and\\n  replication does not start. The GTIDs of the missing purged\\n  transactions are ide"
  "ntified and listed in the source\\'s error log in\\n  the warning message ER_FOUND_MISSING_GTIDS\\n  (https://dev.mysql."
  "com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_found_missing_gtids). Also, if during the exchan"
  "ge of\\n  transactions it is found that the replica has recorded or committed\\n  transactions with the source\\'s UUID "
  "in the GTID, but the source\\n  itself has not committed them, the source sends the error\\n  ER_REPLICA_HAS_MORE_GTIDS"
  "_THAN_SOURCE\\n  (https://dev.mysql.com/doc/mysql-errors/8.4/en/server-error-reference\\n  .html#error_er_replica_has_m"
  "ore_gtids_than_source) to the replica and\\n  replication does not start. For information on how to handle these\\n  si"
  "tuations, see\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-gtids-auto-positi\\n  oning.html.\\n\\n  You can se"
  "e whether replication is running with GTID auto-positioning\\n  enabled by checking the Performance Schema\\n  replicat"
  "ion_connection_status table or the output of SHOW REPLICA\\n  STATUS. Disabling the SOURCE_AUTO_POSITION option again "
  "makes the\\n  replica revert to file-based replication.\\n\\no SOURCE_BIND = \\'interface_name\\'\\n\\n  Determines which of"
  " the replica\\'s network interfaces is chosen for\\n  connecting to the source, for use on replicas that have multiple\\"
  "n  network interfaces. Specify the IP address of the network interface.\\n  The maximum length of the string value is "
  "255 characters.\\n\\n  The IP address configured with this option, if any, can be seen in\\n  the Source_Bind column of "
  "the output from SHOW REPLICA STATUS. In the\\n  source metadata repository table mysql.slave_master_info, the value\\n "
  " can be seen as the Source_bind column. The ability to bind a replica\\n  to a specific network interface is also supp"
  "orted by NDB Cluster.\\n\\no SOURCE_COMPRESSION_ALGORITHMS = \\'algorithm[,algorithm][,algorithm]\\'\\n\\n  Specifies one, "
  "two, or three of the permitted compression algorithms\\n  for connections to the replication source server, separated "
  "by\\n  commas. The maximum length of the string value is 99 characters. The\\n  default value is uncompressed.\\n\\n  The"
  " available algorithms are zlib, zstd, and uncompressed, the same\\n  as for the protocol_compression_algorithms system"
  " variable. The\\n  algorithms can be specified in any order, but it is not an order of\\n  preference - the algorithm n"
  "egotiation process attempts to use zlib,\\n  then zstd, then uncompressed, if they are specified.\\n\\n  The value of SO"
  "URCE_COMPRESSION_ALGORITHMS applies only if the\\n  replica_compressed_protocol system variable is disabled. If\\n  rep"
  "lica_compressed_protocol is enabled, it takes precedence over\\n  SOURCE_COMPRESSION_ALGORITHMS and connections to the"
  " source use zlib\\n  compression if both source and replica support that algorithm. For\\n  more information, see\\n  ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/connection-compression-contro\\n  l.html.\\n\\n  Binary log transaction compressio"
  "n is activated by the\\n  binlog_transaction_compression system variable, and can also be used\\n  to save bandwidth. I"
  "f you do this in combination with connection\\n  compression, connection compression has less opportunity to act on\\n "
  " the data, but can still compress headers and those events and\\n  transaction payloads that are uncompressed. For mor"
  "e information on\\n  binary log transaction compression, see\\n  https://dev.mysql.com/doc/refman/8.4/en/binary-log-tra"
  "nsaction-compre\\n  ssion.html.\\n\\no SOURCE_CONNECT_RETRY = interval\\n\\n  Specifies the interval in seconds between th"
  "e reconnection attempts\\n  that the replica makes after the connection to the source times out.\\n  The default interv"
  "al is 60.\\n\\n  The number of attempts is limited by the SOURCE_RETRY_COUNT option.\\n  If both the default settings ar"
  "e used, the replica waits 60 seconds\\n  between reconnection attempts (SOURCE_CONNECT_RETRY=60), and keeps\\n  attempt"
  "ing to reconnect at this rate for 10 minutes\\n  (SOURCE_RETRY_COUNT=10). These values are recorded in the source\\n  m"
  "etadata repository and shown in the\\n  replication_connection_configuration Performance Schema table.\\n\\no SOURCE_CON"
  "NECTION_AUTO_FAILOVER = {0|1}\\n\\n  Activates the asynchronous connection failover mechanism for a\\n  replication chan"
  "nel if one or more alternative replication source\\n  servers are available (so when there are multiple MySQL servers "
  "or\\n  groups of servers that share the replicated data). The default is 0,\\n  meaning that the mechanism is not activ"
  "ated. For full information and\\n  instructions to set up this feature, see\\n  https://dev.mysql.com/doc/refman/8.4/en"
  "/replication-asynchronous-conn\\n  ection-failover-replica.html.\\n\\n  The asynchronous connection failover mechanism t"
  "akes over after the\\n  reconnection attempts controlled by SOURCE_CONNECT_RETRY and\\n  SOURCE_RETRY_COUNT are exhaust"
  "ed. It reconnects the replica to an\\n  alternative source chosen from a specified source list, which you can\\n  manag"
  "e using the functions\\n  asynchronous_connection_failover_add_source() and\\n  asynchronous_connection_failover_delete"
  "_source(). To add and remove\\n  managed groups of servers, use\\n  asynchronous_connection_failover_add_managed() and\\"
  "n  asynchronous_connection_failover_delete_managed() instead. For more\\n  information, see\\n  https://dev.mysql.com/d"
  "oc/refman/8.4/en/replication-asynchronous-conn\\n  ection-failover.html.\\n\\n  *Important*:\\n\\n   1. You can only set S"
  "OURCE_CONNECTION_AUTO_FAILOVER = 1 when GTID\\n      auto-positioning is in use (SOURCE_AUTO_POSITION = 1).\\n\\n   2. W"
  "hen you set SOURCE_CONNECTION_AUTO_FAILOVER = 1, set\\n      SOURCE_RETRY_COUNT and SOURCE_CONNECT_RETRY to minimal nu"
  "mbers\\n      that just allow a few retry attempts with the same source, in\\n      case the connection failure is caus"
  "ed by a transient network\\n      outage. Otherwise the asynchronous connection failover mechanism\\n      cannot be ac"
  "tivated promptly. Suitable values are\\n      SOURCE_RETRY_COUNT=3 and SOURCE_CONNECT_RETRY=10, which make the\\n      "
  "replica retry the connection 3 times with 10-second intervals\\n      between.\\n\\n   3. When you set SOURCE_CONNECTION"
  "_AUTO_FAILOVER = 1, the replication\\n      metadata repositories must contain the credentials for a\\n      replicatio"
  "n user account that can be used to connect to all the\\n      servers on the source list for the replication channel. "
  "The\\n      account must also have SELECT permissions on the Performance\\n      Schema tables. These credentials can b"
  "e set using the CHANGE\\n      REPLICATION SOURCE TO statement with the SOURCE_USER and\\n      SOURCE_PASSWORD options"
  ". For more information, see\\n      https://dev.mysql.com/doc/refman/8.4/en/replication-asynchronous-\\n      connectio"
  "n-failover.html.\\n\\n   4. When you set SOURCE_CONNECTION_AUTO_FAILOVER = 1, asynchronous\\n      connection failover f"
  "or replicas is automatically activated if\\n      this replication channel is on a Group Replication primary in a\\n   "
  "   group in single-primary mode. With this function active, if the\\n      primary that is replicating goes offline or"
  " into an error state,\\n      the new primary starts replication on the same channel when it is\\n      elected. If you"
  " want to use the function, this replication\\n      channel must also be set up on all the secondary servers in the\\n "
  "     replication group, and on any new joining members. (If the\\n      servers are provisioned using MySQL\\'s clone f"
  "unctionality, this\\n      all happens automatically.) If you do not want to use the\\n      function, disable it by us"
  "ing the\\n      group_replication_disable_member_action() function to disable the\\n      Group Replication member acti"
  "on\\n      mysql_start_failover_channels_if_primary, which is enabled by\\n      default. For more information, see\\n  "
  "    https://dev.mysql.com/doc/refman/8.4/en/replication-asynchronous-\\n      connection-failover-replica.html.\\n\\no S"
  "OURCE_DELAY = interval\\n\\n  Specifies how many seconds behind the source the replica must lag. An\\n  event received f"
  "rom the source is not executed until at least\\n  interval seconds later than its execution on the source. interval\\n "
  " must be a nonnegative integer in the range from 0 to 231−1. The\\n  default is 0. For more information, see\\n  http"
  "s://dev.mysql.com/doc/refman/8.4/en/replication-delayed.html.\\n\\n  A CHANGE REPLICATION SOURCE TO statement using the"
  " SOURCE_DELAY\\n  option can be executed on a running replica when the replication SQL\\n  thread is stopped.\\n\\no SOUR"
  "CE_HEARTBEAT_PERIOD = interval\\n\\n  Controls the heartbeat interval, which stops the connection timeout\\n  occurring "
  "in the absence of data if the connection is still good. A\\n  heartbeat signal is sent to the replica after that numbe"
  "r of seconds,\\n  and the waiting period is reset whenever the source\\'s binary log is\\n  updated with an event. Heart"
  "beats are therefore sent by the source\\n  only if there are no unsent events in the binary log file for a\\n  period l"
  "onger than this.\\n\\n  The heartbeat interval interval is a decimal value having the range 0\\n  to 4294967 seconds and"
  " a resolution in milliseconds; the smallest\\n  nonzero value is 0.001. Setting interval to 0 disables heartbeats\\n  a"
  "ltogether. The heartbeat interval defaults to half the value of the\\n  replica_net_timeout system variable. It is rec"
  "orded in the source\\n  metadata repository and shown in the\\n  replication_connection_configuration Performance Schem"
  "a table.\\n\\n  The replica_net_timeout system variable specifies the number of\\n  seconds that the replica waits for e"
  "ither more data or a heartbeat\\n  signal from the source, before the replica considers the connection\\n  broken, abor"
  "ts the read, and tries to reconnect. The default value is\\n  60 seconds (one minute). Note that a change to the value"
  " or default\\n  setting of replica_net_timeout does not automatically change the\\n  heartbeat interval, whether that h"
  "as been set explicitly or is using\\n  a previously calculated default. A warning is issued if you set the\\n  global v"
  "alue of replica_net_timeout to a value less than that of the\\n  current heartbeat interval. If replica_net_timeout is"
  " changed, you\\n  must also issue CHANGE REPLICATION SOURCE TO to adjust the heartbeat\\n  interval to an appropriate v"
  "alue so that the heartbeat signal occurs\\n  before the connection timeout. If you do not do this, the heartbeat\\n  si"
  "gnal has no effect, and if no data is received from the source, the\\n  replica can make repeated reconnection attempt"
  "s, creating zombie dump\\n  threads.\\n\\no SOURCE_HOST = \\'host_name\\'\\n\\n  The host name or IP address of the replicat"
  "ion source server. The\\n  replica uses this to connect to the source. The maximum length of the\\n  string value is 25"
  "5 characters.\\n\\n  If you specify SOURCE_HOST or SOURCE_PORT, the replica assumes that\\n  the source server is differ"
  "ent from before (even if the option value\\n  is the same as its current value.) In this case, the old values for\\n  t"
  "he source\\'s binary log file name and position are considered no\\n  longer applicable, so if you do not specify SOURC"
  "E_LOG_FILE and\\n  SOURCE_LOG_POS in the statement, SOURCE_LOG_FILE=\\'\\' and\\n  SOURCE_LOG_POS=4 are silently appended"
  " to it.\\n\\n  Setting SOURCE_HOST=\\'\\' (that is, setting its value explicitly to an\\n  empty string) is not the same a"
  "s not setting SOURCE_HOST at all.\\n  Trying to set SOURCE_HOST to an empty string fails with an error.\\n\\no SOURCE_LO"
  "G_FILE = \\'source_log_name\\', SOURCE_LOG_POS = source_log_pos\\n\\n  The binary log file name, and the location in that"
  " file, at which the\\n  replication I/O (receiver) thread begins reading from the source\\'s\\n  binary log the next tim"
  "e the thread starts. Specify these options if\\n  you are using binary log file position based replication.\\n\\n  SOURC"
  "E_LOG_FILE must include the numeric suffix of a specific binary\\n  log file that is available on the source server, f"
  "or example,\\n  SOURCE_LOG_FILE=\\'binlog.000145\\'. The maximum length of the string\\n  value is 511 characters.\\n\\n  S"
  "OURCE_LOG_POS is the numeric position for the replica to start\\n  reading in that file. SOURCE_LOG_POS=4 represents t"
  "he start of the\\n  events in a binary log file.\\n\\n  If you specify either of SOURCE_LOG_FILE or SOURCE_LOG_POS, you\\"
  "n  cannot specify SOURCE_AUTO_POSITION = 1, which is for GTID-based\\n  replication.\\n\\n  If neither of SOURCE_LOG_FIL"
  "E or SOURCE_LOG_POS is specified, the\\n  replica uses the last coordinates of the replication SQL thread\\n  before CH"
  "ANGE REPLICATION SOURCE TO was issued. This ensures that\\n  there is no discontinuity in replication, even if the rep"
  "lication SQL\\n  (applier) thread was late compared to the replication I/O (receiver)\\n  thread.\\n\\no SOURCE_PASSWORD "
  "= \\'password\\'\\n\\n  The password for the replication user account to use for connecting\\n  to the replication source "
  "server. The maximum length of the string\\n  value is 32 characters. If you specify SOURCE_PASSWORD, SOURCE_USER\\n  is"
  " also required.\\n\\n  The password used for a replication user account in a CHANGE\\n  REPLICATION SOURCE TO statement "
  "is limited to 32 characters in\\n  length. Trying to use a password of more than 32 characters causes\\n  CHANGE REPLIC"
  "ATION SOURCE TO to fail.\\n\\n  The password is masked in MySQL Server\\'s logs, Performance Schema\\n  tables, and SHOW "
  "PROCESSLIST statements.\\n\\no SOURCE_PORT = port_num\\n\\n  The TCP/IP port number that the replica uses to connect to t"
  "he\\n  replication source server.\\n\\n  *Note*:\\n\\n  Replication cannot use Unix socket files. You must be able to conn"
  "ect\\n  to the replication source server using TCP/IP.\\n\\n  If you specify SOURCE_HOST or SOURCE_PORT, the replica ass"
  "umes that\\n  the source server is different from before (even if the option value\\n  is the same as its current value"
  ".) In this case, the old values for\\n  the source\\'s binary log file name and position are considered no\\n  longer ap"
  "plicable, so if you do not specify SOURCE_LOG_FILE and\\n  SOURCE_LOG_POS in the statement, SOURCE_LOG_FILE=\\'\\' and\\n"
  "  SOURCE_LOG_POS=4 are silently appended to it.\\n\\no SOURCE_PUBLIC_KEY_PATH = \\'key_file_name\\'\\n\\n  Enables RSA key "
  "pair-based password exchange by providing the path\\n  name to a file containing a replica-side copy of the public key"
  "\\n  required by the source. The file must be in PEM format. The maximum\\n  length of the string value is 511 characte"
  "rs.\\n\\n  This option applies to replicas that authenticate with the\\n  sha256_password or caching_sha2_password authe"
  "ntication plugin. (For\\n  sha256_password, SOURCE_PUBLIC_KEY_PATH can be used only if MySQL was\\n  built using OpenSS"
  "L.) If you are using a replication user account\\n  that authenticates with the caching_sha2_password plugin (the\\n  d"
  "efault), and you are not using a secure connection, you must specify\\n  either this option or the GET_SOURCE_PUBLIC_K"
  "EY=1 option to provide\\n  the RSA public key to the replica.\\n\\no SOURCE_RETRY_COUNT = count\\n\\n  Sets the maximum nu"
  "mber of reconnection attempts that the replica\\n  makes after the connection to the source times out, as determined b"
  "y\\n  the replica_net_timeout system variable. If the replica does need to\\n  reconnect, the first retry occurs immedi"
  "ately after the timeout. The\\n  default is 10 attempts.\\n\\n  The interval between the attempts is specified by the\\n "
  " SOURCE_CONNECT_RETRY option. If both the default settings are used,\\n  the replica waits 60 seconds between reconnec"
  "tion attempts\\n  (SOURCE_CONNECT_RETRY=60), and keeps attempting to reconnect at this\\n  rate for 10 minutes (SOURCE_"
  "RETRY_COUNT=10). A setting of 0 for\\n  SOURCE_RETRY_COUNT means that there is no limit on the number of\\n  reconnecti"
  "on attempts, so the replica keeps trying to reconnect\\n  indefinitely.\\n\\n  The values for SOURCE_CONNECT_RETRY and S"
  "OURCE_RETRY_COUNT are\\n  recorded in the source metadata repository and shown in the\\n  replication_connection_config"
  "uration Performance Schema table.\\n  SOURCE_RETRY_COUNT supersedes the --master-retry-count server startup\\n  option."
  "\\n\\no SOURCE_SSL = {0|1}\\n\\n  Specify whether the replica encrypts the replication connection. The\\n  default is 0, m"
  "eaning that the replica does not encrypt the\\n  replication connection. If you set SOURCE_SSL=1, you can configure\\n "
  " the encryption using the SOURCE_SSL_xxx and SOURCE_TLS_xxx options.\\n\\n  Setting SOURCE_SSL=1 for a replication conn"
  "ection and then setting no\\n  further SOURCE_SSL_xxx options corresponds to setting\\n  --ssl-mode=REQUIRED for the cl"
  "ient, as described in\\n  https://dev.mysql.com/doc/refman/8.4/en/connection-options.html#encry\\n  pted-connection-opt"
  "ions. With SOURCE_SSL=1, the connection attempt\\n  only succeeds if an encrypted connection can be established. A\\n  "
  "replication connection does not fall back to an unencrypted\\n  connection, so there is no setting corresponding to th"
  "e\\n  --ssl-mode=PREFERRED setting for replication. If SOURCE_SSL=0 is set,\\n  this corresponds to --ssl-mode=DISABLED"
  ".\\n\\n  *Important*:\\n\\n  To help prevent sophisticated man-in-the-middle attacks, it is\\n  important for the replica "
  "to verify the server\\'s identity. You can\\n  specify additional SOURCE_SSL_xxx options to correspond to the\\n  settin"
  "gs --ssl-mode=VERIFY_CA and --ssl-mode=VERIFY_IDENTITY, which\\n  are a better choice than the default setting to help"
  " prevent this\\n  type of attack. With these settings, the replica checks that the\\n  server\\'s certificate is valid, "
  "and checks that the host name the\\n  replica is using matches the identity in the server\\'s certificate. To\\n  implem"
  "ent one of these levels of verification, you must first ensure\\n  that the CA certificate for the server is reliably "
  "available to the\\n  replica, otherwise availability issues will result. For this reason,\\n  they are not the default "
  "setting.\\n\\no SOURCE_SSL_xxx, SOURCE_TLS_xxx\\n\\n  Specify how the replica uses encryption and ciphers to secure the\\n"
  "  replication connection. These options can be changed even on replicas\\n  that are compiled without SSL support. The"
  "y are saved to the source\\n  metadata repository, but are ignored if the replica does not have SSL\\n  support enabled"
  ". The maximum length of the value for the\\n  string-valued SOURCE_SSL_xxx and SOURCE_TLS_xxx options is 511\\n  charac"
  "ters, with the exception of SOURCE_TLS_CIPHERSUITES, for which\\n  it is 4000 characters.\\n\\n  The SOURCE_SSL_xxx and "
  "SOURCE_TLS_xxx options perform the same\\n  functions as the --ssl-xxx and --tls-xxx client options described in\\n  ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/connection-options.html#encry\\n  pted-connection-options. The correspondence be"
  "tween the two sets of\\n  options, and the use of the SOURCE_SSL_xxx and SOURCE_TLS_xxx options\\n  to set up a secure "
  "connection, is explained in\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-encrypted-connect\\n  ions.html.\\n\\"
  "no SOURCE_USER = \\'user_name\\'\\n\\n  The user name for the replication user account to use for connecting\\n  to the re"
  "plication source server. The maximum length of the string\\n  value is 96 characters.\\n\\n  For Group Replication, this"
  " account must exist on every member of the\\n  replication group. It is used for distributed recovery if the XCom\\n  c"
  "ommunication stack is in use for the group, and also used for group\\n  communication connections if the MySQL communi"
  "cation stack is in use\\n  for the group. With the MySQL communication stack, the account must\\n  have the GROUP_REPLI"
  "CATION_STREAM permission.\\n\\n  It is possible to set an empty user name by specifying\\n  SOURCE_USER=\\'\\', but the re"
  "plication channel cannot be started with an\\n  empty user name. It is valid to set an empty SOURCE_USER user name\\n  "
  "and use the channel afterwards if you always provide user credentials\\n  using the START REPLICA statement or START G"
  "ROUP_REPLICATION\\n  statement that starts the replication channel. This approach means\\n  that the replication channe"
  "l always needs operator intervention to\\n  restart, but the user credentials are not recorded in the replication\\n  m"
  "etadata repositories.\\n\\n  *Important*:\\n\\n  To connect to the source using a replication user account that\\n  authen"
  "ticates with the caching_sha2_password plugin, you must either\\n  set up a secure connection as described in\\n  https"
  "://dev.mysql.com/doc/refman/8.4/en/replication-encrypted-connect\\n  ions.html, or enable the unencrypted connection t"
  "o support password\\n  exchange using an RSA key pair. The caching_sha2_password\\n  authentication plugin is the defau"
  "lt for new users (see\\n  https://dev.mysql.com/doc/refman/8.4/en/caching-sha2-pluggable-authen\\n  tication.html). If "
  "the user account that you create or use for\\n  replication uses this authentication plugin, and you are not using a\\n"
  "  secure connection, you must enable RSA key pair-based password\\n  exchange for a successful connection. You can do "
  "this using either\\n  the SOURCE_PUBLIC_KEY_PATH option or the GET_SOURCE_PUBLIC_KEY=1\\n  option for this statement.\\n"
  "\\no SOURCE_ZSTD_COMPRESSION_LEVEL = level\\n\\n  The compression level to use for connections to the replication\\n  sou"
  "rce server that use the zstd compression algorithm. The permitted\\n  levels are from 1 to 22, with larger values indi"
  "cating increasing\\n  levels of compression. The default level is 3.\\n\\n  The compression level setting has no effect "
  "on connections that do\\n  not use zstd compression. For more information, see\\n  https://dev.mysql.com/doc/refman/8.4"
  "/en/connection-compression-contro\\n  l.html.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/change-replication-sourc"
  "e-to.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/change-replication-source-to.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (577,43,'RESET REPLICA','Syn"
  "tax:\\nRESET REPLICA [ALL] [channel_option]\\n\\nchannel_option:\\n    FOR CHANNEL channel\\n\\nRESET REPLICA makes the rep"
  "lica forget its position in the source\\'s\\nbinary log.\\n\\nThis statement is meant to be used for a clean start; it cl"
  "ears the\\nreplication metadata repositories, deletes all the relay log files, and\\nstarts a new relay log file. It al"
  "so resets to 0 the replication delay\\nspecified with the SOURCE_DELAY option of the CHANGE REPLICATION SOURCE\\nTO sta"
  "tement.\\n\\n*Note*:\\n\\nAll relay log files are deleted, even if they have not been completely\\nexecuted by the replica"
  "tion SQL thread. (This is a condition likely to\\nexist on a replica if you have issued a STOP REPLICA statement or if"
  "\\nthe replica is highly loaded.)\\n\\nFor a server where GTIDs are in use (gtid_mode is ON), issuing RESET\\nREPLICA has"
  " no effect on the GTID execution history. The statement does\\nnot change the values of gtid_executed or gtid_purged, "
  "or the\\nmysql.gtid_executed table. If you need to reset the GTID execution\\nhistory, use RESET BINARY LOGS AND GTIDS,"
  " even if the GTID-enabled\\nserver is a replica where binary logging is disabled.\\n\\nRESET REPLICA requires the RELOAD"
  " privilege.\\n\\nTo use RESET REPLICA, the replication SQL thread and replication I/O\\n(receiver) thread must be stoppe"
  "d, so on a running replica use STOP\\nREPLICA before issuing RESET REPLICA. To use RESET REPLICA on a Group\\nReplicati"
  "on group member, the member status must be OFFLINE, meaning\\nthat the plugin is loaded but the member does not curren"
  "tly belong to\\nany group. A group member can be taken offline by using a STOP GROUP\\nREPLICATION statement.\\n\\nThe op"
  "tional FOR CHANNEL channel clause enables you to name which\\nreplication channel the statement applies to. Providing "
  "a FOR CHANNEL\\nchannel clause applies the RESET REPLICA statement to a specific\\nreplication channel. Combining a FOR"
  " CHANNEL channel clause with the\\nALL option deletes the specified channel. If no channel is named and no\\nextra chan"
  "nels exist, the statement applies to the default channel.\\nIssuing a RESET REPLICA ALL statement without a FOR CHANNE"
  "L channel\\nclause when multiple replication channels exist deletes all replication\\nchannels and recreates only the d"
  "efault channel. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-channels.html for\\nmore information.\\n\\nRESE"
  "T REPLICA does not change any replication connection parameters,\\nwhich include the source\\'s host name and port, the"
  " replication user\\naccount and its password, the PRIVILEGE_CHECKS_USER account, the\\nREQUIRE_ROW_FORMAT option, the R"
  "EQUIRE_TABLE_PRIMARY_KEY_CHECK\\noption,and the ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS option. If you\\nwant to change "
  "any of the replication connection parameters, you can do\\nthis using a CHANGE REPLICATION SOURCE TO statement after t"
  "he server\\nstarts. If you want to remove all of the replication connection\\nparameters, use RESET REPLICA ALL. RESET "
  "REPLICA ALL also clears the\\nIGNORE_SERVER_IDS list set by CHANGE REPLICATION SOURCE TO. When you\\nhave used RESET RE"
  "PLICA ALL, if you want to use the instance as a\\nreplica again, you need to issue a CHANGE REPLICATION SOURCE TO\\nsta"
  "tement after the server start to specify new connection parameters.\\n\\nYou can set the GTID_ONLY option on the CHANGE"
  " REPLICATION SOURCE TO\\nstatement to stop a replication channel from persisting file names and\\nfile positions in the"
  " replication metadata repositories. When you issue\\nRESET REPLICA, the replication metadata repositories are synchron"
  "ized.\\nRESET REPLICA ALL deletes rather than updates the repositories, so they\\nare synchronized implicitly.\\n\\nIn th"
  "e event of an unexpected server exit or deliberate restart after\\nissuing RESET REPLICA but before issuing START REPL"
  "ICA, replication\\nconnection parameters are preserved in the crash-safe InnoDB tables\\nmysql.slave_master_info and my"
  "sql.slave_relay_log_info as part of the\\nRESET REPLICA operation. They are also retained in memory. In the event\\nof "
  "an unexpected server exit or deliberate restart after issuing RESET\\nREPLICA but before issuing START REPLICA, the re"
  "plication connection\\nparameters are retrieved from the tables and reapplied to the channel.\\nThis applies for both t"
  "he connection and applier metadata repositories.\\n\\nRESET REPLICA does not change any replication filter settings (su"
  "ch as\\n--replicate-ignore-table) for channels affected by the statement.\\nHowever, RESET REPLICA ALL removes the repl"
  "ication filters that were\\nset on the channels deleted by the statement. When the deleted channel\\nor channels are re"
  "created, any global replication filters specified for\\nthe replica are copied to them, and no channel specific replic"
  "ation\\nfilters are applied. For more information see\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-rules-chann"
  "el-based\\n-filters.html.\\n\\nRESET REPLICA causes an implicit commit of an ongoing transaction. See\\nhttps://dev.mysql"
  ".com/doc/refman/8.4/en/implicit-commit.html.\\n\\nIf the replication SQL thread was in the middle of replicating\\ntempo"
  "rary tables when it was stopped, and RESET REPLICA is issued,\\nthese replicated temporary tables are deleted on the r"
  "eplica.\\n\\n*Note*:\\n\\nWhen used on an NDB Cluster replica SQL node, RESET REPLICA clears the\\nmysql.ndb_apply_status "
  "table. You should keep in mind when using this\\nstatement that ndb_apply_status uses the NDB storage engine and so is"
  "\\nshared by all SQL nodes attached to the cluster.\\n\\nYou can override this behavior by issuing SET GLOBAL\\n@@ndb_cle"
  "ar_apply_status=OFF prior to executing RESET REPLICA, which\\nkeeps the replica from purging the ndb_apply_status tabl"
  "e in such\\ncases.\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/reset-replica.html\\n\\n','','https://dev.mysql.com/d"
  "oc/refman/8.4/en/reset-replica.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (578,43,'START REPLICA','Syn"
  "tax:\\nSTART REPLICA [thread_types] [until_option] [connection_options] [channel_option]\\n\\nthread_types:\\n    [thread"
  "_type [, thread_type] ... ]\\n\\nthread_type:\\n    IO_THREAD | SQL_THREAD\\n\\nuntil_option:\\n    UNTIL {   {SQL_BEFORE_G"
  "TIDS | SQL_AFTER_GTIDS} = gtid_set\\n          |   SOURCE_LOG_FILE = \\'log_name\\', SOURCE_LOG_POS = log_pos\\n         "
  " |   RELAY_LOG_FILE = \\'log_name\\', RELAY_LOG_POS = log_pos\\n          |   SQL_AFTER_MTS_GAPS  }\\n\\nconnection_option"
  "s:\\n    [USER=\\'user_name\\'] [PASSWORD=\\'user_pass\\'] [DEFAULT_AUTH=\\'plugin_name\\'] [PLUGIN_DIR=\\'plugin_dir\\']\\n\\n\\"
  "nchannel_option:\\n    FOR CHANNEL channel\\n\\ngtid_set:\\n    uuid_set [, uuid_set] ...\\n    | \\'\\'\\n\\nuuid_set:\\n    u"
  "uid:interval[:interval]...\\n\\nuuid:\\n    hhhhhhhh-hhhh-hhhh-hhhh-hhhhhhhhhhhh\\n\\nh:\\n    [0-9,A-F]\\n\\ninterval:\\n    "
  "n[-n]\\n\\n    (n >= 1)\\n\\nSTART REPLICA starts the replication threads, either together or\\nseparately.\\n\\nSTART REPLI"
  "CA requires the REPLICATION_SLAVE_ADMIN privilege (or the\\ndeprecated SUPER privilege). START REPLICA causes an impli"
  "cit commit of\\nan ongoing transaction. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/implicit-commit.html.\\n\\nFor the "
  "thread type options, you can specify IO_THREAD, SQL_THREAD,\\nboth of these, or neither of them. Only the threads that"
  " are started\\nare affected by the statement.\\n\\no START REPLICA with no thread type options starts all of the\\n  repl"
  "ication threads, and so does START REPLICA with both of the\\n  thread type options.\\n\\no IO_THREAD starts the replica"
  "tion receiver thread, which reads events\\n  from the source server and stores them in the relay log.\\n\\no SQL_THREAD "
  "starts the replication applier thread, which reads events\\n  from the relay log and executes them. A multithreaded re"
  "plica (with\\n  replica_parallel_workers > 0) applies transactions using a\\n  coordinator thread and multiple applier "
  "threads, and SQL_THREAD\\n  starts all of these.\\n\\n*Important*:\\n\\nSTART REPLICA sends an acknowledgment to the user "
  "after all the\\nreplication threads have started. However, the replication receiver\\nthread might not yet have connect"
  "ed to the source successfully, or an\\napplier thread might stop when applying an event right after starting.\\nSTART R"
  "EPLICA does not continue to monitor the threads after they are\\nstarted, so it does not warn you if they subsequently"
  " stop or cannot\\nconnect. You must check the replica\\'s error log for error messages\\ngenerated by the replication th"
  "reads, or check that they are running\\nsatisfactorily with SHOW REPLICA STATUS. A successful START REPLICA\\nstatement"
  " causes SHOW REPLICA STATUS to show Replica_SQL_Running=Yes,\\nbut it might or might not show Replica_IO_Running=Yes, "
  "because\\nReplica_IO_Running=Yes is only shown if the receiver thread is both\\nrunning and connected. For more informa"
  "tion, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-administration-stat\\nus.html.\\n\\nThe optional FOR CHAN"
  "NEL channel clause enables you to name which\\nreplication channel the statement applies to. Providing a FOR CHANNEL\\n"
  "channel clause applies the START REPLICA statement to a specific\\nreplication channel. If no clause is named and no e"
  "xtra channels exist,\\nthe statement applies to the default channel. If a START REPLICA\\nstatement does not have a cha"
  "nnel defined when using multiple channels,\\nthis statement starts the specified threads for all channels. See\\nhttps:"
  "//dev.mysql.com/doc/refman/8.4/en/replication-channels.html for\\nmore information.\\n\\nThe replication channels for Gr"
  "oup Replication\\n(group_replication_applier and group_replication_recovery) are managed\\nautomatically by the server "
  "instance. START REPLICA cannot be used at\\nall with the group_replication_recovery channel, and should only be\\nused "
  "with the group_replication_applier channel when Group Replication\\nis not running. The group_replication_applier chan"
  "nel only has an\\napplier thread and has no receiver thread, so it can be started if\\nrequired by using the SQL_THREAD"
  " option without the IO_THREAD option.\\n\\nSTART REPLICA supports pluggable user-password authentication (see\\nhttps://"
  "dev.mysql.com/doc/refman/8.4/en/pluggable-authentication.html)\\nwith the USER, PASSWORD, DEFAULT_AUTH and PLUGIN_DIR "
  "options, as\\ndescribed in the following list. When you use these options, you must\\nstart the receiver thread (IO_THR"
  "EAD option) or all the replication\\nthreads; you cannot start the replication applier thread (SQL_THREAD\\noption) alo"
  "ne.\\n\\no USER\\n\\n  The user name for the account. You must set this if PASSWORD is used.\\n  The option cannot be set "
  "to an empty or null string.\\n\\no PASSWORD\\n\\n  The password for the named user account.\\n\\no DEFAULT_AUTH\\n\\n  The na"
  "me of the authentication plugin. The default is MySQL native\\n  authentication.\\n\\no PLUGIN_DIR\\n\\n  The location of "
  "the authentication plugin.\\n\\n*Important*:\\n\\nThe password that you set using START REPLICA is masked when it is\\nwri"
  "tten to MySQL Server\\'s logs, Performance Schema tables, and SHOW\\nPROCESSLIST statements. However, it is sent in pla"
  "in text over the\\nconnection to the replica server instance. To protect the password in\\ntransit, use SSL/TLS encrypt"
  "ion, an SSH tunnel, or another method of\\nprotecting the connection from unauthorized viewing, for the connection\\nbe"
  "tween the replica server instance and the client that you use to\\nissue START REPLICA.\\n\\nThe UNTIL clause makes the "
  "replica start replication, then process\\ntransactions up to the point that you specify in the UNTIL clause, then\\nsto"
  "p again. The UNTIL clause can be used to make a replica proceed\\nuntil just before the point where you want to skip a"
  " transaction that\\nis unwanted, and then skip the transaction as described in\\nhttps://dev.mysql.com/doc/refman/8.4/e"
  "n/replication-administration-skip\\n.html. To identify a transaction, you can use mysqlbinlog with the\\nsource\\'s bina"
  "ry log or the replica\\'s relay log, or use a SHOW BINLOG\\nEVENTS statement.\\n\\nYou can also use the UNTIL clause for "
  "debugging replication by\\nprocessing transactions one at a time or in sections. If you are using\\nthe UNTIL clause to"
  " do this, start the replica with\\n--skip-replica-start to prevent the SQL thread from running when the\\nreplica serve"
  "r starts. Remove the option or system variable setting\\nafter the procedure is complete, so that it is not forgotten "
  "in the\\nevent of an unexpected server restart.\\n\\nThe SHOW REPLICA STATUS statement includes output fields that displ"
  "ay\\nthe current values of the UNTIL condition. The UNTIL condition lasts\\nfor as long as the affected threads are sti"
  "ll running, and is removed\\nwhen they stop.\\n\\nThe UNTIL clause operates on the replication applier thread (SQL_THREA"
  "D\\noption). You can use the SQL_THREAD option or let the replica default\\nto starting both threads. If you use the IO"
  "_THREAD option alone, the\\nUNTIL clause is ignored because the applier thread is not started.\\n\\nThe point that you s"
  "pecify in the UNTIL clause can be any one (and only\\none) of the following options:\\n\\no SOURCE_LOG_FILE and SOURCE_L"
  "OG_POS\\n\\n  These options make the replication applier process transactions up to\\n  a position in its relay log, ide"
  "ntified by the file name and file\\n  position of the corresponding point in the binary log on the source\\n  server. T"
  "he applier thread finds the nearest transaction boundary at\\n  or after the specified position, finishes applying the"
  " transaction,\\n  and stops there. For compressed transaction payloads, specify the end\\n  position of the compressed "
  "Transaction_payload_event.\\n\\n  These options can still be used when the GTID_ONLY option was set on\\n  the CHANGE RE"
  "PLICATION SOURCE TO statement to stop the replication\\n  channel from persisting file names and file positions in the"
  "\\n  replication metadata repositories. The file names and file positions\\n  are tracked in memory.\\n\\no RELAY_LOG_FIL"
  "E and RELAY_LOG_POS\\n\\n  These options make the replication applier process transactions up to\\n  a position in the r"
  "eplica\\'s relay log, identified by the relay log\\n  file name and a position in that file. The applier thread finds t"
  "he\\n  nearest transaction boundary at or after the specified position,\\n  finishes applying the transaction, and stop"
  "s there. For compressed\\n  transaction payloads, specify the end position of the compressed\\n  Transaction_payload_ev"
  "ent.\\n\\n  These options can still be used when the GTID_ONLY option was set on\\n  the CHANGE REPLICATION SOURCE TO st"
  "atement to stop the replication\\n  channel from persisting file names and file positions in the\\n  replication metada"
  "ta repositories. The file names and file positions\\n  are tracked in memory.\\n\\no SQL_BEFORE_GTIDS\\n\\n  This option m"
  "akes the replication applier start processing\\n  transactions and stop when it encounters any transaction that is in\\"
  "n  the specified GTID set. The encountered transaction from the GTID set\\n  is not applied, and nor are any of the ot"
  "her transactions in the GTID\\n  set. The option takes a GTID set containing one or more global\\n  transaction identif"
  "iers as an argument (see\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-gtids-concepts.ht\\n  ml#replication-g"
  "tids-concepts-gtid-sets). Transactions in a GTID set\\n  do not necessarily appear in the replication stream in the or"
  "der of\\n  their GTIDs, so the transaction before which the applier stops is not\\n  necessarily the earliest.\\n\\no SQL"
  "_AFTER_GTIDS\\n\\n  This option makes the replication applier start processing\\n  transactions and stop when it has pro"
  "cessed all of the transactions\\n  in a specified GTID set. The option takes a GTID set containing one\\n  or more glob"
  "al transaction identifiers as an argument (see\\n  https://dev.mysql.com/doc/refman/8.4/en/replication-gtids-concepts."
  "ht\\n  ml#replication-gtids-concepts-gtid-sets).\\n\\n  With SQL_AFTER_GTIDS, the replication threads stop after they ha"
  "ve\\n  processed all transactions in the GTID set. Transactions are\\n  processed in the order received, so it is possi"
  "ble that these include\\n  transactions which are not part of the GTID set, but which are\\n  received (and processed) "
  "before all transactions in the set have been\\n  committed. For example, executing START REPLICA UNTIL SQL_AFTER_GTIDS"
  "\\n  = 3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56 causes the replica to\\n  obtain (and process) all transactions from "
  "the source until all of\\n  the transactions having the sequence numbers 11 through 56 have been\\n  processed, and the"
  "n to stop without processing any additional\\n  transactions after that point has been reached.\\n\\n  In older versions"
  " of MySQL, this option could not be used with\\n  replica_parallel_workers > 1. In MySQL 8.4, this is no longer an\\n  "
  "issue, and SQL_AFTER_GTIDS can be used without causing the replica to\\n  fall back into single-threaded mode.\\n\\no SQ"
  "L_AFTER_MTS_GAPS\\n\\n  For a multithreaded replica only (with replica_parallel_workers > 0),\\n  this option makes the "
  "replica process transactions up to the point\\n  where there are no more gaps in the sequence of transactions executed"
  "\\n  from the relay log. When using a multithreaded replica, there is a\\n  chance of gaps occurring in the following s"
  "ituations:\\n\\n  o The coordinator thread is stopped.\\n\\n  o An error occurs in the applier threads.\\n\\n  o mysqld shu"
  "ts down unexpectedly.\\n\\n  When a replication channel has gaps, the replica\\'s database is in a\\n  state that might n"
  "ever have existed on the source. The replica tracks\\n  the gaps internally and disallows CHANGE REPLICATION SOURCE TO"
  "\\n  statements that would remove the gap information if they executed.\\n\\n  All replicas are multithreaded by default"
  ". When\\n  replica_preserve_commit_order=ON on the replica (the default), gaps\\n  should not occur except in the speci"
  "fic situations listed in the\\n  description for this variable. If replica_preserve_commit_order is\\n  OFF, the commit"
  " order of transactions is not preserved, so the chance\\n  of gaps occurring is much larger.\\n\\n  If GTIDs are not in "
  "use and you need to change a failed multithreaded\\n  replica to single-threaded mode, you can issue the following ser"
  "ies\\n  of statements, in the order shown:\\n\\nSTART REPLICA UNTIL SQL_AFTER_MTS_GAPS;\\nSET @@GLOBAL.replica_parallel_w"
  "orkers = 0;\\nSTART REPLICA SQL_THREAD;\\n\\nURL: https://dev.mysql.com/doc/refman/8.4/en/start-replica.html\\n\\n','','ht"
  "tps://dev.mysql.com/doc/refman/8.4/en/start-replica.html');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (579,43,'STOP REPLICA','Synt"
  "ax:\\nSTOP REPLICA [thread_types] [channel_option]\\n\\nthread_types:\\n    [thread_type [, thread_type] ... ]\\n\\nthread_"
  "type: IO_THREAD | SQL_THREAD\\n\\nchannel_option:\\n    FOR CHANNEL channel\\n\\nStops the replication threads.\\n\\nSTOP RE"
  "PLICA requires the REPLICATION_SLAVE_ADMIN privilege (or the\\ndeprecated SUPER privilege). Recommended best practice "
  "is to execute\\nSTOP REPLICA on the replica before stopping the replica server (see\\nhttps://dev.mysql.com/doc/refman/"
  "8.4/en/server-shutdown.html, for more\\ninformation).\\n\\nLike START REPLICA, this statement may be used with the IO_TH"
  "READ and\\nSQL_THREAD options to name the replication thread or threads to be\\nstopped. Note that the Group Replicatio"
  "n applier channel\\n(group_replication_applier) has no replication I/O (receiver) thread,\\nonly a replication SQL (app"
  "lier) thread. Using the SQL_THREAD option\\ntherefore stops this channel completely.\\n\\nSTOP REPLICA causes an implici"
  "t commit of an ongoing transaction. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/implicit-commit.html.\\n\\ngtid_next m"
  "ust be set to AUTOMATIC before issuing this statement.\\n\\nYou can control how long STOP REPLICA waits before timing o"
  "ut by\\nsetting the system variable rpl_stop_replica_timeout. This can be used\\nto avoid deadlocks between STOP REPLIC"
  "A and other SQL statements using\\ndifferent client connections to the replica. When the timeout value is\\nreached, th"
  "e issuing client returns an error message and stops waiting,\\nbut the STOP REPLICA instruction remains in effect. Onc"
  "e the\\nreplication threads are no longer busy, the STOP REPLICA statement is\\nexecuted and the replica stops.\\n\\nSome"
  " CHANGE REPLICATION SOURCE TO statements are allowed while the\\nreplica is running, depending on the states of the re"
  "plication threads.\\nHowever, using STOP REPLICA prior to executing a CHANGE REPLICATION\\nSOURCE TO statement in such "
  "cases is still supported. See [HELP CHANGE\\nREPLICATION SOURCE TO], and\\nhttps://dev.mysql.com/doc/refman/8.4/en/repl"
  "ication-solutions-switch.html\\n, for more information.\\n\\nThe optional FOR CHANNEL channel clause enables you to name"
  " which\\nreplication channel the statement applies to. Providing a FOR CHANNEL\\nchannel clause applies the STOP REPLIC"
  "A statement to a specific\\nreplication channel. If no channel is named and no extra channels\\nexist, the statement ap"
  "plies to the default channel. If a STOP REPLICA\\nstatement does not name a channel when using multiple channels, this"
  "\\nstatement stops the specified threads for all channels. See\\nhttps://dev.mysql.com/doc/refman/8.4/en/replication-ch"
  "annels.html for\\nmore information.\\n\\nThe replication channels for Group Replication\\n(group_replication_applier and "
  "group_replication_recovery) are managed\\nautomatically by the server instance. STOP REPLICA cannot be used at\\nall wi"
  "th the group_replication_recovery channel, and should only be\\nused with the group_replication_applier channel when G"
  "roup Replication\\nis not running. The group_replication_applier channel only has an\\napplier thread and has no receiv"
  "er thread, so it can be stopped if\\nrequired by using the SQL_THREAD option without the IO_THREAD option.\\n\\nWhen the"
  " replica is multithreaded (replica_parallel_workers is a\\nnonzero value), any gaps in the sequence of transactions ex"
  "ecuted from\\nthe relay log are closed as part of stopping the worker threads. If the\\nreplica is stopped unexpectedly"
  " (for example due to an error in a\\nworker thread, or another thread issuing KILL) while a STOP REPLICA\\nstatement is"
  " executing, the sequence of executed transactions from the\\nrelay log may become inconsistent. See\\nhttps://dev.mysql"
  ".com/doc/refman/8.4/en/replication-features-transactio\\nn-inconsistencies.html, for more information.\\n\\nWhen the sou"
  "rce is using the row-based binary logging format, you\\nshould execute STOP REPLICA or STOP REPLICA SQL_THREAD on the "
  "replica\\nprior to shutting down the replica server if you are replicating any\\ntables that use a nontransactional sto"
  "rage engine. If the current\\nreplication event group has modified one or more nontransactional\\ntables, STOP REPLICA "
  "waits for up to 60 seconds for the event group to\\ncomplete, unless you issue a KILL QUERY or KILL CONNECTION stateme"
  "nt\\nfor the replication SQL thread. If the event group remains incomplete\\nafter the timeout, an error message is log"
  "ged.\\n\\nWhen the source is using the statement-based binary logging format,\\nchanging the source while it has open te"
  "mporary tables is potentially\\nunsafe. This is one of the reasons why statement-based replication of\\ntemporary table"
  "s is not recommended. You can find out whether there are\\nany temporary tables on the replica by checking the value o"
  "f\\nReplica_open_temp_tables. When using statement-based replication, this\\nvalue should be 0 before executing CHANGE "
  "REPLICATION SOURCE TO. If\\nthere are any temporary tables open on the replica, issuing a CHANGE\\nREPLICATION SOURCE T"
  "O statement after issuing a STOP REPLICA causes an\\nER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO\\n(https://dev.mysql.com/doc"
  "/mysql-errors/8.4/en/server-error-reference.html\\n#error_er_warn_open_temp_tables_must_be_zero) warning.\\n\\nURL: http"
  "s://dev.mysql.com/doc/refman/8.4/en/stop-replica.html\\n\\n','','https://dev.mysql.com/doc/refman/8.4/en/stop-replica.h"
  "tml');\n",
"INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (580,44,'PREPARE','Syntax:\\n"
  "PREPARE stmt_name FROM preparable_stmt\\n\\nThe PREPARE statement prepares a SQL statement and assigns it a name,\\nstmt"
  "_name, by which to refer to the statement later. The prepared\\nstatement is executed with EXECUTE and released with D"
  "EALLOCATE\\nPREPARE. For examples, see\\nhttps://dev.mysql.com/doc/refman/8.4/en/sql-prepared-statements.html.\\n\\nState"
  "ment names are not case-sensitive. preparable_stmt is either a\\nstring literal or a user variable that contains the t"
  "ext of the SQL\\nstatement. The text must represent a single statement, not multiple\\nstatements. Within the statement"
  ", ? characters can be used as parameter\\nmarkers to indicate where data values are to be bound to the query\\nlater wh"
  "en you execute it. The ? characters should not be enclosed\\nwithin quotation marks, even if you intend to bind them t"
  "o string\\nvalues. Parameter markers can be used only where data values should\\nappear, not for SQL keywords, identifi"
  "ers, and so forth.\\n\\nIf a prepared statement with the given name already exists, it is\\ndeallocated implicitly befor"
  "e the new statement is prepared. This means\\nthat if the new statement contains an error and cannot be prepared, an\\n"
  "error is returned and no statement with the given name exists.\\n\\nThe scope of a prepared statement is the session wi"
  "thin which it is\\ncreated, which as several implications:\\n\\no A prepared statement created in one session is not ava"
  "ilable to other\\n  sessions.\\n\\no When a session ends, whether normally or abnormally, its prepared\\n  statements no "
  "longer exist. If auto-reconnect is enabled, the client\\n  is not notified that the connection was lost. For this reas"
  "on,\\n  clients may wish to disable auto-reconnect. See Automatic\\n  Reconnection Control\\n  (https://dev.mysql.com/do"
  "c/c-api/8.4/en/c-api-auto-reconnect.html).\\n\\no A prepared statement created within a stored program continues to\\n  "
  "exist after the program finishes executing and can be executed\\n  outside the program later.\\n\\no A statement prepare"
  "d in stored program context cannot refer to stored\\n  procedure or function parameters or local variables because the"
  "y go\\n  out of scope when the program ends and would be unavailable were the\\n  statement to be executed later outsid"
  "e the program. As a workaround,\\n  refer instead to user-defined variables, which also have session\\n  scope; see\\n  "
  "https://dev.mysql.com/doc/refman/8.4/en/user-variables.html.\\n\\nThe type of a parameter used in a prepared statement "
  "is determined when\\nthe statement is first prepared; it retains this type whenever EXECUTE\\nis invoked for this prepa"
  "red statement (unless the statement is\\nreprepared, as explained later in this section). Rules for determining\\na par"
  "ameter\\'s type are listed here:\\n\\no A parameter which is an operand of a binary arithmetic operator has\\n  the same "
  "data type as the other operand.\\n\\no If both operands of a binary arithmetic operator are parameters, the\\n  type of "
  "the parameters is decided by the context of the operator.\\n\\no If a parameter is the operand of a unary arithmetic op"
  "erator, 