/* Indicator.c generated by valac 0.56.17, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*-
 * Copyright 2015-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "notifications.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <wingpanel.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <gmodule.h>

#define NOTIFICATIONS_INDICATOR_CHILD_SCHEMA_ID "io.elementary.notifications.applications"
#define NOTIFICATIONS_INDICATOR_CHILD_PATH "/io/elementary/notifications/applications/%s/"
#define NOTIFICATIONS_INDICATOR_REMEMBER_KEY "remember"
#define NOTIFICATIONS_GETTEXT_PACKAGE "notifications-indicator"
#define NOTIFICATIONS_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _NotificationsNotificationsMonitor NotificationsNotificationsMonitor;
typedef struct _NotificationsNotificationsMonitorClass NotificationsNotificationsMonitorClass;
enum  {
	NOTIFICATIONS_INDICATOR_0_PROPERTY,
	NOTIFICATIONS_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* notifications_indicator_properties[NOTIFICATIONS_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NotificationsIndicatorLoadSessionNotificationsData NotificationsIndicatorLoadSessionNotificationsData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _NotificationsIndicatorPrivate {
	GeeHashMap* app_settings_cache;
	GSettings* notify_settings;
	GtkGrid* main_box;
	GtkModelButton* clear_all_btn;
	GtkSpinner* dynamic_icon;
	NotificationsNotificationsList* nlist;
	GList* previous_session;
	NotificationsNotificationsMonitor* monitor;
};

struct _NotificationsIndicatorLoadSessionNotificationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NotificationsIndicator* self;
	GList* _tmp0_;
	GList* notification_collection;
	GList* notification_it;
	NotificationsNotification* _tmp1_;
	NotificationsNotification* notification;
	NotificationsNotificationsList* _tmp2_;
	NotificationsNotification* _tmp3_;
};

static gint NotificationsIndicator_private_offset;
static gpointer notifications_indicator_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GtkWidget* notifications_indicator_real_get_display_widget (WingpanelIndicator* base);
static void notifications_indicator_on_notification_received (NotificationsIndicator* self,
                                                       GDBusMessage* message,
                                                       guint32 id);
static void _notifications_indicator_on_notification_received_notifications_notifications_monitor_notification_received (NotificationsNotificationsMonitor* _sender,
                                                                                                                  GDBusMessage* message,
                                                                                                                  guint32 id,
                                                                                                                  gpointer self);
static void notifications_indicator_on_notification_closed (NotificationsIndicator* self,
                                                     guint32 id,
                                                     NotificationsNotificationCloseReason reason);
static void _notifications_indicator_on_notification_closed_notifications_notifications_monitor_notification_closed (NotificationsNotificationsMonitor* _sender,
                                                                                                              guint32 id,
                                                                                                              NotificationsNotificationCloseReason reason,
                                                                                                              gpointer self);
static void ___lambda21_ (NotificationsIndicator* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda21__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda22_ (NotificationsIndicator* self);
static void notifications_indicator_set_display_icon_name (NotificationsIndicator* self);
static void ____lambda22__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static gboolean ___lambda23_ (NotificationsIndicator* self,
                       GdkEventButton* e);
static gboolean ____lambda23__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean ___lambda24_ (NotificationsIndicator* self);
static void notifications_indicator_load_session_notifications (NotificationsIndicator* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void notifications_indicator_load_session_notifications_finish (NotificationsIndicator* self,
                                                                GAsyncResult* _res_);
static void __lambda25_ (NotificationsIndicator* self);
static void _notifications_indicator_set_display_icon_name_gtk_container_add (GtkContainer* _sender,
                                                                       GtkWidget* widget,
                                                                       gpointer self);
static void _notifications_indicator_set_display_icon_name_gtk_container_remove (GtkContainer* _sender,
                                                                          GtkWidget* widget,
                                                                          gpointer self);
static void ___lambda25__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ____lambda24__gsource_func (gpointer self);
static void notifications_indicator_load_session_notifications_data_free (gpointer _data);
static gboolean notifications_indicator_load_session_notifications_co (NotificationsIndicatorLoadSessionNotificationsData* _data_);
static void notifications_indicator_load_session_notifications_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static GtkWidget* notifications_indicator_real_get_widget (WingpanelIndicator* base);
static void ___lambda26_ (NotificationsIndicator* self);
static void ____lambda26__notifications_notifications_list_close_popover (NotificationsNotificationsList* _sender,
                                                                   gpointer self);
static void notifications_indicator_update_clear_all_sensitivity (NotificationsIndicator* self);
static void _notifications_indicator_update_clear_all_sensitivity_gtk_container_add (GtkContainer* _sender,
                                                                              GtkWidget* widget,
                                                                              gpointer self);
static void _notifications_indicator_update_clear_all_sensitivity_gtk_container_remove (GtkContainer* _sender,
                                                                                 GtkWidget* widget,
                                                                                 gpointer self);
static void ___lambda27_ (NotificationsIndicator* self);
static void ____lambda27__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void notifications_indicator_show_settings (NotificationsIndicator* self);
static void _notifications_indicator_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void notifications_indicator_real_opened (WingpanelIndicator* base);
static void notifications_indicator_real_closed (WingpanelIndicator* base);
static gint __lambda20_ (NotificationsNotificationEntry* e,
                  guint32 i);
static gint ___lambda20__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void notifications_indicator_update_tooltip (NotificationsIndicator* self);
static GObject * notifications_indicator_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void notifications_indicator_finalize (GObject * obj);
static GType notifications_indicator_get_type_once (void);

static inline gpointer
notifications_indicator_get_instance_private (NotificationsIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsIndicator_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

NotificationsIndicator*
notifications_indicator_construct (GType object_type)
{
	NotificationsIndicator * self = NULL;
	self = (NotificationsIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_MESSAGES, "visible", TRUE, NULL);
	return self;
}

NotificationsIndicator*
notifications_indicator_new (void)
{
	return notifications_indicator_construct (NOTIFICATIONS_TYPE_INDICATOR);
}

static void
_notifications_indicator_on_notification_received_notifications_notifications_monitor_notification_received (NotificationsNotificationsMonitor* _sender,
                                                                                                             GDBusMessage* message,
                                                                                                             guint32 id,
                                                                                                             gpointer self)
{
	notifications_indicator_on_notification_received ((NotificationsIndicator*) self, message, id);
}

static void
_notifications_indicator_on_notification_closed_notifications_notifications_monitor_notification_closed (NotificationsNotificationsMonitor* _sender,
                                                                                                         guint32 id,
                                                                                                         NotificationsNotificationCloseReason reason,
                                                                                                         gpointer self)
{
	notifications_indicator_on_notification_closed ((NotificationsIndicator*) self, id, reason);
}

static void
___lambda21_ (NotificationsIndicator* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		notifications_notifications_monitor_init_finish (G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_NOTIFICATIONS_MONITOR, NotificationsNotificationsMonitor), res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("Indicator.vala:73: Unable to monitor notifications bus: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda21__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda21_ ((NotificationsIndicator*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda22_ (NotificationsIndicator* self)
{
	notifications_indicator_set_display_icon_name (self);
}

static void
____lambda22__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda22_ ((NotificationsIndicator*) self);
}

static gboolean
___lambda23_ (NotificationsIndicator* self,
              GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) GDK_BUTTON_MIDDLE)) {
		GSettings* _tmp0_;
		GSettings* _tmp1_;
		_tmp0_ = self->priv->notify_settings;
		_tmp1_ = self->priv->notify_settings;
		g_settings_set_boolean (_tmp0_, "do-not-disturb", !g_settings_get_boolean (_tmp1_, "do-not-disturb"));
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda23__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = ___lambda23_ ((NotificationsIndicator*) self, event);
	return result;
}

static void
_notifications_indicator_set_display_icon_name_gtk_container_add (GtkContainer* _sender,
                                                                  GtkWidget* widget,
                                                                  gpointer self)
{
	notifications_indicator_set_display_icon_name ((NotificationsIndicator*) self);
}

static void
_notifications_indicator_set_display_icon_name_gtk_container_remove (GtkContainer* _sender,
                                                                     GtkWidget* widget,
                                                                     gpointer self)
{
	notifications_indicator_set_display_icon_name ((NotificationsIndicator*) self);
}

static void
__lambda25_ (NotificationsIndicator* self)
{
	NotificationsNotificationsList* _tmp0_;
	NotificationsNotificationsList* _tmp1_;
	notifications_indicator_set_display_icon_name (self);
	_tmp0_ = self->priv->nlist;
	g_signal_connect_object ((GtkContainer*) _tmp0_, "add", (GCallback) _notifications_indicator_set_display_icon_name_gtk_container_add, self, 0);
	_tmp1_ = self->priv->nlist;
	g_signal_connect_object ((GtkContainer*) _tmp1_, "remove", (GCallback) _notifications_indicator_set_display_icon_name_gtk_container_remove, self, 0);
}

static void
___lambda25__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda25_ ((NotificationsIndicator*) self);
	g_object_unref (self);
}

static gboolean
___lambda24_ (NotificationsIndicator* self)
{
	gboolean result;
	notifications_indicator_load_session_notifications (self, ___lambda25__gasync_ready_callback, g_object_ref (self));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda24__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda24_ ((NotificationsIndicator*) self);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
notifications_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	NotificationsIndicator * self;
	GtkSpinner* _tmp0_;
	GtkSpinner* _tmp19_;
	GtkWidget* _tmp20_;
	GtkWidget* result;
	self = (NotificationsIndicator*) base;
	_tmp0_ = self->priv->dynamic_icon;
	if (_tmp0_ == NULL) {
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp1_;
		GtkCssProvider* _tmp2_;
		gchar* _tmp3_;
		GtkSpinner* _tmp4_ = NULL;
		GtkStyleContext* dynamic_icon_style_context = NULL;
		GtkSpinner* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkCssProvider* _tmp8_;
		GtkStyleContext* _tmp9_;
		NotificationsNotificationsList* _tmp10_;
		NotificationsNotificationsMonitor* _tmp11_;
		NotificationsNotificationsMonitor* _tmp12_;
		NotificationsNotificationsMonitor* _tmp13_;
		GSettings* _tmp14_;
		GtkSpinner* _tmp15_;
		NotificationsSession* _tmp16_;
		NotificationsSession* _tmp17_;
		GList* _tmp18_;
		_tmp1_ = gtk_css_provider_new ();
		provider = _tmp1_;
		_tmp2_ = provider;
		gtk_css_provider_load_from_resource (_tmp2_, "io/elementary/wingpanel/notifications/indicator.css");
		_tmp3_ = g_strdup (_ ("Updating notifications…"));
		_tmp4_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_set (_tmp4_, "active", TRUE, NULL);
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp3_);
		_g_free0 (_tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->dynamic_icon);
		self->priv->dynamic_icon = _tmp4_;
		_tmp5_ = self->priv->dynamic_icon;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
		dynamic_icon_style_context = _tmp6_;
		_tmp7_ = dynamic_icon_style_context;
		_tmp8_ = provider;
		gtk_style_context_add_provider (_tmp7_, (GtkStyleProvider*) _tmp8_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_tmp9_ = dynamic_icon_style_context;
		gtk_style_context_add_class (_tmp9_, "notification-icon");
		_tmp10_ = notifications_notifications_list_new ();
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (self->priv->nlist);
		self->priv->nlist = _tmp10_;
		_tmp11_ = self->priv->monitor;
		g_signal_connect_object (_tmp11_, "notification-received", (GCallback) _notifications_indicator_on_notification_received_notifications_notifications_monitor_notification_received, self, 0);
		_tmp12_ = self->priv->monitor;
		g_signal_connect_object (_tmp12_, "notification-closed", (GCallback) _notifications_indicator_on_notification_closed_notifications_notifications_monitor_notification_closed, self, 0);
		_tmp13_ = self->priv->monitor;
		notifications_notifications_monitor_init (_tmp13_, ____lambda21__gasync_ready_callback, g_object_ref (self));
		_tmp14_ = self->priv->notify_settings;
		g_signal_connect_object (_tmp14_, "changed::do-not-disturb", (GCallback) ____lambda22__g_settings_changed, self, 0);
		_tmp15_ = self->priv->dynamic_icon;
		g_signal_connect_object ((GtkWidget*) _tmp15_, "button-press-event", (GCallback) ____lambda23__gtk_widget_button_press_event, self, 0);
		_tmp16_ = notifications_session_get_instance ();
		_tmp17_ = _tmp16_;
		_tmp18_ = notifications_session_get_session_notifications (_tmp17_);
		(self->priv->previous_session == NULL) ? NULL : (self->priv->previous_session = (_g_list_free__g_object_unref0_ (self->priv->previous_session), NULL));
		self->priv->previous_session = _tmp18_;
		_g_object_unref0 (_tmp17_);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, ____lambda24__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (provider);
	}
	_tmp19_ = self->priv->dynamic_icon;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	result = _tmp20_;
	return result;
}

static void
notifications_indicator_load_session_notifications_data_free (gpointer _data)
{
	NotificationsIndicatorLoadSessionNotificationsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NotificationsIndicatorLoadSessionNotificationsData, _data_);
}

static void
notifications_indicator_load_session_notifications (NotificationsIndicator* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	NotificationsIndicatorLoadSessionNotificationsData* _data_;
	NotificationsIndicator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NotificationsIndicatorLoadSessionNotificationsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, notifications_indicator_load_session_notifications_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	notifications_indicator_load_session_notifications_co (_data_);
}

static void
notifications_indicator_load_session_notifications_finish (NotificationsIndicator* self,
                                                           GAsyncResult* _res_)
{
	NotificationsIndicatorLoadSessionNotificationsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
notifications_indicator_load_session_notifications_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	NotificationsIndicatorLoadSessionNotificationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	notifications_indicator_load_session_notifications_co (_data_);
}

static gboolean
notifications_indicator_load_session_notifications_co (NotificationsIndicatorLoadSessionNotificationsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->previous_session;
	{
		_data_->notification_collection = _data_->_tmp0_;
		for (_data_->notification_it = _data_->notification_collection; _data_->notification_it != NULL; _data_->notification_it = _data_->notification_it->next) {
			_data_->_tmp1_ = _g_object_ref0 ((NotificationsNotification*) _data_->notification_it->data);
			_data_->notification = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->self->priv->nlist;
				_data_->_tmp3_ = _data_->notification;
				_data_->_state_ = 1;
				notifications_notifications_list_add_entry (_data_->_tmp2_, _data_->_tmp3_, FALSE, notifications_indicator_load_session_notifications_ready, _data_);
				return FALSE;
				_state_1:
				notifications_notifications_list_add_entry_finish (_data_->_tmp2_, _data_->_res_);
				_g_object_unref0 (_data_->notification);
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
___lambda26_ (NotificationsIndicator* self)
{
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
}

static void
____lambda26__notifications_notifications_list_close_popover (NotificationsNotificationsList* _sender,
                                                              gpointer self)
{
	___lambda26_ ((NotificationsIndicator*) self);
}

static void
_notifications_indicator_update_clear_all_sensitivity_gtk_container_add (GtkContainer* _sender,
                                                                         GtkWidget* widget,
                                                                         gpointer self)
{
	notifications_indicator_update_clear_all_sensitivity ((NotificationsIndicator*) self);
}

static void
_notifications_indicator_update_clear_all_sensitivity_gtk_container_remove (GtkContainer* _sender,
                                                                            GtkWidget* widget,
                                                                            gpointer self)
{
	notifications_indicator_update_clear_all_sensitivity ((NotificationsIndicator*) self);
}

static void
___lambda27_ (NotificationsIndicator* self)
{
	NotificationsNotificationsList* _tmp0_;
	_tmp0_ = self->priv->nlist;
	notifications_notifications_list_clear_all (_tmp0_);
}

static void
____lambda27__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda27_ ((NotificationsIndicator*) self);
}

static void
_notifications_indicator_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	notifications_indicator_show_settings ((NotificationsIndicator*) self);
}

static GtkWidget*
notifications_indicator_real_get_widget (WingpanelIndicator* base)
{
	NotificationsIndicator * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp39_;
	GtkWidget* _tmp40_;
	GtkWidget* result;
	self = (NotificationsIndicator*) base;
	_tmp0_ = self->priv->main_box;
	if (_tmp0_ == NULL) {
		GraniteSwitchModelButton* not_disturb_switch = NULL;
		GraniteSwitchModelButton* _tmp1_;
		GraniteSwitchModelButton* _tmp2_;
		GtkStyleContext* _tmp3_;
		GtkSeparator* dnd_switch_separator = NULL;
		GtkSeparator* _tmp4_ = NULL;
		GtkScrolledWindow* scrolled = NULL;
		GtkScrolledWindow* _tmp5_;
		GtkScrolledWindow* _tmp6_;
		GtkScrolledWindow* _tmp7_;
		GtkScrolledWindow* _tmp8_;
		GtkScrolledWindow* _tmp9_;
		NotificationsNotificationsList* _tmp10_;
		GtkSeparator* clear_all_btn_separator = NULL;
		GtkSeparator* _tmp11_ = NULL;
		GtkModelButton* _tmp12_;
		GtkModelButton* _tmp13_;
		GtkModelButton* settings_btn = NULL;
		GtkModelButton* _tmp14_;
		GtkModelButton* _tmp15_;
		GtkGrid* _tmp16_;
		GtkGrid* _tmp17_;
		GtkGrid* _tmp18_;
		GtkGrid* _tmp19_;
		GraniteSwitchModelButton* _tmp20_;
		GtkGrid* _tmp21_;
		GtkSeparator* _tmp22_;
		GtkGrid* _tmp23_;
		GtkScrolledWindow* _tmp24_;
		GtkGrid* _tmp25_;
		GtkSeparator* _tmp26_;
		GtkGrid* _tmp27_;
		GtkModelButton* _tmp28_;
		GtkGrid* _tmp29_;
		GtkModelButton* _tmp30_;
		GtkGrid* _tmp31_;
		GSettings* _tmp32_;
		GraniteSwitchModelButton* _tmp33_;
		NotificationsNotificationsList* _tmp34_;
		NotificationsNotificationsList* _tmp35_;
		NotificationsNotificationsList* _tmp36_;
		GtkModelButton* _tmp37_;
		GtkModelButton* _tmp38_;
		_tmp1_ = granite_switch_model_button_new (_ ("Do Not Disturb"));
		g_object_ref_sink (_tmp1_);
		not_disturb_switch = _tmp1_;
		_tmp2_ = not_disturb_switch;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
		gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_H4_LABEL);
		_tmp4_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp4_, 3);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp4_, 3);
		g_object_ref_sink (_tmp4_);
		dnd_switch_separator = _tmp4_;
		_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		g_object_ref_sink (_tmp5_);
		scrolled = _tmp5_;
		_tmp6_ = scrolled;
		g_object_set (_tmp6_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
		_tmp7_ = scrolled;
		gtk_scrolled_window_set_max_content_height (_tmp7_, 500);
		_tmp8_ = scrolled;
		gtk_scrolled_window_set_propagate_natural_height (_tmp8_, TRUE);
		_tmp9_ = scrolled;
		_tmp10_ = self->priv->nlist;
		gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 3);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 3);
		g_object_ref_sink (_tmp11_);
		clear_all_btn_separator = _tmp11_;
		_tmp12_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->priv->clear_all_btn);
		self->priv->clear_all_btn = _tmp12_;
		_tmp13_ = self->priv->clear_all_btn;
		g_object_set (_tmp13_, "text", _ ("Clear All Notifications"), NULL);
		_tmp14_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_ref_sink (_tmp14_);
		settings_btn = _tmp14_;
		_tmp15_ = settings_btn;
		g_object_set (_tmp15_, "text", _ ("Notifications Settings…"), NULL);
		_tmp16_ = (GtkGrid*) gtk_grid_new ();
		g_object_ref_sink (_tmp16_);
		_g_object_unref0 (self->priv->main_box);
		self->priv->main_box = _tmp16_;
		_tmp17_ = self->priv->main_box;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp17_, GTK_ORIENTATION_VERTICAL);
		_tmp18_ = self->priv->main_box;
		g_object_set ((GtkWidget*) _tmp18_, "width-request", 360, NULL);
		_tmp19_ = self->priv->main_box;
		_tmp20_ = not_disturb_switch;
		gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
		_tmp21_ = self->priv->main_box;
		_tmp22_ = dnd_switch_separator;
		gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
		_tmp23_ = self->priv->main_box;
		_tmp24_ = scrolled;
		gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->main_box;
		_tmp26_ = clear_all_btn_separator;
		gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
		_tmp27_ = self->priv->main_box;
		_tmp28_ = self->priv->clear_all_btn;
		gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->main_box;
		_tmp30_ = settings_btn;
		gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
		_tmp31_ = self->priv->main_box;
		gtk_widget_show_all ((GtkWidget*) _tmp31_);
		_tmp32_ = self->priv->notify_settings;
		_tmp33_ = not_disturb_switch;
		g_settings_bind (_tmp32_, "do-not-disturb", (GObject*) _tmp33_, "active", G_SETTINGS_BIND_DEFAULT);
		_tmp34_ = self->priv->nlist;
		g_signal_connect_object (_tmp34_, "close-popover", (GCallback) ____lambda26__notifications_notifications_list_close_popover, self, 0);
		_tmp35_ = self->priv->nlist;
		g_signal_connect_object ((GtkContainer*) _tmp35_, "add", (GCallback) _notifications_indicator_update_clear_all_sensitivity_gtk_container_add, self, 0);
		_tmp36_ = self->priv->nlist;
		g_signal_connect_object ((GtkContainer*) _tmp36_, "remove", (GCallback) _notifications_indicator_update_clear_all_sensitivity_gtk_container_remove, self, 0);
		_tmp37_ = self->priv->clear_all_btn;
		g_signal_connect_object ((GtkButton*) _tmp37_, "clicked", (GCallback) ____lambda27__gtk_button_clicked, self, 0);
		_tmp38_ = settings_btn;
		g_signal_connect_object ((GtkButton*) _tmp38_, "clicked", (GCallback) _notifications_indicator_show_settings_gtk_button_clicked, self, 0);
		_g_object_unref0 (settings_btn);
		_g_object_unref0 (clear_all_btn_separator);
		_g_object_unref0 (scrolled);
		_g_object_unref0 (dnd_switch_separator);
		_g_object_unref0 (not_disturb_switch);
	}
	_tmp39_ = self->priv->main_box;
	_tmp40_ = _g_object_ref0 ((GtkWidget*) _tmp39_);
	result = _tmp40_;
	return result;
}

static void
notifications_indicator_real_opened (WingpanelIndicator* base)
{
	NotificationsIndicator * self;
	self = (NotificationsIndicator*) base;
	notifications_indicator_update_clear_all_sensitivity (self);
}

static void
notifications_indicator_real_closed (WingpanelIndicator* base)
{
	NotificationsIndicator * self;
	self = (NotificationsIndicator*) base;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
notifications_indicator_on_notification_received (NotificationsIndicator* self,
                                                  GDBusMessage* message,
                                                  guint32 id)
{
	NotificationsNotification* notification = NULL;
	NotificationsNotification* _tmp0_;
	gchar* app_id = NULL;
	NotificationsNotification* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* app_settings = NULL;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp7_;
	GSettingsSchema* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GSettingsSchema* _tmp11_;
	gboolean _tmp22_ = FALSE;
	GSettings* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = notifications_notification_new_from_message (message, id);
	notification = _tmp0_;
	_tmp1_ = notification;
	_tmp2_ = _tmp1_->desktop_id;
	_tmp3_ = string_replace (_tmp2_, NOTIFICATIONS_NOTIFICATION_DESKTOP_ID_EXT, "");
	app_id = _tmp3_;
	_tmp4_ = self->priv->app_settings_cache;
	_tmp5_ = app_id;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
	app_settings = (GSettings*) _tmp6_;
	_tmp7_ = g_settings_schema_source_get_default ();
	_tmp8_ = g_settings_schema_source_lookup (_tmp7_, NOTIFICATIONS_INDICATOR_CHILD_SCHEMA_ID, TRUE);
	schema = _tmp8_;
	_tmp11_ = schema;
	if (_tmp11_ != NULL) {
		GSettings* _tmp12_;
		_tmp12_ = app_settings;
		_tmp10_ = _tmp12_ == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp13_;
		_tmp13_ = app_id;
		_tmp9_ = g_strcmp0 (_tmp13_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GSettingsSchema* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GSettings* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		GSettings* _tmp21_;
		_tmp14_ = schema;
		_tmp15_ = app_id;
		_tmp16_ = g_strdup_printf (NOTIFICATIONS_INDICATOR_CHILD_PATH, _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_settings_new_full (_tmp14_, NULL, _tmp17_);
		_g_object_unref0 (app_settings);
		app_settings = _tmp18_;
		_g_free0 (_tmp17_);
		_tmp19_ = self->priv->app_settings_cache;
		_tmp20_ = app_id;
		_tmp21_ = app_settings;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp20_, _tmp21_);
	}
	_tmp23_ = app_settings;
	if (_tmp23_ == NULL) {
		_tmp22_ = TRUE;
	} else {
		GSettings* _tmp24_;
		_tmp24_ = app_settings;
		_tmp22_ = g_settings_get_boolean (_tmp24_, NOTIFICATIONS_INDICATOR_REMEMBER_KEY);
	}
	if (_tmp22_) {
		NotificationsNotificationsList* _tmp25_;
		NotificationsNotification* _tmp26_;
		_tmp25_ = self->priv->nlist;
		_tmp26_ = notification;
		notifications_notifications_list_add_entry (_tmp25_, _tmp26_, TRUE, NULL, NULL);
	}
	notifications_indicator_set_display_icon_name (self);
	_g_settings_schema_unref0 (schema);
	_g_object_unref0 (app_settings);
	_g_free0 (app_id);
	_g_object_unref0 (notification);
}

static void
notifications_indicator_update_clear_all_sensitivity (NotificationsIndicator* self)
{
	GtkModelButton* _tmp0_;
	NotificationsNotificationsList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clear_all_btn;
	_tmp1_ = self->priv->nlist;
	_tmp2_ = notifications_notifications_list_get_app_entries (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp5_ > 0);
}

static gint
__lambda20_ (NotificationsNotificationEntry* e,
             guint32 i)
{
	gint _tmp0_ = 0;
	NotificationsNotification* _tmp1_;
	NotificationsNotification* _tmp2_;
	guint32 _tmp3_;
	guint32 _tmp4_;
	gint result;
	g_return_val_if_fail (e != NULL, 0);
	_tmp1_ = notifications_notification_entry_get_notification (e);
	_tmp2_ = _tmp1_;
	_tmp3_ = notifications_notification_get_server_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (i == _tmp4_) {
		_tmp0_ = 0;
	} else {
		gint _tmp5_ = 0;
		NotificationsNotification* _tmp6_;
		NotificationsNotification* _tmp7_;
		guint32 _tmp8_;
		guint32 _tmp9_;
		_tmp6_ = notifications_notification_entry_get_notification (e);
		_tmp7_ = _tmp6_;
		_tmp8_ = notifications_notification_get_server_id (_tmp7_);
		_tmp9_ = _tmp8_;
		if (i > _tmp9_) {
			_tmp5_ = 1;
		} else {
			_tmp5_ = -1;
		}
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static gint
___lambda20__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda20_ ((NotificationsNotificationEntry*) a, (guint32) ((guintptr) b));
	return result;
}

static void
notifications_indicator_on_notification_closed (NotificationsIndicator* self,
                                                guint32 id,
                                                NotificationsNotificationCloseReason reason)
{
	GCompareFunc find_entry = NULL;
	g_return_if_fail (self != NULL);
	find_entry = ___lambda20__gcompare_func;
	{
		GeeIterator* _app_entry_it = NULL;
		NotificationsNotificationsList* _tmp0_;
		GeeHashMap* _tmp1_;
		GeeHashMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp0_ = self->priv->nlist;
		_tmp1_ = notifications_notifications_list_get_app_entries (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_app_entry_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			NotificationsAppEntry* app_entry = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GList* node = NULL;
			NotificationsAppEntry* _tmp11_;
			GList* _tmp12_;
			GCompareFunc _tmp13_;
			GList* _tmp14_;
			GList* _tmp15_;
			_tmp8_ = _app_entry_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _app_entry_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			app_entry = (NotificationsAppEntry*) _tmp10_;
			_tmp11_ = app_entry;
			_tmp12_ = _tmp11_->app_notifications;
			_tmp13_ = find_entry;
			_tmp14_ = g_list_find_custom (_tmp12_, (gpointer) ((guintptr) id), _tmp13_);
			node = _tmp14_;
			_tmp15_ = node;
			if (_tmp15_ != NULL) {
				GList* _tmp16_;
				gconstpointer _tmp17_;
				NotificationsNotification* _tmp18_;
				NotificationsNotification* _tmp19_;
				GList* _tmp20_;
				gconstpointer _tmp21_;
				_tmp16_ = node;
				_tmp17_ = _tmp16_->data;
				_tmp18_ = notifications_notification_entry_get_notification ((NotificationsNotificationEntry*) _tmp17_);
				_tmp19_ = _tmp18_;
				notifications_notification_set_server_id (_tmp19_, (guint32) 0);
				_tmp20_ = node;
				_tmp21_ = _tmp20_->data;
				g_signal_emit_by_name ((NotificationsNotificationEntry*) _tmp21_, "clear");
				_g_object_unref0 (app_entry);
				_g_object_unref0 (_app_entry_it);
				return;
			}
			_g_object_unref0 (app_entry);
		}
		_g_object_unref0 (_app_entry_it);
	}
}

static void
notifications_indicator_set_display_icon_name (NotificationsIndicator* self)
{
	GtkStyleContext* dynamic_icon_style_context = NULL;
	GtkSpinner* _tmp0_;
	GtkStyleContext* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dynamic_icon;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	dynamic_icon_style_context = _tmp1_;
	_tmp2_ = self->priv->notify_settings;
	if (g_settings_get_boolean (_tmp2_, "do-not-disturb")) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = dynamic_icon_style_context;
		gtk_style_context_add_class (_tmp3_, "disabled");
	} else {
		gboolean _tmp4_ = FALSE;
		NotificationsNotificationsList* _tmp5_;
		_tmp5_ = self->priv->nlist;
		if (_tmp5_ != NULL) {
			NotificationsNotificationsList* _tmp6_;
			GeeHashMap* _tmp7_;
			GeeHashMap* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_tmp6_ = self->priv->nlist;
			_tmp7_ = notifications_notifications_list_get_app_entries (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = _tmp10_ > 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkStyleContext* _tmp11_;
			GtkStyleContext* _tmp12_;
			_tmp11_ = dynamic_icon_style_context;
			gtk_style_context_remove_class (_tmp11_, "disabled");
			_tmp12_ = dynamic_icon_style_context;
			gtk_style_context_add_class (_tmp12_, "new");
		} else {
			GtkStyleContext* _tmp13_;
			GtkStyleContext* _tmp14_;
			_tmp13_ = dynamic_icon_style_context;
			gtk_style_context_remove_class (_tmp13_, "disabled");
			_tmp14_ = dynamic_icon_style_context;
			gtk_style_context_remove_class (_tmp14_, "new");
		}
	}
	notifications_indicator_update_tooltip (self);
}

static void
notifications_indicator_show_settings (NotificationsIndicator* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	{
		g_app_info_launch_default_for_uri ("settings://notifications", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Indicator.vala:231: Failed to open notifications settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
notifications_indicator_update_tooltip (NotificationsIndicator* self)
{
	guint number_of_apps = 0U;
	guint number_of_notifications = 0U;
	NotificationsNotificationsList* _tmp0_;
	guint _tmp1_ = 0U;
	guint _tmp2_;
	gchar* description = NULL;
	gchar* accel_label = NULL;
	GSettings* _tmp3_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GtkSpinner* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	number_of_apps = (guint) 0;
	_tmp0_ = self->priv->nlist;
	_tmp2_ = notifications_notifications_list_count_notifications (_tmp0_, &_tmp1_);
	number_of_apps = _tmp1_;
	number_of_notifications = _tmp2_;
	_tmp3_ = self->priv->notify_settings;
	if (g_settings_get_boolean (_tmp3_, "do-not-disturb")) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("Middle-click to disable Do Not Disturb"));
		_g_free0 (accel_label);
		accel_label = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Middle-click to enable Do Not Disturb"));
		_g_free0 (accel_label);
		accel_label = _tmp5_;
	}
	_tmp6_ = accel_label;
	_tmp7_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp6_);
	_g_free0 (accel_label);
	accel_label = _tmp7_;
	switch (number_of_notifications) {
		case 0:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("No notifications"));
			_g_free0 (description);
			description = _tmp8_;
			break;
		}
		case 1:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("1 notification"));
			_g_free0 (description);
			description = _tmp9_;
			break;
		}
		default:
		{
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = g_strdup_printf (g_dngettext (NOTIFICATIONS_GETTEXT_PACKAGE, "%u notification", "%u notifications", (gulong) number_of_notifications), number_of_notifications);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf (g_dngettext (NOTIFICATIONS_GETTEXT_PACKAGE, "%u app", "%u apps", (gulong) number_of_apps), number_of_apps);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf (_ ("%s from %s"), _tmp11_, _tmp13_);
			_g_free0 (description);
			description = _tmp14_;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			break;
		}
	}
	_tmp15_ = self->priv->dynamic_icon;
	_tmp16_ = description;
	_tmp17_ = accel_label;
	_tmp18_ = g_strdup_printf ("%s\n%s", _tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp15_, _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (accel_label);
	_g_free0 (description);
}

static GObject *
notifications_indicator_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NotificationsIndicator * self;
	GSettings* _tmp0_;
	GeeHashMap* _tmp1_;
	NotificationsNotificationsMonitor* _tmp2_;
	parent_class = G_OBJECT_CLASS (notifications_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_INDICATOR, NotificationsIndicator);
	bindtextdomain (NOTIFICATIONS_GETTEXT_PACKAGE, NOTIFICATIONS_LOCALEDIR);
	bind_textdomain_codeset (NOTIFICATIONS_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_settings_new ("io.elementary.notifications");
	_g_object_unref0 (self->priv->notify_settings);
	self->priv->notify_settings = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_settings_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->app_settings_cache);
	self->priv->app_settings_cache = _tmp1_;
	_tmp2_ = notifications_notifications_monitor_new ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp2_;
	return obj;
}

static void
notifications_indicator_class_init (NotificationsIndicatorClass * klass,
                                    gpointer klass_data)
{
	notifications_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) notifications_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) notifications_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) notifications_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) notifications_indicator_real_closed;
	G_OBJECT_CLASS (klass)->constructor = notifications_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = notifications_indicator_finalize;
}

static void
notifications_indicator_instance_init (NotificationsIndicator * self,
                                       gpointer klass)
{
	self->priv = notifications_indicator_get_instance_private (self);
	self->priv->main_box = NULL;
	self->priv->dynamic_icon = NULL;
	self->priv->previous_session = NULL;
}

static void
notifications_indicator_finalize (GObject * obj)
{
	NotificationsIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_INDICATOR, NotificationsIndicator);
	_g_object_unref0 (self->priv->app_settings_cache);
	_g_object_unref0 (self->priv->notify_settings);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->clear_all_btn);
	_g_object_unref0 (self->priv->dynamic_icon);
	_g_object_unref0 (self->priv->nlist);
	(self->priv->previous_session == NULL) ? NULL : (self->priv->previous_session = (_g_list_free__g_object_unref0_ (self->priv->previous_session), NULL));
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (notifications_indicator_parent_class)->finalize (obj);
}

static GType
notifications_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsIndicator), 0, (GInstanceInitFunc) notifications_indicator_instance_init, NULL };
	GType notifications_indicator_type_id;
	notifications_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "NotificationsIndicator", &g_define_type_info, 0);
	NotificationsIndicator_private_offset = g_type_add_instance_private (notifications_indicator_type_id, sizeof (NotificationsIndicatorPrivate));
	return notifications_indicator_type_id;
}

GType
notifications_indicator_get_type (void)
{
	static volatile gsize notifications_indicator_type_id__once = 0;
	if (g_once_init_enter (&notifications_indicator_type_id__once)) {
		GType notifications_indicator_type_id;
		notifications_indicator_type_id = notifications_indicator_get_type_once ();
		g_once_init_leave (&notifications_indicator_type_id__once, notifications_indicator_type_id);
	}
	return notifications_indicator_type_id__once;
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	NotificationsIndicator* indicator = NULL;
	NotificationsIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:271: Activating Notifications Indicator");
	if (server_type != WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		result = NULL;
		return result;
	}
	_tmp0_ = notifications_indicator_new ();
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

