/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPositionOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PositionOptions>> convertDictionary<PositionOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PositionOptions result;
    JSValue enableHighAccuracyValue;
    if (isNullOrUndefined)
        enableHighAccuracyValue = jsUndefined();
    else {
        enableHighAccuracyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "enableHighAccuracy"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto enableHighAccuracyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, enableHighAccuracyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (enableHighAccuracyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.enableHighAccuracy = enableHighAccuracyConversionResult.releaseReturnValue();
    JSValue maximumAgeValue;
    if (isNullOrUndefined)
        maximumAgeValue = jsUndefined();
    else {
        maximumAgeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maximumAge"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto maximumAgeConversionResult = convertOptionalWithDefault<IDLClampAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, maximumAgeValue, [&]() -> ConversionResult<IDLClampAdaptor<IDLUnsignedLong>> { return Converter<IDLClampAdaptor<IDLUnsignedLong>>::ReturnType { 0 }; });
    if (maximumAgeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.maximumAge = maximumAgeConversionResult.releaseReturnValue();
    JSValue timeoutValue;
    if (isNullOrUndefined)
        timeoutValue = jsUndefined();
    else {
        timeoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timeout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto timeoutConversionResult = convertOptionalWithDefault<IDLClampAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, timeoutValue, [&]() -> ConversionResult<IDLClampAdaptor<IDLUnsignedLong>> { return Converter<IDLClampAdaptor<IDLUnsignedLong>>::ReturnType { 0xFFFFFFFF }; });
    if (timeoutConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.timeout = timeoutConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

