const char metrics_collectors_histogram_lua[] =
"local Shared = require('metrics.collectors.shared')\n"
"local Counter = require('metrics.collectors.counter')\n"
"\n"
"local INF = math.huge\n"
"local DEFAULT_BUCKETS = {.005, .01, .025, .05, .075, .1, .25, .5,\n"
"                         .75, 1.0, 2.5, 5.0, 7.5, 10.0, INF}\n"
"\n"
"local Histogram = Shared:new_class('histogram', {'observe_latency'})\n"
"\n"
"function Histogram.check_buckets(buckets)\n"
"    local prev = -math.huge\n"
"    for _, v in ipairs(buckets) do\n"
"        if type(v) ~= 'number' then return false end\n"
"        if v <= 0 then return false end\n"
"        if prev > v then return false end\n"
"        prev = v\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"function Histogram:new(name, help, buckets, metainfo)\n"
"    metainfo = table.copy(metainfo) or {}\n"
"    local obj = Shared.new(self, name, help, metainfo)\n"
"\n"
"    obj.buckets = buckets or DEFAULT_BUCKETS\n"
"    table.sort(obj.buckets)\n"
"    if obj.buckets[#obj.buckets] ~= INF then\n"
"        obj.buckets[#obj.buckets+1] = INF\n"
"    end\n"
"\n"
"    obj.count_collector = Counter:new(name .. '_count', help, metainfo)\n"
"    obj.sum_collector = Counter:new(name .. '_sum', help, metainfo)\n"
"    obj.bucket_collector = Counter:new(name .. '_bucket', help, metainfo)\n"
"\n"
"    return obj\n"
"end\n"
"\n"
"function Histogram:set_registry(registry)\n"
"    Shared.set_registry(self, registry)\n"
"    self.count_collector:set_registry(registry)\n"
"    self.sum_collector:set_registry(registry)\n"
"    self.bucket_collector:set_registry(registry)\n"
"end\n"
"\n"
"function Histogram:observe(num, label_pairs)\n"
"    label_pairs = label_pairs or {}\n"
"    if num ~= nil and type(tonumber(num)) ~= 'number' then\n"
"        error(\"Histogram observation should be a number\")\n"
"    end\n"
"\n"
"    self.count_collector:inc(1, label_pairs)\n"
"    self.sum_collector:inc(num, label_pairs)\n"
"\n"
"    for _, bucket in ipairs(self.buckets) do\n"
"        local bkt_label_pairs = table.deepcopy(label_pairs)\n"
"        bkt_label_pairs.le = bucket\n"
"\n"
"        if num <= bucket then\n"
"            self.bucket_collector:inc(1, bkt_label_pairs)\n"
"        else\n"
"            -- all buckets are needed for histogram quantile approximation\n"
"            -- this creates buckets if they were not created before\n"
"            self.bucket_collector:inc(0, bkt_label_pairs)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"function Histogram:remove(label_pairs)\n"
"    assert(label_pairs, 'label pairs is a required parameter')\n"
"    self.count_collector:remove(label_pairs)\n"
"    self.sum_collector:remove(label_pairs)\n"
"\n"
"    for _, bucket in ipairs(self.buckets) do\n"
"        local bkt_label_pairs = table.deepcopy(label_pairs)\n"
"        bkt_label_pairs.le = bucket\n"
"        self.bucket_collector:remove(bkt_label_pairs)\n"
"    end\n"
"end\n"
"\n"
"function Histogram:collect()\n"
"    local result = {}\n"
"    for _, obs in ipairs(self.count_collector:collect()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"    for _, obs in ipairs(self.sum_collector:collect()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"    for _, obs in ipairs(self.bucket_collector:collect()) do\n"
"        table.insert(result, obs)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"return Histogram\n"
""
;
