/* Printer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Printer.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2015 - 2022 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "cups/cups.h"
#include <glib-object.h>
#include <gee.h>
#include "cups/ipp.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_PRINTER_0_PROPERTY,
	PRINTERS_PRINTER_IS_ENABLED_PROPERTY,
	PRINTERS_PRINTER_IS_DEFAULT_PROPERTY,
	PRINTERS_PRINTER_AUTH_INFO_REQUIRED_PROPERTY,
	PRINTERS_PRINTER_INFO_PROPERTY,
	PRINTERS_PRINTER_IS_ACCEPTING_JOBS_PROPERTY,
	PRINTERS_PRINTER_STATE_PROPERTY,
	PRINTERS_PRINTER_IS_SHARED_PROPERTY,
	PRINTERS_PRINTER_LOCATION_PROPERTY,
	PRINTERS_PRINTER_MAKE_AND_MODEL_PROPERTY,
	PRINTERS_PRINTER_STATE_REASONS_RAW_PROPERTY,
	PRINTERS_PRINTER_STATE_REASONS_PROPERTY,
	PRINTERS_PRINTER_PRINTER_TYPE_PROPERTY,
	PRINTERS_PRINTER_IS_OFFLINE_PROPERTY,
	PRINTERS_PRINTER_NUM_PROPERTIES
};
static GParamSpec* printers_printer_properties[PRINTERS_PRINTER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ippDelete0(var) ((var == NULL) ? NULL : (var = (ippDelete (var), NULL)))
#define _printers_printer_color_level_unref0(var) ((var == NULL) ? NULL : (var = (printers_printer_color_level_unref (var), NULL)))
typedef struct _PrintersPrinterParamSpecColorLevel PrintersPrinterParamSpecColorLevel;
enum  {
	PRINTERS_PRINTER_ENABLED_CHANGED_SIGNAL,
	PRINTERS_PRINTER_DEFAULT_CHANGED_SIGNAL,
	PRINTERS_PRINTER_DELETED_SIGNAL,
	PRINTERS_PRINTER_NUM_SIGNALS
};
static guint printers_printer_signals[PRINTERS_PRINTER_NUM_SIGNALS] = {0};

struct _PrintersPrinterPrivate {
	gboolean _is_accepting_jobs;
	gchar* _state;
	gchar* _state_reasons_raw;
};

struct _PrintersPrinterParamSpecColorLevel {
	GParamSpec parent_instance;
};

static gint PrintersPrinter_private_offset;
static gpointer printers_printer_parent_class = NULL;
static gchar** printers_printer_reasons;
static gint printers_printer_reasons_length1;
static gchar** printers_printer_reasons = NULL;
static gint printers_printer_reasons_length1 = 0;
static gint _printers_printer_reasons_size_ = 0;
static gchar** printers_printer_statuses;
static gint printers_printer_statuses_length1;
static gchar** printers_printer_statuses = NULL;
static gint printers_printer_statuses_length1 = 0;
static gint _printers_printer_statuses_size_ = 0;
static gpointer printers_printer_color_level_parent_class = NULL;

static ipp_t* printers_printer_request_attributes (PrintersPrinter* self,
                                            gchar** attributes,
                                            gint attributes_length1,
                                            GError** error);
static gint __lambda5_ (PrintersPrinter* self,
                 PrintersPrinterColorLevel* a,
                 PrintersPrinterColorLevel* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void printers_printer_color_level_finalize (PrintersPrinterColorLevel * obj);
static GType printers_printer_color_level_get_type_once (void);
static void printers_printer_finalize (GObject * obj);
static GType printers_printer_get_type_once (void);
static void _vala_printers_printer_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_printers_printer_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
printers_printer_get_instance_private (PrintersPrinter* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersPrinter_private_offset);
}

void
printers_printer_set_as_default (PrintersPrinter* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		cups_dest_t _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->dest;
		_tmp2_ = _tmp1_.name;
		_tmp3_ = cups_pk_helper_printer_set_default (_tmp0_, _tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, printers_printer_signals[PRINTERS_PRINTER_DEFAULT_CHANGED_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("Printer.vala:124: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/***********
     * Methods *
     ***********/
static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

PrintersPrinter*
printers_printer_construct (GType object_type,
                            cups_dest_t* dest)
{
	PrintersPrinter * self = NULL;
	gchar* is_accepting_opt = NULL;
	cups_option_t* _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	cups_option_t* _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	cups_option_t* _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	self = (PrintersPrinter*) g_object_new (object_type, NULL);
	self->dest = *dest;
	_tmp0_ = (*dest).options;
	_tmp0__length1 = (*dest).num_options;
	_tmp1_ = cupsGetOption ("is-accepting-jobs", (gint) _tmp0__length1, _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	is_accepting_opt = _tmp2_;
	_tmp4_ = is_accepting_opt;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = is_accepting_opt;
		_tmp3_ = bool_parse (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	printers_printer_set_is_accepting_jobs (self, _tmp3_);
	_tmp6_ = (*dest).options;
	_tmp6__length1 = (*dest).num_options;
	_tmp7_ = cupsGetOption ("printer-state", (gint) _tmp6__length1, _tmp6_);
	printers_printer_set_state (self, _tmp7_);
	_tmp8_ = (*dest).options;
	_tmp8__length1 = (*dest).num_options;
	_tmp9_ = cupsGetOption ("printer-state-reasons", (gint) _tmp8__length1, _tmp8_);
	printers_printer_set_state_reasons_raw (self, _tmp9_);
	_g_free0 (is_accepting_opt);
	return self;
}

PrintersPrinter*
printers_printer_new (cups_dest_t* dest)
{
	return printers_printer_construct (PRINTERS_TYPE_PRINTER, dest);
}

static cups_job_t*
cups_get_jobs (const gchar* name,
               gboolean my_jobs,
               int whichjobs,
               gint* result_length1)
{
	cups_job_t* temp = NULL;
	gint temp_length1 = 0;
	gint _temp_size_ = 0;
	gint _tmp0_ = 0;
	gint len = 0;
	cups_job_t* _tmp1_ = NULL;
	gint _tmp2_;
	cups_job_t* _tmp3_;
	gint _tmp3__length1;
	cups_job_t* result;
	g_return_val_if_fail (name != NULL, NULL);
	if (my_jobs) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp2_ = cupsGetJobs (&_tmp1_, name, _tmp0_, whichjobs);
	temp = _tmp1_;
	temp_length1 = -1;
	_temp_size_ = temp_length1;
	len = _tmp2_;
	temp_length1 = len;
	_tmp3_ = temp;
	_tmp3__length1 = temp_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static cups_job_t*
cups_destination_get_jobs (cups_dest_t *self,
                           gboolean my_jobs,
                           int whichjobs,
                           gint* result_length1)
{
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	cups_job_t* _tmp2_;
	cups_job_t* _tmp3_;
	gint _tmp3__length1;
	cups_job_t* result;
	_tmp0_ = (*self).name;
	_tmp2_ = cups_get_jobs (_tmp0_, my_jobs, whichjobs, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

GeeTreeSet*
printers_printer_get_jobs (PrintersPrinter* self,
                           gboolean my_jobs,
                           int whichjobs)
{
	GeeTreeSet* jobs = NULL;
	GeeTreeSet* _tmp0_;
	cups_job_t* cjobs = NULL;
	gint _tmp1_ = 0;
	cups_job_t* _tmp2_;
	gint cjobs_length1;
	gint _cjobs_size_;
	cups_job_t* _tmp3_;
	gint _tmp3__length1;
	GeeTreeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_tree_set_new (PRINTERS_TYPE_JOB, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	jobs = _tmp0_;
	_tmp2_ = cups_destination_get_jobs (&self->dest, my_jobs, whichjobs, &_tmp1_);
	cjobs = _tmp2_;
	cjobs_length1 = _tmp1_;
	_cjobs_size_ = cjobs_length1;
	_tmp3_ = cjobs;
	_tmp3__length1 = cjobs_length1;
	{
		cups_job_t* cjob_collection = NULL;
		gint cjob_collection_length1 = 0;
		gint _cjob_collection_size_ = 0;
		gint cjob_it = 0;
		cjob_collection = _tmp3_;
		cjob_collection_length1 = _tmp3__length1;
		for (cjob_it = 0; cjob_it < cjob_collection_length1; cjob_it = cjob_it + 1) {
			cups_job_t cjob = {0};
			cjob = cjob_collection[cjob_it];
			{
				PrintersJob* job = NULL;
				cups_job_t _tmp4_;
				PrintersJob* _tmp5_;
				GeeTreeSet* _tmp6_;
				PrintersJob* _tmp7_;
				_tmp4_ = cjob;
				_tmp5_ = printers_job_new (&_tmp4_, self);
				job = _tmp5_;
				_tmp6_ = jobs;
				_tmp7_ = job;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
				_g_object_unref0 (job);
			}
		}
	}
	result = jobs;
	return result;
}

gint
printers_printer_get_pages_per_sheet (PrintersPrinter* self,
                                      GeeTreeSet* pages_per_sheet)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (pages_per_sheet != NULL, 0);
	_tmp0_ = g_strdup (CUPS_NUMBER_UP_SUPPORTED);
	_tmp1_ = g_strdup ("number-up-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp11_;
		ipp_attribute_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, CUPS_NUMBER_UP_SUPPORTED, IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					gee_abstract_collection_add ((GeeAbstractCollection*) pages_per_sheet, (gpointer) ((gintptr) ippGetInteger (_tmp10_, i)));
				}
			}
		}
		_tmp11_ = request;
		_tmp12_ = ippFindAttribute (_tmp11_, "number-up-default", IPP_TAG_ZERO);
		attr = _tmp12_;
		_tmp13_ = attr;
		if (ippGetCount (_tmp13_) > 0) {
			ipp_attribute_t* _tmp14_;
			_tmp14_ = attr;
			result = ippGetInteger (_tmp14_, 0);
			_ippDelete0 (request);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_critical ("Printer.vala:292: Error: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp17_ = -1;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	result = 1;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_set_default_pages (PrintersPrinter* self,
                                    const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "number-up", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "number-up", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:304: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
printers_printer_get_sides (PrintersPrinter* self,
                            GeeTreeSet* sides)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sides != NULL, NULL);
	_tmp0_ = g_strdup (CUPS_SIDES_SUPPORTED);
	_tmp1_ = g_strdup ("sides-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		ipp_attribute_t* _tmp14_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, CUPS_SIDES_SUPPORTED, IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					_tmp11_ = ippGetString (_tmp10_, i, NULL);
					gee_abstract_collection_add ((GeeAbstractCollection*) sides, _tmp11_);
				}
			}
		}
		_tmp12_ = request;
		_tmp13_ = ippFindAttribute (_tmp12_, "sides-default", IPP_TAG_ZERO);
		attr = _tmp13_;
		_tmp14_ = attr;
		if (ippGetCount (_tmp14_) > 0) {
			ipp_attribute_t* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = attr;
			_tmp16_ = ippGetString (_tmp15_, 0, NULL);
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			_ippDelete0 (request);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("Printer.vala:323: Error: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = g_strdup (CUPS_SIDES_ONE_SIDED);
	result = _tmp20_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_set_default_side (PrintersPrinter* self,
                                   const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "sides", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "sides", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:335: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gint
printers_printer_get_orientations (PrintersPrinter* self,
                                   GeeTreeSet* orientations)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (orientations != NULL, 0);
	_tmp0_ = g_strdup (CUPS_ORIENTATION_SUPPORTED);
	_tmp1_ = g_strdup ("orientation-requested-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp11_;
		ipp_attribute_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, CUPS_ORIENTATION_SUPPORTED, IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					gee_abstract_collection_add ((GeeAbstractCollection*) orientations, (gpointer) ((gintptr) ippGetInteger (_tmp10_, i)));
				}
			}
		}
		_tmp11_ = request;
		_tmp12_ = ippFindAttribute (_tmp11_, "orientation-requested-default", IPP_TAG_ZERO);
		attr = _tmp12_;
		_tmp13_ = attr;
		if (ippGetCount (_tmp13_) > 0) {
			gint page = 0;
			ipp_attribute_t* _tmp14_;
			gboolean _tmp15_ = FALSE;
			_tmp14_ = attr;
			page = ippGetInteger (_tmp14_, 0);
			if (page >= 3) {
				_tmp15_ = page <= 6;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = page;
				_ippDelete0 (request);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("Printer.vala:357: Error: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp18_ = -1;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	result = 3;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_set_default_orientation (PrintersPrinter* self,
                                          const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "orientation-requested", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "orientation-requested", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:369: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
printers_printer_get_output_bins (PrintersPrinter* self,
                                  GeeTreeSet* output_bins)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (output_bins != NULL, NULL);
	_tmp0_ = g_strdup ("output-bin-supported");
	_tmp1_ = g_strdup ("output-bin-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		ipp_attribute_t* _tmp14_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, "output-bin-supported", IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					_tmp11_ = ippGetString (_tmp10_, i, NULL);
					gee_abstract_collection_add ((GeeAbstractCollection*) output_bins, _tmp11_);
				}
			}
		}
		_tmp12_ = request;
		_tmp13_ = ippFindAttribute (_tmp12_, "output-bin-default", IPP_TAG_ZERO);
		attr = _tmp13_;
		_tmp14_ = attr;
		if (ippGetCount (_tmp14_) > 0) {
			ipp_attribute_t* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = attr;
			_tmp16_ = ippGetString (_tmp15_, 0, NULL);
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			_ippDelete0 (request);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("Printer.vala:388: Error: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = g_strdup ("rear");
	result = _tmp20_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_set_default_output_bin (PrintersPrinter* self,
                                         const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "output-bin", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "output-bin", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:400: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
printers_printer_get_print_color_modes (PrintersPrinter* self,
                                        GeeTreeSet* print_color_modes)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (print_color_modes != NULL, NULL);
	_tmp0_ = g_strdup ("print-color-mode-supported");
	_tmp1_ = g_strdup ("print-color-mode-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		ipp_attribute_t* _tmp14_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, "print-color-mode-supported", IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					_tmp11_ = ippGetString (_tmp10_, i, NULL);
					gee_abstract_collection_add ((GeeAbstractCollection*) print_color_modes, _tmp11_);
				}
			}
		}
		_tmp12_ = request;
		_tmp13_ = ippFindAttribute (_tmp12_, "print-color-mode-default", IPP_TAG_ZERO);
		attr = _tmp13_;
		_tmp14_ = attr;
		if (ippGetCount (_tmp14_) > 0) {
			ipp_attribute_t* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = attr;
			_tmp16_ = ippGetString (_tmp15_, 0, NULL);
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			_ippDelete0 (request);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("Printer.vala:419: Error: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = g_strdup ("auto");
	result = _tmp20_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_set_default_print_color_mode (PrintersPrinter* self,
                                               const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "print-color-mode", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "print-color-mode", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:431: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
printers_printer_get_media_sources (PrintersPrinter* self,
                                    GeeTreeSet* media_sources)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_sources != NULL, NULL);
	_tmp0_ = g_strdup ("media-source-supported");
	_tmp1_ = g_strdup ("media-source-default-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		ipp_attribute_t* _tmp14_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, "media-source-supported", IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					_tmp11_ = ippGetString (_tmp10_, i, NULL);
					gee_abstract_collection_add ((GeeAbstractCollection*) media_sources, _tmp11_);
				}
			}
		}
		_tmp12_ = request;
		_tmp13_ = ippFindAttribute (_tmp12_, "media-source-default-default", IPP_TAG_ZERO);
		attr = _tmp13_;
		_tmp14_ = attr;
		if (ippGetCount (_tmp14_) > 0) {
			ipp_attribute_t* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = attr;
			_tmp16_ = ippGetString (_tmp15_, 0, NULL);
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			_ippDelete0 (request);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("Printer.vala:450: Error: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = g_strdup ("auto");
	result = _tmp20_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gchar*
printers_printer_get_media_sizes (PrintersPrinter* self,
                                  GeeTreeSet* media_sizes)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_sizes != NULL, NULL);
	_tmp0_ = g_strdup (CUPS_MEDIA_SUPPORTED);
	_tmp1_ = g_strdup ("media-supported-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		ipp_attribute_t* _tmp14_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, CUPS_MEDIA_SUPPORTED, IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					_tmp11_ = ippGetString (_tmp10_, i, NULL);
					gee_abstract_collection_add ((GeeAbstractCollection*) media_sizes, _tmp11_);
				}
			}
		}
		_tmp12_ = request;
		_tmp13_ = ippFindAttribute (_tmp12_, "media-supported-default", IPP_TAG_ZERO);
		attr = _tmp13_;
		_tmp14_ = attr;
		if (ippGetCount (_tmp14_) > 0) {
			ipp_attribute_t* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = attr;
			_tmp16_ = ippGetString (_tmp15_, 0, NULL);
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			_ippDelete0 (request);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("Printer.vala:471: Error: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = gtk_paper_size_get_default ();
	_tmp21_ = g_strdup (_tmp20_);
	result = _tmp21_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_set_default_media_size (PrintersPrinter* self,
                                         const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "media-supported-default", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "media-supported-default", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:483: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
printers_printer_set_default_media_source (PrintersPrinter* self,
                                           const gchar* new_default)
{
	CupsPkHelper* pk_helper = NULL;
	CupsPkHelper* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_default != NULL);
	_tmp0_ = cups_get_pk_helper ();
	pk_helper = _tmp0_;
	{
		CupsPkHelper* _tmp1_;
		cups_dest_t _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		CupsPkHelper* _tmp6_;
		cups_dest_t _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = pk_helper;
		_tmp2_ = self->dest;
		_tmp3_ = _tmp2_.name;
		_tmp4_ = cups_pk_helper_printer_delete_option_default (_tmp1_, _tmp3_, "media-source-default-default", &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = pk_helper;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.name;
		_tmp9_ = g_strdup (new_default);
		_tmp10_ = g_new0 (gchar*, 1 + 1);
		_tmp10_[0] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 1;
		_tmp12_ = cups_pk_helper_printer_add_option_default (_tmp6_, _tmp8_, "media-source-default-default", _tmp11_, (gint) 1, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("Printer.vala:493: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gint
printers_printer_get_print_qualities (PrintersPrinter* self,
                                      GeeTreeSet* print_qualities)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint attributes_length1;
	gint _attributes_size_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (print_qualities != NULL, 0);
	_tmp0_ = g_strdup ("print-quality-supported");
	_tmp1_ = g_strdup ("print-quality-default");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	attributes = _tmp2_;
	attributes_length1 = 2;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		ipp_t* _tmp4_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		ipp_t* _tmp11_;
		ipp_attribute_t* _tmp12_;
		ipp_attribute_t* _tmp13_;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		_tmp4_ = printers_printer_request_attributes (self, _tmp3_, (gint) _tmp3__length1, &_inner_error0_);
		request = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = request;
		_tmp6_ = ippFindAttribute (_tmp5_, "print-quality-supported", IPP_TAG_ZERO);
		attr = _tmp6_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp9_;
					ipp_attribute_t* _tmp10_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = attr;
					if (!(i < ippGetCount (_tmp9_))) {
						break;
					}
					_tmp10_ = attr;
					gee_abstract_collection_add ((GeeAbstractCollection*) print_qualities, (gpointer) ((gintptr) ippGetInteger (_tmp10_, i)));
				}
			}
		}
		_tmp11_ = request;
		_tmp12_ = ippFindAttribute (_tmp11_, "print-quality-default", IPP_TAG_ZERO);
		attr = _tmp12_;
		_tmp13_ = attr;
		if (ippGetCount (_tmp13_) > 0) {
			gint quality = 0;
			ipp_attribute_t* _tmp14_;
			gboolean _tmp15_ = FALSE;
			_tmp14_ = attr;
			quality = ippGetInteger (_tmp14_, 0);
			if (quality >= 3) {
				_tmp15_ = quality <= 5;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = quality;
				_ippDelete0 (request);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("Printer.vala:515: Error: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp18_ = -1;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	result = 4;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
printers_printer_get_all (PrintersPrinter* self)
{
	gchar** attributes = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint attributes_length1;
	gint _attributes_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("all");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	attributes = _tmp1_;
	attributes_length1 = 1;
	_attributes_size_ = attributes_length1;
	{
		ipp_t* request = NULL;
		gchar** _tmp2_;
		gint _tmp2__length1;
		ipp_t* _tmp3_;
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp4_;
		ipp_attribute_t* _tmp5_;
		_tmp2_ = attributes;
		_tmp2__length1 = attributes_length1;
		_tmp3_ = printers_printer_request_attributes (self, _tmp2_, (gint) _tmp2__length1, &_inner_error0_);
		request = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = request;
		_tmp5_ = ippFirstAttribute (_tmp4_);
		attr = _tmp5_;
		while (TRUE) {
			ipp_attribute_t* _tmp6_;
			ipp_attribute_t* _tmp7_;
			const gchar* _tmp8_;
			ipp_t* _tmp9_;
			ipp_attribute_t* _tmp10_;
			_tmp6_ = attr;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = attr;
			_tmp8_ = ippGetName (_tmp7_);
			g_debug ("Printer.vala:527: %s", _tmp8_);
			_tmp9_ = request;
			_tmp10_ = ippNextAttribute (_tmp9_);
			attr = _tmp10_;
		}
		_ippDelete0 (request);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("Printer.vala:531: Error: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
}

static ipp_t*
printers_printer_request_attributes (PrintersPrinter* self,
                                     gchar** attributes,
                                     gint attributes_length1,
                                     GError** error)
{
	gchar* printer_uri = NULL;
	gchar* _tmp0_;
	gint printer_uri_length1;
	gint _printer_uri_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	cups_dest_t _tmp2_;
	const gchar* _tmp3_;
	ipp_t* request = NULL;
	ipp_t* _tmp4_;
	ipp_t* _tmp5_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	ipp_t* _tmp7_;
	http_t* _tmp8_;
	ipp_status_t status_code = 0;
	ipp_t* _tmp9_;
	GError* _inner_error0_ = NULL;
	ipp_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar, HTTP_MAX_URI);
	printer_uri = _tmp0_;
	printer_uri_length1 = HTTP_MAX_URI;
	_printer_uri_size_ = printer_uri_length1;
	_tmp1_ = printer_uri;
	_tmp1__length1 = printer_uri_length1;
	_tmp2_ = self->dest;
	_tmp3_ = _tmp2_.name;
	httpAssembleURIf (HTTP_URI_CODING_QUERY, _tmp1_, (gint) _tmp1__length1, "ipp", NULL, "localhost", 0, "/printers/%s", _tmp3_);
	_tmp4_ = ippNewRequest (IPP_GET_PRINTER_ATTRIBUTES);
	request = _tmp4_;
	_tmp5_ = request;
	_tmp6_ = printer_uri;
	_tmp6__length1 = printer_uri_length1;
	ippAddString (_tmp5_, IPP_TAG_OPERATION, IPP_TAG_URI, "printer-uri", NULL, (const gchar*) _tmp6_);
	_tmp7_ = request;
	ippAddStrings (_tmp7_, IPP_TAG_OPERATION, IPP_TAG_KEYWORD, "requested-attributes", (gint) attributes_length1, NULL, attributes);
	_tmp8_ = CUPS_HTTP_DEFAULT;
	request = cupsDoRequest (_tmp8_, request, "/");
	_tmp9_ = request;
	status_code = ippGetStatusCode (_tmp9_);
	if (status_code <= IPP_OK_CONFLICT) {
		result = request;
		printer_uri = (g_free (printer_uri), NULL);
		return result;
	} else {
		const gchar* _tmp10_;
		GError* _tmp11_;
		_tmp10_ = ippErrorString (status_code);
		_tmp11_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp10_);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		_ippDelete0 (request);
		printer_uri = (g_free (printer_uri), NULL);
		return NULL;
	}
}

static gint
__lambda5_ (PrintersPrinter* self,
            PrintersPrinterColorLevel* a,
            PrintersPrinterColorLevel* b)
{
	GdkRGBA col_a = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA col_b = {0};
	GdkRGBA _tmp1_ = {0};
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GdkRGBA _tmp6_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GdkRGBA _tmp11_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GdkRGBA _tmp16_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GdkRGBA _tmp21_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	GdkRGBA _tmp26_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GdkRGBA _tmp31_;
	gfloat a_tot = 0.0F;
	GdkRGBA _tmp34_;
	GdkRGBA _tmp35_;
	GdkRGBA _tmp36_;
	gfloat b_tot = 0.0F;
	GdkRGBA _tmp37_;
	GdkRGBA _tmp38_;
	GdkRGBA _tmp39_;
	gint result;
	col_a = _tmp0_;
	col_b = _tmp1_;
	_tmp2_ = a->color;
	gdk_rgba_parse (&col_a, _tmp2_);
	_tmp3_ = b->color;
	gdk_rgba_parse (&col_b, _tmp3_);
	_tmp6_ = col_a;
	if (((gdouble) _tmp6_.green) > 0.8) {
		GdkRGBA _tmp7_;
		_tmp7_ = col_a;
		_tmp5_ = ((gdouble) _tmp7_.blue) > 0.8;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GdkRGBA _tmp8_;
		_tmp8_ = col_a;
		_tmp4_ = ((gdouble) _tmp8_.red) < 0.3;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = -1;
		return result;
	}
	_tmp11_ = col_b;
	if (((gdouble) _tmp11_.green) > 0.8) {
		GdkRGBA _tmp12_;
		_tmp12_ = col_b;
		_tmp10_ = ((gdouble) _tmp12_.blue) > 0.8;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GdkRGBA _tmp13_;
		_tmp13_ = col_b;
		_tmp9_ = ((gdouble) _tmp13_.red) < 0.3;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		result = 1;
		return result;
	}
	_tmp16_ = col_a;
	if (((gdouble) _tmp16_.green) < 0.3) {
		GdkRGBA _tmp17_;
		_tmp17_ = col_a;
		_tmp15_ = ((gdouble) _tmp17_.blue) > 0.8;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GdkRGBA _tmp18_;
		_tmp18_ = col_a;
		_tmp14_ = ((gdouble) _tmp18_.red) > 0.8;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		result = -1;
		return result;
	}
	_tmp21_ = col_b;
	if (((gdouble) _tmp21_.green) < 0.3) {
		GdkRGBA _tmp22_;
		_tmp22_ = col_b;
		_tmp20_ = ((gdouble) _tmp22_.blue) > 0.8;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		GdkRGBA _tmp23_;
		_tmp23_ = col_b;
		_tmp19_ = ((gdouble) _tmp23_.red) > 0.8;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		result = 1;
		return result;
	}
	_tmp26_ = col_a;
	if (((gdouble) _tmp26_.green) > 0.8) {
		GdkRGBA _tmp27_;
		_tmp27_ = col_a;
		_tmp25_ = ((gdouble) _tmp27_.blue) < 0.3;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		GdkRGBA _tmp28_;
		_tmp28_ = col_a;
		_tmp24_ = ((gdouble) _tmp28_.red) > 0.8;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = -1;
		return result;
	}
	_tmp31_ = col_b;
	if (((gdouble) _tmp31_.green) > 0.8) {
		GdkRGBA _tmp32_;
		_tmp32_ = col_b;
		_tmp30_ = ((gdouble) _tmp32_.blue) < 0.3;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GdkRGBA _tmp33_;
		_tmp33_ = col_b;
		_tmp29_ = ((gdouble) _tmp33_.red) > 0.8;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		result = 1;
		return result;
	}
	_tmp34_ = col_a;
	_tmp35_ = col_a;
	_tmp36_ = col_a;
	a_tot = (_tmp34_.green + _tmp35_.blue) + _tmp36_.red;
	_tmp37_ = col_b;
	_tmp38_ = col_b;
	_tmp39_ = col_b;
	b_tot = (_tmp37_.green + _tmp38_.blue) + _tmp39_.red;
	if (a_tot > b_tot) {
		result = 1;
		return result;
	} else {
		if (a_tot == b_tot) {
			result = 0;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}

static gint
___lambda5__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda5_ ((PrintersPrinter*) self, (PrintersPrinterColorLevel*) a, (PrintersPrinterColorLevel*) b);
	return result;
}

GeeArrayList*
printers_printer_get_color_levels (PrintersPrinter* self)
{
	gchar* printer_uri = NULL;
	gchar* _tmp0_;
	gint printer_uri_length1;
	gint _printer_uri_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	cups_dest_t _tmp2_;
	const gchar* _tmp3_;
	ipp_t* request = NULL;
	ipp_t* _tmp4_;
	ipp_t* _tmp5_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	static const gchar* ATTRIBUTES[5] = {"marker-colors", "marker-levels", "marker-names", "marker-high-levels", "marker-low-levels"};
	ipp_t* _tmp7_;
	http_t* _tmp8_;
	GeeArrayList* found_colors = NULL;
	GeeArrayList* _tmp9_;
	ipp_status_t status_code = 0;
	ipp_t* _tmp10_;
	GeeArrayList* _tmp65_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar, HTTP_MAX_URI);
	printer_uri = _tmp0_;
	printer_uri_length1 = HTTP_MAX_URI;
	_printer_uri_size_ = printer_uri_length1;
	_tmp1_ = printer_uri;
	_tmp1__length1 = printer_uri_length1;
	_tmp2_ = self->dest;
	_tmp3_ = _tmp2_.name;
	httpAssembleURIf (HTTP_URI_CODING_QUERY, _tmp1_, (gint) _tmp1__length1, "ipp", NULL, "localhost", 0, "/printers/%s", _tmp3_);
	_tmp4_ = ippNewRequest (IPP_GET_PRINTER_ATTRIBUTES);
	request = _tmp4_;
	_tmp5_ = request;
	_tmp6_ = printer_uri;
	_tmp6__length1 = printer_uri_length1;
	ippAddString (_tmp5_, IPP_TAG_OPERATION, IPP_TAG_URI, "printer-uri", NULL, (const gchar*) _tmp6_);
	_tmp7_ = request;
	ippAddStrings (_tmp7_, IPP_TAG_OPERATION, IPP_TAG_KEYWORD, "requested-attributes", (gint) G_N_ELEMENTS (ATTRIBUTES), NULL, ATTRIBUTES);
	_tmp8_ = CUPS_HTTP_DEFAULT;
	request = cupsDoRequest (_tmp8_, request, "/");
	_tmp9_ = gee_array_list_new (PRINTERS_PRINTER_TYPE_COLOR_LEVEL, (GBoxedCopyFunc) printers_printer_color_level_ref, (GDestroyNotify) printers_printer_color_level_unref, NULL, NULL, NULL);
	found_colors = _tmp9_;
	_tmp10_ = request;
	status_code = ippGetStatusCode (_tmp10_);
	if (status_code <= IPP_OK_CONFLICT) {
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp11_;
		ipp_attribute_t* _tmp12_;
		gint color_size = 0;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		ipp_t* _tmp26_;
		ipp_attribute_t* _tmp27_;
		gint bound = 0;
		ipp_attribute_t* _tmp28_;
		ipp_t* _tmp35_;
		ipp_attribute_t* _tmp36_;
		ipp_attribute_t* _tmp37_;
		ipp_t* _tmp44_;
		ipp_attribute_t* _tmp45_;
		ipp_attribute_t* _tmp46_;
		ipp_t* _tmp53_;
		ipp_attribute_t* _tmp54_;
		ipp_attribute_t* _tmp55_;
		_tmp11_ = request;
		_tmp12_ = ippFindAttribute (_tmp11_, "marker-colors", IPP_TAG_ZERO);
		attr = _tmp12_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					ipp_attribute_t* _tmp15_;
					PrintersPrinterColorLevel* color = NULL;
					PrintersPrinterColorLevel* _tmp16_;
					PrintersPrinterColorLevel* _tmp17_;
					ipp_attribute_t* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					GeeArrayList* _tmp21_;
					PrintersPrinterColorLevel* _tmp22_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp15_ = attr;
					if (!(i < ippGetCount (_tmp15_))) {
						break;
					}
					_tmp16_ = printers_printer_color_level_new ();
					color = _tmp16_;
					_tmp17_ = color;
					_tmp18_ = attr;
					_tmp19_ = ippGetString (_tmp18_, i, NULL);
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (_tmp17_->color);
					_tmp17_->color = _tmp20_;
					_tmp21_ = found_colors;
					_tmp22_ = color;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					_printers_printer_color_level_unref0 (color);
				}
			}
		}
		_tmp23_ = found_colors;
		_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		color_size = _tmp25_;
		_tmp26_ = request;
		_tmp27_ = ippFindAttribute (_tmp26_, "marker-levels", IPP_TAG_ZERO);
		attr = _tmp27_;
		_tmp28_ = attr;
		bound = MIN (ippGetCount (_tmp28_), color_size);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp29_ = FALSE;
				_tmp29_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp31_;
					gpointer _tmp32_;
					PrintersPrinterColorLevel* _tmp33_;
					ipp_attribute_t* _tmp34_;
					if (!_tmp29_) {
						gint _tmp30_;
						_tmp30_ = i;
						i = _tmp30_ + 1;
					}
					_tmp29_ = FALSE;
					if (!(i < bound)) {
						break;
					}
					_tmp31_ = found_colors;
					_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, i);
					_tmp33_ = (PrintersPrinterColorLevel*) _tmp32_;
					_tmp34_ = attr;
					_tmp33_->level = ippGetInteger (_tmp34_, i);
					_printers_printer_color_level_unref0 (_tmp33_);
				}
			}
		}
		_tmp35_ = request;
		_tmp36_ = ippFindAttribute (_tmp35_, "marker-high-levels", IPP_TAG_ZERO);
		attr = _tmp36_;
		_tmp37_ = attr;
		bound = MIN (ippGetCount (_tmp37_), color_size);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp38_ = FALSE;
				_tmp38_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp40_;
					gpointer _tmp41_;
					PrintersPrinterColorLevel* _tmp42_;
					ipp_attribute_t* _tmp43_;
					if (!_tmp38_) {
						gint _tmp39_;
						_tmp39_ = i;
						i = _tmp39_ + 1;
					}
					_tmp38_ = FALSE;
					if (!(i < bound)) {
						break;
					}
					_tmp40_ = found_colors;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, i);
					_tmp42_ = (PrintersPrinterColorLevel*) _tmp41_;
					_tmp43_ = attr;
					_tmp42_->level_max = ippGetInteger (_tmp43_, i);
					_printers_printer_color_level_unref0 (_tmp42_);
				}
			}
		}
		_tmp44_ = request;
		_tmp45_ = ippFindAttribute (_tmp44_, "marker-low-levels", IPP_TAG_ZERO);
		attr = _tmp45_;
		_tmp46_ = attr;
		bound = MIN (ippGetCount (_tmp46_), color_size);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp47_ = FALSE;
				_tmp47_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp49_;
					gpointer _tmp50_;
					PrintersPrinterColorLevel* _tmp51_;
					ipp_attribute_t* _tmp52_;
					if (!_tmp47_) {
						gint _tmp48_;
						_tmp48_ = i;
						i = _tmp48_ + 1;
					}
					_tmp47_ = FALSE;
					if (!(i < bound)) {
						break;
					}
					_tmp49_ = found_colors;
					_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, i);
					_tmp51_ = (PrintersPrinterColorLevel*) _tmp50_;
					_tmp52_ = attr;
					_tmp51_->level_min = ippGetInteger (_tmp52_, i);
					_printers_printer_color_level_unref0 (_tmp51_);
				}
			}
		}
		_tmp53_ = request;
		_tmp54_ = ippFindAttribute (_tmp53_, "marker-names", IPP_TAG_ZERO);
		attr = _tmp54_;
		_tmp55_ = attr;
		bound = MIN (ippGetCount (_tmp55_), color_size);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp56_ = FALSE;
				_tmp56_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp58_;
					gpointer _tmp59_;
					PrintersPrinterColorLevel* _tmp60_;
					ipp_attribute_t* _tmp61_;
					const gchar* _tmp62_;
					gchar* _tmp63_;
					if (!_tmp56_) {
						gint _tmp57_;
						_tmp57_ = i;
						i = _tmp57_ + 1;
					}
					_tmp56_ = FALSE;
					if (!(i < bound)) {
						break;
					}
					_tmp58_ = found_colors;
					_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, i);
					_tmp60_ = (PrintersPrinterColorLevel*) _tmp59_;
					_tmp61_ = attr;
					_tmp62_ = ippGetString (_tmp61_, i, NULL);
					_tmp63_ = g_strdup (_tmp62_);
					_g_free0 (_tmp60_->name);
					_tmp60_->name = _tmp63_;
					_printers_printer_color_level_unref0 (_tmp60_);
				}
			}
		}
	} else {
		const gchar* _tmp64_;
		_tmp64_ = ippErrorString (status_code);
		g_critical ("Printer.vala:603: Error: %s", _tmp64_);
	}
	_tmp65_ = found_colors;
	gee_list_sort ((GeeList*) _tmp65_, ___lambda5__gcompare_data_func, g_object_ref (self), g_object_unref);
	result = found_colors;
	_ippDelete0 (request);
	printer_uri = (g_free (printer_uri), NULL);
	return result;
}

gboolean
printers_printer_get_is_enabled (PrintersPrinter* self)
{
	gboolean result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = g_strcmp0 (_tmp0_, "5") != 0;
	return result;
}

void
printers_printer_set_is_enabled (PrintersPrinter* self,
                                 gboolean value)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (value == (g_strcmp0 (_tmp0_, "5") == 0)) {
		{
			CupsPkHelper* _tmp1_;
			cups_dest_t _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp1_ = cups_get_pk_helper ();
			_tmp2_ = self->dest;
			_tmp3_ = _tmp2_.name;
			_tmp4_ = cups_pk_helper_printer_set_enabled (_tmp1_, _tmp3_, value, &_inner_error0_);
			_tmp5_ = _tmp4_;
			_g_free0 (_tmp5_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_critical ("Printer.vala:107: %s", _tmp7_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			CupsPkHelper* _tmp8_;
			cups_dest_t _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = cups_get_pk_helper ();
			_tmp9_ = self->dest;
			_tmp10_ = _tmp9_.name;
			_tmp11_ = cups_pk_helper_printer_set_accept_jobs (_tmp8_, _tmp10_, value, "", &_inner_error0_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp12_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_critical ("Printer.vala:113: %s", _tmp14_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_IS_ENABLED_PROPERTY]);
}

static gboolean
cups_destination_get_is_default (cups_dest_t* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (*self).is_default == 1;
	return result;
}

static void
cups_destination_set_is_default (cups_dest_t* self,
                                 gboolean value)
{
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	(*self).is_default = _tmp0_;
}

gboolean
printers_printer_get_is_default (PrintersPrinter* self)
{
	gboolean result;
	cups_dest_t _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->dest;
	_tmp1_ = cups_destination_get_is_default (&_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

const gchar*
printers_printer_get_auth_info_required (PrintersPrinter* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	cups_dest_t _tmp1_;
	cups_option_t* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->dest;
	_tmp2_ = _tmp1_.options;
	_tmp2__length1 = _tmp1_.num_options;
	_tmp3_ = cupsGetOption ("auth-info-required", (gint) _tmp2__length1, _tmp2_);
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "none";
	}
	result = _tmp0_;
	return result;
}

const gchar*
printers_printer_get_info (PrintersPrinter* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	cups_dest_t _tmp1_;
	cups_option_t* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->dest;
	_tmp2_ = _tmp1_.options;
	_tmp2__length1 = _tmp1_.num_options;
	_tmp3_ = cupsGetOption ("printer-info", (gint) _tmp2__length1, _tmp2_);
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = _ ("Unnamed Printer");
	}
	result = _tmp0_;
	return result;
}

void
printers_printer_set_info (PrintersPrinter* self,
                           const gchar* value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		cups_dest_t _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		cups_dest_t _tmp5_;
		cups_option_t* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->dest;
		_tmp2_ = _tmp1_.name;
		_tmp3_ = cups_pk_helper_printer_set_info (_tmp0_, _tmp2_, value, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->dest;
		_tmp6_ = _tmp5_.options;
		_tmp6__length1 = _tmp5_.num_options;
		_tmp7_ = cupsAddOption ("printer-info", value, _tmp6__length1, &self->dest.options);
		self->dest.num_options = _tmp7_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Printer.vala:156: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_INFO_PROPERTY]);
}

gboolean
printers_printer_get_is_accepting_jobs (PrintersPrinter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_accepting_jobs;
	return result;
}

void
printers_printer_set_is_accepting_jobs (PrintersPrinter* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_printer_get_is_accepting_jobs (self);
	if (old_value != value) {
		self->priv->_is_accepting_jobs = value;
		g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_IS_ACCEPTING_JOBS_PROPERTY]);
	}
}

const gchar*
printers_printer_get_state (PrintersPrinter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}

void
printers_printer_set_state (PrintersPrinter* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_printer_get_state (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_state);
		self->priv->_state = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_STATE_PROPERTY]);
	}
}

gboolean
printers_printer_get_is_shared (PrintersPrinter* self)
{
	gboolean result;
	const gchar* cups_result = NULL;
	cups_dest_t _tmp0_;
	cups_option_t* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->dest;
	_tmp1_ = _tmp0_.options;
	_tmp1__length1 = _tmp0_.num_options;
	_tmp2_ = cupsGetOption ("printer-is-shared", (gint) _tmp1__length1, _tmp1_);
	cups_result = _tmp2_;
	_tmp3_ = cups_result;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp4_ = cups_result;
	result = bool_parse (_tmp4_);
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
printers_printer_set_is_shared (PrintersPrinter* self,
                                gboolean value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		cups_dest_t _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		cups_dest_t _tmp7_;
		cups_option_t* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->dest;
		_tmp2_ = _tmp1_.name;
		_tmp3_ = cups_pk_helper_printer_set_shared (_tmp0_, _tmp2_, value, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = bool_to_string (value);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->dest;
		_tmp8_ = _tmp7_.options;
		_tmp8__length1 = _tmp7_.num_options;
		_tmp9_ = cupsAddOption ("printer-is-shared", _tmp6_, _tmp8__length1, &self->dest.options);
		self->dest.num_options = _tmp9_;
		_g_free0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("Printer.vala:181: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_IS_SHARED_PROPERTY]);
}

const gchar*
printers_printer_get_location (PrintersPrinter* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	cups_dest_t _tmp1_;
	cups_option_t* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->dest;
	_tmp2_ = _tmp1_.options;
	_tmp2__length1 = _tmp1_.num_options;
	_tmp3_ = cupsGetOption ("printer-location", (gint) _tmp2__length1, _tmp2_);
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	result = _tmp0_;
	return result;
}

void
printers_printer_set_location (PrintersPrinter* self,
                               const gchar* value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CupsPkHelper* _tmp0_;
		cups_dest_t _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		cups_dest_t _tmp5_;
		cups_option_t* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		_tmp0_ = cups_get_pk_helper ();
		_tmp1_ = self->dest;
		_tmp2_ = _tmp1_.name;
		_tmp3_ = cups_pk_helper_printer_set_location (_tmp0_, _tmp2_, value, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->dest;
		_tmp6_ = _tmp5_.options;
		_tmp6__length1 = _tmp5_.num_options;
		_tmp7_ = cupsAddOption ("printer-location", value, _tmp6__length1, &self->dest.options);
		self->dest.num_options = _tmp7_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Printer.vala:198: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_LOCATION_PROPERTY]);
}

const gchar*
printers_printer_get_make_and_model (PrintersPrinter* self)
{
	const gchar* result;
	cups_dest_t _tmp0_;
	cups_option_t* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dest;
	_tmp1_ = _tmp0_.options;
	_tmp1__length1 = _tmp0_.num_options;
	_tmp2_ = cupsGetOption ("printer-make-and-model", (gint) _tmp1__length1, _tmp1_);
	result = _tmp2_;
	return result;
}

const gchar*
printers_printer_get_state_reasons_raw (PrintersPrinter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state_reasons_raw;
	result = _tmp0_;
	return result;
}

void
printers_printer_set_state_reasons_raw (PrintersPrinter* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_printer_get_state_reasons_raw (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_state_reasons_raw);
		self->priv->_state_reasons_raw = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_printer_properties[PRINTERS_PRINTER_STATE_REASONS_RAW_PROPERTY]);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

const gchar*
printers_printer_get_state_reasons (PrintersPrinter* self)
{
	const gchar* result;
	const gchar* reason = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state_reasons_raw;
	reason = _tmp0_;
	_tmp2_ = reason;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = reason;
		_tmp4_ = g_utf8_strup (_tmp3_, (gssize) -1);
		_tmp5_ = _tmp4_;
		_tmp1_ = string_contains (_tmp5_, "NONE");
		_g_free0 (_tmp5_);
	}
	if (_tmp1_) {
		result = _ ("Ready");
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = printers_printer_reasons;
				_tmp8__length1 = printers_printer_reasons_length1;
				if (!(i < _tmp8__length1)) {
					break;
				}
				_tmp9_ = reason;
				_tmp10_ = printers_printer_reasons;
				_tmp10__length1 = printers_printer_reasons_length1;
				_tmp11_ = _tmp10_[i];
				if (string_contains (_tmp9_, _tmp11_)) {
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					_tmp12_ = printers_printer_statuses;
					_tmp12__length1 = printers_printer_statuses_length1;
					_tmp13_ = _tmp12_[i];
					result = g_dpgettext2 (BUILD_GETTEXT_PACKAGE, "printer state", _tmp13_);
					return result;
				}
			}
		}
	}
	_tmp14_ = reason;
	result = _tmp14_;
	return result;
}

const gchar*
printers_printer_get_printer_type (PrintersPrinter* self)
{
	const gchar* result;
	cups_dest_t _tmp0_;
	cups_option_t* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dest;
	_tmp1_ = _tmp0_.options;
	_tmp1__length1 = _tmp0_.num_options;
	_tmp2_ = cupsGetOption ("printer-type", (gint) _tmp1__length1, _tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
printers_printer_get_is_offline (PrintersPrinter* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_state_reasons_raw;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_state_reasons_raw;
		_tmp0_ = string_contains (_tmp2_, "offline");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

PrintersPrinterColorLevel*
printers_printer_color_level_construct (GType object_type)
{
	PrintersPrinterColorLevel* self = NULL;
	self = (PrintersPrinterColorLevel*) g_type_create_instance (object_type);
	return self;
}

PrintersPrinterColorLevel*
printers_printer_color_level_new (void)
{
	return printers_printer_color_level_construct (PRINTERS_PRINTER_TYPE_COLOR_LEVEL);
}

static void
printers_printer_value_color_level_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
printers_printer_value_color_level_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		printers_printer_color_level_unref (value->data[0].v_pointer);
	}
}

static void
printers_printer_value_color_level_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = printers_printer_color_level_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
printers_printer_value_color_level_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
printers_printer_value_color_level_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PrintersPrinterColorLevel * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = printers_printer_color_level_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
printers_printer_value_color_level_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	PrintersPrinterColorLevel ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = printers_printer_color_level_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
printers_printer_param_spec_color_level (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	PrintersPrinterParamSpecColorLevel* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PRINTERS_PRINTER_TYPE_COLOR_LEVEL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
printers_printer_value_get_color_level (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PRINTERS_PRINTER_TYPE_COLOR_LEVEL), NULL);
	return value->data[0].v_pointer;
}

void
printers_printer_value_set_color_level (GValue* value,
                                        gpointer v_object)
{
	PrintersPrinterColorLevel * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PRINTERS_PRINTER_TYPE_COLOR_LEVEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PRINTERS_PRINTER_TYPE_COLOR_LEVEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		printers_printer_color_level_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		printers_printer_color_level_unref (old);
	}
}

void
printers_printer_value_take_color_level (GValue* value,
                                         gpointer v_object)
{
	PrintersPrinterColorLevel * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PRINTERS_PRINTER_TYPE_COLOR_LEVEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PRINTERS_PRINTER_TYPE_COLOR_LEVEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		printers_printer_color_level_unref (old);
	}
}

static void
printers_printer_color_level_class_init (PrintersPrinterColorLevelClass * klass,
                                         gpointer klass_data)
{
	printers_printer_color_level_parent_class = g_type_class_peek_parent (klass);
	((PrintersPrinterColorLevelClass *) klass)->finalize = printers_printer_color_level_finalize;
}

static void
printers_printer_color_level_instance_init (PrintersPrinterColorLevel * self,
                                            gpointer klass)
{
	self->ref_count = 1;
}

static void
printers_printer_color_level_finalize (PrintersPrinterColorLevel * obj)
{
	PrintersPrinterColorLevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_PRINTER_TYPE_COLOR_LEVEL, PrintersPrinterColorLevel);
	g_signal_handlers_destroy (self);
	_g_free0 (self->color);
	_g_free0 (self->name);
}

static GType
printers_printer_color_level_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { printers_printer_value_color_level_init, printers_printer_value_color_level_free_value, printers_printer_value_color_level_copy_value, printers_printer_value_color_level_peek_pointer, "p", printers_printer_value_color_level_collect_value, "p", printers_printer_value_color_level_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPrinterColorLevelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_printer_color_level_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPrinterColorLevel), 0, (GInstanceInitFunc) printers_printer_color_level_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType printers_printer_color_level_type_id;
	printers_printer_color_level_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintersPrinterColorLevel", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return printers_printer_color_level_type_id;
}

GType
printers_printer_color_level_get_type (void)
{
	static volatile gsize printers_printer_color_level_type_id__once = 0;
	if (g_once_init_enter (&printers_printer_color_level_type_id__once)) {
		GType printers_printer_color_level_type_id;
		printers_printer_color_level_type_id = printers_printer_color_level_get_type_once ();
		g_once_init_leave (&printers_printer_color_level_type_id__once, printers_printer_color_level_type_id);
	}
	return printers_printer_color_level_type_id__once;
}

gpointer
printers_printer_color_level_ref (gpointer instance)
{
	PrintersPrinterColorLevel * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
printers_printer_color_level_unref (gpointer instance)
{
	PrintersPrinterColorLevel * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PRINTERS_PRINTER_COLOR_LEVEL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
printers_printer_class_init (PrintersPrinterClass * klass,
                             gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	printers_printer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersPrinter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_printer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_printer_set_property;
	G_OBJECT_CLASS (klass)->finalize = printers_printer_finalize;
	/**************
	     * Properties *
	     **************/
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_IS_ENABLED_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_IS_ENABLED_PROPERTY] = g_param_spec_boolean ("is-enabled", "is-enabled", "is-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_IS_DEFAULT_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_IS_DEFAULT_PROPERTY] = g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The type of authentication required for printing to this destination:
	     * "none", "username,password", "domain,username,password", or "negotiate" (Kerberos)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_AUTH_INFO_REQUIRED_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_AUTH_INFO_REQUIRED_PROPERTY] = g_param_spec_string ("auth-info-required", "auth-info-required", "auth-info-required", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The human-readable description of the destination such as "My Laser Printer".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_INFO_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_INFO_PROPERTY] = g_param_spec_string ("info", "info", "info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_IS_ACCEPTING_JOBS_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_IS_ACCEPTING_JOBS_PROPERTY] = g_param_spec_boolean ("is-accepting-jobs", "is-accepting-jobs", "is-accepting-jobs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_STATE_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_STATE_PROPERTY] = g_param_spec_string ("state", "state", "state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_IS_SHARED_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_IS_SHARED_PROPERTY] = g_param_spec_boolean ("is-shared", "is-shared", "is-shared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The human-readable location of the destination such as "Lab 4".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_LOCATION_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_LOCATION_PROPERTY] = g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The human-readable make and model of the destination such as "HP LaserJet 4000 Series".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_MAKE_AND_MODEL_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_MAKE_AND_MODEL_PROPERTY] = g_param_spec_string ("make-and-model", "make-and-model", "make-and-model", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Additional comma-delimited state keywords for the destination such as "media-tray-empty-error" and "toner-low-warning".
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_STATE_REASONS_RAW_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_STATE_REASONS_RAW_PROPERTY] = g_param_spec_string ("state-reasons-raw", "state-reasons-raw", "state-reasons-raw", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_STATE_REASONS_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_STATE_REASONS_PROPERTY] = g_param_spec_string ("state-reasons", "state-reasons", "state-reasons", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The cups_printer_t value associated with the destination.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_PRINTER_TYPE_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_PRINTER_TYPE_PROPERTY] = g_param_spec_string ("printer-type", "printer-type", "printer-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_IS_OFFLINE_PROPERTY, printers_printer_properties[PRINTERS_PRINTER_IS_OFFLINE_PROPERTY] = g_param_spec_boolean ("is-offline", "is-offline", "is-offline", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/***********
	     * Signals *
	     ***********/
	printers_printer_signals[PRINTERS_PRINTER_ENABLED_CHANGED_SIGNAL] = g_signal_new ("enabled-changed", PRINTERS_TYPE_PRINTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	printers_printer_signals[PRINTERS_PRINTER_DEFAULT_CHANGED_SIGNAL] = g_signal_new ("default-changed", PRINTERS_TYPE_PRINTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	printers_printer_signals[PRINTERS_PRINTER_DELETED_SIGNAL] = g_signal_new ("deleted", PRINTERS_TYPE_PRINTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("toner-low");
	_tmp1_ = g_strdup ("toner-empty");
	_tmp2_ = g_strdup ("developer-low");
	_tmp3_ = g_strdup ("developer-empty");
	_tmp4_ = g_strdup ("marker-supply-low");
	_tmp5_ = g_strdup ("marker-supply-empty");
	_tmp6_ = g_strdup ("cover-open");
	_tmp7_ = g_strdup ("door-open");
	_tmp8_ = g_strdup ("media-low");
	_tmp9_ = g_strdup ("media-empty");
	_tmp10_ = g_strdup ("offline");
	_tmp11_ = g_strdup ("paused");
	_tmp12_ = g_strdup ("marker-waste-almost-full");
	_tmp13_ = g_strdup ("marker-waste-full");
	_tmp14_ = g_strdup ("opc-near-eol");
	_tmp15_ = g_strdup ("opc-life-over");
	_tmp16_ = g_new0 (gchar*, 16 + 1);
	_tmp16_[0] = _tmp0_;
	_tmp16_[1] = _tmp1_;
	_tmp16_[2] = _tmp2_;
	_tmp16_[3] = _tmp3_;
	_tmp16_[4] = _tmp4_;
	_tmp16_[5] = _tmp5_;
	_tmp16_[6] = _tmp6_;
	_tmp16_[7] = _tmp7_;
	_tmp16_[8] = _tmp8_;
	_tmp16_[9] = _tmp9_;
	_tmp16_[10] = _tmp10_;
	_tmp16_[11] = _tmp11_;
	_tmp16_[12] = _tmp12_;
	_tmp16_[13] = _tmp13_;
	_tmp16_[14] = _tmp14_;
	_tmp16_[15] = _tmp15_;
	printers_printer_reasons = _tmp16_;
	printers_printer_reasons_length1 = 16;
	_printers_printer_reasons_size_ = printers_printer_reasons_length1;
	_tmp17_ = g_strdup (NC_ ("printer state", "Low on toner"));
	_tmp18_ = g_strdup (NC_ ("printer state", "Out of toner"));
	_tmp19_ = g_strdup (NC_ ("printer state", "Low on developer"));
	_tmp20_ = g_strdup (NC_ ("printer state", "Out of developer"));
	_tmp21_ = g_strdup (NC_ ("printer state", "Low on a marker supply"));
	_tmp22_ = g_strdup (NC_ ("printer state", "Out of a marker supply"));
	_tmp23_ = g_strdup (NC_ ("printer state", "Open cover"));
	_tmp24_ = g_strdup (NC_ ("printer state", "Open door"));
	_tmp25_ = g_strdup (NC_ ("printer state", "Low on paper"));
	_tmp26_ = g_strdup (NC_ ("printer state", "Out of paper"));
	_tmp27_ = g_strdup (NC_ ("printer state", "Offline"));
	_tmp28_ = g_strdup (NC_ ("printer state", "Stopped"));
	_tmp29_ = g_strdup (NC_ ("printer state", "Waste receptacle almost full"));
	_tmp30_ = g_strdup (NC_ ("printer state", "Waste receptacle full"));
	_tmp31_ = g_strdup (NC_ ("printer state", "The optical photo conductor is near end of life"));
	_tmp32_ = g_strdup (NC_ ("printer state", "The optical photo conductor is no longer functioning"));
	_tmp33_ = g_new0 (gchar*, 16 + 1);
	_tmp33_[0] = _tmp17_;
	_tmp33_[1] = _tmp18_;
	_tmp33_[2] = _tmp19_;
	_tmp33_[3] = _tmp20_;
	_tmp33_[4] = _tmp21_;
	_tmp33_[5] = _tmp22_;
	_tmp33_[6] = _tmp23_;
	_tmp33_[7] = _tmp24_;
	_tmp33_[8] = _tmp25_;
	_tmp33_[9] = _tmp26_;
	_tmp33_[10] = _tmp27_;
	_tmp33_[11] = _tmp28_;
	_tmp33_[12] = _tmp29_;
	_tmp33_[13] = _tmp30_;
	_tmp33_[14] = _tmp31_;
	_tmp33_[15] = _tmp32_;
	printers_printer_statuses = _tmp33_;
	printers_printer_statuses_length1 = 16;
	_printers_printer_statuses_size_ = printers_printer_statuses_length1;
}

static void
printers_printer_instance_init (PrintersPrinter * self,
                                gpointer klass)
{
	self->priv = printers_printer_get_instance_private (self);
}

static void
printers_printer_finalize (GObject * obj)
{
	PrintersPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PRINTER, PrintersPrinter);
	_g_free0 (self->priv->_state);
	_g_free0 (self->priv->_state_reasons_raw);
	G_OBJECT_CLASS (printers_printer_parent_class)->finalize (obj);
}

static GType
printers_printer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPrinter), 0, (GInstanceInitFunc) printers_printer_instance_init, NULL };
	GType printers_printer_type_id;
	printers_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "PrintersPrinter", &g_define_type_info, 0);
	PrintersPrinter_private_offset = g_type_add_instance_private (printers_printer_type_id, sizeof (PrintersPrinterPrivate));
	return printers_printer_type_id;
}

GType
printers_printer_get_type (void)
{
	static volatile gsize printers_printer_type_id__once = 0;
	if (g_once_init_enter (&printers_printer_type_id__once)) {
		GType printers_printer_type_id;
		printers_printer_type_id = printers_printer_get_type_once ();
		g_once_init_leave (&printers_printer_type_id__once, printers_printer_type_id);
	}
	return printers_printer_type_id__once;
}

static void
_vala_printers_printer_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PrintersPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_PRINTER, PrintersPrinter);
	switch (property_id) {
		case PRINTERS_PRINTER_IS_ENABLED_PROPERTY:
		g_value_set_boolean (value, printers_printer_get_is_enabled (self));
		break;
		case PRINTERS_PRINTER_IS_DEFAULT_PROPERTY:
		g_value_set_boolean (value, printers_printer_get_is_default (self));
		break;
		case PRINTERS_PRINTER_AUTH_INFO_REQUIRED_PROPERTY:
		g_value_set_string (value, printers_printer_get_auth_info_required (self));
		break;
		case PRINTERS_PRINTER_INFO_PROPERTY:
		g_value_set_string (value, printers_printer_get_info (self));
		break;
		case PRINTERS_PRINTER_IS_ACCEPTING_JOBS_PROPERTY:
		g_value_set_boolean (value, printers_printer_get_is_accepting_jobs (self));
		break;
		case PRINTERS_PRINTER_STATE_PROPERTY:
		g_value_set_string (value, printers_printer_get_state (self));
		break;
		case PRINTERS_PRINTER_IS_SHARED_PROPERTY:
		g_value_set_boolean (value, printers_printer_get_is_shared (self));
		break;
		case PRINTERS_PRINTER_LOCATION_PROPERTY:
		g_value_set_string (value, printers_printer_get_location (self));
		break;
		case PRINTERS_PRINTER_MAKE_AND_MODEL_PROPERTY:
		g_value_set_string (value, printers_printer_get_make_and_model (self));
		break;
		case PRINTERS_PRINTER_STATE_REASONS_RAW_PROPERTY:
		g_value_set_string (value, printers_printer_get_state_reasons_raw (self));
		break;
		case PRINTERS_PRINTER_STATE_REASONS_PROPERTY:
		g_value_set_string (value, printers_printer_get_state_reasons (self));
		break;
		case PRINTERS_PRINTER_PRINTER_TYPE_PROPERTY:
		g_value_set_string (value, printers_printer_get_printer_type (self));
		break;
		case PRINTERS_PRINTER_IS_OFFLINE_PROPERTY:
		g_value_set_boolean (value, printers_printer_get_is_offline (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_printer_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	PrintersPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_PRINTER, PrintersPrinter);
	switch (property_id) {
		case PRINTERS_PRINTER_IS_ENABLED_PROPERTY:
		printers_printer_set_is_enabled (self, g_value_get_boolean (value));
		break;
		case PRINTERS_PRINTER_INFO_PROPERTY:
		printers_printer_set_info (self, g_value_get_string (value));
		break;
		case PRINTERS_PRINTER_IS_ACCEPTING_JOBS_PROPERTY:
		printers_printer_set_is_accepting_jobs (self, g_value_get_boolean (value));
		break;
		case PRINTERS_PRINTER_STATE_PROPERTY:
		printers_printer_set_state (self, g_value_get_string (value));
		break;
		case PRINTERS_PRINTER_IS_SHARED_PROPERTY:
		printers_printer_set_is_shared (self, g_value_get_boolean (value));
		break;
		case PRINTERS_PRINTER_LOCATION_PROPERTY:
		printers_printer_set_location (self, g_value_get_string (value));
		break;
		case PRINTERS_PRINTER_STATE_REASONS_RAW_PROPERTY:
		printers_printer_set_state_reasons_raw (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

