/* Interfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/*
 * Copyright (c) 2011-2016 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "power.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy PowerDBusProxy;
typedef GDBusProxyClass PowerDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	POWER_LOGIND_HELPER_IFACE_CHANGED_SIGNAL,
	POWER_LOGIND_HELPER_IFACE_NUM_SIGNALS
};
static guint power_logind_helper_iface_signals[POWER_LOGIND_HELPER_IFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy PowerLogindHelperIfaceProxy;
typedef GDBusProxyClass PowerLogindHelperIfaceProxyClass;

#define POWER_TYPE_POWER_SETTINGS (power_power_settings_get_type ())
#define POWER_POWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_POWER_SETTINGS, PowerPowerSettings))
#define POWER_IS_POWER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_POWER_SETTINGS))
#define POWER_POWER_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), POWER_TYPE_POWER_SETTINGS, PowerPowerSettingsIface))

typedef struct _PowerPowerSettings PowerPowerSettings;
typedef struct _PowerPowerSettingsIface PowerPowerSettingsIface;

#define POWER_TYPE_POWER_SETTINGS_PROXY (power_power_settings_proxy_get_type ())
typedef GDBusProxy PowerPowerSettingsProxy;
typedef GDBusProxyClass PowerPowerSettingsProxyClass;

#define POWER_TYPE_UPOWER (power_upower_get_type ())
#define POWER_UPOWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_UPOWER, PowerUpower))
#define POWER_IS_UPOWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_UPOWER))
#define POWER_UPOWER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), POWER_TYPE_UPOWER, PowerUpowerIface))

typedef struct _PowerUpower PowerUpower;
typedef struct _PowerUpowerIface PowerUpowerIface;

#define POWER_TYPE_UPOWER_PROXY (power_upower_proxy_get_type ())
enum  {
	POWER_UPOWER_CHANGED_SIGNAL,
	POWER_UPOWER_DEVICE_ADDED_SIGNAL,
	POWER_UPOWER_DEVICE_REMOVED_SIGNAL,
	POWER_UPOWER_NUM_SIGNALS
};
static guint power_upower_signals[POWER_UPOWER_NUM_SIGNALS] = {0};
typedef GDBusProxy PowerUpowerProxy;
typedef GDBusProxyClass PowerUpowerProxyClass;
typedef GDBusProxy PowerPowerProfileProxy;
typedef GDBusProxyClass PowerPowerProfileProxyClass;

struct _PowerPowerSettingsIface {
	GTypeInterface parent_iface;
	gint (*get_brightness) (PowerPowerSettings* self);
	void (*set_brightness) (PowerPowerSettings* self, gint value);
};

struct _PowerUpowerIface {
	GTypeInterface parent_iface;
	char** (*enumerate_devices) (PowerUpower* self, gint* result_length1, GError** error);
	gboolean (*get_on_battery) (PowerUpower* self);
	gboolean (*get_lid_is_present) (PowerUpower* self);
	gboolean (*get_low_on_battery) (PowerUpower* self);
};

static GType power_dbus_get_type_once (void);
static void power_dbus_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters);
static guint32 power_dbus_proxy_get_connection_unix_process_id (PowerDBus* self,
                                                         const gchar* name,
                                                         GError** error);
static guint32 power_dbus_proxy_get_connection_unix_user (PowerDBus* self,
                                                   const gchar* name,
                                                   GError** error);
static void power_dbus_proxy_power_dbus_interface_init (PowerDBusIface* iface);
static void _dbus_power_dbus_get_connection_unix_process_id (PowerDBus* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_power_dbus_get_connection_unix_user (PowerDBus* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void power_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data);
static GVariant* power_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data);
static gboolean power_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data);
static void _power_dbus_unregister_object (gpointer user_data);
static GType power_logind_helper_iface_get_type_once (void);
static void power_logind_helper_iface_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static void _dbus_handle_power_logind_helper_iface_changed (PowerLogindHelperIface* self,
                                                     GVariant* parameters);
static void power_logind_helper_iface_proxy_set_key (PowerLogindHelperIface* self,
                                              const gchar* key,
                                              const gchar* value,
                                              GError** error);
static gchar* power_logind_helper_iface_proxy_get_key (PowerLogindHelperIface* self,
                                                const gchar* key,
                                                GError** error);
static gboolean power_logind_helper_iface_dbus_proxy_get_present (PowerLogindHelperIface* self);
static void power_logind_helper_iface_proxy_power_logind_helper_iface_interface_init (PowerLogindHelperIfaceIface* iface);
static void _dbus_power_logind_helper_iface_set_key (PowerLogindHelperIface* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_power_logind_helper_iface_get_key (PowerLogindHelperIface* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void power_logind_helper_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* power_logind_helper_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static GVariant* _dbus_power_logind_helper_iface_get_present (PowerLogindHelperIface* self);
static gboolean power_logind_helper_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _dbus_power_logind_helper_iface_changed (GObject* _sender,
                                              gpointer* _data);
static void _power_logind_helper_iface_unregister_object (gpointer user_data);
VALA_EXTERN GType power_power_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType power_power_settings_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint power_power_settings_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN gint power_power_settings_get_brightness (PowerPowerSettings* self);
VALA_EXTERN void power_power_settings_set_brightness (PowerPowerSettings* self,
                                          gint value);
static GType power_power_settings_get_type_once (void);
static void power_power_settings_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static gint power_power_settings_dbus_proxy_get_brightness (PowerPowerSettings* self);
static void power_power_settings_dbus_proxy_set_brightness (PowerPowerSettings* self,
                                                     gint value);
static void power_power_settings_proxy_power_power_settings_interface_init (PowerPowerSettingsIface* iface);
static void power_power_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* power_power_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static GVariant* _dbus_power_power_settings_get_brightness (PowerPowerSettings* self);
static gboolean power_power_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_power_power_settings_set_brightness (PowerPowerSettings* self,
                                                GVariant* _value);
static void _power_power_settings_unregister_object (gpointer user_data);
VALA_EXTERN GType power_upower_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint power_upower_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType power_upower_get_type (void) G_GNUC_CONST ;
VALA_EXTERN char** power_upower_enumerate_devices (PowerUpower* self,
                                       gint* result_length1,
                                       GError** error);
VALA_EXTERN gboolean power_upower_get_on_battery (PowerUpower* self);
VALA_EXTERN gboolean power_upower_get_lid_is_present (PowerUpower* self);
VALA_EXTERN gboolean power_upower_get_low_on_battery (PowerUpower* self);
static GType power_upower_get_type_once (void);
static void power_upower_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void _dbus_handle_power_upower_changed (PowerUpower* self,
                                        GVariant* parameters);
static void _dbus_handle_power_upower_device_added (PowerUpower* self,
                                             GVariant* parameters);
static void _dbus_handle_power_upower_device_removed (PowerUpower* self,
                                               GVariant* parameters);
static char** power_upower_proxy_enumerate_devices (PowerUpower* self,
                                             gint* result_length1,
                                             GError** error);
static gboolean power_upower_dbus_proxy_get_on_battery (PowerUpower* self);
static gboolean power_upower_dbus_proxy_get_lid_is_present (PowerUpower* self);
static gboolean power_upower_dbus_proxy_get_low_on_battery (PowerUpower* self);
static void power_upower_proxy_power_upower_interface_init (PowerUpowerIface* iface);
static void _dbus_power_upower_enumerate_devices (PowerUpower* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void power_upower_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* power_upower_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static GVariant* _dbus_power_upower_get_on_battery (PowerUpower* self);
static GVariant* _dbus_power_upower_get_lid_is_present (PowerUpower* self);
static GVariant* _dbus_power_upower_get_low_on_battery (PowerUpower* self);
static gboolean power_upower_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _dbus_power_upower_changed (GObject* _sender,
                                 gpointer* _data);
static void _dbus_power_upower_device_added (GObject* _sender,
                                      const char* device_path,
                                      gpointer* _data);
static void _dbus_power_upower_device_removed (GObject* _sender,
                                        const char* device_path,
                                        gpointer* _data);
static void _power_upower_unregister_object (gpointer user_data);
static GType power_power_profile_get_type_once (void);
static void power_power_profile_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static GHashTable** power_power_profile_dbus_proxy_get_profiles (PowerPowerProfile* self,
                                                          gint* result_length1);
static gchar* power_power_profile_dbus_proxy_get_active_profile (PowerPowerProfile* self);
static void power_power_profile_dbus_proxy_set_active_profile (PowerPowerProfile* self,
                                                        const gchar* value);
static void power_power_profile_proxy_power_power_profile_interface_init (PowerPowerProfileIface* iface);
static void power_power_profile_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* power_power_profile_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static GVariant* _dbus_power_power_profile_get_profiles (PowerPowerProfile* self);
static GVariant* _dbus_power_power_profile_get_active_profile (PowerPowerProfile* self);
static gboolean power_power_profile_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_power_power_profile_set_active_profile (PowerPowerProfile* self,
                                                   GVariant* _value);
static void _power_power_profile_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _power_dbus_dbus_arg_info_get_connection_unix_process_id_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _power_dbus_dbus_arg_info_get_connection_unix_process_id_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _power_dbus_dbus_arg_info_get_connection_unix_process_id_in[] = {&_power_dbus_dbus_arg_info_get_connection_unix_process_id_name, NULL};
static const GDBusArgInfo * const _power_dbus_dbus_arg_info_get_connection_unix_process_id_out[] = {&_power_dbus_dbus_arg_info_get_connection_unix_process_id_result, NULL};
static const GDBusMethodInfo _power_dbus_dbus_method_info_get_connection_unix_process_id = {-1, "GetConnectionUnixProcessID", (GDBusArgInfo **) (&_power_dbus_dbus_arg_info_get_connection_unix_process_id_in), (GDBusArgInfo **) (&_power_dbus_dbus_arg_info_get_connection_unix_process_id_out), NULL};
static const GDBusArgInfo _power_dbus_dbus_arg_info_get_connection_unix_user_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _power_dbus_dbus_arg_info_get_connection_unix_user_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _power_dbus_dbus_arg_info_get_connection_unix_user_in[] = {&_power_dbus_dbus_arg_info_get_connection_unix_user_name, NULL};
static const GDBusArgInfo * const _power_dbus_dbus_arg_info_get_connection_unix_user_out[] = {&_power_dbus_dbus_arg_info_get_connection_unix_user_result, NULL};
static const GDBusMethodInfo _power_dbus_dbus_method_info_get_connection_unix_user = {-1, "GetConnectionUnixUser", (GDBusArgInfo **) (&_power_dbus_dbus_arg_info_get_connection_unix_user_in), (GDBusArgInfo **) (&_power_dbus_dbus_arg_info_get_connection_unix_user_out), NULL};
static const GDBusMethodInfo * const _power_dbus_dbus_method_info[] = {&_power_dbus_dbus_method_info_get_connection_unix_process_id, &_power_dbus_dbus_method_info_get_connection_unix_user, NULL};
static const GDBusSignalInfo * const _power_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _power_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _power_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_power_dbus_dbus_method_info), (GDBusSignalInfo **) (&_power_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_power_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_dbus_dbus_interface_vtable = {power_dbus_dbus_interface_method_call, power_dbus_dbus_interface_get_property, power_dbus_dbus_interface_set_property};
static const GDBusArgInfo _power_logind_helper_iface_dbus_arg_info_set_key_key = {-1, "key", "s", NULL};
static const GDBusArgInfo _power_logind_helper_iface_dbus_arg_info_set_key_value = {-1, "value", "s", NULL};
static const GDBusArgInfo * const _power_logind_helper_iface_dbus_arg_info_set_key_in[] = {&_power_logind_helper_iface_dbus_arg_info_set_key_key, &_power_logind_helper_iface_dbus_arg_info_set_key_value, NULL};
static const GDBusArgInfo * const _power_logind_helper_iface_dbus_arg_info_set_key_out[] = {NULL};
static const GDBusMethodInfo _power_logind_helper_iface_dbus_method_info_set_key = {-1, "SetKey", (GDBusArgInfo **) (&_power_logind_helper_iface_dbus_arg_info_set_key_in), (GDBusArgInfo **) (&_power_logind_helper_iface_dbus_arg_info_set_key_out), NULL};
static const GDBusArgInfo _power_logind_helper_iface_dbus_arg_info_get_key_key = {-1, "key", "s", NULL};
static const GDBusArgInfo _power_logind_helper_iface_dbus_arg_info_get_key_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _power_logind_helper_iface_dbus_arg_info_get_key_in[] = {&_power_logind_helper_iface_dbus_arg_info_get_key_key, NULL};
static const GDBusArgInfo * const _power_logind_helper_iface_dbus_arg_info_get_key_out[] = {&_power_logind_helper_iface_dbus_arg_info_get_key_result, NULL};
static const GDBusMethodInfo _power_logind_helper_iface_dbus_method_info_get_key = {-1, "GetKey", (GDBusArgInfo **) (&_power_logind_helper_iface_dbus_arg_info_get_key_in), (GDBusArgInfo **) (&_power_logind_helper_iface_dbus_arg_info_get_key_out), NULL};
static const GDBusMethodInfo * const _power_logind_helper_iface_dbus_method_info[] = {&_power_logind_helper_iface_dbus_method_info_set_key, &_power_logind_helper_iface_dbus_method_info_get_key, NULL};
static const GDBusArgInfo * const _power_logind_helper_iface_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _power_logind_helper_iface_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_power_logind_helper_iface_dbus_arg_info_changed), NULL};
static const GDBusSignalInfo * const _power_logind_helper_iface_dbus_signal_info[] = {&_power_logind_helper_iface_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo _power_logind_helper_iface_dbus_property_info_present = {-1, "Present", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _power_logind_helper_iface_dbus_property_info[] = {&_power_logind_helper_iface_dbus_property_info_present, NULL};
static const GDBusInterfaceInfo _power_logind_helper_iface_dbus_interface_info = {-1, "io.elementary.logind.helper", (GDBusMethodInfo **) (&_power_logind_helper_iface_dbus_method_info), (GDBusSignalInfo **) (&_power_logind_helper_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_power_logind_helper_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_logind_helper_iface_dbus_interface_vtable = {power_logind_helper_iface_dbus_interface_method_call, power_logind_helper_iface_dbus_interface_get_property, power_logind_helper_iface_dbus_interface_set_property};
static const GDBusMethodInfo * const _power_power_settings_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _power_power_settings_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _power_power_settings_dbus_property_info_brightness = {-1, "Brightness", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _power_power_settings_dbus_property_info[] = {&_power_power_settings_dbus_property_info_brightness, NULL};
static const GDBusInterfaceInfo _power_power_settings_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Power.Screen", (GDBusMethodInfo **) (&_power_power_settings_dbus_method_info), (GDBusSignalInfo **) (&_power_power_settings_dbus_signal_info), (GDBusPropertyInfo **) (&_power_power_settings_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_power_settings_dbus_interface_vtable = {power_power_settings_dbus_interface_method_call, power_power_settings_dbus_interface_get_property, power_power_settings_dbus_interface_set_property};
static const GDBusArgInfo _power_upower_dbus_arg_info_enumerate_devices_result = {-1, "result", "ao", NULL};
static const GDBusArgInfo * const _power_upower_dbus_arg_info_enumerate_devices_in[] = {NULL};
static const GDBusArgInfo * const _power_upower_dbus_arg_info_enumerate_devices_out[] = {&_power_upower_dbus_arg_info_enumerate_devices_result, NULL};
static const GDBusMethodInfo _power_upower_dbus_method_info_enumerate_devices = {-1, "EnumerateDevices", (GDBusArgInfo **) (&_power_upower_dbus_arg_info_enumerate_devices_in), (GDBusArgInfo **) (&_power_upower_dbus_arg_info_enumerate_devices_out), NULL};
static const GDBusMethodInfo * const _power_upower_dbus_method_info[] = {&_power_upower_dbus_method_info_enumerate_devices, NULL};
static const GDBusArgInfo * const _power_upower_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _power_upower_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_power_upower_dbus_arg_info_changed), NULL};
static const GDBusArgInfo _power_upower_dbus_arg_info_device_added_device_path = {-1, "device_path", "o", NULL};
static const GDBusArgInfo * const _power_upower_dbus_arg_info_device_added[] = {&_power_upower_dbus_arg_info_device_added_device_path, NULL};
static const GDBusSignalInfo _power_upower_dbus_signal_info_device_added = {-1, "DeviceAdded", (GDBusArgInfo **) (&_power_upower_dbus_arg_info_device_added), NULL};
static const GDBusArgInfo _power_upower_dbus_arg_info_device_removed_device_path = {-1, "device_path", "o", NULL};
static const GDBusArgInfo * const _power_upower_dbus_arg_info_device_removed[] = {&_power_upower_dbus_arg_info_device_removed_device_path, NULL};
static const GDBusSignalInfo _power_upower_dbus_signal_info_device_removed = {-1, "DeviceRemoved", (GDBusArgInfo **) (&_power_upower_dbus_arg_info_device_removed), NULL};
static const GDBusSignalInfo * const _power_upower_dbus_signal_info[] = {&_power_upower_dbus_signal_info_changed, &_power_upower_dbus_signal_info_device_added, &_power_upower_dbus_signal_info_device_removed, NULL};
static const GDBusPropertyInfo _power_upower_dbus_property_info_on_battery = {-1, "OnBattery", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_dbus_property_info_lid_is_present = {-1, "LidIsPresent", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_dbus_property_info_low_on_battery = {-1, "LowOnBattery", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _power_upower_dbus_property_info[] = {&_power_upower_dbus_property_info_on_battery, &_power_upower_dbus_property_info_lid_is_present, &_power_upower_dbus_property_info_low_on_battery, NULL};
static const GDBusInterfaceInfo _power_upower_dbus_interface_info = {-1, "org.freedesktop.UPower", (GDBusMethodInfo **) (&_power_upower_dbus_method_info), (GDBusSignalInfo **) (&_power_upower_dbus_signal_info), (GDBusPropertyInfo **) (&_power_upower_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_upower_dbus_interface_vtable = {power_upower_dbus_interface_method_call, power_upower_dbus_interface_get_property, power_upower_dbus_interface_set_property};
static const GDBusMethodInfo * const _power_power_profile_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _power_power_profile_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _power_power_profile_dbus_property_info_profiles = {-1, "Profiles", "aa{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_power_profile_dbus_property_info_active_profile = {-1, "ActiveProfile", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _power_power_profile_dbus_property_info[] = {&_power_power_profile_dbus_property_info_profiles, &_power_power_profile_dbus_property_info_active_profile, NULL};
static const GDBusInterfaceInfo _power_power_profile_dbus_interface_info = {-1, "net.hadess.PowerProfiles", (GDBusMethodInfo **) (&_power_power_profile_dbus_method_info), (GDBusSignalInfo **) (&_power_power_profile_dbus_signal_info), (GDBusPropertyInfo **) (&_power_power_profile_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_power_profile_dbus_interface_vtable = {power_power_profile_dbus_interface_method_call, power_power_profile_dbus_interface_get_property, power_power_profile_dbus_interface_set_property};

guint32
power_dbus_get_connection_unix_process_id (PowerDBus* self,
                                           const gchar* name,
                                           GError** error)
{
	PowerDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = POWER_DBUS_GET_INTERFACE (self);
	if (_iface_->get_connection_unix_process_id) {
		return _iface_->get_connection_unix_process_id (self, name, error);
	}
	return 0U;
}

guint32
power_dbus_get_connection_unix_user (PowerDBus* self,
                                     const gchar* name,
                                     GError** error)
{
	PowerDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = POWER_DBUS_GET_INTERFACE (self);
	if (_iface_->get_connection_unix_user) {
		return _iface_->get_connection_unix_user (self, name, error);
	}
	return 0U;
}

static void
power_dbus_default_init (PowerDBusIface * iface,
                         gpointer iface_data)
{
}

static GType
power_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType power_dbus_type_id;
	power_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "PowerDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_dbus_proxy_get_type);
	g_type_set_qdata (power_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
	g_type_set_qdata (power_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_dbus_dbus_interface_info));
	g_type_set_qdata (power_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_dbus_register_object);
	return power_dbus_type_id;
}

GType
power_dbus_get_type (void)
{
	static volatile gsize power_dbus_type_id__once = 0;
	if (g_once_init_enter (&power_dbus_type_id__once)) {
		GType power_dbus_type_id;
		power_dbus_type_id = power_dbus_get_type_once ();
		g_once_init_leave (&power_dbus_type_id__once, power_dbus_type_id);
	}
	return power_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PowerDBusProxy, power_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (POWER_TYPE_DBUS, power_dbus_proxy_power_dbus_interface_init) )
static void
power_dbus_proxy_class_init (PowerDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_dbus_proxy_g_signal;
}

static void
power_dbus_proxy_g_signal (GDBusProxy* proxy,
                           const gchar* sender_name,
                           const gchar* signal_name,
                           GVariant* parameters)
{
}

static void
power_dbus_proxy_init (PowerDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_dbus_dbus_interface_info));
}

static guint32
power_dbus_proxy_get_connection_unix_process_id (PowerDBus* self,
                                                 const gchar* name,
                                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp13_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "GetConnectionUnixProcessID");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		guint32 _tmp11_ = 0U;
		return _tmp11_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint32 _tmp12_ = 0U;
		g_object_unref (_reply_message);
		return _tmp12_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp13_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp13_);
	g_variant_unref (_tmp13_);
	g_object_unref (_reply_message);
	return _result;
}

static guint32
power_dbus_proxy_get_connection_unix_user (PowerDBus* self,
                                           const gchar* name,
                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp16_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "GetConnectionUnixUser");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		guint32 _tmp14_ = 0U;
		return _tmp14_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint32 _tmp15_ = 0U;
		g_object_unref (_reply_message);
		return _tmp15_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp16_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp16_);
	g_variant_unref (_tmp16_);
	g_object_unref (_reply_message);
	return _result;
}

static void
power_dbus_proxy_power_dbus_interface_init (PowerDBusIface* iface)
{
	iface->get_connection_unix_process_id = power_dbus_proxy_get_connection_unix_process_id;
	iface->get_connection_unix_user = power_dbus_proxy_get_connection_unix_user;
}

static void
_dbus_power_dbus_get_connection_unix_process_id (PowerDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp17_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	result = power_dbus_get_connection_unix_process_id (self, name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
_dbus_power_dbus_get_connection_unix_user (PowerDBus* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	result = power_dbus_get_connection_unix_user (self, name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
power_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* method_name,
                                       GVariant* parameters,
                                       GDBusMethodInvocation* invocation,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetConnectionUnixProcessID") == 0) {
		_dbus_power_dbus_get_connection_unix_process_id (object, parameters, invocation);
	} else if (strcmp (method_name, "GetConnectionUnixUser") == 0) {
		_dbus_power_dbus_get_connection_unix_user (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
power_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* property_name,
                                        GError** error,
                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
power_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* property_name,
                                        GVariant* value,
                                        GError** error,
                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
power_dbus_register_object (gpointer object,
                            GDBusConnection* connection,
                            const gchar* path,
                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_dbus_dbus_interface_info), &_power_dbus_dbus_interface_vtable, data, _power_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_power_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
power_logind_helper_iface_set_key (PowerLogindHelperIface* self,
                                   const gchar* key,
                                   const gchar* value,
                                   GError** error)
{
	PowerLogindHelperIfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POWER_LOGIND_HELPER_IFACE_GET_INTERFACE (self);
	if (_iface_->set_key) {
		_iface_->set_key (self, key, value, error);
	}
}

gchar*
power_logind_helper_iface_get_key (PowerLogindHelperIface* self,
                                   const gchar* key,
                                   GError** error)
{
	PowerLogindHelperIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_LOGIND_HELPER_IFACE_GET_INTERFACE (self);
	if (_iface_->get_key) {
		return _iface_->get_key (self, key, error);
	}
	return NULL;
}

gboolean
power_logind_helper_iface_get_present (PowerLogindHelperIface* self)
{
	PowerLogindHelperIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_LOGIND_HELPER_IFACE_GET_INTERFACE (self);
	if (_iface_->get_present) {
		return _iface_->get_present (self);
	}
	return FALSE;
}

static void
power_logind_helper_iface_default_init (PowerLogindHelperIfaceIface * iface,
                                        gpointer iface_data)
{
	power_logind_helper_iface_signals[POWER_LOGIND_HELPER_IFACE_CHANGED_SIGNAL] = g_signal_new ("changed", POWER_TYPE_LOGIND_HELPER_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
power_logind_helper_iface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerLogindHelperIfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_logind_helper_iface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType power_logind_helper_iface_type_id;
	power_logind_helper_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "PowerLogindHelperIface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_logind_helper_iface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_logind_helper_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_logind_helper_iface_proxy_get_type);
	g_type_set_qdata (power_logind_helper_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.logind.helper");
	g_type_set_qdata (power_logind_helper_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_logind_helper_iface_dbus_interface_info));
	g_type_set_qdata (power_logind_helper_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_logind_helper_iface_register_object);
	return power_logind_helper_iface_type_id;
}

GType
power_logind_helper_iface_get_type (void)
{
	static volatile gsize power_logind_helper_iface_type_id__once = 0;
	if (g_once_init_enter (&power_logind_helper_iface_type_id__once)) {
		GType power_logind_helper_iface_type_id;
		power_logind_helper_iface_type_id = power_logind_helper_iface_get_type_once ();
		g_once_init_leave (&power_logind_helper_iface_type_id__once, power_logind_helper_iface_type_id);
	}
	return power_logind_helper_iface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PowerLogindHelperIfaceProxy, power_logind_helper_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (POWER_TYPE_LOGIND_HELPER_IFACE, power_logind_helper_iface_proxy_power_logind_helper_iface_interface_init) )
static void
power_logind_helper_iface_proxy_class_init (PowerLogindHelperIfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_logind_helper_iface_proxy_g_signal;
}

static void
_dbus_handle_power_logind_helper_iface_changed (PowerLogindHelperIface* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "changed");
}

static void
power_logind_helper_iface_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_power_logind_helper_iface_changed ((PowerLogindHelperIface*) proxy, parameters);
	}
}

static void
power_logind_helper_iface_proxy_init (PowerLogindHelperIfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_logind_helper_iface_dbus_interface_info));
}

static void
power_logind_helper_iface_proxy_set_key (PowerLogindHelperIface* self,
                                         const gchar* key,
                                         const gchar* value,
                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.logind.helper", "SetKey");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (key));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
power_logind_helper_iface_proxy_get_key (PowerLogindHelperIface* self,
                                         const gchar* key,
                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp19_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.logind.helper", "GetKey");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (key));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp19_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	g_object_unref (_reply_message);
	return _result;
}

static gboolean
power_logind_helper_iface_dbus_proxy_get_present (PowerLogindHelperIface* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Present");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.logind.helper"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Present"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp20_ = FALSE;
			return _tmp20_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
power_logind_helper_iface_proxy_power_logind_helper_iface_interface_init (PowerLogindHelperIfaceIface* iface)
{
	iface->set_key = power_logind_helper_iface_proxy_set_key;
	iface->get_key = power_logind_helper_iface_proxy_get_key;
	iface->get_present = power_logind_helper_iface_dbus_proxy_get_present;
}

static void
_dbus_power_logind_helper_iface_set_key (PowerLogindHelperIface* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* key = NULL;
	GVariant* _tmp21_;
	gchar* value = NULL;
	GVariant* _tmp22_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	key = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	value = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	power_logind_helper_iface_set_key (self, key, value, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (key);
	_g_free0 (value);
	;
}

static void
_dbus_power_logind_helper_iface_get_key (PowerLogindHelperIface* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* key = NULL;
	GVariant* _tmp23_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	key = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	result = power_logind_helper_iface_get_key (self, key, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (key);
	;
}

static void
power_logind_helper_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetKey") == 0) {
		_dbus_power_logind_helper_iface_set_key (object, parameters, invocation);
	} else if (strcmp (method_name, "GetKey") == 0) {
		_dbus_power_logind_helper_iface_get_key (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_power_logind_helper_iface_get_present (PowerLogindHelperIface* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_logind_helper_iface_get_present (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
power_logind_helper_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Present") == 0) {
		return _dbus_power_logind_helper_iface_get_present (object);
	}
	return NULL;
}

static gboolean
power_logind_helper_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_power_logind_helper_iface_changed (GObject* _sender,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "io.elementary.logind.helper", "Changed", _arguments, NULL);
}

guint
power_logind_helper_iface_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_logind_helper_iface_dbus_interface_info), &_power_logind_helper_iface_dbus_interface_vtable, data, _power_logind_helper_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_power_logind_helper_iface_changed, data);
	return result;
}

static void
_power_logind_helper_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_power_logind_helper_iface_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gint
power_power_settings_get_brightness (PowerPowerSettings* self)
{
	PowerPowerSettingsIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = POWER_POWER_SETTINGS_GET_INTERFACE (self);
	if (_iface_->get_brightness) {
		return _iface_->get_brightness (self);
	}
	return -1;
}

void
power_power_settings_set_brightness (PowerPowerSettings* self,
                                     gint value)
{
	PowerPowerSettingsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POWER_POWER_SETTINGS_GET_INTERFACE (self);
	if (_iface_->set_brightness) {
		_iface_->set_brightness (self, value);
	}
}

static void
power_power_settings_default_init (PowerPowerSettingsIface * iface,
                                   gpointer iface_data)
{
}

static GType
power_power_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerPowerSettingsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_power_settings_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType power_power_settings_type_id;
	power_power_settings_type_id = g_type_register_static (G_TYPE_INTERFACE, "PowerPowerSettings", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_power_settings_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_power_settings_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_power_settings_proxy_get_type);
	g_type_set_qdata (power_power_settings_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Power.Screen");
	g_type_set_qdata (power_power_settings_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_power_settings_dbus_interface_info));
	g_type_set_qdata (power_power_settings_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_power_settings_register_object);
	return power_power_settings_type_id;
}

GType
power_power_settings_get_type (void)
{
	static volatile gsize power_power_settings_type_id__once = 0;
	if (g_once_init_enter (&power_power_settings_type_id__once)) {
		GType power_power_settings_type_id;
		power_power_settings_type_id = power_power_settings_get_type_once ();
		g_once_init_leave (&power_power_settings_type_id__once, power_power_settings_type_id);
	}
	return power_power_settings_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PowerPowerSettingsProxy, power_power_settings_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (POWER_TYPE_POWER_SETTINGS, power_power_settings_proxy_power_power_settings_interface_init) )
static void
power_power_settings_proxy_class_init (PowerPowerSettingsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_power_settings_proxy_g_signal;
}

static void
power_power_settings_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
}

static void
power_power_settings_proxy_init (PowerPowerSettingsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_power_settings_dbus_interface_info));
}

static gint
power_power_settings_dbus_proxy_get_brightness (PowerPowerSettings* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Brightness");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp24_ = 0;
			return _tmp24_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
power_power_settings_dbus_proxy_set_brightness (PowerPowerSettings* self,
                                                gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
power_power_settings_proxy_power_power_settings_interface_init (PowerPowerSettingsIface* iface)
{
	iface->get_brightness = power_power_settings_dbus_proxy_get_brightness;
	iface->set_brightness = power_power_settings_dbus_proxy_set_brightness;
}

static void
power_power_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_power_power_settings_get_brightness (PowerPowerSettings* self)
{
	gint result;
	GVariant* _reply;
	result = power_power_settings_get_brightness (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
power_power_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		return _dbus_power_power_settings_get_brightness (object);
	}
	return NULL;
}

static void
_dbus_power_power_settings_set_brightness (PowerPowerSettings* self,
                                           GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	power_power_settings_set_brightness (self, value);
}

static gboolean
power_power_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		_dbus_power_power_settings_set_brightness (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
power_power_settings_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_power_settings_dbus_interface_info), &_power_power_settings_dbus_interface_vtable, data, _power_power_settings_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_power_power_settings_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

char**
power_upower_enumerate_devices (PowerUpower* self,
                                gint* result_length1,
                                GError** error)
{
	PowerUpowerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_UPOWER_GET_INTERFACE (self);
	if (_iface_->enumerate_devices) {
		return _iface_->enumerate_devices (self, result_length1, error);
	}
	return NULL;
}

gboolean
power_upower_get_on_battery (PowerUpower* self)
{
	PowerUpowerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_UPOWER_GET_INTERFACE (self);
	if (_iface_->get_on_battery) {
		return _iface_->get_on_battery (self);
	}
	return FALSE;
}

gboolean
power_upower_get_lid_is_present (PowerUpower* self)
{
	PowerUpowerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_UPOWER_GET_INTERFACE (self);
	if (_iface_->get_lid_is_present) {
		return _iface_->get_lid_is_present (self);
	}
	return FALSE;
}

gboolean
power_upower_get_low_on_battery (PowerUpower* self)
{
	PowerUpowerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_UPOWER_GET_INTERFACE (self);
	if (_iface_->get_low_on_battery) {
		return _iface_->get_low_on_battery (self);
	}
	return FALSE;
}

static void
power_upower_default_init (PowerUpowerIface * iface,
                           gpointer iface_data)
{
	power_upower_signals[POWER_UPOWER_CHANGED_SIGNAL] = g_signal_new ("changed", POWER_TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	power_upower_signals[POWER_UPOWER_DEVICE_ADDED_SIGNAL] = g_signal_new ("device-added", POWER_TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	power_upower_signals[POWER_UPOWER_DEVICE_REMOVED_SIGNAL] = g_signal_new ("device-removed", POWER_TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static GType
power_upower_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerUpowerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_upower_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType power_upower_type_id;
	power_upower_type_id = g_type_register_static (G_TYPE_INTERFACE, "PowerUpower", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_upower_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_upower_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_upower_proxy_get_type);
	g_type_set_qdata (power_upower_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.UPower");
	g_type_set_qdata (power_upower_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_upower_dbus_interface_info));
	g_type_set_qdata (power_upower_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_upower_register_object);
	return power_upower_type_id;
}

GType
power_upower_get_type (void)
{
	static volatile gsize power_upower_type_id__once = 0;
	if (g_once_init_enter (&power_upower_type_id__once)) {
		GType power_upower_type_id;
		power_upower_type_id = power_upower_get_type_once ();
		g_once_init_leave (&power_upower_type_id__once, power_upower_type_id);
	}
	return power_upower_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PowerUpowerProxy, power_upower_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (POWER_TYPE_UPOWER, power_upower_proxy_power_upower_interface_init) )
static void
power_upower_proxy_class_init (PowerUpowerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_upower_proxy_g_signal;
}

static void
_dbus_handle_power_upower_changed (PowerUpower* self,
                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "changed");
}

static void
_dbus_handle_power_upower_device_added (PowerUpower* self,
                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	char* device_path = NULL;
	GVariant* _tmp25_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	device_path = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	g_signal_emit_by_name (self, "device-added", device_path);
	_g_free0 (device_path);
}

static void
_dbus_handle_power_upower_device_removed (PowerUpower* self,
                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	char* device_path = NULL;
	GVariant* _tmp26_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	device_path = g_variant_dup_string (_tmp26_, NULL);
	g_variant_unref (_tmp26_);
	g_signal_emit_by_name (self, "device-removed", device_path);
	_g_free0 (device_path);
}

static void
power_upower_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_power_upower_changed ((PowerUpower*) proxy, parameters);
	} else if (strcmp (signal_name, "DeviceAdded") == 0) {
		_dbus_handle_power_upower_device_added ((PowerUpower*) proxy, parameters);
	} else if (strcmp (signal_name, "DeviceRemoved") == 0) {
		_dbus_handle_power_upower_device_removed ((PowerUpower*) proxy, parameters);
	}
}

static void
power_upower_proxy_init (PowerUpowerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_upower_dbus_interface_info));
}

static char**
power_upower_proxy_enumerate_devices (PowerUpower* self,
                                      gint* result_length1,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char** _result = NULL;
	gint _result_length1;
	GVariant* _tmp27_;
	char** _tmp28_;
	gint _tmp28__length;
	gint _tmp28__size;
	gint _tmp28__length1;
	GVariantIter _tmp29_;
	GVariant* _tmp30_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.UPower", "EnumerateDevices");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp27_ = g_variant_iter_next_value (&_reply_iter);
	_tmp28_ = g_new (char*, 5);
	_tmp28__length = 0;
	_tmp28__size = 4;
	_tmp28__length1 = 0;
	g_variant_iter_init (&_tmp29_, _tmp27_);
	for (; (_tmp30_ = g_variant_iter_next_value (&_tmp29_)) != NULL; _tmp28__length1++) {
		if (_tmp28__size == _tmp28__length) {
			_tmp28__size = 2 * _tmp28__size;
			_tmp28_ = g_renew (char*, _tmp28_, _tmp28__size + 1);
		}
		_tmp28_[_tmp28__length++] = g_variant_dup_string (_tmp30_, NULL);
		g_variant_unref (_tmp30_);
	}
	_result_length1 = _tmp28__length1;
	_tmp28_[_tmp28__length] = NULL;
	_result = _tmp28_;
	g_variant_unref (_tmp27_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gboolean
power_upower_dbus_proxy_get_on_battery (PowerUpower* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "OnBattery");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("OnBattery"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp31_ = FALSE;
			return _tmp31_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
power_upower_dbus_proxy_get_lid_is_present (PowerUpower* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LidIsPresent");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LidIsPresent"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp32_ = FALSE;
			return _tmp32_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
power_upower_dbus_proxy_get_low_on_battery (PowerUpower* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LowOnBattery");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LowOnBattery"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp33_ = FALSE;
			return _tmp33_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
power_upower_proxy_power_upower_interface_init (PowerUpowerIface* iface)
{
	iface->enumerate_devices = power_upower_proxy_enumerate_devices;
	iface->get_on_battery = power_upower_dbus_proxy_get_on_battery;
	iface->get_lid_is_present = power_upower_dbus_proxy_get_lid_is_present;
	iface->get_low_on_battery = power_upower_dbus_proxy_get_low_on_battery;
}

static void
_dbus_power_upower_enumerate_devices (PowerUpower* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char** result;
	gint result_length1 = 0;
	char** _tmp34_;
	GVariantBuilder _tmp35_;
	gint _tmp36_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = power_upower_enumerate_devices (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp34_ = result;
	g_variant_builder_init (&_tmp35_, G_VARIANT_TYPE ("ao"));
	for (_tmp36_ = 0; _tmp36_ < result_length1; _tmp36_++) {
		g_variant_builder_add_value (&_tmp35_, g_variant_new_object_path (*_tmp34_));
		_tmp34_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp35_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
power_upower_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "EnumerateDevices") == 0) {
		_dbus_power_upower_enumerate_devices (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_power_upower_get_on_battery (PowerUpower* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_upower_get_on_battery (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_get_lid_is_present (PowerUpower* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_upower_get_lid_is_present (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_get_low_on_battery (PowerUpower* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_upower_get_low_on_battery (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
power_upower_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "OnBattery") == 0) {
		return _dbus_power_upower_get_on_battery (object);
	} else if (strcmp (property_name, "LidIsPresent") == 0) {
		return _dbus_power_upower_get_lid_is_present (object);
	} else if (strcmp (property_name, "LowOnBattery") == 0) {
		return _dbus_power_upower_get_low_on_battery (object);
	}
	return NULL;
}

static gboolean
power_upower_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_power_upower_changed (GObject* _sender,
                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "Changed", _arguments, NULL);
}

static void
_dbus_power_upower_device_added (GObject* _sender,
                                 const char* device_path,
                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (device_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "DeviceAdded", _arguments, NULL);
}

static void
_dbus_power_upower_device_removed (GObject* _sender,
                                   const char* device_path,
                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (device_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "DeviceRemoved", _arguments, NULL);
}

guint
power_upower_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_upower_dbus_interface_info), &_power_upower_dbus_interface_vtable, data, _power_upower_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_power_upower_changed, data);
	g_signal_connect (object, "device-added", (GCallback) _dbus_power_upower_device_added, data);
	g_signal_connect (object, "device-removed", (GCallback) _dbus_power_upower_device_removed, data);
	return result;
}

static void
_power_upower_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_power_upower_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_power_upower_device_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_power_upower_device_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

GHashTable**
power_power_profile_get_profiles (PowerPowerProfile* self,
                                  gint* result_length1)
{
	PowerPowerProfileIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_POWER_PROFILE_GET_INTERFACE (self);
	if (_iface_->get_profiles) {
		return _iface_->get_profiles (self, result_length1);
	}
	return NULL;
}

gchar*
power_power_profile_get_active_profile (PowerPowerProfile* self)
{
	PowerPowerProfileIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_POWER_PROFILE_GET_INTERFACE (self);
	if (_iface_->get_active_profile) {
		return _iface_->get_active_profile (self);
	}
	return NULL;
}

void
power_power_profile_set_active_profile (PowerPowerProfile* self,
                                        const gchar* value)
{
	PowerPowerProfileIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POWER_POWER_PROFILE_GET_INTERFACE (self);
	if (_iface_->set_active_profile) {
		_iface_->set_active_profile (self, value);
	}
}

static void
power_power_profile_default_init (PowerPowerProfileIface * iface,
                                  gpointer iface_data)
{
}

static GType
power_power_profile_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerPowerProfileIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_power_profile_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType power_power_profile_type_id;
	power_power_profile_type_id = g_type_register_static (G_TYPE_INTERFACE, "PowerPowerProfile", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_power_profile_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_power_profile_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_power_profile_proxy_get_type);
	g_type_set_qdata (power_power_profile_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.hadess.PowerProfiles");
	g_type_set_qdata (power_power_profile_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_power_profile_dbus_interface_info));
	g_type_set_qdata (power_power_profile_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_power_profile_register_object);
	return power_power_profile_type_id;
}

GType
power_power_profile_get_type (void)
{
	static volatile gsize power_power_profile_type_id__once = 0;
	if (g_once_init_enter (&power_power_profile_type_id__once)) {
		GType power_power_profile_type_id;
		power_power_profile_type_id = power_power_profile_get_type_once ();
		g_once_init_leave (&power_power_profile_type_id__once, power_power_profile_type_id);
	}
	return power_power_profile_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PowerPowerProfileProxy, power_power_profile_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (POWER_TYPE_POWER_PROFILE, power_power_profile_proxy_power_power_profile_interface_init) )
static void
power_power_profile_proxy_class_init (PowerPowerProfileProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_power_profile_proxy_g_signal;
}

static void
power_power_profile_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
power_power_profile_proxy_init (PowerPowerProfileProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_power_profile_dbus_interface_info));
}

static GHashTable**
power_power_profile_dbus_proxy_get_profiles (PowerPowerProfile* self,
                                             gint* result_length1)
{
	GVariant *_inner_reply;
	GHashTable** _result;
	gint _result_length1;
	GHashTable** _tmp37_;
	gint _tmp37__length;
	gint _tmp37__size;
	gint _tmp37__length1;
	GVariantIter _tmp38_;
	GVariant* _tmp39_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Profiles");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.PowerProfiles"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Profiles"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp37_ = g_new (GHashTable*, 5);
	_tmp37__length = 0;
	_tmp37__size = 4;
	_tmp37__length1 = 0;
	g_variant_iter_init (&_tmp38_, _inner_reply);
	for (; (_tmp39_ = g_variant_iter_next_value (&_tmp38_)) != NULL; _tmp37__length1++) {
		GHashTable* _tmp40_;
		GVariantIter _tmp41_;
		GVariant* _tmp42_;
		GVariant* _tmp43_;
		if (_tmp37__size == _tmp37__length) {
			_tmp37__size = 2 * _tmp37__size;
			_tmp37_ = g_renew (GHashTable*, _tmp37_, _tmp37__size + 1);
		}
		_tmp40_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp41_, _tmp39_);
		while (g_variant_iter_loop (&_tmp41_, "{?*}", &_tmp42_, &_tmp43_)) {
			g_hash_table_insert (_tmp40_, g_variant_dup_string (_tmp42_, NULL), g_variant_get_variant (_tmp43_));
		}
		_tmp37_[_tmp37__length++] = _tmp40_;
		g_variant_unref (_tmp39_);
	}
	_result_length1 = _tmp37__length1;
	_tmp37_[_tmp37__length] = NULL;
	_result = _tmp37_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
power_power_profile_dbus_proxy_get_active_profile (PowerPowerProfile* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "ActiveProfile");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.PowerProfiles"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ActiveProfile"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
power_power_profile_dbus_proxy_set_active_profile (PowerPowerProfile* self,
                                                   const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.PowerProfiles"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ActiveProfile"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
power_power_profile_proxy_power_power_profile_interface_init (PowerPowerProfileIface* iface)
{
	iface->get_profiles = power_power_profile_dbus_proxy_get_profiles;
	iface->get_active_profile = power_power_profile_dbus_proxy_get_active_profile;
	iface->set_active_profile = power_power_profile_dbus_proxy_set_active_profile;
}

static void
power_power_profile_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_power_power_profile_get_profiles (PowerPowerProfile* self)
{
	GHashTable** result;
	gint result_length1 = 0;
	GVariant* _reply;
	GHashTable** _tmp44_;
	GVariantBuilder _tmp45_;
	gint _tmp46_;
	result = power_power_profile_get_profiles (self, &result_length1);
	_tmp44_ = result;
	g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp46_ = 0; _tmp46_ < result_length1; _tmp46_++) {
		GVariantBuilder _tmp47_;
		GHashTableIter _tmp48_;
		gpointer _tmp49_;
		gpointer _tmp50_;
		g_hash_table_iter_init (&_tmp48_, *_tmp44_);
		g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp48_, &_tmp49_, &_tmp50_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp49_;
			_value = (GVariant*) _tmp50_;
			g_variant_builder_add (&_tmp47_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp45_, g_variant_builder_end (&_tmp47_));
		_tmp44_++;
	}
	_reply = g_variant_builder_end (&_tmp45_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	return _reply;
}

static GVariant*
_dbus_power_power_profile_get_active_profile (PowerPowerProfile* self)
{
	gchar* result;
	GVariant* _reply;
	result = power_power_profile_get_active_profile (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
power_power_profile_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Profiles") == 0) {
		return _dbus_power_power_profile_get_profiles (object);
	} else if (strcmp (property_name, "ActiveProfile") == 0) {
		return _dbus_power_power_profile_get_active_profile (object);
	}
	return NULL;
}

static void
_dbus_power_power_profile_set_active_profile (PowerPowerProfile* self,
                                              GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	power_power_profile_set_active_profile (self, value);
	_g_free0 (value);
}

static gboolean
power_power_profile_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "ActiveProfile") == 0) {
		_dbus_power_power_profile_set_active_profile (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
power_power_profile_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_power_profile_dbus_interface_info), &_power_power_profile_dbus_interface_vtable, data, _power_power_profile_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_power_power_profile_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

