/* authenticator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from authenticator.vala, do not modify */

/* SPDX-License-Identifer: LGPL-2.1-or-later*/
/* SPDX-FileCopyrightText: 2022 Jens Georg <mail@jensge.org>*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_AUTHENTICATION_RECEIVER (authentication_receiver_get_type ())
#define AUTHENTICATION_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTHENTICATION_RECEIVER, AuthenticationReceiver))
#define IS_AUTHENTICATION_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTHENTICATION_RECEIVER))
#define AUTHENTICATION_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_AUTHENTICATION_RECEIVER, AuthenticationReceiverIface))

typedef struct _AuthenticationReceiver AuthenticationReceiver;
typedef struct _AuthenticationReceiverIface AuthenticationReceiverIface;

#define TYPE_AUTHENTICATION_RECEIVER_PROXY (authentication_receiver_proxy_get_type ())
typedef GDBusProxy AuthenticationReceiverProxy;
typedef GDBusProxyClass AuthenticationReceiverProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AuthenticationReceiverIface {
	GTypeInterface parent_iface;
	void (*callback) (AuthenticationReceiver* self, const gchar* url, GError** error);
};

VALA_EXTERN GType authentication_receiver_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint authentication_receiver_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType authentication_receiver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AuthenticationReceiver, g_object_unref)
VALA_EXTERN void authentication_receiver_callback (AuthenticationReceiver* self,
                                       const gchar* url,
                                       GError** error);
static GType authentication_receiver_get_type_once (void);
static void authentication_receiver_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters);
static void authentication_receiver_proxy_callback (AuthenticationReceiver* self,
                                             const gchar* url,
                                             GError** error);
static void authentication_receiver_proxy_authentication_receiver_interface_init (AuthenticationReceiverIface* iface);
static void _dbus_authentication_receiver_callback (AuthenticationReceiver* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void authentication_receiver_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* authentication_receiver_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static gboolean authentication_receiver_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _authentication_receiver_unregister_object (gpointer user_data);
static gint _vala_main (gchar** args,
                 gint args_length1);

static const GDBusArgInfo _authentication_receiver_dbus_arg_info_callback_url = {-1, "url", "s", NULL};
static const GDBusArgInfo * const _authentication_receiver_dbus_arg_info_callback_in[] = {&_authentication_receiver_dbus_arg_info_callback_url, NULL};
static const GDBusArgInfo * const _authentication_receiver_dbus_arg_info_callback_out[] = {NULL};
static const GDBusMethodInfo _authentication_receiver_dbus_method_info_callback = {-1, "Callback", (GDBusArgInfo **) (&_authentication_receiver_dbus_arg_info_callback_in), (GDBusArgInfo **) (&_authentication_receiver_dbus_arg_info_callback_out), NULL};
static const GDBusMethodInfo * const _authentication_receiver_dbus_method_info[] = {&_authentication_receiver_dbus_method_info_callback, NULL};
static const GDBusSignalInfo * const _authentication_receiver_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _authentication_receiver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _authentication_receiver_dbus_interface_info = {-1, "org.gnome.Shotwell.Authenticate", (GDBusMethodInfo **) (&_authentication_receiver_dbus_method_info), (GDBusSignalInfo **) (&_authentication_receiver_dbus_signal_info), (GDBusPropertyInfo **) (&_authentication_receiver_dbus_property_info), NULL};
static const GDBusInterfaceVTable _authentication_receiver_dbus_interface_vtable = {authentication_receiver_dbus_interface_method_call, authentication_receiver_dbus_interface_get_property, authentication_receiver_dbus_interface_set_property};

void
authentication_receiver_callback (AuthenticationReceiver* self,
                                  const gchar* url,
                                  GError** error)
{
	AuthenticationReceiverIface* _iface_;
	g_return_if_fail (IS_AUTHENTICATION_RECEIVER (self));
	_iface_ = AUTHENTICATION_RECEIVER_GET_INTERFACE (self);
	if (_iface_->callback) {
		_iface_->callback (self, url, error);
	}
}

static void
authentication_receiver_default_init (AuthenticationReceiverIface * iface,
                                      gpointer iface_data)
{
}

static GType
authentication_receiver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AuthenticationReceiverIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) authentication_receiver_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType authentication_receiver_type_id;
	authentication_receiver_type_id = g_type_register_static (G_TYPE_INTERFACE, "AuthenticationReceiver", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (authentication_receiver_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) authentication_receiver_proxy_get_type);
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Shotwell.Authenticate");
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_authentication_receiver_dbus_interface_info));
	g_type_set_qdata (authentication_receiver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) authentication_receiver_register_object);
	return authentication_receiver_type_id;
}

GType
authentication_receiver_get_type (void)
{
	static volatile gsize authentication_receiver_type_id__once = 0;
	if (g_once_init_enter (&authentication_receiver_type_id__once)) {
		GType authentication_receiver_type_id;
		authentication_receiver_type_id = authentication_receiver_get_type_once ();
		g_once_init_leave (&authentication_receiver_type_id__once, authentication_receiver_type_id);
	}
	return authentication_receiver_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AuthenticationReceiverProxy, authentication_receiver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_AUTHENTICATION_RECEIVER, authentication_receiver_proxy_authentication_receiver_interface_init) )
static void
authentication_receiver_proxy_class_init (AuthenticationReceiverProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = authentication_receiver_proxy_g_signal;
}

static void
authentication_receiver_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters)
{
}

static void
authentication_receiver_proxy_init (AuthenticationReceiverProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_authentication_receiver_dbus_interface_info));
}

static void
authentication_receiver_proxy_callback (AuthenticationReceiver* self,
                                        const gchar* url,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Shotwell.Authenticate", "Callback");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
authentication_receiver_proxy_authentication_receiver_interface_init (AuthenticationReceiverIface* iface)
{
	iface->callback = authentication_receiver_proxy_callback;
}

static void
_dbus_authentication_receiver_callback (AuthenticationReceiver* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	authentication_receiver_callback (self, url, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (url);
	;
}

static void
authentication_receiver_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Callback") == 0) {
		_dbus_authentication_receiver_callback (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
authentication_receiver_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
authentication_receiver_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
authentication_receiver_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_authentication_receiver_dbus_interface_info), &_authentication_receiver_dbus_interface_vtable, data, _authentication_receiver_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_authentication_receiver_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	AuthenticationReceiver* receiver = NULL;
	GError* _inner_error0_ = NULL;
	gint result;
	if (args_length1 != 2) {
		const gchar* _tmp0_;
		_tmp0_ = args[0];
		g_print ("Usage: %s <callback-uri>\n", _tmp0_);
		result = 1;
		_g_object_unref0 (receiver);
		return result;
	}
	{
		GUri* uri = NULL;
		const gchar* _tmp1_;
		GUri* _tmp2_;
		gchar* scheme = NULL;
		GUri* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp1_ = args[1];
		_tmp2_ = g_uri_parse (_tmp1_, G_URI_FLAGS_NONE, &_inner_error0_);
		uri = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = uri;
		_tmp4_ = g_uri_get_scheme (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		scheme = _tmp5_;
		_tmp7_ = scheme;
		if (g_strcmp0 (_tmp7_, "shotwell-oauth2") != 0) {
			const gchar* _tmp8_;
			_tmp8_ = scheme;
			_tmp6_ = !g_str_has_prefix (_tmp8_, "com.googleusercontent.apps");
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const gchar* _tmp9_;
			_tmp9_ = args[1];
			g_critical ("authenticator.vala:22: Invalid scheme in callback URI \"%s\"", _tmp9_);
			result = 1;
			_g_free0 (scheme);
			_g_uri_unref0 (uri);
			_g_object_unref0 (receiver);
			return result;
		}
		_g_free0 (scheme);
		_g_uri_unref0 (uri);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = args[1];
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("authenticator.vala:26: Invalid uri: \"%s\": %s", _tmp10_, _tmp12_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (receiver);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp13_ = -1;
		_g_object_unref0 (receiver);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	{
		AuthenticationReceiver* _tmp14_ = NULL;
		AuthenticationReceiver* _tmp15_;
		AuthenticationReceiver* _tmp16_;
		AuthenticationReceiver* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = (AuthenticationReceiver*) g_initable_new (TYPE_AUTHENTICATION_RECEIVER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.Shotwell", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Shotwell", "g-interface-name", "org.gnome.Shotwell.Authenticate", NULL);
		_tmp14_ = (AuthenticationReceiver*) _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp16_ = _tmp14_;
		_tmp14_ = NULL;
		_g_object_unref0 (receiver);
		receiver = _tmp16_;
		_tmp17_ = receiver;
		_tmp18_ = args[1];
		authentication_receiver_callback (_tmp17_, _tmp18_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp14_);
			goto __catch1_g_error;
		}
		_g_object_unref0 (_tmp14_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("authenticator.vala:34: Could not connect to remote shotwell instance: " \
"%s", _tmp20_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (receiver);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp21_ = -1;
		_g_object_unref0 (receiver);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	result = 0;
	_g_object_unref0 (receiver);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

