/* Do not edit this file. It is produced from the corresponding .m4 source */
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* "$Id$" */

#ifndef _NCX_H
#define _NCX_H

#include <stddef.h>    /* size_t */
#include <sys/types.h> /* off_t */
#include <errno.h>

#include <mpi.h>

#include <common.h>

/*
 * An external data representation interface.
 *
 * This started out as a general replacement for ONC XDR,
 * specifically, the xdrmem family of functions.
 *
 * We eventually realized that we could write more portable
 * code if we decoupled any association between the 'C' types
 * and the external types. (XDR has this association between the 'C'
 * types and the external representations, like xdr_int() takes
 * an int argument and goes to an external int representation.)
 * So, now there is a matrix of functions.
 *
 */

#if defined(_CRAY) && !defined(_CRAYIEEE) && !defined(__crayx1)
#define CRAYFLOAT 1 /* CRAY Floating point */
#elif defined(_SX) && defined(_FLOAT2) /* NEC SUPER-UX in CRAY mode */
#define CRAYFLOAT 1 /* CRAY Floating point */
#endif

/*
 * External sizes of the primitive elements.
 */
#define X_SIZEOF_BYTE		1
#define X_SIZEOF_CHAR		1
#define X_SIZEOF_SHORT		2
#define X_SIZEOF_INT		4	/* xdr_int */
#if 0
#define X_SIZEOF_LONG		8 */	/* xdr_long_long */
#endif
#define X_SIZEOF_FLOAT		4
#define X_SIZEOF_DOUBLE		8

/* additional data types in CDF-5 */
#define X_SIZEOF_UBYTE		1
#define X_SIZEOF_USHORT		2
#define X_SIZEOF_UINT		4
#define X_SIZEOF_LONGLONG	8
#define X_SIZEOF_ULONGLONG	8
#define X_SIZEOF_INT64		8
#define X_SIZEOF_UINT64		8

/*
 * For now, netcdf is limited to 32 bit sizes,
 * If compiled with support for "large files", then
 * netcdf will use a 64 bit off_t and it can then write a file
 * using 64 bit offsets.
 *  see also X_SIZE_T_MAX, X_OFF_MAX below
 */
/* #define X_SIZEOF_OFF_T	(sizeof(off_t)) */
#define X_SIZEOF_OFF_T		SIZEOF_OFF_T
#define X_SIZEOF_SIZE_T		X_SIZEOF_INT

/*
 * limits of the external representation
 */
#define X_SCHAR_MIN	(-128)
#define X_SCHAR_MAX	127
#define X_UCHAR_MAX	255U
#define X_SHORT_MIN	(-32768)
#define X_SHRT_MIN	X_SHORT_MIN	/* alias compatible with limits.h */
#define X_SHORT_MAX	32767
#define X_SHRT_MAX	X_SHORT_MAX	/* alias compatible with limits.h */
#define X_USHORT_MAX	65535U
#define X_USHRT_MAX	X_USHORT_MAX	/* alias compatible with limits.h */
#define X_INT_MIN	(-2147483647-1)
#define X_INT_MAX	2147483647
#define X_UINT_MAX	4294967295U
#define X_INT64_MIN	(-9223372036854775807LL-1LL)
#define X_INT64_MAX	9223372036854775807LL
#define X_UINT64_MAX	18446744073709551615ULL
#define X_FLOAT_MAX	3.402823466e+38f
#define X_FLOAT_MIN	(-X_FLOAT_MAX)
#define X_FLT_MAX	X_FLOAT_MAX	/* alias compatible with limits.h */
#if defined(CRAYFLOAT) && CRAYFLOAT != 0
/* ldexp(1. - ldexp(.5 , -46), 1024) */
#define X_DOUBLE_MAX	1.79769313486230e+308
#else
/* scalb(1. - scalb(.5 , -52), 1024) */
#define X_DOUBLE_MAX	1.7976931348623157e+308
#endif
#define X_DOUBLE_MIN	(-X_DOUBLE_MAX)
#define X_DBL_MAX	X_DOUBLE_MAX	/* alias compatible with limits.h */

#define X_SIZE_T_MAX	X_UINT_MAX
#define X_OFF_MAX	X_INT_MAX


/* Begin ncmpix_len */

/*
 * ncmpix_len_xxx() interfaces are defined as macros below,
 * These give the length of an array of nelems of the type.
 * N.B. The 'char' and 'short' interfaces give the X_ALIGNED length.
 */
#define X_ALIGN		4	/* a.k.a. BYTES_PER_XDR_UNIT */

#define ncmpix_len_char(nelems) \
	_RNDUP((nelems), X_ALIGN)

#define ncmpix_len_short(nelems) \
	(((nelems) + (nelems)%2)  * X_SIZEOF_SHORT)

#define ncmpix_len_int(nelems) \
	((nelems) * X_SIZEOF_INT)

#define ncmpix_len_long(nelems) \
	((nelems) * X_SIZEOF_LONG)

#define ncmpix_len_float(nelems) \
	((nelems) * X_SIZEOF_FLOAT)

#define ncmpix_len_double(nelems) \
	((nelems) * X_SIZEOF_DOUBLE)

#define ncmpix_len_ubyte(nelems) \
	_RNDUP((nelems), X_ALIGN)

#define ncmpix_len_ushort(nelems) \
	(((nelems) + (nelems)%2)  * X_SIZEOF_USHORT)

#define ncmpix_len_uint(nelems) \
	((nelems) * X_SIZEOF_UINT)

#define ncmpix_len_int64(nelems) \
	((nelems) * X_SIZEOF_INT64)

#define ncmpix_len_uint64(nelems) \
	((nelems) * X_SIZEOF_UINT64)

/* End ncmpix_len */

/*
 * Primitive numeric conversion functions.
 * The `put' functions convert from native internal
 * type to the external type, while the `get' functions
 * convert from the external to the internal.
 *
 * These take the form
 *	int ncmpix_get_{external_type}_{internal_type}(
 *		const void *xp,
 *		internal_type *ip
 *	);
 *	int ncmpix_put_{external_type}_{internal_type}(
 *		void *xp,
 *		const internal_type *ip
 *	);
 * where
 *	`external_type' chosen from
 *      	NC_CHAR
 *      	NC_BYTE
 *      	NC_SHORT
 *      	NC_INT
 *      	NC_FLOAT
 *      	NC_DOUBLE
 *      	NC_UBYTE
 *      	NC_USHORT
 *      	NC_UINT
 *      	NC_INT64
 *      	NC_UINT64
 *
 *	`internal_type' chosen from
 *      	schar
 *      	uchar
 *      	short
 *      	int
 *      	long
 *      	float
 *      	double
 *      	ushort
 *      	uint
 *      	longlong
 *      	ulonglong
 *
 * Not all combinations make sense, i.e. those causing NC_ECHAR.
 * We may not implement all combinations that make sense.
 * The netcdf functions that use this ncmpix interface do not
 * use these primitive conversion functions. They use the
 * aggregate conversion functions declared below.
 *
 * Storage for a single element of external type is at the `void * xp'
 * argument.
 *
 * Storage for a single element of internal type is at `ip' argument.
 *
 * These functions return NC_NOERR when no error occurred,
 * or NC_ERANGE when the value being converted is too large.
 * When NC_ERANGE occurs, an undefined (implementation dependent)
 * conversion may have occurred.
 *
 * Note that loss of precision may occur silently.
 *
 */

/*
 * Other primitive conversion functions
 * N.B. slightly different interface
 * Used by netcdf.
 */

/* ncmpix_get_int_size_t */
extern int
ncmpix_get_size_t(const void **xpp, size_t *ulp);
/* ncmpix_get_int_off_t */
extern int
ncmpix_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t);

/* ncmpix_put_int_size_t */
extern int
ncmpix_put_size_t(void **xpp, const size_t *ulp);
/* ncmpix_put_int_off_t */
extern int
ncmpix_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t);

extern int
ncmpix_get_uint32(const void **xpp, unsigned int *ip);
extern int
ncmpix_get_uint64(const void **xpp, unsigned long long *ip);
extern int
ncmpix_put_uint32(void **xpp, const unsigned int ip);
extern int
ncmpix_put_uint64(void **xpp, const unsigned long long ip);

extern int
ncmpix_getn_uint32(const void **xpp, unsigned int *ip, int nelems);
extern int
ncmpix_getn_uint64(const void **xpp, unsigned long long *ip, int nelems);
extern int
ncmpix_putn_uint32(void **xpp, const unsigned int *ip, int nelems);
extern int
ncmpix_putn_uint64(void **xpp, const unsigned long long *ip, int nelems);


/*
 * Aggregate numeric conversion functions.
 * Convert an array.  Replaces xdr_array(...).
 * These functions are used by netcdf. Unlike the xdr
 * interface, we optimize for aggregate conversions.
 * This functions should be implemented to take advantage
 * of multiple processor / parallel hardware where available.
 *
 * These take the form
 *	int ncmpix_getn_{external_type}_{internal_type}(
 *		const void *xpp,
 *		size_t nelems,
 *		internal_type *ip
 *	);
 *	int ncmpix_putn_{external_type}_{internal_type}(
 *		void **xpp,
 *		size_t nelems,
 *		const internal_type *ip
 *	);
 * Where the types are as in the primitive numeric conversion functions.
 *
 * The value of the pointer to pointer argument, *xpp, is
 * expected to reference storage for `nelems' of the external
 * type.  On return, it modified to reference just past the last
 * converted external element.
 *
 * The types whose external size is less than X_ALIGN also have `pad'
 * interfaces. These round (and zero fill on put) *xpp up to X_ALIGN
 * boundaries. (This is the usual xdr behavior.)
 *
 * The `ip' argument should point to an array of `nelems' of
 * internal_type.
 *
 * Range errors (NC_ERANGE) for a individual values in the array
 * DO NOT terminate the array conversion. All elements are converted,
 * with some having undefined values.
 * If any range error occurs, the function returns NC_ERANGE.
 *
 */



/*---- NC_BYTE ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_BYTE_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_BYTE_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_BYTE_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_BYTE_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_BYTE_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_BYTE_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_BYTE_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_BYTE_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_BYTE_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_BYTE_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_BYTE_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_pad_getn_NC_BYTE_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_pad_getn_NC_BYTE_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_pad_getn_NC_BYTE_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_pad_getn_NC_BYTE_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_pad_getn_NC_BYTE_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_pad_getn_NC_BYTE_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_pad_getn_NC_BYTE_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_pad_getn_NC_BYTE_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_pad_getn_NC_BYTE_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_pad_getn_NC_BYTE_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_pad_getn_NC_BYTE_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_BYTE_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_BYTE_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

extern int
ncmpix_pad_putn_NC_BYTE_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_BYTE_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_UBYTE ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_UBYTE_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_UBYTE_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_UBYTE_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_UBYTE_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_UBYTE_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_UBYTE_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_UBYTE_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_UBYTE_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_UBYTE_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_UBYTE_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_UBYTE_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_pad_getn_NC_UBYTE_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_pad_getn_NC_UBYTE_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_UBYTE_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_UBYTE_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

extern int
ncmpix_pad_putn_NC_UBYTE_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_UBYTE_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_SHORT ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_SHORT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_SHORT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_SHORT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_SHORT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_SHORT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_SHORT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_SHORT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_SHORT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_SHORT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_SHORT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_SHORT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_pad_getn_NC_SHORT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_pad_getn_NC_SHORT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_pad_getn_NC_SHORT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_pad_getn_NC_SHORT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_pad_getn_NC_SHORT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_pad_getn_NC_SHORT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_pad_getn_NC_SHORT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_pad_getn_NC_SHORT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_pad_getn_NC_SHORT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_pad_getn_NC_SHORT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_pad_getn_NC_SHORT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_SHORT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_SHORT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

extern int
ncmpix_pad_putn_NC_SHORT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_SHORT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_USHORT ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_USHORT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_USHORT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_USHORT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_USHORT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_USHORT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_USHORT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_USHORT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_USHORT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_USHORT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_USHORT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_USHORT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_pad_getn_NC_USHORT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_pad_getn_NC_USHORT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_pad_getn_NC_USHORT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_pad_getn_NC_USHORT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_pad_getn_NC_USHORT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_pad_getn_NC_USHORT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_pad_getn_NC_USHORT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_pad_getn_NC_USHORT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_pad_getn_NC_USHORT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_pad_getn_NC_USHORT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_pad_getn_NC_USHORT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_USHORT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_USHORT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

extern int
ncmpix_pad_putn_NC_USHORT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_pad_putn_NC_USHORT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);


/*---- NC_INT ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_INT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_INT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_INT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_INT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_INT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_INT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_INT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_INT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_INT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_INT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_INT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_INT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_INT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_UINT ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_UINT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_UINT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_UINT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_UINT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_UINT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_UINT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_UINT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_UINT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_UINT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_UINT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_UINT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_UINT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_FLOAT ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_FLOAT_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_FLOAT_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_FLOAT_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_FLOAT_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_FLOAT_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_FLOAT_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_FLOAT_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_FLOAT_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_FLOAT_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_FLOAT_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_FLOAT_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_FLOAT_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_FLOAT_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_DOUBLE ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_DOUBLE_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_DOUBLE_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_DOUBLE_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_DOUBLE_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_DOUBLE_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_DOUBLE_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_DOUBLE_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_DOUBLE_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_DOUBLE_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_DOUBLE_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_DOUBLE_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_DOUBLE_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_DOUBLE_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_INT64 ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_INT64_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_INT64_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_INT64_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_INT64_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_INT64_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_INT64_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_INT64_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_INT64_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_INT64_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_INT64_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_INT64_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_INT64_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_INT64_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);

/*---- NC_UINT64 ----------------------------------------------------------------*/
extern int
ncmpix_getn_NC_UINT64_schar(const void **xpp, MPI_Offset nelems, schar *ip);
extern int
ncmpix_getn_NC_UINT64_uchar(const void **xpp, MPI_Offset nelems, uchar *ip);
extern int
ncmpix_getn_NC_UINT64_short(const void **xpp, MPI_Offset nelems, short *ip);
extern int
ncmpix_getn_NC_UINT64_ushort(const void **xpp, MPI_Offset nelems, ushort *ip);
extern int
ncmpix_getn_NC_UINT64_int(const void **xpp, MPI_Offset nelems, int *ip);
extern int
ncmpix_getn_NC_UINT64_uint(const void **xpp, MPI_Offset nelems, uint *ip);
extern int
ncmpix_getn_NC_UINT64_long(const void **xpp, MPI_Offset nelems, long *ip);
extern int
ncmpix_getn_NC_UINT64_float(const void **xpp, MPI_Offset nelems, float *ip);
extern int
ncmpix_getn_NC_UINT64_double(const void **xpp, MPI_Offset nelems, double *ip);
extern int
ncmpix_getn_NC_UINT64_longlong(const void **xpp, MPI_Offset nelems, longlong *ip);
extern int
ncmpix_getn_NC_UINT64_ulonglong(const void **xpp, MPI_Offset nelems, ulonglong *ip);

extern int
ncmpix_putn_NC_UINT64_schar(void **xpp, MPI_Offset nelems, const schar *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_uchar(void **xpp, MPI_Offset nelems, const uchar *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_short(void **xpp, MPI_Offset nelems, const short *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_ushort(void **xpp, MPI_Offset nelems, const ushort *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_int(void **xpp, MPI_Offset nelems, const int *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_uint(void **xpp, MPI_Offset nelems, const uint *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_long(void **xpp, MPI_Offset nelems, const long *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_float(void **xpp, MPI_Offset nelems, const float *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_double(void **xpp, MPI_Offset nelems, const double *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_longlong(void **xpp, MPI_Offset nelems, const longlong *ip, void *fillp);
extern int
ncmpix_putn_NC_UINT64_ulonglong(void **xpp, MPI_Offset nelems, const ulonglong *ip, void *fillp);


/*
 * Other aggregate conversion functions.
 */

/* read ASCII characters */
extern int
ncmpix_getn_text(const void **xpp, MPI_Offset nchars, char *cp);
extern int
ncmpix_pad_getn_text(const void **xpp, MPI_Offset nchars, char *cp);

/* write ASCII characters */
extern int
ncmpix_putn_text(void **xpp, MPI_Offset nchars, const char *cp);
extern int
ncmpix_pad_putn_text(void **xpp, MPI_Offset nchars, const char *cp);

/* for symmetry */
#define ncmpix_getn_char_char(xpp, nelems, fillp) ncmpix_getn_text(xpp, nelems, fillp)
#define ncmpix_putn_char_char(xpp, nelems, fillp) ncmpix_putn_text(xpp, nelems, fillp)

/* read opaque data */
extern int
ncmpix_getn_void(const void **xpp, MPI_Offset nchars, void *vp);
extern int
ncmpix_pad_getn_void(const void **xpp, MPI_Offset nchars, void *vp);

/* write opaque data */
extern int
ncmpix_putn_void(void **xpp, MPI_Offset nchars, const void *vp);
extern int
ncmpix_pad_putn_void(void **xpp, MPI_Offset nchars, const void *vp);

#endif /* _NCX_H_ */
