// python wrapper for vtkSciVizStatistics
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSciVizStatistics.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSciVizStatistics(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSciVizStatistics_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSciVizStatistics_Tasks_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersStatistics.vtkSciVizStatistics.Tasks", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSciVizStatistics_Tasks_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSciVizStatistics_Tasks_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSciVizStatistics_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSciVizStatistics::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSciVizStatistics::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSciVizStatistics *tempr = vtkSciVizStatistics::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSciVizStatistics *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSciVizStatistics::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSciVizStatistics::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSciVizStatistics::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetAttributeMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAttributeMode() :
      op->vtkSciVizStatistics::GetAttributeMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_SetAttributeMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAttributeMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAttributeMode(temp0);
    }
    else
    {
      op->vtkSciVizStatistics::SetAttributeMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetNumberOfAttributeArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfAttributeArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfAttributeArrays() :
      op->vtkSciVizStatistics::GetNumberOfAttributeArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetAttributeArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetAttributeArrayName(temp0) :
      op->vtkSciVizStatistics::GetAttributeArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetAttributeArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAttributeArrayStatus(temp0) :
      op->vtkSciVizStatistics::GetAttributeArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_EnableAttributeArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableAttributeArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->EnableAttributeArray(temp0);
    }
    else
    {
      op->vtkSciVizStatistics::EnableAttributeArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_ClearAttributeArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearAttributeArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearAttributeArrays();
    }
    else
    {
      op->vtkSciVizStatistics::ClearAttributeArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_SetTrainingFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTrainingFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTrainingFraction(temp0);
    }
    else
    {
      op->vtkSciVizStatistics::SetTrainingFraction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetTrainingFractionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrainingFractionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTrainingFractionMinValue() :
      op->vtkSciVizStatistics::GetTrainingFractionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetTrainingFractionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrainingFractionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTrainingFractionMaxValue() :
      op->vtkSciVizStatistics::GetTrainingFractionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetTrainingFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTrainingFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTrainingFraction() :
      op->vtkSciVizStatistics::GetTrainingFraction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkSciVizStatistics::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkSciVizStatistics::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_SetTask(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTask");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTask(temp0);
    }
    else
    {
      op->vtkSciVizStatistics::SetTask(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_GetTask(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTask");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTask() :
      op->vtkSciVizStatistics::GetTask());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSciVizStatistics_MULTIPLE_MODELS(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MULTIPLE_MODELS");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSciVizStatistics *op = static_cast<vtkSciVizStatistics *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = (ap.IsBound() ?
      op->MULTIPLE_MODELS() :
      op->vtkSciVizStatistics::MULTIPLE_MODELS());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSciVizStatistics_Methods[] = {
  {"IsTypeOf", PyvtkSciVizStatistics_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSciVizStatistics_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSciVizStatistics_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSciVizStatistics\nC++: static vtkSciVizStatistics *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSciVizStatistics_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSciVizStatistics\nC++: vtkSciVizStatistics *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSciVizStatistics_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSciVizStatistics_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetAttributeMode", PyvtkSciVizStatistics_GetAttributeMode, METH_VARARGS,
   "GetAttributeMode(self) -> int\nC++: virtual int GetAttributeMode()\n\nSet/get the type of field attribute (cell, point, field)\n"},
  {"SetAttributeMode", PyvtkSciVizStatistics_SetAttributeMode, METH_VARARGS,
   "SetAttributeMode(self, _arg:int) -> None\nC++: virtual void SetAttributeMode(int _arg)\n\n"},
  {"GetNumberOfAttributeArrays", PyvtkSciVizStatistics_GetNumberOfAttributeArrays, METH_VARARGS,
   "GetNumberOfAttributeArrays(self) -> int\nC++: int GetNumberOfAttributeArrays()\n\nReturn the number of columns available for the current value of\nAttributeMode.\n"},
  {"GetAttributeArrayName", PyvtkSciVizStatistics_GetAttributeArrayName, METH_VARARGS,
   "GetAttributeArrayName(self, n:int) -> str\nC++: const char *GetAttributeArrayName(int n)\n\nGet the name of the n-th array ffor the current value of\nAttributeMode.\n"},
  {"GetAttributeArrayStatus", PyvtkSciVizStatistics_GetAttributeArrayStatus, METH_VARARGS,
   "GetAttributeArrayStatus(self, arrName:str) -> int\nC++: int GetAttributeArrayStatus(const char *arrName)\n\nGet the status of the specified array (i.e., whether or not it is\na column of interest).\n"},
  {"EnableAttributeArray", PyvtkSciVizStatistics_EnableAttributeArray, METH_VARARGS,
   "EnableAttributeArray(self, arrName:str) -> None\nC++: void EnableAttributeArray(const char *arrName)\n\nAn alternate interface for preparing a selection of arrays in\nParaView.\n"},
  {"ClearAttributeArrays", PyvtkSciVizStatistics_ClearAttributeArrays, METH_VARARGS,
   "ClearAttributeArrays(self) -> None\nC++: void ClearAttributeArrays()\n\n"},
  {"SetTrainingFraction", PyvtkSciVizStatistics_SetTrainingFraction, METH_VARARGS,
   "SetTrainingFraction(self, _arg:float) -> None\nC++: virtual void SetTrainingFraction(double _arg)\n\nSet/get the amount of data to be used for training. When 0.0 <\nTrainingFraction < 1.0, a randomly-sampled subset of the data is\nused for training.\n* When an assessment is requested, all data (including the\n  training data) is assessed,\n* regardless of the value of TrainingFraction.\n* The default value is 0.1.\n\n* The random sample of the original dataset (say, of size N) is\n  obtained by choosing N random numbers in [0,1).\n* Any sample where the random number is less than\n  TrainingFraction is included in the training data.\n* Samples are then randomly added or removed from the training\n  data until it is the desired size.\n"},
  {"GetTrainingFractionMinValue", PyvtkSciVizStatistics_GetTrainingFractionMinValue, METH_VARARGS,
   "GetTrainingFractionMinValue(self) -> float\nC++: virtual double GetTrainingFractionMinValue()\n\n"},
  {"GetTrainingFractionMaxValue", PyvtkSciVizStatistics_GetTrainingFractionMaxValue, METH_VARARGS,
   "GetTrainingFractionMaxValue(self) -> float\nC++: virtual double GetTrainingFractionMaxValue()\n\n"},
  {"GetTrainingFraction", PyvtkSciVizStatistics_GetTrainingFraction, METH_VARARGS,
   "GetTrainingFraction(self) -> float\nC++: virtual double GetTrainingFraction()\n\n"},
  {"SetController", PyvtkSciVizStatistics_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nGet/Set the multiprocess controller. If no controller is set,\nsingle process is assumed.\n"},
  {"GetController", PyvtkSciVizStatistics_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetTask", PyvtkSciVizStatistics_SetTask, METH_VARARGS,
   "SetTask(self, _arg:int) -> None\nC++: virtual void SetTask(int _arg)\n\nSet/get whether this filter should create a model of the input or\nassess the input or both. This should take on a value from the\nTasks enum. The default is MODEL_AND_ASSESS.\n"},
  {"GetTask", PyvtkSciVizStatistics_GetTask, METH_VARARGS,
   "GetTask(self) -> int\nC++: virtual int GetTask()\n\n"},
  {"MULTIPLE_MODELS", PyvtkSciVizStatistics_MULTIPLE_MODELS, METH_VARARGS,
   "MULTIPLE_MODELS(self) -> vtkInformationIntegerKey\nC++: vtkInformationIntegerKey *MULTIPLE_MODELS()\n\nA key used to mark the output model data object (output port 0)\nwhen it is a multiblock of models (any of which may be multiblock\ndataset themselves) as opposed to a multiblock dataset containing\na single model.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSciVizStatistics_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("attribute_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSciVizStatistics_GetAttributeMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSciVizStatistics_SetAttributeMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSciVizStatistics_SetAttributeMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAttributeMode/SetAttributeMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("training_fraction"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSciVizStatistics_GetTrainingFraction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSciVizStatistics_SetTrainingFraction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSciVizStatistics_SetTrainingFraction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTrainingFraction/SetTrainingFraction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSciVizStatistics_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSciVizStatistics_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSciVizStatistics_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("task"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSciVizStatistics_GetTask(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSciVizStatistics_SetTask(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSciVizStatistics_SetTask(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTask/SetTask\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_attribute_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSciVizStatistics_GetNumberOfAttributeArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfAttributeArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSciVizStatistics_Doc =
  "vtkSciVizStatistics - Abstract base class for computing statistics\nwith vtkStatistics\n\n"
  "Superclass: vtkTableAlgorithm\n\n"
  "This filter either computes a statistical model of a dataset or takes\n"
  "such a model as its second input. Then, the model (however it is\n"
  "obtained) may optionally be used to assess the input dataset.\n\n"
  "This class serves as a base class that handles table conversion,\n"
  "interfacing with the array selection in the ParaView user interface,\n"
  "and provides a simplified interface to vtkStatisticsAlgorithm.@par\n"
  "Thanks: Thanks to David Thompson and Philippe Pebay from Sandia\n"
  "National Laboratories for implementing this class. Updated by\n"
  "Philippe Pebay, Kitware SAS 2012\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSciVizStatistics_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersStatistics.vtkSciVizStatistics", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSciVizStatistics_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkSciVizStatistics_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSciVizStatistics_Type, PyvtkSciVizStatistics_Methods,
    "vtkSciVizStatistics",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTableAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSciVizStatistics_Tasks_Type);
  PyVTKEnum_Add(&PyvtkSciVizStatistics_Tasks_Type, "vtkSciVizStatistics.Tasks");

  o = (PyObject *)&PyvtkSciVizStatistics_Tasks_Type;
  if (PyDict_SetItemString(d, "Tasks", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 4; c++)
  {
    typedef vtkSciVizStatistics::Tasks cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[4] = {
        { "MODEL_INPUT", vtkSciVizStatistics::MODEL_INPUT },
        { "CREATE_MODEL", vtkSciVizStatistics::CREATE_MODEL },
        { "ASSESS_INPUT", vtkSciVizStatistics::ASSESS_INPUT },
        { "MODEL_AND_ASSESS", vtkSciVizStatistics::MODEL_AND_ASSESS },
      };

    o = PyvtkSciVizStatistics_Tasks_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSciVizStatistics_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSciVizStatistics(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSciVizStatistics_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSciVizStatistics", o) != 0)
  {
    Py_DECREF(o);
  }

}

