/* SourceCollection.c generated by valac 0.56.18, the Vala compiler
 * generated from SourceCollection.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SOURCE_COLLECTION_TYPE_DESTROY_COUNTER (source_collection_destroy_counter_get_type ())
#define SOURCE_COLLECTION_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter))
#define SOURCE_COLLECTION_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_DESTROY_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))

typedef struct _SourceCollectionDestroyCounter SourceCollectionDestroyCounter;
typedef struct _SourceCollectionDestroyCounterClass SourceCollectionDestroyCounterClass;
typedef struct _SourceCollectionDestroyCounterPrivate SourceCollectionDestroyCounterPrivate;
enum  {
	SOURCE_COLLECTION_DESTROY_COUNTER_0_PROPERTY,
	SOURCE_COLLECTION_DESTROY_COUNTER_NUM_PROPERTIES
};
static GParamSpec* source_collection_destroy_counter_properties[SOURCE_COLLECTION_DESTROY_COUNTER_NUM_PROPERTIES];
enum  {
	SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL,
	SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL,
	SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL,
	SOURCE_COLLECTION_NUM_SIGNALS
};
static guint source_collection_signals[SOURCE_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SourceCollectionPrivate {
	GeeMultiMap* backlinks;
};

struct _SourceCollectionDestroyCounter {
	GObject parent_instance;
	SourceCollectionDestroyCounterPrivate * priv;
	Marker* remove_marker;
	GeeArrayList* notify_list;
	GeeArrayList* not_removed;
};

struct _SourceCollectionDestroyCounterClass {
	GObjectClass parent_class;
};

static gint SourceCollection_private_offset;
static gpointer source_collection_parent_class = NULL;
static gpointer source_collection_destroy_counter_parent_class = NULL;

static gboolean source_collection_real_holds_type_of_source (SourceCollection* self,
                                                      DataSource* source);
static void source_collection_real_notify_items_unlinking (SourceCollection* self,
                                                    GeeCollection* unlinking);
static void source_collection_real_notify_items_relinked (SourceCollection* self,
                                                   GeeCollection* relinked);
static void source_collection_real_notify_item_destroyed (SourceCollection* self,
                                                   DataSource* source);
static void source_collection_real_notify_items_destroyed (SourceCollection* self,
                                                    GeeCollection* destroyed);
static void source_collection_real_notify_unlinked_destroyed (SourceCollection* self,
                                                       DataSource* unlinked);
static void source_collection_real_notify_backlink_removed (SourceCollection* self,
                                                     SourceBacklink* backlink,
                                                     GeeCollection* sources);
static gboolean source_collection_real_valid_type (DataCollection* base,
                                            DataObject* object);
static GType source_collection_destroy_counter_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SourceCollectionDestroyCounter* source_collection_destroy_counter_new (Marker* remove_marker);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_construct (GType object_type,
                                                                             Marker* remove_marker);
static gboolean source_collection_destroy_and_delete_source (SourceCollection* self,
                                                      DataObject* object,
                                                      GObject* user);
static gboolean _source_collection_destroy_and_delete_source_marked_action (DataObject* object,
                                                                     GObject* user,
                                                                     gpointer self);
static gboolean source_collection_destroy_source (SourceCollection* self,
                                           DataObject* object,
                                           GObject* user);
static gboolean _source_collection_destroy_source_marked_action (DataObject* object,
                                                          GObject* user,
                                                          gpointer self);
static guint _source_backlink_hash_func_gee_hash_data_func (gconstpointer v,
                                                     gpointer self);
static gboolean _source_backlink_equal_func_gee_equal_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self);
static gboolean source_collection_real_has_backlink (SourceCollection* self,
                                              SourceBacklink* backlink);
static gboolean source_collection_prepare_for_unlink (SourceCollection* self,
                                               DataObject* object,
                                               GObject* user);
static gboolean _source_collection_prepare_for_unlink_marked_action (DataObject* object,
                                                              GObject* user,
                                                              gpointer self);
static void source_collection_real_remove_backlink (SourceCollection* self,
                                             SourceBacklink* backlink);
static void source_collection_real_items_unlinking (SourceCollection* self,
                                             GeeCollection* unlinking);
static void source_collection_real_items_relinked (SourceCollection* self,
                                            GeeCollection* relinked);
static void source_collection_real_item_destroyed (SourceCollection* self,
                                            DataSource* source);
static void source_collection_real_items_destroyed (SourceCollection* self,
                                             GeeCollection* destroyed);
static void source_collection_real_unlinked_destroyed (SourceCollection* self,
                                                DataSource* source);
static void source_collection_real_backlink_removed (SourceCollection* self,
                                              SourceBacklink* backlink,
                                              GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void source_collection_destroy_counter_finalize (GObject * obj);
static GType source_collection_destroy_counter_get_type_once (void);
static void source_collection_finalize (DataCollection * obj);
static GType source_collection_get_type_once (void);

static inline gpointer
source_collection_get_instance_private (SourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, SourceCollection_private_offset);
}

SourceCollection*
source_collection_construct (GType object_type,
                             const gchar* name)
{
	SourceCollection* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SourceCollection*) data_collection_construct (object_type, name);
	return self;
}

static gboolean
source_collection_real_holds_type_of_source (SourceCollection* self,
                                             DataSource* source)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `source_collection_holds_type_of_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
source_collection_holds_type_of_source (SourceCollection* self,
                                        DataSource* source)
{
	SourceCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->holds_type_of_source) {
		return _klass_->holds_type_of_source (self, source);
	}
	return FALSE;
}

static void
source_collection_real_notify_items_unlinking (SourceCollection* self,
                                               GeeCollection* unlinking)
{
	g_return_if_fail (unlinking != NULL);
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL], 0, unlinking);
}

void
source_collection_notify_items_unlinking (SourceCollection* self,
                                          GeeCollection* unlinking)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_unlinking) {
		_klass_->notify_items_unlinking (self, unlinking);
	}
}

static void
source_collection_real_notify_items_relinked (SourceCollection* self,
                                              GeeCollection* relinked)
{
	g_return_if_fail (relinked != NULL);
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL], 0, relinked);
}

void
source_collection_notify_items_relinked (SourceCollection* self,
                                         GeeCollection* relinked)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_relinked) {
		_klass_->notify_items_relinked (self, relinked);
	}
}

static void
source_collection_real_notify_item_destroyed (SourceCollection* self,
                                              DataSource* source)
{
	g_return_if_fail (source != NULL);
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL], 0, source);
}

void
source_collection_notify_item_destroyed (SourceCollection* self,
                                         DataSource* source)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_item_destroyed) {
		_klass_->notify_item_destroyed (self, source);
	}
}

static void
source_collection_real_notify_items_destroyed (SourceCollection* self,
                                               GeeCollection* destroyed)
{
	g_return_if_fail (destroyed != NULL);
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL], 0, destroyed);
}

void
source_collection_notify_items_destroyed (SourceCollection* self,
                                          GeeCollection* destroyed)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_destroyed) {
		_klass_->notify_items_destroyed (self, destroyed);
	}
}

static void
source_collection_real_notify_unlinked_destroyed (SourceCollection* self,
                                                  DataSource* unlinked)
{
	g_return_if_fail (unlinked != NULL);
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL], 0, unlinked);
}

void
source_collection_notify_unlinked_destroyed (SourceCollection* self,
                                             DataSource* unlinked)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_unlinked_destroyed) {
		_klass_->notify_unlinked_destroyed (self, unlinked);
	}
}

static void
source_collection_real_notify_backlink_removed (SourceCollection* self,
                                                SourceBacklink* backlink,
                                                GeeCollection* sources)
{
	g_return_if_fail (backlink != NULL);
	g_return_if_fail (sources != NULL);
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL], 0, backlink, sources);
}

void
source_collection_notify_backlink_removed (SourceCollection* self,
                                           SourceBacklink* backlink,
                                           GeeCollection* sources)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_backlink_removed) {
		_klass_->notify_backlink_removed (self, backlink, sources);
	}
}

static gboolean
source_collection_real_valid_type (DataCollection* base,
                                   DataObject* object)
{
	SourceCollection * self;
	gboolean result;
	self = (SourceCollection*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	result = IS_DATA_SOURCE (object);
	return result;
}

static gboolean
_source_collection_destroy_and_delete_source_marked_action (DataObject* object,
                                                            GObject* user,
                                                            gpointer self)
{
	gboolean result;
	result = source_collection_destroy_and_delete_source ((SourceCollection*) self, object, user);
	return result;
}

static gboolean
_source_collection_destroy_source_marked_action (DataObject* object,
                                                 GObject* user,
                                                 gpointer self)
{
	gboolean result;
	result = source_collection_destroy_source ((SourceCollection*) self, object, user);
	return result;
}

gint
source_collection_destroy_marked (SourceCollection* self,
                                  Marker* marker,
                                  gboolean delete_backing,
                                  ProgressMonitor monitor,
                                  gpointer monitor_target,
                                  GeeList* not_removed)
{
	SourceCollectionDestroyCounter* counter = NULL;
	Marker* _tmp0_;
	Marker* _tmp1_;
	SourceCollectionDestroyCounter* _tmp2_;
	SourceCollectionDestroyCounter* _tmp3_;
	SourceCollectionDestroyCounter* _tmp16_;
	GeeArrayList* _tmp17_;
	SourceCollectionDestroyCounter* _tmp18_;
	Marker* _tmp19_;
	SourceCollectionDestroyCounter* _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (marker != NULL, 0);
	_tmp0_ = data_collection_start_marking ((DataCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_collection_destroy_counter_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	counter = _tmp3_;
	if (delete_backing) {
		SourceCollectionDestroyCounter* _tmp4_;
		_tmp4_ = counter;
		data_collection_act_on_marked ((DataCollection*) self, marker, _source_collection_destroy_and_delete_source_marked_action, self, monitor, monitor_target, (GObject*) _tmp4_);
	} else {
		SourceCollectionDestroyCounter* _tmp5_;
		_tmp5_ = counter;
		data_collection_act_on_marked ((DataCollection*) self, marker, _source_collection_destroy_source_marked_action, self, monitor, monitor_target, (GObject*) _tmp5_);
	}
	{
		GeeArrayList* _source_list = NULL;
		SourceCollectionDestroyCounter* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _source_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _source_index = 0;
		_tmp6_ = counter;
		_tmp7_ = _tmp6_->notify_list;
		_source_list = _tmp7_;
		_tmp8_ = _source_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_source_size = _tmp10_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			DataSource* source = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			DataSource* _tmp15_;
			_source_index = _source_index + 1;
			_tmp11_ = _source_index;
			_tmp12_ = _source_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _source_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _source_index);
			source = (DataSource*) _tmp14_;
			_tmp15_ = source;
			source_collection_notify_item_destroyed (self, _tmp15_);
			_g_object_unref0 (source);
		}
	}
	_tmp16_ = counter;
	_tmp17_ = _tmp16_->notify_list;
	source_collection_notify_items_destroyed (self, (GeeCollection*) _tmp17_);
	_tmp18_ = counter;
	_tmp19_ = _tmp18_->remove_marker;
	data_collection_remove_marked ((DataCollection*) self, _tmp19_);
	if (NULL != not_removed) {
		SourceCollectionDestroyCounter* _tmp20_;
		GeeArrayList* _tmp21_;
		_tmp20_ = counter;
		_tmp21_ = _tmp20_->not_removed;
		gee_collection_add_all ((GeeCollection*) not_removed, (GeeCollection*) _tmp21_);
	}
	_tmp22_ = counter;
	_tmp23_ = _tmp22_->not_removed;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	result = _tmp25_;
	_g_object_unref0 (counter);
	return result;
}

static gboolean
source_collection_destroy_and_delete_source (SourceCollection* self,
                                             DataObject* object,
                                             GObject* user)
{
	gboolean success = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	success = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = data_source_internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		success = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		success = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	if (!success) {
		_tmp2_ = IS_MEDIA_SOURCE (object);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GeeArrayList* _tmp3_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->not_removed;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_SOURCE, MediaSource));
	}
	if (source_collection_destroy_source (self, object, user)) {
		_tmp4_ = success;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
source_collection_destroy_source (SourceCollection* self,
                                  DataObject* object,
                                  GObject* user)
{
	DataSource* source = NULL;
	DataSource* _tmp0_;
	Marker* _tmp1_;
	GeeArrayList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource));
	source = _tmp0_;
	data_source_internal_mark_for_destroy (source);
	data_source_destroy (source);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->remove_marker;
	marker_mark (_tmp1_, (DataObject*) source);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->notify_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, source);
	result = TRUE;
	_g_object_unref0 (source);
	return result;
}

static guint
_source_backlink_hash_func_gee_hash_data_func (gconstpointer v,
                                               gpointer self)
{
	guint result;
	result = source_backlink_hash_func ((SourceBacklink*) v);
	return result;
}

static gboolean
_source_backlink_equal_func_gee_equal_data_func (gconstpointer a,
                                                 gconstpointer b,
                                                 gpointer self)
{
	gboolean result;
	result = source_backlink_equal_func ((SourceBacklink*) a, (SourceBacklink*) b);
	return result;
}

void
source_collection_internal_backlink_set (SourceCollection* self,
                                         DataSource* source,
                                         SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (backlink != NULL);
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		GeeHashMultiMap* _tmp1_;
		_tmp1_ = gee_hash_multi_map_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, (GDestroyNotify) source_backlink_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _source_backlink_hash_func_gee_hash_data_func, NULL, NULL, _source_backlink_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->backlinks);
		self->priv->backlinks = (GeeMultiMap*) _tmp1_;
	}
	_tmp2_ = self->priv->backlinks;
	gee_multi_map_set (_tmp2_, backlink, source);
}

void
source_collection_internal_backlink_removed (SourceCollection* self,
                                             DataSource* source,
                                             SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	gboolean removed = FALSE;
	GeeMultiMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (backlink != NULL);
	_tmp0_ = self->priv->backlinks;
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
	_tmp1_ = self->priv->backlinks;
	removed = gee_multi_map_remove (_tmp1_, backlink, source);
	_vala_assert (removed, "removed");
}

static gboolean
source_collection_real_has_backlink (SourceCollection* self,
                                     SourceBacklink* backlink)
{
	gboolean _tmp0_ = FALSE;
	GeeMultiMap* _tmp1_;
	gboolean result;
	g_return_val_if_fail (backlink != NULL, FALSE);
	_tmp1_ = self->priv->backlinks;
	if (_tmp1_ != NULL) {
		GeeMultiMap* _tmp2_;
		_tmp2_ = self->priv->backlinks;
		_tmp0_ = gee_multi_map_contains (_tmp2_, backlink);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
source_collection_has_backlink (SourceCollection* self,
                                SourceBacklink* backlink)
{
	SourceCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->has_backlink) {
		return _klass_->has_backlink (self, backlink);
	}
	return FALSE;
}

static gboolean
_source_collection_prepare_for_unlink_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self)
{
	gboolean result;
	result = source_collection_prepare_for_unlink ((SourceCollection*) self, object, user);
	return result;
}

GeeCollection*
source_collection_unlink_marked (SourceCollection* self,
                                 Marker* marker,
                                 ProgressMonitor monitor,
                                 gpointer monitor_target)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	Marker* _tmp7_;
	Marker* _tmp8_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (marker != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = list;
	data_collection_act_on_marked ((DataCollection*) self, marker, _source_collection_prepare_for_unlink_marked_action, self, monitor, monitor_target, (GObject*) _tmp1_);
	_tmp2_ = list;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = NULL;
		_g_object_unref0 (list);
		return result;
	}
	_tmp5_ = list;
	source_collection_notify_items_unlinking (self, (GeeCollection*) _tmp5_);
	_tmp6_ = list;
	_tmp7_ = data_collection_mark_many ((DataCollection*) self, (GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	data_collection_remove_marked ((DataCollection*) self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	result = (GeeCollection*) list;
	return result;
}

static gboolean
source_collection_prepare_for_unlink (SourceCollection* self,
                                      DataObject* object,
                                      GObject* user)
{
	DataSource* source = NULL;
	DataSource* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource));
	source = _tmp0_;
	data_source_notify_unlinking (source, self);
	gee_collection_add ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_LIST, GeeList), source);
	result = TRUE;
	_g_object_unref0 (source);
	return result;
}

void
source_collection_relink (SourceCollection* self,
                          DataSource* source)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	data_source_notify_relinking (source, self);
	data_collection_add ((DataCollection*) self, (DataObject*) source);
	_tmp0_ = data_collection_get_singleton ((DataObject*) source);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	source_collection_notify_items_relinked (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	data_source_notify_relinked (source);
}

void
source_collection_relink_many (SourceCollection* self,
                               GeeCollection* relink)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (relink != NULL);
	_tmp0_ = gee_collection_get_size (relink);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) relink);
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataSource* _tmp6_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (DataSource*) _tmp5_;
			_tmp6_ = source;
			data_source_notify_relinking (_tmp6_, self);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp7_ = data_collection_add_many ((DataCollection*) self, relink, NULL, NULL);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	source_collection_notify_items_relinked (self, relink);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp9_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) relink);
		_source_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataSource* source = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataSource* _tmp13_;
			_tmp10_ = _source_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _source_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			source = (DataSource*) _tmp12_;
			_tmp13_ = source;
			data_source_notify_relinked (_tmp13_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
source_collection_real_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	GeeArrayList* sources = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeArrayList* _tmp15_;
	g_return_if_fail (backlink != NULL);
	_tmp0_ = self->priv->backlinks;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	sources = _tmp1_;
	_tmp2_ = sources;
	_tmp3_ = self->priv->backlinks;
	_tmp4_ = gee_multi_map_get (_tmp3_, backlink);
	_tmp5_ = _tmp4_;
	gee_array_list_add_all (_tmp2_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		GeeArrayList* _source_list = NULL;
		GeeArrayList* _tmp6_;
		gint _source_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _source_index = 0;
		_tmp6_ = sources;
		_source_list = _tmp6_;
		_tmp7_ = _source_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_source_size = _tmp9_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			DataSource* source = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			DataSource* _tmp14_;
			_source_index = _source_index + 1;
			_tmp10_ = _source_index;
			_tmp11_ = _source_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _source_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _source_index);
			source = (DataSource*) _tmp13_;
			_tmp14_ = source;
			data_source_remove_backlink (_tmp14_, backlink);
			_g_object_unref0 (source);
		}
	}
	_tmp15_ = sources;
	source_collection_notify_backlink_removed (self, backlink, (GeeCollection*) _tmp15_);
	_g_object_unref0 (sources);
}

void
source_collection_remove_backlink (SourceCollection* self,
                                   SourceBacklink* backlink)
{
	SourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->remove_backlink) {
		_klass_->remove_backlink (self, backlink);
	}
}

static void
source_collection_real_items_unlinking (SourceCollection* self,
                                        GeeCollection* unlinking)
{
	g_return_if_fail (unlinking != NULL);
}

static void
source_collection_real_items_relinked (SourceCollection* self,
                                       GeeCollection* relinked)
{
	g_return_if_fail (relinked != NULL);
}

static void
source_collection_real_item_destroyed (SourceCollection* self,
                                       DataSource* source)
{
	g_return_if_fail (source != NULL);
}

static void
source_collection_real_items_destroyed (SourceCollection* self,
                                        GeeCollection* destroyed)
{
	g_return_if_fail (destroyed != NULL);
}

static void
source_collection_real_unlinked_destroyed (SourceCollection* self,
                                           DataSource* source)
{
	g_return_if_fail (source != NULL);
}

static void
source_collection_real_backlink_removed (SourceCollection* self,
                                         SourceBacklink* backlink,
                                         GeeCollection* sources)
{
	g_return_if_fail (backlink != NULL);
	g_return_if_fail (sources != NULL);
}

static void
g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_source_backlink (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static SourceCollectionDestroyCounter*
source_collection_destroy_counter_construct (GType object_type,
                                             Marker* remove_marker)
{
	SourceCollectionDestroyCounter * self = NULL;
	Marker* _tmp0_;
	g_return_val_if_fail (remove_marker != NULL, NULL);
	self = (SourceCollectionDestroyCounter*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (remove_marker);
	_g_object_unref0 (self->remove_marker);
	self->remove_marker = _tmp0_;
	return self;
}

static SourceCollectionDestroyCounter*
source_collection_destroy_counter_new (Marker* remove_marker)
{
	return source_collection_destroy_counter_construct (SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, remove_marker);
}

static void
source_collection_destroy_counter_class_init (SourceCollectionDestroyCounterClass * klass,
                                              gpointer klass_data)
{
	source_collection_destroy_counter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = source_collection_destroy_counter_finalize;
}

static void
source_collection_destroy_counter_instance_init (SourceCollectionDestroyCounter * self,
                                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->notify_list = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->not_removed = _tmp1_;
}

static void
source_collection_destroy_counter_finalize (GObject * obj)
{
	SourceCollectionDestroyCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter);
	_g_object_unref0 (self->remove_marker);
	_g_object_unref0 (self->notify_list);
	_g_object_unref0 (self->not_removed);
	G_OBJECT_CLASS (source_collection_destroy_counter_parent_class)->finalize (obj);
}

static GType
source_collection_destroy_counter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionDestroyCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_destroy_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollectionDestroyCounter), 0, (GInstanceInitFunc) source_collection_destroy_counter_instance_init, NULL };
	GType source_collection_destroy_counter_type_id;
	source_collection_destroy_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "SourceCollectionDestroyCounter", &g_define_type_info, 0);
	return source_collection_destroy_counter_type_id;
}

static GType
source_collection_destroy_counter_get_type (void)
{
	static volatile gsize source_collection_destroy_counter_type_id__once = 0;
	if (g_once_init_enter (&source_collection_destroy_counter_type_id__once)) {
		GType source_collection_destroy_counter_type_id;
		source_collection_destroy_counter_type_id = source_collection_destroy_counter_get_type_once ();
		g_once_init_leave (&source_collection_destroy_counter_type_id__once, source_collection_destroy_counter_type_id);
	}
	return source_collection_destroy_counter_type_id__once;
}

static void
source_collection_class_init (SourceCollectionClass * klass,
                              gpointer klass_data)
{
	source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &SourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) source_collection_real_holds_type_of_source;
	((SourceCollectionClass *) klass)->notify_items_unlinking = (void (*) (SourceCollection*, GeeCollection*)) source_collection_real_notify_items_unlinking;
	((SourceCollectionClass *) klass)->notify_items_relinked = (void (*) (SourceCollection*, GeeCollection*)) source_collection_real_notify_items_relinked;
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*) (SourceCollection*, DataSource*)) source_collection_real_notify_item_destroyed;
	((SourceCollectionClass *) klass)->notify_items_destroyed = (void (*) (SourceCollection*, GeeCollection*)) source_collection_real_notify_items_destroyed;
	((SourceCollectionClass *) klass)->notify_unlinked_destroyed = (void (*) (SourceCollection*, DataSource*)) source_collection_real_notify_unlinked_destroyed;
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*) (SourceCollection*, SourceBacklink*, GeeCollection*)) source_collection_real_notify_backlink_removed;
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection*, DataObject*)) source_collection_real_valid_type;
	((SourceCollectionClass *) klass)->has_backlink = (gboolean (*) (SourceCollection*, SourceBacklink*)) source_collection_real_has_backlink;
	((SourceCollectionClass *) klass)->remove_backlink = (void (*) (SourceCollection*, SourceBacklink*)) source_collection_real_remove_backlink;
	((SourceCollectionClass *) klass)->items_unlinking = source_collection_real_items_unlinking;
	((SourceCollectionClass *) klass)->items_relinked = source_collection_real_items_relinked;
	((SourceCollectionClass *) klass)->item_destroyed = source_collection_real_item_destroyed;
	((SourceCollectionClass *) klass)->items_destroyed = source_collection_real_items_destroyed;
	((SourceCollectionClass *) klass)->unlinked_destroyed = source_collection_real_unlinked_destroyed;
	((SourceCollectionClass *) klass)->backlink_removed = source_collection_real_backlink_removed;
	source_collection_signals[SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL] = g_signal_new ("items-unlinking", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_unlinking), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	source_collection_signals[SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL] = g_signal_new ("items-relinked", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_relinked), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	source_collection_signals[SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL] = g_signal_new ("item-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, item_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
	source_collection_signals[SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL] = g_signal_new ("items-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	source_collection_signals[SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL] = g_signal_new ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, unlinked_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
	source_collection_signals[SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL] = g_signal_new ("backlink-removed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, backlink_removed), NULL, NULL, g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT, G_TYPE_NONE, 2, TYPE_SOURCE_BACKLINK, GEE_TYPE_COLLECTION);
}

static void
source_collection_instance_init (SourceCollection * self,
                                 gpointer klass)
{
	self->priv = source_collection_get_instance_private (self);
	self->priv->backlinks = NULL;
}

static void
source_collection_finalize (DataCollection * obj)
{
	SourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_COLLECTION, SourceCollection);
	_g_object_unref0 (self->priv->backlinks);
	DATA_COLLECTION_CLASS (source_collection_parent_class)->finalize (obj);
}

static GType
source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollection), 0, (GInstanceInitFunc) source_collection_instance_init, NULL };
	GType source_collection_type_id;
	source_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "SourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SourceCollection_private_offset = g_type_add_instance_private (source_collection_type_id, sizeof (SourceCollectionPrivate));
	return source_collection_type_id;
}

GType
source_collection_get_type (void)
{
	static volatile gsize source_collection_type_id__once = 0;
	if (g_once_init_enter (&source_collection_type_id__once)) {
		GType source_collection_type_id;
		source_collection_type_id = source_collection_get_type_once ();
		g_once_init_leave (&source_collection_type_id__once, source_collection_type_id);
	}
	return source_collection_type_id__once;
}

