/* TextEntryDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from TextEntryDialog.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2017-2018 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TEXT_ENTRY_DIALOG_0_PROPERTY,
	TEXT_ENTRY_DIALOG_INITIAL_TEXT_PROPERTY,
	TEXT_ENTRY_DIALOG_LABEL_PROPERTY,
	TEXT_ENTRY_DIALOG_COMPLETION_LIST_PROPERTY,
	TEXT_ENTRY_DIALOG_COMPLETION_DELIMITER_PROPERTY,
	TEXT_ENTRY_DIALOG_NUM_PROPERTIES
};
static GParamSpec* text_entry_dialog_properties[TEXT_ENTRY_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TextEntryDialogPrivate {
	gchar* _initial_text;
	gchar* _label;
	GeeCollection* _completion_list;
	gchar* _completion_delimiter;
	TextEntryDialogOnModifyValidateType on_modify_validate;
	gpointer on_modify_validate_target;
	GtkEntry* entry;
};

static gint TextEntryDialog_private_offset;
static gpointer text_entry_dialog_parent_class = NULL;

static void text_entry_dialog_on_entry_changed (TextEntryDialog* self);
static void _text_entry_dialog_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
static GObject * text_entry_dialog_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void text_entry_dialog_finalize (GObject * obj);
static GType text_entry_dialog_get_type_once (void);
static void _vala_text_entry_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_text_entry_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
text_entry_dialog_get_instance_private (TextEntryDialog* self)
{
	return G_STRUCT_MEMBER_P (self, TextEntryDialog_private_offset);
}

TextEntryDialog*
text_entry_dialog_construct (GType object_type,
                             TextEntryDialogOnModifyValidateType modify_validate,
                             gpointer modify_validate_target,
                             const gchar* title,
                             const gchar* label,
                             const gchar* initial_text,
                             GeeCollection* completion_list,
                             const gchar* completion_delimiter)
{
	TextEntryDialog * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (TextEntryDialog*) g_object_new (object_type, "completion-delimiter", completion_delimiter, "completion-list", completion_list, "initial-text", initial_text, "label", label, "title", title, NULL);
	self->priv->on_modify_validate = modify_validate;
	self->priv->on_modify_validate_target = modify_validate_target;
	return self;
}

TextEntryDialog*
text_entry_dialog_new (TextEntryDialogOnModifyValidateType modify_validate,
                       gpointer modify_validate_target,
                       const gchar* title,
                       const gchar* label,
                       const gchar* initial_text,
                       GeeCollection* completion_list,
                       const gchar* completion_delimiter)
{
	return text_entry_dialog_construct (TYPE_TEXT_ENTRY_DIALOG, modify_validate, modify_validate_target, title, label, initial_text, completion_list, completion_delimiter);
}

static void
_text_entry_dialog_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	text_entry_dialog_on_entry_changed ((TextEntryDialog*) self);
}

gchar*
text_entry_dialog_execute (TextEntryDialog* self)
{
	gchar* text = NULL;
	TextEntryDialogOnModifyValidateType _tmp0_;
	gpointer _tmp0__target;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	GtkEntry* _tmp6_;
	guint _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	text = NULL;
	_tmp0_ = self->priv->on_modify_validate;
	_tmp0__target = self->priv->on_modify_validate_target;
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, _tmp0_ (_tmp2_, _tmp0__target));
	gtk_widget_show_all ((GtkWidget*) self);
	if (gtk_dialog_run ((GtkDialog*) self) == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->entry;
		_tmp4_ = gtk_entry_get_text (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (text);
		text = _tmp5_;
	}
	_tmp6_ = self->priv->entry;
	g_signal_parse_name ("changed", gtk_editable_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkEditable*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _text_entry_dialog_on_entry_changed_gtk_editable_changed, self);
	gtk_widget_destroy ((GtkWidget*) self);
	result = text;
	return result;
}

static void
text_entry_dialog_on_entry_changed (TextEntryDialog* self)
{
	TextEntryDialogOnModifyValidateType _tmp0_;
	gpointer _tmp0__target;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->on_modify_validate;
	_tmp0__target = self->priv->on_modify_validate_target;
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, _tmp0_ (_tmp2_, _tmp0__target));
}

const gchar*
text_entry_dialog_get_initial_text (TextEntryDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initial_text;
	result = _tmp0_;
	return result;
}

static void
text_entry_dialog_set_initial_text (TextEntryDialog* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = text_entry_dialog_get_initial_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_initial_text);
		self->priv->_initial_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_INITIAL_TEXT_PROPERTY]);
	}
}

const gchar*
text_entry_dialog_get_label (TextEntryDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
text_entry_dialog_set_label (TextEntryDialog* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = text_entry_dialog_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_LABEL_PROPERTY]);
	}
}

GeeCollection*
text_entry_dialog_get_completion_list (TextEntryDialog* self)
{
	GeeCollection* result;
	GeeCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_completion_list;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
text_entry_dialog_set_completion_list (TextEntryDialog* self,
                                       GeeCollection* value)
{
	GeeCollection* old_value;
	g_return_if_fail (self != NULL);
	old_value = text_entry_dialog_get_completion_list (self);
	if (old_value != value) {
		GeeCollection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_completion_list);
		self->priv->_completion_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_COMPLETION_LIST_PROPERTY]);
	}
}

const gchar*
text_entry_dialog_get_completion_delimiter (TextEntryDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_completion_delimiter;
	result = _tmp0_;
	return result;
}

static void
text_entry_dialog_set_completion_delimiter (TextEntryDialog* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = text_entry_dialog_get_completion_delimiter (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_completion_delimiter);
		self->priv->_completion_delimiter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_COMPLETION_DELIMITER_PROPERTY]);
	}
}

static GObject *
text_entry_dialog_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TextEntryDialog * self;
	GtkLabel* name_label = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GeeCollection* _tmp11_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp17_;
	GtkGrid* _tmp18_;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkLabel* _tmp23_;
	GtkGrid* _tmp24_;
	GtkEntry* _tmp25_;
	GtkBox* _tmp26_;
	GtkGrid* _tmp27_;
	AppWindow* _tmp28_;
	AppWindow* _tmp29_;
	GtkEntry* _tmp30_;
	parent_class = G_OBJECT_CLASS (text_entry_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_ENTRY_DIALOG, TextEntryDialog);
	_tmp0_ = self->priv->_label;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	name_label = _tmp1_;
	_tmp2_ = name_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	_tmp3_ = name_label;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp5_;
	_tmp6_ = self->priv->entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	_tmp8_ = self->priv->_initial_text;
	_tmp7_ = _tmp8_;
	if (_tmp7_ == NULL) {
		_tmp7_ = "";
	}
	_tmp9_ = self->priv->entry;
	gtk_entry_set_text (_tmp9_, _tmp7_);
	_tmp10_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->_completion_list;
	if (_tmp11_ != NULL) {
		GtkEntry* _tmp12_;
		GeeCollection* _tmp13_;
		const gchar* _tmp14_;
		EntryMultiCompletion* _tmp15_;
		EntryMultiCompletion* _tmp16_;
		_tmp12_ = self->priv->entry;
		_tmp13_ = self->priv->_completion_list;
		_tmp14_ = self->priv->_completion_delimiter;
		_tmp15_ = entry_multi_completion_new (_tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_entry_set_completion (_tmp12_, (GtkEntryCompletion*) _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp17_);
	grid = _tmp17_;
	_tmp18_ = grid;
	_tmp19_ = grid;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp19_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp18_, 6);
	_tmp20_ = grid;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 18);
	_tmp21_ = grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp21_, GTK_ORIENTATION_VERTICAL);
	_tmp22_ = grid;
	_tmp23_ = name_label;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = grid;
	_tmp25_ = self->priv->entry;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp27_ = grid;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("_Save"), (gint) GTK_RESPONSE_OK);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp28_ = app_window_get_instance ();
	_tmp29_ = _tmp28_;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	gtk_window_set_default_size ((GtkWindow*) self, 350, 104);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	_tmp30_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp30_, "changed", (GCallback) _text_entry_dialog_on_entry_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (name_label);
	return obj;
}

static void
text_entry_dialog_class_init (TextEntryDialogClass * klass,
                              gpointer klass_data)
{
	text_entry_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TextEntryDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_text_entry_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_text_entry_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = text_entry_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = text_entry_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_ENTRY_DIALOG_INITIAL_TEXT_PROPERTY, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_INITIAL_TEXT_PROPERTY] = g_param_spec_string ("initial-text", "initial-text", "initial-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_ENTRY_DIALOG_LABEL_PROPERTY, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_ENTRY_DIALOG_COMPLETION_LIST_PROPERTY, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_COMPLETION_LIST_PROPERTY] = g_param_spec_object ("completion-list", "completion-list", "completion-list", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_ENTRY_DIALOG_COMPLETION_DELIMITER_PROPERTY, text_entry_dialog_properties[TEXT_ENTRY_DIALOG_COMPLETION_DELIMITER_PROPERTY] = g_param_spec_string ("completion-delimiter", "completion-delimiter", "completion-delimiter", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
text_entry_dialog_instance_init (TextEntryDialog * self,
                                 gpointer klass)
{
	self->priv = text_entry_dialog_get_instance_private (self);
}

static void
text_entry_dialog_finalize (GObject * obj)
{
	TextEntryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_ENTRY_DIALOG, TextEntryDialog);
	_g_free0 (self->priv->_initial_text);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_completion_list);
	_g_free0 (self->priv->_completion_delimiter);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (text_entry_dialog_parent_class)->finalize (obj);
}

static GType
text_entry_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TextEntryDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_entry_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextEntryDialog), 0, (GInstanceInitFunc) text_entry_dialog_instance_init, NULL };
	GType text_entry_dialog_type_id;
	text_entry_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "TextEntryDialog", &g_define_type_info, 0);
	TextEntryDialog_private_offset = g_type_add_instance_private (text_entry_dialog_type_id, sizeof (TextEntryDialogPrivate));
	return text_entry_dialog_type_id;
}

GType
text_entry_dialog_get_type (void)
{
	static volatile gsize text_entry_dialog_type_id__once = 0;
	if (g_once_init_enter (&text_entry_dialog_type_id__once)) {
		GType text_entry_dialog_type_id;
		text_entry_dialog_type_id = text_entry_dialog_get_type_once ();
		g_once_init_leave (&text_entry_dialog_type_id__once, text_entry_dialog_type_id);
	}
	return text_entry_dialog_type_id__once;
}

static void
_vala_text_entry_dialog_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	TextEntryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_ENTRY_DIALOG, TextEntryDialog);
	switch (property_id) {
		case TEXT_ENTRY_DIALOG_INITIAL_TEXT_PROPERTY:
		g_value_set_string (value, text_entry_dialog_get_initial_text (self));
		break;
		case TEXT_ENTRY_DIALOG_LABEL_PROPERTY:
		g_value_set_string (value, text_entry_dialog_get_label (self));
		break;
		case TEXT_ENTRY_DIALOG_COMPLETION_LIST_PROPERTY:
		g_value_set_object (value, text_entry_dialog_get_completion_list (self));
		break;
		case TEXT_ENTRY_DIALOG_COMPLETION_DELIMITER_PROPERTY:
		g_value_set_string (value, text_entry_dialog_get_completion_delimiter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_text_entry_dialog_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	TextEntryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_ENTRY_DIALOG, TextEntryDialog);
	switch (property_id) {
		case TEXT_ENTRY_DIALOG_INITIAL_TEXT_PROPERTY:
		text_entry_dialog_set_initial_text (self, g_value_get_string (value));
		break;
		case TEXT_ENTRY_DIALOG_LABEL_PROPERTY:
		text_entry_dialog_set_label (self, g_value_get_string (value));
		break;
		case TEXT_ENTRY_DIALOG_COMPLETION_LIST_PROPERTY:
		text_entry_dialog_set_completion_list (self, g_value_get_object (value));
		break;
		case TEXT_ENTRY_DIALOG_COMPLETION_DELIMITER_PROPERTY:
		text_entry_dialog_set_completion_delimiter (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

