/* IconInfo.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IconInfo.vala, do not modify */

/* Copyright (c) 2018 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_ICON_INFO_0_PROPERTY,
	FILES_ICON_INFO_PIXBUF_PROPERTY,
	FILES_ICON_INFO_NUM_PROPERTIES
};
static GParamSpec* files_icon_info_properties[FILES_ICON_INFO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FilesIconInfoLoadableIconKey FilesIconInfoLoadableIconKey;
typedef struct _FilesIconInfoThemedIconKey FilesIconInfoThemedIconKey;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _files_icon_info_loadable_icon_key_free0(var) ((var == NULL) ? NULL : (var = (files_icon_info_loadable_icon_key_free (var), NULL)))
typedef struct _Block15Data Block15Data;

struct _FilesIconInfoPrivate {
	gint64 last_use_time;
	GdkPixbuf* _pixbuf;
	gchar* icon_name;
};

struct _Block15Data {
	int _ref_count_;
	gint64 time_now;
	guint reap_time_extended;
};

struct _FilesIconInfoLoadableIconKey {
	GIcon* icon;
	gint size;
	gint scale;
};

struct _FilesIconInfoThemedIconKey {
	GThemedIcon* icon;
	gint size;
	gint scale;
};

static gint FilesIconInfo_private_offset;
static gpointer files_icon_info_parent_class = NULL;
static GHashTable* files_icon_info_loadable_icon_cache;
static GHashTable* files_icon_info_loadable_icon_cache = NULL;
static GHashTable* files_icon_info_themed_icon_cache;
static GHashTable* files_icon_info_themed_icon_cache = NULL;
static guint files_icon_info_reap_cache_timeout;
static guint files_icon_info_reap_cache_timeout = (guint) 0;
static guint files_icon_info_reap_time;
static guint files_icon_info_reap_time = (guint) 5000;

static void files_icon_info_loadable_icon_key_free (FilesIconInfoLoadableIconKey * self);
static void files_icon_info_themed_icon_key_free (FilesIconInfoThemedIconKey * self);
static guint files_icon_info_loadable_icon_key_hash (FilesIconInfoLoadableIconKey* a);
static guint _files_icon_info_loadable_icon_key_hash_ghash_func (gconstpointer key);
static gboolean files_icon_info_loadable_icon_key_equal (FilesIconInfoLoadableIconKey* a,
                                                  FilesIconInfoLoadableIconKey* b);
static gboolean _files_icon_info_loadable_icon_key_equal_gequal_func (gconstpointer a,
                                                               gconstpointer b);
static void _files_icon_info_loadable_icon_key_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static FilesIconInfoLoadableIconKey* files_icon_info_loadable_icon_key_new (GIcon* _icon,
                                                                     gint _size,
                                                                     gint _scale);
static FilesIconInfoLoadableIconKey* files_icon_info_loadable_icon_key_new_from_path (const gchar* path,
                                                                               gint _size,
                                                                               gint _scale);
static gboolean files_icon_info_end_reap_cache_timeout (void);
static void files_icon_info_schedule_reap_cache (void);
static gboolean files_icon_info_reap_cache (void);
static gboolean _files_icon_info_reap_cache_gsource_func (gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean ___lambda5_ (Block15Data* _data15_,
                      FilesIconInfoLoadableIconKey* loadableicon,
                      FilesIconInfo* icon_info);
static gboolean ____lambda5__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gboolean ___lambda6_ (Block15Data* _data15_,
                      FilesIconInfoThemedIconKey* themedicon,
                      FilesIconInfo* icon_info);
static gboolean ____lambda6__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static void files_icon_info_loadable_icon_key_instance_init (FilesIconInfoLoadableIconKey * self);
static void files_icon_info_themed_icon_key_instance_init (FilesIconInfoThemedIconKey * self);
static FilesIconInfoThemedIconKey* files_icon_info_themed_icon_key_new (GThemedIcon* _icon,
                                                                 gint _size,
                                                                 gint _scale);
static GObject * files_icon_info_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void files_icon_info_finalize (GObject * obj);
static GType files_icon_info_get_type_once (void);
static void _vala_files_icon_info_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_files_icon_info_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_icon_info_get_instance_private (FilesIconInfo* self)
{
	return G_STRUCT_MEMBER_P (self, FilesIconInfo_private_offset);
}

FilesIconInfo*
files_icon_info_construct_for_pixbuf (GType object_type,
                                      GdkPixbuf* pixbuf)
{
	FilesIconInfo * self = NULL;
	self = (FilesIconInfo*) g_object_new (object_type, NULL);
	files_icon_info_set_pixbuf (self, pixbuf);
	return self;
}

FilesIconInfo*
files_icon_info_new_for_pixbuf (GdkPixbuf* pixbuf)
{
	return files_icon_info_construct_for_pixbuf (FILES_TYPE_ICON_INFO, pixbuf);
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

FilesIconInfo*
files_icon_info_construct_for_icon_info (GType object_type,
                                         GtkIconInfo* icon_info)
{
	FilesIconInfo * self = NULL;
	gchar* filename = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (icon_info != NULL, NULL);
	self = (FilesIconInfo*) g_object_new (object_type, NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		_tmp1_ = gtk_icon_info_load_icon (icon_info, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		files_icon_info_set_pixbuf (self, _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("IconInfo.vala:32: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = gtk_icon_info_get_filename (icon_info);
	_tmp5_ = g_strdup (_tmp4_);
	filename = _tmp5_;
	_tmp6_ = filename;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gint last = 0;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = filename;
		_tmp8_ = g_path_get_basename (_tmp7_);
		_g_free0 (filename);
		filename = _tmp8_;
		_tmp9_ = filename;
		last = string_last_index_of_char (_tmp9_, (gunichar) '.', 0);
		_tmp10_ = filename;
		_tmp11_ = string_substring (_tmp10_, (glong) 0, (glong) last);
		_g_free0 (self->priv->icon_name);
		self->priv->icon_name = _tmp11_;
	}
	_g_free0 (filename);
	return self;
}

FilesIconInfo*
files_icon_info_new_for_icon_info (GtkIconInfo* icon_info)
{
	return files_icon_info_construct_for_icon_info (FILES_TYPE_ICON_INFO, icon_info);
}

static guint
_files_icon_info_loadable_icon_key_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = files_icon_info_loadable_icon_key_hash ((FilesIconInfoLoadableIconKey*) key);
	return result;
}

static gboolean
_files_icon_info_loadable_icon_key_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b)
{
	gboolean result;
	result = files_icon_info_loadable_icon_key_equal ((FilesIconInfoLoadableIconKey*) a, (FilesIconInfoLoadableIconKey*) b);
	return result;
}

static void
_files_icon_info_loadable_icon_key_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_icon_info_loadable_icon_key_free (var), NULL));
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesIconInfo*
files_icon_info_lookup (GIcon* icon,
                        gint size,
                        gint scale,
                        gboolean cache_loadable)
{
	FilesIconInfo* icon_info = NULL;
	GError* _inner_error0_ = NULL;
	FilesIconInfo* result;
	g_return_val_if_fail (icon != NULL, NULL);
	size = MAX (1, size);
	icon_info = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (icon, g_loadable_icon_get_type ())) {
		gchar* str_icon = NULL;
		gchar* _tmp8_;
		gint width = 0;
		gint height = 0;
		const gchar* _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		GdkPixbuf* pixbuf = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		GdkPixbuf* _tmp21_;
		if (cache_loadable) {
			GHashTable* _tmp0_;
			_tmp0_ = files_icon_info_loadable_icon_cache;
			if (_tmp0_ == NULL) {
				GHashTable* _tmp1_;
				_tmp1_ = g_hash_table_new_full (_files_icon_info_loadable_icon_key_hash_ghash_func, _files_icon_info_loadable_icon_key_equal_gequal_func, _files_icon_info_loadable_icon_key_free0_, _g_object_unref0_);
				_g_hash_table_unref0 (files_icon_info_loadable_icon_cache);
				files_icon_info_loadable_icon_cache = _tmp1_;
			} else {
				GHashTable* _tmp2_;
				FilesIconInfoLoadableIconKey* _tmp3_;
				FilesIconInfoLoadableIconKey* _tmp4_;
				gconstpointer _tmp5_;
				FilesIconInfo* _tmp6_;
				FilesIconInfo* _tmp7_;
				_tmp2_ = files_icon_info_loadable_icon_cache;
				_tmp3_ = files_icon_info_loadable_icon_key_new (icon, size, scale);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_hash_table_lookup (_tmp2_, _tmp4_);
				_tmp6_ = _g_object_ref0 ((FilesIconInfo*) _tmp5_);
				_g_object_unref0 (icon_info);
				icon_info = _tmp6_;
				_files_icon_info_loadable_icon_key_free0 (_tmp4_);
				_tmp7_ = icon_info;
				if (_tmp7_ != NULL) {
					result = icon_info;
					return result;
				}
			}
		}
		_tmp8_ = g_icon_to_string (icon);
		str_icon = _tmp8_;
		_tmp9_ = str_icon;
		gdk_pixbuf_get_file_info (_tmp9_, &_tmp10_, &_tmp11_);
		width = _tmp10_;
		height = _tmp11_;
		pixbuf = NULL;
		if (width >= 1) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = width == -1;
		}
		if (_tmp13_) {
			gboolean _tmp14_ = FALSE;
			if (height >= 1) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = height == -1;
			}
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			{
				GdkPixbuf* _tmp15_ = NULL;
				const gchar* _tmp16_;
				GdkPixbuf* _tmp17_;
				GdkPixbuf* _tmp18_;
				_tmp16_ = str_icon;
				_tmp17_ = gdk_pixbuf_new_from_file_at_scale (_tmp16_, MIN (size, width) * scale, MIN (size, height) * scale, TRUE, &_inner_error0_);
				_tmp15_ = _tmp17_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp18_ = _tmp15_;
				_tmp15_ = NULL;
				_g_object_unref0 (pixbuf);
				pixbuf = _tmp18_;
				_g_object_unref0 (_tmp15_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp19_;
				const gchar* _tmp20_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp19_ = e;
				_tmp20_ = _tmp19_->message;
				g_critical ("IconInfo.vala:83: %s", _tmp20_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (pixbuf);
				_g_free0 (str_icon);
				_g_object_unref0 (icon_info);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp21_ = pixbuf;
		if (_tmp21_ != NULL) {
			GdkPixbuf* _tmp22_;
			FilesIconInfo* _tmp23_;
			_tmp22_ = pixbuf;
			_tmp23_ = files_icon_info_new_for_pixbuf (_tmp22_);
			_g_object_unref0 (icon_info);
			icon_info = _tmp23_;
			if (cache_loadable) {
				GHashTable* _tmp24_;
				FilesIconInfoLoadableIconKey* _tmp25_;
				FilesIconInfo* _tmp26_;
				FilesIconInfo* _tmp27_;
				_tmp24_ = files_icon_info_loadable_icon_cache;
				_tmp25_ = files_icon_info_loadable_icon_key_new (icon, size, scale);
				_tmp26_ = icon_info;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				g_hash_table_insert (_tmp24_, _tmp25_, _tmp27_);
			}
		}
		result = icon_info;
		_g_object_unref0 (pixbuf);
		_g_free0 (str_icon);
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (icon, g_themed_icon_get_type ())) {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp28_;
			GtkIconInfo* gtkicon_info = NULL;
			gchar** _tmp29_;
			gchar** _tmp30_;
			GtkIconInfo* _tmp35_;
			_tmp28_ = files_icon_info_get_icon_theme ();
			theme = _tmp28_;
			gtkicon_info = NULL;
			_tmp30_ = _tmp29_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (icon, g_themed_icon_get_type (), GThemedIcon));
			{
				gchar** name_collection = NULL;
				gint name_collection_length1 = 0;
				gint _name_collection_size_ = 0;
				gint name_it = 0;
				name_collection = _tmp30_;
				name_collection_length1 = _vala_array_length (_tmp29_);
				for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
					const gchar* name = NULL;
					name = name_collection[name_it];
					{
						GtkIconTheme* _tmp31_;
						const gchar* _tmp32_;
						GtkIconInfo* _tmp33_;
						GtkIconInfo* _tmp34_;
						_tmp31_ = theme;
						_tmp32_ = name;
						_tmp33_ = gtk_icon_theme_lookup_icon_for_scale (_tmp31_, _tmp32_, size, scale, GTK_ICON_LOOKUP_FORCE_SIZE);
						_g_object_unref0 (gtkicon_info);
						gtkicon_info = _tmp33_;
						_tmp34_ = gtkicon_info;
						if (_tmp34_ != NULL) {
							break;
						}
					}
				}
			}
			_tmp35_ = gtkicon_info;
			if (_tmp35_ != NULL) {
				GtkIconInfo* _tmp36_;
				FilesIconInfo* _tmp37_;
				_tmp36_ = gtkicon_info;
				_tmp37_ = files_icon_info_new_for_icon_info (_tmp36_);
				_g_object_unref0 (icon_info);
				icon_info = _tmp37_;
			}
			result = icon_info;
			_g_object_unref0 (gtkicon_info);
			_g_object_unref0 (theme);
			return result;
		} else {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp38_;
			_tmp38_ = files_icon_info_get_icon_theme ();
			theme = _tmp38_;
			{
				GtkIconInfo* gtk_icon_info = NULL;
				GtkIconTheme* _tmp39_;
				GtkIconInfo* _tmp40_;
				GdkPixbuf* pixbuf = NULL;
				GtkIconInfo* _tmp41_;
				GdkPixbuf* _tmp42_;
				GdkPixbuf* _tmp43_;
				FilesIconInfo* _tmp44_;
				_tmp39_ = theme;
				_tmp40_ = gtk_icon_theme_lookup_by_gicon_for_scale (_tmp39_, icon, size, scale, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
				gtk_icon_info = _tmp40_;
				_tmp41_ = gtk_icon_info;
				_tmp42_ = gtk_icon_info_load_icon (_tmp41_, &_inner_error0_);
				pixbuf = _tmp42_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (gtk_icon_info);
					goto __catch1_g_error;
				}
				_tmp43_ = pixbuf;
				_tmp44_ = files_icon_info_new_for_pixbuf (_tmp43_);
				result = _tmp44_;
				_g_object_unref0 (pixbuf);
				_g_object_unref0 (gtk_icon_info);
				_g_object_unref0 (theme);
				_g_object_unref0 (icon_info);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp45_;
				const gchar* _tmp46_;
				FilesIconInfo* _tmp47_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp45_ = e;
				_tmp46_ = _tmp45_->message;
				g_critical ("IconInfo.vala:118: %s", _tmp46_);
				_tmp47_ = files_icon_info_new_for_pixbuf (NULL);
				result = _tmp47_;
				_g_error_free0 (e);
				_g_object_unref0 (theme);
				_g_object_unref0 (icon_info);
				return result;
			}
			__finally1:
			_g_object_unref0 (theme);
			_g_object_unref0 (icon_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
}

FilesIconInfo*
files_icon_info_get_generic_icon (gint size,
                                  gint scale)
{
	GThemedIcon* generic_icon = NULL;
	GThemedIcon* _tmp0_;
	FilesIconInfo* _tmp1_;
	FilesIconInfo* result;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("text-x-generic");
	generic_icon = _tmp0_;
	_tmp1_ = files_icon_info_lookup ((GIcon*) generic_icon, size, scale, FALSE);
	result = _tmp1_;
	_g_object_unref0 (generic_icon);
	return result;
}

FilesIconInfo*
files_icon_info_lookup_from_name (const gchar* icon_name,
                                  gint size,
                                  gint scale)
{
	GThemedIcon* themed_icon = NULL;
	GThemedIcon* _tmp0_;
	FilesIconInfo* _tmp1_;
	FilesIconInfo* result;
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (icon_name);
	themed_icon = _tmp0_;
	_tmp1_ = files_icon_info_lookup ((GIcon*) themed_icon, size, scale, FALSE);
	result = _tmp1_;
	_g_object_unref0 (themed_icon);
	return result;
}

FilesIconInfo*
files_icon_info_lookup_from_path (const gchar* path,
                                  gint size,
                                  gint scale,
                                  gboolean is_remote)
{
	FilesIconInfo* result;
	if (path != NULL) {
		GFileIcon* file_icon = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		GFileIcon* _tmp2_;
		GFileIcon* _tmp3_;
		GFileIcon* _tmp4_;
		FilesIconInfo* _tmp5_;
		_tmp0_ = g_file_new_for_path (path);
		_tmp1_ = _tmp0_;
		_tmp2_ = (GFileIcon*) g_file_icon_new (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		file_icon = _tmp3_;
		_tmp4_ = file_icon;
		_tmp5_ = files_icon_info_lookup ((GIcon*) _tmp4_, size, scale, is_remote);
		result = _tmp5_;
		_g_object_unref0 (file_icon);
		return result;
	}
	result = NULL;
	return result;
}

gboolean
files_icon_info_is_fallback (FilesIconInfo* self)
{
	GdkPixbuf* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_ == NULL;
	return result;
}

GdkPixbuf*
files_icon_info_get_pixbuf_nodefault (FilesIconInfo* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->last_use_time = g_get_monotonic_time ();
	_tmp0_ = self->priv->_pixbuf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GtkIconTheme*
files_icon_info_get_icon_theme (void)
{
	GdkScreen* _tmp0_;
	GtkIconTheme* result;
	_tmp0_ = gdk_screen_get_default ();
	if (_tmp0_ != NULL) {
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		_tmp1_ = gtk_icon_theme_get_default ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp3_;
		GtkIconTheme* _tmp4_;
		_tmp3_ = gtk_icon_theme_new ();
		theme = _tmp3_;
		_tmp4_ = theme;
		gtk_icon_theme_set_custom_theme (_tmp4_, "hicolor");
		result = theme;
		return result;
	}
}

guint
files_icon_info_loadable_icon_cache_info (void)
{
	guint size = 0U;
	GHashTable* _tmp0_;
	guint result;
	size = 0U;
	_tmp0_ = files_icon_info_loadable_icon_cache;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = files_icon_info_loadable_icon_cache;
		size = g_hash_table_size (_tmp1_);
	}
	result = size;
	return result;
}

guint
files_icon_info_themed_icon_cache_info (void)
{
	guint size = 0U;
	GHashTable* _tmp0_;
	guint result;
	size = 0U;
	_tmp0_ = files_icon_info_themed_icon_cache;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = files_icon_info_themed_icon_cache;
		size = g_hash_table_size (_tmp1_);
	}
	result = size;
	return result;
}

void
files_icon_info_remove_cache (const gchar* path,
                              gint size,
                              gint scale)
{
	GHashTable* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = files_icon_info_loadable_icon_cache;
	if (_tmp0_ != NULL) {
		FilesIconInfoLoadableIconKey* loadable_key = NULL;
		FilesIconInfoLoadableIconKey* _tmp1_;
		GHashTable* _tmp2_;
		FilesIconInfoLoadableIconKey* _tmp3_;
		_tmp1_ = files_icon_info_loadable_icon_key_new_from_path (path, size, scale);
		loadable_key = _tmp1_;
		_tmp2_ = files_icon_info_loadable_icon_cache;
		_tmp3_ = loadable_key;
		g_hash_table_remove (_tmp2_, _tmp3_);
		_files_icon_info_loadable_icon_key_free0 (loadable_key);
	}
}

static gboolean
files_icon_info_end_reap_cache_timeout (void)
{
	gboolean result;
	if (files_icon_info_reap_cache_timeout > ((guint) 0)) {
		g_source_remove (files_icon_info_reap_cache_timeout);
		files_icon_info_reap_cache_timeout = (guint) 0;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_files_icon_info_reap_cache_gsource_func (gpointer self)
{
	gboolean result;
	result = files_icon_info_reap_cache ();
	return result;
}

static void
files_icon_info_schedule_reap_cache (void)
{
	if (files_icon_info_reap_cache_timeout == ((guint) 0)) {
		files_icon_info_reap_cache_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, files_icon_info_reap_time, _files_icon_info_reap_cache_gsource_func, NULL, NULL);
	}
}

void
files_icon_info_set_reap_time (guint milliseconds)
{
	gboolean _tmp0_ = FALSE;
	if (milliseconds > ((guint) 10)) {
		_tmp0_ = milliseconds < ((guint) 100000);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		files_icon_info_reap_time = milliseconds;
		if (files_icon_info_end_reap_cache_timeout ()) {
			files_icon_info_schedule_reap_cache ();
		}
	}
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		g_slice_free (Block15Data, _data15_);
	}
}

static gboolean
___lambda5_ (Block15Data* _data15_,
             FilesIconInfoLoadableIconKey* loadableicon,
             FilesIconInfo* icon_info)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	gboolean result;
	g_return_val_if_fail (loadableicon != NULL, FALSE);
	g_return_val_if_fail (icon_info != NULL, FALSE);
	_tmp1_ = icon_info->priv->_pixbuf;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = icon_info->priv->_pixbuf;
		_tmp0_ = ((GObject*) _tmp2_)->ref_count == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if ((_data15_->time_now - icon_info->priv->last_use_time) > ((gint64) _data15_->reap_time_extended)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda5__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = ___lambda5_ (self, (FilesIconInfoLoadableIconKey*) key, (FilesIconInfo*) value);
	return result;
}

static gboolean
___lambda6_ (Block15Data* _data15_,
             FilesIconInfoThemedIconKey* themedicon,
             FilesIconInfo* icon_info)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	gboolean result;
	g_return_val_if_fail (themedicon != NULL, FALSE);
	g_return_val_if_fail (icon_info != NULL, FALSE);
	_tmp1_ = icon_info->priv->_pixbuf;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = icon_info->priv->_pixbuf;
		_tmp0_ = ((GObject*) _tmp2_)->ref_count == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if ((_data15_->time_now - icon_info->priv->last_use_time) > ((gint64) _data15_->reap_time_extended)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda6__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self, (FilesIconInfoThemedIconKey*) key, (FilesIconInfo*) value);
	return result;
}

static gboolean
files_icon_info_reap_cache (void)
{
	Block15Data* _data15_;
	gboolean reapable_icons_left = FALSE;
	GHashTable* _tmp0_;
	GHashTable* _tmp3_;
	gboolean result;
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	reapable_icons_left = FALSE;
	_data15_->time_now = g_get_monotonic_time ();
	_data15_->reap_time_extended = files_icon_info_reap_time * 6;
	_tmp0_ = files_icon_info_loadable_icon_cache;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		GHashTable* _tmp2_;
		_tmp1_ = files_icon_info_loadable_icon_cache;
		g_hash_table_foreach_remove (_tmp1_, ____lambda5__ghr_func, _data15_);
		_tmp2_ = files_icon_info_loadable_icon_cache;
		reapable_icons_left |= g_hash_table_size (_tmp2_) > ((guint) 0);
	}
	_tmp3_ = files_icon_info_themed_icon_cache;
	if (_tmp3_ != NULL) {
		GHashTable* _tmp4_;
		GHashTable* _tmp5_;
		_tmp4_ = files_icon_info_themed_icon_cache;
		g_hash_table_foreach_remove (_tmp4_, ____lambda6__ghr_func, _data15_);
		_tmp5_ = files_icon_info_themed_icon_cache;
		reapable_icons_left |= g_hash_table_size (_tmp5_) > ((guint) 0);
	}
	if (reapable_icons_left) {
		result = G_SOURCE_CONTINUE;
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return result;
	} else {
		files_icon_info_reap_cache_timeout = (guint) 0;
		result = G_SOURCE_REMOVE;
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return result;
	}
}

void
files_icon_info_clear_caches (void)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	_tmp0_ = files_icon_info_loadable_icon_cache;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = files_icon_info_loadable_icon_cache;
		g_hash_table_remove_all (_tmp1_);
	}
	_tmp2_ = files_icon_info_themed_icon_cache;
	if (_tmp2_ != NULL) {
		GHashTable* _tmp3_;
		_tmp3_ = files_icon_info_themed_icon_cache;
		g_hash_table_remove_all (_tmp3_);
	}
}

FilesIconInfo*
files_icon_info_construct (GType object_type)
{
	FilesIconInfo * self = NULL;
	self = (FilesIconInfo*) g_object_new (object_type, NULL);
	return self;
}

FilesIconInfo*
files_icon_info_new (void)
{
	return files_icon_info_construct (FILES_TYPE_ICON_INFO);
}

GdkPixbuf*
files_icon_info_get_pixbuf (FilesIconInfo* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

void
files_icon_info_set_pixbuf (FilesIconInfo* self,
                            GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_icon_info_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_icon_info_properties[FILES_ICON_INFO_PIXBUF_PROPERTY]);
	}
}

static FilesIconInfoLoadableIconKey*
files_icon_info_loadable_icon_key_new (GIcon* _icon,
                                       gint _size,
                                       gint _scale)
{
	FilesIconInfoLoadableIconKey* self;
	GIcon* _tmp0_;
	g_return_val_if_fail (_icon != NULL, NULL);
	self = g_slice_new0 (FilesIconInfoLoadableIconKey);
	files_icon_info_loadable_icon_key_instance_init (self);
	_tmp0_ = _g_object_ref0 (_icon);
	_g_object_unref0 (self->icon);
	self->icon = _tmp0_;
	self->size = _size;
	self->scale = _scale;
	return self;
}

static FilesIconInfoLoadableIconKey*
files_icon_info_loadable_icon_key_new_from_path (const gchar* path,
                                                 gint _size,
                                                 gint _scale)
{
	FilesIconInfoLoadableIconKey* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileIcon* _tmp2_;
	g_return_val_if_fail (path != NULL, NULL);
	self = g_slice_new0 (FilesIconInfoLoadableIconKey);
	files_icon_info_loadable_icon_key_instance_init (self);
	_tmp0_ = g_file_new_for_path (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GFileIcon*) g_file_icon_new (_tmp1_);
	_g_object_unref0 (self->icon);
	self->icon = (GIcon*) _tmp2_;
	_g_object_unref0 (_tmp1_);
	self->size = _size;
	self->scale = _scale;
	return self;
}

static guint
files_icon_info_loadable_icon_key_hash (FilesIconInfoLoadableIconKey* a)
{
	GIcon* _tmp0_;
	guint result;
	g_return_val_if_fail (a != NULL, 0U);
	_tmp0_ = a->icon;
	result = g_icon_hash (_tmp0_) ^ a->size;
	return result;
}

static gboolean
files_icon_info_loadable_icon_key_equal (FilesIconInfoLoadableIconKey* a,
                                         FilesIconInfoLoadableIconKey* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	if (a->size == b->size) {
		_tmp1_ = a->scale == b->scale;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GIcon* _tmp2_;
		GIcon* _tmp3_;
		_tmp2_ = a->icon;
		_tmp3_ = b->icon;
		_tmp0_ = g_icon_equal (_tmp2_, _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
files_icon_info_loadable_icon_key_instance_init (FilesIconInfoLoadableIconKey * self)
{
}

static void
files_icon_info_loadable_icon_key_free (FilesIconInfoLoadableIconKey * self)
{
	_g_object_unref0 (self->icon);
	g_slice_free (FilesIconInfoLoadableIconKey, self);
}

static FilesIconInfoThemedIconKey*
files_icon_info_themed_icon_key_new (GThemedIcon* _icon,
                                     gint _size,
                                     gint _scale)
{
	FilesIconInfoThemedIconKey* self;
	GThemedIcon* _tmp0_;
	g_return_val_if_fail (_icon != NULL, NULL);
	self = g_slice_new0 (FilesIconInfoThemedIconKey);
	files_icon_info_themed_icon_key_instance_init (self);
	_tmp0_ = _g_object_ref0 (_icon);
	_g_object_unref0 (self->icon);
	self->icon = _tmp0_;
	self->size = _size;
	self->scale = _scale;
	return self;
}

static void
files_icon_info_themed_icon_key_instance_init (FilesIconInfoThemedIconKey * self)
{
}

static void
files_icon_info_themed_icon_key_free (FilesIconInfoThemedIconKey * self)
{
	_g_object_unref0 (self->icon);
	g_slice_free (FilesIconInfoThemedIconKey, self);
}

static GObject *
files_icon_info_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesIconInfo * self;
	parent_class = G_OBJECT_CLASS (files_icon_info_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_ICON_INFO, FilesIconInfo);
	self->priv->last_use_time = g_get_monotonic_time ();
	files_icon_info_schedule_reap_cache ();
	files_icon_info_set_pixbuf (self, NULL);
	return obj;
}

static void
files_icon_info_class_init (FilesIconInfoClass * klass,
                            gpointer klass_data)
{
	files_icon_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesIconInfo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_icon_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_icon_info_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_icon_info_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_icon_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_ICON_INFO_PIXBUF_PROPERTY, files_icon_info_properties[FILES_ICON_INFO_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_icon_info_instance_init (FilesIconInfo * self,
                               gpointer klass)
{
	self->priv = files_icon_info_get_instance_private (self);
}

static void
files_icon_info_finalize (GObject * obj)
{
	FilesIconInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_ICON_INFO, FilesIconInfo);
	_g_object_unref0 (self->priv->_pixbuf);
	_g_free0 (self->priv->icon_name);
	G_OBJECT_CLASS (files_icon_info_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_icon_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesIconInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_icon_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesIconInfo), 0, (GInstanceInitFunc) files_icon_info_instance_init, NULL };
	GType files_icon_info_type_id;
	files_icon_info_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesIconInfo", &g_define_type_info, 0);
	FilesIconInfo_private_offset = g_type_add_instance_private (files_icon_info_type_id, sizeof (FilesIconInfoPrivate));
	return files_icon_info_type_id;
}

GType
files_icon_info_get_type (void)
{
	static volatile gsize files_icon_info_type_id__once = 0;
	if (g_once_init_enter (&files_icon_info_type_id__once)) {
		GType files_icon_info_type_id;
		files_icon_info_type_id = files_icon_info_get_type_once ();
		g_once_init_leave (&files_icon_info_type_id__once, files_icon_info_type_id);
	}
	return files_icon_info_type_id__once;
}

static void
_vala_files_icon_info_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	FilesIconInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_ICON_INFO, FilesIconInfo);
	switch (property_id) {
		case FILES_ICON_INFO_PIXBUF_PROPERTY:
		g_value_set_object (value, files_icon_info_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_icon_info_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	FilesIconInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_ICON_INFO, FilesIconInfo);
	switch (property_id) {
		case FILES_ICON_INFO_PIXBUF_PROPERTY:
		files_icon_info_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

