/* CloneRepositoryDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CloneRepositoryDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2025 elementary, Inc. <https://elementary.io>
 *
 * Authored by: Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <granite.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_NAME_REGEX "^[0-9a-zA-Z].([-_.]?[0-9a-zA-Z])*$"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG (scratch_dialogs_clone_repository_dialog_get_type ())
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialog))
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialogClass))
#define SCRATCH_DIALOGS_IS_CLONE_REPOSITORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG))
#define SCRATCH_DIALOGS_IS_CLONE_REPOSITORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG))
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialogClass))

typedef struct _ScratchDialogsCloneRepositoryDialog ScratchDialogsCloneRepositoryDialog;
typedef struct _ScratchDialogsCloneRepositoryDialogClass ScratchDialogsCloneRepositoryDialogClass;
typedef struct _ScratchDialogsCloneRepositoryDialogPrivate ScratchDialogsCloneRepositoryDialogPrivate;
enum  {
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_0_PROPERTY,
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CAN_CLONE_PROPERTY,
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_LOCAL_FOLDER_PROPERTY,
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_REMOTE_PROPERTY,
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONING_IN_PROGRESS_PROPERTY,
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY (scratch_dialogs_clone_repository_dialog_clone_entry_get_type ())
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY, ScratchDialogsCloneRepositoryDialogCloneEntry))
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY, ScratchDialogsCloneRepositoryDialogCloneEntryClass))
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_IS_CLONE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY))
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_IS_CLONE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY))
#define SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY, ScratchDialogsCloneRepositoryDialogCloneEntryClass))

typedef struct _ScratchDialogsCloneRepositoryDialogCloneEntry ScratchDialogsCloneRepositoryDialogCloneEntry;
typedef struct _ScratchDialogsCloneRepositoryDialogCloneEntryClass ScratchDialogsCloneRepositoryDialogCloneEntryClass;
typedef struct _ScratchDialogsCloneRepositoryDialogCloneEntryPrivate ScratchDialogsCloneRepositoryDialogCloneEntryPrivate;
enum  {
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONE_ENTRY_0_PROPERTY,
	SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONE_ENTRY_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_clone_repository_dialog_clone_entry_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONE_ENTRY_NUM_PROPERTIES];
typedef struct _Block10Data Block10Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchDialogsCloneRepositoryDialog {
	GraniteMessageDialog parent_instance;
	ScratchDialogsCloneRepositoryDialogPrivate * priv;
};

struct _ScratchDialogsCloneRepositoryDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _ScratchDialogsCloneRepositoryDialogPrivate {
	GRegex* name_regex;
	GtkLabel* projects_folder_label;
	GraniteValidatedEntry* remote_repository_uri_entry;
	GraniteValidatedEntry* local_project_name_entry;
	GtkButton* clone_button;
	GtkStack* stack;
	GtkSpinner* spinner;
	gboolean _can_clone;
	gchar* _suggested_local_folder;
	gchar* _suggested_remote;
};

struct _ScratchDialogsCloneRepositoryDialogCloneEntry {
	GtkBox parent_instance;
	ScratchDialogsCloneRepositoryDialogCloneEntryPrivate * priv;
};

struct _ScratchDialogsCloneRepositoryDialogCloneEntryClass {
	GtkBoxClass parent_class;
};

struct _Block10Data {
	int _ref_count_;
	ScratchDialogsCloneRepositoryDialog* self;
	GtkFileChooserNative* chooser;
};

static gint ScratchDialogsCloneRepositoryDialog_private_offset;
static gpointer scratch_dialogs_clone_repository_dialog_parent_class = NULL;
static gpointer scratch_dialogs_clone_repository_dialog_clone_entry_parent_class = NULL;

VALA_EXTERN GType scratch_dialogs_clone_repository_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchDialogsCloneRepositoryDialog, g_object_unref)
VALA_EXTERN ScratchDialogsCloneRepositoryDialog* scratch_dialogs_clone_repository_dialog_new (const gchar* _suggested_local_folder,
                                                                                  const gchar* _suggested_remote);
VALA_EXTERN ScratchDialogsCloneRepositoryDialog* scratch_dialogs_clone_repository_dialog_construct (GType object_type,
                                                                                        const gchar* _suggested_local_folder,
                                                                                        const gchar* _suggested_remote);
VALA_EXTERN gchar* scratch_dialogs_clone_repository_dialog_get_projects_folder (ScratchDialogsCloneRepositoryDialog* self);
VALA_EXTERN gchar* scratch_dialogs_clone_repository_dialog_get_remote (ScratchDialogsCloneRepositoryDialog* self);
VALA_EXTERN const gchar* scratch_dialogs_clone_repository_dialog_get_suggested_remote (ScratchDialogsCloneRepositoryDialog* self);
VALA_EXTERN gchar* scratch_dialogs_clone_repository_dialog_get_valid_source_repository_uri (ScratchDialogsCloneRepositoryDialog* self);
VALA_EXTERN gboolean scratch_dialogs_clone_repository_dialog_get_can_clone (ScratchDialogsCloneRepositoryDialog* self);
VALA_EXTERN gchar* scratch_dialogs_clone_repository_dialog_get_valid_target (ScratchDialogsCloneRepositoryDialog* self);
static void scratch_dialogs_clone_repository_dialog_update_can_clone (ScratchDialogsCloneRepositoryDialog* self);
static void scratch_dialogs_clone_repository_dialog_set_can_clone (ScratchDialogsCloneRepositoryDialog* self,
                                                            gboolean value);
static void scratch_dialogs_clone_repository_dialog_on_remote_uri_changed (ScratchDialogsCloneRepositoryDialog* self,
                                                                    GtkEditable* source);
static gboolean scratch_dialogs_clone_repository_dialog_validate_https_address (ScratchDialogsCloneRepositoryDialog* self,
                                                                         const gchar* address);
static void scratch_dialogs_clone_repository_dialog_validate_local_name (ScratchDialogsCloneRepositoryDialog* self);
VALA_EXTERN const gchar* scratch_dialogs_clone_repository_dialog_get_suggested_local_folder (ScratchDialogsCloneRepositoryDialog* self);
static void scratch_dialogs_clone_repository_dialog_set_suggested_local_folder (ScratchDialogsCloneRepositoryDialog* self,
                                                                         const gchar* value);
static void scratch_dialogs_clone_repository_dialog_set_suggested_remote (ScratchDialogsCloneRepositoryDialog* self,
                                                                   const gchar* value);
VALA_EXTERN void scratch_dialogs_clone_repository_dialog_set_cloning_in_progress (ScratchDialogsCloneRepositoryDialog* self,
                                                                      gboolean value);
static GType scratch_dialogs_clone_repository_dialog_clone_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchDialogsCloneRepositoryDialogCloneEntry, g_object_unref)
static ScratchDialogsCloneRepositoryDialogCloneEntry* scratch_dialogs_clone_repository_dialog_clone_entry_new (const gchar* label_text,
                                                                                                        GtkWidget* entry);
static ScratchDialogsCloneRepositoryDialogCloneEntry* scratch_dialogs_clone_repository_dialog_clone_entry_construct (GType object_type,
                                                                                                              const gchar* label_text,
                                                                                                              GtkWidget* entry);
static GObject * scratch_dialogs_clone_repository_dialog_clone_entry_constructor (GType type,
                                                                           guint n_construct_properties,
                                                                           GObjectConstructParam * construct_properties);
static GType scratch_dialogs_clone_repository_dialog_clone_entry_get_type_once (void);
static GObject * scratch_dialogs_clone_repository_dialog_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties);
static void _scratch_dialogs_clone_repository_dialog_on_remote_uri_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                          gpointer self);
static void _scratch_dialogs_clone_repository_dialog___lambda150_ (ScratchDialogsCloneRepositoryDialog* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda151_ (Block10Data* _data10_,
                   gint res);
static void ___lambda151__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                               gint response_id,
                                               gpointer self);
static void __scratch_dialogs_clone_repository_dialog___lambda150__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self);
static void _scratch_dialogs_clone_repository_dialog_validate_local_name_gtk_editable_changed (GtkEditable* _sender,
                                                                                        gpointer self);
static void scratch_dialogs_clone_repository_dialog_finalize (GObject * obj);
static GType scratch_dialogs_clone_repository_dialog_get_type_once (void);
static void _vala_scratch_dialogs_clone_repository_dialog_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_scratch_dialogs_clone_repository_dialog_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_dialogs_clone_repository_dialog_get_instance_private (ScratchDialogsCloneRepositoryDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchDialogsCloneRepositoryDialog_private_offset);
}

ScratchDialogsCloneRepositoryDialog*
scratch_dialogs_clone_repository_dialog_construct (GType object_type,
                                                   const gchar* _suggested_local_folder,
                                                   const gchar* _suggested_remote)
{
	ScratchDialogsCloneRepositoryDialog * self = NULL;
	g_return_val_if_fail (_suggested_local_folder != NULL, NULL);
	g_return_val_if_fail (_suggested_remote != NULL, NULL);
	self = (ScratchDialogsCloneRepositoryDialog*) g_object_new (object_type, "suggested-local-folder", _suggested_local_folder, "suggested-remote", _suggested_remote, NULL);
	return self;
}

ScratchDialogsCloneRepositoryDialog*
scratch_dialogs_clone_repository_dialog_new (const gchar* _suggested_local_folder,
                                             const gchar* _suggested_remote)
{
	return scratch_dialogs_clone_repository_dialog_construct (SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, _suggested_local_folder, _suggested_remote);
}

gchar*
scratch_dialogs_clone_repository_dialog_get_projects_folder (ScratchDialogsCloneRepositoryDialog* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->projects_folder_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
scratch_dialogs_clone_repository_dialog_get_remote (ScratchDialogsCloneRepositoryDialog* self)
{
	GraniteValidatedEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->remote_repository_uri_entry;
	_tmp1_ = granite_validated_entry_get_is_valid (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gchar* uri = NULL;
		GraniteValidatedEntry* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gint last_separator = 0;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = self->priv->remote_repository_uri_entry;
		_tmp4_ = gtk_entry_get_text ((GtkEntry*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		uri = _tmp6_;
		_tmp7_ = uri;
		last_separator = string_last_index_of (_tmp7_, G_DIR_SEPARATOR_S, 0);
		_tmp8_ = uri;
		_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) (last_separator + 1));
		result = _tmp9_;
		_g_free0 (uri);
		return result;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->priv->_suggested_remote;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
}

gchar*
scratch_dialogs_clone_repository_dialog_get_valid_source_repository_uri (ScratchDialogsCloneRepositoryDialog* self)
{
	gboolean _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_can_clone;
	_vala_return_val_if_fail (_tmp0_, "can_clone", NULL);
	_tmp1_ = self->priv->remote_repository_uri_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}

gchar*
scratch_dialogs_clone_repository_dialog_get_valid_target (ScratchDialogsCloneRepositoryDialog* self)
{
	gboolean _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GraniteValidatedEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_can_clone;
	_vala_return_val_if_fail (_tmp0_, "can_clone", NULL);
	_tmp1_ = self->priv->projects_folder_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->local_project_name_entry;
	_tmp5_ = gtk_entry_get_text ((GtkEntry*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (G_DIR_SEPARATOR_S, _tmp3_, _tmp6_, NULL);
	result = _tmp7_;
	return result;
}

static void
scratch_dialogs_clone_repository_dialog_update_can_clone (ScratchDialogsCloneRepositoryDialog* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GraniteValidatedEntry* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->remote_repository_uri_entry;
	_tmp3_ = granite_validated_entry_get_is_valid (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GraniteValidatedEntry* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->local_project_name_entry;
		_tmp6_ = granite_validated_entry_get_is_valid (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkLabel* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = self->priv->projects_folder_label;
		_tmp9_ = gtk_label_get_label (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	scratch_dialogs_clone_repository_dialog_set_can_clone (self, _tmp0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scratch_dialogs_clone_repository_dialog_on_remote_uri_changed (ScratchDialogsCloneRepositoryDialog* self,
                                                               GtkEditable* source)
{
	GraniteValidatedEntry* entry = NULL;
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, GRANITE_TYPE_VALIDATED_ENTRY, GraniteValidatedEntry));
	entry = _tmp0_;
	_tmp1_ = entry;
	_tmp2_ = granite_validated_entry_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GraniteValidatedEntry* _tmp4_;
		GraniteValidatedEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = entry;
		_tmp5_ = entry;
		_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
		_tmp7_ = _tmp6_;
		granite_validated_entry_set_is_valid (_tmp4_, scratch_dialogs_clone_repository_dialog_validate_https_address (self, _tmp7_));
	}
	scratch_dialogs_clone_repository_dialog_update_can_clone (self);
	_g_object_unref0 (entry);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
scratch_dialogs_clone_repository_dialog_validate_https_address (ScratchDialogsCloneRepositoryDialog* self,
                                                                const gchar* address)
{
	gboolean valid = FALSE;
	gchar* scheme = NULL;
	gchar* userinfo = NULL;
	gchar* host = NULL;
	gchar* path = NULL;
	gchar* query = NULL;
	gchar* fragment = NULL;
	gint port = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	valid = FALSE;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		g_uri_split (address, G_URI_FLAGS_NONE, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_inner_error0_);
		_g_free0 (scheme);
		scheme = _tmp0_;
		_g_free0 (userinfo);
		userinfo = _tmp1_;
		_g_free0 (host);
		host = _tmp2_;
		port = _tmp3_;
		_g_free0 (path);
		path = _tmp4_;
		_g_free0 (query);
		query = _tmp5_;
		_g_free0 (fragment);
		fragment = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error0_->domain == G_URI_ERROR) {
				goto __catch0_g_uri_error;
			}
			_g_free0 (fragment);
			_g_free0 (query);
			_g_free0 (path);
			_g_free0 (host);
			_g_free0 (userinfo);
			_g_free0 (scheme);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
		if (query == NULL) {
			_tmp12_ = fragment == NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = g_strcmp0 (scheme, "https") == 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = host != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = userinfo == NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gboolean _tmp13_ = FALSE;
			if (port < 0) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = port == 443;
			}
			_tmp8_ = _tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp14_;
			gchar** parts = NULL;
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint parts_length1;
			gint _parts_size_;
			gboolean _tmp20_ = FALSE;
			gchar** _tmp21_;
			gint _tmp21__length1;
			_tmp14_ = path;
			if (g_str_has_prefix (_tmp14_, G_DIR_SEPARATOR_S)) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = path;
				_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
				_g_free0 (path);
				path = _tmp16_;
			}
			_tmp17_ = path;
			_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, G_DIR_SEPARATOR_S, 0);
			parts = _tmp19_;
			parts_length1 = _vala_array_length (_tmp18_);
			_parts_size_ = parts_length1;
			_tmp21_ = parts;
			_tmp21__length1 = parts_length1;
			if (_tmp21__length1 == 2) {
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				_tmp22_ = parts;
				_tmp22__length1 = parts_length1;
				_tmp23_ = _tmp22_[1];
				_tmp20_ = g_str_has_suffix (_tmp23_, ".git");
			} else {
				_tmp20_ = FALSE;
			}
			valid = _tmp20_;
			if (valid) {
				GraniteValidatedEntry* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp24_ = self->priv->local_project_name_entry;
				_tmp25_ = parts;
				_tmp25__length1 = parts_length1;
				_tmp26_ = _tmp25_[1];
				_tmp27_ = string_slice (_tmp26_, (glong) 0, (glong) -4);
				_tmp28_ = _tmp27_;
				gtk_entry_set_text ((GtkEntry*) _tmp24_, _tmp28_);
				_g_free0 (_tmp28_);
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally0;
	__catch0_g_uri_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("CloneRepositoryDialog.vala:225: Uri split error %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp31_ = FALSE;
		_g_free0 (fragment);
		_g_free0 (query);
		_g_free0 (path);
		_g_free0 (host);
		_g_free0 (userinfo);
		_g_free0 (scheme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp31_;
	}
	result = valid;
	_g_free0 (fragment);
	_g_free0 (query);
	_g_free0 (path);
	_g_free0 (host);
	_g_free0 (userinfo);
	_g_free0 (scheme);
	return result;
}

static void
scratch_dialogs_clone_repository_dialog_validate_local_name (ScratchDialogsCloneRepositoryDialog* self)
{
	const gchar* name = NULL;
	GraniteValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GMatchInfo* match_info = NULL;
	gboolean valid = FALSE;
	gboolean _tmp3_ = FALSE;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	GraniteValidatedEntry* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->local_project_name_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	name = _tmp2_;
	valid = FALSE;
	_tmp4_ = self->priv->name_regex;
	_tmp5_ = name;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, G_REGEX_MATCH_ANCHORED | G_REGEX_MATCH_NOTEMPTY, &_tmp6_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp6_;
	if (_tmp7_) {
		GMatchInfo* _tmp8_;
		_tmp8_ = match_info;
		_tmp3_ = g_match_info_matches (_tmp8_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp10_ = name;
		if (!g_str_has_suffix (_tmp10_, ".git")) {
			const gchar* _tmp11_;
			_tmp11_ = name;
			_tmp9_ = !g_str_has_suffix (_tmp11_, ".atom");
		} else {
			_tmp9_ = FALSE;
		}
		valid = _tmp9_;
	}
	_tmp12_ = self->priv->local_project_name_entry;
	granite_validated_entry_set_is_valid (_tmp12_, valid);
	scratch_dialogs_clone_repository_dialog_update_can_clone (self);
	_g_match_info_unref0 (match_info);
}

gboolean
scratch_dialogs_clone_repository_dialog_get_can_clone (ScratchDialogsCloneRepositoryDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_clone;
	return result;
}

static void
scratch_dialogs_clone_repository_dialog_set_can_clone (ScratchDialogsCloneRepositoryDialog* self,
                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_clone_repository_dialog_get_can_clone (self);
	if (old_value != value) {
		self->priv->_can_clone = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CAN_CLONE_PROPERTY]);
	}
}

const gchar*
scratch_dialogs_clone_repository_dialog_get_suggested_local_folder (ScratchDialogsCloneRepositoryDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_suggested_local_folder;
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_clone_repository_dialog_set_suggested_local_folder (ScratchDialogsCloneRepositoryDialog* self,
                                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_clone_repository_dialog_get_suggested_local_folder (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_suggested_local_folder);
		self->priv->_suggested_local_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_LOCAL_FOLDER_PROPERTY]);
	}
}

const gchar*
scratch_dialogs_clone_repository_dialog_get_suggested_remote (ScratchDialogsCloneRepositoryDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_suggested_remote;
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_clone_repository_dialog_set_suggested_remote (ScratchDialogsCloneRepositoryDialog* self,
                                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_clone_repository_dialog_get_suggested_remote (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_suggested_remote);
		self->priv->_suggested_remote = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_REMOTE_PROPERTY]);
	}
}

void
scratch_dialogs_clone_repository_dialog_set_cloning_in_progress (ScratchDialogsCloneRepositoryDialog* self,
                                                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkStack* _tmp0_;
		GtkSpinner* _tmp1_;
		_tmp0_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp0_, "cloning");
		_tmp1_ = self->priv->spinner;
		gtk_spinner_start (_tmp1_);
	} else {
		GtkStack* _tmp2_;
		GtkSpinner* _tmp3_;
		_tmp2_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp2_, "entries");
		_tmp3_ = self->priv->spinner;
		gtk_spinner_stop (_tmp3_);
	}
	g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONING_IN_PROGRESS_PROPERTY]);
}

static ScratchDialogsCloneRepositoryDialogCloneEntry*
scratch_dialogs_clone_repository_dialog_clone_entry_construct (GType object_type,
                                                               const gchar* label_text,
                                                               GtkWidget* entry)
{
	ScratchDialogsCloneRepositoryDialogCloneEntry * self = NULL;
	GraniteHeaderLabel* label = NULL;
	GtkWidget* _tmp0_;
	GraniteHeaderLabel* _tmp1_ = NULL;
	g_return_val_if_fail (label_text != NULL, NULL);
	g_return_val_if_fail (entry != NULL, NULL);
	self = (ScratchDialogsCloneRepositoryDialogCloneEntry*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (entry);
	_tmp1_ = granite_header_label_new (label_text);
	gtk_label_set_mnemonic_widget ((GtkLabel*) _tmp1_, _tmp0_);
	_g_object_unref0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) self, entry);
	_g_object_unref0 (label);
	return self;
}

static ScratchDialogsCloneRepositoryDialogCloneEntry*
scratch_dialogs_clone_repository_dialog_clone_entry_new (const gchar* label_text,
                                                         GtkWidget* entry)
{
	return scratch_dialogs_clone_repository_dialog_clone_entry_construct (SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY, label_text, entry);
}

static GObject *
scratch_dialogs_clone_repository_dialog_clone_entry_constructor (GType type,
                                                                 guint n_construct_properties,
                                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchDialogsCloneRepositoryDialogCloneEntry * self;
	parent_class = G_OBJECT_CLASS (scratch_dialogs_clone_repository_dialog_clone_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_TYPE_CLONE_ENTRY, ScratchDialogsCloneRepositoryDialogCloneEntry);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	return obj;
}

static void
scratch_dialogs_clone_repository_dialog_clone_entry_class_init (ScratchDialogsCloneRepositoryDialogCloneEntryClass * klass,
                                                                gpointer klass_data)
{
	scratch_dialogs_clone_repository_dialog_clone_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = scratch_dialogs_clone_repository_dialog_clone_entry_constructor;
}

static void
scratch_dialogs_clone_repository_dialog_clone_entry_instance_init (ScratchDialogsCloneRepositoryDialogCloneEntry * self,
                                                                   gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
scratch_dialogs_clone_repository_dialog_clone_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsCloneRepositoryDialogCloneEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_clone_repository_dialog_clone_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsCloneRepositoryDialogCloneEntry), 0, (GInstanceInitFunc) scratch_dialogs_clone_repository_dialog_clone_entry_instance_init, NULL };
	GType scratch_dialogs_clone_repository_dialog_clone_entry_type_id;
	scratch_dialogs_clone_repository_dialog_clone_entry_type_id = g_type_register_static (gtk_box_get_type (), "ScratchDialogsCloneRepositoryDialogCloneEntry", &g_define_type_info, 0);
	return scratch_dialogs_clone_repository_dialog_clone_entry_type_id;
}

static GType
scratch_dialogs_clone_repository_dialog_clone_entry_get_type (void)
{
	static gsize scratch_dialogs_clone_repository_dialog_clone_entry_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_clone_repository_dialog_clone_entry_type_id__once)) {
		GType scratch_dialogs_clone_repository_dialog_clone_entry_type_id;
		scratch_dialogs_clone_repository_dialog_clone_entry_type_id = scratch_dialogs_clone_repository_dialog_clone_entry_get_type_once ();
		g_once_init_leave (&scratch_dialogs_clone_repository_dialog_clone_entry_type_id__once, scratch_dialogs_clone_repository_dialog_clone_entry_type_id);
	}
	return scratch_dialogs_clone_repository_dialog_clone_entry_type_id__once;
}

static void
_scratch_dialogs_clone_repository_dialog_on_remote_uri_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                     gpointer self)
{
	scratch_dialogs_clone_repository_dialog_on_remote_uri_changed ((ScratchDialogsCloneRepositoryDialog*) self, _sender);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ScratchDialogsCloneRepositoryDialog* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda151_ (Block10Data* _data10_,
              gint res)
{
	ScratchDialogsCloneRepositoryDialog* self;
	GtkFileChooserNative* _tmp4_;
	self = _data10_->self;
	if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkLabel* _tmp0_;
		GtkFileChooserNative* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->projects_folder_label;
		_tmp1_ = _data10_->chooser;
		_tmp2_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp1_);
		_tmp3_ = _tmp2_;
		gtk_label_set_label (_tmp0_, _tmp3_);
		_g_free0 (_tmp3_);
		scratch_dialogs_clone_repository_dialog_update_can_clone (self);
	}
	_tmp4_ = _data10_->chooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp4_);
}

static void
___lambda151__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                          gint response_id,
                                          gpointer self)
{
	__lambda151_ (self, response_id);
}

static void
_scratch_dialogs_clone_repository_dialog___lambda150_ (ScratchDialogsCloneRepositoryDialog* self)
{
	Block10Data* _data10_;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_file_chooser_native_new (_ ("Select folder where the cloned repository will be created"), _tmp1_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, _ ("Select"), _ ("Cancel"));
	_data10_->chooser = _tmp2_;
	_tmp3_ = _data10_->chooser;
	_tmp4_ = self->priv->projects_folder_label;
	_tmp5_ = gtk_label_get_label (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp3_, _tmp6_);
	_tmp7_ = _data10_->chooser;
	g_signal_connect_data ((GtkNativeDialog*) _tmp7_, "response", (GCallback) ___lambda151__gtk_native_dialog_response, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp8_ = _data10_->chooser;
	gtk_native_dialog_show ((GtkNativeDialog*) _tmp8_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
__scratch_dialogs_clone_repository_dialog___lambda150__gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self)
{
	_scratch_dialogs_clone_repository_dialog___lambda150_ ((ScratchDialogsCloneRepositoryDialog*) self);
}

static void
_scratch_dialogs_clone_repository_dialog_validate_local_name_gtk_editable_changed (GtkEditable* _sender,
                                                                                   gpointer self)
{
	scratch_dialogs_clone_repository_dialog_validate_local_name ((ScratchDialogsCloneRepositoryDialog*) self);
}

static GObject *
scratch_dialogs_clone_repository_dialog_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchDialogsCloneRepositoryDialog * self;
	GApplication* _tmp0_;
	GtkWindow* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	GThemedIcon* _tmp4_;
	GThemedIcon* _tmp5_;
	GtkWidget* cancel_button = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	gchar* _tmp16_;
	GraniteValidatedEntry* _tmp17_ = NULL;
	GraniteValidatedEntry* _tmp18_;
	GraniteValidatedEntry* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GtkLabel* _tmp22_ = NULL;
	GtkBox* folder_chooser_button_child = NULL;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GtkImage* _tmp27_;
	GtkImage* _tmp28_;
	GtkButton* folder_chooser_button = NULL;
	GtkBox* _tmp29_;
	GtkWidget* _tmp30_;
	GtkButton* _tmp31_ = NULL;
	GtkButton* _tmp32_;
	GraniteValidatedEntry* _tmp33_ = NULL;
	GraniteValidatedEntry* _tmp34_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GraniteValidatedEntry* _tmp37_;
	ScratchDialogsCloneRepositoryDialogCloneEntry* _tmp38_;
	ScratchDialogsCloneRepositoryDialogCloneEntry* _tmp39_;
	GtkBox* _tmp40_;
	GtkButton* _tmp41_;
	ScratchDialogsCloneRepositoryDialogCloneEntry* _tmp42_;
	ScratchDialogsCloneRepositoryDialogCloneEntry* _tmp43_;
	GtkBox* _tmp44_;
	GraniteValidatedEntry* _tmp45_;
	ScratchDialogsCloneRepositoryDialogCloneEntry* _tmp46_;
	ScratchDialogsCloneRepositoryDialogCloneEntry* _tmp47_;
	GraniteHeaderLabel* cloning_label = NULL;
	GraniteHeaderLabel* _tmp48_;
	GtkSpinner* _tmp49_;
	GtkBox* cloning_box = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkBox* _tmp51_;
	GraniteHeaderLabel* _tmp52_;
	GtkBox* _tmp53_;
	GtkSpinner* _tmp54_;
	GtkStack* _tmp55_;
	GtkStack* _tmp56_;
	GtkBox* _tmp57_;
	GtkStack* _tmp58_;
	GtkBox* _tmp59_;
	GtkStack* _tmp60_;
	GtkBin* _tmp61_;
	GtkBin* _tmp62_;
	GtkStack* _tmp63_;
	GtkBin* _tmp64_;
	GtkBin* _tmp65_;
	GtkButton* _tmp66_;
	GtkSpinner* _tmp67_;
	GtkButton* _tmp68_;
	GtkSpinner* _tmp69_;
	GtkWidget* _tmp70_;
	GtkWidget* _tmp71_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (scratch_dialogs_clone_repository_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialog);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp1_);
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("git");
	_tmp3_ = _tmp2_;
	granite_message_dialog_set_image_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("emblem-downloads");
	_tmp5_ = _tmp4_;
	granite_message_dialog_set_badge_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	granite_message_dialog_set_primary_text ((GraniteMessageDialog*) self, _ ("Create a local clone of a Git repository"));
	granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _ ("The source repository and local folder must exist and have the require" \
"d read and write permissions"));
	_tmp6_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	cancel_button = _tmp7_;
	_tmp8_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Clone Repository"), (gint) GTK_RESPONSE_APPLY);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->clone_button);
	self->priv->clone_button = _tmp9_;
	_tmp10_ = self->priv->clone_button;
	gtk_window_set_default ((GtkWindow*) self, (GtkWidget*) _tmp10_);
	{
		GRegex* _tmp11_ = NULL;
		GRegex* _tmp12_;
		GRegex* _tmp13_;
		_tmp12_ = g_regex_new (SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_NAME_REGEX, G_REGEX_OPTIMIZE, G_REGEX_MATCH_ANCHORED | G_REGEX_MATCH_NOTEMPTY, &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_object_unref0 (cancel_button);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp13_ = _tmp11_;
		_tmp11_ = NULL;
		_g_regex_unref0 (self->priv->name_regex);
		self->priv->name_regex = _tmp13_;
		_g_regex_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("CloneRepositoryDialog.vala:65: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cancel_button);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp16_ = g_strdup (_ ("https://example.com/username/projectname.git"));
	_tmp17_ = granite_validated_entry_new ();
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp17_, _tmp16_);
	_g_free0 (_tmp16_);
	gtk_entry_set_input_purpose ((GtkEntry*) _tmp17_, GTK_INPUT_PURPOSE_URL);
	gtk_entry_set_activates_default ((GtkEntry*) _tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->remote_repository_uri_entry);
	self->priv->remote_repository_uri_entry = _tmp17_;
	_tmp18_ = self->priv->remote_repository_uri_entry;
	g_signal_connect_object ((GtkEditable*) _tmp18_, "changed", (GCallback) _scratch_dialogs_clone_repository_dialog_on_remote_uri_changed_gtk_editable_changed, self, 0);
	_tmp19_ = self->priv->remote_repository_uri_entry;
	_tmp20_ = self->priv->_suggested_remote;
	gtk_entry_set_text ((GtkEntry*) _tmp19_, _tmp20_);
	_tmp21_ = self->priv->_suggested_local_folder;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->projects_folder_label);
	self->priv->projects_folder_label = _tmp22_;
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp23_);
	folder_chooser_button_child = _tmp23_;
	_tmp24_ = folder_chooser_button_child;
	_tmp25_ = self->priv->projects_folder_label;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = folder_chooser_button_child;
	_tmp27_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-open-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = folder_chooser_button_child;
	_tmp30_ = _g_object_ref0 ((GtkWidget*) _tmp29_);
	_tmp31_ = (GtkButton*) gtk_button_new ();
	g_object_set ((GtkContainer*) _tmp31_, "child", _tmp30_, NULL);
	_g_object_unref0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	folder_chooser_button = _tmp31_;
	_tmp32_ = folder_chooser_button;
	g_signal_connect_object (_tmp32_, "clicked", (GCallback) __scratch_dialogs_clone_repository_dialog___lambda150__gtk_button_clicked, self, 0);
	_tmp33_ = granite_validated_entry_new ();
	gtk_entry_set_activates_default ((GtkEntry*) _tmp33_, TRUE);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->local_project_name_entry);
	self->priv->local_project_name_entry = _tmp33_;
	_tmp34_ = self->priv->local_project_name_entry;
	g_signal_connect_object ((GtkEditable*) _tmp34_, "changed", (GCallback) _scratch_dialogs_clone_repository_dialog_validate_local_name_gtk_editable_changed, self, 0);
	_tmp35_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp35_);
	content_box = _tmp35_;
	_tmp36_ = content_box;
	_tmp37_ = self->priv->remote_repository_uri_entry;
	_tmp38_ = scratch_dialogs_clone_repository_dialog_clone_entry_new (_ ("Repository URL"), (GtkWidget*) _tmp37_);
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = content_box;
	_tmp41_ = folder_chooser_button;
	_tmp42_ = scratch_dialogs_clone_repository_dialog_clone_entry_new (_ ("Location"), (GtkWidget*) _tmp41_);
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = content_box;
	_tmp45_ = self->priv->local_project_name_entry;
	_tmp46_ = scratch_dialogs_clone_repository_dialog_clone_entry_new (_ ("Name of Clone"), (GtkWidget*) _tmp45_);
	g_object_ref_sink (_tmp46_);
	_tmp47_ = _tmp46_;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp47_);
	_g_object_unref0 (_tmp47_);
	_tmp48_ = granite_header_label_new (_ ("Cloning in progress"));
	g_object_ref_sink (_tmp48_);
	cloning_label = _tmp48_;
	_tmp49_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp49_;
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_valign ((GtkWidget*) _tmp50_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp50_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp50_);
	cloning_box = _tmp50_;
	_tmp51_ = cloning_box;
	_tmp52_ = cloning_label;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = cloning_box;
	_tmp54_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp55_;
	_tmp56_ = self->priv->stack;
	_tmp57_ = content_box;
	gtk_stack_add_named (_tmp56_, (GtkWidget*) _tmp57_, "entries");
	_tmp58_ = self->priv->stack;
	_tmp59_ = cloning_box;
	gtk_stack_add_named (_tmp58_, (GtkWidget*) _tmp59_, "cloning");
	_tmp60_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp60_, "entries");
	_tmp61_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp62_ = _tmp61_;
	_tmp63_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp65_ = _tmp64_;
	gtk_widget_show_all ((GtkWidget*) _tmp65_);
	_tmp66_ = self->priv->clone_button;
	g_object_bind_property_with_closures ((GObject*) self, "can-clone", (GObject*) _tmp66_, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp67_ = self->priv->spinner;
	_tmp68_ = self->priv->clone_button;
	g_object_bind_property_with_closures ((GObject*) _tmp67_, "active", (GObject*) _tmp68_, "visible", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp69_ = self->priv->spinner;
	_tmp70_ = cancel_button;
	g_object_bind_property_with_closures ((GObject*) _tmp69_, "active", (GObject*) _tmp70_, "visible", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	scratch_dialogs_clone_repository_dialog_set_can_clone (self, FALSE);
	_tmp71_ = cancel_button;
	gtk_widget_grab_focus (_tmp71_);
	_g_object_unref0 (cloning_box);
	_g_object_unref0 (cloning_label);
	_g_object_unref0 (content_box);
	_g_object_unref0 (folder_chooser_button);
	_g_object_unref0 (folder_chooser_button_child);
	_g_object_unref0 (cancel_button);
	return obj;
}

static void
scratch_dialogs_clone_repository_dialog_class_init (ScratchDialogsCloneRepositoryDialogClass * klass,
                                                    gpointer klass_data)
{
	scratch_dialogs_clone_repository_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchDialogsCloneRepositoryDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_dialogs_clone_repository_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_dialogs_clone_repository_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_dialogs_clone_repository_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_dialogs_clone_repository_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CAN_CLONE_PROPERTY, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CAN_CLONE_PROPERTY] = g_param_spec_boolean ("can-clone", "can-clone", "can-clone", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_LOCAL_FOLDER_PROPERTY, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_LOCAL_FOLDER_PROPERTY] = g_param_spec_string ("suggested-local-folder", "suggested-local-folder", "suggested-local-folder", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_REMOTE_PROPERTY, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_REMOTE_PROPERTY] = g_param_spec_string ("suggested-remote", "suggested-remote", "suggested-remote", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONING_IN_PROGRESS_PROPERTY, scratch_dialogs_clone_repository_dialog_properties[SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONING_IN_PROGRESS_PROPERTY] = g_param_spec_boolean ("cloning-in-progress", "cloning-in-progress", "cloning-in-progress", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
scratch_dialogs_clone_repository_dialog_instance_init (ScratchDialogsCloneRepositoryDialog * self,
                                                       gpointer klass)
{
	self->priv = scratch_dialogs_clone_repository_dialog_get_instance_private (self);
	self->priv->_can_clone = FALSE;
}

static void
scratch_dialogs_clone_repository_dialog_finalize (GObject * obj)
{
	ScratchDialogsCloneRepositoryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialog);
	_g_regex_unref0 (self->priv->name_regex);
	_g_object_unref0 (self->priv->projects_folder_label);
	_g_object_unref0 (self->priv->remote_repository_uri_entry);
	_g_object_unref0 (self->priv->local_project_name_entry);
	_g_object_unref0 (self->priv->clone_button);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->spinner);
	_g_free0 (self->priv->_suggested_local_folder);
	_g_free0 (self->priv->_suggested_remote);
	G_OBJECT_CLASS (scratch_dialogs_clone_repository_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_dialogs_clone_repository_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsCloneRepositoryDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_clone_repository_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsCloneRepositoryDialog), 0, (GInstanceInitFunc) scratch_dialogs_clone_repository_dialog_instance_init, NULL };
	GType scratch_dialogs_clone_repository_dialog_type_id;
	scratch_dialogs_clone_repository_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "ScratchDialogsCloneRepositoryDialog", &g_define_type_info, 0);
	ScratchDialogsCloneRepositoryDialog_private_offset = g_type_add_instance_private (scratch_dialogs_clone_repository_dialog_type_id, sizeof (ScratchDialogsCloneRepositoryDialogPrivate));
	return scratch_dialogs_clone_repository_dialog_type_id;
}

GType
scratch_dialogs_clone_repository_dialog_get_type (void)
{
	static gsize scratch_dialogs_clone_repository_dialog_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_clone_repository_dialog_type_id__once)) {
		GType scratch_dialogs_clone_repository_dialog_type_id;
		scratch_dialogs_clone_repository_dialog_type_id = scratch_dialogs_clone_repository_dialog_get_type_once ();
		g_once_init_leave (&scratch_dialogs_clone_repository_dialog_type_id__once, scratch_dialogs_clone_repository_dialog_type_id);
	}
	return scratch_dialogs_clone_repository_dialog_type_id__once;
}

static void
_vala_scratch_dialogs_clone_repository_dialog_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	ScratchDialogsCloneRepositoryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialog);
	switch (property_id) {
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CAN_CLONE_PROPERTY:
		g_value_set_boolean (value, scratch_dialogs_clone_repository_dialog_get_can_clone (self));
		break;
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_LOCAL_FOLDER_PROPERTY:
		g_value_set_string (value, scratch_dialogs_clone_repository_dialog_get_suggested_local_folder (self));
		break;
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_REMOTE_PROPERTY:
		g_value_set_string (value, scratch_dialogs_clone_repository_dialog_get_suggested_remote (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_dialogs_clone_repository_dialog_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	ScratchDialogsCloneRepositoryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_TYPE_CLONE_REPOSITORY_DIALOG, ScratchDialogsCloneRepositoryDialog);
	switch (property_id) {
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CAN_CLONE_PROPERTY:
		scratch_dialogs_clone_repository_dialog_set_can_clone (self, g_value_get_boolean (value));
		break;
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_LOCAL_FOLDER_PROPERTY:
		scratch_dialogs_clone_repository_dialog_set_suggested_local_folder (self, g_value_get_string (value));
		break;
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_SUGGESTED_REMOTE_PROPERTY:
		scratch_dialogs_clone_repository_dialog_set_suggested_remote (self, g_value_get_string (value));
		break;
		case SCRATCH_DIALOGS_CLONE_REPOSITORY_DIALOG_CLONING_IN_PROGRESS_PROPERTY:
		scratch_dialogs_clone_repository_dialog_set_cloning_in_progress (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

