use crate::app::App;
use glib::subclass;
use gtk4::{CompositeTemplate, Switch, Widget, prelude::*, subclass::prelude::*};
use libadwaita::{EntryRow, PreferencesPage, subclass::prelude::*};

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate)]
    #[template(file = "data/resources/ui_templates/settings/share.blp")]
    pub struct SettingsSharePage {
        #[template_child]
        pub share_pocket_switch: TemplateChild<Switch>,
        #[template_child]
        pub share_instapaper_switch: TemplateChild<Switch>,
        #[template_child]
        pub share_mastodon_switch: TemplateChild<Switch>,
        #[template_child]
        pub share_reddit_switch: TemplateChild<Switch>,
        #[template_child]
        pub share_telegram_switch: TemplateChild<Switch>,

        #[template_child]
        pub share_custom_switch: TemplateChild<Switch>,
        #[template_child]
        pub share_custom_name_entry: TemplateChild<EntryRow>,
        #[template_child]
        pub share_custom_url_entry: TemplateChild<EntryRow>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for SettingsSharePage {
        const NAME: &'static str = "SettingsSharePage";
        type ParentType = PreferencesPage;
        type Type = super::SettingsSharePage;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
        }

        fn instance_init(obj: &subclass::InitializingObject<Self>) {
            obj.init_template();
        }
    }

    impl ObjectImpl for SettingsSharePage {
        fn constructed(&self) {
            let share_settings = App::default().settings().share();

            share_settings
                .bind_property("pocket-enabled", &*self.share_pocket_switch, "active")
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("instapaper-enabled", &*self.share_instapaper_switch, "active")
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("mastodon-enabled", &*self.share_mastodon_switch, "active")
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("reddit-enabled", &*self.share_reddit_switch, "active")
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("telegram-enabled", &*self.share_telegram_switch, "active")
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("custom-enabled", &*self.share_custom_switch, "active")
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("custom-enabled", &*self.share_custom_name_entry, "sensitive")
                .sync_create()
                .build();

            share_settings
                .bind_property("custom-enabled", &*self.share_custom_url_entry, "sensitive")
                .sync_create()
                .build();

            share_settings
                .bind_property("custom-name", &*self.share_custom_name_entry, "text")
                .transform_to(|_binding, text: Option<String>| Some(text.unwrap_or_default()))
                .transform_from(|_binding, text: String| Some(if text.is_empty() { None } else { Some(text) }))
                .bidirectional()
                .sync_create()
                .build();

            share_settings
                .bind_property("custom-url", &*self.share_custom_url_entry, "text")
                .transform_to(|_binding, text: Option<String>| Some(text.unwrap_or_default()))
                .transform_from(|_binding, text: String| Some(if text.is_empty() { None } else { Some(text) }))
                .bidirectional()
                .sync_create()
                .build();
        }
    }

    impl WidgetImpl for SettingsSharePage {}

    impl PreferencesPageImpl for SettingsSharePage {}
}

glib::wrapper! {
    pub struct SettingsSharePage(ObjectSubclass<imp::SettingsSharePage>)
        @extends Widget, PreferencesPage;
}

impl Default for SettingsSharePage {
    fn default() -> Self {
        glib::Object::new::<Self>()
    }
}
