use crate::gobject_models::GEnclosure;
use crate::i18n::i18n;
use glib::{Properties, subclass::*};
use gtk4::{CompositeTemplate, prelude::*, subclass::prelude::*};
use std::cell::RefCell;

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::VideoDropdownRow)]
    #[template(file = "data/resources/ui_templates/enclosures/video_dropdown_row.blp")]
    pub struct VideoDropdownRow {
        #[property(get, set)]
        pub model: RefCell<GEnclosure>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for VideoDropdownRow {
        const NAME: &'static str = "VideoDropdownRow";
        type ParentType = gtk4::Box;
        type Type = super::VideoDropdownRow;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
            klass.bind_template_callbacks();
        }

        fn instance_init(obj: &InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for VideoDropdownRow {}

    impl WidgetImpl for VideoDropdownRow {}

    impl BoxImpl for VideoDropdownRow {}

    #[gtk4::template_callbacks]
    impl VideoDropdownRow {
        #[template_callback]
        fn mime_icon_name(&self, is_audio: bool) -> &'static str {
            if is_audio {
                "folder-music-symbolic"
            } else {
                "video-x-generic-symbolic"
            }
        }

        #[template_callback]
        fn mime_title(&self, is_audio: bool) -> String {
            if is_audio { i18n("Audio") } else { i18n("Video") }
        }
    }
}

glib::wrapper! {
    pub struct VideoDropdownRow(ObjectSubclass<imp::VideoDropdownRow>)
        @extends gtk4::Widget, gtk4::Box;
}

impl Default for VideoDropdownRow {
    fn default() -> Self {
        glib::Object::new::<Self>()
    }
}
