use crate::main_window::MainWindow;
use glib::{Object, Properties, prelude::*, subclass::*};
use gtk4::{CompositeTemplate, Widget, subclass::prelude::*};
use libadwaita::{Dialog, prelude::*, subclass::prelude::*};
use std::cell::RefCell;

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::AddCategoryDialog)]
    #[template(file = "data/resources/ui_templates/add_dialog/category.blp")]
    pub struct AddCategoryDialog {
        #[property(get, set)]
        pub title: RefCell<String>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for AddCategoryDialog {
        const NAME: &'static str = "AddCategoryDialog";
        type ParentType = Dialog;
        type Type = super::AddCategoryDialog;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
            klass.bind_template_callbacks();
        }

        fn instance_init(obj: &InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for AddCategoryDialog {}

    impl WidgetImpl for AddCategoryDialog {}

    impl AdwDialogImpl for AddCategoryDialog {}

    #[gtk4::template_callbacks]
    impl AddCategoryDialog {
        #[template_callback]
        fn on_add_category_clicked(&self) {
            let title = self.title.borrow().to_string();

            if !title.is_empty() {
                let variant = title.to_variant();
                MainWindow::activate_action("add-category", Some(&variant));
                self.obj().close();
            }
        }

        #[template_callback]
        fn on_title_activated(&self) {
            if !self.title.borrow().is_empty() {
                self.on_add_category_clicked();
            }
        }

        #[template_callback]
        fn is_string_not_empty(&self, string: String) -> bool {
            !string.is_empty()
        }
    }
}

glib::wrapper! {
    pub struct AddCategoryDialog(ObjectSubclass<imp::AddCategoryDialog>)
        @extends Widget, Dialog;
}

impl Default for AddCategoryDialog {
    fn default() -> Self {
        Object::new::<Self>()
    }
}
