/* Layout.c generated by valac 0.56.18, the Vala compiler
 * generated from Layout.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;
typedef struct _LayoutPrivate LayoutPrivate;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_NODE_BOUNDS (node_bounds_get_type ())
#define NODE_BOUNDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BOUNDS, NodeBounds))
#define NODE_BOUNDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_BOUNDS, NodeBoundsClass))
#define IS_NODE_BOUNDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BOUNDS))
#define IS_NODE_BOUNDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_BOUNDS))
#define NODE_BOUNDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_BOUNDS, NodeBoundsClass))

typedef struct _NodeBounds NodeBounds;
typedef struct _NodeBoundsClass NodeBoundsClass;
enum  {
	LAYOUT_0_PROPERTY,
	LAYOUT_NAME_PROPERTY,
	LAYOUT_ICON_PROPERTY,
	LAYOUT_BALANCEABLE_PROPERTY,
	LAYOUT_NUM_PROPERTIES
};
static GParamSpec* layout_properties[LAYOUT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _node_bounds_unref0(var) ((var == NULL) ? NULL : (var = (node_bounds_unref (var), NULL)))

#define TYPE_SUMMARY_NODE (summary_node_get_type ())
#define SUMMARY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUMMARY_NODE, SummaryNode))
#define SUMMARY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUMMARY_NODE, SummaryNodeClass))
#define IS_SUMMARY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUMMARY_NODE))
#define IS_SUMMARY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUMMARY_NODE))
#define SUMMARY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUMMARY_NODE, SummaryNodeClass))

typedef struct _SummaryNode SummaryNode;
typedef struct _SummaryNodeClass SummaryNodeClass;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

struct _Layout {
	GObject parent_instance;
	LayoutPrivate * priv;
	gdouble _rt_gap;
};

struct _LayoutClass {
	GObjectClass parent_class;
	NodeSide (*side_mapping) (Layout* self, NodeSide side);
	void (*initialize) (Layout* self, Node* parent);
	NodeBounds* (*bbox) (Layout* self, Node* parent, gint side_mask, const gchar* msg);
	void (*adjust_tree) (Layout* self, Node* parent, gint child_index, gint side_mask, gdouble amount);
	void (*adjust_tree_all) (Layout* self, Node* n, NodeBounds* p, gdouble amount, const gchar* msg);
	void (*propagate_side) (Layout* self, Node* parent, NodeSide side);
	NodeSide (*get_side) (Layout* self, Node* n);
	void (*set_side) (Layout* self, Node* current);
	void (*handle_update_by_edit) (Layout* self, Node* n, gdouble diffw, gdouble diffh);
	void (*handle_update_by_fold) (Layout* self, Node* n);
	gdouble (*get_insert_adjust) (Layout* self, Node* child);
	void (*handle_update_by_insert) (Layout* self, Node* parent, Node* child, gint pos);
	void (*handle_update_by_delete) (Layout* self, Node* parent, gint index, NodeSide side, gdouble size);
	void (*position_root) (Layout* self, Node* last, Node* n);
};

struct _LayoutPrivate {
	gchar* _name;
	gchar* _icon;
	gboolean _balanceable;
};

struct _Block24Data {
	int _ref_count_;
	Layout* self;
	Node* parent;
};

static gint Layout_private_offset;
static gpointer layout_parent_class = NULL;

VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN gpointer node_bounds_ref (gpointer instance);
VALA_EXTERN void node_bounds_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_bounds (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_node_bounds (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_node_bounds (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_node_bounds (const GValue* value);
VALA_EXTERN GType node_bounds_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBounds, node_bounds_unref)
VALA_EXTERN NodeSide layout_side_mapping (Layout* self,
                              NodeSide side);
VALA_EXTERN void layout_initialize (Layout* self,
                        Node* parent);
VALA_EXTERN NodeBounds* layout_bbox (Layout* self,
                         Node* parent,
                         gint side_mask,
                         const gchar* msg);
VALA_EXTERN void layout_adjust_tree (Layout* self,
                         Node* parent,
                         gint child_index,
                         gint side_mask,
                         gdouble amount);
VALA_EXTERN void layout_adjust_tree_all (Layout* self,
                             Node* n,
                             NodeBounds* p,
                             gdouble amount,
                             const gchar* msg);
VALA_EXTERN void layout_propagate_side (Layout* self,
                            Node* parent,
                            NodeSide side);
VALA_EXTERN NodeSide layout_get_side (Layout* self,
                          Node* n);
VALA_EXTERN void layout_set_side (Layout* self,
                      Node* current);
VALA_EXTERN void layout_handle_update_by_edit (Layout* self,
                                   Node* n,
                                   gdouble diffw,
                                   gdouble diffh);
VALA_EXTERN void layout_handle_update_by_fold (Layout* self,
                                   Node* n);
VALA_EXTERN gdouble layout_get_insert_adjust (Layout* self,
                                  Node* child);
VALA_EXTERN void layout_handle_update_by_insert (Layout* self,
                                     Node* parent,
                                     Node* child,
                                     gint pos);
VALA_EXTERN void layout_handle_update_by_delete (Layout* self,
                                     Node* parent,
                                     gint index,
                                     NodeSide side,
                                     gdouble size);
VALA_EXTERN void layout_position_root (Layout* self,
                           Node* last,
                           Node* n);
VALA_EXTERN Layout* layout_new (void);
VALA_EXTERN Layout* layout_construct (GType object_type);
static NodeSide layout_real_side_mapping (Layout* self,
                                   NodeSide side);
static void layout_real_initialize (Layout* self,
                             Node* parent);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN void node_set_side (Node* self,
                    NodeSide value);
VALA_EXTERN gboolean node_traversable (Node* self);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gboolean node_is_summary (Node* self);
static void ___lambda131_ (Layout* self,
                    Node* item);
VALA_EXTERN void node_detach (Node* self,
                  NodeSide side);
static void ____lambda131__gfunc (gconstpointer data,
                           gpointer self);
static void ___lambda132_ (Block24Data* _data24_,
                    Node* item);
VALA_EXTERN void node_attach_init (Node* self,
                       Node* parent,
                       gint index);
static void ____lambda132__gfunc (gconstpointer data,
                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static NodeBounds* layout_real_bbox (Layout* self,
                              Node* parent,
                              gint side_mask,
                              const gchar* msg);
VALA_EXTERN void node_bbox (Node* self,
                gdouble* x,
                gdouble* y,
                gdouble* w,
                gdouble* h);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN DrawArea* node_get_da (Node* self);
VALA_EXTERN NodeBounds* node_bounds_new_with_bounds (DrawArea* da,
                                         gdouble x,
                                         gdouble y,
                                         gdouble w,
                                         gdouble h);
VALA_EXTERN NodeBounds* node_bounds_construct_with_bounds (GType object_type,
                                               DrawArea* da,
                                               gdouble x,
                                               gdouble y,
                                               gdouble w,
                                               gdouble h);
VALA_EXTERN gdouble node_bounds_get_x (NodeBounds* self);
VALA_EXTERN gdouble node_bounds_get_width (NodeBounds* self);
VALA_EXTERN gdouble node_bounds_get_y (NodeBounds* self);
VALA_EXTERN gdouble node_bounds_get_height (NodeBounds* self);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN gboolean node_is_summarized (Node* self);
VALA_EXTERN NodeBounds* node_get_tree_bbox (Node* self);
VALA_EXTERN void node_bounds_set_x (NodeBounds* self,
                        gdouble value);
VALA_EXTERN void node_bounds_set_y (NodeBounds* self,
                        gdouble value);
VALA_EXTERN GType summary_node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SummaryNode, g_object_unref)
VALA_EXTERN SummaryNode* node_summary_node (Node* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN gboolean node_first_summarized (Node* self);
VALA_EXTERN gboolean node_last_summarized (Node* self);
VALA_EXTERN gchar* node_bounds_to_string (NodeBounds* self);
VALA_EXTERN gboolean node_side_vertical (NodeSide self);
VALA_EXTERN gboolean node_side_horizontal (NodeSide self);
VALA_EXTERN void node_bounds_set_width (NodeBounds* self,
                            gdouble value);
VALA_EXTERN void node_bounds_set_height (NodeBounds* self,
                             gdouble value);
VALA_EXTERN void layout_update_tree_size (Layout* self,
                              Node* n);
VALA_EXTERN void node_set_tree_bbox (Node* self,
                         NodeBounds* value);
VALA_EXTERN void node_set_tree_size (Node* self,
                         gdouble value);
VALA_EXTERN gdouble layout_get_adjust (Layout* self,
                           Node* parent);
VALA_EXTERN void summary_node_get_extents (SummaryNode* self,
                               gdouble* xy1,
                               gdouble* xy2);
VALA_EXTERN gdouble node_get_tree_size (Node* self);
static void layout_real_adjust_tree (Layout* self,
                              Node* parent,
                              gint child_index,
                              gint side_mask,
                              gdouble amount);
VALA_EXTERN gdouble node_get_posy (Node* self);
VALA_EXTERN void node_set_posy (Node* self,
                    gdouble value);
VALA_EXTERN gdouble node_get_posx (Node* self);
VALA_EXTERN void node_set_posx (Node* self,
                    gdouble value);
static void layout_real_adjust_tree_all (Layout* self,
                                  Node* n,
                                  NodeBounds* p,
                                  gdouble amount,
                                  const gchar* msg);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN gint node_index (Node* self);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN NodeBounds* node_bounds_new_copy (NodeBounds* nb);
VALA_EXTERN NodeBounds* node_bounds_construct_copy (GType object_type,
                                        NodeBounds* nb);
VALA_EXTERN void node_bounds_copy_from (NodeBounds* self,
                            NodeBounds* nb);
VALA_EXTERN void draw_area_handle_tree_overlap (DrawArea* self,
                                    NodeBounds* prev);
static void layout_real_propagate_side (Layout* self,
                                 Node* parent,
                                 NodeSide side);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gint* style_get_branch_margin (Style* self);
static gint* _int_dup (gint* self);
static NodeSide layout_real_get_side (Layout* self,
                               Node* n);
VALA_EXTERN Node* node_get_root (Node* self);
static void layout_real_set_side (Layout* self,
                           Node* current);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN void layout_apply_margin (Layout* self,
                          Node* n);
VALA_EXTERN gdouble node_task_width (Node* self);
static void layout_real_handle_update_by_edit (Layout* self,
                                        Node* n,
                                        gdouble diffw,
                                        gdouble diffh);
VALA_EXTERN void node_adjust_posy_only (Node* self,
                            gdouble value);
VALA_EXTERN void node_adjust_posx_only (Node* self,
                            gdouble value);
static void layout_real_handle_update_by_fold (Layout* self,
                                        Node* n);
static gdouble layout_real_get_insert_adjust (Layout* self,
                                       Node* child);
static void layout_real_handle_update_by_insert (Layout* self,
                                          Node* parent,
                                          Node* child,
                                          gint pos);
VALA_EXTERN gint node_side_count (Node* self,
                      NodeSide side);
static void layout_real_handle_update_by_delete (Layout* self,
                                          Node* parent,
                                          gint index,
                                          NodeSide side,
                                          gdouble size);
static void layout_real_position_root (Layout* self,
                                Node* last,
                                Node* n);
VALA_EXTERN const gchar* layout_get_name (Layout* self);
VALA_EXTERN void layout_set_name (Layout* self,
                      const gchar* value);
VALA_EXTERN const gchar* layout_get_icon (Layout* self);
VALA_EXTERN void layout_set_icon (Layout* self,
                      const gchar* value);
VALA_EXTERN gboolean layout_get_balanceable (Layout* self);
VALA_EXTERN void layout_set_balanceable (Layout* self,
                             gboolean value);
static void layout_finalize (GObject * obj);
static GType layout_get_type_once (void);
static void _vala_layout_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_layout_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);

static inline gpointer
layout_get_instance_private (Layout* self)
{
	return G_STRUCT_MEMBER_P (self, Layout_private_offset);
}

Layout*
layout_construct (GType object_type)
{
	Layout * self = NULL;
	self = (Layout*) g_object_new (object_type, NULL);
	return self;
}

Layout*
layout_new (void)
{
	return layout_construct (TYPE_LAYOUT);
}

static NodeSide
layout_real_side_mapping (Layout* self,
                          NodeSide side)
{
	NodeSide result;
	switch (side) {
		case NODE_SIDE_LEFT:
		{
			result = NODE_SIDE_LEFT;
			return result;
		}
		case NODE_SIDE_RIGHT:
		{
			result = NODE_SIDE_RIGHT;
			return result;
		}
		case NODE_SIDE_TOP:
		{
			result = NODE_SIDE_LEFT;
			return result;
		}
		case NODE_SIDE_BOTTOM:
		{
			result = NODE_SIDE_RIGHT;
			return result;
		}
		default:
		break;
	}
	result = NODE_SIDE_RIGHT;
	return result;
}

NodeSide
layout_side_mapping (Layout* self,
                     NodeSide side)
{
	LayoutClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->side_mapping) {
		return _klass_->side_mapping (self, side);
	}
	return 0;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		Layout* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
___lambda131_ (Layout* self,
               Node* item)
{
	NodeSide _tmp0_;
	NodeSide _tmp1_;
	g_return_if_fail (item != NULL);
	_tmp0_ = node_get_side (item);
	_tmp1_ = _tmp0_;
	node_detach (item, _tmp1_);
}

static void
____lambda131__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda131_ ((Layout*) self, (Node*) data);
}

static void
___lambda132_ (Block24Data* _data24_,
               Node* item)
{
	Layout* self;
	self = _data24_->self;
	g_return_if_fail (item != NULL);
	node_attach_init (item, _data24_->parent, -1);
}

static void
____lambda132__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda132_ (self, (Node*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
layout_real_initialize (Layout* self,
                        Node* parent)
{
	Block24Data* _data24_;
	Node* _tmp0_;
	GSList* list = NULL;
	NodeSide _tmp1_;
	NodeSide _tmp2_;
	g_return_if_fail (parent != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data24_->parent);
	_data24_->parent = _tmp0_;
	list = NULL;
	_tmp1_ = node_get_side (_data24_->parent);
	_tmp2_ = _tmp1_;
	node_set_side (_data24_->parent, layout_side_mapping (self, _tmp2_));
	if (node_traversable (_data24_->parent)) {
		GSList* _tmp17_;
		GSList* _tmp18_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GArray* _tmp5_;
					GArray* _tmp6_;
					gboolean _tmp7_;
					Node* n = NULL;
					GArray* _tmp8_;
					GArray* _tmp9_;
					Node* _tmp10_;
					Node* _tmp11_;
					Node* _tmp12_;
					Node* _tmp13_;
					Node* _tmp14_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = node_children (_data24_->parent);
					_tmp6_ = _tmp5_;
					_tmp7_ = !(((guint) i) < _tmp6_->len);
					_g_array_unref0 (_tmp6_);
					if (_tmp7_) {
						break;
					}
					_tmp8_ = node_children (_data24_->parent);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_array_index (_tmp9_, Node*, (guint) i);
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_tmp12_ = _tmp11_;
					_g_array_unref0 (_tmp9_);
					n = _tmp12_;
					_tmp13_ = n;
					layout_initialize (self, _tmp13_);
					_tmp14_ = n;
					if (!node_is_summary (_tmp14_)) {
						Node* _tmp15_;
						Node* _tmp16_;
						_tmp15_ = n;
						_tmp16_ = _g_object_ref0 (_tmp15_);
						list = g_slist_append (list, _tmp16_);
					}
					_g_object_unref0 (n);
				}
			}
		}
		_tmp17_ = list;
		g_slist_foreach (_tmp17_, ____lambda131__gfunc, self);
		_tmp18_ = list;
		g_slist_foreach (_tmp18_, ____lambda132__gfunc, _data24_);
	}
	(list == NULL) ? NULL : (list = (_g_slist_free__g_object_unref0_ (list), NULL));
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

void
layout_initialize (Layout* self,
                   Node* parent)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->initialize) {
		_klass_->initialize (self, parent);
	}
}

static gpointer
_node_bounds_ref0 (gpointer self)
{
	return self ? node_bounds_ref (self) : NULL;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static NodeBounds*
layout_real_bbox (Layout* self,
                  Node* parent,
                  gint side_mask,
                  const gchar* msg)
{
	guint num_children = 0U;
	GArray* _tmp0_;
	GArray* _tmp1_;
	guint _tmp2_;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble pw = 0.0;
	gdouble ph = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NodeBounds* nb = NULL;
	DrawArea* _tmp7_;
	DrawArea* _tmp8_;
	NodeBounds* _tmp9_;
	gdouble x2 = 0.0;
	NodeBounds* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	NodeBounds* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble y2 = 0.0;
	NodeBounds* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	NodeBounds* _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	NodeBounds* _tmp186_;
	NodeBounds* _tmp187_;
	gdouble _tmp188_;
	gdouble _tmp189_;
	NodeBounds* _tmp190_;
	NodeBounds* _tmp191_;
	gdouble _tmp192_;
	gdouble _tmp193_;
	NodeBounds* result;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = node_children (parent);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->len;
	_g_array_unref0 (_tmp1_);
	num_children = _tmp2_;
	node_bbox (parent, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	px = _tmp3_;
	py = _tmp4_;
	pw = _tmp5_;
	ph = _tmp6_;
	_tmp7_ = node_get_da (parent);
	_tmp8_ = _tmp7_;
	_tmp9_ = node_bounds_new_with_bounds (_tmp8_, px, py, pw, ph);
	nb = _tmp9_;
	_tmp10_ = nb;
	_tmp11_ = node_bounds_get_x (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = nb;
	_tmp14_ = node_bounds_get_width (_tmp13_);
	_tmp15_ = _tmp14_;
	x2 = _tmp12_ + _tmp15_;
	_tmp16_ = nb;
	_tmp17_ = node_bounds_get_y (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = nb;
	_tmp20_ = node_bounds_get_height (_tmp19_);
	_tmp21_ = _tmp20_;
	y2 = _tmp18_ + _tmp21_;
	if (num_children != ((guint) 0)) {
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp24_ = node_get_folded (parent);
		_tmp25_ = _tmp24_;
		_tmp23_ = !_tmp25_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		_tmp22_ = !node_is_summarized (parent);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp26_ = FALSE;
				_tmp26_ = TRUE;
				while (TRUE) {
					GArray* _tmp28_;
					GArray* _tmp29_;
					gboolean _tmp30_;
					GArray* _tmp31_;
					GArray* _tmp32_;
					Node* _tmp33_;
					NodeSide _tmp34_;
					NodeSide _tmp35_;
					gboolean _tmp36_;
					if (!_tmp26_) {
						gint _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp26_ = FALSE;
					_tmp28_ = node_children (parent);
					_tmp29_ = _tmp28_;
					_tmp30_ = !(((guint) i) < _tmp29_->len);
					_g_array_unref0 (_tmp29_);
					if (_tmp30_) {
						break;
					}
					_tmp31_ = node_children (parent);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_array_index (_tmp32_, Node*, (guint) i);
					_tmp34_ = node_get_side (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = (_tmp35_ & side_mask) != 0;
					_g_array_unref0 (_tmp32_);
					if (_tmp36_) {
						NodeBounds* cb = NULL;
						GArray* _tmp37_;
						GArray* _tmp38_;
						Node* _tmp39_;
						NodeBounds* _tmp40_;
						NodeBounds* _tmp41_;
						NodeBounds* _tmp42_;
						NodeBounds* _tmp43_;
						gdouble _tmp44_ = 0.0;
						NodeBounds* _tmp45_;
						gdouble _tmp46_;
						gdouble _tmp47_;
						NodeBounds* _tmp48_;
						gdouble _tmp49_;
						gdouble _tmp50_;
						NodeBounds* _tmp57_;
						gdouble _tmp58_ = 0.0;
						NodeBounds* _tmp59_;
						gdouble _tmp60_;
						gdouble _tmp61_;
						NodeBounds* _tmp62_;
						gdouble _tmp63_;
						gdouble _tmp64_;
						NodeBounds* _tmp71_;
						gdouble _tmp72_ = 0.0;
						NodeBounds* _tmp73_;
						gdouble _tmp74_;
						gdouble _tmp75_;
						NodeBounds* _tmp76_;
						gdouble _tmp77_;
						gdouble _tmp78_;
						gdouble _tmp85_ = 0.0;
						NodeBounds* _tmp86_;
						gdouble _tmp87_;
						gdouble _tmp88_;
						NodeBounds* _tmp89_;
						gdouble _tmp90_;
						gdouble _tmp91_;
						_tmp37_ = node_children (parent);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_array_index (_tmp38_, Node*, (guint) i);
						_tmp40_ = node_get_tree_bbox (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = _node_bounds_ref0 (_tmp41_);
						_tmp43_ = _tmp42_;
						_g_array_unref0 (_tmp38_);
						cb = _tmp43_;
						_tmp45_ = nb;
						_tmp46_ = node_bounds_get_x (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = cb;
						_tmp49_ = node_bounds_get_x (_tmp48_);
						_tmp50_ = _tmp49_;
						if (_tmp47_ < _tmp50_) {
							NodeBounds* _tmp51_;
							gdouble _tmp52_;
							gdouble _tmp53_;
							_tmp51_ = nb;
							_tmp52_ = node_bounds_get_x (_tmp51_);
							_tmp53_ = _tmp52_;
							_tmp44_ = _tmp53_;
						} else {
							NodeBounds* _tmp54_;
							gdouble _tmp55_;
							gdouble _tmp56_;
							_tmp54_ = cb;
							_tmp55_ = node_bounds_get_x (_tmp54_);
							_tmp56_ = _tmp55_;
							_tmp44_ = _tmp56_;
						}
						_tmp57_ = nb;
						node_bounds_set_x (_tmp57_, _tmp44_);
						_tmp59_ = nb;
						_tmp60_ = node_bounds_get_y (_tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = cb;
						_tmp63_ = node_bounds_get_y (_tmp62_);
						_tmp64_ = _tmp63_;
						if (_tmp61_ < _tmp64_) {
							NodeBounds* _tmp65_;
							gdouble _tmp66_;
							gdouble _tmp67_;
							_tmp65_ = nb;
							_tmp66_ = node_bounds_get_y (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp58_ = _tmp67_;
						} else {
							NodeBounds* _tmp68_;
							gdouble _tmp69_;
							gdouble _tmp70_;
							_tmp68_ = cb;
							_tmp69_ = node_bounds_get_y (_tmp68_);
							_tmp70_ = _tmp69_;
							_tmp58_ = _tmp70_;
						}
						_tmp71_ = nb;
						node_bounds_set_y (_tmp71_, _tmp58_);
						_tmp73_ = cb;
						_tmp74_ = node_bounds_get_x (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp76_ = cb;
						_tmp77_ = node_bounds_get_width (_tmp76_);
						_tmp78_ = _tmp77_;
						if (x2 < (_tmp75_ + _tmp78_)) {
							NodeBounds* _tmp79_;
							gdouble _tmp80_;
							gdouble _tmp81_;
							NodeBounds* _tmp82_;
							gdouble _tmp83_;
							gdouble _tmp84_;
							_tmp79_ = cb;
							_tmp80_ = node_bounds_get_x (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp82_ = cb;
							_tmp83_ = node_bounds_get_width (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp72_ = _tmp81_ + _tmp84_;
						} else {
							_tmp72_ = x2;
						}
						x2 = _tmp72_;
						_tmp86_ = cb;
						_tmp87_ = node_bounds_get_y (_tmp86_);
						_tmp88_ = _tmp87_;
						_tmp89_ = cb;
						_tmp90_ = node_bounds_get_height (_tmp89_);
						_tmp91_ = _tmp90_;
						if (y2 < (_tmp88_ + _tmp91_)) {
							NodeBounds* _tmp92_;
							gdouble _tmp93_;
							gdouble _tmp94_;
							NodeBounds* _tmp95_;
							gdouble _tmp96_;
							gdouble _tmp97_;
							_tmp92_ = cb;
							_tmp93_ = node_bounds_get_y (_tmp92_);
							_tmp94_ = _tmp93_;
							_tmp95_ = cb;
							_tmp96_ = node_bounds_get_height (_tmp95_);
							_tmp97_ = _tmp96_;
							_tmp85_ = _tmp94_ + _tmp97_;
						} else {
							_tmp85_ = y2;
						}
						y2 = _tmp85_;
						_node_bounds_unref0 (cb);
					}
				}
			}
		}
	}
	if (node_is_summarized (parent)) {
		SummaryNode* summary = NULL;
		SummaryNode* _tmp98_;
		NodeBounds* sb = NULL;
		SummaryNode* _tmp99_;
		NodeBounds* _tmp100_;
		NodeBounds* _tmp101_;
		NodeBounds* _tmp102_;
		FILE* _tmp103_;
		CanvasText* _tmp104_;
		CanvasText* _tmp105_;
		FormattedText* _tmp106_;
		FormattedText* _tmp107_;
		const gchar* _tmp108_;
		const gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		NodeBounds* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		NodeBounds* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		_tmp98_ = node_summary_node (parent);
		summary = _tmp98_;
		_tmp99_ = summary;
		_tmp100_ = node_get_tree_bbox ((Node*) _tmp99_);
		_tmp101_ = _tmp100_;
		_tmp102_ = _node_bounds_ref0 (_tmp101_);
		sb = _tmp102_;
		_tmp103_ = stdout;
		_tmp104_ = node_get_name (parent);
		_tmp105_ = _tmp104_;
		_tmp106_ = canvas_text_get_text (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = formatted_text_get_text (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = bool_to_string (node_first_summarized (parent));
		_tmp111_ = _tmp110_;
		_tmp112_ = bool_to_string (node_last_summarized (parent));
		_tmp113_ = _tmp112_;
		_tmp114_ = nb;
		_tmp115_ = node_bounds_to_string (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = sb;
		_tmp118_ = node_bounds_to_string (_tmp117_);
		_tmp119_ = _tmp118_;
		fprintf (_tmp103_, "node %s, first: %s, last: %s, nb: %s, sb: %s, msg: %s\n", _tmp109_, _tmp111_, _tmp113_, _tmp116_, _tmp119_, msg);
		_g_free0 (_tmp119_);
		_g_free0 (_tmp116_);
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
		if (node_first_summarized (parent)) {
			gdouble _tmp120_ = 0.0;
			gboolean _tmp121_ = FALSE;
			NodeSide _tmp122_;
			NodeSide _tmp123_;
			NodeBounds* _tmp136_;
			gdouble _tmp137_ = 0.0;
			gboolean _tmp138_ = FALSE;
			NodeSide _tmp139_;
			NodeSide _tmp140_;
			NodeBounds* _tmp153_;
			_tmp122_ = node_get_side (parent);
			_tmp123_ = _tmp122_;
			if (node_side_vertical (_tmp123_)) {
				NodeBounds* _tmp124_;
				gdouble _tmp125_;
				gdouble _tmp126_;
				NodeBounds* _tmp127_;
				gdouble _tmp128_;
				gdouble _tmp129_;
				_tmp124_ = nb;
				_tmp125_ = node_bounds_get_x (_tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = sb;
				_tmp128_ = node_bounds_get_x (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp121_ = _tmp126_ > _tmp129_;
			} else {
				_tmp121_ = FALSE;
			}
			if (_tmp121_) {
				NodeBounds* _tmp130_;
				gdouble _tmp131_;
				gdouble _tmp132_;
				_tmp130_ = sb;
				_tmp131_ = node_bounds_get_x (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp120_ = _tmp132_;
			} else {
				NodeBounds* _tmp133_;
				gdouble _tmp134_;
				gdouble _tmp135_;
				_tmp133_ = nb;
				_tmp134_ = node_bounds_get_x (_tmp133_);
				_tmp135_ = _tmp134_;
				_tmp120_ = _tmp135_;
			}
			_tmp136_ = nb;
			node_bounds_set_x (_tmp136_, _tmp120_);
			_tmp139_ = node_get_side (parent);
			_tmp140_ = _tmp139_;
			if (node_side_horizontal (_tmp140_)) {
				NodeBounds* _tmp141_;
				gdouble _tmp142_;
				gdouble _tmp143_;
				NodeBounds* _tmp144_;
				gdouble _tmp145_;
				gdouble _tmp146_;
				_tmp141_ = nb;
				_tmp142_ = node_bounds_get_y (_tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = sb;
				_tmp145_ = node_bounds_get_y (_tmp144_);
				_tmp146_ = _tmp145_;
				_tmp138_ = _tmp143_ > _tmp146_;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				NodeBounds* _tmp147_;
				gdouble _tmp148_;
				gdouble _tmp149_;
				_tmp147_ = sb;
				_tmp148_ = node_bounds_get_y (_tmp147_);
				_tmp149_ = _tmp148_;
				_tmp137_ = _tmp149_;
			} else {
				NodeBounds* _tmp150_;
				gdouble _tmp151_;
				gdouble _tmp152_;
				_tmp150_ = nb;
				_tmp151_ = node_bounds_get_y (_tmp150_);
				_tmp152_ = _tmp151_;
				_tmp137_ = _tmp152_;
			}
			_tmp153_ = nb;
			node_bounds_set_y (_tmp153_, _tmp137_);
		} else {
			if (node_last_summarized (parent)) {
				gdouble _tmp154_ = 0.0;
				gboolean _tmp155_ = FALSE;
				NodeSide _tmp156_;
				NodeSide _tmp157_;
				gdouble _tmp170_ = 0.0;
				gboolean _tmp171_ = FALSE;
				NodeSide _tmp172_;
				NodeSide _tmp173_;
				_tmp156_ = node_get_side (parent);
				_tmp157_ = _tmp156_;
				if (node_side_vertical (_tmp157_)) {
					NodeBounds* _tmp158_;
					gdouble _tmp159_;
					gdouble _tmp160_;
					NodeBounds* _tmp161_;
					gdouble _tmp162_;
					gdouble _tmp163_;
					_tmp158_ = sb;
					_tmp159_ = node_bounds_get_x (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = sb;
					_tmp162_ = node_bounds_get_width (_tmp161_);
					_tmp163_ = _tmp162_;
					_tmp155_ = x2 < (_tmp160_ + _tmp163_);
				} else {
					_tmp155_ = FALSE;
				}
				if (_tmp155_) {
					NodeBounds* _tmp164_;
					gdouble _tmp165_;
					gdouble _tmp166_;
					NodeBounds* _tmp167_;
					gdouble _tmp168_;
					gdouble _tmp169_;
					_tmp164_ = sb;
					_tmp165_ = node_bounds_get_x (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = sb;
					_tmp168_ = node_bounds_get_width (_tmp167_);
					_tmp169_ = _tmp168_;
					_tmp154_ = _tmp166_ + _tmp169_;
				} else {
					_tmp154_ = x2;
				}
				x2 = _tmp154_;
				_tmp172_ = node_get_side (parent);
				_tmp173_ = _tmp172_;
				if (node_side_horizontal (_tmp173_)) {
					NodeBounds* _tmp174_;
					gdouble _tmp175_;
					gdouble _tmp176_;
					NodeBounds* _tmp177_;
					gdouble _tmp178_;
					gdouble _tmp179_;
					_tmp174_ = sb;
					_tmp175_ = node_bounds_get_y (_tmp174_);
					_tmp176_ = _tmp175_;
					_tmp177_ = sb;
					_tmp178_ = node_bounds_get_height (_tmp177_);
					_tmp179_ = _tmp178_;
					_tmp171_ = y2 < (_tmp176_ + _tmp179_);
				} else {
					_tmp171_ = FALSE;
				}
				if (_tmp171_) {
					NodeBounds* _tmp180_;
					gdouble _tmp181_;
					gdouble _tmp182_;
					NodeBounds* _tmp183_;
					gdouble _tmp184_;
					gdouble _tmp185_;
					_tmp180_ = sb;
					_tmp181_ = node_bounds_get_y (_tmp180_);
					_tmp182_ = _tmp181_;
					_tmp183_ = sb;
					_tmp184_ = node_bounds_get_height (_tmp183_);
					_tmp185_ = _tmp184_;
					_tmp170_ = _tmp182_ + _tmp185_;
				} else {
					_tmp170_ = y2;
				}
				y2 = _tmp170_;
			}
		}
		_node_bounds_unref0 (sb);
		_g_object_unref0 (summary);
	}
	_tmp186_ = nb;
	_tmp187_ = nb;
	_tmp188_ = node_bounds_get_x (_tmp187_);
	_tmp189_ = _tmp188_;
	node_bounds_set_width (_tmp186_, x2 - _tmp189_);
	_tmp190_ = nb;
	_tmp191_ = nb;
	_tmp192_ = node_bounds_get_y (_tmp191_);
	_tmp193_ = _tmp192_;
	node_bounds_set_height (_tmp190_, y2 - _tmp193_);
	result = nb;
	return result;
}

NodeBounds*
layout_bbox (Layout* self,
             Node* parent,
             gint side_mask,
             const gchar* msg)
{
	LayoutClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->bbox) {
		return _klass_->bbox (self, parent, side_mask, msg);
	}
	return NULL;
}

void
layout_update_tree_size (Layout* self,
                         Node* n)
{
	NodeBounds* nb = NULL;
	NodeBounds* _tmp0_;
	NodeBounds* _tmp1_;
	gdouble _tmp2_ = 0.0;
	NodeSide _tmp3_;
	NodeSide _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = layout_bbox (self, n, -1, "update_tree_size");
	nb = _tmp0_;
	_tmp1_ = nb;
	node_set_tree_bbox (n, _tmp1_);
	_tmp3_ = node_get_side (n);
	_tmp4_ = _tmp3_;
	if (node_side_horizontal (_tmp4_)) {
		NodeBounds* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp5_ = nb;
		_tmp6_ = node_bounds_get_height (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_;
	} else {
		NodeBounds* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp8_ = nb;
		_tmp9_ = node_bounds_get_width (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_;
	}
	node_set_tree_size (n, _tmp2_);
	_node_bounds_unref0 (nb);
}

gdouble
layout_get_adjust (Layout* self,
                   Node* parent)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (parent != NULL, 0.0);
	if (node_is_summary (parent)) {
		gdouble xy1 = 0.0;
		gdouble xy2 = 0.0;
		gdouble _tmp0_ = 0.0;
		gdouble _tmp1_ = 0.0;
		gdouble extent_size = 0.0;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gdouble orig_tree_size = 0.0;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_;
		gdouble _tmp9_;
		summary_node_get_extents (IS_SUMMARY_NODE (parent) ? ((SummaryNode*) parent) : NULL, &_tmp0_, &_tmp1_);
		xy1 = _tmp0_;
		xy2 = _tmp1_;
		extent_size = xy2 - xy1;
		_tmp3_ = node_get_tree_size (parent);
		_tmp4_ = _tmp3_;
		if (extent_size < _tmp4_) {
			gdouble _tmp5_;
			gdouble _tmp6_;
			_tmp5_ = node_get_tree_size (parent);
			_tmp6_ = _tmp5_;
			_tmp2_ = _tmp6_;
		} else {
			_tmp2_ = extent_size;
		}
		orig_tree_size = _tmp2_;
		layout_update_tree_size (self, parent);
		_tmp8_ = node_get_tree_size (parent);
		_tmp9_ = _tmp8_;
		if (extent_size < _tmp9_) {
			gdouble _tmp10_;
			gdouble _tmp11_;
			_tmp10_ = node_get_tree_size (parent);
			_tmp11_ = _tmp10_;
			_tmp7_ = _tmp11_ - orig_tree_size;
		} else {
			_tmp7_ = (gdouble) 0;
		}
		result = _tmp7_;
		return result;
	} else {
		gdouble orig_tree_size = 0.0;
		gdouble _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_ = 0.0;
		_tmp12_ = node_get_tree_size (parent);
		_tmp13_ = _tmp12_;
		orig_tree_size = _tmp13_;
		layout_update_tree_size (self, parent);
		if (orig_tree_size == ((gdouble) 0)) {
			_tmp14_ = (gdouble) 0;
		} else {
			gdouble _tmp15_;
			gdouble _tmp16_;
			_tmp15_ = node_get_tree_size (parent);
			_tmp16_ = _tmp15_;
			_tmp14_ = _tmp16_ - orig_tree_size;
		}
		result = _tmp14_;
		return result;
	}
}

static void
layout_real_adjust_tree (Layout* self,
                         Node* parent,
                         gint child_index,
                         gint side_mask,
                         gdouble amount)
{
	g_return_if_fail (parent != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				gboolean _tmp4_;
				Node* n = NULL;
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				Node* _tmp8_;
				Node* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = node_children (parent);
				_tmp3_ = _tmp2_;
				_tmp4_ = !(((guint) i) < _tmp3_->len);
				_g_array_unref0 (_tmp3_);
				if (_tmp4_) {
					break;
				}
				_tmp5_ = node_children (parent);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_array_unref0 (_tmp6_);
				n = _tmp9_;
				if (i != child_index) {
					_tmp11_ = TRUE;
				} else {
					Node* _tmp12_;
					_tmp12_ = n;
					_tmp11_ = node_last_summarized (_tmp12_);
				}
				if (_tmp11_) {
					Node* _tmp13_;
					NodeSide _tmp14_;
					NodeSide _tmp15_;
					_tmp13_ = n;
					_tmp14_ = node_get_side (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp10_ = (_tmp15_ & side_mask) != 0;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					Node* _tmp16_;
					NodeSide _tmp17_;
					NodeSide _tmp18_;
					_tmp16_ = n;
					_tmp17_ = node_get_side (_tmp16_);
					_tmp18_ = _tmp17_;
					if (node_side_horizontal (_tmp18_)) {
						Node* _tmp19_;
						Node* _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
						_tmp19_ = n;
						_tmp20_ = n;
						_tmp21_ = node_get_posy (_tmp20_);
						_tmp22_ = _tmp21_;
						node_set_posy (_tmp20_, _tmp22_ + amount);
					} else {
						Node* _tmp23_;
						Node* _tmp24_;
						gdouble _tmp25_;
						gdouble _tmp26_;
						_tmp23_ = n;
						_tmp24_ = n;
						_tmp25_ = node_get_posx (_tmp24_);
						_tmp26_ = _tmp25_;
						node_set_posx (_tmp24_, _tmp26_ + amount);
					}
				}
				if (i == child_index) {
					amount = 0 - amount;
				}
				_g_object_unref0 (n);
			}
		}
	}
}

void
layout_adjust_tree (Layout* self,
                    Node* parent,
                    gint child_index,
                    gint side_mask,
                    gdouble amount)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->adjust_tree) {
		_klass_->adjust_tree (self, parent, child_index, side_mask, amount);
	}
}

static void
layout_real_adjust_tree_all (Layout* self,
                             Node* n,
                             NodeBounds* p,
                             gdouble amount,
                             const gchar* msg)
{
	Node* parent = NULL;
	Node* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	Node* last = NULL;
	Node* _tmp3_;
	gint index = 0;
	GArray* nodes = NULL;
	DrawArea* _tmp4_;
	DrawArea* _tmp5_;
	GArray* _tmp6_;
	NodeBounds* prev = NULL;
	NodeBounds* _tmp7_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = node_get_parent (n);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	parent = _tmp2_;
	_tmp3_ = _g_object_ref0 (n);
	last = _tmp3_;
	index = node_index (n);
	_tmp4_ = node_get_da (n);
	_tmp5_ = _tmp4_;
	_tmp6_ = draw_area_get_nodes (_tmp5_);
	nodes = _tmp6_;
	_tmp7_ = node_bounds_new_copy (p);
	prev = _tmp7_;
	while (TRUE) {
		Node* _tmp8_;
		Node* _tmp9_;
		NodeSide _tmp10_;
		NodeSide _tmp11_;
		NodeBounds* _tmp12_;
		Node* _tmp13_;
		NodeBounds* _tmp14_;
		NodeBounds* _tmp15_;
		Node* _tmp16_;
		Node* _tmp17_;
		Node* _tmp18_;
		Node* _tmp19_;
		Node* _tmp20_;
		Node* _tmp21_;
		Node* _tmp22_;
		Node* _tmp23_;
		_tmp8_ = parent;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = parent;
		_tmp10_ = node_get_side (n);
		_tmp11_ = _tmp10_;
		layout_adjust_tree (self, _tmp9_, index, (gint) _tmp11_, amount);
		_tmp12_ = prev;
		_tmp13_ = parent;
		_tmp14_ = node_get_tree_bbox (_tmp13_);
		_tmp15_ = _tmp14_;
		node_bounds_copy_from (_tmp12_, _tmp15_);
		_tmp16_ = parent;
		amount = 0 - (layout_get_adjust (self, _tmp16_) / 2);
		_tmp17_ = parent;
		index = node_index (_tmp17_);
		_tmp18_ = parent;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_g_object_unref0 (last);
		last = _tmp19_;
		_tmp20_ = parent;
		_tmp21_ = node_get_parent (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_g_object_unref0 (parent);
		parent = _tmp23_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				GArray* _tmp26_;
				GArray* _tmp27_;
				Node* _tmp28_;
				Node* _tmp29_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = nodes;
				if (!(((guint) i) < _tmp26_->len)) {
					break;
				}
				_tmp27_ = nodes;
				_tmp28_ = g_array_index (_tmp27_, Node*, (guint) i);
				_tmp29_ = last;
				if (_tmp28_ == _tmp29_) {
					DrawArea* _tmp30_;
					DrawArea* _tmp31_;
					NodeBounds* _tmp32_;
					_tmp30_ = node_get_da (n);
					_tmp31_ = _tmp30_;
					_tmp32_ = prev;
					draw_area_handle_tree_overlap (_tmp31_, _tmp32_);
				}
			}
		}
	}
	_node_bounds_unref0 (prev);
	_g_array_unref0 (nodes);
	_g_object_unref0 (last);
	_g_object_unref0 (parent);
}

void
layout_adjust_tree_all (Layout* self,
                        Node* n,
                        NodeBounds* p,
                        gdouble amount,
                        const gchar* msg)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->adjust_tree_all) {
		_klass_->adjust_tree_all (self, n, p, amount, msg);
	}
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
layout_real_propagate_side (Layout* self,
                            Node* parent,
                            NodeSide side)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble pw = 0.0;
	gdouble ph = 0.0;
	gint* margin = NULL;
	Style* _tmp0_;
	Style* _tmp1_;
	gint* _tmp2_;
	gint* _tmp3_;
	gint* _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	g_return_if_fail (parent != NULL);
	if (!node_traversable (parent)) {
		return;
	}
	_tmp0_ = node_get_style (parent);
	_tmp1_ = _tmp0_;
	_tmp2_ = style_get_branch_margin (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = __int_dup0 (_tmp3_);
	margin = _tmp4_;
	node_bbox (parent, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	px = _tmp5_;
	py = _tmp6_;
	pw = _tmp7_;
	ph = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GArray* _tmp11_;
				GArray* _tmp12_;
				gboolean _tmp13_;
				Node* n = NULL;
				GArray* _tmp14_;
				GArray* _tmp15_;
				Node* _tmp16_;
				Node* _tmp17_;
				Node* _tmp18_;
				Node* _tmp19_;
				NodeSide _tmp20_;
				NodeSide _tmp21_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = node_children (parent);
				_tmp12_ = _tmp11_;
				_tmp13_ = !(((guint) i) < _tmp12_->len);
				_g_array_unref0 (_tmp12_);
				if (_tmp13_) {
					break;
				}
				_tmp14_ = node_children (parent);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_array_index (_tmp15_, Node*, (guint) i);
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_tmp18_ = _tmp17_;
				_g_array_unref0 (_tmp15_);
				n = _tmp18_;
				_tmp19_ = n;
				_tmp20_ = node_get_side (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_ != side) {
					Node* _tmp22_;
					Node* _tmp41_;
					_tmp22_ = n;
					node_set_side (_tmp22_, side);
					switch (side) {
						case NODE_SIDE_LEFT:
						{
							gdouble cx = 0.0;
							gdouble cy = 0.0;
							gdouble cw = 0.0;
							gdouble ch = 0.0;
							Node* _tmp23_;
							gdouble _tmp24_ = 0.0;
							gdouble _tmp25_ = 0.0;
							gdouble _tmp26_ = 0.0;
							gdouble _tmp27_ = 0.0;
							Node* _tmp28_;
							gint* _tmp29_;
							_tmp23_ = n;
							node_bbox (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
							cx = _tmp24_;
							cy = _tmp25_;
							cw = _tmp26_;
							ch = _tmp27_;
							_tmp28_ = n;
							_tmp29_ = margin;
							node_set_posx (_tmp28_, (px - (*_tmp29_)) - cw);
							break;
						}
						case NODE_SIDE_RIGHT:
						{
							Node* _tmp30_;
							gint* _tmp31_;
							_tmp30_ = n;
							_tmp31_ = margin;
							node_set_posx (_tmp30_, (px + pw) + (*_tmp31_));
							break;
						}
						case NODE_SIDE_TOP:
						{
							gdouble cx = 0.0;
							gdouble cy = 0.0;
							gdouble cw = 0.0;
							gdouble ch = 0.0;
							Node* _tmp32_;
							gdouble _tmp33_ = 0.0;
							gdouble _tmp34_ = 0.0;
							gdouble _tmp35_ = 0.0;
							gdouble _tmp36_ = 0.0;
							Node* _tmp37_;
							gint* _tmp38_;
							_tmp32_ = n;
							node_bbox (_tmp32_, &_tmp33_, &_tmp34_, &_tmp35_, &_tmp36_);
							cx = _tmp33_;
							cy = _tmp34_;
							cw = _tmp35_;
							ch = _tmp36_;
							_tmp37_ = n;
							_tmp38_ = margin;
							node_set_posy (_tmp37_, (py - (*_tmp38_)) - ch);
							break;
						}
						case NODE_SIDE_BOTTOM:
						{
							Node* _tmp39_;
							gint* _tmp40_;
							_tmp39_ = n;
							_tmp40_ = margin;
							node_set_posy (_tmp39_, (py + ph) + (*_tmp40_));
							break;
						}
						default:
						break;
					}
					_tmp41_ = n;
					layout_propagate_side (self, _tmp41_, side);
				}
				_g_object_unref0 (n);
			}
		}
	}
	_g_free0 (margin);
}

void
layout_propagate_side (Layout* self,
                       Node* parent,
                       NodeSide side)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->propagate_side) {
		_klass_->propagate_side (self, parent, side);
	}
}

static NodeSide
layout_real_get_side (Layout* self,
                      Node* n)
{
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	gdouble rw = 0.0;
	gdouble rh = 0.0;
	gdouble nx = 0.0;
	gdouble ny = 0.0;
	gdouble nw = 0.0;
	gdouble nh = 0.0;
	Node* _tmp0_;
	Node* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	NodeSide _tmp10_;
	NodeSide _tmp11_;
	NodeSide result;
	g_return_val_if_fail (n != NULL, 0);
	_tmp0_ = node_get_root (n);
	_tmp1_ = _tmp0_;
	node_bbox (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	rx = _tmp2_;
	ry = _tmp3_;
	rw = _tmp4_;
	rh = _tmp5_;
	_g_object_unref0 (_tmp1_);
	node_bbox (n, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	nx = _tmp6_;
	ny = _tmp7_;
	nw = _tmp8_;
	nh = _tmp9_;
	_tmp10_ = node_get_side (n);
	_tmp11_ = _tmp10_;
	if (node_side_horizontal (_tmp11_)) {
		NodeSide _tmp12_ = 0;
		if ((nx + (nw / 2)) > (rx + (rw / 2))) {
			_tmp12_ = NODE_SIDE_RIGHT;
		} else {
			_tmp12_ = NODE_SIDE_LEFT;
		}
		result = _tmp12_;
		return result;
	} else {
		NodeSide _tmp13_ = 0;
		if ((ny + (nh / 2)) > (ry + (rh / 2))) {
			_tmp13_ = NODE_SIDE_BOTTOM;
		} else {
			_tmp13_ = NODE_SIDE_TOP;
		}
		result = _tmp13_;
		return result;
	}
}

NodeSide
layout_get_side (Layout* self,
                 Node* n)
{
	LayoutClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->get_side) {
		return _klass_->get_side (self, n);
	}
	return 0;
}

static void
layout_real_set_side (Layout* self,
                      Node* current)
{
	g_return_if_fail (current != NULL);
	if (!node_is_root (current)) {
		NodeSide side = 0;
		NodeSide _tmp0_;
		NodeSide _tmp1_;
		side = layout_get_side (self, current);
		_tmp0_ = node_get_side (current);
		_tmp1_ = _tmp0_;
		if (_tmp1_ != side) {
			node_set_side (current, side);
			layout_propagate_side (self, current, side);
		}
	}
}

void
layout_set_side (Layout* self,
                 Node* current)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->set_side) {
		_klass_->set_side (self, current);
	}
}

void
layout_apply_margin (Layout* self,
                     Node* n)
{
	Node* _tmp0_;
	Node* _tmp1_;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble pw = 0.0;
	gdouble ph = 0.0;
	gint* margin = NULL;
	Node* _tmp2_;
	Node* _tmp3_;
	Style* _tmp4_;
	Style* _tmp5_;
	gint* _tmp6_;
	gint* _tmp7_;
	gint* _tmp8_;
	Node* _tmp9_;
	Node* _tmp10_;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	NodeSide _tmp15_;
	NodeSide _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = node_get_parent (n);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = node_get_parent (n);
	_tmp3_ = _tmp2_;
	_tmp4_ = node_get_style (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = style_get_branch_margin (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = __int_dup0 (_tmp7_);
	margin = _tmp8_;
	_tmp9_ = node_get_parent (n);
	_tmp10_ = _tmp9_;
	node_bbox (_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	px = _tmp11_;
	py = _tmp12_;
	pw = _tmp13_;
	ph = _tmp14_;
	_tmp15_ = node_get_side (n);
	_tmp16_ = _tmp15_;
	switch (_tmp16_) {
		case NODE_SIDE_LEFT:
		{
			gdouble cx = 0.0;
			gdouble cy = 0.0;
			gdouble cw = 0.0;
			gdouble ch = 0.0;
			gdouble _tmp17_ = 0.0;
			gdouble _tmp18_ = 0.0;
			gdouble _tmp19_ = 0.0;
			gdouble _tmp20_ = 0.0;
			gint* _tmp21_;
			node_bbox (n, &_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
			cx = _tmp17_;
			cy = _tmp18_;
			cw = _tmp19_;
			ch = _tmp20_;
			_tmp21_ = margin;
			node_set_posx (n, px - (cw + (*_tmp21_)));
			break;
		}
		case NODE_SIDE_RIGHT:
		{
			gint* _tmp22_;
			Node* _tmp23_;
			Node* _tmp24_;
			_tmp22_ = margin;
			_tmp23_ = node_get_parent (n);
			_tmp24_ = _tmp23_;
			node_set_posx (n, (px + (pw + (*_tmp22_))) - node_task_width (_tmp24_));
			break;
		}
		case NODE_SIDE_TOP:
		{
			gdouble cx = 0.0;
			gdouble cy = 0.0;
			gdouble cw = 0.0;
			gdouble ch = 0.0;
			gdouble _tmp25_ = 0.0;
			gdouble _tmp26_ = 0.0;
			gdouble _tmp27_ = 0.0;
			gdouble _tmp28_ = 0.0;
			gint* _tmp29_;
			node_bbox (n, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
			cx = _tmp25_;
			cy = _tmp26_;
			cw = _tmp27_;
			ch = _tmp28_;
			_tmp29_ = margin;
			node_set_posy (n, py - (ch + (*_tmp29_)));
			break;
		}
		case NODE_SIDE_BOTTOM:
		{
			gint* _tmp30_;
			_tmp30_ = margin;
			node_set_posy (n, py + (ph + (*_tmp30_)));
			break;
		}
		default:
		break;
	}
	_g_free0 (margin);
}

static void
layout_real_handle_update_by_edit (Layout* self,
                                   Node* n,
                                   gdouble diffw,
                                   gdouble diffh)
{
	gdouble adjust = 0.0;
	NodeSide _tmp0_;
	NodeSide _tmp1_;
	NodeBounds* _tmp79_;
	NodeBounds* _tmp80_;
	g_return_if_fail (n != NULL);
	adjust = 0 - (layout_get_adjust (self, n) / 2);
	_tmp0_ = node_get_side (n);
	_tmp1_ = _tmp0_;
	if (node_side_horizontal (_tmp1_)) {
		if (diffh != ((gdouble) 0)) {
			node_adjust_posy_only (n, 0 - (diffh / 2));
		}
		if (diffw != ((gdouble) 0)) {
			if (node_is_root (n)) {
				node_adjust_posx_only (n, 0 - (diffw / 2));
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GArray* _tmp4_;
							GArray* _tmp5_;
							gboolean _tmp6_;
							Node* child = NULL;
							GArray* _tmp7_;
							GArray* _tmp8_;
							Node* _tmp9_;
							Node* _tmp10_;
							Node* _tmp11_;
							Node* _tmp12_;
							NodeSide _tmp13_;
							NodeSide _tmp14_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = i;
								i = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							_tmp4_ = node_children (n);
							_tmp5_ = _tmp4_;
							_tmp6_ = !(((guint) i) < _tmp5_->len);
							_g_array_unref0 (_tmp5_);
							if (_tmp6_) {
								break;
							}
							_tmp7_ = node_children (n);
							_tmp8_ = _tmp7_;
							_tmp9_ = g_array_index (_tmp8_, Node*, (guint) i);
							_tmp10_ = _g_object_ref0 (_tmp9_);
							_tmp11_ = _tmp10_;
							_g_array_unref0 (_tmp8_);
							child = _tmp11_;
							_tmp12_ = child;
							_tmp13_ = node_get_side (_tmp12_);
							_tmp14_ = _tmp13_;
							if (_tmp14_ == NODE_SIDE_LEFT) {
								Node* _tmp15_;
								Node* _tmp16_;
								gdouble _tmp17_;
								gdouble _tmp18_;
								_tmp15_ = child;
								_tmp16_ = child;
								_tmp17_ = node_get_posx (_tmp16_);
								_tmp18_ = _tmp17_;
								node_set_posx (_tmp16_, _tmp18_ - (diffw / 2));
							} else {
								Node* _tmp19_;
								Node* _tmp20_;
								gdouble _tmp21_;
								gdouble _tmp22_;
								_tmp19_ = child;
								_tmp20_ = child;
								_tmp21_ = node_get_posx (_tmp20_);
								_tmp22_ = _tmp21_;
								node_set_posx (_tmp20_, _tmp22_ + (diffw / 2));
							}
							_g_object_unref0 (child);
						}
					}
				}
			} else {
				NodeSide _tmp23_;
				NodeSide _tmp24_;
				_tmp23_ = node_get_side (n);
				_tmp24_ = _tmp23_;
				if (_tmp24_ == NODE_SIDE_LEFT) {
					gdouble _tmp25_;
					gdouble _tmp26_;
					_tmp25_ = node_get_posx (n);
					_tmp26_ = _tmp25_;
					node_set_posx (n, _tmp26_ - diffw);
				} else {
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp27_ = FALSE;
							_tmp27_ = TRUE;
							while (TRUE) {
								GArray* _tmp29_;
								GArray* _tmp30_;
								gboolean _tmp31_;
								GArray* _tmp32_;
								GArray* _tmp33_;
								Node* _tmp34_;
								GArray* _tmp35_;
								GArray* _tmp36_;
								Node* _tmp37_;
								gdouble _tmp38_;
								gdouble _tmp39_;
								if (!_tmp27_) {
									gint _tmp28_;
									_tmp28_ = i;
									i = _tmp28_ + 1;
								}
								_tmp27_ = FALSE;
								_tmp29_ = node_children (n);
								_tmp30_ = _tmp29_;
								_tmp31_ = !(((guint) i) < _tmp30_->len);
								_g_array_unref0 (_tmp30_);
								if (_tmp31_) {
									break;
								}
								_tmp32_ = node_children (n);
								_tmp33_ = _tmp32_;
								_tmp34_ = g_array_index (_tmp33_, Node*, (guint) i);
								_tmp35_ = node_children (n);
								_tmp36_ = _tmp35_;
								_tmp37_ = g_array_index (_tmp36_, Node*, (guint) i);
								_tmp38_ = node_get_posx (_tmp37_);
								_tmp39_ = _tmp38_;
								node_set_posx (_tmp37_, _tmp39_ + diffw);
								_g_array_unref0 (_tmp36_);
								_g_array_unref0 (_tmp33_);
							}
						}
					}
				}
			}
		}
	} else {
		if (diffw != ((gdouble) 0)) {
			node_adjust_posx_only (n, 0 - (diffw / 2));
		}
		if (diffh != ((gdouble) 0)) {
			if (node_is_root (n)) {
				gdouble _tmp40_;
				gdouble _tmp41_;
				_tmp40_ = node_get_posy (n);
				_tmp41_ = _tmp40_;
				node_set_posy (n, _tmp41_ - (diffh / 2));
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp42_ = FALSE;
						_tmp42_ = TRUE;
						while (TRUE) {
							GArray* _tmp44_;
							GArray* _tmp45_;
							gboolean _tmp46_;
							Node* child = NULL;
							GArray* _tmp47_;
							GArray* _tmp48_;
							Node* _tmp49_;
							Node* _tmp50_;
							Node* _tmp51_;
							NodeSide _tmp52_;
							NodeSide _tmp53_;
							if (!_tmp42_) {
								gint _tmp43_;
								_tmp43_ = i;
								i = _tmp43_ + 1;
							}
							_tmp42_ = FALSE;
							_tmp44_ = node_children (n);
							_tmp45_ = _tmp44_;
							_tmp46_ = !(((guint) i) < _tmp45_->len);
							_g_array_unref0 (_tmp45_);
							if (_tmp46_) {
								break;
							}
							_tmp47_ = node_children (n);
							_tmp48_ = _tmp47_;
							_tmp49_ = g_array_index (_tmp48_, Node*, (guint) i);
							_tmp50_ = _g_object_ref0 (_tmp49_);
							_tmp51_ = _tmp50_;
							_g_array_unref0 (_tmp48_);
							child = _tmp51_;
							_tmp52_ = node_get_side (n);
							_tmp53_ = _tmp52_;
							if (_tmp53_ == NODE_SIDE_TOP) {
								Node* _tmp54_;
								Node* _tmp55_;
								gdouble _tmp56_;
								gdouble _tmp57_;
								_tmp54_ = child;
								_tmp55_ = child;
								_tmp56_ = node_get_posy (_tmp55_);
								_tmp57_ = _tmp56_;
								node_set_posy (_tmp55_, _tmp57_ - (diffh / 2));
							} else {
								Node* _tmp58_;
								Node* _tmp59_;
								gdouble _tmp60_;
								gdouble _tmp61_;
								_tmp58_ = child;
								_tmp59_ = child;
								_tmp60_ = node_get_posy (_tmp59_);
								_tmp61_ = _tmp60_;
								node_set_posy (_tmp59_, _tmp61_ + (diffh / 2));
							}
							_g_object_unref0 (child);
						}
					}
				}
			} else {
				NodeSide _tmp62_;
				NodeSide _tmp63_;
				_tmp62_ = node_get_side (n);
				_tmp63_ = _tmp62_;
				if (_tmp63_ == NODE_SIDE_TOP) {
					gdouble _tmp64_;
					gdouble _tmp65_;
					_tmp64_ = node_get_posy (n);
					_tmp65_ = _tmp64_;
					node_set_posy (n, _tmp65_ - diffh);
				} else {
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp66_ = FALSE;
							_tmp66_ = TRUE;
							while (TRUE) {
								GArray* _tmp68_;
								GArray* _tmp69_;
								gboolean _tmp70_;
								GArray* _tmp71_;
								GArray* _tmp72_;
								Node* _tmp73_;
								GArray* _tmp74_;
								GArray* _tmp75_;
								Node* _tmp76_;
								gdouble _tmp77_;
								gdouble _tmp78_;
								if (!_tmp66_) {
									gint _tmp67_;
									_tmp67_ = i;
									i = _tmp67_ + 1;
								}
								_tmp66_ = FALSE;
								_tmp68_ = node_children (n);
								_tmp69_ = _tmp68_;
								_tmp70_ = !(((guint) i) < _tmp69_->len);
								_g_array_unref0 (_tmp69_);
								if (_tmp70_) {
									break;
								}
								_tmp71_ = node_children (n);
								_tmp72_ = _tmp71_;
								_tmp73_ = g_array_index (_tmp72_, Node*, (guint) i);
								_tmp74_ = node_children (n);
								_tmp75_ = _tmp74_;
								_tmp76_ = g_array_index (_tmp75_, Node*, (guint) i);
								_tmp77_ = node_get_posy (_tmp76_);
								_tmp78_ = _tmp77_;
								node_set_posy (_tmp76_, _tmp78_ + diffh);
								_g_array_unref0 (_tmp75_);
								_g_array_unref0 (_tmp72_);
							}
						}
					}
				}
			}
		}
	}
	_tmp79_ = node_get_tree_bbox (n);
	_tmp80_ = _tmp79_;
	layout_adjust_tree_all (self, n, _tmp80_, adjust, "by_edit");
}

void
layout_handle_update_by_edit (Layout* self,
                              Node* n,
                              gdouble diffw,
                              gdouble diffh)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->handle_update_by_edit) {
		_klass_->handle_update_by_edit (self, n, diffw, diffh);
	}
}

static void
layout_real_handle_update_by_fold (Layout* self,
                                   Node* n)
{
	NodeBounds* _tmp0_;
	NodeBounds* _tmp1_;
	g_return_if_fail (n != NULL);
	_tmp0_ = node_get_tree_bbox (n);
	_tmp1_ = _tmp0_;
	layout_adjust_tree_all (self, n, _tmp1_, 0 - (layout_get_adjust (self, n) / 2), "by_fold");
}

void
layout_handle_update_by_fold (Layout* self,
                              Node* n)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->handle_update_by_fold) {
		_klass_->handle_update_by_fold (self, n);
	}
}

static gdouble
layout_real_get_insert_adjust (Layout* self,
                               Node* child)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble result;
	g_return_val_if_fail (child != NULL, 0.0);
	_tmp0_ = node_get_tree_size (child);
	_tmp1_ = _tmp0_;
	result = _tmp1_ / 2;
	return result;
}

gdouble
layout_get_insert_adjust (Layout* self,
                          Node* child)
{
	LayoutClass* _klass_;
	g_return_val_if_fail (self != NULL, 0.0);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->get_insert_adjust) {
		return _klass_->get_insert_adjust (self, child);
	}
	return -1.0;
}

static void
layout_real_handle_update_by_insert (Layout* self,
                                     Node* parent,
                                     Node* child,
                                     gint pos)
{
	gdouble ox = 0.0;
	gdouble oy = 0.0;
	gdouble ow = 0.0;
	gdouble oh = 0.0;
	gdouble adjust = 0.0;
	NodeBounds* cb = NULL;
	NodeBounds* _tmp0_;
	NodeBounds* _tmp1_;
	NodeBounds* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NodeBounds* _tmp78_;
	NodeBounds* _tmp79_;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (child != NULL);
	layout_update_tree_size (self, child);
	_tmp0_ = node_get_tree_bbox (child);
	_tmp1_ = _tmp0_;
	_tmp2_ = _node_bounds_ref0 (_tmp1_);
	cb = _tmp2_;
	node_bbox (child, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	ox = _tmp3_;
	oy = _tmp4_;
	ow = _tmp5_;
	oh = _tmp6_;
	layout_apply_margin (self, child);
	adjust = layout_get_insert_adjust (self, child);
	if (node_is_summary (child)) {
		gdouble xy1 = 0.0;
		gdouble xy2 = 0.0;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
		NodeSide _tmp9_;
		NodeSide _tmp10_;
		summary_node_get_extents (IS_SUMMARY_NODE (child) ? ((SummaryNode*) child) : NULL, &_tmp7_, &_tmp8_);
		xy1 = _tmp7_;
		xy2 = _tmp8_;
		_tmp9_ = node_get_side (child);
		_tmp10_ = _tmp9_;
		if (node_side_horizontal (_tmp10_)) {
			node_set_posy (child, xy1 + (((xy2 - xy1) / 2) - (oh / 2)));
		} else {
			node_set_posx (child, xy1 + (((xy2 - xy1) / 2) - (ow / 2)));
		}
	} else {
		NodeSide _tmp11_;
		NodeSide _tmp12_;
		_tmp11_ = node_get_side (child);
		_tmp12_ = _tmp11_;
		if (node_side_count (parent, _tmp12_) == 1) {
			gdouble px = 0.0;
			gdouble py = 0.0;
			gdouble pw = 0.0;
			gdouble ph = 0.0;
			gdouble _tmp13_ = 0.0;
			gdouble _tmp14_ = 0.0;
			gdouble _tmp15_ = 0.0;
			gdouble _tmp16_ = 0.0;
			NodeSide _tmp17_;
			NodeSide _tmp18_;
			node_bbox (parent, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
			px = _tmp13_;
			py = _tmp14_;
			pw = _tmp15_;
			ph = _tmp16_;
			_tmp17_ = node_get_side (child);
			_tmp18_ = _tmp17_;
			if (node_side_horizontal (_tmp18_)) {
				node_set_posy (child, py + ((ph / 2) - (oh / 2)));
			} else {
				node_set_posx (child, px + ((pw / 2) - (ow / 2)));
			}
		} else {
			gboolean _tmp19_ = FALSE;
			GArray* _tmp20_;
			GArray* _tmp21_;
			gboolean _tmp22_;
			_tmp20_ = node_children (parent);
			_tmp21_ = _tmp20_;
			_tmp22_ = ((guint) (pos + 1)) == _tmp21_->len;
			_g_array_unref0 (_tmp21_);
			if (_tmp22_) {
				_tmp19_ = TRUE;
			} else {
				GArray* _tmp23_;
				GArray* _tmp24_;
				Node* _tmp25_;
				NodeSide _tmp26_;
				NodeSide _tmp27_;
				NodeSide _tmp28_;
				NodeSide _tmp29_;
				_tmp23_ = node_children (parent);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_array_index (_tmp24_, Node*, (guint) (pos + 1));
				_tmp26_ = node_get_side (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = node_get_side (child);
				_tmp29_ = _tmp28_;
				_tmp19_ = _tmp27_ != _tmp29_;
				_g_array_unref0 (_tmp24_);
			}
			if (_tmp19_) {
				NodeBounds* sb = NULL;
				GArray* _tmp30_;
				GArray* _tmp31_;
				Node* _tmp32_;
				NodeSide _tmp33_;
				NodeSide _tmp34_;
				NodeBounds* _tmp35_;
				NodeBounds* _tmp36_;
				NodeSide _tmp37_;
				NodeSide _tmp38_;
				_tmp30_ = node_children (parent);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_array_index (_tmp31_, Node*, (guint) (pos - 1));
				_tmp33_ = node_get_side (child);
				_tmp34_ = _tmp33_;
				_tmp35_ = layout_bbox (self, _tmp32_, (gint) _tmp34_, "insert a");
				_tmp36_ = _tmp35_;
				_g_array_unref0 (_tmp31_);
				sb = _tmp36_;
				_tmp37_ = node_get_side (child);
				_tmp38_ = _tmp37_;
				if (node_side_horizontal (_tmp38_)) {
					NodeBounds* _tmp39_;
					gdouble _tmp40_;
					gdouble _tmp41_;
					NodeBounds* _tmp42_;
					gdouble _tmp43_;
					gdouble _tmp44_;
					NodeBounds* _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					_tmp39_ = sb;
					_tmp40_ = node_bounds_get_y (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = sb;
					_tmp43_ = node_bounds_get_height (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = cb;
					_tmp46_ = node_bounds_get_y (_tmp45_);
					_tmp47_ = _tmp46_;
					node_set_posy (child, ((_tmp41_ + _tmp44_) + (oy - _tmp47_)) - adjust);
				} else {
					NodeBounds* _tmp48_;
					gdouble _tmp49_;
					gdouble _tmp50_;
					NodeBounds* _tmp51_;
					gdouble _tmp52_;
					gdouble _tmp53_;
					NodeBounds* _tmp54_;
					gdouble _tmp55_;
					gdouble _tmp56_;
					_tmp48_ = sb;
					_tmp49_ = node_bounds_get_x (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = sb;
					_tmp52_ = node_bounds_get_width (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = cb;
					_tmp55_ = node_bounds_get_x (_tmp54_);
					_tmp56_ = _tmp55_;
					node_set_posx (child, ((_tmp50_ + _tmp53_) + (ox - _tmp56_)) - adjust);
				}
				_node_bounds_unref0 (sb);
			} else {
				NodeBounds* sb = NULL;
				GArray* _tmp57_;
				GArray* _tmp58_;
				Node* _tmp59_;
				NodeSide _tmp60_;
				NodeSide _tmp61_;
				NodeBounds* _tmp62_;
				NodeBounds* _tmp63_;
				NodeSide _tmp64_;
				NodeSide _tmp65_;
				_tmp57_ = node_children (parent);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_array_index (_tmp58_, Node*, (guint) (pos + 1));
				_tmp60_ = node_get_side (child);
				_tmp61_ = _tmp60_;
				_tmp62_ = layout_bbox (self, _tmp59_, (gint) _tmp61_, "insert b");
				_tmp63_ = _tmp62_;
				_g_array_unref0 (_tmp58_);
				sb = _tmp63_;
				_tmp64_ = node_get_side (child);
				_tmp65_ = _tmp64_;
				if (node_side_horizontal (_tmp65_)) {
					NodeBounds* _tmp66_;
					gdouble _tmp67_;
					gdouble _tmp68_;
					NodeBounds* _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp71_;
					_tmp66_ = sb;
					_tmp67_ = node_bounds_get_y (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = cb;
					_tmp70_ = node_bounds_get_y (_tmp69_);
					_tmp71_ = _tmp70_;
					node_set_posy (child, (_tmp68_ + (oy - _tmp71_)) - adjust);
				} else {
					NodeBounds* _tmp72_;
					gdouble _tmp73_;
					gdouble _tmp74_;
					NodeBounds* _tmp75_;
					gdouble _tmp76_;
					gdouble _tmp77_;
					_tmp72_ = sb;
					_tmp73_ = node_bounds_get_x (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = cb;
					_tmp76_ = node_bounds_get_x (_tmp75_);
					_tmp77_ = _tmp76_;
					node_set_posx (child, (_tmp74_ + (ox - _tmp77_)) - adjust);
				}
				_node_bounds_unref0 (sb);
			}
		}
	}
	_tmp78_ = node_get_tree_bbox (child);
	_tmp79_ = _tmp78_;
	layout_adjust_tree_all (self, child, _tmp79_, 0 - adjust, "by_insert");
	_node_bounds_unref0 (cb);
}

void
layout_handle_update_by_insert (Layout* self,
                                Node* parent,
                                Node* child,
                                gint pos)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->handle_update_by_insert) {
		_klass_->handle_update_by_insert (self, parent, child, pos);
	}
}

static void
layout_real_handle_update_by_delete (Layout* self,
                                     Node* parent,
                                     gint index,
                                     NodeSide side,
                                     gdouble size)
{
	gdouble adjust = 0.0;
	NodeBounds* _tmp25_;
	NodeBounds* _tmp26_;
	g_return_if_fail (parent != NULL);
	adjust = size / 2;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				gboolean _tmp4_;
				Node* n = NULL;
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				Node* _tmp8_;
				Node* _tmp9_;
				Node* _tmp10_;
				NodeSide _tmp11_;
				NodeSide _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = node_children (parent);
				_tmp3_ = _tmp2_;
				_tmp4_ = !(((guint) i) < _tmp3_->len);
				_g_array_unref0 (_tmp3_);
				if (_tmp4_) {
					break;
				}
				_tmp5_ = node_children (parent);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_array_unref0 (_tmp6_);
				n = _tmp9_;
				_tmp10_ = n;
				_tmp11_ = node_get_side (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == side) {
					gdouble _tmp13_ = 0.0;
					gdouble current_adjust = 0.0;
					Node* _tmp14_;
					NodeSide _tmp15_;
					NodeSide _tmp16_;
					if (i >= index) {
						_tmp13_ = 0 - adjust;
					} else {
						_tmp13_ = adjust;
					}
					current_adjust = _tmp13_;
					_tmp14_ = n;
					_tmp15_ = node_get_side (_tmp14_);
					_tmp16_ = _tmp15_;
					if (node_side_horizontal (_tmp16_)) {
						Node* _tmp17_;
						Node* _tmp18_;
						gdouble _tmp19_;
						gdouble _tmp20_;
						_tmp17_ = n;
						_tmp18_ = n;
						_tmp19_ = node_get_posy (_tmp18_);
						_tmp20_ = _tmp19_;
						node_set_posy (_tmp18_, _tmp20_ + current_adjust);
					} else {
						Node* _tmp21_;
						Node* _tmp22_;
						gdouble _tmp23_;
						gdouble _tmp24_;
						_tmp21_ = n;
						_tmp22_ = n;
						_tmp23_ = node_get_posx (_tmp22_);
						_tmp24_ = _tmp23_;
						node_set_posx (_tmp22_, _tmp24_ + current_adjust);
					}
				}
				_g_object_unref0 (n);
			}
		}
	}
	_tmp25_ = node_get_tree_bbox (parent);
	_tmp26_ = _tmp25_;
	layout_adjust_tree_all (self, parent, _tmp26_, 0 - (layout_get_adjust (self, parent) / 2), "by_delete");
}

void
layout_handle_update_by_delete (Layout* self,
                                Node* parent,
                                gint index,
                                NodeSide side,
                                gdouble size)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->handle_update_by_delete) {
		_klass_->handle_update_by_delete (self, parent, index, side, size);
	}
}

static void
layout_real_position_root (Layout* self,
                           Node* last,
                           Node* n)
{
	NodeBounds* nb = NULL;
	NodeBounds* _tmp0_;
	NodeBounds* _tmp1_;
	NodeBounds* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	g_return_if_fail (last != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = node_get_tree_bbox (last);
	_tmp1_ = _tmp0_;
	_tmp2_ = _node_bounds_ref0 (_tmp1_);
	nb = _tmp2_;
	_tmp3_ = node_get_posx (last);
	_tmp4_ = _tmp3_;
	node_set_posx (n, _tmp4_);
	_tmp5_ = node_bounds_get_y (nb);
	_tmp6_ = _tmp5_;
	_tmp7_ = node_bounds_get_height (nb);
	_tmp8_ = _tmp7_;
	node_set_posy (n, (_tmp6_ + _tmp8_) + self->_rt_gap);
	_node_bounds_unref0 (nb);
}

void
layout_position_root (Layout* self,
                      Node* last,
                      Node* n)
{
	LayoutClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LAYOUT_GET_CLASS (self);
	if (_klass_->position_root) {
		_klass_->position_root (self, last, n);
	}
}

const gchar*
layout_get_name (Layout* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
layout_set_name (Layout* self,
                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = layout_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, layout_properties[LAYOUT_NAME_PROPERTY]);
	}
}

const gchar*
layout_get_icon (Layout* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

void
layout_set_icon (Layout* self,
                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = layout_get_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, layout_properties[LAYOUT_ICON_PROPERTY]);
	}
}

gboolean
layout_get_balanceable (Layout* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_balanceable;
	return result;
}

void
layout_set_balanceable (Layout* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = layout_get_balanceable (self);
	if (old_value != value) {
		self->priv->_balanceable = value;
		g_object_notify_by_pspec ((GObject *) self, layout_properties[LAYOUT_BALANCEABLE_PROPERTY]);
	}
}

static void
layout_class_init (LayoutClass * klass,
                   gpointer klass_data)
{
	layout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Layout_private_offset);
	((LayoutClass *) klass)->side_mapping = (NodeSide (*) (Layout*, NodeSide)) layout_real_side_mapping;
	((LayoutClass *) klass)->initialize = (void (*) (Layout*, Node*)) layout_real_initialize;
	((LayoutClass *) klass)->bbox = (NodeBounds* (*) (Layout*, Node*, gint, const gchar*)) layout_real_bbox;
	((LayoutClass *) klass)->adjust_tree = (void (*) (Layout*, Node*, gint, gint, gdouble)) layout_real_adjust_tree;
	((LayoutClass *) klass)->adjust_tree_all = (void (*) (Layout*, Node*, NodeBounds*, gdouble, const gchar*)) layout_real_adjust_tree_all;
	((LayoutClass *) klass)->propagate_side = (void (*) (Layout*, Node*, NodeSide)) layout_real_propagate_side;
	((LayoutClass *) klass)->get_side = (NodeSide (*) (Layout*, Node*)) layout_real_get_side;
	((LayoutClass *) klass)->set_side = (void (*) (Layout*, Node*)) layout_real_set_side;
	((LayoutClass *) klass)->handle_update_by_edit = (void (*) (Layout*, Node*, gdouble, gdouble)) layout_real_handle_update_by_edit;
	((LayoutClass *) klass)->handle_update_by_fold = (void (*) (Layout*, Node*)) layout_real_handle_update_by_fold;
	((LayoutClass *) klass)->get_insert_adjust = (gdouble (*) (Layout*, Node*)) layout_real_get_insert_adjust;
	((LayoutClass *) klass)->handle_update_by_insert = (void (*) (Layout*, Node*, Node*, gint)) layout_real_handle_update_by_insert;
	((LayoutClass *) klass)->handle_update_by_delete = (void (*) (Layout*, Node*, gint, NodeSide, gdouble)) layout_real_handle_update_by_delete;
	((LayoutClass *) klass)->position_root = (void (*) (Layout*, Node*, Node*)) layout_real_position_root;
	G_OBJECT_CLASS (klass)->get_property = _vala_layout_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_layout_set_property;
	G_OBJECT_CLASS (klass)->finalize = layout_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAYOUT_NAME_PROPERTY, layout_properties[LAYOUT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAYOUT_ICON_PROPERTY, layout_properties[LAYOUT_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LAYOUT_BALANCEABLE_PROPERTY, layout_properties[LAYOUT_BALANCEABLE_PROPERTY] = g_param_spec_boolean ("balanceable", "balanceable", "balanceable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
layout_instance_init (Layout * self,
                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = layout_get_instance_private (self);
	self->_rt_gap = (gdouble) 100;
	_tmp0_ = g_strdup ("");
	self->priv->_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon = _tmp1_;
	self->priv->_balanceable = FALSE;
}

static void
layout_finalize (GObject * obj)
{
	Layout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LAYOUT, Layout);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_icon);
	G_OBJECT_CLASS (layout_parent_class)->finalize (obj);
}

static GType
layout_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Layout), 0, (GInstanceInitFunc) layout_instance_init, NULL };
	GType layout_type_id;
	layout_type_id = g_type_register_static (G_TYPE_OBJECT, "Layout", &g_define_type_info, 0);
	Layout_private_offset = g_type_add_instance_private (layout_type_id, sizeof (LayoutPrivate));
	return layout_type_id;
}

GType
layout_get_type (void)
{
	static volatile gsize layout_type_id__once = 0;
	if (g_once_init_enter (&layout_type_id__once)) {
		GType layout_type_id;
		layout_type_id = layout_get_type_once ();
		g_once_init_leave (&layout_type_id__once, layout_type_id);
	}
	return layout_type_id__once;
}

static void
_vala_layout_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Layout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LAYOUT, Layout);
	switch (property_id) {
		case LAYOUT_NAME_PROPERTY:
		g_value_set_string (value, layout_get_name (self));
		break;
		case LAYOUT_ICON_PROPERTY:
		g_value_set_string (value, layout_get_icon (self));
		break;
		case LAYOUT_BALANCEABLE_PROPERTY:
		g_value_set_boolean (value, layout_get_balanceable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_layout_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	Layout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LAYOUT, Layout);
	switch (property_id) {
		case LAYOUT_NAME_PROPERTY:
		layout_set_name (self, g_value_get_string (value));
		break;
		case LAYOUT_ICON_PROPERTY:
		layout_set_icon (self, g_value_get_string (value));
		break;
		case LAYOUT_BALANCEABLE_PROPERTY:
		layout_set_balanceable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

