/* Document.c generated by valac 0.56.18, the Vala compiler
 * generated from Document.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <handy.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;
enum  {
	DOCUMENT_0_PROPERTY,
	DOCUMENT_FILENAME_PROPERTY,
	DOCUMENT_LABEL_PROPERTY,
	DOCUMENT_SAVE_NEEDED_PROPERTY,
	DOCUMENT_READONLY_PROPERTY,
	DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* document_properties[DOCUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _image_manager_unref0(var) ((var == NULL) ? NULL : (var = (image_manager_unref (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Document {
	GObject parent_instance;
	DocumentPrivate * priv;
};

struct _DocumentClass {
	GObjectClass parent_class;
};

struct _DocumentPrivate {
	DrawArea* _da;
	gchar* _filename;
	gboolean _from_user;
	ImageManager* _image_manager;
	gchar* _etag;
	gboolean _read_only;
	gboolean _save_needed;
};

static gint Document_private_offset;
static gpointer document_parent_class = NULL;
VALA_EXTERN gchar* minder_version;

VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN Document* document_new (DrawArea* da);
VALA_EXTERN Document* document_construct (GType object_type,
                              DrawArea* da);
static gchar* document_generate_etag (Document* self);
VALA_EXTERN ImageManager* image_manager_new (void);
VALA_EXTERN ImageManager* image_manager_construct (GType object_type);
static void document_canvas_changed (Document* self);
static void _document_canvas_changed_draw_area_changed (DrawArea* _sender,
                                                 gpointer self);
static void document_set_save_needed (Document* self,
                               gboolean value);
VALA_EXTERN void document_auto_save (Document* self);
VALA_EXTERN void document_load_filename (Document* self,
                             const gchar* fname,
                             gboolean saved);
VALA_EXTERN void document_set_filename (Document* self,
                            const gchar* value);
VALA_EXTERN gboolean document_is_saved (Document* self);
VALA_EXTERN gboolean document_xml_find (const gchar* fname,
                            gint id,
                            gchar** name);
VALA_EXTERN gboolean draw_area_xml_find (xmlNode* n,
                             gint id,
                             gchar** name);
static xmlDoc* document_load_raw (Document* self);
VALA_EXTERN const gchar* document_get_filename (Document* self);
static gchar* document_get_etag (Document* self,
                          xmlDoc* doc);
VALA_EXTERN gboolean document_load (Document* self);
VALA_EXTERN void draw_area_load (DrawArea* self,
                     xmlNode* n);
static gboolean document_save_internal (Document* self,
                                 const gchar* dest_filename,
                                 gboolean bump_etag);
VALA_EXTERN gboolean document_save (Document* self);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN gboolean main_window_ask_modified_overwrite (MainWindow* self,
                                             DrawArea* da);
VALA_EXTERN void draw_area_initialize_for_open (DrawArea* self);
VALA_EXTERN gboolean draw_area_save (DrawArea* self,
                         xmlNode* parent);
VALA_EXTERN gboolean document_remove (Document* self);
VALA_EXTERN gboolean document_get_save_needed (Document* self);
VALA_EXTERN gchar* document_get_label (Document* self);
VALA_EXTERN gboolean document_get_readonly (Document* self);
VALA_EXTERN gboolean utils_is_read_only (const gchar* fname);
static void document_finalize (GObject * obj);
static GType document_get_type_once (void);
static void _vala_document_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_document_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

static inline gpointer
document_get_instance_private (Document* self)
{
	return G_STRUCT_MEMBER_P (self, Document_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_document_canvas_changed_draw_area_changed (DrawArea* _sender,
                                            gpointer self)
{
	document_canvas_changed ((Document*) self);
}

Document*
document_construct (GType object_type,
                    DrawArea* da)
{
	Document * self = NULL;
	DrawArea* _tmp0_;
	gchar* _tmp1_;
	gchar* dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ImageManager* _tmp14_;
	DrawArea* _tmp15_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Document*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = document_generate_etag (self);
	_g_free0 (self->priv->_etag);
	self->priv->_etag = _tmp1_;
	_tmp2_ = g_get_user_data_dir ();
	_tmp3_ = g_build_filename (_tmp2_, "minder", NULL);
	dir = _tmp3_;
	_tmp4_ = dir;
	if (g_mkdir_with_parents (_tmp4_, 0775) == 0) {
		gint i = 0;
		i = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				const gchar* _tmp7_;
				gint _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				if (!_tmp5_) {
					const gchar* _tmp6_;
					_tmp6_ = self->priv->_filename;
					if (!g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
						break;
					}
				}
				_tmp5_ = FALSE;
				_tmp7_ = dir;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = g_strdup_printf ("%d.minder", _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_ ("unnamed"), _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_build_filename (_tmp7_, _tmp12_, NULL);
				_g_free0 (self->priv->_filename);
				self->priv->_filename = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
			}
		}
		self->priv->_from_user = FALSE;
	}
	_tmp14_ = image_manager_new ();
	_image_manager_unref0 (self->priv->_image_manager);
	self->priv->_image_manager = _tmp14_;
	_tmp15_ = self->priv->_da;
	g_signal_connect_object (_tmp15_, "changed", (GCallback) _document_canvas_changed_draw_area_changed, self, 0);
	_g_free0 (dir);
	return self;
}

Document*
document_new (DrawArea* da)
{
	return document_construct (TYPE_DOCUMENT, da);
}

static gchar*
document_generate_etag (Document* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%u", g_random_int ());
	result = _tmp0_;
	return result;
}

static void
document_canvas_changed (Document* self)
{
	g_return_if_fail (self != NULL);
	document_set_save_needed (self, TRUE);
	document_auto_save (self);
}

void
document_load_filename (Document* self,
                        const gchar* fname,
                        gboolean saved)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (fname != NULL);
	document_set_filename (self, fname);
	self->priv->_from_user = saved;
}

gboolean
document_is_saved (Document* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_from_user;
	return result;
}

gboolean
document_xml_find (const gchar* fname,
                   gint id,
                   gchar** name)
{
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	gboolean found = FALSE;
	xmlDoc* _tmp1_;
	xmlDoc* _tmp2_;
	xmlNode* _tmp3_;
	gboolean _tmp4_;
	xmlDoc* _tmp5_;
	gboolean result;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (*name != NULL, FALSE);
	_tmp0_ = xmlReadFile (fname, NULL, (gint) XML_PARSE_HUGE);
	doc = _tmp0_;
	found = FALSE;
	_tmp1_ = doc;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = doc;
	_tmp3_ = xmlDocGetRootElement (_tmp2_);
	_tmp4_ = draw_area_xml_find (_tmp3_, id, name);
	found = _tmp4_;
	_tmp5_ = doc;
	_xmlFreeDoc0 (_tmp5_);
	result = found;
	return result;
}

static xmlDoc*
document_load_raw (Document* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_get_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = xmlReadFile (_tmp1_, NULL, (gint) (XML_PARSE_HUGE | XML_PARSE_NOWARNING));
	result = _tmp2_;
	return result;
}

static gchar*
document_get_etag (Document* self,
                   xmlDoc* doc)
{
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		xmlAttr* prop = NULL;
		xmlNode* _tmp0_;
		xmlAttr* _tmp1_;
		_tmp0_ = xmlDocGetRootElement (doc);
		_tmp1_ = _tmp0_->properties;
		prop = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				xmlAttr* _tmp10_;
				xmlNode* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				if (!_tmp2_) {
					xmlAttr* _tmp3_;
					xmlAttr* _tmp4_;
					_tmp3_ = prop;
					_tmp4_ = _tmp3_->next;
					prop = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = prop;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = prop;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = g_strdup (_tmp7_);
				attr_name = _tmp8_;
				_tmp9_ = attr_name;
				if (g_strcmp0 (_tmp9_, "etag") != 0) {
					_g_free0 (attr_name);
					continue;
				}
				_tmp10_ = prop;
				_tmp11_ = _tmp10_->children;
				_tmp12_ = _tmp11_->content;
				_tmp13_ = g_strdup (_tmp12_);
				result = _tmp13_;
				_g_free0 (attr_name);
				return result;
			}
		}
	}
	_tmp14_ = g_strdup ("");
	result = _tmp14_;
	return result;
}

gboolean
document_load (Document* self)
{
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlDoc* _tmp2_;
	gchar* _tmp3_;
	DrawArea* _tmp4_;
	xmlDoc* _tmp5_;
	xmlNode* _tmp6_;
	xmlDoc* _tmp7_;
	const gchar* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_load_raw (self);
	doc = _tmp0_;
	_tmp1_ = doc;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = doc;
	_tmp3_ = document_get_etag (self, _tmp2_);
	_g_free0 (self->priv->_etag);
	self->priv->_etag = _tmp3_;
	_tmp4_ = self->priv->_da;
	_tmp5_ = doc;
	_tmp6_ = xmlDocGetRootElement (_tmp5_);
	draw_area_load (_tmp4_, _tmp6_);
	_tmp7_ = doc;
	_xmlFreeDoc0 (_tmp7_);
	_tmp8_ = self->priv->_etag;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = document_generate_etag (self);
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp9_;
		_tmp10_ = document_get_filename (self);
		_tmp11_ = _tmp10_;
		document_save_internal (self, _tmp11_, FALSE);
	}
	result = TRUE;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

gboolean
document_save (Document* self)
{
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlDoc* _tmp1_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_load_raw (self);
	doc = _tmp0_;
	_tmp1_ = doc;
	if (_tmp1_ != NULL) {
		gchar* file_etag = NULL;
		xmlDoc* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		xmlDoc* _tmp35_;
		_tmp2_ = doc;
		_tmp3_ = document_get_etag (self, _tmp2_);
		file_etag = _tmp3_;
		_tmp4_ = self->priv->_etag;
		_tmp5_ = file_etag;
		if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
			GDateTime* now = NULL;
			GDateTime* _tmp6_;
			DrawArea* _tmp7_;
			MainWindow* _tmp8_;
			MainWindow* _tmp9_;
			DrawArea* _tmp10_;
			_tmp6_ = g_date_time_new_now_local ();
			now = _tmp6_;
			_tmp7_ = self->priv->_da;
			_tmp8_ = draw_area_get_win (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->_da;
			if (main_window_ask_modified_overwrite (_tmp9_, _tmp10_)) {
				gchar* fname = NULL;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GDateTime* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				xmlDoc* _tmp21_;
				const gchar* _tmp22_;
				_tmp11_ = document_get_filename (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = now;
				_tmp14_ = g_date_time_to_string (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = file_etag;
				_tmp17_ = g_strdup_printf ("-backup-%s-%s.mind", _tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = string_replace (_tmp12_, ".mind", _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				fname = _tmp20_;
				_tmp21_ = doc;
				_tmp22_ = fname;
				xmlSaveFormatFile (_tmp22_, _tmp21_, 1);
				_g_free0 (fname);
			} else {
				gchar* fname = NULL;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GDateTime* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				DrawArea* _tmp34_;
				_tmp23_ = document_get_filename (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = now;
				_tmp26_ = g_date_time_to_string (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = self->priv->_etag;
				_tmp29_ = g_strdup_printf ("-backup-%s-%s.mind", _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = string_replace (_tmp24_, ".mind", _tmp30_);
				_tmp32_ = _tmp31_;
				_g_free0 (_tmp30_);
				_g_free0 (_tmp27_);
				fname = _tmp32_;
				_tmp33_ = fname;
				document_save_internal (self, _tmp33_, FALSE);
				_tmp34_ = self->priv->_da;
				draw_area_initialize_for_open (_tmp34_);
				document_load (self);
				result = FALSE;
				_g_free0 (fname);
				_g_date_time_unref0 (now);
				_g_free0 (file_etag);
				return result;
			}
			_g_date_time_unref0 (now);
		}
		_tmp35_ = doc;
		_xmlFreeDoc0 (_tmp35_);
		_g_free0 (file_etag);
	}
	_tmp36_ = document_get_filename (self);
	_tmp37_ = _tmp36_;
	result = document_save_internal (self, _tmp37_, TRUE);
	return result;
}

static gboolean
document_save_internal (Document* self,
                        const gchar* dest_filename,
                        gboolean bump_etag)
{
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlNode* root = NULL;
	xmlNode* _tmp1_;
	gchar* orig_etag = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	xmlNode* _tmp4_;
	const gchar* _tmp5_;
	xmlNode* _tmp9_;
	const gchar* _tmp10_;
	xmlDoc* _tmp11_;
	xmlNode* _tmp12_;
	DrawArea* _tmp13_;
	xmlNode* _tmp14_;
	gint res = 0;
	xmlDoc* _tmp15_;
	xmlDoc* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dest_filename != NULL, FALSE);
	_tmp0_ = xmlNewDoc ((xmlChar*) "1.0");
	doc = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "minder");
	root = _tmp1_;
	_tmp2_ = self->priv->_etag;
	_tmp3_ = g_strdup (_tmp2_);
	orig_etag = _tmp3_;
	_tmp4_ = root;
	_tmp5_ = minder_version;
	xmlSetProp (_tmp4_, (xmlChar*) "version", (xmlChar*) _tmp5_);
	if (bump_etag) {
		xmlNode* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = root;
		_tmp7_ = self->priv->_etag;
		xmlSetProp (_tmp6_, (xmlChar*) "parent-etag", (xmlChar*) _tmp7_);
		_tmp8_ = document_generate_etag (self);
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp8_;
	}
	_tmp9_ = root;
	_tmp10_ = self->priv->_etag;
	xmlSetProp (_tmp9_, (xmlChar*) "etag", (xmlChar*) _tmp10_);
	_tmp11_ = doc;
	_tmp12_ = root;
	xmlDocSetRootElement (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->_da;
	_tmp14_ = root;
	draw_area_save (_tmp13_, _tmp14_);
	_tmp15_ = doc;
	res = xmlSaveFormatFile (dest_filename, _tmp15_, 1);
	_tmp16_ = doc;
	_xmlFreeDoc0 (_tmp16_);
	if (res < 0) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = orig_etag;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp18_;
		result = FALSE;
		_g_free0 (orig_etag);
		return result;
	}
	document_set_save_needed (self, FALSE);
	result = TRUE;
	_g_free0 (orig_etag);
	return result;
}

gboolean
document_remove (Document* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->_from_user) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->_filename;
		g_unlink (_tmp0_);
	}
	result = TRUE;
	return result;
}

void
document_auto_save (Document* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_save_needed;
	if (_tmp0_) {
		document_save (self);
	}
}

const gchar*
document_get_filename (Document* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

void
document_set_filename (Document* self,
                       const gchar* value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_filename;
	if (g_strcmp0 (_tmp0_, value) != 0) {
		gchar* _tmp2_;
		if (!self->priv->_from_user) {
			const gchar* _tmp1_;
			_tmp1_ = self->priv->_filename;
			g_unlink (_tmp1_);
		}
		_tmp2_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp2_;
		self->priv->_from_user = TRUE;
	}
	g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_FILENAME_PROPERTY]);
}

gchar*
document_get_label (Document* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	_tmp1_ = g_path_get_basename (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
document_get_save_needed (Document* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_needed;
	return result;
}

static void
document_set_save_needed (Document* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = document_get_save_needed (self);
	if (old_value != value) {
		self->priv->_save_needed = value;
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_SAVE_NEEDED_PROPERTY]);
	}
}

gboolean
document_get_readonly (Document* self)
{
	gboolean result;
	gboolean prev_read_only = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	prev_read_only = self->priv->_read_only;
	_tmp0_ = self->priv->_filename;
	self->priv->_read_only = utils_is_read_only (_tmp0_);
	_tmp3_ = self->priv->_save_needed;
	if (_tmp3_) {
		_tmp2_ = prev_read_only;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !self->priv->_read_only;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		document_save (self);
	}
	result = self->priv->_read_only;
	return result;
}

static void
document_class_init (DocumentClass * klass,
                     gpointer klass_data)
{
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Document_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_FILENAME_PROPERTY, document_properties[DOCUMENT_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LABEL_PROPERTY, document_properties[DOCUMENT_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_SAVE_NEEDED_PROPERTY, document_properties[DOCUMENT_SAVE_NEEDED_PROPERTY] = g_param_spec_boolean ("save-needed", "save-needed", "save-needed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY_PROPERTY, document_properties[DOCUMENT_READONLY_PROPERTY] = g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
document_instance_init (Document * self,
                        gpointer klass)
{
	self->priv = document_get_instance_private (self);
	self->priv->_read_only = FALSE;
	self->priv->_save_needed = FALSE;
}

static void
document_finalize (GObject * obj)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
	_g_object_unref0 (self->priv->_da);
	_g_free0 (self->priv->_filename);
	_image_manager_unref0 (self->priv->_image_manager);
	_g_free0 (self->priv->_etag);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}

static GType
document_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
	GType document_type_id;
	document_type_id = g_type_register_static (G_TYPE_OBJECT, "Document", &g_define_type_info, 0);
	Document_private_offset = g_type_add_instance_private (document_type_id, sizeof (DocumentPrivate));
	return document_type_id;
}

GType
document_get_type (void)
{
	static volatile gsize document_type_id__once = 0;
	if (g_once_init_enter (&document_type_id__once)) {
		GType document_type_id;
		document_type_id = document_get_type_once ();
		g_once_init_leave (&document_type_id__once, document_type_id);
	}
	return document_type_id__once;
}

static void
_vala_document_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_FILENAME_PROPERTY:
		g_value_set_string (value, document_get_filename (self));
		break;
		case DOCUMENT_LABEL_PROPERTY:
		g_value_take_string (value, document_get_label (self));
		break;
		case DOCUMENT_SAVE_NEEDED_PROPERTY:
		g_value_set_boolean (value, document_get_save_needed (self));
		break;
		case DOCUMENT_READONLY_PROPERTY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_document_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_FILENAME_PROPERTY:
		document_set_filename (self, g_value_get_string (value));
		break;
		case DOCUMENT_SAVE_NEEDED_PROPERTY:
		document_set_save_needed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

