#ifdef GET_AT_DECL
enum ATValues {
  S1E1R = 960,
  S1E2R = 9152,
  S1E3R = 13248,
  S1E1W = 961,
  S1E2W = 9153,
  S1E3W = 13249,
  S1E0R = 962,
  S1E0W = 963,
  S12E1R = 9156,
  S12E1W = 9157,
  S12E0R = 9158,
  S12E0W = 9159,
  S1E1RP = 968,
  S1E1WP = 969,
};
#endif

#ifdef GET_BTI_DECL
enum BTIValues {
  c = 2,
  j = 4,
  jc = 6,
};
#endif

#ifdef GET_DB_DECL
enum DBValues {
  oshld = 1,
  oshst = 2,
  osh = 3,
  nshld = 5,
  nshst = 6,
  nsh = 7,
  ishld = 9,
  ishst = 10,
  ish = 11,
  ld = 13,
  st = 14,
  sy = 15,
};
#endif

#ifdef GET_DBNXS_DECL
enum DBnXSValues {
  oshnxs = 3,
  nshnxs = 7,
  ishnxs = 11,
  synxs = 15,
};
#endif

#ifdef GET_DC_DECL
enum DCValues {
  ZVA = 7073,
  IVAC = 945,
  ISW = 946,
  CVAC = 7121,
  CSW = 978,
  CVAU = 7129,
  CIVAC = 7153,
  CISW = 1010,
  CVAP = 7137,
  CVADP = 7145,
  IGVAC = 947,
  IGSW = 948,
  CGSW = 980,
  CIGSW = 1012,
  CGVAC = 7123,
  CGVAP = 7139,
  CGVADP = 7147,
  CIGVAC = 7155,
  GVA = 7075,
  IGDVAC = 949,
  IGDSW = 950,
  CGDSW = 982,
  CIGDSW = 1014,
  CGDVAC = 7125,
  CGDVAP = 7141,
  CGDVADP = 7149,
  CIGDVAC = 7157,
  GZVA = 7076,
};
#endif

#ifdef GET_EXACTFPIMM_DECL
enum ExactFPImmValues {
  zero = 0,
  half = 1,
  one = 2,
  two = 3,
};
#endif

#ifdef GET_IC_DECL
enum ICValues {
  IALLUIS = 904,
  IALLU = 936,
  IVAU = 7081,
};
#endif

#ifdef GET_ISB_DECL
enum ISBValues {
  sy = 15,
};
#endif

#ifdef GET_PRCTX_DECL
enum PRCTXValues {
  RCTX = 883,
};
#endif

#ifdef GET_PRFM_DECL
enum PRFMValues {
  pldl1keep = 0,
  pldl1strm = 1,
  pldl2keep = 2,
  pldl2strm = 3,
  pldl3keep = 4,
  pldl3strm = 5,
  plil1keep = 8,
  plil1strm = 9,
  plil2keep = 10,
  plil2strm = 11,
  plil3keep = 12,
  plil3strm = 13,
  pstl1keep = 16,
  pstl1strm = 17,
  pstl2keep = 18,
  pstl2strm = 19,
  pstl3keep = 20,
  pstl3strm = 21,
};
#endif

#ifdef GET_PSB_DECL
enum PSBValues {
  csync = 17,
};
#endif

#ifdef GET_PSTATE_DECL
enum PStateValues {
  SPSel = 5,
  DAIFSet = 30,
  DAIFClr = 31,
  PAN = 4,
  UAO = 3,
  DIT = 26,
  SSBS = 25,
  TCO = 28,
};
#endif

#ifdef GET_SVCR_DECL
enum SVCRValues {
  SVCRSM = 1,
  SVCRZA = 2,
  SVCRSMZA = 3,
};
#endif

#ifdef GET_SVEPREDPAT_DECL
enum SVEPREDPATValues {
  pow2 = 0,
  vl1 = 1,
  vl2 = 2,
  vl3 = 3,
  vl4 = 4,
  vl5 = 5,
  vl6 = 6,
  vl7 = 7,
  vl8 = 8,
  vl16 = 9,
  vl32 = 10,
  vl64 = 11,
  vl128 = 12,
  vl256 = 13,
  mul4 = 29,
  mul3 = 30,
  all = 31,
};
#endif

#ifdef GET_SVEPRFM_DECL
enum SVEPRFMValues {
  pldl1keep = 0,
  pldl1strm = 1,
  pldl2keep = 2,
  pldl2strm = 3,
  pldl3keep = 4,
  pldl3strm = 5,
  pstl1keep = 8,
  pstl1strm = 9,
  pstl2keep = 10,
  pstl2strm = 11,
  pstl3keep = 12,
  pstl3strm = 13,
};
#endif

#ifdef GET_SYSREG_DECL
enum SysRegValues {
  MDCCSR_EL0 = 38920,
  DBGDTRRX_EL0 = 38952,
  MDRAR_EL1 = 32896,
  OSLSR_EL1 = 32908,
  DBGAUTHSTATUS_EL1 = 33782,
  PMCEID0_EL0 = 56550,
  PMCEID1_EL0 = 56551,
  PMMIR_EL1 = 50422,
  MIDR_EL1 = 49152,
  CCSIDR_EL1 = 51200,
  CCSIDR2_EL1 = 51202,
  CLIDR_EL1 = 51201,
  CTR_EL0 = 55297,
  MPIDR_EL1 = 49157,
  REVIDR_EL1 = 49158,
  AIDR_EL1 = 51207,
  DCZID_EL0 = 55303,
  ID_PFR0_EL1 = 49160,
  ID_PFR1_EL1 = 49161,
  ID_PFR2_EL1 = 49180,
  ID_DFR0_EL1 = 49162,
  ID_AFR0_EL1 = 49163,
  ID_MMFR0_EL1 = 49164,
  ID_MMFR1_EL1 = 49165,
  ID_MMFR2_EL1 = 49166,
  ID_MMFR3_EL1 = 49167,
  ID_ISAR0_EL1 = 49168,
  ID_ISAR1_EL1 = 49169,
  ID_ISAR2_EL1 = 49170,
  ID_ISAR3_EL1 = 49171,
  ID_ISAR4_EL1 = 49172,
  ID_ISAR5_EL1 = 49173,
  ID_ISAR6_EL1 = 49175,
  ID_AA64PFR0_EL1 = 49184,
  ID_AA64PFR1_EL1 = 49185,
  ID_AA64DFR0_EL1 = 49192,
  ID_AA64DFR1_EL1 = 49193,
  ID_AA64AFR0_EL1 = 49196,
  ID_AA64AFR1_EL1 = 49197,
  ID_AA64ISAR0_EL1 = 49200,
  ID_AA64ISAR1_EL1 = 49201,
  ID_AA64ISAR2_EL1 = 49202,
  ID_AA64MMFR0_EL1 = 49208,
  ID_AA64MMFR1_EL1 = 49209,
  ID_AA64MMFR2_EL1 = 49210,
  MVFR0_EL1 = 49176,
  MVFR1_EL1 = 49177,
  MVFR2_EL1 = 49178,
  RVBAR_EL1 = 50689,
  RVBAR_EL2 = 58881,
  RVBAR_EL3 = 62977,
  ISR_EL1 = 50696,
  CNTPCT_EL0 = 57089,
  CNTVCT_EL0 = 57090,
  ID_MMFR4_EL1 = 49174,
  ID_MMFR5_EL1 = 49182,
  TRCSTATR = 34840,
  TRCIDR8 = 34822,
  TRCIDR9 = 34830,
  TRCIDR10 = 34838,
  TRCIDR11 = 34846,
  TRCIDR12 = 34854,
  TRCIDR13 = 34862,
  TRCIDR0 = 34887,
  TRCIDR1 = 34895,
  TRCIDR2 = 34903,
  TRCIDR3 = 34911,
  TRCIDR4 = 34919,
  TRCIDR5 = 34927,
  TRCIDR6 = 34935,
  TRCIDR7 = 34943,
  TRCOSLSR = 34956,
  TRCPDSR = 34988,
  TRCDEVAFF0 = 35798,
  TRCDEVAFF1 = 35806,
  TRCLSR = 35822,
  TRCAUTHSTATUS = 35830,
  TRCDEVARCH = 35838,
  TRCDEVID = 35735,
  TRCDEVTYPE = 35743,
  TRCPIDR4 = 35751,
  TRCPIDR5 = 35759,
  TRCPIDR6 = 35767,
  TRCPIDR7 = 35775,
  TRCPIDR0 = 35783,
  TRCPIDR1 = 35791,
  TRCPIDR2 = 35799,
  TRCPIDR3 = 35807,
  TRCCIDR0 = 35815,
  TRCCIDR1 = 35823,
  TRCCIDR2 = 35831,
  TRCCIDR3 = 35839,
  ICC_IAR1_EL1 = 50784,
  ICC_IAR0_EL1 = 50752,
  ICC_HPPIR1_EL1 = 50786,
  ICC_HPPIR0_EL1 = 50754,
  ICC_RPR_EL1 = 50779,
  ICH_VTR_EL2 = 58969,
  ICH_EISR_EL2 = 58971,
  ICH_ELRSR_EL2 = 58973,
  ID_AA64ZFR0_EL1 = 49188,
  LORID_EL1 = 50471,
  ERRIDR_EL1 = 49816,
  ERXFR_EL1 = 49824,
  RNDR = 55584,
  RNDRRS = 55585,
  SCXTNUM_EL0 = 56967,
  SCXTNUM_EL1 = 50823,
  SCXTNUM_EL2 = 59015,
  SCXTNUM_EL3 = 63111,
  SCXTNUM_EL12 = 61063,
  MFAR_EL3 = 62213,
  GPCCR_EL3 = 61710,
  GPTBR_EL3 = 61708,
  ID_AA64SMFR0_EL1 = 49189,
  DBGDTRTX_EL0 = 38952,
  OSLAR_EL1 = 32900,
  PMSWINC_EL0 = 56548,
  TRCOSLAR = 34948,
  TRCLAR = 35814,
  ICC_EOIR1_EL1 = 50785,
  ICC_EOIR0_EL1 = 50753,
  ICC_DIR_EL1 = 50777,
  ICC_SGI1R_EL1 = 50781,
  ICC_ASGI1R_EL1 = 50782,
  ICC_SGI0R_EL1 = 50783,
  OSDTRRX_EL1 = 32770,
  OSDTRTX_EL1 = 32794,
  TEECR32_EL1 = 36864,
  MDCCINT_EL1 = 32784,
  MDSCR_EL1 = 32786,
  DBGDTR_EL0 = 38944,
  OSECCR_EL1 = 32818,
  DBGVCR32_EL2 = 41016,
  DBGBVR0_EL1 = 32772,
  DBGBVR1_EL1 = 32780,
  DBGBVR2_EL1 = 32788,
  DBGBVR3_EL1 = 32796,
  DBGBVR4_EL1 = 32804,
  DBGBVR5_EL1 = 32812,
  DBGBVR6_EL1 = 32820,
  DBGBVR7_EL1 = 32828,
  DBGBVR8_EL1 = 32836,
  DBGBVR9_EL1 = 32844,
  DBGBVR10_EL1 = 32852,
  DBGBVR11_EL1 = 32860,
  DBGBVR12_EL1 = 32868,
  DBGBVR13_EL1 = 32876,
  DBGBVR14_EL1 = 32884,
  DBGBVR15_EL1 = 32892,
  DBGBCR0_EL1 = 32773,
  DBGBCR1_EL1 = 32781,
  DBGBCR2_EL1 = 32789,
  DBGBCR3_EL1 = 32797,
  DBGBCR4_EL1 = 32805,
  DBGBCR5_EL1 = 32813,
  DBGBCR6_EL1 = 32821,
  DBGBCR7_EL1 = 32829,
  DBGBCR8_EL1 = 32837,
  DBGBCR9_EL1 = 32845,
  DBGBCR10_EL1 = 32853,
  DBGBCR11_EL1 = 32861,
  DBGBCR12_EL1 = 32869,
  DBGBCR13_EL1 = 32877,
  DBGBCR14_EL1 = 32885,
  DBGBCR15_EL1 = 32893,
  DBGWVR0_EL1 = 32774,
  DBGWVR1_EL1 = 32782,
  DBGWVR2_EL1 = 32790,
  DBGWVR3_EL1 = 32798,
  DBGWVR4_EL1 = 32806,
  DBGWVR5_EL1 = 32814,
  DBGWVR6_EL1 = 32822,
  DBGWVR7_EL1 = 32830,
  DBGWVR8_EL1 = 32838,
  DBGWVR9_EL1 = 32846,
  DBGWVR10_EL1 = 32854,
  DBGWVR11_EL1 = 32862,
  DBGWVR12_EL1 = 32870,
  DBGWVR13_EL1 = 32878,
  DBGWVR14_EL1 = 32886,
  DBGWVR15_EL1 = 32894,
  DBGWCR0_EL1 = 32775,
  DBGWCR1_EL1 = 32783,
  DBGWCR2_EL1 = 32791,
  DBGWCR3_EL1 = 32799,
  DBGWCR4_EL1 = 32807,
  DBGWCR5_EL1 = 32815,
  DBGWCR6_EL1 = 32823,
  DBGWCR7_EL1 = 32831,
  DBGWCR8_EL1 = 32839,
  DBGWCR9_EL1 = 32847,
  DBGWCR10_EL1 = 32855,
  DBGWCR11_EL1 = 32863,
  DBGWCR12_EL1 = 32871,
  DBGWCR13_EL1 = 32879,
  DBGWCR14_EL1 = 32887,
  DBGWCR15_EL1 = 32895,
  TEEHBR32_EL1 = 36992,
  OSDLR_EL1 = 32924,
  DBGPRCR_EL1 = 32932,
  DBGCLAIMSET_EL1 = 33734,
  DBGCLAIMCLR_EL1 = 33742,
  CSSELR_EL1 = 53248,
  VPIDR_EL2 = 57344,
  VMPIDR_EL2 = 57349,
  CPACR_EL1 = 49282,
  SCTLR_EL1 = 49280,
  SCTLR_EL2 = 57472,
  SCTLR_EL3 = 61568,
  ACTLR_EL1 = 49281,
  ACTLR_EL2 = 57473,
  ACTLR_EL3 = 61569,
  HCR_EL2 = 57480,
  HCRX_EL2 = 57490,
  SCR_EL3 = 61576,
  MDCR_EL2 = 57481,
  SDER32_EL3 = 61577,
  CPTR_EL2 = 57482,
  CPTR_EL3 = 61578,
  HSTR_EL2 = 57483,
  HACR_EL2 = 57487,
  MDCR_EL3 = 61593,
  TTBR0_EL1 = 49408,
  TTBR0_EL3 = 61696,
  TTBR0_EL2 = 57600,
  VTTBR_EL2 = 57608,
  TTBR1_EL1 = 49409,
  TCR_EL1 = 49410,
  TCR_EL2 = 57602,
  TCR_EL3 = 61698,
  VTCR_EL2 = 57610,
  DACR32_EL2 = 57728,
  SPSR_EL1 = 49664,
  SPSR_EL2 = 57856,
  SPSR_EL3 = 61952,
  ELR_EL1 = 49665,
  ELR_EL2 = 57857,
  ELR_EL3 = 61953,
  SP_EL0 = 49672,
  SP_EL1 = 57864,
  SP_EL2 = 61960,
  SPSel = 49680,
  NZCV = 55824,
  DAIF = 55825,
  CurrentEL = 49682,
  SPSR_irq = 57880,
  SPSR_abt = 57881,
  SPSR_und = 57882,
  SPSR_fiq = 57883,
  FPCR = 55840,
  FPSR = 55841,
  DSPSR_EL0 = 55848,
  DLR_EL0 = 55849,
  IFSR32_EL2 = 57985,
  AFSR0_EL1 = 49800,
  AFSR0_EL2 = 57992,
  AFSR0_EL3 = 62088,
  AFSR1_EL1 = 49801,
  AFSR1_EL2 = 57993,
  AFSR1_EL3 = 62089,
  ESR_EL1 = 49808,
  ESR_EL2 = 58000,
  ESR_EL3 = 62096,
  FPEXC32_EL2 = 58008,
  FAR_EL1 = 49920,
  FAR_EL2 = 58112,
  FAR_EL3 = 62208,
  HPFAR_EL2 = 58116,
  PAR_EL1 = 50080,
  PMCR_EL0 = 56544,
  PMCNTENSET_EL0 = 56545,
  PMCNTENCLR_EL0 = 56546,
  PMOVSCLR_EL0 = 56547,
  PMSELR_EL0 = 56549,
  PMCCNTR_EL0 = 56552,
  PMXEVTYPER_EL0 = 56553,
  PMXEVCNTR_EL0 = 56554,
  PMUSERENR_EL0 = 56560,
  PMINTENSET_EL1 = 50417,
  PMINTENCLR_EL1 = 50418,
  PMOVSSET_EL0 = 56563,
  MAIR_EL1 = 50448,
  MAIR_EL2 = 58640,
  MAIR_EL3 = 62736,
  AMAIR_EL1 = 50456,
  AMAIR_EL2 = 58648,
  AMAIR_EL3 = 62744,
  VBAR_EL1 = 50688,
  VBAR_EL2 = 58880,
  VBAR_EL3 = 62976,
  RMR_EL1 = 50690,
  RMR_EL2 = 58882,
  RMR_EL3 = 62978,
  CONTEXTIDR_EL1 = 50817,
  TPIDR_EL0 = 56962,
  TPIDR_EL2 = 59010,
  TPIDR_EL3 = 63106,
  TPIDRRO_EL0 = 56963,
  TPIDR_EL1 = 50820,
  CNTFRQ_EL0 = 57088,
  CNTVOFF_EL2 = 59139,
  CNTKCTL_EL1 = 50952,
  CNTHCTL_EL2 = 59144,
  CNTP_TVAL_EL0 = 57104,
  CNTHP_TVAL_EL2 = 59152,
  CNTPS_TVAL_EL1 = 65296,
  CNTP_CTL_EL0 = 57105,
  CNTHP_CTL_EL2 = 59153,
  CNTPS_CTL_EL1 = 65297,
  CNTP_CVAL_EL0 = 57106,
  CNTHP_CVAL_EL2 = 59154,
  CNTPS_CVAL_EL1 = 65298,
  CNTV_TVAL_EL0 = 57112,
  CNTV_CTL_EL0 = 57113,
  CNTV_CVAL_EL0 = 57114,
  PMEVCNTR0_EL0 = 57152,
  PMEVCNTR1_EL0 = 57153,
  PMEVCNTR2_EL0 = 57154,
  PMEVCNTR3_EL0 = 57155,
  PMEVCNTR4_EL0 = 57156,
  PMEVCNTR5_EL0 = 57157,
  PMEVCNTR6_EL0 = 57158,
  PMEVCNTR7_EL0 = 57159,
  PMEVCNTR8_EL0 = 57160,
  PMEVCNTR9_EL0 = 57161,
  PMEVCNTR10_EL0 = 57162,
  PMEVCNTR11_EL0 = 57163,
  PMEVCNTR12_EL0 = 57164,
  PMEVCNTR13_EL0 = 57165,
  PMEVCNTR14_EL0 = 57166,
  PMEVCNTR15_EL0 = 57167,
  PMEVCNTR16_EL0 = 57168,
  PMEVCNTR17_EL0 = 57169,
  PMEVCNTR18_EL0 = 57170,
  PMEVCNTR19_EL0 = 57171,
  PMEVCNTR20_EL0 = 57172,
  PMEVCNTR21_EL0 = 57173,
  PMEVCNTR22_EL0 = 57174,
  PMEVCNTR23_EL0 = 57175,
  PMEVCNTR24_EL0 = 57176,
  PMEVCNTR25_EL0 = 57177,
  PMEVCNTR26_EL0 = 57178,
  PMEVCNTR27_EL0 = 57179,
  PMEVCNTR28_EL0 = 57180,
  PMEVCNTR29_EL0 = 57181,
  PMEVCNTR30_EL0 = 57182,
  PMCCFILTR_EL0 = 57215,
  PMEVTYPER0_EL0 = 57184,
  PMEVTYPER1_EL0 = 57185,
  PMEVTYPER2_EL0 = 57186,
  PMEVTYPER3_EL0 = 57187,
  PMEVTYPER4_EL0 = 57188,
  PMEVTYPER5_EL0 = 57189,
  PMEVTYPER6_EL0 = 57190,
  PMEVTYPER7_EL0 = 57191,
  PMEVTYPER8_EL0 = 57192,
  PMEVTYPER9_EL0 = 57193,
  PMEVTYPER10_EL0 = 57194,
  PMEVTYPER11_EL0 = 57195,
  PMEVTYPER12_EL0 = 57196,
  PMEVTYPER13_EL0 = 57197,
  PMEVTYPER14_EL0 = 57198,
  PMEVTYPER15_EL0 = 57199,
  PMEVTYPER16_EL0 = 57200,
  PMEVTYPER17_EL0 = 57201,
  PMEVTYPER18_EL0 = 57202,
  PMEVTYPER19_EL0 = 57203,
  PMEVTYPER20_EL0 = 57204,
  PMEVTYPER21_EL0 = 57205,
  PMEVTYPER22_EL0 = 57206,
  PMEVTYPER23_EL0 = 57207,
  PMEVTYPER24_EL0 = 57208,
  PMEVTYPER25_EL0 = 57209,
  PMEVTYPER26_EL0 = 57210,
  PMEVTYPER27_EL0 = 57211,
  PMEVTYPER28_EL0 = 57212,
  PMEVTYPER29_EL0 = 57213,
  PMEVTYPER30_EL0 = 57214,
  TRCPRGCTLR = 34824,
  TRCPROCSELR = 34832,
  TRCCONFIGR = 34848,
  TRCAUXCTLR = 34864,
  TRCEVENTCTL0R = 34880,
  TRCEVENTCTL1R = 34888,
  TRCSTALLCTLR = 34904,
  TRCTSCTLR = 34912,
  TRCSYNCPR = 34920,
  TRCCCCTLR = 34928,
  TRCBBCTLR = 34936,
  TRCTRACEIDR = 34817,
  TRCQCTLR = 34825,
  TRCVICTLR = 34818,
  TRCVIIECTLR = 34826,
  TRCVISSCTLR = 34834,
  TRCVIPCSSCTLR = 34842,
  TRCVDCTLR = 34882,
  TRCVDSACCTLR = 34890,
  TRCVDARCCTLR = 34898,
  TRCSEQEVR0 = 34820,
  TRCSEQEVR1 = 34828,
  TRCSEQEVR2 = 34836,
  TRCSEQRSTEVR = 34868,
  TRCSEQSTR = 34876,
  TRCEXTINSELR = 34884,
  TRCCNTRLDVR0 = 34821,
  TRCCNTRLDVR1 = 34829,
  TRCCNTRLDVR2 = 34837,
  TRCCNTRLDVR3 = 34845,
  TRCCNTCTLR0 = 34853,
  TRCCNTCTLR1 = 34861,
  TRCCNTCTLR2 = 34869,
  TRCCNTCTLR3 = 34877,
  TRCCNTVR0 = 34885,
  TRCCNTVR1 = 34893,
  TRCCNTVR2 = 34901,
  TRCCNTVR3 = 34909,
  TRCIMSPEC0 = 34823,
  TRCIMSPEC1 = 34831,
  TRCIMSPEC2 = 34839,
  TRCIMSPEC3 = 34847,
  TRCIMSPEC4 = 34855,
  TRCIMSPEC5 = 34863,
  TRCIMSPEC6 = 34871,
  TRCIMSPEC7 = 34879,
  TRCRSCTLR2 = 34960,
  TRCRSCTLR3 = 34968,
  TRCRSCTLR4 = 34976,
  TRCRSCTLR5 = 34984,
  TRCRSCTLR6 = 34992,
  TRCRSCTLR7 = 35000,
  TRCRSCTLR8 = 35008,
  TRCRSCTLR9 = 35016,
  TRCRSCTLR10 = 35024,
  TRCRSCTLR11 = 35032,
  TRCRSCTLR12 = 35040,
  TRCRSCTLR13 = 35048,
  TRCRSCTLR14 = 35056,
  TRCRSCTLR15 = 35064,
  TRCRSCTLR16 = 34945,
  TRCRSCTLR17 = 34953,
  TRCRSCTLR18 = 34961,
  TRCRSCTLR19 = 34969,
  TRCRSCTLR20 = 34977,
  TRCRSCTLR21 = 34985,
  TRCRSCTLR22 = 34993,
  TRCRSCTLR23 = 35001,
  TRCRSCTLR24 = 35009,
  TRCRSCTLR25 = 35017,
  TRCRSCTLR26 = 35025,
  TRCRSCTLR27 = 35033,
  TRCRSCTLR28 = 35041,
  TRCRSCTLR29 = 35049,
  TRCRSCTLR30 = 35057,
  TRCRSCTLR31 = 35065,
  TRCSSCCR0 = 34946,
  TRCSSCCR1 = 34954,
  TRCSSCCR2 = 34962,
  TRCSSCCR3 = 34970,
  TRCSSCCR4 = 34978,
  TRCSSCCR5 = 34986,
  TRCSSCCR6 = 34994,
  TRCSSCCR7 = 35002,
  TRCSSCSR0 = 35010,
  TRCSSCSR1 = 35018,
  TRCSSCSR2 = 35026,
  TRCSSCSR3 = 35034,
  TRCSSCSR4 = 35042,
  TRCSSCSR5 = 35050,
  TRCSSCSR6 = 35058,
  TRCSSCSR7 = 35066,
  TRCSSPCICR0 = 34947,
  TRCSSPCICR1 = 34955,
  TRCSSPCICR2 = 34963,
  TRCSSPCICR3 = 34971,
  TRCSSPCICR4 = 34979,
  TRCSSPCICR5 = 34987,
  TRCSSPCICR6 = 34995,
  TRCSSPCICR7 = 35003,
  TRCPDCR = 34980,
  TRCACVR0 = 35072,
  TRCACVR1 = 35088,
  TRCACVR2 = 35104,
  TRCACVR3 = 35120,
  TRCACVR4 = 35136,
  TRCACVR5 = 35152,
  TRCACVR6 = 35168,
  TRCACVR7 = 35184,
  TRCACVR8 = 35073,
  TRCACVR9 = 35089,
  TRCACVR10 = 35105,
  TRCACVR11 = 35121,
  TRCACVR12 = 35137,
  TRCACVR13 = 35153,
  TRCACVR14 = 35169,
  TRCACVR15 = 35185,
  TRCACATR0 = 35074,
  TRCACATR1 = 35090,
  TRCACATR2 = 35106,
  TRCACATR3 = 35122,
  TRCACATR4 = 35138,
  TRCACATR5 = 35154,
  TRCACATR6 = 35170,
  TRCACATR7 = 35186,
  TRCACATR8 = 35075,
  TRCACATR9 = 35091,
  TRCACATR10 = 35107,
  TRCACATR11 = 35123,
  TRCACATR12 = 35139,
  TRCACATR13 = 35155,
  TRCACATR14 = 35171,
  TRCACATR15 = 35187,
  TRCDVCVR0 = 35076,
  TRCDVCVR1 = 35108,
  TRCDVCVR2 = 35140,
  TRCDVCVR3 = 35172,
  TRCDVCVR4 = 35077,
  TRCDVCVR5 = 35109,
  TRCDVCVR6 = 35141,
  TRCDVCVR7 = 35173,
  TRCDVCMR0 = 35078,
  TRCDVCMR1 = 35110,
  TRCDVCMR2 = 35142,
  TRCDVCMR3 = 35174,
  TRCDVCMR4 = 35079,
  TRCDVCMR5 = 35111,
  TRCDVCMR6 = 35143,
  TRCDVCMR7 = 35175,
  TRCCIDCVR0 = 35200,
  TRCCIDCVR1 = 35216,
  TRCCIDCVR2 = 35232,
  TRCCIDCVR3 = 35248,
  TRCCIDCVR4 = 35264,
  TRCCIDCVR5 = 35280,
  TRCCIDCVR6 = 35296,
  TRCCIDCVR7 = 35312,
  TRCVMIDCVR0 = 35201,
  TRCVMIDCVR1 = 35217,
  TRCVMIDCVR2 = 35233,
  TRCVMIDCVR3 = 35249,
  TRCVMIDCVR4 = 35265,
  TRCVMIDCVR5 = 35281,
  TRCVMIDCVR6 = 35297,
  TRCVMIDCVR7 = 35313,
  TRCCIDCCTLR0 = 35202,
  TRCCIDCCTLR1 = 35210,
  TRCVMIDCCTLR0 = 35218,
  TRCVMIDCCTLR1 = 35226,
  TRCITCTRL = 35716,
  TRCCLAIMSET = 35782,
  TRCCLAIMCLR = 35790,
  ICC_BPR1_EL1 = 50787,
  ICC_BPR0_EL1 = 50755,
  ICC_PMR_EL1 = 49712,
  ICC_CTLR_EL1 = 50788,
  ICC_CTLR_EL3 = 63076,
  ICC_SRE_EL1 = 50789,
  ICC_SRE_EL2 = 58957,
  ICC_SRE_EL3 = 63077,
  ICC_IGRPEN0_EL1 = 50790,
  ICC_IGRPEN1_EL1 = 50791,
  ICC_IGRPEN1_EL3 = 63079,
  ICC_AP0R0_EL1 = 50756,
  ICC_AP0R1_EL1 = 50757,
  ICC_AP0R2_EL1 = 50758,
  ICC_AP0R3_EL1 = 50759,
  ICC_AP1R0_EL1 = 50760,
  ICC_AP1R1_EL1 = 50761,
  ICC_AP1R2_EL1 = 50762,
  ICC_AP1R3_EL1 = 50763,
  ICH_AP0R0_EL2 = 58944,
  ICH_AP0R1_EL2 = 58945,
  ICH_AP0R2_EL2 = 58946,
  ICH_AP0R3_EL2 = 58947,
  ICH_AP1R0_EL2 = 58952,
  ICH_AP1R1_EL2 = 58953,
  ICH_AP1R2_EL2 = 58954,
  ICH_AP1R3_EL2 = 58955,
  ICH_HCR_EL2 = 58968,
  ICH_MISR_EL2 = 58970,
  ICH_VMCR_EL2 = 58975,
  ICH_LR0_EL2 = 58976,
  ICH_LR1_EL2 = 58977,
  ICH_LR2_EL2 = 58978,
  ICH_LR3_EL2 = 58979,
  ICH_LR4_EL2 = 58980,
  ICH_LR5_EL2 = 58981,
  ICH_LR6_EL2 = 58982,
  ICH_LR7_EL2 = 58983,
  ICH_LR8_EL2 = 58984,
  ICH_LR9_EL2 = 58985,
  ICH_LR10_EL2 = 58986,
  ICH_LR11_EL2 = 58987,
  ICH_LR12_EL2 = 58988,
  ICH_LR13_EL2 = 58989,
  ICH_LR14_EL2 = 58990,
  ICH_LR15_EL2 = 58991,
  VSCTLR_EL2 = 57600,
  MPUIR_EL1 = 49156,
  MPUIR_EL2 = 57348,
  PRENR_EL1 = 49929,
  PRENR_EL2 = 58121,
  PRSELR_EL1 = 49937,
  PRSELR_EL2 = 58129,
  PRBAR_EL1 = 49984,
  PRBAR_EL2 = 58176,
  PRLAR_EL1 = 49985,
  PRLAR_EL2 = 58177,
  PRBAR1_EL1 = 49988,
  PRLAR1_EL1 = 49989,
  PRBAR1_EL2 = 58180,
  PRLAR1_EL2 = 58181,
  PRBAR2_EL1 = 49992,
  PRLAR2_EL1 = 49993,
  PRBAR2_EL2 = 58184,
  PRLAR2_EL2 = 58185,
  PRBAR3_EL1 = 49996,
  PRLAR3_EL1 = 49997,
  PRBAR3_EL2 = 58188,
  PRLAR3_EL2 = 58189,
  PRBAR4_EL1 = 50000,
  PRLAR4_EL1 = 50001,
  PRBAR4_EL2 = 58192,
  PRLAR4_EL2 = 58193,
  PRBAR5_EL1 = 50004,
  PRLAR5_EL1 = 50005,
  PRBAR5_EL2 = 58196,
  PRLAR5_EL2 = 58197,
  PRBAR6_EL1 = 50008,
  PRLAR6_EL1 = 50009,
  PRBAR6_EL2 = 58200,
  PRLAR6_EL2 = 58201,
  PRBAR7_EL1 = 50012,
  PRLAR7_EL1 = 50013,
  PRBAR7_EL2 = 58204,
  PRLAR7_EL2 = 58205,
  PRBAR8_EL1 = 50016,
  PRLAR8_EL1 = 50017,
  PRBAR8_EL2 = 58208,
  PRLAR8_EL2 = 58209,
  PRBAR9_EL1 = 50020,
  PRLAR9_EL1 = 50021,
  PRBAR9_EL2 = 58212,
  PRLAR9_EL2 = 58213,
  PRBAR10_EL1 = 50024,
  PRLAR10_EL1 = 50025,
  PRBAR10_EL2 = 58216,
  PRLAR10_EL2 = 58217,
  PRBAR11_EL1 = 50028,
  PRLAR11_EL1 = 50029,
  PRBAR11_EL2 = 58220,
  PRLAR11_EL2 = 58221,
  PRBAR12_EL1 = 50032,
  PRLAR12_EL1 = 50033,
  PRBAR12_EL2 = 58224,
  PRLAR12_EL2 = 58225,
  PRBAR13_EL1 = 50036,
  PRLAR13_EL1 = 50037,
  PRBAR13_EL2 = 58228,
  PRLAR13_EL2 = 58229,
  PRBAR14_EL1 = 50040,
  PRLAR14_EL1 = 50041,
  PRBAR14_EL2 = 58232,
  PRLAR14_EL2 = 58233,
  PRBAR15_EL1 = 50044,
  PRLAR15_EL1 = 50045,
  PRBAR15_EL2 = 58236,
  PRLAR15_EL2 = 58237,
  PAN = 49683,
  LORSA_EL1 = 50464,
  LOREA_EL1 = 50465,
  LORN_EL1 = 50466,
  LORC_EL1 = 50467,
  TTBR1_EL2 = 57601,
  CNTHV_TVAL_EL2 = 59160,
  CNTHV_CVAL_EL2 = 59162,
  CNTHV_CTL_EL2 = 59161,
  SCTLR_EL12 = 59520,
  CPACR_EL12 = 59522,
  TTBR0_EL12 = 59648,
  TTBR1_EL12 = 59649,
  TCR_EL12 = 59650,
  AFSR0_EL12 = 60040,
  AFSR1_EL12 = 60041,
  ESR_EL12 = 60048,
  FAR_EL12 = 60160,
  MAIR_EL12 = 60688,
  AMAIR_EL12 = 60696,
  VBAR_EL12 = 60928,
  CONTEXTIDR_EL12 = 61057,
  CNTKCTL_EL12 = 61192,
  CNTP_TVAL_EL02 = 61200,
  CNTP_CTL_EL02 = 61201,
  CNTP_CVAL_EL02 = 61202,
  CNTV_TVAL_EL02 = 61208,
  CNTV_CTL_EL02 = 61209,
  CNTV_CVAL_EL02 = 61210,
  SPSR_EL12 = 59904,
  ELR_EL12 = 59905,
  CONTEXTIDR_EL2 = 59009,
  UAO = 49684,
  PMBLIMITR_EL1 = 50384,
  PMBPTR_EL1 = 50385,
  PMBSR_EL1 = 50387,
  PMBIDR_EL1 = 50391,
  PMSCR_EL2 = 58568,
  PMSCR_EL12 = 60616,
  PMSCR_EL1 = 50376,
  PMSICR_EL1 = 50378,
  PMSIRR_EL1 = 50379,
  PMSFCR_EL1 = 50380,
  PMSEVFR_EL1 = 50381,
  PMSLATFR_EL1 = 50382,
  PMSIDR_EL1 = 50383,
  ERRSELR_EL1 = 49817,
  ERXCTLR_EL1 = 49825,
  ERXSTATUS_EL1 = 49826,
  ERXADDR_EL1 = 49827,
  ERXMISC0_EL1 = 49832,
  ERXMISC1_EL1 = 49833,
  DISR_EL1 = 50697,
  VDISR_EL2 = 58889,
  VSESR_EL2 = 58003,
  APIAKeyLo_EL1 = 49416,
  APIAKeyHi_EL1 = 49417,
  APIBKeyLo_EL1 = 49418,
  APIBKeyHi_EL1 = 49419,
  APDAKeyLo_EL1 = 49424,
  APDAKeyHi_EL1 = 49425,
  APDBKeyLo_EL1 = 49426,
  APDBKeyHi_EL1 = 49427,
  APGAKeyLo_EL1 = 49432,
  APGAKeyHi_EL1 = 49433,
  VSTCR_EL2 = 57650,
  VSTTBR_EL2 = 57648,
  CNTHVS_TVAL_EL2 = 59168,
  CNTHVS_CVAL_EL2 = 59170,
  CNTHVS_CTL_EL2 = 59169,
  CNTHPS_TVAL_EL2 = 59176,
  CNTHPS_CVAL_EL2 = 59178,
  CNTHPS_CTL_EL2 = 59177,
  SDER32_EL2 = 57497,
  ERXPFGCTL_EL1 = 49829,
  ERXPFGCDN_EL1 = 49830,
  ERXMISC2_EL1 = 49834,
  ERXMISC3_EL1 = 49835,
  ERXPFGF_EL1 = 49828,
  MPAM0_EL1 = 50473,
  MPAM1_EL1 = 50472,
  MPAM2_EL2 = 58664,
  MPAM3_EL3 = 62760,
  MPAM1_EL12 = 60712,
  MPAMHCR_EL2 = 58656,
  MPAMVPMV_EL2 = 58657,
  MPAMVPM0_EL2 = 58672,
  MPAMVPM1_EL2 = 58673,
  MPAMVPM2_EL2 = 58674,
  MPAMVPM3_EL2 = 58675,
  MPAMVPM4_EL2 = 58676,
  MPAMVPM5_EL2 = 58677,
  MPAMVPM6_EL2 = 58678,
  MPAMVPM7_EL2 = 58679,
  MPAMIDR_EL1 = 50468,
  AMCR_EL0 = 56976,
  AMCFGR_EL0 = 56977,
  AMCGCR_EL0 = 56978,
  AMUSERENR_EL0 = 56979,
  AMCNTENCLR0_EL0 = 56980,
  AMCNTENSET0_EL0 = 56981,
  AMEVCNTR00_EL0 = 56992,
  AMEVCNTR01_EL0 = 56993,
  AMEVCNTR02_EL0 = 56994,
  AMEVCNTR03_EL0 = 56995,
  AMEVTYPER00_EL0 = 57008,
  AMEVTYPER01_EL0 = 57009,
  AMEVTYPER02_EL0 = 57010,
  AMEVTYPER03_EL0 = 57011,
  AMCNTENCLR1_EL0 = 56984,
  AMCNTENSET1_EL0 = 56985,
  AMEVCNTR10_EL0 = 57056,
  AMEVCNTR11_EL0 = 57057,
  AMEVCNTR12_EL0 = 57058,
  AMEVCNTR13_EL0 = 57059,
  AMEVCNTR14_EL0 = 57060,
  AMEVCNTR15_EL0 = 57061,
  AMEVCNTR16_EL0 = 57062,
  AMEVCNTR17_EL0 = 57063,
  AMEVCNTR18_EL0 = 57064,
  AMEVCNTR19_EL0 = 57065,
  AMEVCNTR110_EL0 = 57066,
  AMEVCNTR111_EL0 = 57067,
  AMEVCNTR112_EL0 = 57068,
  AMEVCNTR113_EL0 = 57069,
  AMEVCNTR114_EL0 = 57070,
  AMEVCNTR115_EL0 = 57071,
  AMEVTYPER10_EL0 = 57072,
  AMEVTYPER11_EL0 = 57073,
  AMEVTYPER12_EL0 = 57074,
  AMEVTYPER13_EL0 = 57075,
  AMEVTYPER14_EL0 = 57076,
  AMEVTYPER15_EL0 = 57077,
  AMEVTYPER16_EL0 = 57078,
  AMEVTYPER17_EL0 = 57079,
  AMEVTYPER18_EL0 = 57080,
  AMEVTYPER19_EL0 = 57081,
  AMEVTYPER110_EL0 = 57082,
  AMEVTYPER111_EL0 = 57083,
  AMEVTYPER112_EL0 = 57084,
  AMEVTYPER113_EL0 = 57085,
  AMEVTYPER114_EL0 = 57086,
  AMEVTYPER115_EL0 = 57087,
  TRFCR_EL1 = 49297,
  TRFCR_EL2 = 57489,
  TRFCR_EL12 = 59537,
  DIT = 55829,
  VNCR_EL2 = 57616,
  ZCR_EL1 = 49296,
  ZCR_EL2 = 57488,
  ZCR_EL3 = 61584,
  ZCR_EL12 = 59536,
  SSBS = 55830,
  TCO = 55831,
  GCR_EL1 = 49286,
  RGSR_EL1 = 49285,
  TFSR_EL1 = 49840,
  TFSR_EL2 = 58032,
  TFSR_EL3 = 62128,
  TFSR_EL12 = 60080,
  TFSRE0_EL1 = 49841,
  GMID_EL1 = 51204,
  TRCRSR = 34896,
  TRCEXTINSELR0 = 34884,
  TRCEXTINSELR1 = 34892,
  TRCEXTINSELR2 = 34900,
  TRCEXTINSELR3 = 34908,
  TRBLIMITR_EL1 = 50392,
  TRBPTR_EL1 = 50393,
  TRBBASER_EL1 = 50394,
  TRBSR_EL1 = 50395,
  TRBMAR_EL1 = 50396,
  TRBTRG_EL1 = 50398,
  TRBIDR_EL1 = 50399,
  AMEVCNTVOFF00_EL2 = 59072,
  AMEVCNTVOFF10_EL2 = 59088,
  AMEVCNTVOFF01_EL2 = 59073,
  AMEVCNTVOFF11_EL2 = 59089,
  AMEVCNTVOFF02_EL2 = 59074,
  AMEVCNTVOFF12_EL2 = 59090,
  AMEVCNTVOFF03_EL2 = 59075,
  AMEVCNTVOFF13_EL2 = 59091,
  AMEVCNTVOFF04_EL2 = 59076,
  AMEVCNTVOFF14_EL2 = 59092,
  AMEVCNTVOFF05_EL2 = 59077,
  AMEVCNTVOFF15_EL2 = 59093,
  AMEVCNTVOFF06_EL2 = 59078,
  AMEVCNTVOFF16_EL2 = 59094,
  AMEVCNTVOFF07_EL2 = 59079,
  AMEVCNTVOFF17_EL2 = 59095,
  AMEVCNTVOFF08_EL2 = 59080,
  AMEVCNTVOFF18_EL2 = 59096,
  AMEVCNTVOFF09_EL2 = 59081,
  AMEVCNTVOFF19_EL2 = 59097,
  AMEVCNTVOFF010_EL2 = 59082,
  AMEVCNTVOFF110_EL2 = 59098,
  AMEVCNTVOFF011_EL2 = 59083,
  AMEVCNTVOFF111_EL2 = 59099,
  AMEVCNTVOFF012_EL2 = 59084,
  AMEVCNTVOFF112_EL2 = 59100,
  AMEVCNTVOFF013_EL2 = 59085,
  AMEVCNTVOFF113_EL2 = 59101,
  AMEVCNTVOFF014_EL2 = 59086,
  AMEVCNTVOFF114_EL2 = 59102,
  AMEVCNTVOFF015_EL2 = 59087,
  AMEVCNTVOFF115_EL2 = 59103,
  HFGRTR_EL2 = 57484,
  HFGWTR_EL2 = 57485,
  HFGITR_EL2 = 57486,
  HDFGRTR_EL2 = 57740,
  HDFGWTR_EL2 = 57741,
  CNTSCALE_EL2 = 59140,
  CNTISCALE_EL2 = 59141,
  CNTPOFF_EL2 = 59142,
  CNTVFRQ_EL2 = 59143,
  CNTPCTSS_EL0 = 57093,
  CNTVCTSS_EL0 = 57094,
  ACCDATA_EL1 = 50821,
  BRBCR_EL1 = 35968,
  BRBCR_EL12 = 44160,
  BRBCR_EL2 = 42112,
  BRBFCR_EL1 = 35969,
  BRBIDR0_EL1 = 35984,
  BRBINFINJ_EL1 = 35976,
  BRBSRCINJ_EL1 = 35977,
  BRBTGTINJ_EL1 = 35978,
  BRBTS_EL1 = 35970,
  BRBINF0_EL1 = 35840,
  BRBSRC0_EL1 = 35841,
  BRBTGT0_EL1 = 35842,
  BRBINF1_EL1 = 35848,
  BRBSRC1_EL1 = 35849,
  BRBTGT1_EL1 = 35850,
  BRBINF2_EL1 = 35856,
  BRBSRC2_EL1 = 35857,
  BRBTGT2_EL1 = 35858,
  BRBINF3_EL1 = 35864,
  BRBSRC3_EL1 = 35865,
  BRBTGT3_EL1 = 35866,
  BRBINF4_EL1 = 35872,
  BRBSRC4_EL1 = 35873,
  BRBTGT4_EL1 = 35874,
  BRBINF5_EL1 = 35880,
  BRBSRC5_EL1 = 35881,
  BRBTGT5_EL1 = 35882,
  BRBINF6_EL1 = 35888,
  BRBSRC6_EL1 = 35889,
  BRBTGT6_EL1 = 35890,
  BRBINF7_EL1 = 35896,
  BRBSRC7_EL1 = 35897,
  BRBTGT7_EL1 = 35898,
  BRBINF8_EL1 = 35904,
  BRBSRC8_EL1 = 35905,
  BRBTGT8_EL1 = 35906,
  BRBINF9_EL1 = 35912,
  BRBSRC9_EL1 = 35913,
  BRBTGT9_EL1 = 35914,
  BRBINF10_EL1 = 35920,
  BRBSRC10_EL1 = 35921,
  BRBTGT10_EL1 = 35922,
  BRBINF11_EL1 = 35928,
  BRBSRC11_EL1 = 35929,
  BRBTGT11_EL1 = 35930,
  BRBINF12_EL1 = 35936,
  BRBSRC12_EL1 = 35937,
  BRBTGT12_EL1 = 35938,
  BRBINF13_EL1 = 35944,
  BRBSRC13_EL1 = 35945,
  BRBTGT13_EL1 = 35946,
  BRBINF14_EL1 = 35952,
  BRBSRC14_EL1 = 35953,
  BRBTGT14_EL1 = 35954,
  BRBINF15_EL1 = 35960,
  BRBSRC15_EL1 = 35961,
  BRBTGT15_EL1 = 35962,
  BRBINF16_EL1 = 35844,
  BRBSRC16_EL1 = 35845,
  BRBTGT16_EL1 = 35846,
  BRBINF17_EL1 = 35852,
  BRBSRC17_EL1 = 35853,
  BRBTGT17_EL1 = 35854,
  BRBINF18_EL1 = 35860,
  BRBSRC18_EL1 = 35861,
  BRBTGT18_EL1 = 35862,
  BRBINF19_EL1 = 35868,
  BRBSRC19_EL1 = 35869,
  BRBTGT19_EL1 = 35870,
  BRBINF20_EL1 = 35876,
  BRBSRC20_EL1 = 35877,
  BRBTGT20_EL1 = 35878,
  BRBINF21_EL1 = 35884,
  BRBSRC21_EL1 = 35885,
  BRBTGT21_EL1 = 35886,
  BRBINF22_EL1 = 35892,
  BRBSRC22_EL1 = 35893,
  BRBTGT22_EL1 = 35894,
  BRBINF23_EL1 = 35900,
  BRBSRC23_EL1 = 35901,
  BRBTGT23_EL1 = 35902,
  BRBINF24_EL1 = 35908,
  BRBSRC24_EL1 = 35909,
  BRBTGT24_EL1 = 35910,
  BRBINF25_EL1 = 35916,
  BRBSRC25_EL1 = 35917,
  BRBTGT25_EL1 = 35918,
  BRBINF26_EL1 = 35924,
  BRBSRC26_EL1 = 35925,
  BRBTGT26_EL1 = 35926,
  BRBINF27_EL1 = 35932,
  BRBSRC27_EL1 = 35933,
  BRBTGT27_EL1 = 35934,
  BRBINF28_EL1 = 35940,
  BRBSRC28_EL1 = 35941,
  BRBTGT28_EL1 = 35942,
  BRBINF29_EL1 = 35948,
  BRBSRC29_EL1 = 35949,
  BRBTGT29_EL1 = 35950,
  BRBINF30_EL1 = 35956,
  BRBSRC30_EL1 = 35957,
  BRBTGT30_EL1 = 35958,
  BRBINF31_EL1 = 35964,
  BRBSRC31_EL1 = 35965,
  BRBTGT31_EL1 = 35966,
  PMSNEVFR_EL1 = 50377,
  CPM_IOACC_CTL_EL3 = 65424,
  SMCR_EL1 = 49302,
  SMCR_EL2 = 57494,
  SMCR_EL3 = 61590,
  SMCR_EL12 = 59542,
  SVCR = 55826,
  SMPRI_EL1 = 49300,
  SMPRIMAP_EL2 = 57493,
  SMIDR_EL1 = 51206,
  TPIDR2_EL0 = 56965,
  MPAMSM_EL1 = 50475,
};
#endif

#ifdef GET_TSB_DECL
enum TSBValues {
  csync = 0,
};
#endif

#ifdef GET_TLBITable_DECL
const TLBI *lookupTLBIByEncoding(uint16_t Encoding);
const TLBI *lookupTLBIByName(StringRef Name);
#endif

#ifdef GET_TLBITable_IMPL
constexpr TLBI TLBITable[] = {
  { "ALLE1", 0x243C, false,  {  }  }, // 0
  { "ALLE1IS", 0x241C, false,  {  }  }, // 1
  { "ALLE1ISnXS", 0x249C, false,  { AArch64::FeatureXS }  }, // 2
  { "ALLE1nXS", 0x24BC, false,  { AArch64::FeatureXS }  }, // 3
  { "ALLE1OS", 0x240C, false,  { AArch64::FeatureTLB_RMI }  }, // 4
  { "ALLE1OSnXS", 0x248C, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 5
  { "ALLE2", 0x2438, false,  {  }  }, // 6
  { "ALLE2IS", 0x2418, false,  {  }  }, // 7
  { "ALLE2ISnXS", 0x2498, false,  { AArch64::FeatureXS }  }, // 8
  { "ALLE2nXS", 0x24B8, false,  { AArch64::FeatureXS }  }, // 9
  { "ALLE2OS", 0x2408, false,  { AArch64::FeatureTLB_RMI }  }, // 10
  { "ALLE2OSnXS", 0x2488, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 11
  { "ALLE3", 0x3438, false,  {  }  }, // 12
  { "ALLE3IS", 0x3418, false,  {  }  }, // 13
  { "ALLE3ISnXS", 0x3498, false,  { AArch64::FeatureXS }  }, // 14
  { "ALLE3nXS", 0x34B8, false,  { AArch64::FeatureXS }  }, // 15
  { "ALLE3OS", 0x3408, false,  { AArch64::FeatureTLB_RMI }  }, // 16
  { "ALLE3OSnXS", 0x3488, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 17
  { "ASIDE1", 0x43A, true,  {  }  }, // 18
  { "ASIDE1IS", 0x41A, true,  {  }  }, // 19
  { "ASIDE1ISnXS", 0x49A, true,  { AArch64::FeatureXS }  }, // 20
  { "ASIDE1nXS", 0x4BA, true,  { AArch64::FeatureXS }  }, // 21
  { "ASIDE1OS", 0x40A, true,  { AArch64::FeatureTLB_RMI }  }, // 22
  { "ASIDE1OSnXS", 0x48A, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 23
  { "IPAS2E1", 0x2421, true,  {  }  }, // 24
  { "IPAS2E1IS", 0x2401, true,  {  }  }, // 25
  { "IPAS2E1ISnXS", 0x2481, true,  { AArch64::FeatureXS }  }, // 26
  { "IPAS2E1nXS", 0x24A1, true,  { AArch64::FeatureXS }  }, // 27
  { "IPAS2E1OS", 0x2420, true,  { AArch64::FeatureTLB_RMI }  }, // 28
  { "IPAS2E1OSnXS", 0x24A0, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 29
  { "IPAS2LE1", 0x2425, true,  {  }  }, // 30
  { "IPAS2LE1IS", 0x2405, true,  {  }  }, // 31
  { "IPAS2LE1ISnXS", 0x2485, true,  { AArch64::FeatureXS }  }, // 32
  { "IPAS2LE1nXS", 0x24A5, true,  { AArch64::FeatureXS }  }, // 33
  { "IPAS2LE1OS", 0x2424, true,  { AArch64::FeatureTLB_RMI }  }, // 34
  { "IPAS2LE1OSnXS", 0x24A4, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 35
  { "PAALL", 0x343C, false,  { AArch64::FeatureRME }  }, // 36
  { "PAALLnXS", 0x34BC, false,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 37
  { "PAALLOS", 0x340C, false,  { AArch64::FeatureRME }  }, // 38
  { "PAALLOSnXS", 0x348C, false,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 39
  { "RIPAS2E1", 0x2422, true,  { AArch64::FeatureTLB_RMI }  }, // 40
  { "RIPAS2E1IS", 0x2402, true,  { AArch64::FeatureTLB_RMI }  }, // 41
  { "RIPAS2E1ISnXS", 0x2482, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 42
  { "RIPAS2E1nXS", 0x24A2, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 43
  { "RIPAS2E1OS", 0x2423, true,  { AArch64::FeatureTLB_RMI }  }, // 44
  { "RIPAS2E1OSnXS", 0x24A3, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 45
  { "RIPAS2LE1", 0x2426, true,  { AArch64::FeatureTLB_RMI }  }, // 46
  { "RIPAS2LE1IS", 0x2406, true,  { AArch64::FeatureTLB_RMI }  }, // 47
  { "RIPAS2LE1ISnXS", 0x2486, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 48
  { "RIPAS2LE1nXS", 0x24A6, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 49
  { "RIPAS2LE1OS", 0x2427, true,  { AArch64::FeatureTLB_RMI }  }, // 50
  { "RIPAS2LE1OSnXS", 0x24A7, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 51
  { "RPALOS", 0x3427, true,  { AArch64::FeatureRME }  }, // 52
  { "RPALOSnXS", 0x34A7, true,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 53
  { "RPAOS", 0x3423, true,  { AArch64::FeatureRME }  }, // 54
  { "RPAOSnXS", 0x34A3, true,  { AArch64::FeatureRME, AArch64::FeatureXS }  }, // 55
  { "RVAAE1", 0x433, true,  { AArch64::FeatureTLB_RMI }  }, // 56
  { "RVAAE1IS", 0x413, true,  { AArch64::FeatureTLB_RMI }  }, // 57
  { "RVAAE1ISnXS", 0x493, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 58
  { "RVAAE1nXS", 0x4B3, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 59
  { "RVAAE1OS", 0x42B, true,  { AArch64::FeatureTLB_RMI }  }, // 60
  { "RVAAE1OSnXS", 0x4AB, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 61
  { "RVAALE1", 0x437, true,  { AArch64::FeatureTLB_RMI }  }, // 62
  { "RVAALE1IS", 0x417, true,  { AArch64::FeatureTLB_RMI }  }, // 63
  { "RVAALE1ISnXS", 0x497, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 64
  { "RVAALE1nXS", 0x4B7, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 65
  { "RVAALE1OS", 0x42F, true,  { AArch64::FeatureTLB_RMI }  }, // 66
  { "RVAALE1OSnXS", 0x4AF, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 67
  { "RVAE1", 0x431, true,  { AArch64::FeatureTLB_RMI }  }, // 68
  { "RVAE1IS", 0x411, true,  { AArch64::FeatureTLB_RMI }  }, // 69
  { "RVAE1ISnXS", 0x491, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 70
  { "RVAE1nXS", 0x4B1, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 71
  { "RVAE1OS", 0x429, true,  { AArch64::FeatureTLB_RMI }  }, // 72
  { "RVAE1OSnXS", 0x4A9, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 73
  { "RVAE2", 0x2431, true,  { AArch64::FeatureTLB_RMI }  }, // 74
  { "RVAE2IS", 0x2411, true,  { AArch64::FeatureTLB_RMI }  }, // 75
  { "RVAE2ISnXS", 0x2491, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 76
  { "RVAE2nXS", 0x24B1, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 77
  { "RVAE2OS", 0x2429, true,  { AArch64::FeatureTLB_RMI }  }, // 78
  { "RVAE2OSnXS", 0x24A9, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 79
  { "RVAE3", 0x3431, true,  { AArch64::FeatureTLB_RMI }  }, // 80
  { "RVAE3IS", 0x3411, true,  { AArch64::FeatureTLB_RMI }  }, // 81
  { "RVAE3ISnXS", 0x3491, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 82
  { "RVAE3nXS", 0x34B1, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 83
  { "RVAE3OS", 0x3429, true,  { AArch64::FeatureTLB_RMI }  }, // 84
  { "RVAE3OSnXS", 0x34A9, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 85
  { "RVALE1", 0x435, true,  { AArch64::FeatureTLB_RMI }  }, // 86
  { "RVALE1IS", 0x415, true,  { AArch64::FeatureTLB_RMI }  }, // 87
  { "RVALE1ISnXS", 0x495, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 88
  { "RVALE1nXS", 0x4B5, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 89
  { "RVALE1OS", 0x42D, true,  { AArch64::FeatureTLB_RMI }  }, // 90
  { "RVALE1OSnXS", 0x4AD, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 91
  { "RVALE2", 0x2435, true,  { AArch64::FeatureTLB_RMI }  }, // 92
  { "RVALE2IS", 0x2415, true,  { AArch64::FeatureTLB_RMI }  }, // 93
  { "RVALE2ISnXS", 0x2495, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 94
  { "RVALE2nXS", 0x24B5, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 95
  { "RVALE2OS", 0x242D, true,  { AArch64::FeatureTLB_RMI }  }, // 96
  { "RVALE2OSnXS", 0x24AD, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 97
  { "RVALE3", 0x3435, true,  { AArch64::FeatureTLB_RMI }  }, // 98
  { "RVALE3IS", 0x3415, true,  { AArch64::FeatureTLB_RMI }  }, // 99
  { "RVALE3ISnXS", 0x3495, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 100
  { "RVALE3nXS", 0x34B5, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 101
  { "RVALE3OS", 0x342D, true,  { AArch64::FeatureTLB_RMI }  }, // 102
  { "RVALE3OSnXS", 0x34AD, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 103
  { "VAAE1", 0x43B, true,  {  }  }, // 104
  { "VAAE1IS", 0x41B, true,  {  }  }, // 105
  { "VAAE1ISnXS", 0x49B, true,  { AArch64::FeatureXS }  }, // 106
  { "VAAE1nXS", 0x4BB, true,  { AArch64::FeatureXS }  }, // 107
  { "VAAE1OS", 0x40B, true,  { AArch64::FeatureTLB_RMI }  }, // 108
  { "VAAE1OSnXS", 0x48B, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 109
  { "VAALE1", 0x43F, true,  {  }  }, // 110
  { "VAALE1IS", 0x41F, true,  {  }  }, // 111
  { "VAALE1ISnXS", 0x49F, true,  { AArch64::FeatureXS }  }, // 112
  { "VAALE1nXS", 0x4BF, true,  { AArch64::FeatureXS }  }, // 113
  { "VAALE1OS", 0x40F, true,  { AArch64::FeatureTLB_RMI }  }, // 114
  { "VAALE1OSnXS", 0x48F, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 115
  { "VAE1", 0x439, true,  {  }  }, // 116
  { "VAE1IS", 0x419, true,  {  }  }, // 117
  { "VAE1ISnXS", 0x499, true,  { AArch64::FeatureXS }  }, // 118
  { "VAE1nXS", 0x4B9, true,  { AArch64::FeatureXS }  }, // 119
  { "VAE1OS", 0x409, true,  { AArch64::FeatureTLB_RMI }  }, // 120
  { "VAE1OSnXS", 0x489, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 121
  { "VAE2", 0x2439, true,  {  }  }, // 122
  { "VAE2IS", 0x2419, true,  {  }  }, // 123
  { "VAE2ISnXS", 0x2499, true,  { AArch64::FeatureXS }  }, // 124
  { "VAE2nXS", 0x24B9, true,  { AArch64::FeatureXS }  }, // 125
  { "VAE2OS", 0x2409, true,  { AArch64::FeatureTLB_RMI }  }, // 126
  { "VAE2OSnXS", 0x2489, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 127
  { "VAE3", 0x3439, true,  {  }  }, // 128
  { "VAE3IS", 0x3419, true,  {  }  }, // 129
  { "VAE3ISnXS", 0x3499, true,  { AArch64::FeatureXS }  }, // 130
  { "VAE3nXS", 0x34B9, true,  { AArch64::FeatureXS }  }, // 131
  { "VAE3OS", 0x3409, true,  { AArch64::FeatureTLB_RMI }  }, // 132
  { "VAE3OSnXS", 0x3489, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 133
  { "VALE1", 0x43D, true,  {  }  }, // 134
  { "VALE1IS", 0x41D, true,  {  }  }, // 135
  { "VALE1ISnXS", 0x49D, true,  { AArch64::FeatureXS }  }, // 136
  { "VALE1nXS", 0x4BD, true,  { AArch64::FeatureXS }  }, // 137
  { "VALE1OS", 0x40D, true,  { AArch64::FeatureTLB_RMI }  }, // 138
  { "VALE1OSnXS", 0x48D, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 139
  { "VALE2", 0x243D, true,  {  }  }, // 140
  { "VALE2IS", 0x241D, true,  {  }  }, // 141
  { "VALE2ISnXS", 0x249D, true,  { AArch64::FeatureXS }  }, // 142
  { "VALE2nXS", 0x24BD, true,  { AArch64::FeatureXS }  }, // 143
  { "VALE2OS", 0x240D, true,  { AArch64::FeatureTLB_RMI }  }, // 144
  { "VALE2OSnXS", 0x248D, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 145
  { "VALE3", 0x343D, true,  {  }  }, // 146
  { "VALE3IS", 0x341D, true,  {  }  }, // 147
  { "VALE3ISnXS", 0x349D, true,  { AArch64::FeatureXS }  }, // 148
  { "VALE3nXS", 0x34BD, true,  { AArch64::FeatureXS }  }, // 149
  { "VALE3OS", 0x340D, true,  { AArch64::FeatureTLB_RMI }  }, // 150
  { "VALE3OSnXS", 0x348D, true,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 151
  { "VMALLE1", 0x438, false,  {  }  }, // 152
  { "VMALLE1IS", 0x418, false,  {  }  }, // 153
  { "VMALLE1ISnXS", 0x498, false,  { AArch64::FeatureXS }  }, // 154
  { "VMALLE1nXS", 0x4B8, false,  { AArch64::FeatureXS }  }, // 155
  { "VMALLE1OS", 0x408, false,  { AArch64::FeatureTLB_RMI }  }, // 156
  { "VMALLE1OSnXS", 0x488, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 157
  { "VMALLS12E1", 0x243E, false,  {  }  }, // 158
  { "VMALLS12E1IS", 0x241E, false,  {  }  }, // 159
  { "VMALLS12E1ISnXS", 0x249E, false,  { AArch64::FeatureXS }  }, // 160
  { "VMALLS12E1nXS", 0x24BE, false,  { AArch64::FeatureXS }  }, // 161
  { "VMALLS12E1OS", 0x240E, false,  { AArch64::FeatureTLB_RMI }  }, // 162
  { "VMALLS12E1OSnXS", 0x248E, false,  { AArch64::FeatureTLB_RMI, AArch64::FeatureXS }  }, // 163
 };

const TLBI *lookupTLBIByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x408, 156 },
    { 0x409, 120 },
    { 0x40A, 22 },
    { 0x40B, 108 },
    { 0x40D, 138 },
    { 0x40F, 114 },
    { 0x411, 69 },
    { 0x413, 57 },
    { 0x415, 87 },
    { 0x417, 63 },
    { 0x418, 153 },
    { 0x419, 117 },
    { 0x41A, 19 },
    { 0x41B, 105 },
    { 0x41D, 135 },
    { 0x41F, 111 },
    { 0x429, 72 },
    { 0x42B, 60 },
    { 0x42D, 90 },
    { 0x42F, 66 },
    { 0x431, 68 },
    { 0x433, 56 },
    { 0x435, 86 },
    { 0x437, 62 },
    { 0x438, 152 },
    { 0x439, 116 },
    { 0x43A, 18 },
    { 0x43B, 104 },
    { 0x43D, 134 },
    { 0x43F, 110 },
    { 0x488, 157 },
    { 0x489, 121 },
    { 0x48A, 23 },
    { 0x48B, 109 },
    { 0x48D, 139 },
    { 0x48F, 115 },
    { 0x491, 70 },
    { 0x493, 58 },
    { 0x495, 88 },
    { 0x497, 64 },
    { 0x498, 154 },
    { 0x499, 118 },
    { 0x49A, 20 },
    { 0x49B, 106 },
    { 0x49D, 136 },
    { 0x49F, 112 },
    { 0x4A9, 73 },
    { 0x4AB, 61 },
    { 0x4AD, 91 },
    { 0x4AF, 67 },
    { 0x4B1, 71 },
    { 0x4B3, 59 },
    { 0x4B5, 89 },
    { 0x4B7, 65 },
    { 0x4B8, 155 },
    { 0x4B9, 119 },
    { 0x4BA, 21 },
    { 0x4BB, 107 },
    { 0x4BD, 137 },
    { 0x4BF, 113 },
    { 0x2401, 25 },
    { 0x2402, 41 },
    { 0x2405, 31 },
    { 0x2406, 47 },
    { 0x2408, 10 },
    { 0x2409, 126 },
    { 0x240C, 4 },
    { 0x240D, 144 },
    { 0x240E, 162 },
    { 0x2411, 75 },
    { 0x2415, 93 },
    { 0x2418, 7 },
    { 0x2419, 123 },
    { 0x241C, 1 },
    { 0x241D, 141 },
    { 0x241E, 159 },
    { 0x2420, 28 },
    { 0x2421, 24 },
    { 0x2422, 40 },
    { 0x2423, 44 },
    { 0x2424, 34 },
    { 0x2425, 30 },
    { 0x2426, 46 },
    { 0x2427, 50 },
    { 0x2429, 78 },
    { 0x242D, 96 },
    { 0x2431, 74 },
    { 0x2435, 92 },
    { 0x2438, 6 },
    { 0x2439, 122 },
    { 0x243C, 0 },
    { 0x243D, 140 },
    { 0x243E, 158 },
    { 0x2481, 26 },
    { 0x2482, 42 },
    { 0x2485, 32 },
    { 0x2486, 48 },
    { 0x2488, 11 },
    { 0x2489, 127 },
    { 0x248C, 5 },
    { 0x248D, 145 },
    { 0x248E, 163 },
    { 0x2491, 76 },
    { 0x2495, 94 },
    { 0x2498, 8 },
    { 0x2499, 124 },
    { 0x249C, 2 },
    { 0x249D, 142 },
    { 0x249E, 160 },
    { 0x24A0, 29 },
    { 0x24A1, 27 },
    { 0x24A2, 43 },
    { 0x24A3, 45 },
    { 0x24A4, 35 },
    { 0x24A5, 33 },
    { 0x24A6, 49 },
    { 0x24A7, 51 },
    { 0x24A9, 79 },
    { 0x24AD, 97 },
    { 0x24B1, 77 },
    { 0x24B5, 95 },
    { 0x24B8, 9 },
    { 0x24B9, 125 },
    { 0x24BC, 3 },
    { 0x24BD, 143 },
    { 0x24BE, 161 },
    { 0x3408, 16 },
    { 0x3409, 132 },
    { 0x340C, 38 },
    { 0x340D, 150 },
    { 0x3411, 81 },
    { 0x3415, 99 },
    { 0x3418, 13 },
    { 0x3419, 129 },
    { 0x341D, 147 },
    { 0x3423, 54 },
    { 0x3427, 52 },
    { 0x3429, 84 },
    { 0x342D, 102 },
    { 0x3431, 80 },
    { 0x3435, 98 },
    { 0x3438, 12 },
    { 0x3439, 128 },
    { 0x343C, 36 },
    { 0x343D, 146 },
    { 0x3488, 17 },
    { 0x3489, 133 },
    { 0x348C, 39 },
    { 0x348D, 151 },
    { 0x3491, 82 },
    { 0x3495, 100 },
    { 0x3498, 14 },
    { 0x3499, 130 },
    { 0x349D, 148 },
    { 0x34A3, 55 },
    { 0x34A7, 53 },
    { 0x34A9, 85 },
    { 0x34AD, 103 },
    { 0x34B1, 83 },
    { 0x34B5, 101 },
    { 0x34B8, 15 },
    { 0x34B9, 131 },
    { 0x34BC, 37 },
    { 0x34BD, 149 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &TLBITable[Idx->_index];
}

const TLBI *lookupTLBIByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ALLE1", 0 },
    { "ALLE1IS", 1 },
    { "ALLE1ISNXS", 2 },
    { "ALLE1NXS", 3 },
    { "ALLE1OS", 4 },
    { "ALLE1OSNXS", 5 },
    { "ALLE2", 6 },
    { "ALLE2IS", 7 },
    { "ALLE2ISNXS", 8 },
    { "ALLE2NXS", 9 },
    { "ALLE2OS", 10 },
    { "ALLE2OSNXS", 11 },
    { "ALLE3", 12 },
    { "ALLE3IS", 13 },
    { "ALLE3ISNXS", 14 },
    { "ALLE3NXS", 15 },
    { "ALLE3OS", 16 },
    { "ALLE3OSNXS", 17 },
    { "ASIDE1", 18 },
    { "ASIDE1IS", 19 },
    { "ASIDE1ISNXS", 20 },
    { "ASIDE1NXS", 21 },
    { "ASIDE1OS", 22 },
    { "ASIDE1OSNXS", 23 },
    { "IPAS2E1", 24 },
    { "IPAS2E1IS", 25 },
    { "IPAS2E1ISNXS", 26 },
    { "IPAS2E1NXS", 27 },
    { "IPAS2E1OS", 28 },
    { "IPAS2E1OSNXS", 29 },
    { "IPAS2LE1", 30 },
    { "IPAS2LE1IS", 31 },
    { "IPAS2LE1ISNXS", 32 },
    { "IPAS2LE1NXS", 33 },
    { "IPAS2LE1OS", 34 },
    { "IPAS2LE1OSNXS", 35 },
    { "PAALL", 36 },
    { "PAALLNXS", 37 },
    { "PAALLOS", 38 },
    { "PAALLOSNXS", 39 },
    { "RIPAS2E1", 40 },
    { "RIPAS2E1IS", 41 },
    { "RIPAS2E1ISNXS", 42 },
    { "RIPAS2E1NXS", 43 },
    { "RIPAS2E1OS", 44 },
    { "RIPAS2E1OSNXS", 45 },
    { "RIPAS2LE1", 46 },
    { "RIPAS2LE1IS", 47 },
    { "RIPAS2LE1ISNXS", 48 },
    { "RIPAS2LE1NXS", 49 },
    { "RIPAS2LE1OS", 50 },
    { "RIPAS2LE1OSNXS", 51 },
    { "RPALOS", 52 },
    { "RPALOSNXS", 53 },
    { "RPAOS", 54 },
    { "RPAOSNXS", 55 },
    { "RVAAE1", 56 },
    { "RVAAE1IS", 57 },
    { "RVAAE1ISNXS", 58 },
    { "RVAAE1NXS", 59 },
    { "RVAAE1OS", 60 },
    { "RVAAE1OSNXS", 61 },
    { "RVAALE1", 62 },
    { "RVAALE1IS", 63 },
    { "RVAALE1ISNXS", 64 },
    { "RVAALE1NXS", 65 },
    { "RVAALE1OS", 66 },
    { "RVAALE1OSNXS", 67 },
    { "RVAE1", 68 },
    { "RVAE1IS", 69 },
    { "RVAE1ISNXS", 70 },
    { "RVAE1NXS", 71 },
    { "RVAE1OS", 72 },
    { "RVAE1OSNXS", 73 },
    { "RVAE2", 74 },
    { "RVAE2IS", 75 },
    { "RVAE2ISNXS", 76 },
    { "RVAE2NXS", 77 },
    { "RVAE2OS", 78 },
    { "RVAE2OSNXS", 79 },
    { "RVAE3", 80 },
    { "RVAE3IS", 81 },
    { "RVAE3ISNXS", 82 },
    { "RVAE3NXS", 83 },
    { "RVAE3OS", 84 },
    { "RVAE3OSNXS", 85 },
    { "RVALE1", 86 },
    { "RVALE1IS", 87 },
    { "RVALE1ISNXS", 88 },
    { "RVALE1NXS", 89 },
    { "RVALE1OS", 90 },
    { "RVALE1OSNXS", 91 },
    { "RVALE2", 92 },
    { "RVALE2IS", 93 },
    { "RVALE2ISNXS", 94 },
    { "RVALE2NXS", 95 },
    { "RVALE2OS", 96 },
    { "RVALE2OSNXS", 97 },
    { "RVALE3", 98 },
    { "RVALE3IS", 99 },
    { "RVALE3ISNXS", 100 },
    { "RVALE3NXS", 101 },
    { "RVALE3OS", 102 },
    { "RVALE3OSNXS", 103 },
    { "VAAE1", 104 },
    { "VAAE1IS", 105 },
    { "VAAE1ISNXS", 106 },
    { "VAAE1NXS", 107 },
    { "VAAE1OS", 108 },
    { "VAAE1OSNXS", 109 },
    { "VAALE1", 110 },
    { "VAALE1IS", 111 },
    { "VAALE1ISNXS", 112 },
    { "VAALE1NXS", 113 },
    { "VAALE1OS", 114 },
    { "VAALE1OSNXS", 115 },
    { "VAE1", 116 },
    { "VAE1IS", 117 },
    { "VAE1ISNXS", 118 },
    { "VAE1NXS", 119 },
    { "VAE1OS", 120 },
    { "VAE1OSNXS", 121 },
    { "VAE2", 122 },
    { "VAE2IS", 123 },
    { "VAE2ISNXS", 124 },
    { "VAE2NXS", 125 },
    { "VAE2OS", 126 },
    { "VAE2OSNXS", 127 },
    { "VAE3", 128 },
    { "VAE3IS", 129 },
    { "VAE3ISNXS", 130 },
    { "VAE3NXS", 131 },
    { "VAE3OS", 132 },
    { "VAE3OSNXS", 133 },
    { "VALE1", 134 },
    { "VALE1IS", 135 },
    { "VALE1ISNXS", 136 },
    { "VALE1NXS", 137 },
    { "VALE1OS", 138 },
    { "VALE1OSNXS", 139 },
    { "VALE2", 140 },
    { "VALE2IS", 141 },
    { "VALE2ISNXS", 142 },
    { "VALE2NXS", 143 },
    { "VALE2OS", 144 },
    { "VALE2OSNXS", 145 },
    { "VALE3", 146 },
    { "VALE3IS", 147 },
    { "VALE3ISNXS", 148 },
    { "VALE3NXS", 149 },
    { "VALE3OS", 150 },
    { "VALE3OSNXS", 151 },
    { "VMALLE1", 152 },
    { "VMALLE1IS", 153 },
    { "VMALLE1ISNXS", 154 },
    { "VMALLE1NXS", 155 },
    { "VMALLE1OS", 156 },
    { "VMALLE1OSNXS", 157 },
    { "VMALLS12E1", 158 },
    { "VMALLS12E1IS", 159 },
    { "VMALLS12E1ISNXS", 160 },
    { "VMALLS12E1NXS", 161 },
    { "VMALLS12E1OS", 162 },
    { "VMALLS12E1OSNXS", 163 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &TLBITable[Idx->_index];
}
#endif

#ifdef GET_AT_DECL
const AT *lookupATByName(StringRef Name);
const AT *lookupATByEncoding(uint16_t Encoding);
#endif

#ifdef GET_AT_IMPL
constexpr AT ATsList[] = {
  { "S12E0R", 0x23C6,  {}  }, // 0
  { "S12E0W", 0x23C7,  {}  }, // 1
  { "S12E1R", 0x23C4,  {}  }, // 2
  { "S12E1W", 0x23C5,  {}  }, // 3
  { "S1E0R", 0x3C2,  {}  }, // 4
  { "S1E0W", 0x3C3,  {}  }, // 5
  { "S1E1R", 0x3C0,  {}  }, // 6
  { "S1E1RP", 0x3C8,  {AArch64::FeaturePAN_RWV}  }, // 7
  { "S1E1W", 0x3C1,  {}  }, // 8
  { "S1E1WP", 0x3C9,  {AArch64::FeaturePAN_RWV}  }, // 9
  { "S1E2R", 0x23C0,  {}  }, // 10
  { "S1E2W", 0x23C1,  {}  }, // 11
  { "S1E3R", 0x33C0,  {}  }, // 12
  { "S1E3W", 0x33C1,  {}  }, // 13
 };

const AT *lookupATByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "S12E0R", 0 },
    { "S12E0W", 1 },
    { "S12E1R", 2 },
    { "S12E1W", 3 },
    { "S1E0R", 4 },
    { "S1E0W", 5 },
    { "S1E1R", 6 },
    { "S1E1RP", 7 },
    { "S1E1W", 8 },
    { "S1E1WP", 9 },
    { "S1E2R", 10 },
    { "S1E2W", 11 },
    { "S1E3R", 12 },
    { "S1E3W", 13 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &ATsList[Idx->_index];
}

const AT *lookupATByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3C0, 6 },
    { 0x3C1, 8 },
    { 0x3C2, 4 },
    { 0x3C3, 5 },
    { 0x3C8, 7 },
    { 0x3C9, 9 },
    { 0x23C0, 10 },
    { 0x23C1, 11 },
    { 0x23C4, 2 },
    { 0x23C5, 3 },
    { 0x23C6, 0 },
    { 0x23C7, 1 },
    { 0x33C0, 12 },
    { 0x33C1, 13 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &ATsList[Idx->_index];
}
#endif

#ifdef GET_BTI_DECL
const BTI *lookupBTIByName(StringRef Name);
const BTI *lookupBTIByEncoding(uint8_t Encoding);
#endif

#ifdef GET_BTI_IMPL
constexpr BTI BTIsList[] = {
  { "c", 0x2 }, // 0
  { "j", 0x4 }, // 1
  { "jc", 0x6 }, // 2
 };

const BTI *lookupBTIByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "C", 0 },
    { "J", 1 },
    { "JC", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &BTIsList[Idx->_index];
}

const BTI *lookupBTIByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x2, 0 },
    { 0x4, 1 },
    { 0x6, 2 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &BTIsList[Idx->_index];
}
#endif

#ifdef GET_DB_DECL
const DB *lookupDBByName(StringRef Name);
const DB *lookupDBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_DB_IMPL
constexpr DB DBsList[] = {
  { "ish", 0xB }, // 0
  { "ishld", 0x9 }, // 1
  { "ishst", 0xA }, // 2
  { "ld", 0xD }, // 3
  { "nsh", 0x7 }, // 4
  { "nshld", 0x5 }, // 5
  { "nshst", 0x6 }, // 6
  { "osh", 0x3 }, // 7
  { "oshld", 0x1 }, // 8
  { "oshst", 0x2 }, // 9
  { "st", 0xE }, // 10
  { "sy", 0xF }, // 11
 };

const DB *lookupDBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ISH", 0 },
    { "ISHLD", 1 },
    { "ISHST", 2 },
    { "LD", 3 },
    { "NSH", 4 },
    { "NSHLD", 5 },
    { "NSHST", 6 },
    { "OSH", 7 },
    { "OSHLD", 8 },
    { "OSHST", 9 },
    { "ST", 10 },
    { "SY", 11 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &DBsList[Idx->_index];
}

const DB *lookupDBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 8 },
    { 0x2, 9 },
    { 0x3, 7 },
    { 0x5, 5 },
    { 0x6, 6 },
    { 0x7, 4 },
    { 0x9, 1 },
    { 0xA, 2 },
    { 0xB, 0 },
    { 0xD, 3 },
    { 0xE, 10 },
    { 0xF, 11 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &DBsList[Idx->_index];
}
#endif

#ifdef GET_DBNXS_DECL
const DBnXS *lookupDBnXSByName(StringRef Name);
const DBnXS *lookupDBnXSByEncoding(uint8_t Encoding);
const DBnXS *lookupDBnXSByImmValue(uint8_t ImmValue);
#endif

#ifdef GET_DBNXS_IMPL
constexpr DBnXS DBnXSsList[] = {
  { "ishnxs", 0xB, 0x18,  {AArch64::FeatureXS}  }, // 0
  { "nshnxs", 0x7, 0x14,  {AArch64::FeatureXS}  }, // 1
  { "oshnxs", 0x3, 0x10,  {AArch64::FeatureXS}  }, // 2
  { "synxs", 0xF, 0x1C,  {AArch64::FeatureXS}  }, // 3
 };

const DBnXS *lookupDBnXSByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ISHNXS", 0 },
    { "NSHNXS", 1 },
    { "OSHNXS", 2 },
    { "SYNXS", 3 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &DBnXSsList[Idx->_index];
}

const DBnXS *lookupDBnXSByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3, 2 },
    { 0x7, 1 },
    { 0xB, 0 },
    { 0xF, 3 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &DBnXSsList[Idx->_index];
}

const DBnXS *lookupDBnXSByImmValue(uint8_t ImmValue) {
  struct IndexType {
    uint8_t ImmValue;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x10, 2 },
    { 0x14, 1 },
    { 0x18, 0 },
    { 0x1C, 3 },
  };

  struct KeyType {
    uint8_t ImmValue;
  };
  KeyType Key = {ImmValue};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.ImmValue < RHS.ImmValue)
        return true;
      if (LHS.ImmValue > RHS.ImmValue)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.ImmValue != Idx->ImmValue)
    return nullptr;
  return &DBnXSsList[Idx->_index];
}
#endif

#ifdef GET_DC_DECL
const DC *lookupDCByName(StringRef Name);
const DC *lookupDCByEncoding(uint16_t Encoding);
#endif

#ifdef GET_DC_IMPL
constexpr DC DCsList[] = {
  { "CGDSW", 0x3D6,  {AArch64::FeatureMTE}  }, // 0
  { "CGDVAC", 0x1BD5,  {AArch64::FeatureMTE}  }, // 1
  { "CGDVADP", 0x1BED,  {AArch64::FeatureMTE}  }, // 2
  { "CGDVAP", 0x1BE5,  {AArch64::FeatureMTE}  }, // 3
  { "CGSW", 0x3D4,  {AArch64::FeatureMTE}  }, // 4
  { "CGVAC", 0x1BD3,  {AArch64::FeatureMTE}  }, // 5
  { "CGVADP", 0x1BEB,  {AArch64::FeatureMTE}  }, // 6
  { "CGVAP", 0x1BE3,  {AArch64::FeatureMTE}  }, // 7
  { "CIGDSW", 0x3F6,  {AArch64::FeatureMTE}  }, // 8
  { "CIGDVAC", 0x1BF5,  {AArch64::FeatureMTE}  }, // 9
  { "CIGSW", 0x3F4,  {AArch64::FeatureMTE}  }, // 10
  { "CIGVAC", 0x1BF3,  {AArch64::FeatureMTE}  }, // 11
  { "CISW", 0x3F2,  {}  }, // 12
  { "CIVAC", 0x1BF1,  {}  }, // 13
  { "CSW", 0x3D2,  {}  }, // 14
  { "CVAC", 0x1BD1,  {}  }, // 15
  { "CVADP", 0x1BE9,  {AArch64::FeatureCacheDeepPersist}  }, // 16
  { "CVAP", 0x1BE1,  {AArch64::FeatureCCPP}  }, // 17
  { "CVAU", 0x1BD9,  {}  }, // 18
  { "GVA", 0x1BA3,  {AArch64::FeatureMTE}  }, // 19
  { "GZVA", 0x1BA4,  {AArch64::FeatureMTE}  }, // 20
  { "IGDSW", 0x3B6,  {AArch64::FeatureMTE}  }, // 21
  { "IGDVAC", 0x3B5,  {AArch64::FeatureMTE}  }, // 22
  { "IGSW", 0x3B4,  {AArch64::FeatureMTE}  }, // 23
  { "IGVAC", 0x3B3,  {AArch64::FeatureMTE}  }, // 24
  { "ISW", 0x3B2,  {}  }, // 25
  { "IVAC", 0x3B1,  {}  }, // 26
  { "ZVA", 0x1BA1,  {}  }, // 27
 };

const DC *lookupDCByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CGDSW", 0 },
    { "CGDVAC", 1 },
    { "CGDVADP", 2 },
    { "CGDVAP", 3 },
    { "CGSW", 4 },
    { "CGVAC", 5 },
    { "CGVADP", 6 },
    { "CGVAP", 7 },
    { "CIGDSW", 8 },
    { "CIGDVAC", 9 },
    { "CIGSW", 10 },
    { "CIGVAC", 11 },
    { "CISW", 12 },
    { "CIVAC", 13 },
    { "CSW", 14 },
    { "CVAC", 15 },
    { "CVADP", 16 },
    { "CVAP", 17 },
    { "CVAU", 18 },
    { "GVA", 19 },
    { "GZVA", 20 },
    { "IGDSW", 21 },
    { "IGDVAC", 22 },
    { "IGSW", 23 },
    { "IGVAC", 24 },
    { "ISW", 25 },
    { "IVAC", 26 },
    { "ZVA", 27 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &DCsList[Idx->_index];
}

const DC *lookupDCByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3B1, 26 },
    { 0x3B2, 25 },
    { 0x3B3, 24 },
    { 0x3B4, 23 },
    { 0x3B5, 22 },
    { 0x3B6, 21 },
    { 0x3D2, 14 },
    { 0x3D4, 4 },
    { 0x3D6, 0 },
    { 0x3F2, 12 },
    { 0x3F4, 10 },
    { 0x3F6, 8 },
    { 0x1BA1, 27 },
    { 0x1BA3, 19 },
    { 0x1BA4, 20 },
    { 0x1BD1, 15 },
    { 0x1BD3, 5 },
    { 0x1BD5, 1 },
    { 0x1BD9, 18 },
    { 0x1BE1, 17 },
    { 0x1BE3, 7 },
    { 0x1BE5, 3 },
    { 0x1BE9, 16 },
    { 0x1BEB, 6 },
    { 0x1BED, 2 },
    { 0x1BF1, 13 },
    { 0x1BF3, 11 },
    { 0x1BF5, 9 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &DCsList[Idx->_index];
}
#endif

#ifdef GET_EXACTFPIMM_DECL
const ExactFPImm *lookupExactFPImmByEnum(uint8_t Enum);
const ExactFPImm *lookupExactFPImmByRepr(StringRef Repr);
#endif

#ifdef GET_EXACTFPIMM_IMPL
constexpr ExactFPImm ExactFPImmsList[] = {
  { "half", 0x1, "0.5" }, // 0
  { "one", 0x2, "1.0" }, // 1
  { "two", 0x3, "2.0" }, // 2
  { "zero", 0x0, "0.0" }, // 3
 };

const ExactFPImm *lookupExactFPImmByEnum(uint8_t Enum) {
  struct IndexType {
    uint8_t Enum;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 3 },
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
  };

  auto Table = makeArrayRef(Index);
  size_t Idx = Enum;
  return Idx >= Table.size() ? nullptr : &ExactFPImmsList[Table[Idx]._index];
}

const ExactFPImm *lookupExactFPImmByRepr(StringRef Repr) {
  struct IndexType {
    const char * Repr;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "0.0", 3 },
    { "0.5", 0 },
    { "1.0", 1 },
    { "2.0", 2 },
  };

  struct KeyType {
    std::string Repr;
  };
  KeyType Key = {Repr.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpRepr = StringRef(LHS.Repr).compare(RHS.Repr);
      if (CmpRepr < 0) return true;
      if (CmpRepr > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Repr != Idx->Repr)
    return nullptr;
  return &ExactFPImmsList[Idx->_index];
}
#endif

#ifdef GET_IC_DECL
const IC *lookupICByName(StringRef Name);
const IC *lookupICByEncoding(uint16_t Encoding);
#endif

#ifdef GET_IC_IMPL
constexpr IC ICsList[] = {
  { "IALLU", 0x3A8, false }, // 0
  { "IALLUIS", 0x388, false }, // 1
  { "IVAU", 0x1BA9, true }, // 2
 };

const IC *lookupICByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "IALLU", 0 },
    { "IALLUIS", 1 },
    { "IVAU", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &ICsList[Idx->_index];
}

const IC *lookupICByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x388, 1 },
    { 0x3A8, 0 },
    { 0x1BA9, 2 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &ICsList[Idx->_index];
}
#endif

#ifdef GET_ISB_DECL
const ISB *lookupISBByName(StringRef Name);
const ISB *lookupISBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_ISB_IMPL
constexpr ISB ISBsList[] = {
  { "sy", 0xF }, // 0
 };

const ISB *lookupISBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "SY", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &ISBsList[Idx->_index];
}

const ISB *lookupISBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0xF, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &ISBsList[Idx->_index];
}
#endif

#ifdef GET_PRCTX_DECL
const PRCTX *lookupPRCTXByName(StringRef Name);
const PRCTX *lookupPRCTXByEncoding(uint16_t Encoding);
#endif

#ifdef GET_PRCTX_IMPL
constexpr PRCTX PRCTXsList[] = {
  { "RCTX", 0x373, true,  {AArch64::FeaturePredRes}  }, // 0
 };

const PRCTX *lookupPRCTXByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "RCTX", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PRCTXsList[Idx->_index];
}

const PRCTX *lookupPRCTXByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x373, 0 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PRCTXsList[Idx->_index];
}
#endif

#ifdef GET_PRFM_DECL
const PRFM *lookupPRFMByName(StringRef Name);
const PRFM *lookupPRFMByEncoding(uint8_t Encoding);
#endif

#ifdef GET_PRFM_IMPL
constexpr PRFM PRFMsList[] = {
  { "pldl1keep", 0x0 }, // 0
  { "pldl1strm", 0x1 }, // 1
  { "pldl2keep", 0x2 }, // 2
  { "pldl2strm", 0x3 }, // 3
  { "pldl3keep", 0x4 }, // 4
  { "pldl3strm", 0x5 }, // 5
  { "plil1keep", 0x8 }, // 6
  { "plil1strm", 0x9 }, // 7
  { "plil2keep", 0xA }, // 8
  { "plil2strm", 0xB }, // 9
  { "plil3keep", 0xC }, // 10
  { "plil3strm", 0xD }, // 11
  { "pstl1keep", 0x10 }, // 12
  { "pstl1strm", 0x11 }, // 13
  { "pstl2keep", 0x12 }, // 14
  { "pstl2strm", 0x13 }, // 15
  { "pstl3keep", 0x14 }, // 16
  { "pstl3strm", 0x15 }, // 17
 };

const PRFM *lookupPRFMByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "PLDL1KEEP", 0 },
    { "PLDL1STRM", 1 },
    { "PLDL2KEEP", 2 },
    { "PLDL2STRM", 3 },
    { "PLDL3KEEP", 4 },
    { "PLDL3STRM", 5 },
    { "PLIL1KEEP", 6 },
    { "PLIL1STRM", 7 },
    { "PLIL2KEEP", 8 },
    { "PLIL2STRM", 9 },
    { "PLIL3KEEP", 10 },
    { "PLIL3STRM", 11 },
    { "PSTL1KEEP", 12 },
    { "PSTL1STRM", 13 },
    { "PSTL2KEEP", 14 },
    { "PSTL2STRM", 15 },
    { "PSTL3KEEP", 16 },
    { "PSTL3STRM", 17 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PRFMsList[Idx->_index];
}

const PRFM *lookupPRFMByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 1 },
    { 0x2, 2 },
    { 0x3, 3 },
    { 0x4, 4 },
    { 0x5, 5 },
    { 0x8, 6 },
    { 0x9, 7 },
    { 0xA, 8 },
    { 0xB, 9 },
    { 0xC, 10 },
    { 0xD, 11 },
    { 0x10, 12 },
    { 0x11, 13 },
    { 0x12, 14 },
    { 0x13, 15 },
    { 0x14, 16 },
    { 0x15, 17 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PRFMsList[Idx->_index];
}
#endif

#ifdef GET_PSB_DECL
const PSB *lookupPSBByName(StringRef Name);
const PSB *lookupPSBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_PSB_IMPL
constexpr PSB PSBsList[] = {
  { "csync", 0x11 }, // 0
 };

const PSB *lookupPSBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CSYNC", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PSBsList[Idx->_index];
}

const PSB *lookupPSBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x11, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PSBsList[Idx->_index];
}
#endif

#ifdef GET_PSTATE_DECL
const PState *lookupPStateByName(StringRef Name);
const PState *lookupPStateByEncoding(uint8_t Encoding);
#endif

#ifdef GET_PSTATE_IMPL
constexpr PState PStatesList[] = {
  { "DAIFClr", 0x1F,  {}  }, // 0
  { "DAIFSet", 0x1E,  {}  }, // 1
  { "DIT", 0x1A,  {AArch64::FeatureDIT}  }, // 2
  { "PAN", 0x4,  {AArch64::FeaturePAN}  }, // 3
  { "SPSel", 0x5,  {}  }, // 4
  { "SSBS", 0x19,  {AArch64::FeatureSSBS}  }, // 5
  { "TCO", 0x1C,  {AArch64::FeatureMTE}  }, // 6
  { "UAO", 0x3,  {AArch64::FeaturePsUAO}  }, // 7
 };

const PState *lookupPStateByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "DAIFCLR", 0 },
    { "DAIFSET", 1 },
    { "DIT", 2 },
    { "PAN", 3 },
    { "SPSEL", 4 },
    { "SSBS", 5 },
    { "TCO", 6 },
    { "UAO", 7 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &PStatesList[Idx->_index];
}

const PState *lookupPStateByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x3, 7 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x19, 5 },
    { 0x1A, 2 },
    { 0x1C, 6 },
    { 0x1E, 1 },
    { 0x1F, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &PStatesList[Idx->_index];
}
#endif

#ifdef GET_SVCR_DECL
const SVCR *lookupSVCRByName(StringRef Name);
const SVCR *lookupSVCRByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVCR_IMPL
constexpr SVCR SVCRsList[] = {
  { "SVCRSM", 0x1,  {AArch64::FeatureSME}  }, // 0
  { "SVCRSMZA", 0x3,  {AArch64::FeatureSME}  }, // 1
  { "SVCRZA", 0x2,  {AArch64::FeatureSME}  }, // 2
 };

const SVCR *lookupSVCRByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "SVCRSM", 0 },
    { "SVCRSMZA", 1 },
    { "SVCRZA", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVCRsList[Idx->_index];
}

const SVCR *lookupSVCRByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 2 },
    { 0x3, 1 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SVCRsList[Idx->_index];
}
#endif

#ifdef GET_SVEPREDPAT_DECL
const SVEPREDPAT *lookupSVEPREDPATByName(StringRef Name);
const SVEPREDPAT *lookupSVEPREDPATByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVEPREDPAT_IMPL
constexpr SVEPREDPAT SVEPREDPATsList[] = {
  { "all", 0x1F }, // 0
  { "mul3", 0x1E }, // 1
  { "mul4", 0x1D }, // 2
  { "pow2", 0x0 }, // 3
  { "vl1", 0x1 }, // 4
  { "vl128", 0xC }, // 5
  { "vl16", 0x9 }, // 6
  { "vl2", 0x2 }, // 7
  { "vl256", 0xD }, // 8
  { "vl3", 0x3 }, // 9
  { "vl32", 0xA }, // 10
  { "vl4", 0x4 }, // 11
  { "vl5", 0x5 }, // 12
  { "vl6", 0x6 }, // 13
  { "vl64", 0xB }, // 14
  { "vl7", 0x7 }, // 15
  { "vl8", 0x8 }, // 16
 };

const SVEPREDPAT *lookupSVEPREDPATByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ALL", 0 },
    { "MUL3", 1 },
    { "MUL4", 2 },
    { "POW2", 3 },
    { "VL1", 4 },
    { "VL128", 5 },
    { "VL16", 6 },
    { "VL2", 7 },
    { "VL256", 8 },
    { "VL3", 9 },
    { "VL32", 10 },
    { "VL4", 11 },
    { "VL5", 12 },
    { "VL6", 13 },
    { "VL64", 14 },
    { "VL7", 15 },
    { "VL8", 16 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVEPREDPATsList[Idx->_index];
}

const SVEPREDPAT *lookupSVEPREDPATByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 3 },
    { 0x1, 4 },
    { 0x2, 7 },
    { 0x3, 9 },
    { 0x4, 11 },
    { 0x5, 12 },
    { 0x6, 13 },
    { 0x7, 15 },
    { 0x8, 16 },
    { 0x9, 6 },
    { 0xA, 10 },
    { 0xB, 14 },
    { 0xC, 5 },
    { 0xD, 8 },
    { 0x1D, 2 },
    { 0x1E, 1 },
    { 0x1F, 0 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SVEPREDPATsList[Idx->_index];
}
#endif

#ifdef GET_SVEPRFM_DECL
const SVEPRFM *lookupSVEPRFMByName(StringRef Name);
const SVEPRFM *lookupSVEPRFMByEncoding(uint8_t Encoding);
#endif

#ifdef GET_SVEPRFM_IMPL
constexpr SVEPRFM SVEPRFMsList[] = {
  { "pldl1keep", 0x0,  {AArch64::FeatureSVE}  }, // 0
  { "pldl1strm", 0x1,  {AArch64::FeatureSVE}  }, // 1
  { "pldl2keep", 0x2,  {AArch64::FeatureSVE}  }, // 2
  { "pldl2strm", 0x3,  {AArch64::FeatureSVE}  }, // 3
  { "pldl3keep", 0x4,  {AArch64::FeatureSVE}  }, // 4
  { "pldl3strm", 0x5,  {AArch64::FeatureSVE}  }, // 5
  { "pstl1keep", 0x8,  {AArch64::FeatureSVE}  }, // 6
  { "pstl1strm", 0x9,  {AArch64::FeatureSVE}  }, // 7
  { "pstl2keep", 0xA,  {AArch64::FeatureSVE}  }, // 8
  { "pstl2strm", 0xB,  {AArch64::FeatureSVE}  }, // 9
  { "pstl3keep", 0xC,  {AArch64::FeatureSVE}  }, // 10
  { "pstl3strm", 0xD,  {AArch64::FeatureSVE}  }, // 11
 };

const SVEPRFM *lookupSVEPRFMByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "PLDL1KEEP", 0 },
    { "PLDL1STRM", 1 },
    { "PLDL2KEEP", 2 },
    { "PLDL2STRM", 3 },
    { "PLDL3KEEP", 4 },
    { "PLDL3STRM", 5 },
    { "PSTL1KEEP", 6 },
    { "PSTL1STRM", 7 },
    { "PSTL2KEEP", 8 },
    { "PSTL2STRM", 9 },
    { "PSTL3KEEP", 10 },
    { "PSTL3STRM", 11 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SVEPRFMsList[Idx->_index];
}

const SVEPRFM *lookupSVEPRFMByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 1 },
    { 0x2, 2 },
    { 0x3, 3 },
    { 0x4, 4 },
    { 0x5, 5 },
    { 0x8, 6 },
    { 0x9, 7 },
    { 0xA, 8 },
    { 0xB, 9 },
    { 0xC, 10 },
    { 0xD, 11 },
  };

  struct KeyType {
    uint8_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SVEPRFMsList[Idx->_index];
}
#endif

#ifdef GET_SYSREG_DECL
const SysReg *lookupSysRegByName(StringRef Name);
const SysReg *lookupSysRegByEncoding(uint16_t Encoding);
#endif

#ifdef GET_SYSREG_IMPL
constexpr SysReg SysRegsList[] = {
  { "ACCDATA_EL1", "ACCDATA_EL1", 0xC685, true, true,  {AArch64::FeatureLS64}  }, // 0
  { "ACTLR_EL1", "ACTLR_EL1", 0xC081, true, true,  {}  }, // 1
  { "ACTLR_EL2", "ACTLR_EL2", 0xE081, true, true,  {}  }, // 2
  { "ACTLR_EL3", "ACTLR_EL3", 0xF081, true, true,  {}  }, // 3
  { "AFSR0_EL1", "AFSR0_EL1", 0xC288, true, true,  {}  }, // 4
  { "AFSR0_EL12", "AFSR0_EL12", 0xEA88, true, true,  {AArch64::FeatureVH}  }, // 5
  { "AFSR0_EL2", "AFSR0_EL2", 0xE288, true, true,  {}  }, // 6
  { "AFSR0_EL3", "AFSR0_EL3", 0xF288, true, true,  {}  }, // 7
  { "AFSR1_EL1", "AFSR1_EL1", 0xC289, true, true,  {}  }, // 8
  { "AFSR1_EL12", "AFSR1_EL12", 0xEA89, true, true,  {AArch64::FeatureVH}  }, // 9
  { "AFSR1_EL2", "AFSR1_EL2", 0xE289, true, true,  {}  }, // 10
  { "AFSR1_EL3", "AFSR1_EL3", 0xF289, true, true,  {}  }, // 11
  { "AIDR_EL1", "AIDR_EL1", 0xC807, true, false,  {}  }, // 12
  { "AMAIR_EL1", "AMAIR_EL1", 0xC518, true, true,  {}  }, // 13
  { "AMAIR_EL12", "AMAIR_EL12", 0xED18, true, true,  {AArch64::FeatureVH}  }, // 14
  { "AMAIR_EL2", "AMAIR_EL2", 0xE518, true, true,  {}  }, // 15
  { "AMAIR_EL3", "AMAIR_EL3", 0xF518, true, true,  {}  }, // 16
  { "AMCFGR_EL0", "AMCFGR_EL0", 0xDE91, true, false,  {AArch64::FeatureAM}  }, // 17
  { "AMCGCR_EL0", "AMCGCR_EL0", 0xDE92, true, false,  {AArch64::FeatureAM}  }, // 18
  { "AMCNTENCLR0_EL0", "AMCNTENCLR0_EL0", 0xDE94, true, true,  {AArch64::FeatureAM}  }, // 19
  { "AMCNTENCLR1_EL0", "AMCNTENCLR1_EL0", 0xDE98, true, true,  {AArch64::FeatureAM}  }, // 20
  { "AMCNTENSET0_EL0", "AMCNTENSET0_EL0", 0xDE95, true, true,  {AArch64::FeatureAM}  }, // 21
  { "AMCNTENSET1_EL0", "AMCNTENSET1_EL0", 0xDE99, true, true,  {AArch64::FeatureAM}  }, // 22
  { "AMCR_EL0", "AMCR_EL0", 0xDE90, true, true,  {AArch64::FeatureAM}  }, // 23
  { "AMEVCNTR00_EL0", "AMEVCNTR00_EL0", 0xDEA0, true, true,  {AArch64::FeatureAM}  }, // 24
  { "AMEVCNTR01_EL0", "AMEVCNTR01_EL0", 0xDEA1, true, true,  {AArch64::FeatureAM}  }, // 25
  { "AMEVCNTR02_EL0", "AMEVCNTR02_EL0", 0xDEA2, true, true,  {AArch64::FeatureAM}  }, // 26
  { "AMEVCNTR03_EL0", "AMEVCNTR03_EL0", 0xDEA3, true, true,  {AArch64::FeatureAM}  }, // 27
  { "AMEVCNTR10_EL0", "AMEVCNTR10_EL0", 0xDEE0, true, true,  {AArch64::FeatureAM}  }, // 28
  { "AMEVCNTR110_EL0", "AMEVCNTR110_EL0", 0xDEEA, true, true,  {AArch64::FeatureAM}  }, // 29
  { "AMEVCNTR111_EL0", "AMEVCNTR111_EL0", 0xDEEB, true, true,  {AArch64::FeatureAM}  }, // 30
  { "AMEVCNTR112_EL0", "AMEVCNTR112_EL0", 0xDEEC, true, true,  {AArch64::FeatureAM}  }, // 31
  { "AMEVCNTR113_EL0", "AMEVCNTR113_EL0", 0xDEED, true, true,  {AArch64::FeatureAM}  }, // 32
  { "AMEVCNTR114_EL0", "AMEVCNTR114_EL0", 0xDEEE, true, true,  {AArch64::FeatureAM}  }, // 33
  { "AMEVCNTR115_EL0", "AMEVCNTR115_EL0", 0xDEEF, true, true,  {AArch64::FeatureAM}  }, // 34
  { "AMEVCNTR11_EL0", "AMEVCNTR11_EL0", 0xDEE1, true, true,  {AArch64::FeatureAM}  }, // 35
  { "AMEVCNTR12_EL0", "AMEVCNTR12_EL0", 0xDEE2, true, true,  {AArch64::FeatureAM}  }, // 36
  { "AMEVCNTR13_EL0", "AMEVCNTR13_EL0", 0xDEE3, true, true,  {AArch64::FeatureAM}  }, // 37
  { "AMEVCNTR14_EL0", "AMEVCNTR14_EL0", 0xDEE4, true, true,  {AArch64::FeatureAM}  }, // 38
  { "AMEVCNTR15_EL0", "AMEVCNTR15_EL0", 0xDEE5, true, true,  {AArch64::FeatureAM}  }, // 39
  { "AMEVCNTR16_EL0", "AMEVCNTR16_EL0", 0xDEE6, true, true,  {AArch64::FeatureAM}  }, // 40
  { "AMEVCNTR17_EL0", "AMEVCNTR17_EL0", 0xDEE7, true, true,  {AArch64::FeatureAM}  }, // 41
  { "AMEVCNTR18_EL0", "AMEVCNTR18_EL0", 0xDEE8, true, true,  {AArch64::FeatureAM}  }, // 42
  { "AMEVCNTR19_EL0", "AMEVCNTR19_EL0", 0xDEE9, true, true,  {AArch64::FeatureAM}  }, // 43
  { "AMEVCNTVOFF00_EL2", "AMEVCNTVOFF00_EL2", 0xE6C0, true, true,  {AArch64::FeatureAMVS}  }, // 44
  { "AMEVCNTVOFF010_EL2", "AMEVCNTVOFF010_EL2", 0xE6CA, true, true,  {AArch64::FeatureAMVS}  }, // 45
  { "AMEVCNTVOFF011_EL2", "AMEVCNTVOFF011_EL2", 0xE6CB, true, true,  {AArch64::FeatureAMVS}  }, // 46
  { "AMEVCNTVOFF012_EL2", "AMEVCNTVOFF012_EL2", 0xE6CC, true, true,  {AArch64::FeatureAMVS}  }, // 47
  { "AMEVCNTVOFF013_EL2", "AMEVCNTVOFF013_EL2", 0xE6CD, true, true,  {AArch64::FeatureAMVS}  }, // 48
  { "AMEVCNTVOFF014_EL2", "AMEVCNTVOFF014_EL2", 0xE6CE, true, true,  {AArch64::FeatureAMVS}  }, // 49
  { "AMEVCNTVOFF015_EL2", "AMEVCNTVOFF015_EL2", 0xE6CF, true, true,  {AArch64::FeatureAMVS}  }, // 50
  { "AMEVCNTVOFF01_EL2", "AMEVCNTVOFF01_EL2", 0xE6C1, true, true,  {AArch64::FeatureAMVS}  }, // 51
  { "AMEVCNTVOFF02_EL2", "AMEVCNTVOFF02_EL2", 0xE6C2, true, true,  {AArch64::FeatureAMVS}  }, // 52
  { "AMEVCNTVOFF03_EL2", "AMEVCNTVOFF03_EL2", 0xE6C3, true, true,  {AArch64::FeatureAMVS}  }, // 53
  { "AMEVCNTVOFF04_EL2", "AMEVCNTVOFF04_EL2", 0xE6C4, true, true,  {AArch64::FeatureAMVS}  }, // 54
  { "AMEVCNTVOFF05_EL2", "AMEVCNTVOFF05_EL2", 0xE6C5, true, true,  {AArch64::FeatureAMVS}  }, // 55
  { "AMEVCNTVOFF06_EL2", "AMEVCNTVOFF06_EL2", 0xE6C6, true, true,  {AArch64::FeatureAMVS}  }, // 56
  { "AMEVCNTVOFF07_EL2", "AMEVCNTVOFF07_EL2", 0xE6C7, true, true,  {AArch64::FeatureAMVS}  }, // 57
  { "AMEVCNTVOFF08_EL2", "AMEVCNTVOFF08_EL2", 0xE6C8, true, true,  {AArch64::FeatureAMVS}  }, // 58
  { "AMEVCNTVOFF09_EL2", "AMEVCNTVOFF09_EL2", 0xE6C9, true, true,  {AArch64::FeatureAMVS}  }, // 59
  { "AMEVCNTVOFF10_EL2", "AMEVCNTVOFF10_EL2", 0xE6D0, true, true,  {AArch64::FeatureAMVS}  }, // 60
  { "AMEVCNTVOFF110_EL2", "AMEVCNTVOFF110_EL2", 0xE6DA, true, true,  {AArch64::FeatureAMVS}  }, // 61
  { "AMEVCNTVOFF111_EL2", "AMEVCNTVOFF111_EL2", 0xE6DB, true, true,  {AArch64::FeatureAMVS}  }, // 62
  { "AMEVCNTVOFF112_EL2", "AMEVCNTVOFF112_EL2", 0xE6DC, true, true,  {AArch64::FeatureAMVS}  }, // 63
  { "AMEVCNTVOFF113_EL2", "AMEVCNTVOFF113_EL2", 0xE6DD, true, true,  {AArch64::FeatureAMVS}  }, // 64
  { "AMEVCNTVOFF114_EL2", "AMEVCNTVOFF114_EL2", 0xE6DE, true, true,  {AArch64::FeatureAMVS}  }, // 65
  { "AMEVCNTVOFF115_EL2", "AMEVCNTVOFF115_EL2", 0xE6DF, true, true,  {AArch64::FeatureAMVS}  }, // 66
  { "AMEVCNTVOFF11_EL2", "AMEVCNTVOFF11_EL2", 0xE6D1, true, true,  {AArch64::FeatureAMVS}  }, // 67
  { "AMEVCNTVOFF12_EL2", "AMEVCNTVOFF12_EL2", 0xE6D2, true, true,  {AArch64::FeatureAMVS}  }, // 68
  { "AMEVCNTVOFF13_EL2", "AMEVCNTVOFF13_EL2", 0xE6D3, true, true,  {AArch64::FeatureAMVS}  }, // 69
  { "AMEVCNTVOFF14_EL2", "AMEVCNTVOFF14_EL2", 0xE6D4, true, true,  {AArch64::FeatureAMVS}  }, // 70
  { "AMEVCNTVOFF15_EL2", "AMEVCNTVOFF15_EL2", 0xE6D5, true, true,  {AArch64::FeatureAMVS}  }, // 71
  { "AMEVCNTVOFF16_EL2", "AMEVCNTVOFF16_EL2", 0xE6D6, true, true,  {AArch64::FeatureAMVS}  }, // 72
  { "AMEVCNTVOFF17_EL2", "AMEVCNTVOFF17_EL2", 0xE6D7, true, true,  {AArch64::FeatureAMVS}  }, // 73
  { "AMEVCNTVOFF18_EL2", "AMEVCNTVOFF18_EL2", 0xE6D8, true, true,  {AArch64::FeatureAMVS}  }, // 74
  { "AMEVCNTVOFF19_EL2", "AMEVCNTVOFF19_EL2", 0xE6D9, true, true,  {AArch64::FeatureAMVS}  }, // 75
  { "AMEVTYPER00_EL0", "AMEVTYPER00_EL0", 0xDEB0, true, false,  {AArch64::FeatureAM}  }, // 76
  { "AMEVTYPER01_EL0", "AMEVTYPER01_EL0", 0xDEB1, true, false,  {AArch64::FeatureAM}  }, // 77
  { "AMEVTYPER02_EL0", "AMEVTYPER02_EL0", 0xDEB2, true, false,  {AArch64::FeatureAM}  }, // 78
  { "AMEVTYPER03_EL0", "AMEVTYPER03_EL0", 0xDEB3, true, false,  {AArch64::FeatureAM}  }, // 79
  { "AMEVTYPER10_EL0", "AMEVTYPER10_EL0", 0xDEF0, true, true,  {AArch64::FeatureAM}  }, // 80
  { "AMEVTYPER110_EL0", "AMEVTYPER110_EL0", 0xDEFA, true, true,  {AArch64::FeatureAM}  }, // 81
  { "AMEVTYPER111_EL0", "AMEVTYPER111_EL0", 0xDEFB, true, true,  {AArch64::FeatureAM}  }, // 82
  { "AMEVTYPER112_EL0", "AMEVTYPER112_EL0", 0xDEFC, true, true,  {AArch64::FeatureAM}  }, // 83
  { "AMEVTYPER113_EL0", "AMEVTYPER113_EL0", 0xDEFD, true, true,  {AArch64::FeatureAM}  }, // 84
  { "AMEVTYPER114_EL0", "AMEVTYPER114_EL0", 0xDEFE, true, true,  {AArch64::FeatureAM}  }, // 85
  { "AMEVTYPER115_EL0", "AMEVTYPER115_EL0", 0xDEFF, true, true,  {AArch64::FeatureAM}  }, // 86
  { "AMEVTYPER11_EL0", "AMEVTYPER11_EL0", 0xDEF1, true, true,  {AArch64::FeatureAM}  }, // 87
  { "AMEVTYPER12_EL0", "AMEVTYPER12_EL0", 0xDEF2, true, true,  {AArch64::FeatureAM}  }, // 88
  { "AMEVTYPER13_EL0", "AMEVTYPER13_EL0", 0xDEF3, true, true,  {AArch64::FeatureAM}  }, // 89
  { "AMEVTYPER14_EL0", "AMEVTYPER14_EL0", 0xDEF4, true, true,  {AArch64::FeatureAM}  }, // 90
  { "AMEVTYPER15_EL0", "AMEVTYPER15_EL0", 0xDEF5, true, true,  {AArch64::FeatureAM}  }, // 91
  { "AMEVTYPER16_EL0", "AMEVTYPER16_EL0", 0xDEF6, true, true,  {AArch64::FeatureAM}  }, // 92
  { "AMEVTYPER17_EL0", "AMEVTYPER17_EL0", 0xDEF7, true, true,  {AArch64::FeatureAM}  }, // 93
  { "AMEVTYPER18_EL0", "AMEVTYPER18_EL0", 0xDEF8, true, true,  {AArch64::FeatureAM}  }, // 94
  { "AMEVTYPER19_EL0", "AMEVTYPER19_EL0", 0xDEF9, true, true,  {AArch64::FeatureAM}  }, // 95
  { "AMUSERENR_EL0", "AMUSERENR_EL0", 0xDE93, true, true,  {AArch64::FeatureAM}  }, // 96
  { "APDAKeyHi_EL1", "APDAKeyHi_EL1", 0xC111, true, true,  {AArch64::FeaturePAuth}  }, // 97
  { "APDAKeyLo_EL1", "APDAKeyLo_EL1", 0xC110, true, true,  {AArch64::FeaturePAuth}  }, // 98
  { "APDBKeyHi_EL1", "APDBKeyHi_EL1", 0xC113, true, true,  {AArch64::FeaturePAuth}  }, // 99
  { "APDBKeyLo_EL1", "APDBKeyLo_EL1", 0xC112, true, true,  {AArch64::FeaturePAuth}  }, // 100
  { "APGAKeyHi_EL1", "APGAKeyHi_EL1", 0xC119, true, true,  {AArch64::FeaturePAuth}  }, // 101
  { "APGAKeyLo_EL1", "APGAKeyLo_EL1", 0xC118, true, true,  {AArch64::FeaturePAuth}  }, // 102
  { "APIAKeyHi_EL1", "APIAKeyHi_EL1", 0xC109, true, true,  {AArch64::FeaturePAuth}  }, // 103
  { "APIAKeyLo_EL1", "APIAKeyLo_EL1", 0xC108, true, true,  {AArch64::FeaturePAuth}  }, // 104
  { "APIBKeyHi_EL1", "APIBKeyHi_EL1", 0xC10B, true, true,  {AArch64::FeaturePAuth}  }, // 105
  { "APIBKeyLo_EL1", "APIBKeyLo_EL1", 0xC10A, true, true,  {AArch64::FeaturePAuth}  }, // 106
  { "BRBCR_EL1", "BRBCR_EL1", 0x8C80, true, true,  {AArch64::FeatureBRBE}  }, // 107
  { "BRBCR_EL12", "BRBCR_EL12", 0xAC80, true, true,  {AArch64::FeatureBRBE}  }, // 108
  { "BRBCR_EL2", "BRBCR_EL2", 0xA480, true, true,  {AArch64::FeatureBRBE}  }, // 109
  { "BRBFCR_EL1", "BRBFCR_EL1", 0x8C81, true, true,  {AArch64::FeatureBRBE}  }, // 110
  { "BRBIDR0_EL1", "BRBIDR0_EL1", 0x8C90, true, false,  {AArch64::FeatureBRBE}  }, // 111
  { "BRBINF0_EL1", "BRBINF0_EL1", 0x8C00, true, false,  {AArch64::FeatureBRBE}  }, // 112
  { "BRBINF10_EL1", "BRBINF10_EL1", 0x8C50, true, false,  {AArch64::FeatureBRBE}  }, // 113
  { "BRBINF11_EL1", "BRBINF11_EL1", 0x8C58, true, false,  {AArch64::FeatureBRBE}  }, // 114
  { "BRBINF12_EL1", "BRBINF12_EL1", 0x8C60, true, false,  {AArch64::FeatureBRBE}  }, // 115
  { "BRBINF13_EL1", "BRBINF13_EL1", 0x8C68, true, false,  {AArch64::FeatureBRBE}  }, // 116
  { "BRBINF14_EL1", "BRBINF14_EL1", 0x8C70, true, false,  {AArch64::FeatureBRBE}  }, // 117
  { "BRBINF15_EL1", "BRBINF15_EL1", 0x8C78, true, false,  {AArch64::FeatureBRBE}  }, // 118
  { "BRBINF16_EL1", "BRBINF16_EL1", 0x8C04, true, false,  {AArch64::FeatureBRBE}  }, // 119
  { "BRBINF17_EL1", "BRBINF17_EL1", 0x8C0C, true, false,  {AArch64::FeatureBRBE}  }, // 120
  { "BRBINF18_EL1", "BRBINF18_EL1", 0x8C14, true, false,  {AArch64::FeatureBRBE}  }, // 121
  { "BRBINF19_EL1", "BRBINF19_EL1", 0x8C1C, true, false,  {AArch64::FeatureBRBE}  }, // 122
  { "BRBINF1_EL1", "BRBINF1_EL1", 0x8C08, true, false,  {AArch64::FeatureBRBE}  }, // 123
  { "BRBINF20_EL1", "BRBINF20_EL1", 0x8C24, true, false,  {AArch64::FeatureBRBE}  }, // 124
  { "BRBINF21_EL1", "BRBINF21_EL1", 0x8C2C, true, false,  {AArch64::FeatureBRBE}  }, // 125
  { "BRBINF22_EL1", "BRBINF22_EL1", 0x8C34, true, false,  {AArch64::FeatureBRBE}  }, // 126
  { "BRBINF23_EL1", "BRBINF23_EL1", 0x8C3C, true, false,  {AArch64::FeatureBRBE}  }, // 127
  { "BRBINF24_EL1", "BRBINF24_EL1", 0x8C44, true, false,  {AArch64::FeatureBRBE}  }, // 128
  { "BRBINF25_EL1", "BRBINF25_EL1", 0x8C4C, true, false,  {AArch64::FeatureBRBE}  }, // 129
  { "BRBINF26_EL1", "BRBINF26_EL1", 0x8C54, true, false,  {AArch64::FeatureBRBE}  }, // 130
  { "BRBINF27_EL1", "BRBINF27_EL1", 0x8C5C, true, false,  {AArch64::FeatureBRBE}  }, // 131
  { "BRBINF28_EL1", "BRBINF28_EL1", 0x8C64, true, false,  {AArch64::FeatureBRBE}  }, // 132
  { "BRBINF29_EL1", "BRBINF29_EL1", 0x8C6C, true, false,  {AArch64::FeatureBRBE}  }, // 133
  { "BRBINF2_EL1", "BRBINF2_EL1", 0x8C10, true, false,  {AArch64::FeatureBRBE}  }, // 134
  { "BRBINF30_EL1", "BRBINF30_EL1", 0x8C74, true, false,  {AArch64::FeatureBRBE}  }, // 135
  { "BRBINF31_EL1", "BRBINF31_EL1", 0x8C7C, true, false,  {AArch64::FeatureBRBE}  }, // 136
  { "BRBINF3_EL1", "BRBINF3_EL1", 0x8C18, true, false,  {AArch64::FeatureBRBE}  }, // 137
  { "BRBINF4_EL1", "BRBINF4_EL1", 0x8C20, true, false,  {AArch64::FeatureBRBE}  }, // 138
  { "BRBINF5_EL1", "BRBINF5_EL1", 0x8C28, true, false,  {AArch64::FeatureBRBE}  }, // 139
  { "BRBINF6_EL1", "BRBINF6_EL1", 0x8C30, true, false,  {AArch64::FeatureBRBE}  }, // 140
  { "BRBINF7_EL1", "BRBINF7_EL1", 0x8C38, true, false,  {AArch64::FeatureBRBE}  }, // 141
  { "BRBINF8_EL1", "BRBINF8_EL1", 0x8C40, true, false,  {AArch64::FeatureBRBE}  }, // 142
  { "BRBINF9_EL1", "BRBINF9_EL1", 0x8C48, true, false,  {AArch64::FeatureBRBE}  }, // 143
  { "BRBINFINJ_EL1", "BRBINFINJ_EL1", 0x8C88, true, true,  {AArch64::FeatureBRBE}  }, // 144
  { "BRBSRC0_EL1", "BRBSRC0_EL1", 0x8C01, true, false,  {AArch64::FeatureBRBE}  }, // 145
  { "BRBSRC10_EL1", "BRBSRC10_EL1", 0x8C51, true, false,  {AArch64::FeatureBRBE}  }, // 146
  { "BRBSRC11_EL1", "BRBSRC11_EL1", 0x8C59, true, false,  {AArch64::FeatureBRBE}  }, // 147
  { "BRBSRC12_EL1", "BRBSRC12_EL1", 0x8C61, true, false,  {AArch64::FeatureBRBE}  }, // 148
  { "BRBSRC13_EL1", "BRBSRC13_EL1", 0x8C69, true, false,  {AArch64::FeatureBRBE}  }, // 149
  { "BRBSRC14_EL1", "BRBSRC14_EL1", 0x8C71, true, false,  {AArch64::FeatureBRBE}  }, // 150
  { "BRBSRC15_EL1", "BRBSRC15_EL1", 0x8C79, true, false,  {AArch64::FeatureBRBE}  }, // 151
  { "BRBSRC16_EL1", "BRBSRC16_EL1", 0x8C05, true, false,  {AArch64::FeatureBRBE}  }, // 152
  { "BRBSRC17_EL1", "BRBSRC17_EL1", 0x8C0D, true, false,  {AArch64::FeatureBRBE}  }, // 153
  { "BRBSRC18_EL1", "BRBSRC18_EL1", 0x8C15, true, false,  {AArch64::FeatureBRBE}  }, // 154
  { "BRBSRC19_EL1", "BRBSRC19_EL1", 0x8C1D, true, false,  {AArch64::FeatureBRBE}  }, // 155
  { "BRBSRC1_EL1", "BRBSRC1_EL1", 0x8C09, true, false,  {AArch64::FeatureBRBE}  }, // 156
  { "BRBSRC20_EL1", "BRBSRC20_EL1", 0x8C25, true, false,  {AArch64::FeatureBRBE}  }, // 157
  { "BRBSRC21_EL1", "BRBSRC21_EL1", 0x8C2D, true, false,  {AArch64::FeatureBRBE}  }, // 158
  { "BRBSRC22_EL1", "BRBSRC22_EL1", 0x8C35, true, false,  {AArch64::FeatureBRBE}  }, // 159
  { "BRBSRC23_EL1", "BRBSRC23_EL1", 0x8C3D, true, false,  {AArch64::FeatureBRBE}  }, // 160
  { "BRBSRC24_EL1", "BRBSRC24_EL1", 0x8C45, true, false,  {AArch64::FeatureBRBE}  }, // 161
  { "BRBSRC25_EL1", "BRBSRC25_EL1", 0x8C4D, true, false,  {AArch64::FeatureBRBE}  }, // 162
  { "BRBSRC26_EL1", "BRBSRC26_EL1", 0x8C55, true, false,  {AArch64::FeatureBRBE}  }, // 163
  { "BRBSRC27_EL1", "BRBSRC27_EL1", 0x8C5D, true, false,  {AArch64::FeatureBRBE}  }, // 164
  { "BRBSRC28_EL1", "BRBSRC28_EL1", 0x8C65, true, false,  {AArch64::FeatureBRBE}  }, // 165
  { "BRBSRC29_EL1", "BRBSRC29_EL1", 0x8C6D, true, false,  {AArch64::FeatureBRBE}  }, // 166
  { "BRBSRC2_EL1", "BRBSRC2_EL1", 0x8C11, true, false,  {AArch64::FeatureBRBE}  }, // 167
  { "BRBSRC30_EL1", "BRBSRC30_EL1", 0x8C75, true, false,  {AArch64::FeatureBRBE}  }, // 168
  { "BRBSRC31_EL1", "BRBSRC31_EL1", 0x8C7D, true, false,  {AArch64::FeatureBRBE}  }, // 169
  { "BRBSRC3_EL1", "BRBSRC3_EL1", 0x8C19, true, false,  {AArch64::FeatureBRBE}  }, // 170
  { "BRBSRC4_EL1", "BRBSRC4_EL1", 0x8C21, true, false,  {AArch64::FeatureBRBE}  }, // 171
  { "BRBSRC5_EL1", "BRBSRC5_EL1", 0x8C29, true, false,  {AArch64::FeatureBRBE}  }, // 172
  { "BRBSRC6_EL1", "BRBSRC6_EL1", 0x8C31, true, false,  {AArch64::FeatureBRBE}  }, // 173
  { "BRBSRC7_EL1", "BRBSRC7_EL1", 0x8C39, true, false,  {AArch64::FeatureBRBE}  }, // 174
  { "BRBSRC8_EL1", "BRBSRC8_EL1", 0x8C41, true, false,  {AArch64::FeatureBRBE}  }, // 175
  { "BRBSRC9_EL1", "BRBSRC9_EL1", 0x8C49, true, false,  {AArch64::FeatureBRBE}  }, // 176
  { "BRBSRCINJ_EL1", "BRBSRCINJ_EL1", 0x8C89, true, true,  {AArch64::FeatureBRBE}  }, // 177
  { "BRBTGT0_EL1", "BRBTGT0_EL1", 0x8C02, true, false,  {AArch64::FeatureBRBE}  }, // 178
  { "BRBTGT10_EL1", "BRBTGT10_EL1", 0x8C52, true, false,  {AArch64::FeatureBRBE}  }, // 179
  { "BRBTGT11_EL1", "BRBTGT11_EL1", 0x8C5A, true, false,  {AArch64::FeatureBRBE}  }, // 180
  { "BRBTGT12_EL1", "BRBTGT12_EL1", 0x8C62, true, false,  {AArch64::FeatureBRBE}  }, // 181
  { "BRBTGT13_EL1", "BRBTGT13_EL1", 0x8C6A, true, false,  {AArch64::FeatureBRBE}  }, // 182
  { "BRBTGT14_EL1", "BRBTGT14_EL1", 0x8C72, true, false,  {AArch64::FeatureBRBE}  }, // 183
  { "BRBTGT15_EL1", "BRBTGT15_EL1", 0x8C7A, true, false,  {AArch64::FeatureBRBE}  }, // 184
  { "BRBTGT16_EL1", "BRBTGT16_EL1", 0x8C06, true, false,  {AArch64::FeatureBRBE}  }, // 185
  { "BRBTGT17_EL1", "BRBTGT17_EL1", 0x8C0E, true, false,  {AArch64::FeatureBRBE}  }, // 186
  { "BRBTGT18_EL1", "BRBTGT18_EL1", 0x8C16, true, false,  {AArch64::FeatureBRBE}  }, // 187
  { "BRBTGT19_EL1", "BRBTGT19_EL1", 0x8C1E, true, false,  {AArch64::FeatureBRBE}  }, // 188
  { "BRBTGT1_EL1", "BRBTGT1_EL1", 0x8C0A, true, false,  {AArch64::FeatureBRBE}  }, // 189
  { "BRBTGT20_EL1", "BRBTGT20_EL1", 0x8C26, true, false,  {AArch64::FeatureBRBE}  }, // 190
  { "BRBTGT21_EL1", "BRBTGT21_EL1", 0x8C2E, true, false,  {AArch64::FeatureBRBE}  }, // 191
  { "BRBTGT22_EL1", "BRBTGT22_EL1", 0x8C36, true, false,  {AArch64::FeatureBRBE}  }, // 192
  { "BRBTGT23_EL1", "BRBTGT23_EL1", 0x8C3E, true, false,  {AArch64::FeatureBRBE}  }, // 193
  { "BRBTGT24_EL1", "BRBTGT24_EL1", 0x8C46, true, false,  {AArch64::FeatureBRBE}  }, // 194
  { "BRBTGT25_EL1", "BRBTGT25_EL1", 0x8C4E, true, false,  {AArch64::FeatureBRBE}  }, // 195
  { "BRBTGT26_EL1", "BRBTGT26_EL1", 0x8C56, true, false,  {AArch64::FeatureBRBE}  }, // 196
  { "BRBTGT27_EL1", "BRBTGT27_EL1", 0x8C5E, true, false,  {AArch64::FeatureBRBE}  }, // 197
  { "BRBTGT28_EL1", "BRBTGT28_EL1", 0x8C66, true, false,  {AArch64::FeatureBRBE}  }, // 198
  { "BRBTGT29_EL1", "BRBTGT29_EL1", 0x8C6E, true, false,  {AArch64::FeatureBRBE}  }, // 199
  { "BRBTGT2_EL1", "BRBTGT2_EL1", 0x8C12, true, false,  {AArch64::FeatureBRBE}  }, // 200
  { "BRBTGT30_EL1", "BRBTGT30_EL1", 0x8C76, true, false,  {AArch64::FeatureBRBE}  }, // 201
  { "BRBTGT31_EL1", "BRBTGT31_EL1", 0x8C7E, true, false,  {AArch64::FeatureBRBE}  }, // 202
  { "BRBTGT3_EL1", "BRBTGT3_EL1", 0x8C1A, true, false,  {AArch64::FeatureBRBE}  }, // 203
  { "BRBTGT4_EL1", "BRBTGT4_EL1", 0x8C22, true, false,  {AArch64::FeatureBRBE}  }, // 204
  { "BRBTGT5_EL1", "BRBTGT5_EL1", 0x8C2A, true, false,  {AArch64::FeatureBRBE}  }, // 205
  { "BRBTGT6_EL1", "BRBTGT6_EL1", 0x8C32, true, false,  {AArch64::FeatureBRBE}  }, // 206
  { "BRBTGT7_EL1", "BRBTGT7_EL1", 0x8C3A, true, false,  {AArch64::FeatureBRBE}  }, // 207
  { "BRBTGT8_EL1", "BRBTGT8_EL1", 0x8C42, true, false,  {AArch64::FeatureBRBE}  }, // 208
  { "BRBTGT9_EL1", "BRBTGT9_EL1", 0x8C4A, true, false,  {AArch64::FeatureBRBE}  }, // 209
  { "BRBTGTINJ_EL1", "BRBTGTINJ_EL1", 0x8C8A, true, true,  {AArch64::FeatureBRBE}  }, // 210
  { "BRBTS_EL1", "BRBTS_EL1", 0x8C82, true, true,  {AArch64::FeatureBRBE}  }, // 211
  { "CCSIDR2_EL1", "CCSIDR2_EL1", 0xC802, true, false,  {AArch64::FeatureCCIDX}  }, // 212
  { "CCSIDR_EL1", "CCSIDR_EL1", 0xC800, true, false,  {}  }, // 213
  { "CLIDR_EL1", "CLIDR_EL1", 0xC801, true, false,  {}  }, // 214
  { "CNTFRQ_EL0", "CNTFRQ_EL0", 0xDF00, true, true,  {}  }, // 215
  { "CNTHCTL_EL2", "CNTHCTL_EL2", 0xE708, true, true,  {}  }, // 216
  { "CNTHPS_CTL_EL2", "CNTHPS_CTL_EL2", 0xE729, true, true,  {AArch64::FeatureSEL2}  }, // 217
  { "CNTHPS_CVAL_EL2", "CNTHPS_CVAL_EL2", 0xE72A, true, true,  {AArch64::FeatureSEL2}  }, // 218
  { "CNTHPS_TVAL_EL2", "CNTHPS_TVAL_EL2", 0xE728, true, true,  {AArch64::FeatureSEL2}  }, // 219
  { "CNTHP_CTL_EL2", "CNTHP_CTL_EL2", 0xE711, true, true,  {}  }, // 220
  { "CNTHP_CVAL_EL2", "CNTHP_CVAL_EL2", 0xE712, true, true,  {}  }, // 221
  { "CNTHP_TVAL_EL2", "CNTHP_TVAL_EL2", 0xE710, true, true,  {}  }, // 222
  { "CNTHVS_CTL_EL2", "CNTHVS_CTL_EL2", 0xE721, true, true,  {AArch64::FeatureSEL2}  }, // 223
  { "CNTHVS_CVAL_EL2", "CNTHVS_CVAL_EL2", 0xE722, true, true,  {AArch64::FeatureSEL2}  }, // 224
  { "CNTHVS_TVAL_EL2", "CNTHVS_TVAL_EL2", 0xE720, true, true,  {AArch64::FeatureSEL2}  }, // 225
  { "CNTHV_CTL_EL2", "CNTHV_CTL_EL2", 0xE719, true, true,  {AArch64::FeatureVH}  }, // 226
  { "CNTHV_CVAL_EL2", "CNTHV_CVAL_EL2", 0xE71A, true, true,  {AArch64::FeatureVH}  }, // 227
  { "CNTHV_TVAL_EL2", "CNTHV_TVAL_EL2", 0xE718, true, true,  {AArch64::FeatureVH}  }, // 228
  { "CNTISCALE_EL2", "CNTISCALE_EL2", 0xE705, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 229
  { "CNTKCTL_EL1", "CNTKCTL_EL1", 0xC708, true, true,  {}  }, // 230
  { "CNTKCTL_EL12", "CNTKCTL_EL12", 0xEF08, true, true,  {AArch64::FeatureVH}  }, // 231
  { "CNTPCTSS_EL0", "CNTPCTSS_EL0", 0xDF05, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 232
  { "CNTPCT_EL0", "CNTPCT_EL0", 0xDF01, true, false,  {}  }, // 233
  { "CNTPOFF_EL2", "CNTPOFF_EL2", 0xE706, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 234
  { "CNTPS_CTL_EL1", "CNTPS_CTL_EL1", 0xFF11, true, true,  {}  }, // 235
  { "CNTPS_CVAL_EL1", "CNTPS_CVAL_EL1", 0xFF12, true, true,  {}  }, // 236
  { "CNTPS_TVAL_EL1", "CNTPS_TVAL_EL1", 0xFF10, true, true,  {}  }, // 237
  { "CNTP_CTL_EL0", "CNTP_CTL_EL0", 0xDF11, true, true,  {}  }, // 238
  { "CNTP_CTL_EL02", "CNTP_CTL_EL02", 0xEF11, true, true,  {AArch64::FeatureVH}  }, // 239
  { "CNTP_CVAL_EL0", "CNTP_CVAL_EL0", 0xDF12, true, true,  {}  }, // 240
  { "CNTP_CVAL_EL02", "CNTP_CVAL_EL02", 0xEF12, true, true,  {AArch64::FeatureVH}  }, // 241
  { "CNTP_TVAL_EL0", "CNTP_TVAL_EL0", 0xDF10, true, true,  {}  }, // 242
  { "CNTP_TVAL_EL02", "CNTP_TVAL_EL02", 0xEF10, true, true,  {AArch64::FeatureVH}  }, // 243
  { "CNTSCALE_EL2", "CNTSCALE_EL2", 0xE704, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 244
  { "CNTVCTSS_EL0", "CNTVCTSS_EL0", 0xDF06, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 245
  { "CNTVCT_EL0", "CNTVCT_EL0", 0xDF02, true, false,  {}  }, // 246
  { "CNTVFRQ_EL2", "CNTVFRQ_EL2", 0xE707, true, true,  {AArch64::FeatureEnhancedCounterVirtualization}  }, // 247
  { "CNTVOFF_EL2", "CNTVOFF_EL2", 0xE703, true, true,  {}  }, // 248
  { "CNTV_CTL_EL0", "CNTV_CTL_EL0", 0xDF19, true, true,  {}  }, // 249
  { "CNTV_CTL_EL02", "CNTV_CTL_EL02", 0xEF19, true, true,  {AArch64::FeatureVH}  }, // 250
  { "CNTV_CVAL_EL0", "CNTV_CVAL_EL0", 0xDF1A, true, true,  {}  }, // 251
  { "CNTV_CVAL_EL02", "CNTV_CVAL_EL02", 0xEF1A, true, true,  {AArch64::FeatureVH}  }, // 252
  { "CNTV_TVAL_EL0", "CNTV_TVAL_EL0", 0xDF18, true, true,  {}  }, // 253
  { "CNTV_TVAL_EL02", "CNTV_TVAL_EL02", 0xEF18, true, true,  {AArch64::FeatureVH}  }, // 254
  { "CONTEXTIDR_EL1", "CONTEXTIDR_EL1", 0xC681, true, true,  {}  }, // 255
  { "CONTEXTIDR_EL12", "CONTEXTIDR_EL12", 0xEE81, true, true,  {AArch64::FeatureVH}  }, // 256
  { "CONTEXTIDR_EL2", "CONTEXTIDR_EL2", 0xE681, true, true,  {AArch64::FeatureCONTEXTIDREL2}  }, // 257
  { "CPACR_EL1", "CPACR_EL1", 0xC082, true, true,  {}  }, // 258
  { "CPACR_EL12", "CPACR_EL12", 0xE882, true, true,  {AArch64::FeatureVH}  }, // 259
  { "CPM_IOACC_CTL_EL3", "CPM_IOACC_CTL_EL3", 0xFF90, true, true,  {AArch64::FeatureAppleA7SysReg}  }, // 260
  { "CPTR_EL2", "CPTR_EL2", 0xE08A, true, true,  {}  }, // 261
  { "CPTR_EL3", "CPTR_EL3", 0xF08A, true, true,  {}  }, // 262
  { "CSSELR_EL1", "CSSELR_EL1", 0xD000, true, true,  {}  }, // 263
  { "CTR_EL0", "CTR_EL0", 0xD801, true, false,  {}  }, // 264
  { "CurrentEL", "CurrentEL", 0xC212, true, false,  {}  }, // 265
  { "DACR32_EL2", "DACR32_EL2", 0xE180, true, true,  {}  }, // 266
  { "DAIF", "DAIF", 0xDA11, true, true,  {}  }, // 267
  { "DBGAUTHSTATUS_EL1", "DBGAUTHSTATUS_EL1", 0x83F6, true, false,  {}  }, // 268
  { "DBGBCR0_EL1", "DBGBCR0_EL1", 0x8005, true, true,  {}  }, // 269
  { "DBGBCR10_EL1", "DBGBCR10_EL1", 0x8055, true, true,  {}  }, // 270
  { "DBGBCR11_EL1", "DBGBCR11_EL1", 0x805D, true, true,  {}  }, // 271
  { "DBGBCR12_EL1", "DBGBCR12_EL1", 0x8065, true, true,  {}  }, // 272
  { "DBGBCR13_EL1", "DBGBCR13_EL1", 0x806D, true, true,  {}  }, // 273
  { "DBGBCR14_EL1", "DBGBCR14_EL1", 0x8075, true, true,  {}  }, // 274
  { "DBGBCR15_EL1", "DBGBCR15_EL1", 0x807D, true, true,  {}  }, // 275
  { "DBGBCR1_EL1", "DBGBCR1_EL1", 0x800D, true, true,  {}  }, // 276
  { "DBGBCR2_EL1", "DBGBCR2_EL1", 0x8015, true, true,  {}  }, // 277
  { "DBGBCR3_EL1", "DBGBCR3_EL1", 0x801D, true, true,  {}  }, // 278
  { "DBGBCR4_EL1", "DBGBCR4_EL1", 0x8025, true, true,  {}  }, // 279
  { "DBGBCR5_EL1", "DBGBCR5_EL1", 0x802D, true, true,  {}  }, // 280
  { "DBGBCR6_EL1", "DBGBCR6_EL1", 0x8035, true, true,  {}  }, // 281
  { "DBGBCR7_EL1", "DBGBCR7_EL1", 0x803D, true, true,  {}  }, // 282
  { "DBGBCR8_EL1", "DBGBCR8_EL1", 0x8045, true, true,  {}  }, // 283
  { "DBGBCR9_EL1", "DBGBCR9_EL1", 0x804D, true, true,  {}  }, // 284
  { "DBGBVR0_EL1", "DBGBVR0_EL1", 0x8004, true, true,  {}  }, // 285
  { "DBGBVR10_EL1", "DBGBVR10_EL1", 0x8054, true, true,  {}  }, // 286
  { "DBGBVR11_EL1", "DBGBVR11_EL1", 0x805C, true, true,  {}  }, // 287
  { "DBGBVR12_EL1", "DBGBVR12_EL1", 0x8064, true, true,  {}  }, // 288
  { "DBGBVR13_EL1", "DBGBVR13_EL1", 0x806C, true, true,  {}  }, // 289
  { "DBGBVR14_EL1", "DBGBVR14_EL1", 0x8074, true, true,  {}  }, // 290
  { "DBGBVR15_EL1", "DBGBVR15_EL1", 0x807C, true, true,  {}  }, // 291
  { "DBGBVR1_EL1", "DBGBVR1_EL1", 0x800C, true, true,  {}  }, // 292
  { "DBGBVR2_EL1", "DBGBVR2_EL1", 0x8014, true, true,  {}  }, // 293
  { "DBGBVR3_EL1", "DBGBVR3_EL1", 0x801C, true, true,  {}  }, // 294
  { "DBGBVR4_EL1", "DBGBVR4_EL1", 0x8024, true, true,  {}  }, // 295
  { "DBGBVR5_EL1", "DBGBVR5_EL1", 0x802C, true, true,  {}  }, // 296
  { "DBGBVR6_EL1", "DBGBVR6_EL1", 0x8034, true, true,  {}  }, // 297
  { "DBGBVR7_EL1", "DBGBVR7_EL1", 0x803C, true, true,  {}  }, // 298
  { "DBGBVR8_EL1", "DBGBVR8_EL1", 0x8044, true, true,  {}  }, // 299
  { "DBGBVR9_EL1", "DBGBVR9_EL1", 0x804C, true, true,  {}  }, // 300
  { "DBGCLAIMCLR_EL1", "DBGCLAIMCLR_EL1", 0x83CE, true, true,  {}  }, // 301
  { "DBGCLAIMSET_EL1", "DBGCLAIMSET_EL1", 0x83C6, true, true,  {}  }, // 302
  { "DBGDTRRX_EL0", "DBGDTRRX_EL0", 0x9828, true, false,  {}  }, // 303
  { "DBGDTRTX_EL0", "DBGDTRTX_EL0", 0x9828, false, true,  {}  }, // 304
  { "DBGDTR_EL0", "DBGDTR_EL0", 0x9820, true, true,  {}  }, // 305
  { "DBGPRCR_EL1", "DBGPRCR_EL1", 0x80A4, true, true,  {}  }, // 306
  { "DBGVCR32_EL2", "DBGVCR32_EL2", 0xA038, true, true,  {}  }, // 307
  { "DBGWCR0_EL1", "DBGWCR0_EL1", 0x8007, true, true,  {}  }, // 308
  { "DBGWCR10_EL1", "DBGWCR10_EL1", 0x8057, true, true,  {}  }, // 309
  { "DBGWCR11_EL1", "DBGWCR11_EL1", 0x805F, true, true,  {}  }, // 310
  { "DBGWCR12_EL1", "DBGWCR12_EL1", 0x8067, true, true,  {}  }, // 311
  { "DBGWCR13_EL1", "DBGWCR13_EL1", 0x806F, true, true,  {}  }, // 312
  { "DBGWCR14_EL1", "DBGWCR14_EL1", 0x8077, true, true,  {}  }, // 313
  { "DBGWCR15_EL1", "DBGWCR15_EL1", 0x807F, true, true,  {}  }, // 314
  { "DBGWCR1_EL1", "DBGWCR1_EL1", 0x800F, true, true,  {}  }, // 315
  { "DBGWCR2_EL1", "DBGWCR2_EL1", 0x8017, true, true,  {}  }, // 316
  { "DBGWCR3_EL1", "DBGWCR3_EL1", 0x801F, true, true,  {}  }, // 317
  { "DBGWCR4_EL1", "DBGWCR4_EL1", 0x8027, true, true,  {}  }, // 318
  { "DBGWCR5_EL1", "DBGWCR5_EL1", 0x802F, true, true,  {}  }, // 319
  { "DBGWCR6_EL1", "DBGWCR6_EL1", 0x8037, true, true,  {}  }, // 320
  { "DBGWCR7_EL1", "DBGWCR7_EL1", 0x803F, true, true,  {}  }, // 321
  { "DBGWCR8_EL1", "DBGWCR8_EL1", 0x8047, true, true,  {}  }, // 322
  { "DBGWCR9_EL1", "DBGWCR9_EL1", 0x804F, true, true,  {}  }, // 323
  { "DBGWVR0_EL1", "DBGWVR0_EL1", 0x8006, true, true,  {}  }, // 324
  { "DBGWVR10_EL1", "DBGWVR10_EL1", 0x8056, true, true,  {}  }, // 325
  { "DBGWVR11_EL1", "DBGWVR11_EL1", 0x805E, true, true,  {}  }, // 326
  { "DBGWVR12_EL1", "DBGWVR12_EL1", 0x8066, true, true,  {}  }, // 327
  { "DBGWVR13_EL1", "DBGWVR13_EL1", 0x806E, true, true,  {}  }, // 328
  { "DBGWVR14_EL1", "DBGWVR14_EL1", 0x8076, true, true,  {}  }, // 329
  { "DBGWVR15_EL1", "DBGWVR15_EL1", 0x807E, true, true,  {}  }, // 330
  { "DBGWVR1_EL1", "DBGWVR1_EL1", 0x800E, true, true,  {}  }, // 331
  { "DBGWVR2_EL1", "DBGWVR2_EL1", 0x8016, true, true,  {}  }, // 332
  { "DBGWVR3_EL1", "DBGWVR3_EL1", 0x801E, true, true,  {}  }, // 333
  { "DBGWVR4_EL1", "DBGWVR4_EL1", 0x8026, true, true,  {}  }, // 334
  { "DBGWVR5_EL1", "DBGWVR5_EL1", 0x802E, true, true,  {}  }, // 335
  { "DBGWVR6_EL1", "DBGWVR6_EL1", 0x8036, true, true,  {}  }, // 336
  { "DBGWVR7_EL1", "DBGWVR7_EL1", 0x803E, true, true,  {}  }, // 337
  { "DBGWVR8_EL1", "DBGWVR8_EL1", 0x8046, true, true,  {}  }, // 338
  { "DBGWVR9_EL1", "DBGWVR9_EL1", 0x804E, true, true,  {}  }, // 339
  { "DCZID_EL0", "DCZID_EL0", 0xD807, true, false,  {}  }, // 340
  { "DISR_EL1", "DISR_EL1", 0xC609, true, true,  {AArch64::FeatureRAS}  }, // 341
  { "DIT", "DIT", 0xDA15, true, true,  {AArch64::FeatureDIT}  }, // 342
  { "DLR_EL0", "DLR_EL0", 0xDA29, true, true,  {}  }, // 343
  { "DSPSR_EL0", "DSPSR_EL0", 0xDA28, true, true,  {}  }, // 344
  { "ELR_EL1", "ELR_EL1", 0xC201, true, true,  {}  }, // 345
  { "ELR_EL12", "ELR_EL12", 0xEA01, true, true,  {AArch64::FeatureVH}  }, // 346
  { "ELR_EL2", "ELR_EL2", 0xE201, true, true,  {}  }, // 347
  { "ELR_EL3", "ELR_EL3", 0xF201, true, true,  {}  }, // 348
  { "ERRIDR_EL1", "ERRIDR_EL1", 0xC298, true, false,  {AArch64::FeatureRAS}  }, // 349
  { "ERRSELR_EL1", "ERRSELR_EL1", 0xC299, true, true,  {AArch64::FeatureRAS}  }, // 350
  { "ERXADDR_EL1", "ERXADDR_EL1", 0xC2A3, true, true,  {AArch64::FeatureRAS}  }, // 351
  { "ERXCTLR_EL1", "ERXCTLR_EL1", 0xC2A1, true, true,  {AArch64::FeatureRAS}  }, // 352
  { "ERXFR_EL1", "ERXFR_EL1", 0xC2A0, true, false,  {AArch64::FeatureRAS}  }, // 353
  { "ERXMISC0_EL1", "ERXMISC0_EL1", 0xC2A8, true, true,  {AArch64::FeatureRAS}  }, // 354
  { "ERXMISC1_EL1", "ERXMISC1_EL1", 0xC2A9, true, true,  {AArch64::FeatureRAS}  }, // 355
  { "ERXMISC2_EL1", "ERXMISC2_EL1", 0xC2AA, true, true,  {}  }, // 356
  { "ERXMISC3_EL1", "ERXMISC3_EL1", 0xC2AB, true, true,  {}  }, // 357
  { "ERXPFGCDN_EL1", "ERXPFGCDN_EL1", 0xC2A6, true, true,  {}  }, // 358
  { "ERXPFGCTL_EL1", "ERXPFGCTL_EL1", 0xC2A5, true, true,  {}  }, // 359
  { "ERXPFGF_EL1", "ERXPFGF_EL1", 0xC2A4, true, false,  {}  }, // 360
  { "ERXSTATUS_EL1", "ERXSTATUS_EL1", 0xC2A2, true, true,  {AArch64::FeatureRAS}  }, // 361
  { "ESR_EL1", "ESR_EL1", 0xC290, true, true,  {}  }, // 362
  { "ESR_EL12", "ESR_EL12", 0xEA90, true, true,  {AArch64::FeatureVH}  }, // 363
  { "ESR_EL2", "ESR_EL2", 0xE290, true, true,  {}  }, // 364
  { "ESR_EL3", "ESR_EL3", 0xF290, true, true,  {}  }, // 365
  { "FAR_EL1", "FAR_EL1", 0xC300, true, true,  {}  }, // 366
  { "FAR_EL12", "FAR_EL12", 0xEB00, true, true,  {AArch64::FeatureVH}  }, // 367
  { "FAR_EL2", "FAR_EL2", 0xE300, true, true,  {}  }, // 368
  { "FAR_EL3", "FAR_EL3", 0xF300, true, true,  {}  }, // 369
  { "FPCR", "FPCR", 0xDA20, true, true,  {}  }, // 370
  { "FPEXC32_EL2", "FPEXC32_EL2", 0xE298, true, true,  {}  }, // 371
  { "FPSR", "FPSR", 0xDA21, true, true,  {}  }, // 372
  { "GCR_EL1", "GCR_EL1", 0xC086, true, true,  {AArch64::FeatureMTE}  }, // 373
  { "GMID_EL1", "GMID_EL1", 0xC804, true, false,  {AArch64::FeatureMTE}  }, // 374
  { "GPCCR_EL3", "GPCCR_EL3", 0xF10E, true, true,  {AArch64::FeatureRME}  }, // 375
  { "GPTBR_EL3", "GPTBR_EL3", 0xF10C, true, true,  {AArch64::FeatureRME}  }, // 376
  { "HACR_EL2", "HACR_EL2", 0xE08F, true, true,  {}  }, // 377
  { "HCRX_EL2", "HCRX_EL2", 0xE092, true, true,  {AArch64::FeatureHCX}  }, // 378
  { "HCR_EL2", "HCR_EL2", 0xE088, true, true,  {}  }, // 379
  { "HDFGRTR_EL2", "HDFGRTR_EL2", 0xE18C, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 380
  { "HDFGWTR_EL2", "HDFGWTR_EL2", 0xE18D, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 381
  { "HFGITR_EL2", "HFGITR_EL2", 0xE08E, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 382
  { "HFGRTR_EL2", "HFGRTR_EL2", 0xE08C, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 383
  { "HFGWTR_EL2", "HFGWTR_EL2", 0xE08D, true, true,  {AArch64::FeatureFineGrainedTraps}  }, // 384
  { "HPFAR_EL2", "HPFAR_EL2", 0xE304, true, true,  {}  }, // 385
  { "HSTR_EL2", "HSTR_EL2", 0xE08B, true, true,  {}  }, // 386
  { "ICC_AP0R0_EL1", "ICC_AP0R0_EL1", 0xC644, true, true,  {}  }, // 387
  { "ICC_AP0R1_EL1", "ICC_AP0R1_EL1", 0xC645, true, true,  {}  }, // 388
  { "ICC_AP0R2_EL1", "ICC_AP0R2_EL1", 0xC646, true, true,  {}  }, // 389
  { "ICC_AP0R3_EL1", "ICC_AP0R3_EL1", 0xC647, true, true,  {}  }, // 390
  { "ICC_AP1R0_EL1", "ICC_AP1R0_EL1", 0xC648, true, true,  {}  }, // 391
  { "ICC_AP1R1_EL1", "ICC_AP1R1_EL1", 0xC649, true, true,  {}  }, // 392
  { "ICC_AP1R2_EL1", "ICC_AP1R2_EL1", 0xC64A, true, true,  {}  }, // 393
  { "ICC_AP1R3_EL1", "ICC_AP1R3_EL1", 0xC64B, true, true,  {}  }, // 394
  { "ICC_ASGI1R_EL1", "ICC_ASGI1R_EL1", 0xC65E, false, true,  {}  }, // 395
  { "ICC_BPR0_EL1", "ICC_BPR0_EL1", 0xC643, true, true,  {}  }, // 396
  { "ICC_BPR1_EL1", "ICC_BPR1_EL1", 0xC663, true, true,  {}  }, // 397
  { "ICC_CTLR_EL1", "ICC_CTLR_EL1", 0xC664, true, true,  {}  }, // 398
  { "ICC_CTLR_EL3", "ICC_CTLR_EL3", 0xF664, true, true,  {}  }, // 399
  { "ICC_DIR_EL1", "ICC_DIR_EL1", 0xC659, false, true,  {}  }, // 400
  { "ICC_EOIR0_EL1", "ICC_EOIR0_EL1", 0xC641, false, true,  {}  }, // 401
  { "ICC_EOIR1_EL1", "ICC_EOIR1_EL1", 0xC661, false, true,  {}  }, // 402
  { "ICC_HPPIR0_EL1", "ICC_HPPIR0_EL1", 0xC642, true, false,  {}  }, // 403
  { "ICC_HPPIR1_EL1", "ICC_HPPIR1_EL1", 0xC662, true, false,  {}  }, // 404
  { "ICC_IAR0_EL1", "ICC_IAR0_EL1", 0xC640, true, false,  {}  }, // 405
  { "ICC_IAR1_EL1", "ICC_IAR1_EL1", 0xC660, true, false,  {}  }, // 406
  { "ICC_IGRPEN0_EL1", "ICC_IGRPEN0_EL1", 0xC666, true, true,  {}  }, // 407
  { "ICC_IGRPEN1_EL1", "ICC_IGRPEN1_EL1", 0xC667, true, true,  {}  }, // 408
  { "ICC_IGRPEN1_EL3", "ICC_IGRPEN1_EL3", 0xF667, true, true,  {}  }, // 409
  { "ICC_PMR_EL1", "ICC_PMR_EL1", 0xC230, true, true,  {}  }, // 410
  { "ICC_RPR_EL1", "ICC_RPR_EL1", 0xC65B, true, false,  {}  }, // 411
  { "ICC_SGI0R_EL1", "ICC_SGI0R_EL1", 0xC65F, false, true,  {}  }, // 412
  { "ICC_SGI1R_EL1", "ICC_SGI1R_EL1", 0xC65D, false, true,  {}  }, // 413
  { "ICC_SRE_EL1", "ICC_SRE_EL1", 0xC665, true, true,  {}  }, // 414
  { "ICC_SRE_EL2", "ICC_SRE_EL2", 0xE64D, true, true,  {}  }, // 415
  { "ICC_SRE_EL3", "ICC_SRE_EL3", 0xF665, true, true,  {}  }, // 416
  { "ICH_AP0R0_EL2", "ICH_AP0R0_EL2", 0xE640, true, true,  {}  }, // 417
  { "ICH_AP0R1_EL2", "ICH_AP0R1_EL2", 0xE641, true, true,  {}  }, // 418
  { "ICH_AP0R2_EL2", "ICH_AP0R2_EL2", 0xE642, true, true,  {}  }, // 419
  { "ICH_AP0R3_EL2", "ICH_AP0R3_EL2", 0xE643, true, true,  {}  }, // 420
  { "ICH_AP1R0_EL2", "ICH_AP1R0_EL2", 0xE648, true, true,  {}  }, // 421
  { "ICH_AP1R1_EL2", "ICH_AP1R1_EL2", 0xE649, true, true,  {}  }, // 422
  { "ICH_AP1R2_EL2", "ICH_AP1R2_EL2", 0xE64A, true, true,  {}  }, // 423
  { "ICH_AP1R3_EL2", "ICH_AP1R3_EL2", 0xE64B, true, true,  {}  }, // 424
  { "ICH_EISR_EL2", "ICH_EISR_EL2", 0xE65B, true, false,  {}  }, // 425
  { "ICH_ELRSR_EL2", "ICH_ELRSR_EL2", 0xE65D, true, false,  {}  }, // 426
  { "ICH_HCR_EL2", "ICH_HCR_EL2", 0xE658, true, true,  {}  }, // 427
  { "ICH_LR0_EL2", "ICH_LR0_EL2", 0xE660, true, true,  {}  }, // 428
  { "ICH_LR10_EL2", "ICH_LR10_EL2", 0xE66A, true, true,  {}  }, // 429
  { "ICH_LR11_EL2", "ICH_LR11_EL2", 0xE66B, true, true,  {}  }, // 430
  { "ICH_LR12_EL2", "ICH_LR12_EL2", 0xE66C, true, true,  {}  }, // 431
  { "ICH_LR13_EL2", "ICH_LR13_EL2", 0xE66D, true, true,  {}  }, // 432
  { "ICH_LR14_EL2", "ICH_LR14_EL2", 0xE66E, true, true,  {}  }, // 433
  { "ICH_LR15_EL2", "ICH_LR15_EL2", 0xE66F, true, true,  {}  }, // 434
  { "ICH_LR1_EL2", "ICH_LR1_EL2", 0xE661, true, true,  {}  }, // 435
  { "ICH_LR2_EL2", "ICH_LR2_EL2", 0xE662, true, true,  {}  }, // 436
  { "ICH_LR3_EL2", "ICH_LR3_EL2", 0xE663, true, true,  {}  }, // 437
  { "ICH_LR4_EL2", "ICH_LR4_EL2", 0xE664, true, true,  {}  }, // 438
  { "ICH_LR5_EL2", "ICH_LR5_EL2", 0xE665, true, true,  {}  }, // 439
  { "ICH_LR6_EL2", "ICH_LR6_EL2", 0xE666, true, true,  {}  }, // 440
  { "ICH_LR7_EL2", "ICH_LR7_EL2", 0xE667, true, true,  {}  }, // 441
  { "ICH_LR8_EL2", "ICH_LR8_EL2", 0xE668, true, true,  {}  }, // 442
  { "ICH_LR9_EL2", "ICH_LR9_EL2", 0xE669, true, true,  {}  }, // 443
  { "ICH_MISR_EL2", "ICH_MISR_EL2", 0xE65A, true, false,  {}  }, // 444
  { "ICH_VMCR_EL2", "ICH_VMCR_EL2", 0xE65F, true, true,  {}  }, // 445
  { "ICH_VTR_EL2", "ICH_VTR_EL2", 0xE659, true, false,  {}  }, // 446
  { "ID_AA64AFR0_EL1", "ID_AA64AFR0_EL1", 0xC02C, true, false,  {}  }, // 447
  { "ID_AA64AFR1_EL1", "ID_AA64AFR1_EL1", 0xC02D, true, false,  {}  }, // 448
  { "ID_AA64DFR0_EL1", "ID_AA64DFR0_EL1", 0xC028, true, false,  {}  }, // 449
  { "ID_AA64DFR1_EL1", "ID_AA64DFR1_EL1", 0xC029, true, false,  {}  }, // 450
  { "ID_AA64ISAR0_EL1", "ID_AA64ISAR0_EL1", 0xC030, true, false,  {}  }, // 451
  { "ID_AA64ISAR1_EL1", "ID_AA64ISAR1_EL1", 0xC031, true, false,  {}  }, // 452
  { "ID_AA64ISAR2_EL1", "ID_AA64ISAR2_EL1", 0xC032, true, false,  {}  }, // 453
  { "ID_AA64MMFR0_EL1", "ID_AA64MMFR0_EL1", 0xC038, true, false,  {}  }, // 454
  { "ID_AA64MMFR1_EL1", "ID_AA64MMFR1_EL1", 0xC039, true, false,  {}  }, // 455
  { "ID_AA64MMFR2_EL1", "ID_AA64MMFR2_EL1", 0xC03A, true, false,  {}  }, // 456
  { "ID_AA64PFR0_EL1", "ID_AA64PFR0_EL1", 0xC020, true, false,  {}  }, // 457
  { "ID_AA64PFR1_EL1", "ID_AA64PFR1_EL1", 0xC021, true, false,  {}  }, // 458
  { "ID_AA64SMFR0_EL1", "ID_AA64SMFR0_EL1", 0xC025, true, false,  {AArch64::FeatureSME}  }, // 459
  { "ID_AA64ZFR0_EL1", "ID_AA64ZFR0_EL1", 0xC024, true, false,  {AArch64::FeatureSVE}  }, // 460
  { "ID_AFR0_EL1", "ID_AFR0_EL1", 0xC00B, true, false,  {}  }, // 461
  { "ID_DFR0_EL1", "ID_DFR0_EL1", 0xC00A, true, false,  {}  }, // 462
  { "ID_ISAR0_EL1", "ID_ISAR0_EL1", 0xC010, true, false,  {}  }, // 463
  { "ID_ISAR1_EL1", "ID_ISAR1_EL1", 0xC011, true, false,  {}  }, // 464
  { "ID_ISAR2_EL1", "ID_ISAR2_EL1", 0xC012, true, false,  {}  }, // 465
  { "ID_ISAR3_EL1", "ID_ISAR3_EL1", 0xC013, true, false,  {}  }, // 466
  { "ID_ISAR4_EL1", "ID_ISAR4_EL1", 0xC014, true, false,  {}  }, // 467
  { "ID_ISAR5_EL1", "ID_ISAR5_EL1", 0xC015, true, false,  {}  }, // 468
  { "ID_ISAR6_EL1", "ID_ISAR6_EL1", 0xC017, true, false,  {AArch64::HasV8_2aOps}  }, // 469
  { "ID_MMFR0_EL1", "ID_MMFR0_EL1", 0xC00C, true, false,  {}  }, // 470
  { "ID_MMFR1_EL1", "ID_MMFR1_EL1", 0xC00D, true, false,  {}  }, // 471
  { "ID_MMFR2_EL1", "ID_MMFR2_EL1", 0xC00E, true, false,  {}  }, // 472
  { "ID_MMFR3_EL1", "ID_MMFR3_EL1", 0xC00F, true, false,  {}  }, // 473
  { "ID_MMFR4_EL1", "ID_MMFR4_EL1", 0xC016, true, false,  {}  }, // 474
  { "ID_MMFR5_EL1", "ID_MMFR5_EL1", 0xC01E, true, false,  {}  }, // 475
  { "ID_PFR0_EL1", "ID_PFR0_EL1", 0xC008, true, false,  {}  }, // 476
  { "ID_PFR1_EL1", "ID_PFR1_EL1", 0xC009, true, false,  {}  }, // 477
  { "ID_PFR2_EL1", "ID_PFR2_EL1", 0xC01C, true, false,  {AArch64::FeatureSpecRestrict}  }, // 478
  { "IFSR32_EL2", "IFSR32_EL2", 0xE281, true, true,  {}  }, // 479
  { "ISR_EL1", "ISR_EL1", 0xC608, true, false,  {}  }, // 480
  { "LORC_EL1", "LORC_EL1", 0xC523, true, true,  {AArch64::FeatureLOR}  }, // 481
  { "LOREA_EL1", "LOREA_EL1", 0xC521, true, true,  {AArch64::FeatureLOR}  }, // 482
  { "LORID_EL1", "LORID_EL1", 0xC527, true, false,  {AArch64::FeatureLOR}  }, // 483
  { "LORN_EL1", "LORN_EL1", 0xC522, true, true,  {AArch64::FeatureLOR}  }, // 484
  { "LORSA_EL1", "LORSA_EL1", 0xC520, true, true,  {AArch64::FeatureLOR}  }, // 485
  { "MAIR_EL1", "MAIR_EL1", 0xC510, true, true,  {}  }, // 486
  { "MAIR_EL12", "MAIR_EL12", 0xED10, true, true,  {AArch64::FeatureVH}  }, // 487
  { "MAIR_EL2", "MAIR_EL2", 0xE510, true, true,  {}  }, // 488
  { "MAIR_EL3", "MAIR_EL3", 0xF510, true, true,  {}  }, // 489
  { "MDCCINT_EL1", "MDCCINT_EL1", 0x8010, true, true,  {}  }, // 490
  { "MDCCSR_EL0", "MDCCSR_EL0", 0x9808, true, false,  {}  }, // 491
  { "MDCR_EL2", "MDCR_EL2", 0xE089, true, true,  {}  }, // 492
  { "MDCR_EL3", "MDCR_EL3", 0xF099, true, true,  {}  }, // 493
  { "MDRAR_EL1", "MDRAR_EL1", 0x8080, true, false,  {}  }, // 494
  { "MDSCR_EL1", "MDSCR_EL1", 0x8012, true, true,  {}  }, // 495
  { "MFAR_EL3", "MFAR_EL3", 0xF305, true, true,  {AArch64::FeatureRME}  }, // 496
  { "MIDR_EL1", "MIDR_EL1", 0xC000, true, false,  {}  }, // 497
  { "MPAM0_EL1", "MPAM0_EL1", 0xC529, true, true,  {AArch64::FeatureMPAM}  }, // 498
  { "MPAM1_EL1", "MPAM1_EL1", 0xC528, true, true,  {AArch64::FeatureMPAM}  }, // 499
  { "MPAM1_EL12", "MPAM1_EL12", 0xED28, true, true,  {AArch64::FeatureMPAM}  }, // 500
  { "MPAM2_EL2", "MPAM2_EL2", 0xE528, true, true,  {AArch64::FeatureMPAM}  }, // 501
  { "MPAM3_EL3", "MPAM3_EL3", 0xF528, true, true,  {AArch64::FeatureMPAM}  }, // 502
  { "MPAMHCR_EL2", "MPAMHCR_EL2", 0xE520, true, true,  {AArch64::FeatureMPAM}  }, // 503
  { "MPAMIDR_EL1", "MPAMIDR_EL1", 0xC524, true, false,  {AArch64::FeatureMPAM}  }, // 504
  { "MPAMSM_EL1", "MPAMSM_EL1", 0xC52B, true, true,  {AArch64::FeatureMPAM, AArch64::FeatureSME}  }, // 505
  { "MPAMVPM0_EL2", "MPAMVPM0_EL2", 0xE530, true, true,  {AArch64::FeatureMPAM}  }, // 506
  { "MPAMVPM1_EL2", "MPAMVPM1_EL2", 0xE531, true, true,  {AArch64::FeatureMPAM}  }, // 507
  { "MPAMVPM2_EL2", "MPAMVPM2_EL2", 0xE532, true, true,  {AArch64::FeatureMPAM}  }, // 508
  { "MPAMVPM3_EL2", "MPAMVPM3_EL2", 0xE533, true, true,  {AArch64::FeatureMPAM}  }, // 509
  { "MPAMVPM4_EL2", "MPAMVPM4_EL2", 0xE534, true, true,  {AArch64::FeatureMPAM}  }, // 510
  { "MPAMVPM5_EL2", "MPAMVPM5_EL2", 0xE535, true, true,  {AArch64::FeatureMPAM}  }, // 511
  { "MPAMVPM6_EL2", "MPAMVPM6_EL2", 0xE536, true, true,  {AArch64::FeatureMPAM}  }, // 512
  { "MPAMVPM7_EL2", "MPAMVPM7_EL2", 0xE537, true, true,  {AArch64::FeatureMPAM}  }, // 513
  { "MPAMVPMV_EL2", "MPAMVPMV_EL2", 0xE521, true, true,  {AArch64::FeatureMPAM}  }, // 514
  { "MPIDR_EL1", "MPIDR_EL1", 0xC005, true, false,  {}  }, // 515
  { "MPUIR_EL1", "MPUIR_EL1", 0xC004, true, true,  {AArch64::HasV8_0rOps}  }, // 516
  { "MPUIR_EL2", "MPUIR_EL2", 0xE004, true, true,  {AArch64::HasV8_0rOps}  }, // 517
  { "MVFR0_EL1", "MVFR0_EL1", 0xC018, true, false,  {}  }, // 518
  { "MVFR1_EL1", "MVFR1_EL1", 0xC019, true, false,  {}  }, // 519
  { "MVFR2_EL1", "MVFR2_EL1", 0xC01A, true, false,  {}  }, // 520
  { "NZCV", "NZCV", 0xDA10, true, true,  {}  }, // 521
  { "OSDLR_EL1", "OSDLR_EL1", 0x809C, true, true,  {}  }, // 522
  { "OSDTRRX_EL1", "OSDTRRX_EL1", 0x8002, true, true,  {}  }, // 523
  { "OSDTRTX_EL1", "OSDTRTX_EL1", 0x801A, true, true,  {}  }, // 524
  { "OSECCR_EL1", "OSECCR_EL1", 0x8032, true, true,  {}  }, // 525
  { "OSLAR_EL1", "OSLAR_EL1", 0x8084, false, true,  {}  }, // 526
  { "OSLSR_EL1", "OSLSR_EL1", 0x808C, true, false,  {}  }, // 527
  { "PAN", "PAN", 0xC213, true, true,  {AArch64::FeaturePAN}  }, // 528
  { "PAR_EL1", "PAR_EL1", 0xC3A0, true, true,  {}  }, // 529
  { "PMBIDR_EL1", "PMBIDR_EL1", 0xC4D7, true, false,  {AArch64::FeatureSPE}  }, // 530
  { "PMBLIMITR_EL1", "PMBLIMITR_EL1", 0xC4D0, true, true,  {AArch64::FeatureSPE}  }, // 531
  { "PMBPTR_EL1", "PMBPTR_EL1", 0xC4D1, true, true,  {AArch64::FeatureSPE}  }, // 532
  { "PMBSR_EL1", "PMBSR_EL1", 0xC4D3, true, true,  {AArch64::FeatureSPE}  }, // 533
  { "PMCCFILTR_EL0", "PMCCFILTR_EL0", 0xDF7F, true, true,  {}  }, // 534
  { "PMCCNTR_EL0", "PMCCNTR_EL0", 0xDCE8, true, true,  {}  }, // 535
  { "PMCEID0_EL0", "PMCEID0_EL0", 0xDCE6, true, false,  {}  }, // 536
  { "PMCEID1_EL0", "PMCEID1_EL0", 0xDCE7, true, false,  {}  }, // 537
  { "PMCNTENCLR_EL0", "PMCNTENCLR_EL0", 0xDCE2, true, true,  {}  }, // 538
  { "PMCNTENSET_EL0", "PMCNTENSET_EL0", 0xDCE1, true, true,  {}  }, // 539
  { "PMCR_EL0", "PMCR_EL0", 0xDCE0, true, true,  {}  }, // 540
  { "PMEVCNTR0_EL0", "PMEVCNTR0_EL0", 0xDF40, true, true,  {}  }, // 541
  { "PMEVCNTR10_EL0", "PMEVCNTR10_EL0", 0xDF4A, true, true,  {}  }, // 542
  { "PMEVCNTR11_EL0", "PMEVCNTR11_EL0", 0xDF4B, true, true,  {}  }, // 543
  { "PMEVCNTR12_EL0", "PMEVCNTR12_EL0", 0xDF4C, true, true,  {}  }, // 544
  { "PMEVCNTR13_EL0", "PMEVCNTR13_EL0", 0xDF4D, true, true,  {}  }, // 545
  { "PMEVCNTR14_EL0", "PMEVCNTR14_EL0", 0xDF4E, true, true,  {}  }, // 546
  { "PMEVCNTR15_EL0", "PMEVCNTR15_EL0", 0xDF4F, true, true,  {}  }, // 547
  { "PMEVCNTR16_EL0", "PMEVCNTR16_EL0", 0xDF50, true, true,  {}  }, // 548
  { "PMEVCNTR17_EL0", "PMEVCNTR17_EL0", 0xDF51, true, true,  {}  }, // 549
  { "PMEVCNTR18_EL0", "PMEVCNTR18_EL0", 0xDF52, true, true,  {}  }, // 550
  { "PMEVCNTR19_EL0", "PMEVCNTR19_EL0", 0xDF53, true, true,  {}  }, // 551
  { "PMEVCNTR1_EL0", "PMEVCNTR1_EL0", 0xDF41, true, true,  {}  }, // 552
  { "PMEVCNTR20_EL0", "PMEVCNTR20_EL0", 0xDF54, true, true,  {}  }, // 553
  { "PMEVCNTR21_EL0", "PMEVCNTR21_EL0", 0xDF55, true, true,  {}  }, // 554
  { "PMEVCNTR22_EL0", "PMEVCNTR22_EL0", 0xDF56, true, true,  {}  }, // 555
  { "PMEVCNTR23_EL0", "PMEVCNTR23_EL0", 0xDF57, true, true,  {}  }, // 556
  { "PMEVCNTR24_EL0", "PMEVCNTR24_EL0", 0xDF58, true, true,  {}  }, // 557
  { "PMEVCNTR25_EL0", "PMEVCNTR25_EL0", 0xDF59, true, true,  {}  }, // 558
  { "PMEVCNTR26_EL0", "PMEVCNTR26_EL0", 0xDF5A, true, true,  {}  }, // 559
  { "PMEVCNTR27_EL0", "PMEVCNTR27_EL0", 0xDF5B, true, true,  {}  }, // 560
  { "PMEVCNTR28_EL0", "PMEVCNTR28_EL0", 0xDF5C, true, true,  {}  }, // 561
  { "PMEVCNTR29_EL0", "PMEVCNTR29_EL0", 0xDF5D, true, true,  {}  }, // 562
  { "PMEVCNTR2_EL0", "PMEVCNTR2_EL0", 0xDF42, true, true,  {}  }, // 563
  { "PMEVCNTR30_EL0", "PMEVCNTR30_EL0", 0xDF5E, true, true,  {}  }, // 564
  { "PMEVCNTR3_EL0", "PMEVCNTR3_EL0", 0xDF43, true, true,  {}  }, // 565
  { "PMEVCNTR4_EL0", "PMEVCNTR4_EL0", 0xDF44, true, true,  {}  }, // 566
  { "PMEVCNTR5_EL0", "PMEVCNTR5_EL0", 0xDF45, true, true,  {}  }, // 567
  { "PMEVCNTR6_EL0", "PMEVCNTR6_EL0", 0xDF46, true, true,  {}  }, // 568
  { "PMEVCNTR7_EL0", "PMEVCNTR7_EL0", 0xDF47, true, true,  {}  }, // 569
  { "PMEVCNTR8_EL0", "PMEVCNTR8_EL0", 0xDF48, true, true,  {}  }, // 570
  { "PMEVCNTR9_EL0", "PMEVCNTR9_EL0", 0xDF49, true, true,  {}  }, // 571
  { "PMEVTYPER0_EL0", "PMEVTYPER0_EL0", 0xDF60, true, true,  {}  }, // 572
  { "PMEVTYPER10_EL0", "PMEVTYPER10_EL0", 0xDF6A, true, true,  {}  }, // 573
  { "PMEVTYPER11_EL0", "PMEVTYPER11_EL0", 0xDF6B, true, true,  {}  }, // 574
  { "PMEVTYPER12_EL0", "PMEVTYPER12_EL0", 0xDF6C, true, true,  {}  }, // 575
  { "PMEVTYPER13_EL0", "PMEVTYPER13_EL0", 0xDF6D, true, true,  {}  }, // 576
  { "PMEVTYPER14_EL0", "PMEVTYPER14_EL0", 0xDF6E, true, true,  {}  }, // 577
  { "PMEVTYPER15_EL0", "PMEVTYPER15_EL0", 0xDF6F, true, true,  {}  }, // 578
  { "PMEVTYPER16_EL0", "PMEVTYPER16_EL0", 0xDF70, true, true,  {}  }, // 579
  { "PMEVTYPER17_EL0", "PMEVTYPER17_EL0", 0xDF71, true, true,  {}  }, // 580
  { "PMEVTYPER18_EL0", "PMEVTYPER18_EL0", 0xDF72, true, true,  {}  }, // 581
  { "PMEVTYPER19_EL0", "PMEVTYPER19_EL0", 0xDF73, true, true,  {}  }, // 582
  { "PMEVTYPER1_EL0", "PMEVTYPER1_EL0", 0xDF61, true, true,  {}  }, // 583
  { "PMEVTYPER20_EL0", "PMEVTYPER20_EL0", 0xDF74, true, true,  {}  }, // 584
  { "PMEVTYPER21_EL0", "PMEVTYPER21_EL0", 0xDF75, true, true,  {}  }, // 585
  { "PMEVTYPER22_EL0", "PMEVTYPER22_EL0", 0xDF76, true, true,  {}  }, // 586
  { "PMEVTYPER23_EL0", "PMEVTYPER23_EL0", 0xDF77, true, true,  {}  }, // 587
  { "PMEVTYPER24_EL0", "PMEVTYPER24_EL0", 0xDF78, true, true,  {}  }, // 588
  { "PMEVTYPER25_EL0", "PMEVTYPER25_EL0", 0xDF79, true, true,  {}  }, // 589
  { "PMEVTYPER26_EL0", "PMEVTYPER26_EL0", 0xDF7A, true, true,  {}  }, // 590
  { "PMEVTYPER27_EL0", "PMEVTYPER27_EL0", 0xDF7B, true, true,  {}  }, // 591
  { "PMEVTYPER28_EL0", "PMEVTYPER28_EL0", 0xDF7C, true, true,  {}  }, // 592
  { "PMEVTYPER29_EL0", "PMEVTYPER29_EL0", 0xDF7D, true, true,  {}  }, // 593
  { "PMEVTYPER2_EL0", "PMEVTYPER2_EL0", 0xDF62, true, true,  {}  }, // 594
  { "PMEVTYPER30_EL0", "PMEVTYPER30_EL0", 0xDF7E, true, true,  {}  }, // 595
  { "PMEVTYPER3_EL0", "PMEVTYPER3_EL0", 0xDF63, true, true,  {}  }, // 596
  { "PMEVTYPER4_EL0", "PMEVTYPER4_EL0", 0xDF64, true, true,  {}  }, // 597
  { "PMEVTYPER5_EL0", "PMEVTYPER5_EL0", 0xDF65, true, true,  {}  }, // 598
  { "PMEVTYPER6_EL0", "PMEVTYPER6_EL0", 0xDF66, true, true,  {}  }, // 599
  { "PMEVTYPER7_EL0", "PMEVTYPER7_EL0", 0xDF67, true, true,  {}  }, // 600
  { "PMEVTYPER8_EL0", "PMEVTYPER8_EL0", 0xDF68, true, true,  {}  }, // 601
  { "PMEVTYPER9_EL0", "PMEVTYPER9_EL0", 0xDF69, true, true,  {}  }, // 602
  { "PMINTENCLR_EL1", "PMINTENCLR_EL1", 0xC4F2, true, true,  {}  }, // 603
  { "PMINTENSET_EL1", "PMINTENSET_EL1", 0xC4F1, true, true,  {}  }, // 604
  { "PMMIR_EL1", "PMMIR_EL1", 0xC4F6, true, false,  {}  }, // 605
  { "PMOVSCLR_EL0", "PMOVSCLR_EL0", 0xDCE3, true, true,  {}  }, // 606
  { "PMOVSSET_EL0", "PMOVSSET_EL0", 0xDCF3, true, true,  {}  }, // 607
  { "PMSCR_EL1", "PMSCR_EL1", 0xC4C8, true, true,  {AArch64::FeatureSPE}  }, // 608
  { "PMSCR_EL12", "PMSCR_EL12", 0xECC8, true, true,  {AArch64::FeatureSPE}  }, // 609
  { "PMSCR_EL2", "PMSCR_EL2", 0xE4C8, true, true,  {AArch64::FeatureSPE}  }, // 610
  { "PMSELR_EL0", "PMSELR_EL0", 0xDCE5, true, true,  {}  }, // 611
  { "PMSEVFR_EL1", "PMSEVFR_EL1", 0xC4CD, true, true,  {AArch64::FeatureSPE}  }, // 612
  { "PMSFCR_EL1", "PMSFCR_EL1", 0xC4CC, true, true,  {AArch64::FeatureSPE}  }, // 613
  { "PMSICR_EL1", "PMSICR_EL1", 0xC4CA, true, true,  {AArch64::FeatureSPE}  }, // 614
  { "PMSIDR_EL1", "PMSIDR_EL1", 0xC4CF, true, false,  {AArch64::FeatureSPE}  }, // 615
  { "PMSIRR_EL1", "PMSIRR_EL1", 0xC4CB, true, true,  {AArch64::FeatureSPE}  }, // 616
  { "PMSLATFR_EL1", "PMSLATFR_EL1", 0xC4CE, true, true,  {AArch64::FeatureSPE}  }, // 617
  { "PMSNEVFR_EL1", "PMSNEVFR_EL1", 0xC4C9, true, true,  {AArch64::FeatureSPE_EEF}  }, // 618
  { "PMSWINC_EL0", "PMSWINC_EL0", 0xDCE4, false, true,  {}  }, // 619
  { "PMUSERENR_EL0", "PMUSERENR_EL0", 0xDCF0, true, true,  {}  }, // 620
  { "PMXEVCNTR_EL0", "PMXEVCNTR_EL0", 0xDCEA, true, true,  {}  }, // 621
  { "PMXEVTYPER_EL0", "PMXEVTYPER_EL0", 0xDCE9, true, true,  {}  }, // 622
  { "PRBAR10_EL1", "PRBAR10_EL1", 0xC368, true, true,  {AArch64::HasV8_0rOps}  }, // 623
  { "PRBAR10_EL2", "PRBAR10_EL2", 0xE368, true, true,  {AArch64::HasV8_0rOps}  }, // 624
  { "PRBAR11_EL1", "PRBAR11_EL1", 0xC36C, true, true,  {AArch64::HasV8_0rOps}  }, // 625
  { "PRBAR11_EL2", "PRBAR11_EL2", 0xE36C, true, true,  {AArch64::HasV8_0rOps}  }, // 626
  { "PRBAR12_EL1", "PRBAR12_EL1", 0xC370, true, true,  {AArch64::HasV8_0rOps}  }, // 627
  { "PRBAR12_EL2", "PRBAR12_EL2", 0xE370, true, true,  {AArch64::HasV8_0rOps}  }, // 628
  { "PRBAR13_EL1", "PRBAR13_EL1", 0xC374, true, true,  {AArch64::HasV8_0rOps}  }, // 629
  { "PRBAR13_EL2", "PRBAR13_EL2", 0xE374, true, true,  {AArch64::HasV8_0rOps}  }, // 630
  { "PRBAR14_EL1", "PRBAR14_EL1", 0xC378, true, true,  {AArch64::HasV8_0rOps}  }, // 631
  { "PRBAR14_EL2", "PRBAR14_EL2", 0xE378, true, true,  {AArch64::HasV8_0rOps}  }, // 632
  { "PRBAR15_EL1", "PRBAR15_EL1", 0xC37C, true, true,  {AArch64::HasV8_0rOps}  }, // 633
  { "PRBAR15_EL2", "PRBAR15_EL2", 0xE37C, true, true,  {AArch64::HasV8_0rOps}  }, // 634
  { "PRBAR1_EL1", "PRBAR1_EL1", 0xC344, true, true,  {AArch64::HasV8_0rOps}  }, // 635
  { "PRBAR1_EL2", "PRBAR1_EL2", 0xE344, true, true,  {AArch64::HasV8_0rOps}  }, // 636
  { "PRBAR2_EL1", "PRBAR2_EL1", 0xC348, true, true,  {AArch64::HasV8_0rOps}  }, // 637
  { "PRBAR2_EL2", "PRBAR2_EL2", 0xE348, true, true,  {AArch64::HasV8_0rOps}  }, // 638
  { "PRBAR3_EL1", "PRBAR3_EL1", 0xC34C, true, true,  {AArch64::HasV8_0rOps}  }, // 639
  { "PRBAR3_EL2", "PRBAR3_EL2", 0xE34C, true, true,  {AArch64::HasV8_0rOps}  }, // 640
  { "PRBAR4_EL1", "PRBAR4_EL1", 0xC350, true, true,  {AArch64::HasV8_0rOps}  }, // 641
  { "PRBAR4_EL2", "PRBAR4_EL2", 0xE350, true, true,  {AArch64::HasV8_0rOps}  }, // 642
  { "PRBAR5_EL1", "PRBAR5_EL1", 0xC354, true, true,  {AArch64::HasV8_0rOps}  }, // 643
  { "PRBAR5_EL2", "PRBAR5_EL2", 0xE354, true, true,  {AArch64::HasV8_0rOps}  }, // 644
  { "PRBAR6_EL1", "PRBAR6_EL1", 0xC358, true, true,  {AArch64::HasV8_0rOps}  }, // 645
  { "PRBAR6_EL2", "PRBAR6_EL2", 0xE358, true, true,  {AArch64::HasV8_0rOps}  }, // 646
  { "PRBAR7_EL1", "PRBAR7_EL1", 0xC35C, true, true,  {AArch64::HasV8_0rOps}  }, // 647
  { "PRBAR7_EL2", "PRBAR7_EL2", 0xE35C, true, true,  {AArch64::HasV8_0rOps}  }, // 648
  { "PRBAR8_EL1", "PRBAR8_EL1", 0xC360, true, true,  {AArch64::HasV8_0rOps}  }, // 649
  { "PRBAR8_EL2", "PRBAR8_EL2", 0xE360, true, true,  {AArch64::HasV8_0rOps}  }, // 650
  { "PRBAR9_EL1", "PRBAR9_EL1", 0xC364, true, true,  {AArch64::HasV8_0rOps}  }, // 651
  { "PRBAR9_EL2", "PRBAR9_EL2", 0xE364, true, true,  {AArch64::HasV8_0rOps}  }, // 652
  { "PRBAR_EL1", "PRBAR_EL1", 0xC340, true, true,  {AArch64::HasV8_0rOps}  }, // 653
  { "PRBAR_EL2", "PRBAR_EL2", 0xE340, true, true,  {AArch64::HasV8_0rOps}  }, // 654
  { "PRENR_EL1", "PRENR_EL1", 0xC309, true, true,  {AArch64::HasV8_0rOps}  }, // 655
  { "PRENR_EL2", "PRENR_EL2", 0xE309, true, true,  {AArch64::HasV8_0rOps}  }, // 656
  { "PRLAR10_EL1", "PRLAR10_EL1", 0xC369, true, true,  {AArch64::HasV8_0rOps}  }, // 657
  { "PRLAR10_EL2", "PRLAR10_EL2", 0xE369, true, true,  {AArch64::HasV8_0rOps}  }, // 658
  { "PRLAR11_EL1", "PRLAR11_EL1", 0xC36D, true, true,  {AArch64::HasV8_0rOps}  }, // 659
  { "PRLAR11_EL2", "PRLAR11_EL2", 0xE36D, true, true,  {AArch64::HasV8_0rOps}  }, // 660
  { "PRLAR12_EL1", "PRLAR12_EL1", 0xC371, true, true,  {AArch64::HasV8_0rOps}  }, // 661
  { "PRLAR12_EL2", "PRLAR12_EL2", 0xE371, true, true,  {AArch64::HasV8_0rOps}  }, // 662
  { "PRLAR13_EL1", "PRLAR13_EL1", 0xC375, true, true,  {AArch64::HasV8_0rOps}  }, // 663
  { "PRLAR13_EL2", "PRLAR13_EL2", 0xE375, true, true,  {AArch64::HasV8_0rOps}  }, // 664
  { "PRLAR14_EL1", "PRLAR14_EL1", 0xC379, true, true,  {AArch64::HasV8_0rOps}  }, // 665
  { "PRLAR14_EL2", "PRLAR14_EL2", 0xE379, true, true,  {AArch64::HasV8_0rOps}  }, // 666
  { "PRLAR15_EL1", "PRLAR15_EL1", 0xC37D, true, true,  {AArch64::HasV8_0rOps}  }, // 667
  { "PRLAR15_EL2", "PRLAR15_EL2", 0xE37D, true, true,  {AArch64::HasV8_0rOps}  }, // 668
  { "PRLAR1_EL1", "PRLAR1_EL1", 0xC345, true, true,  {AArch64::HasV8_0rOps}  }, // 669
  { "PRLAR1_EL2", "PRLAR1_EL2", 0xE345, true, true,  {AArch64::HasV8_0rOps}  }, // 670
  { "PRLAR2_EL1", "PRLAR2_EL1", 0xC349, true, true,  {AArch64::HasV8_0rOps}  }, // 671
  { "PRLAR2_EL2", "PRLAR2_EL2", 0xE349, true, true,  {AArch64::HasV8_0rOps}  }, // 672
  { "PRLAR3_EL1", "PRLAR3_EL1", 0xC34D, true, true,  {AArch64::HasV8_0rOps}  }, // 673
  { "PRLAR3_EL2", "PRLAR3_EL2", 0xE34D, true, true,  {AArch64::HasV8_0rOps}  }, // 674
  { "PRLAR4_EL1", "PRLAR4_EL1", 0xC351, true, true,  {AArch64::HasV8_0rOps}  }, // 675
  { "PRLAR4_EL2", "PRLAR4_EL2", 0xE351, true, true,  {AArch64::HasV8_0rOps}  }, // 676
  { "PRLAR5_EL1", "PRLAR5_EL1", 0xC355, true, true,  {AArch64::HasV8_0rOps}  }, // 677
  { "PRLAR5_EL2", "PRLAR5_EL2", 0xE355, true, true,  {AArch64::HasV8_0rOps}  }, // 678
  { "PRLAR6_EL1", "PRLAR6_EL1", 0xC359, true, true,  {AArch64::HasV8_0rOps}  }, // 679
  { "PRLAR6_EL2", "PRLAR6_EL2", 0xE359, true, true,  {AArch64::HasV8_0rOps}  }, // 680
  { "PRLAR7_EL1", "PRLAR7_EL1", 0xC35D, true, true,  {AArch64::HasV8_0rOps}  }, // 681
  { "PRLAR7_EL2", "PRLAR7_EL2", 0xE35D, true, true,  {AArch64::HasV8_0rOps}  }, // 682
  { "PRLAR8_EL1", "PRLAR8_EL1", 0xC361, true, true,  {AArch64::HasV8_0rOps}  }, // 683
  { "PRLAR8_EL2", "PRLAR8_EL2", 0xE361, true, true,  {AArch64::HasV8_0rOps}  }, // 684
  { "PRLAR9_EL1", "PRLAR9_EL1", 0xC365, true, true,  {AArch64::HasV8_0rOps}  }, // 685
  { "PRLAR9_EL2", "PRLAR9_EL2", 0xE365, true, true,  {AArch64::HasV8_0rOps}  }, // 686
  { "PRLAR_EL1", "PRLAR_EL1", 0xC341, true, true,  {AArch64::HasV8_0rOps}  }, // 687
  { "PRLAR_EL2", "PRLAR_EL2", 0xE341, true, true,  {AArch64::HasV8_0rOps}  }, // 688
  { "PRSELR_EL1", "PRSELR_EL1", 0xC311, true, true,  {AArch64::HasV8_0rOps}  }, // 689
  { "PRSELR_EL2", "PRSELR_EL2", 0xE311, true, true,  {AArch64::HasV8_0rOps}  }, // 690
  { "REVIDR_EL1", "REVIDR_EL1", 0xC006, true, false,  {}  }, // 691
  { "RGSR_EL1", "RGSR_EL1", 0xC085, true, true,  {AArch64::FeatureMTE}  }, // 692
  { "RMR_EL1", "RMR_EL1", 0xC602, true, true,  {}  }, // 693
  { "RMR_EL2", "RMR_EL2", 0xE602, true, true,  {}  }, // 694
  { "RMR_EL3", "RMR_EL3", 0xF602, true, true,  {}  }, // 695
  { "RNDR", "RNDR", 0xD920, true, false,  {AArch64::FeatureRandGen}  }, // 696
  { "RNDRRS", "RNDRRS", 0xD921, true, false,  {AArch64::FeatureRandGen}  }, // 697
  { "RVBAR_EL1", "RVBAR_EL1", 0xC601, true, false,  {}  }, // 698
  { "RVBAR_EL2", "RVBAR_EL2", 0xE601, true, false,  {}  }, // 699
  { "RVBAR_EL3", "RVBAR_EL3", 0xF601, true, false,  {}  }, // 700
  { "SCR_EL3", "SCR_EL3", 0xF088, true, true,  {}  }, // 701
  { "SCTLR_EL1", "SCTLR_EL1", 0xC080, true, true,  {}  }, // 702
  { "SCTLR_EL12", "SCTLR_EL12", 0xE880, true, true,  {AArch64::FeatureVH}  }, // 703
  { "SCTLR_EL2", "SCTLR_EL2", 0xE080, true, true,  {}  }, // 704
  { "SCTLR_EL3", "SCTLR_EL3", 0xF080, true, true,  {}  }, // 705
  { "SCXTNUM_EL0", "SCXTNUM_EL0", 0xDE87, true, true,  {AArch64::FeatureSpecRestrict}  }, // 706
  { "SCXTNUM_EL1", "SCXTNUM_EL1", 0xC687, true, true,  {AArch64::FeatureSpecRestrict}  }, // 707
  { "SCXTNUM_EL12", "SCXTNUM_EL12", 0xEE87, true, true,  {AArch64::FeatureSpecRestrict}  }, // 708
  { "SCXTNUM_EL2", "SCXTNUM_EL2", 0xE687, true, true,  {AArch64::FeatureSpecRestrict}  }, // 709
  { "SCXTNUM_EL3", "SCXTNUM_EL3", 0xF687, true, true,  {AArch64::FeatureSpecRestrict}  }, // 710
  { "SDER32_EL2", "SDER32_EL2", 0xE099, true, true,  {AArch64::FeatureSEL2}  }, // 711
  { "SDER32_EL3", "SDER32_EL3", 0xF089, true, true,  {}  }, // 712
  { "SMCR_EL1", "SMCR_EL1", 0xC096, true, true,  {AArch64::FeatureSME}  }, // 713
  { "SMCR_EL12", "SMCR_EL12", 0xE896, true, true,  {AArch64::FeatureSME}  }, // 714
  { "SMCR_EL2", "SMCR_EL2", 0xE096, true, true,  {AArch64::FeatureSME}  }, // 715
  { "SMCR_EL3", "SMCR_EL3", 0xF096, true, true,  {AArch64::FeatureSME}  }, // 716
  { "SMIDR_EL1", "SMIDR_EL1", 0xC806, true, false,  {AArch64::FeatureSME}  }, // 717
  { "SMPRIMAP_EL2", "SMPRIMAP_EL2", 0xE095, true, true,  {AArch64::FeatureSME}  }, // 718
  { "SMPRI_EL1", "SMPRI_EL1", 0xC094, true, true,  {AArch64::FeatureSME}  }, // 719
  { "SPSel", "SPSel", 0xC210, true, true,  {}  }, // 720
  { "SPSR_abt", "SPSR_abt", 0xE219, true, true,  {}  }, // 721
  { "SPSR_EL1", "SPSR_EL1", 0xC200, true, true,  {}  }, // 722
  { "SPSR_EL12", "SPSR_EL12", 0xEA00, true, true,  {AArch64::FeatureVH}  }, // 723
  { "SPSR_EL2", "SPSR_EL2", 0xE200, true, true,  {}  }, // 724
  { "SPSR_EL3", "SPSR_EL3", 0xF200, true, true,  {}  }, // 725
  { "SPSR_fiq", "SPSR_fiq", 0xE21B, true, true,  {}  }, // 726
  { "SPSR_irq", "SPSR_irq", 0xE218, true, true,  {}  }, // 727
  { "SPSR_und", "SPSR_und", 0xE21A, true, true,  {}  }, // 728
  { "SP_EL0", "SP_EL0", 0xC208, true, true,  {}  }, // 729
  { "SP_EL1", "SP_EL1", 0xE208, true, true,  {}  }, // 730
  { "SP_EL2", "SP_EL2", 0xF208, true, true,  {}  }, // 731
  { "SSBS", "SSBS", 0xDA16, true, true,  {AArch64::FeatureSSBS}  }, // 732
  { "SVCR", "SVCR", 0xDA12, true, true,  {AArch64::FeatureSME}  }, // 733
  { "TCO", "TCO", 0xDA17, true, true,  {AArch64::FeatureMTE}  }, // 734
  { "TCR_EL1", "TCR_EL1", 0xC102, true, true,  {}  }, // 735
  { "TCR_EL12", "TCR_EL12", 0xE902, true, true,  {AArch64::FeatureVH}  }, // 736
  { "TCR_EL2", "TCR_EL2", 0xE102, true, true,  {}  }, // 737
  { "TCR_EL3", "TCR_EL3", 0xF102, true, true,  {}  }, // 738
  { "TEECR32_EL1", "TEECR32_EL1", 0x9000, true, true,  {}  }, // 739
  { "TEEHBR32_EL1", "TEEHBR32_EL1", 0x9080, true, true,  {}  }, // 740
  { "TFSRE0_EL1", "TFSRE0_EL1", 0xC2B1, true, true,  {AArch64::FeatureMTE}  }, // 741
  { "TFSR_EL1", "TFSR_EL1", 0xC2B0, true, true,  {AArch64::FeatureMTE}  }, // 742
  { "TFSR_EL12", "TFSR_EL12", 0xEAB0, true, true,  {AArch64::FeatureMTE}  }, // 743
  { "TFSR_EL2", "TFSR_EL2", 0xE2B0, true, true,  {AArch64::FeatureMTE}  }, // 744
  { "TFSR_EL3", "TFSR_EL3", 0xF2B0, true, true,  {AArch64::FeatureMTE}  }, // 745
  { "TPIDR2_EL0", "TPIDR2_EL0", 0xDE85, true, true,  {AArch64::FeatureSME}  }, // 746
  { "TPIDRRO_EL0", "TPIDRRO_EL0", 0xDE83, true, true,  {}  }, // 747
  { "TPIDR_EL0", "TPIDR_EL0", 0xDE82, true, true,  {}  }, // 748
  { "TPIDR_EL1", "TPIDR_EL1", 0xC684, true, true,  {}  }, // 749
  { "TPIDR_EL2", "TPIDR_EL2", 0xE682, true, true,  {}  }, // 750
  { "TPIDR_EL3", "TPIDR_EL3", 0xF682, true, true,  {}  }, // 751
  { "TRBBASER_EL1", "TRBBASER_EL1", 0xC4DA, true, true,  {AArch64::FeatureTRBE}  }, // 752
  { "TRBIDR_EL1", "TRBIDR_EL1", 0xC4DF, true, false,  {AArch64::FeatureTRBE}  }, // 753
  { "TRBLIMITR_EL1", "TRBLIMITR_EL1", 0xC4D8, true, true,  {AArch64::FeatureTRBE}  }, // 754
  { "TRBMAR_EL1", "TRBMAR_EL1", 0xC4DC, true, true,  {AArch64::FeatureTRBE}  }, // 755
  { "TRBPTR_EL1", "TRBPTR_EL1", 0xC4D9, true, true,  {AArch64::FeatureTRBE}  }, // 756
  { "TRBSR_EL1", "TRBSR_EL1", 0xC4DB, true, true,  {AArch64::FeatureTRBE}  }, // 757
  { "TRBTRG_EL1", "TRBTRG_EL1", 0xC4DE, true, true,  {AArch64::FeatureTRBE}  }, // 758
  { "TRCACATR0", "TRCACATR0", 0x8902, true, true,  {}  }, // 759
  { "TRCACATR1", "TRCACATR1", 0x8912, true, true,  {}  }, // 760
  { "TRCACATR10", "TRCACATR10", 0x8923, true, true,  {}  }, // 761
  { "TRCACATR11", "TRCACATR11", 0x8933, true, true,  {}  }, // 762
  { "TRCACATR12", "TRCACATR12", 0x8943, true, true,  {}  }, // 763
  { "TRCACATR13", "TRCACATR13", 0x8953, true, true,  {}  }, // 764
  { "TRCACATR14", "TRCACATR14", 0x8963, true, true,  {}  }, // 765
  { "TRCACATR15", "TRCACATR15", 0x8973, true, true,  {}  }, // 766
  { "TRCACATR2", "TRCACATR2", 0x8922, true, true,  {}  }, // 767
  { "TRCACATR3", "TRCACATR3", 0x8932, true, true,  {}  }, // 768
  { "TRCACATR4", "TRCACATR4", 0x8942, true, true,  {}  }, // 769
  { "TRCACATR5", "TRCACATR5", 0x8952, true, true,  {}  }, // 770
  { "TRCACATR6", "TRCACATR6", 0x8962, true, true,  {}  }, // 771
  { "TRCACATR7", "TRCACATR7", 0x8972, true, true,  {}  }, // 772
  { "TRCACATR8", "TRCACATR8", 0x8903, true, true,  {}  }, // 773
  { "TRCACATR9", "TRCACATR9", 0x8913, true, true,  {}  }, // 774
  { "TRCACVR0", "TRCACVR0", 0x8900, true, true,  {}  }, // 775
  { "TRCACVR1", "TRCACVR1", 0x8910, true, true,  {}  }, // 776
  { "TRCACVR10", "TRCACVR10", 0x8921, true, true,  {}  }, // 777
  { "TRCACVR11", "TRCACVR11", 0x8931, true, true,  {}  }, // 778
  { "TRCACVR12", "TRCACVR12", 0x8941, true, true,  {}  }, // 779
  { "TRCACVR13", "TRCACVR13", 0x8951, true, true,  {}  }, // 780
  { "TRCACVR14", "TRCACVR14", 0x8961, true, true,  {}  }, // 781
  { "TRCACVR15", "TRCACVR15", 0x8971, true, true,  {}  }, // 782
  { "TRCACVR2", "TRCACVR2", 0x8920, true, true,  {}  }, // 783
  { "TRCACVR3", "TRCACVR3", 0x8930, true, true,  {}  }, // 784
  { "TRCACVR4", "TRCACVR4", 0x8940, true, true,  {}  }, // 785
  { "TRCACVR5", "TRCACVR5", 0x8950, true, true,  {}  }, // 786
  { "TRCACVR6", "TRCACVR6", 0x8960, true, true,  {}  }, // 787
  { "TRCACVR7", "TRCACVR7", 0x8970, true, true,  {}  }, // 788
  { "TRCACVR8", "TRCACVR8", 0x8901, true, true,  {}  }, // 789
  { "TRCACVR9", "TRCACVR9", 0x8911, true, true,  {}  }, // 790
  { "TRCAUTHSTATUS", "TRCAUTHSTATUS", 0x8BF6, true, false,  {}  }, // 791
  { "TRCAUXCTLR", "TRCAUXCTLR", 0x8830, true, true,  {}  }, // 792
  { "TRCBBCTLR", "TRCBBCTLR", 0x8878, true, true,  {}  }, // 793
  { "TRCCCCTLR", "TRCCCCTLR", 0x8870, true, true,  {}  }, // 794
  { "TRCCIDCCTLR0", "TRCCIDCCTLR0", 0x8982, true, true,  {}  }, // 795
  { "TRCCIDCCTLR1", "TRCCIDCCTLR1", 0x898A, true, true,  {}  }, // 796
  { "TRCCIDCVR0", "TRCCIDCVR0", 0x8980, true, true,  {}  }, // 797
  { "TRCCIDCVR1", "TRCCIDCVR1", 0x8990, true, true,  {}  }, // 798
  { "TRCCIDCVR2", "TRCCIDCVR2", 0x89A0, true, true,  {}  }, // 799
  { "TRCCIDCVR3", "TRCCIDCVR3", 0x89B0, true, true,  {}  }, // 800
  { "TRCCIDCVR4", "TRCCIDCVR4", 0x89C0, true, true,  {}  }, // 801
  { "TRCCIDCVR5", "TRCCIDCVR5", 0x89D0, true, true,  {}  }, // 802
  { "TRCCIDCVR6", "TRCCIDCVR6", 0x89E0, true, true,  {}  }, // 803
  { "TRCCIDCVR7", "TRCCIDCVR7", 0x89F0, true, true,  {}  }, // 804
  { "TRCCIDR0", "TRCCIDR0", 0x8BE7, true, false,  {}  }, // 805
  { "TRCCIDR1", "TRCCIDR1", 0x8BEF, true, false,  {}  }, // 806
  { "TRCCIDR2", "TRCCIDR2", 0x8BF7, true, false,  {}  }, // 807
  { "TRCCIDR3", "TRCCIDR3", 0x8BFF, true, false,  {}  }, // 808
  { "TRCCLAIMCLR", "TRCCLAIMCLR", 0x8BCE, true, true,  {}  }, // 809
  { "TRCCLAIMSET", "TRCCLAIMSET", 0x8BC6, true, true,  {}  }, // 810
  { "TRCCNTCTLR0", "TRCCNTCTLR0", 0x8825, true, true,  {}  }, // 811
  { "TRCCNTCTLR1", "TRCCNTCTLR1", 0x882D, true, true,  {}  }, // 812
  { "TRCCNTCTLR2", "TRCCNTCTLR2", 0x8835, true, true,  {}  }, // 813
  { "TRCCNTCTLR3", "TRCCNTCTLR3", 0x883D, true, true,  {}  }, // 814
  { "TRCCNTRLDVR0", "TRCCNTRLDVR0", 0x8805, true, true,  {}  }, // 815
  { "TRCCNTRLDVR1", "TRCCNTRLDVR1", 0x880D, true, true,  {}  }, // 816
  { "TRCCNTRLDVR2", "TRCCNTRLDVR2", 0x8815, true, true,  {}  }, // 817
  { "TRCCNTRLDVR3", "TRCCNTRLDVR3", 0x881D, true, true,  {}  }, // 818
  { "TRCCNTVR0", "TRCCNTVR0", 0x8845, true, true,  {}  }, // 819
  { "TRCCNTVR1", "TRCCNTVR1", 0x884D, true, true,  {}  }, // 820
  { "TRCCNTVR2", "TRCCNTVR2", 0x8855, true, true,  {}  }, // 821
  { "TRCCNTVR3", "TRCCNTVR3", 0x885D, true, true,  {}  }, // 822
  { "TRCCONFIGR", "TRCCONFIGR", 0x8820, true, true,  {}  }, // 823
  { "TRCDEVAFF0", "TRCDEVAFF0", 0x8BD6, true, false,  {}  }, // 824
  { "TRCDEVAFF1", "TRCDEVAFF1", 0x8BDE, true, false,  {}  }, // 825
  { "TRCDEVARCH", "TRCDEVARCH", 0x8BFE, true, false,  {}  }, // 826
  { "TRCDEVID", "TRCDEVID", 0x8B97, true, false,  {}  }, // 827
  { "TRCDEVTYPE", "TRCDEVTYPE", 0x8B9F, true, false,  {}  }, // 828
  { "TRCDVCMR0", "TRCDVCMR0", 0x8906, true, true,  {}  }, // 829
  { "TRCDVCMR1", "TRCDVCMR1", 0x8926, true, true,  {}  }, // 830
  { "TRCDVCMR2", "TRCDVCMR2", 0x8946, true, true,  {}  }, // 831
  { "TRCDVCMR3", "TRCDVCMR3", 0x8966, true, true,  {}  }, // 832
  { "TRCDVCMR4", "TRCDVCMR4", 0x8907, true, true,  {}  }, // 833
  { "TRCDVCMR5", "TRCDVCMR5", 0x8927, true, true,  {}  }, // 834
  { "TRCDVCMR6", "TRCDVCMR6", 0x8947, true, true,  {}  }, // 835
  { "TRCDVCMR7", "TRCDVCMR7", 0x8967, true, true,  {}  }, // 836
  { "TRCDVCVR0", "TRCDVCVR0", 0x8904, true, true,  {}  }, // 837
  { "TRCDVCVR1", "TRCDVCVR1", 0x8924, true, true,  {}  }, // 838
  { "TRCDVCVR2", "TRCDVCVR2", 0x8944, true, true,  {}  }, // 839
  { "TRCDVCVR3", "TRCDVCVR3", 0x8964, true, true,  {}  }, // 840
  { "TRCDVCVR4", "TRCDVCVR4", 0x8905, true, true,  {}  }, // 841
  { "TRCDVCVR5", "TRCDVCVR5", 0x8925, true, true,  {}  }, // 842
  { "TRCDVCVR6", "TRCDVCVR6", 0x8945, true, true,  {}  }, // 843
  { "TRCDVCVR7", "TRCDVCVR7", 0x8965, true, true,  {}  }, // 844
  { "TRCEVENTCTL0R", "TRCEVENTCTL0R", 0x8840, true, true,  {}  }, // 845
  { "TRCEVENTCTL1R", "TRCEVENTCTL1R", 0x8848, true, true,  {}  }, // 846
  { "TRCEXTINSELR", "TRCEXTINSELR", 0x8844, true, true,  {}  }, // 847
  { "TRCEXTINSELR0", "TRCEXTINSELR0", 0x8844, true, true,  {AArch64::FeatureETE}  }, // 848
  { "TRCEXTINSELR1", "TRCEXTINSELR1", 0x884C, true, true,  {AArch64::FeatureETE}  }, // 849
  { "TRCEXTINSELR2", "TRCEXTINSELR2", 0x8854, true, true,  {AArch64::FeatureETE}  }, // 850
  { "TRCEXTINSELR3", "TRCEXTINSELR3", 0x885C, true, true,  {AArch64::FeatureETE}  }, // 851
  { "TRCIDR0", "TRCIDR0", 0x8847, true, false,  {}  }, // 852
  { "TRCIDR1", "TRCIDR1", 0x884F, true, false,  {}  }, // 853
  { "TRCIDR10", "TRCIDR10", 0x8816, true, false,  {}  }, // 854
  { "TRCIDR11", "TRCIDR11", 0x881E, true, false,  {}  }, // 855
  { "TRCIDR12", "TRCIDR12", 0x8826, true, false,  {}  }, // 856
  { "TRCIDR13", "TRCIDR13", 0x882E, true, false,  {}  }, // 857
  { "TRCIDR2", "TRCIDR2", 0x8857, true, false,  {}  }, // 858
  { "TRCIDR3", "TRCIDR3", 0x885F, true, false,  {}  }, // 859
  { "TRCIDR4", "TRCIDR4", 0x8867, true, false,  {}  }, // 860
  { "TRCIDR5", "TRCIDR5", 0x886F, true, false,  {}  }, // 861
  { "TRCIDR6", "TRCIDR6", 0x8877, true, false,  {}  }, // 862
  { "TRCIDR7", "TRCIDR7", 0x887F, true, false,  {}  }, // 863
  { "TRCIDR8", "TRCIDR8", 0x8806, true, false,  {}  }, // 864
  { "TRCIDR9", "TRCIDR9", 0x880E, true, false,  {}  }, // 865
  { "TRCIMSPEC0", "TRCIMSPEC0", 0x8807, true, true,  {}  }, // 866
  { "TRCIMSPEC1", "TRCIMSPEC1", 0x880F, true, true,  {}  }, // 867
  { "TRCIMSPEC2", "TRCIMSPEC2", 0x8817, true, true,  {}  }, // 868
  { "TRCIMSPEC3", "TRCIMSPEC3", 0x881F, true, true,  {}  }, // 869
  { "TRCIMSPEC4", "TRCIMSPEC4", 0x8827, true, true,  {}  }, // 870
  { "TRCIMSPEC5", "TRCIMSPEC5", 0x882F, true, true,  {}  }, // 871
  { "TRCIMSPEC6", "TRCIMSPEC6", 0x8837, true, true,  {}  }, // 872
  { "TRCIMSPEC7", "TRCIMSPEC7", 0x883F, true, true,  {}  }, // 873
  { "TRCITCTRL", "TRCITCTRL", 0x8B84, true, true,  {}  }, // 874
  { "TRCLAR", "TRCLAR", 0x8BE6, false, true,  {}  }, // 875
  { "TRCLSR", "TRCLSR", 0x8BEE, true, false,  {}  }, // 876
  { "TRCOSLAR", "TRCOSLAR", 0x8884, false, true,  {}  }, // 877
  { "TRCOSLSR", "TRCOSLSR", 0x888C, true, false,  {}  }, // 878
  { "TRCPDCR", "TRCPDCR", 0x88A4, true, true,  {}  }, // 879
  { "TRCPDSR", "TRCPDSR", 0x88AC, true, false,  {}  }, // 880
  { "TRCPIDR0", "TRCPIDR0", 0x8BC7, true, false,  {}  }, // 881
  { "TRCPIDR1", "TRCPIDR1", 0x8BCF, true, false,  {}  }, // 882
  { "TRCPIDR2", "TRCPIDR2", 0x8BD7, true, false,  {}  }, // 883
  { "TRCPIDR3", "TRCPIDR3", 0x8BDF, true, false,  {}  }, // 884
  { "TRCPIDR4", "TRCPIDR4", 0x8BA7, true, false,  {}  }, // 885
  { "TRCPIDR5", "TRCPIDR5", 0x8BAF, true, false,  {}  }, // 886
  { "TRCPIDR6", "TRCPIDR6", 0x8BB7, true, false,  {}  }, // 887
  { "TRCPIDR7", "TRCPIDR7", 0x8BBF, true, false,  {}  }, // 888
  { "TRCPRGCTLR", "TRCPRGCTLR", 0x8808, true, true,  {}  }, // 889
  { "TRCPROCSELR", "TRCPROCSELR", 0x8810, true, true,  {}  }, // 890
  { "TRCQCTLR", "TRCQCTLR", 0x8809, true, true,  {}  }, // 891
  { "TRCRSCTLR10", "TRCRSCTLR10", 0x88D0, true, true,  {}  }, // 892
  { "TRCRSCTLR11", "TRCRSCTLR11", 0x88D8, true, true,  {}  }, // 893
  { "TRCRSCTLR12", "TRCRSCTLR12", 0x88E0, true, true,  {}  }, // 894
  { "TRCRSCTLR13", "TRCRSCTLR13", 0x88E8, true, true,  {}  }, // 895
  { "TRCRSCTLR14", "TRCRSCTLR14", 0x88F0, true, true,  {}  }, // 896
  { "TRCRSCTLR15", "TRCRSCTLR15", 0x88F8, true, true,  {}  }, // 897
  { "TRCRSCTLR16", "TRCRSCTLR16", 0x8881, true, true,  {}  }, // 898
  { "TRCRSCTLR17", "TRCRSCTLR17", 0x8889, true, true,  {}  }, // 899
  { "TRCRSCTLR18", "TRCRSCTLR18", 0x8891, true, true,  {}  }, // 900
  { "TRCRSCTLR19", "TRCRSCTLR19", 0x8899, true, true,  {}  }, // 901
  { "TRCRSCTLR2", "TRCRSCTLR2", 0x8890, true, true,  {}  }, // 902
  { "TRCRSCTLR20", "TRCRSCTLR20", 0x88A1, true, true,  {}  }, // 903
  { "TRCRSCTLR21", "TRCRSCTLR21", 0x88A9, true, true,  {}  }, // 904
  { "TRCRSCTLR22", "TRCRSCTLR22", 0x88B1, true, true,  {}  }, // 905
  { "TRCRSCTLR23", "TRCRSCTLR23", 0x88B9, true, true,  {}  }, // 906
  { "TRCRSCTLR24", "TRCRSCTLR24", 0x88C1, true, true,  {}  }, // 907
  { "TRCRSCTLR25", "TRCRSCTLR25", 0x88C9, true, true,  {}  }, // 908
  { "TRCRSCTLR26", "TRCRSCTLR26", 0x88D1, true, true,  {}  }, // 909
  { "TRCRSCTLR27", "TRCRSCTLR27", 0x88D9, true, true,  {}  }, // 910
  { "TRCRSCTLR28", "TRCRSCTLR28", 0x88E1, true, true,  {}  }, // 911
  { "TRCRSCTLR29", "TRCRSCTLR29", 0x88E9, true, true,  {}  }, // 912
  { "TRCRSCTLR3", "TRCRSCTLR3", 0x8898, true, true,  {}  }, // 913
  { "TRCRSCTLR30", "TRCRSCTLR30", 0x88F1, true, true,  {}  }, // 914
  { "TRCRSCTLR31", "TRCRSCTLR31", 0x88F9, true, true,  {}  }, // 915
  { "TRCRSCTLR4", "TRCRSCTLR4", 0x88A0, true, true,  {}  }, // 916
  { "TRCRSCTLR5", "TRCRSCTLR5", 0x88A8, true, true,  {}  }, // 917
  { "TRCRSCTLR6", "TRCRSCTLR6", 0x88B0, true, true,  {}  }, // 918
  { "TRCRSCTLR7", "TRCRSCTLR7", 0x88B8, true, true,  {}  }, // 919
  { "TRCRSCTLR8", "TRCRSCTLR8", 0x88C0, true, true,  {}  }, // 920
  { "TRCRSCTLR9", "TRCRSCTLR9", 0x88C8, true, true,  {}  }, // 921
  { "TRCRSR", "TRCRSR", 0x8850, true, true,  {AArch64::FeatureETE}  }, // 922
  { "TRCSEQEVR0", "TRCSEQEVR0", 0x8804, true, true,  {}  }, // 923
  { "TRCSEQEVR1", "TRCSEQEVR1", 0x880C, true, true,  {}  }, // 924
  { "TRCSEQEVR2", "TRCSEQEVR2", 0x8814, true, true,  {}  }, // 925
  { "TRCSEQRSTEVR", "TRCSEQRSTEVR", 0x8834, true, true,  {}  }, // 926
  { "TRCSEQSTR", "TRCSEQSTR", 0x883C, true, true,  {}  }, // 927
  { "TRCSSCCR0", "TRCSSCCR0", 0x8882, true, true,  {}  }, // 928
  { "TRCSSCCR1", "TRCSSCCR1", 0x888A, true, true,  {}  }, // 929
  { "TRCSSCCR2", "TRCSSCCR2", 0x8892, true, true,  {}  }, // 930
  { "TRCSSCCR3", "TRCSSCCR3", 0x889A, true, true,  {}  }, // 931
  { "TRCSSCCR4", "TRCSSCCR4", 0x88A2, true, true,  {}  }, // 932
  { "TRCSSCCR5", "TRCSSCCR5", 0x88AA, true, true,  {}  }, // 933
  { "TRCSSCCR6", "TRCSSCCR6", 0x88B2, true, true,  {}  }, // 934
  { "TRCSSCCR7", "TRCSSCCR7", 0x88BA, true, true,  {}  }, // 935
  { "TRCSSCSR0", "TRCSSCSR0", 0x88C2, true, true,  {}  }, // 936
  { "TRCSSCSR1", "TRCSSCSR1", 0x88CA, true, true,  {}  }, // 937
  { "TRCSSCSR2", "TRCSSCSR2", 0x88D2, true, true,  {}  }, // 938
  { "TRCSSCSR3", "TRCSSCSR3", 0x88DA, true, true,  {}  }, // 939
  { "TRCSSCSR4", "TRCSSCSR4", 0x88E2, true, true,  {}  }, // 940
  { "TRCSSCSR5", "TRCSSCSR5", 0x88EA, true, true,  {}  }, // 941
  { "TRCSSCSR6", "TRCSSCSR6", 0x88F2, true, true,  {}  }, // 942
  { "TRCSSCSR7", "TRCSSCSR7", 0x88FA, true, true,  {}  }, // 943
  { "TRCSSPCICR0", "TRCSSPCICR0", 0x8883, true, true,  {}  }, // 944
  { "TRCSSPCICR1", "TRCSSPCICR1", 0x888B, true, true,  {}  }, // 945
  { "TRCSSPCICR2", "TRCSSPCICR2", 0x8893, true, true,  {}  }, // 946
  { "TRCSSPCICR3", "TRCSSPCICR3", 0x889B, true, true,  {}  }, // 947
  { "TRCSSPCICR4", "TRCSSPCICR4", 0x88A3, true, true,  {}  }, // 948
  { "TRCSSPCICR5", "TRCSSPCICR5", 0x88AB, true, true,  {}  }, // 949
  { "TRCSSPCICR6", "TRCSSPCICR6", 0x88B3, true, true,  {}  }, // 950
  { "TRCSSPCICR7", "TRCSSPCICR7", 0x88BB, true, true,  {}  }, // 951
  { "TRCSTALLCTLR", "TRCSTALLCTLR", 0x8858, true, true,  {}  }, // 952
  { "TRCSTATR", "TRCSTATR", 0x8818, true, false,  {}  }, // 953
  { "TRCSYNCPR", "TRCSYNCPR", 0x8868, true, true,  {}  }, // 954
  { "TRCTRACEIDR", "TRCTRACEIDR", 0x8801, true, true,  {}  }, // 955
  { "TRCTSCTLR", "TRCTSCTLR", 0x8860, true, true,  {}  }, // 956
  { "TRCVDARCCTLR", "TRCVDARCCTLR", 0x8852, true, true,  {}  }, // 957
  { "TRCVDCTLR", "TRCVDCTLR", 0x8842, true, true,  {}  }, // 958
  { "TRCVDSACCTLR", "TRCVDSACCTLR", 0x884A, true, true,  {}  }, // 959
  { "TRCVICTLR", "TRCVICTLR", 0x8802, true, true,  {}  }, // 960
  { "TRCVIIECTLR", "TRCVIIECTLR", 0x880A, true, true,  {}  }, // 961
  { "TRCVIPCSSCTLR", "TRCVIPCSSCTLR", 0x881A, true, true,  {}  }, // 962
  { "TRCVISSCTLR", "TRCVISSCTLR", 0x8812, true, true,  {}  }, // 963
  { "TRCVMIDCCTLR0", "TRCVMIDCCTLR0", 0x8992, true, true,  {}  }, // 964
  { "TRCVMIDCCTLR1", "TRCVMIDCCTLR1", 0x899A, true, true,  {}  }, // 965
  { "TRCVMIDCVR0", "TRCVMIDCVR0", 0x8981, true, true,  {}  }, // 966
  { "TRCVMIDCVR1", "TRCVMIDCVR1", 0x8991, true, true,  {}  }, // 967
  { "TRCVMIDCVR2", "TRCVMIDCVR2", 0x89A1, true, true,  {}  }, // 968
  { "TRCVMIDCVR3", "TRCVMIDCVR3", 0x89B1, true, true,  {}  }, // 969
  { "TRCVMIDCVR4", "TRCVMIDCVR4", 0x89C1, true, true,  {}  }, // 970
  { "TRCVMIDCVR5", "TRCVMIDCVR5", 0x89D1, true, true,  {}  }, // 971
  { "TRCVMIDCVR6", "TRCVMIDCVR6", 0x89E1, true, true,  {}  }, // 972
  { "TRCVMIDCVR7", "TRCVMIDCVR7", 0x89F1, true, true,  {}  }, // 973
  { "TRFCR_EL1", "TRFCR_EL1", 0xC091, true, true,  {AArch64::FeatureTRACEV8_4}  }, // 974
  { "TRFCR_EL12", "TRFCR_EL12", 0xE891, true, true,  {AArch64::FeatureTRACEV8_4}  }, // 975
  { "TRFCR_EL2", "TRFCR_EL2", 0xE091, true, true,  {AArch64::FeatureTRACEV8_4}  }, // 976
  { "TTBR0_EL1", "TTBR0_EL1", 0xC100, true, true,  {}  }, // 977
  { "TTBR0_EL12", "TTBR0_EL12", 0xE900, true, true,  {AArch64::FeatureVH}  }, // 978
  { "TTBR0_EL2", "VSCTLR_EL2", 0xE100, true, true,  {AArch64::FeatureEL2VMSA}  }, // 979
  { "TTBR0_EL3", "TTBR0_EL3", 0xF100, true, true,  {}  }, // 980
  { "TTBR1_EL1", "TTBR1_EL1", 0xC101, true, true,  {}  }, // 981
  { "TTBR1_EL12", "TTBR1_EL12", 0xE901, true, true,  {AArch64::FeatureVH}  }, // 982
  { "TTBR1_EL2", "TTBR1_EL2", 0xE101, true, true,  {AArch64::FeatureVH}  }, // 983
  { "UAO", "UAO", 0xC214, true, true,  {AArch64::FeaturePsUAO}  }, // 984
  { "VBAR_EL1", "VBAR_EL1", 0xC600, true, true,  {}  }, // 985
  { "VBAR_EL12", "VBAR_EL12", 0xEE00, true, true,  {AArch64::FeatureVH}  }, // 986
  { "VBAR_EL2", "VBAR_EL2", 0xE600, true, true,  {}  }, // 987
  { "VBAR_EL3", "VBAR_EL3", 0xF600, true, true,  {}  }, // 988
  { "VDISR_EL2", "VDISR_EL2", 0xE609, true, true,  {AArch64::FeatureRAS}  }, // 989
  { "VMPIDR_EL2", "VMPIDR_EL2", 0xE005, true, true,  {}  }, // 990
  { "VNCR_EL2", "VNCR_EL2", 0xE110, true, true,  {AArch64::FeatureNV}  }, // 991
  { "VPIDR_EL2", "VPIDR_EL2", 0xE000, true, true,  {}  }, // 992
  { "VSCTLR_EL2", "TTBR0_EL2", 0xE100, true, true,  {AArch64::HasV8_0rOps}  }, // 993
  { "VSESR_EL2", "VSESR_EL2", 0xE293, true, true,  {AArch64::FeatureRAS}  }, // 994
  { "VSTCR_EL2", "VSTCR_EL2", 0xE132, true, true,  {AArch64::FeatureSEL2}  }, // 995
  { "VSTTBR_EL2", "VSTTBR_EL2", 0xE130, true, true,  {AArch64::HasV8_0aOps}  }, // 996
  { "VTCR_EL2", "VTCR_EL2", 0xE10A, true, true,  {}  }, // 997
  { "VTTBR_EL2", "VTTBR_EL2", 0xE108, true, true,  {AArch64::FeatureEL2VMSA}  }, // 998
  { "ZCR_EL1", "ZCR_EL1", 0xC090, true, true,  {AArch64::FeatureSVE}  }, // 999
  { "ZCR_EL12", "ZCR_EL12", 0xE890, true, true,  {AArch64::FeatureSVE}  }, // 1000
  { "ZCR_EL2", "ZCR_EL2", 0xE090, true, true,  {AArch64::FeatureSVE}  }, // 1001
  { "ZCR_EL3", "ZCR_EL3", 0xF090, true, true,  {AArch64::FeatureSVE}  }, // 1002
 };

const SysReg *lookupSysRegByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ACCDATA_EL1", 0 },
    { "ACTLR_EL1", 1 },
    { "ACTLR_EL2", 2 },
    { "ACTLR_EL3", 3 },
    { "AFSR0_EL1", 4 },
    { "AFSR0_EL12", 5 },
    { "AFSR0_EL2", 6 },
    { "AFSR0_EL3", 7 },
    { "AFSR1_EL1", 8 },
    { "AFSR1_EL12", 9 },
    { "AFSR1_EL2", 10 },
    { "AFSR1_EL3", 11 },
    { "AIDR_EL1", 12 },
    { "AMAIR_EL1", 13 },
    { "AMAIR_EL12", 14 },
    { "AMAIR_EL2", 15 },
    { "AMAIR_EL3", 16 },
    { "AMCFGR_EL0", 17 },
    { "AMCGCR_EL0", 18 },
    { "AMCNTENCLR0_EL0", 19 },
    { "AMCNTENCLR1_EL0", 20 },
    { "AMCNTENSET0_EL0", 21 },
    { "AMCNTENSET1_EL0", 22 },
    { "AMCR_EL0", 23 },
    { "AMEVCNTR00_EL0", 24 },
    { "AMEVCNTR01_EL0", 25 },
    { "AMEVCNTR02_EL0", 26 },
    { "AMEVCNTR03_EL0", 27 },
    { "AMEVCNTR10_EL0", 28 },
    { "AMEVCNTR110_EL0", 29 },
    { "AMEVCNTR111_EL0", 30 },
    { "AMEVCNTR112_EL0", 31 },
    { "AMEVCNTR113_EL0", 32 },
    { "AMEVCNTR114_EL0", 33 },
    { "AMEVCNTR115_EL0", 34 },
    { "AMEVCNTR11_EL0", 35 },
    { "AMEVCNTR12_EL0", 36 },
    { "AMEVCNTR13_EL0", 37 },
    { "AMEVCNTR14_EL0", 38 },
    { "AMEVCNTR15_EL0", 39 },
    { "AMEVCNTR16_EL0", 40 },
    { "AMEVCNTR17_EL0", 41 },
    { "AMEVCNTR18_EL0", 42 },
    { "AMEVCNTR19_EL0", 43 },
    { "AMEVCNTVOFF00_EL2", 44 },
    { "AMEVCNTVOFF010_EL2", 45 },
    { "AMEVCNTVOFF011_EL2", 46 },
    { "AMEVCNTVOFF012_EL2", 47 },
    { "AMEVCNTVOFF013_EL2", 48 },
    { "AMEVCNTVOFF014_EL2", 49 },
    { "AMEVCNTVOFF015_EL2", 50 },
    { "AMEVCNTVOFF01_EL2", 51 },
    { "AMEVCNTVOFF02_EL2", 52 },
    { "AMEVCNTVOFF03_EL2", 53 },
    { "AMEVCNTVOFF04_EL2", 54 },
    { "AMEVCNTVOFF05_EL2", 55 },
    { "AMEVCNTVOFF06_EL2", 56 },
    { "AMEVCNTVOFF07_EL2", 57 },
    { "AMEVCNTVOFF08_EL2", 58 },
    { "AMEVCNTVOFF09_EL2", 59 },
    { "AMEVCNTVOFF10_EL2", 60 },
    { "AMEVCNTVOFF110_EL2", 61 },
    { "AMEVCNTVOFF111_EL2", 62 },
    { "AMEVCNTVOFF112_EL2", 63 },
    { "AMEVCNTVOFF113_EL2", 64 },
    { "AMEVCNTVOFF114_EL2", 65 },
    { "AMEVCNTVOFF115_EL2", 66 },
    { "AMEVCNTVOFF11_EL2", 67 },
    { "AMEVCNTVOFF12_EL2", 68 },
    { "AMEVCNTVOFF13_EL2", 69 },
    { "AMEVCNTVOFF14_EL2", 70 },
    { "AMEVCNTVOFF15_EL2", 71 },
    { "AMEVCNTVOFF16_EL2", 72 },
    { "AMEVCNTVOFF17_EL2", 73 },
    { "AMEVCNTVOFF18_EL2", 74 },
    { "AMEVCNTVOFF19_EL2", 75 },
    { "AMEVTYPER00_EL0", 76 },
    { "AMEVTYPER01_EL0", 77 },
    { "AMEVTYPER02_EL0", 78 },
    { "AMEVTYPER03_EL0", 79 },
    { "AMEVTYPER10_EL0", 80 },
    { "AMEVTYPER110_EL0", 81 },
    { "AMEVTYPER111_EL0", 82 },
    { "AMEVTYPER112_EL0", 83 },
    { "AMEVTYPER113_EL0", 84 },
    { "AMEVTYPER114_EL0", 85 },
    { "AMEVTYPER115_EL0", 86 },
    { "AMEVTYPER11_EL0", 87 },
    { "AMEVTYPER12_EL0", 88 },
    { "AMEVTYPER13_EL0", 89 },
    { "AMEVTYPER14_EL0", 90 },
    { "AMEVTYPER15_EL0", 91 },
    { "AMEVTYPER16_EL0", 92 },
    { "AMEVTYPER17_EL0", 93 },
    { "AMEVTYPER18_EL0", 94 },
    { "AMEVTYPER19_EL0", 95 },
    { "AMUSERENR_EL0", 96 },
    { "APDAKEYHI_EL1", 97 },
    { "APDAKEYLO_EL1", 98 },
    { "APDBKEYHI_EL1", 99 },
    { "APDBKEYLO_EL1", 100 },
    { "APGAKEYHI_EL1", 101 },
    { "APGAKEYLO_EL1", 102 },
    { "APIAKEYHI_EL1", 103 },
    { "APIAKEYLO_EL1", 104 },
    { "APIBKEYHI_EL1", 105 },
    { "APIBKEYLO_EL1", 106 },
    { "BRBCR_EL1", 107 },
    { "BRBCR_EL12", 108 },
    { "BRBCR_EL2", 109 },
    { "BRBFCR_EL1", 110 },
    { "BRBIDR0_EL1", 111 },
    { "BRBINF0_EL1", 112 },
    { "BRBINF10_EL1", 113 },
    { "BRBINF11_EL1", 114 },
    { "BRBINF12_EL1", 115 },
    { "BRBINF13_EL1", 116 },
    { "BRBINF14_EL1", 117 },
    { "BRBINF15_EL1", 118 },
    { "BRBINF16_EL1", 119 },
    { "BRBINF17_EL1", 120 },
    { "BRBINF18_EL1", 121 },
    { "BRBINF19_EL1", 122 },
    { "BRBINF1_EL1", 123 },
    { "BRBINF20_EL1", 124 },
    { "BRBINF21_EL1", 125 },
    { "BRBINF22_EL1", 126 },
    { "BRBINF23_EL1", 127 },
    { "BRBINF24_EL1", 128 },
    { "BRBINF25_EL1", 129 },
    { "BRBINF26_EL1", 130 },
    { "BRBINF27_EL1", 131 },
    { "BRBINF28_EL1", 132 },
    { "BRBINF29_EL1", 133 },
    { "BRBINF2_EL1", 134 },
    { "BRBINF30_EL1", 135 },
    { "BRBINF31_EL1", 136 },
    { "BRBINF3_EL1", 137 },
    { "BRBINF4_EL1", 138 },
    { "BRBINF5_EL1", 139 },
    { "BRBINF6_EL1", 140 },
    { "BRBINF7_EL1", 141 },
    { "BRBINF8_EL1", 142 },
    { "BRBINF9_EL1", 143 },
    { "BRBINFINJ_EL1", 144 },
    { "BRBSRC0_EL1", 145 },
    { "BRBSRC10_EL1", 146 },
    { "BRBSRC11_EL1", 147 },
    { "BRBSRC12_EL1", 148 },
    { "BRBSRC13_EL1", 149 },
    { "BRBSRC14_EL1", 150 },
    { "BRBSRC15_EL1", 151 },
    { "BRBSRC16_EL1", 152 },
    { "BRBSRC17_EL1", 153 },
    { "BRBSRC18_EL1", 154 },
    { "BRBSRC19_EL1", 155 },
    { "BRBSRC1_EL1", 156 },
    { "BRBSRC20_EL1", 157 },
    { "BRBSRC21_EL1", 158 },
    { "BRBSRC22_EL1", 159 },
    { "BRBSRC23_EL1", 160 },
    { "BRBSRC24_EL1", 161 },
    { "BRBSRC25_EL1", 162 },
    { "BRBSRC26_EL1", 163 },
    { "BRBSRC27_EL1", 164 },
    { "BRBSRC28_EL1", 165 },
    { "BRBSRC29_EL1", 166 },
    { "BRBSRC2_EL1", 167 },
    { "BRBSRC30_EL1", 168 },
    { "BRBSRC31_EL1", 169 },
    { "BRBSRC3_EL1", 170 },
    { "BRBSRC4_EL1", 171 },
    { "BRBSRC5_EL1", 172 },
    { "BRBSRC6_EL1", 173 },
    { "BRBSRC7_EL1", 174 },
    { "BRBSRC8_EL1", 175 },
    { "BRBSRC9_EL1", 176 },
    { "BRBSRCINJ_EL1", 177 },
    { "BRBTGT0_EL1", 178 },
    { "BRBTGT10_EL1", 179 },
    { "BRBTGT11_EL1", 180 },
    { "BRBTGT12_EL1", 181 },
    { "BRBTGT13_EL1", 182 },
    { "BRBTGT14_EL1", 183 },
    { "BRBTGT15_EL1", 184 },
    { "BRBTGT16_EL1", 185 },
    { "BRBTGT17_EL1", 186 },
    { "BRBTGT18_EL1", 187 },
    { "BRBTGT19_EL1", 188 },
    { "BRBTGT1_EL1", 189 },
    { "BRBTGT20_EL1", 190 },
    { "BRBTGT21_EL1", 191 },
    { "BRBTGT22_EL1", 192 },
    { "BRBTGT23_EL1", 193 },
    { "BRBTGT24_EL1", 194 },
    { "BRBTGT25_EL1", 195 },
    { "BRBTGT26_EL1", 196 },
    { "BRBTGT27_EL1", 197 },
    { "BRBTGT28_EL1", 198 },
    { "BRBTGT29_EL1", 199 },
    { "BRBTGT2_EL1", 200 },
    { "BRBTGT30_EL1", 201 },
    { "BRBTGT31_EL1", 202 },
    { "BRBTGT3_EL1", 203 },
    { "BRBTGT4_EL1", 204 },
    { "BRBTGT5_EL1", 205 },
    { "BRBTGT6_EL1", 206 },
    { "BRBTGT7_EL1", 207 },
    { "BRBTGT8_EL1", 208 },
    { "BRBTGT9_EL1", 209 },
    { "BRBTGTINJ_EL1", 210 },
    { "BRBTS_EL1", 211 },
    { "CCSIDR2_EL1", 212 },
    { "CCSIDR_EL1", 213 },
    { "CLIDR_EL1", 214 },
    { "CNTFRQ_EL0", 215 },
    { "CNTHCTL_EL2", 216 },
    { "CNTHPS_CTL_EL2", 217 },
    { "CNTHPS_CVAL_EL2", 218 },
    { "CNTHPS_TVAL_EL2", 219 },
    { "CNTHP_CTL_EL2", 220 },
    { "CNTHP_CVAL_EL2", 221 },
    { "CNTHP_TVAL_EL2", 222 },
    { "CNTHVS_CTL_EL2", 223 },
    { "CNTHVS_CVAL_EL2", 224 },
    { "CNTHVS_TVAL_EL2", 225 },
    { "CNTHV_CTL_EL2", 226 },
    { "CNTHV_CVAL_EL2", 227 },
    { "CNTHV_TVAL_EL2", 228 },
    { "CNTISCALE_EL2", 229 },
    { "CNTKCTL_EL1", 230 },
    { "CNTKCTL_EL12", 231 },
    { "CNTPCTSS_EL0", 232 },
    { "CNTPCT_EL0", 233 },
    { "CNTPOFF_EL2", 234 },
    { "CNTPS_CTL_EL1", 235 },
    { "CNTPS_CVAL_EL1", 236 },
    { "CNTPS_TVAL_EL1", 237 },
    { "CNTP_CTL_EL0", 238 },
    { "CNTP_CTL_EL02", 239 },
    { "CNTP_CVAL_EL0", 240 },
    { "CNTP_CVAL_EL02", 241 },
    { "CNTP_TVAL_EL0", 242 },
    { "CNTP_TVAL_EL02", 243 },
    { "CNTSCALE_EL2", 244 },
    { "CNTVCTSS_EL0", 245 },
    { "CNTVCT_EL0", 246 },
    { "CNTVFRQ_EL2", 247 },
    { "CNTVOFF_EL2", 248 },
    { "CNTV_CTL_EL0", 249 },
    { "CNTV_CTL_EL02", 250 },
    { "CNTV_CVAL_EL0", 251 },
    { "CNTV_CVAL_EL02", 252 },
    { "CNTV_TVAL_EL0", 253 },
    { "CNTV_TVAL_EL02", 254 },
    { "CONTEXTIDR_EL1", 255 },
    { "CONTEXTIDR_EL12", 256 },
    { "CONTEXTIDR_EL2", 257 },
    { "CPACR_EL1", 258 },
    { "CPACR_EL12", 259 },
    { "CPM_IOACC_CTL_EL3", 260 },
    { "CPTR_EL2", 261 },
    { "CPTR_EL3", 262 },
    { "CSSELR_EL1", 263 },
    { "CTR_EL0", 264 },
    { "CURRENTEL", 265 },
    { "DACR32_EL2", 266 },
    { "DAIF", 267 },
    { "DBGAUTHSTATUS_EL1", 268 },
    { "DBGBCR0_EL1", 269 },
    { "DBGBCR10_EL1", 270 },
    { "DBGBCR11_EL1", 271 },
    { "DBGBCR12_EL1", 272 },
    { "DBGBCR13_EL1", 273 },
    { "DBGBCR14_EL1", 274 },
    { "DBGBCR15_EL1", 275 },
    { "DBGBCR1_EL1", 276 },
    { "DBGBCR2_EL1", 277 },
    { "DBGBCR3_EL1", 278 },
    { "DBGBCR4_EL1", 279 },
    { "DBGBCR5_EL1", 280 },
    { "DBGBCR6_EL1", 281 },
    { "DBGBCR7_EL1", 282 },
    { "DBGBCR8_EL1", 283 },
    { "DBGBCR9_EL1", 284 },
    { "DBGBVR0_EL1", 285 },
    { "DBGBVR10_EL1", 286 },
    { "DBGBVR11_EL1", 287 },
    { "DBGBVR12_EL1", 288 },
    { "DBGBVR13_EL1", 289 },
    { "DBGBVR14_EL1", 290 },
    { "DBGBVR15_EL1", 291 },
    { "DBGBVR1_EL1", 292 },
    { "DBGBVR2_EL1", 293 },
    { "DBGBVR3_EL1", 294 },
    { "DBGBVR4_EL1", 295 },
    { "DBGBVR5_EL1", 296 },
    { "DBGBVR6_EL1", 297 },
    { "DBGBVR7_EL1", 298 },
    { "DBGBVR8_EL1", 299 },
    { "DBGBVR9_EL1", 300 },
    { "DBGCLAIMCLR_EL1", 301 },
    { "DBGCLAIMSET_EL1", 302 },
    { "DBGDTRRX_EL0", 303 },
    { "DBGDTRTX_EL0", 304 },
    { "DBGDTR_EL0", 305 },
    { "DBGPRCR_EL1", 306 },
    { "DBGVCR32_EL2", 307 },
    { "DBGWCR0_EL1", 308 },
    { "DBGWCR10_EL1", 309 },
    { "DBGWCR11_EL1", 310 },
    { "DBGWCR12_EL1", 311 },
    { "DBGWCR13_EL1", 312 },
    { "DBGWCR14_EL1", 313 },
    { "DBGWCR15_EL1", 314 },
    { "DBGWCR1_EL1", 315 },
    { "DBGWCR2_EL1", 316 },
    { "DBGWCR3_EL1", 317 },
    { "DBGWCR4_EL1", 318 },
    { "DBGWCR5_EL1", 319 },
    { "DBGWCR6_EL1", 320 },
    { "DBGWCR7_EL1", 321 },
    { "DBGWCR8_EL1", 322 },
    { "DBGWCR9_EL1", 323 },
    { "DBGWVR0_EL1", 324 },
    { "DBGWVR10_EL1", 325 },
    { "DBGWVR11_EL1", 326 },
    { "DBGWVR12_EL1", 327 },
    { "DBGWVR13_EL1", 328 },
    { "DBGWVR14_EL1", 329 },
    { "DBGWVR15_EL1", 330 },
    { "DBGWVR1_EL1", 331 },
    { "DBGWVR2_EL1", 332 },
    { "DBGWVR3_EL1", 333 },
    { "DBGWVR4_EL1", 334 },
    { "DBGWVR5_EL1", 335 },
    { "DBGWVR6_EL1", 336 },
    { "DBGWVR7_EL1", 337 },
    { "DBGWVR8_EL1", 338 },
    { "DBGWVR9_EL1", 339 },
    { "DCZID_EL0", 340 },
    { "DISR_EL1", 341 },
    { "DIT", 342 },
    { "DLR_EL0", 343 },
    { "DSPSR_EL0", 344 },
    { "ELR_EL1", 345 },
    { "ELR_EL12", 346 },
    { "ELR_EL2", 347 },
    { "ELR_EL3", 348 },
    { "ERRIDR_EL1", 349 },
    { "ERRSELR_EL1", 350 },
    { "ERXADDR_EL1", 351 },
    { "ERXCTLR_EL1", 352 },
    { "ERXFR_EL1", 353 },
    { "ERXMISC0_EL1", 354 },
    { "ERXMISC1_EL1", 355 },
    { "ERXMISC2_EL1", 356 },
    { "ERXMISC3_EL1", 357 },
    { "ERXPFGCDN_EL1", 358 },
    { "ERXPFGCTL_EL1", 359 },
    { "ERXPFGF_EL1", 360 },
    { "ERXSTATUS_EL1", 361 },
    { "ESR_EL1", 362 },
    { "ESR_EL12", 363 },
    { "ESR_EL2", 364 },
    { "ESR_EL3", 365 },
    { "FAR_EL1", 366 },
    { "FAR_EL12", 367 },
    { "FAR_EL2", 368 },
    { "FAR_EL3", 369 },
    { "FPCR", 370 },
    { "FPEXC32_EL2", 371 },
    { "FPSR", 372 },
    { "GCR_EL1", 373 },
    { "GMID_EL1", 374 },
    { "GPCCR_EL3", 375 },
    { "GPTBR_EL3", 376 },
    { "HACR_EL2", 377 },
    { "HCRX_EL2", 378 },
    { "HCR_EL2", 379 },
    { "HDFGRTR_EL2", 380 },
    { "HDFGWTR_EL2", 381 },
    { "HFGITR_EL2", 382 },
    { "HFGRTR_EL2", 383 },
    { "HFGWTR_EL2", 384 },
    { "HPFAR_EL2", 385 },
    { "HSTR_EL2", 386 },
    { "ICC_AP0R0_EL1", 387 },
    { "ICC_AP0R1_EL1", 388 },
    { "ICC_AP0R2_EL1", 389 },
    { "ICC_AP0R3_EL1", 390 },
    { "ICC_AP1R0_EL1", 391 },
    { "ICC_AP1R1_EL1", 392 },
    { "ICC_AP1R2_EL1", 393 },
    { "ICC_AP1R3_EL1", 394 },
    { "ICC_ASGI1R_EL1", 395 },
    { "ICC_BPR0_EL1", 396 },
    { "ICC_BPR1_EL1", 397 },
    { "ICC_CTLR_EL1", 398 },
    { "ICC_CTLR_EL3", 399 },
    { "ICC_DIR_EL1", 400 },
    { "ICC_EOIR0_EL1", 401 },
    { "ICC_EOIR1_EL1", 402 },
    { "ICC_HPPIR0_EL1", 403 },
    { "ICC_HPPIR1_EL1", 404 },
    { "ICC_IAR0_EL1", 405 },
    { "ICC_IAR1_EL1", 406 },
    { "ICC_IGRPEN0_EL1", 407 },
    { "ICC_IGRPEN1_EL1", 408 },
    { "ICC_IGRPEN1_EL3", 409 },
    { "ICC_PMR_EL1", 410 },
    { "ICC_RPR_EL1", 411 },
    { "ICC_SGI0R_EL1", 412 },
    { "ICC_SGI1R_EL1", 413 },
    { "ICC_SRE_EL1", 414 },
    { "ICC_SRE_EL2", 415 },
    { "ICC_SRE_EL3", 416 },
    { "ICH_AP0R0_EL2", 417 },
    { "ICH_AP0R1_EL2", 418 },
    { "ICH_AP0R2_EL2", 419 },
    { "ICH_AP0R3_EL2", 420 },
    { "ICH_AP1R0_EL2", 421 },
    { "ICH_AP1R1_EL2", 422 },
    { "ICH_AP1R2_EL2", 423 },
    { "ICH_AP1R3_EL2", 424 },
    { "ICH_EISR_EL2", 425 },
    { "ICH_ELRSR_EL2", 426 },
    { "ICH_HCR_EL2", 427 },
    { "ICH_LR0_EL2", 428 },
    { "ICH_LR10_EL2", 429 },
    { "ICH_LR11_EL2", 430 },
    { "ICH_LR12_EL2", 431 },
    { "ICH_LR13_EL2", 432 },
    { "ICH_LR14_EL2", 433 },
    { "ICH_LR15_EL2", 434 },
    { "ICH_LR1_EL2", 435 },
    { "ICH_LR2_EL2", 436 },
    { "ICH_LR3_EL2", 437 },
    { "ICH_LR4_EL2", 438 },
    { "ICH_LR5_EL2", 439 },
    { "ICH_LR6_EL2", 440 },
    { "ICH_LR7_EL2", 441 },
    { "ICH_LR8_EL2", 442 },
    { "ICH_LR9_EL2", 443 },
    { "ICH_MISR_EL2", 444 },
    { "ICH_VMCR_EL2", 445 },
    { "ICH_VTR_EL2", 446 },
    { "ID_AA64AFR0_EL1", 447 },
    { "ID_AA64AFR1_EL1", 448 },
    { "ID_AA64DFR0_EL1", 449 },
    { "ID_AA64DFR1_EL1", 450 },
    { "ID_AA64ISAR0_EL1", 451 },
    { "ID_AA64ISAR1_EL1", 452 },
    { "ID_AA64ISAR2_EL1", 453 },
    { "ID_AA64MMFR0_EL1", 454 },
    { "ID_AA64MMFR1_EL1", 455 },
    { "ID_AA64MMFR2_EL1", 456 },
    { "ID_AA64PFR0_EL1", 457 },
    { "ID_AA64PFR1_EL1", 458 },
    { "ID_AA64SMFR0_EL1", 459 },
    { "ID_AA64ZFR0_EL1", 460 },
    { "ID_AFR0_EL1", 461 },
    { "ID_DFR0_EL1", 462 },
    { "ID_ISAR0_EL1", 463 },
    { "ID_ISAR1_EL1", 464 },
    { "ID_ISAR2_EL1", 465 },
    { "ID_ISAR3_EL1", 466 },
    { "ID_ISAR4_EL1", 467 },
    { "ID_ISAR5_EL1", 468 },
    { "ID_ISAR6_EL1", 469 },
    { "ID_MMFR0_EL1", 470 },
    { "ID_MMFR1_EL1", 471 },
    { "ID_MMFR2_EL1", 472 },
    { "ID_MMFR3_EL1", 473 },
    { "ID_MMFR4_EL1", 474 },
    { "ID_MMFR5_EL1", 475 },
    { "ID_PFR0_EL1", 476 },
    { "ID_PFR1_EL1", 477 },
    { "ID_PFR2_EL1", 478 },
    { "IFSR32_EL2", 479 },
    { "ISR_EL1", 480 },
    { "LORC_EL1", 481 },
    { "LOREA_EL1", 482 },
    { "LORID_EL1", 483 },
    { "LORN_EL1", 484 },
    { "LORSA_EL1", 485 },
    { "MAIR_EL1", 486 },
    { "MAIR_EL12", 487 },
    { "MAIR_EL2", 488 },
    { "MAIR_EL3", 489 },
    { "MDCCINT_EL1", 490 },
    { "MDCCSR_EL0", 491 },
    { "MDCR_EL2", 492 },
    { "MDCR_EL3", 493 },
    { "MDRAR_EL1", 494 },
    { "MDSCR_EL1", 495 },
    { "MFAR_EL3", 496 },
    { "MIDR_EL1", 497 },
    { "MPAM0_EL1", 498 },
    { "MPAM1_EL1", 499 },
    { "MPAM1_EL12", 500 },
    { "MPAM2_EL2", 501 },
    { "MPAM3_EL3", 502 },
    { "MPAMHCR_EL2", 503 },
    { "MPAMIDR_EL1", 504 },
    { "MPAMSM_EL1", 505 },
    { "MPAMVPM0_EL2", 506 },
    { "MPAMVPM1_EL2", 507 },
    { "MPAMVPM2_EL2", 508 },
    { "MPAMVPM3_EL2", 509 },
    { "MPAMVPM4_EL2", 510 },
    { "MPAMVPM5_EL2", 511 },
    { "MPAMVPM6_EL2", 512 },
    { "MPAMVPM7_EL2", 513 },
    { "MPAMVPMV_EL2", 514 },
    { "MPIDR_EL1", 515 },
    { "MPUIR_EL1", 516 },
    { "MPUIR_EL2", 517 },
    { "MVFR0_EL1", 518 },
    { "MVFR1_EL1", 519 },
    { "MVFR2_EL1", 520 },
    { "NZCV", 521 },
    { "OSDLR_EL1", 522 },
    { "OSDTRRX_EL1", 523 },
    { "OSDTRTX_EL1", 524 },
    { "OSECCR_EL1", 525 },
    { "OSLAR_EL1", 526 },
    { "OSLSR_EL1", 527 },
    { "PAN", 528 },
    { "PAR_EL1", 529 },
    { "PMBIDR_EL1", 530 },
    { "PMBLIMITR_EL1", 531 },
    { "PMBPTR_EL1", 532 },
    { "PMBSR_EL1", 533 },
    { "PMCCFILTR_EL0", 534 },
    { "PMCCNTR_EL0", 535 },
    { "PMCEID0_EL0", 536 },
    { "PMCEID1_EL0", 537 },
    { "PMCNTENCLR_EL0", 538 },
    { "PMCNTENSET_EL0", 539 },
    { "PMCR_EL0", 540 },
    { "PMEVCNTR0_EL0", 541 },
    { "PMEVCNTR10_EL0", 542 },
    { "PMEVCNTR11_EL0", 543 },
    { "PMEVCNTR12_EL0", 544 },
    { "PMEVCNTR13_EL0", 545 },
    { "PMEVCNTR14_EL0", 546 },
    { "PMEVCNTR15_EL0", 547 },
    { "PMEVCNTR16_EL0", 548 },
    { "PMEVCNTR17_EL0", 549 },
    { "PMEVCNTR18_EL0", 550 },
    { "PMEVCNTR19_EL0", 551 },
    { "PMEVCNTR1_EL0", 552 },
    { "PMEVCNTR20_EL0", 553 },
    { "PMEVCNTR21_EL0", 554 },
    { "PMEVCNTR22_EL0", 555 },
    { "PMEVCNTR23_EL0", 556 },
    { "PMEVCNTR24_EL0", 557 },
    { "PMEVCNTR25_EL0", 558 },
    { "PMEVCNTR26_EL0", 559 },
    { "PMEVCNTR27_EL0", 560 },
    { "PMEVCNTR28_EL0", 561 },
    { "PMEVCNTR29_EL0", 562 },
    { "PMEVCNTR2_EL0", 563 },
    { "PMEVCNTR30_EL0", 564 },
    { "PMEVCNTR3_EL0", 565 },
    { "PMEVCNTR4_EL0", 566 },
    { "PMEVCNTR5_EL0", 567 },
    { "PMEVCNTR6_EL0", 568 },
    { "PMEVCNTR7_EL0", 569 },
    { "PMEVCNTR8_EL0", 570 },
    { "PMEVCNTR9_EL0", 571 },
    { "PMEVTYPER0_EL0", 572 },
    { "PMEVTYPER10_EL0", 573 },
    { "PMEVTYPER11_EL0", 574 },
    { "PMEVTYPER12_EL0", 575 },
    { "PMEVTYPER13_EL0", 576 },
    { "PMEVTYPER14_EL0", 577 },
    { "PMEVTYPER15_EL0", 578 },
    { "PMEVTYPER16_EL0", 579 },
    { "PMEVTYPER17_EL0", 580 },
    { "PMEVTYPER18_EL0", 581 },
    { "PMEVTYPER19_EL0", 582 },
    { "PMEVTYPER1_EL0", 583 },
    { "PMEVTYPER20_EL0", 584 },
    { "PMEVTYPER21_EL0", 585 },
    { "PMEVTYPER22_EL0", 586 },
    { "PMEVTYPER23_EL0", 587 },
    { "PMEVTYPER24_EL0", 588 },
    { "PMEVTYPER25_EL0", 589 },
    { "PMEVTYPER26_EL0", 590 },
    { "PMEVTYPER27_EL0", 591 },
    { "PMEVTYPER28_EL0", 592 },
    { "PMEVTYPER29_EL0", 593 },
    { "PMEVTYPER2_EL0", 594 },
    { "PMEVTYPER30_EL0", 595 },
    { "PMEVTYPER3_EL0", 596 },
    { "PMEVTYPER4_EL0", 597 },
    { "PMEVTYPER5_EL0", 598 },
    { "PMEVTYPER6_EL0", 599 },
    { "PMEVTYPER7_EL0", 600 },
    { "PMEVTYPER8_EL0", 601 },
    { "PMEVTYPER9_EL0", 602 },
    { "PMINTENCLR_EL1", 603 },
    { "PMINTENSET_EL1", 604 },
    { "PMMIR_EL1", 605 },
    { "PMOVSCLR_EL0", 606 },
    { "PMOVSSET_EL0", 607 },
    { "PMSCR_EL1", 608 },
    { "PMSCR_EL12", 609 },
    { "PMSCR_EL2", 610 },
    { "PMSELR_EL0", 611 },
    { "PMSEVFR_EL1", 612 },
    { "PMSFCR_EL1", 613 },
    { "PMSICR_EL1", 614 },
    { "PMSIDR_EL1", 615 },
    { "PMSIRR_EL1", 616 },
    { "PMSLATFR_EL1", 617 },
    { "PMSNEVFR_EL1", 618 },
    { "PMSWINC_EL0", 619 },
    { "PMUSERENR_EL0", 620 },
    { "PMXEVCNTR_EL0", 621 },
    { "PMXEVTYPER_EL0", 622 },
    { "PRBAR10_EL1", 623 },
    { "PRBAR10_EL2", 624 },
    { "PRBAR11_EL1", 625 },
    { "PRBAR11_EL2", 626 },
    { "PRBAR12_EL1", 627 },
    { "PRBAR12_EL2", 628 },
    { "PRBAR13_EL1", 629 },
    { "PRBAR13_EL2", 630 },
    { "PRBAR14_EL1", 631 },
    { "PRBAR14_EL2", 632 },
    { "PRBAR15_EL1", 633 },
    { "PRBAR15_EL2", 634 },
    { "PRBAR1_EL1", 635 },
    { "PRBAR1_EL2", 636 },
    { "PRBAR2_EL1", 637 },
    { "PRBAR2_EL2", 638 },
    { "PRBAR3_EL1", 639 },
    { "PRBAR3_EL2", 640 },
    { "PRBAR4_EL1", 641 },
    { "PRBAR4_EL2", 642 },
    { "PRBAR5_EL1", 643 },
    { "PRBAR5_EL2", 644 },
    { "PRBAR6_EL1", 645 },
    { "PRBAR6_EL2", 646 },
    { "PRBAR7_EL1", 647 },
    { "PRBAR7_EL2", 648 },
    { "PRBAR8_EL1", 649 },
    { "PRBAR8_EL2", 650 },
    { "PRBAR9_EL1", 651 },
    { "PRBAR9_EL2", 652 },
    { "PRBAR_EL1", 653 },
    { "PRBAR_EL2", 654 },
    { "PRENR_EL1", 655 },
    { "PRENR_EL2", 656 },
    { "PRLAR10_EL1", 657 },
    { "PRLAR10_EL2", 658 },
    { "PRLAR11_EL1", 659 },
    { "PRLAR11_EL2", 660 },
    { "PRLAR12_EL1", 661 },
    { "PRLAR12_EL2", 662 },
    { "PRLAR13_EL1", 663 },
    { "PRLAR13_EL2", 664 },
    { "PRLAR14_EL1", 665 },
    { "PRLAR14_EL2", 666 },
    { "PRLAR15_EL1", 667 },
    { "PRLAR15_EL2", 668 },
    { "PRLAR1_EL1", 669 },
    { "PRLAR1_EL2", 670 },
    { "PRLAR2_EL1", 671 },
    { "PRLAR2_EL2", 672 },
    { "PRLAR3_EL1", 673 },
    { "PRLAR3_EL2", 674 },
    { "PRLAR4_EL1", 675 },
    { "PRLAR4_EL2", 676 },
    { "PRLAR5_EL1", 677 },
    { "PRLAR5_EL2", 678 },
    { "PRLAR6_EL1", 679 },
    { "PRLAR6_EL2", 680 },
    { "PRLAR7_EL1", 681 },
    { "PRLAR7_EL2", 682 },
    { "PRLAR8_EL1", 683 },
    { "PRLAR8_EL2", 684 },
    { "PRLAR9_EL1", 685 },
    { "PRLAR9_EL2", 686 },
    { "PRLAR_EL1", 687 },
    { "PRLAR_EL2", 688 },
    { "PRSELR_EL1", 689 },
    { "PRSELR_EL2", 690 },
    { "REVIDR_EL1", 691 },
    { "RGSR_EL1", 692 },
    { "RMR_EL1", 693 },
    { "RMR_EL2", 694 },
    { "RMR_EL3", 695 },
    { "RNDR", 696 },
    { "RNDRRS", 697 },
    { "RVBAR_EL1", 698 },
    { "RVBAR_EL2", 699 },
    { "RVBAR_EL3", 700 },
    { "SCR_EL3", 701 },
    { "SCTLR_EL1", 702 },
    { "SCTLR_EL12", 703 },
    { "SCTLR_EL2", 704 },
    { "SCTLR_EL3", 705 },
    { "SCXTNUM_EL0", 706 },
    { "SCXTNUM_EL1", 707 },
    { "SCXTNUM_EL12", 708 },
    { "SCXTNUM_EL2", 709 },
    { "SCXTNUM_EL3", 710 },
    { "SDER32_EL2", 711 },
    { "SDER32_EL3", 712 },
    { "SMCR_EL1", 713 },
    { "SMCR_EL12", 714 },
    { "SMCR_EL2", 715 },
    { "SMCR_EL3", 716 },
    { "SMIDR_EL1", 717 },
    { "SMPRIMAP_EL2", 718 },
    { "SMPRI_EL1", 719 },
    { "SPSEL", 720 },
    { "SPSR_ABT", 721 },
    { "SPSR_EL1", 722 },
    { "SPSR_EL12", 723 },
    { "SPSR_EL2", 724 },
    { "SPSR_EL3", 725 },
    { "SPSR_FIQ", 726 },
    { "SPSR_IRQ", 727 },
    { "SPSR_UND", 728 },
    { "SP_EL0", 729 },
    { "SP_EL1", 730 },
    { "SP_EL2", 731 },
    { "SSBS", 732 },
    { "SVCR", 733 },
    { "TCO", 734 },
    { "TCR_EL1", 735 },
    { "TCR_EL12", 736 },
    { "TCR_EL2", 737 },
    { "TCR_EL3", 738 },
    { "TEECR32_EL1", 739 },
    { "TEEHBR32_EL1", 740 },
    { "TFSRE0_EL1", 741 },
    { "TFSR_EL1", 742 },
    { "TFSR_EL12", 743 },
    { "TFSR_EL2", 744 },
    { "TFSR_EL3", 745 },
    { "TPIDR2_EL0", 746 },
    { "TPIDRRO_EL0", 747 },
    { "TPIDR_EL0", 748 },
    { "TPIDR_EL1", 749 },
    { "TPIDR_EL2", 750 },
    { "TPIDR_EL3", 751 },
    { "TRBBASER_EL1", 752 },
    { "TRBIDR_EL1", 753 },
    { "TRBLIMITR_EL1", 754 },
    { "TRBMAR_EL1", 755 },
    { "TRBPTR_EL1", 756 },
    { "TRBSR_EL1", 757 },
    { "TRBTRG_EL1", 758 },
    { "TRCACATR0", 759 },
    { "TRCACATR1", 760 },
    { "TRCACATR10", 761 },
    { "TRCACATR11", 762 },
    { "TRCACATR12", 763 },
    { "TRCACATR13", 764 },
    { "TRCACATR14", 765 },
    { "TRCACATR15", 766 },
    { "TRCACATR2", 767 },
    { "TRCACATR3", 768 },
    { "TRCACATR4", 769 },
    { "TRCACATR5", 770 },
    { "TRCACATR6", 771 },
    { "TRCACATR7", 772 },
    { "TRCACATR8", 773 },
    { "TRCACATR9", 774 },
    { "TRCACVR0", 775 },
    { "TRCACVR1", 776 },
    { "TRCACVR10", 777 },
    { "TRCACVR11", 778 },
    { "TRCACVR12", 779 },
    { "TRCACVR13", 780 },
    { "TRCACVR14", 781 },
    { "TRCACVR15", 782 },
    { "TRCACVR2", 783 },
    { "TRCACVR3", 784 },
    { "TRCACVR4", 785 },
    { "TRCACVR5", 786 },
    { "TRCACVR6", 787 },
    { "TRCACVR7", 788 },
    { "TRCACVR8", 789 },
    { "TRCACVR9", 790 },
    { "TRCAUTHSTATUS", 791 },
    { "TRCAUXCTLR", 792 },
    { "TRCBBCTLR", 793 },
    { "TRCCCCTLR", 794 },
    { "TRCCIDCCTLR0", 795 },
    { "TRCCIDCCTLR1", 796 },
    { "TRCCIDCVR0", 797 },
    { "TRCCIDCVR1", 798 },
    { "TRCCIDCVR2", 799 },
    { "TRCCIDCVR3", 800 },
    { "TRCCIDCVR4", 801 },
    { "TRCCIDCVR5", 802 },
    { "TRCCIDCVR6", 803 },
    { "TRCCIDCVR7", 804 },
    { "TRCCIDR0", 805 },
    { "TRCCIDR1", 806 },
    { "TRCCIDR2", 807 },
    { "TRCCIDR3", 808 },
    { "TRCCLAIMCLR", 809 },
    { "TRCCLAIMSET", 810 },
    { "TRCCNTCTLR0", 811 },
    { "TRCCNTCTLR1", 812 },
    { "TRCCNTCTLR2", 813 },
    { "TRCCNTCTLR3", 814 },
    { "TRCCNTRLDVR0", 815 },
    { "TRCCNTRLDVR1", 816 },
    { "TRCCNTRLDVR2", 817 },
    { "TRCCNTRLDVR3", 818 },
    { "TRCCNTVR0", 819 },
    { "TRCCNTVR1", 820 },
    { "TRCCNTVR2", 821 },
    { "TRCCNTVR3", 822 },
    { "TRCCONFIGR", 823 },
    { "TRCDEVAFF0", 824 },
    { "TRCDEVAFF1", 825 },
    { "TRCDEVARCH", 826 },
    { "TRCDEVID", 827 },
    { "TRCDEVTYPE", 828 },
    { "TRCDVCMR0", 829 },
    { "TRCDVCMR1", 830 },
    { "TRCDVCMR2", 831 },
    { "TRCDVCMR3", 832 },
    { "TRCDVCMR4", 833 },
    { "TRCDVCMR5", 834 },
    { "TRCDVCMR6", 835 },
    { "TRCDVCMR7", 836 },
    { "TRCDVCVR0", 837 },
    { "TRCDVCVR1", 838 },
    { "TRCDVCVR2", 839 },
    { "TRCDVCVR3", 840 },
    { "TRCDVCVR4", 841 },
    { "TRCDVCVR5", 842 },
    { "TRCDVCVR6", 843 },
    { "TRCDVCVR7", 844 },
    { "TRCEVENTCTL0R", 845 },
    { "TRCEVENTCTL1R", 846 },
    { "TRCEXTINSELR", 847 },
    { "TRCEXTINSELR0", 848 },
    { "TRCEXTINSELR1", 849 },
    { "TRCEXTINSELR2", 850 },
    { "TRCEXTINSELR3", 851 },
    { "TRCIDR0", 852 },
    { "TRCIDR1", 853 },
    { "TRCIDR10", 854 },
    { "TRCIDR11", 855 },
    { "TRCIDR12", 856 },
    { "TRCIDR13", 857 },
    { "TRCIDR2", 858 },
    { "TRCIDR3", 859 },
    { "TRCIDR4", 860 },
    { "TRCIDR5", 861 },
    { "TRCIDR6", 862 },
    { "TRCIDR7", 863 },
    { "TRCIDR8", 864 },
    { "TRCIDR9", 865 },
    { "TRCIMSPEC0", 866 },
    { "TRCIMSPEC1", 867 },
    { "TRCIMSPEC2", 868 },
    { "TRCIMSPEC3", 869 },
    { "TRCIMSPEC4", 870 },
    { "TRCIMSPEC5", 871 },
    { "TRCIMSPEC6", 872 },
    { "TRCIMSPEC7", 873 },
    { "TRCITCTRL", 874 },
    { "TRCLAR", 875 },
    { "TRCLSR", 876 },
    { "TRCOSLAR", 877 },
    { "TRCOSLSR", 878 },
    { "TRCPDCR", 879 },
    { "TRCPDSR", 880 },
    { "TRCPIDR0", 881 },
    { "TRCPIDR1", 882 },
    { "TRCPIDR2", 883 },
    { "TRCPIDR3", 884 },
    { "TRCPIDR4", 885 },
    { "TRCPIDR5", 886 },
    { "TRCPIDR6", 887 },
    { "TRCPIDR7", 888 },
    { "TRCPRGCTLR", 889 },
    { "TRCPROCSELR", 890 },
    { "TRCQCTLR", 891 },
    { "TRCRSCTLR10", 892 },
    { "TRCRSCTLR11", 893 },
    { "TRCRSCTLR12", 894 },
    { "TRCRSCTLR13", 895 },
    { "TRCRSCTLR14", 896 },
    { "TRCRSCTLR15", 897 },
    { "TRCRSCTLR16", 898 },
    { "TRCRSCTLR17", 899 },
    { "TRCRSCTLR18", 900 },
    { "TRCRSCTLR19", 901 },
    { "TRCRSCTLR2", 902 },
    { "TRCRSCTLR20", 903 },
    { "TRCRSCTLR21", 904 },
    { "TRCRSCTLR22", 905 },
    { "TRCRSCTLR23", 906 },
    { "TRCRSCTLR24", 907 },
    { "TRCRSCTLR25", 908 },
    { "TRCRSCTLR26", 909 },
    { "TRCRSCTLR27", 910 },
    { "TRCRSCTLR28", 911 },
    { "TRCRSCTLR29", 912 },
    { "TRCRSCTLR3", 913 },
    { "TRCRSCTLR30", 914 },
    { "TRCRSCTLR31", 915 },
    { "TRCRSCTLR4", 916 },
    { "TRCRSCTLR5", 917 },
    { "TRCRSCTLR6", 918 },
    { "TRCRSCTLR7", 919 },
    { "TRCRSCTLR8", 920 },
    { "TRCRSCTLR9", 921 },
    { "TRCRSR", 922 },
    { "TRCSEQEVR0", 923 },
    { "TRCSEQEVR1", 924 },
    { "TRCSEQEVR2", 925 },
    { "TRCSEQRSTEVR", 926 },
    { "TRCSEQSTR", 927 },
    { "TRCSSCCR0", 928 },
    { "TRCSSCCR1", 929 },
    { "TRCSSCCR2", 930 },
    { "TRCSSCCR3", 931 },
    { "TRCSSCCR4", 932 },
    { "TRCSSCCR5", 933 },
    { "TRCSSCCR6", 934 },
    { "TRCSSCCR7", 935 },
    { "TRCSSCSR0", 936 },
    { "TRCSSCSR1", 937 },
    { "TRCSSCSR2", 938 },
    { "TRCSSCSR3", 939 },
    { "TRCSSCSR4", 940 },
    { "TRCSSCSR5", 941 },
    { "TRCSSCSR6", 942 },
    { "TRCSSCSR7", 943 },
    { "TRCSSPCICR0", 944 },
    { "TRCSSPCICR1", 945 },
    { "TRCSSPCICR2", 946 },
    { "TRCSSPCICR3", 947 },
    { "TRCSSPCICR4", 948 },
    { "TRCSSPCICR5", 949 },
    { "TRCSSPCICR6", 950 },
    { "TRCSSPCICR7", 951 },
    { "TRCSTALLCTLR", 952 },
    { "TRCSTATR", 953 },
    { "TRCSYNCPR", 954 },
    { "TRCTRACEIDR", 955 },
    { "TRCTSCTLR", 956 },
    { "TRCVDARCCTLR", 957 },
    { "TRCVDCTLR", 958 },
    { "TRCVDSACCTLR", 959 },
    { "TRCVICTLR", 960 },
    { "TRCVIIECTLR", 961 },
    { "TRCVIPCSSCTLR", 962 },
    { "TRCVISSCTLR", 963 },
    { "TRCVMIDCCTLR0", 964 },
    { "TRCVMIDCCTLR1", 965 },
    { "TRCVMIDCVR0", 966 },
    { "TRCVMIDCVR1", 967 },
    { "TRCVMIDCVR2", 968 },
    { "TRCVMIDCVR3", 969 },
    { "TRCVMIDCVR4", 970 },
    { "TRCVMIDCVR5", 971 },
    { "TRCVMIDCVR6", 972 },
    { "TRCVMIDCVR7", 973 },
    { "TRFCR_EL1", 974 },
    { "TRFCR_EL12", 975 },
    { "TRFCR_EL2", 976 },
    { "TTBR0_EL1", 977 },
    { "TTBR0_EL12", 978 },
    { "TTBR0_EL2", 979 },
    { "TTBR0_EL3", 980 },
    { "TTBR1_EL1", 981 },
    { "TTBR1_EL12", 982 },
    { "TTBR1_EL2", 983 },
    { "UAO", 984 },
    { "VBAR_EL1", 985 },
    { "VBAR_EL12", 986 },
    { "VBAR_EL2", 987 },
    { "VBAR_EL3", 988 },
    { "VDISR_EL2", 989 },
    { "VMPIDR_EL2", 990 },
    { "VNCR_EL2", 991 },
    { "VPIDR_EL2", 992 },
    { "VSCTLR_EL2", 993 },
    { "VSESR_EL2", 994 },
    { "VSTCR_EL2", 995 },
    { "VSTTBR_EL2", 996 },
    { "VTCR_EL2", 997 },
    { "VTTBR_EL2", 998 },
    { "ZCR_EL1", 999 },
    { "ZCR_EL12", 1000 },
    { "ZCR_EL2", 1001 },
    { "ZCR_EL3", 1002 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &SysRegsList[Idx->_index];
}

const SysReg *lookupSysRegByEncoding(uint16_t Encoding) {
  struct IndexType {
    uint16_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x8002, 523 },
    { 0x8004, 285 },
    { 0x8005, 269 },
    { 0x8006, 324 },
    { 0x8007, 308 },
    { 0x800C, 292 },
    { 0x800D, 276 },
    { 0x800E, 331 },
    { 0x800F, 315 },
    { 0x8010, 490 },
    { 0x8012, 495 },
    { 0x8014, 293 },
    { 0x8015, 277 },
    { 0x8016, 332 },
    { 0x8017, 316 },
    { 0x801A, 524 },
    { 0x801C, 294 },
    { 0x801D, 278 },
    { 0x801E, 333 },
    { 0x801F, 317 },
    { 0x8024, 295 },
    { 0x8025, 279 },
    { 0x8026, 334 },
    { 0x8027, 318 },
    { 0x802C, 296 },
    { 0x802D, 280 },
    { 0x802E, 335 },
    { 0x802F, 319 },
    { 0x8032, 525 },
    { 0x8034, 297 },
    { 0x8035, 281 },
    { 0x8036, 336 },
    { 0x8037, 320 },
    { 0x803C, 298 },
    { 0x803D, 282 },
    { 0x803E, 337 },
    { 0x803F, 321 },
    { 0x8044, 299 },
    { 0x8045, 283 },
    { 0x8046, 338 },
    { 0x8047, 322 },
    { 0x804C, 300 },
    { 0x804D, 284 },
    { 0x804E, 339 },
    { 0x804F, 323 },
    { 0x8054, 286 },
    { 0x8055, 270 },
    { 0x8056, 325 },
    { 0x8057, 309 },
    { 0x805C, 287 },
    { 0x805D, 271 },
    { 0x805E, 326 },
    { 0x805F, 310 },
    { 0x8064, 288 },
    { 0x8065, 272 },
    { 0x8066, 327 },
    { 0x8067, 311 },
    { 0x806C, 289 },
    { 0x806D, 273 },
    { 0x806E, 328 },
    { 0x806F, 312 },
    { 0x8074, 290 },
    { 0x8075, 274 },
    { 0x8076, 329 },
    { 0x8077, 313 },
    { 0x807C, 291 },
    { 0x807D, 275 },
    { 0x807E, 330 },
    { 0x807F, 314 },
    { 0x8080, 494 },
    { 0x8084, 526 },
    { 0x808C, 527 },
    { 0x809C, 522 },
    { 0x80A4, 306 },
    { 0x83C6, 302 },
    { 0x83CE, 301 },
    { 0x83F6, 268 },
    { 0x8801, 955 },
    { 0x8802, 960 },
    { 0x8804, 923 },
    { 0x8805, 815 },
    { 0x8806, 864 },
    { 0x8807, 866 },
    { 0x8808, 889 },
    { 0x8809, 891 },
    { 0x880A, 961 },
    { 0x880C, 924 },
    { 0x880D, 816 },
    { 0x880E, 865 },
    { 0x880F, 867 },
    { 0x8810, 890 },
    { 0x8812, 963 },
    { 0x8814, 925 },
    { 0x8815, 817 },
    { 0x8816, 854 },
    { 0x8817, 868 },
    { 0x8818, 953 },
    { 0x881A, 962 },
    { 0x881D, 818 },
    { 0x881E, 855 },
    { 0x881F, 869 },
    { 0x8820, 823 },
    { 0x8825, 811 },
    { 0x8826, 856 },
    { 0x8827, 870 },
    { 0x882D, 812 },
    { 0x882E, 857 },
    { 0x882F, 871 },
    { 0x8830, 792 },
    { 0x8834, 926 },
    { 0x8835, 813 },
    { 0x8837, 872 },
    { 0x883C, 927 },
    { 0x883D, 814 },
    { 0x883F, 873 },
    { 0x8840, 845 },
    { 0x8842, 958 },
    { 0x8844, 847 },
    { 0x8844, 848 },
    { 0x8845, 819 },
    { 0x8847, 852 },
    { 0x8848, 846 },
    { 0x884A, 959 },
    { 0x884C, 849 },
    { 0x884D, 820 },
    { 0x884F, 853 },
    { 0x8850, 922 },
    { 0x8852, 957 },
    { 0x8854, 850 },
    { 0x8855, 821 },
    { 0x8857, 858 },
    { 0x8858, 952 },
    { 0x885C, 851 },
    { 0x885D, 822 },
    { 0x885F, 859 },
    { 0x8860, 956 },
    { 0x8867, 860 },
    { 0x8868, 954 },
    { 0x886F, 861 },
    { 0x8870, 794 },
    { 0x8877, 862 },
    { 0x8878, 793 },
    { 0x887F, 863 },
    { 0x8881, 898 },
    { 0x8882, 928 },
    { 0x8883, 944 },
    { 0x8884, 877 },
    { 0x8889, 899 },
    { 0x888A, 929 },
    { 0x888B, 945 },
    { 0x888C, 878 },
    { 0x8890, 902 },
    { 0x8891, 900 },
    { 0x8892, 930 },
    { 0x8893, 946 },
    { 0x8898, 913 },
    { 0x8899, 901 },
    { 0x889A, 931 },
    { 0x889B, 947 },
    { 0x88A0, 916 },
    { 0x88A1, 903 },
    { 0x88A2, 932 },
    { 0x88A3, 948 },
    { 0x88A4, 879 },
    { 0x88A8, 917 },
    { 0x88A9, 904 },
    { 0x88AA, 933 },
    { 0x88AB, 949 },
    { 0x88AC, 880 },
    { 0x88B0, 918 },
    { 0x88B1, 905 },
    { 0x88B2, 934 },
    { 0x88B3, 950 },
    { 0x88B8, 919 },
    { 0x88B9, 906 },
    { 0x88BA, 935 },
    { 0x88BB, 951 },
    { 0x88C0, 920 },
    { 0x88C1, 907 },
    { 0x88C2, 936 },
    { 0x88C8, 921 },
    { 0x88C9, 908 },
    { 0x88CA, 937 },
    { 0x88D0, 892 },
    { 0x88D1, 909 },
    { 0x88D2, 938 },
    { 0x88D8, 893 },
    { 0x88D9, 910 },
    { 0x88DA, 939 },
    { 0x88E0, 894 },
    { 0x88E1, 911 },
    { 0x88E2, 940 },
    { 0x88E8, 895 },
    { 0x88E9, 912 },
    { 0x88EA, 941 },
    { 0x88F0, 896 },
    { 0x88F1, 914 },
    { 0x88F2, 942 },
    { 0x88F8, 897 },
    { 0x88F9, 915 },
    { 0x88FA, 943 },
    { 0x8900, 775 },
    { 0x8901, 789 },
    { 0x8902, 759 },
    { 0x8903, 773 },
    { 0x8904, 837 },
    { 0x8905, 841 },
    { 0x8906, 829 },
    { 0x8907, 833 },
    { 0x8910, 776 },
    { 0x8911, 790 },
    { 0x8912, 760 },
    { 0x8913, 774 },
    { 0x8920, 783 },
    { 0x8921, 777 },
    { 0x8922, 767 },
    { 0x8923, 761 },
    { 0x8924, 838 },
    { 0x8925, 842 },
    { 0x8926, 830 },
    { 0x8927, 834 },
    { 0x8930, 784 },
    { 0x8931, 778 },
    { 0x8932, 768 },
    { 0x8933, 762 },
    { 0x8940, 785 },
    { 0x8941, 779 },
    { 0x8942, 769 },
    { 0x8943, 763 },
    { 0x8944, 839 },
    { 0x8945, 843 },
    { 0x8946, 831 },
    { 0x8947, 835 },
    { 0x8950, 786 },
    { 0x8951, 780 },
    { 0x8952, 770 },
    { 0x8953, 764 },
    { 0x8960, 787 },
    { 0x8961, 781 },
    { 0x8962, 771 },
    { 0x8963, 765 },
    { 0x8964, 840 },
    { 0x8965, 844 },
    { 0x8966, 832 },
    { 0x8967, 836 },
    { 0x8970, 788 },
    { 0x8971, 782 },
    { 0x8972, 772 },
    { 0x8973, 766 },
    { 0x8980, 797 },
    { 0x8981, 966 },
    { 0x8982, 795 },
    { 0x898A, 796 },
    { 0x8990, 798 },
    { 0x8991, 967 },
    { 0x8992, 964 },
    { 0x899A, 965 },
    { 0x89A0, 799 },
    { 0x89A1, 968 },
    { 0x89B0, 800 },
    { 0x89B1, 969 },
    { 0x89C0, 801 },
    { 0x89C1, 970 },
    { 0x89D0, 802 },
    { 0x89D1, 971 },
    { 0x89E0, 803 },
    { 0x89E1, 972 },
    { 0x89F0, 804 },
    { 0x89F1, 973 },
    { 0x8B84, 874 },
    { 0x8B97, 827 },
    { 0x8B9F, 828 },
    { 0x8BA7, 885 },
    { 0x8BAF, 886 },
    { 0x8BB7, 887 },
    { 0x8BBF, 888 },
    { 0x8BC6, 810 },
    { 0x8BC7, 881 },
    { 0x8BCE, 809 },
    { 0x8BCF, 882 },
    { 0x8BD6, 824 },
    { 0x8BD7, 883 },
    { 0x8BDE, 825 },
    { 0x8BDF, 884 },
    { 0x8BE6, 875 },
    { 0x8BE7, 805 },
    { 0x8BEE, 876 },
    { 0x8BEF, 806 },
    { 0x8BF6, 791 },
    { 0x8BF7, 807 },
    { 0x8BFE, 826 },
    { 0x8BFF, 808 },
    { 0x8C00, 112 },
    { 0x8C01, 145 },
    { 0x8C02, 178 },
    { 0x8C04, 119 },
    { 0x8C05, 152 },
    { 0x8C06, 185 },
    { 0x8C08, 123 },
    { 0x8C09, 156 },
    { 0x8C0A, 189 },
    { 0x8C0C, 120 },
    { 0x8C0D, 153 },
    { 0x8C0E, 186 },
    { 0x8C10, 134 },
    { 0x8C11, 167 },
    { 0x8C12, 200 },
    { 0x8C14, 121 },
    { 0x8C15, 154 },
    { 0x8C16, 187 },
    { 0x8C18, 137 },
    { 0x8C19, 170 },
    { 0x8C1A, 203 },
    { 0x8C1C, 122 },
    { 0x8C1D, 155 },
    { 0x8C1E, 188 },
    { 0x8C20, 138 },
    { 0x8C21, 171 },
    { 0x8C22, 204 },
    { 0x8C24, 124 },
    { 0x8C25, 157 },
    { 0x8C26, 190 },
    { 0x8C28, 139 },
    { 0x8C29, 172 },
    { 0x8C2A, 205 },
    { 0x8C2C, 125 },
    { 0x8C2D, 158 },
    { 0x8C2E, 191 },
    { 0x8C30, 140 },
    { 0x8C31, 173 },
    { 0x8C32, 206 },
    { 0x8C34, 126 },
    { 0x8C35, 159 },
    { 0x8C36, 192 },
    { 0x8C38, 141 },
    { 0x8C39, 174 },
    { 0x8C3A, 207 },
    { 0x8C3C, 127 },
    { 0x8C3D, 160 },
    { 0x8C3E, 193 },
    { 0x8C40, 142 },
    { 0x8C41, 175 },
    { 0x8C42, 208 },
    { 0x8C44, 128 },
    { 0x8C45, 161 },
    { 0x8C46, 194 },
    { 0x8C48, 143 },
    { 0x8C49, 176 },
    { 0x8C4A, 209 },
    { 0x8C4C, 129 },
    { 0x8C4D, 162 },
    { 0x8C4E, 195 },
    { 0x8C50, 113 },
    { 0x8C51, 146 },
    { 0x8C52, 179 },
    { 0x8C54, 130 },
    { 0x8C55, 163 },
    { 0x8C56, 196 },
    { 0x8C58, 114 },
    { 0x8C59, 147 },
    { 0x8C5A, 180 },
    { 0x8C5C, 131 },
    { 0x8C5D, 164 },
    { 0x8C5E, 197 },
    { 0x8C60, 115 },
    { 0x8C61, 148 },
    { 0x8C62, 181 },
    { 0x8C64, 132 },
    { 0x8C65, 165 },
    { 0x8C66, 198 },
    { 0x8C68, 116 },
    { 0x8C69, 149 },
    { 0x8C6A, 182 },
    { 0x8C6C, 133 },
    { 0x8C6D, 166 },
    { 0x8C6E, 199 },
    { 0x8C70, 117 },
    { 0x8C71, 150 },
    { 0x8C72, 183 },
    { 0x8C74, 135 },
    { 0x8C75, 168 },
    { 0x8C76, 201 },
    { 0x8C78, 118 },
    { 0x8C79, 151 },
    { 0x8C7A, 184 },
    { 0x8C7C, 136 },
    { 0x8C7D, 169 },
    { 0x8C7E, 202 },
    { 0x8C80, 107 },
    { 0x8C81, 110 },
    { 0x8C82, 211 },
    { 0x8C88, 144 },
    { 0x8C89, 177 },
    { 0x8C8A, 210 },
    { 0x8C90, 111 },
    { 0x9000, 739 },
    { 0x9080, 740 },
    { 0x9808, 491 },
    { 0x9820, 305 },
    { 0x9828, 303 },
    { 0x9828, 304 },
    { 0xA038, 307 },
    { 0xA480, 109 },
    { 0xAC80, 108 },
    { 0xC000, 497 },
    { 0xC004, 516 },
    { 0xC005, 515 },
    { 0xC006, 691 },
    { 0xC008, 476 },
    { 0xC009, 477 },
    { 0xC00A, 462 },
    { 0xC00B, 461 },
    { 0xC00C, 470 },
    { 0xC00D, 471 },
    { 0xC00E, 472 },
    { 0xC00F, 473 },
    { 0xC010, 463 },
    { 0xC011, 464 },
    { 0xC012, 465 },
    { 0xC013, 466 },
    { 0xC014, 467 },
    { 0xC015, 468 },
    { 0xC016, 474 },
    { 0xC017, 469 },
    { 0xC018, 518 },
    { 0xC019, 519 },
    { 0xC01A, 520 },
    { 0xC01C, 478 },
    { 0xC01E, 475 },
    { 0xC020, 457 },
    { 0xC021, 458 },
    { 0xC024, 460 },
    { 0xC025, 459 },
    { 0xC028, 449 },
    { 0xC029, 450 },
    { 0xC02C, 447 },
    { 0xC02D, 448 },
    { 0xC030, 451 },
    { 0xC031, 452 },
    { 0xC032, 453 },
    { 0xC038, 454 },
    { 0xC039, 455 },
    { 0xC03A, 456 },
    { 0xC080, 702 },
    { 0xC081, 1 },
    { 0xC082, 258 },
    { 0xC085, 692 },
    { 0xC086, 373 },
    { 0xC090, 999 },
    { 0xC091, 974 },
    { 0xC094, 719 },
    { 0xC096, 713 },
    { 0xC100, 977 },
    { 0xC101, 981 },
    { 0xC102, 735 },
    { 0xC108, 104 },
    { 0xC109, 103 },
    { 0xC10A, 106 },
    { 0xC10B, 105 },
    { 0xC110, 98 },
    { 0xC111, 97 },
    { 0xC112, 100 },
    { 0xC113, 99 },
    { 0xC118, 102 },
    { 0xC119, 101 },
    { 0xC200, 722 },
    { 0xC201, 345 },
    { 0xC208, 729 },
    { 0xC210, 720 },
    { 0xC212, 265 },
    { 0xC213, 528 },
    { 0xC214, 984 },
    { 0xC230, 410 },
    { 0xC288, 4 },
    { 0xC289, 8 },
    { 0xC290, 362 },
    { 0xC298, 349 },
    { 0xC299, 350 },
    { 0xC2A0, 353 },
    { 0xC2A1, 352 },
    { 0xC2A2, 361 },
    { 0xC2A3, 351 },
    { 0xC2A4, 360 },
    { 0xC2A5, 359 },
    { 0xC2A6, 358 },
    { 0xC2A8, 354 },
    { 0xC2A9, 355 },
    { 0xC2AA, 356 },
    { 0xC2AB, 357 },
    { 0xC2B0, 742 },
    { 0xC2B1, 741 },
    { 0xC300, 366 },
    { 0xC309, 655 },
    { 0xC311, 689 },
    { 0xC340, 653 },
    { 0xC341, 687 },
    { 0xC344, 635 },
    { 0xC345, 669 },
    { 0xC348, 637 },
    { 0xC349, 671 },
    { 0xC34C, 639 },
    { 0xC34D, 673 },
    { 0xC350, 641 },
    { 0xC351, 675 },
    { 0xC354, 643 },
    { 0xC355, 677 },
    { 0xC358, 645 },
    { 0xC359, 679 },
    { 0xC35C, 647 },
    { 0xC35D, 681 },
    { 0xC360, 649 },
    { 0xC361, 683 },
    { 0xC364, 651 },
    { 0xC365, 685 },
    { 0xC368, 623 },
    { 0xC369, 657 },
    { 0xC36C, 625 },
    { 0xC36D, 659 },
    { 0xC370, 627 },
    { 0xC371, 661 },
    { 0xC374, 629 },
    { 0xC375, 663 },
    { 0xC378, 631 },
    { 0xC379, 665 },
    { 0xC37C, 633 },
    { 0xC37D, 667 },
    { 0xC3A0, 529 },
    { 0xC4C8, 608 },
    { 0xC4C9, 618 },
    { 0xC4CA, 614 },
    { 0xC4CB, 616 },
    { 0xC4CC, 613 },
    { 0xC4CD, 612 },
    { 0xC4CE, 617 },
    { 0xC4CF, 615 },
    { 0xC4D0, 531 },
    { 0xC4D1, 532 },
    { 0xC4D3, 533 },
    { 0xC4D7, 530 },
    { 0xC4D8, 754 },
    { 0xC4D9, 756 },
    { 0xC4DA, 752 },
    { 0xC4DB, 757 },
    { 0xC4DC, 755 },
    { 0xC4DE, 758 },
    { 0xC4DF, 753 },
    { 0xC4F1, 604 },
    { 0xC4F2, 603 },
    { 0xC4F6, 605 },
    { 0xC510, 486 },
    { 0xC518, 13 },
    { 0xC520, 485 },
    { 0xC521, 482 },
    { 0xC522, 484 },
    { 0xC523, 481 },
    { 0xC524, 504 },
    { 0xC527, 483 },
    { 0xC528, 499 },
    { 0xC529, 498 },
    { 0xC52B, 505 },
    { 0xC600, 985 },
    { 0xC601, 698 },
    { 0xC602, 693 },
    { 0xC608, 480 },
    { 0xC609, 341 },
    { 0xC640, 405 },
    { 0xC641, 401 },
    { 0xC642, 403 },
    { 0xC643, 396 },
    { 0xC644, 387 },
    { 0xC645, 388 },
    { 0xC646, 389 },
    { 0xC647, 390 },
    { 0xC648, 391 },
    { 0xC649, 392 },
    { 0xC64A, 393 },
    { 0xC64B, 394 },
    { 0xC659, 400 },
    { 0xC65B, 411 },
    { 0xC65D, 413 },
    { 0xC65E, 395 },
    { 0xC65F, 412 },
    { 0xC660, 406 },
    { 0xC661, 402 },
    { 0xC662, 404 },
    { 0xC663, 397 },
    { 0xC664, 398 },
    { 0xC665, 414 },
    { 0xC666, 407 },
    { 0xC667, 408 },
    { 0xC681, 255 },
    { 0xC684, 749 },
    { 0xC685, 0 },
    { 0xC687, 707 },
    { 0xC708, 230 },
    { 0xC800, 213 },
    { 0xC801, 214 },
    { 0xC802, 212 },
    { 0xC804, 374 },
    { 0xC806, 717 },
    { 0xC807, 12 },
    { 0xD000, 263 },
    { 0xD801, 264 },
    { 0xD807, 340 },
    { 0xD920, 696 },
    { 0xD921, 697 },
    { 0xDA10, 521 },
    { 0xDA11, 267 },
    { 0xDA12, 733 },
    { 0xDA15, 342 },
    { 0xDA16, 732 },
    { 0xDA17, 734 },
    { 0xDA20, 370 },
    { 0xDA21, 372 },
    { 0xDA28, 344 },
    { 0xDA29, 343 },
    { 0xDCE0, 540 },
    { 0xDCE1, 539 },
    { 0xDCE2, 538 },
    { 0xDCE3, 606 },
    { 0xDCE4, 619 },
    { 0xDCE5, 611 },
    { 0xDCE6, 536 },
    { 0xDCE7, 537 },
    { 0xDCE8, 535 },
    { 0xDCE9, 622 },
    { 0xDCEA, 621 },
    { 0xDCF0, 620 },
    { 0xDCF3, 607 },
    { 0xDE82, 748 },
    { 0xDE83, 747 },
    { 0xDE85, 746 },
    { 0xDE87, 706 },
    { 0xDE90, 23 },
    { 0xDE91, 17 },
    { 0xDE92, 18 },
    { 0xDE93, 96 },
    { 0xDE94, 19 },
    { 0xDE95, 21 },
    { 0xDE98, 20 },
    { 0xDE99, 22 },
    { 0xDEA0, 24 },
    { 0xDEA1, 25 },
    { 0xDEA2, 26 },
    { 0xDEA3, 27 },
    { 0xDEB0, 76 },
    { 0xDEB1, 77 },
    { 0xDEB2, 78 },
    { 0xDEB3, 79 },
    { 0xDEE0, 28 },
    { 0xDEE1, 35 },
    { 0xDEE2, 36 },
    { 0xDEE3, 37 },
    { 0xDEE4, 38 },
    { 0xDEE5, 39 },
    { 0xDEE6, 40 },
    { 0xDEE7, 41 },
    { 0xDEE8, 42 },
    { 0xDEE9, 43 },
    { 0xDEEA, 29 },
    { 0xDEEB, 30 },
    { 0xDEEC, 31 },
    { 0xDEED, 32 },
    { 0xDEEE, 33 },
    { 0xDEEF, 34 },
    { 0xDEF0, 80 },
    { 0xDEF1, 87 },
    { 0xDEF2, 88 },
    { 0xDEF3, 89 },
    { 0xDEF4, 90 },
    { 0xDEF5, 91 },
    { 0xDEF6, 92 },
    { 0xDEF7, 93 },
    { 0xDEF8, 94 },
    { 0xDEF9, 95 },
    { 0xDEFA, 81 },
    { 0xDEFB, 82 },
    { 0xDEFC, 83 },
    { 0xDEFD, 84 },
    { 0xDEFE, 85 },
    { 0xDEFF, 86 },
    { 0xDF00, 215 },
    { 0xDF01, 233 },
    { 0xDF02, 246 },
    { 0xDF05, 232 },
    { 0xDF06, 245 },
    { 0xDF10, 242 },
    { 0xDF11, 238 },
    { 0xDF12, 240 },
    { 0xDF18, 253 },
    { 0xDF19, 249 },
    { 0xDF1A, 251 },
    { 0xDF40, 541 },
    { 0xDF41, 552 },
    { 0xDF42, 563 },
    { 0xDF43, 565 },
    { 0xDF44, 566 },
    { 0xDF45, 567 },
    { 0xDF46, 568 },
    { 0xDF47, 569 },
    { 0xDF48, 570 },
    { 0xDF49, 571 },
    { 0xDF4A, 542 },
    { 0xDF4B, 543 },
    { 0xDF4C, 544 },
    { 0xDF4D, 545 },
    { 0xDF4E, 546 },
    { 0xDF4F, 547 },
    { 0xDF50, 548 },
    { 0xDF51, 549 },
    { 0xDF52, 550 },
    { 0xDF53, 551 },
    { 0xDF54, 553 },
    { 0xDF55, 554 },
    { 0xDF56, 555 },
    { 0xDF57, 556 },
    { 0xDF58, 557 },
    { 0xDF59, 558 },
    { 0xDF5A, 559 },
    { 0xDF5B, 560 },
    { 0xDF5C, 561 },
    { 0xDF5D, 562 },
    { 0xDF5E, 564 },
    { 0xDF60, 572 },
    { 0xDF61, 583 },
    { 0xDF62, 594 },
    { 0xDF63, 596 },
    { 0xDF64, 597 },
    { 0xDF65, 598 },
    { 0xDF66, 599 },
    { 0xDF67, 600 },
    { 0xDF68, 601 },
    { 0xDF69, 602 },
    { 0xDF6A, 573 },
    { 0xDF6B, 574 },
    { 0xDF6C, 575 },
    { 0xDF6D, 576 },
    { 0xDF6E, 577 },
    { 0xDF6F, 578 },
    { 0xDF70, 579 },
    { 0xDF71, 580 },
    { 0xDF72, 581 },
    { 0xDF73, 582 },
    { 0xDF74, 584 },
    { 0xDF75, 585 },
    { 0xDF76, 586 },
    { 0xDF77, 587 },
    { 0xDF78, 588 },
    { 0xDF79, 589 },
    { 0xDF7A, 590 },
    { 0xDF7B, 591 },
    { 0xDF7C, 592 },
    { 0xDF7D, 593 },
    { 0xDF7E, 595 },
    { 0xDF7F, 534 },
    { 0xE000, 992 },
    { 0xE004, 517 },
    { 0xE005, 990 },
    { 0xE080, 704 },
    { 0xE081, 2 },
    { 0xE088, 379 },
    { 0xE089, 492 },
    { 0xE08A, 261 },
    { 0xE08B, 386 },
    { 0xE08C, 383 },
    { 0xE08D, 384 },
    { 0xE08E, 382 },
    { 0xE08F, 377 },
    { 0xE090, 1001 },
    { 0xE091, 976 },
    { 0xE092, 378 },
    { 0xE095, 718 },
    { 0xE096, 715 },
    { 0xE099, 711 },
    { 0xE100, 979 },
    { 0xE100, 993 },
    { 0xE101, 983 },
    { 0xE102, 737 },
    { 0xE108, 998 },
    { 0xE10A, 997 },
    { 0xE110, 991 },
    { 0xE130, 996 },
    { 0xE132, 995 },
    { 0xE180, 266 },
    { 0xE18C, 380 },
    { 0xE18D, 381 },
    { 0xE200, 724 },
    { 0xE201, 347 },
    { 0xE208, 730 },
    { 0xE218, 727 },
    { 0xE219, 721 },
    { 0xE21A, 728 },
    { 0xE21B, 726 },
    { 0xE281, 479 },
    { 0xE288, 6 },
    { 0xE289, 10 },
    { 0xE290, 364 },
    { 0xE293, 994 },
    { 0xE298, 371 },
    { 0xE2B0, 744 },
    { 0xE300, 368 },
    { 0xE304, 385 },
    { 0xE309, 656 },
    { 0xE311, 690 },
    { 0xE340, 654 },
    { 0xE341, 688 },
    { 0xE344, 636 },
    { 0xE345, 670 },
    { 0xE348, 638 },
    { 0xE349, 672 },
    { 0xE34C, 640 },
    { 0xE34D, 674 },
    { 0xE350, 642 },
    { 0xE351, 676 },
    { 0xE354, 644 },
    { 0xE355, 678 },
    { 0xE358, 646 },
    { 0xE359, 680 },
    { 0xE35C, 648 },
    { 0xE35D, 682 },
    { 0xE360, 650 },
    { 0xE361, 684 },
    { 0xE364, 652 },
    { 0xE365, 686 },
    { 0xE368, 624 },
    { 0xE369, 658 },
    { 0xE36C, 626 },
    { 0xE36D, 660 },
    { 0xE370, 628 },
    { 0xE371, 662 },
    { 0xE374, 630 },
    { 0xE375, 664 },
    { 0xE378, 632 },
    { 0xE379, 666 },
    { 0xE37C, 634 },
    { 0xE37D, 668 },
    { 0xE4C8, 610 },
    { 0xE510, 488 },
    { 0xE518, 15 },
    { 0xE520, 503 },
    { 0xE521, 514 },
    { 0xE528, 501 },
    { 0xE530, 506 },
    { 0xE531, 507 },
    { 0xE532, 508 },
    { 0xE533, 509 },
    { 0xE534, 510 },
    { 0xE535, 511 },
    { 0xE536, 512 },
    { 0xE537, 513 },
    { 0xE600, 987 },
    { 0xE601, 699 },
    { 0xE602, 694 },
    { 0xE609, 989 },
    { 0xE640, 417 },
    { 0xE641, 418 },
    { 0xE642, 419 },
    { 0xE643, 420 },
    { 0xE648, 421 },
    { 0xE649, 422 },
    { 0xE64A, 423 },
    { 0xE64B, 424 },
    { 0xE64D, 415 },
    { 0xE658, 427 },
    { 0xE659, 446 },
    { 0xE65A, 444 },
    { 0xE65B, 425 },
    { 0xE65D, 426 },
    { 0xE65F, 445 },
    { 0xE660, 428 },
    { 0xE661, 435 },
    { 0xE662, 436 },
    { 0xE663, 437 },
    { 0xE664, 438 },
    { 0xE665, 439 },
    { 0xE666, 440 },
    { 0xE667, 441 },
    { 0xE668, 442 },
    { 0xE669, 443 },
    { 0xE66A, 429 },
    { 0xE66B, 430 },
    { 0xE66C, 431 },
    { 0xE66D, 432 },
    { 0xE66E, 433 },
    { 0xE66F, 434 },
    { 0xE681, 257 },
    { 0xE682, 750 },
    { 0xE687, 709 },
    { 0xE6C0, 44 },
    { 0xE6C1, 51 },
    { 0xE6C2, 52 },
    { 0xE6C3, 53 },
    { 0xE6C4, 54 },
    { 0xE6C5, 55 },
    { 0xE6C6, 56 },
    { 0xE6C7, 57 },
    { 0xE6C8, 58 },
    { 0xE6C9, 59 },
    { 0xE6CA, 45 },
    { 0xE6CB, 46 },
    { 0xE6CC, 47 },
    { 0xE6CD, 48 },
    { 0xE6CE, 49 },
    { 0xE6CF, 50 },
    { 0xE6D0, 60 },
    { 0xE6D1, 67 },
    { 0xE6D2, 68 },
    { 0xE6D3, 69 },
    { 0xE6D4, 70 },
    { 0xE6D5, 71 },
    { 0xE6D6, 72 },
    { 0xE6D7, 73 },
    { 0xE6D8, 74 },
    { 0xE6D9, 75 },
    { 0xE6DA, 61 },
    { 0xE6DB, 62 },
    { 0xE6DC, 63 },
    { 0xE6DD, 64 },
    { 0xE6DE, 65 },
    { 0xE6DF, 66 },
    { 0xE703, 248 },
    { 0xE704, 244 },
    { 0xE705, 229 },
    { 0xE706, 234 },
    { 0xE707, 247 },
    { 0xE708, 216 },
    { 0xE710, 222 },
    { 0xE711, 220 },
    { 0xE712, 221 },
    { 0xE718, 228 },
    { 0xE719, 226 },
    { 0xE71A, 227 },
    { 0xE720, 225 },
    { 0xE721, 223 },
    { 0xE722, 224 },
    { 0xE728, 219 },
    { 0xE729, 217 },
    { 0xE72A, 218 },
    { 0xE880, 703 },
    { 0xE882, 259 },
    { 0xE890, 1000 },
    { 0xE891, 975 },
    { 0xE896, 714 },
    { 0xE900, 978 },
    { 0xE901, 982 },
    { 0xE902, 736 },
    { 0xEA00, 723 },
    { 0xEA01, 346 },
    { 0xEA88, 5 },
    { 0xEA89, 9 },
    { 0xEA90, 363 },
    { 0xEAB0, 743 },
    { 0xEB00, 367 },
    { 0xECC8, 609 },
    { 0xED10, 487 },
    { 0xED18, 14 },
    { 0xED28, 500 },
    { 0xEE00, 986 },
    { 0xEE81, 256 },
    { 0xEE87, 708 },
    { 0xEF08, 231 },
    { 0xEF10, 243 },
    { 0xEF11, 239 },
    { 0xEF12, 241 },
    { 0xEF18, 254 },
    { 0xEF19, 250 },
    { 0xEF1A, 252 },
    { 0xF080, 705 },
    { 0xF081, 3 },
    { 0xF088, 701 },
    { 0xF089, 712 },
    { 0xF08A, 262 },
    { 0xF090, 1002 },
    { 0xF096, 716 },
    { 0xF099, 493 },
    { 0xF100, 980 },
    { 0xF102, 738 },
    { 0xF10C, 376 },
    { 0xF10E, 375 },
    { 0xF200, 725 },
    { 0xF201, 348 },
    { 0xF208, 731 },
    { 0xF288, 7 },
    { 0xF289, 11 },
    { 0xF290, 365 },
    { 0xF2B0, 745 },
    { 0xF300, 369 },
    { 0xF305, 496 },
    { 0xF510, 489 },
    { 0xF518, 16 },
    { 0xF528, 502 },
    { 0xF600, 988 },
    { 0xF601, 700 },
    { 0xF602, 695 },
    { 0xF664, 399 },
    { 0xF665, 416 },
    { 0xF667, 409 },
    { 0xF682, 751 },
    { 0xF687, 710 },
    { 0xFF10, 237 },
    { 0xFF11, 235 },
    { 0xFF12, 236 },
    { 0xFF90, 260 },
  };

  struct KeyType {
    uint16_t Encoding;
  };
  KeyType Key = {Encoding};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Encoding < RHS.Encoding)
        return true;
      if (LHS.Encoding > RHS.Encoding)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Encoding != Idx->Encoding)
    return nullptr;
  return &SysRegsList[Idx->_index];
}
#endif

#ifdef GET_TSB_DECL
const TSB *lookupTSBByName(StringRef Name);
const TSB *lookupTSBByEncoding(uint8_t Encoding);
#endif

#ifdef GET_TSB_IMPL
constexpr TSB TSBsList[] = {
  { "csync", 0x0,  {AArch64::FeatureTRACEV8_4}  }, // 0
 };

const TSB *lookupTSBByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CSYNC", 0 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &TSBsList[Idx->_index];
}

const TSB *lookupTSBByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
  };

  auto Table = makeArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &TSBsList[Table[Idx]._index];
}
#endif

#undef GET_AT_DECL
#undef GET_AT_IMPL
#undef GET_BTI_DECL
#undef GET_BTI_IMPL
#undef GET_DBNXS_DECL
#undef GET_DBNXS_IMPL
#undef GET_DB_DECL
#undef GET_DB_IMPL
#undef GET_DC_DECL
#undef GET_DC_IMPL
#undef GET_EXACTFPIMM_DECL
#undef GET_EXACTFPIMM_IMPL
#undef GET_IC_DECL
#undef GET_IC_IMPL
#undef GET_ISB_DECL
#undef GET_ISB_IMPL
#undef GET_PRCTX_DECL
#undef GET_PRCTX_IMPL
#undef GET_PRFM_DECL
#undef GET_PRFM_IMPL
#undef GET_PSB_DECL
#undef GET_PSB_IMPL
#undef GET_PSTATE_DECL
#undef GET_PSTATE_IMPL
#undef GET_SVCR_DECL
#undef GET_SVCR_IMPL
#undef GET_SVEPREDPAT_DECL
#undef GET_SVEPREDPAT_IMPL
#undef GET_SVEPRFM_DECL
#undef GET_SVEPRFM_IMPL
#undef GET_SYSREG_DECL
#undef GET_SYSREG_IMPL
#undef GET_TLBITable_DECL
#undef GET_TLBITable_IMPL
#undef GET_TSB_DECL
#undef GET_TSB_IMPL
