﻿#ifndef LIBRETRO_CORE_OPTIONS_INTL_H__
#define LIBRETRO_CORE_OPTIONS_INTL_H__

#if defined(_MSC_VER) && (_MSC_VER >= 1500 && _MSC_VER < 1900)
/* https://support.microsoft.com/en-us/kb/980263 */
#pragma execution_character_set("utf-8")
#pragma warning(disable:4566)
#endif

#include <libretro.h>

/*
 ********************************
 * VERSION: 2.0
 ********************************
 *
 * - 2.0: Add support for core options v2 interface
 * - 1.3: Move translations to libretro_core_options_intl.h
 *        - libretro_core_options_intl.h includes BOM and utf-8
 *          fix for MSVC 2010-2013
 *        - Added HAVE_NO_LANGEXTRA flag to disable translations
 *          on platforms/compilers without BOM support
 * - 1.2: Use core options v1 interface when
 *        RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION is >= 1
 *        (previously required RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION == 1)
 * - 1.1: Support generation of core options v0 retro_core_option_value
 *        arrays containing options with a single value
 * - 1.0: First commit
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 ********************************
 * Core Option Definitions
 ********************************
*/
/* RETRO_LANGUAGE_AR */

#define CATEGORY_GB_LINK_LABEL_AR NULL
#define CATEGORY_GB_LINK_INFO_0_AR NULL
#define GAMBATTE_GB_COLORIZATION_LABEL_AR "تلوين GB"
#define GAMBATTE_GB_COLORIZATION_INFO_0_AR NULL
#define OPTION_VAL_AUTO_AR "تلقائي"
#define OPTION_VAL_GBC_AR NULL
#define OPTION_VAL_SGB_AR NULL
#define OPTION_VAL_INTERNAL_AR "داخلي"
#define OPTION_VAL_CUSTOM_AR "مخصص"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_AR NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_AR NULL
#define OPTION_VAL_GB_DMG_AR NULL
#define OPTION_VAL_GB_POCKET_AR "GB - الجيب"
#define OPTION_VAL_GB_LIGHT_AR NULL
#define OPTION_VAL_GBC_BLUE_AR "GBC - أزرق"
#define OPTION_VAL_GBC_BROWN_AR "GBC - بني"
#define OPTION_VAL_GBC_DARK_BLUE_AR "GBC - أزرق غامق"
#define OPTION_VAL_GBC_DARK_BROWN_AR NULL
#define OPTION_VAL_GBC_DARK_GREEN_AR NULL
#define OPTION_VAL_GBC_GRAYSCALE_AR NULL
#define OPTION_VAL_GBC_GREEN_AR NULL
#define OPTION_VAL_GBC_INVERTED_AR NULL
#define OPTION_VAL_GBC_ORANGE_AR NULL
#define OPTION_VAL_GBC_PASTEL_MIX_AR NULL
#define OPTION_VAL_GBC_RED_AR NULL
#define OPTION_VAL_GBC_YELLOW_AR NULL
#define OPTION_VAL_SGB_1A_AR NULL
#define OPTION_VAL_SGB_1B_AR NULL
#define OPTION_VAL_SGB_1C_AR NULL
#define OPTION_VAL_SGB_1D_AR NULL
#define OPTION_VAL_SGB_1E_AR NULL
#define OPTION_VAL_SGB_1F_AR NULL
#define OPTION_VAL_SGB_1G_AR NULL
#define OPTION_VAL_SGB_1H_AR NULL
#define OPTION_VAL_SGB_2A_AR NULL
#define OPTION_VAL_SGB_2B_AR NULL
#define OPTION_VAL_SGB_2C_AR NULL
#define OPTION_VAL_SGB_2D_AR NULL
#define OPTION_VAL_SGB_2E_AR NULL
#define OPTION_VAL_SGB_2F_AR NULL
#define OPTION_VAL_SGB_2G_AR NULL
#define OPTION_VAL_SGB_2H_AR NULL
#define OPTION_VAL_SGB_3A_AR NULL
#define OPTION_VAL_SGB_3B_AR NULL
#define OPTION_VAL_SGB_3C_AR NULL
#define OPTION_VAL_SGB_3D_AR NULL
#define OPTION_VAL_SGB_3E_AR NULL
#define OPTION_VAL_SGB_3F_AR NULL
#define OPTION_VAL_SGB_3G_AR NULL
#define OPTION_VAL_SGB_3H_AR NULL
#define OPTION_VAL_SGB_4A_AR NULL
#define OPTION_VAL_SGB_4B_AR NULL
#define OPTION_VAL_SGB_4C_AR NULL
#define OPTION_VAL_SGB_4D_AR NULL
#define OPTION_VAL_SGB_4E_AR NULL
#define OPTION_VAL_SGB_4F_AR NULL
#define OPTION_VAL_SGB_4G_AR NULL
#define OPTION_VAL_SGB_4H_AR NULL
#define OPTION_VAL_SPECIAL_1_AR NULL
#define OPTION_VAL_SPECIAL_2_AR NULL
#define OPTION_VAL_SPECIAL_3_AR NULL
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_AR NULL
#define OPTION_VAL_TWB64_PACK_1_AR NULL
#define OPTION_VAL_TWB64_PACK_2_AR NULL
#define OPTION_VAL_TWB64_PACK_3_AR NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_AR NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_AR NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_AR NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_AR NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_AR NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_AR NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_AR NULL
#define OPTION_VAL_TWB64_005_NEON_RED_AR NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_AR NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_AR NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_AR NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_AR NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_AR NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_AR NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_AR NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_AR NULL
#define OPTION_VAL_TWB64_014_DMG_099_AR NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_AR NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_AR NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_AR NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_AR NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_AR NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_AR NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_AR NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_AR NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_AR NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_AR NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_AR NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_AR NULL
#define OPTION_VAL_TWB64_027_BMO_VER_AR NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_AR NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_AR NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_AR NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_AR NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_AR NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_AR NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_AR NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_AR NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_AR NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_AR NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_AR NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_AR NULL
#define OPTION_VAL_TWB64_040_DMG_VER_AR NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_AR NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_AR NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_AR NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_AR NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_AR NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_AR NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_AR NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_AR NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_AR NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_AR NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_AR NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_AR NULL
#define OPTION_VAL_TWB64_053_VMU_VER_AR NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_AR NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_AR NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_AR NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_AR NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_AR NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_AR NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_AR NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_AR NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_AR NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_AR NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_AR NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_AR NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_AR NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_AR NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_AR NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_AR NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_AR NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_AR NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_AR NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_AR NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_AR NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_AR NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_AR NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_AR NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_AR NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_AR NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_AR NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_AR NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_AR NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_AR NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_AR NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_AR NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_AR NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_AR NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_AR NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_AR NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_AR NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_AR NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_AR NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_AR NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_AR NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_AR NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_AR NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_AR NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_AR NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_AR NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_AR NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_AR NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_AR NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_AR NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_AR NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_AR NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_AR NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_AR NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_AR NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_AR NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_AR NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_AR NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_AR NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_AR NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_AR NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_AR NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_AR NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_AR NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_AR NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_AR NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_AR NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_AR NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_AR NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_AR NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_AR NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_AR NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_AR NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_AR NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_AR NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_AR NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_AR NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_AR NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_AR NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_AR NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_AR NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_AR NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_AR NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_AR NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_AR NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_AR NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_AR NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_AR NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_AR NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_AR NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_AR NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_AR NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_AR NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_AR NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_AR NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_AR NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_AR NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_AR NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_AR NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_AR NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_AR NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_AR NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_AR NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_AR NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_AR NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_AR NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_AR NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_AR NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_AR NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_AR NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_AR NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_AR NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_AR NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_AR NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_AR NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_AR NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_AR NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_AR NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_AR NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_AR NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_AR NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_AR NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_AR NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_AR NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_AR NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_AR NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_AR NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_AR NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_AR NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_AR NULL
#define OPTION_VAL_TWB64_182_PASTEL109_AR NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_AR NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_AR NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_AR NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_AR NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_AR NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_AR NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_AR NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_AR NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_AR NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_AR NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_AR NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_AR NULL
#define OPTION_VAL_TWB64_195_EVA_01_AR NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_AR NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_AR NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_AR NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_AR NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_AR NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_AR NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_AR NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_AR NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_AR NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_AR NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_AR NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_AR NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_AR NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_AR NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_AR NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_AR NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_AR NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_AR NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_AR NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_AR NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_AR NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_AR NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_AR NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_AR NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_AR NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_AR NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_AR NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_AR NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_AR NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_AR NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_AR NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_AR NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_AR NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_AR NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_AR NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_AR NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_AR NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_AR NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_AR NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_AR NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_AR NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_AR NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_AR NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_AR NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_AR NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_AR NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_AR NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_AR NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_AR NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_AR NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_AR NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_AR NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_AR NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_AR NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_AR NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_AR NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_AR NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_AR NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_AR NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_AR NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_AR NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_AR NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_AR NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_AR NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_AR NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_AR NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_AR NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_AR NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_AR NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_AR NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_AR NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_AR NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_AR NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_AR NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_AR NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_AR NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_AR NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_AR NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_AR NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_AR NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_AR NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_AR NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_AR NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_AR NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_AR NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_AR NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_AR NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_AR NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_AR NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_AR NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_AR NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_AR NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_AR NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_AR NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_AR NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_AR NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_AR NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_AR NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_AR NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_AR NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_AR NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_AR NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_AR NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_AR NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_AR NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_AR NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_AR NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_AR NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_AR NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_AR NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_AR NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_AR NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_AR NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_AR NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_AR NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_AR NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_AR NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_AR NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_AR NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_AR NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_AR NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_AR NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_AR NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_AR NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_AR NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_AR NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__AR NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_AR NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_AR NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_AR NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_AR NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_AR NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_AR NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_AR NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_AR NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_AR NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_AR NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_AR NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_AR NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_AR NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_AR NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_AR NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_AR NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_AR NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_AR NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_AR NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_AR NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_AR NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_AR NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_AR NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_AR NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_AR NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_AR NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_AR NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_AR "تصحيح الألوان"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_AR "ضبط ألوان الإخراج لمطابقة عرض معدات Game Boy Color الحقيقي. يتضمن \"GBC فقط\" أن التصحيح سيتم تطبيقه فقط عند لعب Game Boy Color اللعبة، أو عند استخدام لوح ألوان Game Boy Color اللعبة. \"دائماً\" يطبق تصحيح الألوان على جميع المحتوى، وسوف ينتج نتائج غير متوقعة/دون المستوى الأمثل عند استخدام ألواح الألوان الداخلية \"GB\" أو \"SGB\"."
#define OPTION_VAL_GBC_ONLY_AR "GBC فقط"
#define OPTION_VAL_ALWAYS_AR "دائما"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_AR "وضع تصحيح الألوان"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_AR "يحدد الطريقة المستخدمة عند القيام بتصحيح الألوان. 'دقيقة' ينتج المخرجات تقريبا لا يمكن تمييزها عن لوحةGame Boy Color لوح LCD. \"سريع\" فقط ألوان مظلمة وتقلل من التشبع، وقد تستخدم على أجهزة منخفضة النهاية إذا كانت طريقة \"دقيقة\" بطيئة جداً."
#define OPTION_VAL_ACCURATE_AR "دقيق"
#define OPTION_VAL_FAST_AR "سريع"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_AR "تصحيح اللون - موقع الضوء الأمامي"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_AR "محاكاة الاستجابة الفيزيائية للوحة Game Boy Color LCD، عند الإضاءة من زوايا مختلفة. 'المركزية' يمثل استنساخ الألوان القياسي. 'أعلى الشاشة' يزيد السطوع. 'أسفل الشاشة' يقلل السطوع. ينطبق هذا الإعداد فقط عند تعيين 'وضع تصحيح الألوان' إلى 'دقيقة'."
#define OPTION_VAL_CENTRAL_AR "مركزي"
#define OPTION_VAL_ABOVE_SCREEN_AR "أعلى الشاشة"
#define OPTION_VAL_BELOW_SCREEN_AR "أسفل الشاشة"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_AR "مستوى فلتر الظلام (%)"
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_AR "تمكين تقليل السطوع القائم على الإضاءة. قد تستخدم لتجنب السلال/العين عند لعب الألعاب مع خلفيات بيضاء ، وهي مصممة للعرض على Game Boy اللعبة غير الخلفية ويمكن لذلك أن تبدو مشرقة بشكل غير مريح عند مشاهدتها على شاشة خلفية حديثة."
#define GAMBATTE_MIX_FRAMES_LABEL_AR "مزج حدود مشتركة"
#define GAMBATTE_MIX_FRAMES_INFO_0_AR "محاكاة تأثيرات شبح LCD. \"بسيط\" يقوم بمزيج 50:50 من الإطارات الحالية والسابقة. محاكاة أوقات الاستجابة الطبيعية لبلورات LCD، بالجمع بين إطارات زبائن متعددة. المزج 'بسيط' مطلوب عند لعب الألعاب التي تعتمد على شبح LCD لتأثيرات الشفافية (Wave Race, Ballistic, Chikyuu Kaihou Gun ZAS...)."
#define OPTION_VAL_MIX_AR "بسيط"
#define OPTION_VAL_LCD_GHOSTING_AR "LCD Ghost (دقيقة)"
#define OPTION_VAL_LCD_GHOSTING_FAST_AR "LCD Ghost (سريع)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_AR "إعادة تشغيل الصوت"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_AR "حدد الخوارزمية التي ستستخدم عند إعادة تسمية الصوت الذي تم إنشاؤه (معدل صوت فتى اللعبة محدود فقط من خلال سرعة كتابة المعالج الخاص بها، بحيث تكون الترددات 'الأصلية` غير عملية على الأجهزة الصوتية الحديثة ويجب أن تُنزل على العينة). \"Sinc\" ينتج أعلى جودة. \"Cosine\" يحسّن الأداء على الأجهزة الطرفية المنخفضة."
#define OPTION_VAL_SINC_AR "صفر"
#define OPTION_VAL_CC_AR NULL
#define GAMBATTE_GB_HWMODE_LABEL_AR "محاكاة العتاد (مطلوب إعادة التشغيل)"
#define GAMBATTE_GB_HWMODE_INFO_0_AR "حدد نوع الأجهزة التي يجب محاكاتها. \"تلقائي\" ينصح به. اختيار 'GBA' يفتح ميزات إضافية في بعض ألعاب ألوان الألعاب 'GBA المعززة' (شانتا وويندي - كل طريق ساحرة، أسطورة زيلدا: أوراكل من المواسم/الأعمار...)."
#define OPTION_VAL_GB_AR NULL
#define OPTION_VAL_GBA_AR NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_AR "استخدم محمل الإقلاع الرسمي (مطلوب إعادة التشغيل)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_AR "تمكين الدعم لمشغلي الألعاب الرسمية و مشغلي الألوان اللعبة، مع ما يقابل ذلك من الرسوم المتحركة لشعار البدء."
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_AR "السماح باتجاهات المعارضة"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_AR "تمكين هذا سوف يسمح بالضغط / التبديل/الضغط بسرعة على الإتجاهات اليسرى واليسرى (أو الأعلى والأسفل) في نفس الوقت. قد يسبب هذا إغراءات قائمة على الحركة."
#define GAMBATTE_TURBO_PERIOD_LABEL_AR NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_AR NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_AR NULL
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_AR NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_AR NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_AR NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_AR NULL
#define OPTION_VAL_NOT_CONNECTED_AR NULL
#define OPTION_VAL_NETWORK_SERVER_AR "خادم الشبكة"
#define OPTION_VAL_NETWORK_CLIENT_AR "عميل الشبكة"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_AR "منفذ رابط الشبكة"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_AR "المنفذ"
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_AR "حدد المنفذ المستخدم للاتصال بشبكة رابط اللعبة."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_AR "عنوان سيرفر الشبكة Pt. 01: x__.__.___._.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_AR "عنوان الخادم Pt. 01: x__._.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_AR "الرقم الأول لعنوان IP لخادم شبكة اللعبة البعيدة. يستخدم فقط عندما يتم تعيين \"وضع رابط اللعبة\" إلى \"عميل الشبكة\"."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_AR "الرقم الأول لعنوان IP لخادم شبكة اللعبة البعيدة. يستخدم فقط عندما يتم تعيين \"وضع الرابط\" إلى \"عميل الشبكة\"."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_AR "عنوان سيرفر رابط الشبكة Pt. 02: _x_.___.___.___.____"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_AR "عنوان الخادم Pt. 02: _x_.___.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_AR "الرقم الثاني لعنوان IP لخادم شبكة اللعبة البعيدة. يستخدم فقط عندما يتم تعيين \"وضع رابط اللعبة\" إلى \"عميل الشبكة\"."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_AR NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_AR "الرقم الثاني عشر لعنوان IP لخادم شبكة اللعبة البعيد. يستخدم فقط عندما يتم تعيين \"وضع رابط اللعبة\" إلى \"عميل الشبكة\"."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_AR "الرقم الثاني عشر لعنوان IP لخادم شبكة اللعبة البعيدة. يستخدم فقط عندما يتم تعيين \"وضع الرابط\" إلى \"عميل الشبكة\"."

struct retro_core_option_v2_category option_cats_ar[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_AR,
      CATEGORY_GB_LINK_INFO_0_AR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ar[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_AR,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_AR,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_AR },
         { "GBC",      OPTION_VAL_GBC_AR },
         { "SGB",      OPTION_VAL_SGB_AR },
         { "internal", OPTION_VAL_INTERNAL_AR },
         { "custom",   OPTION_VAL_CUSTOM_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_AR,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_AR,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_AR },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_AR },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_AR },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_AR },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_AR },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_AR },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_AR },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_AR },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_AR },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_AR },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_AR },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_AR },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_AR },
         { "GBC - Red",                OPTION_VAL_GBC_RED_AR },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_AR },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_AR },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_AR },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_AR },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_AR },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_AR },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_AR },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_AR },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_AR },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_AR },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_AR },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_AR },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_AR },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_AR },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_AR },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_AR },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_AR },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_AR },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_AR },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_AR },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_AR },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_AR },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_AR },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_AR },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_AR },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_AR },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_AR },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_AR },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_AR },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_AR },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_AR },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_AR },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_AR },
         { "Special 1",                OPTION_VAL_SPECIAL_1_AR },
         { "Special 2",                OPTION_VAL_SPECIAL_2_AR },
         { "Special 3",                OPTION_VAL_SPECIAL_3_AR },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_AR },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_AR },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_AR },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_AR },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_AR },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_AR,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_AR,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_AR },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_AR },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_AR },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_AR },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_AR },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_AR },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_AR },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_AR },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_AR },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_AR },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_AR },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_AR },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_AR },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_AR },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_AR },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_AR },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_AR },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_AR },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_AR },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_AR },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_AR },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_AR },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_AR },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_AR },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_AR },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_AR },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_AR },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_AR },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_AR },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_AR },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_AR },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_AR },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_AR },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_AR },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_AR },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_AR },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_AR },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_AR },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_AR },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_AR },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_AR },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_AR },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_AR },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_AR },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_AR },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_AR },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_AR },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_AR },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_AR },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_AR },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_AR },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_AR },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_AR },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_AR },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_AR },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_AR },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_AR },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_AR },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_AR },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_AR },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_AR },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_AR },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_AR },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_AR },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_AR },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_AR },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_AR },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_AR },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_AR },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_AR },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_AR },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_AR },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_AR },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_AR },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_AR },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_AR },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_AR },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_AR },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_AR },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_AR },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_AR },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_AR },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_AR },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_AR },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_AR },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_AR },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_AR },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_AR },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_AR },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_AR },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_AR },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_AR },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_AR },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_AR },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_AR },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_AR },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_AR },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_AR },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_AR },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_AR },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_AR,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_AR,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_AR },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_AR },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_AR },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_AR },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_AR },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_AR },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_AR },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_AR },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_AR },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_AR },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_AR },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_AR },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_AR },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_AR },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_AR },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_AR },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_AR },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_AR },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_AR },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_AR },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_AR },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_AR },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_AR },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_AR },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_AR },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_AR },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_AR },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_AR },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_AR },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_AR },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_AR },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_AR },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_AR },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_AR },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_AR },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_AR },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_AR },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_AR },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_AR },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_AR },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_AR },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_AR },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_AR },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_AR },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_AR },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_AR },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_AR },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_AR },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_AR },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_AR },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_AR },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_AR },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_AR },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_AR },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_AR },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_AR },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_AR },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_AR },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_AR },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_AR },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_AR },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_AR },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_AR },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_AR },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_AR },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_AR },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_AR },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_AR },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_AR },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_AR },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_AR },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_AR },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_AR },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_AR },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_AR },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_AR },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_AR },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_AR },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_AR },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_AR },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_AR },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_AR },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_AR },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_AR },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_AR },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_AR },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_AR },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_AR },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_AR },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_AR },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_AR },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_AR },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_AR },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_AR },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_AR },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_AR },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_AR },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_AR },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_AR },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_AR },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_AR,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_AR,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_AR },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_AR },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_AR },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_AR },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_AR },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_AR },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_AR },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_AR },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_AR },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_AR },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_AR },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_AR },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_AR },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_AR },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_AR },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_AR },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_AR },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_AR },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_AR },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_AR },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_AR },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_AR },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_AR },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_AR },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_AR },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_AR },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_AR },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_AR },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_AR },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_AR },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_AR },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_AR },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_AR },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_AR },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_AR },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_AR },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_AR },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_AR },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_AR },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_AR },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_AR },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_AR },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_AR },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_AR },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_AR },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_AR },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_AR },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_AR },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_AR },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_AR },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_AR },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_AR },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_AR },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_AR },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_AR },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_AR },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_AR },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_AR },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_AR },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_AR },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_AR },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_AR },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_AR },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_AR },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_AR },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_AR },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_AR },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_AR },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_AR },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_AR },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_AR },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_AR },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_AR },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_AR },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_AR },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_AR },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_AR },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_AR },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_AR },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_AR },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_AR },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_AR },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_AR },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_AR },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_AR },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_AR },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_AR },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_AR },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_AR },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_AR },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_AR },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_AR },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_AR },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_AR },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_AR },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_AR },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_AR },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_AR },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_AR },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_AR },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_AR,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_AR,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_AR },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_AR },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_AR },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_AR },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_AR },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_AR },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_AR },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_AR },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_AR },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_AR },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_AR },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_AR },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_AR },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_AR },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_AR },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_AR },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_AR },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__AR },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_AR },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_AR },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_AR },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_AR },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_AR },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_AR },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_AR },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_AR },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_AR },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_AR },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_AR },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_AR },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_AR },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_AR },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_AR },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_AR },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_AR },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_AR },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_AR },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_AR },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_AR },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_AR },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_AR },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_AR },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_AR },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_AR },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_AR },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_AR,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_AR,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_AR },
         { "always",   OPTION_VAL_ALWAYS_AR },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_AR,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_AR,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_AR },
         { "fast",     OPTION_VAL_FAST_AR },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_AR,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_AR,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_AR },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_AR },
         { "below screen", OPTION_VAL_BELOW_SCREEN_AR },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_AR,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_AR,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_AR,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_AR,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_AR },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_AR },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_AR,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_AR,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_AR },
         { "cc",   OPTION_VAL_CC_AR },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_AR,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_AR,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_AR },
         { "GB",   OPTION_VAL_GB_AR },
         { "GBC",  OPTION_VAL_GBC_AR },
         { "GBA",  OPTION_VAL_GBA_AR },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_AR,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_AR,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_AR,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_AR,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_AR,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_AR,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_AR,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_AR,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_AR,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_AR,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_AR,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_MODE_INFO_0_AR,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_AR },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_AR },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_AR },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_AR,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_AR,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_AR,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ar = {
   option_cats_ar,
   option_defs_ar
};

/* RETRO_LANGUAGE_AST */

#define CATEGORY_GB_LINK_LABEL_AST NULL
#define CATEGORY_GB_LINK_INFO_0_AST NULL
#define GAMBATTE_GB_COLORIZATION_LABEL_AST NULL
#define GAMBATTE_GB_COLORIZATION_INFO_0_AST NULL
#define OPTION_VAL_AUTO_AST NULL
#define OPTION_VAL_GBC_AST NULL
#define OPTION_VAL_SGB_AST NULL
#define OPTION_VAL_INTERNAL_AST NULL
#define OPTION_VAL_CUSTOM_AST NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_AST "Paleta interna"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_AST NULL
#define OPTION_VAL_GB_DMG_AST NULL
#define OPTION_VAL_GB_POCKET_AST NULL
#define OPTION_VAL_GB_LIGHT_AST NULL
#define OPTION_VAL_GBC_BLUE_AST "GBC - Azul"
#define OPTION_VAL_GBC_BROWN_AST "GBC - Marrón"
#define OPTION_VAL_GBC_DARK_BLUE_AST "GBC - Azul escuro"
#define OPTION_VAL_GBC_DARK_BROWN_AST "GBC - Marrón escuro"
#define OPTION_VAL_GBC_DARK_GREEN_AST "GBC - Verde escuro"
#define OPTION_VAL_GBC_GRAYSCALE_AST "GBC - Escala de buxos"
#define OPTION_VAL_GBC_GREEN_AST "GBC - Verde"
#define OPTION_VAL_GBC_INVERTED_AST NULL
#define OPTION_VAL_GBC_ORANGE_AST "GBC - Naranxa"
#define OPTION_VAL_GBC_PASTEL_MIX_AST NULL
#define OPTION_VAL_GBC_RED_AST "GBC - Coloráu"
#define OPTION_VAL_GBC_YELLOW_AST "GBC - Mariellu"
#define OPTION_VAL_SGB_1A_AST NULL
#define OPTION_VAL_SGB_1B_AST NULL
#define OPTION_VAL_SGB_1C_AST NULL
#define OPTION_VAL_SGB_1D_AST NULL
#define OPTION_VAL_SGB_1E_AST NULL
#define OPTION_VAL_SGB_1F_AST NULL
#define OPTION_VAL_SGB_1G_AST NULL
#define OPTION_VAL_SGB_1H_AST NULL
#define OPTION_VAL_SGB_2A_AST NULL
#define OPTION_VAL_SGB_2B_AST NULL
#define OPTION_VAL_SGB_2C_AST NULL
#define OPTION_VAL_SGB_2D_AST NULL
#define OPTION_VAL_SGB_2E_AST NULL
#define OPTION_VAL_SGB_2F_AST NULL
#define OPTION_VAL_SGB_2G_AST NULL
#define OPTION_VAL_SGB_2H_AST NULL
#define OPTION_VAL_SGB_3A_AST NULL
#define OPTION_VAL_SGB_3B_AST NULL
#define OPTION_VAL_SGB_3C_AST NULL
#define OPTION_VAL_SGB_3D_AST NULL
#define OPTION_VAL_SGB_3E_AST NULL
#define OPTION_VAL_SGB_3F_AST NULL
#define OPTION_VAL_SGB_3G_AST NULL
#define OPTION_VAL_SGB_3H_AST NULL
#define OPTION_VAL_SGB_4A_AST NULL
#define OPTION_VAL_SGB_4B_AST NULL
#define OPTION_VAL_SGB_4C_AST NULL
#define OPTION_VAL_SGB_4D_AST NULL
#define OPTION_VAL_SGB_4E_AST NULL
#define OPTION_VAL_SGB_4F_AST NULL
#define OPTION_VAL_SGB_4G_AST NULL
#define OPTION_VAL_SGB_4H_AST NULL
#define OPTION_VAL_SPECIAL_1_AST "Especial 1"
#define OPTION_VAL_SPECIAL_2_AST "Especial 2"
#define OPTION_VAL_SPECIAL_3_AST "Especial 3"
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_AST NULL
#define OPTION_VAL_TWB64_PACK_1_AST "TWB64 - Paquete 1"
#define OPTION_VAL_TWB64_PACK_2_AST "TWB64 - Paquete 2"
#define OPTION_VAL_TWB64_PACK_3_AST "TWB64 - Paquete 3"
#define OPTION_VAL_PIXELSHIFT_PACK_1_AST "PixelShift - Paquete 1"
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_AST NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_AST NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_AST NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_AST NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_AST NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_AST NULL
#define OPTION_VAL_TWB64_005_NEON_RED_AST "TWB64 005 - Coloráu neón"
#define OPTION_VAL_TWB64_006_NEON_BLUE_AST "TWB64 006 - Azul neón"
#define OPTION_VAL_TWB64_007_NEON_YELLOW_AST "TWB64 007 - Mariellu neón"
#define OPTION_VAL_TWB64_008_NEON_GREEN_AST "TWB64 008 - Verde neón"
#define OPTION_VAL_TWB64_009_NEON_PINK_AST "TWB64 009 - Rosa neón"
#define OPTION_VAL_TWB64_010_MARIO_RED_AST NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_AST NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_AST NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_AST NULL
#define OPTION_VAL_TWB64_014_DMG_099_AST NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_AST NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_AST NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_AST NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_AST NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_AST NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_AST NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_AST NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_AST NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_AST NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_AST NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_AST NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_AST NULL
#define OPTION_VAL_TWB64_027_BMO_VER_AST NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_AST NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_AST NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_AST NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_AST NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_AST NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_AST NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_AST NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_AST NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_AST NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_AST NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_AST NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_AST NULL
#define OPTION_VAL_TWB64_040_DMG_VER_AST NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_AST NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_AST NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_AST NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_AST NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_AST "TWB64 045 - Mariellu Pikachu"
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_AST "TWB64 046 - Marrón Eevee"
#define OPTION_VAL_TWB64_047_MICROVISION_VER_AST NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_AST NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_AST NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_AST NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_AST NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_AST NULL
#define OPTION_VAL_TWB64_053_VMU_VER_AST NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_AST NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_AST "TWB64 055 - Verde Android"
#define OPTION_VAL_TWB64_056_AMAZON_VISION_AST NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_AST "TWB64 057 - Coloráu Google"
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_AST "TWB64 058 - Azul Google"
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_AST "TWB64 059 - Mariellu Google"
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_AST "TWB64 060 - Verde Google"
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_AST NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_AST NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_AST NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_AST NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_AST NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_AST NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_AST NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_AST NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_AST NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_AST NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_AST NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_AST NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_AST NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_AST NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_AST NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_AST NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_AST NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_AST NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_AST NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_AST NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_AST NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_AST NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_AST NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_AST NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_AST NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_AST NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_AST NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_AST NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_AST NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_AST NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_AST NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_AST NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_AST NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_AST NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_AST NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_AST NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_AST NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_AST NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_AST NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_AST NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_AST NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_AST NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_AST "TWB64 101 - Rosa 765PRO"
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_AST "TWB64 102 - Azul CINDERELLA"
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_AST NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_AST "TWB64 104 - Verde SideM"
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_AST NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_AST NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_AST NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_AST NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_AST NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_AST NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_AST NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_AST NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_AST NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_AST NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_AST NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_AST NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_AST NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_AST NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_AST "TWB64 119 - Rosa AKB48"
#define OPTION_VAL_TWB64_120_MIKU_BLUE_AST "TWB64 120 - Azul Miku"
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_AST NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_AST NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_AST NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_AST NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_AST NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_AST NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_AST NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_AST NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_AST NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_AST NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_AST "TWB64 131 - Moráu neón"
#define OPTION_VAL_TWB64_132_NEON_ORANGE_AST "TWB64 132 - Naranxa neón"
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_AST NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_AST NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_AST NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_AST NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_AST "TWB64 137 - Mariellu Pac-Man"
#define OPTION_VAL_TWB64_138_IRISH_GREEN_AST "TWB64 138 - Verde irlandés"
#define OPTION_VAL_TWB64_139_GOKU_GI_AST NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_AST NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_AST NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_AST NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_AST NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_AST NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_AST NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_AST NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_AST NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_AST NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_AST NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_AST NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_AST NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_AST NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_AST NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_AST NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_AST NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_AST "TWB64 156 - Coloráu Pokédex"
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_AST NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_AST "TWB64 158 - Verde Xbox"
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_AST NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_AST NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_AST NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_AST NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_AST NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_AST NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_AST NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_AST NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_AST "TWB64 167 - Azul estrunfín"
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_AST NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_AST NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_AST NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_AST NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_AST NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_AST NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_AST "TWB64 174 - Rosa Barbie"
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_AST NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_AST NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_AST NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_AST NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_AST NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_AST NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_AST NULL
#define OPTION_VAL_TWB64_182_PASTEL109_AST NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_AST NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_AST NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_AST NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_AST NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_AST NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_AST "TWB64 188 - Coloráu Pizza Hut"
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_AST "TWB64 189 - Verde esmeralda"
#define OPTION_VAL_TWB64_190_GRAND_IVORY_AST NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_AST NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_AST "TWB64 192 - Azul SEGA Tokiu"
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_AST NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_AST NULL
#define OPTION_VAL_TWB64_195_EVA_01_AST NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_AST NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_AST NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_AST NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_AST NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_AST NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_AST NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_AST NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_AST NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_AST NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_AST NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_AST NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_AST NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_AST NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_AST NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_AST NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_AST NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_AST NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_AST NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_AST NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_AST NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_AST NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_AST NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_AST NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_AST NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_AST NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_AST NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_AST NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_AST NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_AST NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_AST NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_AST NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_AST NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_AST NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_AST NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_AST NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_AST NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_AST "TWB64 230 - Troféu d'oru"
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_AST NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_AST NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_AST NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_AST NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_AST NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_AST NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_AST NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_AST NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_AST NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_AST NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_AST NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_AST NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_AST NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_AST NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_AST NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_AST "TWB64 246 - Verde Spotify"
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_AST NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_AST NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_AST NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_AST NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_AST NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_AST NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_AST NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_AST NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_AST NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_AST NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_AST NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_AST NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_AST NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_AST NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_AST NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_AST NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_AST NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_AST NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_AST NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_AST NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_AST NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_AST NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_AST NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_AST NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_AST NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_AST NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_AST NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_AST NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_AST NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_AST NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_AST NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_AST NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_AST NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_AST NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_AST NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_AST NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_AST NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_AST NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_AST NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_AST NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_AST NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_AST NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_AST NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_AST NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_AST NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_AST NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_AST NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_AST NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_AST NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_AST NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_AST NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_AST NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_AST NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_AST NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_AST NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_AST NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_AST NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_AST NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_AST NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_AST NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_AST NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_AST NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_AST NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_AST NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_AST NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_AST NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_AST NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_AST NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_AST NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_AST NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_AST NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_AST NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_AST NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__AST NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_AST NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_AST NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_AST NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_AST NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_AST NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_AST NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_AST NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_AST NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_AST NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_AST NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_AST NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_AST NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_AST NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_AST NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_AST NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_AST NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_AST "PixelShift 35 - MS-DOS"
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_AST NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_AST NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_AST NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_AST NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_AST NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_AST NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_AST NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_AST NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_AST NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_AST NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_AST NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_AST NULL
#define OPTION_VAL_GBC_ONLY_AST NULL
#define OPTION_VAL_ALWAYS_AST "Siempre"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_AST NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_AST NULL
#define OPTION_VAL_ACCURATE_AST NULL
#define OPTION_VAL_FAST_AST NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_AST NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_AST NULL
#define OPTION_VAL_CENTRAL_AST NULL
#define OPTION_VAL_ABOVE_SCREEN_AST NULL
#define OPTION_VAL_BELOW_SCREEN_AST NULL
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_AST NULL
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_AST NULL
#define GAMBATTE_MIX_FRAMES_LABEL_AST NULL
#define GAMBATTE_MIX_FRAMES_INFO_0_AST NULL
#define OPTION_VAL_MIX_AST NULL
#define OPTION_VAL_LCD_GHOSTING_AST NULL
#define OPTION_VAL_LCD_GHOSTING_FAST_AST NULL
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_AST NULL
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_AST NULL
#define OPTION_VAL_SINC_AST NULL
#define OPTION_VAL_CC_AST NULL
#define GAMBATTE_GB_HWMODE_LABEL_AST NULL
#define GAMBATTE_GB_HWMODE_INFO_0_AST NULL
#define OPTION_VAL_GB_AST NULL
#define OPTION_VAL_GBA_AST NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_AST "Usar el cargador d'arrinque oficial (ye obligatorio reaniciar)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_AST "Activa la compatibilidá colos xestores d'arrinque de Game Boy ya Game Boy Color xunto colos sos logos animaos del aniciu."
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_AST "Permitir les direiciones opuestes"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_AST NULL
#define GAMBATTE_TURBO_PERIOD_LABEL_AST NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_AST NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_AST "Fuercia del vibrador del mandu"
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_AST NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_AST NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_AST NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_AST NULL
#define OPTION_VAL_NOT_CONNECTED_AST NULL
#define OPTION_VAL_NETWORK_SERVER_AST NULL
#define OPTION_VAL_NETWORK_CLIENT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_AST "Puertu"
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_AST NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_AST NULL

struct retro_core_option_v2_category option_cats_ast[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_AST,
      CATEGORY_GB_LINK_INFO_0_AST
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ast[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_AST,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_AST,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_AST },
         { "GBC",      OPTION_VAL_GBC_AST },
         { "SGB",      OPTION_VAL_SGB_AST },
         { "internal", OPTION_VAL_INTERNAL_AST },
         { "custom",   OPTION_VAL_CUSTOM_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_AST,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_AST,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_AST },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_AST },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_AST },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_AST },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_AST },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_AST },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_AST },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_AST },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_AST },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_AST },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_AST },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_AST },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_AST },
         { "GBC - Red",                OPTION_VAL_GBC_RED_AST },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_AST },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_AST },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_AST },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_AST },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_AST },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_AST },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_AST },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_AST },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_AST },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_AST },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_AST },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_AST },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_AST },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_AST },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_AST },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_AST },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_AST },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_AST },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_AST },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_AST },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_AST },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_AST },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_AST },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_AST },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_AST },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_AST },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_AST },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_AST },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_AST },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_AST },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_AST },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_AST },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_AST },
         { "Special 1",                OPTION_VAL_SPECIAL_1_AST },
         { "Special 2",                OPTION_VAL_SPECIAL_2_AST },
         { "Special 3",                OPTION_VAL_SPECIAL_3_AST },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_AST },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_AST },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_AST },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_AST },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_AST },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_AST,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_AST,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_AST },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_AST },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_AST },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_AST },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_AST },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_AST },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_AST },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_AST },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_AST },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_AST },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_AST },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_AST },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_AST },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_AST },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_AST },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_AST },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_AST },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_AST },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_AST },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_AST },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_AST },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_AST },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_AST },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_AST },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_AST },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_AST },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_AST },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_AST },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_AST },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_AST },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_AST },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_AST },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_AST },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_AST },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_AST },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_AST },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_AST },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_AST },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_AST },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_AST },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_AST },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_AST },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_AST },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_AST },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_AST },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_AST },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_AST },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_AST },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_AST },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_AST },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_AST },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_AST },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_AST },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_AST },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_AST },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_AST },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_AST },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_AST },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_AST },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_AST },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_AST },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_AST },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_AST },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_AST },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_AST },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_AST },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_AST },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_AST },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_AST },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_AST },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_AST },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_AST },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_AST },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_AST },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_AST },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_AST },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_AST },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_AST },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_AST },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_AST },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_AST },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_AST },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_AST },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_AST },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_AST },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_AST },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_AST },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_AST },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_AST },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_AST },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_AST },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_AST },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_AST },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_AST },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_AST },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_AST },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_AST },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_AST },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_AST },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_AST },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_AST,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_AST,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_AST },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_AST },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_AST },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_AST },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_AST },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_AST },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_AST },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_AST },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_AST },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_AST },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_AST },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_AST },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_AST },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_AST },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_AST },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_AST },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_AST },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_AST },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_AST },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_AST },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_AST },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_AST },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_AST },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_AST },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_AST },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_AST },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_AST },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_AST },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_AST },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_AST },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_AST },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_AST },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_AST },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_AST },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_AST },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_AST },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_AST },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_AST },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_AST },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_AST },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_AST },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_AST },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_AST },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_AST },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_AST },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_AST },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_AST },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_AST },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_AST },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_AST },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_AST },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_AST },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_AST },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_AST },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_AST },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_AST },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_AST },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_AST },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_AST },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_AST },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_AST },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_AST },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_AST },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_AST },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_AST },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_AST },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_AST },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_AST },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_AST },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_AST },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_AST },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_AST },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_AST },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_AST },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_AST },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_AST },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_AST },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_AST },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_AST },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_AST },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_AST },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_AST },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_AST },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_AST },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_AST },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_AST },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_AST },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_AST },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_AST },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_AST },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_AST },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_AST },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_AST },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_AST },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_AST },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_AST },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_AST },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_AST },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_AST },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_AST },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_AST,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_AST,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_AST },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_AST },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_AST },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_AST },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_AST },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_AST },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_AST },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_AST },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_AST },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_AST },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_AST },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_AST },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_AST },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_AST },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_AST },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_AST },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_AST },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_AST },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_AST },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_AST },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_AST },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_AST },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_AST },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_AST },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_AST },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_AST },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_AST },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_AST },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_AST },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_AST },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_AST },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_AST },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_AST },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_AST },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_AST },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_AST },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_AST },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_AST },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_AST },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_AST },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_AST },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_AST },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_AST },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_AST },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_AST },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_AST },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_AST },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_AST },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_AST },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_AST },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_AST },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_AST },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_AST },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_AST },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_AST },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_AST },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_AST },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_AST },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_AST },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_AST },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_AST },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_AST },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_AST },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_AST },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_AST },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_AST },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_AST },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_AST },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_AST },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_AST },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_AST },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_AST },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_AST },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_AST },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_AST },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_AST },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_AST },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_AST },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_AST },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_AST },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_AST },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_AST },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_AST },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_AST },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_AST },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_AST },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_AST },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_AST },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_AST },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_AST },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_AST },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_AST },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_AST },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_AST },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_AST },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_AST },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_AST },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_AST },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_AST },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_AST },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_AST,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_AST,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_AST },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_AST },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_AST },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_AST },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_AST },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_AST },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_AST },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_AST },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_AST },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_AST },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_AST },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_AST },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_AST },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_AST },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_AST },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_AST },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_AST },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__AST },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_AST },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_AST },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_AST },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_AST },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_AST },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_AST },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_AST },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_AST },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_AST },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_AST },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_AST },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_AST },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_AST },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_AST },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_AST },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_AST },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_AST },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_AST },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_AST },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_AST },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_AST },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_AST },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_AST },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_AST },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_AST },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_AST },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_AST },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_AST,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_AST,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_AST },
         { "always",   OPTION_VAL_ALWAYS_AST },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_AST,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_AST,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_AST },
         { "fast",     OPTION_VAL_FAST_AST },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_AST,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_AST,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_AST },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_AST },
         { "below screen", OPTION_VAL_BELOW_SCREEN_AST },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_AST,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_AST,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_AST,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_AST,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_AST },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_AST },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_AST,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_AST,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_AST },
         { "cc",   OPTION_VAL_CC_AST },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_AST,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_AST,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_AST },
         { "GB",   OPTION_VAL_GB_AST },
         { "GBC",  OPTION_VAL_GBC_AST },
         { "GBA",  OPTION_VAL_GBA_AST },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_AST,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_AST,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_AST,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_AST,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_AST,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_AST,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_AST,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_AST,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_AST,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_AST,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_AST,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_MODE_INFO_0_AST,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_AST },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_AST },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_AST },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_AST,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_AST,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_AST,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ast = {
   option_cats_ast,
   option_defs_ast
};

/* RETRO_LANGUAGE_BE */

#define CATEGORY_GB_LINK_LABEL_BE NULL
#define CATEGORY_GB_LINK_INFO_0_BE "Наладкі сеткавага (мультыплэера) Game Link."
#define GAMBATTE_GB_COLORIZATION_LABEL_BE "Каларызацыя GB"
#define GAMBATTE_GB_COLORIZATION_INFO_0_BE "Уключае каларызацыю гульняў Game Boy. 'Аўта' выбірае 'найлепшую' (найболей падыходную/маляўнічую) палітру. 'GBC' выкарыстоўвае для гульні прадусталяваную палітру Game Boy Color ці, пры яе адсутнасці, 'GBC - Dark Green'. 'SGB' выкарыстоўвае для гульні прадусталяваную палітру Super Game Boy ці, пры яе адсутнасці, 'SGB - 1A'. 'Убудаваная' выкарыстоўвае опцыю 'Убудаваная палітра'. 'Кастомная' загружае карыстальніцкую палітру з сістэмнага каталога."
#define OPTION_VAL_AUTO_BE "Аўта"
#define OPTION_VAL_GBC_BE NULL
#define OPTION_VAL_SGB_BE NULL
#define OPTION_VAL_INTERNAL_BE "Убудаваная"
#define OPTION_VAL_CUSTOM_BE "Уласная"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_BE "Убудаваная палітра"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_BE "Палітра, якая выкарыстоўваецца для размалёўвання гульняў Game Boy пры ўсталёўцы опцыі 'Каларызацыя GB' у рэжым 'Убудаваная' або калі ўсталяваны рэжым 'Аўта' і для гульні няма прадусталяванай палітры SGB/GBC. Палітры 'GB' імітуюць арыгінальную выяву кансолі. Палітры 'GBC' ідэнтычныя ўбудаваным прасэтам Game Boy Color. Палітры 'SGB' адпавядаюць убудаваным прасэтам Super Game Boy."
#define OPTION_VAL_GB_DMG_BE NULL
#define OPTION_VAL_GB_POCKET_BE NULL
#define OPTION_VAL_GB_LIGHT_BE "GB - Светлая"
#define OPTION_VAL_GBC_BLUE_BE "GBC - Блакітная"
#define OPTION_VAL_GBC_BROWN_BE "GBC - Карычневая"
#define OPTION_VAL_GBC_DARK_BLUE_BE "GBC - Цёмна-сіняя"
#define OPTION_VAL_GBC_DARK_BROWN_BE "GBC - Цёмна-карычневая"
#define OPTION_VAL_GBC_DARK_GREEN_BE "GBC - Цёмна-зялёная"
#define OPTION_VAL_GBC_GRAYSCALE_BE "GBC - Адценні шэрага"
#define OPTION_VAL_GBC_GREEN_BE "GBC - Зялёная"
#define OPTION_VAL_GBC_INVERTED_BE "GBC - Інверсія"
#define OPTION_VAL_GBC_ORANGE_BE "GBC - Аранжавая"
#define OPTION_VAL_GBC_PASTEL_MIX_BE "GBC - Пастэльны мікс"
#define OPTION_VAL_GBC_RED_BE "GBC - Чырвоная"
#define OPTION_VAL_GBC_YELLOW_BE "GBC - Жоўтая"
#define OPTION_VAL_SGB_1A_BE NULL
#define OPTION_VAL_SGB_1B_BE NULL
#define OPTION_VAL_SGB_1C_BE NULL
#define OPTION_VAL_SGB_1D_BE NULL
#define OPTION_VAL_SGB_1E_BE NULL
#define OPTION_VAL_SGB_1F_BE NULL
#define OPTION_VAL_SGB_1G_BE NULL
#define OPTION_VAL_SGB_1H_BE NULL
#define OPTION_VAL_SGB_2A_BE NULL
#define OPTION_VAL_SGB_2B_BE NULL
#define OPTION_VAL_SGB_2C_BE NULL
#define OPTION_VAL_SGB_2D_BE NULL
#define OPTION_VAL_SGB_2E_BE NULL
#define OPTION_VAL_SGB_2F_BE NULL
#define OPTION_VAL_SGB_2G_BE NULL
#define OPTION_VAL_SGB_2H_BE NULL
#define OPTION_VAL_SGB_3A_BE NULL
#define OPTION_VAL_SGB_3B_BE NULL
#define OPTION_VAL_SGB_3C_BE NULL
#define OPTION_VAL_SGB_3D_BE NULL
#define OPTION_VAL_SGB_3E_BE NULL
#define OPTION_VAL_SGB_3F_BE NULL
#define OPTION_VAL_SGB_3G_BE NULL
#define OPTION_VAL_SGB_3H_BE NULL
#define OPTION_VAL_SGB_4A_BE NULL
#define OPTION_VAL_SGB_4B_BE NULL
#define OPTION_VAL_SGB_4C_BE NULL
#define OPTION_VAL_SGB_4D_BE NULL
#define OPTION_VAL_SGB_4E_BE NULL
#define OPTION_VAL_SGB_4F_BE NULL
#define OPTION_VAL_SGB_4G_BE NULL
#define OPTION_VAL_SGB_4H_BE NULL
#define OPTION_VAL_SPECIAL_1_BE "Асаблівая 1"
#define OPTION_VAL_SPECIAL_2_BE "Асаблівая 2"
#define OPTION_VAL_SPECIAL_3_BE "Асаблівая 3"
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_BE NULL
#define OPTION_VAL_TWB64_PACK_1_BE "TWB64 - Пакет 1"
#define OPTION_VAL_TWB64_PACK_2_BE "TWB64 - Пакет 2"
#define OPTION_VAL_TWB64_PACK_3_BE "TWB64 - Пакет 3"
#define OPTION_VAL_PIXELSHIFT_PACK_1_BE "PixelShift - Пакет 1"
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_BE "> Палітра TWB64 - Пакет 1"
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_BE "Выбар убудаванай палітры каларызацыі, калі для опцыі 'Убудаваная палітра' зададзена 'TWB64 - Пакет 1'."
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_BE NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_BE NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_BE NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_BE NULL
#define OPTION_VAL_TWB64_005_NEON_RED_BE NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_BE NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_BE NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_BE NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_BE NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_BE NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_BE NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_BE NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_BE NULL
#define OPTION_VAL_TWB64_014_DMG_099_BE NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_BE NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_BE NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_BE NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_BE NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_BE NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_BE NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_BE NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_BE NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_BE NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_BE NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_BE NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_BE NULL
#define OPTION_VAL_TWB64_027_BMO_VER_BE NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_BE NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_BE NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_BE NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_BE NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_BE NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_BE NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_BE NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_BE NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_BE NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_BE NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_BE NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_BE NULL
#define OPTION_VAL_TWB64_040_DMG_VER_BE NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_BE NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_BE NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_BE NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_BE NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_BE NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_BE NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_BE NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_BE NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_BE NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_BE NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_BE NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_BE NULL
#define OPTION_VAL_TWB64_053_VMU_VER_BE NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_BE NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_BE NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_BE NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_BE NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_BE NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_BE NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_BE NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_BE NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_BE NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_BE NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_BE NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_BE NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_BE NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_BE NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_BE NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_BE NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_BE NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_BE NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_BE NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_BE NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_BE NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_BE NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_BE NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_BE NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_BE NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_BE NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_BE NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_BE NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_BE NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_BE NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_BE NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_BE NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_BE NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_BE NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_BE NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_BE NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_BE NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_BE NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_BE NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_BE NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_BE NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_BE NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_BE NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_BE NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_BE NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_BE NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_BE NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_BE "> Палітра TWB64 - Пакет 2"
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_BE "Выбар убудаванай палітры каларызацыі, калі для опцыі 'Убудаваная палітра' зададзена 'TWB64 - Пакет 2'."
#define OPTION_VAL_TWB64_101_765PRO_PINK_BE NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_BE NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_BE NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_BE NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_BE NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_BE NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_BE NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_BE NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_BE NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_BE NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_BE NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_BE NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_BE NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_BE NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_BE NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_BE NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_BE NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_BE NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_BE NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_BE NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_BE NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_BE NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_BE NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_BE NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_BE NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_BE NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_BE NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_BE NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_BE NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_BE NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_BE NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_BE NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_BE NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_BE NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_BE NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_BE NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_BE NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_BE NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_BE NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_BE NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_BE NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_BE NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_BE NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_BE NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_BE NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_BE NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_BE NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_BE NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_BE NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_BE NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_BE NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_BE NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_BE NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_BE NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_BE NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_BE NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_BE NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_BE NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_BE NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_BE NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_BE NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_BE NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_BE NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_BE NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_BE NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_BE NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_BE NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_BE NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_BE NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_BE NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_BE NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_BE NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_BE NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_BE NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_BE NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_BE NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_BE NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_BE NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_BE NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_BE NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_BE NULL
#define OPTION_VAL_TWB64_182_PASTEL109_BE NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_BE NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_BE NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_BE NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_BE NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_BE NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_BE NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_BE NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_BE NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_BE NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_BE NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_BE NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_BE NULL
#define OPTION_VAL_TWB64_195_EVA_01_BE NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_BE NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_BE NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_BE NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_BE NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_BE NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_BE "> Палітра TWB64 - Пакет 3"
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_BE "Выбар убудаванай палітры каларызацыі, калі для опцыі 'Убудаваная палітра' зададзена 'TWB64 - Пакет 3'."
#define OPTION_VAL_TWB64_201_DMG_GOLD_BE NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_BE NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_BE NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_BE NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_BE NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_BE NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_BE NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_BE NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_BE NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_BE NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_BE NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_BE NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_BE NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_BE NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_BE NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_BE NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_BE NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_BE NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_BE NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_BE NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_BE NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_BE NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_BE NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_BE NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_BE NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_BE NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_BE NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_BE NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_BE NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_BE NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_BE NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_BE NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_BE NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_BE NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_BE NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_BE NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_BE NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_BE NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_BE NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_BE NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_BE NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_BE NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_BE NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_BE NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_BE NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_BE NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_BE NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_BE NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_BE NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_BE NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_BE NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_BE NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_BE NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_BE NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_BE NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_BE NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_BE NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_BE NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_BE NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_BE NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_BE NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_BE NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_BE NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_BE NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_BE NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_BE NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_BE NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_BE NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_BE NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_BE NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_BE NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_BE NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_BE NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_BE NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_BE NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_BE NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_BE NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_BE NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_BE NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_BE NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_BE NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_BE NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_BE NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_BE NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_BE NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_BE NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_BE NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_BE NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_BE NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_BE NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_BE NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_BE NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_BE NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_BE NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_BE NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_BE NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_BE NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_BE NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_BE NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_BE NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_BE "> Палітра PixelShift - Пакет 1"
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_BE "Выбар убудаванай палітры каларызацыі, калі для опцыі 'Убудаваная палітра' зададзена 'PixelShift - Пакет 1'."
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_BE NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_BE NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_BE NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_BE NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_BE NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_BE NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_BE NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_BE NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_BE NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_BE NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_BE NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_BE NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_BE NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_BE NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_BE NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_BE NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_BE NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__BE NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_BE NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_BE NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_BE NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_BE NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_BE NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_BE NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_BE NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_BE NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_BE NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_BE NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_BE NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_BE NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_BE NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_BE NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_BE NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_BE NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_BE NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_BE NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_BE NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_BE NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_BE NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_BE NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_BE NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_BE NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_BE NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_BE NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_BE NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_BE "Карэкцыя колеру"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_BE "Падладка каляровасці для адпаведнасці малюнку на дысплеі рэальнага Game Boy Color. 'Толькі GBC' ужывае карэкцыю пры запуску гульняў Game Boy Color ці калі для каларызацыі гульні Game Boy выкарыстоўваецца палітра Game Boy Color. 'Заўсёды' ужывае колеракарэкцыю да ўсяго кантэнту і прыводзіць да непажаданых вынікаў пры выкарыстанні ўбудаваных палітраў 'GB' або 'SGB'."
#define OPTION_VAL_GBC_ONLY_BE "Толькі GBC"
#define OPTION_VAL_ALWAYS_BE "Заўсёды"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_BE "Рэжым карэкцыі колеру"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_BE "Выбар рэжыму, які выкарыстоўваецца для колеракарэкцыі. 'Дакладны' прайгравае колеры практычна неадрозна ад рэальнай ВК-панэлі Game Boy Color. 'Хуткі' толькі зацямняе колеры і памяншае насычанасць і падыходзіць для слабых прылад у тым выпадку, калі 'Дакладны' рэжым працуе занадта павольна."
#define OPTION_VAL_ACCURATE_BE "Дакладны"
#define OPTION_VAL_FAST_BE "Хуткі"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_BE "Карэкцыя колеру - крыніца святла"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_BE "Імітуе фізічны водгук ВК-панэлі Game Boy Color пры асвятленні з розных кутоў. 'Па цэнтры' адпавядае стандартнай колераперадачы. 'Над экранам' павялічвае яркасць. 'Пад экранам' памяншае яркасць. Дадзеная налада ўжываецца толькі ў тым выпадку, калі 'Рэжым колеракарэкцыі' мае значэнне 'Дакладны'."
#define OPTION_VAL_CENTRAL_BE "Цэнтральны"
#define OPTION_VAL_ABOVE_SCREEN_BE "Над экранам"
#define OPTION_VAL_BELOW_SCREEN_BE "Пад экранам"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_BE "Узровень фільтра зацямнення (%)"
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_BE "Уключае памяншэнне яркасці ў залежнасці ад навакольнага асвятлення. Можа выкарыстоўвацца для зніжэння нагрузкі на вочы ў гульнях з белым заднім фонам, якія прызначаны для Game Boy Color без падсвятлення і з-за залішняй яркасці могуць выклікаць дыскамфорт на сучасных экранах з падсветкай."
#define GAMBATTE_MIX_FRAMES_LABEL_BE "Міжкадравае змешванне"
#define GAMBATTE_MIX_FRAMES_INFO_0_BE "Імітацыя эфекту дваення LCD. 'Простае' змешвае бягучыя кадры з папярэднімі ў прапорцыі 50:50. 'Дваенне LCD' імітуе натуральны час водгуку LCD аб'яднаннем некалькіх буфераваных кадраў. \"Простае\" змешванне патрабуецца для гульняў, якія выкарыстоўваюць LCD-гостынг для эфектаў празрыстасці (Wave Race, Ballistic, Chikyuu Kaihou Gun ZAS...)."
#define OPTION_VAL_MIX_BE "Простае"
#define OPTION_VAL_LCD_GHOSTING_BE "Дваенне ВК (дакладна)"
#define OPTION_VAL_LCD_GHOSTING_FAST_BE "Дваенне ВК (хутка)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_BE "Перадыскрэтызацыя гуку"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_BE "Алгарытм перадіскрэтызацыі згенераванага гуку (частата гуку Game Boy абмежавана толькі хуткасцю запісу CPU кансолі, т. ч., 'натыўныя' частоты на сучасных гукавых прыладах непрымяняльныя і патрабуюць паніжэнні). 'Сінусны' забяспечвае найлепшую якасць. 'Касінусны' паляпшае прадукцыйнасць для слабых прылад."
#define OPTION_VAL_SINC_BE "Сінусны"
#define OPTION_VAL_CC_BE "Касінусны"
#define GAMBATTE_GB_HWMODE_LABEL_BE "Мадэль кансолі (патрабуецца перазапуск)"
#define GAMBATTE_GB_HWMODE_INFO_0_BE "Выбар сістэмы для эмуляцыі. Рэкамендуецца ўсталяваць «Аўта». Выбар 'GBA' адкрывае новыя магчымасці ў некаторых гульнях Game Boy Color з паляпшэннямі для GBA (Shantae, Wendy - Every Witch Way, Legend of Zelda: Oracle of Seasons/Ages...)."
#define OPTION_VAL_GB_BE NULL
#define OPTION_VAL_GBA_BE NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_BE "Выкарыстоўваць афіцыйны загрузчык (патрабуецца перазапуск)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_BE "Уключае падтрымку афіцыйных загрузчыкаў Game Boy і Game Boy Color з адпаведнай анімацыяй запуску."
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_BE "Дазволіць супрацьлеглыя напрамкі"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_BE "Дазваляе націскаць/хутка змяняць/адначасова заціскаць кірункі налева і направа (ці ўверх і ўніз). Можа выклікаць глітчы, злучаныя з перасоўваннем."
#define GAMBATTE_TURBO_PERIOD_LABEL_BE "Перыяд турба-кнопкі"
#define GAMBATTE_TURBO_PERIOD_INFO_0_BE "Усталёўвае інтэрвал паўтору (у кадрах) пры ўтрыманні турба-кнопак A/B."
#define GAMBATTE_RUMBLE_LEVEL_LABEL_BE "Інтэнсіўнасць аддачы кантролера"
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_BE "Уключае эфекты тактыльнай аддачы для гульняў з падтрымкай (Pokemon Pinball, Perfect Dark...)."
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_BE "Паказваць налады Game Link"
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_BE "Уключае настройку сеткавых параметраў (мультыплэера) Game Link. Для прымянення змен патрабуецца пераключыць хуткае меню."
#define GAMBATTE_GB_LINK_MODE_LABEL_BE "Рэжым Game Link"
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_BE "Рэжым сувязі"
#define GAMBATTE_GB_LINK_MODE_INFO_0_BE "Пры ўключэнні Game Link усталёўвае рэжым сервера або кліента для запушчанага ядра."
#define OPTION_VAL_NOT_CONNECTED_BE "Падлучэнне адсутнічае"
#define OPTION_VAL_NETWORK_SERVER_BE "Сеткавы сервер"
#define OPTION_VAL_NETWORK_CLIENT_BE "Сеткавы кліент"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_BE "Сеткавы порт сувязі"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_BE "Порт"
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_BE "Устанаўлівае порт, які выкарыстоўваецца для сувязі з Game Link."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_BE "Адрас сеткавага сервера сувязі з. 01: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_BE "Адрас сервера ч. 01: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_BE "1-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_BE "1-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_BE "Адрас сеткавага сервера сувязі з. 02: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_BE "Адрас сервера ч. 02: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_BE "2-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_BE "2-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_BE "Адрас сеткавага сервера сувязі з. 03: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_BE "Адрас сервера ч. 03: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_BE "3-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_BE "3-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_BE "Адрас сеткавага сервера сувязі з. 04: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_BE "Адрас сервера ч. 04: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_BE "4-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_BE "4-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_BE "Адрас сеткавага сервера сувязі з. 05: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_BE "Адрас сервера ч. 05: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_BE "5-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_BE "5-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_BE "Адрас сеткавага сервера сувязі з. 06: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_BE "Адрас сервера ч. 06: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_BE "6-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_BE "6-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_BE "Адрас сеткавага сервера сувязі з. 07: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_BE "Адрас сервера ч. 07: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_BE "7-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_BE "7-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_BE "Адрас сеткавага сервера сувязі з. 08: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_BE "Адрас сервера ч. 08: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_BE "8-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_BE "8-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_BE "Адрас сеткавага сервера сувязі з. 09: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_BE "Адрас сервера ч. 09: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_BE "9-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_BE "9-я лічба IP-адраса аддаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_BE "Адрас сеткавага сервера сувязі з. 10: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_BE "Адрас сервера ч. 10: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_BE "10-я лічба IP-адраса выдаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_BE "10-я лічба IP-адраса выдаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_BE "Адрас сеткавага сервера сувязі з. 11: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_BE "Адрас сервера ч. 11: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_BE "11-я лічба IP-адраса выдаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_BE "11-я лічба IP-адраса выдаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_BE "Адрас сеткавага сервера сувязі з. 12: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_BE "Адрас сервера ч. 12: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_BE "12-я лічба IP-адраса выдаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым Game Link' усталяваны ў 'Сеткавы кліент'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_BE "12-я лічба IP-адраса выдаленага сервера Game Link. Выкарыстоўваецца толькі калі 'Рэжым сувязі' усталяваны ў 'Сеткавы кліент'."

struct retro_core_option_v2_category option_cats_be[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_BE,
      CATEGORY_GB_LINK_INFO_0_BE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_be[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_BE,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_BE,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_BE },
         { "GBC",      OPTION_VAL_GBC_BE },
         { "SGB",      OPTION_VAL_SGB_BE },
         { "internal", OPTION_VAL_INTERNAL_BE },
         { "custom",   OPTION_VAL_CUSTOM_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_BE,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_BE,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_BE },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_BE },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_BE },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_BE },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_BE },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_BE },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_BE },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_BE },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_BE },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_BE },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_BE },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_BE },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_BE },
         { "GBC - Red",                OPTION_VAL_GBC_RED_BE },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_BE },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_BE },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_BE },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_BE },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_BE },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_BE },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_BE },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_BE },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_BE },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_BE },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_BE },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_BE },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_BE },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_BE },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_BE },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_BE },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_BE },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_BE },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_BE },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_BE },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_BE },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_BE },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_BE },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_BE },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_BE },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_BE },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_BE },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_BE },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_BE },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_BE },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_BE },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_BE },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_BE },
         { "Special 1",                OPTION_VAL_SPECIAL_1_BE },
         { "Special 2",                OPTION_VAL_SPECIAL_2_BE },
         { "Special 3",                OPTION_VAL_SPECIAL_3_BE },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_BE },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_BE },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_BE },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_BE },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_BE },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_BE,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_BE,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_BE },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_BE },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_BE },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_BE },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_BE },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_BE },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_BE },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_BE },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_BE },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_BE },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_BE },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_BE },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_BE },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_BE },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_BE },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_BE },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_BE },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_BE },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_BE },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_BE },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_BE },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_BE },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_BE },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_BE },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_BE },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_BE },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_BE },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_BE },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_BE },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_BE },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_BE },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_BE },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_BE },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_BE },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_BE },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_BE },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_BE },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_BE },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_BE },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_BE },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_BE },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_BE },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_BE },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_BE },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_BE },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_BE },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_BE },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_BE },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_BE },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_BE },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_BE },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_BE },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_BE },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_BE },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_BE },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_BE },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_BE },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_BE },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_BE },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_BE },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_BE },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_BE },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_BE },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_BE },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_BE },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_BE },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_BE },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_BE },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_BE },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_BE },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_BE },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_BE },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_BE },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_BE },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_BE },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_BE },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_BE },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_BE },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_BE },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_BE },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_BE },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_BE },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_BE },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_BE },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_BE },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_BE },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_BE },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_BE },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_BE },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_BE },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_BE },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_BE },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_BE },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_BE },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_BE },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_BE },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_BE },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_BE },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_BE },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_BE },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_BE,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_BE,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_BE },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_BE },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_BE },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_BE },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_BE },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_BE },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_BE },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_BE },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_BE },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_BE },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_BE },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_BE },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_BE },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_BE },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_BE },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_BE },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_BE },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_BE },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_BE },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_BE },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_BE },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_BE },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_BE },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_BE },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_BE },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_BE },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_BE },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_BE },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_BE },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_BE },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_BE },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_BE },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_BE },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_BE },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_BE },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_BE },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_BE },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_BE },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_BE },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_BE },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_BE },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_BE },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_BE },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_BE },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_BE },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_BE },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_BE },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_BE },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_BE },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_BE },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_BE },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_BE },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_BE },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_BE },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_BE },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_BE },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_BE },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_BE },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_BE },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_BE },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_BE },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_BE },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_BE },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_BE },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_BE },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_BE },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_BE },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_BE },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_BE },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_BE },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_BE },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_BE },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_BE },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_BE },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_BE },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_BE },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_BE },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_BE },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_BE },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_BE },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_BE },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_BE },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_BE },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_BE },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_BE },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_BE },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_BE },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_BE },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_BE },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_BE },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_BE },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_BE },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_BE },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_BE },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_BE },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_BE },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_BE },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_BE },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_BE },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_BE },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_BE,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_BE,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_BE },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_BE },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_BE },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_BE },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_BE },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_BE },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_BE },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_BE },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_BE },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_BE },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_BE },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_BE },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_BE },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_BE },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_BE },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_BE },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_BE },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_BE },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_BE },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_BE },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_BE },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_BE },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_BE },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_BE },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_BE },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_BE },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_BE },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_BE },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_BE },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_BE },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_BE },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_BE },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_BE },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_BE },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_BE },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_BE },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_BE },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_BE },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_BE },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_BE },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_BE },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_BE },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_BE },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_BE },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_BE },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_BE },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_BE },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_BE },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_BE },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_BE },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_BE },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_BE },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_BE },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_BE },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_BE },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_BE },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_BE },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_BE },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_BE },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_BE },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_BE },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_BE },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_BE },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_BE },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_BE },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_BE },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_BE },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_BE },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_BE },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_BE },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_BE },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_BE },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_BE },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_BE },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_BE },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_BE },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_BE },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_BE },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_BE },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_BE },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_BE },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_BE },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_BE },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_BE },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_BE },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_BE },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_BE },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_BE },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_BE },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_BE },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_BE },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_BE },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_BE },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_BE },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_BE },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_BE },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_BE },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_BE },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_BE },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_BE },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_BE,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_BE,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_BE },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_BE },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_BE },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_BE },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_BE },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_BE },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_BE },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_BE },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_BE },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_BE },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_BE },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_BE },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_BE },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_BE },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_BE },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_BE },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_BE },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__BE },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_BE },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_BE },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_BE },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_BE },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_BE },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_BE },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_BE },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_BE },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_BE },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_BE },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_BE },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_BE },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_BE },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_BE },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_BE },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_BE },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_BE },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_BE },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_BE },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_BE },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_BE },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_BE },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_BE },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_BE },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_BE },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_BE },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_BE },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_BE,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_BE,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_BE },
         { "always",   OPTION_VAL_ALWAYS_BE },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_BE,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_BE,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_BE },
         { "fast",     OPTION_VAL_FAST_BE },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_BE,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_BE,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_BE },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_BE },
         { "below screen", OPTION_VAL_BELOW_SCREEN_BE },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_BE,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_BE,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_BE,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_BE,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_BE },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_BE },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_BE,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_BE,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_BE },
         { "cc",   OPTION_VAL_CC_BE },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_BE,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_BE,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_BE },
         { "GB",   OPTION_VAL_GB_BE },
         { "GBC",  OPTION_VAL_GBC_BE },
         { "GBA",  OPTION_VAL_GBA_BE },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_BE,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_BE,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_BE,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_BE,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_BE,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_BE,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_BE,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_BE,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_BE,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_BE,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_BE,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_MODE_INFO_0_BE,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_BE },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_BE },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_BE },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_BE,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_BE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_BE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_be = {
   option_cats_be,
   option_defs_be
};

/* RETRO_LANGUAGE_BG */

#define CATEGORY_GB_LINK_LABEL_BG NULL
#define CATEGORY_GB_LINK_INFO_0_BG NULL
#define GAMBATTE_GB_COLORIZATION_LABEL_BG NULL
#define GAMBATTE_GB_COLORIZATION_INFO_0_BG NULL
#define OPTION_VAL_AUTO_BG NULL
#define OPTION_VAL_GBC_BG NULL
#define OPTION_VAL_SGB_BG NULL
#define OPTION_VAL_INTERNAL_BG NULL
#define OPTION_VAL_CUSTOM_BG NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_BG NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_BG NULL
#define OPTION_VAL_GB_DMG_BG NULL
#define OPTION_VAL_GB_POCKET_BG NULL
#define OPTION_VAL_GB_LIGHT_BG NULL
#define OPTION_VAL_GBC_BLUE_BG NULL
#define OPTION_VAL_GBC_BROWN_BG NULL
#define OPTION_VAL_GBC_DARK_BLUE_BG NULL
#define OPTION_VAL_GBC_DARK_BROWN_BG NULL
#define OPTION_VAL_GBC_DARK_GREEN_BG NULL
#define OPTION_VAL_GBC_GRAYSCALE_BG NULL
#define OPTION_VAL_GBC_GREEN_BG NULL
#define OPTION_VAL_GBC_INVERTED_BG NULL
#define OPTION_VAL_GBC_ORANGE_BG NULL
#define OPTION_VAL_GBC_PASTEL_MIX_BG NULL
#define OPTION_VAL_GBC_RED_BG NULL
#define OPTION_VAL_GBC_YELLOW_BG NULL
#define OPTION_VAL_SGB_1A_BG NULL
#define OPTION_VAL_SGB_1B_BG NULL
#define OPTION_VAL_SGB_1C_BG NULL
#define OPTION_VAL_SGB_1D_BG NULL
#define OPTION_VAL_SGB_1E_BG NULL
#define OPTION_VAL_SGB_1F_BG NULL
#define OPTION_VAL_SGB_1G_BG NULL
#define OPTION_VAL_SGB_1H_BG NULL
#define OPTION_VAL_SGB_2A_BG NULL
#define OPTION_VAL_SGB_2B_BG NULL
#define OPTION_VAL_SGB_2C_BG NULL
#define OPTION_VAL_SGB_2D_BG NULL
#define OPTION_VAL_SGB_2E_BG NULL
#define OPTION_VAL_SGB_2F_BG NULL
#define OPTION_VAL_SGB_2G_BG NULL
#define OPTION_VAL_SGB_2H_BG NULL
#define OPTION_VAL_SGB_3A_BG NULL
#define OPTION_VAL_SGB_3B_BG NULL
#define OPTION_VAL_SGB_3C_BG NULL
#define OPTION_VAL_SGB_3D_BG NULL
#define OPTION_VAL_SGB_3E_BG NULL
#define OPTION_VAL_SGB_3F_BG NULL
#define OPTION_VAL_SGB_3G_BG NULL
#define OPTION_VAL_SGB_3H_BG NULL
#define OPTION_VAL_SGB_4A_BG NULL
#define OPTION_VAL_SGB_4B_BG NULL
#define OPTION_VAL_SGB_4C_BG NULL
#define OPTION_VAL_SGB_4D_BG NULL
#define OPTION_VAL_SGB_4E_BG NULL
#define OPTION_VAL_SGB_4F_BG NULL
#define OPTION_VAL_SGB_4G_BG NULL
#define OPTION_VAL_SGB_4H_BG NULL
#define OPTION_VAL_SPECIAL_1_BG NULL
#define OPTION_VAL_SPECIAL_2_BG NULL
#define OPTION_VAL_SPECIAL_3_BG NULL
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_BG NULL
#define OPTION_VAL_TWB64_PACK_1_BG NULL
#define OPTION_VAL_TWB64_PACK_2_BG NULL
#define OPTION_VAL_TWB64_PACK_3_BG NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_BG NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_BG NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_BG NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_BG NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_BG NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_BG NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_BG NULL
#define OPTION_VAL_TWB64_005_NEON_RED_BG NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_BG NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_BG NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_BG NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_BG NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_BG NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_BG NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_BG NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_BG NULL
#define OPTION_VAL_TWB64_014_DMG_099_BG NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_BG NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_BG NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_BG NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_BG NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_BG NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_BG NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_BG NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_BG NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_BG NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_BG NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_BG NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_BG NULL
#define OPTION_VAL_TWB64_027_BMO_VER_BG NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_BG NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_BG NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_BG NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_BG NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_BG NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_BG NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_BG NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_BG NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_BG NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_BG NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_BG NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_BG NULL
#define OPTION_VAL_TWB64_040_DMG_VER_BG NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_BG NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_BG NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_BG NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_BG NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_BG NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_BG NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_BG NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_BG NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_BG NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_BG NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_BG NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_BG NULL
#define OPTION_VAL_TWB64_053_VMU_VER_BG NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_BG NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_BG NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_BG NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_BG NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_BG NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_BG NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_BG NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_BG NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_BG NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_BG NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_BG NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_BG NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_BG NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_BG NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_BG NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_BG NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_BG NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_BG NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_BG NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_BG NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_BG NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_BG NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_BG NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_BG NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_BG NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_BG NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_BG NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_BG NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_BG NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_BG NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_BG NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_BG NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_BG NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_BG NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_BG NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_BG NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_BG NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_BG NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_BG NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_BG NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_BG NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_BG NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_BG NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_BG NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_BG NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_BG NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_BG NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_BG NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_BG NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_BG NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_BG NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_BG NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_BG NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_BG NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_BG NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_BG NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_BG NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_BG NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_BG NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_BG NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_BG NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_BG NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_BG NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_BG NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_BG NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_BG NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_BG NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_BG NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_BG NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_BG NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_BG NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_BG NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_BG NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_BG NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_BG NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_BG NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_BG NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_BG NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_BG NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_BG NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_BG NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_BG NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_BG NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_BG NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_BG NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_BG NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_BG NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_BG NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_BG NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_BG NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_BG NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_BG NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_BG NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_BG NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_BG NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_BG NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_BG NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_BG NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_BG NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_BG NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_BG NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_BG NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_BG NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_BG NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_BG NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_BG NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_BG NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_BG NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_BG NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_BG NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_BG NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_BG NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_BG NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_BG NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_BG NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_BG NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_BG NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_BG NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_BG NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_BG NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_BG NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_BG NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_BG NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_BG NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_BG NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_BG NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_BG NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_BG NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_BG NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_BG NULL
#define OPTION_VAL_TWB64_182_PASTEL109_BG NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_BG NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_BG NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_BG NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_BG NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_BG NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_BG NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_BG NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_BG NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_BG NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_BG NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_BG NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_BG NULL
#define OPTION_VAL_TWB64_195_EVA_01_BG NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_BG NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_BG NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_BG NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_BG NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_BG NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_BG NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_BG NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_BG NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_BG NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_BG NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_BG NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_BG NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_BG NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_BG NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_BG NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_BG NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_BG NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_BG NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_BG NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_BG NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_BG NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_BG NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_BG NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_BG NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_BG NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_BG NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_BG NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_BG NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_BG NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_BG NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_BG NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_BG NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_BG NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_BG NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_BG NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_BG NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_BG NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_BG NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_BG NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_BG NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_BG NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_BG NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_BG NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_BG NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_BG NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_BG NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_BG NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_BG NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_BG NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_BG NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_BG NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_BG NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_BG NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_BG NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_BG NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_BG NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_BG NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_BG NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_BG NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_BG NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_BG NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_BG NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_BG NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_BG NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_BG NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_BG NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_BG NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_BG NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_BG NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_BG NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_BG NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_BG NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_BG NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_BG NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_BG NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_BG NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_BG NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_BG NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_BG NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_BG NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_BG NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_BG NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_BG NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_BG NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_BG NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_BG NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_BG NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_BG NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_BG NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_BG NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_BG NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_BG NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_BG NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_BG NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_BG NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_BG NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_BG NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_BG NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_BG NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_BG NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_BG NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_BG NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_BG NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_BG NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_BG NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_BG NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_BG NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_BG NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_BG NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_BG NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_BG NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_BG NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_BG NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_BG NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_BG NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_BG NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_BG NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_BG NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_BG NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_BG NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_BG NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_BG NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_BG NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_BG NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_BG NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_BG NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__BG NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_BG NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_BG NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_BG NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_BG NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_BG NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_BG NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_BG NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_BG NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_BG NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_BG NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_BG NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_BG NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_BG NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_BG NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_BG NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_BG NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_BG NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_BG NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_BG NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_BG NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_BG NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_BG NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_BG NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_BG NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_BG NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_BG NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_BG NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_BG NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_BG NULL
#define OPTION_VAL_GBC_ONLY_BG NULL
#define OPTION_VAL_ALWAYS_BG NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_BG NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_BG NULL
#define OPTION_VAL_ACCURATE_BG NULL
#define OPTION_VAL_FAST_BG NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_BG NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_BG NULL
#define OPTION_VAL_CENTRAL_BG NULL
#define OPTION_VAL_ABOVE_SCREEN_BG NULL
#define OPTION_VAL_BELOW_SCREEN_BG NULL
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_BG NULL
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_BG NULL
#define GAMBATTE_MIX_FRAMES_LABEL_BG NULL
#define GAMBATTE_MIX_FRAMES_INFO_0_BG NULL
#define OPTION_VAL_MIX_BG NULL
#define OPTION_VAL_LCD_GHOSTING_BG NULL
#define OPTION_VAL_LCD_GHOSTING_FAST_BG NULL
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_BG NULL
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_BG NULL
#define OPTION_VAL_SINC_BG NULL
#define OPTION_VAL_CC_BG NULL
#define GAMBATTE_GB_HWMODE_LABEL_BG NULL
#define GAMBATTE_GB_HWMODE_INFO_0_BG NULL
#define OPTION_VAL_GB_BG NULL
#define OPTION_VAL_GBA_BG NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_BG NULL
#define GAMBATTE_GB_BOOTLOADER_INFO_0_BG NULL
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_BG NULL
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_BG NULL
#define GAMBATTE_TURBO_PERIOD_LABEL_BG NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_BG NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_BG NULL
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_BG NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_BG NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_BG NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_BG NULL
#define OPTION_VAL_NOT_CONNECTED_BG NULL
#define OPTION_VAL_NETWORK_SERVER_BG NULL
#define OPTION_VAL_NETWORK_CLIENT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_BG NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_BG NULL

struct retro_core_option_v2_category option_cats_bg[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_BG,
      CATEGORY_GB_LINK_INFO_0_BG
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_bg[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_BG,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_BG,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_BG },
         { "GBC",      OPTION_VAL_GBC_BG },
         { "SGB",      OPTION_VAL_SGB_BG },
         { "internal", OPTION_VAL_INTERNAL_BG },
         { "custom",   OPTION_VAL_CUSTOM_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_BG,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_BG,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_BG },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_BG },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_BG },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_BG },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_BG },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_BG },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_BG },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_BG },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_BG },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_BG },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_BG },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_BG },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_BG },
         { "GBC - Red",                OPTION_VAL_GBC_RED_BG },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_BG },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_BG },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_BG },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_BG },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_BG },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_BG },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_BG },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_BG },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_BG },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_BG },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_BG },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_BG },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_BG },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_BG },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_BG },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_BG },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_BG },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_BG },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_BG },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_BG },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_BG },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_BG },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_BG },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_BG },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_BG },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_BG },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_BG },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_BG },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_BG },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_BG },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_BG },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_BG },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_BG },
         { "Special 1",                OPTION_VAL_SPECIAL_1_BG },
         { "Special 2",                OPTION_VAL_SPECIAL_2_BG },
         { "Special 3",                OPTION_VAL_SPECIAL_3_BG },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_BG },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_BG },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_BG },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_BG },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_BG },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_BG,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_BG,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_BG },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_BG },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_BG },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_BG },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_BG },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_BG },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_BG },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_BG },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_BG },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_BG },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_BG },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_BG },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_BG },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_BG },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_BG },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_BG },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_BG },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_BG },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_BG },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_BG },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_BG },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_BG },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_BG },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_BG },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_BG },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_BG },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_BG },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_BG },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_BG },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_BG },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_BG },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_BG },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_BG },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_BG },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_BG },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_BG },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_BG },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_BG },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_BG },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_BG },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_BG },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_BG },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_BG },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_BG },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_BG },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_BG },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_BG },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_BG },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_BG },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_BG },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_BG },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_BG },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_BG },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_BG },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_BG },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_BG },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_BG },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_BG },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_BG },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_BG },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_BG },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_BG },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_BG },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_BG },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_BG },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_BG },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_BG },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_BG },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_BG },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_BG },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_BG },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_BG },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_BG },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_BG },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_BG },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_BG },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_BG },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_BG },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_BG },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_BG },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_BG },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_BG },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_BG },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_BG },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_BG },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_BG },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_BG },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_BG },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_BG },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_BG },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_BG },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_BG },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_BG },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_BG },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_BG },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_BG },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_BG },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_BG },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_BG },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_BG },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_BG,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_BG,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_BG },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_BG },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_BG },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_BG },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_BG },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_BG },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_BG },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_BG },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_BG },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_BG },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_BG },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_BG },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_BG },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_BG },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_BG },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_BG },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_BG },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_BG },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_BG },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_BG },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_BG },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_BG },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_BG },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_BG },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_BG },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_BG },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_BG },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_BG },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_BG },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_BG },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_BG },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_BG },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_BG },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_BG },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_BG },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_BG },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_BG },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_BG },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_BG },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_BG },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_BG },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_BG },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_BG },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_BG },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_BG },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_BG },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_BG },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_BG },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_BG },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_BG },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_BG },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_BG },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_BG },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_BG },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_BG },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_BG },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_BG },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_BG },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_BG },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_BG },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_BG },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_BG },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_BG },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_BG },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_BG },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_BG },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_BG },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_BG },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_BG },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_BG },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_BG },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_BG },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_BG },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_BG },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_BG },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_BG },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_BG },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_BG },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_BG },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_BG },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_BG },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_BG },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_BG },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_BG },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_BG },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_BG },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_BG },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_BG },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_BG },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_BG },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_BG },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_BG },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_BG },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_BG },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_BG },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_BG },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_BG },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_BG },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_BG },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_BG },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_BG,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_BG,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_BG },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_BG },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_BG },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_BG },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_BG },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_BG },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_BG },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_BG },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_BG },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_BG },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_BG },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_BG },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_BG },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_BG },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_BG },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_BG },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_BG },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_BG },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_BG },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_BG },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_BG },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_BG },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_BG },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_BG },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_BG },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_BG },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_BG },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_BG },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_BG },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_BG },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_BG },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_BG },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_BG },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_BG },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_BG },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_BG },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_BG },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_BG },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_BG },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_BG },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_BG },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_BG },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_BG },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_BG },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_BG },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_BG },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_BG },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_BG },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_BG },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_BG },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_BG },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_BG },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_BG },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_BG },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_BG },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_BG },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_BG },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_BG },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_BG },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_BG },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_BG },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_BG },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_BG },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_BG },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_BG },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_BG },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_BG },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_BG },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_BG },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_BG },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_BG },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_BG },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_BG },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_BG },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_BG },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_BG },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_BG },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_BG },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_BG },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_BG },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_BG },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_BG },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_BG },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_BG },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_BG },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_BG },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_BG },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_BG },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_BG },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_BG },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_BG },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_BG },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_BG },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_BG },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_BG },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_BG },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_BG },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_BG },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_BG },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_BG },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_BG,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_BG,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_BG },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_BG },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_BG },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_BG },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_BG },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_BG },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_BG },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_BG },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_BG },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_BG },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_BG },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_BG },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_BG },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_BG },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_BG },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_BG },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_BG },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__BG },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_BG },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_BG },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_BG },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_BG },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_BG },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_BG },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_BG },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_BG },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_BG },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_BG },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_BG },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_BG },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_BG },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_BG },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_BG },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_BG },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_BG },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_BG },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_BG },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_BG },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_BG },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_BG },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_BG },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_BG },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_BG },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_BG },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_BG },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_BG,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_BG,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_BG },
         { "always",   OPTION_VAL_ALWAYS_BG },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_BG,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_BG,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_BG },
         { "fast",     OPTION_VAL_FAST_BG },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_BG,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_BG,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_BG },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_BG },
         { "below screen", OPTION_VAL_BELOW_SCREEN_BG },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_BG,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_BG,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_BG,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_BG,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_BG },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_BG },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_BG,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_BG,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_BG },
         { "cc",   OPTION_VAL_CC_BG },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_BG,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_BG,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_BG },
         { "GB",   OPTION_VAL_GB_BG },
         { "GBC",  OPTION_VAL_GBC_BG },
         { "GBA",  OPTION_VAL_GBA_BG },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_BG,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_BG,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_BG,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_BG,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_BG,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_BG,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_BG,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_BG,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_BG,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_BG,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_BG,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_MODE_INFO_0_BG,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_BG },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_BG },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_BG },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_BG,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_BG,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_BG,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_bg = {
   option_cats_bg,
   option_defs_bg
};

/* RETRO_LANGUAGE_CA */

#define CATEGORY_GB_LINK_LABEL_CA NULL
#define CATEGORY_GB_LINK_INFO_0_CA "Canvia les opcions de connexió (multijugador) mitjançant el cable Game Link."
#define GAMBATTE_GB_COLORIZATION_LABEL_CA "Coloració de GB"
#define GAMBATTE_GB_COLORIZATION_INFO_0_CA "Habilita la coloració dels jocs de Game Boy. 'Automàtic' selecciona la millor paleta de colors (més apropiada). 'GBC' selecciona la paleta específica de Game Boy Color si està definida, si no, es fa servir 'GBC- Dark Green'. 'SGB' selecciona la paleta dissenyada per Super Game Boy si està definida, si no, es fa servir 'SGB 1A'. 'Interna' fa servir la paleta interna del nucli. 'Personalitzar' carrega una paleta de colors personalitzada de la carpeta del sistema."
#define OPTION_VAL_AUTO_CA "Automàtic"
#define OPTION_VAL_GBC_CA NULL
#define OPTION_VAL_SGB_CA NULL
#define OPTION_VAL_INTERNAL_CA "Intern"
#define OPTION_VAL_CUSTOM_CA "Personalitzat"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CA "Paleta de colors interna"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CA "Selecciona la paleta amb la qual acolorir els jocs de Game Boy quan l'opció d'acolorir de Game Boy està configurada com a 'Interna' o 'Automàtica', però el joc no té una paleta de colors definida per SGB o GBC. Les paletes de colors de GB emulen la pantalla original de Game Boy. Les paletes de colors de GBC son idèntiques a les predefinides en una Game Boy Color. Les paletes de color de SGB son idèntiques a les predefinides en una Super Game Boy."
#define OPTION_VAL_GB_DMG_CA NULL
#define OPTION_VAL_GB_POCKET_CA "GB - Butxaca"
#define OPTION_VAL_GB_LIGHT_CA "GB - Brillant"
#define OPTION_VAL_GBC_BLUE_CA "GBC - Blau"
#define OPTION_VAL_GBC_BROWN_CA "GBC - Marró"
#define OPTION_VAL_GBC_DARK_BLUE_CA "GB. - Blau fosc"
#define OPTION_VAL_GBC_DARK_BROWN_CA "GBC - Marró fosc"
#define OPTION_VAL_GBC_DARK_GREEN_CA "GBC - Verd fosc"
#define OPTION_VAL_GBC_GRAYSCALE_CA "GBC - Escala de grisos"
#define OPTION_VAL_GBC_GREEN_CA "GBC - Verd"
#define OPTION_VAL_GBC_INVERTED_CA "GBC - Invertida"
#define OPTION_VAL_GBC_ORANGE_CA "GBC - Taronja"
#define OPTION_VAL_GBC_PASTEL_MIX_CA "GBC - Pastel mix"
#define OPTION_VAL_GBC_RED_CA "GBC - Vermell"
#define OPTION_VAL_GBC_YELLOW_CA "GBC - Groc"
#define OPTION_VAL_SGB_1A_CA NULL
#define OPTION_VAL_SGB_1B_CA NULL
#define OPTION_VAL_SGB_1C_CA NULL
#define OPTION_VAL_SGB_1D_CA NULL
#define OPTION_VAL_SGB_1E_CA NULL
#define OPTION_VAL_SGB_1F_CA NULL
#define OPTION_VAL_SGB_1G_CA NULL
#define OPTION_VAL_SGB_1H_CA NULL
#define OPTION_VAL_SGB_2A_CA NULL
#define OPTION_VAL_SGB_2B_CA NULL
#define OPTION_VAL_SGB_2C_CA NULL
#define OPTION_VAL_SGB_2D_CA NULL
#define OPTION_VAL_SGB_2E_CA NULL
#define OPTION_VAL_SGB_2F_CA NULL
#define OPTION_VAL_SGB_2G_CA NULL
#define OPTION_VAL_SGB_2H_CA NULL
#define OPTION_VAL_SGB_3A_CA NULL
#define OPTION_VAL_SGB_3B_CA NULL
#define OPTION_VAL_SGB_3C_CA NULL
#define OPTION_VAL_SGB_3D_CA NULL
#define OPTION_VAL_SGB_3E_CA NULL
#define OPTION_VAL_SGB_3F_CA NULL
#define OPTION_VAL_SGB_3G_CA NULL
#define OPTION_VAL_SGB_3H_CA NULL
#define OPTION_VAL_SGB_4A_CA NULL
#define OPTION_VAL_SGB_4B_CA NULL
#define OPTION_VAL_SGB_4C_CA NULL
#define OPTION_VAL_SGB_4D_CA NULL
#define OPTION_VAL_SGB_4E_CA NULL
#define OPTION_VAL_SGB_4F_CA NULL
#define OPTION_VAL_SGB_4G_CA NULL
#define OPTION_VAL_SGB_4H_CA NULL
#define OPTION_VAL_SPECIAL_1_CA "Especial 1"
#define OPTION_VAL_SPECIAL_2_CA "Especial 2"
#define OPTION_VAL_SPECIAL_3_CA "Especial 3"
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CA NULL
#define OPTION_VAL_TWB64_PACK_1_CA NULL
#define OPTION_VAL_TWB64_PACK_2_CA NULL
#define OPTION_VAL_TWB64_PACK_3_CA NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_CA NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CA NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CA "Selecciona la paleta de colors interna a 'TWB64 - Pack 1'."
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_CA NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CA NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CA NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CA NULL
#define OPTION_VAL_TWB64_005_NEON_RED_CA NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_CA NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_CA NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_CA "TWB64 008 - Verd neó"
#define OPTION_VAL_TWB64_009_NEON_PINK_CA NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_CA NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_CA NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_CA NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_CA NULL
#define OPTION_VAL_TWB64_014_DMG_099_CA NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CA NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CA NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CA NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CA NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_CA NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CA NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_CA NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_CA NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CA NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CA NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CA NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_CA NULL
#define OPTION_VAL_TWB64_027_BMO_VER_CA NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_CA NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_CA NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CA NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CA NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CA NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CA NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_CA NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_CA NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CA NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CA NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CA NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_CA NULL
#define OPTION_VAL_TWB64_040_DMG_VER_CA NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_CA NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_CA NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CA NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CA NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CA NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_CA NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_CA NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_CA NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_CA NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_CA NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CA NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CA NULL
#define OPTION_VAL_TWB64_053_VMU_VER_CA NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_CA NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_CA NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_CA NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_CA NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_CA NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CA NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_CA NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_CA NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CA NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_CA NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_CA NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_CA NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CA NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_CA NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CA NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_CA NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_CA NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CA NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_CA NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CA NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CA NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CA NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_CA NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_CA NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_CA NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CA NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CA NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CA NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CA NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CA NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_CA NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CA NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CA NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_CA NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_CA NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CA NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CA NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_CA NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CA NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CA NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CA NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CA NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_CA NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CA NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CA NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CA NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CA NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CA NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CA "Selecciona la paleta de colors interna a 'TWB64 - Pack 2'."
#define OPTION_VAL_TWB64_101_765PRO_PINK_CA NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CA NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_CA NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_CA NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CA NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CA NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_CA NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_CA NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_CA NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CA NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_CA NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_CA NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_CA NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CA NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_CA NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CA NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_CA NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_CA NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_CA NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_CA NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CA NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CA NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_CA NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CA NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CA NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_CA NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_CA NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_CA NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_CA NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_CA NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_CA NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_CA NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CA NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_CA NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CA NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CA NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CA NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_CA NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_CA NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CA NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CA NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_CA NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CA NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CA NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CA NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CA NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_CA NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_CA NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CA NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CA NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CA NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CA NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_CA NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CA NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CA NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_CA NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_CA NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_CA NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CA NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_CA "TWB64 160 - Scarlett Green"
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_CA NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_CA NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_CA NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CA NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_CA NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CA NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_CA NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CA NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CA NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_CA NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_CA NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CA NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CA NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_CA NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CA NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_CA NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_CA NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_CA NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CA NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CA NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CA NULL
#define OPTION_VAL_TWB64_182_PASTEL109_CA NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CA NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_CA NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CA NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CA NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CA NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CA NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_CA NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_CA NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_CA NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CA NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CA NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CA NULL
#define OPTION_VAL_TWB64_195_EVA_01_CA NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_CA NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CA NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CA NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_CA NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CA NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CA NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CA "Selecciona la paleta de colors interna a 'TWB64 - Pack 3'."
#define OPTION_VAL_TWB64_201_DMG_GOLD_CA NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CA NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CA NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CA NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CA NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_CA NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CA NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CA NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CA NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_CA NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CA NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CA NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_CA NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CA NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CA NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CA NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CA NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_CA NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CA NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_CA NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_CA NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CA NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_CA NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_CA NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CA NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CA NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CA NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_CA NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CA NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CA NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CA NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CA NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CA NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CA NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CA NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CA NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CA NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_CA NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_CA NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CA NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CA NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CA NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_CA NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_CA NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_CA "TWB64 245 - Chozo Blau"
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CA NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_CA NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CA NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_CA NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CA NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CA NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CA NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CA NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_CA NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CA NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CA NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_CA NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CA NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CA NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CA NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_CA NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CA NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CA NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CA NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CA NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CA NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CA NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_CA NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CA NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CA NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CA NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CA NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CA NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CA NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CA NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CA NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CA NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CA NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CA NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CA NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CA NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CA NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CA NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CA NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_CA NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_CA NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CA NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CA NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CA NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_CA NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CA NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_CA NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CA NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_CA NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CA NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CA NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CA NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CA NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CA NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_CA NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CA NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CA "Selecciona la paleta de colors interna a 'PixelShift - Pack 1'."
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CA NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CA NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CA NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CA NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CA NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_CA NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CA NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CA NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_CA NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CA NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CA NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CA NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CA NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CA NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CA NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CA NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CA NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CA NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CA NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CA NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CA NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CA NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CA NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_CA NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CA NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_CA NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CA NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CA NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_CA NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CA NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CA NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CA NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CA NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CA NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_CA NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CA NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CA NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CA NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CA NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_CA NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CA NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_CA NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CA NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CA NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_CA NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CA "Correcció de color"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CA "Ajusta els colors de sortida del vídeo perquè s'assemblin als colors del maquinari real d'una Game Boy Color. 'Només per GBC' fa que només s'apliqui la correcció de color en executar jocs de Game Boy Color o en fer servir una paleta de colors de Game Boy Color en un joc de Game Boy. 'Sempre' aplicarà la correcció de color sobre tots els continguts, pot produir resultats inesperats o deficients en fer servir paletes internes de GB o SGB."
#define OPTION_VAL_GBC_ONLY_CA "Només GBC"
#define OPTION_VAL_ALWAYS_CA "Sempre"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CA "Mode de correcció de color"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CA "Especifica el mètode utilitzat per la correcció de color. 'Acurat' produeix una imatge quasi indistingible de la imatge real de la Game Boy Color. 'Ràpid' es limita a enfosquir els colors i reduir la saturació. L'opció 'Ràpid' es pot utilitzar en maquinari de gamma baixa si l'opció 'Acurat' és massa lenta."
#define OPTION_VAL_ACCURATE_CA "Precís"
#define OPTION_VAL_FAST_CA "Ràpida"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CA "Correcció de color - Posició de la llum frontal"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CA "Simula la resposta física del panell LCD d'una Game Boy Color quan s'il·lumina des de diferents angles. 'Centrada' representa la reproducció estàndard de color. 'Per sobre de la pantalla' augmenta la brillantor i 'Per sota de la pantalla' disminueix la brillantor. Aquest ajustament s'aplica només quan el mode de correcció de color està configurat com 'Precís'."
#define OPTION_VAL_CENTRAL_CA NULL
#define OPTION_VAL_ABOVE_SCREEN_CA "Per sobre la pantalla"
#define OPTION_VAL_BELOW_SCREEN_CA "Per sota la pantalla"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_CA "Nivell del filtre fosc (%)"
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CA "Permet reduir la brillantor mitjançant la lluminositat. Pot evitar reflexos o cansament de la vista en executar jocs amb el fons blanc que estan pensats per un Game Boy Color sense retroil·luminació i que poden mostrar una brillantor excessiva en una pantalla retroil·luminada moderna."
#define GAMBATTE_MIX_FRAMES_LABEL_CA "Fusió de fotogrames"
#define GAMBATTE_MIX_FRAMES_INFO_0_CA "Simula els efectes fantasma del LCD. 'Simple' mescla al 50% el fotograma actual i el fotograma anterior. 'Fantasmeig LCD' imita el temps de resposta real de la pantalla LCD combinant diferents fotogrames. 'Simple' és necessari per executar jocs que necessiten el fantasmeig LCD per efectes de transparència (Wave Race, Balllistic, Chikyuu Kaihou Gun ZAS...)."
#define OPTION_VAL_MIX_CA NULL
#define OPTION_VAL_LCD_GHOSTING_CA "Imatge fantasma de LCD (Acurat)"
#define OPTION_VAL_LCD_GHOSTING_FAST_CA "Imatge fantasma del LCD (ràpid)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_CA "Remostreig d'àudio"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_CA "Especifica l'algoritme utilitzat per remostrejar l'àudio generat (la ratio d'àudio de Game Boy està limitat per la velocitat de lectura de la CPU, pel qual les freqüències natives no son pràctiques en dispositius moderns). 'Sinc' produeix una millor qualitat. 'Cosine' millora el rendiment en sistemes de gamma baixa."
#define OPTION_VAL_SINC_CA NULL
#define OPTION_VAL_CC_CA NULL
#define GAMBATTE_GB_HWMODE_LABEL_CA "Maquinari emulat (Es requereix reinici)"
#define GAMBATTE_GB_HWMODE_INFO_0_CA "Especifica el tipus de maquinari a emular. Es recomana l'opció 'Auto'. Seleccionar 'GBA' desbloqueja algunes funcions extres en aquells jocs de Game Boy Color que tinguin el mode 'GBA Enhanced' (Shantae, Wendy - Every Witch Way, Legend of Zelda: Oracle of Seasons/Ages...)."
#define OPTION_VAL_GB_CA NULL
#define OPTION_VAL_GBA_CA NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_CA "Fes servir el carregador d'arrancada oficial (Es requereix reinici)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_CA "Activa el suport pels programes d'arrancada oficials de Game Boy i Game Boy Color amb les corresponents animacions inicials."
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_CA "Permet direccions oposades"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CA "Habilita aquesta opció per permetre alternar o mantenir les direccions esquerra i dreta (o amunt i avall) al mateix temps. Pot provocar errors en el moviment."
#define GAMBATTE_TURBO_PERIOD_LABEL_CA "Duració del botó Turbo"
#define GAMBATTE_TURBO_PERIOD_INFO_0_CA "Especifica l'interval (en fotogrames) en el qual es repetirà la pulsació dels botons A o B al mantenir polsats els botons de turbo equivalents."
#define GAMBATTE_RUMBLE_LEVEL_LABEL_CA "Força de la vibració del controlador"
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_CA "Activa els efectes de resposta hàptica en aquells jocs que siguin compatibles (Pokemon Pinball, Perfect Dark,...)."
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CA "Mostrar la configuració de Game Link"
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CA "Activa la configuració d'opcions del cable Game Link. NOTA: És necessari sortir i tornar a entrar al menú ràpid per a que el canvi tingui efecte."
#define GAMBATTE_GB_LINK_MODE_LABEL_CA "Mode de cable Game Link"
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_CA "Mode de connexió"
#define GAMBATTE_GB_LINK_MODE_INFO_0_CA "En activar la funció de xarxa del cable Game Link, aquesta opció especifica quina instància ha de fer de servidor i quina de client."
#define OPTION_VAL_NOT_CONNECTED_CA "Sense connexió"
#define OPTION_VAL_NETWORK_SERVER_CA "Servidor de xarxa"
#define OPTION_VAL_NETWORK_CLIENT_CA "Client de xarxa"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CA "Port d'enllaç a la xarxa"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CA NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CA "Especifica el port de xarxa que es farà servir per Game Link."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CA "Valor 01 de l'adreça de servidor: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CA "Valor 01 de l'adreça del servidor: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CA "El primer dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CA "El primer dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CA "Valor 02 de l'adreça de servidor: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CA "Valor 02 de l'adreça del servidor: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CA "El segon dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CA "El segon dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CA "Valor 03 de l'adreça de servidor: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CA "Valor 03 de l'adreça del servidor: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CA "El tercer dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CA "El tercer dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CA "Valor 04 de l'adreça de servidor: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CA "Valor 04 de l'adreça del servidor: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CA "El quart dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CA "El quart dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CA "Valor 05 de l'adreça de servidor: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CA "Valor 05 de l'adreça del servidor: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CA "El cinquè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CA "El cinquè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CA "Valor 06 de l'adreça de servidor: ___.__x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CA "Valor 06 de l'adreça del servidor: ___._x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CA "El sisè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CA "El sisè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CA "Valor 07 de l'adreça de servidor: ___.___.x__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CA "Valor 07 de l'adreça del servidor: ___.___.x__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CA "El setè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CA "El setè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CA "Valor 08 de l'adreça de servidor: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CA "Valor 08 de l'adreça del servidor: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CA "El vuitè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CA "El vuitè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CA "Valor 09 de l'adreça de servidor: ___.___.__x.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CA "Valor 09 de l'adreça del servidor: ___.___.__x.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CA "El novè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CA "El novè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CA "Valor 10 de l'adreça de servidor: ___.___.___.x__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CA "Valor 10 de l'adreça del servidor: ___.___.___.x__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CA "El desè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CA "El desè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CA "Valor 11 de l'adreça de servidor: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CA "Valor 11 de l'adreça del servidor: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CA "El onzè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CA "El onzè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CA "Valor 12 de l'adreça de servidor: ___.___.___.__x"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CA "Valor 12 de l'adreça del servidor: ___.___.___.__x"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CA "El dotzè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de cable Game Lint estigui configurat com 'Client de xarxa'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CA "El dotzè dígit de l'adreça IP del servidor de xarxa del cable Game Link. Només s'utilitzarà quan el mode de connexió sigui 'Client de xarxa'."

struct retro_core_option_v2_category option_cats_ca[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_CA,
      CATEGORY_GB_LINK_INFO_0_CA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ca[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_CA,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_CA,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CA },
         { "GBC",      OPTION_VAL_GBC_CA },
         { "SGB",      OPTION_VAL_SGB_CA },
         { "internal", OPTION_VAL_INTERNAL_CA },
         { "custom",   OPTION_VAL_CUSTOM_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CA,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CA,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_CA },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_CA },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_CA },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_CA },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_CA },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_CA },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_CA },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_CA },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_CA },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_CA },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_CA },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_CA },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_CA },
         { "GBC - Red",                OPTION_VAL_GBC_RED_CA },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_CA },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_CA },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_CA },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_CA },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_CA },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_CA },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_CA },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_CA },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_CA },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_CA },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_CA },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_CA },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_CA },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_CA },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_CA },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_CA },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_CA },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_CA },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_CA },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_CA },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_CA },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_CA },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_CA },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_CA },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_CA },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_CA },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_CA },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_CA },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_CA },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_CA },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_CA },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_CA },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_CA },
         { "Special 1",                OPTION_VAL_SPECIAL_1_CA },
         { "Special 2",                OPTION_VAL_SPECIAL_2_CA },
         { "Special 3",                OPTION_VAL_SPECIAL_3_CA },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CA },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_CA },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_CA },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_CA },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_CA },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CA,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CA,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_CA },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CA },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CA },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CA },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_CA },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_CA },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_CA },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_CA },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_CA },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_CA },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_CA },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_CA },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_CA },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_CA },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CA },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CA },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CA },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CA },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_CA },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CA },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_CA },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_CA },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CA },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CA },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CA },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_CA },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_CA },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_CA },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_CA },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CA },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CA },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CA },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CA },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_CA },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_CA },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CA },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CA },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CA },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_CA },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_CA },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_CA },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_CA },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CA },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CA },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CA },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_CA },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_CA },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_CA },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_CA },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_CA },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CA },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CA },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_CA },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_CA },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_CA },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_CA },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_CA },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_CA },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CA },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_CA },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_CA },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CA },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_CA },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_CA },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_CA },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CA },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_CA },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CA },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_CA },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_CA },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CA },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_CA },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CA },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CA },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CA },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_CA },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_CA },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_CA },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CA },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CA },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CA },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CA },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CA },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_CA },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CA },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CA },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_CA },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_CA },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CA },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CA },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_CA },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CA },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CA },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CA },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CA },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_CA },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CA },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CA },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CA },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CA },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CA,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CA,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_CA },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CA },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_CA },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_CA },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CA },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CA },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_CA },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_CA },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_CA },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CA },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_CA },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_CA },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_CA },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CA },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_CA },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CA },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_CA },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_CA },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_CA },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_CA },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CA },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CA },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_CA },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CA },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CA },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_CA },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_CA },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_CA },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_CA },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_CA },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_CA },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_CA },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CA },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_CA },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CA },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CA },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CA },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_CA },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_CA },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CA },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CA },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_CA },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CA },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CA },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CA },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CA },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_CA },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_CA },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CA },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CA },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CA },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CA },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_CA },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CA },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CA },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_CA },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_CA },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_CA },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CA },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_CA },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_CA },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_CA },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_CA },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CA },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_CA },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CA },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_CA },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CA },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CA },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_CA },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_CA },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CA },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CA },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_CA },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CA },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_CA },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_CA },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_CA },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CA },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CA },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CA },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_CA },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CA },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_CA },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CA },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CA },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CA },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CA },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_CA },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_CA },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_CA },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CA },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CA },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CA },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_CA },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_CA },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CA },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CA },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_CA },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CA },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CA,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CA,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_CA },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CA },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CA },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CA },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CA },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_CA },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CA },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CA },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CA },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_CA },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CA },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CA },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_CA },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CA },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CA },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CA },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CA },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_CA },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CA },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_CA },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_CA },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CA },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_CA },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_CA },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CA },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CA },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CA },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_CA },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CA },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CA },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CA },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CA },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CA },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CA },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CA },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CA },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CA },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_CA },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_CA },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CA },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CA },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CA },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_CA },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_CA },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_CA },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CA },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_CA },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CA },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_CA },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CA },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CA },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CA },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CA },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_CA },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CA },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CA },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_CA },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CA },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CA },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CA },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_CA },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CA },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CA },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CA },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CA },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CA },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CA },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_CA },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CA },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CA },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CA },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CA },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CA },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CA },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CA },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CA },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CA },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CA },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CA },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CA },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CA },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CA },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CA },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CA },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_CA },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_CA },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CA },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CA },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CA },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_CA },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CA },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_CA },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CA },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_CA },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CA },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CA },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CA },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CA },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CA },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_CA },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CA,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CA,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CA },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CA },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CA },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CA },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CA },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_CA },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CA },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CA },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_CA },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CA },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CA },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CA },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CA },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CA },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CA },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CA },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CA },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CA },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CA },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CA },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CA },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CA },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CA },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_CA },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CA },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_CA },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CA },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CA },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_CA },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CA },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CA },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CA },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CA },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CA },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_CA },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CA },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CA },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CA },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CA },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_CA },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CA },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_CA },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CA },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CA },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_CA },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CA,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CA,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_CA },
         { "always",   OPTION_VAL_ALWAYS_CA },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CA,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CA,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_CA },
         { "fast",     OPTION_VAL_FAST_CA },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CA,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CA,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_CA },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_CA },
         { "below screen", OPTION_VAL_BELOW_SCREEN_CA },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_CA,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CA,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_CA,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_CA,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_CA },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_CA },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_CA,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_CA,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_CA },
         { "cc",   OPTION_VAL_CC_CA },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_CA,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_CA,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_CA },
         { "GB",   OPTION_VAL_GB_CA },
         { "GBC",  OPTION_VAL_GBC_CA },
         { "GBA",  OPTION_VAL_GBA_CA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_CA,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_CA,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_CA,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CA,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_CA,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_CA,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_CA,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_CA,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CA,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CA,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_CA,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_MODE_INFO_0_CA,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_CA },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_CA },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_CA },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CA,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ca = {
   option_cats_ca,
   option_defs_ca
};

/* RETRO_LANGUAGE_CHS */

#define CATEGORY_GB_LINK_LABEL_CHS "游戏链接"
#define CATEGORY_GB_LINK_INFO_0_CHS "更改网络游戏链接 (多人)"
#define GAMBATTE_GB_COLORIZATION_LABEL_CHS "GB 调色"
#define GAMBATTE_GB_COLORIZATION_INFO_0_CHS NULL
#define OPTION_VAL_AUTO_CHS "自动"
#define OPTION_VAL_GBC_CHS NULL
#define OPTION_VAL_SGB_CHS NULL
#define OPTION_VAL_INTERNAL_CHS "内建"
#define OPTION_VAL_CUSTOM_CHS "自定义"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CHS "内部色板"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CHS "选择 'GB 色彩化' 时用于彩色游戏的调色板。'GB 色彩化' 设置为 '内部'， 或者当“GB 色彩化”设置为“自动”且游戏没有预定义的 SGB/GBC 调色板。 'GB'的调色板模拟GameBoy硬件的显示。'GBC' 色板与GameBoy颜色的内置预设相同。 'SGB'调色板与SuperGameBoy的内置预设相同。"
#define OPTION_VAL_GB_DMG_CHS NULL
#define OPTION_VAL_GB_POCKET_CHS NULL
#define OPTION_VAL_GB_LIGHT_CHS NULL
#define OPTION_VAL_GBC_BLUE_CHS NULL
#define OPTION_VAL_GBC_BROWN_CHS NULL
#define OPTION_VAL_GBC_DARK_BLUE_CHS NULL
#define OPTION_VAL_GBC_DARK_BROWN_CHS NULL
#define OPTION_VAL_GBC_DARK_GREEN_CHS NULL
#define OPTION_VAL_GBC_GRAYSCALE_CHS NULL
#define OPTION_VAL_GBC_GREEN_CHS NULL
#define OPTION_VAL_GBC_INVERTED_CHS NULL
#define OPTION_VAL_GBC_ORANGE_CHS NULL
#define OPTION_VAL_GBC_PASTEL_MIX_CHS NULL
#define OPTION_VAL_GBC_RED_CHS NULL
#define OPTION_VAL_GBC_YELLOW_CHS NULL
#define OPTION_VAL_SGB_1A_CHS NULL
#define OPTION_VAL_SGB_1B_CHS NULL
#define OPTION_VAL_SGB_1C_CHS NULL
#define OPTION_VAL_SGB_1D_CHS NULL
#define OPTION_VAL_SGB_1E_CHS NULL
#define OPTION_VAL_SGB_1F_CHS NULL
#define OPTION_VAL_SGB_1G_CHS NULL
#define OPTION_VAL_SGB_1H_CHS NULL
#define OPTION_VAL_SGB_2A_CHS NULL
#define OPTION_VAL_SGB_2B_CHS NULL
#define OPTION_VAL_SGB_2C_CHS NULL
#define OPTION_VAL_SGB_2D_CHS NULL
#define OPTION_VAL_SGB_2E_CHS NULL
#define OPTION_VAL_SGB_2F_CHS NULL
#define OPTION_VAL_SGB_2G_CHS NULL
#define OPTION_VAL_SGB_2H_CHS NULL
#define OPTION_VAL_SGB_3A_CHS NULL
#define OPTION_VAL_SGB_3B_CHS NULL
#define OPTION_VAL_SGB_3C_CHS NULL
#define OPTION_VAL_SGB_3D_CHS NULL
#define OPTION_VAL_SGB_3E_CHS NULL
#define OPTION_VAL_SGB_3F_CHS NULL
#define OPTION_VAL_SGB_3G_CHS NULL
#define OPTION_VAL_SGB_3H_CHS NULL
#define OPTION_VAL_SGB_4A_CHS NULL
#define OPTION_VAL_SGB_4B_CHS NULL
#define OPTION_VAL_SGB_4C_CHS NULL
#define OPTION_VAL_SGB_4D_CHS NULL
#define OPTION_VAL_SGB_4E_CHS NULL
#define OPTION_VAL_SGB_4F_CHS NULL
#define OPTION_VAL_SGB_4G_CHS NULL
#define OPTION_VAL_SGB_4H_CHS NULL
#define OPTION_VAL_SPECIAL_1_CHS NULL
#define OPTION_VAL_SPECIAL_2_CHS NULL
#define OPTION_VAL_SPECIAL_3_CHS NULL
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CHS NULL
#define OPTION_VAL_TWB64_PACK_1_CHS NULL
#define OPTION_VAL_TWB64_PACK_2_CHS NULL
#define OPTION_VAL_TWB64_PACK_3_CHS NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_CHS NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CHS NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CHS NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_CHS NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CHS NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CHS NULL
#define OPTION_VAL_TWB64_005_NEON_RED_CHS NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_CHS NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_CHS NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_CHS NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_CHS NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_CHS NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_CHS NULL
#define OPTION_VAL_TWB64_014_DMG_099_CHS NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CHS NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CHS NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CHS NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_CHS NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CHS NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_CHS NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_CHS NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CHS NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CHS NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CHS NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_CHS NULL
#define OPTION_VAL_TWB64_027_BMO_VER_CHS NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_CHS NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_CHS NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CHS NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CHS NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CHS NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CHS NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_CHS NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_CHS NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CHS NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CHS NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_CHS NULL
#define OPTION_VAL_TWB64_040_DMG_VER_CHS NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_CHS NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_CHS NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CHS NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CHS NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_CHS NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_CHS NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_CHS NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_CHS NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_CHS NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CHS NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CHS NULL
#define OPTION_VAL_TWB64_053_VMU_VER_CHS NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_CHS NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_CHS NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_CHS NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_CHS NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_CHS NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_CHS NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_CHS NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CHS NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_CHS NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_CHS NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_CHS NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CHS NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_CHS NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CHS NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_CHS NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_CHS NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CHS NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_CHS NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CHS NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CHS NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CHS NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_CHS NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_CHS NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_CHS NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CHS NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CHS NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CHS NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CHS NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CHS NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_CHS NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CHS NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CHS NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_CHS NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_CHS NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CHS NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CHS NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_CHS NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CHS NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CHS NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_CHS NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CHS NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CHS NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CHS NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CHS NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CHS NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CHS NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_CHS NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CHS NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_CHS NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CHS NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CHS NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_CHS NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_CHS NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_CHS NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CHS NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_CHS NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_CHS NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_CHS NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CHS NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_CHS NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CHS NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_CHS NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_CHS NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_CHS NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CHS NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CHS NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_CHS NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CHS NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CHS NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_CHS NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_CHS NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_CHS NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_CHS NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_CHS NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_CHS NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CHS NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_CHS NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CHS NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CHS NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_CHS NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_CHS NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CHS NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_CHS NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CHS NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CHS NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CHS NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CHS NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_CHS NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CHS NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CHS NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CHS NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_CHS NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CHS NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CHS NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_CHS NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_CHS NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_CHS NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CHS NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_CHS NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_CHS NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_CHS NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_CHS NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CHS NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_CHS NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CHS NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_CHS NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CHS NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CHS NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_CHS NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_CHS NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CHS NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CHS NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_CHS NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CHS NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_CHS NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_CHS NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_CHS NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CHS NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CHS NULL
#define OPTION_VAL_TWB64_182_PASTEL109_CHS NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CHS NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_CHS NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CHS NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CHS NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CHS NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CHS NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_CHS NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_CHS NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_CHS NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CHS NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CHS NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CHS NULL
#define OPTION_VAL_TWB64_195_EVA_01_CHS NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_CHS NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CHS NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CHS NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_CHS NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CHS NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CHS NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CHS NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_CHS NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CHS NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CHS NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CHS NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CHS NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_CHS NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CHS NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CHS NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CHS NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_CHS NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CHS NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CHS NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_CHS NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CHS NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CHS NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CHS NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CHS NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_CHS NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CHS NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_CHS NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_CHS NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CHS NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_CHS NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_CHS NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CHS NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CHS NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CHS NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_CHS NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CHS NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CHS NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CHS NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CHS NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CHS NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CHS NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CHS NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CHS NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CHS NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_CHS NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_CHS NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CHS NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CHS NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CHS NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_CHS NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_CHS NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_CHS NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CHS NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_CHS NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CHS NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_CHS NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CHS NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CHS NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CHS NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CHS NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_CHS NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CHS NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CHS NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_CHS NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CHS NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CHS NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CHS NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_CHS NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CHS NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CHS NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CHS NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CHS NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CHS NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CHS NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_CHS NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CHS NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CHS NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CHS NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CHS NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CHS NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CHS NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CHS NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CHS NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CHS NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CHS NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CHS NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CHS NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CHS NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CHS NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CHS NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CHS NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_CHS NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_CHS NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CHS NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CHS NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CHS NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_CHS NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CHS NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_CHS NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CHS NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_CHS NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CHS NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CHS NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CHS NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CHS NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CHS NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_CHS NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CHS NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CHS NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CHS NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CHS NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CHS NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CHS NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CHS NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_CHS NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CHS NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CHS NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_CHS NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CHS NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CHS NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CHS NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CHS NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CHS NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CHS NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CHS NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CHS NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CHS NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CHS NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CHS NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CHS NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CHS NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CHS NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_CHS NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CHS NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_CHS NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CHS NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CHS NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_CHS NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CHS NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CHS NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CHS NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CHS NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CHS NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_CHS NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CHS NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CHS NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CHS NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CHS NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_CHS NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CHS NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_CHS NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CHS NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CHS NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_CHS NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CHS "色彩校正"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CHS NULL
#define OPTION_VAL_GBC_ONLY_CHS NULL
#define OPTION_VAL_ALWAYS_CHS "总是"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CHS NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CHS NULL
#define OPTION_VAL_ACCURATE_CHS "精确"
#define OPTION_VAL_FAST_CHS "快"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CHS NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CHS NULL
#define OPTION_VAL_CENTRAL_CHS "中央"
#define OPTION_VAL_ABOVE_SCREEN_CHS NULL
#define OPTION_VAL_BELOW_SCREEN_CHS NULL
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_CHS NULL
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CHS NULL
#define GAMBATTE_MIX_FRAMES_LABEL_CHS NULL
#define GAMBATTE_MIX_FRAMES_INFO_0_CHS NULL
#define OPTION_VAL_MIX_CHS "简单"
#define OPTION_VAL_LCD_GHOSTING_CHS "LCD 重影 (精准)"
#define OPTION_VAL_LCD_GHOSTING_FAST_CHS "LCD 重影 (快速)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_CHS "音频重采样器"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_CHS NULL
#define OPTION_VAL_SINC_CHS NULL
#define OPTION_VAL_CC_CHS NULL
#define GAMBATTE_GB_HWMODE_LABEL_CHS NULL
#define GAMBATTE_GB_HWMODE_INFO_0_CHS NULL
#define OPTION_VAL_GB_CHS NULL
#define OPTION_VAL_GBA_CHS NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_CHS NULL
#define GAMBATTE_GB_BOOTLOADER_INFO_0_CHS NULL
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_CHS "允许相反方向的输入"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CHS NULL
#define GAMBATTE_TURBO_PERIOD_LABEL_CHS NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_CHS NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_CHS NULL
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_CHS NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CHS NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_CHS NULL
#define OPTION_VAL_NOT_CONNECTED_CHS "未连接"
#define OPTION_VAL_NETWORK_SERVER_CHS NULL
#define OPTION_VAL_NETWORK_CLIENT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CHS "端口"
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CHS NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CHS NULL

struct retro_core_option_v2_category option_cats_chs[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_CHS,
      CATEGORY_GB_LINK_INFO_0_CHS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_chs[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_CHS,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "GBC",      OPTION_VAL_GBC_CHS },
         { "SGB",      OPTION_VAL_SGB_CHS },
         { "internal", OPTION_VAL_INTERNAL_CHS },
         { "custom",   OPTION_VAL_CUSTOM_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CHS,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_CHS },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_CHS },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_CHS },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_CHS },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_CHS },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_CHS },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_CHS },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_CHS },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_CHS },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_CHS },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_CHS },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_CHS },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_CHS },
         { "GBC - Red",                OPTION_VAL_GBC_RED_CHS },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_CHS },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_CHS },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_CHS },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_CHS },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_CHS },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_CHS },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_CHS },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_CHS },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_CHS },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_CHS },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_CHS },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_CHS },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_CHS },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_CHS },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_CHS },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_CHS },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_CHS },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_CHS },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_CHS },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_CHS },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_CHS },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_CHS },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_CHS },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_CHS },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_CHS },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_CHS },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_CHS },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_CHS },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_CHS },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_CHS },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_CHS },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_CHS },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_CHS },
         { "Special 1",                OPTION_VAL_SPECIAL_1_CHS },
         { "Special 2",                OPTION_VAL_SPECIAL_2_CHS },
         { "Special 3",                OPTION_VAL_SPECIAL_3_CHS },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CHS },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_CHS },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_CHS },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_CHS },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_CHS },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CHS,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_CHS },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CHS },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CHS },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CHS },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_CHS },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_CHS },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_CHS },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_CHS },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_CHS },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_CHS },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_CHS },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_CHS },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_CHS },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_CHS },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CHS },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CHS },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CHS },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CHS },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_CHS },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CHS },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_CHS },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_CHS },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CHS },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CHS },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CHS },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_CHS },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_CHS },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_CHS },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_CHS },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CHS },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CHS },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CHS },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CHS },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_CHS },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_CHS },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CHS },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CHS },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CHS },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_CHS },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_CHS },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_CHS },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_CHS },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CHS },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CHS },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CHS },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_CHS },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_CHS },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_CHS },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_CHS },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_CHS },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CHS },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CHS },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_CHS },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_CHS },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_CHS },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_CHS },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_CHS },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_CHS },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CHS },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_CHS },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_CHS },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CHS },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_CHS },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_CHS },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_CHS },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CHS },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_CHS },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CHS },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_CHS },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_CHS },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CHS },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_CHS },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CHS },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CHS },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CHS },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_CHS },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_CHS },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_CHS },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CHS },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CHS },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CHS },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CHS },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CHS },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_CHS },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CHS },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CHS },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_CHS },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_CHS },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CHS },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CHS },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_CHS },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CHS },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CHS },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CHS },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CHS },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_CHS },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CHS },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CHS },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CHS },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CHS },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CHS,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_CHS },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CHS },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_CHS },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_CHS },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CHS },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CHS },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_CHS },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_CHS },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_CHS },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CHS },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_CHS },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_CHS },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_CHS },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CHS },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_CHS },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CHS },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_CHS },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_CHS },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_CHS },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_CHS },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CHS },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CHS },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_CHS },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CHS },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CHS },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_CHS },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_CHS },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_CHS },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_CHS },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_CHS },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_CHS },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_CHS },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CHS },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_CHS },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CHS },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CHS },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CHS },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_CHS },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_CHS },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CHS },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CHS },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_CHS },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CHS },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CHS },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CHS },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CHS },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_CHS },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_CHS },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CHS },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CHS },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CHS },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CHS },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_CHS },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CHS },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CHS },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_CHS },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_CHS },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_CHS },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CHS },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_CHS },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_CHS },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_CHS },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_CHS },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CHS },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_CHS },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CHS },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_CHS },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CHS },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CHS },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_CHS },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_CHS },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CHS },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CHS },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_CHS },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CHS },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_CHS },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_CHS },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_CHS },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CHS },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CHS },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CHS },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_CHS },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CHS },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_CHS },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CHS },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CHS },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CHS },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CHS },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_CHS },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_CHS },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_CHS },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CHS },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CHS },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CHS },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_CHS },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_CHS },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CHS },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CHS },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_CHS },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CHS },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CHS,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_CHS },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CHS },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CHS },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CHS },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CHS },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_CHS },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CHS },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CHS },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CHS },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_CHS },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CHS },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CHS },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_CHS },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CHS },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CHS },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CHS },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CHS },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_CHS },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CHS },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_CHS },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_CHS },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CHS },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_CHS },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_CHS },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CHS },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CHS },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CHS },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_CHS },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CHS },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CHS },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CHS },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CHS },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CHS },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CHS },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CHS },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CHS },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CHS },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_CHS },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_CHS },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CHS },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CHS },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CHS },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_CHS },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_CHS },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_CHS },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CHS },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_CHS },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CHS },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_CHS },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CHS },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CHS },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CHS },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CHS },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_CHS },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CHS },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CHS },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_CHS },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CHS },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CHS },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CHS },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_CHS },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CHS },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CHS },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CHS },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CHS },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CHS },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CHS },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_CHS },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CHS },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CHS },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CHS },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CHS },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CHS },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CHS },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CHS },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CHS },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CHS },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CHS },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CHS },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CHS },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CHS },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CHS },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CHS },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CHS },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_CHS },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_CHS },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CHS },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CHS },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CHS },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_CHS },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CHS },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_CHS },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CHS },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_CHS },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CHS },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CHS },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CHS },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CHS },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CHS },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_CHS },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CHS,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CHS },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CHS },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CHS },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CHS },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CHS },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_CHS },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CHS },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CHS },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_CHS },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CHS },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CHS },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CHS },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CHS },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CHS },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CHS },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CHS },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CHS },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CHS },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CHS },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CHS },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CHS },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CHS },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CHS },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_CHS },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CHS },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_CHS },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CHS },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CHS },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_CHS },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CHS },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CHS },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CHS },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CHS },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CHS },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_CHS },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CHS },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CHS },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CHS },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CHS },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_CHS },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CHS },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_CHS },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CHS },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CHS },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_CHS },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CHS,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_CHS },
         { "always",   OPTION_VAL_ALWAYS_CHS },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CHS,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_CHS },
         { "fast",     OPTION_VAL_FAST_CHS },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CHS,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_CHS },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_CHS },
         { "below screen", OPTION_VAL_BELOW_SCREEN_CHS },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_CHS,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_CHS,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_CHS },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_CHS },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_CHS,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_CHS },
         { "cc",   OPTION_VAL_CC_CHS },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_CHS,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_CHS },
         { "GB",   OPTION_VAL_GB_CHS },
         { "GBC",  OPTION_VAL_GBC_CHS },
         { "GBA",  OPTION_VAL_GBA_CHS },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_CHS,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_CHS,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_CHS,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_CHS,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CHS,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_CHS,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_MODE_INFO_0_CHS,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_CHS },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_CHS },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_CHS },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CHS,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CHS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CHS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_chs = {
   option_cats_chs,
   option_defs_chs
};

/* RETRO_LANGUAGE_CHT */

#define CATEGORY_GB_LINK_LABEL_CHT "連線主機連接"
#define CATEGORY_GB_LINK_INFO_0_CHT "變更連線對戰時主機連接的設定。"
#define GAMBATTE_GB_COLORIZATION_LABEL_CHT "Game Boy著色"
#define GAMBATTE_GB_COLORIZATION_INFO_0_CHT "設定Game Boy遊戲的著色模式, 設定<自動>時為核心定義的配色效果, 當遊戲未定義時套用「影像配色」設定, 設定<GBC>時為GBC配色, 未定義則用深綠, 設定<SGB>時為SGB配色, 未定義則用1A, 設定<影像配色>時套用「影像配色」設定, 設定<自訂>時從系統資料夾載入自訂調色板。"
#define OPTION_VAL_AUTO_CHT "自動"
#define OPTION_VAL_GBC_CHT "GBC (Game Boy Color主機)"
#define OPTION_VAL_SGB_CHT "SGB (Super Game Boy介面卡)"
#define OPTION_VAL_INTERNAL_CHT "影像配色"
#define OPTION_VAL_CUSTOM_CHT "自訂"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CHT "影像配色"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CHT "「Game Boy著色」 設定為<影像配色>或<自動>且未定義配色時使用, 此選項GB類別為主機擬真畫面, GBC類別為主機內建顏色, SGB類別為介面卡內建顏色, 調色師有 狼兔64 (TheWolfBunny64) 和 PixelShift (像素偏移) 提供的配色, 設定為調色師時依設定套用其他選項。"
#define OPTION_VAL_GB_DMG_CHT "GB - 初版主機"
#define OPTION_VAL_GB_POCKET_CHT "GB - 輕薄型主機"
#define OPTION_VAL_GB_LIGHT_CHT "GB - 背光型主機"
#define OPTION_VAL_GBC_BLUE_CHT "GBC - 內建藍色 (左鍵)"
#define OPTION_VAL_GBC_BROWN_CHT "GBC - 內建褐色 (上鍵)"
#define OPTION_VAL_GBC_DARK_BLUE_CHT "GBC - 內建深藍 (左+A)"
#define OPTION_VAL_GBC_DARK_BROWN_CHT "GBC - 內建深褐 (上+B)"
#define OPTION_VAL_GBC_DARK_GREEN_CHT "GBC - 內建深綠 (右+A)"
#define OPTION_VAL_GBC_GRAYSCALE_CHT "GBC - 內建灰階 (左+B)"
#define OPTION_VAL_GBC_GREEN_CHT "GBC - 內建綠色 (右鍵)"
#define OPTION_VAL_GBC_INVERTED_CHT "GBC - 內建反轉 (右+B)"
#define OPTION_VAL_GBC_ORANGE_CHT "GBC - 內建橘色 (下+A)"
#define OPTION_VAL_GBC_PASTEL_MIX_CHT "GBC - 內建粉彩 (下鍵)"
#define OPTION_VAL_GBC_RED_CHT "GBC - 內建紅色 (上+A)"
#define OPTION_VAL_GBC_YELLOW_CHT "GBC - 內建黃色 (下+B)"
#define OPTION_VAL_SGB_1A_CHT "SGB - 內建顏色 [1-A]"
#define OPTION_VAL_SGB_1B_CHT "SGB - 內建顏色 [1-B]"
#define OPTION_VAL_SGB_1C_CHT "SGB - 內建顏色 [1-C]"
#define OPTION_VAL_SGB_1D_CHT "SGB - 內建顏色 [1-D]"
#define OPTION_VAL_SGB_1E_CHT "SGB - 內建顏色 [1-E]"
#define OPTION_VAL_SGB_1F_CHT "SGB - 內建顏色 [1-F]"
#define OPTION_VAL_SGB_1G_CHT "SGB - 內建顏色 [1-G]"
#define OPTION_VAL_SGB_1H_CHT "SGB - 內建顏色 [1-H]"
#define OPTION_VAL_SGB_2A_CHT "SGB - 內建顏色 [2-A]"
#define OPTION_VAL_SGB_2B_CHT "SGB - 內建顏色 [2-B]"
#define OPTION_VAL_SGB_2C_CHT "SGB - 內建顏色 [2-C]"
#define OPTION_VAL_SGB_2D_CHT "SGB - 內建顏色 [2-D]"
#define OPTION_VAL_SGB_2E_CHT "SGB - 內建顏色 [2-E]"
#define OPTION_VAL_SGB_2F_CHT "SGB - 內建顏色 [2-F]"
#define OPTION_VAL_SGB_2G_CHT "SGB - 內建顏色 [2-G]"
#define OPTION_VAL_SGB_2H_CHT "SGB - 內建顏色 [2-H]"
#define OPTION_VAL_SGB_3A_CHT "SGB - 內建顏色 [3-A]"
#define OPTION_VAL_SGB_3B_CHT "SGB - 內建顏色 [3-B]"
#define OPTION_VAL_SGB_3C_CHT "SGB - 內建顏色 [3-C]"
#define OPTION_VAL_SGB_3D_CHT "SGB - 內建顏色 [3-D]"
#define OPTION_VAL_SGB_3E_CHT "SGB - 內建顏色 [3-E]"
#define OPTION_VAL_SGB_3F_CHT "SGB - 內建顏色 [3-F]"
#define OPTION_VAL_SGB_3G_CHT "SGB - 內建顏色 [3-G]"
#define OPTION_VAL_SGB_3H_CHT "SGB - 內建顏色 [3-H]"
#define OPTION_VAL_SGB_4A_CHT "SGB - 內建顏色 [4-A]"
#define OPTION_VAL_SGB_4B_CHT "SGB - 內建顏色 [4-B]"
#define OPTION_VAL_SGB_4C_CHT "SGB - 內建顏色 [4-C]"
#define OPTION_VAL_SGB_4D_CHT "SGB - 內建顏色 [4-D]"
#define OPTION_VAL_SGB_4E_CHT "SGB - 內建顏色 [4-E]"
#define OPTION_VAL_SGB_4F_CHT "SGB - 內建顏色 [4-F]"
#define OPTION_VAL_SGB_4G_CHT "SGB - 內建顏色 [4-G]"
#define OPTION_VAL_SGB_4H_CHT "SGB - 內建顏色 [4-H]"
#define OPTION_VAL_SPECIAL_1_CHT "特調 1"
#define OPTION_VAL_SPECIAL_2_CHT "特調 2"
#define OPTION_VAL_SPECIAL_3_CHT "特調 3"
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CHT "特調 4 (TI-83工程計算機)"
#define OPTION_VAL_TWB64_PACK_1_CHT "調色師 - 狼兔64 (1)"
#define OPTION_VAL_TWB64_PACK_2_CHT "調色師 - 狼兔64 (2)"
#define OPTION_VAL_TWB64_PACK_3_CHT NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_CHT "調色師 - 像素偏移 (1)"
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CHT "> 狼兔64 - 配色包 1"
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CHT "僅限「影像配色」設定為<狼兔64(1)>時套用。"
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_CHT "狼兔64 001 - 水團藍"
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CHT "狼兔64 002 - 漫畫展版 (白黑)"
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CHT "狼兔64 003 - 海綿寶寶黃"
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CHT "狼兔64 004 - 派大星粉紅"
#define OPTION_VAL_TWB64_005_NEON_RED_CHT "狼兔64 005 - 紅色霓虹燈"
#define OPTION_VAL_TWB64_006_NEON_BLUE_CHT "狼兔64 006 - 藍色霓虹燈"
#define OPTION_VAL_TWB64_007_NEON_YELLOW_CHT "狼兔64 007 - 黃色霓虹燈"
#define OPTION_VAL_TWB64_008_NEON_GREEN_CHT "狼兔64 008 - 綠色霓虹燈"
#define OPTION_VAL_TWB64_009_NEON_PINK_CHT "狼兔64 009 - 粉紅霓虹燈"
#define OPTION_VAL_TWB64_010_MARIO_RED_CHT "狼兔64 010 - 瑪利歐紅"
#define OPTION_VAL_TWB64_011_NICK_ORANGE_CHT "狼兔64 011 - 尼克兒童頻道橘"
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_CHT NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_CHT "狼兔64 013 - 薩爾達傳說曠野金"
#define OPTION_VAL_TWB64_014_DMG_099_CHT NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CHT "狼兔64 015 - Discord商標藍紫"
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CHT "狼兔64 016 - 765偶像藍紫"
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CHT "狼兔64 017 - 瑪利歐創作家超級球黃"
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CHT "狼兔64 018 - Crunchyroll商標橘"
#define OPTION_VAL_TWB64_019_MUSE_PINK_CHT "狼兔64 019 - 學園偶像計畫繆斯粉色"
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CHT NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_CHT "狼兔64 021 - 超級小子主機 (Gamate)"
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_CHT "狼兔64 022 - 綠色階"
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CHT "狼兔64 023 - 奧德賽金幣 (金黃)"
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CHT "狼兔64 024 - 超級賽亞人之神 (紅光)"
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CHT "狼兔64 025 - 超級賽亞人藍 (藍光)"
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_CHT NULL
#define OPTION_VAL_TWB64_027_BMO_VER_CHT NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_CHT NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_CHT NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CHT NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CHT NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CHT NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CHT NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_CHT NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_CHT NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CHT NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CHT NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_CHT NULL
#define OPTION_VAL_TWB64_040_DMG_VER_CHT NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_CHT NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_CHT NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CHT NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CHT NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_CHT NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_CHT NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_CHT NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_CHT NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_CHT NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CHT NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CHT NULL
#define OPTION_VAL_TWB64_053_VMU_VER_CHT NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_CHT NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_CHT NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_CHT NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_CHT NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_CHT NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_CHT NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_CHT NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CHT NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_CHT NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_CHT NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_CHT NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CHT NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_CHT NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CHT NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_CHT "狼兔64 069 - 飛天小女警花花粉"
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_CHT "狼兔64 070 - 飛天小女警泡泡藍"
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CHT "狼兔64 071 - 飛天小女警毛毛綠"
#define OPTION_VAL_TWB64_072_NASCAR_VER_CHT NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CHT NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CHT NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CHT NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_CHT NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_CHT NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_CHT NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CHT NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CHT NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CHT NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CHT NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CHT NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_CHT NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CHT NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CHT NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_CHT NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_CHT NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CHT NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CHT NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_CHT NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CHT NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CHT NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_CHT NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CHT NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CHT NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CHT NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CHT NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CHT "> 狼兔64 - 配色包 2"
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CHT "僅限「影像配色」設定為<狼兔64(2)>時套用。"
#define OPTION_VAL_TWB64_101_765PRO_PINK_CHT NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CHT NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_CHT NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CHT NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CHT NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_CHT NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_CHT NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_CHT NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CHT NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_CHT NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_CHT NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_CHT NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CHT NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_CHT NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CHT NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_CHT NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_CHT NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_CHT NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CHT NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CHT NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_CHT NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CHT NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CHT NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_CHT NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_CHT NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_CHT NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_CHT NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_CHT NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_CHT NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CHT NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_CHT NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CHT NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CHT NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_CHT NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_CHT NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CHT NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_CHT NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CHT NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CHT NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CHT NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CHT NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_CHT NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CHT NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CHT NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CHT NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_CHT NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CHT NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CHT NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_CHT NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_CHT NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_CHT NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CHT NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_CHT NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_CHT NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_CHT NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_CHT NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CHT NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_CHT NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CHT NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_CHT NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CHT NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CHT NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_CHT NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_CHT NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CHT NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CHT NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_CHT NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CHT NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_CHT NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_CHT NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_CHT NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CHT NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CHT NULL
#define OPTION_VAL_TWB64_182_PASTEL109_CHT NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CHT NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_CHT NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CHT NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CHT NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CHT NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CHT NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_CHT NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_CHT NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_CHT NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CHT NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CHT NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CHT NULL
#define OPTION_VAL_TWB64_195_EVA_01_CHT NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_CHT NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CHT NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CHT NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_CHT NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CHT NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CHT NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CHT NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_CHT NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CHT NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CHT NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CHT NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CHT NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_CHT NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CHT NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CHT NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CHT NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_CHT NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CHT NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CHT NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_CHT NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CHT NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CHT NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CHT NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CHT NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_CHT NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CHT NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_CHT NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_CHT NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CHT NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_CHT NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_CHT NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CHT NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CHT NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CHT NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_CHT NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CHT NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CHT NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CHT NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CHT NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CHT NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CHT NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CHT NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CHT NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CHT NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_CHT NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_CHT NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CHT NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CHT NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CHT NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_CHT NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_CHT NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_CHT NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CHT NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_CHT NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CHT NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_CHT NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CHT NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CHT NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CHT NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CHT NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_CHT NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CHT NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CHT NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_CHT NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CHT NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CHT NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CHT NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_CHT NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CHT NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CHT NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CHT NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CHT NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CHT NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CHT NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_CHT NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CHT NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CHT NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CHT NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CHT NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CHT NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CHT NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CHT NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CHT NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CHT NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CHT NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CHT NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CHT NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CHT NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CHT NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CHT NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CHT NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_CHT NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_CHT NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CHT NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CHT NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CHT NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_CHT NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CHT NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_CHT NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CHT NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_CHT NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CHT NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CHT NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CHT NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CHT NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CHT NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_CHT NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CHT "> 像素偏移 - 配色包 1"
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CHT "僅限「影像配色」設定為<像素偏移(1)>時套用。"
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CHT "像素偏移 01 - 薄荷綠"
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CHT "像素偏移 02 - Arduboy主機 (黑白)"
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CHT "像素偏移 03 - BGB模擬器0.3版 (翠綠)"
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CHT "像素偏移 04 - 黃綠迷彩色"
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CHT "像素偏移 05 - 牛奶巧克力"
#define OPTION_VAL_PIXELSHIFT_06_CMYK_CHT "像素偏移 06 - 印刷四色"
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CHT "像素偏移 07 - 棉花糖"
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CHT "像素偏移 08 - 簡單綠"
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_CHT "像素偏移 09 - 超級小子主機 (綠光)"
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CHT "像素偏移 10 - Game Boy Light主機 (綠光)"
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CHT "像素偏移 11 - Game Boy Pocket主機 (橄欖綠)"
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CHT "像素偏移 12 - Game Boy Pocket主機 (羅勒綠)"
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CHT "像素偏移 13 - Game Pocket Computer主機 (白黑)"
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CHT "像素偏移 14 - Game & Watch Ball主機 (深灰綠)"
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CHT "像素偏移 15 - 藍色背光液晶"
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CHT "像素偏移 16 - 白色背光液晶"
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CHT "像素偏移 17 - 橘色背光液晶"
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CHT "像素偏移 18 - 亮藍背光液晶"
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CHT "像素偏移 19 - 暗黃背光液晶"
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CHT "像素偏移 20 - 偽GB主機 (淡藍)"
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CHT "像素偏移 21 - 仿製GB主機 (灰黑)"
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CHT "像素偏移 22 - BGB-001展示機 (亮綠)"
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CHT "像素偏移 23 - NESM92V展示機 (亮黃)"
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_CHT "像素偏移 24 - GB新液晶 (綠色)"
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CHT "像素偏移 25 - GB微調 (藍綠色)"
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_CHT "像素偏移 26 - GB舊液晶 (黃綠色)"
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CHT "像素偏移 27 - GBP反相器藍背光"
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CHT "像素偏移 28 - GB水洗黃背光"
#define OPTION_VAL_PIXELSHIFT_29_GHOST_CHT "像素偏移 29 - 粉紅幽靈"
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CHT "像素偏移 30 - 暗綠光"
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CHT "像素偏移 31 - 金條"
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CHT "像素偏移 32 - 葡萄柚"
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CHT "像素偏移 33 - 灰綠混合"
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CHT "像素偏移 34 - 寶可夢遺失號碼 (白黃)"
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_CHT "像素偏移 35 - 微軟磁碟作業系統 (黑綠)"
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CHT "像素偏移 36 - 報紙 (深灰色)"
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CHT "像素偏移 37 - 嗶嗶小子 (黑綠)"
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CHT "像素偏移 38 - 口袋少女 (黃粉)"
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CHT "像素偏移 39 - 黑色輪廓"
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_CHT "像素偏移 40 - 太陽爆炸 (淡黃)"
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CHT "像素偏移 41 - 鮮艷 (淡粉紅色)"
#define OPTION_VAL_PIXELSHIFT_42_TRON_CHT "像素偏移 42 - 電子世界爭霸戰 (黑紫)"
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CHT "像素偏移 43 - 蒸汽波藍"
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CHT "像素偏移 44 - Virtual Boy主機 (紅黑)"
#define OPTION_VAL_PIXELSHIFT_45_WISH_CHT "像素偏移 45 - 期望藍"
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CHT "色彩校正"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CHT NULL
#define OPTION_VAL_GBC_ONLY_CHT "僅限GBC"
#define OPTION_VAL_ALWAYS_CHT "全部類型"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CHT "色彩校正模式"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CHT NULL
#define OPTION_VAL_ACCURATE_CHT "準確"
#define OPTION_VAL_FAST_CHT "快速"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CHT "色彩校正 - 前光位置"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CHT NULL
#define OPTION_VAL_CENTRAL_CHT "中間"
#define OPTION_VAL_ABOVE_SCREEN_CHT "螢幕上方"
#define OPTION_VAL_BELOW_SCREEN_CHT "螢幕下方"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_CHT "亮度降低 (%)"
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CHT NULL
#define GAMBATTE_MIX_FRAMES_LABEL_CHT "模擬殘影"
#define GAMBATTE_MIX_FRAMES_INFO_0_CHT NULL
#define OPTION_VAL_MIX_CHT "簡易"
#define OPTION_VAL_LCD_GHOSTING_CHT "液晶顯示器 (準確)"
#define OPTION_VAL_LCD_GHOSTING_FAST_CHT "液晶顯示器 (快速)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_CHT "音訊重新取樣器"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_CHT NULL
#define OPTION_VAL_SINC_CHT "正弦波"
#define OPTION_VAL_CC_CHT "餘弦波"
#define GAMBATTE_GB_HWMODE_LABEL_CHT "模擬主機硬體 (需要重新啟動)"
#define GAMBATTE_GB_HWMODE_INFO_0_CHT NULL
#define OPTION_VAL_GB_CHT "GB (Game Boy主機)"
#define OPTION_VAL_GBA_CHT "GBA (Game Boy Advance主機)"
#define GAMBATTE_GB_BOOTLOADER_LABEL_CHT "主機開機畫面 (需要重新啟動)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_CHT NULL
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_CHT "允許反向操作"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CHT "允許控制器反方向快速操作, 可同時按左右或上下的方向, 可能導致遊戲的移動架構出錯。"
#define GAMBATTE_TURBO_PERIOD_LABEL_CHT "連發間隔"
#define GAMBATTE_TURBO_PERIOD_INFO_0_CHT NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_CHT "模擬震動強度"
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_CHT "設定遊戲支援震動的震動強度, 模擬內建振動模組的卡帶, 例如「寶可夢彈珠臺(Pokemon Pinball)」。"
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CHT "顯示連線主機連接選項"
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CHT "顯示連線對戰時主機連接相關的選項。\n注意: 此選項變更時需要重新進入核心選項才能生效。"
#define GAMBATTE_GB_LINK_MODE_LABEL_CHT "主機連接模式"
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_CHT "主機連接模式"
#define GAMBATTE_GB_LINK_MODE_INFO_0_CHT "設定連線對戰時核心的連接模式, 必須在未建立連線之前設定完成, <用戶端>需要設定主機端IP位址。"
#define OPTION_VAL_NOT_CONNECTED_CHT "不連接"
#define OPTION_VAL_NETWORK_SERVER_CHT "主機端"
#define OPTION_VAL_NETWORK_CLIENT_CHT "用戶端"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CHT "連接通訊埠號"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CHT "連接通訊埠號"
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CHT "設定主機連接時使用的通訊埠號。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CHT "連線主機位址(01): #__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CHT "連線主機位址(01): #__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CHT "設定連線主機IP位址第1碼, 例如「192.168.1.1」不滿12個數字, 設定方式為「192.168.001.001」。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CHT "設定連線主機IP位址第1碼, 例如「192.168.1.1」不滿12個數字, 設定方式為「192.168.001.001」。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CHT "連線主機位址(02): _#_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CHT "連線主機位址(02): _#_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CHT "設定連線主機IP位址第2碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CHT "設定連線主機IP位址第2碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CHT "連線主機位址(03): __#.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CHT "連線主機位址(03): __#.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CHT "設定連線主機IP位址第3碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CHT "設定連線主機IP位址第3碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CHT "連線主機位址(04): ___.#__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CHT "連線主機位址(04): ___.#__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CHT "設定連線主機IP位址第4碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CHT "設定連線主機IP位址第4碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CHT "連線主機位址(05): ___._#_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CHT "連線主機位址(05): ___._#_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CHT "設定連線主機IP位址第5碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CHT "設定連線主機IP位址第5碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CHT "連線主機位址(06): ___.__#.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CHT "連線主機位址(06): ___.__#.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CHT "設定連線主機IP位址第6碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CHT "設定連線主機IP位址第6碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CHT "連線主機位址(07): ___.___.#__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CHT "連線主機位址(07): ___.___.#__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CHT "設定連線主機IP位址第7碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CHT "設定連線主機IP位址第7碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CHT "連線主機位址(08): ___.___._#_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CHT "連線主機位址(08): ___.___._#_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CHT "設定連線主機IP位址第8碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CHT "設定連線主機IP位址第8碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CHT "連線主機位址(09): ___.___.__#.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CHT "連線主機位址(09): ___.___.__#.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CHT "設定連線主機IP位址第9碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CHT "設定連線主機IP位址第9碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CHT "連線主機位址(10): ___.___.___.#__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CHT "連線主機位址(10): ___.___.___.#__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CHT "設定連線主機IP位址第10碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CHT "設定連線主機IP位址第10碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CHT "連線主機位址(11): ___.___.___._#_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CHT "連線主機位址(11): ___.___.___._#_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CHT "設定連線主機IP位址第11碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CHT "設定連線主機IP位址第11碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CHT "連線主機位址(12): ___.___.___.__#"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CHT "連線主機位址(12): ___.___.___.__#"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CHT "設定連線主機IP位址第12碼, 僅限「主機連接模式」設定為<用戶端>時使用。"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CHT "設定連線主機IP位址第12碼, 僅限「主機連接模式」設定為<用戶端>時使用。"

struct retro_core_option_v2_category option_cats_cht[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_CHT,
      CATEGORY_GB_LINK_INFO_0_CHT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cht[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_CHT,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "GBC",      OPTION_VAL_GBC_CHT },
         { "SGB",      OPTION_VAL_SGB_CHT },
         { "internal", OPTION_VAL_INTERNAL_CHT },
         { "custom",   OPTION_VAL_CUSTOM_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CHT,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_CHT },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_CHT },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_CHT },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_CHT },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_CHT },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_CHT },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_CHT },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_CHT },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_CHT },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_CHT },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_CHT },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_CHT },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_CHT },
         { "GBC - Red",                OPTION_VAL_GBC_RED_CHT },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_CHT },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_CHT },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_CHT },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_CHT },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_CHT },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_CHT },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_CHT },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_CHT },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_CHT },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_CHT },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_CHT },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_CHT },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_CHT },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_CHT },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_CHT },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_CHT },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_CHT },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_CHT },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_CHT },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_CHT },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_CHT },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_CHT },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_CHT },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_CHT },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_CHT },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_CHT },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_CHT },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_CHT },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_CHT },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_CHT },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_CHT },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_CHT },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_CHT },
         { "Special 1",                OPTION_VAL_SPECIAL_1_CHT },
         { "Special 2",                OPTION_VAL_SPECIAL_2_CHT },
         { "Special 3",                OPTION_VAL_SPECIAL_3_CHT },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CHT },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_CHT },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_CHT },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_CHT },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_CHT },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CHT,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_CHT },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CHT },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CHT },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CHT },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_CHT },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_CHT },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_CHT },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_CHT },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_CHT },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_CHT },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_CHT },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_CHT },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_CHT },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_CHT },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CHT },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CHT },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CHT },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CHT },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_CHT },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CHT },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_CHT },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_CHT },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CHT },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CHT },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CHT },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_CHT },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_CHT },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_CHT },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_CHT },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CHT },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CHT },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CHT },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CHT },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_CHT },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_CHT },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CHT },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CHT },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CHT },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_CHT },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_CHT },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_CHT },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_CHT },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CHT },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CHT },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CHT },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_CHT },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_CHT },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_CHT },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_CHT },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_CHT },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CHT },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CHT },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_CHT },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_CHT },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_CHT },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_CHT },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_CHT },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_CHT },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CHT },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_CHT },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_CHT },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CHT },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_CHT },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_CHT },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_CHT },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CHT },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_CHT },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CHT },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_CHT },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_CHT },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CHT },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_CHT },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CHT },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CHT },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CHT },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_CHT },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_CHT },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_CHT },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CHT },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CHT },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CHT },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CHT },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CHT },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_CHT },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CHT },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CHT },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_CHT },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_CHT },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CHT },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CHT },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_CHT },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CHT },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CHT },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CHT },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CHT },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_CHT },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CHT },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CHT },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CHT },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CHT },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CHT,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_CHT },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CHT },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_CHT },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_CHT },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CHT },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CHT },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_CHT },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_CHT },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_CHT },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CHT },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_CHT },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_CHT },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_CHT },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CHT },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_CHT },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CHT },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_CHT },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_CHT },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_CHT },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_CHT },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CHT },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CHT },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_CHT },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CHT },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CHT },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_CHT },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_CHT },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_CHT },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_CHT },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_CHT },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_CHT },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_CHT },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CHT },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_CHT },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CHT },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CHT },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CHT },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_CHT },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_CHT },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CHT },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CHT },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_CHT },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CHT },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CHT },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CHT },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CHT },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_CHT },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_CHT },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CHT },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CHT },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CHT },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CHT },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_CHT },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CHT },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CHT },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_CHT },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_CHT },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_CHT },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CHT },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_CHT },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_CHT },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_CHT },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_CHT },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CHT },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_CHT },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CHT },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_CHT },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CHT },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CHT },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_CHT },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_CHT },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CHT },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CHT },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_CHT },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CHT },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_CHT },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_CHT },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_CHT },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CHT },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CHT },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CHT },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_CHT },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CHT },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_CHT },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CHT },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CHT },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CHT },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CHT },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_CHT },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_CHT },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_CHT },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CHT },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CHT },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CHT },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_CHT },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_CHT },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CHT },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CHT },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_CHT },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CHT },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CHT,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_CHT },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CHT },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CHT },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CHT },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CHT },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_CHT },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CHT },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CHT },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CHT },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_CHT },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CHT },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CHT },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_CHT },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CHT },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CHT },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CHT },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CHT },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_CHT },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CHT },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_CHT },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_CHT },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CHT },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_CHT },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_CHT },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CHT },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CHT },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CHT },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_CHT },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CHT },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CHT },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CHT },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CHT },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CHT },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CHT },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CHT },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CHT },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CHT },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_CHT },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_CHT },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CHT },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CHT },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CHT },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_CHT },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_CHT },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_CHT },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CHT },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_CHT },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CHT },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_CHT },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CHT },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CHT },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CHT },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CHT },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_CHT },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CHT },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CHT },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_CHT },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CHT },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CHT },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CHT },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_CHT },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CHT },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CHT },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CHT },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CHT },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CHT },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CHT },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_CHT },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CHT },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CHT },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CHT },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CHT },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CHT },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CHT },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CHT },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CHT },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CHT },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CHT },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CHT },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CHT },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CHT },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CHT },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CHT },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CHT },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_CHT },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_CHT },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CHT },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CHT },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CHT },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_CHT },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CHT },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_CHT },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CHT },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_CHT },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CHT },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CHT },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CHT },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CHT },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CHT },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_CHT },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CHT,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CHT },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CHT },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CHT },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CHT },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CHT },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_CHT },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CHT },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CHT },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_CHT },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CHT },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CHT },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CHT },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CHT },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CHT },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CHT },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CHT },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CHT },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CHT },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CHT },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CHT },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CHT },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CHT },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CHT },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_CHT },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CHT },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_CHT },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CHT },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CHT },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_CHT },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CHT },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CHT },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CHT },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CHT },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CHT },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_CHT },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CHT },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CHT },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CHT },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CHT },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_CHT },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CHT },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_CHT },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CHT },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CHT },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_CHT },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CHT,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_CHT },
         { "always",   OPTION_VAL_ALWAYS_CHT },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CHT,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_CHT },
         { "fast",     OPTION_VAL_FAST_CHT },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CHT,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_CHT },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_CHT },
         { "below screen", OPTION_VAL_BELOW_SCREEN_CHT },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_CHT,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_CHT,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_CHT },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_CHT },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_CHT,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_CHT },
         { "cc",   OPTION_VAL_CC_CHT },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_CHT,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_CHT },
         { "GB",   OPTION_VAL_GB_CHT },
         { "GBC",  OPTION_VAL_GBC_CHT },
         { "GBA",  OPTION_VAL_GBA_CHT },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_CHT,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_CHT,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_CHT,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_CHT,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CHT,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_CHT,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_MODE_INFO_0_CHT,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_CHT },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_CHT },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_CHT },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CHT,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CHT,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CHT,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cht = {
   option_cats_cht,
   option_defs_cht
};

/* RETRO_LANGUAGE_CS */

#define CATEGORY_GB_LINK_LABEL_CS "Odkaz na Hru"
#define CATEGORY_GB_LINK_INFO_0_CS "Změna nastavení funkce Game Link (multiplayer) v síti."
#define GAMBATTE_GB_COLORIZATION_LABEL_CS "GB Barevná"
#define GAMBATTE_GB_COLORIZATION_INFO_0_CS "Umožňuje kolorování her pro Game Boy. 'Auto' vybere 'nejlepší' (nejbarevnější/vhodnější) paletu. 'GBC' vybere paletu specifickou pro hru Game Boy Color, pokud je definována, jinak 'GBC - tmavě zelená'. 'SGB' vybere paletu specifickou pro hru Super Game Boy, pokud je definována, jinak 'SGB - 1A'. 'Internal' používá základní volbu 'Internal Palette'. 'Vlastní' načte paletu vytvořenou uživatelem ze systémového adresáře."
#define OPTION_VAL_AUTO_CS NULL
#define OPTION_VAL_GBC_CS NULL
#define OPTION_VAL_SGB_CS NULL
#define OPTION_VAL_INTERNAL_CS "Interní"
#define OPTION_VAL_CUSTOM_CS "Vlastní"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CS "Interní Paleta"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CS "Vybere paletu použitou pro kolorování her pro Game Boy, pokud je položka 'GB Colorization' nastavena na 'Internal' nebo pokud je položka 'GB Colorization' nastavena na 'Auto' a hra nemá předdefinovanou paletu SGB/GBC. Palety 'GB' napodobují zobrazení původního hardwaru Game Boy. Palety 'GBC' jsou totožné s vestavěnými předvolbami Game Boy Color. Palety 'SGB' jsou totožné s vestavěnými předvolbami zařízení Super Game Boy."
#define OPTION_VAL_GB_DMG_CS "GB – DMG"
#define OPTION_VAL_GB_POCKET_CS "GB - Kapesní"
#define OPTION_VAL_GB_LIGHT_CS "GB - Světlá"
#define OPTION_VAL_GBC_BLUE_CS "GBC - Modrá"
#define OPTION_VAL_GBC_BROWN_CS "GBC - Hnědá"
#define OPTION_VAL_GBC_DARK_BLUE_CS "GBC - Tmavě Modrá"
#define OPTION_VAL_GBC_DARK_BROWN_CS "GBC - Tmavě Hnědá"
#define OPTION_VAL_GBC_DARK_GREEN_CS "GBC - Tmavě Zelená"
#define OPTION_VAL_GBC_GRAYSCALE_CS "GBC - Odstín šedé"
#define OPTION_VAL_GBC_GREEN_CS "GBC - Zelená"
#define OPTION_VAL_GBC_INVERTED_CS "GBC - Invertované"
#define OPTION_VAL_GBC_ORANGE_CS "GBC - Oranžová"
#define OPTION_VAL_GBC_PASTEL_MIX_CS "GBC - Pastelový mix"
#define OPTION_VAL_GBC_RED_CS "GBC - Červená"
#define OPTION_VAL_GBC_YELLOW_CS "GBC - Žlutá"
#define OPTION_VAL_SGB_1A_CS NULL
#define OPTION_VAL_SGB_1B_CS NULL
#define OPTION_VAL_SGB_1C_CS NULL
#define OPTION_VAL_SGB_1D_CS NULL
#define OPTION_VAL_SGB_1E_CS NULL
#define OPTION_VAL_SGB_1F_CS NULL
#define OPTION_VAL_SGB_1G_CS NULL
#define OPTION_VAL_SGB_1H_CS NULL
#define OPTION_VAL_SGB_2A_CS NULL
#define OPTION_VAL_SGB_2B_CS NULL
#define OPTION_VAL_SGB_2C_CS NULL
#define OPTION_VAL_SGB_2D_CS NULL
#define OPTION_VAL_SGB_2E_CS NULL
#define OPTION_VAL_SGB_2F_CS NULL
#define OPTION_VAL_SGB_2G_CS NULL
#define OPTION_VAL_SGB_2H_CS NULL
#define OPTION_VAL_SGB_3A_CS NULL
#define OPTION_VAL_SGB_3B_CS NULL
#define OPTION_VAL_SGB_3C_CS NULL
#define OPTION_VAL_SGB_3D_CS NULL
#define OPTION_VAL_SGB_3E_CS NULL
#define OPTION_VAL_SGB_3F_CS NULL
#define OPTION_VAL_SGB_3G_CS NULL
#define OPTION_VAL_SGB_3H_CS NULL
#define OPTION_VAL_SGB_4A_CS NULL
#define OPTION_VAL_SGB_4B_CS NULL
#define OPTION_VAL_SGB_4C_CS NULL
#define OPTION_VAL_SGB_4D_CS NULL
#define OPTION_VAL_SGB_4E_CS NULL
#define OPTION_VAL_SGB_4F_CS NULL
#define OPTION_VAL_SGB_4G_CS NULL
#define OPTION_VAL_SGB_4H_CS NULL
#define OPTION_VAL_SPECIAL_1_CS "Speciální 1"
#define OPTION_VAL_SPECIAL_2_CS "Speciální 2"
#define OPTION_VAL_SPECIAL_3_CS "Speciální 3"
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CS "Speciální 4 (TI-83 Legát)"
#define OPTION_VAL_TWB64_PACK_1_CS "TWB64 - Balíček 1"
#define OPTION_VAL_TWB64_PACK_2_CS "TWB64 - Balíček 2"
#define OPTION_VAL_TWB64_PACK_3_CS "TWB64 - Balíček 3"
#define OPTION_VAL_PIXELSHIFT_PACK_1_CS "PixelShift - Balíček 1"
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CS "> TWB64 - Balíček Palety 1"
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CS "Vybere interní barevnou paletu, pokud je položka 'Interní Paleta' nastavena na hodnotu 'TWB64 - Balíček 1'."
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_CS "TWB64 001 - Modrá Aqours"
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CS "TWB64 002 - Animovaná Expo Ver."
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CS "TWB64 003 - SpongeBob Žlutá"
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CS "TWB64 004 - Patrick Hvězdně Růžová"
#define OPTION_VAL_TWB64_005_NEON_RED_CS "TWB64 005 - Neonově Červená"
#define OPTION_VAL_TWB64_006_NEON_BLUE_CS "TWB64 006 - Neonově Modrá"
#define OPTION_VAL_TWB64_007_NEON_YELLOW_CS "TWB64 007 - Neonově Žlutá"
#define OPTION_VAL_TWB64_008_NEON_GREEN_CS "TWB64 008 - Neonově Zelená"
#define OPTION_VAL_TWB64_009_NEON_PINK_CS "TWB64 009 - Neonově Růžová"
#define OPTION_VAL_TWB64_010_MARIO_RED_CS "TWB64 010 - Mario Červená"
#define OPTION_VAL_TWB64_011_NICK_ORANGE_CS "TWB64 011 - Nick Oranžový"
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_CS NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_CS "TWB64 013 - Zlatý Wild"
#define OPTION_VAL_TWB64_014_DMG_099_CS NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CS NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CS NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CS NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CS "TWB64 018 - Crunchyroll Oranžový"
#define OPTION_VAL_TWB64_019_MUSE_PINK_CS "TWB64 019 - Muse Růžový"
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CS "TWB64 020 - Modrý školní idol"
#define OPTION_VAL_TWB64_021_GAMATE_VER_CS NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_CS NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CS "TWB64 023 - Odyssey Zlatý"
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CS NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CS "TWB64 025 - Super Saiyan Modrý"
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_CS "TWB64 026 - ANIMAX MODRÁ"
#define OPTION_VAL_TWB64_027_BMO_VER_CS NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_CS NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_CS "TWB64 029 - Sanrio Růžová"
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CS "TWB64 030 - Timmy Turner růžová"
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CS "TWB64 031 - Docela zvláštní paleta"
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CS "TWB64 032 - Danny Phantom stříbrný"
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CS NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_CS NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_CS NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CS "TWB64 036 - Game Grump Oranžová"
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CS NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CS NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_CS NULL
#define OPTION_VAL_TWB64_040_DMG_VER_CS NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_CS NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_CS NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CS "TWB64 043 - Paleta všech mocných hrdinů"
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CS "TWB64 044 - U.A. Uniforma střední školy"
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CS "TWB64 045 - Pikachu Žlutá"
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_CS "TWB64 046 - Eevee Hnědá"
#define OPTION_VAL_TWB64_047_MICROVISION_VER_CS NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_CS NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_CS NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_CS NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CS NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CS "TWB64 052 - Chobotnička zelená mořská pěna"
#define OPTION_VAL_TWB64_053_VMU_VER_CS NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_CS NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_CS "TWB64 055 - Android Zelená"
#define OPTION_VAL_TWB64_056_AMAZON_VISION_CS "TWB64 056 - Vize Amazonu"
#define OPTION_VAL_TWB64_057_GOOGLE_RED_CS "TWB64 057 - Google Červená"
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_CS "TWB64 058 - Google Modrá"
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CS "TWB64 059 - Google Žlutá"
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_CS "TWB64 060 - Google Zelená"
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_CS NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CS NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_CS NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_CS "TWB64 064 - Vize Coca-Coly"
#define OPTION_VAL_TWB64_065_GAMEKING_VER_CS NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CS NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_CS NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CS NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_CS "TWB64 069 - Blossom Růžová"
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_CS "TWB64 070 - Bubbles Modrá"
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CS "TWB64 071 - Buttercup Zelená"
#define OPTION_VAL_TWB64_072_NASCAR_VER_CS NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CS "TWB64 073 - Lemon-Lime Zelená"
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CS NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CS NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_CS "TWB64 076 - Phantom Červená"
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_CS NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_CS NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CS "TWB64 079 - Cardcaptor Růžová"
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CS "TWB64 080 - Pretty Guardian Zlatá"
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CS NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CS NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CS NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_CS NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CS "TWB64 085 - Zdokonalený ultra instinkt"
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CS "TWB64 086 - Saint Snow Červená"
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_CS "Banánově Žlutá"
#define OPTION_VAL_TWB64_088_GREEN_BANANA_CS "Banánově Zelená"
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CS NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CS "TWB64 090 - Super Saiyan Modrá Evolved"
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_CS NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CS "TWB64 092 - Investigation Žlutá"
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CS "TWB64 093 - S.E.E.S. Modrá"
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CS "TWB64 094 - Znak ultra instinktu"
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CS "TWB64 095 - Hokage Oranžová"
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_CS "TWB64 096 - Straw Hat Červená"
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CS "TWB64 097 - Sword Art Azurová"
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CS "TWB64 098 - Deku Alpha Smaragdová"
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CS "TWB64 099 - Modrá Stripes Ver."
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CS "TWB64 100 - Prekurzor mramorová malina"
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CS "> TWB64 - Balíček Palety 2"
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CS "Vybere interní barevnou paletu, pokud je položka 'Interní Paleta' nastavena na hodnotu 'TWB64 - Pack 2'."
#define OPTION_VAL_TWB64_101_765PRO_PINK_CS "TWB64 101 - 765PRO Růžová"
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CS "TWB64 102 - CINDERELLA Modrá"
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_CS "TWB64 103 - MILLION Žlutá!"
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_CS "TWB64 104 - SideM Zelená"
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CS "TWB64 105 - SHINY Nebesky Modrá"
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CS NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_CS "TWB64 107 - Vize NBA"
#define OPTION_VAL_TWB64_108_NFL_VISION_CS "TWB64 108 - Vize NFL"
#define OPTION_VAL_TWB64_109_MLB_VISION_CS "TWB64 109 - Vize MLB"
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CS "TWB64 110 - Anime Digivice Verze."
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_CS NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_CS NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_CS "TWB64 113 - Sakura Růžová"
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CS NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_CS NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CS "TWB64 116 - Zlatá Kiiro"
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_CS "TWB64 117 - Stříbrná Shiro"
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_CS "TWB64 118 - Fruity Oranžová"
#define OPTION_VAL_TWB64_119_AKB48_PINK_CS "TWB64 119 - AKB48 Růžová"
#define OPTION_VAL_TWB64_120_MIKU_BLUE_CS "TWB64 120 - Miku Modrá"
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CS "TWB64 121 - Tri Digivice Verze."
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CS "TWB64 122 - Uniforma průzkumných jednotek"
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_CS "TWB64 123 - Island Zelená"
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CS "TWB64 124 - Nogizaka46 fialová"
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CS "TWB64 125 - Ninja Turtle Zelená"
#define OPTION_VAL_TWB64_126_SLIME_BLUE_CS "TWB64 126 - Slime Modrá"
#define OPTION_VAL_TWB64_127_LIME_MIDORI_CS NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_CS NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_CS NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_CS "TWB64 130 - Royal Modrá"
#define OPTION_VAL_TWB64_131_NEON_PURPLE_CS "TWB64 131 - Neon Fialová"
#define OPTION_VAL_TWB64_132_NEON_ORANGE_CS "TWB64 132 - Neon Oranžová"
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CS NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_CS "TWB64 134 - Červené vycházející slunce"
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CS "TWB64 135 - Barevná kombinace Burger King"
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CS "TWB64 136 - Velký plášť Zeno"
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CS "TWB64 137 - Pac-Man Žlutá"
#define OPTION_VAL_TWB64_138_IRISH_GREEN_CS "TWB64 138 - Irish Zelená"
#define OPTION_VAL_TWB64_139_GOKU_GI_CS NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CS "TWB64 140 - Dragon Ball Oranžová"
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CS "TWB64 141 - Christmas Zlatá"
#define OPTION_VAL_TWB64_142_PEPSI_VISION_CS NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CS "TWB64 143 - Bubblun Zelená"
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CS "TWB64 144 - Bobblun Modrá"
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CS NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CS "TWB64 146 - Olympic Zlatá"
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_CS "TWB64 147 - Oranžová LisAni!"
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_CS "TWB64 148 - Liella Fialová!"
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CS "TWB64 149 - Olympic Stříbrná"
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CS "TWB64 150 - Olympic Bronzová"
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CS "TWB64 151 - Modrá letecká ANA"
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CS "TWB64 152 - Nijigasaki Oranžová"
#define OPTION_VAL_TWB64_153_HOLOBLUE_CS NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CS "TWB64 154 - WWE bílá a červená"
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CS "TWB64 155 - Yoshi Egg Zelená"
#define OPTION_VAL_TWB64_156_POKEDEX_RED_CS "TWB64 156 - Pokedex Červená"
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_CS "TWB64 157 - FamilyMart Vize"
#define OPTION_VAL_TWB64_158_XBOX_GREEN_CS "TWB64 158 - Xbox Zelená"
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CS "TWB64 159 - Sonic Mega Modrá"
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_CS NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_CS "TWB64 161 - Scarlett Zelená"
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_CS "TWB64 162 - Glitchy Modrá"
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_CS NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CS NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_CS NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CS NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_CS "TWB64 167 - Smurfy Modrá"
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CS "TWB64 168 - Swampy Ogre Zelená"
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CS "TWB64 169 - Sailor Spinach Zelená"
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_CS "TWB64 170 - Shenron Zelená"
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_CS "TWB64 171 - Berserk Krvavá"
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CS "TWB64 172 - Super Star Růžová"
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CS NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_CS "TWB64 174 - Barbie Růžová"
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CS NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_CS NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_CS "TWB64 177 - Clover Zelená"
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_CS NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CS "TWB64 179 - Famicom Disk Žlutá"
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CS "TWB64 180 - Uniforma Rakeťáků"
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CS "TWB64 181 - SEIKO Timely vize"
#define OPTION_VAL_TWB64_182_PASTEL109_CS NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CS NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_CS "TWB64 184 - Fury Modrá"
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CS "TWB64 185 - Vize dobrého úsměvu"
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CS "TWB64 186 - Puyo Puyo Zelená"
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CS "TWB64 187 - Kruh K barevná kombinace"
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CS "TWB64 188 - Pizza Hut Červená"
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_CS "TWB64 189 - Smaragdově zelená"
#define OPTION_VAL_TWB64_190_GRAND_IVORY_CS NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_CS "TWB64 191 - Demon's Zlatá"
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CS "TWB64 192 - SEGA Tokyo Modrá"
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CS NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CS "TWB64 194 - DK Barrel Hnědá"
#define OPTION_VAL_TWB64_195_EVA_01_CS NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_CS "TWB64 196 - Vize divokého západu"
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CS "TWB64 197 - Paleta Optimus Prime"
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CS NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_CS "TWB64 199 - Duracell Měděná"
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CS "TWB64 200 - TOKYO SKYTREE CLOUDY MODRÁ"
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CS NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CS "Vybere interní barevnou paletu, pokud je položka 'Internal Palette' nastavena na hodnotu 'TWB64 - Pack 3'."
#define OPTION_VAL_TWB64_201_DMG_GOLD_CS NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CS NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CS NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CS NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CS NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_CS NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CS NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CS "TWB64 208 - Vize modrého bombera"
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CS "TWB64 209 - Vize Krispy Kreme"
#define OPTION_VAL_TWB64_210_STEAM_GRAY_CS NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CS NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CS NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_CS NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CS NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CS NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CS NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CS NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_CS NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CS "TWB64 219 - Neporazitelná žlutá a modrá"
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_CS NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_CS "TWB64 221 - animovaná vize"
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CS NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_CS NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_CS NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CS NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CS NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CS NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_CS NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CS NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CS NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CS "TWB64 231 - Ledovcová zimní modř"
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CS NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CS NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CS NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CS NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CS NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CS NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_CS NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_CS NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CS NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CS NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CS NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_CS NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_CS NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_CS NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CS NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_CS NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CS NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_CS "TWB64 249 - Dunkinova vize"
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CS "TWB64 250 - Deku paleta jasu"
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CS NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CS NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CS NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_CS NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CS NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CS "TWB64 256 - Vize Domino's Pizza"
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_CS NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CS NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CS NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CS NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_CS NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CS NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CS NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CS NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CS NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CS NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CS NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_CS NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CS NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CS NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CS NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CS NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CS "TWB64 273 - Paleta Deku Vigilante"
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CS NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CS NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CS NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CS NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CS NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CS NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CS NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CS NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CS NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CS NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CS NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_CS NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_CS NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CS NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CS NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CS NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_CS NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CS NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_CS NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CS NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_CS NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CS NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CS NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CS NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CS NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CS NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_CS NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CS "> PixelShift - Balíček Paleta 1"
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CS "Vybere interní barevnou paletu, pokud je položka 'Interní paleta' nastavena na hodnotu 'PixelShift - Balíček 1'."
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CS "PixelShift 01 - Arktická zelená"
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CS NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CS NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CS "PixelShift 04 - Kamufláž"
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CS "PixelShift 05 - Čokoládová tyčinka"
#define OPTION_VAL_PIXELSHIFT_06_CMYK_CS NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CS "PixelShift 07 - Cukrová vata"
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CS "PixelShift 08 - Lehce zelená"
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_CS "PixelShift 09 - Hračská"
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CS "PixelShift 10 - Světelný Game Boy"
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CS "PixelShift 11 - Kapesní Game Boy"
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CS "PixelShift 12 - Kapesní Game Boy Alt"
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CS "PixelShift 13 - Herní kapesní počítač"
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CS "PixelShift 14 - Hra a Sledovací míč"
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CS "PixelShift 15 - Modré podsvícení GB"
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CS "PixelShift 16 - Vybledlé podsvícení GB"
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CS "PixelShift 17 - Oranžové podsvícení GB"
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CS "PixelShift 18 - Bílé podsvícení GB "
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CS "PixelShift 19 - Žlutotmavé podsvícení GB"
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CS NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CS "PixelShift 21 - Lovec GB"
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CS "PixelShift 22 - Kiosek GB"
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CS "PixelShift 23 - Kiosek 2 GB"
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_CS "PixelShift 24 - Nový GB"
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CS "PixelShift 25 - Zničený GB"
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_CS "PixelShift 26 - Starý GB"
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CS NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CS "PixelShift 28 - Žluté vyprané podsvícení GB"
#define OPTION_VAL_PIXELSHIFT_29_GHOST_CS "PixelShift 29 - Duch"
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CS "PixelShift 30 - Záře ve tmě"
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CS "PixelShift 31 - Zlatá lišta"
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CS NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CS "PixelShift 33 - Šedozelený mix"
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CS "PixelShift 34 - Chybějící"
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_CS NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CS "PixelShift 36 - Zpravodajství"
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CS NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CS "PixelShift 38 - Kapesní dívka"
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CS "PixelShift 39 - Silueta"
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_CS "PixelShift 40 - Sluneční záře"
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CS "PixelShift 41 - Technické barvy"
#define OPTION_VAL_PIXELSHIFT_42_TRON_CS NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CS "PixelShift 43 - Vlnobití"
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CS NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_CS "PixelShift 45 - Přání"
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CS "Korekce Barev"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CS "Upraví výstupní barvy tak, aby odpovídaly zobrazení skutečného hardwaru Game Boy Color. 'Pouze GBC' zajišťuje, že korekce bude použita pouze při hraní her Game Boy Color nebo při použití palety Game Boy Color k barevné úpravě hry Game Boy. 'Vždy' aplikuje korekci barev na veškerý obsah a při použití interních barevných palet 'GB' nebo 'SGB' přinese neočekávané/podoptimální výsledky."
#define OPTION_VAL_GBC_ONLY_CS "Pouze GBC"
#define OPTION_VAL_ALWAYS_CS "Vždy"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CS "Režim Korekce Barev"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CS "Určuje metodu použitou při provádění korekce barev. 'Přesná' vytváří výstup téměř nerozeznatelný od skutečného LCD panelu Game Boy Color. 'Rychlá' pouze ztmavuje barvy a snižuje sytost a může být použita na hardwaru nižší třídy, pokud je metoda 'Přesná' příliš pomalá."
#define OPTION_VAL_ACCURATE_CS "Přesné"
#define OPTION_VAL_FAST_CS "Rychle"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CS "Korekce Barev - Pozice Čelního Světla"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CS "Simuluje fyzickou odezvu LCD panelu Game Boy Color při osvětlení z různých úhlů. 'Centrální' představuje standardní reprodukci barev. 'Nad Obrazovkou' zvyšuje jas. 'Pod Obrazovkou' snižuje jas. Toto nastavení se použije pouze tehdy, když je položka 'Režim Korekce Barev' nastavena na hodnotu 'Přesná'."
#define OPTION_VAL_CENTRAL_CS "Centrální"
#define OPTION_VAL_ABOVE_SCREEN_CS "Nad Obrazovkou"
#define OPTION_VAL_BELOW_SCREEN_CS "Pod Obrazovkou"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_CS "Úroveň Tmavého Filtru (%)"
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CS "Povolení snížení jasu na základě svítivosti. Lze použít k zamezení oslnění/únavy očí při hraní her s bílým pozadím, které jsou určeny pro zobrazení na nepodsvícené obrazovce Game Boy Color, a proto se mohou při zobrazení na moderní podsvícené obrazovce jevit jako nepříjemně jasné."
#define GAMBATTE_MIX_FRAMES_LABEL_CS "Prolínání Mezi-Snímku"
#define GAMBATTE_MIX_FRAMES_INFO_0_CS "Simuluje efekty duchů na LCD. 'Jednoduchý' provede mix aktuálního a předchozího snímku v poměru 50:50. 'LCD Ghosting' napodobuje přirozenou dobu odezvy LCD kombinací více vyrovnávací paměti snímků. Prolínání 'Jednoduchý' je nutné při hraní her, které se spoléhají na efekty průhlednosti LCD ghosting (Wave Race, Ballistic, Chikyuu Kaihou Gun ZAS...)."
#define OPTION_VAL_MIX_CS "Jednoduchá"
#define OPTION_VAL_LCD_GHOSTING_CS "LCD Ghosting (Přesný)"
#define OPTION_VAL_LCD_GHOSTING_FAST_CS "LCD Ghosting (Rychlý)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_CS "Převzorkování Zvuku"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_CS "Určete, který algoritmus se má použít při převzorkování generovaného zvuku (rychlost zvuku Game Boy je omezena pouze rychlostí zápisu procesoru, takže \"nativní\" frekvence jsou na moderních zvukových zařízeních nepraktické a musí se snížit). Nejvyšší kvalitu poskytuje 'Sinus'. 'Kosinus' zlepšuje výkon na méně náročném hardwaru."
#define OPTION_VAL_SINC_CS "Sinus"
#define OPTION_VAL_CC_CS "Kosinus"
#define GAMBATTE_GB_HWMODE_LABEL_CS "Emulovaný Hardware (Vyžaduje Restart)"
#define GAMBATTE_GB_HWMODE_INFO_0_CS "Zadejte, který typ hardwaru se má emulovat. Doporučuje se 'Auto'. Výběrem možnosti 'GBA' se odemknou dodatečné funkce v některých hrách pro Game Boy Color s funkcí 'GBA Enhanced' (Shantae, Wendy - Every Witch Way, Legend of Zelda: Oracle of Seasons/Ages...)."
#define OPTION_VAL_GB_CS NULL
#define OPTION_VAL_GBA_CS NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_CS "Použít Oficiální Bootloader (Vyžaduje Restart)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_CS "Povolení podpory oficiálních zavaděčů Game Boy a Game Boy Color s odpovídajícími animacemi spouštěcího loga."
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_CS NULL
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CS "Povolení této funkce umožní střídavé stisknutí/rychlé podržení směru doleva a doprava (nebo nahoru a dolů) současně. To může způsobit závady založené na pohybu."
#define GAMBATTE_TURBO_PERIOD_LABEL_CS "Doba Turba Tlačítka"
#define GAMBATTE_TURBO_PERIOD_INFO_0_CS "Zadejte interval opakování (ve snímcích) při podržení tlačítek Turbo A/B."
#define GAMBATTE_RUMBLE_LEVEL_LABEL_CS "Síla Vibrace Ovladače"
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_CS "Povoluje efekty haptické zpětné vazby pro podporované hry (Pokemon Pinball, Perfect Dark...)."
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CS "Zobrazit Nastavení Propojení Hry"
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CS "Povolení konfigurace možností síťového propojení hry (multiplayer). POZNÁMKA: Aby se toto nastavení projevilo, může být nutné přepnout Rychlé Menu."
#define GAMBATTE_GB_LINK_MODE_LABEL_CS "Režim Propojení Hry"
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_CS "Režim Propojení"
#define GAMBATTE_GB_LINK_MODE_INFO_0_CS "Při povolování funkce síťového propojení her zadejte, zda má aktuální instance běžet jako server nebo klient."
#define OPTION_VAL_NOT_CONNECTED_CS "Nepřipojeno"
#define OPTION_VAL_NETWORK_SERVER_CS "Síťový Server"
#define OPTION_VAL_NETWORK_CLIENT_CS "Síťový Klient"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CS "Port Síťového Propojení"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CS NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CS "Zadejte port používaný pro síťovou komunikaci Propojení Hry."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 01: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CS "Adresa Serveru Pt. 01: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CS "1. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CS "1. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 02: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CS "Adresa Serveru Pt. 02: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CS "2. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CS "2. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 03: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CS "Adresa Serveru Pt. 03: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CS "3. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CS "3. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 04: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CS "Adresa Serveru Pt. 04: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CS "4. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CS "4. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 05: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CS "Adresa Serveru Pt. 05: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CS "5. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CS "5. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 06: ___.__x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CS "Adresa Serveru Pt. 06: ___.__x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CS "6. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CS "6. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 07: ___.___.x__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CS "Adresa Serveru Pt. 07: ___.___.x__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CS "7. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CS "7. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 08: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CS "Adresa Serveru Pt. 08: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CS "8. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CS "8. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 09: ___.___.__x.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CS "Adresa Serveru Pt. 09: ___.___.__x.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CS "9. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CS "9. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 10: ___.___.___.x__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CS "Adresa Serveru Pt. 10: ___.___.___.x__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CS "10. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CS "10. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 11: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CS "Adresa Serveru Pt. 11: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CS "11. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CS "11. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CS "Adresa Serveru Síťového Připojení Pt. 12: ___.___.___.__x"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CS "Adresa Serveru Pt. 12: ___.___.___.__x"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CS "12. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení Hry' nastavena na 'Síťový Klient'."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CS "12. číslice IP adresy vzdáleného síťového serveru Propojení Hry. Používá se pouze v případě, že je položka 'Režim Propojení' nastavena na 'Síťový Klient'."

struct retro_core_option_v2_category option_cats_cs[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_CS,
      CATEGORY_GB_LINK_INFO_0_CS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cs[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_CS,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_CS,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CS },
         { "GBC",      OPTION_VAL_GBC_CS },
         { "SGB",      OPTION_VAL_SGB_CS },
         { "internal", OPTION_VAL_INTERNAL_CS },
         { "custom",   OPTION_VAL_CUSTOM_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CS,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CS,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_CS },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_CS },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_CS },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_CS },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_CS },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_CS },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_CS },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_CS },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_CS },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_CS },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_CS },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_CS },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_CS },
         { "GBC - Red",                OPTION_VAL_GBC_RED_CS },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_CS },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_CS },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_CS },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_CS },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_CS },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_CS },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_CS },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_CS },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_CS },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_CS },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_CS },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_CS },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_CS },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_CS },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_CS },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_CS },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_CS },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_CS },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_CS },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_CS },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_CS },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_CS },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_CS },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_CS },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_CS },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_CS },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_CS },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_CS },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_CS },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_CS },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_CS },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_CS },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_CS },
         { "Special 1",                OPTION_VAL_SPECIAL_1_CS },
         { "Special 2",                OPTION_VAL_SPECIAL_2_CS },
         { "Special 3",                OPTION_VAL_SPECIAL_3_CS },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CS },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_CS },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_CS },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_CS },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_CS },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CS,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CS,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_CS },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CS },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CS },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CS },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_CS },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_CS },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_CS },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_CS },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_CS },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_CS },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_CS },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_CS },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_CS },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_CS },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CS },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CS },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CS },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CS },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_CS },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CS },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_CS },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_CS },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CS },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CS },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CS },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_CS },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_CS },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_CS },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_CS },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CS },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CS },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CS },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CS },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_CS },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_CS },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CS },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CS },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CS },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_CS },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_CS },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_CS },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_CS },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CS },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CS },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CS },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_CS },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_CS },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_CS },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_CS },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_CS },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CS },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CS },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_CS },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_CS },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_CS },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_CS },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_CS },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_CS },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CS },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_CS },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_CS },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CS },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_CS },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_CS },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_CS },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CS },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_CS },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CS },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_CS },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_CS },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CS },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_CS },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CS },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CS },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CS },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_CS },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_CS },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_CS },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CS },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CS },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CS },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CS },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CS },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_CS },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CS },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CS },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_CS },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_CS },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CS },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CS },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_CS },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CS },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CS },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CS },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CS },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_CS },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CS },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CS },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CS },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CS },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CS,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CS,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_CS },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CS },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_CS },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_CS },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CS },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CS },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_CS },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_CS },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_CS },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CS },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_CS },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_CS },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_CS },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CS },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_CS },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CS },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_CS },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_CS },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_CS },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_CS },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CS },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CS },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_CS },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CS },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CS },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_CS },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_CS },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_CS },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_CS },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_CS },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_CS },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_CS },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CS },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_CS },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CS },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CS },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CS },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_CS },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_CS },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CS },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CS },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_CS },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CS },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CS },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CS },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CS },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_CS },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_CS },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CS },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CS },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CS },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CS },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_CS },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CS },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CS },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_CS },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_CS },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_CS },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CS },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_CS },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_CS },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_CS },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_CS },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CS },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_CS },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CS },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_CS },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CS },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CS },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_CS },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_CS },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CS },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CS },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_CS },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CS },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_CS },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_CS },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_CS },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CS },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CS },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CS },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_CS },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CS },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_CS },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CS },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CS },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CS },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CS },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_CS },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_CS },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_CS },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CS },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CS },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CS },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_CS },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_CS },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CS },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CS },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_CS },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CS },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CS,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CS,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_CS },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CS },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CS },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CS },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CS },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_CS },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CS },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CS },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CS },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_CS },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CS },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CS },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_CS },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CS },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CS },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CS },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CS },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_CS },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CS },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_CS },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_CS },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CS },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_CS },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_CS },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CS },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CS },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CS },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_CS },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CS },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CS },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CS },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CS },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CS },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CS },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CS },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CS },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CS },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_CS },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_CS },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CS },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CS },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CS },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_CS },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_CS },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_CS },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CS },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_CS },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CS },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_CS },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CS },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CS },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CS },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CS },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_CS },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CS },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CS },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_CS },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CS },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CS },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CS },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_CS },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CS },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CS },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CS },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CS },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CS },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CS },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_CS },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CS },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CS },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CS },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CS },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CS },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CS },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CS },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CS },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CS },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CS },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CS },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CS },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CS },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CS },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CS },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CS },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_CS },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_CS },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CS },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CS },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CS },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_CS },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CS },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_CS },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CS },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_CS },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CS },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CS },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CS },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CS },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CS },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_CS },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CS,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CS,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CS },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CS },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CS },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CS },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CS },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_CS },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CS },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CS },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_CS },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CS },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CS },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CS },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CS },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CS },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CS },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CS },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CS },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CS },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CS },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CS },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CS },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CS },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CS },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_CS },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CS },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_CS },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CS },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CS },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_CS },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CS },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CS },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CS },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CS },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CS },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_CS },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CS },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CS },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CS },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CS },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_CS },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CS },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_CS },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CS },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CS },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_CS },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CS,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CS,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_CS },
         { "always",   OPTION_VAL_ALWAYS_CS },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CS,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CS,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_CS },
         { "fast",     OPTION_VAL_FAST_CS },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CS,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CS,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_CS },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_CS },
         { "below screen", OPTION_VAL_BELOW_SCREEN_CS },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_CS,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CS,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_CS,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_CS,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_CS },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_CS },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_CS,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_CS,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_CS },
         { "cc",   OPTION_VAL_CC_CS },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_CS,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_CS,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_CS },
         { "GB",   OPTION_VAL_GB_CS },
         { "GBC",  OPTION_VAL_GBC_CS },
         { "GBA",  OPTION_VAL_GBA_CS },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_CS,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_CS,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_CS,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CS,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_CS,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_CS,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_CS,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_CS,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CS,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CS,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_CS,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_MODE_INFO_0_CS,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_CS },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_CS },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_CS },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CS,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CS,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CS,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cs = {
   option_cats_cs,
   option_defs_cs
};

/* RETRO_LANGUAGE_CY */

#define CATEGORY_GB_LINK_LABEL_CY NULL
#define CATEGORY_GB_LINK_INFO_0_CY NULL
#define GAMBATTE_GB_COLORIZATION_LABEL_CY NULL
#define GAMBATTE_GB_COLORIZATION_INFO_0_CY NULL
#define OPTION_VAL_AUTO_CY NULL
#define OPTION_VAL_GBC_CY NULL
#define OPTION_VAL_SGB_CY NULL
#define OPTION_VAL_INTERNAL_CY NULL
#define OPTION_VAL_CUSTOM_CY NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CY NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CY NULL
#define OPTION_VAL_GB_DMG_CY NULL
#define OPTION_VAL_GB_POCKET_CY NULL
#define OPTION_VAL_GB_LIGHT_CY NULL
#define OPTION_VAL_GBC_BLUE_CY NULL
#define OPTION_VAL_GBC_BROWN_CY NULL
#define OPTION_VAL_GBC_DARK_BLUE_CY NULL
#define OPTION_VAL_GBC_DARK_BROWN_CY NULL
#define OPTION_VAL_GBC_DARK_GREEN_CY NULL
#define OPTION_VAL_GBC_GRAYSCALE_CY NULL
#define OPTION_VAL_GBC_GREEN_CY NULL
#define OPTION_VAL_GBC_INVERTED_CY NULL
#define OPTION_VAL_GBC_ORANGE_CY NULL
#define OPTION_VAL_GBC_PASTEL_MIX_CY NULL
#define OPTION_VAL_GBC_RED_CY NULL
#define OPTION_VAL_GBC_YELLOW_CY NULL
#define OPTION_VAL_SGB_1A_CY NULL
#define OPTION_VAL_SGB_1B_CY NULL
#define OPTION_VAL_SGB_1C_CY NULL
#define OPTION_VAL_SGB_1D_CY NULL
#define OPTION_VAL_SGB_1E_CY NULL
#define OPTION_VAL_SGB_1F_CY NULL
#define OPTION_VAL_SGB_1G_CY NULL
#define OPTION_VAL_SGB_1H_CY NULL
#define OPTION_VAL_SGB_2A_CY NULL
#define OPTION_VAL_SGB_2B_CY NULL
#define OPTION_VAL_SGB_2C_CY NULL
#define OPTION_VAL_SGB_2D_CY NULL
#define OPTION_VAL_SGB_2E_CY NULL
#define OPTION_VAL_SGB_2F_CY NULL
#define OPTION_VAL_SGB_2G_CY NULL
#define OPTION_VAL_SGB_2H_CY NULL
#define OPTION_VAL_SGB_3A_CY NULL
#define OPTION_VAL_SGB_3B_CY NULL
#define OPTION_VAL_SGB_3C_CY NULL
#define OPTION_VAL_SGB_3D_CY NULL
#define OPTION_VAL_SGB_3E_CY NULL
#define OPTION_VAL_SGB_3F_CY NULL
#define OPTION_VAL_SGB_3G_CY NULL
#define OPTION_VAL_SGB_3H_CY NULL
#define OPTION_VAL_SGB_4A_CY NULL
#define OPTION_VAL_SGB_4B_CY NULL
#define OPTION_VAL_SGB_4C_CY NULL
#define OPTION_VAL_SGB_4D_CY NULL
#define OPTION_VAL_SGB_4E_CY NULL
#define OPTION_VAL_SGB_4F_CY NULL
#define OPTION_VAL_SGB_4G_CY NULL
#define OPTION_VAL_SGB_4H_CY NULL
#define OPTION_VAL_SPECIAL_1_CY NULL
#define OPTION_VAL_SPECIAL_2_CY NULL
#define OPTION_VAL_SPECIAL_3_CY NULL
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CY NULL
#define OPTION_VAL_TWB64_PACK_1_CY NULL
#define OPTION_VAL_TWB64_PACK_2_CY NULL
#define OPTION_VAL_TWB64_PACK_3_CY NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_CY NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CY NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CY NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_CY NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CY NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CY NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CY NULL
#define OPTION_VAL_TWB64_005_NEON_RED_CY NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_CY NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_CY NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_CY NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_CY NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_CY NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_CY NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_CY NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_CY NULL
#define OPTION_VAL_TWB64_014_DMG_099_CY NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CY NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CY NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CY NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CY NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_CY NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CY NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_CY NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_CY NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CY NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CY NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CY NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_CY NULL
#define OPTION_VAL_TWB64_027_BMO_VER_CY NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_CY NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_CY NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CY NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CY NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CY NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CY NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_CY NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_CY NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CY NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CY NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CY NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_CY NULL
#define OPTION_VAL_TWB64_040_DMG_VER_CY NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_CY NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_CY NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CY NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CY NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CY NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_CY NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_CY NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_CY NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_CY NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_CY NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CY NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CY NULL
#define OPTION_VAL_TWB64_053_VMU_VER_CY NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_CY NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_CY NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_CY NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_CY NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_CY NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CY NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_CY NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_CY NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CY NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_CY NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_CY NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_CY NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CY NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_CY NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CY NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_CY NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_CY NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CY NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_CY NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CY NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CY NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CY NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_CY NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_CY NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_CY NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CY NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CY NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CY NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CY NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CY NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_CY NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CY NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CY NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_CY NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_CY NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CY NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CY NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_CY NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CY NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CY NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CY NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CY NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_CY NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CY NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CY NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CY NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CY NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CY NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CY NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_CY NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CY NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_CY NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_CY NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CY NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CY NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_CY NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_CY NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_CY NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CY NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_CY NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_CY NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_CY NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CY NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_CY NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CY NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_CY NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_CY NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_CY NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_CY NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CY NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CY NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_CY NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CY NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CY NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_CY NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_CY NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_CY NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_CY NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_CY NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_CY NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_CY NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CY NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_CY NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CY NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CY NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CY NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_CY NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_CY NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CY NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CY NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_CY NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CY NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CY NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CY NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CY NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_CY NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_CY NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CY NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CY NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CY NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CY NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_CY NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CY NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CY NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_CY NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_CY NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_CY NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CY NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_CY NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_CY NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_CY NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_CY NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CY NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_CY NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CY NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_CY NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CY NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CY NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_CY NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_CY NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CY NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CY NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_CY NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CY NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_CY NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_CY NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_CY NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CY NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CY NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CY NULL
#define OPTION_VAL_TWB64_182_PASTEL109_CY NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CY NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_CY NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CY NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CY NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CY NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CY NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_CY NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_CY NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_CY NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CY NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CY NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CY NULL
#define OPTION_VAL_TWB64_195_EVA_01_CY NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_CY NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CY NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CY NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_CY NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CY NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CY NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CY NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_CY NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CY NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CY NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CY NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CY NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_CY NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CY NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CY NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CY NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_CY NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CY NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CY NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_CY NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CY NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CY NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CY NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CY NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_CY NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CY NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_CY NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_CY NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CY NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_CY NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_CY NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CY NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CY NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CY NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_CY NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CY NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CY NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CY NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CY NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CY NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CY NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CY NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CY NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CY NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_CY NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_CY NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CY NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CY NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CY NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_CY NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_CY NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_CY NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CY NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_CY NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CY NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_CY NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CY NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CY NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CY NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CY NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_CY NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CY NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CY NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_CY NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CY NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CY NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CY NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_CY NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CY NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CY NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CY NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CY NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CY NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CY NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_CY NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CY NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CY NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CY NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CY NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CY NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CY NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CY NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CY NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CY NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CY NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CY NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CY NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CY NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CY NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CY NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CY NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_CY NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_CY NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CY NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CY NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CY NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_CY NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CY NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_CY NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CY NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_CY NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CY NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CY NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CY NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CY NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CY NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_CY NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CY NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CY NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CY NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CY NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CY NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CY NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CY NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_CY NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CY NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CY NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_CY NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CY NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CY NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CY NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CY NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CY NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CY NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CY NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CY NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CY NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CY NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CY NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CY NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CY NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CY NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_CY NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CY NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_CY NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CY NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CY NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_CY NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CY NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CY NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CY NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CY NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CY NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_CY NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CY NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CY NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CY NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CY NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_CY NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CY NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_CY NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CY NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CY NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_CY NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CY NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CY NULL
#define OPTION_VAL_GBC_ONLY_CY NULL
#define OPTION_VAL_ALWAYS_CY NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CY NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CY NULL
#define OPTION_VAL_ACCURATE_CY NULL
#define OPTION_VAL_FAST_CY NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CY NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CY NULL
#define OPTION_VAL_CENTRAL_CY NULL
#define OPTION_VAL_ABOVE_SCREEN_CY NULL
#define OPTION_VAL_BELOW_SCREEN_CY NULL
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_CY NULL
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CY NULL
#define GAMBATTE_MIX_FRAMES_LABEL_CY NULL
#define GAMBATTE_MIX_FRAMES_INFO_0_CY NULL
#define OPTION_VAL_MIX_CY NULL
#define OPTION_VAL_LCD_GHOSTING_CY NULL
#define OPTION_VAL_LCD_GHOSTING_FAST_CY NULL
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_CY NULL
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_CY NULL
#define OPTION_VAL_SINC_CY NULL
#define OPTION_VAL_CC_CY NULL
#define GAMBATTE_GB_HWMODE_LABEL_CY NULL
#define GAMBATTE_GB_HWMODE_INFO_0_CY NULL
#define OPTION_VAL_GB_CY NULL
#define OPTION_VAL_GBA_CY NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_CY NULL
#define GAMBATTE_GB_BOOTLOADER_INFO_0_CY NULL
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_CY NULL
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CY NULL
#define GAMBATTE_TURBO_PERIOD_LABEL_CY NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_CY NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_CY NULL
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_CY NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CY NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CY NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_CY NULL
#define OPTION_VAL_NOT_CONNECTED_CY NULL
#define OPTION_VAL_NETWORK_SERVER_CY NULL
#define OPTION_VAL_NETWORK_CLIENT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CY NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CY NULL

struct retro_core_option_v2_category option_cats_cy[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_CY,
      CATEGORY_GB_LINK_INFO_0_CY
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cy[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_CY,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_CY,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CY },
         { "GBC",      OPTION_VAL_GBC_CY },
         { "SGB",      OPTION_VAL_SGB_CY },
         { "internal", OPTION_VAL_INTERNAL_CY },
         { "custom",   OPTION_VAL_CUSTOM_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_CY,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_CY,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_CY },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_CY },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_CY },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_CY },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_CY },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_CY },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_CY },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_CY },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_CY },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_CY },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_CY },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_CY },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_CY },
         { "GBC - Red",                OPTION_VAL_GBC_RED_CY },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_CY },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_CY },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_CY },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_CY },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_CY },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_CY },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_CY },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_CY },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_CY },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_CY },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_CY },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_CY },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_CY },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_CY },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_CY },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_CY },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_CY },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_CY },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_CY },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_CY },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_CY },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_CY },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_CY },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_CY },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_CY },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_CY },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_CY },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_CY },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_CY },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_CY },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_CY },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_CY },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_CY },
         { "Special 1",                OPTION_VAL_SPECIAL_1_CY },
         { "Special 2",                OPTION_VAL_SPECIAL_2_CY },
         { "Special 3",                OPTION_VAL_SPECIAL_3_CY },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_CY },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_CY },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_CY },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_CY },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_CY },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_CY,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_CY,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_CY },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_CY },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_CY },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_CY },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_CY },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_CY },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_CY },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_CY },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_CY },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_CY },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_CY },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_CY },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_CY },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_CY },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_CY },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_CY },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_CY },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_CY },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_CY },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_CY },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_CY },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_CY },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_CY },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_CY },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_CY },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_CY },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_CY },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_CY },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_CY },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_CY },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_CY },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_CY },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_CY },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_CY },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_CY },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_CY },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_CY },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_CY },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_CY },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_CY },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_CY },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_CY },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_CY },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_CY },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_CY },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_CY },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_CY },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_CY },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_CY },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_CY },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_CY },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_CY },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_CY },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_CY },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_CY },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_CY },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_CY },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_CY },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_CY },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_CY },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_CY },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_CY },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_CY },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_CY },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_CY },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_CY },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_CY },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_CY },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_CY },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_CY },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_CY },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_CY },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_CY },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_CY },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_CY },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_CY },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_CY },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_CY },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_CY },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_CY },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_CY },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_CY },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_CY },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_CY },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_CY },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_CY },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_CY },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_CY },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_CY },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_CY },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_CY },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_CY },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_CY },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_CY },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_CY },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_CY },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_CY },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_CY },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_CY },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_CY },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_CY,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_CY,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_CY },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_CY },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_CY },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_CY },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_CY },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_CY },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_CY },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_CY },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_CY },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_CY },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_CY },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_CY },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_CY },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_CY },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_CY },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_CY },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_CY },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_CY },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_CY },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_CY },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_CY },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_CY },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_CY },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_CY },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_CY },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_CY },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_CY },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_CY },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_CY },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_CY },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_CY },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_CY },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_CY },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_CY },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_CY },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_CY },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_CY },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_CY },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_CY },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_CY },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_CY },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_CY },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_CY },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_CY },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_CY },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_CY },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_CY },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_CY },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_CY },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_CY },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_CY },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_CY },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_CY },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_CY },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_CY },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_CY },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_CY },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_CY },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_CY },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_CY },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_CY },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_CY },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_CY },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_CY },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_CY },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_CY },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_CY },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_CY },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_CY },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_CY },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_CY },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_CY },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_CY },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_CY },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_CY },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_CY },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_CY },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_CY },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_CY },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_CY },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_CY },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_CY },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_CY },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_CY },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_CY },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_CY },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_CY },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_CY },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_CY },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_CY },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_CY },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_CY },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_CY },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_CY },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_CY },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_CY },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_CY },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_CY },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_CY },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_CY },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_CY,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_CY,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_CY },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_CY },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_CY },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_CY },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_CY },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_CY },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_CY },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_CY },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_CY },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_CY },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_CY },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_CY },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_CY },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_CY },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_CY },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_CY },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_CY },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_CY },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_CY },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_CY },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_CY },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_CY },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_CY },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_CY },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_CY },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_CY },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_CY },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_CY },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_CY },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_CY },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_CY },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_CY },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_CY },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_CY },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_CY },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_CY },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_CY },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_CY },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_CY },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_CY },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_CY },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_CY },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_CY },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_CY },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_CY },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_CY },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_CY },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_CY },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_CY },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_CY },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_CY },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_CY },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_CY },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_CY },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_CY },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_CY },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_CY },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_CY },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_CY },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_CY },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_CY },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_CY },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_CY },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_CY },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_CY },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_CY },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_CY },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_CY },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_CY },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_CY },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_CY },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_CY },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_CY },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_CY },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_CY },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_CY },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_CY },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_CY },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_CY },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_CY },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_CY },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_CY },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_CY },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_CY },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_CY },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_CY },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_CY },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_CY },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_CY },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_CY },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_CY },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_CY },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_CY },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_CY },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_CY },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_CY },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_CY },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_CY },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_CY },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_CY },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_CY,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_CY,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_CY },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_CY },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_CY },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_CY },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_CY },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_CY },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_CY },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_CY },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_CY },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_CY },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_CY },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_CY },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_CY },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_CY },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_CY },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_CY },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_CY },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__CY },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_CY },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_CY },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_CY },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_CY },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_CY },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_CY },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_CY },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_CY },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_CY },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_CY },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_CY },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_CY },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_CY },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_CY },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_CY },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_CY },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_CY },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_CY },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_CY },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_CY },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_CY },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_CY },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_CY },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_CY },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_CY },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_CY },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_CY },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_CY,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_CY,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_CY },
         { "always",   OPTION_VAL_ALWAYS_CY },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_CY,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_CY,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_CY },
         { "fast",     OPTION_VAL_FAST_CY },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_CY,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_CY,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_CY },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_CY },
         { "below screen", OPTION_VAL_BELOW_SCREEN_CY },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_CY,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_CY,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_CY,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_CY,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_CY },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_CY },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_CY,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_CY,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_CY },
         { "cc",   OPTION_VAL_CC_CY },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_CY,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_CY,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_CY },
         { "GB",   OPTION_VAL_GB_CY },
         { "GBC",  OPTION_VAL_GBC_CY },
         { "GBA",  OPTION_VAL_GBA_CY },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_CY,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_CY,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_CY,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_CY,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_CY,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_CY,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_CY,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_CY,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_CY,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_CY,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_CY,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_MODE_INFO_0_CY,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_CY },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_CY },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_CY },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_CY,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_CY,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_CY,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cy = {
   option_cats_cy,
   option_defs_cy
};

/* RETRO_LANGUAGE_DA */

#define CATEGORY_GB_LINK_LABEL_DA NULL
#define CATEGORY_GB_LINK_INFO_0_DA NULL
#define GAMBATTE_GB_COLORIZATION_LABEL_DA NULL
#define GAMBATTE_GB_COLORIZATION_INFO_0_DA NULL
#define OPTION_VAL_AUTO_DA NULL
#define OPTION_VAL_GBC_DA NULL
#define OPTION_VAL_SGB_DA NULL
#define OPTION_VAL_INTERNAL_DA NULL
#define OPTION_VAL_CUSTOM_DA NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_DA NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_DA NULL
#define OPTION_VAL_GB_DMG_DA NULL
#define OPTION_VAL_GB_POCKET_DA NULL
#define OPTION_VAL_GB_LIGHT_DA NULL
#define OPTION_VAL_GBC_BLUE_DA NULL
#define OPTION_VAL_GBC_BROWN_DA NULL
#define OPTION_VAL_GBC_DARK_BLUE_DA NULL
#define OPTION_VAL_GBC_DARK_BROWN_DA NULL
#define OPTION_VAL_GBC_DARK_GREEN_DA NULL
#define OPTION_VAL_GBC_GRAYSCALE_DA NULL
#define OPTION_VAL_GBC_GREEN_DA NULL
#define OPTION_VAL_GBC_INVERTED_DA NULL
#define OPTION_VAL_GBC_ORANGE_DA NULL
#define OPTION_VAL_GBC_PASTEL_MIX_DA NULL
#define OPTION_VAL_GBC_RED_DA NULL
#define OPTION_VAL_GBC_YELLOW_DA NULL
#define OPTION_VAL_SGB_1A_DA NULL
#define OPTION_VAL_SGB_1B_DA NULL
#define OPTION_VAL_SGB_1C_DA NULL
#define OPTION_VAL_SGB_1D_DA NULL
#define OPTION_VAL_SGB_1E_DA NULL
#define OPTION_VAL_SGB_1F_DA NULL
#define OPTION_VAL_SGB_1G_DA NULL
#define OPTION_VAL_SGB_1H_DA NULL
#define OPTION_VAL_SGB_2A_DA NULL
#define OPTION_VAL_SGB_2B_DA NULL
#define OPTION_VAL_SGB_2C_DA NULL
#define OPTION_VAL_SGB_2D_DA NULL
#define OPTION_VAL_SGB_2E_DA NULL
#define OPTION_VAL_SGB_2F_DA NULL
#define OPTION_VAL_SGB_2G_DA NULL
#define OPTION_VAL_SGB_2H_DA NULL
#define OPTION_VAL_SGB_3A_DA NULL
#define OPTION_VAL_SGB_3B_DA NULL
#define OPTION_VAL_SGB_3C_DA NULL
#define OPTION_VAL_SGB_3D_DA NULL
#define OPTION_VAL_SGB_3E_DA NULL
#define OPTION_VAL_SGB_3F_DA NULL
#define OPTION_VAL_SGB_3G_DA NULL
#define OPTION_VAL_SGB_3H_DA NULL
#define OPTION_VAL_SGB_4A_DA NULL
#define OPTION_VAL_SGB_4B_DA NULL
#define OPTION_VAL_SGB_4C_DA NULL
#define OPTION_VAL_SGB_4D_DA NULL
#define OPTION_VAL_SGB_4E_DA NULL
#define OPTION_VAL_SGB_4F_DA NULL
#define OPTION_VAL_SGB_4G_DA NULL
#define OPTION_VAL_SGB_4H_DA NULL
#define OPTION_VAL_SPECIAL_1_DA NULL
#define OPTION_VAL_SPECIAL_2_DA NULL
#define OPTION_VAL_SPECIAL_3_DA NULL
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_DA NULL
#define OPTION_VAL_TWB64_PACK_1_DA NULL
#define OPTION_VAL_TWB64_PACK_2_DA NULL
#define OPTION_VAL_TWB64_PACK_3_DA NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_DA NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_DA NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_DA NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_DA NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_DA NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_DA NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_DA NULL
#define OPTION_VAL_TWB64_005_NEON_RED_DA NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_DA NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_DA NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_DA NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_DA NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_DA NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_DA NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_DA NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_DA NULL
#define OPTION_VAL_TWB64_014_DMG_099_DA NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_DA NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_DA NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_DA NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_DA NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_DA NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_DA NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_DA NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_DA NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_DA NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_DA NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_DA NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_DA NULL
#define OPTION_VAL_TWB64_027_BMO_VER_DA NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_DA NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_DA NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_DA NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_DA NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_DA NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_DA NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_DA NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_DA NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_DA NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_DA NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_DA NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_DA NULL
#define OPTION_VAL_TWB64_040_DMG_VER_DA NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_DA NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_DA NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_DA NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_DA NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_DA NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_DA NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_DA NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_DA NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_DA NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_DA NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_DA NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_DA NULL
#define OPTION_VAL_TWB64_053_VMU_VER_DA NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_DA NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_DA NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_DA NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_DA NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_DA NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_DA NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_DA NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_DA NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_DA NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_DA NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_DA NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_DA NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_DA NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_DA NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_DA NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_DA NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_DA NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_DA NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_DA NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_DA NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_DA NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_DA NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_DA NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_DA NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_DA NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_DA NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_DA NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_DA NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_DA NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_DA NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_DA NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_DA NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_DA NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_DA NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_DA NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_DA NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_DA NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_DA NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_DA NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_DA NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_DA NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_DA NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_DA NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_DA NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_DA NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_DA NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_DA NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_DA NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_DA NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_DA NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_DA NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_DA NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_DA NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_DA NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_DA NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_DA NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_DA NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_DA NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_DA NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_DA NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_DA NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_DA NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_DA NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_DA NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_DA NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_DA NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_DA NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_DA NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_DA NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_DA NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_DA NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_DA NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_DA NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_DA NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_DA NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_DA NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_DA NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_DA NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_DA NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_DA NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_DA NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_DA NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_DA NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_DA NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_DA NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_DA NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_DA NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_DA NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_DA NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_DA NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_DA NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_DA NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_DA NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_DA NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_DA NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_DA NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_DA NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_DA NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_DA NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_DA NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_DA NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_DA NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_DA NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_DA NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_DA NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_DA NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_DA NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_DA NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_DA NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_DA NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_DA NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_DA NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_DA NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_DA NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_DA NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_DA NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_DA NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_DA NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_DA NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_DA NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_DA NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_DA NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_DA NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_DA NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_DA NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_DA NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_DA NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_DA NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_DA NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_DA NULL
#define OPTION_VAL_TWB64_182_PASTEL109_DA NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_DA NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_DA NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_DA NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_DA NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_DA NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_DA NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_DA NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_DA NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_DA NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_DA NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_DA NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_DA NULL
#define OPTION_VAL_TWB64_195_EVA_01_DA NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_DA NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_DA NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_DA NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_DA NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_DA NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_DA NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_DA NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_DA NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_DA NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_DA NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_DA NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_DA NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_DA NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_DA NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_DA NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_DA NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_DA NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_DA NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_DA NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_DA NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_DA NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_DA NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_DA NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_DA NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_DA NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_DA NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_DA NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_DA NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_DA NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_DA NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_DA NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_DA NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_DA NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_DA NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_DA NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_DA NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_DA NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_DA NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_DA NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_DA NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_DA NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_DA NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_DA NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_DA NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_DA NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_DA NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_DA NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_DA NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_DA NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_DA NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_DA NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_DA NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_DA NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_DA NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_DA NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_DA NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_DA NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_DA NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_DA NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_DA NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_DA NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_DA NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_DA NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_DA NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_DA NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_DA NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_DA NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_DA NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_DA NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_DA NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_DA NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_DA NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_DA NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_DA NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_DA NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_DA NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_DA NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_DA NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_DA NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_DA NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_DA NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_DA NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_DA NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_DA NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_DA NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_DA NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_DA NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_DA NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_DA NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_DA NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_DA NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_DA NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_DA NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_DA NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_DA NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_DA NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_DA NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_DA NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_DA NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_DA NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_DA NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_DA NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_DA NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_DA NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_DA NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_DA NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_DA NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_DA NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_DA NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_DA NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_DA NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_DA NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_DA NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_DA NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_DA NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_DA NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_DA NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_DA NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_DA NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_DA NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_DA NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_DA NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_DA NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_DA NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_DA NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_DA NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__DA NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_DA NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_DA NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_DA NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_DA NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_DA NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_DA NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_DA NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_DA NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_DA NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_DA NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_DA NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_DA NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_DA NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_DA NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_DA NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_DA NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_DA NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_DA NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_DA NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_DA NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_DA NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_DA NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_DA NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_DA NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_DA NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_DA NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_DA NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_DA NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_DA NULL
#define OPTION_VAL_GBC_ONLY_DA NULL
#define OPTION_VAL_ALWAYS_DA NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_DA NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_DA NULL
#define OPTION_VAL_ACCURATE_DA NULL
#define OPTION_VAL_FAST_DA NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_DA NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_DA NULL
#define OPTION_VAL_CENTRAL_DA NULL
#define OPTION_VAL_ABOVE_SCREEN_DA NULL
#define OPTION_VAL_BELOW_SCREEN_DA NULL
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_DA NULL
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_DA NULL
#define GAMBATTE_MIX_FRAMES_LABEL_DA NULL
#define GAMBATTE_MIX_FRAMES_INFO_0_DA NULL
#define OPTION_VAL_MIX_DA NULL
#define OPTION_VAL_LCD_GHOSTING_DA NULL
#define OPTION_VAL_LCD_GHOSTING_FAST_DA NULL
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_DA "Lyd resampler"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_DA NULL
#define OPTION_VAL_SINC_DA NULL
#define OPTION_VAL_CC_DA NULL
#define GAMBATTE_GB_HWMODE_LABEL_DA NULL
#define GAMBATTE_GB_HWMODE_INFO_0_DA NULL
#define OPTION_VAL_GB_DA NULL
#define OPTION_VAL_GBA_DA NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_DA NULL
#define GAMBATTE_GB_BOOTLOADER_INFO_0_DA NULL
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_DA NULL
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_DA NULL
#define GAMBATTE_TURBO_PERIOD_LABEL_DA NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_DA NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_DA NULL
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_DA NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_DA NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_DA NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_DA NULL
#define OPTION_VAL_NOT_CONNECTED_DA NULL
#define OPTION_VAL_NETWORK_SERVER_DA NULL
#define OPTION_VAL_NETWORK_CLIENT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_DA NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_DA NULL

struct retro_core_option_v2_category option_cats_da[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_DA,
      CATEGORY_GB_LINK_INFO_0_DA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_da[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_DA,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_DA,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_DA },
         { "GBC",      OPTION_VAL_GBC_DA },
         { "SGB",      OPTION_VAL_SGB_DA },
         { "internal", OPTION_VAL_INTERNAL_DA },
         { "custom",   OPTION_VAL_CUSTOM_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_DA,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_DA,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_DA },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_DA },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_DA },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_DA },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_DA },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_DA },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_DA },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_DA },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_DA },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_DA },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_DA },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_DA },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_DA },
         { "GBC - Red",                OPTION_VAL_GBC_RED_DA },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_DA },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_DA },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_DA },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_DA },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_DA },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_DA },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_DA },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_DA },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_DA },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_DA },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_DA },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_DA },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_DA },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_DA },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_DA },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_DA },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_DA },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_DA },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_DA },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_DA },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_DA },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_DA },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_DA },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_DA },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_DA },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_DA },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_DA },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_DA },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_DA },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_DA },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_DA },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_DA },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_DA },
         { "Special 1",                OPTION_VAL_SPECIAL_1_DA },
         { "Special 2",                OPTION_VAL_SPECIAL_2_DA },
         { "Special 3",                OPTION_VAL_SPECIAL_3_DA },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_DA },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_DA },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_DA },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_DA },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_DA },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_DA,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_DA,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_DA },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_DA },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_DA },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_DA },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_DA },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_DA },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_DA },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_DA },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_DA },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_DA },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_DA },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_DA },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_DA },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_DA },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_DA },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_DA },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_DA },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_DA },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_DA },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_DA },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_DA },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_DA },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_DA },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_DA },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_DA },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_DA },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_DA },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_DA },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_DA },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_DA },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_DA },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_DA },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_DA },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_DA },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_DA },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_DA },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_DA },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_DA },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_DA },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_DA },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_DA },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_DA },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_DA },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_DA },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_DA },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_DA },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_DA },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_DA },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_DA },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_DA },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_DA },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_DA },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_DA },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_DA },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_DA },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_DA },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_DA },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_DA },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_DA },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_DA },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_DA },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_DA },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_DA },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_DA },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_DA },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_DA },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_DA },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_DA },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_DA },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_DA },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_DA },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_DA },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_DA },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_DA },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_DA },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_DA },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_DA },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_DA },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_DA },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_DA },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_DA },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_DA },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_DA },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_DA },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_DA },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_DA },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_DA },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_DA },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_DA },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_DA },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_DA },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_DA },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_DA },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_DA },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_DA },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_DA },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_DA },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_DA },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_DA },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_DA },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_DA,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_DA,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_DA },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_DA },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_DA },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_DA },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_DA },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_DA },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_DA },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_DA },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_DA },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_DA },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_DA },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_DA },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_DA },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_DA },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_DA },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_DA },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_DA },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_DA },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_DA },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_DA },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_DA },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_DA },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_DA },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_DA },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_DA },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_DA },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_DA },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_DA },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_DA },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_DA },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_DA },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_DA },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_DA },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_DA },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_DA },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_DA },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_DA },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_DA },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_DA },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_DA },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_DA },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_DA },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_DA },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_DA },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_DA },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_DA },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_DA },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_DA },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_DA },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_DA },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_DA },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_DA },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_DA },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_DA },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_DA },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_DA },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_DA },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_DA },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_DA },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_DA },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_DA },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_DA },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_DA },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_DA },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_DA },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_DA },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_DA },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_DA },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_DA },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_DA },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_DA },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_DA },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_DA },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_DA },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_DA },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_DA },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_DA },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_DA },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_DA },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_DA },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_DA },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_DA },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_DA },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_DA },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_DA },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_DA },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_DA },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_DA },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_DA },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_DA },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_DA },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_DA },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_DA },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_DA },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_DA },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_DA },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_DA },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_DA },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_DA },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_DA },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_DA,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_DA,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_DA },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_DA },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_DA },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_DA },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_DA },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_DA },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_DA },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_DA },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_DA },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_DA },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_DA },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_DA },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_DA },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_DA },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_DA },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_DA },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_DA },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_DA },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_DA },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_DA },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_DA },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_DA },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_DA },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_DA },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_DA },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_DA },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_DA },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_DA },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_DA },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_DA },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_DA },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_DA },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_DA },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_DA },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_DA },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_DA },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_DA },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_DA },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_DA },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_DA },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_DA },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_DA },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_DA },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_DA },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_DA },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_DA },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_DA },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_DA },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_DA },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_DA },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_DA },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_DA },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_DA },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_DA },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_DA },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_DA },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_DA },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_DA },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_DA },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_DA },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_DA },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_DA },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_DA },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_DA },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_DA },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_DA },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_DA },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_DA },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_DA },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_DA },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_DA },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_DA },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_DA },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_DA },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_DA },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_DA },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_DA },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_DA },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_DA },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_DA },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_DA },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_DA },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_DA },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_DA },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_DA },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_DA },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_DA },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_DA },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_DA },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_DA },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_DA },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_DA },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_DA },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_DA },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_DA },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_DA },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_DA },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_DA },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_DA },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_DA },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_DA,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_DA,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_DA },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_DA },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_DA },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_DA },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_DA },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_DA },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_DA },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_DA },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_DA },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_DA },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_DA },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_DA },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_DA },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_DA },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_DA },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_DA },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_DA },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__DA },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_DA },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_DA },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_DA },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_DA },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_DA },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_DA },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_DA },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_DA },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_DA },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_DA },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_DA },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_DA },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_DA },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_DA },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_DA },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_DA },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_DA },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_DA },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_DA },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_DA },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_DA },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_DA },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_DA },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_DA },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_DA },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_DA },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_DA },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_DA,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_DA,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_DA },
         { "always",   OPTION_VAL_ALWAYS_DA },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_DA,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_DA,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_DA },
         { "fast",     OPTION_VAL_FAST_DA },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_DA,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_DA,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_DA },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_DA },
         { "below screen", OPTION_VAL_BELOW_SCREEN_DA },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_DA,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_DA,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_DA,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_DA,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_DA },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_DA },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_DA,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_DA,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_DA },
         { "cc",   OPTION_VAL_CC_DA },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_DA,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_DA,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_DA },
         { "GB",   OPTION_VAL_GB_DA },
         { "GBC",  OPTION_VAL_GBC_DA },
         { "GBA",  OPTION_VAL_GBA_DA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_DA,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_DA,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_DA,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_DA,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_DA,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_DA,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_DA,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_DA,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_DA,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_DA,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_DA,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_MODE_INFO_0_DA,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_DA },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_DA },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_DA },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_DA,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_DA,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_DA,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_da = {
   option_cats_da,
   option_defs_da
};

/* RETRO_LANGUAGE_DE */

#define CATEGORY_GB_LINK_LABEL_DE "Spiel-Link"
#define CATEGORY_GB_LINK_INFO_0_DE "Konfiguriert vernetzte \"Game Boy Spiele Link\" (Mehrspieler) Optionen."
#define GAMBATTE_GB_COLORIZATION_LABEL_DE "GB-Einfärbung"
#define GAMBATTE_GB_COLORIZATION_INFO_0_DE "Aktiviert die Einfärbung von Game Boy Spielen. 'Automatisch' wählt die 'beste' (am buntesten/angemessenste) Palette. 'GBC' wählt spielspezifische Game Boy Color Palette aus, wenn sie definiert ist, ansonsten 'GBC - Dunkelgrün'. 'SGB' wählt spielspezifische Super Game Boy Palette falls definiert, ansonsten 'SGB - 1A'. 'Intern' verwendet 'Interne Farbpalette' Core-Einstellung. 'Benutzerdefiniert' lädt benutzerdefinierte Palette aus dem Systemverzeichnis."
#define OPTION_VAL_AUTO_DE NULL
#define OPTION_VAL_GBC_DE NULL
#define OPTION_VAL_SGB_DE NULL
#define OPTION_VAL_INTERNAL_DE "Intern"
#define OPTION_VAL_CUSTOM_DE "Benutzerdefiniert"
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_DE "Interne Farbpalette"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_DE "Wählt die Farbpalette, die für das Einfärben von Game-Boy-Spielen genutzt wird wenn \"GB-Einfärbung\" auf \"Intern\" gestellt ist, oder wenn \"GB-Einfärbung\" auf \"Automatisch\" gestellt ist und das Spiel keine definierte SGB- oder GBC-Farbpalette besitzt. \"GB\" ahmt das Display des originalen Game Boys nach. \"GBC\" ist identisch zu den eingebauten Voreinstellungen des Game Boy Colors. \"SGB\" ist identisch zu den eingebauten Voreinstellungen des Super Game Boys."
#define OPTION_VAL_GB_DMG_DE NULL
#define OPTION_VAL_GB_POCKET_DE NULL
#define OPTION_VAL_GB_LIGHT_DE NULL
#define OPTION_VAL_GBC_BLUE_DE "GBC - Blau"
#define OPTION_VAL_GBC_BROWN_DE "GBC - Braun"
#define OPTION_VAL_GBC_DARK_BLUE_DE "GBC - Dunkelblau"
#define OPTION_VAL_GBC_DARK_BROWN_DE "GBC - Dunkelbraun"
#define OPTION_VAL_GBC_DARK_GREEN_DE "GBC - Dunkelgrün"
#define OPTION_VAL_GBC_GRAYSCALE_DE "GBC - Graustufen"
#define OPTION_VAL_GBC_GREEN_DE "GBC - Grün"
#define OPTION_VAL_GBC_INVERTED_DE "GBC - Invertiert"
#define OPTION_VAL_GBC_ORANGE_DE NULL
#define OPTION_VAL_GBC_PASTEL_MIX_DE "GBC - Pastellmischung"
#define OPTION_VAL_GBC_RED_DE "GBC - Rot"
#define OPTION_VAL_GBC_YELLOW_DE "GBC - Gelb"
#define OPTION_VAL_SGB_1A_DE NULL
#define OPTION_VAL_SGB_1B_DE NULL
#define OPTION_VAL_SGB_1C_DE NULL
#define OPTION_VAL_SGB_1D_DE NULL
#define OPTION_VAL_SGB_1E_DE NULL
#define OPTION_VAL_SGB_1F_DE NULL
#define OPTION_VAL_SGB_1G_DE NULL
#define OPTION_VAL_SGB_1H_DE NULL
#define OPTION_VAL_SGB_2A_DE NULL
#define OPTION_VAL_SGB_2B_DE NULL
#define OPTION_VAL_SGB_2C_DE NULL
#define OPTION_VAL_SGB_2D_DE NULL
#define OPTION_VAL_SGB_2E_DE NULL
#define OPTION_VAL_SGB_2F_DE NULL
#define OPTION_VAL_SGB_2G_DE NULL
#define OPTION_VAL_SGB_2H_DE NULL
#define OPTION_VAL_SGB_3A_DE NULL
#define OPTION_VAL_SGB_3B_DE NULL
#define OPTION_VAL_SGB_3C_DE NULL
#define OPTION_VAL_SGB_3D_DE NULL
#define OPTION_VAL_SGB_3E_DE NULL
#define OPTION_VAL_SGB_3F_DE NULL
#define OPTION_VAL_SGB_3G_DE NULL
#define OPTION_VAL_SGB_3H_DE NULL
#define OPTION_VAL_SGB_4A_DE NULL
#define OPTION_VAL_SGB_4B_DE NULL
#define OPTION_VAL_SGB_4C_DE NULL
#define OPTION_VAL_SGB_4D_DE NULL
#define OPTION_VAL_SGB_4E_DE NULL
#define OPTION_VAL_SGB_4F_DE NULL
#define OPTION_VAL_SGB_4G_DE NULL
#define OPTION_VAL_SGB_4H_DE NULL
#define OPTION_VAL_SPECIAL_1_DE "Spezial 1"
#define OPTION_VAL_SPECIAL_2_DE "Spezial 2"
#define OPTION_VAL_SPECIAL_3_DE "Spezial 3"
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_DE "Spezial 4 (TI-83)"
#define OPTION_VAL_TWB64_PACK_1_DE NULL
#define OPTION_VAL_TWB64_PACK_2_DE NULL
#define OPTION_VAL_TWB64_PACK_3_DE NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_DE NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_DE "> TWB64 - Pack 1-Farbpalette"
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_DE "Wählt die interne Farbpalette wenn „Interne Farbpalette“ auf „TWB64 - Pack 1“ gestellt ist."
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_DE "TWB64 001 - Aqours Blau"
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_DE NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_DE "TWB64 003 - SpongeBob Gelb"
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_DE NULL
#define OPTION_VAL_TWB64_005_NEON_RED_DE "TWB64 005 - Neon-Rot"
#define OPTION_VAL_TWB64_006_NEON_BLUE_DE "TWB64 006 - Neon-Blau"
#define OPTION_VAL_TWB64_007_NEON_YELLOW_DE "TWB64 007 - Neon-Gelb"
#define OPTION_VAL_TWB64_008_NEON_GREEN_DE "TWB64 008 - Neon-Grün"
#define OPTION_VAL_TWB64_009_NEON_PINK_DE "TWB64 009 - Neon-Pink"
#define OPTION_VAL_TWB64_010_MARIO_RED_DE "TWB64 010 - Mario Rot"
#define OPTION_VAL_TWB64_011_NICK_ORANGE_DE NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_DE "TWB64 012 - Virtueller Blick"
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_DE "TWB64 013 - Goldene Wildnis"
#define OPTION_VAL_TWB64_014_DMG_099_DE NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_DE "TWB64 015 - Klassisches Bliolett"
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_DE NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_DE NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_DE NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_DE "TWB64 019 - Musen Pink"
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_DE "TWB64 020 - School Idol Blau"
#define OPTION_VAL_TWB64_021_GAMATE_VER_DE NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_DE "TWB64 022 - Grünstufen Ver."
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_DE NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_DE "TWB64 024 - Super-Saiyajin-Gott"
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_DE "TWB64 025 - Super-Saiyajin-Blau"
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_DE "TWB64 026 - ANIMAX BLAU"
#define OPTION_VAL_TWB64_027_BMO_VER_DE NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_DE NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_DE NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_DE NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_DE "TWB64 031 - Cosmo & WandaPalette"
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_DE "TWB64 032 - Danny Phantom Silber"
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_DE NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_DE "TWB64 034 - Reiseholz"
#define OPTION_VAL_TWB64_035_POKEMON_VER_DE "TWB64 035 - Pokemon-Ver."
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_DE "TWB64 036 - Game-Grump-Orange"
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_DE "TWB64 037 - Scooby-Doo-Mystery-Ver."
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_DE "TWB64 038 - Pokemon-mini-Ver."
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_DE "TWB64 039 - Supervision-Ver."
#define OPTION_VAL_TWB64_040_DMG_VER_DE "TWB64 040 - DMG-Ver."
#define OPTION_VAL_TWB64_041_POCKET_VER_DE "TWB64 041 - Pocket-Ver."
#define OPTION_VAL_TWB64_042_LIGHT_VER_DE "TWB64 042 - Light-Ver."
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_DE NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_DE NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_DE "TWB64 045 - Pikachu-Gelb"
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_DE "TWB64 046 - Evoli-Braun"
#define OPTION_VAL_TWB64_047_MICROVISION_VER_DE "TWB64 047 - Microvision-Ver."
#define OPTION_VAL_TWB64_048_TI_83_VER_DE "TWB64 048 - TI-83-Ver."
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_DE NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_DE NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_DE NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_DE "TWB64 052 - Thaddäus Meerschaumgrün"
#define OPTION_VAL_TWB64_053_VMU_VER_DE NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_DE NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_DE "TWB64 055 - Android-Grün"
#define OPTION_VAL_TWB64_056_AMAZON_VISION_DE "TWB64 056 - Amazonas Vision"
#define OPTION_VAL_TWB64_057_GOOGLE_RED_DE "TWB64 057 - Google-Rot"
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_DE "TWB64 058 - Google-Blau"
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_DE "TWB64 059 - Google-Gelb"
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_DE "TWB64 060 - Google-Grün"
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_DE NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_DE NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_DE NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_DE NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_DE NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_DE NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_DE NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_DE NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_DE NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_DE NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_DE NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_DE NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_DE NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_DE NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_DE NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_DE NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_DE NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_DE NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_DE NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_DE NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_DE NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_DE NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_DE NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_DE "TWB64 084 - Super-Saiyajin"
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_DE "TWB64 085 - Perfekter Ultrainstinkt"
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_DE "TWB64 086 - Saint Snow Rot"
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_DE "TWB64 087 - Gelbe Banane"
#define OPTION_VAL_TWB64_088_GREEN_BANANA_DE "TWB64 088 - Grüne Banane"
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_DE "TWB64 089 - Super-Saiyajin 3"
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_DE "TWB64 090 - Super Saiyajin Blue Evolved"
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_DE NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_DE "TWB64 092 - Untersuchungsgelb"
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_DE NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_DE NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_DE NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_DE "TWB64 096 - Strohhut Rot"
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_DE NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_DE "TWB64 098 - Deku Alpha Smaragd"
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_DE "TWB64 099 - Blaue Streifen Ver."
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_DE "TWB64 100 - Vorgehärtete Marmor-Himbeere"
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_DE "> TWB64 - Pack 2-Farbpalette"
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_DE "Wählt die interne Farbpalette wenn „Interne Farbpalette“ auf „TWB64 - Pack 2“ gestellt ist."
#define OPTION_VAL_TWB64_101_765PRO_PINK_DE NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_DE NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_DE NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_DE NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_DE NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_DE NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_DE NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_DE NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_DE NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_DE NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_DE NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_DE NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_DE NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_DE NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_DE NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_DE NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_DE NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_DE NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_DE NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_DE NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_DE NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_DE NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_DE NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_DE "TWB64 124 - Nogizaka46 Lila"
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_DE NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_DE NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_DE NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_DE NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_DE NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_DE NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_DE NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_DE NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_DE NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_DE "TWB64 134 - Sonnenaufgangs-Rot"
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_DE "TWB64 135 - Burger King Farbkombo"
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_DE "TWB64 136 - Grand Zeno Mantel"
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_DE NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_DE "TWB64 138 - Irischgrün"
#define OPTION_VAL_TWB64_139_GOKU_GI_DE NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_DE NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_DE "TWB64 141 - Weihnachtsgold"
#define OPTION_VAL_TWB64_142_PEPSI_VISION_DE NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_DE "TWB64 143 - Bubblun-Grün"
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_DE "TWB64 144 - Bobblun-Blau"
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_DE NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_DE "TWB64 146 - Olympisches Gold"
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_DE NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_DE NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_DE "TWB64 149 - Olympisches Silber"
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_DE "TWB64 150 - Olympische Bronze"
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_DE "TWB64 151 - ANA Flight Blau"
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_DE "TWB64 152 - Nijigasaki-Orange"
#define OPTION_VAL_TWB64_153_HOLOBLUE_DE "TWB64 153 - Holoblau"
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_DE "TWB64 154 - WWE Weiß und Rot"
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_DE NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_DE "TWB64 156 - Pokedex-Rot"
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_DE NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_DE "TWB64 158 - Xbox-Grün"
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_DE NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_DE "TWB64 160 - Sprite Grün"
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_DE NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_DE NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_DE NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_DE NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_DE NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_DE "TWB64 166 - Zeitloses Gold und Rot"
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_DE NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_DE NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_DE NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_DE NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_DE NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_DE NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_DE NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_DE NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_DE NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_DE NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_DE NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_DE NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_DE NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_DE NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_DE NULL
#define OPTION_VAL_TWB64_182_PASTEL109_DE "TWB64 182 - PASTELL109"
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_DE NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_DE NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_DE NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_DE NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_DE "TWB64 187 - Circle K Farbkombo"
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_DE "TWB64 188 - Pizza-Hut-Rot"
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_DE "TWB64 189 - Emerald-Grün"
#define OPTION_VAL_TWB64_190_GRAND_IVORY_DE NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_DE "TWB64 191 - Dämonengold"
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_DE "TWB64 192 - SEGA-Tokyo-Blau"
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_DE "TWB64 193 - Champions Tunic"
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_DE "TWB64 194 - DK-Fassbraun"
#define OPTION_VAL_TWB64_195_EVA_01_DE NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_DE "TWB64 196 - Wilder Westen Vision"
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_DE NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_DE "TWB64 198 - Niconico Meeresgrün"
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_DE "TWB64 199 - Duracell Kupfer"
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_DE NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_DE "> TWB64 - Pack 3-Farbpalette"
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_DE "Wählt die interne Farbpalette wenn „Interne Farbpalette“ auf „TWB64 - Pack 3“ gestellt ist."
#define OPTION_VAL_TWB64_201_DMG_GOLD_DE NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_DE "TWB64 202 - LCD Uhr Grün"
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_DE "TWB64 203 - Famicom Rausch"
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_DE "TWB64 204 - DK Arcade Blau"
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_DE "TWB64 205 - Erweitertes Indigo"
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_DE "TWB64 206 - Ultraschwarz"
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_DE "TWB64 207 - Chaos Emerald Grün"
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_DE "TWB64 208 - Blauer Bomber Vision"
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_DE NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_DE "TWB64 210 - Dampfgrau"
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_DE NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_DE NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_DE NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_DE "TWB64 214 - COLLECTION von SaGa Ver."
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_DE "TWB64 215 - Rocky Valley Urlaub"
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_DE NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_DE "TWB64 217 - DMG Erbsengrün"
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_DE NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_DE "TWB64 219 - Unbesiegbares Gelb und Blau"
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_DE "TWB64 220 - Grinch Grün"
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_DE "TWB64 221 - animierende vision"
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_DE NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_DE "TWB64 223 - Grünes Erwachen"
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_DE "TWB64 224 - Goomba Braun"
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_DE "TWB64 225 - WarioWare MikroBlau"
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_DE "TWB64 226 - KonoSuba Sorbett"
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_DE "TWB64 227 - Gruseliges Violett"
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_DE "TWB64 228 - Schatzgold"
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_DE "TWB64 229 - Kirschblüte Pink"
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_DE "TWB64 230 - Goldene Trophäe"
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_DE "TWB64 231 - Gletscher-Winterblau"
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_DE "TWB64 232 - Leprechaun Grün"
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_DE "TWB64 233 - SAITAMA SUPERBLAU"
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_DE "TWB64 234 - SAITAMA SUPERGRÜN"
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_DE "TWB64 235 - Duolingogrün"
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_DE "TWB64 236 - Super Pilzblick"
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_DE "TWB64 237 - Antikes Hisuianisches Braun"
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_DE NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_DE "TWB64 239 - LAWSON BLAU"
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_DE "TWB64 240 - Anime-Expo Rot"
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_DE "TWB64 241 - Brillantes Diamantblau"
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_DE "TWB64 242 - Leuchtende Perle Pink"
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_DE "TWB64 243 - Funimation Melone"
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_DE "TWB64 244 - Teyvat Braun"
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_DE "TWB64 245 - Chozo Blau"
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_DE "TWB64 246 - Spotify Grün"
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_DE "TWB64 247 - Dr. Pepper Rot"
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_DE "TWB64 248 - NHK Silber-Grau"
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_DE NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_DE NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_DE "TWB64 251 - Universal Studios Blau"
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_DE NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_DE "TWB64 253 - Kentucky Fried Rot"
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_DE NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_DE NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_DE NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_DE NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_DE "TWB64 258 - Bills PC-Bildschirm"
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_DE "TWB64 259 - Sonic Mega Blau"
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_DE "TWB64 260 - Fools Gold und Silber"
#define OPTION_VAL_TWB64_261_UTA_VISION_DE NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_DE "TWB64 262 - Metallisches Paldea-Messing"
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_DE "TWB64 263 - Noble Weihnachten"
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_DE "TWB64 264 - Winter Weihnachten"
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_DE NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_DE NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_DE "TWB64 267 - 7-Eleven Farbkombo"
#define OPTION_VAL_TWB64_268_PAC_PALETTE_DE NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_DE "TWB64 269 - Verwundbares Blau"
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_DE "TWB64 270 - Nachtsicht Grün"
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_DE NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_DE "TWB64 272 - Gold, Silber und Bronze"
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_DE NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_DE NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_DE "TWB64 275 - Saugfähig und Gelb"
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_DE NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_DE NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_DE "TWB64 278 - 1. Vision Pastel"
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_DE "TWB64 279 - Perfekter Majin-Kaiser"
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_DE "TWB64 280 - J-Pop Idol Sorbett"
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_DE "TWB64 281 - Ryuuguu Sonnenuntergang"
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_DE "TWB64 282 - Tropischer Sternfall"
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_DE "TWB64 283 - Farbenfrohe Horizonte"
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_DE "TWB64 284 - SCHWARZPINK BLINKENDES PINK"
#define OPTION_VAL_TWB64_285_DMG_SWITCH_DE NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_DE NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_DE NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_DE "TWB64 288 - Saiyan Biest Silber"
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_DE NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_DE "TWB64 290 - A-RISE BLAU"
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_DE "TWB64 291 - TROPISCHE DOPPEL-APRIKOSE"
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_DE NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_DE "TWB64 293 - Froschmünze Grün"
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_DE NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_DE NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_DE "TWB64 296 - BANGTAN ARMEE VIOLETT"
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_DE "TWB64 297 - LE SSERAFIM FURCHTLOSES BLAU"
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_DE NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_DE "TWB64 299 - 3DS Virtual Console Grün"
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_DE "TWB64 300 - Wunder-Violett"
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_DE NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_DE "Wählt die interne Farbpalette wenn „Interne Farbpalette“ auf „PixelShift - Pack 1“ gestellt ist."
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_DE "PixelShift 01 - Arktis-Grün"
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_DE NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_DE NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_DE NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_DE "PixelShift 05 - Schokoladenleiste"
#define OPTION_VAL_PIXELSHIFT_06_CMYK_DE NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_DE "PixelShift 07 - Zuckerwatte"
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_DE "PixelShift 08 - Einfache Grüne"
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_DE NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_DE NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_DE NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_DE "PixelShift 12 - Game Boy Pocket alt"
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_DE NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_DE NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_DE "PixelShift 15 - GB Hintergrundbeleuchtung blau"
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_DE "PixelShift 16 - GB Hintergrundbeleuchtung verblasst"
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_DE "PixelShift 17 - GB Hintergrundbeleuchtung orange"
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__DE "PixelShift 18 - GB Hintergrundbeleuchtung weiss "
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_DE "PixelShift 19 - GB Hintergrundbeleuchtung dunkles Gelb"
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_DE NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_DE NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_DE NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_DE NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_DE "PixelShift 24 - GB neu"
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_DE NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_DE "PixelShift 26 - GB alt"
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_DE NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_DE "PixelShift 28 - GB Gewaschen-gelbe Hintergrundbeleuchtung"
#define OPTION_VAL_PIXELSHIFT_29_GHOST_DE "PixelShift 29 - Geist"
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_DE "PixelShift 30 - Im Dunkeln leuchten"
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_DE "PixelShift 31 - Goldene Leiste"
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_DE NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_DE "PixelShift 33 - Grau-grüne Mischung"
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_DE NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_DE NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_DE "PixelShift 36 - Zeitung"
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_DE NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_DE NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_DE "PixelShift 39 - Umriss"
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_DE "PixelShift 40 - Plötzlicher Sonnenschein"
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_DE NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_DE NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_DE NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_DE NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_DE "PixelShift 45 - Wunsch"
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_DE "Farbkorrektur"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_DE "Passt die Ausgabefarben an die Anzeige der realen Game Boy Color Hardware an. 'Nur GBC' sorgt dafür, dass die Korrektur nur beim Spielen von Game Boy Color Spielen angewendet wird oder wenn Sie eine Game Boy Color Palette verwenden, um ein Game Boy Spiel einzufärben. 'Immer' wendet die Farbkorrektur auf alle Inhalte an und liefert unerwartete/suboptimale Ergebnisse bei Verwendung von 'GB' oder 'SGB' internen Farbpaletten."
#define OPTION_VAL_GBC_ONLY_DE "Nur GBC"
#define OPTION_VAL_ALWAYS_DE "Immer"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_DE "Farbkorrekturmodus"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_DE "Bestimmt die Methode, die bei der Farbkorrektur verwendet wird. 'Genau' erzeugt Ausgabe, die kaum von einem echten LCD-Bildschirm für Game Boy zu unterscheiden ist. 'Schnell' verdunkelt lediglich die Farben und verringert die Sättigung und kann auf Low-End-Hardware verwendet werden, wenn die 'Genau'-Methode zu langsam ist."
#define OPTION_VAL_ACCURATE_DE "Genau"
#define OPTION_VAL_FAST_DE "Schnell"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_DE "Farbkorrektur – Frontlichtposition"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_DE "Simuliert die physikalische Reaktion des Game Boy Color LCD-Bildschirms, wenn es aus verschiedenen Blickwinkeln beleuchtet wird. 'Zentral' stellt die Standard-Farbwiedergabe dar. 'Über dem Bildschirm' erhöht die Helligkeit. 'Unterhalb des Bildschirms' verringert die Helligkeit. Diese Einstellung gilt nur, wenn 'Farbkorrekturmodus' auf 'Genau' gesetzt ist."
#define OPTION_VAL_CENTRAL_DE "Zentral"
#define OPTION_VAL_ABOVE_SCREEN_DE "Über dem Bildschirm"
#define OPTION_VAL_BELOW_SCREEN_DE "Unterhalb des Bildschirms"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_DE "Dunkle Filterstufe (%)"
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_DE "Helligkeitsreduzierung auf Helligkeitsbasis aktivieren. Kann verwendet werden, um Blenden/Augenbelastung zu vermeiden, wenn Spiele mit weißem Hintergrund gespielt werden, die für die Anzeige auf einem nicht-hintergrundbeleuchteten Game Boy Color bestimmt sind und daher auf einem modernen Hintergrundbeleuchtungsbildschirm unbequem hell erscheinen können."
#define GAMBATTE_MIX_FRAMES_LABEL_DE "Interframe-Blending"
#define GAMBATTE_MIX_FRAMES_INFO_0_DE "Simuliert LCD-Ghosting-Effekte. 'Einfach' führt eine 50:50-Mischung aus aktuellem und vorherigen Bild durch. 'LCD-Ghosting' ahmt die natürlichen LCD-Reaktionszeiten nach, indem mehrere gepufferte Bilder kombiniert werden. 'Einfaches' Überblenden ist bei Spielen erforderlich, die LCD-Ghosting aggressiv für Transparenzeffekte ausnutzen (Wave Race, Chikyuu Kaihou Gun ZAS, F-Zero, die Boktai-Serie…)."
#define OPTION_VAL_MIX_DE "Einfach"
#define OPTION_VAL_LCD_GHOSTING_DE "LCD-Ghosting (Genau)"
#define OPTION_VAL_LCD_GHOSTING_FAST_DE "LCD-Ghosting (Schnell)"
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_DE "Audio-Resampling-Treiber"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_DE "Legt fest, welcher Algorithmus beim Resampling von generierten Audio verwendet werden soll (die Audio-Rate des Game Boy ist nur durch die CPU-Schreibgeschwindigkeit begrenzt, so dass \"native\" Frequenzen auf modernen Klanggeräten unpraktisch sind und heruntergetaktet werden müssen). 'Sinus' produziert höchste Qualität. 'Kosinus' verbessert die Leistung auf Low-End-Hardware."
#define OPTION_VAL_SINC_DE "Sinus"
#define OPTION_VAL_CC_DE "Kosinus"
#define GAMBATTE_GB_HWMODE_LABEL_DE "Emulierte Hardware (Neustart erforderlich)"
#define GAMBATTE_GB_HWMODE_INFO_0_DE "Gibt an, welche Art von Hardware emuliert werden soll. 'Automatisch' wird empfohlen. Das Auswählen von 'GBA' schaltet zusätzliche Funktionen in bestimmten 'GBA Enhanced' Game Boy Color Spielen frei (Shantae, Wendy - Every Witch Way, Legend of Zelda: Oracle of Seasons/Ages...)."
#define OPTION_VAL_GB_DE NULL
#define OPTION_VAL_GBA_DE NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_DE "Offiziellen Bootloader verwenden (Neustart erforderlich)"
#define GAMBATTE_GB_BOOTLOADER_INFO_0_DE "Aktiviert Unterstützung für offizielle Game Boy und Game Boy Color Bootloader, mit entsprechenden Einschalt-Logo-Animationen."
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_DE "Entgegengesetzte Richtungen zulassen"
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_DE "Aktivieren erlaubt es gleichzeitig, die linke und rechte (oder nach oben und unten) Richtung zu drücken/schnell zu wechseln. Dies kann zu bewegungsbasierten Aussetzern führen."
#define GAMBATTE_TURBO_PERIOD_LABEL_DE "Turbo Tasten Intervall"
#define GAMBATTE_TURBO_PERIOD_INFO_0_DE "Legt das Wiederholungsintervall (in Bildern) fest, wenn die Turbo-Tasten A/B gedrückt gehalten werden."
#define GAMBATTE_RUMBLE_LEVEL_LABEL_DE "Controller Vibrationsstärke"
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_DE "Aktiviert haptische Feedback-Effekte für unterstützte Spiele (Pokemon Pinball, Perfect Dark...)."
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_DE "Spiel-Link-Einstellungen anzeigen"
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_DE "Aktiviert die Konfiguration von vernetzten Spiele-Link (Mehrspieler-Optionen). HINWEIS: Das Schnellmenü muss eingeschaltet sein, damit diese Einstellung wirksam wird."
#define GAMBATTE_GB_LINK_MODE_LABEL_DE "Spiel-Link-Modus"
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_DE "Link-Modus"
#define GAMBATTE_GB_LINK_MODE_INFO_0_DE "Legt beim Aktivieren von vernetzten Spiel-Link-Funktionen fest, ob die aktuelle Instanz als Server oder Client ausgeführt werden soll."
#define OPTION_VAL_NOT_CONNECTED_DE "Nicht verbunden"
#define OPTION_VAL_NETWORK_SERVER_DE "Netzwerk-Server"
#define OPTION_VAL_NETWORK_CLIENT_DE "Netzwerk-Client"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_DE "Netzwerk-Linkport"
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_DE NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_DE "Den Port angeben, der für die Kommunikation mit dem Spiele-Link verwendet wird."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_DE "Netzwerk-Linkserveradresse Teil 01: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_DE "Serveradresse Teil 01: x__.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_DE "1. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_DE "1. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_DE "Netzwerk-Linkserveradresse Teil 02: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_DE "Serveradresse Teil 02: _x_.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_DE "2. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_DE "2. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_DE "Netzwerk-Linkserveradresse Teil 03: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_DE "Serveradresse Teil 03: __x.___.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_DE "4. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_DE "3. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_DE "Netzwerk-Linkserveradresse Teil 04: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_DE "Serveradresse Teil 04: ___.x__.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_DE "4. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_DE "4. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_DE "Netzwerk-Linkserveradresse Teil 05: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_DE "Serveradresse Teil 05: ___._x_.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_DE "5. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_DE "5. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_DE "Netzwerk-Linkserveradresse Teil 06: ___.__x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_DE "Serveradresse Teil 06: ___.__x.___.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_DE "6. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_DE "6. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_DE "Netzwerk-Linkserveradresse Teil 07: ___.___.x__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_DE "Serveradresse Teil 07: ___.___.x__.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_DE "7. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_DE "7. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_DE "Netzwerk-Linkserveradresse Teil 08: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_DE "Serveradresse Teil 08: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_DE "8. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_DE "8. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_DE "Netzwerk-Linkserveradresse Teil 09: ___.___.__x.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_DE "Serveradresse Teil 09: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_DE "9. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_DE "9. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_DE "Netzwerk-Linkserveradresse Teil 10: ___.___.___.x__"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_DE "Serveradresse Teil 10: ___.___._x_.___"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_DE "10. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_DE "10. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_DE "Netzwerk-Linkserveradresse Teil 11: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_DE "Serveradresse Teil 11: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_DE "11. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_DE "11. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_DE "Netzwerk-Linkserveradresse Teil 12: ___.___.___.__x"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_DE "Serveradresse Teil 12: ___.___.___._x_"
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_DE "12. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Game-Link-Modus“ auf „Netzwerkclient“ eingestellt ist."
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_DE "12. Ziffer der IP-Adresse von entferntem Game-Link-Netzwerkserver. Wird nur verwendet, wenn „Linkmodus“ auf „Netzwerkclient“ eingestellt ist."

struct retro_core_option_v2_category option_cats_de[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_DE,
      CATEGORY_GB_LINK_INFO_0_DE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_de[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_DE,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_DE,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_DE },
         { "GBC",      OPTION_VAL_GBC_DE },
         { "SGB",      OPTION_VAL_SGB_DE },
         { "internal", OPTION_VAL_INTERNAL_DE },
         { "custom",   OPTION_VAL_CUSTOM_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_DE,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_DE,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_DE },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_DE },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_DE },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_DE },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_DE },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_DE },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_DE },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_DE },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_DE },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_DE },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_DE },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_DE },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_DE },
         { "GBC - Red",                OPTION_VAL_GBC_RED_DE },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_DE },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_DE },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_DE },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_DE },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_DE },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_DE },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_DE },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_DE },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_DE },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_DE },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_DE },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_DE },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_DE },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_DE },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_DE },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_DE },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_DE },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_DE },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_DE },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_DE },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_DE },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_DE },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_DE },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_DE },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_DE },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_DE },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_DE },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_DE },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_DE },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_DE },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_DE },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_DE },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_DE },
         { "Special 1",                OPTION_VAL_SPECIAL_1_DE },
         { "Special 2",                OPTION_VAL_SPECIAL_2_DE },
         { "Special 3",                OPTION_VAL_SPECIAL_3_DE },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_DE },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_DE },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_DE },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_DE },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_DE },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_DE,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_DE,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_DE },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_DE },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_DE },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_DE },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_DE },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_DE },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_DE },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_DE },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_DE },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_DE },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_DE },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_DE },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_DE },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_DE },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_DE },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_DE },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_DE },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_DE },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_DE },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_DE },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_DE },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_DE },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_DE },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_DE },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_DE },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_DE },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_DE },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_DE },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_DE },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_DE },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_DE },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_DE },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_DE },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_DE },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_DE },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_DE },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_DE },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_DE },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_DE },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_DE },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_DE },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_DE },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_DE },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_DE },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_DE },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_DE },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_DE },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_DE },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_DE },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_DE },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_DE },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_DE },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_DE },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_DE },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_DE },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_DE },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_DE },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_DE },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_DE },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_DE },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_DE },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_DE },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_DE },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_DE },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_DE },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_DE },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_DE },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_DE },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_DE },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_DE },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_DE },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_DE },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_DE },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_DE },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_DE },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_DE },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_DE },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_DE },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_DE },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_DE },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_DE },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_DE },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_DE },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_DE },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_DE },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_DE },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_DE },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_DE },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_DE },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_DE },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_DE },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_DE },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_DE },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_DE },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_DE },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_DE },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_DE },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_DE },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_DE },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_DE },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_DE,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_DE,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_DE },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_DE },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_DE },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_DE },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_DE },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_DE },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_DE },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_DE },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_DE },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_DE },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_DE },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_DE },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_DE },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_DE },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_DE },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_DE },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_DE },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_DE },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_DE },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_DE },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_DE },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_DE },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_DE },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_DE },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_DE },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_DE },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_DE },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_DE },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_DE },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_DE },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_DE },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_DE },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_DE },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_DE },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_DE },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_DE },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_DE },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_DE },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_DE },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_DE },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_DE },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_DE },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_DE },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_DE },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_DE },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_DE },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_DE },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_DE },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_DE },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_DE },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_DE },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_DE },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_DE },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_DE },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_DE },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_DE },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_DE },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_DE },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_DE },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_DE },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_DE },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_DE },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_DE },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_DE },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_DE },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_DE },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_DE },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_DE },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_DE },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_DE },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_DE },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_DE },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_DE },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_DE },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_DE },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_DE },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_DE },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_DE },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_DE },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_DE },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_DE },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_DE },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_DE },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_DE },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_DE },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_DE },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_DE },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_DE },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_DE },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_DE },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_DE },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_DE },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_DE },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_DE },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_DE },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_DE },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_DE },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_DE },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_DE },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_DE },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_DE,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_DE,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_DE },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_DE },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_DE },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_DE },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_DE },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_DE },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_DE },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_DE },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_DE },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_DE },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_DE },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_DE },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_DE },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_DE },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_DE },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_DE },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_DE },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_DE },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_DE },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_DE },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_DE },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_DE },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_DE },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_DE },
         { "TWB64 225 - WarioWare MicroBlue",       OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_DE },
         { "TWB64 226 - KonoSuba Sherbet",          OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_DE },
         { "TWB64 227 - Spooky Purple",             OPTION_VAL_TWB64_227_SPOOKY_PURPLE_DE },
         { "TWB64 228 - Treasure Gold",             OPTION_VAL_TWB64_228_TREASURE_GOLD_DE },
         { "TWB64 229 - Cherry Blossom Pink",       OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_DE },
         { "TWB64 230 - Golden Trophy",             OPTION_VAL_TWB64_230_GOLDEN_TROPHY_DE },
         { "TWB64 231 - Glacial Winter Blue",       OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_DE },
         { "TWB64 232 - Leprechaun Green",          OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_DE },
         { "TWB64 233 - SAITAMA SUPER BLUE",        OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_DE },
         { "TWB64 234 - SAITAMA SUPER GREEN",       OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_DE },
         { "TWB64 235 - Duolingo Green",            OPTION_VAL_TWB64_235_DUOLINGO_GREEN_DE },
         { "TWB64 236 - Super Mushroom Vision",     OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_DE },
         { "TWB64 237 - Ancient Hisuian Brown",     OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_DE },
         { "TWB64 238 - Sky Pop Ivory",             OPTION_VAL_TWB64_238_SKY_POP_IVORY_DE },
         { "TWB64 239 - LAWSON BLUE",               OPTION_VAL_TWB64_239_LAWSON_BLUE_DE },
         { "TWB64 240 - Anime Expo Red",            OPTION_VAL_TWB64_240_ANIME_EXPO_RED_DE },
         { "TWB64 241 - Brilliant Diamond Blue",    OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_DE },
         { "TWB64 242 - Shining Pearl Pink",        OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_DE },
         { "TWB64 243 - Funimation Melon",          OPTION_VAL_TWB64_243_FUNIMATION_MELON_DE },
         { "TWB64 244 - Teyvat Brown",              OPTION_VAL_TWB64_244_TEYVAT_BROWN_DE },
         { "TWB64 245 - Chozo Blue",                OPTION_VAL_TWB64_245_CHOZO_BLUE_DE },
         { "TWB64 246 - Spotify Green",             OPTION_VAL_TWB64_246_SPOTIFY_GREEN_DE },
         { "TWB64 247 - Dr Pepper Red",             OPTION_VAL_TWB64_247_DR_PEPPER_RED_DE },
         { "TWB64 248 - NHK Silver Gray",           OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_DE },
         { "TWB64 249 - Dunkin' Vision",            OPTION_VAL_TWB64_249_DUNKIN_VISION_DE },
         { "TWB64 250 - Deku Gamma Palette",        OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_DE },
         { "TWB64 251 - Universal Studios Blue",    OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_DE },
         { "TWB64 252 - Hogwarts Goldius",          OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_DE },
         { "TWB64 253 - Kentucky Fried Red",        OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_DE },
         { "TWB64 254 - Cheeto Orange",             OPTION_VAL_TWB64_254_CHEETO_ORANGE_DE },
         { "TWB64 255 - Namco Idol Pink",           OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_DE },
         { "TWB64 256 - Domino's Pizza Vision",     OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_DE },
         { "TWB64 257 - Pac-Man Vision",            OPTION_VAL_TWB64_257_PAC_MAN_VISION_DE },
         { "TWB64 258 - Bill's PC Screen",          OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_DE },
         { "TWB64 259 - Sonic Mega Blue",           OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_DE },
         { "TWB64 260 - Fool's Gold and Silver",    OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_DE },
         { "TWB64 261 - UTA VISION",                OPTION_VAL_TWB64_261_UTA_VISION_DE },
         { "TWB64 262 - Metallic Paldea Brass",     OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_DE },
         { "TWB64 263 - Classy Christmas",          OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_DE },
         { "TWB64 264 - Winter Christmas",          OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_DE },
         { "TWB64 265 - IDOL WORLD TRICOLOR!!!",    OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_DE },
         { "TWB64 266 - Inkling Tricolor",          OPTION_VAL_TWB64_266_INKLING_TRICOLOR_DE },
         { "TWB64 267 - 7-Eleven Color Combo",      OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_DE },
         { "TWB64 268 - PAC-PALETTE",               OPTION_VAL_TWB64_268_PAC_PALETTE_DE },
         { "TWB64 269 - Vulnerable Blue",           OPTION_VAL_TWB64_269_VULNERABLE_BLUE_DE },
         { "TWB64 270 - Nightvision Green",         OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_DE },
         { "TWB64 271 - Bandai Namco Tricolor",     OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_DE },
         { "TWB64 272 - Gold, Silver, and Bronze",  OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_DE },
         { "TWB64 273 - Deku Vigilante Palette",    OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_DE },
         { "TWB64 274 - Super Famicom Supreme",     OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_DE },
         { "TWB64 275 - Absorbent and Yellow",      OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_DE },
         { "TWB64 276 - 765PRO TRICOLOR",           OPTION_VAL_TWB64_276_765PRO_TRICOLOR_DE },
         { "TWB64 277 - GameCube Glimmer",          OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_DE },
         { "TWB64 278 - 1st Vision Pastel",         OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_DE },
         { "TWB64 279 - Perfect Majin Emperor",     OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_DE },
         { "TWB64 280 - J-Pop Idol Sherbet",        OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_DE },
         { "TWB64 281 - Ryuuguu Sunset",            OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_DE },
         { "TWB64 282 - Tropical Starfall",         OPTION_VAL_TWB64_282_TROPICAL_STARFALL_DE },
         { "TWB64 283 - Colorful Horizons",         OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_DE },
         { "TWB64 284 - BLACKPINK BLINK PINK",      OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_DE },
         { "TWB64 285 - DMG-SWITCH",                OPTION_VAL_TWB64_285_DMG_SWITCH_DE },
         { "TWB64 286 - POCKET SWITCH",             OPTION_VAL_TWB64_286_POCKET_SWITCH_DE },
         { "TWB64 287 - Sunny Passion Paradise",    OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_DE },
         { "TWB64 288 - Saiyan Beast Silver",       OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_DE },
         { "TWB64 289 - RADIANT SMILE RAMP",        OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_DE },
         { "TWB64 290 - A-RISE BLUE",               OPTION_VAL_TWB64_290_A_RISE_BLUE_DE },
         { "TWB64 291 - TROPICAL TWICE APRICOT",    OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_DE },
         { "TWB64 292 - Odyssey Boy",               OPTION_VAL_TWB64_292_ODYSSEY_BOY_DE },
         { "TWB64 293 - Frog Coin Green",           OPTION_VAL_TWB64_293_FROG_COIN_GREEN_DE },
         { "TWB64 294 - Garfield Vision",           OPTION_VAL_TWB64_294_GARFIELD_VISION_DE },
         { "TWB64 295 - Bedrock Caveman Vision",    OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_DE },
         { "TWB64 296 - BANGTAN ARMY PURPLE",       OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_DE },
         { "TWB64 297 - LE SSERAFIM FEARLESS BLUE", OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_DE },
         { "TWB64 298 - Baja Blast Beach",          OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_DE },
         { "TWB64 299 - 3DS Virtual Console Green", OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_DE },
         { "TWB64 300 - Wonder Purple",             OPTION_VAL_TWB64_300_WONDER_PURPLE_DE },
         { NULL, NULL },
      },
      "TWB64 201 - DMG-GOLD"
   },
   {
      "gambatte_gb_palette_pixelshift_1",
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_DE,
      NULL,
      GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_DE,
      NULL,
      NULL,
      {
         { "PixelShift 01 - Arctic Green",               OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_DE },
         { "PixelShift 02 - Arduboy",                    OPTION_VAL_PIXELSHIFT_02_ARDUBOY_DE },
         { "PixelShift 03 - BGB 0.3 Emulator",           OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_DE },
         { "PixelShift 04 - Camouflage",                 OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_DE },
         { "PixelShift 05 - Chocolate Bar",              OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_DE },
         { "PixelShift 06 - CMYK",                       OPTION_VAL_PIXELSHIFT_06_CMYK_DE },
         { "PixelShift 07 - Cotton Candy",               OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_DE },
         { "PixelShift 08 - Easy Greens",                OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_DE },
         { "PixelShift 09 - Gamate",                     OPTION_VAL_PIXELSHIFT_09_GAMATE_DE },
         { "PixelShift 10 - Game Boy Light",             OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_DE },
         { "PixelShift 11 - Game Boy Pocket",            OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_DE },
         { "PixelShift 12 - Game Boy Pocket Alt",        OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_DE },
         { "PixelShift 13 - Game Pocket Computer",       OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_DE },
         { "PixelShift 14 - Game & Watch Ball",          OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_DE },
         { "PixelShift 15 - GB Backlight Blue",          OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_DE },
         { "PixelShift 16 - GB Backlight Faded",         OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_DE },
         { "PixelShift 17 - GB Backlight Orange",        OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_DE },
         { "PixelShift 18 - GB Backlight White ",        OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__DE },
         { "PixelShift 19 - GB Backlight Yellow Dark",   OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_DE },
         { "PixelShift 20 - GB Bootleg",                 OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_DE },
         { "PixelShift 21 - GB Hunter",                  OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_DE },
         { "PixelShift 22 - GB Kiosk",                   OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_DE },
         { "PixelShift 23 - GB Kiosk 2",                 OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_DE },
         { "PixelShift 24 - GB New",                     OPTION_VAL_PIXELSHIFT_24_GB_NEW_DE },
         { "PixelShift 25 - GB Nuked",                   OPTION_VAL_PIXELSHIFT_25_GB_NUKED_DE },
         { "PixelShift 26 - GB Old",                     OPTION_VAL_PIXELSHIFT_26_GB_OLD_DE },
         { "PixelShift 27 - GBP Bivert",                 OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_DE },
         { "PixelShift 28 - GB Washed Yellow Backlight", OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_DE },
         { "PixelShift 29 - Ghost",                      OPTION_VAL_PIXELSHIFT_29_GHOST_DE },
         { "PixelShift 30 - Glow In The Dark",           OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_DE },
         { "PixelShift 31 - Gold Bar",                   OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_DE },
         { "PixelShift 32 - Grapefruit",                 OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_DE },
         { "PixelShift 33 - Gray Green Mix",             OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_DE },
         { "PixelShift 34 - Missingno",                  OPTION_VAL_PIXELSHIFT_34_MISSINGNO_DE },
         { "PixelShift 35 - MS-Dos",                     OPTION_VAL_PIXELSHIFT_35_MS_DOS_DE },
         { "PixelShift 36 - Newspaper",                  OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_DE },
         { "PixelShift 37 - Pip-Boy",                    OPTION_VAL_PIXELSHIFT_37_PIP_BOY_DE },
         { "PixelShift 38 - Pocket Girl",                OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_DE },
         { "PixelShift 39 - Silhouette",                 OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_DE },
         { "PixelShift 40 - Sunburst",                   OPTION_VAL_PIXELSHIFT_40_SUNBURST_DE },
         { "PixelShift 41 - Technicolor",                OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_DE },
         { "PixelShift 42 - Tron",                       OPTION_VAL_PIXELSHIFT_42_TRON_DE },
         { "PixelShift 43 - Vaporwave",                  OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_DE },
         { "PixelShift 44 - Virtual Boy",                OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_DE },
         { "PixelShift 45 - Wish",                       OPTION_VAL_PIXELSHIFT_45_WISH_DE },
         { NULL, NULL },
      },
      "PixelShift 01 - Arctic Green"
   },
   {
      "gambatte_gbc_color_correction",
      GAMBATTE_GBC_COLOR_CORRECTION_LABEL_DE,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_DE,
      NULL,
      NULL,
      {
         { "GBC only", OPTION_VAL_GBC_ONLY_DE },
         { "always",   OPTION_VAL_ALWAYS_DE },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "GBC only"
   },
   {
      "gambatte_gbc_color_correction_mode",
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_DE,
      NULL,
      GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_DE,
      NULL,
      NULL,
      {
         { "accurate", OPTION_VAL_ACCURATE_DE },
         { "fast",     OPTION_VAL_FAST_DE },
         { NULL, NULL },
      },
      "accurate"
   },
   {
      "gambatte_gbc_frontlight_position",
      GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_DE,
      NULL,
      GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_DE,
      NULL,
      NULL,
      {
         { "central",      OPTION_VAL_CENTRAL_DE },
         { "above screen", OPTION_VAL_ABOVE_SCREEN_DE },
         { "below screen", OPTION_VAL_BELOW_SCREEN_DE },
         { NULL, NULL },
      },
      "central"
   },
   {
      "gambatte_dark_filter_level",
      GAMBATTE_DARK_FILTER_LEVEL_LABEL_DE,
      NULL,
      GAMBATTE_DARK_FILTER_LEVEL_INFO_0_DE,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_mix_frames",
      GAMBATTE_MIX_FRAMES_LABEL_DE,
      NULL,
      GAMBATTE_MIX_FRAMES_INFO_0_DE,
      NULL,
      NULL,
      {
         { "disabled",          NULL },
         { "mix",               OPTION_VAL_MIX_DE },
         { "lcd_ghosting",      OPTION_VAL_LCD_GHOSTING_DE },
         { "lcd_ghosting_fast", OPTION_VAL_LCD_GHOSTING_FAST_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_audio_resampler",
      GAMBATTE_AUDIO_RESAMPLER_LABEL_DE,
      NULL,
      GAMBATTE_AUDIO_RESAMPLER_INFO_0_DE,
      NULL,
      NULL,
      {
         { "sinc", OPTION_VAL_SINC_DE },
         { "cc",   OPTION_VAL_CC_DE },
         { NULL, NULL },
      },
#if (defined(PS2) || defined(PSP) || defined(VITA) || defined(_3DS) || defined(DINGUX))
      "cc"
#else
      "sinc"
#endif
   },
   {
      "gambatte_gb_hwmode",
      GAMBATTE_GB_HWMODE_LABEL_DE,
      NULL,
      GAMBATTE_GB_HWMODE_INFO_0_DE,
      NULL,
      NULL,
      {
         { "Auto", OPTION_VAL_AUTO_DE },
         { "GB",   OPTION_VAL_GB_DE },
         { "GBC",  OPTION_VAL_GBC_DE },
         { "GBA",  OPTION_VAL_GBA_DE },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "gambatte_gb_bootloader",
      GAMBATTE_GB_BOOTLOADER_LABEL_DE,
      NULL,
      GAMBATTE_GB_BOOTLOADER_INFO_0_DE,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "gambatte_up_down_allowed",
      GAMBATTE_UP_DOWN_ALLOWED_LABEL_DE,
      NULL,
      GAMBATTE_UP_DOWN_ALLOWED_INFO_0_DE,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_turbo_period",
      GAMBATTE_TURBO_PERIOD_LABEL_DE,
      NULL,
      GAMBATTE_TURBO_PERIOD_INFO_0_DE,
      NULL,
      NULL,
      {
         { "4",   NULL },
         { "5",   NULL },
         { "6",   NULL },
         { "7",   NULL },
         { "8",   NULL },
         { "9",   NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { "64",  NULL },
         { "65",  NULL },
         { "66",  NULL },
         { "67",  NULL },
         { "68",  NULL },
         { "69",  NULL },
         { "70",  NULL },
         { "71",  NULL },
         { "72",  NULL },
         { "73",  NULL },
         { "74",  NULL },
         { "75",  NULL },
         { "76",  NULL },
         { "77",  NULL },
         { "78",  NULL },
         { "79",  NULL },
         { "80",  NULL },
         { "81",  NULL },
         { "82",  NULL },
         { "83",  NULL },
         { "84",  NULL },
         { "85",  NULL },
         { "86",  NULL },
         { "87",  NULL },
         { "88",  NULL },
         { "89",  NULL },
         { "90",  NULL },
         { "91",  NULL },
         { "92",  NULL },
         { "93",  NULL },
         { "94",  NULL },
         { "95",  NULL },
         { "96",  NULL },
         { "97",  NULL },
         { "98",  NULL },
         { "99",  NULL },
         { "100", NULL },
         { "101", NULL },
         { "102", NULL },
         { "103", NULL },
         { "104", NULL },
         { "105", NULL },
         { "106", NULL },
         { "107", NULL },
         { "108", NULL },
         { "109", NULL },
         { "110", NULL },
         { "111", NULL },
         { "112", NULL },
         { "113", NULL },
         { "114", NULL },
         { "115", NULL },
         { "116", NULL },
         { "117", NULL },
         { "118", NULL },
         { "119", NULL },
         { "120", NULL },
         { NULL, NULL },
      },
      "4"
   },
   {
      "gambatte_rumble_level",
      GAMBATTE_RUMBLE_LEVEL_LABEL_DE,
      NULL,
      GAMBATTE_RUMBLE_LEVEL_INFO_0_DE,
      NULL,
      NULL,
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { NULL, NULL },
      },
      "10"
   },
#ifdef HAVE_NETWORK
   {
      "gambatte_show_gb_link_settings",
      GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_DE,
      NULL,
      GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_DE,
      NULL,
      NULL,
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_link_mode",
      GAMBATTE_GB_LINK_MODE_LABEL_DE,
      GAMBATTE_GB_LINK_MODE_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_MODE_INFO_0_DE,
      NULL,
      "gb_link",
      {
         { "Not Connected",  OPTION_VAL_NOT_CONNECTED_DE },
         { "Network Server", OPTION_VAL_NETWORK_SERVER_DE },
         { "Network Client", OPTION_VAL_NETWORK_CLIENT_DE },
         { NULL, NULL },
      },
      "Not Connected"
   },
   {
      "gambatte_gb_link_network_port",
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_DE,
      NULL,
      "gb_link",
      {
         { "56400", NULL },
         { "56401", NULL },
         { "56402", NULL },
         { "56403", NULL },
         { "56404", NULL },
         { "56405", NULL },
         { "56406", NULL },
         { "56407", NULL },
         { "56408", NULL },
         { "56409", NULL },
         { "56410", NULL },
         { "56411", NULL },
         { "56412", NULL },
         { "56413", NULL },
         { "56414", NULL },
         { "56415", NULL },
         { "56416", NULL },
         { "56417", NULL },
         { "56418", NULL },
         { "56419", NULL },
         { "56420", NULL },
         { NULL, NULL },
      },
      "56400"
   },
   {
      "gambatte_gb_link_network_server_ip_1",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_2",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_3",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_4",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_5",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_6",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_7",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_8",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_9",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_10",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_11",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      "gambatte_gb_link_network_server_ip_12",
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_DE,
      GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_DE,
      "gb_link",
      {
         { "0", NULL },
         { "1", NULL },
         { "2", NULL },
         { "3", NULL },
         { "4", NULL },
         { "5", NULL },
         { "6", NULL },
         { "7", NULL },
         { "8", NULL },
         { "9", NULL },
         { NULL, NULL },
      },
      "0"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_de = {
   option_cats_de,
   option_defs_de
};

/* RETRO_LANGUAGE_EL */

#define CATEGORY_GB_LINK_LABEL_EL NULL
#define CATEGORY_GB_LINK_INFO_0_EL NULL
#define GAMBATTE_GB_COLORIZATION_LABEL_EL "Χρωματισμός GB"
#define GAMBATTE_GB_COLORIZATION_INFO_0_EL NULL
#define OPTION_VAL_AUTO_EL "Αυτόματο"
#define OPTION_VAL_GBC_EL NULL
#define OPTION_VAL_SGB_EL NULL
#define OPTION_VAL_INTERNAL_EL NULL
#define OPTION_VAL_CUSTOM_EL NULL
#define GAMBATTE_GB_INTERNAL_PALETTE_LABEL_EL "Εσωτερική Παλέτα"
#define GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_EL NULL
#define OPTION_VAL_GB_DMG_EL NULL
#define OPTION_VAL_GB_POCKET_EL NULL
#define OPTION_VAL_GB_LIGHT_EL NULL
#define OPTION_VAL_GBC_BLUE_EL "GBC - Μπλε"
#define OPTION_VAL_GBC_BROWN_EL "GBC - Καφέ"
#define OPTION_VAL_GBC_DARK_BLUE_EL "GBC - Σκούρο Μπλε"
#define OPTION_VAL_GBC_DARK_BROWN_EL "GBC - Σκούρο Καφέ"
#define OPTION_VAL_GBC_DARK_GREEN_EL "GBC - Σκούρο Πράσινο"
#define OPTION_VAL_GBC_GRAYSCALE_EL NULL
#define OPTION_VAL_GBC_GREEN_EL "GBC - Πράσινο"
#define OPTION_VAL_GBC_INVERTED_EL NULL
#define OPTION_VAL_GBC_ORANGE_EL "GBC - Πορτοκαλί"
#define OPTION_VAL_GBC_PASTEL_MIX_EL NULL
#define OPTION_VAL_GBC_RED_EL "GBC - Κόκκινο"
#define OPTION_VAL_GBC_YELLOW_EL "GBC - Κίτρινο"
#define OPTION_VAL_SGB_1A_EL NULL
#define OPTION_VAL_SGB_1B_EL NULL
#define OPTION_VAL_SGB_1C_EL NULL
#define OPTION_VAL_SGB_1D_EL NULL
#define OPTION_VAL_SGB_1E_EL NULL
#define OPTION_VAL_SGB_1F_EL NULL
#define OPTION_VAL_SGB_1G_EL NULL
#define OPTION_VAL_SGB_1H_EL NULL
#define OPTION_VAL_SGB_2A_EL NULL
#define OPTION_VAL_SGB_2B_EL NULL
#define OPTION_VAL_SGB_2C_EL NULL
#define OPTION_VAL_SGB_2D_EL NULL
#define OPTION_VAL_SGB_2E_EL NULL
#define OPTION_VAL_SGB_2F_EL NULL
#define OPTION_VAL_SGB_2G_EL NULL
#define OPTION_VAL_SGB_2H_EL NULL
#define OPTION_VAL_SGB_3A_EL NULL
#define OPTION_VAL_SGB_3B_EL NULL
#define OPTION_VAL_SGB_3C_EL NULL
#define OPTION_VAL_SGB_3D_EL NULL
#define OPTION_VAL_SGB_3E_EL NULL
#define OPTION_VAL_SGB_3F_EL NULL
#define OPTION_VAL_SGB_3G_EL NULL
#define OPTION_VAL_SGB_3H_EL NULL
#define OPTION_VAL_SGB_4A_EL NULL
#define OPTION_VAL_SGB_4B_EL NULL
#define OPTION_VAL_SGB_4C_EL NULL
#define OPTION_VAL_SGB_4D_EL NULL
#define OPTION_VAL_SGB_4E_EL NULL
#define OPTION_VAL_SGB_4F_EL NULL
#define OPTION_VAL_SGB_4G_EL NULL
#define OPTION_VAL_SGB_4H_EL NULL
#define OPTION_VAL_SPECIAL_1_EL NULL
#define OPTION_VAL_SPECIAL_2_EL NULL
#define OPTION_VAL_SPECIAL_3_EL NULL
#define OPTION_VAL_SPECIAL_4_TI_83_LEGACY_EL NULL
#define OPTION_VAL_TWB64_PACK_1_EL NULL
#define OPTION_VAL_TWB64_PACK_2_EL NULL
#define OPTION_VAL_TWB64_PACK_3_EL NULL
#define OPTION_VAL_PIXELSHIFT_PACK_1_EL NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_LABEL_EL NULL
#define GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_EL NULL
#define OPTION_VAL_TWB64_001_AQOURS_BLUE_EL NULL
#define OPTION_VAL_TWB64_002_ANIME_EXPO_VER_EL NULL
#define OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_EL NULL
#define OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_EL NULL
#define OPTION_VAL_TWB64_005_NEON_RED_EL NULL
#define OPTION_VAL_TWB64_006_NEON_BLUE_EL NULL
#define OPTION_VAL_TWB64_007_NEON_YELLOW_EL NULL
#define OPTION_VAL_TWB64_008_NEON_GREEN_EL NULL
#define OPTION_VAL_TWB64_009_NEON_PINK_EL NULL
#define OPTION_VAL_TWB64_010_MARIO_RED_EL NULL
#define OPTION_VAL_TWB64_011_NICK_ORANGE_EL NULL
#define OPTION_VAL_TWB64_012_VIRTUAL_VISION_EL NULL
#define OPTION_VAL_TWB64_013_GOLDEN_WILD_EL NULL
#define OPTION_VAL_TWB64_014_DMG_099_EL NULL
#define OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_EL NULL
#define OPTION_VAL_TWB64_016_765_PRODUCTION_VER_EL NULL
#define OPTION_VAL_TWB64_017_SUPERBALL_IVORY_EL NULL
#define OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_EL NULL
#define OPTION_VAL_TWB64_019_MUSE_PINK_EL NULL
#define OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_EL NULL
#define OPTION_VAL_TWB64_021_GAMATE_VER_EL NULL
#define OPTION_VAL_TWB64_022_GREENSCALE_VER_EL NULL
#define OPTION_VAL_TWB64_023_ODYSSEY_GOLD_EL NULL
#define OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_EL NULL
#define OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_EL NULL
#define OPTION_VAL_TWB64_026_ANIMAX_BLUE_EL NULL
#define OPTION_VAL_TWB64_027_BMO_VER_EL NULL
#define OPTION_VAL_TWB64_028_GAME_COM_VER_EL NULL
#define OPTION_VAL_TWB64_029_SANRIO_PINK_EL NULL
#define OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_EL NULL
#define OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_EL NULL
#define OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_EL NULL
#define OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_EL NULL
#define OPTION_VAL_TWB64_034_TRAVEL_WOOD_EL NULL
#define OPTION_VAL_TWB64_035_POKEMON_VER_EL NULL
#define OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_EL NULL
#define OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_EL NULL
#define OPTION_VAL_TWB64_038_POKEMON_MINI_VER_EL NULL
#define OPTION_VAL_TWB64_039_SUPERVISION_VER_EL NULL
#define OPTION_VAL_TWB64_040_DMG_VER_EL NULL
#define OPTION_VAL_TWB64_041_POCKET_VER_EL NULL
#define OPTION_VAL_TWB64_042_LIGHT_VER_EL NULL
#define OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_EL NULL
#define OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_EL NULL
#define OPTION_VAL_TWB64_045_PIKACHU_YELLOW_EL NULL
#define OPTION_VAL_TWB64_046_EEVEE_BROWN_EL NULL
#define OPTION_VAL_TWB64_047_MICROVISION_VER_EL NULL
#define OPTION_VAL_TWB64_048_TI_83_VER_EL NULL
#define OPTION_VAL_TWB64_049_AEGIS_CHERRY_EL NULL
#define OPTION_VAL_TWB64_050_LABO_FAWN_EL NULL
#define OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_EL NULL
#define OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_EL NULL
#define OPTION_VAL_TWB64_053_VMU_VER_EL NULL
#define OPTION_VAL_TWB64_054_GAME_MASTER_VER_EL NULL
#define OPTION_VAL_TWB64_055_ANDROID_GREEN_EL NULL
#define OPTION_VAL_TWB64_056_AMAZON_VISION_EL NULL
#define OPTION_VAL_TWB64_057_GOOGLE_RED_EL NULL
#define OPTION_VAL_TWB64_058_GOOGLE_BLUE_EL NULL
#define OPTION_VAL_TWB64_059_GOOGLE_YELLOW_EL NULL
#define OPTION_VAL_TWB64_060_GOOGLE_GREEN_EL NULL
#define OPTION_VAL_TWB64_061_WONDERSWAN_VER_EL NULL
#define OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_EL NULL
#define OPTION_VAL_TWB64_063_DEW_GREEN_EL NULL
#define OPTION_VAL_TWB64_064_COCA_COLA_VISION_EL NULL
#define OPTION_VAL_TWB64_065_GAMEKING_VER_EL NULL
#define OPTION_VAL_TWB64_066_DO_THE_DEW_VER_EL NULL
#define OPTION_VAL_TWB64_067_DIGIVICE_VER_EL NULL
#define OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_EL NULL
#define OPTION_VAL_TWB64_069_BLOSSOM_PINK_EL NULL
#define OPTION_VAL_TWB64_070_BUBBLES_BLUE_EL NULL
#define OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_EL NULL
#define OPTION_VAL_TWB64_072_NASCAR_VER_EL NULL
#define OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_EL NULL
#define OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_EL NULL
#define OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_EL NULL
#define OPTION_VAL_TWB64_076_PHANTOM_RED_EL NULL
#define OPTION_VAL_TWB64_077_HALLOWEEN_VER_EL NULL
#define OPTION_VAL_TWB64_078_CHRISTMAS_VER_EL NULL
#define OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_EL NULL
#define OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_EL NULL
#define OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_EL NULL
#define OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_EL NULL
#define OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_EL NULL
#define OPTION_VAL_TWB64_084_SUPER_SAIYAN_EL NULL
#define OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_EL NULL
#define OPTION_VAL_TWB64_086_SAINT_SNOW_RED_EL NULL
#define OPTION_VAL_TWB64_087_YELLOW_BANANA_EL NULL
#define OPTION_VAL_TWB64_088_GREEN_BANANA_EL NULL
#define OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_EL NULL
#define OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_EL NULL
#define OPTION_VAL_TWB64_091_POCKET_TALES_VER_EL NULL
#define OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_EL NULL
#define OPTION_VAL_TWB64_093_S_E_E_S_BLUE_EL NULL
#define OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_EL NULL
#define OPTION_VAL_TWB64_095_HOKAGE_ORANGE_EL NULL
#define OPTION_VAL_TWB64_096_STRAW_HAT_RED_EL NULL
#define OPTION_VAL_TWB64_097_SWORD_ART_CYAN_EL NULL
#define OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_EL NULL
#define OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_EL NULL
#define OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_EL NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_LABEL_EL NULL
#define GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_EL NULL
#define OPTION_VAL_TWB64_101_765PRO_PINK_EL NULL
#define OPTION_VAL_TWB64_102_CINDERELLA_BLUE_EL NULL
#define OPTION_VAL_TWB64_103_MILLION_YELLOW_EL NULL
#define OPTION_VAL_TWB64_104_SIDEM_GREEN_EL NULL
#define OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_EL NULL
#define OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_EL NULL
#define OPTION_VAL_TWB64_107_NBA_VISION_EL NULL
#define OPTION_VAL_TWB64_108_NFL_VISION_EL NULL
#define OPTION_VAL_TWB64_109_MLB_VISION_EL NULL
#define OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_EL NULL
#define OPTION_VAL_TWB64_111_AQUATIC_IRO_EL NULL
#define OPTION_VAL_TWB64_112_TEA_MIDORI_EL NULL
#define OPTION_VAL_TWB64_113_SAKURA_PINK_EL NULL
#define OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_EL NULL
#define OPTION_VAL_TWB64_115_ONI_AKA_EL NULL
#define OPTION_VAL_TWB64_116_GOLDEN_KIIRO_EL NULL
#define OPTION_VAL_TWB64_117_SILVER_SHIRO_EL NULL
#define OPTION_VAL_TWB64_118_FRUITY_ORANGE_EL NULL
#define OPTION_VAL_TWB64_119_AKB48_PINK_EL NULL
#define OPTION_VAL_TWB64_120_MIKU_BLUE_EL NULL
#define OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_EL NULL
#define OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_EL NULL
#define OPTION_VAL_TWB64_123_ISLAND_GREEN_EL NULL
#define OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_EL NULL
#define OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_EL NULL
#define OPTION_VAL_TWB64_126_SLIME_BLUE_EL NULL
#define OPTION_VAL_TWB64_127_LIME_MIDORI_EL NULL
#define OPTION_VAL_TWB64_128_GHOSTLY_AOI_EL NULL
#define OPTION_VAL_TWB64_129_RETRO_BOGEDA_EL NULL
#define OPTION_VAL_TWB64_130_ROYAL_BLUE_EL NULL
#define OPTION_VAL_TWB64_131_NEON_PURPLE_EL NULL
#define OPTION_VAL_TWB64_132_NEON_ORANGE_EL NULL
#define OPTION_VAL_TWB64_133_MOONLIGHT_VISION_EL NULL
#define OPTION_VAL_TWB64_134_RISING_SUN_RED_EL NULL
#define OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_EL NULL
#define OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_EL NULL
#define OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_EL NULL
#define OPTION_VAL_TWB64_138_IRISH_GREEN_EL NULL
#define OPTION_VAL_TWB64_139_GOKU_GI_EL NULL
#define OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_EL NULL
#define OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_EL NULL
#define OPTION_VAL_TWB64_142_PEPSI_VISION_EL NULL
#define OPTION_VAL_TWB64_143_BUBBLUN_GREEN_EL NULL
#define OPTION_VAL_TWB64_144_BOBBLUN_BLUE_EL NULL
#define OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_EL NULL
#define OPTION_VAL_TWB64_146_OLYMPIC_GOLD_EL NULL
#define OPTION_VAL_TWB64_147_LISANI_ORANGE_EL NULL
#define OPTION_VAL_TWB64_148_LIELLA_PURPLE_EL NULL
#define OPTION_VAL_TWB64_149_OLYMPIC_SILVER_EL NULL
#define OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_EL NULL
#define OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_EL NULL
#define OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_EL NULL
#define OPTION_VAL_TWB64_153_HOLOBLUE_EL NULL
#define OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_EL NULL
#define OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_EL NULL
#define OPTION_VAL_TWB64_156_POKEDEX_RED_EL NULL
#define OPTION_VAL_TWB64_157_FAMILYMART_VISION_EL NULL
#define OPTION_VAL_TWB64_158_XBOX_GREEN_EL NULL
#define OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_EL NULL
#define OPTION_VAL_TWB64_160_SPRITE_GREEN_EL NULL
#define OPTION_VAL_TWB64_161_SCARLETT_GREEN_EL NULL
#define OPTION_VAL_TWB64_162_GLITCHY_BLUE_EL NULL
#define OPTION_VAL_TWB64_163_CLASSIC_LCD_EL NULL
#define OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_EL NULL
#define OPTION_VAL_TWB64_165_POCKETSTATION_VER_EL NULL
#define OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_EL NULL
#define OPTION_VAL_TWB64_167_SMURFY_BLUE_EL NULL
#define OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_EL NULL
#define OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_EL NULL
#define OPTION_VAL_TWB64_170_SHENRON_GREEN_EL NULL
#define OPTION_VAL_TWB64_171_BERSERK_BLOOD_EL NULL
#define OPTION_VAL_TWB64_172_SUPER_STAR_PINK_EL NULL
#define OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_EL NULL
#define OPTION_VAL_TWB64_174_BARBIE_PINK_EL NULL
#define OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_EL NULL
#define OPTION_VAL_TWB64_176_NOKIA_3310_VER_EL NULL
#define OPTION_VAL_TWB64_177_CLOVER_GREEN_EL NULL
#define OPTION_VAL_TWB64_178_GOKU_GT_GI_EL NULL
#define OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_EL NULL
#define OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_EL NULL
#define OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_EL NULL
#define OPTION_VAL_TWB64_182_PASTEL109_EL NULL
#define OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_EL NULL
#define OPTION_VAL_TWB64_184_FURY_BLUE_EL NULL
#define OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_EL NULL
#define OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_EL NULL
#define OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_EL NULL
#define OPTION_VAL_TWB64_188_PIZZA_HUT_RED_EL NULL
#define OPTION_VAL_TWB64_189_EMERALD_GREEN_EL NULL
#define OPTION_VAL_TWB64_190_GRAND_IVORY_EL NULL
#define OPTION_VAL_TWB64_191_DEMON_S_GOLD_EL NULL
#define OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_EL NULL
#define OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_EL NULL
#define OPTION_VAL_TWB64_194_DK_BARREL_BROWN_EL NULL
#define OPTION_VAL_TWB64_195_EVA_01_EL NULL
#define OPTION_VAL_TWB64_196_WILD_WEST_VISION_EL NULL
#define OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_EL NULL
#define OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_EL NULL
#define OPTION_VAL_TWB64_199_DURACELL_COPPER_EL NULL
#define OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_EL NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_LABEL_EL NULL
#define GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_EL NULL
#define OPTION_VAL_TWB64_201_DMG_GOLD_EL NULL
#define OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_EL NULL
#define OPTION_VAL_TWB64_203_FAMICOM_FRENZY_EL NULL
#define OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_EL NULL
#define OPTION_VAL_TWB64_205_ADVANCED_INDIGO_EL NULL
#define OPTION_VAL_TWB64_206_ULTRA_BLACK_EL NULL
#define OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_EL NULL
#define OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_EL NULL
#define OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_EL NULL
#define OPTION_VAL_TWB64_210_STEAM_GRAY_EL NULL
#define OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_EL NULL
#define OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_EL NULL
#define OPTION_VAL_TWB64_213_POKETCH_VER_EL NULL
#define OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_EL NULL
#define OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_EL NULL
#define OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_EL NULL
#define OPTION_VAL_TWB64_217_DMG_PEA_GREEN_EL NULL
#define OPTION_VAL_TWB64_218_TIMING_HERO_VER_EL NULL
#define OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_EL NULL
#define OPTION_VAL_TWB64_220_GRINCHY_GREEN_EL NULL
#define OPTION_VAL_TWB64_221_ANIMATE_VISION_EL NULL
#define OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_EL NULL
#define OPTION_VAL_TWB64_223_GREEN_AWAKENING_EL NULL
#define OPTION_VAL_TWB64_224_GOOMBA_BROWN_EL NULL
#define OPTION_VAL_TWB64_225_WARIOWARE_MICROBLUE_EL NULL
#define OPTION_VAL_TWB64_226_KONOSUBA_SHERBET_EL NULL
#define OPTION_VAL_TWB64_227_SPOOKY_PURPLE_EL NULL
#define OPTION_VAL_TWB64_228_TREASURE_GOLD_EL NULL
#define OPTION_VAL_TWB64_229_CHERRY_BLOSSOM_PINK_EL NULL
#define OPTION_VAL_TWB64_230_GOLDEN_TROPHY_EL NULL
#define OPTION_VAL_TWB64_231_GLACIAL_WINTER_BLUE_EL NULL
#define OPTION_VAL_TWB64_232_LEPRECHAUN_GREEN_EL NULL
#define OPTION_VAL_TWB64_233_SAITAMA_SUPER_BLUE_EL NULL
#define OPTION_VAL_TWB64_234_SAITAMA_SUPER_GREEN_EL NULL
#define OPTION_VAL_TWB64_235_DUOLINGO_GREEN_EL NULL
#define OPTION_VAL_TWB64_236_SUPER_MUSHROOM_VISION_EL NULL
#define OPTION_VAL_TWB64_237_ANCIENT_HISUIAN_BROWN_EL NULL
#define OPTION_VAL_TWB64_238_SKY_POP_IVORY_EL NULL
#define OPTION_VAL_TWB64_239_LAWSON_BLUE_EL NULL
#define OPTION_VAL_TWB64_240_ANIME_EXPO_RED_EL NULL
#define OPTION_VAL_TWB64_241_BRILLIANT_DIAMOND_BLUE_EL NULL
#define OPTION_VAL_TWB64_242_SHINING_PEARL_PINK_EL NULL
#define OPTION_VAL_TWB64_243_FUNIMATION_MELON_EL NULL
#define OPTION_VAL_TWB64_244_TEYVAT_BROWN_EL NULL
#define OPTION_VAL_TWB64_245_CHOZO_BLUE_EL NULL
#define OPTION_VAL_TWB64_246_SPOTIFY_GREEN_EL NULL
#define OPTION_VAL_TWB64_247_DR_PEPPER_RED_EL NULL
#define OPTION_VAL_TWB64_248_NHK_SILVER_GRAY_EL NULL
#define OPTION_VAL_TWB64_249_DUNKIN_VISION_EL NULL
#define OPTION_VAL_TWB64_250_DEKU_GAMMA_PALETTE_EL NULL
#define OPTION_VAL_TWB64_251_UNIVERSAL_STUDIOS_BLUE_EL NULL
#define OPTION_VAL_TWB64_252_HOGWARTS_GOLDIUS_EL NULL
#define OPTION_VAL_TWB64_253_KENTUCKY_FRIED_RED_EL NULL
#define OPTION_VAL_TWB64_254_CHEETO_ORANGE_EL NULL
#define OPTION_VAL_TWB64_255_NAMCO_IDOL_PINK_EL NULL
#define OPTION_VAL_TWB64_256_DOMINO_S_PIZZA_VISION_EL NULL
#define OPTION_VAL_TWB64_257_PAC_MAN_VISION_EL NULL
#define OPTION_VAL_TWB64_258_BILL_S_PC_SCREEN_EL NULL
#define OPTION_VAL_TWB64_259_SONIC_MEGA_BLUE_EL NULL
#define OPTION_VAL_TWB64_260_FOOL_S_GOLD_AND_SILVER_EL NULL
#define OPTION_VAL_TWB64_261_UTA_VISION_EL NULL
#define OPTION_VAL_TWB64_262_METALLIC_PALDEA_BRASS_EL NULL
#define OPTION_VAL_TWB64_263_CLASSY_CHRISTMAS_EL NULL
#define OPTION_VAL_TWB64_264_WINTER_CHRISTMAS_EL NULL
#define OPTION_VAL_TWB64_265_IDOL_WORLD_TRICOLOR_EL NULL
#define OPTION_VAL_TWB64_266_INKLING_TRICOLOR_EL NULL
#define OPTION_VAL_TWB64_267_7_ELEVEN_COLOR_COMBO_EL NULL
#define OPTION_VAL_TWB64_268_PAC_PALETTE_EL NULL
#define OPTION_VAL_TWB64_269_VULNERABLE_BLUE_EL NULL
#define OPTION_VAL_TWB64_270_NIGHTVISION_GREEN_EL NULL
#define OPTION_VAL_TWB64_271_BANDAI_NAMCO_TRICOLOR_EL NULL
#define OPTION_VAL_TWB64_272_GOLD_SILVER_AND_BRONZE_EL NULL
#define OPTION_VAL_TWB64_273_DEKU_VIGILANTE_PALETTE_EL NULL
#define OPTION_VAL_TWB64_274_SUPER_FAMICOM_SUPREME_EL NULL
#define OPTION_VAL_TWB64_275_ABSORBENT_AND_YELLOW_EL NULL
#define OPTION_VAL_TWB64_276_765PRO_TRICOLOR_EL NULL
#define OPTION_VAL_TWB64_277_GAMECUBE_GLIMMER_EL NULL
#define OPTION_VAL_TWB64_278_1ST_VISION_PASTEL_EL NULL
#define OPTION_VAL_TWB64_279_PERFECT_MAJIN_EMPEROR_EL NULL
#define OPTION_VAL_TWB64_280_J_POP_IDOL_SHERBET_EL NULL
#define OPTION_VAL_TWB64_281_RYUUGUU_SUNSET_EL NULL
#define OPTION_VAL_TWB64_282_TROPICAL_STARFALL_EL NULL
#define OPTION_VAL_TWB64_283_COLORFUL_HORIZONS_EL NULL
#define OPTION_VAL_TWB64_284_BLACKPINK_BLINK_PINK_EL NULL
#define OPTION_VAL_TWB64_285_DMG_SWITCH_EL NULL
#define OPTION_VAL_TWB64_286_POCKET_SWITCH_EL NULL
#define OPTION_VAL_TWB64_287_SUNNY_PASSION_PARADISE_EL NULL
#define OPTION_VAL_TWB64_288_SAIYAN_BEAST_SILVER_EL NULL
#define OPTION_VAL_TWB64_289_RADIANT_SMILE_RAMP_EL NULL
#define OPTION_VAL_TWB64_290_A_RISE_BLUE_EL NULL
#define OPTION_VAL_TWB64_291_TROPICAL_TWICE_APRICOT_EL NULL
#define OPTION_VAL_TWB64_292_ODYSSEY_BOY_EL NULL
#define OPTION_VAL_TWB64_293_FROG_COIN_GREEN_EL NULL
#define OPTION_VAL_TWB64_294_GARFIELD_VISION_EL NULL
#define OPTION_VAL_TWB64_295_BEDROCK_CAVEMAN_VISION_EL NULL
#define OPTION_VAL_TWB64_296_BANGTAN_ARMY_PURPLE_EL NULL
#define OPTION_VAL_TWB64_297_LE_SSERAFIM_FEARLESS_BLUE_EL NULL
#define OPTION_VAL_TWB64_298_BAJA_BLAST_BEACH_EL NULL
#define OPTION_VAL_TWB64_299_3DS_VIRTUAL_CONSOLE_GREEN_EL NULL
#define OPTION_VAL_TWB64_300_WONDER_PURPLE_EL NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_LABEL_EL NULL
#define GAMBATTE_GB_PALETTE_PIXELSHIFT_1_INFO_0_EL NULL
#define OPTION_VAL_PIXELSHIFT_01_ARCTIC_GREEN_EL NULL
#define OPTION_VAL_PIXELSHIFT_02_ARDUBOY_EL NULL
#define OPTION_VAL_PIXELSHIFT_03_BGB_0_3_EMULATOR_EL NULL
#define OPTION_VAL_PIXELSHIFT_04_CAMOUFLAGE_EL NULL
#define OPTION_VAL_PIXELSHIFT_05_CHOCOLATE_BAR_EL NULL
#define OPTION_VAL_PIXELSHIFT_06_CMYK_EL NULL
#define OPTION_VAL_PIXELSHIFT_07_COTTON_CANDY_EL NULL
#define OPTION_VAL_PIXELSHIFT_08_EASY_GREENS_EL NULL
#define OPTION_VAL_PIXELSHIFT_09_GAMATE_EL NULL
#define OPTION_VAL_PIXELSHIFT_10_GAME_BOY_LIGHT_EL NULL
#define OPTION_VAL_PIXELSHIFT_11_GAME_BOY_POCKET_EL NULL
#define OPTION_VAL_PIXELSHIFT_12_GAME_BOY_POCKET_ALT_EL NULL
#define OPTION_VAL_PIXELSHIFT_13_GAME_POCKET_COMPUTER_EL NULL
#define OPTION_VAL_PIXELSHIFT_14_GAME_WATCH_BALL_EL NULL
#define OPTION_VAL_PIXELSHIFT_15_GB_BACKLIGHT_BLUE_EL NULL
#define OPTION_VAL_PIXELSHIFT_16_GB_BACKLIGHT_FADED_EL NULL
#define OPTION_VAL_PIXELSHIFT_17_GB_BACKLIGHT_ORANGE_EL NULL
#define OPTION_VAL_PIXELSHIFT_18_GB_BACKLIGHT_WHITE__EL NULL
#define OPTION_VAL_PIXELSHIFT_19_GB_BACKLIGHT_YELLOW_DARK_EL NULL
#define OPTION_VAL_PIXELSHIFT_20_GB_BOOTLEG_EL NULL
#define OPTION_VAL_PIXELSHIFT_21_GB_HUNTER_EL NULL
#define OPTION_VAL_PIXELSHIFT_22_GB_KIOSK_EL NULL
#define OPTION_VAL_PIXELSHIFT_23_GB_KIOSK_2_EL NULL
#define OPTION_VAL_PIXELSHIFT_24_GB_NEW_EL NULL
#define OPTION_VAL_PIXELSHIFT_25_GB_NUKED_EL NULL
#define OPTION_VAL_PIXELSHIFT_26_GB_OLD_EL NULL
#define OPTION_VAL_PIXELSHIFT_27_GBP_BIVERT_EL NULL
#define OPTION_VAL_PIXELSHIFT_28_GB_WASHED_YELLOW_BACKLIGHT_EL NULL
#define OPTION_VAL_PIXELSHIFT_29_GHOST_EL NULL
#define OPTION_VAL_PIXELSHIFT_30_GLOW_IN_THE_DARK_EL NULL
#define OPTION_VAL_PIXELSHIFT_31_GOLD_BAR_EL NULL
#define OPTION_VAL_PIXELSHIFT_32_GRAPEFRUIT_EL NULL
#define OPTION_VAL_PIXELSHIFT_33_GRAY_GREEN_MIX_EL NULL
#define OPTION_VAL_PIXELSHIFT_34_MISSINGNO_EL NULL
#define OPTION_VAL_PIXELSHIFT_35_MS_DOS_EL NULL
#define OPTION_VAL_PIXELSHIFT_36_NEWSPAPER_EL NULL
#define OPTION_VAL_PIXELSHIFT_37_PIP_BOY_EL NULL
#define OPTION_VAL_PIXELSHIFT_38_POCKET_GIRL_EL NULL
#define OPTION_VAL_PIXELSHIFT_39_SILHOUETTE_EL NULL
#define OPTION_VAL_PIXELSHIFT_40_SUNBURST_EL NULL
#define OPTION_VAL_PIXELSHIFT_41_TECHNICOLOR_EL NULL
#define OPTION_VAL_PIXELSHIFT_42_TRON_EL NULL
#define OPTION_VAL_PIXELSHIFT_43_VAPORWAVE_EL NULL
#define OPTION_VAL_PIXELSHIFT_44_VIRTUAL_BOY_EL NULL
#define OPTION_VAL_PIXELSHIFT_45_WISH_EL NULL
#define GAMBATTE_GBC_COLOR_CORRECTION_LABEL_EL "Διόρθωση Χρωμάτων"
#define GAMBATTE_GBC_COLOR_CORRECTION_INFO_0_EL NULL
#define OPTION_VAL_GBC_ONLY_EL "Μόνο GBC"
#define OPTION_VAL_ALWAYS_EL "Πάντα"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_LABEL_EL "Διόρθωση Χρωμάτων"
#define GAMBATTE_GBC_COLOR_CORRECTION_MODE_INFO_0_EL NULL
#define OPTION_VAL_ACCURATE_EL "Ακριβής"
#define OPTION_VAL_FAST_EL "Γρήγορη Ταχύτητα"
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_LABEL_EL NULL
#define GAMBATTE_GBC_FRONTLIGHT_POSITION_INFO_0_EL NULL
#define OPTION_VAL_CENTRAL_EL NULL
#define OPTION_VAL_ABOVE_SCREEN_EL "Πάνω Από Την Οθόνη"
#define OPTION_VAL_BELOW_SCREEN_EL "Κάτω Από Την Οθόνη"
#define GAMBATTE_DARK_FILTER_LEVEL_LABEL_EL NULL
#define GAMBATTE_DARK_FILTER_LEVEL_INFO_0_EL NULL
#define GAMBATTE_MIX_FRAMES_LABEL_EL NULL
#define GAMBATTE_MIX_FRAMES_INFO_0_EL NULL
#define OPTION_VAL_MIX_EL "Απλό"
#define OPTION_VAL_LCD_GHOSTING_EL NULL
#define OPTION_VAL_LCD_GHOSTING_FAST_EL NULL
#define GAMBATTE_AUDIO_RESAMPLER_LABEL_EL "Οδηγός Επαναδειγματολήπτη Ήχου"
#define GAMBATTE_AUDIO_RESAMPLER_INFO_0_EL NULL
#define OPTION_VAL_SINC_EL NULL
#define OPTION_VAL_CC_EL NULL
#define GAMBATTE_GB_HWMODE_LABEL_EL NULL
#define GAMBATTE_GB_HWMODE_INFO_0_EL NULL
#define OPTION_VAL_GB_EL NULL
#define OPTION_VAL_GBA_EL NULL
#define GAMBATTE_GB_BOOTLOADER_LABEL_EL NULL
#define GAMBATTE_GB_BOOTLOADER_INFO_0_EL NULL
#define GAMBATTE_UP_DOWN_ALLOWED_LABEL_EL NULL
#define GAMBATTE_UP_DOWN_ALLOWED_INFO_0_EL NULL
#define GAMBATTE_TURBO_PERIOD_LABEL_EL NULL
#define GAMBATTE_TURBO_PERIOD_INFO_0_EL NULL
#define GAMBATTE_RUMBLE_LEVEL_LABEL_EL NULL
#define GAMBATTE_RUMBLE_LEVEL_INFO_0_EL NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_LABEL_EL NULL
#define GAMBATTE_SHOW_GB_LINK_SETTINGS_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_EL NULL
#define GAMBATTE_GB_LINK_MODE_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_MODE_INFO_0_EL NULL
#define OPTION_VAL_NOT_CONNECTED_EL NULL
#define OPTION_VAL_NETWORK_SERVER_EL "Διακομιστής Δικτύου"
#define OPTION_VAL_NETWORK_CLIENT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_PORT_LABEL_CAT_EL "Θύρα"
#define GAMBATTE_GB_LINK_NETWORK_PORT_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_1_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_2_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_3_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_4_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_5_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_6_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_7_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_8_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_9_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_10_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_11_INFO_1_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_LABEL_CAT_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_0_EL NULL
#define GAMBATTE_GB_LINK_NETWORK_SERVER_IP_12_INFO_1_EL NULL

struct retro_core_option_v2_category option_cats_el[] = {
   {
      "gb_link",
      CATEGORY_GB_LINK_LABEL_EL,
      CATEGORY_GB_LINK_INFO_0_EL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_el[] = {
   {
      "gambatte_gb_colorization",
      GAMBATTE_GB_COLORIZATION_LABEL_EL,
      NULL,
      GAMBATTE_GB_COLORIZATION_INFO_0_EL,
      NULL,
      NULL,
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_EL },
         { "GBC",      OPTION_VAL_GBC_EL },
         { "SGB",      OPTION_VAL_SGB_EL },
         { "internal", OPTION_VAL_INTERNAL_EL },
         { "custom",   OPTION_VAL_CUSTOM_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "gambatte_gb_internal_palette",
      GAMBATTE_GB_INTERNAL_PALETTE_LABEL_EL,
      NULL,
      GAMBATTE_GB_INTERNAL_PALETTE_INFO_0_EL,
      NULL,
      NULL,
      {
         { "GB - DMG",                 OPTION_VAL_GB_DMG_EL },
         { "GB - Pocket",              OPTION_VAL_GB_POCKET_EL },
         { "GB - Light",               OPTION_VAL_GB_LIGHT_EL },
         { "GBC - Blue",               OPTION_VAL_GBC_BLUE_EL },
         { "GBC - Brown",              OPTION_VAL_GBC_BROWN_EL },
         { "GBC - Dark Blue",          OPTION_VAL_GBC_DARK_BLUE_EL },
         { "GBC - Dark Brown",         OPTION_VAL_GBC_DARK_BROWN_EL },
         { "GBC - Dark Green",         OPTION_VAL_GBC_DARK_GREEN_EL },
         { "GBC - Grayscale",          OPTION_VAL_GBC_GRAYSCALE_EL },
         { "GBC - Green",              OPTION_VAL_GBC_GREEN_EL },
         { "GBC - Inverted",           OPTION_VAL_GBC_INVERTED_EL },
         { "GBC - Orange",             OPTION_VAL_GBC_ORANGE_EL },
         { "GBC - Pastel Mix",         OPTION_VAL_GBC_PASTEL_MIX_EL },
         { "GBC - Red",                OPTION_VAL_GBC_RED_EL },
         { "GBC - Yellow",             OPTION_VAL_GBC_YELLOW_EL },
         { "SGB - 1A",                 OPTION_VAL_SGB_1A_EL },
         { "SGB - 1B",                 OPTION_VAL_SGB_1B_EL },
         { "SGB - 1C",                 OPTION_VAL_SGB_1C_EL },
         { "SGB - 1D",                 OPTION_VAL_SGB_1D_EL },
         { "SGB - 1E",                 OPTION_VAL_SGB_1E_EL },
         { "SGB - 1F",                 OPTION_VAL_SGB_1F_EL },
         { "SGB - 1G",                 OPTION_VAL_SGB_1G_EL },
         { "SGB - 1H",                 OPTION_VAL_SGB_1H_EL },
         { "SGB - 2A",                 OPTION_VAL_SGB_2A_EL },
         { "SGB - 2B",                 OPTION_VAL_SGB_2B_EL },
         { "SGB - 2C",                 OPTION_VAL_SGB_2C_EL },
         { "SGB - 2D",                 OPTION_VAL_SGB_2D_EL },
         { "SGB - 2E",                 OPTION_VAL_SGB_2E_EL },
         { "SGB - 2F",                 OPTION_VAL_SGB_2F_EL },
         { "SGB - 2G",                 OPTION_VAL_SGB_2G_EL },
         { "SGB - 2H",                 OPTION_VAL_SGB_2H_EL },
         { "SGB - 3A",                 OPTION_VAL_SGB_3A_EL },
         { "SGB - 3B",                 OPTION_VAL_SGB_3B_EL },
         { "SGB - 3C",                 OPTION_VAL_SGB_3C_EL },
         { "SGB - 3D",                 OPTION_VAL_SGB_3D_EL },
         { "SGB - 3E",                 OPTION_VAL_SGB_3E_EL },
         { "SGB - 3F",                 OPTION_VAL_SGB_3F_EL },
         { "SGB - 3G",                 OPTION_VAL_SGB_3G_EL },
         { "SGB - 3H",                 OPTION_VAL_SGB_3H_EL },
         { "SGB - 4A",                 OPTION_VAL_SGB_4A_EL },
         { "SGB - 4B",                 OPTION_VAL_SGB_4B_EL },
         { "SGB - 4C",                 OPTION_VAL_SGB_4C_EL },
         { "SGB - 4D",                 OPTION_VAL_SGB_4D_EL },
         { "SGB - 4E",                 OPTION_VAL_SGB_4E_EL },
         { "SGB - 4F",                 OPTION_VAL_SGB_4F_EL },
         { "SGB - 4G",                 OPTION_VAL_SGB_4G_EL },
         { "SGB - 4H",                 OPTION_VAL_SGB_4H_EL },
         { "Special 1",                OPTION_VAL_SPECIAL_1_EL },
         { "Special 2",                OPTION_VAL_SPECIAL_2_EL },
         { "Special 3",                OPTION_VAL_SPECIAL_3_EL },
         { "Special 4 (TI-83 Legacy)", OPTION_VAL_SPECIAL_4_TI_83_LEGACY_EL },
         { "TWB64 - Pack 1",           OPTION_VAL_TWB64_PACK_1_EL },
         { "TWB64 - Pack 2",           OPTION_VAL_TWB64_PACK_2_EL },
         { "TWB64 - Pack 3",           OPTION_VAL_TWB64_PACK_3_EL },
         { "PixelShift - Pack 1",      OPTION_VAL_PIXELSHIFT_PACK_1_EL },
         { NULL, NULL },
      },
      "GB - DMG"
   },
   {
      "gambatte_gb_palette_twb64_1",
      GAMBATTE_GB_PALETTE_TWB64_1_LABEL_EL,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_1_INFO_0_EL,
      NULL,
      NULL,
      {
         { "TWB64 001 - Aqours Blue",               OPTION_VAL_TWB64_001_AQOURS_BLUE_EL },
         { "TWB64 002 - Anime Expo Ver.",           OPTION_VAL_TWB64_002_ANIME_EXPO_VER_EL },
         { "TWB64 003 - SpongeBob Yellow",          OPTION_VAL_TWB64_003_SPONGEBOB_YELLOW_EL },
         { "TWB64 004 - Patrick Star Pink",         OPTION_VAL_TWB64_004_PATRICK_STAR_PINK_EL },
         { "TWB64 005 - Neon Red",                  OPTION_VAL_TWB64_005_NEON_RED_EL },
         { "TWB64 006 - Neon Blue",                 OPTION_VAL_TWB64_006_NEON_BLUE_EL },
         { "TWB64 007 - Neon Yellow",               OPTION_VAL_TWB64_007_NEON_YELLOW_EL },
         { "TWB64 008 - Neon Green",                OPTION_VAL_TWB64_008_NEON_GREEN_EL },
         { "TWB64 009 - Neon Pink",                 OPTION_VAL_TWB64_009_NEON_PINK_EL },
         { "TWB64 010 - Mario Red",                 OPTION_VAL_TWB64_010_MARIO_RED_EL },
         { "TWB64 011 - Nick Orange",               OPTION_VAL_TWB64_011_NICK_ORANGE_EL },
         { "TWB64 012 - Virtual Vision",            OPTION_VAL_TWB64_012_VIRTUAL_VISION_EL },
         { "TWB64 013 - Golden Wild",               OPTION_VAL_TWB64_013_GOLDEN_WILD_EL },
         { "TWB64 014 - DMG-099",                   OPTION_VAL_TWB64_014_DMG_099_EL },
         { "TWB64 015 - Classic Blurple",           OPTION_VAL_TWB64_015_CLASSIC_BLURPLE_EL },
         { "TWB64 016 - 765 Production Ver.",       OPTION_VAL_TWB64_016_765_PRODUCTION_VER_EL },
         { "TWB64 017 - Superball Ivory",           OPTION_VAL_TWB64_017_SUPERBALL_IVORY_EL },
         { "TWB64 018 - Crunchyroll Orange",        OPTION_VAL_TWB64_018_CRUNCHYROLL_ORANGE_EL },
         { "TWB64 019 - Muse Pink",                 OPTION_VAL_TWB64_019_MUSE_PINK_EL },
         { "TWB64 020 - School Idol Blue",          OPTION_VAL_TWB64_020_SCHOOL_IDOL_BLUE_EL },
         { "TWB64 021 - Gamate Ver.",               OPTION_VAL_TWB64_021_GAMATE_VER_EL },
         { "TWB64 022 - Greenscale Ver.",           OPTION_VAL_TWB64_022_GREENSCALE_VER_EL },
         { "TWB64 023 - Odyssey Gold",              OPTION_VAL_TWB64_023_ODYSSEY_GOLD_EL },
         { "TWB64 024 - Super Saiyan God",          OPTION_VAL_TWB64_024_SUPER_SAIYAN_GOD_EL },
         { "TWB64 025 - Super Saiyan Blue",         OPTION_VAL_TWB64_025_SUPER_SAIYAN_BLUE_EL },
         { "TWB64 026 - ANIMAX BLUE",               OPTION_VAL_TWB64_026_ANIMAX_BLUE_EL },
         { "TWB64 027 - BMO Ver.",                  OPTION_VAL_TWB64_027_BMO_VER_EL },
         { "TWB64 028 - Game.com Ver.",             OPTION_VAL_TWB64_028_GAME_COM_VER_EL },
         { "TWB64 029 - Sanrio Pink",               OPTION_VAL_TWB64_029_SANRIO_PINK_EL },
         { "TWB64 030 - Timmy Turner Pink",         OPTION_VAL_TWB64_030_TIMMY_TURNER_PINK_EL },
         { "TWB64 031 - Fairly OddPalette",         OPTION_VAL_TWB64_031_FAIRLY_ODDPALETTE_EL },
         { "TWB64 032 - Danny Phantom Silver",      OPTION_VAL_TWB64_032_DANNY_PHANTOM_SILVER_EL },
         { "TWB64 033 - Link's Awakening DX Ver.",  OPTION_VAL_TWB64_033_LINK_S_AWAKENING_DX_VER_EL },
         { "TWB64 034 - Travel Wood",               OPTION_VAL_TWB64_034_TRAVEL_WOOD_EL },
         { "TWB64 035 - Pokemon Ver.",              OPTION_VAL_TWB64_035_POKEMON_VER_EL },
         { "TWB64 036 - Game Grump Orange",         OPTION_VAL_TWB64_036_GAME_GRUMP_ORANGE_EL },
         { "TWB64 037 - Scooby-Doo Mystery Ver.",   OPTION_VAL_TWB64_037_SCOOBY_DOO_MYSTERY_VER_EL },
         { "TWB64 038 - Pokemon mini Ver.",         OPTION_VAL_TWB64_038_POKEMON_MINI_VER_EL },
         { "TWB64 039 - Supervision Ver.",          OPTION_VAL_TWB64_039_SUPERVISION_VER_EL },
         { "TWB64 040 - DMG Ver.",                  OPTION_VAL_TWB64_040_DMG_VER_EL },
         { "TWB64 041 - Pocket Ver.",               OPTION_VAL_TWB64_041_POCKET_VER_EL },
         { "TWB64 042 - Light Ver.",                OPTION_VAL_TWB64_042_LIGHT_VER_EL },
         { "TWB64 043 - All Might Hero Palette",    OPTION_VAL_TWB64_043_ALL_MIGHT_HERO_PALETTE_EL },
         { "TWB64 044 - U.A. High School Uniform",  OPTION_VAL_TWB64_044_U_A_HIGH_SCHOOL_UNIFORM_EL },
         { "TWB64 045 - Pikachu Yellow",            OPTION_VAL_TWB64_045_PIKACHU_YELLOW_EL },
         { "TWB64 046 - Eevee Brown",               OPTION_VAL_TWB64_046_EEVEE_BROWN_EL },
         { "TWB64 047 - Microvision Ver.",          OPTION_VAL_TWB64_047_MICROVISION_VER_EL },
         { "TWB64 048 - TI-83 Ver.",                OPTION_VAL_TWB64_048_TI_83_VER_EL },
         { "TWB64 049 - Aegis Cherry",              OPTION_VAL_TWB64_049_AEGIS_CHERRY_EL },
         { "TWB64 050 - Labo Fawn",                 OPTION_VAL_TWB64_050_LABO_FAWN_EL },
         { "TWB64 051 - MILLION LIVE GOLD!",        OPTION_VAL_TWB64_051_MILLION_LIVE_GOLD_EL },
         { "TWB64 052 - Squidward Sea Foam Green",  OPTION_VAL_TWB64_052_SQUIDWARD_SEA_FOAM_GREEN_EL },
         { "TWB64 053 - VMU Ver.",                  OPTION_VAL_TWB64_053_VMU_VER_EL },
         { "TWB64 054 - Game Master Ver.",          OPTION_VAL_TWB64_054_GAME_MASTER_VER_EL },
         { "TWB64 055 - Android Green",             OPTION_VAL_TWB64_055_ANDROID_GREEN_EL },
         { "TWB64 056 - Amazon Vision",             OPTION_VAL_TWB64_056_AMAZON_VISION_EL },
         { "TWB64 057 - Google Red",                OPTION_VAL_TWB64_057_GOOGLE_RED_EL },
         { "TWB64 058 - Google Blue",               OPTION_VAL_TWB64_058_GOOGLE_BLUE_EL },
         { "TWB64 059 - Google Yellow",             OPTION_VAL_TWB64_059_GOOGLE_YELLOW_EL },
         { "TWB64 060 - Google Green",              OPTION_VAL_TWB64_060_GOOGLE_GREEN_EL },
         { "TWB64 061 - WonderSwan Ver.",           OPTION_VAL_TWB64_061_WONDERSWAN_VER_EL },
         { "TWB64 062 - Neo Geo Pocket Ver.",       OPTION_VAL_TWB64_062_NEO_GEO_POCKET_VER_EL },
         { "TWB64 063 - Dew Green",                 OPTION_VAL_TWB64_063_DEW_GREEN_EL },
         { "TWB64 064 - Coca-Cola Vision",          OPTION_VAL_TWB64_064_COCA_COLA_VISION_EL },
         { "TWB64 065 - GameKing Ver.",             OPTION_VAL_TWB64_065_GAMEKING_VER_EL },
         { "TWB64 066 - Do The Dew Ver.",           OPTION_VAL_TWB64_066_DO_THE_DEW_VER_EL },
         { "TWB64 067 - Digivice Ver.",             OPTION_VAL_TWB64_067_DIGIVICE_VER_EL },
         { "TWB64 068 - Bikini Bottom Ver.",        OPTION_VAL_TWB64_068_BIKINI_BOTTOM_VER_EL },
         { "TWB64 069 - Blossom Pink",              OPTION_VAL_TWB64_069_BLOSSOM_PINK_EL },
         { "TWB64 070 - Bubbles Blue",              OPTION_VAL_TWB64_070_BUBBLES_BLUE_EL },
         { "TWB64 071 - Buttercup Green",           OPTION_VAL_TWB64_071_BUTTERCUP_GREEN_EL },
         { "TWB64 072 - NASCAR Ver.",               OPTION_VAL_TWB64_072_NASCAR_VER_EL },
         { "TWB64 073 - Lemon-Lime Green",          OPTION_VAL_TWB64_073_LEMON_LIME_GREEN_EL },
         { "TWB64 074 - Mega Man V Ver.",           OPTION_VAL_TWB64_074_MEGA_MAN_V_VER_EL },
         { "TWB64 075 - Tamagotchi Ver.",           OPTION_VAL_TWB64_075_TAMAGOTCHI_VER_EL },
         { "TWB64 076 - Phantom Red",               OPTION_VAL_TWB64_076_PHANTOM_RED_EL },
         { "TWB64 077 - Halloween Ver.",            OPTION_VAL_TWB64_077_HALLOWEEN_VER_EL },
         { "TWB64 078 - Christmas Ver.",            OPTION_VAL_TWB64_078_CHRISTMAS_VER_EL },
         { "TWB64 079 - Cardcaptor Pink",           OPTION_VAL_TWB64_079_CARDCAPTOR_PINK_EL },
         { "TWB64 080 - Pretty Guardian Gold",      OPTION_VAL_TWB64_080_PRETTY_GUARDIAN_GOLD_EL },
         { "TWB64 081 - Camouflage Ver.",           OPTION_VAL_TWB64_081_CAMOUFLAGE_VER_EL },
         { "TWB64 082 - Legendary Super Saiyan",    OPTION_VAL_TWB64_082_LEGENDARY_SUPER_SAIYAN_EL },
         { "TWB64 083 - Super Saiyan Rose",         OPTION_VAL_TWB64_083_SUPER_SAIYAN_ROSE_EL },
         { "TWB64 084 - Super Saiyan",              OPTION_VAL_TWB64_084_SUPER_SAIYAN_EL },
         { "TWB64 085 - Perfected Ultra Instinct",  OPTION_VAL_TWB64_085_PERFECTED_ULTRA_INSTINCT_EL },
         { "TWB64 086 - Saint Snow Red",            OPTION_VAL_TWB64_086_SAINT_SNOW_RED_EL },
         { "TWB64 087 - Yellow Banana",             OPTION_VAL_TWB64_087_YELLOW_BANANA_EL },
         { "TWB64 088 - Green Banana",              OPTION_VAL_TWB64_088_GREEN_BANANA_EL },
         { "TWB64 089 - Super Saiyan 3",            OPTION_VAL_TWB64_089_SUPER_SAIYAN_3_EL },
         { "TWB64 090 - Super Saiyan Blue Evolved", OPTION_VAL_TWB64_090_SUPER_SAIYAN_BLUE_EVOLVED_EL },
         { "TWB64 091 - Pocket Tales Ver.",         OPTION_VAL_TWB64_091_POCKET_TALES_VER_EL },
         { "TWB64 092 - Investigation Yellow",      OPTION_VAL_TWB64_092_INVESTIGATION_YELLOW_EL },
         { "TWB64 093 - S.E.E.S. Blue",             OPTION_VAL_TWB64_093_S_E_E_S_BLUE_EL },
         { "TWB64 094 - Ultra Instinct Sign",       OPTION_VAL_TWB64_094_ULTRA_INSTINCT_SIGN_EL },
         { "TWB64 095 - Hokage Orange",             OPTION_VAL_TWB64_095_HOKAGE_ORANGE_EL },
         { "TWB64 096 - Straw Hat Red",             OPTION_VAL_TWB64_096_STRAW_HAT_RED_EL },
         { "TWB64 097 - Sword Art Cyan",            OPTION_VAL_TWB64_097_SWORD_ART_CYAN_EL },
         { "TWB64 098 - Deku Alpha Emerald",        OPTION_VAL_TWB64_098_DEKU_ALPHA_EMERALD_EL },
         { "TWB64 099 - Blue Stripes Ver.",         OPTION_VAL_TWB64_099_BLUE_STRIPES_VER_EL },
         { "TWB64 100 - Precure Marble Raspberry",  OPTION_VAL_TWB64_100_PRECURE_MARBLE_RASPBERRY_EL },
         { NULL, NULL },
      },
      "TWB64 001 - Aqours Blue"
   },
   {
      "gambatte_gb_palette_twb64_2",
      GAMBATTE_GB_PALETTE_TWB64_2_LABEL_EL,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_2_INFO_0_EL,
      NULL,
      NULL,
      {
         { "TWB64 101 - 765PRO Pink",               OPTION_VAL_TWB64_101_765PRO_PINK_EL },
         { "TWB64 102 - CINDERELLA Blue",           OPTION_VAL_TWB64_102_CINDERELLA_BLUE_EL },
         { "TWB64 103 - MILLION Yellow!",           OPTION_VAL_TWB64_103_MILLION_YELLOW_EL },
         { "TWB64 104 - SideM Green",               OPTION_VAL_TWB64_104_SIDEM_GREEN_EL },
         { "TWB64 105 - SHINY Sky Blue",            OPTION_VAL_TWB64_105_SHINY_SKY_BLUE_EL },
         { "TWB64 106 - Angry Volcano Ver.",        OPTION_VAL_TWB64_106_ANGRY_VOLCANO_VER_EL },
         { "TWB64 107 - NBA Vision",                OPTION_VAL_TWB64_107_NBA_VISION_EL },
         { "TWB64 108 - NFL Vision",                OPTION_VAL_TWB64_108_NFL_VISION_EL },
         { "TWB64 109 - MLB Vision",                OPTION_VAL_TWB64_109_MLB_VISION_EL },
         { "TWB64 110 - Anime Digivice Ver.",       OPTION_VAL_TWB64_110_ANIME_DIGIVICE_VER_EL },
         { "TWB64 111 - Aquatic Iro",               OPTION_VAL_TWB64_111_AQUATIC_IRO_EL },
         { "TWB64 112 - Tea Midori",                OPTION_VAL_TWB64_112_TEA_MIDORI_EL },
         { "TWB64 113 - Sakura Pink",               OPTION_VAL_TWB64_113_SAKURA_PINK_EL },
         { "TWB64 114 - Wisteria Murasaki",         OPTION_VAL_TWB64_114_WISTERIA_MURASAKI_EL },
         { "TWB64 115 - Oni Aka",                   OPTION_VAL_TWB64_115_ONI_AKA_EL },
         { "TWB64 116 - Golden Kiiro",              OPTION_VAL_TWB64_116_GOLDEN_KIIRO_EL },
         { "TWB64 117 - Silver Shiro",              OPTION_VAL_TWB64_117_SILVER_SHIRO_EL },
         { "TWB64 118 - Fruity Orange",             OPTION_VAL_TWB64_118_FRUITY_ORANGE_EL },
         { "TWB64 119 - AKB48 Pink",                OPTION_VAL_TWB64_119_AKB48_PINK_EL },
         { "TWB64 120 - Miku Blue",                 OPTION_VAL_TWB64_120_MIKU_BLUE_EL },
         { "TWB64 121 - Tri Digivice Ver.",         OPTION_VAL_TWB64_121_TRI_DIGIVICE_VER_EL },
         { "TWB64 122 - Survey Corps Uniform",      OPTION_VAL_TWB64_122_SURVEY_CORPS_UNIFORM_EL },
         { "TWB64 123 - Island Green",              OPTION_VAL_TWB64_123_ISLAND_GREEN_EL },
         { "TWB64 124 - Nogizaka46 Purple",         OPTION_VAL_TWB64_124_NOGIZAKA46_PURPLE_EL },
         { "TWB64 125 - Ninja Turtle Green",        OPTION_VAL_TWB64_125_NINJA_TURTLE_GREEN_EL },
         { "TWB64 126 - Slime Blue",                OPTION_VAL_TWB64_126_SLIME_BLUE_EL },
         { "TWB64 127 - Lime Midori",               OPTION_VAL_TWB64_127_LIME_MIDORI_EL },
         { "TWB64 128 - Ghostly Aoi",               OPTION_VAL_TWB64_128_GHOSTLY_AOI_EL },
         { "TWB64 129 - Retro Bogeda",              OPTION_VAL_TWB64_129_RETRO_BOGEDA_EL },
         { "TWB64 130 - Royal Blue",                OPTION_VAL_TWB64_130_ROYAL_BLUE_EL },
         { "TWB64 131 - Neon Purple",               OPTION_VAL_TWB64_131_NEON_PURPLE_EL },
         { "TWB64 132 - Neon Orange",               OPTION_VAL_TWB64_132_NEON_ORANGE_EL },
         { "TWB64 133 - Moonlight Vision",          OPTION_VAL_TWB64_133_MOONLIGHT_VISION_EL },
         { "TWB64 134 - Rising Sun Red",            OPTION_VAL_TWB64_134_RISING_SUN_RED_EL },
         { "TWB64 135 - Burger King Color Combo",   OPTION_VAL_TWB64_135_BURGER_KING_COLOR_COMBO_EL },
         { "TWB64 136 - Grand Zeno Coat",           OPTION_VAL_TWB64_136_GRAND_ZENO_COAT_EL },
         { "TWB64 137 - Pac-Man Yellow",            OPTION_VAL_TWB64_137_PAC_MAN_YELLOW_EL },
         { "TWB64 138 - Irish Green",               OPTION_VAL_TWB64_138_IRISH_GREEN_EL },
         { "TWB64 139 - Goku Gi",                   OPTION_VAL_TWB64_139_GOKU_GI_EL },
         { "TWB64 140 - Dragon Ball Orange",        OPTION_VAL_TWB64_140_DRAGON_BALL_ORANGE_EL },
         { "TWB64 141 - Christmas Gold",            OPTION_VAL_TWB64_141_CHRISTMAS_GOLD_EL },
         { "TWB64 142 - Pepsi Vision",              OPTION_VAL_TWB64_142_PEPSI_VISION_EL },
         { "TWB64 143 - Bubblun Green",             OPTION_VAL_TWB64_143_BUBBLUN_GREEN_EL },
         { "TWB64 144 - Bobblun Blue",              OPTION_VAL_TWB64_144_BOBBLUN_BLUE_EL },
         { "TWB64 145 - Baja Blast Storm",          OPTION_VAL_TWB64_145_BAJA_BLAST_STORM_EL },
         { "TWB64 146 - Olympic Gold",              OPTION_VAL_TWB64_146_OLYMPIC_GOLD_EL },
         { "TWB64 147 - LisAni Orange!",            OPTION_VAL_TWB64_147_LISANI_ORANGE_EL },
         { "TWB64 148 - Liella Purple!",            OPTION_VAL_TWB64_148_LIELLA_PURPLE_EL },
         { "TWB64 149 - Olympic Silver",            OPTION_VAL_TWB64_149_OLYMPIC_SILVER_EL },
         { "TWB64 150 - Olympic Bronze",            OPTION_VAL_TWB64_150_OLYMPIC_BRONZE_EL },
         { "TWB64 151 - ANA Flight Blue",           OPTION_VAL_TWB64_151_ANA_FLIGHT_BLUE_EL },
         { "TWB64 152 - Nijigasaki Orange",         OPTION_VAL_TWB64_152_NIJIGASAKI_ORANGE_EL },
         { "TWB64 153 - holoblue",                  OPTION_VAL_TWB64_153_HOLOBLUE_EL },
         { "TWB64 154 - WWE White and Red",         OPTION_VAL_TWB64_154_WWE_WHITE_AND_RED_EL },
         { "TWB64 155 - Yoshi Egg Green",           OPTION_VAL_TWB64_155_YOSHI_EGG_GREEN_EL },
         { "TWB64 156 - Pokedex Red",               OPTION_VAL_TWB64_156_POKEDEX_RED_EL },
         { "TWB64 157 - FamilyMart Vision",         OPTION_VAL_TWB64_157_FAMILYMART_VISION_EL },
         { "TWB64 158 - Xbox Green",                OPTION_VAL_TWB64_158_XBOX_GREEN_EL },
         { "TWB64 159 - Sonic Mega Blue",           OPTION_VAL_TWB64_159_SONIC_MEGA_BLUE_EL },
         { "TWB64 160 - Sprite Green",              OPTION_VAL_TWB64_160_SPRITE_GREEN_EL },
         { "TWB64 161 - Scarlett Green",            OPTION_VAL_TWB64_161_SCARLETT_GREEN_EL },
         { "TWB64 162 - Glitchy Blue",              OPTION_VAL_TWB64_162_GLITCHY_BLUE_EL },
         { "TWB64 163 - Classic LCD",               OPTION_VAL_TWB64_163_CLASSIC_LCD_EL },
         { "TWB64 164 - 3DS Virtual Console Ver.",  OPTION_VAL_TWB64_164_3DS_VIRTUAL_CONSOLE_VER_EL },
         { "TWB64 165 - PocketStation Ver.",        OPTION_VAL_TWB64_165_POCKETSTATION_VER_EL },
         { "TWB64 166 - Timeless Gold and Red",     OPTION_VAL_TWB64_166_TIMELESS_GOLD_AND_RED_EL },
         { "TWB64 167 - Smurfy Blue",               OPTION_VAL_TWB64_167_SMURFY_BLUE_EL },
         { "TWB64 168 - Swampy Ogre Green",         OPTION_VAL_TWB64_168_SWAMPY_OGRE_GREEN_EL },
         { "TWB64 169 - Sailor Spinach Green",      OPTION_VAL_TWB64_169_SAILOR_SPINACH_GREEN_EL },
         { "TWB64 170 - Shenron Green",             OPTION_VAL_TWB64_170_SHENRON_GREEN_EL },
         { "TWB64 171 - Berserk Blood",             OPTION_VAL_TWB64_171_BERSERK_BLOOD_EL },
         { "TWB64 172 - Super Star Pink",           OPTION_VAL_TWB64_172_SUPER_STAR_PINK_EL },
         { "TWB64 173 - Gamebuino Classic Ver.",    OPTION_VAL_TWB64_173_GAMEBUINO_CLASSIC_VER_EL },
         { "TWB64 174 - Barbie Pink",               OPTION_VAL_TWB64_174_BARBIE_PINK_EL },
         { "TWB64 175 - YOASOBI AMARANTH",          OPTION_VAL_TWB64_175_YOASOBI_AMARANTH_EL },
         { "TWB64 176 - Nokia 3310 Ver.",           OPTION_VAL_TWB64_176_NOKIA_3310_VER_EL },
         { "TWB64 177 - Clover Green",              OPTION_VAL_TWB64_177_CLOVER_GREEN_EL },
         { "TWB64 178 - Goku GT Gi",                OPTION_VAL_TWB64_178_GOKU_GT_GI_EL },
         { "TWB64 179 - Famicom Disk Yellow",       OPTION_VAL_TWB64_179_FAMICOM_DISK_YELLOW_EL },
         { "TWB64 180 - Team Rocket Uniform",       OPTION_VAL_TWB64_180_TEAM_ROCKET_UNIFORM_EL },
         { "TWB64 181 - SEIKO Timely Vision",       OPTION_VAL_TWB64_181_SEIKO_TIMELY_VISION_EL },
         { "TWB64 182 - PASTEL109",                 OPTION_VAL_TWB64_182_PASTEL109_EL },
         { "TWB64 183 - Doraemon Tricolor",         OPTION_VAL_TWB64_183_DORAEMON_TRICOLOR_EL },
         { "TWB64 184 - Fury Blue",                 OPTION_VAL_TWB64_184_FURY_BLUE_EL },
         { "TWB64 185 - GOOD SMILE VISION",         OPTION_VAL_TWB64_185_GOOD_SMILE_VISION_EL },
         { "TWB64 186 - Puyo Puyo Green",           OPTION_VAL_TWB64_186_PUYO_PUYO_GREEN_EL },
         { "TWB64 187 - Circle K Color Combo",      OPTION_VAL_TWB64_187_CIRCLE_K_COLOR_COMBO_EL },
         { "TWB64 188 - Pizza Hut Red",             OPTION_VAL_TWB64_188_PIZZA_HUT_RED_EL },
         { "TWB64 189 - Emerald Green",             OPTION_VAL_TWB64_189_EMERALD_GREEN_EL },
         { "TWB64 190 - Grand Ivory",               OPTION_VAL_TWB64_190_GRAND_IVORY_EL },
         { "TWB64 191 - Demon's Gold",              OPTION_VAL_TWB64_191_DEMON_S_GOLD_EL },
         { "TWB64 192 - SEGA Tokyo Blue",           OPTION_VAL_TWB64_192_SEGA_TOKYO_BLUE_EL },
         { "TWB64 193 - Champion's Tunic",          OPTION_VAL_TWB64_193_CHAMPION_S_TUNIC_EL },
         { "TWB64 194 - DK Barrel Brown",           OPTION_VAL_TWB64_194_DK_BARREL_BROWN_EL },
         { "TWB64 195 - EVA-01",                    OPTION_VAL_TWB64_195_EVA_01_EL },
         { "TWB64 196 - Wild West Vision",          OPTION_VAL_TWB64_196_WILD_WEST_VISION_EL },
         { "TWB64 197 - Optimus Prime Palette",     OPTION_VAL_TWB64_197_OPTIMUS_PRIME_PALETTE_EL },
         { "TWB64 198 - niconico sea green",        OPTION_VAL_TWB64_198_NICONICO_SEA_GREEN_EL },
         { "TWB64 199 - Duracell Copper",           OPTION_VAL_TWB64_199_DURACELL_COPPER_EL },
         { "TWB64 200 - TOKYO SKYTREE CLOUDY BLUE", OPTION_VAL_TWB64_200_TOKYO_SKYTREE_CLOUDY_BLUE_EL },
         { NULL, NULL },
      },
      "TWB64 101 - 765PRO Pink"
   },
   {
      "gambatte_gb_palette_twb64_3",
      GAMBATTE_GB_PALETTE_TWB64_3_LABEL_EL,
      NULL,
      GAMBATTE_GB_PALETTE_TWB64_3_INFO_0_EL,
      NULL,
      NULL,
      {
         { "TWB64 201 - DMG-GOLD",                  OPTION_VAL_TWB64_201_DMG_GOLD_EL },
         { "TWB64 202 - LCD Clock Green",           OPTION_VAL_TWB64_202_LCD_CLOCK_GREEN_EL },
         { "TWB64 203 - Famicom Frenzy",            OPTION_VAL_TWB64_203_FAMICOM_FRENZY_EL },
         { "TWB64 204 - DK Arcade Blue",            OPTION_VAL_TWB64_204_DK_ARCADE_BLUE_EL },
         { "TWB64 205 - Advanced Indigo",           OPTION_VAL_TWB64_205_ADVANCED_INDIGO_EL },
         { "TWB64 206 - Ultra Black",               OPTION_VAL_TWB64_206_ULTRA_BLACK_EL },
         { "TWB64 207 - Chaos Emerald Green",       OPTION_VAL_TWB64_207_CHAOS_EMERALD_GREEN_EL },
         { "TWB64 208 - Blue Bomber Vision",        OPTION_VAL_TWB64_208_BLUE_BOMBER_VISION_EL },
         { "TWB64 209 - Krispy Kreme Vision",       OPTION_VAL_TWB64_209_KRISPY_KREME_VISION_EL },
         { "TWB64 210 - Steam Gray",                OPTION_VAL_TWB64_210_STEAM_GRAY_EL },
         { "TWB64 211 - Dream Land GB Ver.",        OPTION_VAL_TWB64_211_DREAM_LAND_GB_VER_EL },
         { "TWB64 212 - Pokemon Pinball Ver.",      OPTION_VAL_TWB64_212_POKEMON_PINBALL_VER_EL },
         { "TWB64 213 - Poketch Ver.",              OPTION_VAL_TWB64_213_POKETCH_VER_EL },
         { "TWB64 214 - COLLECTION of SaGa Ver.",   OPTION_VAL_TWB64_214_COLLECTION_OF_SAGA_VER_EL },
         { "TWB64 215 - Rocky-Valley Holiday",      OPTION_VAL_TWB64_215_ROCKY_VALLEY_HOLIDAY_EL },
         { "TWB64 216 - Giga Kiwi DMG",             OPTION_VAL_TWB64_216_GIGA_KIWI_DMG_EL },
         { "TWB64 217 - DMG Pea Green",             OPTION_VAL_TWB64_217_DMG_PEA_GREEN_EL },
         { "TWB64 218 - Timing Hero Ver.",          OPTION_VAL_TWB64_218_TIMING_HERO_VER_EL },
         { "TWB64 219 - Invincible Yellow and Blue",OPTION_VAL_TWB64_219_INVINCIBLE_YELLOW_AND_BLUE_EL },
         { "TWB64 220 - Grinchy Green",             OPTION_VAL_TWB64_220_GRINCHY_GREEN_EL },
         { "TWB64 221 - animate vision",            OPTION_VAL_TWB64_221_ANIMATE_VISION_EL },
         { "TWB64 222 - School Idol Mix",           OPTION_VAL_TWB64_222_SCHOOL_IDOL_MIX_EL },
         { "TWB64 223 - Green Awakening",           OPTION_VAL_TWB64_223_GREEN_AWAKENING_EL },
         { "TWB64 224 - Goomba Brown",              OPTION_VAL_TWB64_224_GOOMBA_BROWN_EL },
         { "TWB64 225 -