
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktoolbarlabelaction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktoolbarspaceraction_wrapper.h"

// Argument includes
#include <QString>
#include <qaction.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToolBarLabelAction_Type = nullptr;
static PyTypeObject *Sbk_KToolBarLabelAction_TypeF(void)
{
    return _Sbk_KToolBarLabelAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KToolBarLabelActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KToolBarLabelActionWrapper::KToolBarLabelActionWrapper(::QAction * buddy, const ::QString & text, ::QObject * parent) : KToolBarLabelAction(buddy, text, parent)
{
}

KToolBarLabelActionWrapper::KToolBarLabelActionWrapper(const ::QString & text, ::QObject * parent) : KToolBarLabelAction(text, parent)
{
}

void KToolBarLabelActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KToolBarLabelAction", funcName, gil, pyOverride, event);
}

void KToolBarLabelActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToolBarLabelAction", funcName, gil, pyOverride, signal);
}

::QWidget * KToolBarLabelActionWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToolBarLabelAction::createWidget(parent);
    }
    return KToolBarSpacerActionWrapper::sbk_o_createWidget("KToolBarLabelAction", funcName, gil, pyOverride, parent);
}

void KToolBarLabelActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KToolBarLabelAction", funcName, gil, pyOverride, event);
}

void KToolBarLabelActionWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidgetAction::deleteWidget(widget);
    }
    KToolBarSpacerActionWrapper::sbk_o_deleteWidget("KToolBarLabelAction", funcName, gil, pyOverride, widget);
}

void KToolBarLabelActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KToolBarLabelAction", funcName, gil, pyOverride, signal);
}

bool KToolBarLabelActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToolBarLabelAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KToolBarLabelAction", funcName, gil, pyOverride, arg__1);
}

bool KToolBarLabelActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KToolBarLabelAction::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KToolBarLabelAction", funcName, gil, pyOverride, watched, event);
}

void KToolBarLabelActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KToolBarLabelAction_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KToolBarLabelAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KToolBarLabelActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KToolBarLabelAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KToolBarLabelActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KToolBarLabelAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KToolBarLabelActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KToolBarLabelActionWrapper *>(this));
    }
    return KToolBarLabelAction::qt_metacast(_clname);
}

KToolBarLabelActionWrapper::~KToolBarLabelActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KToolBarLabelAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KToolBarLabelAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KToolBarLabelAction >()))
        return -1;

    KToolBarLabelActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KToolBarLabelAction", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KToolBarLabelAction::KToolBarLabelAction(QAction*,QString,QObject*)
    // 1: KToolBarLabelAction::KToolBarLabelAction(QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 0; // KToolBarLabelAction(QAction*,QString,QObject*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 1; // KToolBarLabelAction(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KToolBarLabelAction(QAction *buddy, const QString &text, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAction *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToolBarLabelAction(QAction*,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToolBarLabelActionWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToolBarLabelActionWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 1: // KToolBarLabelAction(const QString &text, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KToolBarLabelAction(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KToolBarLabelActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KToolBarLabelActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KToolBarLabelAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KToolBarLabelActionFunc_buddy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarLabelAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // buddy()const
        QAction * cppResult = const_cast<const ::KToolBarLabelAction *>(cppSelf)->buddy();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarLabelActionFunc_createWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarLabelAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::createWidget(QWidget*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // createWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createWidget(QWidget*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToolBarLabelAction::createWidget(cppArg0)
                : cppSelf->createWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarLabelActionFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarLabelAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToolBarLabelAction::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarLabelActionFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarLabelAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToolBarLabelAction::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolBarLabelActionFunc_setBuddy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolBarLabelAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KToolBarLabelAction::setBuddy(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // setBuddy(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBuddy", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBuddy(QAction*)
            cppSelf->setBuddy(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KToolBarLabelAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToolBarLabelAction_methods[] = {
    {"buddy", reinterpret_cast<PyCFunction>(Sbk_KToolBarLabelActionFunc_buddy), METH_NOARGS, nullptr},
    {"createWidget", reinterpret_cast<PyCFunction>(Sbk_KToolBarLabelActionFunc_createWidget), METH_O, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KToolBarLabelActionFunc_event), METH_O, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KToolBarLabelActionFunc_eventFilter), METH_VARARGS, nullptr},
    {"setBuddy", reinterpret_cast<PyCFunction>(Sbk_KToolBarLabelActionFunc_setBuddy), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToolBarLabelAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KToolBarLabelAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KToolBarLabelActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToolBarLabelAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToolBarLabelAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToolBarLabelAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToolBarLabelAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToolBarLabelAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToolBarLabelAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToolBarLabelAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToolBarLabelAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToolBarLabelAction_spec = {
    "1:KWidgetsAddons.KToolBarLabelAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToolBarLabelAction_slots
};

} //extern "C"

static void *Sbk_KToolBarLabelAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KToolBarLabelAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToolBarLabelAction_PythonToCpp_KToolBarLabelAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToolBarLabelAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToolBarLabelAction_PythonToCpp_KToolBarLabelAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToolBarLabelAction_TypeF()))
        return KToolBarLabelAction_PythonToCpp_KToolBarLabelAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToolBarLabelAction_PTR_CppToPython_KToolBarLabelAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KToolBarLabelAction *>(const_cast<void *>(cppIn)), Sbk_KToolBarLabelAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToolBarLabelAction_SignatureStrings[] = {
    "1:KWidgetsAddons.KToolBarLabelAction(self,buddy:PySide6.QtGui.QAction,text:QString,parent:PySide6.QtCore.QObject)",
    "0:KWidgetsAddons.KToolBarLabelAction(self,text:QString,parent:PySide6.QtCore.QObject)",
    "KWidgetsAddons.KToolBarLabelAction.buddy(self)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KToolBarLabelAction.createWidget(self,parent:PySide6.QtWidgets.QWidget)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KToolBarLabelAction.event(self,arg__1:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KToolBarLabelAction.eventFilter(self,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KToolBarLabelAction.setBuddy(self,buddy:PySide6.QtGui.QAction)",
    nullptr}; // Sentinel
#else
static constexpr size_t KToolBarLabelAction_SignatureByteSize = 208;
static constexpr uint8_t KToolBarLabelAction_SignatureBytes[208] = {
    0x78, 0xda, 0xa5, 0x92, 0xcf, 0x0b, 0x82, 0x30, 0x14, 0xc7, 0xef, 0xfe, 0x25, 0x09, 0x36, 0xf2,
    0xd2, 0xc1, 0x43, 0xa0, 0x51, 0x1d, 0x0c, 0x6a, 0x18, 0x74, 0x94, 0xe9, 0x5e, 0xb6, 0x10, 0x17,
    0xf3, 0x59, 0xf9, 0xdf, 0x67, 0x2e, 0xa2, 0xb2, 0x1f, 0x8b, 0x6e, 0x83, 0x7d, 0xdf, 0xe7, 0xf3,
    0xde, 0xdb, 0x5c, 0x2f, 0x5c, 0x0b, 0x9e, 0x01, 0x96, 0x3e, 0xe7, 0xb2, 0x28, 0x49, 0xb8, 0x92,
    0x32, 0x0f, 0x98, 0x9a, 0xb3, 0x04, 0x72, 0x3f, 0x45, 0x21, 0x8b, 0x5e, 0x09, 0xf9, 0xc6, 0x49,
    0x2a, 0xce, 0x6b, 0x6f, 0x59, 0x47, 0x82, 0xc3, 0x90, 0x50, 0x9c, 0x55, 0x82, 0x50, 0x1d, 0x70,
    0x10, 0x4e, 0xe8, 0xd1, 0x08, 0x95, 0x28, 0x32, 0x67, 0xcf, 0x14, 0x14, 0x78, 0x97, 0x1c, 0x4b,
    0x05, 0x84, 0x2e, 0x92, 0x1d, 0xa4, 0x68, 0x5b, 0x03, 0x63, 0xe3, 0x2f, 0xd4, 0xef, 0x4c, 0xd2,
    0x0e, 0xd0, 0x92, 0xed, 0xfe, 0xe8, 0xe5, 0x1c, 0x26, 0x94, 0x54, 0x01, 0x43, 0xd0, 0x39, 0xdd,
    0x66, 0xa7, 0xb3, 0x2b, 0x84, 0x50, 0x7d, 0x78, 0xb0, 0x3d, 0xdd, 0x99, 0x18, 0xe1, 0xd0, 0xe0,
    0xb5, 0x8a, 0xa9, 0x2c, 0x8e, 0xdd, 0xce, 0x12, 0x26, 0x97, 0x44, 0xa3, 0x49, 0x9a, 0x62, 0x63,
    0xe2, 0x54, 0xe4, 0x08, 0x4a, 0x73, 0x8f, 0x0c, 0xd3, 0x2d, 0xf0, 0x37, 0xdb, 0x75, 0xda, 0xfc,
    0xdf, 0xd6, 0x12, 0x30, 0xb8, 0x3d, 0xc1, 0xa7, 0xef, 0x64, 0x5b, 0x67, 0x84, 0x96, 0xef, 0x64
};
#endif

PyTypeObject *init_KToolBarLabelAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KToolBarLabelAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX]))));

    _Sbk_KToolBarLabelAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToolBarLabelAction",
        "KToolBarLabelAction*",
        &Sbk_KToolBarLabelAction_spec,
        &Shiboken::callCppDestructor< KToolBarLabelAction >,
        Sbk_KToolBarLabelAction_Type_bases.object(),
        0);
    auto *pyType = Sbk_KToolBarLabelAction_TypeF(); // references _Sbk_KToolBarLabelAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToolBarLabelAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToolBarLabelAction_SignatureBytes, KToolBarLabelAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToolBarLabelAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToolBarLabelAction_PythonToCpp_KToolBarLabelAction_PTR,
        is_KToolBarLabelAction_PythonToCpp_KToolBarLabelAction_PTR_Convertible,
        KToolBarLabelAction_PTR_CppToPython_KToolBarLabelAction);

    Shiboken::Conversions::registerConverterName(converter, "KToolBarLabelAction");
    Shiboken::Conversions::registerConverterName(converter, "KToolBarLabelAction*");
    Shiboken::Conversions::registerConverterName(converter, "KToolBarLabelAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToolBarLabelAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KToolBarLabelActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KToolBarLabelAction_TypeF(), &Sbk_KToolBarLabelAction_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KToolBarLabelAction::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KToolBarLabelAction::staticMetaObject, sizeof(KToolBarLabelActionWrapper));

    return pyType;
}
