
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kruler_wrapper.h"

// Wrappers providing overrides
#include "kselector_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kruler.h>
#include <qabstractslider.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KRuler_Type = nullptr;
static PyTypeObject *Sbk_KRuler_TypeF(void)
{
    return _Sbk_KRuler_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KRulerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KRulerWrapper::KRulerWrapper(::QWidget * parent) : KRuler(parent)
{
}

KRulerWrapper::KRulerWrapper(::Qt::Orientation orient, ::QWidget * parent, ::QFlags<Qt::WindowType> f) : KRuler(orient, parent, f)
{
}

KRulerWrapper::KRulerWrapper(::Qt::Orientation orient, int widgetWidth, ::QWidget * parent, ::QFlags<Qt::WindowType> f) : KRuler(orient, widgetWidth, parent, f)
{
}

void KRulerWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KRuler", funcName, gil, pyOverride, e);
}

void KRulerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KRuler", funcName, gil, pyOverride, signal);
}

void KRulerWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KRuler", funcName, gil, pyOverride, event);
}

int KRulerWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KRuler", funcName, gil, pyOverride);
}

void KRulerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KRuler", funcName, gil, pyOverride, signal);
}

void KRulerWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KRuler", funcName, gil, pyOverride, event);
}

bool KRulerWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KRuler", funcName, gil, pyOverride, e);
}

bool KRulerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KRuler", funcName, gil, pyOverride, watched, event);
}

void KRulerWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KRuler", funcName, gil, pyOverride, event);
}

bool KRulerWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KRuler", funcName, gil, pyOverride, next);
}

void KRulerWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KRuler", funcName, gil, pyOverride, event);
}

bool KRulerWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KRuler", funcName, gil, pyOverride);
}

int KRulerWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KRuler", funcName, gil, pyOverride, arg__1);
}

void KRulerWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KRuler", funcName, gil, pyOverride, painter);
}

void KRulerWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KRuler", funcName, gil, pyOverride, event);
}

::QVariant KRulerWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KRuler", funcName, gil, pyOverride, arg__1);
}

void KRulerWrapper::keyPressEvent(::QKeyEvent * ev)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::keyPressEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KRuler", funcName, gil, pyOverride, ev);
}

void KRulerWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KRuler", funcName, gil, pyOverride, event);
}

int KRulerWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KRuler", funcName, gil, pyOverride, arg__1);
}

::QSize KRulerWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KRuler", funcName, gil, pyOverride);
}

void KRulerWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KRuler", funcName, gil, pyOverride, event);
}

bool KRulerWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KRuler", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KRulerWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KRuler", funcName, gil, pyOverride);
}

void KRulerWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::KRuler::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KRuler", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KRulerWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KRuler", funcName, gil, pyOverride, offset);
}

void KRulerWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KRuler", funcName, gil, pyOverride, visible);
}

::QPainter * KRulerWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KRuler", funcName, gil, pyOverride);
}

void KRulerWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KRuler", funcName, gil, pyOverride, event);
}

::QSize KRulerWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KRuler", funcName, gil, pyOverride);
}

void KRulerWrapper::sliderChange(::QAbstractSlider::SliderChange change)
{
    static const char *funcName = "sliderChange";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::sliderChange(change);
    }
    KSelectorWrapper::sbk_o_sliderChange("KRuler", funcName, gil, pyOverride, change);
}

void KRulerWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KRuler", funcName, gil, pyOverride, event);
}

void KRulerWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::timerEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KRuler", funcName, gil, pyOverride, arg__1);
}

void KRulerWrapper::wheelEvent(::QWheelEvent * e)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRuler_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractSlider::wheelEvent(e);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KRuler", funcName, gil, pyOverride, e);
}

const QMetaObject *KRulerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KRuler::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KRulerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KRuler::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KRulerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KRulerWrapper *>(this));
    }
    return KRuler::qt_metacast(_clname);
}

KRulerWrapper::~KRulerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KRuler_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KRuler_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KRuler >()))
        return -1;

    KRulerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOOO:KRuler", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KRuler::KRuler(QWidget*=)
    // 1: KRuler::KRuler(Qt::Orientation,QWidget*=,QFlags<Qt::WindowType>=)
    // 2: KRuler::KRuler(Qt::Orientation,int,QWidget*=,QFlags<Qt::WindowType>=)
    if (numArgs == 0) {
        overloadId = 0; // KRuler(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KRuler(Qt::Orientation,QWidget*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // KRuler(Qt::Orientation,int,QWidget*,QFlags<Qt::WindowType>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // KRuler(Qt::Orientation,int,QWidget*,QFlags<Qt::WindowType>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[3])))) {
                    overloadId = 2; // KRuler(Qt::Orientation,int,QWidget*,QFlags<Qt::WindowType>)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KRuler(Qt::Orientation,QWidget*,QFlags<Qt::WindowType>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[2])))) {
                overloadId = 1; // KRuler(Qt::Orientation,QWidget*,QFlags<Qt::WindowType>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KRuler(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KRuler(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KRuler(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KRulerWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KRulerWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KRuler(Qt::Orientation orient, QWidget *parent, QFlags<Qt::WindowType> f)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 1}, {"f", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
                }
            }
            ::Qt::Orientation cppArg0 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::WindowType> cppArg2 = Qt::WindowFlags();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KRuler(Qt::Orientation,QWidget*,QFlags<Qt::WindowType>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KRulerWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KRulerWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 2: // KRuler(Qt::Orientation orient, int widgetWidth, QWidget *parent, QFlags<Qt::WindowType> f)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 2}, {"f", 3}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
                }
            }
            ::Qt::Orientation cppArg0 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QWidget *cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::WindowType> cppArg3 = Qt::WindowFlags();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KRuler(Qt::Orientation,int,QWidget*,QFlags<Qt::WindowType>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KRulerWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KRulerWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KRuler >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KRulerFunc_bigMarkDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bigMarkDistance()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->bigMarkDistance();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_endLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // endLabel()const
        QString cppResult = const_cast<const ::KRuler *>(cppSelf)->endLabel();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_endOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // endOffset()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->endOffset();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // length()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->length();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_lengthFixed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // lengthFixed()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->lengthFixed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_littleMarkDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // littleMarkDistance()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->littleMarkDistance();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_mediumMarkDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mediumMarkDistance()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->mediumMarkDistance();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_offset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // offset()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->offset();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KRuler::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_pixelPerMark(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pixelPerMark()const
        double cppResult = const_cast<const ::KRuler *>(cppSelf)->pixelPerMark();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_setBigMarkDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setBigMarkDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBigMarkDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBigMarkDistance", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBigMarkDistance(int)
            cppSelf->setBigMarkDistance(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setEndLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setEndLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setEndLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEndLabel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEndLabel(QString)
            cppSelf->setEndLabel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLength(int)
            cppSelf->setLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setLengthFixed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setLengthFixed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setLengthFixed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLengthFixed", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLengthFixed(bool)
            cppSelf->setLengthFixed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setLittleMarkDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setLittleMarkDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLittleMarkDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLittleMarkDistance", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLittleMarkDistance(int)
            cppSelf->setLittleMarkDistance(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setMediumMarkDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setMediumMarkDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMediumMarkDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMediumMarkDistance", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMediumMarkDistance(int)
            cppSelf->setMediumMarkDistance(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setOffset(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setOffset(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOffset", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOffset(int)
            cppSelf->setOffset(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setPixelPerMark(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setPixelPerMark(double)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setPixelPerMark(double)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPixelPerMark", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPixelPerMark(double)
            cppSelf->setPixelPerMark(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setRulerMetricStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setRulerMetricStyle(KRuler::MetricStyle)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_MetricStyle_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setRulerMetricStyle(KRuler::MetricStyle)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRulerMetricStyle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        ::KRuler::MetricStyle cppArg0{KRuler::Custom};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRulerMetricStyle(KRuler::MetricStyle)
            cppSelf->setRulerMetricStyle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowBigMarks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowBigMarks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowBigMarks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowBigMarks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowBigMarks(bool)
            cppSelf->setShowBigMarks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowEndLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowEndLabel(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowEndLabel(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowEndLabel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowEndLabel(bool)
            cppSelf->setShowEndLabel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowEndMarks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowEndMarks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowEndMarks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowEndMarks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowEndMarks(bool)
            cppSelf->setShowEndMarks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowLittleMarks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowLittleMarks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowLittleMarks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowLittleMarks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowLittleMarks(bool)
            cppSelf->setShowLittleMarks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowMediumMarks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowMediumMarks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowMediumMarks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowMediumMarks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowMediumMarks(bool)
            cppSelf->setShowMediumMarks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowPointer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowPointer(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowPointer(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowPointer", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowPointer(bool)
            cppSelf->setShowPointer(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setShowTinyMarks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setShowTinyMarks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowTinyMarks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowTinyMarks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowTinyMarks(bool)
            cppSelf->setShowTinyMarks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_setTinyMarkDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::setTinyMarkDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTinyMarkDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTinyMarkDistance", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTinyMarkDistance(int)
            cppSelf->setTinyMarkDistance(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_showBigMarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showBigMarks()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showBigMarks();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_showEndLabel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showEndLabel()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showEndLabel();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_showEndMarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showEndMarks()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showEndMarks();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_showLittleMarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showLittleMarks()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showLittleMarks();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_showMediumMarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showMediumMarks()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showMediumMarks();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_showPointer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showPointer()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showPointer();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_showTinyMarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showTinyMarks()const
        bool cppResult = const_cast<const ::KRuler *>(cppSelf)->showTinyMarks();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRulerFunc_slideDown(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "slideDown", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    if (PyArg_ParseTuple(args, "|O:slideDown", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KRuler::slideDown(int=)
    if (numArgs == 0) {
        overloadId = 0; // slideDown(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // slideDown(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slideDown", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"count", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "slideDown", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
            }
        }
        int cppArg0 = 1;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slideDown(int)
            cppSelf->slideDown(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_slideUp(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "slideUp", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    if (PyArg_ParseTuple(args, "|O:slideUp", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KRuler::slideUp(int=)
    if (numArgs == 0) {
        overloadId = 0; // slideUp(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // slideUp(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slideUp", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"count", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "slideUp", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
            }
        }
        int cppArg0 = 1;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slideUp(int)
            cppSelf->slideUp(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_slotEndOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::slotEndOffset(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // slotEndOffset(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotEndOffset", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotEndOffset(int)
            cppSelf->slotEndOffset(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_slotNewOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::slotNewOffset(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // slotNewOffset(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotNewOffset", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotNewOffset(int)
            cppSelf->slotNewOffset(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_slotNewValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRuler::slotNewValue(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // slotNewValue(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotNewValue", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotNewValue(int)
            cppSelf->slotNewValue(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRulerFunc_tinyMarkDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tinyMarkDistance()const
        int cppResult = const_cast<const ::KRuler *>(cppSelf)->tinyMarkDistance();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KRuler_PropertyStrings[] = {
    "bigMarkDistance::",
    "endLabel::",
    "endOffset:",
    "length::",
    "lengthFixed::",
    "littleMarkDistance::",
    "mediumMarkDistance::setBigMarkDistance",
    "offset:",
    "pixelPerMark::",
    "showBigMarks::",
    "showEndLabel::",
    "showLittleMarks::",
    "showMediumMarks::",
    "showPointer::",
    "showTinyMarks::",
    "tinyMarkDistance::",
    nullptr // Sentinel
};

static const char *Sbk_KRuler_EnumFlagInfo[] = {
    "MetricStyle:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KRuler_methods[] = {
    {"bigMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_bigMarkDistance), METH_NOARGS, nullptr},
    {"endLabel", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_endLabel), METH_NOARGS, nullptr},
    {"endOffset", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_endOffset), METH_NOARGS, nullptr},
    {"length", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_length), METH_NOARGS, nullptr},
    {"lengthFixed", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_lengthFixed), METH_NOARGS, nullptr},
    {"littleMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_littleMarkDistance), METH_NOARGS, nullptr},
    {"mediumMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_mediumMarkDistance), METH_NOARGS, nullptr},
    {"offset", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_offset), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_paintEvent), METH_O, nullptr},
    {"pixelPerMark", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_pixelPerMark), METH_NOARGS, nullptr},
    {"setBigMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setBigMarkDistance), METH_O, nullptr},
    {"setEndLabel", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setEndLabel), METH_O, nullptr},
    {"setLength", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setLength), METH_O, nullptr},
    {"setLengthFixed", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setLengthFixed), METH_O, nullptr},
    {"setLittleMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setLittleMarkDistance), METH_O, nullptr},
    {"setMediumMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setMediumMarkDistance), METH_O, nullptr},
    {"setOffset", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setOffset), METH_O, nullptr},
    {"setPixelPerMark", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setPixelPerMark), METH_O, nullptr},
    {"setRulerMetricStyle", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setRulerMetricStyle), METH_O, nullptr},
    {"setShowBigMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowBigMarks), METH_O, nullptr},
    {"setShowEndLabel", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowEndLabel), METH_O, nullptr},
    {"setShowEndMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowEndMarks), METH_O, nullptr},
    {"setShowLittleMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowLittleMarks), METH_O, nullptr},
    {"setShowMediumMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowMediumMarks), METH_O, nullptr},
    {"setShowPointer", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowPointer), METH_O, nullptr},
    {"setShowTinyMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setShowTinyMarks), METH_O, nullptr},
    {"setTinyMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_setTinyMarkDistance), METH_O, nullptr},
    {"showBigMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showBigMarks), METH_NOARGS, nullptr},
    {"showEndLabel", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showEndLabel), METH_NOARGS, nullptr},
    {"showEndMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showEndMarks), METH_NOARGS, nullptr},
    {"showLittleMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showLittleMarks), METH_NOARGS, nullptr},
    {"showMediumMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showMediumMarks), METH_NOARGS, nullptr},
    {"showPointer", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showPointer), METH_NOARGS, nullptr},
    {"showTinyMarks", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_showTinyMarks), METH_NOARGS, nullptr},
    {"slideDown", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_slideDown), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"slideUp", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_slideUp), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"slotEndOffset", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_slotEndOffset), METH_O, nullptr},
    {"slotNewOffset", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_slotNewOffset), METH_O, nullptr},
    {"slotNewValue", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_slotNewValue), METH_O, nullptr},
    {"tinyMarkDistance", reinterpret_cast<PyCFunction>(Sbk_KRulerFunc_tinyMarkDistance), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KRuler_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KRuler *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KRulerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KRuler_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KRuler_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KRulerSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KRuler *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractSlider_IDX]))
        return static_cast< ::QAbstractSlider *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KRuler_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KRuler_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KRuler_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KRuler_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KRuler_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KRuler_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KRuler_spec = {
    "1:KWidgetsAddons.KRuler",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KRuler_slots
};

} //extern "C"

static void *Sbk_KRuler_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KRuler *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KRuler *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KRuler *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KRuler_MetricStyle(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KRuler::MetricStyle>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KRuler::MetricStyle *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KRuler_MetricStyle_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRuler_MetricStyle_IDX])))
        return Enum_PythonToCpp_KRuler_MetricStyle;
    return {};
}

static PyObject *KRuler_MetricStyle_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KRuler::MetricStyle>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KRuler::MetricStyle *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KRuler_PythonToCpp_KRuler_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KRuler_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KRuler_PythonToCpp_KRuler_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KRuler_TypeF()))
        return KRuler_PythonToCpp_KRuler_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KRuler_PTR_CppToPython_KRuler(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KRuler *>(const_cast<void *>(cppIn)), Sbk_KRuler_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KRuler_SignatureStrings[] = {
    "2:KWidgetsAddons.KRuler(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,showTinyMarks:bool=None,showLittleMarks:bool=None,showMediumMarks:bool=None,showBigMarks:bool=None,showPointer:bool=None,showEndLabel:bool=None,tinyMarkDistance:int=None,littleMarkDistance:int=None,mediumMarkDistance:int=None,bigMarkDistance:int=None,pixelPerMark:double=None,lengthFixed:bool=None,endLabel:QString=None,length:int=None,offset:int=None,endOffset:int=None)",
    "1:KWidgetsAddons.KRuler(self,orient:PySide6.QtCore.Qt.Orientation,parent:PySide6.QtWidgets.QWidget=nullptr,f:PySide6.QtCore.Qt.WindowType=Qt.WindowFlags(),*:KeywordOnly=None,showTinyMarks:bool=None,showLittleMarks:bool=None,showMediumMarks:bool=None,showBigMarks:bool=None,showPointer:bool=None,showEndLabel:bool=None,tinyMarkDistance:int=None,littleMarkDistance:int=None,mediumMarkDistance:int=None,bigMarkDistance:int=None,pixelPerMark:double=None,lengthFixed:bool=None,endLabel:QString=None,length:int=None,offset:int=None,endOffset:int=None)",
    "0:KWidgetsAddons.KRuler(self,orient:PySide6.QtCore.Qt.Orientation,widgetWidth:int,parent:PySide6.QtWidgets.QWidget=nullptr,f:PySide6.QtCore.Qt.WindowType=Qt.WindowFlags(),*:KeywordOnly=None,showTinyMarks:bool=None,showLittleMarks:bool=None,showMediumMarks:bool=None,showBigMarks:bool=None,showPointer:bool=None,showEndLabel:bool=None,tinyMarkDistance:int=None,littleMarkDistance:int=None,mediumMarkDistance:int=None,bigMarkDistance:int=None,pixelPerMark:double=None,lengthFixed:bool=None,endLabel:QString=None,length:int=None,offset:int=None,endOffset:int=None)",
    "KWidgetsAddons.KRuler.bigMarkDistance(self)->int",
    "KWidgetsAddons.KRuler.endLabel(self)->QString",
    "KWidgetsAddons.KRuler.endOffset(self)->int",
    "KWidgetsAddons.KRuler.length(self)->int",
    "KWidgetsAddons.KRuler.lengthFixed(self)->bool",
    "KWidgetsAddons.KRuler.littleMarkDistance(self)->int",
    "KWidgetsAddons.KRuler.mediumMarkDistance(self)->int",
    "KWidgetsAddons.KRuler.offset(self)->int",
    "KWidgetsAddons.KRuler.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KRuler.pixelPerMark(self)->double",
    "KWidgetsAddons.KRuler.setBigMarkDistance(self,arg__1:int)",
    "KWidgetsAddons.KRuler.setEndLabel(self,arg__1:QString)",
    "KWidgetsAddons.KRuler.setLength(self,arg__1:int)",
    "KWidgetsAddons.KRuler.setLengthFixed(self,fix:bool)",
    "KWidgetsAddons.KRuler.setLittleMarkDistance(self,arg__1:int)",
    "KWidgetsAddons.KRuler.setMediumMarkDistance(self,arg__1:int)",
    "KWidgetsAddons.KRuler.setOffset(self,offset:int)",
    "KWidgetsAddons.KRuler.setPixelPerMark(self,rate:double)",
    "KWidgetsAddons.KRuler.setRulerMetricStyle(self,arg__1:KWidgetsAddons.KRuler.MetricStyle)",
    "KWidgetsAddons.KRuler.setShowBigMarks(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setShowEndLabel(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setShowEndMarks(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setShowLittleMarks(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setShowMediumMarks(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setShowPointer(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setShowTinyMarks(self,arg__1:bool)",
    "KWidgetsAddons.KRuler.setTinyMarkDistance(self,arg__1:int)",
    "KWidgetsAddons.KRuler.showBigMarks(self)->bool",
    "KWidgetsAddons.KRuler.showEndLabel(self)->bool",
    "KWidgetsAddons.KRuler.showEndMarks(self)->bool",
    "KWidgetsAddons.KRuler.showLittleMarks(self)->bool",
    "KWidgetsAddons.KRuler.showMediumMarks(self)->bool",
    "KWidgetsAddons.KRuler.showPointer(self)->bool",
    "KWidgetsAddons.KRuler.showTinyMarks(self)->bool",
    "KWidgetsAddons.KRuler.slideDown(self,count:int=1)",
    "KWidgetsAddons.KRuler.slideUp(self,count:int=1)",
    "KWidgetsAddons.KRuler.slotEndOffset(self,arg__1:int)",
    "KWidgetsAddons.KRuler.slotNewOffset(self,arg__1:int)",
    "KWidgetsAddons.KRuler.slotNewValue(self,arg__1:int)",
    "KWidgetsAddons.KRuler.tinyMarkDistance(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KRuler_SignatureByteSize = 572;
static constexpr uint8_t KRuler_SignatureBytes[572] = {
    0x78, 0xda, 0xed, 0x55, 0xc1, 0x72, 0x9b, 0x30, 0x10, 0xbd, 0xf7, 0x4b, 0xe2, 0x0e, 0x65, 0xea,
    0x1e, 0x7a, 0x60, 0xc6, 0x9d, 0x69, 0x1a, 0xa7, 0x07, 0xdb, 0x31, 0xae, 0x93, 0xe6, 0x98, 0xc1,
    0xd6, 0x42, 0x34, 0x55, 0x24, 0x46, 0x88, 0x12, 0xfe, 0xbe, 0x32, 0x02, 0x2c, 0x40, 0x80, 0x70,
    0x2f, 0x9d, 0x4e, 0x4e, 0x80, 0xf6, 0xbd, 0xdd, 0x87, 0xde, 0x6a, 0xf5, 0xc9, 0x5b, 0x3d, 0x62,
    0x14, 0x81, 0x48, 0xbe, 0x22, 0xc4, 0x68, 0xe2, 0xae, 0x7e, 0xa4, 0x04, 0xf8, 0x55, 0x02, 0x24,
    0x74, 0xe2, 0x80, 0x03, 0x15, 0x9e, 0x9f, 0xef, 0x31, 0x82, 0xcf, 0xee, 0x4e, 0x94, 0x50, 0x77,
    0xa7, 0x5e, 0x16, 0x34, 0x25, 0x24, 0x16, 0xdc, 0x79, 0xef, 0xad, 0x20, 0xcf, 0x18, 0x47, 0x5b,
    0x4a, 0xf2, 0xc5, 0x1d, 0xa3, 0xe0, 0x24, 0xcf, 0x2c, 0xbb, 0xc7, 0x34, 0xdf, 0x04, 0xfc, 0x57,
    0xe2, 0x1d, 0x18, 0x23, 0xe7, 0xf5, 0x35, 0x16, 0x82, 0x80, 0x29, 0xb2, 0x01, 0x84, 0xd3, 0x17,
    0x53, 0xe4, 0x1a, 0x47, 0xa6, 0x65, 0x9f, 0x61, 0x2a, 0x80, 0xb7, 0x56, 0x97, 0x14, 0xad, 0x83,
    0x03, 0x10, 0x6d, 0x59, 0x94, 0x5a, 0x6e, 0x70, 0x22, 0x02, 0x7a, 0x04, 0x4f, 0xf2, 0x54, 0x84,
    0xd4, 0x6a, 0xba, 0xb1, 0x97, 0x5a, 0x4f, 0x37, 0x76, 0x50, 0x8a, 0xba, 0x81, 0x18, 0xbf, 0x02,
    0xf1, 0x81, 0x9f, 0xa2, 0x1e, 0x62, 0xe9, 0x81, 0x40, 0x59, 0x09, 0x68, 0x24, 0x9e, 0x6f, 0x65,
    0x18, 0x69, 0xca, 0xa0, 0x12, 0xbb, 0xdb, 0x0b, 0x8e, 0x69, 0xa4, 0x63, 0xcf, 0x49, 0x59, 0x18,
    0x26, 0x20, 0xce, 0xdf, 0x92, 0xb5, 0x6d, 0x2e, 0xcd, 0xde, 0xcd, 0x87, 0xcc, 0x64, 0x1c, 0x37,
    0xcd, 0xfc, 0xc6, 0x38, 0xc8, 0x87, 0xbb, 0x2d, 0x02, 0x81, 0xc0, 0x8c, 0xda, 0x3b, 0x1e, 0x1a,
    0x12, 0x3d, 0x62, 0x8a, 0xa4, 0xe9, 0x79, 0x0c, 0x8b, 0xfa, 0xeb, 0x96, 0x04, 0x51, 0x72, 0x35,
    0x7b, 0xeb, 0x90, 0x7f, 0xa3, 0x43, 0x3e, 0xfe, 0x75, 0x87, 0x64, 0x05, 0x5d, 0x26, 0x51, 0xa5,
    0xdf, 0x3a, 0xe6, 0x3f, 0xef, 0x18, 0x63, 0xbf, 0xb8, 0x2d, 0x9d, 0x45, 0xff, 0xcc, 0x3e, 0x7c,
    0x91, 0xb4, 0x1e, 0x42, 0x25, 0xa8, 0x42, 0x96, 0xba, 0xfa, 0xd1, 0x4a, 0xc8, 0x78, 0x62, 0xf5,
    0x4f, 0xb6, 0xb8, 0x62, 0x9f, 0x2a, 0xf0, 0x69, 0xbb, 0xfa, 0xd0, 0x1d, 0xff, 0xc6, 0x2b, 0x74,
    0x7d, 0x1d, 0xe7, 0x30, 0xcb, 0xbf, 0x8c, 0x03, 0x19, 0x5b, 0xfe, 0x96, 0x27, 0x4d, 0x1d, 0xd5,
    0x80, 0x47, 0x4f, 0x4f, 0x73, 0xed, 0x44, 0x7d, 0x4f, 0xb1, 0xbb, 0xf3, 0x6b, 0x54, 0x9f, 0x6f,
    0x7a, 0x1b, 0x55, 0x55, 0x55, 0x37, 0xf5, 0x10, 0xa4, 0xba, 0x6b, 0x83, 0xd7, 0x95, 0x00, 0xdc,
    0x5f, 0x4a, 0x32, 0x97, 0xba, 0xe9, 0x15, 0xa5, 0x74, 0x7e, 0x80, 0xb6, 0x3e, 0x5b, 0x6a, 0x57,
    0x67, 0xdd, 0xf2, 0xd6, 0x09, 0xf1, 0x6b, 0x71, 0x18, 0x86, 0x38, 0x66, 0x87, 0xed, 0x0a, 0x6e,
    0xcc, 0x56, 0xdb, 0x91, 0xb5, 0xce, 0xd6, 0x4e, 0xe0, 0x00, 0xc1, 0x6f, 0x9b, 0xe6, 0xf0, 0x40,
    0x40, 0x39, 0x05, 0x06, 0x78, 0xc5, 0xcb, 0x06, 0xe4, 0x76, 0x1f, 0xf7, 0x22, 0x27, 0x4d, 0x8d,
    0x66, 0x96, 0x86, 0x1e, 0x48, 0xbc, 0xd7, 0x66, 0x67, 0x23, 0xe9, 0xc8, 0x9e, 0xef, 0xb5, 0x31,
    0x7a, 0x01, 0xef, 0xa2, 0x7a, 0xda, 0xbd, 0x30, 0x95, 0xaa, 0x5d, 0x1c, 0x53, 0xa9, 0xe5, 0x15,
    0x32, 0x95, 0x56, 0x5f, 0x6e, 0x53, 0x88, 0xf7, 0xad, 0x5b, 0xc8, 0xba, 0x15, 0xdb, 0x2e, 0x0e,
    0x8f, 0xc4, 0xa4, 0x6d, 0x9e, 0x15, 0x7c, 0x4a, 0xf6, 0xb6, 0x55, 0xe3, 0x8c, 0xb6, 0x43, 0xe3,
    0x0c, 0xdd, 0x98, 0x71, 0x74, 0xd3, 0x8f, 0x11, 0x3c, 0x91, 0xa3, 0xf8, 0x86, 0x65, 0x54, 0xed,
    0xff, 0x91, 0xa5, 0x54, 0xdd, 0xa3, 0xf3, 0xd9, 0x10, 0xe3, 0x21, 0x9e, 0x80, 0x67, 0xa7, 0x91,
    0xaa, 0xcf, 0x0f, 0x0b, 0x97, 0x25, 0xe9, 0x0e, 0xb2, 0x8b, 0x48, 0x3f, 0x03, 0x92, 0x5a, 0xb7,
    0x93, 0x30, 0xb5, 0x61, 0x79, 0xa9, 0xfd, 0x01, 0x72, 0x04, 0x52, 0x9d
};
#endif

PyTypeObject *init_KRuler(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX].type;

    Shiboken::AutoDecRef Sbk_KRuler_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractSlider_IDX]))));

    _Sbk_KRuler_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KRuler",
        "KRuler*",
        &Sbk_KRuler_spec,
        &Shiboken::callCppDestructor< KRuler >,
        Sbk_KRuler_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KRuler_TypeF(); // references _Sbk_KRuler_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KRuler_SignatureStrings);
#else
    InitSignatureBytes(pyType, KRuler_SignatureBytes, KRuler_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KRuler_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KRuler_PythonToCpp_KRuler_PTR,
        is_KRuler_PythonToCpp_KRuler_PTR_Convertible,
        KRuler_PTR_CppToPython_KRuler);

    Shiboken::Conversions::registerConverterName(converter, "KRuler");
    Shiboken::Conversions::registerConverterName(converter, "KRuler*");
    Shiboken::Conversions::registerConverterName(converter, "KRuler&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KRuler).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KRulerWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KRuler_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KRuler_TypeF(), &Sbk_KRulerSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KRuler_TypeF(), &Sbk_KRuler_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KRuler_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'MetricStyle'.
    const char *MetricStyle_Initializer[] = {
        "Custom",
        "Pixel",
        "Inch",
        "Millimetres",
        "Centimetres",
        "Metres",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t MetricStyle_InitializerValues[] = {
        uint8_t(KRuler::MetricStyle::Custom),      //  0x00  0
        uint8_t(KRuler::MetricStyle::Pixel),       //  0x01  1
        uint8_t(KRuler::MetricStyle::Inch),        //  0x02  2
        uint8_t(KRuler::MetricStyle::Millimetres), //  0x03  3
        uint8_t(KRuler::MetricStyle::Centimetres), //  0x04  4
        uint8_t(KRuler::MetricStyle::Metres)       //  0x05  5
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KRuler_TypeF(),
        "1:KWidgetsAddons.KRuler.MetricStyle",
        MetricStyle_Initializer, MetricStyle_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KRuler_MetricStyle_IDX].type = EType;
    // Register converter for enum 'KRuler::MetricStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KRuler_MetricStyle_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KRuler_MetricStyle,
            is_Enum_PythonToCpp_KRuler_MetricStyle_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KRuler::MetricStyle");
        Shiboken::Conversions::registerConverterAlias(converter, "MetricStyle");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'MetricStyle' enum.

    qRegisterMetaType< ::KRuler::MetricStyle >("KRuler::MetricStyle");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KRuler::staticMetaObject, sizeof(KRulerWrapper));

    return pyType;
}
