
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpagemodel_wrapper.h"

// Wrappers providing overrides
#include "kpagemodel_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QHash>
#include <QList>
#include <QMap>
#include <QStringList>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qvariant.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPageModel_Type = nullptr;
static PyTypeObject *Sbk_KPageModel_TypeF(void)
{
    return _Sbk_KPageModel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPageModelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPageModelWrapper::KPageModelWrapper(::QObject * parent) : KPageModel(parent)
{
}

::QModelIndex KPageModelWrapper::buddy(const ::QModelIndex & index) const
{
    static const char *funcName = "buddy";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::buddy(index);
    }
    return sbk_o_buddy("KPageModel", funcName, gil, pyOverride, index);
}

::QModelIndex KPageModelWrapper::sbk_o_buddy(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QModelIndex >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "canDropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canDropMimeData(data, action, row, column, parent);
    }
    return sbk_o_canDropMimeData("KPageModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool KPageModelWrapper::sbk_o_canDropMimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[5] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), data),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_DropAction_IDX])))->converter, &action),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &row),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &column),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiiN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), data),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_DropAction_IDX])))->converter, &action),
        row,
        column,
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 5, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
    Py_DECREF(pyArgArray[4]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::canFetchMore(const ::QModelIndex & parent) const
{
    static const char *funcName = "canFetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canFetchMore(parent);
    }
    return sbk_o_canFetchMore("KPageModel", funcName, gil, pyOverride, parent);
}

bool KPageModelWrapper::sbk_o_canFetchMore(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KPageModelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPageModel", funcName, gil, pyOverride, event);
}

bool KPageModelWrapper::clearItemData(const ::QModelIndex & index)
{
    static const char *funcName = "clearItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::clearItemData(index);
    }
    return KPageModelWrapper::sbk_o_canFetchMore("KPageModel", funcName, gil, pyOverride, index);
}

int KPageModelWrapper::columnCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "columnCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KPageModel.columnCount");
        return 0;
    }
    return sbk_o_columnCount("KPageModel", funcName, gil, pyOverride, parent);
}

int KPageModelWrapper::sbk_o_columnCount(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KPageModelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageModel", funcName, gil, pyOverride, signal);
}

void KPageModelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPageModel", funcName, gil, pyOverride, event);
}

::QVariant KPageModelWrapper::data(const ::QModelIndex & index, int role) const
{
    static const char *funcName = "data";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KPageModel.data");
        return ::QVariant();
    }
    return sbk_o_data("KPageModel", funcName, gil, pyOverride, index, role);
}

::QVariant KPageModelWrapper::sbk_o_data(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, int role)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &role)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(Ni)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        role
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QVariant();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

void KPageModelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageModel", funcName, gil, pyOverride, signal);
}

bool KPageModelWrapper::dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    static const char *funcName = "dropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::dropMimeData(data, action, row, column, parent);
    }
    return KPageModelWrapper::sbk_o_canDropMimeData("KPageModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool KPageModelWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPageModel", funcName, gil, pyOverride, event);
}

bool KPageModelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPageModel", funcName, gil, pyOverride, watched, event);
}

void KPageModelWrapper::fetchMore(const ::QModelIndex & parent)
{
    static const char *funcName = "fetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::fetchMore(parent);
    }
    sbk_o_fetchMore("KPageModel", funcName, gil, pyOverride, parent);
}

void KPageModelWrapper::sbk_o_fetchMore(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QFlags<Qt::ItemFlag> KPageModelWrapper::flags(const ::QModelIndex & index) const
{
    static const char *funcName = "flags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::flags(index);
    }
    return sbk_o_flags("KPageModel", funcName, gil, pyOverride, index);
}

::QFlags<Qt::ItemFlag> KPageModelWrapper::sbk_o_flags(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return QFlags<Qt::ItemFlag>(0);
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_ItemFlag_IDX])))->flagsConverter, pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QFlags<Qt::ItemFlag> >()), Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::ItemFlag>(0);
    }
    ::QFlags<Qt::ItemFlag> cppResult = QFlags<Qt::ItemFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::hasChildren(const ::QModelIndex & parent) const
{
    static const char *funcName = "hasChildren";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::hasChildren(parent);
    }
    return KPageModelWrapper::sbk_o_canFetchMore("KPageModel", funcName, gil, pyOverride, parent);
}

::QVariant KPageModelWrapper::headerData(int section, ::Qt::Orientation orientation, int role) const
{
    static const char *funcName = "headerData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::headerData(section, orientation, role);
    }
    return sbk_o_headerData("KPageModel", funcName, gil, pyOverride, section, orientation, role);
}

::QVariant KPageModelWrapper::sbk_o_headerData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int section, ::Qt::Orientation orientation, int role)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &section),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, &orientation),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &role)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iNi)",
        section,
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, &orientation),
        role
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QVariant();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndex KPageModelWrapper::index(int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "index";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KPageModel.index");
        return {};
    }
    return sbk_o_index("KPageModel", funcName, gil, pyOverride, row, column, parent);
}

::QModelIndex KPageModelWrapper::sbk_o_index(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int row, int column, const ::QModelIndex & parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &row),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &column),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
        row,
        column,
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QModelIndex >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QModelIndex cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::insertColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    }
    return sbk_o_insertColumns("KPageModel", funcName, gil, pyOverride, column, count, parent);
}

bool KPageModelWrapper::sbk_o_insertColumns(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int column, int count, const ::QModelIndex & parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &column),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &count),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iiN)",
        column,
        count,
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::insertRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageModel", funcName, gil, pyOverride, row, count, parent);
}

::QMap<int,QVariant> KPageModelWrapper::itemData(const ::QModelIndex & index) const
{
    static const char *funcName = "itemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::itemData(index);
    }
    return sbk_o_itemData("KPageModel", funcName, gil, pyOverride, index);
}

::QMap<int,QVariant> KPageModelWrapper::sbk_o_itemData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_int_QVariant_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "dict", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QMap<int,QVariant> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QList<QModelIndex> KPageModelWrapper::match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags) const
{
    static const char *funcName = "match";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    }
    return sbk_o_match("KPageModel", funcName, gil, pyOverride, start, role, value, hits, flags);
}

::QList<QModelIndex> KPageModelWrapper::sbk_o_match(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[5] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &start),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &role),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &hits),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_MatchFlag_IDX])))->flagsConverter, &flags)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiNiN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &start),
        role,
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value),
        hits,
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_MatchFlag_IDX])))->flagsConverter, &flags)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 5, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
    Py_DECREF(pyArgArray[4]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QModelIndex> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMimeData * KPageModelWrapper::mimeData(const ::QList<QModelIndex> & indexes) const
{
    static const char *funcName = "mimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::mimeData(indexes);
    }
    return sbk_o_mimeData("KPageModel", funcName, gil, pyOverride, indexes);
}

::QMimeData * KPageModelWrapper::sbk_o_mimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QList<QModelIndex> & indexes)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX], &indexes)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX], &indexes)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QMimeData >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMimeData *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

::QStringList KPageModelWrapper::mimeTypes() const
{
    static const char *funcName = "mimeTypes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::mimeTypes();
    }
    return sbk_o_mimeTypes("KPageModel", funcName, gil, pyOverride);
}

::QStringList KPageModelWrapper::sbk_o_mimeTypes(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QStringList();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
    return sbk_o_moveColumns("KPageModel", funcName, gil, pyOverride, sourceParent, sourceColumn, count, destinationParent, destinationChild);
}

bool KPageModelWrapper::sbk_o_moveColumns(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[5] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &sourceParent),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &sourceColumn),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &count),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &destinationParent),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &destinationChild)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiiNi)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &sourceParent),
        sourceColumn,
        count,
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &destinationParent),
        destinationChild
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 5, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
    Py_DECREF(pyArgArray[4]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
    return KPageModelWrapper::sbk_o_moveColumns("KPageModel", funcName, gil, pyOverride, sourceParent, sourceRow, count, destinationParent, destinationChild);
}

void KPageModelWrapper::multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const
{
    static const char *funcName = "multiData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::multiData(index, roleDataSpan);
    }
    sbk_o_multiData("KPageModel", funcName, gil, pyOverride, index, roleDataSpan);
}

void KPageModelWrapper::sbk_o_multiData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelRoleDataSpan_IDX]), &roleDataSpan)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelRoleDataSpan_IDX]), &roleDataSpan)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QModelIndex KPageModelWrapper::parent(const ::QModelIndex & child) const
{
    static const char *funcName = "parent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KPageModel.parent");
        return {};
    }
    return KPageModelWrapper::sbk_o_buddy("KPageModel", funcName, gil, pyOverride, child);
}

bool KPageModelWrapper::removeColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageModel", funcName, gil, pyOverride, column, count, parent);
}

bool KPageModelWrapper::removeRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    }
    return KPageModelWrapper::sbk_o_insertColumns("KPageModel", funcName, gil, pyOverride, row, count, parent);
}

void KPageModelWrapper::resetInternalData()
{
    static const char *funcName = "resetInternalData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::resetInternalData();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPageModel", funcName, gil, pyOverride);
}

void KPageModelWrapper::revert()
{
    static const char *funcName = "revert";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::revert();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KPageModel", funcName, gil, pyOverride);
}

::QHash<int,QByteArray> KPageModelWrapper::roleNames() const
{
    static const char *funcName = "roleNames";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::roleNames();
    }
    return sbk_o_roleNames("KPageModel", funcName, gil, pyOverride);
}

::QHash<int,QByteArray> KPageModelWrapper::sbk_o_roleNames(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QHash_int_QByteArray_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "dict", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QHash<int,QByteArray> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int KPageModelWrapper::rowCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "rowCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KPageModel.rowCount");
        return 0;
    }
    return KPageModelWrapper::sbk_o_columnCount("KPageModel", funcName, gil, pyOverride, parent);
}

bool KPageModelWrapper::setData(const ::QModelIndex & index, const ::QVariant & value, int role)
{
    static const char *funcName = "setData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setData(index, value, role);
    }
    return sbk_o_setData("KPageModel", funcName, gil, pyOverride, index, value, role);
}

bool KPageModelWrapper::sbk_o_setData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, const ::QVariant & value, int role)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &role)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNi)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value),
        role
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    static const char *funcName = "setHeaderData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }
    return sbk_o_setHeaderData("KPageModel", funcName, gil, pyOverride, section, orientation, value, role);
}

bool KPageModelWrapper::sbk_o_setHeaderData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &section),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, &orientation),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &role)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iNNi)",
        section,
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, &orientation),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value),
        role
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles)
{
    static const char *funcName = "setItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setItemData(index, roles);
    }
    return sbk_o_setItemData("KPageModel", funcName, gil, pyOverride, index, roles);
}

bool KPageModelWrapper::sbk_o_setItemData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, const ::QMap<int,QVariant> & roles)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_int_QVariant_IDX], &roles)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index),
        Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_int_QVariant_IDX], &roles)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QModelIndex KPageModelWrapper::sibling(int row, int column, const ::QModelIndex & idx) const
{
    static const char *funcName = "sibling";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sibling(row, column, idx);
    }
    return KPageModelWrapper::sbk_o_index("KPageModel", funcName, gil, pyOverride, row, column, idx);
}

void KPageModelWrapper::sort(int column, ::Qt::SortOrder order)
{
    static const char *funcName = "sort";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sort(column, order);
    }
    sbk_o_sort("KPageModel", funcName, gil, pyOverride, column, order);
}

void KPageModelWrapper::sbk_o_sort(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int column, ::Qt::SortOrder order)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &column),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_SortOrder_IDX])))->converter, &order)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iN)",
        column,
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_SortOrder_IDX])))->converter, &order)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QSize KPageModelWrapper::span(const ::QModelIndex & index) const
{
    static const char *funcName = "span";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::span(index);
    }
    return sbk_o_span("KPageModel", funcName, gil, pyOverride, index);
}

::QSize KPageModelWrapper::sbk_o_span(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &index)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QSize >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KPageModelWrapper::submit()
{
    static const char *funcName = "submit";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::submit();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPageModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> KPageModelWrapper::supportedDragActions() const
{
    static const char *funcName = "supportedDragActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDragActions();
    }
    return sbk_o_supportedDragActions("KPageModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> KPageModelWrapper::sbk_o_supportedDragActions(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return QFlags<Qt::DropAction>(0);
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_DropAction_IDX])))->flagsConverter, pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QFlags<Qt::DropAction> >()), Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::DropAction>(0);
    }
    ::QFlags<Qt::DropAction> cppResult = QFlags<Qt::DropAction>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<Qt::DropAction> KPageModelWrapper::supportedDropActions() const
{
    static const char *funcName = "supportedDropActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDropActions();
    }
    return KPageModelWrapper::sbk_o_supportedDragActions("KPageModel", funcName, gil, pyOverride);
}

void KPageModelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageModel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPageModel", funcName, gil, pyOverride, event);
}

const QMetaObject *KPageModelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPageModel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPageModelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPageModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPageModelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPageModelWrapper *>(this));
    }
    return KPageModel::qt_metacast(_clname);
}

KPageModelWrapper::~KPageModelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPageModel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPageModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KPageModel");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPageModel >()))
        return -1;

    KPageModelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KPageModel", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPageModel::KPageModel(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KPageModel(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPageModel(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPageModel(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPageModelWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPageModelWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPageModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);
    };


    return 1;
}


static const char *Sbk_KPageModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KPageModel_EnumFlagInfo[] = {
    "Role:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPageModel_methods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPageModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPageModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPageModelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPageModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPageModel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPageModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPageModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPageModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPageModel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPageModel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPageModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPageModel_spec = {
    "1:KWidgetsAddons.KPageModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPageModel_slots
};

} //extern "C"

static void *Sbk_KPageModel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPageModel *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KPageModel_Role(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPageModel::Role>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPageModel::Role *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPageModel_Role_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_Role_IDX])))
        return Enum_PythonToCpp_KPageModel_Role;
    return {};
}

static PyObject *KPageModel_Role_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPageModel::Role>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPageModel::Role *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPageModel_PythonToCpp_KPageModel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPageModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPageModel_PythonToCpp_KPageModel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPageModel_TypeF()))
        return KPageModel_PythonToCpp_KPageModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPageModel_PTR_CppToPython_KPageModel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPageModel *>(const_cast<void *>(cppIn)), Sbk_KPageModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPageModel_SignatureStrings[] = {
    "KWidgetsAddons.KPageModel(self,parent:PySide6.QtCore.QObject=nullptr)",
    nullptr}; // Sentinel
#else
static constexpr size_t KPageModel_SignatureByteSize = 78;
static constexpr uint8_t KPageModel_SignatureBytes[78] = {
    0x78, 0xda, 0xf3, 0x0e, 0xcf, 0x4c, 0x49, 0x4f, 0x2d, 0x29, 0x76, 0x4c, 0x49, 0xc9, 0xcf, 0x2b,
    0xd6, 0xf3, 0x0e, 0x48, 0x4c, 0x4f, 0xf5, 0xcd, 0x4f, 0x49, 0xcd, 0xd1, 0x28, 0x4e, 0xcd, 0x49,
    0xd3, 0x29, 0x48, 0x2c, 0x4a, 0xcd, 0x2b, 0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3,
    0x0b, 0x2c, 0x71, 0xce, 0x2f, 0x4a, 0xd5, 0x0b, 0xf4, 0x4f, 0xca, 0x4a, 0x4d, 0x2e, 0xb1, 0xcd,
    0x2b, 0xcd, 0xc9, 0x29, 0x28, 0x29, 0xd2, 0xe4, 0x02, 0x00, 0x95, 0x0d, 0x19, 0x7c
};
#endif

PyTypeObject *init_KPageModel(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX].type;

    Shiboken::AutoDecRef Sbk_KPageModel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]))));

    _Sbk_KPageModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPageModel",
        "KPageModel*",
        &Sbk_KPageModel_spec,
        &Shiboken::callCppDestructor< KPageModel >,
        Sbk_KPageModel_Type_bases.object(),
        0);
    auto *pyType = Sbk_KPageModel_TypeF(); // references _Sbk_KPageModel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPageModel_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPageModel_SignatureBytes, KPageModel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPageModel_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPageModel_PythonToCpp_KPageModel_PTR,
        is_KPageModel_PythonToCpp_KPageModel_PTR_Convertible,
        KPageModel_PTR_CppToPython_KPageModel);

    Shiboken::Conversions::registerConverterName(converter, "KPageModel");
    Shiboken::Conversions::registerConverterName(converter, "KPageModel*");
    Shiboken::Conversions::registerConverterName(converter, "KPageModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPageModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPageModelWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPageModel_TypeF(), &Sbk_KPageModel_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KPageModel_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Role'.
    const char *Role_Initializer[] = {
        "HeaderRole",
        "WidgetRole",
        "HeaderVisibleRole",
        "ActionsRole",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t Role_InitializerValues[] = {
        uint16_t(KPageModel::Role::HeaderRole),        //  0x0101  257
        uint16_t(KPageModel::Role::WidgetRole),        //  0x0102  258
        uint16_t(KPageModel::Role::HeaderVisibleRole), //  0x0103  259
        uint16_t(KPageModel::Role::ActionsRole)        //  0x0104  260
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPageModel_TypeF(),
        "1:KWidgetsAddons.KPageModel.Role",
        Role_Initializer, Role_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_Role_IDX].type = EType;
    // Register converter for enum 'KPageModel::Role'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPageModel_Role_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPageModel_Role,
            is_Enum_PythonToCpp_KPageModel_Role_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPageModel::Role");
        Shiboken::Conversions::registerConverterAlias(converter, "Role");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Role' enum.

    qRegisterMetaType< ::KPageModel::Role >("KPageModel::Role");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPageModel::staticMetaObject, sizeof(KPageModelWrapper));

    return pyType;
}
