
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kcolumnresizer_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qlayout.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KColumnResizer_Type = nullptr;
static PyTypeObject *Sbk_KColumnResizer_TypeF(void)
{
    return _Sbk_KColumnResizer_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KColumnResizerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KColumnResizerWrapper::KColumnResizerWrapper(::QObject * parent) : KColumnResizer(parent)
{
}

void KColumnResizerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KColumnResizer", funcName, gil, pyOverride, event);
}

void KColumnResizerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KColumnResizer", funcName, gil, pyOverride, signal);
}

void KColumnResizerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KColumnResizer", funcName, gil, pyOverride, event);
}

void KColumnResizerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KColumnResizer", funcName, gil, pyOverride, signal);
}

bool KColumnResizerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KColumnResizer", funcName, gil, pyOverride, event);
}

bool KColumnResizerWrapper::eventFilter(::QObject * arg__1, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KColumnResizer::eventFilter(arg__1, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KColumnResizer", funcName, gil, pyOverride, arg__1, event);
}

void KColumnResizerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColumnResizer_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KColumnResizer", funcName, gil, pyOverride, event);
}

const QMetaObject *KColumnResizerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KColumnResizer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KColumnResizerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KColumnResizer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KColumnResizerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KColumnResizerWrapper *>(this));
    }
    return KColumnResizer::qt_metacast(_clname);
}

KColumnResizerWrapper::~KColumnResizerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KColumnResizer_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KColumnResizer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KColumnResizer >()))
        return -1;

    KColumnResizerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KColumnResizer", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KColumnResizer::KColumnResizer(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KColumnResizer(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KColumnResizer(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KColumnResizer(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KColumnResizerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KColumnResizerWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KColumnResizer >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KColumnResizerFunc_addWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColumnResizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KColumnResizer::addWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // addWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addWidget(QWidget*)
            cppSelf->addWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KColumnResizerFunc_addWidgetsFromLayout(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColumnResizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addWidgetsFromLayout", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addWidgetsFromLayout", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KColumnResizer::addWidgetsFromLayout(QLayout*,int=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLayout_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addWidgetsFromLayout(QLayout*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // addWidgetsFromLayout(QLayout*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addWidgetsFromLayout", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"column", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addWidgetsFromLayout", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QLayout *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addWidgetsFromLayout(QLayout*,int)
            cppSelf->addWidgetsFromLayout(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KColumnResizerFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColumnResizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KColumnResizer::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KColumnResizerFunc_removeWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColumnResizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KColumnResizer::removeWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // removeWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeWidget(QWidget*)
            cppSelf->removeWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KColumnResizer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KColumnResizer_methods[] = {
    {"addWidget", reinterpret_cast<PyCFunction>(Sbk_KColumnResizerFunc_addWidget), METH_O, nullptr},
    {"addWidgetsFromLayout", reinterpret_cast<PyCFunction>(Sbk_KColumnResizerFunc_addWidgetsFromLayout), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KColumnResizerFunc_eventFilter), METH_VARARGS, nullptr},
    {"removeWidget", reinterpret_cast<PyCFunction>(Sbk_KColumnResizerFunc_removeWidget), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KColumnResizer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KColumnResizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KColumnResizerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KColumnResizer_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KColumnResizer_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KColumnResizer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KColumnResizer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KColumnResizer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KColumnResizer_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KColumnResizer_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KColumnResizer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KColumnResizer_spec = {
    "1:KWidgetsAddons.KColumnResizer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KColumnResizer_slots
};

} //extern "C"

static void *Sbk_KColumnResizer_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KColumnResizer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KColumnResizer_PythonToCpp_KColumnResizer_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KColumnResizer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KColumnResizer_PythonToCpp_KColumnResizer_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KColumnResizer_TypeF()))
        return KColumnResizer_PythonToCpp_KColumnResizer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KColumnResizer_PTR_CppToPython_KColumnResizer(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KColumnResizer *>(const_cast<void *>(cppIn)), Sbk_KColumnResizer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KColumnResizer_SignatureStrings[] = {
    "KWidgetsAddons.KColumnResizer(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KWidgetsAddons.KColumnResizer.addWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KColumnResizer.addWidgetsFromLayout(self,layout:PySide6.QtWidgets.QLayout,column:int=0)",
    "KWidgetsAddons.KColumnResizer.eventFilter(self,arg__1:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KColumnResizer.removeWidget(self,widget:PySide6.QtWidgets.QWidget)",
    nullptr}; // Sentinel
#else
static constexpr size_t KColumnResizer_SignatureByteSize = 181;
static constexpr uint8_t KColumnResizer_SignatureBytes[181] = {
    0x78, 0xda, 0x95, 0x90, 0xcd, 0x0a, 0xc2, 0x30, 0x10, 0x84, 0xef, 0x3e, 0x89, 0x85, 0x1a, 0xf4,
    0xe2, 0xa1, 0x50, 0x41, 0x8a, 0xbd, 0x54, 0xd0, 0xea, 0xc1, 0x63, 0x49, 0x9b, 0xb5, 0x44, 0xd2,
    0x6c, 0x49, 0xd2, 0x4a, 0x7d, 0x7a, 0x35, 0xa9, 0x20, 0xf8, 0x53, 0xbd, 0x0d, 0xbb, 0xb3, 0xdf,
    0xb0, 0x93, 0x1c, 0x38, 0x2b, 0xc1, 0xe8, 0x25, 0x63, 0x28, 0x35, 0x49, 0x22, 0x14, 0x4d, 0x25,
    0x77, 0xa0, 0xf9, 0x05, 0xd4, 0x58, 0x83, 0x38, 0xfa, 0x35, 0x55, 0x20, 0x4d, 0xb0, 0xed, 0xf6,
    0x9c, 0xc1, 0x9c, 0xa4, 0x26, 0x42, 0x05, 0x24, 0xdd, 0xe4, 0x27, 0x28, 0x4c, 0x28, 0x1b, 0x21,
    0x6a, 0xa3, 0xbc, 0x51, 0xf2, 0x8d, 0x44, 0x28, 0x63, 0x6e, 0xef, 0x98, 0x67, 0xab, 0x9f, 0x98,
    0xfd, 0x31, 0x49, 0x9d, 0xf8, 0x19, 0xa7, 0x63, 0x85, 0xd5, 0x9a, 0x76, 0xd8, 0xf4, 0x64, 0x61,
    0xf5, 0x3b, 0xb2, 0x73, 0xf9, 0x85, 0x05, 0x05, 0x5c, 0x9a, 0x70, 0x3a, 0x14, 0x03, 0xed, 0xed,
    0xf3, 0x98, 0x0b, 0xf3, 0xe8, 0x82, 0xaa, 0x32, 0xcb, 0x66, 0x1f, 0xba, 0xf0, 0xad, 0xfd, 0x65,
    0xb9, 0xba, 0x4f, 0xbd, 0xc9, 0x22, 0x47, 0x14, 0x03, 0x79, 0x0a, 0x2a, 0x6c, 0xe1, 0xbf, 0xa2,
    0xae, 0x39, 0xe3, 0xa6, 0x13
};
#endif

PyTypeObject *init_KColumnResizer(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX].type;

    Shiboken::AutoDecRef Sbk_KColumnResizer_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KColumnResizer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KColumnResizer",
        "KColumnResizer*",
        &Sbk_KColumnResizer_spec,
        &Shiboken::callCppDestructor< KColumnResizer >,
        Sbk_KColumnResizer_Type_bases.object(),
        0);
    auto *pyType = Sbk_KColumnResizer_TypeF(); // references _Sbk_KColumnResizer_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KColumnResizer_SignatureStrings);
#else
    InitSignatureBytes(pyType, KColumnResizer_SignatureBytes, KColumnResizer_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KColumnResizer_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KColumnResizer_PythonToCpp_KColumnResizer_PTR,
        is_KColumnResizer_PythonToCpp_KColumnResizer_PTR_Convertible,
        KColumnResizer_PTR_CppToPython_KColumnResizer);

    Shiboken::Conversions::registerConverterName(converter, "KColumnResizer");
    Shiboken::Conversions::registerConverterName(converter, "KColumnResizer*");
    Shiboken::Conversions::registerConverterName(converter, "KColumnResizer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KColumnResizer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KColumnResizerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KColumnResizer_TypeF(), &Sbk_KColumnResizer_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KColumnResizer::staticMetaObject, sizeof(KColumnResizerWrapper));

    return pyType;
}
