
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kbusyindicatorwidget_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KBusyIndicatorWidget_Type = nullptr;
static PyTypeObject *Sbk_KBusyIndicatorWidget_TypeF(void)
{
    return _Sbk_KBusyIndicatorWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KBusyIndicatorWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KBusyIndicatorWidgetWrapper::KBusyIndicatorWidgetWrapper(::QWidget * parent) : KBusyIndicatorWidget(parent)
{
}

void KBusyIndicatorWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KBusyIndicatorWidget", funcName, gil, pyOverride, signal);
}

void KBusyIndicatorWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

int KBusyIndicatorWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KBusyIndicatorWidget", funcName, gil, pyOverride);
}

void KBusyIndicatorWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KBusyIndicatorWidget", funcName, gil, pyOverride, signal);
}

void KBusyIndicatorWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

bool KBusyIndicatorWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KBusyIndicatorWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

bool KBusyIndicatorWidgetWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KBusyIndicatorWidget", funcName, gil, pyOverride, watched, event);
}

void KBusyIndicatorWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

bool KBusyIndicatorWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KBusyIndicatorWidget", funcName, gil, pyOverride, next);
}

void KBusyIndicatorWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

bool KBusyIndicatorWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KBusyIndicatorWidget", funcName, gil, pyOverride);
}

int KBusyIndicatorWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KBusyIndicatorWidget", funcName, gil, pyOverride, arg__1);
}

void KBusyIndicatorWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::KBusyIndicatorWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KBusyIndicatorWidget", funcName, gil, pyOverride, painter);
}

void KBusyIndicatorWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

::QVariant KBusyIndicatorWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KBusyIndicatorWidget", funcName, gil, pyOverride, arg__1);
}

void KBusyIndicatorWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

int KBusyIndicatorWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KBusyIndicatorWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KBusyIndicatorWidgetWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::KBusyIndicatorWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KBusyIndicatorWidget", funcName, gil, pyOverride);
}

void KBusyIndicatorWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

bool KBusyIndicatorWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KBusyIndicatorWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KBusyIndicatorWidget", funcName, gil, pyOverride);
}

void KBusyIndicatorWidgetWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::KBusyIndicatorWidget::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KBusyIndicatorWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KBusyIndicatorWidget", funcName, gil, pyOverride, offset);
}

void KBusyIndicatorWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::KBusyIndicatorWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KBusyIndicatorWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KBusyIndicatorWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KBusyIndicatorWidget", funcName, gil, pyOverride);
}

void KBusyIndicatorWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::KBusyIndicatorWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

::QSize KBusyIndicatorWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KBusyIndicatorWidget", funcName, gil, pyOverride);
}

void KBusyIndicatorWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

void KBusyIndicatorWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KBusyIndicatorWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KBusyIndicatorWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KBusyIndicatorWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KBusyIndicatorWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KBusyIndicatorWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KBusyIndicatorWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KBusyIndicatorWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KBusyIndicatorWidgetWrapper *>(this));
    }
    return KBusyIndicatorWidget::qt_metacast(_clname);
}

KBusyIndicatorWidgetWrapper::~KBusyIndicatorWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KBusyIndicatorWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KBusyIndicatorWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KBusyIndicatorWidget >()))
        return -1;

    KBusyIndicatorWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KBusyIndicatorWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KBusyIndicatorWidget::KBusyIndicatorWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KBusyIndicatorWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KBusyIndicatorWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KBusyIndicatorWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KBusyIndicatorWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KBusyIndicatorWidgetWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KBusyIndicatorWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KBusyIndicatorWidget::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_hideEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::hideEvent(QHideEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QHideEvent_IDX]), (pyArg)))) {
        overloadId = 0; // hideEvent(QHideEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hideEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHideEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // hideEvent(QHideEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KBusyIndicatorWidget::hideEvent(cppArg0)
                : cppSelf->hideEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_isRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRunning()const
        bool cppResult = const_cast<const ::KBusyIndicatorWidget *>(cppSelf)->isRunning();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KBusyIndicatorWidget *>(cppSelf)->::KBusyIndicatorWidget::minimumSizeHint()
            : const_cast<const ::KBusyIndicatorWidget *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KBusyIndicatorWidget::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KBusyIndicatorWidget::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_setRunning(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setRunning", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    if (PyArg_ParseTuple(args, "|O:setRunning", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KBusyIndicatorWidget::setRunning(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setRunning(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setRunning(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setRunning", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"enable", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setRunning", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRunning(bool)
            cppSelf->setRunning(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QShowEvent_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KBusyIndicatorWidget::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KBusyIndicatorWidgetFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stop()
        cppSelf->stop();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KBusyIndicatorWidget_PropertyStrings[] = {
    "isRunning::setRunning",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KBusyIndicatorWidget_methods[] = {
    {"event", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_event), METH_O, nullptr},
    {"hideEvent", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_hideEvent), METH_O, nullptr},
    {"isRunning", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_isRunning), METH_NOARGS, nullptr},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_paintEvent), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_resizeEvent), METH_O, nullptr},
    {"setRunning", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_setRunning), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_showEvent), METH_O, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_start), METH_NOARGS, nullptr},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_KBusyIndicatorWidgetFunc_stop), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KBusyIndicatorWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KBusyIndicatorWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KBusyIndicatorWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KBusyIndicatorWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KBusyIndicatorWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KBusyIndicatorWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KBusyIndicatorWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KBusyIndicatorWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KBusyIndicatorWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KBusyIndicatorWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KBusyIndicatorWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KBusyIndicatorWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KBusyIndicatorWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KBusyIndicatorWidget_spec = {
    "1:KWidgetsAddons.KBusyIndicatorWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KBusyIndicatorWidget_slots
};

} //extern "C"

static void *Sbk_KBusyIndicatorWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KBusyIndicatorWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KBusyIndicatorWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KBusyIndicatorWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KBusyIndicatorWidget_PythonToCpp_KBusyIndicatorWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KBusyIndicatorWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KBusyIndicatorWidget_PythonToCpp_KBusyIndicatorWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KBusyIndicatorWidget_TypeF()))
        return KBusyIndicatorWidget_PythonToCpp_KBusyIndicatorWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KBusyIndicatorWidget_PTR_CppToPython_KBusyIndicatorWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KBusyIndicatorWidget *>(const_cast<void *>(cppIn)), Sbk_KBusyIndicatorWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KBusyIndicatorWidget_SignatureStrings[] = {
    "KWidgetsAddons.KBusyIndicatorWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,isRunning:bool=None)",
    "KWidgetsAddons.KBusyIndicatorWidget.event(self,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KBusyIndicatorWidget.hideEvent(self,event:PySide6.QtGui.QHideEvent)",
    "KWidgetsAddons.KBusyIndicatorWidget.isRunning(self)->bool",
    "KWidgetsAddons.KBusyIndicatorWidget.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KBusyIndicatorWidget.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KBusyIndicatorWidget.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KBusyIndicatorWidget.setRunning(self,enable:bool=true)",
    "KWidgetsAddons.KBusyIndicatorWidget.showEvent(self,event:PySide6.QtGui.QShowEvent)",
    "KWidgetsAddons.KBusyIndicatorWidget.start(self)",
    "KWidgetsAddons.KBusyIndicatorWidget.stop(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KBusyIndicatorWidget_SignatureByteSize = 254;
static constexpr uint8_t KBusyIndicatorWidget_SignatureBytes[254] = {
    0x78, 0xda, 0x95, 0x52, 0x4b, 0x4b, 0xc3, 0x40, 0x10, 0xbe, 0xfb, 0x4b, 0x6c, 0x89, 0x0b, 0x5e,
    0x7a, 0x08, 0x54, 0x50, 0x29, 0x56, 0x02, 0xda, 0x34, 0x07, 0x8f, 0x65, 0xeb, 0x8e, 0xe9, 0xc0,
    0x66, 0x26, 0xec, 0xc3, 0x12, 0x7f, 0xbd, 0x9b, 0x47, 0x6b, 0x28, 0x48, 0xb6, 0xb7, 0x61, 0xf6,
    0x9b, 0xef, 0x31, 0x3b, 0xd9, 0x07, 0xaa, 0x12, 0x9c, 0x7d, 0x54, 0x8a, 0xc9, 0x8a, 0xec, 0xc9,
    0xdb, 0xe6, 0x95, 0x14, 0x7e, 0x4a, 0xc7, 0xa6, 0x7f, 0xbb, 0xb5, 0xa0, 0xbf, 0x92, 0x5a, 0x1a,
    0x20, 0x97, 0x6e, 0x9a, 0x02, 0x15, 0x2c, 0x44, 0xee, 0x86, 0x41, 0x91, 0xf7, 0xc5, 0x92, 0xbc,
    0xd6, 0xb5, 0x33, 0xc9, 0x3c, 0xcd, 0xa0, 0x39, 0xb2, 0x51, 0xef, 0xa4, 0x9b, 0xe5, 0x1b, 0x13,
    0x24, 0x68, 0xb7, 0x9e, 0x08, 0xa9, 0x4c, 0xf7, 0xcc, 0xba, 0xeb, 0xcd, 0x6e, 0xb2, 0x69, 0x65,
    0x01, 0xdf, 0x41, 0xb3, 0xd7, 0xef, 0xca, 0x91, 0xfc, 0x33, 0x1b, 0x10, 0xf9, 0xaa, 0xed, 0xce,
    0xee, 0x1e, 0x5a, 0xde, 0x28, 0xc6, 0x43, 0x18, 0x5f, 0xfd, 0xcf, 0xfa, 0xe2, 0x51, 0xe4, 0xeb,
    0x13, 0x26, 0xce, 0xe4, 0x39, 0x5d, 0x47, 0x79, 0x8d, 0x99, 0x0a, 0x09, 0x2b, 0x5f, 0x15, 0xf8,
    0x03, 0x6b, 0x1c, 0x2c, 0x85, 0xf9, 0xcb, 0x90, 0xed, 0x7b, 0x14, 0x5f, 0x2d, 0x03, 0xcb, 0x28,
    0x9d, 0x34, 0xe5, 0x6e, 0x77, 0x7f, 0x19, 0x6f, 0x73, 0x46, 0xc5, 0xe5, 0x33, 0x60, 0x83, 0x81,
    0xa9, 0xa5, 0x6d, 0xff, 0x50, 0x71, 0xb4, 0x16, 0xdc, 0x78, 0x6f, 0x09, 0x90, 0xdc, 0x6b, 0xe8,
    0x2f, 0xc4, 0x19, 0x1f, 0x79, 0x21, 0xf6, 0xc0, 0xc7, 0x29, 0x6b, 0xc5, 0x09, 0x13, 0x49, 0xe9,
    0xa4, 0x19, 0xfe, 0x22, 0x12, 0xcf, 0xf5, 0x00, 0xff, 0x05, 0xca, 0xc2, 0x3a, 0x1b
};
#endif

PyTypeObject *init_KBusyIndicatorWidget(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KBusyIndicatorWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KBusyIndicatorWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KBusyIndicatorWidget",
        "KBusyIndicatorWidget*",
        &Sbk_KBusyIndicatorWidget_spec,
        &Shiboken::callCppDestructor< KBusyIndicatorWidget >,
        Sbk_KBusyIndicatorWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KBusyIndicatorWidget_TypeF(); // references _Sbk_KBusyIndicatorWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KBusyIndicatorWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KBusyIndicatorWidget_SignatureBytes, KBusyIndicatorWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KBusyIndicatorWidget_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KBusyIndicatorWidget_PythonToCpp_KBusyIndicatorWidget_PTR,
        is_KBusyIndicatorWidget_PythonToCpp_KBusyIndicatorWidget_PTR_Convertible,
        KBusyIndicatorWidget_PTR_CppToPython_KBusyIndicatorWidget);

    Shiboken::Conversions::registerConverterName(converter, "KBusyIndicatorWidget");
    Shiboken::Conversions::registerConverterName(converter, "KBusyIndicatorWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KBusyIndicatorWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KBusyIndicatorWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KBusyIndicatorWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KBusyIndicatorWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KBusyIndicatorWidget_TypeF(), &Sbk_KBusyIndicatorWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KBusyIndicatorWidget_TypeF(), &Sbk_KBusyIndicatorWidget_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KBusyIndicatorWidget::staticMetaObject, sizeof(KBusyIndicatorWidgetWrapper));

    return pyType;
}
