
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kunitconversion_python.h"

// main header
#include "kunitconversion_value_wrapper.h"

// Argument includes
#include <QString>
#include <qchar.h>
#include <unit.h>
#include <value.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KUnitConversion;

extern "C" {
static PyTypeObject *_Sbk_KUnitConversion_Value_Type = nullptr;
static PyTypeObject *Sbk_KUnitConversion_Value_TypeF(void)
{
    return _Sbk_KUnitConversion_Value_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUnitConversion_Value_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUnitConversion::Value >()))
        return -1;

    ::KUnitConversion::Value *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Value", 0, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Value::Value()
    // 1: Value::Value(KUnitConversion::Value)
    // 2: Value::Value(QVariant,QString)
    // 3: Value::Value(qreal,KUnitConversion::UnitId)
    // 4: Value::Value(qreal,KUnitConversion::Unit)
    // 5: Value::Value(qreal,QString)
    if (numArgs == 0) {
        overloadId = 0; // Value()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 5; // Value(qreal,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArgs[1])))) {
            overloadId = 4; // Value(qreal,KUnitConversion::Unit)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 3; // Value(qreal,KUnitConversion::UnitId)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Value(KUnitConversion::Value)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 2; // Value(QVariant,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Value()
        {

            // Value()
            cptr = new ::KUnitConversion::Value();
            break;
        }
        case 1: // Value(const KUnitConversion::Value &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Value(KUnitConversion::Value)
                cptr = new ::KUnitConversion::Value(*cppArg0);
            }
            break;
        }
        case 2: // Value(const QVariant &number, const QString &unitString)
        {
            ::QVariant cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Value(QVariant,QString)
                cptr = new ::KUnitConversion::Value(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // Value(qreal number, KUnitConversion::UnitId unitId)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KUnitConversion::UnitId cppArg1{KUnitConversion::NoUnit};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Value(qreal,KUnitConversion::UnitId)
                cptr = new ::KUnitConversion::Value(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // Value(qreal number, const KUnitConversion::Unit &unit)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::KUnitConversion::Unit *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Value(qreal,KUnitConversion::Unit)
                cptr = new ::KUnitConversion::Value(cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // Value(qreal number, const QString &unitString)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Value(qreal,QString)
                cptr = new ::KUnitConversion::Value(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUnitConversion::Value >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUnitConversion_ValueFunc_convertTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Value::convertTo(KUnitConversion::UnitId)const->KUnitConversion::Value
    // 1: Value::convertTo(KUnitConversion::Unit)const->KUnitConversion::Value
    // 2: Value::convertTo(QString)const->KUnitConversion::Value
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 2; // convertTo(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArg)))) {
        overloadId = 1; // convertTo(KUnitConversion::Unit)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // convertTo(KUnitConversion::UnitId)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "convertTo", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // convertTo(KUnitConversion::UnitId unit) const
        {
            ::KUnitConversion::UnitId cppArg0{KUnitConversion::NoUnit};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convertTo(KUnitConversion::UnitId)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::Value *>(cppSelf)->convertTo(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
        case 1: // convertTo(const KUnitConversion::Unit &unit) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::KUnitConversion::Unit *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convertTo(KUnitConversion::Unit)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::Value *>(cppSelf)->convertTo(*cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
        case 2: // convertTo(const QString &unit) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convertTo(QString)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::Value *>(cppSelf)->convertTo(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KUnitConversion::Value *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KUnitConversion::Value *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_number(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // number()const
        qreal cppResult = const_cast<const ::KUnitConversion::Value *>(cppSelf)->number();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_round(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Value::round(uint)->KUnitConversion::Value&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // round(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "round", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // round(uint)
            KUnitConversion::Value & cppResult = cppSelf->round(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Value::swap(KUnitConversion::Value&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), (pyArg)))) {
        overloadId = 0; // swap(KUnitConversion::Value&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "swap", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KUnitConversion::Value *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // swap(KUnitConversion::Value&)
            cppSelf->swap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUnitConversion_ValueFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "toString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:toString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Value::toString(int=,char=,int=,const QChar&=)const->QString
    if (numArgs == 0) {
        overloadId = 0; // toString(int,char,int,QChar)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toString(int,char,int,QChar)const
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toString(int,char,int,QChar)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // toString(int,char,int,QChar)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[3])))) {
                    overloadId = 0; // toString(int,char,int,QChar)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "toString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"fieldWidth", 0}, {"format", 1}, {"precision", 2}, {"fillChar", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "toString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        char cppArg1 = 'g';
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = -1;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QChar cppArg3 = QLatin1Char(' ');
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toString(int,char,int,QChar)const
            QString cppResult = const_cast<const ::KUnitConversion::Value *>(cppSelf)->toString(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_toSymbolString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "toSymbolString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:toSymbolString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Value::toSymbolString(int=,char=,int=,const QChar&=)const->QString
    if (numArgs == 0) {
        overloadId = 0; // toSymbolString(int,char,int,QChar)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toSymbolString(int,char,int,QChar)const
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toSymbolString(int,char,int,QChar)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // toSymbolString(int,char,int,QChar)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[3])))) {
                    overloadId = 0; // toSymbolString(int,char,int,QChar)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "toSymbolString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"fieldWidth", 0}, {"format", 1}, {"precision", 2}, {"fillChar", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "toSymbolString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]);
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        char cppArg1 = 'g';
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = -1;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QChar cppArg3 = QLatin1Char(' ');
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toSymbolString(int,char,int,QChar)const
            QString cppResult = const_cast<const ::KUnitConversion::Value *>(cppSelf)->toSymbolString(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_ValueFunc_unit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // unit()const
        KUnitConversion::Unit* cppResult = new KUnitConversion::Unit(const_cast<const ::KUnitConversion::Value *>(cppSelf)->unit());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KUnitConversion_Value_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUnitConversion_Value_methods[] = {
    {"convertTo", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_convertTo), METH_O, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_isNull), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_isValid), METH_NOARGS, nullptr},
    {"number", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_number), METH_NOARGS, nullptr},
    {"round", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_round), METH_O, nullptr},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_swap), METH_O, nullptr},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_toString), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"toSymbolString", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_toSymbolString), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"unit", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_ValueFunc_unit), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KUnitConversion_Value_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUnitConversion::Value *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), (pyArg)))) {
                // operator!=(const KUnitConversion::Value &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUnitConversion::Value *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), (pyArg)))) {
                // operator==(const KUnitConversion::Value &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUnitConversion::Value *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static int Sbk_KUnitConversion_Value_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUnitConversion_Value_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUnitConversion_Value_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUnitConversion_Value_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUnitConversion_Value_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KUnitConversion_Value_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUnitConversion_Value_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUnitConversion_Value_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUnitConversion_Value_spec = {
    "1:KUnitConversion.KUnitConversion.Value",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUnitConversion_Value_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Value_PythonToCpp_Value_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUnitConversion_Value_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Value_PythonToCpp_Value_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUnitConversion_Value_TypeF()))
        return Value_PythonToCpp_Value_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Value_PTR_CppToPython_Value(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUnitConversion_Value_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUnitConversion_Value_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUnitConversion_Value_SignatureStrings[] = {
    "5:KUnitConversion.KUnitConversion.Value(self)",
    "4:KUnitConversion.KUnitConversion.Value(self,other:KUnitConversion.KUnitConversion.Value)",
    "3:KUnitConversion.KUnitConversion.Value(self,number:QVariant,unitString:QString)",
    "2:KUnitConversion.KUnitConversion.Value(self,number:qreal,unitId:KUnitConversion.KUnitConversion.UnitId)",
    "1:KUnitConversion.KUnitConversion.Value(self,number:qreal,unit:KUnitConversion.KUnitConversion.Unit)",
    "0:KUnitConversion.KUnitConversion.Value(self,number:qreal,unitString:QString)",
    "2:KUnitConversion.KUnitConversion.Value.convertTo(self,unit:KUnitConversion.KUnitConversion.UnitId)->KUnitConversion.KUnitConversion.Value",
    "1:KUnitConversion.KUnitConversion.Value.convertTo(self,unit:KUnitConversion.KUnitConversion.Unit)->KUnitConversion.KUnitConversion.Value",
    "0:KUnitConversion.KUnitConversion.Value.convertTo(self,unit:QString)->KUnitConversion.KUnitConversion.Value",
    "KUnitConversion.KUnitConversion.Value.isNull(self)->bool",
    "KUnitConversion.KUnitConversion.Value.isValid(self)->bool",
    "KUnitConversion.KUnitConversion.Value.number(self)->qreal",
    "KUnitConversion.KUnitConversion.Value.round(self,decimals:uint)->KUnitConversion.KUnitConversion.Value",
    "KUnitConversion.KUnitConversion.Value.swap(self,other:KUnitConversion.KUnitConversion.Value)",
    "KUnitConversion.KUnitConversion.Value.toString(self,fieldWidth:int=0,format:char='g',precision:int=-1,fillChar:QChar=QLatin1Char(' '))->QString",
    "KUnitConversion.KUnitConversion.Value.toSymbolString(self,fieldWidth:int=0,format:char='g',precision:int=-1,fillChar:QChar=QLatin1Char(' '))->QString",
    "KUnitConversion.KUnitConversion.Value.unit(self)->KUnitConversion.KUnitConversion.Unit",
    "KUnitConversion.KUnitConversion.Value.__ne__(self,other:KUnitConversion.KUnitConversion.Value)->bool",
    "KUnitConversion.KUnitConversion.Value.__eq__(self,other:KUnitConversion.KUnitConversion.Value)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KUnitConversion_Value_SignatureByteSize = 316;
static constexpr uint8_t KUnitConversion_Value_SignatureBytes[316] = {
    0x78, 0xda, 0xcd, 0x54, 0x4d, 0x6f, 0x84, 0x20, 0x14, 0xbc, 0xf3, 0x2b, 0x7a, 0x73, 0x49, 0x74,
    0xa3, 0xfd, 0xb8, 0x90, 0xb8, 0x97, 0x3d, 0x35, 0x6d, 0x9a, 0x98, 0x76, 0xb7, 0x47, 0x82, 0x8a,
    0x2b, 0x09, 0xc2, 0x2e, 0x42, 0x9b, 0xfe, 0xfb, 0xa2, 0xd4, 0x4b, 0x2f, 0x7d, 0xea, 0x1e, 0x7a,
    0x11, 0x95, 0x37, 0x33, 0x8f, 0x61, 0xe0, 0x81, 0x3c, 0x1d, 0x94, 0xb0, 0x7b, 0xad, 0x3e, 0xb8,
    0xe9, 0x85, 0x56, 0xdb, 0xdf, 0xdf, 0x47, 0x26, 0x1d, 0xdf, 0xf4, 0x5c, 0x36, 0x18, 0xdd, 0xcf,
    0xa8, 0x8e, 0xb5, 0x6d, 0xb9, 0x81, 0x01, 0x30, 0xba, 0x9b, 0xc3, 0xac, 0x5c, 0x57, 0x7a, 0xea,
    0xe2, 0xc8, 0x8c, 0x60, 0xca, 0xc6, 0xce, 0x57, 0xbe, 0x5a, 0x23, 0xd4, 0x89, 0x14, 0x61, 0xc4,
    0xe8, 0x76, 0x01, 0xe1, 0xc5, 0x70, 0x26, 0x47, 0xb6, 0xc7, 0xfa, 0x4f, 0xf8, 0x61, 0x2c, 0xc3,
    0x28, 0x5b, 0x25, 0x04, 0x92, 0xc1, 0x28, 0x5d, 0x25, 0xb2, 0xd0, 0x9b, 0x6d, 0x35, 0xfe, 0xb0,
    0x6f, 0x3a, 0xf0, 0x82, 0xfb, 0xf5, 0xb6, 0x24, 0x3b, 0x90, 0x04, 0xd4, 0xbd, 0xc5, 0xad, 0x80,
    0x1b, 0x49, 0x57, 0x34, 0x32, 0x19, 0x0b, 0xd5, 0x82, 0x29, 0x89, 0xfe, 0xc5, 0x49, 0x19, 0x4e,
    0x5e, 0xb2, 0x2b, 0xb5, 0x96, 0x60, 0xa0, 0x1f, 0x45, 0xbd, 0x00, 0x19, 0x92, 0x33, 0x01, 0xc7,
    0x00, 0x01, 0x91, 0x46, 0x3b, 0x15, 0x14, 0xe3, 0x9a, 0x57, 0xa2, 0x63, 0xb2, 0x27, 0x4e, 0x28,
    0x7b, 0x65, 0x4f, 0xfa, 0x4f, 0x76, 0x5e, 0x70, 0xbb, 0xc0, 0xc8, 0xad, 0x0e, 0xfb, 0x18, 0x04,
    0x1a, 0xc1, 0x65, 0xfd, 0x2e, 0x6a, 0xdb, 0x12, 0xbf, 0x8e, 0x3c, 0x8d, 0x1b, 0x6d, 0x3a, 0x66,
    0x49, 0xd5, 0x32, 0x93, 0x47, 0xa7, 0x28, 0x3e, 0x1b, 0xbf, 0xd0, 0x01, 0x3e, 0xce, 0x27, 0x99,
    0x47, 0x48, 0xb9, 0xf7, 0xb3, 0xa4, 0x18, 0x9e, 0x79, 0xf1, 0xcc, 0xac, 0x50, 0xd9, 0xf0, 0xbe,
    0x89, 0x6e, 0x22, 0xec, 0xad, 0xf8, 0x09, 0x0a, 0xbc, 0x9f, 0xaf, 0xae, 0xd4, 0xf2, 0x7f, 0x75,
    0x35, 0x24, 0x7e, 0x4a, 0x08, 0xe4, 0x04, 0x02, 0x69, 0x29, 0x55, 0x9c, 0xd2, 0xf9, 0x7b, 0x3b,
    0x2b, 0xdf, 0x94, 0xf2, 0xcb, 0x0a, 0x91, 0x6f, 0x18, 0x2b, 0xaf, 0x1c
};
#endif

PyTypeObject *init_KUnitConversion_Value(PyObject *enclosingClass)
{
    if (SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX].type != nullptr)
        return SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX].type;

    Shiboken::AutoDecRef Sbk_KUnitConversion_Value_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUnitConversion_Value_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Value",
        "KUnitConversion::Value*",
        &Sbk_KUnitConversion_Value_spec,
        &Shiboken::callCppDestructor< ::KUnitConversion::Value >,
        Sbk_KUnitConversion_Value_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass);
    auto *pyType = Sbk_KUnitConversion_Value_TypeF(); // references _Sbk_KUnitConversion_Value_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUnitConversion_Value_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUnitConversion_Value_SignatureBytes, KUnitConversion_Value_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUnitConversion_Value_PropertyStrings);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Value_PythonToCpp_Value_PTR,
        is_Value_PythonToCpp_Value_PTR_Convertible,
        Value_PTR_CppToPython_Value);

    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Value");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Value*");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Value&");
    Shiboken::Conversions::registerConverterAlias(converter, "Value");
    Shiboken::Conversions::registerConverterAlias(converter, "Value*");
    Shiboken::Conversions::registerConverterAlias(converter, "Value&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUnitConversion::Value).name());

    qRegisterMetaType< ::KUnitConversion::Value *>();

    return pyType;
}
