
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "ksandbox_wrapper.h"

// inner classes
#include "ksandbox_processcontext_wrapper.h"

// Argument includes
#include <ksandbox.h>
#include <qprocess.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KSandbox_Type = nullptr;
static PyTypeObject *Sbk_KSandbox_TypeF(void)
{
    return _Sbk_KSandbox_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KSandbox_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KSandbox");
    return -1;
}

static PyObject *Sbk_KSandboxFunc_isFlatpak(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFlatpak()
        bool cppResult = ::KSandbox::isFlatpak();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSandboxFunc_isInside(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isInside()
        bool cppResult = ::KSandbox::isInside();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSandboxFunc_isSnap(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSnap()
        bool cppResult = ::KSandbox::isSnap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSandboxFunc_makeHostContext(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KSandbox::makeHostContext(QProcess)->KSandbox::ProcessContext
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QProcess_IDX]), (pyArg)))) {
        overloadId = 0; // makeHostContext(QProcess)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "makeHostContext", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QProcess *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // makeHostContext(QProcess)
            KSandbox::ProcessContext* cppResult = new KSandbox::ProcessContext(::KSandbox::makeHostContext(*cppArg0));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSandbox_ProcessContext_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSandboxFunc_startHostProcess(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "startHostProcess", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX]);

    if (PyArg_ParseTuple(args, "|OO:startHostProcess", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KSandbox::startHostProcess(QProcess&,QFlags<QIODeviceBase::OpenModeFlag>=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QProcess_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // startHostProcess(QProcess&,QFlags<QIODeviceBase::OpenModeFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // startHostProcess(QProcess&,QFlags<QIODeviceBase::OpenModeFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "startHostProcess", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"mode", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "startHostProcess", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QProcess *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QIODeviceBase::OpenModeFlag> cppArg1(QProcess::ReadWrite);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // startHostProcess(QProcess&,QFlags<QIODeviceBase::OpenModeFlag>)
            ::KSandbox::startHostProcess(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KSandbox_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KSandbox_methods[] = {
    {"isFlatpak", reinterpret_cast<PyCFunction>(Sbk_KSandboxFunc_isFlatpak), METH_NOARGS|METH_STATIC, nullptr},
    {"isInside", reinterpret_cast<PyCFunction>(Sbk_KSandboxFunc_isInside), METH_NOARGS|METH_STATIC, nullptr},
    {"isSnap", reinterpret_cast<PyCFunction>(Sbk_KSandboxFunc_isSnap), METH_NOARGS|METH_STATIC, nullptr},
    {"makeHostContext", reinterpret_cast<PyCFunction>(Sbk_KSandboxFunc_makeHostContext), METH_O|METH_STATIC, nullptr},
    {"startHostProcess", reinterpret_cast<PyCFunction>(Sbk_KSandboxFunc_startHostProcess), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KSandbox_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KSandbox_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KSandbox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KSandbox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KSandbox_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KSandbox_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KSandbox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KSandbox_spec = {
    "1:KCoreAddons.KSandbox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KSandbox_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKSandbox_SignatureStrings[] = {
    "KCoreAddons.KSandbox.isFlatpak()->bool",
    "KCoreAddons.KSandbox.isInside()->bool",
    "KCoreAddons.KSandbox.isSnap()->bool",
    "KCoreAddons.KSandbox.makeHostContext(process:PySide6.QtCore.QProcess)->KCoreAddons.KSandbox.ProcessContext",
    "KCoreAddons.KSandbox.startHostProcess(process:PySide6.QtCore.QProcess,mode:PySide6.QtCore.QIODeviceBase.OpenModeFlag=QProcess.ReadWrite)",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKSandbox_SignatureByteSize = 164;
static constexpr uint8_t KCoreAddonsKSandbox_SignatureBytes[164] = {
    0x78, 0xda, 0x85, 0x90, 0x41, 0x0b, 0x82, 0x40, 0x10, 0x85, 0xef, 0xfe, 0x12, 0x85, 0xda, 0x63,
    0x87, 0xa0, 0xa0, 0x8c, 0x48, 0x24, 0xd4, 0x3c, 0x74, 0x1e, 0xdd, 0x21, 0x16, 0x75, 0x47, 0x76,
    0x86, 0xb0, 0x7f, 0xdf, 0x4a, 0x76, 0x4a, 0xf2, 0x3a, 0xef, 0x7b, 0xdf, 0x83, 0x49, 0x63, 0x72,
    0x78, 0xd0, 0x9a, 0x2c, 0xab, 0xb4, 0x04, 0xab, 0x2b, 0x1a, 0x94, 0xe1, 0x73, 0x0b, 0xd2, 0x43,
    0x13, 0x46, 0xeb, 0x7d, 0x45, 0xd4, 0x06, 0xe9, 0x3c, 0x96, 0x58, 0x36, 0x1a, 0x97, 0xa8, 0xd2,
    0x42, 0xff, 0x9f, 0xe9, 0xa0, 0xc1, 0x0b, 0xb1, 0xc4, 0x64, 0x05, 0x07, 0x09, 0x7b, 0x47, 0x35,
    0x32, 0x6f, 0xf3, 0x57, 0xe9, 0xfd, 0x1b, 0x55, 0xc8, 0xd8, 0x52, 0x45, 0xfe, 0xb9, 0x7b, 0xd7,
    0xac, 0x66, 0x8a, 0x27, 0xcb, 0xfc, 0x14, 0x0b, 0x38, 0x19, 0xb7, 0x26, 0x78, 0x69, 0x6b, 0xd5,
    0x91, 0xc6, 0x9f, 0x30, 0xc9, 0x4e, 0xf8, 0x34, 0x35, 0x1e, 0x81, 0x51, 0x65, 0x3d, 0xda, 0xab,
    0xa7, 0xfc, 0xd3, 0x1e, 0xbb, 0x6f, 0x4f, 0xdd, 0x10, 0xf4, 0xdd, 0x19, 0xc1, 0x28, 0x78, 0x03,
    0xd6, 0x74, 0x81, 0x1b
};
#endif

PyTypeObject *init_KCoreAddonsKSandbox(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX].type;

    Shiboken::AutoDecRef Sbk_KSandbox_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KSandbox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KSandbox",
        "KSandbox",
        &Sbk_KSandbox_spec,
        nullptr,
        Sbk_KSandbox_Type_bases.object(),
        0);
    auto *pyType = Sbk_KSandbox_TypeF(); // references _Sbk_KSandbox_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKSandbox_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKSandbox_SignatureBytes, KCoreAddonsKSandbox_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KSandbox_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKSandbox_IDX].type = pyType;



    return pyType;
}
