
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kautosavefile_wrapper.h"

// Wrappers providing overrides
#include "kjob_wrapper.h"
#include "ksignalhandler_wrapper.h"
#include "kprocess_wrapper.h"
#include "kjobuidelegate_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kautosavefile.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qurl.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAutoSaveFile_Type = nullptr;
static PyTypeObject *Sbk_KAutoSaveFile_TypeF(void)
{
    return _Sbk_KAutoSaveFile_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KAutoSaveFileWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KAutoSaveFileWrapper::KAutoSaveFileWrapper(::QObject * parent) : KAutoSaveFile(parent)
{
}

KAutoSaveFileWrapper::KAutoSaveFileWrapper(const ::QUrl & filename, ::QObject * parent) : KAutoSaveFile(filename, parent)
{
}

bool KAutoSaveFileWrapper::atEnd() const
{
    static const char *funcName = "atEnd";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::atEnd();
    }
    return KProcessWrapper::sbk_o_atEnd("KAutoSaveFile", funcName, gil, pyOverride);
}

qint64 KAutoSaveFileWrapper::bytesAvailable() const
{
    static const char *funcName = "bytesAvailable";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::bytesAvailable();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KAutoSaveFile", funcName, gil, pyOverride);
}

qint64 KAutoSaveFileWrapper::bytesToWrite() const
{
    static const char *funcName = "bytesToWrite";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::bytesToWrite();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KAutoSaveFile", funcName, gil, pyOverride);
}

bool KAutoSaveFileWrapper::canReadLine() const
{
    static const char *funcName = "canReadLine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::canReadLine();
    }
    return KProcessWrapper::sbk_o_atEnd("KAutoSaveFile", funcName, gil, pyOverride);
}

void KAutoSaveFileWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KAutoSaveFile", funcName, gil, pyOverride, event);
}

void KAutoSaveFileWrapper::close()
{
    static const char *funcName = "close";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::close();
    }
    KProcessWrapper::sbk_o_close("KAutoSaveFile", funcName, gil, pyOverride);
}

void KAutoSaveFileWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KAutoSaveFile", funcName, gil, pyOverride, signal);
}

void KAutoSaveFileWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KAutoSaveFile", funcName, gil, pyOverride, event);
}

void KAutoSaveFileWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KAutoSaveFile", funcName, gil, pyOverride, signal);
}

bool KAutoSaveFileWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KAutoSaveFile", funcName, gil, pyOverride, event);
}

bool KAutoSaveFileWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KAutoSaveFile", funcName, gil, pyOverride, watched, event);
}

::QString KAutoSaveFileWrapper::fileName() const
{
    static const char *funcName = "fileName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFile::fileName();
    }
    return KJobWrapper::sbk_o_errorString("KAutoSaveFile", funcName, gil, pyOverride);
}

bool KAutoSaveFileWrapper::isSequential() const
{
    static const char *funcName = "isSequential";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::isSequential();
    }
    return KProcessWrapper::sbk_o_atEnd("KAutoSaveFile", funcName, gil, pyOverride);
}

bool KAutoSaveFileWrapper::open(::QFlags<QIODeviceBase::OpenModeFlag> openmode)
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAutoSaveFile::open(openmode);
    }
    return sbk_o_open("KAutoSaveFile", funcName, gil, pyOverride, openmode);
}

bool KAutoSaveFileWrapper::sbk_o_open(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFlags<QIODeviceBase::OpenModeFlag> openmode)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, &openmode)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, &openmode)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QFileDevice::Permission> KAutoSaveFileWrapper::permissions() const
{
    static const char *funcName = "permissions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFile::permissions();
    }
    return sbk_o_permissions("KAutoSaveFile", funcName, gil, pyOverride);
}

::QFlags<QFileDevice::Permission> KAutoSaveFileWrapper::sbk_o_permissions(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return QFlags<QFileDevice::Permission>(0);
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QFileDevice_Permission_IDX])))->flagsConverter, pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QFlags<QFileDevice::Permission> >()), Py_TYPE(pyResult)->tp_name);
        return QFlags<QFileDevice::Permission>(0);
    }
    ::QFlags<QFileDevice::Permission> cppResult = QFlags<QFileDevice::Permission>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KAutoSaveFileWrapper::pos() const
{
    static const char *funcName = "pos";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::pos();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KAutoSaveFile", funcName, gil, pyOverride);
}

qint64 KAutoSaveFileWrapper::readData(char * data, qint64 maxlen)
{
    static const char *funcName = "readData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::readData(data, maxlen);
    }
    return KProcessWrapper::sbk_o_readData("KAutoSaveFile", funcName, gil, pyOverride, data, maxlen);
}

qint64 KAutoSaveFileWrapper::readLineData(char * data, qint64 maxlen)
{
    static const char *funcName = "readLineData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::readLineData(data, maxlen);
    }
    return KProcessWrapper::sbk_o_readLineData("KAutoSaveFile", funcName, gil, pyOverride, data, maxlen);
}

void KAutoSaveFileWrapper::releaseLock()
{
    static const char *funcName = "releaseLock";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAutoSaveFile::releaseLock();
    }
    KJobUiDelegateWrapper::sbk_o_showErrorMessage("KAutoSaveFile", funcName, gil, pyOverride);
}

bool KAutoSaveFileWrapper::reset()
{
    static const char *funcName = "reset";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::reset();
    }
    return KProcessWrapper::sbk_o_atEnd("KAutoSaveFile", funcName, gil, pyOverride);
}

bool KAutoSaveFileWrapper::resize(qint64 sz)
{
    static const char *funcName = "resize";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFile::resize(sz);
    }
    return sbk_o_resize("KAutoSaveFile", funcName, gil, pyOverride, sz);
}

bool KAutoSaveFileWrapper::sbk_o_resize(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, qint64 sz)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &sz)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
        sz
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KAutoSaveFileWrapper::seek(qint64 offset)
{
    static const char *funcName = "seek";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::seek(offset);
    }
    return KProcessWrapper::sbk_o_seek("KAutoSaveFile", funcName, gil, pyOverride, offset);
}

bool KAutoSaveFileWrapper::setPermissions(::QFlags<QFileDevice::Permission> permissionSpec)
{
    static const char *funcName = "setPermissions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFile::setPermissions(permissionSpec);
    }
    return sbk_o_setPermissions("KAutoSaveFile", funcName, gil, pyOverride, permissionSpec);
}

bool KAutoSaveFileWrapper::sbk_o_setPermissions(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFlags<QFileDevice::Permission> permissionSpec)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QFileDevice_Permission_IDX])))->flagsConverter, &permissionSpec)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QFileDevice_Permission_IDX])))->flagsConverter, &permissionSpec)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KAutoSaveFileWrapper::size() const
{
    static const char *funcName = "size";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFile::size();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KAutoSaveFile", funcName, gil, pyOverride);
}

qint64 KAutoSaveFileWrapper::skipData(qint64 maxSize)
{
    static const char *funcName = "skipData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::skipData(maxSize);
    }
    return KProcessWrapper::sbk_o_skipData("KAutoSaveFile", funcName, gil, pyOverride, maxSize);
}

void KAutoSaveFileWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KAutoSaveFile", funcName, gil, pyOverride, event);
}

bool KAutoSaveFileWrapper::waitForBytesWritten(int msecs)
{
    static const char *funcName = "waitForBytesWritten";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::waitForBytesWritten(msecs);
    }
    return KProcessWrapper::sbk_o_waitForBytesWritten("KAutoSaveFile", funcName, gil, pyOverride, msecs);
}

bool KAutoSaveFileWrapper::waitForReadyRead(int msecs)
{
    static const char *funcName = "waitForReadyRead";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::waitForReadyRead(msecs);
    }
    return KProcessWrapper::sbk_o_waitForReadyRead("KAutoSaveFile", funcName, gil, pyOverride, msecs);
}

qint64 KAutoSaveFileWrapper::writeData(const char * data, qint64 len)
{
    static const char *funcName = "writeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAutoSaveFile_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFileDevice::writeData(data, len);
    }
    return KProcessWrapper::sbk_o_writeData("KAutoSaveFile", funcName, gil, pyOverride, data, len);
}

const QMetaObject *KAutoSaveFileWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KAutoSaveFile::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KAutoSaveFileWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KAutoSaveFile::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KAutoSaveFileWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KAutoSaveFileWrapper *>(this));
    }
    return KAutoSaveFile::qt_metacast(_clname);
}

KAutoSaveFileWrapper::~KAutoSaveFileWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KAutoSaveFile_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAutoSaveFile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAutoSaveFile >()))
        return -1;

    KAutoSaveFileWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KAutoSaveFile", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAutoSaveFile::KAutoSaveFile(QObject*=)
    // 1: KAutoSaveFile::KAutoSaveFile(QUrl,QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KAutoSaveFile(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KAutoSaveFile(QUrl,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KAutoSaveFile(QUrl,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KAutoSaveFile(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KAutoSaveFile(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAutoSaveFile(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KAutoSaveFileWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KAutoSaveFileWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KAutoSaveFile(const QUrl &filename, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAutoSaveFile(QUrl,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KAutoSaveFileWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KAutoSaveFileWrapper(*cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KAutoSaveFile >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KAutoSaveFileFunc_allStaleFiles(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "allStaleFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    if (PyArg_ParseTuple(args, "|O:allStaleFiles", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KAutoSaveFile::allStaleFiles(const QString&=)->QList<KAutoSaveFile*>
    if (numArgs == 0) {
        overloadId = 0; // allStaleFiles(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // allStaleFiles(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "allStaleFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"applicationName", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "allStaleFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // allStaleFiles(QString)
            QList<KAutoSaveFile*> cppResult = ::KAutoSaveFile::allStaleFiles(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAutoSaveFilePTR_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAutoSaveFileFunc_managedFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAutoSaveFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // managedFile()const
        QUrl cppResult = const_cast<const ::KAutoSaveFile *>(cppSelf)->managedFile();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAutoSaveFileFunc_open(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAutoSaveFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "open", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:open", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QIODevice::open(QFlags<QIODeviceBase::OpenModeFlag>)->bool
    // 1: QFile::open(QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::Permission>)->bool
    // 2: QFile::open(int,QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>=)->bool
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // open(int,QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QFileDevice_FileHandleFlag_IDX])))->flagsConverter, (pyArgs[2])))) {
            overloadId = 2; // open(int,QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // open(QFlags<QIODeviceBase::OpenModeFlag>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QFileDevice_Permission_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 1; // open(QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::Permission>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "open", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // open(QFlags<QIODeviceBase::OpenModeFlag> openmode)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "open", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
            }
            ::QFlags<QIODeviceBase::OpenModeFlag> cppArg0 = QFlags<QIODeviceBase::OpenModeFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // open(QFlags<QIODeviceBase::OpenModeFlag>)
                bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::KAutoSaveFile::open(cppArg0)
                    : cppSelf->open(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // open(QFlags<QIODeviceBase::OpenModeFlag> flags, QFlags<QFileDevice::Permission> permissions)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "open", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
            }
            ::QFlags<QIODeviceBase::OpenModeFlag> cppArg0 = QFlags<QIODeviceBase::OpenModeFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QFileDevice::Permission> cppArg1 = QFlags<QFileDevice::Permission>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // open(QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::Permission>)
                bool cppResult = reinterpret_cast<QFile *>(cppSelf)->open(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // open(int fd, QFlags<QIODeviceBase::OpenModeFlag> ioFlags, QFlags<QFileDevice::FileHandleFlag> handleFlags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"handleFlags", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QFileDevice_FileHandleFlag_IDX])))->flagsConverter, (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "open", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QIODeviceBase::OpenModeFlag> cppArg1 = QFlags<QIODeviceBase::OpenModeFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QFileDevice::FileHandleFlag> cppArg2(QFileDevice::FileHandleFlag::DontCloseHandle);
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // open(int,QFlags<QIODeviceBase::OpenModeFlag>,QFlags<QFileDevice::FileHandleFlag>)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                bool cppResult = reinterpret_cast<QFile *>(cppSelf)->open(cppArg0, cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAutoSaveFileFunc_releaseLock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAutoSaveFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // releaseLock()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KAutoSaveFile::releaseLock()
            : cppSelf->releaseLock();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAutoSaveFileFunc_setManagedFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAutoSaveFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAutoSaveFile::setManagedFile(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // setManagedFile(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setManagedFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setManagedFile(QUrl)
            cppSelf->setManagedFile(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAutoSaveFileFunc_staleFiles(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "staleFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    if (PyArg_ParseTuple(args, "|OO:staleFiles", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KAutoSaveFile::staleFiles(QUrl,const QString&=)->QList<KAutoSaveFile*>
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // staleFiles(QUrl,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // staleFiles(QUrl,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "staleFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"applicationName", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "staleFiles", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // staleFiles(QUrl,QString)
            QList<KAutoSaveFile*> cppResult = ::KAutoSaveFile::staleFiles(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAutoSaveFilePTR_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KAutoSaveFile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAutoSaveFile_methods[] = {
    {"allStaleFiles", reinterpret_cast<PyCFunction>(Sbk_KAutoSaveFileFunc_allStaleFiles), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"managedFile", reinterpret_cast<PyCFunction>(Sbk_KAutoSaveFileFunc_managedFile), METH_NOARGS, nullptr},
    {"open", reinterpret_cast<PyCFunction>(Sbk_KAutoSaveFileFunc_open), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"releaseLock", reinterpret_cast<PyCFunction>(Sbk_KAutoSaveFileFunc_releaseLock), METH_NOARGS, nullptr},
    {"setManagedFile", reinterpret_cast<PyCFunction>(Sbk_KAutoSaveFileFunc_setManagedFile), METH_O, nullptr},
    {"staleFiles", reinterpret_cast<PyCFunction>(Sbk_KAutoSaveFileFunc_staleFiles), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KAutoSaveFile_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KAutoSaveFile *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KAutoSaveFileWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KAutoSaveFile_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAutoSaveFile_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KAutoSaveFileSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KAutoSaveFile *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFile_IDX]))
        return static_cast< ::QFile *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFileDevice_IDX]))
        return static_cast< ::QFileDevice *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]))
        return static_cast< ::QIODevice *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODeviceBase_IDX]))
        return static_cast< ::QIODeviceBase *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAutoSaveFile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KAutoSaveFile_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAutoSaveFile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAutoSaveFile_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAutoSaveFile_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAutoSaveFile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAutoSaveFile_spec = {
    "1:KCoreAddons.KAutoSaveFile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAutoSaveFile_slots
};

} //extern "C"

static void *Sbk_KAutoSaveFile_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KAutoSaveFile *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAutoSaveFile_PythonToCpp_KAutoSaveFile_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAutoSaveFile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAutoSaveFile_PythonToCpp_KAutoSaveFile_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAutoSaveFile_TypeF()))
        return KAutoSaveFile_PythonToCpp_KAutoSaveFile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAutoSaveFile_PTR_CppToPython_KAutoSaveFile(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KAutoSaveFile *>(const_cast<void *>(cppIn)), Sbk_KAutoSaveFile_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAutoSaveFile_SignatureStrings[] = {
    "1:KCoreAddons.KAutoSaveFile(self,parent:PySide6.QtCore.QObject=nullptr)",
    "0:KCoreAddons.KAutoSaveFile(self,filename:typing.Union[PySide6.QtCore.QUrl, QString],parent:PySide6.QtCore.QObject=nullptr)",
    "KCoreAddons.KAutoSaveFile.allStaleFiles(applicationName:QString=QString())->QList[KCoreAddons.KAutoSaveFile]",
    "KCoreAddons.KAutoSaveFile.managedFile(self)->PySide6.QtCore.QUrl",
    "2:KCoreAddons.KAutoSaveFile.open(self,openmode:PySide6.QtCore.QIODeviceBase.OpenModeFlag)->bool",
    "1:KCoreAddons.KAutoSaveFile.open(self,flags:PySide6.QtCore.QIODeviceBase.OpenModeFlag,permissions:PySide6.QtCore.QFileDevice.Permission)->bool",
    "0:KCoreAddons.KAutoSaveFile.open(self,fd:int,ioFlags:PySide6.QtCore.QIODeviceBase.OpenModeFlag,handleFlags:PySide6.QtCore.QFileDevice.FileHandleFlag=QFileDevice.FileHandleFlag.DontCloseHandle)->bool",
    "KCoreAddons.KAutoSaveFile.releaseLock(self)",
    "KCoreAddons.KAutoSaveFile.setManagedFile(self,filename:typing.Union[PySide6.QtCore.QUrl, QString])",
    "KCoreAddons.KAutoSaveFile.staleFiles(url:typing.Union[PySide6.QtCore.QUrl, QString],applicationName:QString=QString())->QList[KCoreAddons.KAutoSaveFile]",
    nullptr}; // Sentinel
#else
static constexpr size_t KAutoSaveFile_SignatureByteSize = 322;
static constexpr uint8_t KAutoSaveFile_SignatureBytes[322] = {
    0x78, 0xda, 0xad, 0x53, 0x3d, 0x6f, 0xc2, 0x30, 0x10, 0xdd, 0xf9, 0x15, 0x1d, 0x41, 0x4a, 0x2d,
    0xe8, 0xd0, 0x21, 0x12, 0x95, 0x28, 0x28, 0x6a, 0x05, 0x14, 0xa2, 0x88, 0x09, 0x31, 0x98, 0xf8,
    0x48, 0xdd, 0x5e, 0x6c, 0xcb, 0x3e, 0x90, 0xf8, 0xf7, 0x75, 0x1a, 0xa0, 0x08, 0x08, 0x0d, 0x55,
    0xa7, 0x5c, 0x9c, 0x77, 0xef, 0xe3, 0xe2, 0xeb, 0x84, 0xc3, 0xbe, 0xb6, 0xd0, 0x13, 0x42, 0x2b,
    0xc7, 0x86, 0xbd, 0x35, 0xe9, 0x84, 0x6f, 0x20, 0x92, 0x08, 0x4d, 0x07, 0xb8, 0x0a, 0x0c, 0xb7,
    0xa0, 0x28, 0x9c, 0x6e, 0x13, 0x29, 0xe0, 0x91, 0xc5, 0x54, 0xc0, 0x59, 0x3c, 0x59, 0x7e, 0x40,
    0x4a, 0x5d, 0xb5, 0x46, 0x34, 0x64, 0x5b, 0x8d, 0xf6, 0x6f, 0x3c, 0x2b, 0x5f, 0x29, 0x9e, 0x43,
    0x48, 0x5b, 0x23, 0x55, 0xc6, 0x66, 0x4a, 0x6a, 0x35, 0x3f, 0xa5, 0x9d, 0x59, 0x0c, 0xee, 0xe2,
    0x84, 0xac, 0x87, 0x2c, 0xea, 0x6a, 0x57, 0x2a, 0x33, 0x8e, 0x98, 0x10, 0xc7, 0xef, 0x17, 0xd7,
    0xe4, 0xc6, 0xa0, 0x4c, 0x39, 0x79, 0xe1, 0xb7, 0xc2, 0xc9, 0x4e, 0xa7, 0xbb, 0x7b, 0x36, 0x5b,
    0xad, 0xfb, 0xa7, 0x78, 0x24, 0x1d, 0xcd, 0x2b, 0x19, 0x17, 0x57, 0xc4, 0x72, 0xae, 0x78, 0x06,
    0xe2, 0x10, 0xd9, 0xb3, 0x5d, 0x88, 0xd7, 0x78, 0xa8, 0x9e, 0x14, 0xd3, 0x06, 0x54, 0x39, 0xae,
    0xa2, 0xca, 0xb5, 0x80, 0xb3, 0xf0, 0xaf, 0x93, 0x01, 0x6c, 0x64, 0x0a, 0xcf, 0xdc, 0x01, 0x9b,
    0x78, 0xd4, 0xd8, 0xa3, 0x22, 0xe4, 0x99, 0x97, 0x5b, 0x6a, 0x8d, 0x8d, 0x4e, 0x2d, 0xfe, 0x95,
    0xef, 0x70, 0xf5, 0xc9, 0x03, 0x03, 0x36, 0x97, 0xce, 0xf9, 0xd1, 0x9d, 0x77, 0x15, 0xd4, 0x65,
    0x1f, 0x9b, 0x1e, 0x60, 0x7b, 0x3b, 0xed, 0x7a, 0x76, 0x44, 0x28, 0x15, 0x05, 0x52, 0x47, 0x37,
    0xfa, 0x7a, 0xe7, 0x4a, 0x20, 0x5c, 0xee, 0x3a, 0xf2, 0x55, 0x94, 0x2f, 0x07, 0x68, 0xb7, 0xfa,
    0x13, 0x1b, 0x68, 0x45, 0x7d, 0xd4, 0x6e, 0x77, 0xb6, 0x8f, 0x51, 0x1d, 0xc2, 0x02, 0x82, 0xb7,
    0x35, 0xd2, 0xe9, 0x67, 0xf9, 0xdb, 0xaf, 0x60, 0x1d, 0xd0, 0xf8, 0xe4, 0x96, 0xfc, 0x65, 0x31,
    0xae, 0x4a, 0xfc, 0xdc, 0xf7, 0xb5, 0xc5, 0x5b, 0xb6, 0xed, 0x5f, 0xd6, 0xe3, 0x0b, 0x03, 0xf2,
    0x8d, 0xe8
};
#endif

PyTypeObject *init_KAutoSaveFile(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX].type;

    Shiboken::AutoDecRef Sbk_KAutoSaveFile_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFile_IDX]))));

    _Sbk_KAutoSaveFile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAutoSaveFile",
        "KAutoSaveFile*",
        &Sbk_KAutoSaveFile_spec,
        &Shiboken::callCppDestructor< KAutoSaveFile >,
        Sbk_KAutoSaveFile_Type_bases.object(),
        0);
    auto *pyType = Sbk_KAutoSaveFile_TypeF(); // references _Sbk_KAutoSaveFile_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAutoSaveFile_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAutoSaveFile_SignatureBytes, KAutoSaveFile_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAutoSaveFile_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KAutoSaveFile_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAutoSaveFile_PythonToCpp_KAutoSaveFile_PTR,
        is_KAutoSaveFile_PythonToCpp_KAutoSaveFile_PTR_Convertible,
        KAutoSaveFile_PTR_CppToPython_KAutoSaveFile);

    Shiboken::Conversions::registerConverterName(converter, "KAutoSaveFile");
    Shiboken::Conversions::registerConverterName(converter, "KAutoSaveFile*");
    Shiboken::Conversions::registerConverterName(converter, "KAutoSaveFile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAutoSaveFile).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KAutoSaveFileWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KAutoSaveFile_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KAutoSaveFile_TypeF(), &Sbk_KAutoSaveFileSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KAutoSaveFile_TypeF(), &Sbk_KAutoSaveFile_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KAutoSaveFile::staticMetaObject, sizeof(KAutoSaveFileWrapper));

    return pyType;
}
